# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit cmake

DESCRIPTION="DJ's Hex Calculator"
HOMEPAGE="https://www.delorie.com/store/hcalc/ https://github.com/jlec/hcalc"
SRC_URI="https://github.com/jlec/hcalc/archive/refs/tags/${PV}.tar.gz -> ${P}.gh.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="amd64 ~ppc ~x86"

RDEPEND="
	x11-libs/libX11
	x11-libs/libXpm"
DEPEND="${RDEPEND}"

PATCHES=(
	"${FILESDIR}"/${P}-fno-common.patch
	"${FILESDIR}"/${P}-clang16.patch
	"${FILESDIR}"/${P}-cmake4.patch # bug 952071, downstream patch
)

pkg_postinst() {
	einfo "Enter hcalc to run and use kill or ctrl-c to exit."
}
