[vset VERSION 1.7.2]
[comment {-*- tcl -*- doctools manpage}]
[manpage_begin mime n [vset VERSION]]
[see_also ftp]
[see_also http]
[see_also pop3]
[see_also smtp]
[keywords email]
[keywords internet]
[keywords mail]
[keywords mime]
[keywords net]
[keywords {rfc 821}]
[keywords {rfc 822}]
[keywords {rfc 2045}]
[keywords {rfc 2046}]
[keywords {rfc 2049}]
[keywords smtp]
[copyright {1999-2000 Marshall T. Rose}]
[moddesc   {Mime}]
[titledesc {Manipulation of MIME body parts}]
[category  {Text processing}]
[require Tcl "8.5 9"]
[require mime [opt [vset VERSION]]]
[description]
[para]

The [package mime] library package provides the commands to create and
manipulate MIME body parts.

[list_begin definitions]

[call [cmd ::mime::initialize] [opt "[option -canonical] [arg type/subtype] [opt "[option -param] \{[arg {key value}]\}..."] [opt "[option -encoding] [arg value]"] [opt "[option -header] \{[arg {key value}]\}..."]"] "([option -file] [arg name] | [option -string] [arg value] | [option -parts] \{[arg token1] ... [arg tokenN]\})"]

Creates a MIME part and returns a token representing it.

[list_begin itemized]

[item]

If the [option -canonical] option is present, then the body is in
canonical (raw) form and is found by consulting either the

[option -file], [option -string], or [option -parts] option.

[para]

In addition, both the [option -param] and [option -header] options may
occur zero or more times to specify [const Content-Type] parameters
(e.g., [const charset]) and header keyword/values (e.g.,

[const Content-Disposition]), respectively.

[para]

Also, [option -encoding], if present, specifies the

[const Content-Transfer-Encoding] when copying the body.

[item]

If the [option -canonical] option is not present, then the MIME part
contained in either the [option -file] or the [option -string] option
is parsed, dynamically generating subordinates as appropriate.

[list_end]

[call [cmd ::mime::finalize] [arg token] [opt "[option -subordinates] [const all] | [const dynamic] | [const none]"]]

Destroys the MIME part represented by [arg token]. It
returns an empty string.

[para]

If the [option -subordinates] option is present, it specifies which
subordinates should also be destroyed. The default value is

[const dynamic], destroying all subordinates which were created by
[cmd ::mime::initialize] together with the containing body part.

[call [cmd ::mime::getproperty] [arg token] [opt "[arg property] | [option -names]"]]

Returns a string or a list of strings containing the
properties of a MIME part. If the command is invoked with the name of
a specific property, then the corresponding value is returned;
instead, if [option -names] is specified, a list of all properties is
returned; otherwise, a serialized array of properties and values is
returned.

[para]
The possible properties are:

[list_begin definitions]

[def [const content]]

The type/subtype describing the content

[def [const encoding]]

The "Content-Transfer-Encoding"

[def [const params]]

A list of "Content-Type" parameters

[def [const parts]]

A list of tokens for the part's subordinates.  This property is
present only if the MIME part has subordinates.

[def [const size]]

The approximate size of the content (unencoded)

[list_end]

[call [cmd ::mime::getheader] [arg token] [opt "[arg key] | [option -names]"]]

Returns the header of a MIME part as a dictionary with possibly-redundant keys.

[para]

If [arg key] is provided, then a list of values of matching names, without
regard to case, is returned.

[para]

If [option -names] is provided, a list of all keys is returned.


[call [cmd ::mime::setheader] [arg token] [arg {key value}] [opt "[option -mode] [const write] | [const append] | [const delete]"]]

If [const append] is provided, creates a new header named [arg key] with the
value of [arg value] is added.

If [const write] is provided, deletes any existing headers whose names match
[arg key] and then creates a new header named [arg key] with the value of
[arg value].

If [const delete] is provided any existing header having a name that matches
[arg key] is deleted.

Returns a list of strings containing the previous value associated with the
key.

[para]

The value for [option -mode] is one of:

[list_begin definitions]

[def [const write]]

The [arg key]/[arg value] is either created or overwritten (the default).

[def [const append]]

A new [arg value] is appended for the [arg key] (creating it as necessary).

[def [const delete]]

All values associated with the key are removed (the [arg value]
parameter is ignored).

[list_end]

[call [cmd ::mime::getbody] [arg token] [opt [option -decode]] [opt "[option -command] [arg callback] [opt "[option -blocksize] [arg octets]"]"]]

Returns a string containing the body of the leaf MIME
part represented by [arg token] in canonical form.

[para]

If the [option -command] option is present, then it is repeatedly
invoked with a fragment of the body as this:

[example {
  uplevel #0 $callback [list "data" $fragment]
}]

[para]

(The [option -blocksize] option, if present, specifies the maximum
size of each fragment passed to the callback.)

[para]

When the end of the body is reached, the callback is invoked as:

[example {
    uplevel #0 $callback "end"
}]

[para]

Alternatively, if an error occurs, the callback is invoked as:

[example {
    uplevel #0 $callback [list "error" reason]
}]

[para]

Regardless, the return value of the final invocation of the callback
is propagated upwards by [cmd ::mime::getbody].

[para]

If the [option -command] option is absent, then the return value of
[cmd ::mime::getbody] is a string containing the MIME part's entire
body.

[para]

If the option [option -decode] is absent the return value computed
above is returned as is. This means that it will be in the charset
specified for the token and not the usual utf-8.

If the option [option -decode] is present however the command will use
the charset information associated with the token to convert the
string from its encoding into utf-8 before returning it.

[call [cmd ::mime::copymessage] [arg token] [arg channel]]

Copies the MIME represented by [arg token] part to the
specified [arg channel]. The command operates synchronously, and uses
fileevent to allow asynchronous operations to proceed
independently. It returns an empty string.

[call [cmd ::mime::buildmessage] [arg token]]

Returns the MIME part represented by [arg token] as a
string.  It is similar to [cmd ::mime::copymessage], only it returns
the data as a return string instead of writing to a channel.

[call [cmd ::mime::parseaddress] [arg string]]

Takes a string containing one or more 822-style address
specifications and returns a list of serialized arrays, one element
for each address specified in the argument. If the string contains
more than one address they will be separated by commas.

[para]

Each serialized array contains the properties below. Note that one or
more of these properties may be empty.

[list_begin definitions]

[def [const address]]

local@domain

[def [const comment]]

822-style comment

[def [const domain]]

the domain part (rhs)

[def [const error]]

non-empty on a parse error

[def [const group]]

this address begins a group

[def [const friendly]]

user-friendly rendering

[def [const local]]

the local part (lhs)

[def [const memberP]]

this address belongs to a group

[def [const phrase]]

the phrase part

[def [const proper]]

822-style address specification

[def [const route]]

822-style route specification (obsolete)

[list_end]

[call [cmd ::mime::parsedatetime] ([arg string] | [option -now]) [arg property]]

Takes a string containing an 822-style date-time
specification and returns the specified property as a serialized
array.

[para]

The list of properties and their ranges are:

[list_begin definitions]

[def [const hour]]

0 .. 23

[def [const lmonth]]

January, February, ..., December

[def [const lweekday]]

Sunday, Monday, ... Saturday

[def [const mday]]

1 .. 31

[def [const min]]

0 .. 59

[def [const mon]]

1 .. 12

[def [const month]]

Jan, Feb, ..., Dec

[def [const proper]]

822-style date-time specification

[def [const rclock]]

elapsed seconds between then and now

[def [const sec]]

0 .. 59

[def [const wday]]

0 .. 6 (Sun .. Mon)

[def [const weekday]]

Sun, Mon, ..., Sat

[def [const yday]]

1 .. 366

[def [const year]]

1900 ...

[def [const zone]]

-720 .. 720 (minutes east of GMT)

[list_end]

[call [cmd ::mime::mapencoding] [arg encoding_name]]

Maps tcl encodings onto the proper names for their MIME
charset type.  This is only done for encodings whose charset types
were known.  The remaining encodings return "" for now.

[call [cmd ::mime::reversemapencoding] [arg charset_type]]

Maps MIME charset types onto tcl encoding names.  Those
that are unknown return "".

[list_end]

[section {KNOWN BUGS}]

[list_begin definitions]
[def {Tcllib Bug #447037}]

This problem affects only people which are using Tcl and Mime on a
64-bit system. The currently recommended fix for this problem is to
upgrade to Tcl version 8.4. This version has extended 64 bit support
and the bug does not appear anymore.

[para]

The problem could have been generally solved by requiring the use of
Tcl 8.4 for this package. We decided against this solution as it would
force a large number of unaffected users to upgrade their Tcl
interpreter for no reason.

[para]

See [uri {/tktview?name=447037} {Ticket 447037}] for additional information.

[list_end]

[vset CATEGORY mime]
[include ../common-text/feedback.inc]
[manpage_end]
