'\"
'\" Generated from file 'mkdoc\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2019-2024, Detlef Groth <detlef(at)dgroth(dot)de>
'\"
.TH "mkdoc" n 0\&.7\&.2 tcllib "Source code documentation using Markdown"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
mkdoc \- Extracts and optionally converts Markdown comments in source code to HTML
.SH SYNOPSIS
package require \fBTcl 8\&.6 9\fR
.sp
package require \fBMarkdown ?1\&.2\&.2?\fR
.sp
package require \fByaml ?0\&.4\&.2?\fR
.sp
package require \fBmkdoc ?0\&.7\&.2?\fR
.sp
package require \fBhook\fR
.sp
\fB::mkdoc::mkdoc\fR \fIinfile\fR \fIoutfile\fR ?\fB-css\fR \fIcssfile\fR?
.sp
\fB::mkdoc::run\fR \fIinfile\fR
.sp
.BE
.SH DESCRIPTION
The package \fBmkdoc\fR provides a command to extract documentation embedded in code
and optionally convert these comments into HTML\&.
The latter uses Tcllib's \fBMarkdown\fR package\&.
Each line of the embedded documentation begins with the special comment marker
\fB#'\fR\&.
.TP
\fB::mkdoc::mkdoc\fR \fIinfile\fR \fIoutfile\fR ?\fB-css\fR \fIcssfile\fR?
The command reads the specified \fIinfile\fR and extracts the code comments introduced by
the \fB #'\fR marker\&.  If the \fIoutfile\fR is either a "\fI\&.html\fR" or "\fI\&.htm\fR"
file the Markdown is converted into HTML using either a default style or the specified
style sheet \fIcssfile\fR\&.
.sp
All arguments are paths to the files to read from or write to\&.
.sp
The result of the command is the empty string\&.
.sp
See section \fBFormatting\fR for the supported Markdown syntax and extensions
to it\&.
.TP
\fB::mkdoc::run\fR \fIinfile\fR
The command reads the specified \fIinfile\fR, extracts the embedded documentation, and
then executes the contents of the first example, i\&.e\&. \fB```\fR-quoted block, found in
the \fBExample\fR section\&.
.sp
Here is such an example which will be executed by the Tcl interpreter
.CS


    #' ## <a name="example">Example</a>
    #'
    #' ```
    #' puts "Hello mkdoc package"
    #' puts "I am in the example section"
    #' ```

.CE
.sp
\fIDANGER, BEWARE\fR\&.
Failing to open the \fIinfile\fR causes the command to \fIexit\fR the entire process\&.
.sp
Use of this command in a general context is not recommended\&.
.PP
.SH EXAMPLES
The example below demonstrates the conversion of the documentation embedded into the file
"\fImkdoc\&.tcl\fR" itself:
.PP
.CS


    package require mkdoc
    # extracting the Markdown
    mkdoc::mkdoc mkdoc\&.tcl mkdoc\&.md
    # converting Markdown to HTML
    mkdoc::mkdoc mkdoc\&.md mkdoc\&.html
    # direct conversion without intermediate file
    mkdoc::mkdoc mkdoc\&.tcl mkdoc\&.html

.CE
.SH FORMATTING
The package supports the syntax supported by Tcllib's \fBMarkdown\fR package\&.
.PP
It further supports a set of simple YAML headers whose information is inserted into
appropriate HTML \fBmeta\fR-tags\&. The supported keys are
.TP
\fBauthor\fR
Set the document author\&. Defaults to \fBNN\fR\&.
.TP
\fBtitle\fR
Set the document title\&. Defaults to \fBDocumentation \fR\fBfilename\fR]\&.
.TP
\fBdate\fR
Sets the document date\&. Defaults to the current day\&.
.TP
\fBcss\fR
Sets a custom CSS stylesheet\&. Defaults to the internal mkdoc sheet\&.
.PP
.PP
\fINote\fR that in Markdown output mode these headers are simply passed through
into the result\&. This is proper, as processors like \fBpandoc\fR are able to use them
as well\&.
.PP
See the example below for the syntax:
.CS


    #' ---
    #' title: mkdoc::mkdoc 0\&.7\&.1
    #' author: Detlef Groth, Schwielowsee, Germany
    #' date: 2022-04-17
    #' css: mini\&.css
    #' ---
    #'

.CE
.PP
Another extension over standard Markdown is the support of a single level of includes\&.
.PP
See the example below for the syntax:
.CS


    #' #include "path/to/include/file"

.CE
.PP
\fINote\fR, the double-quotes around the path are part of the syntax\&.
.PP
\fIBeware\fR further that relative paths are resolved relative to the current
working directory, and \fInot\fR relative to the location of the including file\&.
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain bugs and other
problems\&. Please report such to the author of this package\&. Please also report any ideas
for enhancements you may have for either package and/or documentation\&.
.SH "CODE COPYRIGHT"
BSD License type:
.PP
The following terms apply to all files a ssociated with the software unless
explicitly disclaimed in individual files\&.
.PP
The authors hereby grant permission to use, copy, modify, distribute, and license
this software and its documentation for any purpose, provided that existing copyright
notices are retained in all copies and that this notice is included verbatim in any
distributions\&. No written agreement, license, or royalty fee is required for any of the
authorized uses\&.  Modifications to this software may be copyrighted by their authors and
need not follow the licensing terms described here, provided that the new terms are
clearly indicated on the first page of each file where they apply\&.
.PP
In no event shall the authors or distributors be liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use of this
software, its documentation, or any derivatives thereof, even if the authors have been
advised of the possibility of such damage\&.
.PP
The authors and distributors specifically disclaim any warranties, including, but
not limited to, the implied warranties of merchantability, fitness for a particular
purpose, and non-infringement\&.
This software is provided on an "as is" basis, and the authors and distributors have no
obligation to provide maintenance, support, updates, enhancements, or modifications\&.
.PP
\fIRESTRICTED RIGHTS\fR: Use, duplication or disclosure by the government is
subject to the restrictions as set forth in subparagraph (c) (1) (ii) of the Rights in
Technical Data and Computer Software Clause as DFARS 252\&.227-7013 and FAR 52\&.227-19\&.
.SH CATEGORY
Text processing
.SH COPYRIGHT
.nf
Copyright (c) 2019-2024, Detlef Groth <detlef(at)dgroth(dot)de>

.fi
