/*
  File autogenerated by gengetopt version 2.23
  generated with the following command:
  /usr/bin/gengetopt -i RNAsubopt.ggo --file-name=RNAsubopt_cmdl --include-getopt --default-optional --func-name=RNAsubopt_cmdline_parser --arg-struct-name=RNAsubopt_args_info

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif


#include "RNAsubopt_cmdl.h"

const char *RNAsubopt_args_info_purpose = "calculate suboptimal secondary structures of RNAs";

const char *RNAsubopt_args_info_usage = "Usage: RNAsubopt [OPTION]...";

const char *RNAsubopt_args_info_versiontext = "";

const char *RNAsubopt_args_info_description = "Reads RNA sequences from stdin and (in the default -e mode) calculates all\nsuboptimal secondary structures within a user defined energy range above the\nminimum free energy (mfe). It prints the suboptimal structures in dot-bracket\nnotation followed by the energy in kcal/mol to stdout. Be careful, the number\nof structures returned grows exponentially with both sequence length and energy\nrange.\n\nAlternatively, when used with the -p option, RNAsubopt produces Boltzmann\nweighted samples of secondary structures.\n";

const char *RNAsubopt_args_info_detailed_help[] = {
  "  -h, --help                    Print help and exit",
  "      --detailed-help           Print help, including all details and hidden\n                                  options, and exit",
  "      --full-help               Print help, including hidden options, and exit",
  "  -V, --version                 Print version and exit",
  "  -v, --verbose                 Be verbose.\n                                    (default=off)",
  "  Lower the log level setting such that even INFO messages are passed through.\n\n",
  "\nI/O Options:",
  "  Command line options for input and output (pre-)processing\n\n",
  "  -i, --infile=filename         Read a file instead of reading from stdin.\n",
  "  The default behavior of RNAsubopt is to read input from stdin. Using this\n  parameter the user can specify an input file name where data is read from.\n\n",
  "  -o, --outfile[=filename]      Print output to file instead of stdout.\n",
  "  This option may be used to write all output to output files rather than\n  printing to stdout. The default filename is \"RNAsubopt_output.sub\" if no\n  FASTA header precedes the input sequences and the --auto-id feature is\n  inactive. Otherwise, output files with the scheme \"prefix.sub\" are\n  generated, where the \"prefix\" is taken from the sequence id. The user may\n  specify a single output file name for all data generated from the input by\n  supplying an optional string as argument to this parameter. In case a file\n  with the same filename already exists, any output of the program will be\n  appended to it. Note: Any special characters in the filename will be replaced\n  by the filename delimiter, hence there is no way to pass an entire directory\n  path through this option yet. (See also the \"--filename-delim\" parameter)\n\n",
  "      --noconv                  Do not automatically substitute nucleotide\n                                  \"T\" with \"U\".\n\n                                    (default=off)",
  "      --auto-id                 Automatically generate an ID for each sequence.\n                                    (default=off)",
  "  The default mode of RNAsubopt is to automatically determine an ID from the\n  input sequence data if the input file format allows to do that. Sequence IDs\n  are usually given in the FASTA header of input sequences. If this flag is\n  active, RNAsubopt ignores any IDs retrieved from the input and automatically\n  generates an ID for each sequence. This ID consists of a prefix and an\n  increasing number. This flag can also be used to add a FASTA header to the\n  output even if the input has none.\n\n",
  "      --id-prefix=STRING        Prefix for automatically generated IDs (as used\n                                  in output file names).\n                                    (default=`sequence')",
  "  If this parameter is set, each sequences' FASTA id will be prefixed with the\n  provided string. FASTA ids then take the form \">prefix_xxxx\" where xxxx is\n  the sequence number. Note: Setting this parameter implies --auto-id.\n\n",
  "      --id-delim=CHAR           Change the delimiter between prefix and\n                                  increasing number for automatically generated\n                                  IDs (as used in output file names).\n                                    (default=`_')",
  "  This parameter can be used to change the default delimiter \"_\" between the\n  prefix string and the increasing number for automatically generated ID.\n\n",
  "      --id-digits=INT           Specify the number of digits of the counter in\n                                  automatically generated alignment IDs.\n                                    (default=`4')",
  "  When alignments IDs are automatically generated, they receive an increasing\n  number, starting with 1. This number will always be left-padded by leading\n  zeros, such that the number takes up a certain width. Using this parameter,\n  the width can be specified to the users need. We allow numbers in the range\n  [1:18]. This option implies --auto-id.\n\n",
  "      --id-start=LONG           Specify the first number in automatically\n                                  generated IDs.\n                                    (default=`1')",
  "  When sequence IDs are automatically generated, they receive an increasing\n  number, usually starting with 1. Using this parameter, the first number can\n  be specified to the users requirements. Note: negative numbers are not\n  allowed.\n  Note: Setting this parameter implies to ignore any IDs retrieved from the\n  input data, i.e. it activates the --auto-id flag.\n\n",
  "      --filename-delim=CHAR     Change the delimiting character used in\n                                  sanitized filenames.\n                                    (default=`ID-delimiter')",
  "  This parameter can be used to change the delimiting character used while\n  sanitizing filenames, i.e. replacing invalid characters. Note, that the\n  default delimiter ALWAYS is the first character of the \"ID delimiter\" as\n  supplied through the --id-delim option. If the delimiter is a whitespace\n  character or empty, invalid characters will be simply removed rather than\n  substituted. Currently, we regard the following characters as illegal for use\n  in filenames: backslash '\', slash '/', question mark '?', percent sign '%',\n  asterisk '*', colon ':', pipe symbol '|', double quote '\"', triangular\n  brackets '<' and '>'.\n\n",
  "      --filename-full           Use full FASTA header to create filenames.\n                                    (default=off)",
  "  This parameter can be used to deactivate the default behavior of limiting\n  output filenames to the first word of the sequence ID. Consider the following\n  example: An input with FASTA header '>NM_0001 Homo Sapiens some gene' usually\n  produces output files with the prefix \"NM_0001\" without the additional data\n  available in the FASTA header, e.g. \"NM_0001.sub\". With this flag set, no\n  truncation of the output filenames is performed, i.e. output filenames\n  receive the full FASTA header data as prefixes. Note, however, that invalid\n  characters (such as whitespace) will be substituted by a delimiting character\n  or simply removed, (see also the parameter option --filename-delim).\n\n",
  "      --log-level=level         Set log level threshold.\n                                    (default=`2')",
  "  By default, any log messages are filtered such that only warnings (level 2)\n  or errors (level 3) are printed. This setting allows for specifying the log\n  level threshold, where higher values result in fewer information. Log-level 5\n  turns off all messages, even errors and other critical information.\n\n",
  "      --log-file[=filename]     Print log messages to a file instead of stderr.\n                                    (default=`RNAsubopt.log')",
  "      --log-time                Include time stamp in log messages.\n\n                                    (default=off)",
  "      --log-call                Include file and line of log calling function.\n\n                                    (default=off)",
  "\nAlgorithms:",
  "  Select the algorithms which should be applied to the given RNA sequence(s).\n\n",
  "  -e, --deltaEnergy=range       Compute suboptimal structures with energy in a\n                                  certain range of the optimum (kcal/mol).\n",
  "  Default is calculation of mfe structure only.\n\n",
  "      --deltaEnergyPost=range   Only print structures with energy within range\n                                  of the mfe after post reevaluation of\n                                  energies.\n",
  "  Useful in conjunction with -logML, -d1 or -d3: while the -e option specifies\n  the range before energies are re-evaluated, this option specifies the maximum\n  energy after re-evaluation.\n\n",
  "  -s, --sorted                  Sort the suboptimal structures by energy and\n                                  lexicographical order.\n                                    (default=off)",
  "  Structures are first sorted by energy in ascending order. Within groups of\n  the same energy, structures are then sorted in ascending in lexicographical\n  order of their dot-bracket notation. See the --en-only flag to deactivate\n  this second step. Note that sorting is done in memory, thus it can easily\n  lead to exhaution of RAM! This is especially true if the number of structures\n  produced becomes large or the RNA sequence is rather long. In such cases\n  better use an external sort method, such as UNIX \"sort\".\n\n",
  "      --en-only                 Only sort structures by free energy.\n                                    (default=off)",
  "  In combination with --sorted, this flag deactivates the second sorting\n  criteria and sorts structures solely by their free energy instead of\n  additionally sorting by lexicographic order in each energy band. This might\n  save some time during the sorting process in situations where lexicographic\n  order is not required.\n\n",
  "  -p, --stochBT=number          Randomly draw structures according to their\n                                  probability in the Boltzmann ensemble.\n",
  "  Instead of producing all suboptimals in an energy range, produce a random\n  sample of suboptimal structures, drawn with probabilities equal to their\n  Boltzmann weights via stochastic backtracking in the partition function. The\n  -e and -p options are mutually exclusive.\n\n",
  "      --stochBT_en=number       Same as \"--stochBT\" but also print free\n                                  energies and probabilities of the backtraced\n                                  structures.\n\n",
  "      --random-seed=INT         Set the seed for the random number generator\n\n",
  "      --betaScale=DOUBLE        Set the scaling of the Boltzmann factors.\n                                    (default=`1.')",
  "  The argument provided with this option is used to scale the thermodynamic\n  temperature in the Boltzmann factors independently from the temperature of\n  the individual loop energy contributions. The Boltzmann factors then become\n  'exp(- dG/(kT*betaScale))' where 'k' is the Boltzmann constant, 'dG' the free\n  energy contribution of the state and 'T' the absolute temperature.\n\n",
  "  -N, --nonRedundant            Enable non-redundant sampling strategy.\n\n                                    (default=off)",
  "  -S, --pfScale=DOUBLE          In the calculation of the pf use scale*mfe as\n                                  an estimate for the ensemble free energy\n                                  (used to avoid overflows).\n                                    (default=`1.07')",
  "  The default is 1.07, useful values are 1.0 to 1.2. Occasionally needed for\n  long sequences.\n\n",
  "  -c, --circ                    Assume a circular (instead of linear) RNA\n                                  molecule.\n\n                                    (default=off)",
  "  -D, --dos                     Compute density of states instead of secondary\n                                  structures.\n                                    (default=off)",
  "  This option enables the evaluation of the number of secondary structures in\n  certain energy bands around the MFE.\n\n",
  "  -z, --zuker                   Compute Zuker suboptimals instead of all\n                                  suboptimal structures within an energy band\n                                  around the MFE.\n\n                                    (default=off)",
  "  -g, --gquad                   Incoorporate G-Quadruplex formation.\n                                    (default=off)",
  "  No support of G-quadruplex prediction for stochastic backtracking and\n  Zuker-style suboptimals yet).\n\n",
  "\nStructure Constraints:",
  "  Command line options to interact with the structure constraints feature of\n  this program\n\n",
  "      --maxBPspan=INT           Set the maximum base pair span.\n\n                                    (default=`-1')",
  "  -C, --constraint[=filename]   Calculate structures subject to constraints.\n                                    (default=`')",
  "  The program reads first the sequence, then a string containing constraints on\n  the structure encoded with the symbols:\n\n  '.' (no constraint for this base)\n\n  '|' (the corresponding base has to be paired\n\n  'x' (the base is unpaired)\n\n  '<' (base i is paired with a base j>i)\n\n  '>' (base i is paired with a base j<i)\n\n  and matching brackets '(' ')' (base i pairs base j)\n\n  With the exception of '|', constraints will disallow all pairs conflicting\n  with the constraint. This is usually sufficient to enforce the constraint,\n  but occasionally a base may stay unpaired in spite of constraints. PF folding\n  ignores constraints of type '|'.\n\n",
  "      --batch                   Use constraints for multiple sequences.\n                                    (default=off)",
  "  Usually, constraints provided from input file only apply to a single input\n  sequence. Therefore, RNAsubopt will stop its computation and quit after the\n  first input sequence was processed. Using this switch, RNAsubopt processes\n  multiple input sequences and applies the same provided constraints to each of\n  them.\n\n",
  "      --canonicalBPonly         Remove non-canonical base pairs from the\n                                  structure constraint.\n\n                                    (default=off)",
  "      --enforceConstraint       Enforce base pairs given by round brackets '('\n                                  ')' in structure constraint.\n\n                                    (default=off)",
  "      --commands=filename       Read additional commands from file\n",
  "  Commands include hard and soft constraints, but also structure motifs in\n  hairpin and internal loops that need to be treeted differently. Furthermore,\n  commands can be set for unstructured and structured domains.\n\n",
  "\nExperimental Structure Probing Data:",
  "  The following arguments and siwtches control various implementations that\n  allow for guiding the structure prediction with the help of additional\n  (experimental) RNA structure probing data, such as SHAPE, DMS, etc.\n\n",
  "      --sp-data=filename        Read structure probing data from an input file\n                                  and guide the predictions accordingly. Must\n                                  precede the strategy, i.e. a data file must\n                                  be specified before the corresponding\n                                  --sp-strategy option!\n\n",
  "  This option and its argument only specifies the file name with the\n  (reactivity) data. What kind of data the file contains and how the data is\n  actually used during the predictions can be specified by the --sp-strategy\n  and --sp-preprocess options.\n\n",
  "      --sp-strategy=strategy    Select the strategy how the probing data is\n                                  used to guide the structure predictions.\n\n                                    (default=`D')",
  "  The following strategies (methods) are available to convert structure probing\n  data into pseudo energy contributions:\n\n   'D': Deigan et al 2009 strategy.\n\n   Here, probing data is converted into pseudo energy terms using a linear\n  model. The derived energies are then applied for every nucleotide involved in\n  a stacked pair. The default slope and intercept variables of the linear model\n  are 'm=1.8' and 'b=-0.6', respectively. To change these parameters, e.g. to\n  'm=1.9' and 'b=-0.7', use a parameter string like this:\n  --sp-strategy=\"Dm1.9b-0.7\". Note the precedence of 'm' over 'b'. You may\n  also provide only one of the two variables like: --sp-strategy=\"Dm1.9\" or\n  --sp-strategy=\"Db-0.7\".\n\n   'E': Eddy 2014 strategy.\n\n   This strategy distinguishes two structural states (classes) for each base,\n  paired and unpaired. Based on a list of prior distributions for each of the\n  classes, the posterior probability for observing a probing reactivity of a\n  base is estimated and then converted into a respective pseudo energy\n  contribution. Thermodynamic temperature T is taken from the model settings as\n  specified by --temp but can be changed to any other value, either in degrees\n  Celcius ('c' or 't') or Kelvin ('k'). Use one of the following parameter\n  strings to change the temperature to 25 degree Celcius:\n  --sp-strategy=\"Ec=25\" or --sp-strategy=\"Ek=298.15\". By default, built-in\n  prior distributions are used with this strategy. This can be changed if the\n  user passes additional probing data files via the --sp-data option and then\n  selects the prior distribution specifier ('P') as strategy (see below).\n\n   'P': Use probing data as prior distribution for Eddy 2014 strategy.\n\n   This indicates that the most recent probing data file actually contains a\n  prior distribution of probing data for a particular structure class, i.e.\n  unpaired or paired bases. The prior distribution then replaces the default\n  priors in the Eddy 2014 ('E') strategy. Use the lower case characters 'u' and\n  'p' to indicate which class, unpaired or paired, the prior distribution\n  represents, e.g. --sp-strategy=\"Pp\" will be interpreted as prior\n  distribution for paired nucleotides.\n  Note, that this option must follow after the --sp-strategy=\"E\" and before\n  any further --sp-strategy options that do not specify other prior\n  distributions!\n\n   'Z': Zarringhalam et al 2012 strategy.\n\n   Here, the probing data is first converted into pairing probabilities and\n  aberration from the observed pairing probabilities will be penalized during\n  the folding recursion. The magnitude of the penalties can affected by\n  adjusting the factor beta (e.g. --sp-strategy=\"Zb0.8\").\n\n   'W': Apply a given vector of perturbation energies to unpaired nucleotides\n  according to Washietl et al 2012. Perturbation vectors can be calculated by\n  using RNApvmin.\n\n",
  "      --sp-preprocess=method    Select a method to pre-process the structure\n                                  probing data before it undergoes conversion\n                                  by a strategy.\n\n                                    (default=`I')",
  "      --shape=filename          Use SHAPE reactivity data to guide structure\n                                  predictions.\n\n",
  "      --shapeMethod=method      Select SHAPE reactivity data incorporation\n                                  strategy.\n\n                                    (default=`D')",
  "  The following methods can be used to convert SHAPE reactivities into pseudo\n  energy contributions.\n\n   'D': Convert by using the linear equation according to Deigan et al 2009.\n  Derived pseudo energy terms will be applied for every nucleotide involved in\n  a stacked pair. This method is recognized by a capital 'D' in the provided\n  parameter, i.e.: --shapeMethod=\"D\" is the default setting. The slope 'm'\n  and the intercept 'b' can be set to a non-default value if necessary,\n  otherwise m=1.8 and b=-0.6. To alter these parameters, e.g. m=1.9 and b=-0.7,\n  use a parameter string like this: --shapeMethod=\"Dm1.9b-0.7\". You may also\n  provide only one of the two parameters like: --shapeMethod=\"Dm1.9\" or\n  --shapeMethod=\"Db-0.7\".\n\n   'Z': Convert SHAPE reactivities to pseudo energies according to Zarringhalam\n  et al 2012. SHAPE reactivities will be converted to pairing probabilities by\n  using linear mapping. Aberration from the observed pairing probabilities will\n  be penalized during the folding recursion. The magnitude of the penalties can\n  affected by adjusting the factor beta (e.g. --shapeMethod=\"Zb0.8\").\n\n   'W': Apply a given vector of perturbation energies to unpaired nucleotides\n  according to Washietl et al 2012. Perturbation vectors can be calculated by\n  using RNApvmin.\n\n",
  "      --shapeConversion=method  Select method for SHAPE reactivity conversion.\n\n                                    (default=`O')",
  "  This parameter is useful when dealing with the SHAPE incorporation according\n  to Zarringhalam et al. The following methods can be used to convert SHAPE\n  reactivities into the probability for a certain nucleotide to be unpaired.\n\n  'M': Use linear mapping according to Zarringhalam et al.\n  'C': Use a cutoff-approach to divide into paired and unpaired nucleotides\n  (e.g. \"C0.25\")\n  'S': Skip the normalizing step since the input data already represents\n  probabilities for being unpaired rather than raw reactivity values\n  'L': Use a linear model to convert the reactivity into a probability for\n  being unpaired (e.g. \"Ls0.68i0.2\" to use a slope of 0.68 and an intercept\n  of 0.2)\n  'O': Use a linear model to convert the log of the reactivity into a\n  probability for being unpaired (e.g. \"Os1.6i-2.29\" to use a slope of 1.6\n  and an intercept of -2.29)\n\n",
  "\nEnergy Parameters:",
  "  Energy parameter sets can be adapted or loaded from user-provided input files\n\n",
  "  -T, --temp=DOUBLE             Rescale energy parameters to a temperature of\n                                  temp C. Default is 37C.\n\n                                    (default=`37.0')",
  "  -P, --paramFile=paramfile     Read energy parameters from paramfile, instead\n                                  of using the default parameter set.\n",
  "  Different sets of energy parameters for RNA and DNA should accompany your\n  distribution.\n  See the RNAlib documentation for details on the file format. The placeholder\n  file name 'DNA' can be used to load DNA parameters without the need to\n  actually specify any input file.\n\n",
  "  -4, --noTetra                 Do not include special tabulated stabilizing\n                                  energies for tri-, tetra- and hexaloop\n                                  hairpins.\n                                    (default=off)",
  "  Mostly for testing.\n\n",
  "      --salt=DOUBLE             Set salt concentration in molar (M). Default is\n                                  1.021M.\n\n",
  "  -m, --modifications[=STRING]  Allow for modified bases within the RNA\n                                  sequence string.\n                                    (default=`7I6P9D')",
  "  Treat modified bases within the RNA sequence differently, i.e. use\n  corresponding energy corrections and/or pairing partner rules if available.\n  For that, the modified bases in the input sequence must be marked by their\n  corresponding one-letter code. If no additional arguments are supplied, all\n  available corrections are performed. Otherwise, the user may limit the\n  modifications to a particular subset of modifications, resp. one-letter\n  codes, e.g. -mP6 will only correct for pseudouridine and m6A bases.\n   Currently supported one-letter codes and energy corrections are:\n\n   '7': 7-deaza-adenonsine (7DA)\n\n   'I': Inosine\n\n   '6': N6-methyladenosine (m6A)\n\n   'P': Pseudouridine\n\n   '9': Purine (a.k.a. nebularine)\n\n   'D': Dihydrouridine\n\n",
  "      --mod-file=STRING         Use additional modified base data from JSON\n                                  file.\n\n",
  "\nModel Details:",
  "  Tweak the energy model and pairing rules additionally using the following\n  parameters\n\n",
  "  -d, --dangles=INT             How to treat \"dangling end\" energies for\n                                  bases adjacent to helices in free ends and\n                                  multi-loops.\n                                    (default=`2')",
  "  \n  With -d1 only unpaired bases can participate in at most one dangling end.\n  With -d2 this check is ignored, dangling energies will be added for the bases\n  adjacent to a helix on both sides in any case; this is the default for mfe\n  and partition function folding (-p).\n  The option -d0 ignores dangling ends altogether (mostly for debugging).\n  With -d3 mfe folding will allow coaxial stacking of adjacent helices in\n  multi-loops. At the moment the implementation will not allow coaxial stacking\n  of the two enclosed pairs in a loop of degree 3 and works only for mfe\n  folding.\n\n  Note that with -d1 and -d3 only the MFE computations will be using this\n  setting while partition function uses -d2 setting, i.e. dangling ends will be\n  treated differently.\n\n",
  "      --noLP                    Produce structures without lonely pairs\n                                  (helices of length 1).\n                                    (default=off)",
  "  For partition function folding this only disallows pairs that can only occur\n  isolated. Other pairs may still occasionally occur as helices of length 1.\n\n",
  "      --noGU                    Do not allow GU pairs.\n\n                                    (default=off)",
  "      --noClosingGU             Do not allow GU pairs at the end of helices.\n\n                                    (default=off)",
  "      --logML                   Recompute energies of structures using a\n                                  logarithmic energy function for multi-loops\n                                  before output.  (default=off)",
  "  This option does not effect structure generation, only the energies that are\n  printed out. Since logML lowers energies somewhat, some structures may be\n  missing.\n",
  "      --nsp=STRING              Allow other pairs in addition to the usual\n                                  AU,GC,and GU pairs.\n",
  "  Its argument is a comma separated list of additionally allowed pairs. If the\n  first character is a \"-\" then AB will imply that AB and BA are allowed\n  pairs, e.g. --nsp=\"-GA\"  will allow GA and AG pairs. Nonstandard pairs are\n  given 0 stacking energy.\n\n",
  "      --energyModel=INT         Set energy model.\n",
  "  Rarely used option to fold sequences from the artificial ABCD... alphabet,\n  where A pairs B, C-D etc.  Use the energy parameters for GC (--energyModel 1)\n  or AU (--energyModel 2) pairs.\n\n",
  "      --helical-rise=FLOAT      Set the helical rise of the helix in units of\n                                  Angstrom.\n                                    (default=`2.8')",
  "  Use with caution! This value will be re-set automatically to 3.4 in case DNA\n  parameters are loaded via -P DNA and no further value is provided.\n\n",
  "      --backbone-length=FLOAT   Set the average backbone length for looped\n                                  regions in units of Angstrom.\n                                    (default=`6.0')",
  "  Use with caution! This value will be re-set automatically to 6.76 in case DNA\n  parameters are loaded via -P DNA and no further value is provided.\n\n",
  "\nIf in doubt our program is right, nature is at fault.\nComments should be sent to rna@tbi.univie.ac.at.\n\n",
    0
};
static void
init_full_help_array(void)
{
  RNAsubopt_args_info_full_help[0] = RNAsubopt_args_info_detailed_help[0];
  RNAsubopt_args_info_full_help[1] = RNAsubopt_args_info_detailed_help[1];
  RNAsubopt_args_info_full_help[2] = RNAsubopt_args_info_detailed_help[2];
  RNAsubopt_args_info_full_help[3] = RNAsubopt_args_info_detailed_help[3];
  RNAsubopt_args_info_full_help[4] = RNAsubopt_args_info_detailed_help[4];
  RNAsubopt_args_info_full_help[5] = RNAsubopt_args_info_detailed_help[6];
  RNAsubopt_args_info_full_help[6] = RNAsubopt_args_info_detailed_help[7];
  RNAsubopt_args_info_full_help[7] = RNAsubopt_args_info_detailed_help[8];
  RNAsubopt_args_info_full_help[8] = RNAsubopt_args_info_detailed_help[10];
  RNAsubopt_args_info_full_help[9] = RNAsubopt_args_info_detailed_help[12];
  RNAsubopt_args_info_full_help[10] = RNAsubopt_args_info_detailed_help[13];
  RNAsubopt_args_info_full_help[11] = RNAsubopt_args_info_detailed_help[15];
  RNAsubopt_args_info_full_help[12] = RNAsubopt_args_info_detailed_help[17];
  RNAsubopt_args_info_full_help[13] = RNAsubopt_args_info_detailed_help[19];
  RNAsubopt_args_info_full_help[14] = RNAsubopt_args_info_detailed_help[21];
  RNAsubopt_args_info_full_help[15] = RNAsubopt_args_info_detailed_help[23];
  RNAsubopt_args_info_full_help[16] = RNAsubopt_args_info_detailed_help[25];
  RNAsubopt_args_info_full_help[17] = RNAsubopt_args_info_detailed_help[27];
  RNAsubopt_args_info_full_help[18] = RNAsubopt_args_info_detailed_help[29];
  RNAsubopt_args_info_full_help[19] = RNAsubopt_args_info_detailed_help[30];
  RNAsubopt_args_info_full_help[20] = RNAsubopt_args_info_detailed_help[31];
  RNAsubopt_args_info_full_help[21] = RNAsubopt_args_info_detailed_help[32];
  RNAsubopt_args_info_full_help[22] = RNAsubopt_args_info_detailed_help[33];
  RNAsubopt_args_info_full_help[23] = RNAsubopt_args_info_detailed_help[34];
  RNAsubopt_args_info_full_help[24] = RNAsubopt_args_info_detailed_help[36];
  RNAsubopt_args_info_full_help[25] = RNAsubopt_args_info_detailed_help[38];
  RNAsubopt_args_info_full_help[26] = RNAsubopt_args_info_detailed_help[40];
  RNAsubopt_args_info_full_help[27] = RNAsubopt_args_info_detailed_help[42];
  RNAsubopt_args_info_full_help[28] = RNAsubopt_args_info_detailed_help[44];
  RNAsubopt_args_info_full_help[29] = RNAsubopt_args_info_detailed_help[45];
  RNAsubopt_args_info_full_help[30] = RNAsubopt_args_info_detailed_help[46];
  RNAsubopt_args_info_full_help[31] = RNAsubopt_args_info_detailed_help[48];
  RNAsubopt_args_info_full_help[32] = RNAsubopt_args_info_detailed_help[49];
  RNAsubopt_args_info_full_help[33] = RNAsubopt_args_info_detailed_help[51];
  RNAsubopt_args_info_full_help[34] = RNAsubopt_args_info_detailed_help[52];
  RNAsubopt_args_info_full_help[35] = RNAsubopt_args_info_detailed_help[54];
  RNAsubopt_args_info_full_help[36] = RNAsubopt_args_info_detailed_help[55];
  RNAsubopt_args_info_full_help[37] = RNAsubopt_args_info_detailed_help[57];
  RNAsubopt_args_info_full_help[38] = RNAsubopt_args_info_detailed_help[58];
  RNAsubopt_args_info_full_help[39] = RNAsubopt_args_info_detailed_help[59];
  RNAsubopt_args_info_full_help[40] = RNAsubopt_args_info_detailed_help[60];
  RNAsubopt_args_info_full_help[41] = RNAsubopt_args_info_detailed_help[62];
  RNAsubopt_args_info_full_help[42] = RNAsubopt_args_info_detailed_help[64];
  RNAsubopt_args_info_full_help[43] = RNAsubopt_args_info_detailed_help[65];
  RNAsubopt_args_info_full_help[44] = RNAsubopt_args_info_detailed_help[66];
  RNAsubopt_args_info_full_help[45] = RNAsubopt_args_info_detailed_help[68];
  RNAsubopt_args_info_full_help[46] = RNAsubopt_args_info_detailed_help[69];
  RNAsubopt_args_info_full_help[47] = RNAsubopt_args_info_detailed_help[70];
  RNAsubopt_args_info_full_help[48] = RNAsubopt_args_info_detailed_help[72];
  RNAsubopt_args_info_full_help[49] = RNAsubopt_args_info_detailed_help[74];
  RNAsubopt_args_info_full_help[50] = RNAsubopt_args_info_detailed_help[75];
  RNAsubopt_args_info_full_help[51] = RNAsubopt_args_info_detailed_help[76];
  RNAsubopt_args_info_full_help[52] = RNAsubopt_args_info_detailed_help[78];
  RNAsubopt_args_info_full_help[53] = RNAsubopt_args_info_detailed_help[80];
  RNAsubopt_args_info_full_help[54] = RNAsubopt_args_info_detailed_help[81];
  RNAsubopt_args_info_full_help[55] = RNAsubopt_args_info_detailed_help[82];
  RNAsubopt_args_info_full_help[56] = RNAsubopt_args_info_detailed_help[83];
  RNAsubopt_args_info_full_help[57] = RNAsubopt_args_info_detailed_help[85];
  RNAsubopt_args_info_full_help[58] = RNAsubopt_args_info_detailed_help[87];
  RNAsubopt_args_info_full_help[59] = RNAsubopt_args_info_detailed_help[88];
  RNAsubopt_args_info_full_help[60] = RNAsubopt_args_info_detailed_help[90];
  RNAsubopt_args_info_full_help[61] = RNAsubopt_args_info_detailed_help[91];
  RNAsubopt_args_info_full_help[62] = RNAsubopt_args_info_detailed_help[92];
  RNAsubopt_args_info_full_help[63] = RNAsubopt_args_info_detailed_help[93];
  RNAsubopt_args_info_full_help[64] = RNAsubopt_args_info_detailed_help[95];
  RNAsubopt_args_info_full_help[65] = RNAsubopt_args_info_detailed_help[97];
  RNAsubopt_args_info_full_help[66] = RNAsubopt_args_info_detailed_help[98];
  RNAsubopt_args_info_full_help[67] = RNAsubopt_args_info_detailed_help[99];
  RNAsubopt_args_info_full_help[68] = RNAsubopt_args_info_detailed_help[101];
  RNAsubopt_args_info_full_help[69] = RNAsubopt_args_info_detailed_help[103];
  RNAsubopt_args_info_full_help[70] = RNAsubopt_args_info_detailed_help[105];
  RNAsubopt_args_info_full_help[71] = RNAsubopt_args_info_detailed_help[107];
  RNAsubopt_args_info_full_help[72] = RNAsubopt_args_info_detailed_help[109];
  RNAsubopt_args_info_full_help[73] = 0; 
  
}

const char *RNAsubopt_args_info_full_help[74];

static void
init_help_array(void)
{
  RNAsubopt_args_info_help[0] = RNAsubopt_args_info_detailed_help[0];
  RNAsubopt_args_info_help[1] = RNAsubopt_args_info_detailed_help[1];
  RNAsubopt_args_info_help[2] = RNAsubopt_args_info_detailed_help[2];
  RNAsubopt_args_info_help[3] = RNAsubopt_args_info_detailed_help[3];
  RNAsubopt_args_info_help[4] = RNAsubopt_args_info_detailed_help[4];
  RNAsubopt_args_info_help[5] = RNAsubopt_args_info_detailed_help[6];
  RNAsubopt_args_info_help[6] = RNAsubopt_args_info_detailed_help[7];
  RNAsubopt_args_info_help[7] = RNAsubopt_args_info_detailed_help[8];
  RNAsubopt_args_info_help[8] = RNAsubopt_args_info_detailed_help[10];
  RNAsubopt_args_info_help[9] = RNAsubopt_args_info_detailed_help[12];
  RNAsubopt_args_info_help[10] = RNAsubopt_args_info_detailed_help[13];
  RNAsubopt_args_info_help[11] = RNAsubopt_args_info_detailed_help[15];
  RNAsubopt_args_info_help[12] = RNAsubopt_args_info_detailed_help[32];
  RNAsubopt_args_info_help[13] = RNAsubopt_args_info_detailed_help[33];
  RNAsubopt_args_info_help[14] = RNAsubopt_args_info_detailed_help[34];
  RNAsubopt_args_info_help[15] = RNAsubopt_args_info_detailed_help[38];
  RNAsubopt_args_info_help[16] = RNAsubopt_args_info_detailed_help[42];
  RNAsubopt_args_info_help[17] = RNAsubopt_args_info_detailed_help[48];
  RNAsubopt_args_info_help[18] = RNAsubopt_args_info_detailed_help[51];
  RNAsubopt_args_info_help[19] = RNAsubopt_args_info_detailed_help[52];
  RNAsubopt_args_info_help[20] = RNAsubopt_args_info_detailed_help[54];
  RNAsubopt_args_info_help[21] = RNAsubopt_args_info_detailed_help[55];
  RNAsubopt_args_info_help[22] = RNAsubopt_args_info_detailed_help[57];
  RNAsubopt_args_info_help[23] = RNAsubopt_args_info_detailed_help[58];
  RNAsubopt_args_info_help[24] = RNAsubopt_args_info_detailed_help[59];
  RNAsubopt_args_info_help[25] = RNAsubopt_args_info_detailed_help[60];
  RNAsubopt_args_info_help[26] = RNAsubopt_args_info_detailed_help[65];
  RNAsubopt_args_info_help[27] = RNAsubopt_args_info_detailed_help[68];
  RNAsubopt_args_info_help[28] = RNAsubopt_args_info_detailed_help[69];
  RNAsubopt_args_info_help[29] = RNAsubopt_args_info_detailed_help[70];
  RNAsubopt_args_info_help[30] = RNAsubopt_args_info_detailed_help[72];
  RNAsubopt_args_info_help[31] = RNAsubopt_args_info_detailed_help[75];
  RNAsubopt_args_info_help[32] = RNAsubopt_args_info_detailed_help[80];
  RNAsubopt_args_info_help[33] = RNAsubopt_args_info_detailed_help[81];
  RNAsubopt_args_info_help[34] = RNAsubopt_args_info_detailed_help[82];
  RNAsubopt_args_info_help[35] = RNAsubopt_args_info_detailed_help[83];
  RNAsubopt_args_info_help[36] = RNAsubopt_args_info_detailed_help[87];
  RNAsubopt_args_info_help[37] = RNAsubopt_args_info_detailed_help[88];
  RNAsubopt_args_info_help[38] = RNAsubopt_args_info_detailed_help[90];
  RNAsubopt_args_info_help[39] = RNAsubopt_args_info_detailed_help[91];
  RNAsubopt_args_info_help[40] = RNAsubopt_args_info_detailed_help[92];
  RNAsubopt_args_info_help[41] = RNAsubopt_args_info_detailed_help[93];
  RNAsubopt_args_info_help[42] = RNAsubopt_args_info_detailed_help[95];
  RNAsubopt_args_info_help[43] = RNAsubopt_args_info_detailed_help[99];
  RNAsubopt_args_info_help[44] = RNAsubopt_args_info_detailed_help[109];
  RNAsubopt_args_info_help[45] = 0; 
  
}

const char *RNAsubopt_args_info_help[46];

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
  , ARG_LONG
  , ARG_FLOAT
  , ARG_DOUBLE
} RNAsubopt_cmdline_parser_arg_type;

static
void clear_given (struct RNAsubopt_args_info *args_info);
static
void clear_args (struct RNAsubopt_args_info *args_info);

static int
RNAsubopt_cmdline_parser_internal (int argc, char **argv, struct RNAsubopt_args_info *args_info,
                        struct RNAsubopt_cmdline_parser_params *params, const char *additional_error);

static int
RNAsubopt_cmdline_parser_required2 (struct RNAsubopt_args_info *args_info, const char *prog_name, const char *additional_error);

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct RNAsubopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->detailed_help_given = 0 ;
  args_info->full_help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->infile_given = 0 ;
  args_info->outfile_given = 0 ;
  args_info->noconv_given = 0 ;
  args_info->auto_id_given = 0 ;
  args_info->id_prefix_given = 0 ;
  args_info->id_delim_given = 0 ;
  args_info->id_digits_given = 0 ;
  args_info->id_start_given = 0 ;
  args_info->filename_delim_given = 0 ;
  args_info->filename_full_given = 0 ;
  args_info->log_level_given = 0 ;
  args_info->log_file_given = 0 ;
  args_info->log_time_given = 0 ;
  args_info->log_call_given = 0 ;
  args_info->deltaEnergy_given = 0 ;
  args_info->deltaEnergyPost_given = 0 ;
  args_info->sorted_given = 0 ;
  args_info->en_only_given = 0 ;
  args_info->stochBT_given = 0 ;
  args_info->stochBT_en_given = 0 ;
  args_info->random_seed_given = 0 ;
  args_info->betaScale_given = 0 ;
  args_info->nonRedundant_given = 0 ;
  args_info->pfScale_given = 0 ;
  args_info->circ_given = 0 ;
  args_info->dos_given = 0 ;
  args_info->zuker_given = 0 ;
  args_info->gquad_given = 0 ;
  args_info->maxBPspan_given = 0 ;
  args_info->constraint_given = 0 ;
  args_info->batch_given = 0 ;
  args_info->canonicalBPonly_given = 0 ;
  args_info->enforceConstraint_given = 0 ;
  args_info->commands_given = 0 ;
  args_info->sp_data_given = 0 ;
  args_info->sp_strategy_given = 0 ;
  args_info->sp_preprocess_given = 0 ;
  args_info->shape_given = 0 ;
  args_info->shapeMethod_given = 0 ;
  args_info->shapeConversion_given = 0 ;
  args_info->temp_given = 0 ;
  args_info->paramFile_given = 0 ;
  args_info->noTetra_given = 0 ;
  args_info->salt_given = 0 ;
  args_info->modifications_given = 0 ;
  args_info->mod_file_given = 0 ;
  args_info->dangles_given = 0 ;
  args_info->noLP_given = 0 ;
  args_info->noGU_given = 0 ;
  args_info->noClosingGU_given = 0 ;
  args_info->logML_given = 0 ;
  args_info->nsp_given = 0 ;
  args_info->energyModel_given = 0 ;
  args_info->helical_rise_given = 0 ;
  args_info->backbone_length_given = 0 ;
}

static
void clear_args (struct RNAsubopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->verbose_flag = 0;
  args_info->infile_arg = NULL;
  args_info->infile_orig = NULL;
  args_info->outfile_arg = NULL;
  args_info->outfile_orig = NULL;
  args_info->noconv_flag = 0;
  args_info->auto_id_flag = 0;
  args_info->id_prefix_arg = gengetopt_strdup ("sequence");
  args_info->id_prefix_orig = NULL;
  args_info->id_delim_arg = gengetopt_strdup ("_");
  args_info->id_delim_orig = NULL;
  args_info->id_digits_arg = 4;
  args_info->id_digits_orig = NULL;
  args_info->id_start_arg = 1;
  args_info->id_start_orig = NULL;
  args_info->filename_delim_arg = gengetopt_strdup ("ID-delimiter");
  args_info->filename_delim_orig = NULL;
  args_info->filename_full_flag = 0;
  args_info->log_level_arg = 2;
  args_info->log_level_orig = NULL;
  args_info->log_file_arg = gengetopt_strdup ("RNAsubopt.log");
  args_info->log_file_orig = NULL;
  args_info->log_time_flag = 0;
  args_info->log_call_flag = 0;
  args_info->deltaEnergy_orig = NULL;
  args_info->deltaEnergyPost_orig = NULL;
  args_info->sorted_flag = 0;
  args_info->en_only_flag = 0;
  args_info->stochBT_orig = NULL;
  args_info->stochBT_en_orig = NULL;
  args_info->random_seed_orig = NULL;
  args_info->betaScale_arg = 1.;
  args_info->betaScale_orig = NULL;
  args_info->nonRedundant_flag = 0;
  args_info->pfScale_arg = 1.07;
  args_info->pfScale_orig = NULL;
  args_info->circ_flag = 0;
  args_info->dos_flag = 0;
  args_info->zuker_flag = 0;
  args_info->gquad_flag = 0;
  args_info->maxBPspan_arg = -1;
  args_info->maxBPspan_orig = NULL;
  args_info->constraint_arg = gengetopt_strdup ("");
  args_info->constraint_orig = NULL;
  args_info->batch_flag = 0;
  args_info->canonicalBPonly_flag = 0;
  args_info->enforceConstraint_flag = 0;
  args_info->commands_arg = NULL;
  args_info->commands_orig = NULL;
  args_info->sp_data_arg = NULL;
  args_info->sp_data_orig = NULL;
  args_info->sp_strategy_arg = NULL;
  args_info->sp_strategy_orig = NULL;
  args_info->sp_preprocess_arg = NULL;
  args_info->sp_preprocess_orig = NULL;
  args_info->shape_arg = NULL;
  args_info->shape_orig = NULL;
  args_info->shapeMethod_arg = gengetopt_strdup ("D");
  args_info->shapeMethod_orig = NULL;
  args_info->shapeConversion_arg = gengetopt_strdup ("O");
  args_info->shapeConversion_orig = NULL;
  args_info->temp_arg = 37.0;
  args_info->temp_orig = NULL;
  args_info->paramFile_arg = NULL;
  args_info->paramFile_orig = NULL;
  args_info->noTetra_flag = 0;
  args_info->salt_orig = NULL;
  args_info->modifications_arg = gengetopt_strdup ("7I6P9D");
  args_info->modifications_orig = NULL;
  args_info->mod_file_arg = NULL;
  args_info->mod_file_orig = NULL;
  args_info->dangles_arg = 2;
  args_info->dangles_orig = NULL;
  args_info->noLP_flag = 0;
  args_info->noGU_flag = 0;
  args_info->noClosingGU_flag = 0;
  args_info->logML_flag = 0;
  args_info->nsp_arg = NULL;
  args_info->nsp_orig = NULL;
  args_info->energyModel_orig = NULL;
  args_info->helical_rise_arg = 2.8;
  args_info->helical_rise_orig = NULL;
  args_info->backbone_length_arg = 6.0;
  args_info->backbone_length_orig = NULL;
  
}

static
void init_args_info(struct RNAsubopt_args_info *args_info)
{
  init_full_help_array(); 
  init_help_array(); 
  args_info->help_help = RNAsubopt_args_info_detailed_help[0] ;
  args_info->detailed_help_help = RNAsubopt_args_info_detailed_help[1] ;
  args_info->full_help_help = RNAsubopt_args_info_detailed_help[2] ;
  args_info->version_help = RNAsubopt_args_info_detailed_help[3] ;
  args_info->verbose_help = RNAsubopt_args_info_detailed_help[4] ;
  args_info->infile_help = RNAsubopt_args_info_detailed_help[8] ;
  args_info->outfile_help = RNAsubopt_args_info_detailed_help[10] ;
  args_info->noconv_help = RNAsubopt_args_info_detailed_help[12] ;
  args_info->auto_id_help = RNAsubopt_args_info_detailed_help[13] ;
  args_info->id_prefix_help = RNAsubopt_args_info_detailed_help[15] ;
  args_info->id_delim_help = RNAsubopt_args_info_detailed_help[17] ;
  args_info->id_digits_help = RNAsubopt_args_info_detailed_help[19] ;
  args_info->id_start_help = RNAsubopt_args_info_detailed_help[21] ;
  args_info->filename_delim_help = RNAsubopt_args_info_detailed_help[23] ;
  args_info->filename_full_help = RNAsubopt_args_info_detailed_help[25] ;
  args_info->log_level_help = RNAsubopt_args_info_detailed_help[27] ;
  args_info->log_file_help = RNAsubopt_args_info_detailed_help[29] ;
  args_info->log_time_help = RNAsubopt_args_info_detailed_help[30] ;
  args_info->log_call_help = RNAsubopt_args_info_detailed_help[31] ;
  args_info->deltaEnergy_help = RNAsubopt_args_info_detailed_help[34] ;
  args_info->deltaEnergyPost_help = RNAsubopt_args_info_detailed_help[36] ;
  args_info->sorted_help = RNAsubopt_args_info_detailed_help[38] ;
  args_info->en_only_help = RNAsubopt_args_info_detailed_help[40] ;
  args_info->stochBT_help = RNAsubopt_args_info_detailed_help[42] ;
  args_info->stochBT_en_help = RNAsubopt_args_info_detailed_help[44] ;
  args_info->random_seed_help = RNAsubopt_args_info_detailed_help[45] ;
  args_info->betaScale_help = RNAsubopt_args_info_detailed_help[46] ;
  args_info->nonRedundant_help = RNAsubopt_args_info_detailed_help[48] ;
  args_info->pfScale_help = RNAsubopt_args_info_detailed_help[49] ;
  args_info->circ_help = RNAsubopt_args_info_detailed_help[51] ;
  args_info->dos_help = RNAsubopt_args_info_detailed_help[52] ;
  args_info->zuker_help = RNAsubopt_args_info_detailed_help[54] ;
  args_info->gquad_help = RNAsubopt_args_info_detailed_help[55] ;
  args_info->maxBPspan_help = RNAsubopt_args_info_detailed_help[59] ;
  args_info->constraint_help = RNAsubopt_args_info_detailed_help[60] ;
  args_info->batch_help = RNAsubopt_args_info_detailed_help[62] ;
  args_info->canonicalBPonly_help = RNAsubopt_args_info_detailed_help[64] ;
  args_info->enforceConstraint_help = RNAsubopt_args_info_detailed_help[65] ;
  args_info->commands_help = RNAsubopt_args_info_detailed_help[66] ;
  args_info->sp_data_help = RNAsubopt_args_info_detailed_help[70] ;
  args_info->sp_data_min = 0;
  args_info->sp_data_max = 0;
  args_info->sp_strategy_help = RNAsubopt_args_info_detailed_help[72] ;
  args_info->sp_strategy_min = 0;
  args_info->sp_strategy_max = 0;
  args_info->sp_preprocess_help = RNAsubopt_args_info_detailed_help[74] ;
  args_info->sp_preprocess_min = 0;
  args_info->sp_preprocess_max = 0;
  args_info->shape_help = RNAsubopt_args_info_detailed_help[75] ;
  args_info->shapeMethod_help = RNAsubopt_args_info_detailed_help[76] ;
  args_info->shapeConversion_help = RNAsubopt_args_info_detailed_help[78] ;
  args_info->temp_help = RNAsubopt_args_info_detailed_help[82] ;
  args_info->paramFile_help = RNAsubopt_args_info_detailed_help[83] ;
  args_info->noTetra_help = RNAsubopt_args_info_detailed_help[85] ;
  args_info->salt_help = RNAsubopt_args_info_detailed_help[87] ;
  args_info->modifications_help = RNAsubopt_args_info_detailed_help[88] ;
  args_info->mod_file_help = RNAsubopt_args_info_detailed_help[90] ;
  args_info->mod_file_min = 0;
  args_info->mod_file_max = 0;
  args_info->dangles_help = RNAsubopt_args_info_detailed_help[93] ;
  args_info->noLP_help = RNAsubopt_args_info_detailed_help[95] ;
  args_info->noGU_help = RNAsubopt_args_info_detailed_help[97] ;
  args_info->noClosingGU_help = RNAsubopt_args_info_detailed_help[98] ;
  args_info->logML_help = RNAsubopt_args_info_detailed_help[99] ;
  args_info->nsp_help = RNAsubopt_args_info_detailed_help[101] ;
  args_info->energyModel_help = RNAsubopt_args_info_detailed_help[103] ;
  args_info->helical_rise_help = RNAsubopt_args_info_detailed_help[105] ;
  args_info->backbone_length_help = RNAsubopt_args_info_detailed_help[107] ;
  
}

void
RNAsubopt_cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(RNASUBOPT_CMDLINE_PARSER_PACKAGE_NAME) ? RNASUBOPT_CMDLINE_PARSER_PACKAGE_NAME : RNASUBOPT_CMDLINE_PARSER_PACKAGE),
     RNASUBOPT_CMDLINE_PARSER_VERSION);

  if (strlen(RNAsubopt_args_info_versiontext) > 0)
    printf("\n%s\n", RNAsubopt_args_info_versiontext);
}

static void print_help_common(void)
{
	size_t len_purpose = strlen(RNAsubopt_args_info_purpose);
	size_t len_usage = strlen(RNAsubopt_args_info_usage);

	if (len_usage > 0) {
		printf("%s\n", RNAsubopt_args_info_usage);
	}
	if (len_purpose > 0) {
		printf("%s\n", RNAsubopt_args_info_purpose);
	}

	if (len_usage || len_purpose) {
		printf("\n");
	}

	if (strlen(RNAsubopt_args_info_description) > 0) {
		printf("%s\n\n", RNAsubopt_args_info_description);
	}
}

void
RNAsubopt_cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (RNAsubopt_args_info_help[i])
    printf("%s\n", RNAsubopt_args_info_help[i++]);
}

void
RNAsubopt_cmdline_parser_print_full_help (void)
{
  int i = 0;
  print_help_common();
  while (RNAsubopt_args_info_full_help[i])
    printf("%s\n", RNAsubopt_args_info_full_help[i++]);
}

void
RNAsubopt_cmdline_parser_print_detailed_help (void)
{
  int i = 0;
  print_help_common();
  while (RNAsubopt_args_info_detailed_help[i])
    printf("%s\n", RNAsubopt_args_info_detailed_help[i++]);
}

void
RNAsubopt_cmdline_parser_init (struct RNAsubopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
RNAsubopt_cmdline_parser_params_init(struct RNAsubopt_cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct RNAsubopt_cmdline_parser_params *
RNAsubopt_cmdline_parser_params_create(void)
{
  struct RNAsubopt_cmdline_parser_params *params = 
    (struct RNAsubopt_cmdline_parser_params *)malloc(sizeof(struct RNAsubopt_cmdline_parser_params));
  RNAsubopt_cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}

/** @brief generic value variable */
union generic_value {
    int int_arg;
    long long_arg;
    float float_arg;
    double double_arg;
    char *string_arg;
    const char *default_string_arg;
};

/** @brief holds temporary values for multiple options */
struct generic_list
{
  union generic_value arg;
  char *orig;
  struct generic_list *next;
};

/**
 * @brief add a node at the head of the list 
 */
static void add_node(struct generic_list **list) {
  struct generic_list *new_node = (struct generic_list *) malloc (sizeof (struct generic_list));
  new_node->next = *list;
  *list = new_node;
  new_node->arg.string_arg = 0;
  new_node->orig = 0;
}


static void
free_multiple_string_field(unsigned int len, char ***arg, char ***orig)
{
  unsigned int i;
  if (*arg) {
    for (i = 0; i < len; ++i)
      {
        free_string_field(&((*arg)[i]));
        free_string_field(&((*orig)[i]));
      }
    free_string_field(&((*arg)[0])); /* free default string */

    free (*arg);
    *arg = 0;
    free (*orig);
    *orig = 0;
  }
}

static void
RNAsubopt_cmdline_parser_release (struct RNAsubopt_args_info *args_info)
{

  free_string_field (&(args_info->infile_arg));
  free_string_field (&(args_info->infile_orig));
  free_string_field (&(args_info->outfile_arg));
  free_string_field (&(args_info->outfile_orig));
  free_string_field (&(args_info->id_prefix_arg));
  free_string_field (&(args_info->id_prefix_orig));
  free_string_field (&(args_info->id_delim_arg));
  free_string_field (&(args_info->id_delim_orig));
  free_string_field (&(args_info->id_digits_orig));
  free_string_field (&(args_info->id_start_orig));
  free_string_field (&(args_info->filename_delim_arg));
  free_string_field (&(args_info->filename_delim_orig));
  free_string_field (&(args_info->log_level_orig));
  free_string_field (&(args_info->log_file_arg));
  free_string_field (&(args_info->log_file_orig));
  free_string_field (&(args_info->deltaEnergy_orig));
  free_string_field (&(args_info->deltaEnergyPost_orig));
  free_string_field (&(args_info->stochBT_orig));
  free_string_field (&(args_info->stochBT_en_orig));
  free_string_field (&(args_info->random_seed_orig));
  free_string_field (&(args_info->betaScale_orig));
  free_string_field (&(args_info->pfScale_orig));
  free_string_field (&(args_info->maxBPspan_orig));
  free_string_field (&(args_info->constraint_arg));
  free_string_field (&(args_info->constraint_orig));
  free_string_field (&(args_info->commands_arg));
  free_string_field (&(args_info->commands_orig));
  free_multiple_string_field (args_info->sp_data_given, &(args_info->sp_data_arg), &(args_info->sp_data_orig));
  free_multiple_string_field (args_info->sp_strategy_given, &(args_info->sp_strategy_arg), &(args_info->sp_strategy_orig));
  free_multiple_string_field (args_info->sp_preprocess_given, &(args_info->sp_preprocess_arg), &(args_info->sp_preprocess_orig));
  free_string_field (&(args_info->shape_arg));
  free_string_field (&(args_info->shape_orig));
  free_string_field (&(args_info->shapeMethod_arg));
  free_string_field (&(args_info->shapeMethod_orig));
  free_string_field (&(args_info->shapeConversion_arg));
  free_string_field (&(args_info->shapeConversion_orig));
  free_string_field (&(args_info->temp_orig));
  free_string_field (&(args_info->paramFile_arg));
  free_string_field (&(args_info->paramFile_orig));
  free_string_field (&(args_info->salt_orig));
  free_string_field (&(args_info->modifications_arg));
  free_string_field (&(args_info->modifications_orig));
  free_multiple_string_field (args_info->mod_file_given, &(args_info->mod_file_arg), &(args_info->mod_file_orig));
  free_string_field (&(args_info->dangles_orig));
  free_string_field (&(args_info->nsp_arg));
  free_string_field (&(args_info->nsp_orig));
  free_string_field (&(args_info->energyModel_orig));
  free_string_field (&(args_info->helical_rise_orig));
  free_string_field (&(args_info->backbone_length_orig));
  
  

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}

static void
write_multiple_into_file(FILE *outfile, int len, const char *opt, char **arg, const char *values[])
{
  int i;
  
  for (i = 0; i < len; ++i)
    write_into_file(outfile, opt, (arg ? arg[i] : 0), values);
}

int
RNAsubopt_cmdline_parser_dump(FILE *outfile, struct RNAsubopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", RNASUBOPT_CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->detailed_help_given)
    write_into_file(outfile, "detailed-help", 0, 0 );
  if (args_info->full_help_given)
    write_into_file(outfile, "full-help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->verbose_given)
    write_into_file(outfile, "verbose", 0, 0 );
  if (args_info->infile_given)
    write_into_file(outfile, "infile", args_info->infile_orig, 0);
  if (args_info->outfile_given)
    write_into_file(outfile, "outfile", args_info->outfile_orig, 0);
  if (args_info->noconv_given)
    write_into_file(outfile, "noconv", 0, 0 );
  if (args_info->auto_id_given)
    write_into_file(outfile, "auto-id", 0, 0 );
  if (args_info->id_prefix_given)
    write_into_file(outfile, "id-prefix", args_info->id_prefix_orig, 0);
  if (args_info->id_delim_given)
    write_into_file(outfile, "id-delim", args_info->id_delim_orig, 0);
  if (args_info->id_digits_given)
    write_into_file(outfile, "id-digits", args_info->id_digits_orig, 0);
  if (args_info->id_start_given)
    write_into_file(outfile, "id-start", args_info->id_start_orig, 0);
  if (args_info->filename_delim_given)
    write_into_file(outfile, "filename-delim", args_info->filename_delim_orig, 0);
  if (args_info->filename_full_given)
    write_into_file(outfile, "filename-full", 0, 0 );
  if (args_info->log_level_given)
    write_into_file(outfile, "log-level", args_info->log_level_orig, 0);
  if (args_info->log_file_given)
    write_into_file(outfile, "log-file", args_info->log_file_orig, 0);
  if (args_info->log_time_given)
    write_into_file(outfile, "log-time", 0, 0 );
  if (args_info->log_call_given)
    write_into_file(outfile, "log-call", 0, 0 );
  if (args_info->deltaEnergy_given)
    write_into_file(outfile, "deltaEnergy", args_info->deltaEnergy_orig, 0);
  if (args_info->deltaEnergyPost_given)
    write_into_file(outfile, "deltaEnergyPost", args_info->deltaEnergyPost_orig, 0);
  if (args_info->sorted_given)
    write_into_file(outfile, "sorted", 0, 0 );
  if (args_info->en_only_given)
    write_into_file(outfile, "en-only", 0, 0 );
  if (args_info->stochBT_given)
    write_into_file(outfile, "stochBT", args_info->stochBT_orig, 0);
  if (args_info->stochBT_en_given)
    write_into_file(outfile, "stochBT_en", args_info->stochBT_en_orig, 0);
  if (args_info->random_seed_given)
    write_into_file(outfile, "random-seed", args_info->random_seed_orig, 0);
  if (args_info->betaScale_given)
    write_into_file(outfile, "betaScale", args_info->betaScale_orig, 0);
  if (args_info->nonRedundant_given)
    write_into_file(outfile, "nonRedundant", 0, 0 );
  if (args_info->pfScale_given)
    write_into_file(outfile, "pfScale", args_info->pfScale_orig, 0);
  if (args_info->circ_given)
    write_into_file(outfile, "circ", 0, 0 );
  if (args_info->dos_given)
    write_into_file(outfile, "dos", 0, 0 );
  if (args_info->zuker_given)
    write_into_file(outfile, "zuker", 0, 0 );
  if (args_info->gquad_given)
    write_into_file(outfile, "gquad", 0, 0 );
  if (args_info->maxBPspan_given)
    write_into_file(outfile, "maxBPspan", args_info->maxBPspan_orig, 0);
  if (args_info->constraint_given)
    write_into_file(outfile, "constraint", args_info->constraint_orig, 0);
  if (args_info->batch_given)
    write_into_file(outfile, "batch", 0, 0 );
  if (args_info->canonicalBPonly_given)
    write_into_file(outfile, "canonicalBPonly", 0, 0 );
  if (args_info->enforceConstraint_given)
    write_into_file(outfile, "enforceConstraint", 0, 0 );
  if (args_info->commands_given)
    write_into_file(outfile, "commands", args_info->commands_orig, 0);
  write_multiple_into_file(outfile, args_info->sp_data_given, "sp-data", args_info->sp_data_orig, 0);
  write_multiple_into_file(outfile, args_info->sp_strategy_given, "sp-strategy", args_info->sp_strategy_orig, 0);
  write_multiple_into_file(outfile, args_info->sp_preprocess_given, "sp-preprocess", args_info->sp_preprocess_orig, 0);
  if (args_info->shape_given)
    write_into_file(outfile, "shape", args_info->shape_orig, 0);
  if (args_info->shapeMethod_given)
    write_into_file(outfile, "shapeMethod", args_info->shapeMethod_orig, 0);
  if (args_info->shapeConversion_given)
    write_into_file(outfile, "shapeConversion", args_info->shapeConversion_orig, 0);
  if (args_info->temp_given)
    write_into_file(outfile, "temp", args_info->temp_orig, 0);
  if (args_info->paramFile_given)
    write_into_file(outfile, "paramFile", args_info->paramFile_orig, 0);
  if (args_info->noTetra_given)
    write_into_file(outfile, "noTetra", 0, 0 );
  if (args_info->salt_given)
    write_into_file(outfile, "salt", args_info->salt_orig, 0);
  if (args_info->modifications_given)
    write_into_file(outfile, "modifications", args_info->modifications_orig, 0);
  write_multiple_into_file(outfile, args_info->mod_file_given, "mod-file", args_info->mod_file_orig, 0);
  if (args_info->dangles_given)
    write_into_file(outfile, "dangles", args_info->dangles_orig, 0);
  if (args_info->noLP_given)
    write_into_file(outfile, "noLP", 0, 0 );
  if (args_info->noGU_given)
    write_into_file(outfile, "noGU", 0, 0 );
  if (args_info->noClosingGU_given)
    write_into_file(outfile, "noClosingGU", 0, 0 );
  if (args_info->logML_given)
    write_into_file(outfile, "logML", 0, 0 );
  if (args_info->nsp_given)
    write_into_file(outfile, "nsp", args_info->nsp_orig, 0);
  if (args_info->energyModel_given)
    write_into_file(outfile, "energyModel", args_info->energyModel_orig, 0);
  if (args_info->helical_rise_given)
    write_into_file(outfile, "helical-rise", args_info->helical_rise_orig, 0);
  if (args_info->backbone_length_given)
    write_into_file(outfile, "backbone-length", args_info->backbone_length_orig, 0);
  

  i = EXIT_SUCCESS;
  return i;
}

int
RNAsubopt_cmdline_parser_file_save(const char *filename, struct RNAsubopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", RNASUBOPT_CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = RNAsubopt_cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
RNAsubopt_cmdline_parser_free (struct RNAsubopt_args_info *args_info)
{
  RNAsubopt_cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

static char *
get_multiple_arg_token(const char *arg)
{
  const char *tok;
  char *ret;
  size_t len, num_of_escape, i, j;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');
  num_of_escape = 0;

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
          ++num_of_escape;
        }
      else
        break;
    }

  if (tok)
    len = (size_t)(tok - arg + 1);
  else
    len = strlen (arg) + 1;

  len -= num_of_escape;

  ret = (char *) malloc (len);

  i = 0;
  j = 0;
  while (arg[i] && (j < len-1))
    {
      if (arg[i] == '\\' && 
	  arg[ i + 1 ] && 
	  arg[ i + 1 ] == ',')
        ++i;

      ret[j++] = arg[i++];
    }

  ret[len-1] = '\0';

  return ret;
}

static const char *
get_multiple_arg_token_next(const char *arg)
{
  const char *tok;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
        }
      else
        break;
    }

  if (! tok || strlen(tok) == 1)
    return 0;

  return tok+1;
}

static int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc);

int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc)
{
  int error_occurred = 0;

  if (option_given && (min > 0 || max > 0))
    {
      if (min > 0 && max > 0)
        {
          if (min == max)
            {
              /* specific occurrences */
              if (option_given != (unsigned int) min)
                {
                  fprintf (stderr, "%s: %s option occurrences must be %d\n",
                    prog_name, option_desc, min);
                  error_occurred = 1;
                }
            }
          else if (option_given < (unsigned int) min
                || option_given > (unsigned int) max)
            {
              /* range occurrences */
              fprintf (stderr, "%s: %s option occurrences must be between %d and %d\n",
                prog_name, option_desc, min, max);
              error_occurred = 1;
            }
        }
      else if (min > 0)
        {
          /* at least check */
          if (option_given < min)
            {
              fprintf (stderr, "%s: %s option occurrences must be at least %d\n",
                prog_name, option_desc, min);
              error_occurred = 1;
            }
        }
      else if (max > 0)
        {
          /* at most check */
          if (option_given > max)
            {
              fprintf (stderr, "%s: %s option occurrences must be at most %d\n",
                prog_name, option_desc, max);
              error_occurred = 1;
            }
        }
    }
    
  return error_occurred;
}
int
RNAsubopt_cmdline_parser (int argc, char **argv, struct RNAsubopt_args_info *args_info)
{
  return RNAsubopt_cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
RNAsubopt_cmdline_parser_ext (int argc, char **argv, struct RNAsubopt_args_info *args_info,
                   struct RNAsubopt_cmdline_parser_params *params)
{
  int result;
  result = RNAsubopt_cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      RNAsubopt_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
RNAsubopt_cmdline_parser2 (int argc, char **argv, struct RNAsubopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct RNAsubopt_cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = RNAsubopt_cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      RNAsubopt_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
RNAsubopt_cmdline_parser_required (struct RNAsubopt_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (RNAsubopt_cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      RNAsubopt_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
RNAsubopt_cmdline_parser_required2 (struct RNAsubopt_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error_occurred = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  if (check_multiple_option_occurrences(prog_name, args_info->sp_data_given, args_info->sp_data_min, args_info->sp_data_max, "'--sp-data'"))
     error_occurred = 1;
  
  if (check_multiple_option_occurrences(prog_name, args_info->sp_strategy_given, args_info->sp_strategy_min, args_info->sp_strategy_max, "'--sp-strategy'"))
     error_occurred = 1;
  
  if (check_multiple_option_occurrences(prog_name, args_info->sp_preprocess_given, args_info->sp_preprocess_min, args_info->sp_preprocess_max, "'--sp-preprocess'"))
     error_occurred = 1;
  
  if (check_multiple_option_occurrences(prog_name, args_info->mod_file_given, args_info->mod_file_min, args_info->mod_file_max, "'--mod-file'"))
     error_occurred = 1;
  
  
  /* checks for dependences among options */
  if (args_info->en_only_given && ! args_info->sorted_given)
    {
      fprintf (stderr, "%s: '--en-only' option depends on option 'sorted'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->betaScale_given && ! args_info->stochBT_given)
    {
      fprintf (stderr, "%s: '--betaScale' option depends on option 'stochBT'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->batch_given && ! args_info->constraint_given)
    {
      fprintf (stderr, "%s: '--batch' option depends on option 'constraint'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->canonicalBPonly_given && ! args_info->constraint_given)
    {
      fprintf (stderr, "%s: '--canonicalBPonly' option depends on option 'constraint'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->enforceConstraint_given && ! args_info->constraint_given)
    {
      fprintf (stderr, "%s: '--enforceConstraint' option depends on option 'constraint'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->sp_strategy_given && ! args_info->sp_data_given)
    {
      fprintf (stderr, "%s: '--sp-strategy' option depends on option 'sp-data'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->sp_preprocess_given && ! args_info->sp_data_given)
    {
      fprintf (stderr, "%s: '--sp-preprocess' option depends on option 'sp-data'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  if (args_info->shapeMethod_given && ! args_info->shape_given)
    {
      fprintf (stderr, "%s: '--shapeMethod' option depends on option 'shape'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }

  return error_occurred;
}

/*
 * Extracted from the glibc source tree, version 2.3.6
 *
 * Licensed under the GPL as per the whole glibc source tree.
 *
 * This file was modified so that getopt_long can be called
 * many times without risking previous memory to be spoiled.
 *
 * Modified by Andre Noll and Lorenzo Bettini for use in
 * GNU gengetopt generated files.
 *
 */

/* 
 * we must include anything we need since this file is not thought to be
 * inserted in a file already using getopt.h
 *
 * Lorenzo
 */

struct option
{
  const char *name;
  /* has_arg can't be an enum because some compilers complain about
     type mismatches in all the code that assumes it is an int.  */
  int has_arg;
  int *flag;
  int val;
};

/* This version of `getopt' appears to the caller like standard Unix `getopt'
   but it behaves differently for the user, since it allows the user
   to intersperse the options with the other arguments.

   As `getopt' works, it permutes the elements of ARGV so that,
   when it is done, all the options precede everything else.  Thus
   all application programs are extended to handle flexible argument order.
*/
/*
   If the field `flag' is not NULL, it points to a variable that is set
   to the value given in the field `val' when the option is found, but
   left unchanged if the option is not found.

   To have a long-named option do something other than set an `int' to
   a compiled-in constant, such as set a value from `custom_optarg', set the
   option's `flag' field to zero and its `val' field to a nonzero
   value (the equivalent single-letter option character, if there is
   one).  For long options that have a zero `flag' field, `getopt'
   returns the contents of the `val' field.  */

/* Names for the values of the `has_arg' field of `struct option'.  */
#ifndef no_argument
#define no_argument		0
#endif

#ifndef required_argument
#define required_argument	1
#endif

#ifndef optional_argument
#define optional_argument	2
#endif

struct custom_getopt_data {
	/*
	 * These have exactly the same meaning as the corresponding global variables,
	 * except that they are used for the reentrant versions of getopt.
	 */
	int custom_optind;
	int custom_opterr;
	int custom_optopt;
	char *custom_optarg;

	/* True if the internal members have been initialized.  */
	int initialized;

	/*
	 * The next char to be scanned in the option-element in which the last option
	 * character we returned was found.  This allows us to pick up the scan where
	 * we left off.  If this is zero, or a null string, it means resume the scan by
	 * advancing to the next ARGV-element.
	 */
	char *nextchar;

	/*
	 * Describe the part of ARGV that contains non-options that have been skipped.
	 * `first_nonopt' is the index in ARGV of the first of them; `last_nonopt' is
	 * the index after the last of them.
	 */
	int first_nonopt;
	int last_nonopt;
};

/*
 * the variables optarg, optind, opterr and optopt are renamed with
 * the custom_ prefix so that they don't interfere with getopt ones.
 *
 * Moreover they're static so they are visible only from within the
 * file where this very file will be included.
 */

/*
 * For communication from `custom_getopt' to the caller.  When `custom_getopt' finds an
 * option that takes an argument, the argument value is returned here.
 */
static char *custom_optarg;

/*
 * Index in ARGV of the next element to be scanned.  This is used for
 * communication to and from the caller and for communication between
 * successive calls to `custom_getopt'.
 *
 * On entry to `custom_getopt', 1 means this is the first call; initialize.
 *
 * When `custom_getopt' returns -1, this is the index of the first of the non-option
 * elements that the caller should itself scan.
 *
 * Otherwise, `custom_optind' communicates from one call to the next how much of ARGV
 * has been scanned so far.
 *
 * 1003.2 says this must be 1 before any call.
 */
static int custom_optind = 1;

/*
 * Callers store zero here to inhibit the error message for unrecognized
 * options.
 */
static int custom_opterr = 1;

/*
 * Set to an option character which was unrecognized.  This must be initialized
 * on some systems to avoid linking in the system's own getopt implementation.
 */
static int custom_optopt = '?';

/*
 * Exchange two adjacent subsequences of ARGV.  One subsequence is elements
 * [first_nonopt,last_nonopt) which contains all the non-options that have been
 * skipped so far.  The other is elements [last_nonopt,custom_optind), which contains
 * all the options processed since those non-options were skipped.
 * `first_nonopt' and `last_nonopt' are relocated so that they describe the new
 * indices of the non-options in ARGV after they are moved.
 */
static void exchange(char **argv, struct custom_getopt_data *d)
{
	int bottom = d->first_nonopt;
	int middle = d->last_nonopt;
	int top = d->custom_optind;
	char *tem;

	/*
	 * Exchange the shorter segment with the far end of the longer segment.
	 * That puts the shorter segment into the right place.  It leaves the
	 * longer segment in the right place overall, but it consists of two
	 * parts that need to be swapped next.
	 */
	while (top > middle && middle > bottom) {
		if (top - middle > middle - bottom) {
			/* Bottom segment is the short one.  */
			int len = middle - bottom;
			int i;

			/* Swap it with the top part of the top segment.  */
			for (i = 0; i < len; i++) {
				tem = argv[bottom + i];
				argv[bottom + i] =
					argv[top - (middle - bottom) + i];
				argv[top - (middle - bottom) + i] = tem;
			}
			/* Exclude the moved bottom segment from further swapping.  */
			top -= len;
		} else {
			/* Top segment is the short one.  */
			int len = top - middle;
			int i;

			/* Swap it with the bottom part of the bottom segment.  */
			for (i = 0; i < len; i++) {
				tem = argv[bottom + i];
				argv[bottom + i] = argv[middle + i];
				argv[middle + i] = tem;
			}
			/* Exclude the moved top segment from further swapping.  */
			bottom += len;
		}
	}
	/* Update records for the slots the non-options now occupy.  */
	d->first_nonopt += (d->custom_optind - d->last_nonopt);
	d->last_nonopt = d->custom_optind;
}

/* Initialize the internal data when the first call is made.  */
static void custom_getopt_initialize(struct custom_getopt_data *d)
{
	/*
	 * Start processing options with ARGV-element 1 (since ARGV-element 0
	 * is the program name); the sequence of previously skipped non-option
	 * ARGV-elements is empty.
	 */
	d->first_nonopt = d->last_nonopt = d->custom_optind;
	d->nextchar = NULL;
	d->initialized = 1;
}

#define NONOPTION_P (argv[d->custom_optind][0] != '-' || argv[d->custom_optind][1] == '\0')

/* return: zero: continue, nonzero: return given value to user */
static int shuffle_argv(int argc, char *const *argv,const struct option *longopts,
	struct custom_getopt_data *d)
{
	/*
	 * Give FIRST_NONOPT & LAST_NONOPT rational values if CUSTOM_OPTIND has been
	 * moved back by the user (who may also have changed the arguments).
	 */
	if (d->last_nonopt > d->custom_optind)
		d->last_nonopt = d->custom_optind;
	if (d->first_nonopt > d->custom_optind)
		d->first_nonopt = d->custom_optind;
	/*
	 * If we have just processed some options following some
	 * non-options, exchange them so that the options come first.
	 */
	if (d->first_nonopt != d->last_nonopt &&
			d->last_nonopt != d->custom_optind)
		exchange((char **) argv, d);
	else if (d->last_nonopt != d->custom_optind)
		d->first_nonopt = d->custom_optind;
	/*
	 * Skip any additional non-options and extend the range of
	 * non-options previously skipped.
	 */
	while (d->custom_optind < argc && NONOPTION_P)
		d->custom_optind++;
	d->last_nonopt = d->custom_optind;
	/*
	 * The special ARGV-element `--' means premature end of options.  Skip
	 * it like a null option, then exchange with previous non-options as if
	 * it were an option, then skip everything else like a non-option.
	 */
	if (d->custom_optind != argc && !strcmp(argv[d->custom_optind], "--")) {
		d->custom_optind++;
		if (d->first_nonopt != d->last_nonopt
				&& d->last_nonopt != d->custom_optind)
			exchange((char **) argv, d);
		else if (d->first_nonopt == d->last_nonopt)
			d->first_nonopt = d->custom_optind;
		d->last_nonopt = argc;
		d->custom_optind = argc;
	}
	/*
	 * If we have done all the ARGV-elements, stop the scan and back over
	 * any non-options that we skipped and permuted.
	 */
	if (d->custom_optind == argc) {
		/*
		 * Set the next-arg-index to point at the non-options that we
		 * previously skipped, so the caller will digest them.
		 */
		if (d->first_nonopt != d->last_nonopt)
			d->custom_optind = d->first_nonopt;
		return -1;
	}
	/*
	 * If we have come to a non-option and did not permute it, either stop
	 * the scan or describe it to the caller and pass it by.
	 */
	if (NONOPTION_P) {
		d->custom_optarg = argv[d->custom_optind++];
		return 1;
	}
	/*
	 * We have found another option-ARGV-element. Skip the initial
	 * punctuation.
	 */
	d->nextchar = (argv[d->custom_optind] + 1 + (longopts != NULL && argv[d->custom_optind][1] == '-'));
	return 0;
}

/*
 * Check whether the ARGV-element is a long option.
 *
 * If there's a long option "fubar" and the ARGV-element is "-fu", consider
 * that an abbreviation of the long option, just like "--fu", and not "-f" with
 * arg "u".
 *
 * This distinction seems to be the most useful approach.
 *
 */
static int check_long_opt(int argc, char *const *argv, const char *optstring,
		const struct option *longopts, int *longind,
		int print_errors, struct custom_getopt_data *d)
{
	char *nameend;
	const struct option *p;
	const struct option *pfound = NULL;
	int exact = 0;
	int ambig = 0;
	int indfound = -1;
	int option_index;

	for (nameend = d->nextchar; *nameend && *nameend != '='; nameend++)
		/* Do nothing.  */ ;

	/* Test all long options for either exact match or abbreviated matches */
	for (p = longopts, option_index = 0; p->name; p++, option_index++)
		if (!strncmp(p->name, d->nextchar, nameend - d->nextchar)) {
			if ((unsigned int) (nameend - d->nextchar)
					== (unsigned int) strlen(p->name)) {
				/* Exact match found.  */
				pfound = p;
				indfound = option_index;
				exact = 1;
				break;
			} else if (pfound == NULL) {
				/* First nonexact match found.  */
				pfound = p;
				indfound = option_index;
			} else if (pfound->has_arg != p->has_arg
					|| pfound->flag != p->flag
					|| pfound->val != p->val)
				/* Second or later nonexact match found.  */
				ambig = 1;
		}
	if (ambig && !exact) {
		if (print_errors) {
			fprintf(stderr,
				"%s: option `%s' is ambiguous\n",
				argv[0], argv[d->custom_optind]);
		}
		d->nextchar += strlen(d->nextchar);
		d->custom_optind++;
		d->custom_optopt = 0;
		return '?';
	}
	if (pfound) {
		option_index = indfound;
		d->custom_optind++;
		if (*nameend) {
			if (pfound->has_arg != no_argument)
				d->custom_optarg = nameend + 1;
			else {
				if (print_errors) {
					if (argv[d->custom_optind - 1][1] == '-') {
						/* --option */
						fprintf(stderr, "%s: option `--%s' doesn't allow an argument\n",
							argv[0], pfound->name);
					} else {
						/* +option or -option */
						fprintf(stderr, "%s: option `%c%s' doesn't allow an argument\n",
							argv[0], argv[d->custom_optind - 1][0], pfound->name);
					}

				}
				d->nextchar += strlen(d->nextchar);
				d->custom_optopt = pfound->val;
				return '?';
			}
		} else if (pfound->has_arg == required_argument) {
			if (d->custom_optind < argc)
				d->custom_optarg = argv[d->custom_optind++];
			else {
				if (print_errors) {
					fprintf(stderr,
						"%s: option `%s' requires an argument\n",
						argv[0],
						argv[d->custom_optind - 1]);
				}
				d->nextchar += strlen(d->nextchar);
				d->custom_optopt = pfound->val;
				return optstring[0] == ':' ? ':' : '?';
			}
		}
		d->nextchar += strlen(d->nextchar);
		if (longind != NULL)
			*longind = option_index;
		if (pfound->flag) {
			*(pfound->flag) = pfound->val;
			return 0;
		}
		return pfound->val;
	}
	/*
	 * Can't find it as a long option.  If this is not getopt_long_only, or
	 * the option starts with '--' or is not a valid short option, then
	 * it's an error.  Otherwise interpret it as a short option.
	 */
	if (print_errors) {
		if (argv[d->custom_optind][1] == '-') {
			/* --option */
			fprintf(stderr,
				"%s: unrecognized option `--%s'\n",
				argv[0], d->nextchar);
		} else {
			/* +option or -option */
			fprintf(stderr,
				"%s: unrecognized option `%c%s'\n",
				argv[0], argv[d->custom_optind][0],
				d->nextchar);
		}
	}
	d->nextchar = (char *) "";
	d->custom_optind++;
	d->custom_optopt = 0;
	return '?';
}

static int check_short_opt(int argc, char *const *argv, const char *optstring,
		int print_errors, struct custom_getopt_data *d)
{
	char c = *d->nextchar++;
	const char *temp = strchr(optstring, c);

	/* Increment `custom_optind' when we start to process its last character.  */
	if (*d->nextchar == '\0')
		++d->custom_optind;
	if (!temp || c == ':') {
		if (print_errors)
			fprintf(stderr, "%s: invalid option -- %c\n", argv[0], c);

		d->custom_optopt = c;
		return '?';
	}
	if (temp[1] == ':') {
		if (temp[2] == ':') {
			/* This is an option that accepts an argument optionally.  */
			if (*d->nextchar != '\0') {
				d->custom_optarg = d->nextchar;
				d->custom_optind++;
			} else
				d->custom_optarg = NULL;
			d->nextchar = NULL;
		} else {
			/* This is an option that requires an argument.  */
			if (*d->nextchar != '\0') {
				d->custom_optarg = d->nextchar;
				/*
				 * If we end this ARGV-element by taking the
				 * rest as an arg, we must advance to the next
				 * element now.
				 */
				d->custom_optind++;
			} else if (d->custom_optind == argc) {
				if (print_errors) {
					fprintf(stderr,
						"%s: option requires an argument -- %c\n",
						argv[0], c);
				}
				d->custom_optopt = c;
				if (optstring[0] == ':')
					c = ':';
				else
					c = '?';
			} else
				/*
				 * We already incremented `custom_optind' once;
				 * increment it again when taking next ARGV-elt
				 * as argument.
				 */
				d->custom_optarg = argv[d->custom_optind++];
			d->nextchar = NULL;
		}
	}
	return c;
}

/*
 * Scan elements of ARGV for option characters given in OPTSTRING.
 *
 * If an element of ARGV starts with '-', and is not exactly "-" or "--",
 * then it is an option element.  The characters of this element
 * (aside from the initial '-') are option characters.  If `getopt'
 * is called repeatedly, it returns successively each of the option characters
 * from each of the option elements.
 *
 * If `getopt' finds another option character, it returns that character,
 * updating `custom_optind' and `nextchar' so that the next call to `getopt' can
 * resume the scan with the following option character or ARGV-element.
 *
 * If there are no more option characters, `getopt' returns -1.
 * Then `custom_optind' is the index in ARGV of the first ARGV-element
 * that is not an option.  (The ARGV-elements have been permuted
 * so that those that are not options now come last.)
 *
 * OPTSTRING is a string containing the legitimate option characters.
 * If an option character is seen that is not listed in OPTSTRING,
 * return '?' after printing an error message.  If you set `custom_opterr' to
 * zero, the error message is suppressed but we still return '?'.
 *
 * If a char in OPTSTRING is followed by a colon, that means it wants an arg,
 * so the following text in the same ARGV-element, or the text of the following
 * ARGV-element, is returned in `custom_optarg'.  Two colons mean an option that
 * wants an optional arg; if there is text in the current ARGV-element,
 * it is returned in `custom_optarg', otherwise `custom_optarg' is set to zero.
 *
 * If OPTSTRING starts with `-' or `+', it requests different methods of
 * handling the non-option ARGV-elements.
 * See the comments about RETURN_IN_ORDER and REQUIRE_ORDER, above.
 *
 * Long-named options begin with `--' instead of `-'.
 * Their names may be abbreviated as long as the abbreviation is unique
 * or is an exact match for some defined option.  If they have an
 * argument, it follows the option name in the same ARGV-element, separated
 * from the option name by a `=', or else the in next ARGV-element.
 * When `getopt' finds a long-named option, it returns 0 if that option's
 * `flag' field is nonzero, the value of the option's `val' field
 * if the `flag' field is zero.
 *
 * The elements of ARGV aren't really const, because we permute them.
 * But we pretend they're const in the prototype to be compatible
 * with other systems.
 *
 * LONGOPTS is a vector of `struct option' terminated by an
 * element containing a name which is zero.
 *
 * LONGIND returns the index in LONGOPT of the long-named option found.
 * It is only valid when a long-named option has been found by the most
 * recent call.
 *
 * Return the option character from OPTS just read.  Return -1 when there are
 * no more options.  For unrecognized options, or options missing arguments,
 * `custom_optopt' is set to the option letter, and '?' is returned.
 *
 * The OPTS string is a list of characters which are recognized option letters,
 * optionally followed by colons, specifying that that letter takes an
 * argument, to be placed in `custom_optarg'.
 *
 * If a letter in OPTS is followed by two colons, its argument is optional.
 * This behavior is specific to the GNU `getopt'.
 *
 * The argument `--' causes premature termination of argument scanning,
 * explicitly telling `getopt' that there are no more options.  If OPTS begins
 * with `--', then non-option arguments are treated as arguments to the option
 * '\0'.  This behavior is specific to the GNU `getopt'.
 */

static int getopt_internal_r(int argc, char *const *argv, const char *optstring,
		const struct option *longopts, int *longind,
		struct custom_getopt_data *d)
{
	int ret, print_errors = d->custom_opterr;

	if (optstring[0] == ':')
		print_errors = 0;
	if (argc < 1)
		return -1;
	d->custom_optarg = NULL;

	/* 
	 * This is a big difference with GNU getopt, since optind == 0
	 * means initialization while here 1 means first call.
	 */
	if (d->custom_optind == 0 || !d->initialized) {
		if (d->custom_optind == 0)
			d->custom_optind = 1;	/* Don't scan ARGV[0], the program name.  */
		custom_getopt_initialize(d);
	}
	if (d->nextchar == NULL || *d->nextchar == '\0') {
		ret = shuffle_argv(argc, argv, longopts, d);
		if (ret)
			return ret;
	}
	if (longopts && (argv[d->custom_optind][1] == '-' ))
		return check_long_opt(argc, argv, optstring, longopts,
			longind, print_errors, d);
	return check_short_opt(argc, argv, optstring, print_errors, d);
}

static int custom_getopt_internal(int argc, char *const *argv, const char *optstring,
	const struct option *longopts, int *longind)
{
	int result;
	/* Keep a global copy of all internal members of d */
	static struct custom_getopt_data d;

	d.custom_optind = custom_optind;
	d.custom_opterr = custom_opterr;
	result = getopt_internal_r(argc, argv, optstring, longopts,
		longind, &d);
	custom_optind = d.custom_optind;
	custom_optarg = d.custom_optarg;
	custom_optopt = d.custom_optopt;
	return result;
}

static int custom_getopt_long (int argc, char *const *argv, const char *options,
	const struct option *long_options, int *opt_index)
{
	return custom_getopt_internal(argc, argv, options, long_options,
		opt_index);
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see RNAsubopt_cmdline_parser_params.check_ambiguity
 * @param override @see RNAsubopt_cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               RNAsubopt_cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_LONG:
    if (val) *((long *)field) = (long)strtol (val, &stop_char, 0);
    break;
  case ARG_FLOAT:
    if (val) *((float *)field) = (float)strtod (val, &stop_char);
    break;
  case ARG_DOUBLE:
    if (val) *((double *)field) = strtod (val, &stop_char);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
  case ARG_LONG:
  case ARG_FLOAT:
  case ARG_DOUBLE:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}

/**
 * @brief store information about a multiple option in a temporary list
 * @param list where to (temporarily) store multiple options
 */
static
int update_multiple_arg_temp(struct generic_list **list,
               unsigned int *prev_given, const char *val,
               const char *possible_values[], const char *default_value,
               RNAsubopt_cmdline_parser_arg_type arg_type,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  /* store single arguments */
  char *multi_token;
  const char *multi_next;

  if (arg_type == ARG_NO) {
    (*prev_given)++;
    return 0; /* OK */
  }

  multi_token = get_multiple_arg_token(val);
  multi_next = get_multiple_arg_token_next (val);

  while (1)
    {
      add_node (list);
      if (update_arg((void *)&((*list)->arg), &((*list)->orig), 0,
          prev_given, multi_token, possible_values, default_value, 
          arg_type, 0, 1, 1, 1, long_opt, short_opt, additional_error)) {
        if (multi_token) free(multi_token);
        return 1; /* failure */
      }

      if (multi_next)
        {
          multi_token = get_multiple_arg_token(multi_next);
          multi_next = get_multiple_arg_token_next (multi_next);
        }
      else
        break;
    }

  return 0; /* OK */
}

/**
 * @brief free the passed list (including possible string argument)
 */
static
void free_list(struct generic_list *list, short string_arg)
{
  if (list) {
    struct generic_list *tmp;
    while (list)
      {
        tmp = list;
        if (string_arg && list->arg.string_arg)
          free (list->arg.string_arg);
        if (list->orig)
          free (list->orig);
        list = list->next;
        free (tmp);
      }
  }
}

/**
 * @brief updates a multiple option starting from the passed list
 */
static
void update_multiple_arg(void *field, char ***orig_field,
               unsigned int field_given, unsigned int prev_given, union generic_value *default_value,
               RNAsubopt_cmdline_parser_arg_type arg_type,
               struct generic_list *list)
{
  int i;
  struct generic_list *tmp;

  if (prev_given && list) {
    *orig_field = (char **) realloc (*orig_field, (field_given + prev_given) * sizeof (char *));

    switch(arg_type) {
    case ARG_INT:
      *((int **)field) = (int *)realloc (*((int **)field), (field_given + prev_given) * sizeof (int)); break;
    case ARG_LONG:
      *((long **)field) = (long *)realloc (*((long **)field), (field_given + prev_given) * sizeof (long)); break;
    case ARG_FLOAT:
      *((float **)field) = (float *)realloc (*((float **)field), (field_given + prev_given) * sizeof (float)); break;
    case ARG_DOUBLE:
      *((double **)field) = (double *)realloc (*((double **)field), (field_given + prev_given) * sizeof (double)); break;
    case ARG_STRING:
      *((char ***)field) = (char **)realloc (*((char ***)field), (field_given + prev_given) * sizeof (char *)); break;
    default:
      break;
    };
    
    for (i = (prev_given - 1); i >= 0; --i)
      {
        tmp = list;
        
        switch(arg_type) {
        case ARG_INT:
          (*((int **)field))[i + field_given] = tmp->arg.int_arg; break;
        case ARG_LONG:
          (*((long **)field))[i + field_given] = tmp->arg.long_arg; break;
        case ARG_FLOAT:
          (*((float **)field))[i + field_given] = tmp->arg.float_arg; break;
        case ARG_DOUBLE:
          (*((double **)field))[i + field_given] = tmp->arg.double_arg; break;
        case ARG_STRING:
          (*((char ***)field))[i + field_given] = tmp->arg.string_arg; break;
        default:
          break;
        }        
        (*orig_field) [i + field_given] = list->orig;
        list = list->next;
        free (tmp);
      }
  } else { /* set the default value */
    if (default_value && ! field_given) {
      switch(arg_type) {
      case ARG_INT:
        if (! *((int **)field)) {
          *((int **)field) = (int *)malloc (sizeof (int));
          (*((int **)field))[0] = default_value->int_arg; 
        }
        break;
      case ARG_LONG:
        if (! *((long **)field)) {
          *((long **)field) = (long *)malloc (sizeof (long));
          (*((long **)field))[0] = default_value->long_arg;
        }
        break;
      case ARG_FLOAT:
        if (! *((float **)field)) {
          *((float **)field) = (float *)malloc (sizeof (float));
          (*((float **)field))[0] = default_value->float_arg;
        }
        break;
      case ARG_DOUBLE:
        if (! *((double **)field)) {
          *((double **)field) = (double *)malloc (sizeof (double));
          (*((double **)field))[0] = default_value->double_arg;
        }
        break;
      case ARG_STRING:
        if (! *((char ***)field)) {
          *((char ***)field) = (char **)malloc (sizeof (char *));
          (*((char ***)field))[0] = gengetopt_strdup(default_value->string_arg);
        }
        break;
      default: break;
      }
      if (!(*orig_field)) {
        *orig_field = (char **) malloc (sizeof (char *));
        (*orig_field)[0] = 0;
      }
    }
  }
}

int
RNAsubopt_cmdline_parser_internal (
  int argc, char **argv, struct RNAsubopt_args_info *args_info,
                        struct RNAsubopt_cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */
  union generic_value multiple_default_value;

  struct generic_list * sp_data_list = NULL;
  struct generic_list * sp_strategy_list = NULL;
  struct generic_list * sp_preprocess_list = NULL;
  struct generic_list * mod_file_list = NULL;
  int error_occurred = 0;
  struct RNAsubopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;

  char *optarg;
  int optind;
  int opterr;
  int optopt;
  
  package_name = argv[0];
  
  /* TODO: Why is this here? It is not used anywhere. */
  override = params->override;
  FIX_UNUSED(override);

  initialize = params->initialize;
  check_required = params->check_required;

  /* TODO: Why is this here? It is not used anywhere. */
  check_ambiguity = params->check_ambiguity;
  FIX_UNUSED(check_ambiguity);

  if (initialize)
    RNAsubopt_cmdline_parser_init (args_info);

  RNAsubopt_cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "detailed-help",	0, NULL, 0 },
        { "full-help",	0, NULL, 0 },
        { "version",	0, NULL, 'V' },
        { "verbose",	0, NULL, 'v' },
        { "infile",	1, NULL, 'i' },
        { "outfile",	2, NULL, 'o' },
        { "noconv",	0, NULL, 0 },
        { "auto-id",	0, NULL, 0 },
        { "id-prefix",	1, NULL, 0 },
        { "id-delim",	1, NULL, 0 },
        { "id-digits",	1, NULL, 0 },
        { "id-start",	1, NULL, 0 },
        { "filename-delim",	1, NULL, 0 },
        { "filename-full",	0, NULL, 0 },
        { "log-level",	1, NULL, 0 },
        { "log-file",	2, NULL, 0 },
        { "log-time",	0, NULL, 0 },
        { "log-call",	0, NULL, 0 },
        { "deltaEnergy",	1, NULL, 'e' },
        { "deltaEnergyPost",	1, NULL, 0 },
        { "sorted",	0, NULL, 's' },
        { "en-only",	0, NULL, 0 },
        { "stochBT",	1, NULL, 'p' },
        { "stochBT_en",	1, NULL, 0 },
        { "random-seed",	1, NULL, 0 },
        { "betaScale",	1, NULL, 0 },
        { "nonRedundant",	0, NULL, 'N' },
        { "pfScale",	1, NULL, 'S' },
        { "circ",	0, NULL, 'c' },
        { "dos",	0, NULL, 'D' },
        { "zuker",	0, NULL, 'z' },
        { "gquad",	0, NULL, 'g' },
        { "maxBPspan",	1, NULL, 0 },
        { "constraint",	2, NULL, 'C' },
        { "batch",	0, NULL, 0 },
        { "canonicalBPonly",	0, NULL, 0 },
        { "enforceConstraint",	0, NULL, 0 },
        { "commands",	1, NULL, 0 },
        { "sp-data",	1, NULL, 0 },
        { "sp-strategy",	1, NULL, 0 },
        { "sp-preprocess",	1, NULL, 0 },
        { "shape",	1, NULL, 0 },
        { "shapeMethod",	1, NULL, 0 },
        { "shapeConversion",	1, NULL, 0 },
        { "temp",	1, NULL, 'T' },
        { "paramFile",	1, NULL, 'P' },
        { "noTetra",	0, NULL, '4' },
        { "salt",	1, NULL, 0 },
        { "modifications",	2, NULL, 'm' },
        { "mod-file",	1, NULL, 0 },
        { "dangles",	1, NULL, 'd' },
        { "noLP",	0, NULL, 0 },
        { "noGU",	0, NULL, 0 },
        { "noClosingGU",	0, NULL, 0 },
        { "logML",	0, NULL, 0 },
        { "nsp",	1, NULL, 0 },
        { "energyModel",	1, NULL, 0 },
        { "helical-rise",	1, NULL, 0 },
        { "backbone-length",	1, NULL, 0 },
        { 0,  0, 0, 0 }
      };

      custom_optarg = optarg;
      custom_optind = optind;
      custom_opterr = opterr;
      custom_optopt = optopt;

      c = custom_getopt_long (argc, argv, "hVvi:o::e:sp:NS:cDzgC::T:P:4m::d:", long_options, &option_index);

      optarg = custom_optarg;
      optind = custom_optind;
      opterr = custom_opterr;
      optopt = custom_optopt;

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          RNAsubopt_cmdline_parser_print_help ();
          RNAsubopt_cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          RNAsubopt_cmdline_parser_print_version ();
          RNAsubopt_cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'v':	/* Be verbose.
.  */
        
        
          if (update_arg((void *)&(args_info->verbose_flag), 0, &(args_info->verbose_given),
              &(local_args_info.verbose_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "verbose", 'v',
              additional_error))
            goto failure;
        
          break;
        case 'i':	/* Read a file instead of reading from stdin.
.  */
        
        
          if (update_arg( (void *)&(args_info->infile_arg), 
               &(args_info->infile_orig), &(args_info->infile_given),
              &(local_args_info.infile_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "infile", 'i',
              additional_error))
            goto failure;
        
          break;
        case 'o':	/* Print output to file instead of stdout.
.  */
        
        
          if (update_arg( (void *)&(args_info->outfile_arg), 
               &(args_info->outfile_orig), &(args_info->outfile_given),
              &(local_args_info.outfile_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "outfile", 'o',
              additional_error))
            goto failure;
        
          break;
        case 'e':	/* Compute suboptimal structures with energy in a certain range of the optimum (kcal/mol).
.  */
        
        
          if (update_arg( (void *)&(args_info->deltaEnergy_arg), 
               &(args_info->deltaEnergy_orig), &(args_info->deltaEnergy_given),
              &(local_args_info.deltaEnergy_given), optarg, 0, 0, ARG_FLOAT,
              check_ambiguity, override, 0, 0,
              "deltaEnergy", 'e',
              additional_error))
            goto failure;
        
          break;
        case 's':	/* Sort the suboptimal structures by energy and lexicographical order.
.  */
        
        
          if (update_arg((void *)&(args_info->sorted_flag), 0, &(args_info->sorted_given),
              &(local_args_info.sorted_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "sorted", 's',
              additional_error))
            goto failure;
        
          break;
        case 'p':	/* Randomly draw structures according to their probability in the Boltzmann ensemble.
.  */
        
        
          if (update_arg( (void *)&(args_info->stochBT_arg), 
               &(args_info->stochBT_orig), &(args_info->stochBT_given),
              &(local_args_info.stochBT_given), optarg, 0, 0, ARG_INT,
              check_ambiguity, override, 0, 0,
              "stochBT", 'p',
              additional_error))
            goto failure;
        
          break;
        case 'N':	/* Enable non-redundant sampling strategy.
        
.  */
        
        
          if (update_arg((void *)&(args_info->nonRedundant_flag), 0, &(args_info->nonRedundant_given),
              &(local_args_info.nonRedundant_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "nonRedundant", 'N',
              additional_error))
            goto failure;
        
          break;
        case 'S':	/* In the calculation of the pf use scale*mfe as an estimate for the ensemble free energy (used to avoid overflows).
.  */
        
        
          if (update_arg( (void *)&(args_info->pfScale_arg), 
               &(args_info->pfScale_orig), &(args_info->pfScale_given),
              &(local_args_info.pfScale_given), optarg, 0, "1.07", ARG_DOUBLE,
              check_ambiguity, override, 0, 0,
              "pfScale", 'S',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* Assume a circular (instead of linear) RNA molecule.
        
.  */
        
        
          if (update_arg((void *)&(args_info->circ_flag), 0, &(args_info->circ_given),
              &(local_args_info.circ_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "circ", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'D':	/* Compute density of states instead of secondary structures.
.  */
        
        
          if (update_arg((void *)&(args_info->dos_flag), 0, &(args_info->dos_given),
              &(local_args_info.dos_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "dos", 'D',
              additional_error))
            goto failure;
        
          break;
        case 'z':	/* Compute Zuker suboptimals instead of all suboptimal structures within an energy band around the MFE.
        
.  */
        
        
          if (update_arg((void *)&(args_info->zuker_flag), 0, &(args_info->zuker_given),
              &(local_args_info.zuker_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "zuker", 'z',
              additional_error))
            goto failure;
        
          break;
        case 'g':	/* Incoorporate G-Quadruplex formation.
.  */
        
        
          if (update_arg((void *)&(args_info->gquad_flag), 0, &(args_info->gquad_given),
              &(local_args_info.gquad_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "gquad", 'g',
              additional_error))
            goto failure;
        
          break;
        case 'C':	/* Calculate structures subject to constraints.
.  */
        
        
          if (update_arg( (void *)&(args_info->constraint_arg), 
               &(args_info->constraint_orig), &(args_info->constraint_given),
              &(local_args_info.constraint_given), optarg, 0, "", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "constraint", 'C',
              additional_error))
            goto failure;
        
          break;
        case 'T':	/* Rescale energy parameters to a temperature of temp C. Default is 37C.
        
.  */
        
        
          if (update_arg( (void *)&(args_info->temp_arg), 
               &(args_info->temp_orig), &(args_info->temp_given),
              &(local_args_info.temp_given), optarg, 0, "37.0", ARG_DOUBLE,
              check_ambiguity, override, 0, 0,
              "temp", 'T',
              additional_error))
            goto failure;
        
          break;
        case 'P':	/* Read energy parameters from paramfile, instead of using the default parameter set.
.  */
        
        
          if (update_arg( (void *)&(args_info->paramFile_arg), 
               &(args_info->paramFile_orig), &(args_info->paramFile_given),
              &(local_args_info.paramFile_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "paramFile", 'P',
              additional_error))
            goto failure;
        
          break;
        case '4':	/* Do not include special tabulated stabilizing energies for tri-, tetra- and hexaloop hairpins.
.  */
        
        
          if (update_arg((void *)&(args_info->noTetra_flag), 0, &(args_info->noTetra_given),
              &(local_args_info.noTetra_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "noTetra", '4',
              additional_error))
            goto failure;
        
          break;
        case 'm':	/* Allow for modified bases within the RNA sequence string.
.  */
        
        
          if (update_arg( (void *)&(args_info->modifications_arg), 
               &(args_info->modifications_orig), &(args_info->modifications_given),
              &(local_args_info.modifications_given), optarg, 0, "7I6P9D", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "modifications", 'm',
              additional_error))
            goto failure;
        
          break;
        case 'd':	/* How to treat \"dangling end\" energies for bases adjacent to helices in free ends and multi-loops.
.  */
        
        
          if (update_arg( (void *)&(args_info->dangles_arg), 
               &(args_info->dangles_orig), &(args_info->dangles_given),
              &(local_args_info.dangles_given), optarg, 0, "2", ARG_INT,
              check_ambiguity, override, 0, 0,
              "dangles", 'd',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          if (strcmp (long_options[option_index].name, "detailed-help") == 0) {
            RNAsubopt_cmdline_parser_print_detailed_help ();
            RNAsubopt_cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          if (strcmp (long_options[option_index].name, "full-help") == 0) {
            RNAsubopt_cmdline_parser_print_full_help ();
            RNAsubopt_cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          /* Do not automatically substitute nucleotide \"T\" with \"U\".
          
.  */
          if (strcmp (long_options[option_index].name, "noconv") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noconv_flag), 0, &(args_info->noconv_given),
                &(local_args_info.noconv_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noconv", '-',
                additional_error))
              goto failure;
          
          }
          /* Automatically generate an ID for each sequence.
.  */
          else if (strcmp (long_options[option_index].name, "auto-id") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->auto_id_flag), 0, &(args_info->auto_id_given),
                &(local_args_info.auto_id_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "auto-id", '-',
                additional_error))
              goto failure;
          
          }
          /* Prefix for automatically generated IDs (as used in output file names).
.  */
          else if (strcmp (long_options[option_index].name, "id-prefix") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->id_prefix_arg), 
                 &(args_info->id_prefix_orig), &(args_info->id_prefix_given),
                &(local_args_info.id_prefix_given), optarg, 0, "sequence", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "id-prefix", '-',
                additional_error))
              goto failure;
          
          }
          /* Change the delimiter between prefix and increasing number for automatically generated IDs (as used in output file names).
.  */
          else if (strcmp (long_options[option_index].name, "id-delim") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->id_delim_arg), 
                 &(args_info->id_delim_orig), &(args_info->id_delim_given),
                &(local_args_info.id_delim_given), optarg, 0, "_", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "id-delim", '-',
                additional_error))
              goto failure;
          
          }
          /* Specify the number of digits of the counter in automatically generated alignment IDs.
.  */
          else if (strcmp (long_options[option_index].name, "id-digits") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->id_digits_arg), 
                 &(args_info->id_digits_orig), &(args_info->id_digits_given),
                &(local_args_info.id_digits_given), optarg, 0, "4", ARG_INT,
                check_ambiguity, override, 0, 0,
                "id-digits", '-',
                additional_error))
              goto failure;
          
          }
          /* Specify the first number in automatically generated IDs.
.  */
          else if (strcmp (long_options[option_index].name, "id-start") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->id_start_arg), 
                 &(args_info->id_start_orig), &(args_info->id_start_given),
                &(local_args_info.id_start_given), optarg, 0, "1", ARG_LONG,
                check_ambiguity, override, 0, 0,
                "id-start", '-',
                additional_error))
              goto failure;
          
          }
          /* Change the delimiting character used in sanitized filenames.
.  */
          else if (strcmp (long_options[option_index].name, "filename-delim") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->filename_delim_arg), 
                 &(args_info->filename_delim_orig), &(args_info->filename_delim_given),
                &(local_args_info.filename_delim_given), optarg, 0, "ID-delimiter", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "filename-delim", '-',
                additional_error))
              goto failure;
          
          }
          /* Use full FASTA header to create filenames.
.  */
          else if (strcmp (long_options[option_index].name, "filename-full") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->filename_full_flag), 0, &(args_info->filename_full_given),
                &(local_args_info.filename_full_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "filename-full", '-',
                additional_error))
              goto failure;
          
          }
          /* Set log level threshold.
.  */
          else if (strcmp (long_options[option_index].name, "log-level") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->log_level_arg), 
                 &(args_info->log_level_orig), &(args_info->log_level_given),
                &(local_args_info.log_level_given), optarg, 0, "2", ARG_INT,
                check_ambiguity, override, 0, 0,
                "log-level", '-',
                additional_error))
              goto failure;
          
          }
          /* Print log messages to a file instead of stderr.
.  */
          else if (strcmp (long_options[option_index].name, "log-file") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->log_file_arg), 
                 &(args_info->log_file_orig), &(args_info->log_file_given),
                &(local_args_info.log_file_given), optarg, 0, "RNAsubopt.log", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "log-file", '-',
                additional_error))
              goto failure;
          
          }
          /* Include time stamp in log messages.
          
.  */
          else if (strcmp (long_options[option_index].name, "log-time") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->log_time_flag), 0, &(args_info->log_time_given),
                &(local_args_info.log_time_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "log-time", '-',
                additional_error))
              goto failure;
          
          }
          /* Include file and line of log calling function.
          
.  */
          else if (strcmp (long_options[option_index].name, "log-call") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->log_call_flag), 0, &(args_info->log_call_given),
                &(local_args_info.log_call_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "log-call", '-',
                additional_error))
              goto failure;
          
          }
          /* Only print structures with energy within range of the mfe after post reevaluation of energies.
.  */
          else if (strcmp (long_options[option_index].name, "deltaEnergyPost") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->deltaEnergyPost_arg), 
                 &(args_info->deltaEnergyPost_orig), &(args_info->deltaEnergyPost_given),
                &(local_args_info.deltaEnergyPost_given), optarg, 0, 0, ARG_FLOAT,
                check_ambiguity, override, 0, 0,
                "deltaEnergyPost", '-',
                additional_error))
              goto failure;
          
          }
          /* Only sort structures by free energy.
.  */
          else if (strcmp (long_options[option_index].name, "en-only") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->en_only_flag), 0, &(args_info->en_only_given),
                &(local_args_info.en_only_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "en-only", '-',
                additional_error))
              goto failure;
          
          }
          /* Same as \"--stochBT\" but also print free energies and probabilities of the backtraced structures.
          
.  */
          else if (strcmp (long_options[option_index].name, "stochBT_en") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->stochBT_en_arg), 
                 &(args_info->stochBT_en_orig), &(args_info->stochBT_en_given),
                &(local_args_info.stochBT_en_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "stochBT_en", '-',
                additional_error))
              goto failure;
          
          }
          /* Set the seed for the random number generator
          
.  */
          else if (strcmp (long_options[option_index].name, "random-seed") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->random_seed_arg), 
                 &(args_info->random_seed_orig), &(args_info->random_seed_given),
                &(local_args_info.random_seed_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "random-seed", '-',
                additional_error))
              goto failure;
          
          }
          /* Set the scaling of the Boltzmann factors.
.  */
          else if (strcmp (long_options[option_index].name, "betaScale") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->betaScale_arg), 
                 &(args_info->betaScale_orig), &(args_info->betaScale_given),
                &(local_args_info.betaScale_given), optarg, 0, "1.", ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "betaScale", '-',
                additional_error))
              goto failure;
          
          }
          /* Set the maximum base pair span.
          
.  */
          else if (strcmp (long_options[option_index].name, "maxBPspan") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->maxBPspan_arg), 
                 &(args_info->maxBPspan_orig), &(args_info->maxBPspan_given),
                &(local_args_info.maxBPspan_given), optarg, 0, "-1", ARG_INT,
                check_ambiguity, override, 0, 0,
                "maxBPspan", '-',
                additional_error))
              goto failure;
          
          }
          /* Use constraints for multiple sequences.
.  */
          else if (strcmp (long_options[option_index].name, "batch") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->batch_flag), 0, &(args_info->batch_given),
                &(local_args_info.batch_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "batch", '-',
                additional_error))
              goto failure;
          
          }
          /* Remove non-canonical base pairs from the structure constraint.
          
.  */
          else if (strcmp (long_options[option_index].name, "canonicalBPonly") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->canonicalBPonly_flag), 0, &(args_info->canonicalBPonly_given),
                &(local_args_info.canonicalBPonly_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "canonicalBPonly", '-',
                additional_error))
              goto failure;
          
          }
          /* Enforce base pairs given by round brackets '(' ')' in structure constraint.
          
.  */
          else if (strcmp (long_options[option_index].name, "enforceConstraint") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->enforceConstraint_flag), 0, &(args_info->enforceConstraint_given),
                &(local_args_info.enforceConstraint_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "enforceConstraint", '-',
                additional_error))
              goto failure;
          
          }
          /* Read additional commands from file
.  */
          else if (strcmp (long_options[option_index].name, "commands") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->commands_arg), 
                 &(args_info->commands_orig), &(args_info->commands_given),
                &(local_args_info.commands_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "commands", '-',
                additional_error))
              goto failure;
          
          }
          /* Read structure probing data from an input file and guide the predictions accordingly. Must precede the strategy, i.e. a data file must be specified before the corresponding --sp-strategy option!
          
.  */
          else if (strcmp (long_options[option_index].name, "sp-data") == 0)
          {
          
            if (update_multiple_arg_temp(&sp_data_list, 
                &(local_args_info.sp_data_given), optarg, 0, 0, ARG_STRING,
                "sp-data", '-',
                additional_error))
              goto failure;
          
          }
          /* Select the strategy how the probing data is used to guide the structure predictions.
          
.  */
          else if (strcmp (long_options[option_index].name, "sp-strategy") == 0)
          {
          
            if (update_multiple_arg_temp(&sp_strategy_list, 
                &(local_args_info.sp_strategy_given), optarg, 0, "D", ARG_STRING,
                "sp-strategy", '-',
                additional_error))
              goto failure;
          
          }
          /* Select a method to pre-process the structure probing data before it undergoes conversion by a strategy.
          
.  */
          else if (strcmp (long_options[option_index].name, "sp-preprocess") == 0)
          {
          
            if (update_multiple_arg_temp(&sp_preprocess_list, 
                &(local_args_info.sp_preprocess_given), optarg, 0, "I", ARG_STRING,
                "sp-preprocess", '-',
                additional_error))
              goto failure;
          
          }
          /* Use SHAPE reactivity data to guide structure predictions.
          
.  */
          else if (strcmp (long_options[option_index].name, "shape") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->shape_arg), 
                 &(args_info->shape_orig), &(args_info->shape_given),
                &(local_args_info.shape_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "shape", '-',
                additional_error))
              goto failure;
          
          }
          /* Select SHAPE reactivity data incorporation strategy.
          
.  */
          else if (strcmp (long_options[option_index].name, "shapeMethod") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->shapeMethod_arg), 
                 &(args_info->shapeMethod_orig), &(args_info->shapeMethod_given),
                &(local_args_info.shapeMethod_given), optarg, 0, "D", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "shapeMethod", '-',
                additional_error))
              goto failure;
          
          }
          /* Select method for SHAPE reactivity conversion.
          
.  */
          else if (strcmp (long_options[option_index].name, "shapeConversion") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->shapeConversion_arg), 
                 &(args_info->shapeConversion_orig), &(args_info->shapeConversion_given),
                &(local_args_info.shapeConversion_given), optarg, 0, "O", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "shapeConversion", '-',
                additional_error))
              goto failure;
          
          }
          /* Set salt concentration in molar (M). Default is 1.021M.
          
.  */
          else if (strcmp (long_options[option_index].name, "salt") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->salt_arg), 
                 &(args_info->salt_orig), &(args_info->salt_given),
                &(local_args_info.salt_given), optarg, 0, 0, ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "salt", '-',
                additional_error))
              goto failure;
          
          }
          /* Use additional modified base data from JSON file.
          
.  */
          else if (strcmp (long_options[option_index].name, "mod-file") == 0)
          {
          
            if (update_multiple_arg_temp(&mod_file_list, 
                &(local_args_info.mod_file_given), optarg, 0, 0, ARG_STRING,
                "mod-file", '-',
                additional_error))
              goto failure;
          
          }
          /* Produce structures without lonely pairs (helices of length 1).
.  */
          else if (strcmp (long_options[option_index].name, "noLP") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noLP_flag), 0, &(args_info->noLP_given),
                &(local_args_info.noLP_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noLP", '-',
                additional_error))
              goto failure;
          
          }
          /* Do not allow GU pairs.
          
.  */
          else if (strcmp (long_options[option_index].name, "noGU") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noGU_flag), 0, &(args_info->noGU_given),
                &(local_args_info.noGU_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noGU", '-',
                additional_error))
              goto failure;
          
          }
          /* Do not allow GU pairs at the end of helices.
          
.  */
          else if (strcmp (long_options[option_index].name, "noClosingGU") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->noClosingGU_flag), 0, &(args_info->noClosingGU_given),
                &(local_args_info.noClosingGU_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "noClosingGU", '-',
                additional_error))
              goto failure;
          
          }
          /* Recompute energies of structures using a logarithmic energy function for multi-loops before output..  */
          else if (strcmp (long_options[option_index].name, "logML") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->logML_flag), 0, &(args_info->logML_given),
                &(local_args_info.logML_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "logML", '-',
                additional_error))
              goto failure;
          
          }
          /* Allow other pairs in addition to the usual AU,GC,and GU pairs.
.  */
          else if (strcmp (long_options[option_index].name, "nsp") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->nsp_arg), 
                 &(args_info->nsp_orig), &(args_info->nsp_given),
                &(local_args_info.nsp_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "nsp", '-',
                additional_error))
              goto failure;
          
          }
          /* Set energy model.
.  */
          else if (strcmp (long_options[option_index].name, "energyModel") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->energyModel_arg), 
                 &(args_info->energyModel_orig), &(args_info->energyModel_given),
                &(local_args_info.energyModel_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "energyModel", '-',
                additional_error))
              goto failure;
          
          }
          /* Set the helical rise of the helix in units of Angstrom.
.  */
          else if (strcmp (long_options[option_index].name, "helical-rise") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->helical_rise_arg), 
                 &(args_info->helical_rise_orig), &(args_info->helical_rise_given),
                &(local_args_info.helical_rise_given), optarg, 0, "2.8", ARG_FLOAT,
                check_ambiguity, override, 0, 0,
                "helical-rise", '-',
                additional_error))
              goto failure;
          
          }
          /* Set the average backbone length for looped regions in units of Angstrom.
.  */
          else if (strcmp (long_options[option_index].name, "backbone-length") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->backbone_length_arg), 
                 &(args_info->backbone_length_orig), &(args_info->backbone_length_given),
                &(local_args_info.backbone_length_given), optarg, 0, "6.0", ARG_FLOAT,
                check_ambiguity, override, 0, 0,
                "backbone-length", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", RNASUBOPT_CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */


  update_multiple_arg((void *)&(args_info->sp_data_arg),
    &(args_info->sp_data_orig), args_info->sp_data_given,
    local_args_info.sp_data_given, 0,
    ARG_STRING, sp_data_list);
  multiple_default_value.default_string_arg = "D";
  update_multiple_arg((void *)&(args_info->sp_strategy_arg),
    &(args_info->sp_strategy_orig), args_info->sp_strategy_given,
    local_args_info.sp_strategy_given, &multiple_default_value,
    ARG_STRING, sp_strategy_list);
  multiple_default_value.default_string_arg = "I";
  update_multiple_arg((void *)&(args_info->sp_preprocess_arg),
    &(args_info->sp_preprocess_orig), args_info->sp_preprocess_given,
    local_args_info.sp_preprocess_given, &multiple_default_value,
    ARG_STRING, sp_preprocess_list);
  update_multiple_arg((void *)&(args_info->mod_file_arg),
    &(args_info->mod_file_orig), args_info->mod_file_given,
    local_args_info.mod_file_given, 0,
    ARG_STRING, mod_file_list);

  args_info->sp_data_given += local_args_info.sp_data_given;
  local_args_info.sp_data_given = 0;
  args_info->sp_strategy_given += local_args_info.sp_strategy_given;
  local_args_info.sp_strategy_given = 0;
  args_info->sp_preprocess_given += local_args_info.sp_preprocess_given;
  local_args_info.sp_preprocess_given = 0;
  args_info->mod_file_given += local_args_info.mod_file_given;
  local_args_info.mod_file_given = 0;
  
  if (check_required)
    {
      error_occurred += RNAsubopt_cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  RNAsubopt_cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  return 0;

failure:
  free_list (sp_data_list, 1 );
  free_list (sp_strategy_list, 1 );
  free_list (sp_preprocess_list, 1 );
  free_list (mod_file_list, 1 );
  
  RNAsubopt_cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
/* vim: set ft=c noet ts=8 sts=8 sw=8 tw=80 nojs spell : */
