// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// capture_gles_2_0_autogen.cpp:
//   Capture functions for the OpenGL ES 2.0 entry points.

#include "libANGLE/capture/capture_gles_2_0_autogen.h"

#include "common/gl_enum_utils.h"
#include "libANGLE/Context.h"
#include "libANGLE/capture/FrameCapture.h"
#include "libANGLE/validationES2.h"

using namespace angle;

namespace gl
{
CallCapture CaptureActiveTexture(const State &glState, bool isCallValid, GLenum texture)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("texture", GLESEnum::TextureUnit, ParamType::TGLenum, texture);

    return CallCapture(angle::EntryPoint::GLActiveTexture, std::move(paramBuffer));
}

CallCapture CaptureAttachShader(const State &glState,
                                bool isCallValid,
                                ShaderProgramID programPacked,
                                ShaderProgramID shaderPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("shaderPacked", ParamType::TShaderProgramID, shaderPacked);

    return CallCapture(angle::EntryPoint::GLAttachShader, std::move(paramBuffer));
}

CallCapture CaptureBindAttribLocation(const State &glState,
                                      bool isCallValid,
                                      ShaderProgramID programPacked,
                                      GLuint index,
                                      const GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureBindAttribLocation_name(glState, programPacked, index, name, &nameParam);
    }
    else
    {
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
    }
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture(angle::EntryPoint::GLBindAttribLocation, std::move(paramBuffer));
}

CallCapture CaptureBindBuffer(const State &glState,
                              bool isCallValid,
                              BufferBinding targetPacked,
                              BufferID bufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);

    return CallCapture(angle::EntryPoint::GLBindBuffer, std::move(paramBuffer));
}

CallCapture CaptureBindFramebuffer(const State &glState,
                                   bool isCallValid,
                                   GLenum target,
                                   FramebufferID framebufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);

    return CallCapture(angle::EntryPoint::GLBindFramebuffer, std::move(paramBuffer));
}

CallCapture CaptureBindRenderbuffer(const State &glState,
                                    bool isCallValid,
                                    GLenum target,
                                    RenderbufferID renderbufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::RenderbufferTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("renderbufferPacked", ParamType::TRenderbufferID, renderbufferPacked);

    return CallCapture(angle::EntryPoint::GLBindRenderbuffer, std::move(paramBuffer));
}

CallCapture CaptureBindTexture(const State &glState,
                               bool isCallValid,
                               TextureType targetPacked,
                               TextureID texturePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);

    return CallCapture(angle::EntryPoint::GLBindTexture, std::move(paramBuffer));
}

CallCapture CaptureBlendColor(const State &glState,
                              bool isCallValid,
                              GLfloat red,
                              GLfloat green,
                              GLfloat blue,
                              GLfloat alpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLfloat, red);
    paramBuffer.addValueParam("green", ParamType::TGLfloat, green);
    paramBuffer.addValueParam("blue", ParamType::TGLfloat, blue);
    paramBuffer.addValueParam("alpha", ParamType::TGLfloat, alpha);

    return CallCapture(angle::EntryPoint::GLBlendColor, std::move(paramBuffer));
}

CallCapture CaptureBlendEquation(const State &glState, bool isCallValid, GLenum mode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("mode", GLESEnum::BlendEquationModeEXT, ParamType::TGLenum, mode);

    return CallCapture(angle::EntryPoint::GLBlendEquation, std::move(paramBuffer));
}

CallCapture CaptureBlendEquationSeparate(const State &glState,
                                         bool isCallValid,
                                         GLenum modeRGB,
                                         GLenum modeAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("modeRGB", GLESEnum::BlendEquationModeEXT, ParamType::TGLenum,
                             modeRGB);
    paramBuffer.addEnumParam("modeAlpha", GLESEnum::BlendEquationModeEXT, ParamType::TGLenum,
                             modeAlpha);

    return CallCapture(angle::EntryPoint::GLBlendEquationSeparate, std::move(paramBuffer));
}

CallCapture CaptureBlendFunc(const State &glState, bool isCallValid, GLenum sfactor, GLenum dfactor)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("sfactor", GLESEnum::BlendingFactor, ParamType::TGLenum, sfactor);
    paramBuffer.addEnumParam("dfactor", GLESEnum::BlendingFactor, ParamType::TGLenum, dfactor);

    return CallCapture(angle::EntryPoint::GLBlendFunc, std::move(paramBuffer));
}

CallCapture CaptureBlendFuncSeparate(const State &glState,
                                     bool isCallValid,
                                     GLenum sfactorRGB,
                                     GLenum dfactorRGB,
                                     GLenum sfactorAlpha,
                                     GLenum dfactorAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("sfactorRGB", GLESEnum::BlendingFactor, ParamType::TGLenum,
                             sfactorRGB);
    paramBuffer.addEnumParam("dfactorRGB", GLESEnum::BlendingFactor, ParamType::TGLenum,
                             dfactorRGB);
    paramBuffer.addEnumParam("sfactorAlpha", GLESEnum::BlendingFactor, ParamType::TGLenum,
                             sfactorAlpha);
    paramBuffer.addEnumParam("dfactorAlpha", GLESEnum::BlendingFactor, ParamType::TGLenum,
                             dfactorAlpha);

    return CallCapture(angle::EntryPoint::GLBlendFuncSeparate, std::move(paramBuffer));
}

CallCapture CaptureBufferData(const State &glState,
                              bool isCallValid,
                              BufferBinding targetPacked,
                              GLsizeiptr size,
                              const void *data,
                              BufferUsage usagePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    ParamCapture dataParam("data", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureBufferData_data(glState, targetPacked, size, data, usagePacked, &dataParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
    }
    paramBuffer.addParam(std::move(dataParam));

    paramBuffer.addValueParam("usagePacked", ParamType::TBufferUsage, usagePacked);

    return CallCapture(angle::EntryPoint::GLBufferData, std::move(paramBuffer));
}

CallCapture CaptureBufferSubData(const State &glState,
                                 bool isCallValid,
                                 BufferBinding targetPacked,
                                 GLintptr offset,
                                 GLsizeiptr size,
                                 const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    ParamCapture dataParam("data", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureBufferSubData_data(glState, targetPacked, offset, size, data, &dataParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
    }
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(angle::EntryPoint::GLBufferSubData, std::move(paramBuffer));
}

CallCapture CaptureCheckFramebufferStatus(const State &glState,
                                          bool isCallValid,
                                          GLenum target,
                                          GLenum returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::FramebufferTarget, ParamType::TGLenum, target);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLenum);
    InitParamValue(ParamType::TGLenum, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLCheckFramebufferStatus, std::move(paramBuffer));
}

CallCapture CaptureClear(const State &glState, bool isCallValid, GLbitfield mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("mask", GLESEnum::ClearBufferMask, ParamType::TGLbitfield, mask);

    return CallCapture(angle::EntryPoint::GLClear, std::move(paramBuffer));
}

CallCapture CaptureClearColor(const State &glState,
                              bool isCallValid,
                              GLfloat red,
                              GLfloat green,
                              GLfloat blue,
                              GLfloat alpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLfloat, red);
    paramBuffer.addValueParam("green", ParamType::TGLfloat, green);
    paramBuffer.addValueParam("blue", ParamType::TGLfloat, blue);
    paramBuffer.addValueParam("alpha", ParamType::TGLfloat, alpha);

    return CallCapture(angle::EntryPoint::GLClearColor, std::move(paramBuffer));
}

CallCapture CaptureClearDepthf(const State &glState, bool isCallValid, GLfloat d)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("d", ParamType::TGLfloat, d);

    return CallCapture(angle::EntryPoint::GLClearDepthf, std::move(paramBuffer));
}

CallCapture CaptureClearStencil(const State &glState, bool isCallValid, GLint s)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("s", ParamType::TGLint, s);

    return CallCapture(angle::EntryPoint::GLClearStencil, std::move(paramBuffer));
}

CallCapture CaptureColorMask(const State &glState,
                             bool isCallValid,
                             GLboolean red,
                             GLboolean green,
                             GLboolean blue,
                             GLboolean alpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("red", ParamType::TGLboolean, red);
    paramBuffer.addValueParam("green", ParamType::TGLboolean, green);
    paramBuffer.addValueParam("blue", ParamType::TGLboolean, blue);
    paramBuffer.addValueParam("alpha", ParamType::TGLboolean, alpha);

    return CallCapture(angle::EntryPoint::GLColorMask, std::move(paramBuffer));
}

CallCapture CaptureCompileShader(const State &glState,
                                 bool isCallValid,
                                 ShaderProgramID shaderPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shaderPacked", ParamType::TShaderProgramID, shaderPacked);

    return CallCapture(angle::EntryPoint::GLCompileShader, std::move(paramBuffer));
}

CallCapture CaptureCompressedTexImage2D(const State &glState,
                                        bool isCallValid,
                                        TextureTarget targetPacked,
                                        GLint level,
                                        GLenum internalformat,
                                        GLsizei width,
                                        GLsizei height,
                                        GLint border,
                                        GLsizei imageSize,
                                        const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("internalformat", GLESEnum::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);

    ParamCapture dataParam("data", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureCompressedTexImage2D_data(glState, targetPacked, level, internalformat, width,
                                         height, border, imageSize, data, &dataParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
    }
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(angle::EntryPoint::GLCompressedTexImage2D, std::move(paramBuffer));
}

CallCapture CaptureCompressedTexSubImage2D(const State &glState,
                                           bool isCallValid,
                                           TextureTarget targetPacked,
                                           GLint level,
                                           GLint xoffset,
                                           GLint yoffset,
                                           GLsizei width,
                                           GLsizei height,
                                           GLenum format,
                                           GLsizei imageSize,
                                           const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", GLESEnum::InternalFormat, ParamType::TGLenum, format);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);

    ParamCapture dataParam("data", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureCompressedTexSubImage2D_data(glState, targetPacked, level, xoffset, yoffset, width,
                                            height, format, imageSize, data, &dataParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
    }
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(angle::EntryPoint::GLCompressedTexSubImage2D, std::move(paramBuffer));
}

CallCapture CaptureCopyTexImage2D(const State &glState,
                                  bool isCallValid,
                                  TextureTarget targetPacked,
                                  GLint level,
                                  GLenum internalformat,
                                  GLint x,
                                  GLint y,
                                  GLsizei width,
                                  GLsizei height,
                                  GLint border)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("internalformat", GLESEnum::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);

    return CallCapture(angle::EntryPoint::GLCopyTexImage2D, std::move(paramBuffer));
}

CallCapture CaptureCopyTexSubImage2D(const State &glState,
                                     bool isCallValid,
                                     TextureTarget targetPacked,
                                     GLint level,
                                     GLint xoffset,
                                     GLint yoffset,
                                     GLint x,
                                     GLint y,
                                     GLsizei width,
                                     GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(angle::EntryPoint::GLCopyTexSubImage2D, std::move(paramBuffer));
}

CallCapture CaptureCreateProgram(const State &glState, bool isCallValid, GLuint returnValue)
{
    ParamBuffer paramBuffer;

    ParamCapture returnValueCapture("returnValue", ParamType::TGLuint);
    InitParamValue(ParamType::TGLuint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLCreateProgram, std::move(paramBuffer));
}

CallCapture CaptureCreateShader(const State &glState,
                                bool isCallValid,
                                ShaderType typePacked,
                                GLuint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("typePacked", ParamType::TShaderType, typePacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLuint);
    InitParamValue(ParamType::TGLuint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLCreateShader, std::move(paramBuffer));
}

CallCapture CaptureCullFace(const State &glState, bool isCallValid, CullFaceMode modePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TCullFaceMode, modePacked);

    return CallCapture(angle::EntryPoint::GLCullFace, std::move(paramBuffer));
}

CallCapture CaptureDeleteBuffers(const State &glState,
                                 bool isCallValid,
                                 GLsizei n,
                                 const BufferID *buffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture buffersPackedParam("buffersPacked", ParamType::TBufferIDConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TBufferIDConstPointer, buffersPacked, &buffersPackedParam.value);
        CaptureDeleteBuffers_buffersPacked(glState, n, buffersPacked, &buffersPackedParam);
    }
    else
    {
        InitParamValue(ParamType::TBufferIDConstPointer, static_cast<const BufferID *>(nullptr),
                       &buffersPackedParam.value);
    }
    paramBuffer.addParam(std::move(buffersPackedParam));

    return CallCapture(angle::EntryPoint::GLDeleteBuffers, std::move(paramBuffer));
}

CallCapture CaptureDeleteFramebuffers(const State &glState,
                                      bool isCallValid,
                                      GLsizei n,
                                      const FramebufferID *framebuffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture framebuffersPackedParam("framebuffersPacked",
                                         ParamType::TFramebufferIDConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TFramebufferIDConstPointer, framebuffersPacked,
                       &framebuffersPackedParam.value);
        CaptureDeleteFramebuffers_framebuffersPacked(glState, n, framebuffersPacked,
                                                     &framebuffersPackedParam);
    }
    else
    {
        InitParamValue(ParamType::TFramebufferIDConstPointer,
                       static_cast<const FramebufferID *>(nullptr), &framebuffersPackedParam.value);
    }
    paramBuffer.addParam(std::move(framebuffersPackedParam));

    return CallCapture(angle::EntryPoint::GLDeleteFramebuffers, std::move(paramBuffer));
}

CallCapture CaptureDeleteProgram(const State &glState,
                                 bool isCallValid,
                                 ShaderProgramID programPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    return CallCapture(angle::EntryPoint::GLDeleteProgram, std::move(paramBuffer));
}

CallCapture CaptureDeleteRenderbuffers(const State &glState,
                                       bool isCallValid,
                                       GLsizei n,
                                       const RenderbufferID *renderbuffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture renderbuffersPackedParam("renderbuffersPacked",
                                          ParamType::TRenderbufferIDConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TRenderbufferIDConstPointer, renderbuffersPacked,
                       &renderbuffersPackedParam.value);
        CaptureDeleteRenderbuffers_renderbuffersPacked(glState, n, renderbuffersPacked,
                                                       &renderbuffersPackedParam);
    }
    else
    {
        InitParamValue(ParamType::TRenderbufferIDConstPointer,
                       static_cast<const RenderbufferID *>(nullptr),
                       &renderbuffersPackedParam.value);
    }
    paramBuffer.addParam(std::move(renderbuffersPackedParam));

    return CallCapture(angle::EntryPoint::GLDeleteRenderbuffers, std::move(paramBuffer));
}

CallCapture CaptureDeleteShader(const State &glState,
                                bool isCallValid,
                                ShaderProgramID shaderPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shaderPacked", ParamType::TShaderProgramID, shaderPacked);

    return CallCapture(angle::EntryPoint::GLDeleteShader, std::move(paramBuffer));
}

CallCapture CaptureDeleteTextures(const State &glState,
                                  bool isCallValid,
                                  GLsizei n,
                                  const TextureID *texturesPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture texturesPackedParam("texturesPacked", ParamType::TTextureIDConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TTextureIDConstPointer, texturesPacked,
                       &texturesPackedParam.value);
        CaptureDeleteTextures_texturesPacked(glState, n, texturesPacked, &texturesPackedParam);
    }
    else
    {
        InitParamValue(ParamType::TTextureIDConstPointer, static_cast<const TextureID *>(nullptr),
                       &texturesPackedParam.value);
    }
    paramBuffer.addParam(std::move(texturesPackedParam));

    return CallCapture(angle::EntryPoint::GLDeleteTextures, std::move(paramBuffer));
}

CallCapture CaptureDepthFunc(const State &glState, bool isCallValid, GLenum func)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("func", GLESEnum::DepthFunction, ParamType::TGLenum, func);

    return CallCapture(angle::EntryPoint::GLDepthFunc, std::move(paramBuffer));
}

CallCapture CaptureDepthMask(const State &glState, bool isCallValid, GLboolean flag)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("flag", ParamType::TGLboolean, flag);

    return CallCapture(angle::EntryPoint::GLDepthMask, std::move(paramBuffer));
}

CallCapture CaptureDepthRangef(const State &glState, bool isCallValid, GLfloat n, GLfloat f)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLfloat, n);
    paramBuffer.addValueParam("f", ParamType::TGLfloat, f);

    return CallCapture(angle::EntryPoint::GLDepthRangef, std::move(paramBuffer));
}

CallCapture CaptureDetachShader(const State &glState,
                                bool isCallValid,
                                ShaderProgramID programPacked,
                                ShaderProgramID shaderPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("shaderPacked", ParamType::TShaderProgramID, shaderPacked);

    return CallCapture(angle::EntryPoint::GLDetachShader, std::move(paramBuffer));
}

CallCapture CaptureDisable(const State &glState, bool isCallValid, GLenum cap)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("cap", GLESEnum::EnableCap, ParamType::TGLenum, cap);

    return CallCapture(angle::EntryPoint::GLDisable, std::move(paramBuffer));
}

CallCapture CaptureDisableVertexAttribArray(const State &glState, bool isCallValid, GLuint index)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    return CallCapture(angle::EntryPoint::GLDisableVertexAttribArray, std::move(paramBuffer));
}

CallCapture CaptureDrawArrays(const State &glState,
                              bool isCallValid,
                              PrimitiveMode modePacked,
                              GLint first,
                              GLsizei count)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("first", ParamType::TGLint, first);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    return CallCapture(angle::EntryPoint::GLDrawArrays, std::move(paramBuffer));
}

CallCapture CaptureDrawElements(const State &glState,
                                bool isCallValid,
                                PrimitiveMode modePacked,
                                GLsizei count,
                                DrawElementsType typePacked,
                                const void *indices)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawElements_indices(glState, modePacked, count, typePacked, indices, &indicesParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
    }
    paramBuffer.addParam(std::move(indicesParam));

    return CallCapture(angle::EntryPoint::GLDrawElements, std::move(paramBuffer));
}

CallCapture CaptureEnable(const State &glState, bool isCallValid, GLenum cap)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("cap", GLESEnum::EnableCap, ParamType::TGLenum, cap);

    return CallCapture(angle::EntryPoint::GLEnable, std::move(paramBuffer));
}

CallCapture CaptureEnableVertexAttribArray(const State &glState, bool isCallValid, GLuint index)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    return CallCapture(angle::EntryPoint::GLEnableVertexAttribArray, std::move(paramBuffer));
}

CallCapture CaptureFinish(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLFinish, std::move(paramBuffer));
}

CallCapture CaptureFlush(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLFlush, std::move(paramBuffer));
}

CallCapture CaptureFramebufferRenderbuffer(const State &glState,
                                           bool isCallValid,
                                           GLenum target,
                                           GLenum attachment,
                                           GLenum renderbuffertarget,
                                           RenderbufferID renderbufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLESEnum::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addEnumParam("renderbuffertarget", GLESEnum::RenderbufferTarget, ParamType::TGLenum,
                             renderbuffertarget);
    paramBuffer.addValueParam("renderbufferPacked", ParamType::TRenderbufferID, renderbufferPacked);

    return CallCapture(angle::EntryPoint::GLFramebufferRenderbuffer, std::move(paramBuffer));
}

CallCapture CaptureFramebufferTexture2D(const State &glState,
                                        bool isCallValid,
                                        GLenum target,
                                        GLenum attachment,
                                        TextureTarget textargetPacked,
                                        TextureID texturePacked,
                                        GLint level)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLESEnum::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addValueParam("textargetPacked", ParamType::TTextureTarget, textargetPacked);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);

    return CallCapture(angle::EntryPoint::GLFramebufferTexture2D, std::move(paramBuffer));
}

CallCapture CaptureFrontFace(const State &glState, bool isCallValid, GLenum mode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("mode", GLESEnum::FrontFaceDirection, ParamType::TGLenum, mode);

    return CallCapture(angle::EntryPoint::GLFrontFace, std::move(paramBuffer));
}

CallCapture CaptureGenBuffers(const State &glState,
                              bool isCallValid,
                              GLsizei n,
                              BufferID *buffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture buffersPackedParam("buffersPacked", ParamType::TBufferIDPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TBufferIDPointer, buffersPacked, &buffersPackedParam.value);
        CaptureGenBuffers_buffersPacked(glState, n, buffersPacked, &buffersPackedParam);
    }
    else
    {
        InitParamValue(ParamType::TBufferIDPointer, static_cast<BufferID *>(nullptr),
                       &buffersPackedParam.value);
    }
    paramBuffer.addParam(std::move(buffersPackedParam));

    return CallCapture(angle::EntryPoint::GLGenBuffers, std::move(paramBuffer));
}

CallCapture CaptureGenFramebuffers(const State &glState,
                                   bool isCallValid,
                                   GLsizei n,
                                   FramebufferID *framebuffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture framebuffersPackedParam("framebuffersPacked", ParamType::TFramebufferIDPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TFramebufferIDPointer, framebuffersPacked,
                       &framebuffersPackedParam.value);
        CaptureGenFramebuffers_framebuffersPacked(glState, n, framebuffersPacked,
                                                  &framebuffersPackedParam);
    }
    else
    {
        InitParamValue(ParamType::TFramebufferIDPointer, static_cast<FramebufferID *>(nullptr),
                       &framebuffersPackedParam.value);
    }
    paramBuffer.addParam(std::move(framebuffersPackedParam));

    return CallCapture(angle::EntryPoint::GLGenFramebuffers, std::move(paramBuffer));
}

CallCapture CaptureGenRenderbuffers(const State &glState,
                                    bool isCallValid,
                                    GLsizei n,
                                    RenderbufferID *renderbuffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture renderbuffersPackedParam("renderbuffersPacked", ParamType::TRenderbufferIDPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TRenderbufferIDPointer, renderbuffersPacked,
                       &renderbuffersPackedParam.value);
        CaptureGenRenderbuffers_renderbuffersPacked(glState, n, renderbuffersPacked,
                                                    &renderbuffersPackedParam);
    }
    else
    {
        InitParamValue(ParamType::TRenderbufferIDPointer, static_cast<RenderbufferID *>(nullptr),
                       &renderbuffersPackedParam.value);
    }
    paramBuffer.addParam(std::move(renderbuffersPackedParam));

    return CallCapture(angle::EntryPoint::GLGenRenderbuffers, std::move(paramBuffer));
}

CallCapture CaptureGenTextures(const State &glState,
                               bool isCallValid,
                               GLsizei n,
                               TextureID *texturesPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture texturesPackedParam("texturesPacked", ParamType::TTextureIDPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TTextureIDPointer, texturesPacked, &texturesPackedParam.value);
        CaptureGenTextures_texturesPacked(glState, n, texturesPacked, &texturesPackedParam);
    }
    else
    {
        InitParamValue(ParamType::TTextureIDPointer, static_cast<TextureID *>(nullptr),
                       &texturesPackedParam.value);
    }
    paramBuffer.addParam(std::move(texturesPackedParam));

    return CallCapture(angle::EntryPoint::GLGenTextures, std::move(paramBuffer));
}

CallCapture CaptureGenerateMipmap(const State &glState, bool isCallValid, TextureType targetPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);

    return CallCapture(angle::EntryPoint::GLGenerateMipmap, std::move(paramBuffer));
}

CallCapture CaptureGetActiveAttrib(const State &glState,
                                   bool isCallValid,
                                   ShaderProgramID programPacked,
                                   GLuint index,
                                   GLsizei bufSize,
                                   GLsizei *length,
                                   GLint *size,
                                   GLenum *type,
                                   GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetActiveAttrib_length(glState, programPacked, index, bufSize, length, size, type,
                                      name, &lengthParam);
    }
    else
    {
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
    }
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture sizeParam("size", ParamType::TGLintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintPointer, size, &sizeParam.value);
        CaptureGetActiveAttrib_size(glState, programPacked, index, bufSize, length, size, type,
                                    name, &sizeParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &sizeParam.value);
    }
    paramBuffer.addParam(std::move(sizeParam));

    ParamCapture typeParam("type", ParamType::TGLenumPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLenumPointer, type, &typeParam.value);
        CaptureGetActiveAttrib_type(glState, programPacked, index, bufSize, length, size, type,
                                    name, &typeParam);
    }
    else
    {
        InitParamValue(ParamType::TGLenumPointer, static_cast<GLenum *>(nullptr), &typeParam.value);
    }
    paramBuffer.addParam(std::move(typeParam));

    ParamCapture nameParam("name", ParamType::TGLcharPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLcharPointer, name, &nameParam.value);
        CaptureGetActiveAttrib_name(glState, programPacked, index, bufSize, length, size, type,
                                    name, &nameParam);
    }
    else
    {
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr), &nameParam.value);
    }
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture(angle::EntryPoint::GLGetActiveAttrib, std::move(paramBuffer));
}

CallCapture CaptureGetActiveUniform(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    GLuint index,
                                    GLsizei bufSize,
                                    GLsizei *length,
                                    GLint *size,
                                    GLenum *type,
                                    GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetActiveUniform_length(glState, programPacked, index, bufSize, length, size, type,
                                       name, &lengthParam);
    }
    else
    {
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
    }
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture sizeParam("size", ParamType::TGLintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintPointer, size, &sizeParam.value);
        CaptureGetActiveUniform_size(glState, programPacked, index, bufSize, length, size, type,
                                     name, &sizeParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &sizeParam.value);
    }
    paramBuffer.addParam(std::move(sizeParam));

    ParamCapture typeParam("type", ParamType::TGLenumPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLenumPointer, type, &typeParam.value);
        CaptureGetActiveUniform_type(glState, programPacked, index, bufSize, length, size, type,
                                     name, &typeParam);
    }
    else
    {
        InitParamValue(ParamType::TGLenumPointer, static_cast<GLenum *>(nullptr), &typeParam.value);
    }
    paramBuffer.addParam(std::move(typeParam));

    ParamCapture nameParam("name", ParamType::TGLcharPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLcharPointer, name, &nameParam.value);
        CaptureGetActiveUniform_name(glState, programPacked, index, bufSize, length, size, type,
                                     name, &nameParam);
    }
    else
    {
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr), &nameParam.value);
    }
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture(angle::EntryPoint::GLGetActiveUniform, std::move(paramBuffer));
}

CallCapture CaptureGetAttachedShaders(const State &glState,
                                      bool isCallValid,
                                      ShaderProgramID programPacked,
                                      GLsizei maxCount,
                                      GLsizei *count,
                                      ShaderProgramID *shadersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("maxCount", ParamType::TGLsizei, maxCount);

    ParamCapture countParam("count", ParamType::TGLsizeiPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLsizeiPointer, count, &countParam.value);
        CaptureGetAttachedShaders_count(glState, programPacked, maxCount, count, shadersPacked,
                                        &countParam);
    }
    else
    {
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &countParam.value);
    }
    paramBuffer.addParam(std::move(countParam));

    ParamCapture shadersPackedParam("shadersPacked", ParamType::TShaderProgramIDPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TShaderProgramIDPointer, shadersPacked,
                       &shadersPackedParam.value);
        CaptureGetAttachedShaders_shadersPacked(glState, programPacked, maxCount, count,
                                                shadersPacked, &shadersPackedParam);
    }
    else
    {
        InitParamValue(ParamType::TShaderProgramIDPointer, static_cast<ShaderProgramID *>(nullptr),
                       &shadersPackedParam.value);
    }
    paramBuffer.addParam(std::move(shadersPackedParam));

    return CallCapture(angle::EntryPoint::GLGetAttachedShaders, std::move(paramBuffer));
}

CallCapture CaptureGetAttribLocation(const State &glState,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     const GLchar *name,
                                     GLint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureGetAttribLocation_name(glState, programPacked, name, &nameParam);
    }
    else
    {
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
    }
    paramBuffer.addParam(std::move(nameParam));

    ParamCapture returnValueCapture("returnValue", ParamType::TGLint);
    InitParamValue(ParamType::TGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLGetAttribLocation, std::move(paramBuffer));
}

CallCapture CaptureGetBooleanv(const State &glState,
                               bool isCallValid,
                               GLenum pname,
                               GLboolean *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::GetPName, ParamType::TGLenum, pname);

    ParamCapture dataParam("data", ParamType::TGLbooleanPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLbooleanPointer, data, &dataParam.value);
        CaptureGetBooleanv_data(glState, pname, data, &dataParam);
    }
    else
    {
        InitParamValue(ParamType::TGLbooleanPointer, static_cast<GLboolean *>(nullptr),
                       &dataParam.value);
    }
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(angle::EntryPoint::GLGetBooleanv, std::move(paramBuffer));
}

CallCapture CaptureGetBufferParameteriv(const State &glState,
                                        bool isCallValid,
                                        BufferBinding targetPacked,
                                        GLenum pname,
                                        GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetBufferParameteriv_params(glState, targetPacked, pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetBufferParameteriv, std::move(paramBuffer));
}

CallCapture CaptureGetError(const State &glState, bool isCallValid, GLenum returnValue)
{
    ParamBuffer paramBuffer;

    ParamCapture returnValueCapture("returnValue", ParamType::TGLenum);
    InitParamValue(ParamType::TGLenum, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLGetError, std::move(paramBuffer));
}

CallCapture CaptureGetFloatv(const State &glState, bool isCallValid, GLenum pname, GLfloat *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::GetPName, ParamType::TGLenum, pname);

    ParamCapture dataParam("data", ParamType::TGLfloatPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatPointer, data, &dataParam.value);
        CaptureGetFloatv_data(glState, pname, data, &dataParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &dataParam.value);
    }
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(angle::EntryPoint::GLGetFloatv, std::move(paramBuffer));
}

CallCapture CaptureGetFramebufferAttachmentParameteriv(const State &glState,
                                                       bool isCallValid,
                                                       GLenum target,
                                                       GLenum attachment,
                                                       GLenum pname,
                                                       GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLESEnum::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addEnumParam("pname", GLESEnum::FramebufferAttachmentParameterName,
                             ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetFramebufferAttachmentParameteriv_params(glState, target, attachment, pname,
                                                          params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetFramebufferAttachmentParameteriv,
                       std::move(paramBuffer));
}

CallCapture CaptureGetIntegerv(const State &glState, bool isCallValid, GLenum pname, GLint *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::GetPName, ParamType::TGLenum, pname);

    ParamCapture dataParam("data", ParamType::TGLintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintPointer, data, &dataParam.value);
        CaptureGetIntegerv_data(glState, pname, data, &dataParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &dataParam.value);
    }
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(angle::EntryPoint::GLGetIntegerv, std::move(paramBuffer));
}

CallCapture CaptureGetProgramInfoLog(const State &glState,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     GLsizei bufSize,
                                     GLsizei *length,
                                     GLchar *infoLog)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetProgramInfoLog_length(glState, programPacked, bufSize, length, infoLog,
                                        &lengthParam);
    }
    else
    {
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
    }
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture infoLogParam("infoLog", ParamType::TGLcharPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLcharPointer, infoLog, &infoLogParam.value);
        CaptureGetProgramInfoLog_infoLog(glState, programPacked, bufSize, length, infoLog,
                                         &infoLogParam);
    }
    else
    {
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr),
                       &infoLogParam.value);
    }
    paramBuffer.addParam(std::move(infoLogParam));

    return CallCapture(angle::EntryPoint::GLGetProgramInfoLog, std::move(paramBuffer));
}

CallCapture CaptureGetProgramiv(const State &glState,
                                bool isCallValid,
                                ShaderProgramID programPacked,
                                GLenum pname,
                                GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::ProgramPropertyARB, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetProgramiv_params(glState, programPacked, pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetProgramiv, std::move(paramBuffer));
}

CallCapture CaptureGetRenderbufferParameteriv(const State &glState,
                                              bool isCallValid,
                                              GLenum target,
                                              GLenum pname,
                                              GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::RenderbufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("pname", GLESEnum::RenderbufferParameterName, ParamType::TGLenum,
                             pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetRenderbufferParameteriv_params(glState, target, pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetRenderbufferParameteriv, std::move(paramBuffer));
}

CallCapture CaptureGetShaderInfoLog(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID shaderPacked,
                                    GLsizei bufSize,
                                    GLsizei *length,
                                    GLchar *infoLog)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shaderPacked", ParamType::TShaderProgramID, shaderPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetShaderInfoLog_length(glState, shaderPacked, bufSize, length, infoLog,
                                       &lengthParam);
    }
    else
    {
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
    }
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture infoLogParam("infoLog", ParamType::TGLcharPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLcharPointer, infoLog, &infoLogParam.value);
        CaptureGetShaderInfoLog_infoLog(glState, shaderPacked, bufSize, length, infoLog,
                                        &infoLogParam);
    }
    else
    {
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr),
                       &infoLogParam.value);
    }
    paramBuffer.addParam(std::move(infoLogParam));

    return CallCapture(angle::EntryPoint::GLGetShaderInfoLog, std::move(paramBuffer));
}

CallCapture CaptureGetShaderPrecisionFormat(const State &glState,
                                            bool isCallValid,
                                            GLenum shadertype,
                                            GLenum precisiontype,
                                            GLint *range,
                                            GLint *precision)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("shadertype", GLESEnum::ShaderType, ParamType::TGLenum, shadertype);
    paramBuffer.addEnumParam("precisiontype", GLESEnum::PrecisionType, ParamType::TGLenum,
                             precisiontype);

    ParamCapture rangeParam("range", ParamType::TGLintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintPointer, range, &rangeParam.value);
        CaptureGetShaderPrecisionFormat_range(glState, shadertype, precisiontype, range, precision,
                                              &rangeParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &rangeParam.value);
    }
    paramBuffer.addParam(std::move(rangeParam));

    ParamCapture precisionParam("precision", ParamType::TGLintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintPointer, precision, &precisionParam.value);
        CaptureGetShaderPrecisionFormat_precision(glState, shadertype, precisiontype, range,
                                                  precision, &precisionParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr),
                       &precisionParam.value);
    }
    paramBuffer.addParam(std::move(precisionParam));

    return CallCapture(angle::EntryPoint::GLGetShaderPrecisionFormat, std::move(paramBuffer));
}

CallCapture CaptureGetShaderSource(const State &glState,
                                   bool isCallValid,
                                   ShaderProgramID shaderPacked,
                                   GLsizei bufSize,
                                   GLsizei *length,
                                   GLchar *source)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shaderPacked", ParamType::TShaderProgramID, shaderPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetShaderSource_length(glState, shaderPacked, bufSize, length, source, &lengthParam);
    }
    else
    {
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
    }
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture sourceParam("source", ParamType::TGLcharPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLcharPointer, source, &sourceParam.value);
        CaptureGetShaderSource_source(glState, shaderPacked, bufSize, length, source, &sourceParam);
    }
    else
    {
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr),
                       &sourceParam.value);
    }
    paramBuffer.addParam(std::move(sourceParam));

    return CallCapture(angle::EntryPoint::GLGetShaderSource, std::move(paramBuffer));
}

CallCapture CaptureGetShaderiv(const State &glState,
                               bool isCallValid,
                               ShaderProgramID shaderPacked,
                               GLenum pname,
                               GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shaderPacked", ParamType::TShaderProgramID, shaderPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::ShaderParameterName, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetShaderiv_params(glState, shaderPacked, pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetShaderiv, std::move(paramBuffer));
}

CallCapture CaptureGetString(const State &glState,
                             bool isCallValid,
                             GLenum name,
                             const GLubyte *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("name", GLESEnum::StringName, ParamType::TGLenum, name);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLubyteConstPointer);
    InitParamValue(ParamType::TGLubyteConstPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLGetString, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterfv(const State &glState,
                                     bool isCallValid,
                                     TextureType targetPacked,
                                     GLenum pname,
                                     GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::GetTextureParameter, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetTexParameterfv_params(glState, targetPacked, pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetTexParameterfv, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameteriv(const State &glState,
                                     bool isCallValid,
                                     TextureType targetPacked,
                                     GLenum pname,
                                     GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::GetTextureParameter, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetTexParameteriv_params(glState, targetPacked, pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetTexParameteriv, std::move(paramBuffer));
}

CallCapture CaptureGetUniformLocation(const State &glState,
                                      bool isCallValid,
                                      ShaderProgramID programPacked,
                                      const GLchar *name,
                                      GLint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureGetUniformLocation_name(glState, programPacked, name, &nameParam);
    }
    else
    {
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
    }
    paramBuffer.addParam(std::move(nameParam));

    ParamCapture returnValueCapture("returnValue", ParamType::TGLint);
    InitParamValue(ParamType::TGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLGetUniformLocation, std::move(paramBuffer));
}

CallCapture CaptureGetUniformfv(const State &glState,
                                bool isCallValid,
                                ShaderProgramID programPacked,
                                UniformLocation locationPacked,
                                GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetUniformfv_params(glState, programPacked, locationPacked, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetUniformfv, std::move(paramBuffer));
}

CallCapture CaptureGetUniformiv(const State &glState,
                                bool isCallValid,
                                ShaderProgramID programPacked,
                                UniformLocation locationPacked,
                                GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetUniformiv_params(glState, programPacked, locationPacked, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetUniformiv, std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribPointerv(const State &glState,
                                           bool isCallValid,
                                           GLuint index,
                                           GLenum pname,
                                           void **pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);

    ParamCapture pointerParam("pointer", ParamType::TvoidPointerPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointerPointer, pointer, &pointerParam.value);
        CaptureGetVertexAttribPointerv_pointer(glState, index, pname, pointer, &pointerParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointerPointer, static_cast<void **>(nullptr),
                       &pointerParam.value);
    }
    paramBuffer.addParam(std::move(pointerParam));

    return CallCapture(angle::EntryPoint::GLGetVertexAttribPointerv, std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribfv(const State &glState,
                                     bool isCallValid,
                                     GLuint index,
                                     GLenum pname,
                                     GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetVertexAttribfv_params(glState, index, pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetVertexAttribfv, std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribiv(const State &glState,
                                     bool isCallValid,
                                     GLuint index,
                                     GLenum pname,
                                     GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetVertexAttribiv_params(glState, index, pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetVertexAttribiv, std::move(paramBuffer));
}

CallCapture CaptureHint(const State &glState, bool isCallValid, GLenum target, GLenum mode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::HintTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("mode", GLESEnum::HintMode, ParamType::TGLenum, mode);

    return CallCapture(angle::EntryPoint::GLHint, std::move(paramBuffer));
}

CallCapture CaptureIsBuffer(const State &glState,
                            bool isCallValid,
                            BufferID bufferPacked,
                            GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLIsBuffer, std::move(paramBuffer));
}

CallCapture CaptureIsEnabled(const State &glState,
                             bool isCallValid,
                             GLenum cap,
                             GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("cap", GLESEnum::EnableCap, ParamType::TGLenum, cap);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLIsEnabled, std::move(paramBuffer));
}

CallCapture CaptureIsFramebuffer(const State &glState,
                                 bool isCallValid,
                                 FramebufferID framebufferPacked,
                                 GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLIsFramebuffer, std::move(paramBuffer));
}

CallCapture CaptureIsProgram(const State &glState,
                             bool isCallValid,
                             ShaderProgramID programPacked,
                             GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLIsProgram, std::move(paramBuffer));
}

CallCapture CaptureIsRenderbuffer(const State &glState,
                                  bool isCallValid,
                                  RenderbufferID renderbufferPacked,
                                  GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("renderbufferPacked", ParamType::TRenderbufferID, renderbufferPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLIsRenderbuffer, std::move(paramBuffer));
}

CallCapture CaptureIsShader(const State &glState,
                            bool isCallValid,
                            ShaderProgramID shaderPacked,
                            GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shaderPacked", ParamType::TShaderProgramID, shaderPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLIsShader, std::move(paramBuffer));
}

CallCapture CaptureIsTexture(const State &glState,
                             bool isCallValid,
                             TextureID texturePacked,
                             GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLIsTexture, std::move(paramBuffer));
}

CallCapture CaptureLineWidth(const State &glState, bool isCallValid, GLfloat width)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("width", ParamType::TGLfloat, width);

    return CallCapture(angle::EntryPoint::GLLineWidth, std::move(paramBuffer));
}

CallCapture CaptureLinkProgram(const State &glState,
                               bool isCallValid,
                               ShaderProgramID programPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    return CallCapture(angle::EntryPoint::GLLinkProgram, std::move(paramBuffer));
}

CallCapture CapturePixelStorei(const State &glState, bool isCallValid, GLenum pname, GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::PixelStoreParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture(angle::EntryPoint::GLPixelStorei, std::move(paramBuffer));
}

CallCapture CapturePolygonOffset(const State &glState,
                                 bool isCallValid,
                                 GLfloat factor,
                                 GLfloat units)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("factor", ParamType::TGLfloat, factor);
    paramBuffer.addValueParam("units", ParamType::TGLfloat, units);

    return CallCapture(angle::EntryPoint::GLPolygonOffset, std::move(paramBuffer));
}

CallCapture CaptureReadPixels(const State &glState,
                              bool isCallValid,
                              GLint x,
                              GLint y,
                              GLsizei width,
                              GLsizei height,
                              GLenum format,
                              GLenum type,
                              void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", GLESEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLESEnum::PixelType, ParamType::TGLenum, type);

    ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, pixels, &pixelsParam.value);
        CaptureReadPixels_pixels(glState, x, y, width, height, format, type, pixels, &pixelsParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &pixelsParam.value);
    }
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture(angle::EntryPoint::GLReadPixels, std::move(paramBuffer));
}

CallCapture CaptureReleaseShaderCompiler(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLReleaseShaderCompiler, std::move(paramBuffer));
}

CallCapture CaptureRenderbufferStorage(const State &glState,
                                       bool isCallValid,
                                       GLenum target,
                                       GLenum internalformat,
                                       GLsizei width,
                                       GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::RenderbufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("internalformat", GLESEnum::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(angle::EntryPoint::GLRenderbufferStorage, std::move(paramBuffer));
}

CallCapture CaptureSampleCoverage(const State &glState,
                                  bool isCallValid,
                                  GLfloat value,
                                  GLboolean invert)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("value", ParamType::TGLfloat, value);
    paramBuffer.addValueParam("invert", ParamType::TGLboolean, invert);

    return CallCapture(angle::EntryPoint::GLSampleCoverage, std::move(paramBuffer));
}

CallCapture CaptureScissor(const State &glState,
                           bool isCallValid,
                           GLint x,
                           GLint y,
                           GLsizei width,
                           GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(angle::EntryPoint::GLScissor, std::move(paramBuffer));
}

CallCapture CaptureShaderBinary(const State &glState,
                                bool isCallValid,
                                GLsizei count,
                                const ShaderProgramID *shadersPacked,
                                GLenum binaryFormat,
                                const void *binary,
                                GLsizei length)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture shadersPackedParam("shadersPacked", ParamType::TShaderProgramIDConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TShaderProgramIDConstPointer, shadersPacked,
                       &shadersPackedParam.value);
        CaptureShaderBinary_shadersPacked(glState, count, shadersPacked, binaryFormat, binary,
                                          length, &shadersPackedParam);
    }
    else
    {
        InitParamValue(ParamType::TShaderProgramIDConstPointer,
                       static_cast<const ShaderProgramID *>(nullptr), &shadersPackedParam.value);
    }
    paramBuffer.addParam(std::move(shadersPackedParam));

    paramBuffer.addEnumParam("binaryFormat", GLESEnum::ShaderBinaryFormat, ParamType::TGLenum,
                             binaryFormat);

    ParamCapture binaryParam("binary", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, binary, &binaryParam.value);
        CaptureShaderBinary_binary(glState, count, shadersPacked, binaryFormat, binary, length,
                                   &binaryParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &binaryParam.value);
    }
    paramBuffer.addParam(std::move(binaryParam));

    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    return CallCapture(angle::EntryPoint::GLShaderBinary, std::move(paramBuffer));
}

CallCapture CaptureShaderSource(const State &glState,
                                bool isCallValid,
                                ShaderProgramID shaderPacked,
                                GLsizei count,
                                const GLchar *const *string,
                                const GLint *length)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shaderPacked", ParamType::TShaderProgramID, shaderPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture stringParam("string", ParamType::TGLcharConstPointerPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLcharConstPointerPointer, string, &stringParam.value);
        CaptureShaderSource_string(glState, shaderPacked, count, string, length, &stringParam);
    }
    else
    {
        InitParamValue(ParamType::TGLcharConstPointerPointer,
                       static_cast<const GLchar *const *>(nullptr), &stringParam.value);
    }
    paramBuffer.addParam(std::move(stringParam));

    ParamCapture lengthParam("length", ParamType::TGLintConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintConstPointer, length, &lengthParam.value);
        CaptureShaderSource_length(glState, shaderPacked, count, string, length, &lengthParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &lengthParam.value);
    }
    paramBuffer.addParam(std::move(lengthParam));

    return CallCapture(angle::EntryPoint::GLShaderSource, std::move(paramBuffer));
}

CallCapture CaptureStencilFunc(const State &glState,
                               bool isCallValid,
                               GLenum func,
                               GLint ref,
                               GLuint mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("func", GLESEnum::StencilFunction, ParamType::TGLenum, func);
    paramBuffer.addValueParam("ref", ParamType::TGLint, ref);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);

    return CallCapture(angle::EntryPoint::GLStencilFunc, std::move(paramBuffer));
}

CallCapture CaptureStencilFuncSeparate(const State &glState,
                                       bool isCallValid,
                                       GLenum face,
                                       GLenum func,
                                       GLint ref,
                                       GLuint mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("face", GLESEnum::TriangleFace, ParamType::TGLenum, face);
    paramBuffer.addEnumParam("func", GLESEnum::StencilFunction, ParamType::TGLenum, func);
    paramBuffer.addValueParam("ref", ParamType::TGLint, ref);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);

    return CallCapture(angle::EntryPoint::GLStencilFuncSeparate, std::move(paramBuffer));
}

CallCapture CaptureStencilMask(const State &glState, bool isCallValid, GLuint mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);

    return CallCapture(angle::EntryPoint::GLStencilMask, std::move(paramBuffer));
}

CallCapture CaptureStencilMaskSeparate(const State &glState,
                                       bool isCallValid,
                                       GLenum face,
                                       GLuint mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("face", GLESEnum::TriangleFace, ParamType::TGLenum, face);
    paramBuffer.addValueParam("mask", ParamType::TGLuint, mask);

    return CallCapture(angle::EntryPoint::GLStencilMaskSeparate, std::move(paramBuffer));
}

CallCapture CaptureStencilOp(const State &glState,
                             bool isCallValid,
                             GLenum fail,
                             GLenum zfail,
                             GLenum zpass)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("fail", GLESEnum::StencilOp, ParamType::TGLenum, fail);
    paramBuffer.addEnumParam("zfail", GLESEnum::StencilOp, ParamType::TGLenum, zfail);
    paramBuffer.addEnumParam("zpass", GLESEnum::StencilOp, ParamType::TGLenum, zpass);

    return CallCapture(angle::EntryPoint::GLStencilOp, std::move(paramBuffer));
}

CallCapture CaptureStencilOpSeparate(const State &glState,
                                     bool isCallValid,
                                     GLenum face,
                                     GLenum sfail,
                                     GLenum dpfail,
                                     GLenum dppass)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("face", GLESEnum::TriangleFace, ParamType::TGLenum, face);
    paramBuffer.addEnumParam("sfail", GLESEnum::StencilOp, ParamType::TGLenum, sfail);
    paramBuffer.addEnumParam("dpfail", GLESEnum::StencilOp, ParamType::TGLenum, dpfail);
    paramBuffer.addEnumParam("dppass", GLESEnum::StencilOp, ParamType::TGLenum, dppass);

    return CallCapture(angle::EntryPoint::GLStencilOpSeparate, std::move(paramBuffer));
}

CallCapture CaptureTexImage2D(const State &glState,
                              bool isCallValid,
                              TextureTarget targetPacked,
                              GLint level,
                              GLint internalformat,
                              GLsizei width,
                              GLsizei height,
                              GLint border,
                              GLenum format,
                              GLenum type,
                              const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("internalformat", ParamType::TGLint, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addEnumParam("format", GLESEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLESEnum::PixelType, ParamType::TGLenum, type);

    ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
        CaptureTexImage2D_pixels(glState, targetPacked, level, internalformat, width, height,
                                 border, format, type, pixels, &pixelsParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pixelsParam.value);
    }
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture(angle::EntryPoint::GLTexImage2D, std::move(paramBuffer));
}

CallCapture CaptureTexParameterf(const State &glState,
                                 bool isCallValid,
                                 TextureType targetPacked,
                                 GLenum pname,
                                 GLfloat param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::TextureParameterName, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfloat, param);

    return CallCapture(angle::EntryPoint::GLTexParameterf, std::move(paramBuffer));
}

CallCapture CaptureTexParameterfv(const State &glState,
                                  bool isCallValid,
                                  TextureType targetPacked,
                                  GLenum pname,
                                  const GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::TextureParameterName, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatConstPointer, params, &paramsParam.value);
        CaptureTexParameterfv_params(glState, targetPacked, pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLTexParameterfv, std::move(paramBuffer));
}

CallCapture CaptureTexParameteri(const State &glState,
                                 bool isCallValid,
                                 TextureType targetPacked,
                                 GLenum pname,
                                 GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::TextureParameterName, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture(angle::EntryPoint::GLTexParameteri, std::move(paramBuffer));
}

CallCapture CaptureTexParameteriv(const State &glState,
                                  bool isCallValid,
                                  TextureType targetPacked,
                                  GLenum pname,
                                  const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::TextureParameterName, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
        CaptureTexParameteriv_params(glState, targetPacked, pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLTexParameteriv, std::move(paramBuffer));
}

CallCapture CaptureTexSubImage2D(const State &glState,
                                 bool isCallValid,
                                 TextureTarget targetPacked,
                                 GLint level,
                                 GLint xoffset,
                                 GLint yoffset,
                                 GLsizei width,
                                 GLsizei height,
                                 GLenum format,
                                 GLenum type,
                                 const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", GLESEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLESEnum::PixelType, ParamType::TGLenum, type);

    ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
        CaptureTexSubImage2D_pixels(glState, targetPacked, level, xoffset, yoffset, width, height,
                                    format, type, pixels, &pixelsParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pixelsParam.value);
    }
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture(angle::EntryPoint::GLTexSubImage2D, std::move(paramBuffer));
}

CallCapture CaptureUniform1f(const State &glState,
                             bool isCallValid,
                             UniformLocation locationPacked,
                             GLfloat v0)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLfloat, v0);

    return CallCapture(angle::EntryPoint::GLUniform1f, std::move(paramBuffer));
}

CallCapture CaptureUniform1fv(const State &glState,
                              bool isCallValid,
                              UniformLocation locationPacked,
                              GLsizei count,
                              const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureUniform1fv_value(glState, locationPacked, count, value, &valueParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
    }
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(angle::EntryPoint::GLUniform1fv, std::move(paramBuffer));
}

CallCapture CaptureUniform1i(const State &glState,
                             bool isCallValid,
                             UniformLocation locationPacked,
                             GLint v0)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLint, v0);

    return CallCapture(angle::EntryPoint::GLUniform1i, std::move(paramBuffer));
}

CallCapture CaptureUniform1iv(const State &glState,
                              bool isCallValid,
                              UniformLocation locationPacked,
                              GLsizei count,
                              const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLintConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
        CaptureUniform1iv_value(glState, locationPacked, count, value, &valueParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &valueParam.value);
    }
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(angle::EntryPoint::GLUniform1iv, std::move(paramBuffer));
}

CallCapture CaptureUniform2f(const State &glState,
                             bool isCallValid,
                             UniformLocation locationPacked,
                             GLfloat v0,
                             GLfloat v1)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLfloat, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLfloat, v1);

    return CallCapture(angle::EntryPoint::GLUniform2f, std::move(paramBuffer));
}

CallCapture CaptureUniform2fv(const State &glState,
                              bool isCallValid,
                              UniformLocation locationPacked,
                              GLsizei count,
                              const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureUniform2fv_value(glState, locationPacked, count, value, &valueParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
    }
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(angle::EntryPoint::GLUniform2fv, std::move(paramBuffer));
}

CallCapture CaptureUniform2i(const State &glState,
                             bool isCallValid,
                             UniformLocation locationPacked,
                             GLint v0,
                             GLint v1)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLint, v1);

    return CallCapture(angle::EntryPoint::GLUniform2i, std::move(paramBuffer));
}

CallCapture CaptureUniform2iv(const State &glState,
                              bool isCallValid,
                              UniformLocation locationPacked,
                              GLsizei count,
                              const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLintConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
        CaptureUniform2iv_value(glState, locationPacked, count, value, &valueParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &valueParam.value);
    }
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(angle::EntryPoint::GLUniform2iv, std::move(paramBuffer));
}

CallCapture CaptureUniform3f(const State &glState,
                             bool isCallValid,
                             UniformLocation locationPacked,
                             GLfloat v0,
                             GLfloat v1,
                             GLfloat v2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLfloat, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLfloat, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLfloat, v2);

    return CallCapture(angle::EntryPoint::GLUniform3f, std::move(paramBuffer));
}

CallCapture CaptureUniform3fv(const State &glState,
                              bool isCallValid,
                              UniformLocation locationPacked,
                              GLsizei count,
                              const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureUniform3fv_value(glState, locationPacked, count, value, &valueParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
    }
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(angle::EntryPoint::GLUniform3fv, std::move(paramBuffer));
}

CallCapture CaptureUniform3i(const State &glState,
                             bool isCallValid,
                             UniformLocation locationPacked,
                             GLint v0,
                             GLint v1,
                             GLint v2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLint, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLint, v2);

    return CallCapture(angle::EntryPoint::GLUniform3i, std::move(paramBuffer));
}

CallCapture CaptureUniform3iv(const State &glState,
                              bool isCallValid,
                              UniformLocation locationPacked,
                              GLsizei count,
                              const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLintConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
        CaptureUniform3iv_value(glState, locationPacked, count, value, &valueParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &valueParam.value);
    }
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(angle::EntryPoint::GLUniform3iv, std::move(paramBuffer));
}

CallCapture CaptureUniform4f(const State &glState,
                             bool isCallValid,
                             UniformLocation locationPacked,
                             GLfloat v0,
                             GLfloat v1,
                             GLfloat v2,
                             GLfloat v3)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLfloat, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLfloat, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLfloat, v2);
    paramBuffer.addValueParam("v3", ParamType::TGLfloat, v3);

    return CallCapture(angle::EntryPoint::GLUniform4f, std::move(paramBuffer));
}

CallCapture CaptureUniform4fv(const State &glState,
                              bool isCallValid,
                              UniformLocation locationPacked,
                              GLsizei count,
                              const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureUniform4fv_value(glState, locationPacked, count, value, &valueParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
    }
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(angle::EntryPoint::GLUniform4fv, std::move(paramBuffer));
}

CallCapture CaptureUniform4i(const State &glState,
                             bool isCallValid,
                             UniformLocation locationPacked,
                             GLint v0,
                             GLint v1,
                             GLint v2,
                             GLint v3)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLint, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLint, v2);
    paramBuffer.addValueParam("v3", ParamType::TGLint, v3);

    return CallCapture(angle::EntryPoint::GLUniform4i, std::move(paramBuffer));
}

CallCapture CaptureUniform4iv(const State &glState,
                              bool isCallValid,
                              UniformLocation locationPacked,
                              GLsizei count,
                              const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLintConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
        CaptureUniform4iv_value(glState, locationPacked, count, value, &valueParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &valueParam.value);
    }
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(angle::EntryPoint::GLUniform4iv, std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix2fv(const State &glState,
                                    bool isCallValid,
                                    UniformLocation locationPacked,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureUniformMatrix2fv_value(glState, locationPacked, count, transpose, value,
                                      &valueParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
    }
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(angle::EntryPoint::GLUniformMatrix2fv, std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix3fv(const State &glState,
                                    bool isCallValid,
                                    UniformLocation locationPacked,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureUniformMatrix3fv_value(glState, locationPacked, count, transpose, value,
                                      &valueParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
    }
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(angle::EntryPoint::GLUniformMatrix3fv, std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix4fv(const State &glState,
                                    bool isCallValid,
                                    UniformLocation locationPacked,
                                    GLsizei count,
                                    GLboolean transpose,
                                    const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureUniformMatrix4fv_value(glState, locationPacked, count, transpose, value,
                                      &valueParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
    }
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(angle::EntryPoint::GLUniformMatrix4fv, std::move(paramBuffer));
}

CallCapture CaptureUseProgram(const State &glState, bool isCallValid, ShaderProgramID programPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    return CallCapture(angle::EntryPoint::GLUseProgram, std::move(paramBuffer));
}

CallCapture CaptureValidateProgram(const State &glState,
                                   bool isCallValid,
                                   ShaderProgramID programPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    return CallCapture(angle::EntryPoint::GLValidateProgram, std::move(paramBuffer));
}

CallCapture CaptureVertexAttrib1f(const State &glState, bool isCallValid, GLuint index, GLfloat x)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);

    return CallCapture(angle::EntryPoint::GLVertexAttrib1f, std::move(paramBuffer));
}

CallCapture CaptureVertexAttrib1fv(const State &glState,
                                   bool isCallValid,
                                   GLuint index,
                                   const GLfloat *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureVertexAttrib1fv_v(glState, index, v, &vParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
    }
    paramBuffer.addParam(std::move(vParam));

    return CallCapture(angle::EntryPoint::GLVertexAttrib1fv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttrib2f(const State &glState,
                                  bool isCallValid,
                                  GLuint index,
                                  GLfloat x,
                                  GLfloat y)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);

    return CallCapture(angle::EntryPoint::GLVertexAttrib2f, std::move(paramBuffer));
}

CallCapture CaptureVertexAttrib2fv(const State &glState,
                                   bool isCallValid,
                                   GLuint index,
                                   const GLfloat *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureVertexAttrib2fv_v(glState, index, v, &vParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
    }
    paramBuffer.addParam(std::move(vParam));

    return CallCapture(angle::EntryPoint::GLVertexAttrib2fv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttrib3f(const State &glState,
                                  bool isCallValid,
                                  GLuint index,
                                  GLfloat x,
                                  GLfloat y,
                                  GLfloat z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);
    paramBuffer.addValueParam("z", ParamType::TGLfloat, z);

    return CallCapture(angle::EntryPoint::GLVertexAttrib3f, std::move(paramBuffer));
}

CallCapture CaptureVertexAttrib3fv(const State &glState,
                                   bool isCallValid,
                                   GLuint index,
                                   const GLfloat *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureVertexAttrib3fv_v(glState, index, v, &vParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
    }
    paramBuffer.addParam(std::move(vParam));

    return CallCapture(angle::EntryPoint::GLVertexAttrib3fv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttrib4f(const State &glState,
                                  bool isCallValid,
                                  GLuint index,
                                  GLfloat x,
                                  GLfloat y,
                                  GLfloat z,
                                  GLfloat w)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);
    paramBuffer.addValueParam("z", ParamType::TGLfloat, z);
    paramBuffer.addValueParam("w", ParamType::TGLfloat, w);

    return CallCapture(angle::EntryPoint::GLVertexAttrib4f, std::move(paramBuffer));
}

CallCapture CaptureVertexAttrib4fv(const State &glState,
                                   bool isCallValid,
                                   GLuint index,
                                   const GLfloat *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture vParam("v", ParamType::TGLfloatConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatConstPointer, v, &vParam.value);
        CaptureVertexAttrib4fv_v(glState, index, v, &vParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &vParam.value);
    }
    paramBuffer.addParam(std::move(vParam));

    return CallCapture(angle::EntryPoint::GLVertexAttrib4fv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribPointer(const State &glState,
                                       bool isCallValid,
                                       GLuint index,
                                       GLint size,
                                       VertexAttribType typePacked,
                                       GLboolean normalized,
                                       GLsizei stride,
                                       const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addValueParam("typePacked", ParamType::TVertexAttribType, typePacked);
    paramBuffer.addValueParam("normalized", ParamType::TGLboolean, normalized);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
        CaptureVertexAttribPointer_pointer(glState, index, size, typePacked, normalized, stride,
                                           pointer, &pointerParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pointerParam.value);
    }
    paramBuffer.addParam(std::move(pointerParam));

    return CallCapture(angle::EntryPoint::GLVertexAttribPointer, std::move(paramBuffer));
}

CallCapture CaptureViewport(const State &glState,
                            bool isCallValid,
                            GLint x,
                            GLint y,
                            GLsizei width,
                            GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(angle::EntryPoint::GLViewport, std::move(paramBuffer));
}

}  // namespace gl
