#ifdef GET_RISCVMaskedPseudosTable_DECL
const RISCVMaskedPseudoInfo *getMaskedPseudoInfo(unsigned MaskedPseudo);
const RISCVMaskedPseudoInfo *lookupMaskedIntrinsicByUnmaskedTA(unsigned UnmaskedPseudo);
#endif

#ifdef GET_RISCVMaskedPseudosTable_IMPL
constexpr RISCVMaskedPseudoInfo RISCVMaskedPseudosTable[] = {
  { PseudoVAADDU_VV_M1_MASK, PseudoVAADDU_VV_M1, PseudoVAADDU_VV_M1_TU, 0x3 }, // 0
  { PseudoVAADDU_VV_M2_MASK, PseudoVAADDU_VV_M2, PseudoVAADDU_VV_M2_TU, 0x3 }, // 1
  { PseudoVAADDU_VV_M4_MASK, PseudoVAADDU_VV_M4, PseudoVAADDU_VV_M4_TU, 0x3 }, // 2
  { PseudoVAADDU_VV_M8_MASK, PseudoVAADDU_VV_M8, PseudoVAADDU_VV_M8_TU, 0x3 }, // 3
  { PseudoVAADDU_VV_MF2_MASK, PseudoVAADDU_VV_MF2, PseudoVAADDU_VV_MF2_TU, 0x3 }, // 4
  { PseudoVAADDU_VV_MF4_MASK, PseudoVAADDU_VV_MF4, PseudoVAADDU_VV_MF4_TU, 0x3 }, // 5
  { PseudoVAADDU_VV_MF8_MASK, PseudoVAADDU_VV_MF8, PseudoVAADDU_VV_MF8_TU, 0x3 }, // 6
  { PseudoVAADDU_VX_M1_MASK, PseudoVAADDU_VX_M1, PseudoVAADDU_VX_M1_TU, 0x3 }, // 7
  { PseudoVAADDU_VX_M2_MASK, PseudoVAADDU_VX_M2, PseudoVAADDU_VX_M2_TU, 0x3 }, // 8
  { PseudoVAADDU_VX_M4_MASK, PseudoVAADDU_VX_M4, PseudoVAADDU_VX_M4_TU, 0x3 }, // 9
  { PseudoVAADDU_VX_M8_MASK, PseudoVAADDU_VX_M8, PseudoVAADDU_VX_M8_TU, 0x3 }, // 10
  { PseudoVAADDU_VX_MF2_MASK, PseudoVAADDU_VX_MF2, PseudoVAADDU_VX_MF2_TU, 0x3 }, // 11
  { PseudoVAADDU_VX_MF4_MASK, PseudoVAADDU_VX_MF4, PseudoVAADDU_VX_MF4_TU, 0x3 }, // 12
  { PseudoVAADDU_VX_MF8_MASK, PseudoVAADDU_VX_MF8, PseudoVAADDU_VX_MF8_TU, 0x3 }, // 13
  { PseudoVAADD_VV_M1_MASK, PseudoVAADD_VV_M1, PseudoVAADD_VV_M1_TU, 0x3 }, // 14
  { PseudoVAADD_VV_M2_MASK, PseudoVAADD_VV_M2, PseudoVAADD_VV_M2_TU, 0x3 }, // 15
  { PseudoVAADD_VV_M4_MASK, PseudoVAADD_VV_M4, PseudoVAADD_VV_M4_TU, 0x3 }, // 16
  { PseudoVAADD_VV_M8_MASK, PseudoVAADD_VV_M8, PseudoVAADD_VV_M8_TU, 0x3 }, // 17
  { PseudoVAADD_VV_MF2_MASK, PseudoVAADD_VV_MF2, PseudoVAADD_VV_MF2_TU, 0x3 }, // 18
  { PseudoVAADD_VV_MF4_MASK, PseudoVAADD_VV_MF4, PseudoVAADD_VV_MF4_TU, 0x3 }, // 19
  { PseudoVAADD_VV_MF8_MASK, PseudoVAADD_VV_MF8, PseudoVAADD_VV_MF8_TU, 0x3 }, // 20
  { PseudoVAADD_VX_M1_MASK, PseudoVAADD_VX_M1, PseudoVAADD_VX_M1_TU, 0x3 }, // 21
  { PseudoVAADD_VX_M2_MASK, PseudoVAADD_VX_M2, PseudoVAADD_VX_M2_TU, 0x3 }, // 22
  { PseudoVAADD_VX_M4_MASK, PseudoVAADD_VX_M4, PseudoVAADD_VX_M4_TU, 0x3 }, // 23
  { PseudoVAADD_VX_M8_MASK, PseudoVAADD_VX_M8, PseudoVAADD_VX_M8_TU, 0x3 }, // 24
  { PseudoVAADD_VX_MF2_MASK, PseudoVAADD_VX_MF2, PseudoVAADD_VX_MF2_TU, 0x3 }, // 25
  { PseudoVAADD_VX_MF4_MASK, PseudoVAADD_VX_MF4, PseudoVAADD_VX_MF4_TU, 0x3 }, // 26
  { PseudoVAADD_VX_MF8_MASK, PseudoVAADD_VX_MF8, PseudoVAADD_VX_MF8_TU, 0x3 }, // 27
  { PseudoVADD_VI_M1_MASK, PseudoVADD_VI_M1, PseudoVADD_VI_M1_TU, 0x3 }, // 28
  { PseudoVADD_VI_M2_MASK, PseudoVADD_VI_M2, PseudoVADD_VI_M2_TU, 0x3 }, // 29
  { PseudoVADD_VI_M4_MASK, PseudoVADD_VI_M4, PseudoVADD_VI_M4_TU, 0x3 }, // 30
  { PseudoVADD_VI_M8_MASK, PseudoVADD_VI_M8, PseudoVADD_VI_M8_TU, 0x3 }, // 31
  { PseudoVADD_VI_MF2_MASK, PseudoVADD_VI_MF2, PseudoVADD_VI_MF2_TU, 0x3 }, // 32
  { PseudoVADD_VI_MF4_MASK, PseudoVADD_VI_MF4, PseudoVADD_VI_MF4_TU, 0x3 }, // 33
  { PseudoVADD_VI_MF8_MASK, PseudoVADD_VI_MF8, PseudoVADD_VI_MF8_TU, 0x3 }, // 34
  { PseudoVADD_VV_M1_MASK, PseudoVADD_VV_M1, PseudoVADD_VV_M1_TU, 0x3 }, // 35
  { PseudoVADD_VV_M2_MASK, PseudoVADD_VV_M2, PseudoVADD_VV_M2_TU, 0x3 }, // 36
  { PseudoVADD_VV_M4_MASK, PseudoVADD_VV_M4, PseudoVADD_VV_M4_TU, 0x3 }, // 37
  { PseudoVADD_VV_M8_MASK, PseudoVADD_VV_M8, PseudoVADD_VV_M8_TU, 0x3 }, // 38
  { PseudoVADD_VV_MF2_MASK, PseudoVADD_VV_MF2, PseudoVADD_VV_MF2_TU, 0x3 }, // 39
  { PseudoVADD_VV_MF4_MASK, PseudoVADD_VV_MF4, PseudoVADD_VV_MF4_TU, 0x3 }, // 40
  { PseudoVADD_VV_MF8_MASK, PseudoVADD_VV_MF8, PseudoVADD_VV_MF8_TU, 0x3 }, // 41
  { PseudoVADD_VX_M1_MASK, PseudoVADD_VX_M1, PseudoVADD_VX_M1_TU, 0x3 }, // 42
  { PseudoVADD_VX_M2_MASK, PseudoVADD_VX_M2, PseudoVADD_VX_M2_TU, 0x3 }, // 43
  { PseudoVADD_VX_M4_MASK, PseudoVADD_VX_M4, PseudoVADD_VX_M4_TU, 0x3 }, // 44
  { PseudoVADD_VX_M8_MASK, PseudoVADD_VX_M8, PseudoVADD_VX_M8_TU, 0x3 }, // 45
  { PseudoVADD_VX_MF2_MASK, PseudoVADD_VX_MF2, PseudoVADD_VX_MF2_TU, 0x3 }, // 46
  { PseudoVADD_VX_MF4_MASK, PseudoVADD_VX_MF4, PseudoVADD_VX_MF4_TU, 0x3 }, // 47
  { PseudoVADD_VX_MF8_MASK, PseudoVADD_VX_MF8, PseudoVADD_VX_MF8_TU, 0x3 }, // 48
  { PseudoVAND_VI_M1_MASK, PseudoVAND_VI_M1, PseudoVAND_VI_M1_TU, 0x3 }, // 49
  { PseudoVAND_VI_M2_MASK, PseudoVAND_VI_M2, PseudoVAND_VI_M2_TU, 0x3 }, // 50
  { PseudoVAND_VI_M4_MASK, PseudoVAND_VI_M4, PseudoVAND_VI_M4_TU, 0x3 }, // 51
  { PseudoVAND_VI_M8_MASK, PseudoVAND_VI_M8, PseudoVAND_VI_M8_TU, 0x3 }, // 52
  { PseudoVAND_VI_MF2_MASK, PseudoVAND_VI_MF2, PseudoVAND_VI_MF2_TU, 0x3 }, // 53
  { PseudoVAND_VI_MF4_MASK, PseudoVAND_VI_MF4, PseudoVAND_VI_MF4_TU, 0x3 }, // 54
  { PseudoVAND_VI_MF8_MASK, PseudoVAND_VI_MF8, PseudoVAND_VI_MF8_TU, 0x3 }, // 55
  { PseudoVAND_VV_M1_MASK, PseudoVAND_VV_M1, PseudoVAND_VV_M1_TU, 0x3 }, // 56
  { PseudoVAND_VV_M2_MASK, PseudoVAND_VV_M2, PseudoVAND_VV_M2_TU, 0x3 }, // 57
  { PseudoVAND_VV_M4_MASK, PseudoVAND_VV_M4, PseudoVAND_VV_M4_TU, 0x3 }, // 58
  { PseudoVAND_VV_M8_MASK, PseudoVAND_VV_M8, PseudoVAND_VV_M8_TU, 0x3 }, // 59
  { PseudoVAND_VV_MF2_MASK, PseudoVAND_VV_MF2, PseudoVAND_VV_MF2_TU, 0x3 }, // 60
  { PseudoVAND_VV_MF4_MASK, PseudoVAND_VV_MF4, PseudoVAND_VV_MF4_TU, 0x3 }, // 61
  { PseudoVAND_VV_MF8_MASK, PseudoVAND_VV_MF8, PseudoVAND_VV_MF8_TU, 0x3 }, // 62
  { PseudoVAND_VX_M1_MASK, PseudoVAND_VX_M1, PseudoVAND_VX_M1_TU, 0x3 }, // 63
  { PseudoVAND_VX_M2_MASK, PseudoVAND_VX_M2, PseudoVAND_VX_M2_TU, 0x3 }, // 64
  { PseudoVAND_VX_M4_MASK, PseudoVAND_VX_M4, PseudoVAND_VX_M4_TU, 0x3 }, // 65
  { PseudoVAND_VX_M8_MASK, PseudoVAND_VX_M8, PseudoVAND_VX_M8_TU, 0x3 }, // 66
  { PseudoVAND_VX_MF2_MASK, PseudoVAND_VX_MF2, PseudoVAND_VX_MF2_TU, 0x3 }, // 67
  { PseudoVAND_VX_MF4_MASK, PseudoVAND_VX_MF4, PseudoVAND_VX_MF4_TU, 0x3 }, // 68
  { PseudoVAND_VX_MF8_MASK, PseudoVAND_VX_MF8, PseudoVAND_VX_MF8_TU, 0x3 }, // 69
  { PseudoVASUBU_VV_M1_MASK, PseudoVASUBU_VV_M1, PseudoVASUBU_VV_M1_TU, 0x3 }, // 70
  { PseudoVASUBU_VV_M2_MASK, PseudoVASUBU_VV_M2, PseudoVASUBU_VV_M2_TU, 0x3 }, // 71
  { PseudoVASUBU_VV_M4_MASK, PseudoVASUBU_VV_M4, PseudoVASUBU_VV_M4_TU, 0x3 }, // 72
  { PseudoVASUBU_VV_M8_MASK, PseudoVASUBU_VV_M8, PseudoVASUBU_VV_M8_TU, 0x3 }, // 73
  { PseudoVASUBU_VV_MF2_MASK, PseudoVASUBU_VV_MF2, PseudoVASUBU_VV_MF2_TU, 0x3 }, // 74
  { PseudoVASUBU_VV_MF4_MASK, PseudoVASUBU_VV_MF4, PseudoVASUBU_VV_MF4_TU, 0x3 }, // 75
  { PseudoVASUBU_VV_MF8_MASK, PseudoVASUBU_VV_MF8, PseudoVASUBU_VV_MF8_TU, 0x3 }, // 76
  { PseudoVASUBU_VX_M1_MASK, PseudoVASUBU_VX_M1, PseudoVASUBU_VX_M1_TU, 0x3 }, // 77
  { PseudoVASUBU_VX_M2_MASK, PseudoVASUBU_VX_M2, PseudoVASUBU_VX_M2_TU, 0x3 }, // 78
  { PseudoVASUBU_VX_M4_MASK, PseudoVASUBU_VX_M4, PseudoVASUBU_VX_M4_TU, 0x3 }, // 79
  { PseudoVASUBU_VX_M8_MASK, PseudoVASUBU_VX_M8, PseudoVASUBU_VX_M8_TU, 0x3 }, // 80
  { PseudoVASUBU_VX_MF2_MASK, PseudoVASUBU_VX_MF2, PseudoVASUBU_VX_MF2_TU, 0x3 }, // 81
  { PseudoVASUBU_VX_MF4_MASK, PseudoVASUBU_VX_MF4, PseudoVASUBU_VX_MF4_TU, 0x3 }, // 82
  { PseudoVASUBU_VX_MF8_MASK, PseudoVASUBU_VX_MF8, PseudoVASUBU_VX_MF8_TU, 0x3 }, // 83
  { PseudoVASUB_VV_M1_MASK, PseudoVASUB_VV_M1, PseudoVASUB_VV_M1_TU, 0x3 }, // 84
  { PseudoVASUB_VV_M2_MASK, PseudoVASUB_VV_M2, PseudoVASUB_VV_M2_TU, 0x3 }, // 85
  { PseudoVASUB_VV_M4_MASK, PseudoVASUB_VV_M4, PseudoVASUB_VV_M4_TU, 0x3 }, // 86
  { PseudoVASUB_VV_M8_MASK, PseudoVASUB_VV_M8, PseudoVASUB_VV_M8_TU, 0x3 }, // 87
  { PseudoVASUB_VV_MF2_MASK, PseudoVASUB_VV_MF2, PseudoVASUB_VV_MF2_TU, 0x3 }, // 88
  { PseudoVASUB_VV_MF4_MASK, PseudoVASUB_VV_MF4, PseudoVASUB_VV_MF4_TU, 0x3 }, // 89
  { PseudoVASUB_VV_MF8_MASK, PseudoVASUB_VV_MF8, PseudoVASUB_VV_MF8_TU, 0x3 }, // 90
  { PseudoVASUB_VX_M1_MASK, PseudoVASUB_VX_M1, PseudoVASUB_VX_M1_TU, 0x3 }, // 91
  { PseudoVASUB_VX_M2_MASK, PseudoVASUB_VX_M2, PseudoVASUB_VX_M2_TU, 0x3 }, // 92
  { PseudoVASUB_VX_M4_MASK, PseudoVASUB_VX_M4, PseudoVASUB_VX_M4_TU, 0x3 }, // 93
  { PseudoVASUB_VX_M8_MASK, PseudoVASUB_VX_M8, PseudoVASUB_VX_M8_TU, 0x3 }, // 94
  { PseudoVASUB_VX_MF2_MASK, PseudoVASUB_VX_MF2, PseudoVASUB_VX_MF2_TU, 0x3 }, // 95
  { PseudoVASUB_VX_MF4_MASK, PseudoVASUB_VX_MF4, PseudoVASUB_VX_MF4_TU, 0x3 }, // 96
  { PseudoVASUB_VX_MF8_MASK, PseudoVASUB_VX_MF8, PseudoVASUB_VX_MF8_TU, 0x3 }, // 97
  { PseudoVDIVU_VV_M1_MASK, PseudoVDIVU_VV_M1, PseudoVDIVU_VV_M1_TU, 0x3 }, // 98
  { PseudoVDIVU_VV_M2_MASK, PseudoVDIVU_VV_M2, PseudoVDIVU_VV_M2_TU, 0x3 }, // 99
  { PseudoVDIVU_VV_M4_MASK, PseudoVDIVU_VV_M4, PseudoVDIVU_VV_M4_TU, 0x3 }, // 100
  { PseudoVDIVU_VV_M8_MASK, PseudoVDIVU_VV_M8, PseudoVDIVU_VV_M8_TU, 0x3 }, // 101
  { PseudoVDIVU_VV_MF2_MASK, PseudoVDIVU_VV_MF2, PseudoVDIVU_VV_MF2_TU, 0x3 }, // 102
  { PseudoVDIVU_VV_MF4_MASK, PseudoVDIVU_VV_MF4, PseudoVDIVU_VV_MF4_TU, 0x3 }, // 103
  { PseudoVDIVU_VV_MF8_MASK, PseudoVDIVU_VV_MF8, PseudoVDIVU_VV_MF8_TU, 0x3 }, // 104
  { PseudoVDIVU_VX_M1_MASK, PseudoVDIVU_VX_M1, PseudoVDIVU_VX_M1_TU, 0x3 }, // 105
  { PseudoVDIVU_VX_M2_MASK, PseudoVDIVU_VX_M2, PseudoVDIVU_VX_M2_TU, 0x3 }, // 106
  { PseudoVDIVU_VX_M4_MASK, PseudoVDIVU_VX_M4, PseudoVDIVU_VX_M4_TU, 0x3 }, // 107
  { PseudoVDIVU_VX_M8_MASK, PseudoVDIVU_VX_M8, PseudoVDIVU_VX_M8_TU, 0x3 }, // 108
  { PseudoVDIVU_VX_MF2_MASK, PseudoVDIVU_VX_MF2, PseudoVDIVU_VX_MF2_TU, 0x3 }, // 109
  { PseudoVDIVU_VX_MF4_MASK, PseudoVDIVU_VX_MF4, PseudoVDIVU_VX_MF4_TU, 0x3 }, // 110
  { PseudoVDIVU_VX_MF8_MASK, PseudoVDIVU_VX_MF8, PseudoVDIVU_VX_MF8_TU, 0x3 }, // 111
  { PseudoVDIV_VV_M1_MASK, PseudoVDIV_VV_M1, PseudoVDIV_VV_M1_TU, 0x3 }, // 112
  { PseudoVDIV_VV_M2_MASK, PseudoVDIV_VV_M2, PseudoVDIV_VV_M2_TU, 0x3 }, // 113
  { PseudoVDIV_VV_M4_MASK, PseudoVDIV_VV_M4, PseudoVDIV_VV_M4_TU, 0x3 }, // 114
  { PseudoVDIV_VV_M8_MASK, PseudoVDIV_VV_M8, PseudoVDIV_VV_M8_TU, 0x3 }, // 115
  { PseudoVDIV_VV_MF2_MASK, PseudoVDIV_VV_MF2, PseudoVDIV_VV_MF2_TU, 0x3 }, // 116
  { PseudoVDIV_VV_MF4_MASK, PseudoVDIV_VV_MF4, PseudoVDIV_VV_MF4_TU, 0x3 }, // 117
  { PseudoVDIV_VV_MF8_MASK, PseudoVDIV_VV_MF8, PseudoVDIV_VV_MF8_TU, 0x3 }, // 118
  { PseudoVDIV_VX_M1_MASK, PseudoVDIV_VX_M1, PseudoVDIV_VX_M1_TU, 0x3 }, // 119
  { PseudoVDIV_VX_M2_MASK, PseudoVDIV_VX_M2, PseudoVDIV_VX_M2_TU, 0x3 }, // 120
  { PseudoVDIV_VX_M4_MASK, PseudoVDIV_VX_M4, PseudoVDIV_VX_M4_TU, 0x3 }, // 121
  { PseudoVDIV_VX_M8_MASK, PseudoVDIV_VX_M8, PseudoVDIV_VX_M8_TU, 0x3 }, // 122
  { PseudoVDIV_VX_MF2_MASK, PseudoVDIV_VX_MF2, PseudoVDIV_VX_MF2_TU, 0x3 }, // 123
  { PseudoVDIV_VX_MF4_MASK, PseudoVDIV_VX_MF4, PseudoVDIV_VX_MF4_TU, 0x3 }, // 124
  { PseudoVDIV_VX_MF8_MASK, PseudoVDIV_VX_MF8, PseudoVDIV_VX_MF8_TU, 0x3 }, // 125
  { PseudoVFADD_VF16_M1_MASK, PseudoVFADD_VF16_M1, PseudoVFADD_VF16_M1_TU, 0x3 }, // 126
  { PseudoVFADD_VF16_M2_MASK, PseudoVFADD_VF16_M2, PseudoVFADD_VF16_M2_TU, 0x3 }, // 127
  { PseudoVFADD_VF16_M4_MASK, PseudoVFADD_VF16_M4, PseudoVFADD_VF16_M4_TU, 0x3 }, // 128
  { PseudoVFADD_VF16_M8_MASK, PseudoVFADD_VF16_M8, PseudoVFADD_VF16_M8_TU, 0x3 }, // 129
  { PseudoVFADD_VF16_MF2_MASK, PseudoVFADD_VF16_MF2, PseudoVFADD_VF16_MF2_TU, 0x3 }, // 130
  { PseudoVFADD_VF16_MF4_MASK, PseudoVFADD_VF16_MF4, PseudoVFADD_VF16_MF4_TU, 0x3 }, // 131
  { PseudoVFADD_VF32_M1_MASK, PseudoVFADD_VF32_M1, PseudoVFADD_VF32_M1_TU, 0x3 }, // 132
  { PseudoVFADD_VF32_M2_MASK, PseudoVFADD_VF32_M2, PseudoVFADD_VF32_M2_TU, 0x3 }, // 133
  { PseudoVFADD_VF32_M4_MASK, PseudoVFADD_VF32_M4, PseudoVFADD_VF32_M4_TU, 0x3 }, // 134
  { PseudoVFADD_VF32_M8_MASK, PseudoVFADD_VF32_M8, PseudoVFADD_VF32_M8_TU, 0x3 }, // 135
  { PseudoVFADD_VF32_MF2_MASK, PseudoVFADD_VF32_MF2, PseudoVFADD_VF32_MF2_TU, 0x3 }, // 136
  { PseudoVFADD_VF64_M1_MASK, PseudoVFADD_VF64_M1, PseudoVFADD_VF64_M1_TU, 0x3 }, // 137
  { PseudoVFADD_VF64_M2_MASK, PseudoVFADD_VF64_M2, PseudoVFADD_VF64_M2_TU, 0x3 }, // 138
  { PseudoVFADD_VF64_M4_MASK, PseudoVFADD_VF64_M4, PseudoVFADD_VF64_M4_TU, 0x3 }, // 139
  { PseudoVFADD_VF64_M8_MASK, PseudoVFADD_VF64_M8, PseudoVFADD_VF64_M8_TU, 0x3 }, // 140
  { PseudoVFADD_VV_M1_MASK, PseudoVFADD_VV_M1, PseudoVFADD_VV_M1_TU, 0x3 }, // 141
  { PseudoVFADD_VV_M2_MASK, PseudoVFADD_VV_M2, PseudoVFADD_VV_M2_TU, 0x3 }, // 142
  { PseudoVFADD_VV_M4_MASK, PseudoVFADD_VV_M4, PseudoVFADD_VV_M4_TU, 0x3 }, // 143
  { PseudoVFADD_VV_M8_MASK, PseudoVFADD_VV_M8, PseudoVFADD_VV_M8_TU, 0x3 }, // 144
  { PseudoVFADD_VV_MF2_MASK, PseudoVFADD_VV_MF2, PseudoVFADD_VV_MF2_TU, 0x3 }, // 145
  { PseudoVFADD_VV_MF4_MASK, PseudoVFADD_VV_MF4, PseudoVFADD_VV_MF4_TU, 0x3 }, // 146
  { PseudoVFCLASS_V_M1_MASK, PseudoVFCLASS_V_M1, PseudoVFCLASS_V_M1_TU, 0x2 }, // 147
  { PseudoVFCLASS_V_M2_MASK, PseudoVFCLASS_V_M2, PseudoVFCLASS_V_M2_TU, 0x2 }, // 148
  { PseudoVFCLASS_V_M4_MASK, PseudoVFCLASS_V_M4, PseudoVFCLASS_V_M4_TU, 0x2 }, // 149
  { PseudoVFCLASS_V_M8_MASK, PseudoVFCLASS_V_M8, PseudoVFCLASS_V_M8_TU, 0x2 }, // 150
  { PseudoVFCLASS_V_MF2_MASK, PseudoVFCLASS_V_MF2, PseudoVFCLASS_V_MF2_TU, 0x2 }, // 151
  { PseudoVFCLASS_V_MF4_MASK, PseudoVFCLASS_V_MF4, PseudoVFCLASS_V_MF4_TU, 0x2 }, // 152
  { PseudoVFCVT_F_XU_V_M1_MASK, PseudoVFCVT_F_XU_V_M1, PseudoVFCVT_F_XU_V_M1_TU, 0x2 }, // 153
  { PseudoVFCVT_F_XU_V_M2_MASK, PseudoVFCVT_F_XU_V_M2, PseudoVFCVT_F_XU_V_M2_TU, 0x2 }, // 154
  { PseudoVFCVT_F_XU_V_M4_MASK, PseudoVFCVT_F_XU_V_M4, PseudoVFCVT_F_XU_V_M4_TU, 0x2 }, // 155
  { PseudoVFCVT_F_XU_V_M8_MASK, PseudoVFCVT_F_XU_V_M8, PseudoVFCVT_F_XU_V_M8_TU, 0x2 }, // 156
  { PseudoVFCVT_F_XU_V_MF2_MASK, PseudoVFCVT_F_XU_V_MF2, PseudoVFCVT_F_XU_V_MF2_TU, 0x2 }, // 157
  { PseudoVFCVT_F_XU_V_MF4_MASK, PseudoVFCVT_F_XU_V_MF4, PseudoVFCVT_F_XU_V_MF4_TU, 0x2 }, // 158
  { PseudoVFCVT_F_X_V_M1_MASK, PseudoVFCVT_F_X_V_M1, PseudoVFCVT_F_X_V_M1_TU, 0x2 }, // 159
  { PseudoVFCVT_F_X_V_M2_MASK, PseudoVFCVT_F_X_V_M2, PseudoVFCVT_F_X_V_M2_TU, 0x2 }, // 160
  { PseudoVFCVT_F_X_V_M4_MASK, PseudoVFCVT_F_X_V_M4, PseudoVFCVT_F_X_V_M4_TU, 0x2 }, // 161
  { PseudoVFCVT_F_X_V_M8_MASK, PseudoVFCVT_F_X_V_M8, PseudoVFCVT_F_X_V_M8_TU, 0x2 }, // 162
  { PseudoVFCVT_F_X_V_MF2_MASK, PseudoVFCVT_F_X_V_MF2, PseudoVFCVT_F_X_V_MF2_TU, 0x2 }, // 163
  { PseudoVFCVT_F_X_V_MF4_MASK, PseudoVFCVT_F_X_V_MF4, PseudoVFCVT_F_X_V_MF4_TU, 0x2 }, // 164
  { PseudoVFCVT_RTZ_XU_F_V_M1_MASK, PseudoVFCVT_RTZ_XU_F_V_M1, PseudoVFCVT_RTZ_XU_F_V_M1_TU, 0x2 }, // 165
  { PseudoVFCVT_RTZ_XU_F_V_M2_MASK, PseudoVFCVT_RTZ_XU_F_V_M2, PseudoVFCVT_RTZ_XU_F_V_M2_TU, 0x2 }, // 166
  { PseudoVFCVT_RTZ_XU_F_V_M4_MASK, PseudoVFCVT_RTZ_XU_F_V_M4, PseudoVFCVT_RTZ_XU_F_V_M4_TU, 0x2 }, // 167
  { PseudoVFCVT_RTZ_XU_F_V_M8_MASK, PseudoVFCVT_RTZ_XU_F_V_M8, PseudoVFCVT_RTZ_XU_F_V_M8_TU, 0x2 }, // 168
  { PseudoVFCVT_RTZ_XU_F_V_MF2_MASK, PseudoVFCVT_RTZ_XU_F_V_MF2, PseudoVFCVT_RTZ_XU_F_V_MF2_TU, 0x2 }, // 169
  { PseudoVFCVT_RTZ_XU_F_V_MF4_MASK, PseudoVFCVT_RTZ_XU_F_V_MF4, PseudoVFCVT_RTZ_XU_F_V_MF4_TU, 0x2 }, // 170
  { PseudoVFCVT_RTZ_X_F_V_M1_MASK, PseudoVFCVT_RTZ_X_F_V_M1, PseudoVFCVT_RTZ_X_F_V_M1_TU, 0x2 }, // 171
  { PseudoVFCVT_RTZ_X_F_V_M2_MASK, PseudoVFCVT_RTZ_X_F_V_M2, PseudoVFCVT_RTZ_X_F_V_M2_TU, 0x2 }, // 172
  { PseudoVFCVT_RTZ_X_F_V_M4_MASK, PseudoVFCVT_RTZ_X_F_V_M4, PseudoVFCVT_RTZ_X_F_V_M4_TU, 0x2 }, // 173
  { PseudoVFCVT_RTZ_X_F_V_M8_MASK, PseudoVFCVT_RTZ_X_F_V_M8, PseudoVFCVT_RTZ_X_F_V_M8_TU, 0x2 }, // 174
  { PseudoVFCVT_RTZ_X_F_V_MF2_MASK, PseudoVFCVT_RTZ_X_F_V_MF2, PseudoVFCVT_RTZ_X_F_V_MF2_TU, 0x2 }, // 175
  { PseudoVFCVT_RTZ_X_F_V_MF4_MASK, PseudoVFCVT_RTZ_X_F_V_MF4, PseudoVFCVT_RTZ_X_F_V_MF4_TU, 0x2 }, // 176
  { PseudoVFCVT_XU_F_V_M1_MASK, PseudoVFCVT_XU_F_V_M1, PseudoVFCVT_XU_F_V_M1_TU, 0x2 }, // 177
  { PseudoVFCVT_XU_F_V_M2_MASK, PseudoVFCVT_XU_F_V_M2, PseudoVFCVT_XU_F_V_M2_TU, 0x2 }, // 178
  { PseudoVFCVT_XU_F_V_M4_MASK, PseudoVFCVT_XU_F_V_M4, PseudoVFCVT_XU_F_V_M4_TU, 0x2 }, // 179
  { PseudoVFCVT_XU_F_V_M8_MASK, PseudoVFCVT_XU_F_V_M8, PseudoVFCVT_XU_F_V_M8_TU, 0x2 }, // 180
  { PseudoVFCVT_XU_F_V_MF2_MASK, PseudoVFCVT_XU_F_V_MF2, PseudoVFCVT_XU_F_V_MF2_TU, 0x2 }, // 181
  { PseudoVFCVT_XU_F_V_MF4_MASK, PseudoVFCVT_XU_F_V_MF4, PseudoVFCVT_XU_F_V_MF4_TU, 0x2 }, // 182
  { PseudoVFCVT_X_F_V_M1_MASK, PseudoVFCVT_X_F_V_M1, PseudoVFCVT_X_F_V_M1_TU, 0x2 }, // 183
  { PseudoVFCVT_X_F_V_M2_MASK, PseudoVFCVT_X_F_V_M2, PseudoVFCVT_X_F_V_M2_TU, 0x2 }, // 184
  { PseudoVFCVT_X_F_V_M4_MASK, PseudoVFCVT_X_F_V_M4, PseudoVFCVT_X_F_V_M4_TU, 0x2 }, // 185
  { PseudoVFCVT_X_F_V_M8_MASK, PseudoVFCVT_X_F_V_M8, PseudoVFCVT_X_F_V_M8_TU, 0x2 }, // 186
  { PseudoVFCVT_X_F_V_MF2_MASK, PseudoVFCVT_X_F_V_MF2, PseudoVFCVT_X_F_V_MF2_TU, 0x2 }, // 187
  { PseudoVFCVT_X_F_V_MF4_MASK, PseudoVFCVT_X_F_V_MF4, PseudoVFCVT_X_F_V_MF4_TU, 0x2 }, // 188
  { PseudoVFDIV_VF16_M1_MASK, PseudoVFDIV_VF16_M1, PseudoVFDIV_VF16_M1_TU, 0x3 }, // 189
  { PseudoVFDIV_VF16_M2_MASK, PseudoVFDIV_VF16_M2, PseudoVFDIV_VF16_M2_TU, 0x3 }, // 190
  { PseudoVFDIV_VF16_M4_MASK, PseudoVFDIV_VF16_M4, PseudoVFDIV_VF16_M4_TU, 0x3 }, // 191
  { PseudoVFDIV_VF16_M8_MASK, PseudoVFDIV_VF16_M8, PseudoVFDIV_VF16_M8_TU, 0x3 }, // 192
  { PseudoVFDIV_VF16_MF2_MASK, PseudoVFDIV_VF16_MF2, PseudoVFDIV_VF16_MF2_TU, 0x3 }, // 193
  { PseudoVFDIV_VF16_MF4_MASK, PseudoVFDIV_VF16_MF4, PseudoVFDIV_VF16_MF4_TU, 0x3 }, // 194
  { PseudoVFDIV_VF32_M1_MASK, PseudoVFDIV_VF32_M1, PseudoVFDIV_VF32_M1_TU, 0x3 }, // 195
  { PseudoVFDIV_VF32_M2_MASK, PseudoVFDIV_VF32_M2, PseudoVFDIV_VF32_M2_TU, 0x3 }, // 196
  { PseudoVFDIV_VF32_M4_MASK, PseudoVFDIV_VF32_M4, PseudoVFDIV_VF32_M4_TU, 0x3 }, // 197
  { PseudoVFDIV_VF32_M8_MASK, PseudoVFDIV_VF32_M8, PseudoVFDIV_VF32_M8_TU, 0x3 }, // 198
  { PseudoVFDIV_VF32_MF2_MASK, PseudoVFDIV_VF32_MF2, PseudoVFDIV_VF32_MF2_TU, 0x3 }, // 199
  { PseudoVFDIV_VF64_M1_MASK, PseudoVFDIV_VF64_M1, PseudoVFDIV_VF64_M1_TU, 0x3 }, // 200
  { PseudoVFDIV_VF64_M2_MASK, PseudoVFDIV_VF64_M2, PseudoVFDIV_VF64_M2_TU, 0x3 }, // 201
  { PseudoVFDIV_VF64_M4_MASK, PseudoVFDIV_VF64_M4, PseudoVFDIV_VF64_M4_TU, 0x3 }, // 202
  { PseudoVFDIV_VF64_M8_MASK, PseudoVFDIV_VF64_M8, PseudoVFDIV_VF64_M8_TU, 0x3 }, // 203
  { PseudoVFDIV_VV_M1_MASK, PseudoVFDIV_VV_M1, PseudoVFDIV_VV_M1_TU, 0x3 }, // 204
  { PseudoVFDIV_VV_M2_MASK, PseudoVFDIV_VV_M2, PseudoVFDIV_VV_M2_TU, 0x3 }, // 205
  { PseudoVFDIV_VV_M4_MASK, PseudoVFDIV_VV_M4, PseudoVFDIV_VV_M4_TU, 0x3 }, // 206
  { PseudoVFDIV_VV_M8_MASK, PseudoVFDIV_VV_M8, PseudoVFDIV_VV_M8_TU, 0x3 }, // 207
  { PseudoVFDIV_VV_MF2_MASK, PseudoVFDIV_VV_MF2, PseudoVFDIV_VV_MF2_TU, 0x3 }, // 208
  { PseudoVFDIV_VV_MF4_MASK, PseudoVFDIV_VV_MF4, PseudoVFDIV_VV_MF4_TU, 0x3 }, // 209
  { PseudoVFMAX_VF16_M1_MASK, PseudoVFMAX_VF16_M1, PseudoVFMAX_VF16_M1_TU, 0x3 }, // 210
  { PseudoVFMAX_VF16_M2_MASK, PseudoVFMAX_VF16_M2, PseudoVFMAX_VF16_M2_TU, 0x3 }, // 211
  { PseudoVFMAX_VF16_M4_MASK, PseudoVFMAX_VF16_M4, PseudoVFMAX_VF16_M4_TU, 0x3 }, // 212
  { PseudoVFMAX_VF16_M8_MASK, PseudoVFMAX_VF16_M8, PseudoVFMAX_VF16_M8_TU, 0x3 }, // 213
  { PseudoVFMAX_VF16_MF2_MASK, PseudoVFMAX_VF16_MF2, PseudoVFMAX_VF16_MF2_TU, 0x3 }, // 214
  { PseudoVFMAX_VF16_MF4_MASK, PseudoVFMAX_VF16_MF4, PseudoVFMAX_VF16_MF4_TU, 0x3 }, // 215
  { PseudoVFMAX_VF32_M1_MASK, PseudoVFMAX_VF32_M1, PseudoVFMAX_VF32_M1_TU, 0x3 }, // 216
  { PseudoVFMAX_VF32_M2_MASK, PseudoVFMAX_VF32_M2, PseudoVFMAX_VF32_M2_TU, 0x3 }, // 217
  { PseudoVFMAX_VF32_M4_MASK, PseudoVFMAX_VF32_M4, PseudoVFMAX_VF32_M4_TU, 0x3 }, // 218
  { PseudoVFMAX_VF32_M8_MASK, PseudoVFMAX_VF32_M8, PseudoVFMAX_VF32_M8_TU, 0x3 }, // 219
  { PseudoVFMAX_VF32_MF2_MASK, PseudoVFMAX_VF32_MF2, PseudoVFMAX_VF32_MF2_TU, 0x3 }, // 220
  { PseudoVFMAX_VF64_M1_MASK, PseudoVFMAX_VF64_M1, PseudoVFMAX_VF64_M1_TU, 0x3 }, // 221
  { PseudoVFMAX_VF64_M2_MASK, PseudoVFMAX_VF64_M2, PseudoVFMAX_VF64_M2_TU, 0x3 }, // 222
  { PseudoVFMAX_VF64_M4_MASK, PseudoVFMAX_VF64_M4, PseudoVFMAX_VF64_M4_TU, 0x3 }, // 223
  { PseudoVFMAX_VF64_M8_MASK, PseudoVFMAX_VF64_M8, PseudoVFMAX_VF64_M8_TU, 0x3 }, // 224
  { PseudoVFMAX_VV_M1_MASK, PseudoVFMAX_VV_M1, PseudoVFMAX_VV_M1_TU, 0x3 }, // 225
  { PseudoVFMAX_VV_M2_MASK, PseudoVFMAX_VV_M2, PseudoVFMAX_VV_M2_TU, 0x3 }, // 226
  { PseudoVFMAX_VV_M4_MASK, PseudoVFMAX_VV_M4, PseudoVFMAX_VV_M4_TU, 0x3 }, // 227
  { PseudoVFMAX_VV_M8_MASK, PseudoVFMAX_VV_M8, PseudoVFMAX_VV_M8_TU, 0x3 }, // 228
  { PseudoVFMAX_VV_MF2_MASK, PseudoVFMAX_VV_MF2, PseudoVFMAX_VV_MF2_TU, 0x3 }, // 229
  { PseudoVFMAX_VV_MF4_MASK, PseudoVFMAX_VV_MF4, PseudoVFMAX_VV_MF4_TU, 0x3 }, // 230
  { PseudoVFMIN_VF16_M1_MASK, PseudoVFMIN_VF16_M1, PseudoVFMIN_VF16_M1_TU, 0x3 }, // 231
  { PseudoVFMIN_VF16_M2_MASK, PseudoVFMIN_VF16_M2, PseudoVFMIN_VF16_M2_TU, 0x3 }, // 232
  { PseudoVFMIN_VF16_M4_MASK, PseudoVFMIN_VF16_M4, PseudoVFMIN_VF16_M4_TU, 0x3 }, // 233
  { PseudoVFMIN_VF16_M8_MASK, PseudoVFMIN_VF16_M8, PseudoVFMIN_VF16_M8_TU, 0x3 }, // 234
  { PseudoVFMIN_VF16_MF2_MASK, PseudoVFMIN_VF16_MF2, PseudoVFMIN_VF16_MF2_TU, 0x3 }, // 235
  { PseudoVFMIN_VF16_MF4_MASK, PseudoVFMIN_VF16_MF4, PseudoVFMIN_VF16_MF4_TU, 0x3 }, // 236
  { PseudoVFMIN_VF32_M1_MASK, PseudoVFMIN_VF32_M1, PseudoVFMIN_VF32_M1_TU, 0x3 }, // 237
  { PseudoVFMIN_VF32_M2_MASK, PseudoVFMIN_VF32_M2, PseudoVFMIN_VF32_M2_TU, 0x3 }, // 238
  { PseudoVFMIN_VF32_M4_MASK, PseudoVFMIN_VF32_M4, PseudoVFMIN_VF32_M4_TU, 0x3 }, // 239
  { PseudoVFMIN_VF32_M8_MASK, PseudoVFMIN_VF32_M8, PseudoVFMIN_VF32_M8_TU, 0x3 }, // 240
  { PseudoVFMIN_VF32_MF2_MASK, PseudoVFMIN_VF32_MF2, PseudoVFMIN_VF32_MF2_TU, 0x3 }, // 241
  { PseudoVFMIN_VF64_M1_MASK, PseudoVFMIN_VF64_M1, PseudoVFMIN_VF64_M1_TU, 0x3 }, // 242
  { PseudoVFMIN_VF64_M2_MASK, PseudoVFMIN_VF64_M2, PseudoVFMIN_VF64_M2_TU, 0x3 }, // 243
  { PseudoVFMIN_VF64_M4_MASK, PseudoVFMIN_VF64_M4, PseudoVFMIN_VF64_M4_TU, 0x3 }, // 244
  { PseudoVFMIN_VF64_M8_MASK, PseudoVFMIN_VF64_M8, PseudoVFMIN_VF64_M8_TU, 0x3 }, // 245
  { PseudoVFMIN_VV_M1_MASK, PseudoVFMIN_VV_M1, PseudoVFMIN_VV_M1_TU, 0x3 }, // 246
  { PseudoVFMIN_VV_M2_MASK, PseudoVFMIN_VV_M2, PseudoVFMIN_VV_M2_TU, 0x3 }, // 247
  { PseudoVFMIN_VV_M4_MASK, PseudoVFMIN_VV_M4, PseudoVFMIN_VV_M4_TU, 0x3 }, // 248
  { PseudoVFMIN_VV_M8_MASK, PseudoVFMIN_VV_M8, PseudoVFMIN_VV_M8_TU, 0x3 }, // 249
  { PseudoVFMIN_VV_MF2_MASK, PseudoVFMIN_VV_MF2, PseudoVFMIN_VV_MF2_TU, 0x3 }, // 250
  { PseudoVFMIN_VV_MF4_MASK, PseudoVFMIN_VV_MF4, PseudoVFMIN_VV_MF4_TU, 0x3 }, // 251
  { PseudoVFMUL_VF16_M1_MASK, PseudoVFMUL_VF16_M1, PseudoVFMUL_VF16_M1_TU, 0x3 }, // 252
  { PseudoVFMUL_VF16_M2_MASK, PseudoVFMUL_VF16_M2, PseudoVFMUL_VF16_M2_TU, 0x3 }, // 253
  { PseudoVFMUL_VF16_M4_MASK, PseudoVFMUL_VF16_M4, PseudoVFMUL_VF16_M4_TU, 0x3 }, // 254
  { PseudoVFMUL_VF16_M8_MASK, PseudoVFMUL_VF16_M8, PseudoVFMUL_VF16_M8_TU, 0x3 }, // 255
  { PseudoVFMUL_VF16_MF2_MASK, PseudoVFMUL_VF16_MF2, PseudoVFMUL_VF16_MF2_TU, 0x3 }, // 256
  { PseudoVFMUL_VF16_MF4_MASK, PseudoVFMUL_VF16_MF4, PseudoVFMUL_VF16_MF4_TU, 0x3 }, // 257
  { PseudoVFMUL_VF32_M1_MASK, PseudoVFMUL_VF32_M1, PseudoVFMUL_VF32_M1_TU, 0x3 }, // 258
  { PseudoVFMUL_VF32_M2_MASK, PseudoVFMUL_VF32_M2, PseudoVFMUL_VF32_M2_TU, 0x3 }, // 259
  { PseudoVFMUL_VF32_M4_MASK, PseudoVFMUL_VF32_M4, PseudoVFMUL_VF32_M4_TU, 0x3 }, // 260
  { PseudoVFMUL_VF32_M8_MASK, PseudoVFMUL_VF32_M8, PseudoVFMUL_VF32_M8_TU, 0x3 }, // 261
  { PseudoVFMUL_VF32_MF2_MASK, PseudoVFMUL_VF32_MF2, PseudoVFMUL_VF32_MF2_TU, 0x3 }, // 262
  { PseudoVFMUL_VF64_M1_MASK, PseudoVFMUL_VF64_M1, PseudoVFMUL_VF64_M1_TU, 0x3 }, // 263
  { PseudoVFMUL_VF64_M2_MASK, PseudoVFMUL_VF64_M2, PseudoVFMUL_VF64_M2_TU, 0x3 }, // 264
  { PseudoVFMUL_VF64_M4_MASK, PseudoVFMUL_VF64_M4, PseudoVFMUL_VF64_M4_TU, 0x3 }, // 265
  { PseudoVFMUL_VF64_M8_MASK, PseudoVFMUL_VF64_M8, PseudoVFMUL_VF64_M8_TU, 0x3 }, // 266
  { PseudoVFMUL_VV_M1_MASK, PseudoVFMUL_VV_M1, PseudoVFMUL_VV_M1_TU, 0x3 }, // 267
  { PseudoVFMUL_VV_M2_MASK, PseudoVFMUL_VV_M2, PseudoVFMUL_VV_M2_TU, 0x3 }, // 268
  { PseudoVFMUL_VV_M4_MASK, PseudoVFMUL_VV_M4, PseudoVFMUL_VV_M4_TU, 0x3 }, // 269
  { PseudoVFMUL_VV_M8_MASK, PseudoVFMUL_VV_M8, PseudoVFMUL_VV_M8_TU, 0x3 }, // 270
  { PseudoVFMUL_VV_MF2_MASK, PseudoVFMUL_VV_MF2, PseudoVFMUL_VV_MF2_TU, 0x3 }, // 271
  { PseudoVFMUL_VV_MF4_MASK, PseudoVFMUL_VV_MF4, PseudoVFMUL_VV_MF4_TU, 0x3 }, // 272
  { PseudoVFNCVT_F_F_W_M1_MASK, PseudoVFNCVT_F_F_W_M1, PseudoVFNCVT_F_F_W_M1_TU, 0x2 }, // 273
  { PseudoVFNCVT_F_F_W_M2_MASK, PseudoVFNCVT_F_F_W_M2, PseudoVFNCVT_F_F_W_M2_TU, 0x2 }, // 274
  { PseudoVFNCVT_F_F_W_M4_MASK, PseudoVFNCVT_F_F_W_M4, PseudoVFNCVT_F_F_W_M4_TU, 0x2 }, // 275
  { PseudoVFNCVT_F_F_W_MF2_MASK, PseudoVFNCVT_F_F_W_MF2, PseudoVFNCVT_F_F_W_MF2_TU, 0x2 }, // 276
  { PseudoVFNCVT_F_F_W_MF4_MASK, PseudoVFNCVT_F_F_W_MF4, PseudoVFNCVT_F_F_W_MF4_TU, 0x2 }, // 277
  { PseudoVFNCVT_F_XU_W_M1_MASK, PseudoVFNCVT_F_XU_W_M1, PseudoVFNCVT_F_XU_W_M1_TU, 0x2 }, // 278
  { PseudoVFNCVT_F_XU_W_M2_MASK, PseudoVFNCVT_F_XU_W_M2, PseudoVFNCVT_F_XU_W_M2_TU, 0x2 }, // 279
  { PseudoVFNCVT_F_XU_W_M4_MASK, PseudoVFNCVT_F_XU_W_M4, PseudoVFNCVT_F_XU_W_M4_TU, 0x2 }, // 280
  { PseudoVFNCVT_F_XU_W_MF2_MASK, PseudoVFNCVT_F_XU_W_MF2, PseudoVFNCVT_F_XU_W_MF2_TU, 0x2 }, // 281
  { PseudoVFNCVT_F_XU_W_MF4_MASK, PseudoVFNCVT_F_XU_W_MF4, PseudoVFNCVT_F_XU_W_MF4_TU, 0x2 }, // 282
  { PseudoVFNCVT_F_X_W_M1_MASK, PseudoVFNCVT_F_X_W_M1, PseudoVFNCVT_F_X_W_M1_TU, 0x2 }, // 283
  { PseudoVFNCVT_F_X_W_M2_MASK, PseudoVFNCVT_F_X_W_M2, PseudoVFNCVT_F_X_W_M2_TU, 0x2 }, // 284
  { PseudoVFNCVT_F_X_W_M4_MASK, PseudoVFNCVT_F_X_W_M4, PseudoVFNCVT_F_X_W_M4_TU, 0x2 }, // 285
  { PseudoVFNCVT_F_X_W_MF2_MASK, PseudoVFNCVT_F_X_W_MF2, PseudoVFNCVT_F_X_W_MF2_TU, 0x2 }, // 286
  { PseudoVFNCVT_F_X_W_MF4_MASK, PseudoVFNCVT_F_X_W_MF4, PseudoVFNCVT_F_X_W_MF4_TU, 0x2 }, // 287
  { PseudoVFNCVT_ROD_F_F_W_M1_MASK, PseudoVFNCVT_ROD_F_F_W_M1, PseudoVFNCVT_ROD_F_F_W_M1_TU, 0x2 }, // 288
  { PseudoVFNCVT_ROD_F_F_W_M2_MASK, PseudoVFNCVT_ROD_F_F_W_M2, PseudoVFNCVT_ROD_F_F_W_M2_TU, 0x2 }, // 289
  { PseudoVFNCVT_ROD_F_F_W_M4_MASK, PseudoVFNCVT_ROD_F_F_W_M4, PseudoVFNCVT_ROD_F_F_W_M4_TU, 0x2 }, // 290
  { PseudoVFNCVT_ROD_F_F_W_MF2_MASK, PseudoVFNCVT_ROD_F_F_W_MF2, PseudoVFNCVT_ROD_F_F_W_MF2_TU, 0x2 }, // 291
  { PseudoVFNCVT_ROD_F_F_W_MF4_MASK, PseudoVFNCVT_ROD_F_F_W_MF4, PseudoVFNCVT_ROD_F_F_W_MF4_TU, 0x2 }, // 292
  { PseudoVFNCVT_RTZ_XU_F_W_M1_MASK, PseudoVFNCVT_RTZ_XU_F_W_M1, PseudoVFNCVT_RTZ_XU_F_W_M1_TU, 0x2 }, // 293
  { PseudoVFNCVT_RTZ_XU_F_W_M2_MASK, PseudoVFNCVT_RTZ_XU_F_W_M2, PseudoVFNCVT_RTZ_XU_F_W_M2_TU, 0x2 }, // 294
  { PseudoVFNCVT_RTZ_XU_F_W_M4_MASK, PseudoVFNCVT_RTZ_XU_F_W_M4, PseudoVFNCVT_RTZ_XU_F_W_M4_TU, 0x2 }, // 295
  { PseudoVFNCVT_RTZ_XU_F_W_MF2_MASK, PseudoVFNCVT_RTZ_XU_F_W_MF2, PseudoVFNCVT_RTZ_XU_F_W_MF2_TU, 0x2 }, // 296
  { PseudoVFNCVT_RTZ_XU_F_W_MF4_MASK, PseudoVFNCVT_RTZ_XU_F_W_MF4, PseudoVFNCVT_RTZ_XU_F_W_MF4_TU, 0x2 }, // 297
  { PseudoVFNCVT_RTZ_XU_F_W_MF8_MASK, PseudoVFNCVT_RTZ_XU_F_W_MF8, PseudoVFNCVT_RTZ_XU_F_W_MF8_TU, 0x2 }, // 298
  { PseudoVFNCVT_RTZ_X_F_W_M1_MASK, PseudoVFNCVT_RTZ_X_F_W_M1, PseudoVFNCVT_RTZ_X_F_W_M1_TU, 0x2 }, // 299
  { PseudoVFNCVT_RTZ_X_F_W_M2_MASK, PseudoVFNCVT_RTZ_X_F_W_M2, PseudoVFNCVT_RTZ_X_F_W_M2_TU, 0x2 }, // 300
  { PseudoVFNCVT_RTZ_X_F_W_M4_MASK, PseudoVFNCVT_RTZ_X_F_W_M4, PseudoVFNCVT_RTZ_X_F_W_M4_TU, 0x2 }, // 301
  { PseudoVFNCVT_RTZ_X_F_W_MF2_MASK, PseudoVFNCVT_RTZ_X_F_W_MF2, PseudoVFNCVT_RTZ_X_F_W_MF2_TU, 0x2 }, // 302
  { PseudoVFNCVT_RTZ_X_F_W_MF4_MASK, PseudoVFNCVT_RTZ_X_F_W_MF4, PseudoVFNCVT_RTZ_X_F_W_MF4_TU, 0x2 }, // 303
  { PseudoVFNCVT_RTZ_X_F_W_MF8_MASK, PseudoVFNCVT_RTZ_X_F_W_MF8, PseudoVFNCVT_RTZ_X_F_W_MF8_TU, 0x2 }, // 304
  { PseudoVFNCVT_XU_F_W_M1_MASK, PseudoVFNCVT_XU_F_W_M1, PseudoVFNCVT_XU_F_W_M1_TU, 0x2 }, // 305
  { PseudoVFNCVT_XU_F_W_M2_MASK, PseudoVFNCVT_XU_F_W_M2, PseudoVFNCVT_XU_F_W_M2_TU, 0x2 }, // 306
  { PseudoVFNCVT_XU_F_W_M4_MASK, PseudoVFNCVT_XU_F_W_M4, PseudoVFNCVT_XU_F_W_M4_TU, 0x2 }, // 307
  { PseudoVFNCVT_XU_F_W_MF2_MASK, PseudoVFNCVT_XU_F_W_MF2, PseudoVFNCVT_XU_F_W_MF2_TU, 0x2 }, // 308
  { PseudoVFNCVT_XU_F_W_MF4_MASK, PseudoVFNCVT_XU_F_W_MF4, PseudoVFNCVT_XU_F_W_MF4_TU, 0x2 }, // 309
  { PseudoVFNCVT_XU_F_W_MF8_MASK, PseudoVFNCVT_XU_F_W_MF8, PseudoVFNCVT_XU_F_W_MF8_TU, 0x2 }, // 310
  { PseudoVFNCVT_X_F_W_M1_MASK, PseudoVFNCVT_X_F_W_M1, PseudoVFNCVT_X_F_W_M1_TU, 0x2 }, // 311
  { PseudoVFNCVT_X_F_W_M2_MASK, PseudoVFNCVT_X_F_W_M2, PseudoVFNCVT_X_F_W_M2_TU, 0x2 }, // 312
  { PseudoVFNCVT_X_F_W_M4_MASK, PseudoVFNCVT_X_F_W_M4, PseudoVFNCVT_X_F_W_M4_TU, 0x2 }, // 313
  { PseudoVFNCVT_X_F_W_MF2_MASK, PseudoVFNCVT_X_F_W_MF2, PseudoVFNCVT_X_F_W_MF2_TU, 0x2 }, // 314
  { PseudoVFNCVT_X_F_W_MF4_MASK, PseudoVFNCVT_X_F_W_MF4, PseudoVFNCVT_X_F_W_MF4_TU, 0x2 }, // 315
  { PseudoVFNCVT_X_F_W_MF8_MASK, PseudoVFNCVT_X_F_W_MF8, PseudoVFNCVT_X_F_W_MF8_TU, 0x2 }, // 316
  { PseudoVFRDIV_VF16_M1_MASK, PseudoVFRDIV_VF16_M1, PseudoVFRDIV_VF16_M1_TU, 0x3 }, // 317
  { PseudoVFRDIV_VF16_M2_MASK, PseudoVFRDIV_VF16_M2, PseudoVFRDIV_VF16_M2_TU, 0x3 }, // 318
  { PseudoVFRDIV_VF16_M4_MASK, PseudoVFRDIV_VF16_M4, PseudoVFRDIV_VF16_M4_TU, 0x3 }, // 319
  { PseudoVFRDIV_VF16_M8_MASK, PseudoVFRDIV_VF16_M8, PseudoVFRDIV_VF16_M8_TU, 0x3 }, // 320
  { PseudoVFRDIV_VF16_MF2_MASK, PseudoVFRDIV_VF16_MF2, PseudoVFRDIV_VF16_MF2_TU, 0x3 }, // 321
  { PseudoVFRDIV_VF16_MF4_MASK, PseudoVFRDIV_VF16_MF4, PseudoVFRDIV_VF16_MF4_TU, 0x3 }, // 322
  { PseudoVFRDIV_VF32_M1_MASK, PseudoVFRDIV_VF32_M1, PseudoVFRDIV_VF32_M1_TU, 0x3 }, // 323
  { PseudoVFRDIV_VF32_M2_MASK, PseudoVFRDIV_VF32_M2, PseudoVFRDIV_VF32_M2_TU, 0x3 }, // 324
  { PseudoVFRDIV_VF32_M4_MASK, PseudoVFRDIV_VF32_M4, PseudoVFRDIV_VF32_M4_TU, 0x3 }, // 325
  { PseudoVFRDIV_VF32_M8_MASK, PseudoVFRDIV_VF32_M8, PseudoVFRDIV_VF32_M8_TU, 0x3 }, // 326
  { PseudoVFRDIV_VF32_MF2_MASK, PseudoVFRDIV_VF32_MF2, PseudoVFRDIV_VF32_MF2_TU, 0x3 }, // 327
  { PseudoVFRDIV_VF64_M1_MASK, PseudoVFRDIV_VF64_M1, PseudoVFRDIV_VF64_M1_TU, 0x3 }, // 328
  { PseudoVFRDIV_VF64_M2_MASK, PseudoVFRDIV_VF64_M2, PseudoVFRDIV_VF64_M2_TU, 0x3 }, // 329
  { PseudoVFRDIV_VF64_M4_MASK, PseudoVFRDIV_VF64_M4, PseudoVFRDIV_VF64_M4_TU, 0x3 }, // 330
  { PseudoVFRDIV_VF64_M8_MASK, PseudoVFRDIV_VF64_M8, PseudoVFRDIV_VF64_M8_TU, 0x3 }, // 331
  { PseudoVFREC7_V_M1_MASK, PseudoVFREC7_V_M1, PseudoVFREC7_V_M1_TU, 0x2 }, // 332
  { PseudoVFREC7_V_M2_MASK, PseudoVFREC7_V_M2, PseudoVFREC7_V_M2_TU, 0x2 }, // 333
  { PseudoVFREC7_V_M4_MASK, PseudoVFREC7_V_M4, PseudoVFREC7_V_M4_TU, 0x2 }, // 334
  { PseudoVFREC7_V_M8_MASK, PseudoVFREC7_V_M8, PseudoVFREC7_V_M8_TU, 0x2 }, // 335
  { PseudoVFREC7_V_MF2_MASK, PseudoVFREC7_V_MF2, PseudoVFREC7_V_MF2_TU, 0x2 }, // 336
  { PseudoVFREC7_V_MF4_MASK, PseudoVFREC7_V_MF4, PseudoVFREC7_V_MF4_TU, 0x2 }, // 337
  { PseudoVFRSQRT7_V_M1_MASK, PseudoVFRSQRT7_V_M1, PseudoVFRSQRT7_V_M1_TU, 0x2 }, // 338
  { PseudoVFRSQRT7_V_M2_MASK, PseudoVFRSQRT7_V_M2, PseudoVFRSQRT7_V_M2_TU, 0x2 }, // 339
  { PseudoVFRSQRT7_V_M4_MASK, PseudoVFRSQRT7_V_M4, PseudoVFRSQRT7_V_M4_TU, 0x2 }, // 340
  { PseudoVFRSQRT7_V_M8_MASK, PseudoVFRSQRT7_V_M8, PseudoVFRSQRT7_V_M8_TU, 0x2 }, // 341
  { PseudoVFRSQRT7_V_MF2_MASK, PseudoVFRSQRT7_V_MF2, PseudoVFRSQRT7_V_MF2_TU, 0x2 }, // 342
  { PseudoVFRSQRT7_V_MF4_MASK, PseudoVFRSQRT7_V_MF4, PseudoVFRSQRT7_V_MF4_TU, 0x2 }, // 343
  { PseudoVFRSUB_VF16_M1_MASK, PseudoVFRSUB_VF16_M1, PseudoVFRSUB_VF16_M1_TU, 0x3 }, // 344
  { PseudoVFRSUB_VF16_M2_MASK, PseudoVFRSUB_VF16_M2, PseudoVFRSUB_VF16_M2_TU, 0x3 }, // 345
  { PseudoVFRSUB_VF16_M4_MASK, PseudoVFRSUB_VF16_M4, PseudoVFRSUB_VF16_M4_TU, 0x3 }, // 346
  { PseudoVFRSUB_VF16_M8_MASK, PseudoVFRSUB_VF16_M8, PseudoVFRSUB_VF16_M8_TU, 0x3 }, // 347
  { PseudoVFRSUB_VF16_MF2_MASK, PseudoVFRSUB_VF16_MF2, PseudoVFRSUB_VF16_MF2_TU, 0x3 }, // 348
  { PseudoVFRSUB_VF16_MF4_MASK, PseudoVFRSUB_VF16_MF4, PseudoVFRSUB_VF16_MF4_TU, 0x3 }, // 349
  { PseudoVFRSUB_VF32_M1_MASK, PseudoVFRSUB_VF32_M1, PseudoVFRSUB_VF32_M1_TU, 0x3 }, // 350
  { PseudoVFRSUB_VF32_M2_MASK, PseudoVFRSUB_VF32_M2, PseudoVFRSUB_VF32_M2_TU, 0x3 }, // 351
  { PseudoVFRSUB_VF32_M4_MASK, PseudoVFRSUB_VF32_M4, PseudoVFRSUB_VF32_M4_TU, 0x3 }, // 352
  { PseudoVFRSUB_VF32_M8_MASK, PseudoVFRSUB_VF32_M8, PseudoVFRSUB_VF32_M8_TU, 0x3 }, // 353
  { PseudoVFRSUB_VF32_MF2_MASK, PseudoVFRSUB_VF32_MF2, PseudoVFRSUB_VF32_MF2_TU, 0x3 }, // 354
  { PseudoVFRSUB_VF64_M1_MASK, PseudoVFRSUB_VF64_M1, PseudoVFRSUB_VF64_M1_TU, 0x3 }, // 355
  { PseudoVFRSUB_VF64_M2_MASK, PseudoVFRSUB_VF64_M2, PseudoVFRSUB_VF64_M2_TU, 0x3 }, // 356
  { PseudoVFRSUB_VF64_M4_MASK, PseudoVFRSUB_VF64_M4, PseudoVFRSUB_VF64_M4_TU, 0x3 }, // 357
  { PseudoVFRSUB_VF64_M8_MASK, PseudoVFRSUB_VF64_M8, PseudoVFRSUB_VF64_M8_TU, 0x3 }, // 358
  { PseudoVFSGNJN_VF16_M1_MASK, PseudoVFSGNJN_VF16_M1, PseudoVFSGNJN_VF16_M1_TU, 0x3 }, // 359
  { PseudoVFSGNJN_VF16_M2_MASK, PseudoVFSGNJN_VF16_M2, PseudoVFSGNJN_VF16_M2_TU, 0x3 }, // 360
  { PseudoVFSGNJN_VF16_M4_MASK, PseudoVFSGNJN_VF16_M4, PseudoVFSGNJN_VF16_M4_TU, 0x3 }, // 361
  { PseudoVFSGNJN_VF16_M8_MASK, PseudoVFSGNJN_VF16_M8, PseudoVFSGNJN_VF16_M8_TU, 0x3 }, // 362
  { PseudoVFSGNJN_VF16_MF2_MASK, PseudoVFSGNJN_VF16_MF2, PseudoVFSGNJN_VF16_MF2_TU, 0x3 }, // 363
  { PseudoVFSGNJN_VF16_MF4_MASK, PseudoVFSGNJN_VF16_MF4, PseudoVFSGNJN_VF16_MF4_TU, 0x3 }, // 364
  { PseudoVFSGNJN_VF32_M1_MASK, PseudoVFSGNJN_VF32_M1, PseudoVFSGNJN_VF32_M1_TU, 0x3 }, // 365
  { PseudoVFSGNJN_VF32_M2_MASK, PseudoVFSGNJN_VF32_M2, PseudoVFSGNJN_VF32_M2_TU, 0x3 }, // 366
  { PseudoVFSGNJN_VF32_M4_MASK, PseudoVFSGNJN_VF32_M4, PseudoVFSGNJN_VF32_M4_TU, 0x3 }, // 367
  { PseudoVFSGNJN_VF32_M8_MASK, PseudoVFSGNJN_VF32_M8, PseudoVFSGNJN_VF32_M8_TU, 0x3 }, // 368
  { PseudoVFSGNJN_VF32_MF2_MASK, PseudoVFSGNJN_VF32_MF2, PseudoVFSGNJN_VF32_MF2_TU, 0x3 }, // 369
  { PseudoVFSGNJN_VF64_M1_MASK, PseudoVFSGNJN_VF64_M1, PseudoVFSGNJN_VF64_M1_TU, 0x3 }, // 370
  { PseudoVFSGNJN_VF64_M2_MASK, PseudoVFSGNJN_VF64_M2, PseudoVFSGNJN_VF64_M2_TU, 0x3 }, // 371
  { PseudoVFSGNJN_VF64_M4_MASK, PseudoVFSGNJN_VF64_M4, PseudoVFSGNJN_VF64_M4_TU, 0x3 }, // 372
  { PseudoVFSGNJN_VF64_M8_MASK, PseudoVFSGNJN_VF64_M8, PseudoVFSGNJN_VF64_M8_TU, 0x3 }, // 373
  { PseudoVFSGNJN_VV_M1_MASK, PseudoVFSGNJN_VV_M1, PseudoVFSGNJN_VV_M1_TU, 0x3 }, // 374
  { PseudoVFSGNJN_VV_M2_MASK, PseudoVFSGNJN_VV_M2, PseudoVFSGNJN_VV_M2_TU, 0x3 }, // 375
  { PseudoVFSGNJN_VV_M4_MASK, PseudoVFSGNJN_VV_M4, PseudoVFSGNJN_VV_M4_TU, 0x3 }, // 376
  { PseudoVFSGNJN_VV_M8_MASK, PseudoVFSGNJN_VV_M8, PseudoVFSGNJN_VV_M8_TU, 0x3 }, // 377
  { PseudoVFSGNJN_VV_MF2_MASK, PseudoVFSGNJN_VV_MF2, PseudoVFSGNJN_VV_MF2_TU, 0x3 }, // 378
  { PseudoVFSGNJN_VV_MF4_MASK, PseudoVFSGNJN_VV_MF4, PseudoVFSGNJN_VV_MF4_TU, 0x3 }, // 379
  { PseudoVFSGNJX_VF16_M1_MASK, PseudoVFSGNJX_VF16_M1, PseudoVFSGNJX_VF16_M1_TU, 0x3 }, // 380
  { PseudoVFSGNJX_VF16_M2_MASK, PseudoVFSGNJX_VF16_M2, PseudoVFSGNJX_VF16_M2_TU, 0x3 }, // 381
  { PseudoVFSGNJX_VF16_M4_MASK, PseudoVFSGNJX_VF16_M4, PseudoVFSGNJX_VF16_M4_TU, 0x3 }, // 382
  { PseudoVFSGNJX_VF16_M8_MASK, PseudoVFSGNJX_VF16_M8, PseudoVFSGNJX_VF16_M8_TU, 0x3 }, // 383
  { PseudoVFSGNJX_VF16_MF2_MASK, PseudoVFSGNJX_VF16_MF2, PseudoVFSGNJX_VF16_MF2_TU, 0x3 }, // 384
  { PseudoVFSGNJX_VF16_MF4_MASK, PseudoVFSGNJX_VF16_MF4, PseudoVFSGNJX_VF16_MF4_TU, 0x3 }, // 385
  { PseudoVFSGNJX_VF32_M1_MASK, PseudoVFSGNJX_VF32_M1, PseudoVFSGNJX_VF32_M1_TU, 0x3 }, // 386
  { PseudoVFSGNJX_VF32_M2_MASK, PseudoVFSGNJX_VF32_M2, PseudoVFSGNJX_VF32_M2_TU, 0x3 }, // 387
  { PseudoVFSGNJX_VF32_M4_MASK, PseudoVFSGNJX_VF32_M4, PseudoVFSGNJX_VF32_M4_TU, 0x3 }, // 388
  { PseudoVFSGNJX_VF32_M8_MASK, PseudoVFSGNJX_VF32_M8, PseudoVFSGNJX_VF32_M8_TU, 0x3 }, // 389
  { PseudoVFSGNJX_VF32_MF2_MASK, PseudoVFSGNJX_VF32_MF2, PseudoVFSGNJX_VF32_MF2_TU, 0x3 }, // 390
  { PseudoVFSGNJX_VF64_M1_MASK, PseudoVFSGNJX_VF64_M1, PseudoVFSGNJX_VF64_M1_TU, 0x3 }, // 391
  { PseudoVFSGNJX_VF64_M2_MASK, PseudoVFSGNJX_VF64_M2, PseudoVFSGNJX_VF64_M2_TU, 0x3 }, // 392
  { PseudoVFSGNJX_VF64_M4_MASK, PseudoVFSGNJX_VF64_M4, PseudoVFSGNJX_VF64_M4_TU, 0x3 }, // 393
  { PseudoVFSGNJX_VF64_M8_MASK, PseudoVFSGNJX_VF64_M8, PseudoVFSGNJX_VF64_M8_TU, 0x3 }, // 394
  { PseudoVFSGNJX_VV_M1_MASK, PseudoVFSGNJX_VV_M1, PseudoVFSGNJX_VV_M1_TU, 0x3 }, // 395
  { PseudoVFSGNJX_VV_M2_MASK, PseudoVFSGNJX_VV_M2, PseudoVFSGNJX_VV_M2_TU, 0x3 }, // 396
  { PseudoVFSGNJX_VV_M4_MASK, PseudoVFSGNJX_VV_M4, PseudoVFSGNJX_VV_M4_TU, 0x3 }, // 397
  { PseudoVFSGNJX_VV_M8_MASK, PseudoVFSGNJX_VV_M8, PseudoVFSGNJX_VV_M8_TU, 0x3 }, // 398
  { PseudoVFSGNJX_VV_MF2_MASK, PseudoVFSGNJX_VV_MF2, PseudoVFSGNJX_VV_MF2_TU, 0x3 }, // 399
  { PseudoVFSGNJX_VV_MF4_MASK, PseudoVFSGNJX_VV_MF4, PseudoVFSGNJX_VV_MF4_TU, 0x3 }, // 400
  { PseudoVFSGNJ_VF16_M1_MASK, PseudoVFSGNJ_VF16_M1, PseudoVFSGNJ_VF16_M1_TU, 0x3 }, // 401
  { PseudoVFSGNJ_VF16_M2_MASK, PseudoVFSGNJ_VF16_M2, PseudoVFSGNJ_VF16_M2_TU, 0x3 }, // 402
  { PseudoVFSGNJ_VF16_M4_MASK, PseudoVFSGNJ_VF16_M4, PseudoVFSGNJ_VF16_M4_TU, 0x3 }, // 403
  { PseudoVFSGNJ_VF16_M8_MASK, PseudoVFSGNJ_VF16_M8, PseudoVFSGNJ_VF16_M8_TU, 0x3 }, // 404
  { PseudoVFSGNJ_VF16_MF2_MASK, PseudoVFSGNJ_VF16_MF2, PseudoVFSGNJ_VF16_MF2_TU, 0x3 }, // 405
  { PseudoVFSGNJ_VF16_MF4_MASK, PseudoVFSGNJ_VF16_MF4, PseudoVFSGNJ_VF16_MF4_TU, 0x3 }, // 406
  { PseudoVFSGNJ_VF32_M1_MASK, PseudoVFSGNJ_VF32_M1, PseudoVFSGNJ_VF32_M1_TU, 0x3 }, // 407
  { PseudoVFSGNJ_VF32_M2_MASK, PseudoVFSGNJ_VF32_M2, PseudoVFSGNJ_VF32_M2_TU, 0x3 }, // 408
  { PseudoVFSGNJ_VF32_M4_MASK, PseudoVFSGNJ_VF32_M4, PseudoVFSGNJ_VF32_M4_TU, 0x3 }, // 409
  { PseudoVFSGNJ_VF32_M8_MASK, PseudoVFSGNJ_VF32_M8, PseudoVFSGNJ_VF32_M8_TU, 0x3 }, // 410
  { PseudoVFSGNJ_VF32_MF2_MASK, PseudoVFSGNJ_VF32_MF2, PseudoVFSGNJ_VF32_MF2_TU, 0x3 }, // 411
  { PseudoVFSGNJ_VF64_M1_MASK, PseudoVFSGNJ_VF64_M1, PseudoVFSGNJ_VF64_M1_TU, 0x3 }, // 412
  { PseudoVFSGNJ_VF64_M2_MASK, PseudoVFSGNJ_VF64_M2, PseudoVFSGNJ_VF64_M2_TU, 0x3 }, // 413
  { PseudoVFSGNJ_VF64_M4_MASK, PseudoVFSGNJ_VF64_M4, PseudoVFSGNJ_VF64_M4_TU, 0x3 }, // 414
  { PseudoVFSGNJ_VF64_M8_MASK, PseudoVFSGNJ_VF64_M8, PseudoVFSGNJ_VF64_M8_TU, 0x3 }, // 415
  { PseudoVFSGNJ_VV_M1_MASK, PseudoVFSGNJ_VV_M1, PseudoVFSGNJ_VV_M1_TU, 0x3 }, // 416
  { PseudoVFSGNJ_VV_M2_MASK, PseudoVFSGNJ_VV_M2, PseudoVFSGNJ_VV_M2_TU, 0x3 }, // 417
  { PseudoVFSGNJ_VV_M4_MASK, PseudoVFSGNJ_VV_M4, PseudoVFSGNJ_VV_M4_TU, 0x3 }, // 418
  { PseudoVFSGNJ_VV_M8_MASK, PseudoVFSGNJ_VV_M8, PseudoVFSGNJ_VV_M8_TU, 0x3 }, // 419
  { PseudoVFSGNJ_VV_MF2_MASK, PseudoVFSGNJ_VV_MF2, PseudoVFSGNJ_VV_MF2_TU, 0x3 }, // 420
  { PseudoVFSGNJ_VV_MF4_MASK, PseudoVFSGNJ_VV_MF4, PseudoVFSGNJ_VV_MF4_TU, 0x3 }, // 421
  { PseudoVFSLIDE1DOWN_VF16_M1_MASK, PseudoVFSLIDE1DOWN_VF16_M1, PseudoVFSLIDE1DOWN_VF16_M1_TU, 0x3 }, // 422
  { PseudoVFSLIDE1DOWN_VF16_M2_MASK, PseudoVFSLIDE1DOWN_VF16_M2, PseudoVFSLIDE1DOWN_VF16_M2_TU, 0x3 }, // 423
  { PseudoVFSLIDE1DOWN_VF16_M4_MASK, PseudoVFSLIDE1DOWN_VF16_M4, PseudoVFSLIDE1DOWN_VF16_M4_TU, 0x3 }, // 424
  { PseudoVFSLIDE1DOWN_VF16_M8_MASK, PseudoVFSLIDE1DOWN_VF16_M8, PseudoVFSLIDE1DOWN_VF16_M8_TU, 0x3 }, // 425
  { PseudoVFSLIDE1DOWN_VF16_MF2_MASK, PseudoVFSLIDE1DOWN_VF16_MF2, PseudoVFSLIDE1DOWN_VF16_MF2_TU, 0x3 }, // 426
  { PseudoVFSLIDE1DOWN_VF16_MF4_MASK, PseudoVFSLIDE1DOWN_VF16_MF4, PseudoVFSLIDE1DOWN_VF16_MF4_TU, 0x3 }, // 427
  { PseudoVFSLIDE1DOWN_VF32_M1_MASK, PseudoVFSLIDE1DOWN_VF32_M1, PseudoVFSLIDE1DOWN_VF32_M1_TU, 0x3 }, // 428
  { PseudoVFSLIDE1DOWN_VF32_M2_MASK, PseudoVFSLIDE1DOWN_VF32_M2, PseudoVFSLIDE1DOWN_VF32_M2_TU, 0x3 }, // 429
  { PseudoVFSLIDE1DOWN_VF32_M4_MASK, PseudoVFSLIDE1DOWN_VF32_M4, PseudoVFSLIDE1DOWN_VF32_M4_TU, 0x3 }, // 430
  { PseudoVFSLIDE1DOWN_VF32_M8_MASK, PseudoVFSLIDE1DOWN_VF32_M8, PseudoVFSLIDE1DOWN_VF32_M8_TU, 0x3 }, // 431
  { PseudoVFSLIDE1DOWN_VF32_MF2_MASK, PseudoVFSLIDE1DOWN_VF32_MF2, PseudoVFSLIDE1DOWN_VF32_MF2_TU, 0x3 }, // 432
  { PseudoVFSLIDE1DOWN_VF64_M1_MASK, PseudoVFSLIDE1DOWN_VF64_M1, PseudoVFSLIDE1DOWN_VF64_M1_TU, 0x3 }, // 433
  { PseudoVFSLIDE1DOWN_VF64_M2_MASK, PseudoVFSLIDE1DOWN_VF64_M2, PseudoVFSLIDE1DOWN_VF64_M2_TU, 0x3 }, // 434
  { PseudoVFSLIDE1DOWN_VF64_M4_MASK, PseudoVFSLIDE1DOWN_VF64_M4, PseudoVFSLIDE1DOWN_VF64_M4_TU, 0x3 }, // 435
  { PseudoVFSLIDE1DOWN_VF64_M8_MASK, PseudoVFSLIDE1DOWN_VF64_M8, PseudoVFSLIDE1DOWN_VF64_M8_TU, 0x3 }, // 436
  { PseudoVFSLIDE1UP_VF16_M1_MASK, PseudoVFSLIDE1UP_VF16_M1, PseudoVFSLIDE1UP_VF16_M1_TU, 0x3 }, // 437
  { PseudoVFSLIDE1UP_VF16_M2_MASK, PseudoVFSLIDE1UP_VF16_M2, PseudoVFSLIDE1UP_VF16_M2_TU, 0x3 }, // 438
  { PseudoVFSLIDE1UP_VF16_M4_MASK, PseudoVFSLIDE1UP_VF16_M4, PseudoVFSLIDE1UP_VF16_M4_TU, 0x3 }, // 439
  { PseudoVFSLIDE1UP_VF16_M8_MASK, PseudoVFSLIDE1UP_VF16_M8, PseudoVFSLIDE1UP_VF16_M8_TU, 0x3 }, // 440
  { PseudoVFSLIDE1UP_VF16_MF2_MASK, PseudoVFSLIDE1UP_VF16_MF2, PseudoVFSLIDE1UP_VF16_MF2_TU, 0x3 }, // 441
  { PseudoVFSLIDE1UP_VF16_MF4_MASK, PseudoVFSLIDE1UP_VF16_MF4, PseudoVFSLIDE1UP_VF16_MF4_TU, 0x3 }, // 442
  { PseudoVFSLIDE1UP_VF32_M1_MASK, PseudoVFSLIDE1UP_VF32_M1, PseudoVFSLIDE1UP_VF32_M1_TU, 0x3 }, // 443
  { PseudoVFSLIDE1UP_VF32_M2_MASK, PseudoVFSLIDE1UP_VF32_M2, PseudoVFSLIDE1UP_VF32_M2_TU, 0x3 }, // 444
  { PseudoVFSLIDE1UP_VF32_M4_MASK, PseudoVFSLIDE1UP_VF32_M4, PseudoVFSLIDE1UP_VF32_M4_TU, 0x3 }, // 445
  { PseudoVFSLIDE1UP_VF32_M8_MASK, PseudoVFSLIDE1UP_VF32_M8, PseudoVFSLIDE1UP_VF32_M8_TU, 0x3 }, // 446
  { PseudoVFSLIDE1UP_VF32_MF2_MASK, PseudoVFSLIDE1UP_VF32_MF2, PseudoVFSLIDE1UP_VF32_MF2_TU, 0x3 }, // 447
  { PseudoVFSLIDE1UP_VF64_M1_MASK, PseudoVFSLIDE1UP_VF64_M1, PseudoVFSLIDE1UP_VF64_M1_TU, 0x3 }, // 448
  { PseudoVFSLIDE1UP_VF64_M2_MASK, PseudoVFSLIDE1UP_VF64_M2, PseudoVFSLIDE1UP_VF64_M2_TU, 0x3 }, // 449
  { PseudoVFSLIDE1UP_VF64_M4_MASK, PseudoVFSLIDE1UP_VF64_M4, PseudoVFSLIDE1UP_VF64_M4_TU, 0x3 }, // 450
  { PseudoVFSLIDE1UP_VF64_M8_MASK, PseudoVFSLIDE1UP_VF64_M8, PseudoVFSLIDE1UP_VF64_M8_TU, 0x3 }, // 451
  { PseudoVFSQRT_V_M1_MASK, PseudoVFSQRT_V_M1, PseudoVFSQRT_V_M1_TU, 0x2 }, // 452
  { PseudoVFSQRT_V_M2_MASK, PseudoVFSQRT_V_M2, PseudoVFSQRT_V_M2_TU, 0x2 }, // 453
  { PseudoVFSQRT_V_M4_MASK, PseudoVFSQRT_V_M4, PseudoVFSQRT_V_M4_TU, 0x2 }, // 454
  { PseudoVFSQRT_V_M8_MASK, PseudoVFSQRT_V_M8, PseudoVFSQRT_V_M8_TU, 0x2 }, // 455
  { PseudoVFSQRT_V_MF2_MASK, PseudoVFSQRT_V_MF2, PseudoVFSQRT_V_MF2_TU, 0x2 }, // 456
  { PseudoVFSQRT_V_MF4_MASK, PseudoVFSQRT_V_MF4, PseudoVFSQRT_V_MF4_TU, 0x2 }, // 457
  { PseudoVFSUB_VF16_M1_MASK, PseudoVFSUB_VF16_M1, PseudoVFSUB_VF16_M1_TU, 0x3 }, // 458
  { PseudoVFSUB_VF16_M2_MASK, PseudoVFSUB_VF16_M2, PseudoVFSUB_VF16_M2_TU, 0x3 }, // 459
  { PseudoVFSUB_VF16_M4_MASK, PseudoVFSUB_VF16_M4, PseudoVFSUB_VF16_M4_TU, 0x3 }, // 460
  { PseudoVFSUB_VF16_M8_MASK, PseudoVFSUB_VF16_M8, PseudoVFSUB_VF16_M8_TU, 0x3 }, // 461
  { PseudoVFSUB_VF16_MF2_MASK, PseudoVFSUB_VF16_MF2, PseudoVFSUB_VF16_MF2_TU, 0x3 }, // 462
  { PseudoVFSUB_VF16_MF4_MASK, PseudoVFSUB_VF16_MF4, PseudoVFSUB_VF16_MF4_TU, 0x3 }, // 463
  { PseudoVFSUB_VF32_M1_MASK, PseudoVFSUB_VF32_M1, PseudoVFSUB_VF32_M1_TU, 0x3 }, // 464
  { PseudoVFSUB_VF32_M2_MASK, PseudoVFSUB_VF32_M2, PseudoVFSUB_VF32_M2_TU, 0x3 }, // 465
  { PseudoVFSUB_VF32_M4_MASK, PseudoVFSUB_VF32_M4, PseudoVFSUB_VF32_M4_TU, 0x3 }, // 466
  { PseudoVFSUB_VF32_M8_MASK, PseudoVFSUB_VF32_M8, PseudoVFSUB_VF32_M8_TU, 0x3 }, // 467
  { PseudoVFSUB_VF32_MF2_MASK, PseudoVFSUB_VF32_MF2, PseudoVFSUB_VF32_MF2_TU, 0x3 }, // 468
  { PseudoVFSUB_VF64_M1_MASK, PseudoVFSUB_VF64_M1, PseudoVFSUB_VF64_M1_TU, 0x3 }, // 469
  { PseudoVFSUB_VF64_M2_MASK, PseudoVFSUB_VF64_M2, PseudoVFSUB_VF64_M2_TU, 0x3 }, // 470
  { PseudoVFSUB_VF64_M4_MASK, PseudoVFSUB_VF64_M4, PseudoVFSUB_VF64_M4_TU, 0x3 }, // 471
  { PseudoVFSUB_VF64_M8_MASK, PseudoVFSUB_VF64_M8, PseudoVFSUB_VF64_M8_TU, 0x3 }, // 472
  { PseudoVFSUB_VV_M1_MASK, PseudoVFSUB_VV_M1, PseudoVFSUB_VV_M1_TU, 0x3 }, // 473
  { PseudoVFSUB_VV_M2_MASK, PseudoVFSUB_VV_M2, PseudoVFSUB_VV_M2_TU, 0x3 }, // 474
  { PseudoVFSUB_VV_M4_MASK, PseudoVFSUB_VV_M4, PseudoVFSUB_VV_M4_TU, 0x3 }, // 475
  { PseudoVFSUB_VV_M8_MASK, PseudoVFSUB_VV_M8, PseudoVFSUB_VV_M8_TU, 0x3 }, // 476
  { PseudoVFSUB_VV_MF2_MASK, PseudoVFSUB_VV_MF2, PseudoVFSUB_VV_MF2_TU, 0x3 }, // 477
  { PseudoVFSUB_VV_MF4_MASK, PseudoVFSUB_VV_MF4, PseudoVFSUB_VV_MF4_TU, 0x3 }, // 478
  { PseudoVFWADD_VF16_M1_MASK, PseudoVFWADD_VF16_M1, PseudoVFWADD_VF16_M1_TU, 0x3 }, // 479
  { PseudoVFWADD_VF16_M2_MASK, PseudoVFWADD_VF16_M2, PseudoVFWADD_VF16_M2_TU, 0x3 }, // 480
  { PseudoVFWADD_VF16_M4_MASK, PseudoVFWADD_VF16_M4, PseudoVFWADD_VF16_M4_TU, 0x3 }, // 481
  { PseudoVFWADD_VF16_MF2_MASK, PseudoVFWADD_VF16_MF2, PseudoVFWADD_VF16_MF2_TU, 0x3 }, // 482
  { PseudoVFWADD_VF16_MF4_MASK, PseudoVFWADD_VF16_MF4, PseudoVFWADD_VF16_MF4_TU, 0x3 }, // 483
  { PseudoVFWADD_VF32_M1_MASK, PseudoVFWADD_VF32_M1, PseudoVFWADD_VF32_M1_TU, 0x3 }, // 484
  { PseudoVFWADD_VF32_M2_MASK, PseudoVFWADD_VF32_M2, PseudoVFWADD_VF32_M2_TU, 0x3 }, // 485
  { PseudoVFWADD_VF32_M4_MASK, PseudoVFWADD_VF32_M4, PseudoVFWADD_VF32_M4_TU, 0x3 }, // 486
  { PseudoVFWADD_VF32_MF2_MASK, PseudoVFWADD_VF32_MF2, PseudoVFWADD_VF32_MF2_TU, 0x3 }, // 487
  { PseudoVFWADD_VV_M1_MASK, PseudoVFWADD_VV_M1, PseudoVFWADD_VV_M1_TU, 0x3 }, // 488
  { PseudoVFWADD_VV_M2_MASK, PseudoVFWADD_VV_M2, PseudoVFWADD_VV_M2_TU, 0x3 }, // 489
  { PseudoVFWADD_VV_M4_MASK, PseudoVFWADD_VV_M4, PseudoVFWADD_VV_M4_TU, 0x3 }, // 490
  { PseudoVFWADD_VV_MF2_MASK, PseudoVFWADD_VV_MF2, PseudoVFWADD_VV_MF2_TU, 0x3 }, // 491
  { PseudoVFWADD_VV_MF4_MASK, PseudoVFWADD_VV_MF4, PseudoVFWADD_VV_MF4_TU, 0x3 }, // 492
  { PseudoVFWADD_WF16_M1_MASK, PseudoVFWADD_WF16_M1, PseudoVFWADD_WF16_M1_TU, 0x3 }, // 493
  { PseudoVFWADD_WF16_M2_MASK, PseudoVFWADD_WF16_M2, PseudoVFWADD_WF16_M2_TU, 0x3 }, // 494
  { PseudoVFWADD_WF16_M4_MASK, PseudoVFWADD_WF16_M4, PseudoVFWADD_WF16_M4_TU, 0x3 }, // 495
  { PseudoVFWADD_WF16_MF2_MASK, PseudoVFWADD_WF16_MF2, PseudoVFWADD_WF16_MF2_TU, 0x3 }, // 496
  { PseudoVFWADD_WF16_MF4_MASK, PseudoVFWADD_WF16_MF4, PseudoVFWADD_WF16_MF4_TU, 0x3 }, // 497
  { PseudoVFWADD_WF32_M1_MASK, PseudoVFWADD_WF32_M1, PseudoVFWADD_WF32_M1_TU, 0x3 }, // 498
  { PseudoVFWADD_WF32_M2_MASK, PseudoVFWADD_WF32_M2, PseudoVFWADD_WF32_M2_TU, 0x3 }, // 499
  { PseudoVFWADD_WF32_M4_MASK, PseudoVFWADD_WF32_M4, PseudoVFWADD_WF32_M4_TU, 0x3 }, // 500
  { PseudoVFWADD_WF32_MF2_MASK, PseudoVFWADD_WF32_MF2, PseudoVFWADD_WF32_MF2_TU, 0x3 }, // 501
  { PseudoVFWADD_WV_M1_MASK, PseudoVFWADD_WV_M1, PseudoVFWADD_WV_M1_TU, 0x3 }, // 502
  { PseudoVFWADD_WV_M2_MASK, PseudoVFWADD_WV_M2, PseudoVFWADD_WV_M2_TU, 0x3 }, // 503
  { PseudoVFWADD_WV_M4_MASK, PseudoVFWADD_WV_M4, PseudoVFWADD_WV_M4_TU, 0x3 }, // 504
  { PseudoVFWADD_WV_MF2_MASK, PseudoVFWADD_WV_MF2, PseudoVFWADD_WV_MF2_TU, 0x3 }, // 505
  { PseudoVFWADD_WV_MF4_MASK, PseudoVFWADD_WV_MF4, PseudoVFWADD_WV_MF4_TU, 0x3 }, // 506
  { PseudoVFWCVT_F_F_V_M1_MASK, PseudoVFWCVT_F_F_V_M1, PseudoVFWCVT_F_F_V_M1_TU, 0x2 }, // 507
  { PseudoVFWCVT_F_F_V_M2_MASK, PseudoVFWCVT_F_F_V_M2, PseudoVFWCVT_F_F_V_M2_TU, 0x2 }, // 508
  { PseudoVFWCVT_F_F_V_M4_MASK, PseudoVFWCVT_F_F_V_M4, PseudoVFWCVT_F_F_V_M4_TU, 0x2 }, // 509
  { PseudoVFWCVT_F_F_V_MF2_MASK, PseudoVFWCVT_F_F_V_MF2, PseudoVFWCVT_F_F_V_MF2_TU, 0x2 }, // 510
  { PseudoVFWCVT_F_F_V_MF4_MASK, PseudoVFWCVT_F_F_V_MF4, PseudoVFWCVT_F_F_V_MF4_TU, 0x2 }, // 511
  { PseudoVFWCVT_F_XU_V_M1_MASK, PseudoVFWCVT_F_XU_V_M1, PseudoVFWCVT_F_XU_V_M1_TU, 0x2 }, // 512
  { PseudoVFWCVT_F_XU_V_M2_MASK, PseudoVFWCVT_F_XU_V_M2, PseudoVFWCVT_F_XU_V_M2_TU, 0x2 }, // 513
  { PseudoVFWCVT_F_XU_V_M4_MASK, PseudoVFWCVT_F_XU_V_M4, PseudoVFWCVT_F_XU_V_M4_TU, 0x2 }, // 514
  { PseudoVFWCVT_F_XU_V_MF2_MASK, PseudoVFWCVT_F_XU_V_MF2, PseudoVFWCVT_F_XU_V_MF2_TU, 0x2 }, // 515
  { PseudoVFWCVT_F_XU_V_MF4_MASK, PseudoVFWCVT_F_XU_V_MF4, PseudoVFWCVT_F_XU_V_MF4_TU, 0x2 }, // 516
  { PseudoVFWCVT_F_XU_V_MF8_MASK, PseudoVFWCVT_F_XU_V_MF8, PseudoVFWCVT_F_XU_V_MF8_TU, 0x2 }, // 517
  { PseudoVFWCVT_F_X_V_M1_MASK, PseudoVFWCVT_F_X_V_M1, PseudoVFWCVT_F_X_V_M1_TU, 0x2 }, // 518
  { PseudoVFWCVT_F_X_V_M2_MASK, PseudoVFWCVT_F_X_V_M2, PseudoVFWCVT_F_X_V_M2_TU, 0x2 }, // 519
  { PseudoVFWCVT_F_X_V_M4_MASK, PseudoVFWCVT_F_X_V_M4, PseudoVFWCVT_F_X_V_M4_TU, 0x2 }, // 520
  { PseudoVFWCVT_F_X_V_MF2_MASK, PseudoVFWCVT_F_X_V_MF2, PseudoVFWCVT_F_X_V_MF2_TU, 0x2 }, // 521
  { PseudoVFWCVT_F_X_V_MF4_MASK, PseudoVFWCVT_F_X_V_MF4, PseudoVFWCVT_F_X_V_MF4_TU, 0x2 }, // 522
  { PseudoVFWCVT_F_X_V_MF8_MASK, PseudoVFWCVT_F_X_V_MF8, PseudoVFWCVT_F_X_V_MF8_TU, 0x2 }, // 523
  { PseudoVFWCVT_RTZ_XU_F_V_M1_MASK, PseudoVFWCVT_RTZ_XU_F_V_M1, PseudoVFWCVT_RTZ_XU_F_V_M1_TU, 0x2 }, // 524
  { PseudoVFWCVT_RTZ_XU_F_V_M2_MASK, PseudoVFWCVT_RTZ_XU_F_V_M2, PseudoVFWCVT_RTZ_XU_F_V_M2_TU, 0x2 }, // 525
  { PseudoVFWCVT_RTZ_XU_F_V_M4_MASK, PseudoVFWCVT_RTZ_XU_F_V_M4, PseudoVFWCVT_RTZ_XU_F_V_M4_TU, 0x2 }, // 526
  { PseudoVFWCVT_RTZ_XU_F_V_MF2_MASK, PseudoVFWCVT_RTZ_XU_F_V_MF2, PseudoVFWCVT_RTZ_XU_F_V_MF2_TU, 0x2 }, // 527
  { PseudoVFWCVT_RTZ_XU_F_V_MF4_MASK, PseudoVFWCVT_RTZ_XU_F_V_MF4, PseudoVFWCVT_RTZ_XU_F_V_MF4_TU, 0x2 }, // 528
  { PseudoVFWCVT_RTZ_X_F_V_M1_MASK, PseudoVFWCVT_RTZ_X_F_V_M1, PseudoVFWCVT_RTZ_X_F_V_M1_TU, 0x2 }, // 529
  { PseudoVFWCVT_RTZ_X_F_V_M2_MASK, PseudoVFWCVT_RTZ_X_F_V_M2, PseudoVFWCVT_RTZ_X_F_V_M2_TU, 0x2 }, // 530
  { PseudoVFWCVT_RTZ_X_F_V_M4_MASK, PseudoVFWCVT_RTZ_X_F_V_M4, PseudoVFWCVT_RTZ_X_F_V_M4_TU, 0x2 }, // 531
  { PseudoVFWCVT_RTZ_X_F_V_MF2_MASK, PseudoVFWCVT_RTZ_X_F_V_MF2, PseudoVFWCVT_RTZ_X_F_V_MF2_TU, 0x2 }, // 532
  { PseudoVFWCVT_RTZ_X_F_V_MF4_MASK, PseudoVFWCVT_RTZ_X_F_V_MF4, PseudoVFWCVT_RTZ_X_F_V_MF4_TU, 0x2 }, // 533
  { PseudoVFWCVT_XU_F_V_M1_MASK, PseudoVFWCVT_XU_F_V_M1, PseudoVFWCVT_XU_F_V_M1_TU, 0x2 }, // 534
  { PseudoVFWCVT_XU_F_V_M2_MASK, PseudoVFWCVT_XU_F_V_M2, PseudoVFWCVT_XU_F_V_M2_TU, 0x2 }, // 535
  { PseudoVFWCVT_XU_F_V_M4_MASK, PseudoVFWCVT_XU_F_V_M4, PseudoVFWCVT_XU_F_V_M4_TU, 0x2 }, // 536
  { PseudoVFWCVT_XU_F_V_MF2_MASK, PseudoVFWCVT_XU_F_V_MF2, PseudoVFWCVT_XU_F_V_MF2_TU, 0x2 }, // 537
  { PseudoVFWCVT_XU_F_V_MF4_MASK, PseudoVFWCVT_XU_F_V_MF4, PseudoVFWCVT_XU_F_V_MF4_TU, 0x2 }, // 538
  { PseudoVFWCVT_X_F_V_M1_MASK, PseudoVFWCVT_X_F_V_M1, PseudoVFWCVT_X_F_V_M1_TU, 0x2 }, // 539
  { PseudoVFWCVT_X_F_V_M2_MASK, PseudoVFWCVT_X_F_V_M2, PseudoVFWCVT_X_F_V_M2_TU, 0x2 }, // 540
  { PseudoVFWCVT_X_F_V_M4_MASK, PseudoVFWCVT_X_F_V_M4, PseudoVFWCVT_X_F_V_M4_TU, 0x2 }, // 541
  { PseudoVFWCVT_X_F_V_MF2_MASK, PseudoVFWCVT_X_F_V_MF2, PseudoVFWCVT_X_F_V_MF2_TU, 0x2 }, // 542
  { PseudoVFWCVT_X_F_V_MF4_MASK, PseudoVFWCVT_X_F_V_MF4, PseudoVFWCVT_X_F_V_MF4_TU, 0x2 }, // 543
  { PseudoVFWMUL_VF16_M1_MASK, PseudoVFWMUL_VF16_M1, PseudoVFWMUL_VF16_M1_TU, 0x3 }, // 544
  { PseudoVFWMUL_VF16_M2_MASK, PseudoVFWMUL_VF16_M2, PseudoVFWMUL_VF16_M2_TU, 0x3 }, // 545
  { PseudoVFWMUL_VF16_M4_MASK, PseudoVFWMUL_VF16_M4, PseudoVFWMUL_VF16_M4_TU, 0x3 }, // 546
  { PseudoVFWMUL_VF16_MF2_MASK, PseudoVFWMUL_VF16_MF2, PseudoVFWMUL_VF16_MF2_TU, 0x3 }, // 547
  { PseudoVFWMUL_VF16_MF4_MASK, PseudoVFWMUL_VF16_MF4, PseudoVFWMUL_VF16_MF4_TU, 0x3 }, // 548
  { PseudoVFWMUL_VF32_M1_MASK, PseudoVFWMUL_VF32_M1, PseudoVFWMUL_VF32_M1_TU, 0x3 }, // 549
  { PseudoVFWMUL_VF32_M2_MASK, PseudoVFWMUL_VF32_M2, PseudoVFWMUL_VF32_M2_TU, 0x3 }, // 550
  { PseudoVFWMUL_VF32_M4_MASK, PseudoVFWMUL_VF32_M4, PseudoVFWMUL_VF32_M4_TU, 0x3 }, // 551
  { PseudoVFWMUL_VF32_MF2_MASK, PseudoVFWMUL_VF32_MF2, PseudoVFWMUL_VF32_MF2_TU, 0x3 }, // 552
  { PseudoVFWMUL_VV_M1_MASK, PseudoVFWMUL_VV_M1, PseudoVFWMUL_VV_M1_TU, 0x3 }, // 553
  { PseudoVFWMUL_VV_M2_MASK, PseudoVFWMUL_VV_M2, PseudoVFWMUL_VV_M2_TU, 0x3 }, // 554
  { PseudoVFWMUL_VV_M4_MASK, PseudoVFWMUL_VV_M4, PseudoVFWMUL_VV_M4_TU, 0x3 }, // 555
  { PseudoVFWMUL_VV_MF2_MASK, PseudoVFWMUL_VV_MF2, PseudoVFWMUL_VV_MF2_TU, 0x3 }, // 556
  { PseudoVFWMUL_VV_MF4_MASK, PseudoVFWMUL_VV_MF4, PseudoVFWMUL_VV_MF4_TU, 0x3 }, // 557
  { PseudoVFWSUB_VF16_M1_MASK, PseudoVFWSUB_VF16_M1, PseudoVFWSUB_VF16_M1_TU, 0x3 }, // 558
  { PseudoVFWSUB_VF16_M2_MASK, PseudoVFWSUB_VF16_M2, PseudoVFWSUB_VF16_M2_TU, 0x3 }, // 559
  { PseudoVFWSUB_VF16_M4_MASK, PseudoVFWSUB_VF16_M4, PseudoVFWSUB_VF16_M4_TU, 0x3 }, // 560
  { PseudoVFWSUB_VF16_MF2_MASK, PseudoVFWSUB_VF16_MF2, PseudoVFWSUB_VF16_MF2_TU, 0x3 }, // 561
  { PseudoVFWSUB_VF16_MF4_MASK, PseudoVFWSUB_VF16_MF4, PseudoVFWSUB_VF16_MF4_TU, 0x3 }, // 562
  { PseudoVFWSUB_VF32_M1_MASK, PseudoVFWSUB_VF32_M1, PseudoVFWSUB_VF32_M1_TU, 0x3 }, // 563
  { PseudoVFWSUB_VF32_M2_MASK, PseudoVFWSUB_VF32_M2, PseudoVFWSUB_VF32_M2_TU, 0x3 }, // 564
  { PseudoVFWSUB_VF32_M4_MASK, PseudoVFWSUB_VF32_M4, PseudoVFWSUB_VF32_M4_TU, 0x3 }, // 565
  { PseudoVFWSUB_VF32_MF2_MASK, PseudoVFWSUB_VF32_MF2, PseudoVFWSUB_VF32_MF2_TU, 0x3 }, // 566
  { PseudoVFWSUB_VV_M1_MASK, PseudoVFWSUB_VV_M1, PseudoVFWSUB_VV_M1_TU, 0x3 }, // 567
  { PseudoVFWSUB_VV_M2_MASK, PseudoVFWSUB_VV_M2, PseudoVFWSUB_VV_M2_TU, 0x3 }, // 568
  { PseudoVFWSUB_VV_M4_MASK, PseudoVFWSUB_VV_M4, PseudoVFWSUB_VV_M4_TU, 0x3 }, // 569
  { PseudoVFWSUB_VV_MF2_MASK, PseudoVFWSUB_VV_MF2, PseudoVFWSUB_VV_MF2_TU, 0x3 }, // 570
  { PseudoVFWSUB_VV_MF4_MASK, PseudoVFWSUB_VV_MF4, PseudoVFWSUB_VV_MF4_TU, 0x3 }, // 571
  { PseudoVFWSUB_WF16_M1_MASK, PseudoVFWSUB_WF16_M1, PseudoVFWSUB_WF16_M1_TU, 0x3 }, // 572
  { PseudoVFWSUB_WF16_M2_MASK, PseudoVFWSUB_WF16_M2, PseudoVFWSUB_WF16_M2_TU, 0x3 }, // 573
  { PseudoVFWSUB_WF16_M4_MASK, PseudoVFWSUB_WF16_M4, PseudoVFWSUB_WF16_M4_TU, 0x3 }, // 574
  { PseudoVFWSUB_WF16_MF2_MASK, PseudoVFWSUB_WF16_MF2, PseudoVFWSUB_WF16_MF2_TU, 0x3 }, // 575
  { PseudoVFWSUB_WF16_MF4_MASK, PseudoVFWSUB_WF16_MF4, PseudoVFWSUB_WF16_MF4_TU, 0x3 }, // 576
  { PseudoVFWSUB_WF32_M1_MASK, PseudoVFWSUB_WF32_M1, PseudoVFWSUB_WF32_M1_TU, 0x3 }, // 577
  { PseudoVFWSUB_WF32_M2_MASK, PseudoVFWSUB_WF32_M2, PseudoVFWSUB_WF32_M2_TU, 0x3 }, // 578
  { PseudoVFWSUB_WF32_M4_MASK, PseudoVFWSUB_WF32_M4, PseudoVFWSUB_WF32_M4_TU, 0x3 }, // 579
  { PseudoVFWSUB_WF32_MF2_MASK, PseudoVFWSUB_WF32_MF2, PseudoVFWSUB_WF32_MF2_TU, 0x3 }, // 580
  { PseudoVFWSUB_WV_M1_MASK, PseudoVFWSUB_WV_M1, PseudoVFWSUB_WV_M1_TU, 0x3 }, // 581
  { PseudoVFWSUB_WV_M2_MASK, PseudoVFWSUB_WV_M2, PseudoVFWSUB_WV_M2_TU, 0x3 }, // 582
  { PseudoVFWSUB_WV_M4_MASK, PseudoVFWSUB_WV_M4, PseudoVFWSUB_WV_M4_TU, 0x3 }, // 583
  { PseudoVFWSUB_WV_MF2_MASK, PseudoVFWSUB_WV_MF2, PseudoVFWSUB_WV_MF2_TU, 0x3 }, // 584
  { PseudoVFWSUB_WV_MF4_MASK, PseudoVFWSUB_WV_MF4, PseudoVFWSUB_WV_MF4_TU, 0x3 }, // 585
  { PseudoVID_V_M1_MASK, PseudoVID_V_M1, PseudoVID_V_M1_TU, 0x1 }, // 586
  { PseudoVID_V_M2_MASK, PseudoVID_V_M2, PseudoVID_V_M2_TU, 0x1 }, // 587
  { PseudoVID_V_M4_MASK, PseudoVID_V_M4, PseudoVID_V_M4_TU, 0x1 }, // 588
  { PseudoVID_V_M8_MASK, PseudoVID_V_M8, PseudoVID_V_M8_TU, 0x1 }, // 589
  { PseudoVID_V_MF2_MASK, PseudoVID_V_MF2, PseudoVID_V_MF2_TU, 0x1 }, // 590
  { PseudoVID_V_MF4_MASK, PseudoVID_V_MF4, PseudoVID_V_MF4_TU, 0x1 }, // 591
  { PseudoVID_V_MF8_MASK, PseudoVID_V_MF8, PseudoVID_V_MF8_TU, 0x1 }, // 592
  { PseudoVIOTA_M_M1_MASK, PseudoVIOTA_M_M1, PseudoVIOTA_M_M1_TU, 0x2 }, // 593
  { PseudoVIOTA_M_M2_MASK, PseudoVIOTA_M_M2, PseudoVIOTA_M_M2_TU, 0x2 }, // 594
  { PseudoVIOTA_M_M4_MASK, PseudoVIOTA_M_M4, PseudoVIOTA_M_M4_TU, 0x2 }, // 595
  { PseudoVIOTA_M_M8_MASK, PseudoVIOTA_M_M8, PseudoVIOTA_M_M8_TU, 0x2 }, // 596
  { PseudoVIOTA_M_MF2_MASK, PseudoVIOTA_M_MF2, PseudoVIOTA_M_MF2_TU, 0x2 }, // 597
  { PseudoVIOTA_M_MF4_MASK, PseudoVIOTA_M_MF4, PseudoVIOTA_M_MF4_TU, 0x2 }, // 598
  { PseudoVIOTA_M_MF8_MASK, PseudoVIOTA_M_MF8, PseudoVIOTA_M_MF8_TU, 0x2 }, // 599
  { PseudoVLE16FF_V_M1_MASK, PseudoVLE16FF_V_M1, PseudoVLE16FF_V_M1_TU, 0x2 }, // 600
  { PseudoVLE16FF_V_M2_MASK, PseudoVLE16FF_V_M2, PseudoVLE16FF_V_M2_TU, 0x2 }, // 601
  { PseudoVLE16FF_V_M4_MASK, PseudoVLE16FF_V_M4, PseudoVLE16FF_V_M4_TU, 0x2 }, // 602
  { PseudoVLE16FF_V_M8_MASK, PseudoVLE16FF_V_M8, PseudoVLE16FF_V_M8_TU, 0x2 }, // 603
  { PseudoVLE16FF_V_MF2_MASK, PseudoVLE16FF_V_MF2, PseudoVLE16FF_V_MF2_TU, 0x2 }, // 604
  { PseudoVLE16FF_V_MF4_MASK, PseudoVLE16FF_V_MF4, PseudoVLE16FF_V_MF4_TU, 0x2 }, // 605
  { PseudoVLE16_V_M1_MASK, PseudoVLE16_V_M1, PseudoVLE16_V_M1_TU, 0x2 }, // 606
  { PseudoVLE16_V_M2_MASK, PseudoVLE16_V_M2, PseudoVLE16_V_M2_TU, 0x2 }, // 607
  { PseudoVLE16_V_M4_MASK, PseudoVLE16_V_M4, PseudoVLE16_V_M4_TU, 0x2 }, // 608
  { PseudoVLE16_V_M8_MASK, PseudoVLE16_V_M8, PseudoVLE16_V_M8_TU, 0x2 }, // 609
  { PseudoVLE16_V_MF2_MASK, PseudoVLE16_V_MF2, PseudoVLE16_V_MF2_TU, 0x2 }, // 610
  { PseudoVLE16_V_MF4_MASK, PseudoVLE16_V_MF4, PseudoVLE16_V_MF4_TU, 0x2 }, // 611
  { PseudoVLE32FF_V_M1_MASK, PseudoVLE32FF_V_M1, PseudoVLE32FF_V_M1_TU, 0x2 }, // 612
  { PseudoVLE32FF_V_M2_MASK, PseudoVLE32FF_V_M2, PseudoVLE32FF_V_M2_TU, 0x2 }, // 613
  { PseudoVLE32FF_V_M4_MASK, PseudoVLE32FF_V_M4, PseudoVLE32FF_V_M4_TU, 0x2 }, // 614
  { PseudoVLE32FF_V_M8_MASK, PseudoVLE32FF_V_M8, PseudoVLE32FF_V_M8_TU, 0x2 }, // 615
  { PseudoVLE32FF_V_MF2_MASK, PseudoVLE32FF_V_MF2, PseudoVLE32FF_V_MF2_TU, 0x2 }, // 616
  { PseudoVLE32_V_M1_MASK, PseudoVLE32_V_M1, PseudoVLE32_V_M1_TU, 0x2 }, // 617
  { PseudoVLE32_V_M2_MASK, PseudoVLE32_V_M2, PseudoVLE32_V_M2_TU, 0x2 }, // 618
  { PseudoVLE32_V_M4_MASK, PseudoVLE32_V_M4, PseudoVLE32_V_M4_TU, 0x2 }, // 619
  { PseudoVLE32_V_M8_MASK, PseudoVLE32_V_M8, PseudoVLE32_V_M8_TU, 0x2 }, // 620
  { PseudoVLE32_V_MF2_MASK, PseudoVLE32_V_MF2, PseudoVLE32_V_MF2_TU, 0x2 }, // 621
  { PseudoVLE64FF_V_M1_MASK, PseudoVLE64FF_V_M1, PseudoVLE64FF_V_M1_TU, 0x2 }, // 622
  { PseudoVLE64FF_V_M2_MASK, PseudoVLE64FF_V_M2, PseudoVLE64FF_V_M2_TU, 0x2 }, // 623
  { PseudoVLE64FF_V_M4_MASK, PseudoVLE64FF_V_M4, PseudoVLE64FF_V_M4_TU, 0x2 }, // 624
  { PseudoVLE64FF_V_M8_MASK, PseudoVLE64FF_V_M8, PseudoVLE64FF_V_M8_TU, 0x2 }, // 625
  { PseudoVLE64_V_M1_MASK, PseudoVLE64_V_M1, PseudoVLE64_V_M1_TU, 0x2 }, // 626
  { PseudoVLE64_V_M2_MASK, PseudoVLE64_V_M2, PseudoVLE64_V_M2_TU, 0x2 }, // 627
  { PseudoVLE64_V_M4_MASK, PseudoVLE64_V_M4, PseudoVLE64_V_M4_TU, 0x2 }, // 628
  { PseudoVLE64_V_M8_MASK, PseudoVLE64_V_M8, PseudoVLE64_V_M8_TU, 0x2 }, // 629
  { PseudoVLE8FF_V_M1_MASK, PseudoVLE8FF_V_M1, PseudoVLE8FF_V_M1_TU, 0x2 }, // 630
  { PseudoVLE8FF_V_M2_MASK, PseudoVLE8FF_V_M2, PseudoVLE8FF_V_M2_TU, 0x2 }, // 631
  { PseudoVLE8FF_V_M4_MASK, PseudoVLE8FF_V_M4, PseudoVLE8FF_V_M4_TU, 0x2 }, // 632
  { PseudoVLE8FF_V_M8_MASK, PseudoVLE8FF_V_M8, PseudoVLE8FF_V_M8_TU, 0x2 }, // 633
  { PseudoVLE8FF_V_MF2_MASK, PseudoVLE8FF_V_MF2, PseudoVLE8FF_V_MF2_TU, 0x2 }, // 634
  { PseudoVLE8FF_V_MF4_MASK, PseudoVLE8FF_V_MF4, PseudoVLE8FF_V_MF4_TU, 0x2 }, // 635
  { PseudoVLE8FF_V_MF8_MASK, PseudoVLE8FF_V_MF8, PseudoVLE8FF_V_MF8_TU, 0x2 }, // 636
  { PseudoVLE8_V_M1_MASK, PseudoVLE8_V_M1, PseudoVLE8_V_M1_TU, 0x2 }, // 637
  { PseudoVLE8_V_M2_MASK, PseudoVLE8_V_M2, PseudoVLE8_V_M2_TU, 0x2 }, // 638
  { PseudoVLE8_V_M4_MASK, PseudoVLE8_V_M4, PseudoVLE8_V_M4_TU, 0x2 }, // 639
  { PseudoVLE8_V_M8_MASK, PseudoVLE8_V_M8, PseudoVLE8_V_M8_TU, 0x2 }, // 640
  { PseudoVLE8_V_MF2_MASK, PseudoVLE8_V_MF2, PseudoVLE8_V_MF2_TU, 0x2 }, // 641
  { PseudoVLE8_V_MF4_MASK, PseudoVLE8_V_MF4, PseudoVLE8_V_MF4_TU, 0x2 }, // 642
  { PseudoVLE8_V_MF8_MASK, PseudoVLE8_V_MF8, PseudoVLE8_V_MF8_TU, 0x2 }, // 643
  { PseudoVLOXEI16_V_M1_M1_MASK, PseudoVLOXEI16_V_M1_M1, PseudoVLOXEI16_V_M1_M1_TU, 0x3 }, // 644
  { PseudoVLOXEI16_V_M1_M2_MASK, PseudoVLOXEI16_V_M1_M2, PseudoVLOXEI16_V_M1_M2_TU, 0x3 }, // 645
  { PseudoVLOXEI16_V_M1_M4_MASK, PseudoVLOXEI16_V_M1_M4, PseudoVLOXEI16_V_M1_M4_TU, 0x3 }, // 646
  { PseudoVLOXEI16_V_M1_MF2_MASK, PseudoVLOXEI16_V_M1_MF2, PseudoVLOXEI16_V_M1_MF2_TU, 0x3 }, // 647
  { PseudoVLOXEI16_V_M2_M1_MASK, PseudoVLOXEI16_V_M2_M1, PseudoVLOXEI16_V_M2_M1_TU, 0x3 }, // 648
  { PseudoVLOXEI16_V_M2_M2_MASK, PseudoVLOXEI16_V_M2_M2, PseudoVLOXEI16_V_M2_M2_TU, 0x3 }, // 649
  { PseudoVLOXEI16_V_M2_M4_MASK, PseudoVLOXEI16_V_M2_M4, PseudoVLOXEI16_V_M2_M4_TU, 0x3 }, // 650
  { PseudoVLOXEI16_V_M2_M8_MASK, PseudoVLOXEI16_V_M2_M8, PseudoVLOXEI16_V_M2_M8_TU, 0x3 }, // 651
  { PseudoVLOXEI16_V_M4_M2_MASK, PseudoVLOXEI16_V_M4_M2, PseudoVLOXEI16_V_M4_M2_TU, 0x3 }, // 652
  { PseudoVLOXEI16_V_M4_M4_MASK, PseudoVLOXEI16_V_M4_M4, PseudoVLOXEI16_V_M4_M4_TU, 0x3 }, // 653
  { PseudoVLOXEI16_V_M4_M8_MASK, PseudoVLOXEI16_V_M4_M8, PseudoVLOXEI16_V_M4_M8_TU, 0x3 }, // 654
  { PseudoVLOXEI16_V_M8_M4_MASK, PseudoVLOXEI16_V_M8_M4, PseudoVLOXEI16_V_M8_M4_TU, 0x3 }, // 655
  { PseudoVLOXEI16_V_M8_M8_MASK, PseudoVLOXEI16_V_M8_M8, PseudoVLOXEI16_V_M8_M8_TU, 0x3 }, // 656
  { PseudoVLOXEI16_V_MF2_M1_MASK, PseudoVLOXEI16_V_MF2_M1, PseudoVLOXEI16_V_MF2_M1_TU, 0x3 }, // 657
  { PseudoVLOXEI16_V_MF2_M2_MASK, PseudoVLOXEI16_V_MF2_M2, PseudoVLOXEI16_V_MF2_M2_TU, 0x3 }, // 658
  { PseudoVLOXEI16_V_MF2_MF2_MASK, PseudoVLOXEI16_V_MF2_MF2, PseudoVLOXEI16_V_MF2_MF2_TU, 0x3 }, // 659
  { PseudoVLOXEI16_V_MF2_MF4_MASK, PseudoVLOXEI16_V_MF2_MF4, PseudoVLOXEI16_V_MF2_MF4_TU, 0x3 }, // 660
  { PseudoVLOXEI16_V_MF4_M1_MASK, PseudoVLOXEI16_V_MF4_M1, PseudoVLOXEI16_V_MF4_M1_TU, 0x3 }, // 661
  { PseudoVLOXEI16_V_MF4_MF2_MASK, PseudoVLOXEI16_V_MF4_MF2, PseudoVLOXEI16_V_MF4_MF2_TU, 0x3 }, // 662
  { PseudoVLOXEI16_V_MF4_MF4_MASK, PseudoVLOXEI16_V_MF4_MF4, PseudoVLOXEI16_V_MF4_MF4_TU, 0x3 }, // 663
  { PseudoVLOXEI16_V_MF4_MF8_MASK, PseudoVLOXEI16_V_MF4_MF8, PseudoVLOXEI16_V_MF4_MF8_TU, 0x3 }, // 664
  { PseudoVLOXEI32_V_M1_M1_MASK, PseudoVLOXEI32_V_M1_M1, PseudoVLOXEI32_V_M1_M1_TU, 0x3 }, // 665
  { PseudoVLOXEI32_V_M1_M2_MASK, PseudoVLOXEI32_V_M1_M2, PseudoVLOXEI32_V_M1_M2_TU, 0x3 }, // 666
  { PseudoVLOXEI32_V_M1_MF2_MASK, PseudoVLOXEI32_V_M1_MF2, PseudoVLOXEI32_V_M1_MF2_TU, 0x3 }, // 667
  { PseudoVLOXEI32_V_M1_MF4_MASK, PseudoVLOXEI32_V_M1_MF4, PseudoVLOXEI32_V_M1_MF4_TU, 0x3 }, // 668
  { PseudoVLOXEI32_V_M2_M1_MASK, PseudoVLOXEI32_V_M2_M1, PseudoVLOXEI32_V_M2_M1_TU, 0x3 }, // 669
  { PseudoVLOXEI32_V_M2_M2_MASK, PseudoVLOXEI32_V_M2_M2, PseudoVLOXEI32_V_M2_M2_TU, 0x3 }, // 670
  { PseudoVLOXEI32_V_M2_M4_MASK, PseudoVLOXEI32_V_M2_M4, PseudoVLOXEI32_V_M2_M4_TU, 0x3 }, // 671
  { PseudoVLOXEI32_V_M2_MF2_MASK, PseudoVLOXEI32_V_M2_MF2, PseudoVLOXEI32_V_M2_MF2_TU, 0x3 }, // 672
  { PseudoVLOXEI32_V_M4_M1_MASK, PseudoVLOXEI32_V_M4_M1, PseudoVLOXEI32_V_M4_M1_TU, 0x3 }, // 673
  { PseudoVLOXEI32_V_M4_M2_MASK, PseudoVLOXEI32_V_M4_M2, PseudoVLOXEI32_V_M4_M2_TU, 0x3 }, // 674
  { PseudoVLOXEI32_V_M4_M4_MASK, PseudoVLOXEI32_V_M4_M4, PseudoVLOXEI32_V_M4_M4_TU, 0x3 }, // 675
  { PseudoVLOXEI32_V_M4_M8_MASK, PseudoVLOXEI32_V_M4_M8, PseudoVLOXEI32_V_M4_M8_TU, 0x3 }, // 676
  { PseudoVLOXEI32_V_M8_M2_MASK, PseudoVLOXEI32_V_M8_M2, PseudoVLOXEI32_V_M8_M2_TU, 0x3 }, // 677
  { PseudoVLOXEI32_V_M8_M4_MASK, PseudoVLOXEI32_V_M8_M4, PseudoVLOXEI32_V_M8_M4_TU, 0x3 }, // 678
  { PseudoVLOXEI32_V_M8_M8_MASK, PseudoVLOXEI32_V_M8_M8, PseudoVLOXEI32_V_M8_M8_TU, 0x3 }, // 679
  { PseudoVLOXEI32_V_MF2_M1_MASK, PseudoVLOXEI32_V_MF2_M1, PseudoVLOXEI32_V_MF2_M1_TU, 0x3 }, // 680
  { PseudoVLOXEI32_V_MF2_MF2_MASK, PseudoVLOXEI32_V_MF2_MF2, PseudoVLOXEI32_V_MF2_MF2_TU, 0x3 }, // 681
  { PseudoVLOXEI32_V_MF2_MF4_MASK, PseudoVLOXEI32_V_MF2_MF4, PseudoVLOXEI32_V_MF2_MF4_TU, 0x3 }, // 682
  { PseudoVLOXEI32_V_MF2_MF8_MASK, PseudoVLOXEI32_V_MF2_MF8, PseudoVLOXEI32_V_MF2_MF8_TU, 0x3 }, // 683
  { PseudoVLOXEI64_V_M1_M1_MASK, PseudoVLOXEI64_V_M1_M1, PseudoVLOXEI64_V_M1_M1_TU, 0x3 }, // 684
  { PseudoVLOXEI64_V_M1_MF2_MASK, PseudoVLOXEI64_V_M1_MF2, PseudoVLOXEI64_V_M1_MF2_TU, 0x3 }, // 685
  { PseudoVLOXEI64_V_M1_MF4_MASK, PseudoVLOXEI64_V_M1_MF4, PseudoVLOXEI64_V_M1_MF4_TU, 0x3 }, // 686
  { PseudoVLOXEI64_V_M1_MF8_MASK, PseudoVLOXEI64_V_M1_MF8, PseudoVLOXEI64_V_M1_MF8_TU, 0x3 }, // 687
  { PseudoVLOXEI64_V_M2_M1_MASK, PseudoVLOXEI64_V_M2_M1, PseudoVLOXEI64_V_M2_M1_TU, 0x3 }, // 688
  { PseudoVLOXEI64_V_M2_M2_MASK, PseudoVLOXEI64_V_M2_M2, PseudoVLOXEI64_V_M2_M2_TU, 0x3 }, // 689
  { PseudoVLOXEI64_V_M2_MF2_MASK, PseudoVLOXEI64_V_M2_MF2, PseudoVLOXEI64_V_M2_MF2_TU, 0x3 }, // 690
  { PseudoVLOXEI64_V_M2_MF4_MASK, PseudoVLOXEI64_V_M2_MF4, PseudoVLOXEI64_V_M2_MF4_TU, 0x3 }, // 691
  { PseudoVLOXEI64_V_M4_M1_MASK, PseudoVLOXEI64_V_M4_M1, PseudoVLOXEI64_V_M4_M1_TU, 0x3 }, // 692
  { PseudoVLOXEI64_V_M4_M2_MASK, PseudoVLOXEI64_V_M4_M2, PseudoVLOXEI64_V_M4_M2_TU, 0x3 }, // 693
  { PseudoVLOXEI64_V_M4_M4_MASK, PseudoVLOXEI64_V_M4_M4, PseudoVLOXEI64_V_M4_M4_TU, 0x3 }, // 694
  { PseudoVLOXEI64_V_M4_MF2_MASK, PseudoVLOXEI64_V_M4_MF2, PseudoVLOXEI64_V_M4_MF2_TU, 0x3 }, // 695
  { PseudoVLOXEI64_V_M8_M1_MASK, PseudoVLOXEI64_V_M8_M1, PseudoVLOXEI64_V_M8_M1_TU, 0x3 }, // 696
  { PseudoVLOXEI64_V_M8_M2_MASK, PseudoVLOXEI64_V_M8_M2, PseudoVLOXEI64_V_M8_M2_TU, 0x3 }, // 697
  { PseudoVLOXEI64_V_M8_M4_MASK, PseudoVLOXEI64_V_M8_M4, PseudoVLOXEI64_V_M8_M4_TU, 0x3 }, // 698
  { PseudoVLOXEI64_V_M8_M8_MASK, PseudoVLOXEI64_V_M8_M8, PseudoVLOXEI64_V_M8_M8_TU, 0x3 }, // 699
  { PseudoVLOXEI8_V_M1_M1_MASK, PseudoVLOXEI8_V_M1_M1, PseudoVLOXEI8_V_M1_M1_TU, 0x3 }, // 700
  { PseudoVLOXEI8_V_M1_M2_MASK, PseudoVLOXEI8_V_M1_M2, PseudoVLOXEI8_V_M1_M2_TU, 0x3 }, // 701
  { PseudoVLOXEI8_V_M1_M4_MASK, PseudoVLOXEI8_V_M1_M4, PseudoVLOXEI8_V_M1_M4_TU, 0x3 }, // 702
  { PseudoVLOXEI8_V_M1_M8_MASK, PseudoVLOXEI8_V_M1_M8, PseudoVLOXEI8_V_M1_M8_TU, 0x3 }, // 703
  { PseudoVLOXEI8_V_M2_M2_MASK, PseudoVLOXEI8_V_M2_M2, PseudoVLOXEI8_V_M2_M2_TU, 0x3 }, // 704
  { PseudoVLOXEI8_V_M2_M4_MASK, PseudoVLOXEI8_V_M2_M4, PseudoVLOXEI8_V_M2_M4_TU, 0x3 }, // 705
  { PseudoVLOXEI8_V_M2_M8_MASK, PseudoVLOXEI8_V_M2_M8, PseudoVLOXEI8_V_M2_M8_TU, 0x3 }, // 706
  { PseudoVLOXEI8_V_M4_M4_MASK, PseudoVLOXEI8_V_M4_M4, PseudoVLOXEI8_V_M4_M4_TU, 0x3 }, // 707
  { PseudoVLOXEI8_V_M4_M8_MASK, PseudoVLOXEI8_V_M4_M8, PseudoVLOXEI8_V_M4_M8_TU, 0x3 }, // 708
  { PseudoVLOXEI8_V_M8_M8_MASK, PseudoVLOXEI8_V_M8_M8, PseudoVLOXEI8_V_M8_M8_TU, 0x3 }, // 709
  { PseudoVLOXEI8_V_MF2_M1_MASK, PseudoVLOXEI8_V_MF2_M1, PseudoVLOXEI8_V_MF2_M1_TU, 0x3 }, // 710
  { PseudoVLOXEI8_V_MF2_M2_MASK, PseudoVLOXEI8_V_MF2_M2, PseudoVLOXEI8_V_MF2_M2_TU, 0x3 }, // 711
  { PseudoVLOXEI8_V_MF2_M4_MASK, PseudoVLOXEI8_V_MF2_M4, PseudoVLOXEI8_V_MF2_M4_TU, 0x3 }, // 712
  { PseudoVLOXEI8_V_MF2_MF2_MASK, PseudoVLOXEI8_V_MF2_MF2, PseudoVLOXEI8_V_MF2_MF2_TU, 0x3 }, // 713
  { PseudoVLOXEI8_V_MF4_M1_MASK, PseudoVLOXEI8_V_MF4_M1, PseudoVLOXEI8_V_MF4_M1_TU, 0x3 }, // 714
  { PseudoVLOXEI8_V_MF4_M2_MASK, PseudoVLOXEI8_V_MF4_M2, PseudoVLOXEI8_V_MF4_M2_TU, 0x3 }, // 715
  { PseudoVLOXEI8_V_MF4_MF2_MASK, PseudoVLOXEI8_V_MF4_MF2, PseudoVLOXEI8_V_MF4_MF2_TU, 0x3 }, // 716
  { PseudoVLOXEI8_V_MF4_MF4_MASK, PseudoVLOXEI8_V_MF4_MF4, PseudoVLOXEI8_V_MF4_MF4_TU, 0x3 }, // 717
  { PseudoVLOXEI8_V_MF8_M1_MASK, PseudoVLOXEI8_V_MF8_M1, PseudoVLOXEI8_V_MF8_M1_TU, 0x3 }, // 718
  { PseudoVLOXEI8_V_MF8_MF2_MASK, PseudoVLOXEI8_V_MF8_MF2, PseudoVLOXEI8_V_MF8_MF2_TU, 0x3 }, // 719
  { PseudoVLOXEI8_V_MF8_MF4_MASK, PseudoVLOXEI8_V_MF8_MF4, PseudoVLOXEI8_V_MF8_MF4_TU, 0x3 }, // 720
  { PseudoVLOXEI8_V_MF8_MF8_MASK, PseudoVLOXEI8_V_MF8_MF8, PseudoVLOXEI8_V_MF8_MF8_TU, 0x3 }, // 721
  { PseudoVLSE16_V_M1_MASK, PseudoVLSE16_V_M1, PseudoVLSE16_V_M1_TU, 0x3 }, // 722
  { PseudoVLSE16_V_M2_MASK, PseudoVLSE16_V_M2, PseudoVLSE16_V_M2_TU, 0x3 }, // 723
  { PseudoVLSE16_V_M4_MASK, PseudoVLSE16_V_M4, PseudoVLSE16_V_M4_TU, 0x3 }, // 724
  { PseudoVLSE16_V_M8_MASK, PseudoVLSE16_V_M8, PseudoVLSE16_V_M8_TU, 0x3 }, // 725
  { PseudoVLSE16_V_MF2_MASK, PseudoVLSE16_V_MF2, PseudoVLSE16_V_MF2_TU, 0x3 }, // 726
  { PseudoVLSE16_V_MF4_MASK, PseudoVLSE16_V_MF4, PseudoVLSE16_V_MF4_TU, 0x3 }, // 727
  { PseudoVLSE32_V_M1_MASK, PseudoVLSE32_V_M1, PseudoVLSE32_V_M1_TU, 0x3 }, // 728
  { PseudoVLSE32_V_M2_MASK, PseudoVLSE32_V_M2, PseudoVLSE32_V_M2_TU, 0x3 }, // 729
  { PseudoVLSE32_V_M4_MASK, PseudoVLSE32_V_M4, PseudoVLSE32_V_M4_TU, 0x3 }, // 730
  { PseudoVLSE32_V_M8_MASK, PseudoVLSE32_V_M8, PseudoVLSE32_V_M8_TU, 0x3 }, // 731
  { PseudoVLSE32_V_MF2_MASK, PseudoVLSE32_V_MF2, PseudoVLSE32_V_MF2_TU, 0x3 }, // 732
  { PseudoVLSE64_V_M1_MASK, PseudoVLSE64_V_M1, PseudoVLSE64_V_M1_TU, 0x3 }, // 733
  { PseudoVLSE64_V_M2_MASK, PseudoVLSE64_V_M2, PseudoVLSE64_V_M2_TU, 0x3 }, // 734
  { PseudoVLSE64_V_M4_MASK, PseudoVLSE64_V_M4, PseudoVLSE64_V_M4_TU, 0x3 }, // 735
  { PseudoVLSE64_V_M8_MASK, PseudoVLSE64_V_M8, PseudoVLSE64_V_M8_TU, 0x3 }, // 736
  { PseudoVLSE8_V_M1_MASK, PseudoVLSE8_V_M1, PseudoVLSE8_V_M1_TU, 0x3 }, // 737
  { PseudoVLSE8_V_M2_MASK, PseudoVLSE8_V_M2, PseudoVLSE8_V_M2_TU, 0x3 }, // 738
  { PseudoVLSE8_V_M4_MASK, PseudoVLSE8_V_M4, PseudoVLSE8_V_M4_TU, 0x3 }, // 739
  { PseudoVLSE8_V_M8_MASK, PseudoVLSE8_V_M8, PseudoVLSE8_V_M8_TU, 0x3 }, // 740
  { PseudoVLSE8_V_MF2_MASK, PseudoVLSE8_V_MF2, PseudoVLSE8_V_MF2_TU, 0x3 }, // 741
  { PseudoVLSE8_V_MF4_MASK, PseudoVLSE8_V_MF4, PseudoVLSE8_V_MF4_TU, 0x3 }, // 742
  { PseudoVLSE8_V_MF8_MASK, PseudoVLSE8_V_MF8, PseudoVLSE8_V_MF8_TU, 0x3 }, // 743
  { PseudoVLUXEI16_V_M1_M1_MASK, PseudoVLUXEI16_V_M1_M1, PseudoVLUXEI16_V_M1_M1_TU, 0x3 }, // 744
  { PseudoVLUXEI16_V_M1_M2_MASK, PseudoVLUXEI16_V_M1_M2, PseudoVLUXEI16_V_M1_M2_TU, 0x3 }, // 745
  { PseudoVLUXEI16_V_M1_M4_MASK, PseudoVLUXEI16_V_M1_M4, PseudoVLUXEI16_V_M1_M4_TU, 0x3 }, // 746
  { PseudoVLUXEI16_V_M1_MF2_MASK, PseudoVLUXEI16_V_M1_MF2, PseudoVLUXEI16_V_M1_MF2_TU, 0x3 }, // 747
  { PseudoVLUXEI16_V_M2_M1_MASK, PseudoVLUXEI16_V_M2_M1, PseudoVLUXEI16_V_M2_M1_TU, 0x3 }, // 748
  { PseudoVLUXEI16_V_M2_M2_MASK, PseudoVLUXEI16_V_M2_M2, PseudoVLUXEI16_V_M2_M2_TU, 0x3 }, // 749
  { PseudoVLUXEI16_V_M2_M4_MASK, PseudoVLUXEI16_V_M2_M4, PseudoVLUXEI16_V_M2_M4_TU, 0x3 }, // 750
  { PseudoVLUXEI16_V_M2_M8_MASK, PseudoVLUXEI16_V_M2_M8, PseudoVLUXEI16_V_M2_M8_TU, 0x3 }, // 751
  { PseudoVLUXEI16_V_M4_M2_MASK, PseudoVLUXEI16_V_M4_M2, PseudoVLUXEI16_V_M4_M2_TU, 0x3 }, // 752
  { PseudoVLUXEI16_V_M4_M4_MASK, PseudoVLUXEI16_V_M4_M4, PseudoVLUXEI16_V_M4_M4_TU, 0x3 }, // 753
  { PseudoVLUXEI16_V_M4_M8_MASK, PseudoVLUXEI16_V_M4_M8, PseudoVLUXEI16_V_M4_M8_TU, 0x3 }, // 754
  { PseudoVLUXEI16_V_M8_M4_MASK, PseudoVLUXEI16_V_M8_M4, PseudoVLUXEI16_V_M8_M4_TU, 0x3 }, // 755
  { PseudoVLUXEI16_V_M8_M8_MASK, PseudoVLUXEI16_V_M8_M8, PseudoVLUXEI16_V_M8_M8_TU, 0x3 }, // 756
  { PseudoVLUXEI16_V_MF2_M1_MASK, PseudoVLUXEI16_V_MF2_M1, PseudoVLUXEI16_V_MF2_M1_TU, 0x3 }, // 757
  { PseudoVLUXEI16_V_MF2_M2_MASK, PseudoVLUXEI16_V_MF2_M2, PseudoVLUXEI16_V_MF2_M2_TU, 0x3 }, // 758
  { PseudoVLUXEI16_V_MF2_MF2_MASK, PseudoVLUXEI16_V_MF2_MF2, PseudoVLUXEI16_V_MF2_MF2_TU, 0x3 }, // 759
  { PseudoVLUXEI16_V_MF2_MF4_MASK, PseudoVLUXEI16_V_MF2_MF4, PseudoVLUXEI16_V_MF2_MF4_TU, 0x3 }, // 760
  { PseudoVLUXEI16_V_MF4_M1_MASK, PseudoVLUXEI16_V_MF4_M1, PseudoVLUXEI16_V_MF4_M1_TU, 0x3 }, // 761
  { PseudoVLUXEI16_V_MF4_MF2_MASK, PseudoVLUXEI16_V_MF4_MF2, PseudoVLUXEI16_V_MF4_MF2_TU, 0x3 }, // 762
  { PseudoVLUXEI16_V_MF4_MF4_MASK, PseudoVLUXEI16_V_MF4_MF4, PseudoVLUXEI16_V_MF4_MF4_TU, 0x3 }, // 763
  { PseudoVLUXEI16_V_MF4_MF8_MASK, PseudoVLUXEI16_V_MF4_MF8, PseudoVLUXEI16_V_MF4_MF8_TU, 0x3 }, // 764
  { PseudoVLUXEI32_V_M1_M1_MASK, PseudoVLUXEI32_V_M1_M1, PseudoVLUXEI32_V_M1_M1_TU, 0x3 }, // 765
  { PseudoVLUXEI32_V_M1_M2_MASK, PseudoVLUXEI32_V_M1_M2, PseudoVLUXEI32_V_M1_M2_TU, 0x3 }, // 766
  { PseudoVLUXEI32_V_M1_MF2_MASK, PseudoVLUXEI32_V_M1_MF2, PseudoVLUXEI32_V_M1_MF2_TU, 0x3 }, // 767
  { PseudoVLUXEI32_V_M1_MF4_MASK, PseudoVLUXEI32_V_M1_MF4, PseudoVLUXEI32_V_M1_MF4_TU, 0x3 }, // 768
  { PseudoVLUXEI32_V_M2_M1_MASK, PseudoVLUXEI32_V_M2_M1, PseudoVLUXEI32_V_M2_M1_TU, 0x3 }, // 769
  { PseudoVLUXEI32_V_M2_M2_MASK, PseudoVLUXEI32_V_M2_M2, PseudoVLUXEI32_V_M2_M2_TU, 0x3 }, // 770
  { PseudoVLUXEI32_V_M2_M4_MASK, PseudoVLUXEI32_V_M2_M4, PseudoVLUXEI32_V_M2_M4_TU, 0x3 }, // 771
  { PseudoVLUXEI32_V_M2_MF2_MASK, PseudoVLUXEI32_V_M2_MF2, PseudoVLUXEI32_V_M2_MF2_TU, 0x3 }, // 772
  { PseudoVLUXEI32_V_M4_M1_MASK, PseudoVLUXEI32_V_M4_M1, PseudoVLUXEI32_V_M4_M1_TU, 0x3 }, // 773
  { PseudoVLUXEI32_V_M4_M2_MASK, PseudoVLUXEI32_V_M4_M2, PseudoVLUXEI32_V_M4_M2_TU, 0x3 }, // 774
  { PseudoVLUXEI32_V_M4_M4_MASK, PseudoVLUXEI32_V_M4_M4, PseudoVLUXEI32_V_M4_M4_TU, 0x3 }, // 775
  { PseudoVLUXEI32_V_M4_M8_MASK, PseudoVLUXEI32_V_M4_M8, PseudoVLUXEI32_V_M4_M8_TU, 0x3 }, // 776
  { PseudoVLUXEI32_V_M8_M2_MASK, PseudoVLUXEI32_V_M8_M2, PseudoVLUXEI32_V_M8_M2_TU, 0x3 }, // 777
  { PseudoVLUXEI32_V_M8_M4_MASK, PseudoVLUXEI32_V_M8_M4, PseudoVLUXEI32_V_M8_M4_TU, 0x3 }, // 778
  { PseudoVLUXEI32_V_M8_M8_MASK, PseudoVLUXEI32_V_M8_M8, PseudoVLUXEI32_V_M8_M8_TU, 0x3 }, // 779
  { PseudoVLUXEI32_V_MF2_M1_MASK, PseudoVLUXEI32_V_MF2_M1, PseudoVLUXEI32_V_MF2_M1_TU, 0x3 }, // 780
  { PseudoVLUXEI32_V_MF2_MF2_MASK, PseudoVLUXEI32_V_MF2_MF2, PseudoVLUXEI32_V_MF2_MF2_TU, 0x3 }, // 781
  { PseudoVLUXEI32_V_MF2_MF4_MASK, PseudoVLUXEI32_V_MF2_MF4, PseudoVLUXEI32_V_MF2_MF4_TU, 0x3 }, // 782
  { PseudoVLUXEI32_V_MF2_MF8_MASK, PseudoVLUXEI32_V_MF2_MF8, PseudoVLUXEI32_V_MF2_MF8_TU, 0x3 }, // 783
  { PseudoVLUXEI64_V_M1_M1_MASK, PseudoVLUXEI64_V_M1_M1, PseudoVLUXEI64_V_M1_M1_TU, 0x3 }, // 784
  { PseudoVLUXEI64_V_M1_MF2_MASK, PseudoVLUXEI64_V_M1_MF2, PseudoVLUXEI64_V_M1_MF2_TU, 0x3 }, // 785
  { PseudoVLUXEI64_V_M1_MF4_MASK, PseudoVLUXEI64_V_M1_MF4, PseudoVLUXEI64_V_M1_MF4_TU, 0x3 }, // 786
  { PseudoVLUXEI64_V_M1_MF8_MASK, PseudoVLUXEI64_V_M1_MF8, PseudoVLUXEI64_V_M1_MF8_TU, 0x3 }, // 787
  { PseudoVLUXEI64_V_M2_M1_MASK, PseudoVLUXEI64_V_M2_M1, PseudoVLUXEI64_V_M2_M1_TU, 0x3 }, // 788
  { PseudoVLUXEI64_V_M2_M2_MASK, PseudoVLUXEI64_V_M2_M2, PseudoVLUXEI64_V_M2_M2_TU, 0x3 }, // 789
  { PseudoVLUXEI64_V_M2_MF2_MASK, PseudoVLUXEI64_V_M2_MF2, PseudoVLUXEI64_V_M2_MF2_TU, 0x3 }, // 790
  { PseudoVLUXEI64_V_M2_MF4_MASK, PseudoVLUXEI64_V_M2_MF4, PseudoVLUXEI64_V_M2_MF4_TU, 0x3 }, // 791
  { PseudoVLUXEI64_V_M4_M1_MASK, PseudoVLUXEI64_V_M4_M1, PseudoVLUXEI64_V_M4_M1_TU, 0x3 }, // 792
  { PseudoVLUXEI64_V_M4_M2_MASK, PseudoVLUXEI64_V_M4_M2, PseudoVLUXEI64_V_M4_M2_TU, 0x3 }, // 793
  { PseudoVLUXEI64_V_M4_M4_MASK, PseudoVLUXEI64_V_M4_M4, PseudoVLUXEI64_V_M4_M4_TU, 0x3 }, // 794
  { PseudoVLUXEI64_V_M4_MF2_MASK, PseudoVLUXEI64_V_M4_MF2, PseudoVLUXEI64_V_M4_MF2_TU, 0x3 }, // 795
  { PseudoVLUXEI64_V_M8_M1_MASK, PseudoVLUXEI64_V_M8_M1, PseudoVLUXEI64_V_M8_M1_TU, 0x3 }, // 796
  { PseudoVLUXEI64_V_M8_M2_MASK, PseudoVLUXEI64_V_M8_M2, PseudoVLUXEI64_V_M8_M2_TU, 0x3 }, // 797
  { PseudoVLUXEI64_V_M8_M4_MASK, PseudoVLUXEI64_V_M8_M4, PseudoVLUXEI64_V_M8_M4_TU, 0x3 }, // 798
  { PseudoVLUXEI64_V_M8_M8_MASK, PseudoVLUXEI64_V_M8_M8, PseudoVLUXEI64_V_M8_M8_TU, 0x3 }, // 799
  { PseudoVLUXEI8_V_M1_M1_MASK, PseudoVLUXEI8_V_M1_M1, PseudoVLUXEI8_V_M1_M1_TU, 0x3 }, // 800
  { PseudoVLUXEI8_V_M1_M2_MASK, PseudoVLUXEI8_V_M1_M2, PseudoVLUXEI8_V_M1_M2_TU, 0x3 }, // 801
  { PseudoVLUXEI8_V_M1_M4_MASK, PseudoVLUXEI8_V_M1_M4, PseudoVLUXEI8_V_M1_M4_TU, 0x3 }, // 802
  { PseudoVLUXEI8_V_M1_M8_MASK, PseudoVLUXEI8_V_M1_M8, PseudoVLUXEI8_V_M1_M8_TU, 0x3 }, // 803
  { PseudoVLUXEI8_V_M2_M2_MASK, PseudoVLUXEI8_V_M2_M2, PseudoVLUXEI8_V_M2_M2_TU, 0x3 }, // 804
  { PseudoVLUXEI8_V_M2_M4_MASK, PseudoVLUXEI8_V_M2_M4, PseudoVLUXEI8_V_M2_M4_TU, 0x3 }, // 805
  { PseudoVLUXEI8_V_M2_M8_MASK, PseudoVLUXEI8_V_M2_M8, PseudoVLUXEI8_V_M2_M8_TU, 0x3 }, // 806
  { PseudoVLUXEI8_V_M4_M4_MASK, PseudoVLUXEI8_V_M4_M4, PseudoVLUXEI8_V_M4_M4_TU, 0x3 }, // 807
  { PseudoVLUXEI8_V_M4_M8_MASK, PseudoVLUXEI8_V_M4_M8, PseudoVLUXEI8_V_M4_M8_TU, 0x3 }, // 808
  { PseudoVLUXEI8_V_M8_M8_MASK, PseudoVLUXEI8_V_M8_M8, PseudoVLUXEI8_V_M8_M8_TU, 0x3 }, // 809
  { PseudoVLUXEI8_V_MF2_M1_MASK, PseudoVLUXEI8_V_MF2_M1, PseudoVLUXEI8_V_MF2_M1_TU, 0x3 }, // 810
  { PseudoVLUXEI8_V_MF2_M2_MASK, PseudoVLUXEI8_V_MF2_M2, PseudoVLUXEI8_V_MF2_M2_TU, 0x3 }, // 811
  { PseudoVLUXEI8_V_MF2_M4_MASK, PseudoVLUXEI8_V_MF2_M4, PseudoVLUXEI8_V_MF2_M4_TU, 0x3 }, // 812
  { PseudoVLUXEI8_V_MF2_MF2_MASK, PseudoVLUXEI8_V_MF2_MF2, PseudoVLUXEI8_V_MF2_MF2_TU, 0x3 }, // 813
  { PseudoVLUXEI8_V_MF4_M1_MASK, PseudoVLUXEI8_V_MF4_M1, PseudoVLUXEI8_V_MF4_M1_TU, 0x3 }, // 814
  { PseudoVLUXEI8_V_MF4_M2_MASK, PseudoVLUXEI8_V_MF4_M2, PseudoVLUXEI8_V_MF4_M2_TU, 0x3 }, // 815
  { PseudoVLUXEI8_V_MF4_MF2_MASK, PseudoVLUXEI8_V_MF4_MF2, PseudoVLUXEI8_V_MF4_MF2_TU, 0x3 }, // 816
  { PseudoVLUXEI8_V_MF4_MF4_MASK, PseudoVLUXEI8_V_MF4_MF4, PseudoVLUXEI8_V_MF4_MF4_TU, 0x3 }, // 817
  { PseudoVLUXEI8_V_MF8_M1_MASK, PseudoVLUXEI8_V_MF8_M1, PseudoVLUXEI8_V_MF8_M1_TU, 0x3 }, // 818
  { PseudoVLUXEI8_V_MF8_MF2_MASK, PseudoVLUXEI8_V_MF8_MF2, PseudoVLUXEI8_V_MF8_MF2_TU, 0x3 }, // 819
  { PseudoVLUXEI8_V_MF8_MF4_MASK, PseudoVLUXEI8_V_MF8_MF4, PseudoVLUXEI8_V_MF8_MF4_TU, 0x3 }, // 820
  { PseudoVLUXEI8_V_MF8_MF8_MASK, PseudoVLUXEI8_V_MF8_MF8, PseudoVLUXEI8_V_MF8_MF8_TU, 0x3 }, // 821
  { PseudoVMAXU_VV_M1_MASK, PseudoVMAXU_VV_M1, PseudoVMAXU_VV_M1_TU, 0x3 }, // 822
  { PseudoVMAXU_VV_M2_MASK, PseudoVMAXU_VV_M2, PseudoVMAXU_VV_M2_TU, 0x3 }, // 823
  { PseudoVMAXU_VV_M4_MASK, PseudoVMAXU_VV_M4, PseudoVMAXU_VV_M4_TU, 0x3 }, // 824
  { PseudoVMAXU_VV_M8_MASK, PseudoVMAXU_VV_M8, PseudoVMAXU_VV_M8_TU, 0x3 }, // 825
  { PseudoVMAXU_VV_MF2_MASK, PseudoVMAXU_VV_MF2, PseudoVMAXU_VV_MF2_TU, 0x3 }, // 826
  { PseudoVMAXU_VV_MF4_MASK, PseudoVMAXU_VV_MF4, PseudoVMAXU_VV_MF4_TU, 0x3 }, // 827
  { PseudoVMAXU_VV_MF8_MASK, PseudoVMAXU_VV_MF8, PseudoVMAXU_VV_MF8_TU, 0x3 }, // 828
  { PseudoVMAXU_VX_M1_MASK, PseudoVMAXU_VX_M1, PseudoVMAXU_VX_M1_TU, 0x3 }, // 829
  { PseudoVMAXU_VX_M2_MASK, PseudoVMAXU_VX_M2, PseudoVMAXU_VX_M2_TU, 0x3 }, // 830
  { PseudoVMAXU_VX_M4_MASK, PseudoVMAXU_VX_M4, PseudoVMAXU_VX_M4_TU, 0x3 }, // 831
  { PseudoVMAXU_VX_M8_MASK, PseudoVMAXU_VX_M8, PseudoVMAXU_VX_M8_TU, 0x3 }, // 832
  { PseudoVMAXU_VX_MF2_MASK, PseudoVMAXU_VX_MF2, PseudoVMAXU_VX_MF2_TU, 0x3 }, // 833
  { PseudoVMAXU_VX_MF4_MASK, PseudoVMAXU_VX_MF4, PseudoVMAXU_VX_MF4_TU, 0x3 }, // 834
  { PseudoVMAXU_VX_MF8_MASK, PseudoVMAXU_VX_MF8, PseudoVMAXU_VX_MF8_TU, 0x3 }, // 835
  { PseudoVMAX_VV_M1_MASK, PseudoVMAX_VV_M1, PseudoVMAX_VV_M1_TU, 0x3 }, // 836
  { PseudoVMAX_VV_M2_MASK, PseudoVMAX_VV_M2, PseudoVMAX_VV_M2_TU, 0x3 }, // 837
  { PseudoVMAX_VV_M4_MASK, PseudoVMAX_VV_M4, PseudoVMAX_VV_M4_TU, 0x3 }, // 838
  { PseudoVMAX_VV_M8_MASK, PseudoVMAX_VV_M8, PseudoVMAX_VV_M8_TU, 0x3 }, // 839
  { PseudoVMAX_VV_MF2_MASK, PseudoVMAX_VV_MF2, PseudoVMAX_VV_MF2_TU, 0x3 }, // 840
  { PseudoVMAX_VV_MF4_MASK, PseudoVMAX_VV_MF4, PseudoVMAX_VV_MF4_TU, 0x3 }, // 841
  { PseudoVMAX_VV_MF8_MASK, PseudoVMAX_VV_MF8, PseudoVMAX_VV_MF8_TU, 0x3 }, // 842
  { PseudoVMAX_VX_M1_MASK, PseudoVMAX_VX_M1, PseudoVMAX_VX_M1_TU, 0x3 }, // 843
  { PseudoVMAX_VX_M2_MASK, PseudoVMAX_VX_M2, PseudoVMAX_VX_M2_TU, 0x3 }, // 844
  { PseudoVMAX_VX_M4_MASK, PseudoVMAX_VX_M4, PseudoVMAX_VX_M4_TU, 0x3 }, // 845
  { PseudoVMAX_VX_M8_MASK, PseudoVMAX_VX_M8, PseudoVMAX_VX_M8_TU, 0x3 }, // 846
  { PseudoVMAX_VX_MF2_MASK, PseudoVMAX_VX_MF2, PseudoVMAX_VX_MF2_TU, 0x3 }, // 847
  { PseudoVMAX_VX_MF4_MASK, PseudoVMAX_VX_MF4, PseudoVMAX_VX_MF4_TU, 0x3 }, // 848
  { PseudoVMAX_VX_MF8_MASK, PseudoVMAX_VX_MF8, PseudoVMAX_VX_MF8_TU, 0x3 }, // 849
  { PseudoVMFEQ_VF16_M1_MASK, PseudoVMFEQ_VF16_M1, PseudoVMFEQ_VF16_M1_MASK, 0x3 }, // 850
  { PseudoVMFEQ_VF16_M2_MASK, PseudoVMFEQ_VF16_M2, PseudoVMFEQ_VF16_M2_MASK, 0x3 }, // 851
  { PseudoVMFEQ_VF16_M4_MASK, PseudoVMFEQ_VF16_M4, PseudoVMFEQ_VF16_M4_MASK, 0x3 }, // 852
  { PseudoVMFEQ_VF16_M8_MASK, PseudoVMFEQ_VF16_M8, PseudoVMFEQ_VF16_M8_MASK, 0x3 }, // 853
  { PseudoVMFEQ_VF16_MF2_MASK, PseudoVMFEQ_VF16_MF2, PseudoVMFEQ_VF16_MF2_MASK, 0x3 }, // 854
  { PseudoVMFEQ_VF16_MF4_MASK, PseudoVMFEQ_VF16_MF4, PseudoVMFEQ_VF16_MF4_MASK, 0x3 }, // 855
  { PseudoVMFEQ_VF32_M1_MASK, PseudoVMFEQ_VF32_M1, PseudoVMFEQ_VF32_M1_MASK, 0x3 }, // 856
  { PseudoVMFEQ_VF32_M2_MASK, PseudoVMFEQ_VF32_M2, PseudoVMFEQ_VF32_M2_MASK, 0x3 }, // 857
  { PseudoVMFEQ_VF32_M4_MASK, PseudoVMFEQ_VF32_M4, PseudoVMFEQ_VF32_M4_MASK, 0x3 }, // 858
  { PseudoVMFEQ_VF32_M8_MASK, PseudoVMFEQ_VF32_M8, PseudoVMFEQ_VF32_M8_MASK, 0x3 }, // 859
  { PseudoVMFEQ_VF32_MF2_MASK, PseudoVMFEQ_VF32_MF2, PseudoVMFEQ_VF32_MF2_MASK, 0x3 }, // 860
  { PseudoVMFEQ_VF64_M1_MASK, PseudoVMFEQ_VF64_M1, PseudoVMFEQ_VF64_M1_MASK, 0x3 }, // 861
  { PseudoVMFEQ_VF64_M2_MASK, PseudoVMFEQ_VF64_M2, PseudoVMFEQ_VF64_M2_MASK, 0x3 }, // 862
  { PseudoVMFEQ_VF64_M4_MASK, PseudoVMFEQ_VF64_M4, PseudoVMFEQ_VF64_M4_MASK, 0x3 }, // 863
  { PseudoVMFEQ_VF64_M8_MASK, PseudoVMFEQ_VF64_M8, PseudoVMFEQ_VF64_M8_MASK, 0x3 }, // 864
  { PseudoVMFEQ_VV_M1_MASK, PseudoVMFEQ_VV_M1, PseudoVMFEQ_VV_M1_MASK, 0x3 }, // 865
  { PseudoVMFEQ_VV_M2_MASK, PseudoVMFEQ_VV_M2, PseudoVMFEQ_VV_M2_MASK, 0x3 }, // 866
  { PseudoVMFEQ_VV_M4_MASK, PseudoVMFEQ_VV_M4, PseudoVMFEQ_VV_M4_MASK, 0x3 }, // 867
  { PseudoVMFEQ_VV_M8_MASK, PseudoVMFEQ_VV_M8, PseudoVMFEQ_VV_M8_MASK, 0x3 }, // 868
  { PseudoVMFEQ_VV_MF2_MASK, PseudoVMFEQ_VV_MF2, PseudoVMFEQ_VV_MF2_MASK, 0x3 }, // 869
  { PseudoVMFEQ_VV_MF4_MASK, PseudoVMFEQ_VV_MF4, PseudoVMFEQ_VV_MF4_MASK, 0x3 }, // 870
  { PseudoVMFGE_VF16_M1_MASK, PseudoVMFGE_VF16_M1, PseudoVMFGE_VF16_M1_MASK, 0x3 }, // 871
  { PseudoVMFGE_VF16_M2_MASK, PseudoVMFGE_VF16_M2, PseudoVMFGE_VF16_M2_MASK, 0x3 }, // 872
  { PseudoVMFGE_VF16_M4_MASK, PseudoVMFGE_VF16_M4, PseudoVMFGE_VF16_M4_MASK, 0x3 }, // 873
  { PseudoVMFGE_VF16_M8_MASK, PseudoVMFGE_VF16_M8, PseudoVMFGE_VF16_M8_MASK, 0x3 }, // 874
  { PseudoVMFGE_VF16_MF2_MASK, PseudoVMFGE_VF16_MF2, PseudoVMFGE_VF16_MF2_MASK, 0x3 }, // 875
  { PseudoVMFGE_VF16_MF4_MASK, PseudoVMFGE_VF16_MF4, PseudoVMFGE_VF16_MF4_MASK, 0x3 }, // 876
  { PseudoVMFGE_VF32_M1_MASK, PseudoVMFGE_VF32_M1, PseudoVMFGE_VF32_M1_MASK, 0x3 }, // 877
  { PseudoVMFGE_VF32_M2_MASK, PseudoVMFGE_VF32_M2, PseudoVMFGE_VF32_M2_MASK, 0x3 }, // 878
  { PseudoVMFGE_VF32_M4_MASK, PseudoVMFGE_VF32_M4, PseudoVMFGE_VF32_M4_MASK, 0x3 }, // 879
  { PseudoVMFGE_VF32_M8_MASK, PseudoVMFGE_VF32_M8, PseudoVMFGE_VF32_M8_MASK, 0x3 }, // 880
  { PseudoVMFGE_VF32_MF2_MASK, PseudoVMFGE_VF32_MF2, PseudoVMFGE_VF32_MF2_MASK, 0x3 }, // 881
  { PseudoVMFGE_VF64_M1_MASK, PseudoVMFGE_VF64_M1, PseudoVMFGE_VF64_M1_MASK, 0x3 }, // 882
  { PseudoVMFGE_VF64_M2_MASK, PseudoVMFGE_VF64_M2, PseudoVMFGE_VF64_M2_MASK, 0x3 }, // 883
  { PseudoVMFGE_VF64_M4_MASK, PseudoVMFGE_VF64_M4, PseudoVMFGE_VF64_M4_MASK, 0x3 }, // 884
  { PseudoVMFGE_VF64_M8_MASK, PseudoVMFGE_VF64_M8, PseudoVMFGE_VF64_M8_MASK, 0x3 }, // 885
  { PseudoVMFGT_VF16_M1_MASK, PseudoVMFGT_VF16_M1, PseudoVMFGT_VF16_M1_MASK, 0x3 }, // 886
  { PseudoVMFGT_VF16_M2_MASK, PseudoVMFGT_VF16_M2, PseudoVMFGT_VF16_M2_MASK, 0x3 }, // 887
  { PseudoVMFGT_VF16_M4_MASK, PseudoVMFGT_VF16_M4, PseudoVMFGT_VF16_M4_MASK, 0x3 }, // 888
  { PseudoVMFGT_VF16_M8_MASK, PseudoVMFGT_VF16_M8, PseudoVMFGT_VF16_M8_MASK, 0x3 }, // 889
  { PseudoVMFGT_VF16_MF2_MASK, PseudoVMFGT_VF16_MF2, PseudoVMFGT_VF16_MF2_MASK, 0x3 }, // 890
  { PseudoVMFGT_VF16_MF4_MASK, PseudoVMFGT_VF16_MF4, PseudoVMFGT_VF16_MF4_MASK, 0x3 }, // 891
  { PseudoVMFGT_VF32_M1_MASK, PseudoVMFGT_VF32_M1, PseudoVMFGT_VF32_M1_MASK, 0x3 }, // 892
  { PseudoVMFGT_VF32_M2_MASK, PseudoVMFGT_VF32_M2, PseudoVMFGT_VF32_M2_MASK, 0x3 }, // 893
  { PseudoVMFGT_VF32_M4_MASK, PseudoVMFGT_VF32_M4, PseudoVMFGT_VF32_M4_MASK, 0x3 }, // 894
  { PseudoVMFGT_VF32_M8_MASK, PseudoVMFGT_VF32_M8, PseudoVMFGT_VF32_M8_MASK, 0x3 }, // 895
  { PseudoVMFGT_VF32_MF2_MASK, PseudoVMFGT_VF32_MF2, PseudoVMFGT_VF32_MF2_MASK, 0x3 }, // 896
  { PseudoVMFGT_VF64_M1_MASK, PseudoVMFGT_VF64_M1, PseudoVMFGT_VF64_M1_MASK, 0x3 }, // 897
  { PseudoVMFGT_VF64_M2_MASK, PseudoVMFGT_VF64_M2, PseudoVMFGT_VF64_M2_MASK, 0x3 }, // 898
  { PseudoVMFGT_VF64_M4_MASK, PseudoVMFGT_VF64_M4, PseudoVMFGT_VF64_M4_MASK, 0x3 }, // 899
  { PseudoVMFGT_VF64_M8_MASK, PseudoVMFGT_VF64_M8, PseudoVMFGT_VF64_M8_MASK, 0x3 }, // 900
  { PseudoVMFLE_VF16_M1_MASK, PseudoVMFLE_VF16_M1, PseudoVMFLE_VF16_M1_MASK, 0x3 }, // 901
  { PseudoVMFLE_VF16_M2_MASK, PseudoVMFLE_VF16_M2, PseudoVMFLE_VF16_M2_MASK, 0x3 }, // 902
  { PseudoVMFLE_VF16_M4_MASK, PseudoVMFLE_VF16_M4, PseudoVMFLE_VF16_M4_MASK, 0x3 }, // 903
  { PseudoVMFLE_VF16_M8_MASK, PseudoVMFLE_VF16_M8, PseudoVMFLE_VF16_M8_MASK, 0x3 }, // 904
  { PseudoVMFLE_VF16_MF2_MASK, PseudoVMFLE_VF16_MF2, PseudoVMFLE_VF16_MF2_MASK, 0x3 }, // 905
  { PseudoVMFLE_VF16_MF4_MASK, PseudoVMFLE_VF16_MF4, PseudoVMFLE_VF16_MF4_MASK, 0x3 }, // 906
  { PseudoVMFLE_VF32_M1_MASK, PseudoVMFLE_VF32_M1, PseudoVMFLE_VF32_M1_MASK, 0x3 }, // 907
  { PseudoVMFLE_VF32_M2_MASK, PseudoVMFLE_VF32_M2, PseudoVMFLE_VF32_M2_MASK, 0x3 }, // 908
  { PseudoVMFLE_VF32_M4_MASK, PseudoVMFLE_VF32_M4, PseudoVMFLE_VF32_M4_MASK, 0x3 }, // 909
  { PseudoVMFLE_VF32_M8_MASK, PseudoVMFLE_VF32_M8, PseudoVMFLE_VF32_M8_MASK, 0x3 }, // 910
  { PseudoVMFLE_VF32_MF2_MASK, PseudoVMFLE_VF32_MF2, PseudoVMFLE_VF32_MF2_MASK, 0x3 }, // 911
  { PseudoVMFLE_VF64_M1_MASK, PseudoVMFLE_VF64_M1, PseudoVMFLE_VF64_M1_MASK, 0x3 }, // 912
  { PseudoVMFLE_VF64_M2_MASK, PseudoVMFLE_VF64_M2, PseudoVMFLE_VF64_M2_MASK, 0x3 }, // 913
  { PseudoVMFLE_VF64_M4_MASK, PseudoVMFLE_VF64_M4, PseudoVMFLE_VF64_M4_MASK, 0x3 }, // 914
  { PseudoVMFLE_VF64_M8_MASK, PseudoVMFLE_VF64_M8, PseudoVMFLE_VF64_M8_MASK, 0x3 }, // 915
  { PseudoVMFLE_VV_M1_MASK, PseudoVMFLE_VV_M1, PseudoVMFLE_VV_M1_MASK, 0x3 }, // 916
  { PseudoVMFLE_VV_M2_MASK, PseudoVMFLE_VV_M2, PseudoVMFLE_VV_M2_MASK, 0x3 }, // 917
  { PseudoVMFLE_VV_M4_MASK, PseudoVMFLE_VV_M4, PseudoVMFLE_VV_M4_MASK, 0x3 }, // 918
  { PseudoVMFLE_VV_M8_MASK, PseudoVMFLE_VV_M8, PseudoVMFLE_VV_M8_MASK, 0x3 }, // 919
  { PseudoVMFLE_VV_MF2_MASK, PseudoVMFLE_VV_MF2, PseudoVMFLE_VV_MF2_MASK, 0x3 }, // 920
  { PseudoVMFLE_VV_MF4_MASK, PseudoVMFLE_VV_MF4, PseudoVMFLE_VV_MF4_MASK, 0x3 }, // 921
  { PseudoVMFLT_VF16_M1_MASK, PseudoVMFLT_VF16_M1, PseudoVMFLT_VF16_M1_MASK, 0x3 }, // 922
  { PseudoVMFLT_VF16_M2_MASK, PseudoVMFLT_VF16_M2, PseudoVMFLT_VF16_M2_MASK, 0x3 }, // 923
  { PseudoVMFLT_VF16_M4_MASK, PseudoVMFLT_VF16_M4, PseudoVMFLT_VF16_M4_MASK, 0x3 }, // 924
  { PseudoVMFLT_VF16_M8_MASK, PseudoVMFLT_VF16_M8, PseudoVMFLT_VF16_M8_MASK, 0x3 }, // 925
  { PseudoVMFLT_VF16_MF2_MASK, PseudoVMFLT_VF16_MF2, PseudoVMFLT_VF16_MF2_MASK, 0x3 }, // 926
  { PseudoVMFLT_VF16_MF4_MASK, PseudoVMFLT_VF16_MF4, PseudoVMFLT_VF16_MF4_MASK, 0x3 }, // 927
  { PseudoVMFLT_VF32_M1_MASK, PseudoVMFLT_VF32_M1, PseudoVMFLT_VF32_M1_MASK, 0x3 }, // 928
  { PseudoVMFLT_VF32_M2_MASK, PseudoVMFLT_VF32_M2, PseudoVMFLT_VF32_M2_MASK, 0x3 }, // 929
  { PseudoVMFLT_VF32_M4_MASK, PseudoVMFLT_VF32_M4, PseudoVMFLT_VF32_M4_MASK, 0x3 }, // 930
  { PseudoVMFLT_VF32_M8_MASK, PseudoVMFLT_VF32_M8, PseudoVMFLT_VF32_M8_MASK, 0x3 }, // 931
  { PseudoVMFLT_VF32_MF2_MASK, PseudoVMFLT_VF32_MF2, PseudoVMFLT_VF32_MF2_MASK, 0x3 }, // 932
  { PseudoVMFLT_VF64_M1_MASK, PseudoVMFLT_VF64_M1, PseudoVMFLT_VF64_M1_MASK, 0x3 }, // 933
  { PseudoVMFLT_VF64_M2_MASK, PseudoVMFLT_VF64_M2, PseudoVMFLT_VF64_M2_MASK, 0x3 }, // 934
  { PseudoVMFLT_VF64_M4_MASK, PseudoVMFLT_VF64_M4, PseudoVMFLT_VF64_M4_MASK, 0x3 }, // 935
  { PseudoVMFLT_VF64_M8_MASK, PseudoVMFLT_VF64_M8, PseudoVMFLT_VF64_M8_MASK, 0x3 }, // 936
  { PseudoVMFLT_VV_M1_MASK, PseudoVMFLT_VV_M1, PseudoVMFLT_VV_M1_MASK, 0x3 }, // 937
  { PseudoVMFLT_VV_M2_MASK, PseudoVMFLT_VV_M2, PseudoVMFLT_VV_M2_MASK, 0x3 }, // 938
  { PseudoVMFLT_VV_M4_MASK, PseudoVMFLT_VV_M4, PseudoVMFLT_VV_M4_MASK, 0x3 }, // 939
  { PseudoVMFLT_VV_M8_MASK, PseudoVMFLT_VV_M8, PseudoVMFLT_VV_M8_MASK, 0x3 }, // 940
  { PseudoVMFLT_VV_MF2_MASK, PseudoVMFLT_VV_MF2, PseudoVMFLT_VV_MF2_MASK, 0x3 }, // 941
  { PseudoVMFLT_VV_MF4_MASK, PseudoVMFLT_VV_MF4, PseudoVMFLT_VV_MF4_MASK, 0x3 }, // 942
  { PseudoVMFNE_VF16_M1_MASK, PseudoVMFNE_VF16_M1, PseudoVMFNE_VF16_M1_MASK, 0x3 }, // 943
  { PseudoVMFNE_VF16_M2_MASK, PseudoVMFNE_VF16_M2, PseudoVMFNE_VF16_M2_MASK, 0x3 }, // 944
  { PseudoVMFNE_VF16_M4_MASK, PseudoVMFNE_VF16_M4, PseudoVMFNE_VF16_M4_MASK, 0x3 }, // 945
  { PseudoVMFNE_VF16_M8_MASK, PseudoVMFNE_VF16_M8, PseudoVMFNE_VF16_M8_MASK, 0x3 }, // 946
  { PseudoVMFNE_VF16_MF2_MASK, PseudoVMFNE_VF16_MF2, PseudoVMFNE_VF16_MF2_MASK, 0x3 }, // 947
  { PseudoVMFNE_VF16_MF4_MASK, PseudoVMFNE_VF16_MF4, PseudoVMFNE_VF16_MF4_MASK, 0x3 }, // 948
  { PseudoVMFNE_VF32_M1_MASK, PseudoVMFNE_VF32_M1, PseudoVMFNE_VF32_M1_MASK, 0x3 }, // 949
  { PseudoVMFNE_VF32_M2_MASK, PseudoVMFNE_VF32_M2, PseudoVMFNE_VF32_M2_MASK, 0x3 }, // 950
  { PseudoVMFNE_VF32_M4_MASK, PseudoVMFNE_VF32_M4, PseudoVMFNE_VF32_M4_MASK, 0x3 }, // 951
  { PseudoVMFNE_VF32_M8_MASK, PseudoVMFNE_VF32_M8, PseudoVMFNE_VF32_M8_MASK, 0x3 }, // 952
  { PseudoVMFNE_VF32_MF2_MASK, PseudoVMFNE_VF32_MF2, PseudoVMFNE_VF32_MF2_MASK, 0x3 }, // 953
  { PseudoVMFNE_VF64_M1_MASK, PseudoVMFNE_VF64_M1, PseudoVMFNE_VF64_M1_MASK, 0x3 }, // 954
  { PseudoVMFNE_VF64_M2_MASK, PseudoVMFNE_VF64_M2, PseudoVMFNE_VF64_M2_MASK, 0x3 }, // 955
  { PseudoVMFNE_VF64_M4_MASK, PseudoVMFNE_VF64_M4, PseudoVMFNE_VF64_M4_MASK, 0x3 }, // 956
  { PseudoVMFNE_VF64_M8_MASK, PseudoVMFNE_VF64_M8, PseudoVMFNE_VF64_M8_MASK, 0x3 }, // 957
  { PseudoVMFNE_VV_M1_MASK, PseudoVMFNE_VV_M1, PseudoVMFNE_VV_M1_MASK, 0x3 }, // 958
  { PseudoVMFNE_VV_M2_MASK, PseudoVMFNE_VV_M2, PseudoVMFNE_VV_M2_MASK, 0x3 }, // 959
  { PseudoVMFNE_VV_M4_MASK, PseudoVMFNE_VV_M4, PseudoVMFNE_VV_M4_MASK, 0x3 }, // 960
  { PseudoVMFNE_VV_M8_MASK, PseudoVMFNE_VV_M8, PseudoVMFNE_VV_M8_MASK, 0x3 }, // 961
  { PseudoVMFNE_VV_MF2_MASK, PseudoVMFNE_VV_MF2, PseudoVMFNE_VV_MF2_MASK, 0x3 }, // 962
  { PseudoVMFNE_VV_MF4_MASK, PseudoVMFNE_VV_MF4, PseudoVMFNE_VV_MF4_MASK, 0x3 }, // 963
  { PseudoVMINU_VV_M1_MASK, PseudoVMINU_VV_M1, PseudoVMINU_VV_M1_TU, 0x3 }, // 964
  { PseudoVMINU_VV_M2_MASK, PseudoVMINU_VV_M2, PseudoVMINU_VV_M2_TU, 0x3 }, // 965
  { PseudoVMINU_VV_M4_MASK, PseudoVMINU_VV_M4, PseudoVMINU_VV_M4_TU, 0x3 }, // 966
  { PseudoVMINU_VV_M8_MASK, PseudoVMINU_VV_M8, PseudoVMINU_VV_M8_TU, 0x3 }, // 967
  { PseudoVMINU_VV_MF2_MASK, PseudoVMINU_VV_MF2, PseudoVMINU_VV_MF2_TU, 0x3 }, // 968
  { PseudoVMINU_VV_MF4_MASK, PseudoVMINU_VV_MF4, PseudoVMINU_VV_MF4_TU, 0x3 }, // 969
  { PseudoVMINU_VV_MF8_MASK, PseudoVMINU_VV_MF8, PseudoVMINU_VV_MF8_TU, 0x3 }, // 970
  { PseudoVMINU_VX_M1_MASK, PseudoVMINU_VX_M1, PseudoVMINU_VX_M1_TU, 0x3 }, // 971
  { PseudoVMINU_VX_M2_MASK, PseudoVMINU_VX_M2, PseudoVMINU_VX_M2_TU, 0x3 }, // 972
  { PseudoVMINU_VX_M4_MASK, PseudoVMINU_VX_M4, PseudoVMINU_VX_M4_TU, 0x3 }, // 973
  { PseudoVMINU_VX_M8_MASK, PseudoVMINU_VX_M8, PseudoVMINU_VX_M8_TU, 0x3 }, // 974
  { PseudoVMINU_VX_MF2_MASK, PseudoVMINU_VX_MF2, PseudoVMINU_VX_MF2_TU, 0x3 }, // 975
  { PseudoVMINU_VX_MF4_MASK, PseudoVMINU_VX_MF4, PseudoVMINU_VX_MF4_TU, 0x3 }, // 976
  { PseudoVMINU_VX_MF8_MASK, PseudoVMINU_VX_MF8, PseudoVMINU_VX_MF8_TU, 0x3 }, // 977
  { PseudoVMIN_VV_M1_MASK, PseudoVMIN_VV_M1, PseudoVMIN_VV_M1_TU, 0x3 }, // 978
  { PseudoVMIN_VV_M2_MASK, PseudoVMIN_VV_M2, PseudoVMIN_VV_M2_TU, 0x3 }, // 979
  { PseudoVMIN_VV_M4_MASK, PseudoVMIN_VV_M4, PseudoVMIN_VV_M4_TU, 0x3 }, // 980
  { PseudoVMIN_VV_M8_MASK, PseudoVMIN_VV_M8, PseudoVMIN_VV_M8_TU, 0x3 }, // 981
  { PseudoVMIN_VV_MF2_MASK, PseudoVMIN_VV_MF2, PseudoVMIN_VV_MF2_TU, 0x3 }, // 982
  { PseudoVMIN_VV_MF4_MASK, PseudoVMIN_VV_MF4, PseudoVMIN_VV_MF4_TU, 0x3 }, // 983
  { PseudoVMIN_VV_MF8_MASK, PseudoVMIN_VV_MF8, PseudoVMIN_VV_MF8_TU, 0x3 }, // 984
  { PseudoVMIN_VX_M1_MASK, PseudoVMIN_VX_M1, PseudoVMIN_VX_M1_TU, 0x3 }, // 985
  { PseudoVMIN_VX_M2_MASK, PseudoVMIN_VX_M2, PseudoVMIN_VX_M2_TU, 0x3 }, // 986
  { PseudoVMIN_VX_M4_MASK, PseudoVMIN_VX_M4, PseudoVMIN_VX_M4_TU, 0x3 }, // 987
  { PseudoVMIN_VX_M8_MASK, PseudoVMIN_VX_M8, PseudoVMIN_VX_M8_TU, 0x3 }, // 988
  { PseudoVMIN_VX_MF2_MASK, PseudoVMIN_VX_MF2, PseudoVMIN_VX_MF2_TU, 0x3 }, // 989
  { PseudoVMIN_VX_MF4_MASK, PseudoVMIN_VX_MF4, PseudoVMIN_VX_MF4_TU, 0x3 }, // 990
  { PseudoVMIN_VX_MF8_MASK, PseudoVMIN_VX_MF8, PseudoVMIN_VX_MF8_TU, 0x3 }, // 991
  { PseudoVMSEQ_VI_M1_MASK, PseudoVMSEQ_VI_M1, PseudoVMSEQ_VI_M1_MASK, 0x3 }, // 992
  { PseudoVMSEQ_VI_M2_MASK, PseudoVMSEQ_VI_M2, PseudoVMSEQ_VI_M2_MASK, 0x3 }, // 993
  { PseudoVMSEQ_VI_M4_MASK, PseudoVMSEQ_VI_M4, PseudoVMSEQ_VI_M4_MASK, 0x3 }, // 994
  { PseudoVMSEQ_VI_M8_MASK, PseudoVMSEQ_VI_M8, PseudoVMSEQ_VI_M8_MASK, 0x3 }, // 995
  { PseudoVMSEQ_VI_MF2_MASK, PseudoVMSEQ_VI_MF2, PseudoVMSEQ_VI_MF2_MASK, 0x3 }, // 996
  { PseudoVMSEQ_VI_MF4_MASK, PseudoVMSEQ_VI_MF4, PseudoVMSEQ_VI_MF4_MASK, 0x3 }, // 997
  { PseudoVMSEQ_VI_MF8_MASK, PseudoVMSEQ_VI_MF8, PseudoVMSEQ_VI_MF8_MASK, 0x3 }, // 998
  { PseudoVMSEQ_VV_M1_MASK, PseudoVMSEQ_VV_M1, PseudoVMSEQ_VV_M1_MASK, 0x3 }, // 999
  { PseudoVMSEQ_VV_M2_MASK, PseudoVMSEQ_VV_M2, PseudoVMSEQ_VV_M2_MASK, 0x3 }, // 1000
  { PseudoVMSEQ_VV_M4_MASK, PseudoVMSEQ_VV_M4, PseudoVMSEQ_VV_M4_MASK, 0x3 }, // 1001
  { PseudoVMSEQ_VV_M8_MASK, PseudoVMSEQ_VV_M8, PseudoVMSEQ_VV_M8_MASK, 0x3 }, // 1002
  { PseudoVMSEQ_VV_MF2_MASK, PseudoVMSEQ_VV_MF2, PseudoVMSEQ_VV_MF2_MASK, 0x3 }, // 1003
  { PseudoVMSEQ_VV_MF4_MASK, PseudoVMSEQ_VV_MF4, PseudoVMSEQ_VV_MF4_MASK, 0x3 }, // 1004
  { PseudoVMSEQ_VV_MF8_MASK, PseudoVMSEQ_VV_MF8, PseudoVMSEQ_VV_MF8_MASK, 0x3 }, // 1005
  { PseudoVMSEQ_VX_M1_MASK, PseudoVMSEQ_VX_M1, PseudoVMSEQ_VX_M1_MASK, 0x3 }, // 1006
  { PseudoVMSEQ_VX_M2_MASK, PseudoVMSEQ_VX_M2, PseudoVMSEQ_VX_M2_MASK, 0x3 }, // 1007
  { PseudoVMSEQ_VX_M4_MASK, PseudoVMSEQ_VX_M4, PseudoVMSEQ_VX_M4_MASK, 0x3 }, // 1008
  { PseudoVMSEQ_VX_M8_MASK, PseudoVMSEQ_VX_M8, PseudoVMSEQ_VX_M8_MASK, 0x3 }, // 1009
  { PseudoVMSEQ_VX_MF2_MASK, PseudoVMSEQ_VX_MF2, PseudoVMSEQ_VX_MF2_MASK, 0x3 }, // 1010
  { PseudoVMSEQ_VX_MF4_MASK, PseudoVMSEQ_VX_MF4, PseudoVMSEQ_VX_MF4_MASK, 0x3 }, // 1011
  { PseudoVMSEQ_VX_MF8_MASK, PseudoVMSEQ_VX_MF8, PseudoVMSEQ_VX_MF8_MASK, 0x3 }, // 1012
  { PseudoVMSGTU_VI_M1_MASK, PseudoVMSGTU_VI_M1, PseudoVMSGTU_VI_M1_MASK, 0x3 }, // 1013
  { PseudoVMSGTU_VI_M2_MASK, PseudoVMSGTU_VI_M2, PseudoVMSGTU_VI_M2_MASK, 0x3 }, // 1014
  { PseudoVMSGTU_VI_M4_MASK, PseudoVMSGTU_VI_M4, PseudoVMSGTU_VI_M4_MASK, 0x3 }, // 1015
  { PseudoVMSGTU_VI_M8_MASK, PseudoVMSGTU_VI_M8, PseudoVMSGTU_VI_M8_MASK, 0x3 }, // 1016
  { PseudoVMSGTU_VI_MF2_MASK, PseudoVMSGTU_VI_MF2, PseudoVMSGTU_VI_MF2_MASK, 0x3 }, // 1017
  { PseudoVMSGTU_VI_MF4_MASK, PseudoVMSGTU_VI_MF4, PseudoVMSGTU_VI_MF4_MASK, 0x3 }, // 1018
  { PseudoVMSGTU_VI_MF8_MASK, PseudoVMSGTU_VI_MF8, PseudoVMSGTU_VI_MF8_MASK, 0x3 }, // 1019
  { PseudoVMSGTU_VX_M1_MASK, PseudoVMSGTU_VX_M1, PseudoVMSGTU_VX_M1_MASK, 0x3 }, // 1020
  { PseudoVMSGTU_VX_M2_MASK, PseudoVMSGTU_VX_M2, PseudoVMSGTU_VX_M2_MASK, 0x3 }, // 1021
  { PseudoVMSGTU_VX_M4_MASK, PseudoVMSGTU_VX_M4, PseudoVMSGTU_VX_M4_MASK, 0x3 }, // 1022
  { PseudoVMSGTU_VX_M8_MASK, PseudoVMSGTU_VX_M8, PseudoVMSGTU_VX_M8_MASK, 0x3 }, // 1023
  { PseudoVMSGTU_VX_MF2_MASK, PseudoVMSGTU_VX_MF2, PseudoVMSGTU_VX_MF2_MASK, 0x3 }, // 1024
  { PseudoVMSGTU_VX_MF4_MASK, PseudoVMSGTU_VX_MF4, PseudoVMSGTU_VX_MF4_MASK, 0x3 }, // 1025
  { PseudoVMSGTU_VX_MF8_MASK, PseudoVMSGTU_VX_MF8, PseudoVMSGTU_VX_MF8_MASK, 0x3 }, // 1026
  { PseudoVMSGT_VI_M1_MASK, PseudoVMSGT_VI_M1, PseudoVMSGT_VI_M1_MASK, 0x3 }, // 1027
  { PseudoVMSGT_VI_M2_MASK, PseudoVMSGT_VI_M2, PseudoVMSGT_VI_M2_MASK, 0x3 }, // 1028
  { PseudoVMSGT_VI_M4_MASK, PseudoVMSGT_VI_M4, PseudoVMSGT_VI_M4_MASK, 0x3 }, // 1029
  { PseudoVMSGT_VI_M8_MASK, PseudoVMSGT_VI_M8, PseudoVMSGT_VI_M8_MASK, 0x3 }, // 1030
  { PseudoVMSGT_VI_MF2_MASK, PseudoVMSGT_VI_MF2, PseudoVMSGT_VI_MF2_MASK, 0x3 }, // 1031
  { PseudoVMSGT_VI_MF4_MASK, PseudoVMSGT_VI_MF4, PseudoVMSGT_VI_MF4_MASK, 0x3 }, // 1032
  { PseudoVMSGT_VI_MF8_MASK, PseudoVMSGT_VI_MF8, PseudoVMSGT_VI_MF8_MASK, 0x3 }, // 1033
  { PseudoVMSGT_VX_M1_MASK, PseudoVMSGT_VX_M1, PseudoVMSGT_VX_M1_MASK, 0x3 }, // 1034
  { PseudoVMSGT_VX_M2_MASK, PseudoVMSGT_VX_M2, PseudoVMSGT_VX_M2_MASK, 0x3 }, // 1035
  { PseudoVMSGT_VX_M4_MASK, PseudoVMSGT_VX_M4, PseudoVMSGT_VX_M4_MASK, 0x3 }, // 1036
  { PseudoVMSGT_VX_M8_MASK, PseudoVMSGT_VX_M8, PseudoVMSGT_VX_M8_MASK, 0x3 }, // 1037
  { PseudoVMSGT_VX_MF2_MASK, PseudoVMSGT_VX_MF2, PseudoVMSGT_VX_MF2_MASK, 0x3 }, // 1038
  { PseudoVMSGT_VX_MF4_MASK, PseudoVMSGT_VX_MF4, PseudoVMSGT_VX_MF4_MASK, 0x3 }, // 1039
  { PseudoVMSGT_VX_MF8_MASK, PseudoVMSGT_VX_MF8, PseudoVMSGT_VX_MF8_MASK, 0x3 }, // 1040
  { PseudoVMSLEU_VI_M1_MASK, PseudoVMSLEU_VI_M1, PseudoVMSLEU_VI_M1_MASK, 0x3 }, // 1041
  { PseudoVMSLEU_VI_M2_MASK, PseudoVMSLEU_VI_M2, PseudoVMSLEU_VI_M2_MASK, 0x3 }, // 1042
  { PseudoVMSLEU_VI_M4_MASK, PseudoVMSLEU_VI_M4, PseudoVMSLEU_VI_M4_MASK, 0x3 }, // 1043
  { PseudoVMSLEU_VI_M8_MASK, PseudoVMSLEU_VI_M8, PseudoVMSLEU_VI_M8_MASK, 0x3 }, // 1044
  { PseudoVMSLEU_VI_MF2_MASK, PseudoVMSLEU_VI_MF2, PseudoVMSLEU_VI_MF2_MASK, 0x3 }, // 1045
  { PseudoVMSLEU_VI_MF4_MASK, PseudoVMSLEU_VI_MF4, PseudoVMSLEU_VI_MF4_MASK, 0x3 }, // 1046
  { PseudoVMSLEU_VI_MF8_MASK, PseudoVMSLEU_VI_MF8, PseudoVMSLEU_VI_MF8_MASK, 0x3 }, // 1047
  { PseudoVMSLEU_VV_M1_MASK, PseudoVMSLEU_VV_M1, PseudoVMSLEU_VV_M1_MASK, 0x3 }, // 1048
  { PseudoVMSLEU_VV_M2_MASK, PseudoVMSLEU_VV_M2, PseudoVMSLEU_VV_M2_MASK, 0x3 }, // 1049
  { PseudoVMSLEU_VV_M4_MASK, PseudoVMSLEU_VV_M4, PseudoVMSLEU_VV_M4_MASK, 0x3 }, // 1050
  { PseudoVMSLEU_VV_M8_MASK, PseudoVMSLEU_VV_M8, PseudoVMSLEU_VV_M8_MASK, 0x3 }, // 1051
  { PseudoVMSLEU_VV_MF2_MASK, PseudoVMSLEU_VV_MF2, PseudoVMSLEU_VV_MF2_MASK, 0x3 }, // 1052
  { PseudoVMSLEU_VV_MF4_MASK, PseudoVMSLEU_VV_MF4, PseudoVMSLEU_VV_MF4_MASK, 0x3 }, // 1053
  { PseudoVMSLEU_VV_MF8_MASK, PseudoVMSLEU_VV_MF8, PseudoVMSLEU_VV_MF8_MASK, 0x3 }, // 1054
  { PseudoVMSLEU_VX_M1_MASK, PseudoVMSLEU_VX_M1, PseudoVMSLEU_VX_M1_MASK, 0x3 }, // 1055
  { PseudoVMSLEU_VX_M2_MASK, PseudoVMSLEU_VX_M2, PseudoVMSLEU_VX_M2_MASK, 0x3 }, // 1056
  { PseudoVMSLEU_VX_M4_MASK, PseudoVMSLEU_VX_M4, PseudoVMSLEU_VX_M4_MASK, 0x3 }, // 1057
  { PseudoVMSLEU_VX_M8_MASK, PseudoVMSLEU_VX_M8, PseudoVMSLEU_VX_M8_MASK, 0x3 }, // 1058
  { PseudoVMSLEU_VX_MF2_MASK, PseudoVMSLEU_VX_MF2, PseudoVMSLEU_VX_MF2_MASK, 0x3 }, // 1059
  { PseudoVMSLEU_VX_MF4_MASK, PseudoVMSLEU_VX_MF4, PseudoVMSLEU_VX_MF4_MASK, 0x3 }, // 1060
  { PseudoVMSLEU_VX_MF8_MASK, PseudoVMSLEU_VX_MF8, PseudoVMSLEU_VX_MF8_MASK, 0x3 }, // 1061
  { PseudoVMSLE_VI_M1_MASK, PseudoVMSLE_VI_M1, PseudoVMSLE_VI_M1_MASK, 0x3 }, // 1062
  { PseudoVMSLE_VI_M2_MASK, PseudoVMSLE_VI_M2, PseudoVMSLE_VI_M2_MASK, 0x3 }, // 1063
  { PseudoVMSLE_VI_M4_MASK, PseudoVMSLE_VI_M4, PseudoVMSLE_VI_M4_MASK, 0x3 }, // 1064
  { PseudoVMSLE_VI_M8_MASK, PseudoVMSLE_VI_M8, PseudoVMSLE_VI_M8_MASK, 0x3 }, // 1065
  { PseudoVMSLE_VI_MF2_MASK, PseudoVMSLE_VI_MF2, PseudoVMSLE_VI_MF2_MASK, 0x3 }, // 1066
  { PseudoVMSLE_VI_MF4_MASK, PseudoVMSLE_VI_MF4, PseudoVMSLE_VI_MF4_MASK, 0x3 }, // 1067
  { PseudoVMSLE_VI_MF8_MASK, PseudoVMSLE_VI_MF8, PseudoVMSLE_VI_MF8_MASK, 0x3 }, // 1068
  { PseudoVMSLE_VV_M1_MASK, PseudoVMSLE_VV_M1, PseudoVMSLE_VV_M1_MASK, 0x3 }, // 1069
  { PseudoVMSLE_VV_M2_MASK, PseudoVMSLE_VV_M2, PseudoVMSLE_VV_M2_MASK, 0x3 }, // 1070
  { PseudoVMSLE_VV_M4_MASK, PseudoVMSLE_VV_M4, PseudoVMSLE_VV_M4_MASK, 0x3 }, // 1071
  { PseudoVMSLE_VV_M8_MASK, PseudoVMSLE_VV_M8, PseudoVMSLE_VV_M8_MASK, 0x3 }, // 1072
  { PseudoVMSLE_VV_MF2_MASK, PseudoVMSLE_VV_MF2, PseudoVMSLE_VV_MF2_MASK, 0x3 }, // 1073
  { PseudoVMSLE_VV_MF4_MASK, PseudoVMSLE_VV_MF4, PseudoVMSLE_VV_MF4_MASK, 0x3 }, // 1074
  { PseudoVMSLE_VV_MF8_MASK, PseudoVMSLE_VV_MF8, PseudoVMSLE_VV_MF8_MASK, 0x3 }, // 1075
  { PseudoVMSLE_VX_M1_MASK, PseudoVMSLE_VX_M1, PseudoVMSLE_VX_M1_MASK, 0x3 }, // 1076
  { PseudoVMSLE_VX_M2_MASK, PseudoVMSLE_VX_M2, PseudoVMSLE_VX_M2_MASK, 0x3 }, // 1077
  { PseudoVMSLE_VX_M4_MASK, PseudoVMSLE_VX_M4, PseudoVMSLE_VX_M4_MASK, 0x3 }, // 1078
  { PseudoVMSLE_VX_M8_MASK, PseudoVMSLE_VX_M8, PseudoVMSLE_VX_M8_MASK, 0x3 }, // 1079
  { PseudoVMSLE_VX_MF2_MASK, PseudoVMSLE_VX_MF2, PseudoVMSLE_VX_MF2_MASK, 0x3 }, // 1080
  { PseudoVMSLE_VX_MF4_MASK, PseudoVMSLE_VX_MF4, PseudoVMSLE_VX_MF4_MASK, 0x3 }, // 1081
  { PseudoVMSLE_VX_MF8_MASK, PseudoVMSLE_VX_MF8, PseudoVMSLE_VX_MF8_MASK, 0x3 }, // 1082
  { PseudoVMSLTU_VV_M1_MASK, PseudoVMSLTU_VV_M1, PseudoVMSLTU_VV_M1_MASK, 0x3 }, // 1083
  { PseudoVMSLTU_VV_M2_MASK, PseudoVMSLTU_VV_M2, PseudoVMSLTU_VV_M2_MASK, 0x3 }, // 1084
  { PseudoVMSLTU_VV_M4_MASK, PseudoVMSLTU_VV_M4, PseudoVMSLTU_VV_M4_MASK, 0x3 }, // 1085
  { PseudoVMSLTU_VV_M8_MASK, PseudoVMSLTU_VV_M8, PseudoVMSLTU_VV_M8_MASK, 0x3 }, // 1086
  { PseudoVMSLTU_VV_MF2_MASK, PseudoVMSLTU_VV_MF2, PseudoVMSLTU_VV_MF2_MASK, 0x3 }, // 1087
  { PseudoVMSLTU_VV_MF4_MASK, PseudoVMSLTU_VV_MF4, PseudoVMSLTU_VV_MF4_MASK, 0x3 }, // 1088
  { PseudoVMSLTU_VV_MF8_MASK, PseudoVMSLTU_VV_MF8, PseudoVMSLTU_VV_MF8_MASK, 0x3 }, // 1089
  { PseudoVMSLTU_VX_M1_MASK, PseudoVMSLTU_VX_M1, PseudoVMSLTU_VX_M1_MASK, 0x3 }, // 1090
  { PseudoVMSLTU_VX_M2_MASK, PseudoVMSLTU_VX_M2, PseudoVMSLTU_VX_M2_MASK, 0x3 }, // 1091
  { PseudoVMSLTU_VX_M4_MASK, PseudoVMSLTU_VX_M4, PseudoVMSLTU_VX_M4_MASK, 0x3 }, // 1092
  { PseudoVMSLTU_VX_M8_MASK, PseudoVMSLTU_VX_M8, PseudoVMSLTU_VX_M8_MASK, 0x3 }, // 1093
  { PseudoVMSLTU_VX_MF2_MASK, PseudoVMSLTU_VX_MF2, PseudoVMSLTU_VX_MF2_MASK, 0x3 }, // 1094
  { PseudoVMSLTU_VX_MF4_MASK, PseudoVMSLTU_VX_MF4, PseudoVMSLTU_VX_MF4_MASK, 0x3 }, // 1095
  { PseudoVMSLTU_VX_MF8_MASK, PseudoVMSLTU_VX_MF8, PseudoVMSLTU_VX_MF8_MASK, 0x3 }, // 1096
  { PseudoVMSLT_VV_M1_MASK, PseudoVMSLT_VV_M1, PseudoVMSLT_VV_M1_MASK, 0x3 }, // 1097
  { PseudoVMSLT_VV_M2_MASK, PseudoVMSLT_VV_M2, PseudoVMSLT_VV_M2_MASK, 0x3 }, // 1098
  { PseudoVMSLT_VV_M4_MASK, PseudoVMSLT_VV_M4, PseudoVMSLT_VV_M4_MASK, 0x3 }, // 1099
  { PseudoVMSLT_VV_M8_MASK, PseudoVMSLT_VV_M8, PseudoVMSLT_VV_M8_MASK, 0x3 }, // 1100
  { PseudoVMSLT_VV_MF2_MASK, PseudoVMSLT_VV_MF2, PseudoVMSLT_VV_MF2_MASK, 0x3 }, // 1101
  { PseudoVMSLT_VV_MF4_MASK, PseudoVMSLT_VV_MF4, PseudoVMSLT_VV_MF4_MASK, 0x3 }, // 1102
  { PseudoVMSLT_VV_MF8_MASK, PseudoVMSLT_VV_MF8, PseudoVMSLT_VV_MF8_MASK, 0x3 }, // 1103
  { PseudoVMSLT_VX_M1_MASK, PseudoVMSLT_VX_M1, PseudoVMSLT_VX_M1_MASK, 0x3 }, // 1104
  { PseudoVMSLT_VX_M2_MASK, PseudoVMSLT_VX_M2, PseudoVMSLT_VX_M2_MASK, 0x3 }, // 1105
  { PseudoVMSLT_VX_M4_MASK, PseudoVMSLT_VX_M4, PseudoVMSLT_VX_M4_MASK, 0x3 }, // 1106
  { PseudoVMSLT_VX_M8_MASK, PseudoVMSLT_VX_M8, PseudoVMSLT_VX_M8_MASK, 0x3 }, // 1107
  { PseudoVMSLT_VX_MF2_MASK, PseudoVMSLT_VX_MF2, PseudoVMSLT_VX_MF2_MASK, 0x3 }, // 1108
  { PseudoVMSLT_VX_MF4_MASK, PseudoVMSLT_VX_MF4, PseudoVMSLT_VX_MF4_MASK, 0x3 }, // 1109
  { PseudoVMSLT_VX_MF8_MASK, PseudoVMSLT_VX_MF8, PseudoVMSLT_VX_MF8_MASK, 0x3 }, // 1110
  { PseudoVMSNE_VI_M1_MASK, PseudoVMSNE_VI_M1, PseudoVMSNE_VI_M1_MASK, 0x3 }, // 1111
  { PseudoVMSNE_VI_M2_MASK, PseudoVMSNE_VI_M2, PseudoVMSNE_VI_M2_MASK, 0x3 }, // 1112
  { PseudoVMSNE_VI_M4_MASK, PseudoVMSNE_VI_M4, PseudoVMSNE_VI_M4_MASK, 0x3 }, // 1113
  { PseudoVMSNE_VI_M8_MASK, PseudoVMSNE_VI_M8, PseudoVMSNE_VI_M8_MASK, 0x3 }, // 1114
  { PseudoVMSNE_VI_MF2_MASK, PseudoVMSNE_VI_MF2, PseudoVMSNE_VI_MF2_MASK, 0x3 }, // 1115
  { PseudoVMSNE_VI_MF4_MASK, PseudoVMSNE_VI_MF4, PseudoVMSNE_VI_MF4_MASK, 0x3 }, // 1116
  { PseudoVMSNE_VI_MF8_MASK, PseudoVMSNE_VI_MF8, PseudoVMSNE_VI_MF8_MASK, 0x3 }, // 1117
  { PseudoVMSNE_VV_M1_MASK, PseudoVMSNE_VV_M1, PseudoVMSNE_VV_M1_MASK, 0x3 }, // 1118
  { PseudoVMSNE_VV_M2_MASK, PseudoVMSNE_VV_M2, PseudoVMSNE_VV_M2_MASK, 0x3 }, // 1119
  { PseudoVMSNE_VV_M4_MASK, PseudoVMSNE_VV_M4, PseudoVMSNE_VV_M4_MASK, 0x3 }, // 1120
  { PseudoVMSNE_VV_M8_MASK, PseudoVMSNE_VV_M8, PseudoVMSNE_VV_M8_MASK, 0x3 }, // 1121
  { PseudoVMSNE_VV_MF2_MASK, PseudoVMSNE_VV_MF2, PseudoVMSNE_VV_MF2_MASK, 0x3 }, // 1122
  { PseudoVMSNE_VV_MF4_MASK, PseudoVMSNE_VV_MF4, PseudoVMSNE_VV_MF4_MASK, 0x3 }, // 1123
  { PseudoVMSNE_VV_MF8_MASK, PseudoVMSNE_VV_MF8, PseudoVMSNE_VV_MF8_MASK, 0x3 }, // 1124
  { PseudoVMSNE_VX_M1_MASK, PseudoVMSNE_VX_M1, PseudoVMSNE_VX_M1_MASK, 0x3 }, // 1125
  { PseudoVMSNE_VX_M2_MASK, PseudoVMSNE_VX_M2, PseudoVMSNE_VX_M2_MASK, 0x3 }, // 1126
  { PseudoVMSNE_VX_M4_MASK, PseudoVMSNE_VX_M4, PseudoVMSNE_VX_M4_MASK, 0x3 }, // 1127
  { PseudoVMSNE_VX_M8_MASK, PseudoVMSNE_VX_M8, PseudoVMSNE_VX_M8_MASK, 0x3 }, // 1128
  { PseudoVMSNE_VX_MF2_MASK, PseudoVMSNE_VX_MF2, PseudoVMSNE_VX_MF2_MASK, 0x3 }, // 1129
  { PseudoVMSNE_VX_MF4_MASK, PseudoVMSNE_VX_MF4, PseudoVMSNE_VX_MF4_MASK, 0x3 }, // 1130
  { PseudoVMSNE_VX_MF8_MASK, PseudoVMSNE_VX_MF8, PseudoVMSNE_VX_MF8_MASK, 0x3 }, // 1131
  { PseudoVMULHSU_VV_M1_MASK, PseudoVMULHSU_VV_M1, PseudoVMULHSU_VV_M1_TU, 0x3 }, // 1132
  { PseudoVMULHSU_VV_M2_MASK, PseudoVMULHSU_VV_M2, PseudoVMULHSU_VV_M2_TU, 0x3 }, // 1133
  { PseudoVMULHSU_VV_M4_MASK, PseudoVMULHSU_VV_M4, PseudoVMULHSU_VV_M4_TU, 0x3 }, // 1134
  { PseudoVMULHSU_VV_M8_MASK, PseudoVMULHSU_VV_M8, PseudoVMULHSU_VV_M8_TU, 0x3 }, // 1135
  { PseudoVMULHSU_VV_MF2_MASK, PseudoVMULHSU_VV_MF2, PseudoVMULHSU_VV_MF2_TU, 0x3 }, // 1136
  { PseudoVMULHSU_VV_MF4_MASK, PseudoVMULHSU_VV_MF4, PseudoVMULHSU_VV_MF4_TU, 0x3 }, // 1137
  { PseudoVMULHSU_VV_MF8_MASK, PseudoVMULHSU_VV_MF8, PseudoVMULHSU_VV_MF8_TU, 0x3 }, // 1138
  { PseudoVMULHSU_VX_M1_MASK, PseudoVMULHSU_VX_M1, PseudoVMULHSU_VX_M1_TU, 0x3 }, // 1139
  { PseudoVMULHSU_VX_M2_MASK, PseudoVMULHSU_VX_M2, PseudoVMULHSU_VX_M2_TU, 0x3 }, // 1140
  { PseudoVMULHSU_VX_M4_MASK, PseudoVMULHSU_VX_M4, PseudoVMULHSU_VX_M4_TU, 0x3 }, // 1141
  { PseudoVMULHSU_VX_M8_MASK, PseudoVMULHSU_VX_M8, PseudoVMULHSU_VX_M8_TU, 0x3 }, // 1142
  { PseudoVMULHSU_VX_MF2_MASK, PseudoVMULHSU_VX_MF2, PseudoVMULHSU_VX_MF2_TU, 0x3 }, // 1143
  { PseudoVMULHSU_VX_MF4_MASK, PseudoVMULHSU_VX_MF4, PseudoVMULHSU_VX_MF4_TU, 0x3 }, // 1144
  { PseudoVMULHSU_VX_MF8_MASK, PseudoVMULHSU_VX_MF8, PseudoVMULHSU_VX_MF8_TU, 0x3 }, // 1145
  { PseudoVMULHU_VV_M1_MASK, PseudoVMULHU_VV_M1, PseudoVMULHU_VV_M1_TU, 0x3 }, // 1146
  { PseudoVMULHU_VV_M2_MASK, PseudoVMULHU_VV_M2, PseudoVMULHU_VV_M2_TU, 0x3 }, // 1147
  { PseudoVMULHU_VV_M4_MASK, PseudoVMULHU_VV_M4, PseudoVMULHU_VV_M4_TU, 0x3 }, // 1148
  { PseudoVMULHU_VV_M8_MASK, PseudoVMULHU_VV_M8, PseudoVMULHU_VV_M8_TU, 0x3 }, // 1149
  { PseudoVMULHU_VV_MF2_MASK, PseudoVMULHU_VV_MF2, PseudoVMULHU_VV_MF2_TU, 0x3 }, // 1150
  { PseudoVMULHU_VV_MF4_MASK, PseudoVMULHU_VV_MF4, PseudoVMULHU_VV_MF4_TU, 0x3 }, // 1151
  { PseudoVMULHU_VV_MF8_MASK, PseudoVMULHU_VV_MF8, PseudoVMULHU_VV_MF8_TU, 0x3 }, // 1152
  { PseudoVMULHU_VX_M1_MASK, PseudoVMULHU_VX_M1, PseudoVMULHU_VX_M1_TU, 0x3 }, // 1153
  { PseudoVMULHU_VX_M2_MASK, PseudoVMULHU_VX_M2, PseudoVMULHU_VX_M2_TU, 0x3 }, // 1154
  { PseudoVMULHU_VX_M4_MASK, PseudoVMULHU_VX_M4, PseudoVMULHU_VX_M4_TU, 0x3 }, // 1155
  { PseudoVMULHU_VX_M8_MASK, PseudoVMULHU_VX_M8, PseudoVMULHU_VX_M8_TU, 0x3 }, // 1156
  { PseudoVMULHU_VX_MF2_MASK, PseudoVMULHU_VX_MF2, PseudoVMULHU_VX_MF2_TU, 0x3 }, // 1157
  { PseudoVMULHU_VX_MF4_MASK, PseudoVMULHU_VX_MF4, PseudoVMULHU_VX_MF4_TU, 0x3 }, // 1158
  { PseudoVMULHU_VX_MF8_MASK, PseudoVMULHU_VX_MF8, PseudoVMULHU_VX_MF8_TU, 0x3 }, // 1159
  { PseudoVMULH_VV_M1_MASK, PseudoVMULH_VV_M1, PseudoVMULH_VV_M1_TU, 0x3 }, // 1160
  { PseudoVMULH_VV_M2_MASK, PseudoVMULH_VV_M2, PseudoVMULH_VV_M2_TU, 0x3 }, // 1161
  { PseudoVMULH_VV_M4_MASK, PseudoVMULH_VV_M4, PseudoVMULH_VV_M4_TU, 0x3 }, // 1162
  { PseudoVMULH_VV_M8_MASK, PseudoVMULH_VV_M8, PseudoVMULH_VV_M8_TU, 0x3 }, // 1163
  { PseudoVMULH_VV_MF2_MASK, PseudoVMULH_VV_MF2, PseudoVMULH_VV_MF2_TU, 0x3 }, // 1164
  { PseudoVMULH_VV_MF4_MASK, PseudoVMULH_VV_MF4, PseudoVMULH_VV_MF4_TU, 0x3 }, // 1165
  { PseudoVMULH_VV_MF8_MASK, PseudoVMULH_VV_MF8, PseudoVMULH_VV_MF8_TU, 0x3 }, // 1166
  { PseudoVMULH_VX_M1_MASK, PseudoVMULH_VX_M1, PseudoVMULH_VX_M1_TU, 0x3 }, // 1167
  { PseudoVMULH_VX_M2_MASK, PseudoVMULH_VX_M2, PseudoVMULH_VX_M2_TU, 0x3 }, // 1168
  { PseudoVMULH_VX_M4_MASK, PseudoVMULH_VX_M4, PseudoVMULH_VX_M4_TU, 0x3 }, // 1169
  { PseudoVMULH_VX_M8_MASK, PseudoVMULH_VX_M8, PseudoVMULH_VX_M8_TU, 0x3 }, // 1170
  { PseudoVMULH_VX_MF2_MASK, PseudoVMULH_VX_MF2, PseudoVMULH_VX_MF2_TU, 0x3 }, // 1171
  { PseudoVMULH_VX_MF4_MASK, PseudoVMULH_VX_MF4, PseudoVMULH_VX_MF4_TU, 0x3 }, // 1172
  { PseudoVMULH_VX_MF8_MASK, PseudoVMULH_VX_MF8, PseudoVMULH_VX_MF8_TU, 0x3 }, // 1173
  { PseudoVMUL_VV_M1_MASK, PseudoVMUL_VV_M1, PseudoVMUL_VV_M1_TU, 0x3 }, // 1174
  { PseudoVMUL_VV_M2_MASK, PseudoVMUL_VV_M2, PseudoVMUL_VV_M2_TU, 0x3 }, // 1175
  { PseudoVMUL_VV_M4_MASK, PseudoVMUL_VV_M4, PseudoVMUL_VV_M4_TU, 0x3 }, // 1176
  { PseudoVMUL_VV_M8_MASK, PseudoVMUL_VV_M8, PseudoVMUL_VV_M8_TU, 0x3 }, // 1177
  { PseudoVMUL_VV_MF2_MASK, PseudoVMUL_VV_MF2, PseudoVMUL_VV_MF2_TU, 0x3 }, // 1178
  { PseudoVMUL_VV_MF4_MASK, PseudoVMUL_VV_MF4, PseudoVMUL_VV_MF4_TU, 0x3 }, // 1179
  { PseudoVMUL_VV_MF8_MASK, PseudoVMUL_VV_MF8, PseudoVMUL_VV_MF8_TU, 0x3 }, // 1180
  { PseudoVMUL_VX_M1_MASK, PseudoVMUL_VX_M1, PseudoVMUL_VX_M1_TU, 0x3 }, // 1181
  { PseudoVMUL_VX_M2_MASK, PseudoVMUL_VX_M2, PseudoVMUL_VX_M2_TU, 0x3 }, // 1182
  { PseudoVMUL_VX_M4_MASK, PseudoVMUL_VX_M4, PseudoVMUL_VX_M4_TU, 0x3 }, // 1183
  { PseudoVMUL_VX_M8_MASK, PseudoVMUL_VX_M8, PseudoVMUL_VX_M8_TU, 0x3 }, // 1184
  { PseudoVMUL_VX_MF2_MASK, PseudoVMUL_VX_MF2, PseudoVMUL_VX_MF2_TU, 0x3 }, // 1185
  { PseudoVMUL_VX_MF4_MASK, PseudoVMUL_VX_MF4, PseudoVMUL_VX_MF4_TU, 0x3 }, // 1186
  { PseudoVMUL_VX_MF8_MASK, PseudoVMUL_VX_MF8, PseudoVMUL_VX_MF8_TU, 0x3 }, // 1187
  { PseudoVNCLIPU_WI_M1_MASK, PseudoVNCLIPU_WI_M1, PseudoVNCLIPU_WI_M1_TU, 0x3 }, // 1188
  { PseudoVNCLIPU_WI_M2_MASK, PseudoVNCLIPU_WI_M2, PseudoVNCLIPU_WI_M2_TU, 0x3 }, // 1189
  { PseudoVNCLIPU_WI_M4_MASK, PseudoVNCLIPU_WI_M4, PseudoVNCLIPU_WI_M4_TU, 0x3 }, // 1190
  { PseudoVNCLIPU_WI_MF2_MASK, PseudoVNCLIPU_WI_MF2, PseudoVNCLIPU_WI_MF2_TU, 0x3 }, // 1191
  { PseudoVNCLIPU_WI_MF4_MASK, PseudoVNCLIPU_WI_MF4, PseudoVNCLIPU_WI_MF4_TU, 0x3 }, // 1192
  { PseudoVNCLIPU_WI_MF8_MASK, PseudoVNCLIPU_WI_MF8, PseudoVNCLIPU_WI_MF8_TU, 0x3 }, // 1193
  { PseudoVNCLIPU_WV_M1_MASK, PseudoVNCLIPU_WV_M1, PseudoVNCLIPU_WV_M1_TU, 0x3 }, // 1194
  { PseudoVNCLIPU_WV_M2_MASK, PseudoVNCLIPU_WV_M2, PseudoVNCLIPU_WV_M2_TU, 0x3 }, // 1195
  { PseudoVNCLIPU_WV_M4_MASK, PseudoVNCLIPU_WV_M4, PseudoVNCLIPU_WV_M4_TU, 0x3 }, // 1196
  { PseudoVNCLIPU_WV_MF2_MASK, PseudoVNCLIPU_WV_MF2, PseudoVNCLIPU_WV_MF2_TU, 0x3 }, // 1197
  { PseudoVNCLIPU_WV_MF4_MASK, PseudoVNCLIPU_WV_MF4, PseudoVNCLIPU_WV_MF4_TU, 0x3 }, // 1198
  { PseudoVNCLIPU_WV_MF8_MASK, PseudoVNCLIPU_WV_MF8, PseudoVNCLIPU_WV_MF8_TU, 0x3 }, // 1199
  { PseudoVNCLIPU_WX_M1_MASK, PseudoVNCLIPU_WX_M1, PseudoVNCLIPU_WX_M1_TU, 0x3 }, // 1200
  { PseudoVNCLIPU_WX_M2_MASK, PseudoVNCLIPU_WX_M2, PseudoVNCLIPU_WX_M2_TU, 0x3 }, // 1201
  { PseudoVNCLIPU_WX_M4_MASK, PseudoVNCLIPU_WX_M4, PseudoVNCLIPU_WX_M4_TU, 0x3 }, // 1202
  { PseudoVNCLIPU_WX_MF2_MASK, PseudoVNCLIPU_WX_MF2, PseudoVNCLIPU_WX_MF2_TU, 0x3 }, // 1203
  { PseudoVNCLIPU_WX_MF4_MASK, PseudoVNCLIPU_WX_MF4, PseudoVNCLIPU_WX_MF4_TU, 0x3 }, // 1204
  { PseudoVNCLIPU_WX_MF8_MASK, PseudoVNCLIPU_WX_MF8, PseudoVNCLIPU_WX_MF8_TU, 0x3 }, // 1205
  { PseudoVNCLIP_WI_M1_MASK, PseudoVNCLIP_WI_M1, PseudoVNCLIP_WI_M1_TU, 0x3 }, // 1206
  { PseudoVNCLIP_WI_M2_MASK, PseudoVNCLIP_WI_M2, PseudoVNCLIP_WI_M2_TU, 0x3 }, // 1207
  { PseudoVNCLIP_WI_M4_MASK, PseudoVNCLIP_WI_M4, PseudoVNCLIP_WI_M4_TU, 0x3 }, // 1208
  { PseudoVNCLIP_WI_MF2_MASK, PseudoVNCLIP_WI_MF2, PseudoVNCLIP_WI_MF2_TU, 0x3 }, // 1209
  { PseudoVNCLIP_WI_MF4_MASK, PseudoVNCLIP_WI_MF4, PseudoVNCLIP_WI_MF4_TU, 0x3 }, // 1210
  { PseudoVNCLIP_WI_MF8_MASK, PseudoVNCLIP_WI_MF8, PseudoVNCLIP_WI_MF8_TU, 0x3 }, // 1211
  { PseudoVNCLIP_WV_M1_MASK, PseudoVNCLIP_WV_M1, PseudoVNCLIP_WV_M1_TU, 0x3 }, // 1212
  { PseudoVNCLIP_WV_M2_MASK, PseudoVNCLIP_WV_M2, PseudoVNCLIP_WV_M2_TU, 0x3 }, // 1213
  { PseudoVNCLIP_WV_M4_MASK, PseudoVNCLIP_WV_M4, PseudoVNCLIP_WV_M4_TU, 0x3 }, // 1214
  { PseudoVNCLIP_WV_MF2_MASK, PseudoVNCLIP_WV_MF2, PseudoVNCLIP_WV_MF2_TU, 0x3 }, // 1215
  { PseudoVNCLIP_WV_MF4_MASK, PseudoVNCLIP_WV_MF4, PseudoVNCLIP_WV_MF4_TU, 0x3 }, // 1216
  { PseudoVNCLIP_WV_MF8_MASK, PseudoVNCLIP_WV_MF8, PseudoVNCLIP_WV_MF8_TU, 0x3 }, // 1217
  { PseudoVNCLIP_WX_M1_MASK, PseudoVNCLIP_WX_M1, PseudoVNCLIP_WX_M1_TU, 0x3 }, // 1218
  { PseudoVNCLIP_WX_M2_MASK, PseudoVNCLIP_WX_M2, PseudoVNCLIP_WX_M2_TU, 0x3 }, // 1219
  { PseudoVNCLIP_WX_M4_MASK, PseudoVNCLIP_WX_M4, PseudoVNCLIP_WX_M4_TU, 0x3 }, // 1220
  { PseudoVNCLIP_WX_MF2_MASK, PseudoVNCLIP_WX_MF2, PseudoVNCLIP_WX_MF2_TU, 0x3 }, // 1221
  { PseudoVNCLIP_WX_MF4_MASK, PseudoVNCLIP_WX_MF4, PseudoVNCLIP_WX_MF4_TU, 0x3 }, // 1222
  { PseudoVNCLIP_WX_MF8_MASK, PseudoVNCLIP_WX_MF8, PseudoVNCLIP_WX_MF8_TU, 0x3 }, // 1223
  { PseudoVNSRA_WI_M1_MASK, PseudoVNSRA_WI_M1, PseudoVNSRA_WI_M1_TU, 0x3 }, // 1224
  { PseudoVNSRA_WI_M2_MASK, PseudoVNSRA_WI_M2, PseudoVNSRA_WI_M2_TU, 0x3 }, // 1225
  { PseudoVNSRA_WI_M4_MASK, PseudoVNSRA_WI_M4, PseudoVNSRA_WI_M4_TU, 0x3 }, // 1226
  { PseudoVNSRA_WI_MF2_MASK, PseudoVNSRA_WI_MF2, PseudoVNSRA_WI_MF2_TU, 0x3 }, // 1227
  { PseudoVNSRA_WI_MF4_MASK, PseudoVNSRA_WI_MF4, PseudoVNSRA_WI_MF4_TU, 0x3 }, // 1228
  { PseudoVNSRA_WI_MF8_MASK, PseudoVNSRA_WI_MF8, PseudoVNSRA_WI_MF8_TU, 0x3 }, // 1229
  { PseudoVNSRA_WV_M1_MASK, PseudoVNSRA_WV_M1, PseudoVNSRA_WV_M1_TU, 0x3 }, // 1230
  { PseudoVNSRA_WV_M2_MASK, PseudoVNSRA_WV_M2, PseudoVNSRA_WV_M2_TU, 0x3 }, // 1231
  { PseudoVNSRA_WV_M4_MASK, PseudoVNSRA_WV_M4, PseudoVNSRA_WV_M4_TU, 0x3 }, // 1232
  { PseudoVNSRA_WV_MF2_MASK, PseudoVNSRA_WV_MF2, PseudoVNSRA_WV_MF2_TU, 0x3 }, // 1233
  { PseudoVNSRA_WV_MF4_MASK, PseudoVNSRA_WV_MF4, PseudoVNSRA_WV_MF4_TU, 0x3 }, // 1234
  { PseudoVNSRA_WV_MF8_MASK, PseudoVNSRA_WV_MF8, PseudoVNSRA_WV_MF8_TU, 0x3 }, // 1235
  { PseudoVNSRA_WX_M1_MASK, PseudoVNSRA_WX_M1, PseudoVNSRA_WX_M1_TU, 0x3 }, // 1236
  { PseudoVNSRA_WX_M2_MASK, PseudoVNSRA_WX_M2, PseudoVNSRA_WX_M2_TU, 0x3 }, // 1237
  { PseudoVNSRA_WX_M4_MASK, PseudoVNSRA_WX_M4, PseudoVNSRA_WX_M4_TU, 0x3 }, // 1238
  { PseudoVNSRA_WX_MF2_MASK, PseudoVNSRA_WX_MF2, PseudoVNSRA_WX_MF2_TU, 0x3 }, // 1239
  { PseudoVNSRA_WX_MF4_MASK, PseudoVNSRA_WX_MF4, PseudoVNSRA_WX_MF4_TU, 0x3 }, // 1240
  { PseudoVNSRA_WX_MF8_MASK, PseudoVNSRA_WX_MF8, PseudoVNSRA_WX_MF8_TU, 0x3 }, // 1241
  { PseudoVNSRL_WI_M1_MASK, PseudoVNSRL_WI_M1, PseudoVNSRL_WI_M1_TU, 0x3 }, // 1242
  { PseudoVNSRL_WI_M2_MASK, PseudoVNSRL_WI_M2, PseudoVNSRL_WI_M2_TU, 0x3 }, // 1243
  { PseudoVNSRL_WI_M4_MASK, PseudoVNSRL_WI_M4, PseudoVNSRL_WI_M4_TU, 0x3 }, // 1244
  { PseudoVNSRL_WI_MF2_MASK, PseudoVNSRL_WI_MF2, PseudoVNSRL_WI_MF2_TU, 0x3 }, // 1245
  { PseudoVNSRL_WI_MF4_MASK, PseudoVNSRL_WI_MF4, PseudoVNSRL_WI_MF4_TU, 0x3 }, // 1246
  { PseudoVNSRL_WI_MF8_MASK, PseudoVNSRL_WI_MF8, PseudoVNSRL_WI_MF8_TU, 0x3 }, // 1247
  { PseudoVNSRL_WV_M1_MASK, PseudoVNSRL_WV_M1, PseudoVNSRL_WV_M1_TU, 0x3 }, // 1248
  { PseudoVNSRL_WV_M2_MASK, PseudoVNSRL_WV_M2, PseudoVNSRL_WV_M2_TU, 0x3 }, // 1249
  { PseudoVNSRL_WV_M4_MASK, PseudoVNSRL_WV_M4, PseudoVNSRL_WV_M4_TU, 0x3 }, // 1250
  { PseudoVNSRL_WV_MF2_MASK, PseudoVNSRL_WV_MF2, PseudoVNSRL_WV_MF2_TU, 0x3 }, // 1251
  { PseudoVNSRL_WV_MF4_MASK, PseudoVNSRL_WV_MF4, PseudoVNSRL_WV_MF4_TU, 0x3 }, // 1252
  { PseudoVNSRL_WV_MF8_MASK, PseudoVNSRL_WV_MF8, PseudoVNSRL_WV_MF8_TU, 0x3 }, // 1253
  { PseudoVNSRL_WX_M1_MASK, PseudoVNSRL_WX_M1, PseudoVNSRL_WX_M1_TU, 0x3 }, // 1254
  { PseudoVNSRL_WX_M2_MASK, PseudoVNSRL_WX_M2, PseudoVNSRL_WX_M2_TU, 0x3 }, // 1255
  { PseudoVNSRL_WX_M4_MASK, PseudoVNSRL_WX_M4, PseudoVNSRL_WX_M4_TU, 0x3 }, // 1256
  { PseudoVNSRL_WX_MF2_MASK, PseudoVNSRL_WX_MF2, PseudoVNSRL_WX_MF2_TU, 0x3 }, // 1257
  { PseudoVNSRL_WX_MF4_MASK, PseudoVNSRL_WX_MF4, PseudoVNSRL_WX_MF4_TU, 0x3 }, // 1258
  { PseudoVNSRL_WX_MF8_MASK, PseudoVNSRL_WX_MF8, PseudoVNSRL_WX_MF8_TU, 0x3 }, // 1259
  { PseudoVOR_VI_M1_MASK, PseudoVOR_VI_M1, PseudoVOR_VI_M1_TU, 0x3 }, // 1260
  { PseudoVOR_VI_M2_MASK, PseudoVOR_VI_M2, PseudoVOR_VI_M2_TU, 0x3 }, // 1261
  { PseudoVOR_VI_M4_MASK, PseudoVOR_VI_M4, PseudoVOR_VI_M4_TU, 0x3 }, // 1262
  { PseudoVOR_VI_M8_MASK, PseudoVOR_VI_M8, PseudoVOR_VI_M8_TU, 0x3 }, // 1263
  { PseudoVOR_VI_MF2_MASK, PseudoVOR_VI_MF2, PseudoVOR_VI_MF2_TU, 0x3 }, // 1264
  { PseudoVOR_VI_MF4_MASK, PseudoVOR_VI_MF4, PseudoVOR_VI_MF4_TU, 0x3 }, // 1265
  { PseudoVOR_VI_MF8_MASK, PseudoVOR_VI_MF8, PseudoVOR_VI_MF8_TU, 0x3 }, // 1266
  { PseudoVOR_VV_M1_MASK, PseudoVOR_VV_M1, PseudoVOR_VV_M1_TU, 0x3 }, // 1267
  { PseudoVOR_VV_M2_MASK, PseudoVOR_VV_M2, PseudoVOR_VV_M2_TU, 0x3 }, // 1268
  { PseudoVOR_VV_M4_MASK, PseudoVOR_VV_M4, PseudoVOR_VV_M4_TU, 0x3 }, // 1269
  { PseudoVOR_VV_M8_MASK, PseudoVOR_VV_M8, PseudoVOR_VV_M8_TU, 0x3 }, // 1270
  { PseudoVOR_VV_MF2_MASK, PseudoVOR_VV_MF2, PseudoVOR_VV_MF2_TU, 0x3 }, // 1271
  { PseudoVOR_VV_MF4_MASK, PseudoVOR_VV_MF4, PseudoVOR_VV_MF4_TU, 0x3 }, // 1272
  { PseudoVOR_VV_MF8_MASK, PseudoVOR_VV_MF8, PseudoVOR_VV_MF8_TU, 0x3 }, // 1273
  { PseudoVOR_VX_M1_MASK, PseudoVOR_VX_M1, PseudoVOR_VX_M1_TU, 0x3 }, // 1274
  { PseudoVOR_VX_M2_MASK, PseudoVOR_VX_M2, PseudoVOR_VX_M2_TU, 0x3 }, // 1275
  { PseudoVOR_VX_M4_MASK, PseudoVOR_VX_M4, PseudoVOR_VX_M4_TU, 0x3 }, // 1276
  { PseudoVOR_VX_M8_MASK, PseudoVOR_VX_M8, PseudoVOR_VX_M8_TU, 0x3 }, // 1277
  { PseudoVOR_VX_MF2_MASK, PseudoVOR_VX_MF2, PseudoVOR_VX_MF2_TU, 0x3 }, // 1278
  { PseudoVOR_VX_MF4_MASK, PseudoVOR_VX_MF4, PseudoVOR_VX_MF4_TU, 0x3 }, // 1279
  { PseudoVOR_VX_MF8_MASK, PseudoVOR_VX_MF8, PseudoVOR_VX_MF8_TU, 0x3 }, // 1280
  { PseudoVREMU_VV_M1_MASK, PseudoVREMU_VV_M1, PseudoVREMU_VV_M1_TU, 0x3 }, // 1281
  { PseudoVREMU_VV_M2_MASK, PseudoVREMU_VV_M2, PseudoVREMU_VV_M2_TU, 0x3 }, // 1282
  { PseudoVREMU_VV_M4_MASK, PseudoVREMU_VV_M4, PseudoVREMU_VV_M4_TU, 0x3 }, // 1283
  { PseudoVREMU_VV_M8_MASK, PseudoVREMU_VV_M8, PseudoVREMU_VV_M8_TU, 0x3 }, // 1284
  { PseudoVREMU_VV_MF2_MASK, PseudoVREMU_VV_MF2, PseudoVREMU_VV_MF2_TU, 0x3 }, // 1285
  { PseudoVREMU_VV_MF4_MASK, PseudoVREMU_VV_MF4, PseudoVREMU_VV_MF4_TU, 0x3 }, // 1286
  { PseudoVREMU_VV_MF8_MASK, PseudoVREMU_VV_MF8, PseudoVREMU_VV_MF8_TU, 0x3 }, // 1287
  { PseudoVREMU_VX_M1_MASK, PseudoVREMU_VX_M1, PseudoVREMU_VX_M1_TU, 0x3 }, // 1288
  { PseudoVREMU_VX_M2_MASK, PseudoVREMU_VX_M2, PseudoVREMU_VX_M2_TU, 0x3 }, // 1289
  { PseudoVREMU_VX_M4_MASK, PseudoVREMU_VX_M4, PseudoVREMU_VX_M4_TU, 0x3 }, // 1290
  { PseudoVREMU_VX_M8_MASK, PseudoVREMU_VX_M8, PseudoVREMU_VX_M8_TU, 0x3 }, // 1291
  { PseudoVREMU_VX_MF2_MASK, PseudoVREMU_VX_MF2, PseudoVREMU_VX_MF2_TU, 0x3 }, // 1292
  { PseudoVREMU_VX_MF4_MASK, PseudoVREMU_VX_MF4, PseudoVREMU_VX_MF4_TU, 0x3 }, // 1293
  { PseudoVREMU_VX_MF8_MASK, PseudoVREMU_VX_MF8, PseudoVREMU_VX_MF8_TU, 0x3 }, // 1294
  { PseudoVREM_VV_M1_MASK, PseudoVREM_VV_M1, PseudoVREM_VV_M1_TU, 0x3 }, // 1295
  { PseudoVREM_VV_M2_MASK, PseudoVREM_VV_M2, PseudoVREM_VV_M2_TU, 0x3 }, // 1296
  { PseudoVREM_VV_M4_MASK, PseudoVREM_VV_M4, PseudoVREM_VV_M4_TU, 0x3 }, // 1297
  { PseudoVREM_VV_M8_MASK, PseudoVREM_VV_M8, PseudoVREM_VV_M8_TU, 0x3 }, // 1298
  { PseudoVREM_VV_MF2_MASK, PseudoVREM_VV_MF2, PseudoVREM_VV_MF2_TU, 0x3 }, // 1299
  { PseudoVREM_VV_MF4_MASK, PseudoVREM_VV_MF4, PseudoVREM_VV_MF4_TU, 0x3 }, // 1300
  { PseudoVREM_VV_MF8_MASK, PseudoVREM_VV_MF8, PseudoVREM_VV_MF8_TU, 0x3 }, // 1301
  { PseudoVREM_VX_M1_MASK, PseudoVREM_VX_M1, PseudoVREM_VX_M1_TU, 0x3 }, // 1302
  { PseudoVREM_VX_M2_MASK, PseudoVREM_VX_M2, PseudoVREM_VX_M2_TU, 0x3 }, // 1303
  { PseudoVREM_VX_M4_MASK, PseudoVREM_VX_M4, PseudoVREM_VX_M4_TU, 0x3 }, // 1304
  { PseudoVREM_VX_M8_MASK, PseudoVREM_VX_M8, PseudoVREM_VX_M8_TU, 0x3 }, // 1305
  { PseudoVREM_VX_MF2_MASK, PseudoVREM_VX_MF2, PseudoVREM_VX_MF2_TU, 0x3 }, // 1306
  { PseudoVREM_VX_MF4_MASK, PseudoVREM_VX_MF4, PseudoVREM_VX_MF4_TU, 0x3 }, // 1307
  { PseudoVREM_VX_MF8_MASK, PseudoVREM_VX_MF8, PseudoVREM_VX_MF8_TU, 0x3 }, // 1308
  { PseudoVRGATHEREI16_VV_M1_M1_MASK, PseudoVRGATHEREI16_VV_M1_M1, PseudoVRGATHEREI16_VV_M1_M1_TU, 0x3 }, // 1309
  { PseudoVRGATHEREI16_VV_M1_M2_MASK, PseudoVRGATHEREI16_VV_M1_M2, PseudoVRGATHEREI16_VV_M1_M2_TU, 0x3 }, // 1310
  { PseudoVRGATHEREI16_VV_M1_MF2_MASK, PseudoVRGATHEREI16_VV_M1_MF2, PseudoVRGATHEREI16_VV_M1_MF2_TU, 0x3 }, // 1311
  { PseudoVRGATHEREI16_VV_M1_MF4_MASK, PseudoVRGATHEREI16_VV_M1_MF4, PseudoVRGATHEREI16_VV_M1_MF4_TU, 0x3 }, // 1312
  { PseudoVRGATHEREI16_VV_M2_M1_MASK, PseudoVRGATHEREI16_VV_M2_M1, PseudoVRGATHEREI16_VV_M2_M1_TU, 0x3 }, // 1313
  { PseudoVRGATHEREI16_VV_M2_M2_MASK, PseudoVRGATHEREI16_VV_M2_M2, PseudoVRGATHEREI16_VV_M2_M2_TU, 0x3 }, // 1314
  { PseudoVRGATHEREI16_VV_M2_M4_MASK, PseudoVRGATHEREI16_VV_M2_M4, PseudoVRGATHEREI16_VV_M2_M4_TU, 0x3 }, // 1315
  { PseudoVRGATHEREI16_VV_M2_MF2_MASK, PseudoVRGATHEREI16_VV_M2_MF2, PseudoVRGATHEREI16_VV_M2_MF2_TU, 0x3 }, // 1316
  { PseudoVRGATHEREI16_VV_M4_M1_MASK, PseudoVRGATHEREI16_VV_M4_M1, PseudoVRGATHEREI16_VV_M4_M1_TU, 0x3 }, // 1317
  { PseudoVRGATHEREI16_VV_M4_M2_MASK, PseudoVRGATHEREI16_VV_M4_M2, PseudoVRGATHEREI16_VV_M4_M2_TU, 0x3 }, // 1318
  { PseudoVRGATHEREI16_VV_M4_M4_MASK, PseudoVRGATHEREI16_VV_M4_M4, PseudoVRGATHEREI16_VV_M4_M4_TU, 0x3 }, // 1319
  { PseudoVRGATHEREI16_VV_M4_M8_MASK, PseudoVRGATHEREI16_VV_M4_M8, PseudoVRGATHEREI16_VV_M4_M8_TU, 0x3 }, // 1320
  { PseudoVRGATHEREI16_VV_M8_M2_MASK, PseudoVRGATHEREI16_VV_M8_M2, PseudoVRGATHEREI16_VV_M8_M2_TU, 0x3 }, // 1321
  { PseudoVRGATHEREI16_VV_M8_M4_MASK, PseudoVRGATHEREI16_VV_M8_M4, PseudoVRGATHEREI16_VV_M8_M4_TU, 0x3 }, // 1322
  { PseudoVRGATHEREI16_VV_M8_M8_MASK, PseudoVRGATHEREI16_VV_M8_M8, PseudoVRGATHEREI16_VV_M8_M8_TU, 0x3 }, // 1323
  { PseudoVRGATHEREI16_VV_MF2_M1_MASK, PseudoVRGATHEREI16_VV_MF2_M1, PseudoVRGATHEREI16_VV_MF2_M1_TU, 0x3 }, // 1324
  { PseudoVRGATHEREI16_VV_MF2_MF2_MASK, PseudoVRGATHEREI16_VV_MF2_MF2, PseudoVRGATHEREI16_VV_MF2_MF2_TU, 0x3 }, // 1325
  { PseudoVRGATHEREI16_VV_MF2_MF4_MASK, PseudoVRGATHEREI16_VV_MF2_MF4, PseudoVRGATHEREI16_VV_MF2_MF4_TU, 0x3 }, // 1326
  { PseudoVRGATHEREI16_VV_MF2_MF8_MASK, PseudoVRGATHEREI16_VV_MF2_MF8, PseudoVRGATHEREI16_VV_MF2_MF8_TU, 0x3 }, // 1327
  { PseudoVRGATHEREI16_VV_MF4_MF2_MASK, PseudoVRGATHEREI16_VV_MF4_MF2, PseudoVRGATHEREI16_VV_MF4_MF2_TU, 0x3 }, // 1328
  { PseudoVRGATHEREI16_VV_MF4_MF4_MASK, PseudoVRGATHEREI16_VV_MF4_MF4, PseudoVRGATHEREI16_VV_MF4_MF4_TU, 0x3 }, // 1329
  { PseudoVRGATHEREI16_VV_MF4_MF8_MASK, PseudoVRGATHEREI16_VV_MF4_MF8, PseudoVRGATHEREI16_VV_MF4_MF8_TU, 0x3 }, // 1330
  { PseudoVRGATHEREI16_VV_MF8_MF4_MASK, PseudoVRGATHEREI16_VV_MF8_MF4, PseudoVRGATHEREI16_VV_MF8_MF4_TU, 0x3 }, // 1331
  { PseudoVRGATHEREI16_VV_MF8_MF8_MASK, PseudoVRGATHEREI16_VV_MF8_MF8, PseudoVRGATHEREI16_VV_MF8_MF8_TU, 0x3 }, // 1332
  { PseudoVRGATHER_VI_M1_MASK, PseudoVRGATHER_VI_M1, PseudoVRGATHER_VI_M1_TU, 0x3 }, // 1333
  { PseudoVRGATHER_VI_M2_MASK, PseudoVRGATHER_VI_M2, PseudoVRGATHER_VI_M2_TU, 0x3 }, // 1334
  { PseudoVRGATHER_VI_M4_MASK, PseudoVRGATHER_VI_M4, PseudoVRGATHER_VI_M4_TU, 0x3 }, // 1335
  { PseudoVRGATHER_VI_M8_MASK, PseudoVRGATHER_VI_M8, PseudoVRGATHER_VI_M8_TU, 0x3 }, // 1336
  { PseudoVRGATHER_VI_MF2_MASK, PseudoVRGATHER_VI_MF2, PseudoVRGATHER_VI_MF2_TU, 0x3 }, // 1337
  { PseudoVRGATHER_VI_MF4_MASK, PseudoVRGATHER_VI_MF4, PseudoVRGATHER_VI_MF4_TU, 0x3 }, // 1338
  { PseudoVRGATHER_VI_MF8_MASK, PseudoVRGATHER_VI_MF8, PseudoVRGATHER_VI_MF8_TU, 0x3 }, // 1339
  { PseudoVRGATHER_VV_M1_MASK, PseudoVRGATHER_VV_M1, PseudoVRGATHER_VV_M1_TU, 0x3 }, // 1340
  { PseudoVRGATHER_VV_M2_MASK, PseudoVRGATHER_VV_M2, PseudoVRGATHER_VV_M2_TU, 0x3 }, // 1341
  { PseudoVRGATHER_VV_M4_MASK, PseudoVRGATHER_VV_M4, PseudoVRGATHER_VV_M4_TU, 0x3 }, // 1342
  { PseudoVRGATHER_VV_M8_MASK, PseudoVRGATHER_VV_M8, PseudoVRGATHER_VV_M8_TU, 0x3 }, // 1343
  { PseudoVRGATHER_VV_MF2_MASK, PseudoVRGATHER_VV_MF2, PseudoVRGATHER_VV_MF2_TU, 0x3 }, // 1344
  { PseudoVRGATHER_VV_MF4_MASK, PseudoVRGATHER_VV_MF4, PseudoVRGATHER_VV_MF4_TU, 0x3 }, // 1345
  { PseudoVRGATHER_VV_MF8_MASK, PseudoVRGATHER_VV_MF8, PseudoVRGATHER_VV_MF8_TU, 0x3 }, // 1346
  { PseudoVRGATHER_VX_M1_MASK, PseudoVRGATHER_VX_M1, PseudoVRGATHER_VX_M1_TU, 0x3 }, // 1347
  { PseudoVRGATHER_VX_M2_MASK, PseudoVRGATHER_VX_M2, PseudoVRGATHER_VX_M2_TU, 0x3 }, // 1348
  { PseudoVRGATHER_VX_M4_MASK, PseudoVRGATHER_VX_M4, PseudoVRGATHER_VX_M4_TU, 0x3 }, // 1349
  { PseudoVRGATHER_VX_M8_MASK, PseudoVRGATHER_VX_M8, PseudoVRGATHER_VX_M8_TU, 0x3 }, // 1350
  { PseudoVRGATHER_VX_MF2_MASK, PseudoVRGATHER_VX_MF2, PseudoVRGATHER_VX_MF2_TU, 0x3 }, // 1351
  { PseudoVRGATHER_VX_MF4_MASK, PseudoVRGATHER_VX_MF4, PseudoVRGATHER_VX_MF4_TU, 0x3 }, // 1352
  { PseudoVRGATHER_VX_MF8_MASK, PseudoVRGATHER_VX_MF8, PseudoVRGATHER_VX_MF8_TU, 0x3 }, // 1353
  { PseudoVRSUB_VI_M1_MASK, PseudoVRSUB_VI_M1, PseudoVRSUB_VI_M1_TU, 0x3 }, // 1354
  { PseudoVRSUB_VI_M2_MASK, PseudoVRSUB_VI_M2, PseudoVRSUB_VI_M2_TU, 0x3 }, // 1355
  { PseudoVRSUB_VI_M4_MASK, PseudoVRSUB_VI_M4, PseudoVRSUB_VI_M4_TU, 0x3 }, // 1356
  { PseudoVRSUB_VI_M8_MASK, PseudoVRSUB_VI_M8, PseudoVRSUB_VI_M8_TU, 0x3 }, // 1357
  { PseudoVRSUB_VI_MF2_MASK, PseudoVRSUB_VI_MF2, PseudoVRSUB_VI_MF2_TU, 0x3 }, // 1358
  { PseudoVRSUB_VI_MF4_MASK, PseudoVRSUB_VI_MF4, PseudoVRSUB_VI_MF4_TU, 0x3 }, // 1359
  { PseudoVRSUB_VI_MF8_MASK, PseudoVRSUB_VI_MF8, PseudoVRSUB_VI_MF8_TU, 0x3 }, // 1360
  { PseudoVRSUB_VX_M1_MASK, PseudoVRSUB_VX_M1, PseudoVRSUB_VX_M1_TU, 0x3 }, // 1361
  { PseudoVRSUB_VX_M2_MASK, PseudoVRSUB_VX_M2, PseudoVRSUB_VX_M2_TU, 0x3 }, // 1362
  { PseudoVRSUB_VX_M4_MASK, PseudoVRSUB_VX_M4, PseudoVRSUB_VX_M4_TU, 0x3 }, // 1363
  { PseudoVRSUB_VX_M8_MASK, PseudoVRSUB_VX_M8, PseudoVRSUB_VX_M8_TU, 0x3 }, // 1364
  { PseudoVRSUB_VX_MF2_MASK, PseudoVRSUB_VX_MF2, PseudoVRSUB_VX_MF2_TU, 0x3 }, // 1365
  { PseudoVRSUB_VX_MF4_MASK, PseudoVRSUB_VX_MF4, PseudoVRSUB_VX_MF4_TU, 0x3 }, // 1366
  { PseudoVRSUB_VX_MF8_MASK, PseudoVRSUB_VX_MF8, PseudoVRSUB_VX_MF8_TU, 0x3 }, // 1367
  { PseudoVSADDU_VI_M1_MASK, PseudoVSADDU_VI_M1, PseudoVSADDU_VI_M1_TU, 0x3 }, // 1368
  { PseudoVSADDU_VI_M2_MASK, PseudoVSADDU_VI_M2, PseudoVSADDU_VI_M2_TU, 0x3 }, // 1369
  { PseudoVSADDU_VI_M4_MASK, PseudoVSADDU_VI_M4, PseudoVSADDU_VI_M4_TU, 0x3 }, // 1370
  { PseudoVSADDU_VI_M8_MASK, PseudoVSADDU_VI_M8, PseudoVSADDU_VI_M8_TU, 0x3 }, // 1371
  { PseudoVSADDU_VI_MF2_MASK, PseudoVSADDU_VI_MF2, PseudoVSADDU_VI_MF2_TU, 0x3 }, // 1372
  { PseudoVSADDU_VI_MF4_MASK, PseudoVSADDU_VI_MF4, PseudoVSADDU_VI_MF4_TU, 0x3 }, // 1373
  { PseudoVSADDU_VI_MF8_MASK, PseudoVSADDU_VI_MF8, PseudoVSADDU_VI_MF8_TU, 0x3 }, // 1374
  { PseudoVSADDU_VV_M1_MASK, PseudoVSADDU_VV_M1, PseudoVSADDU_VV_M1_TU, 0x3 }, // 1375
  { PseudoVSADDU_VV_M2_MASK, PseudoVSADDU_VV_M2, PseudoVSADDU_VV_M2_TU, 0x3 }, // 1376
  { PseudoVSADDU_VV_M4_MASK, PseudoVSADDU_VV_M4, PseudoVSADDU_VV_M4_TU, 0x3 }, // 1377
  { PseudoVSADDU_VV_M8_MASK, PseudoVSADDU_VV_M8, PseudoVSADDU_VV_M8_TU, 0x3 }, // 1378
  { PseudoVSADDU_VV_MF2_MASK, PseudoVSADDU_VV_MF2, PseudoVSADDU_VV_MF2_TU, 0x3 }, // 1379
  { PseudoVSADDU_VV_MF4_MASK, PseudoVSADDU_VV_MF4, PseudoVSADDU_VV_MF4_TU, 0x3 }, // 1380
  { PseudoVSADDU_VV_MF8_MASK, PseudoVSADDU_VV_MF8, PseudoVSADDU_VV_MF8_TU, 0x3 }, // 1381
  { PseudoVSADDU_VX_M1_MASK, PseudoVSADDU_VX_M1, PseudoVSADDU_VX_M1_TU, 0x3 }, // 1382
  { PseudoVSADDU_VX_M2_MASK, PseudoVSADDU_VX_M2, PseudoVSADDU_VX_M2_TU, 0x3 }, // 1383
  { PseudoVSADDU_VX_M4_MASK, PseudoVSADDU_VX_M4, PseudoVSADDU_VX_M4_TU, 0x3 }, // 1384
  { PseudoVSADDU_VX_M8_MASK, PseudoVSADDU_VX_M8, PseudoVSADDU_VX_M8_TU, 0x3 }, // 1385
  { PseudoVSADDU_VX_MF2_MASK, PseudoVSADDU_VX_MF2, PseudoVSADDU_VX_MF2_TU, 0x3 }, // 1386
  { PseudoVSADDU_VX_MF4_MASK, PseudoVSADDU_VX_MF4, PseudoVSADDU_VX_MF4_TU, 0x3 }, // 1387
  { PseudoVSADDU_VX_MF8_MASK, PseudoVSADDU_VX_MF8, PseudoVSADDU_VX_MF8_TU, 0x3 }, // 1388
  { PseudoVSADD_VI_M1_MASK, PseudoVSADD_VI_M1, PseudoVSADD_VI_M1_TU, 0x3 }, // 1389
  { PseudoVSADD_VI_M2_MASK, PseudoVSADD_VI_M2, PseudoVSADD_VI_M2_TU, 0x3 }, // 1390
  { PseudoVSADD_VI_M4_MASK, PseudoVSADD_VI_M4, PseudoVSADD_VI_M4_TU, 0x3 }, // 1391
  { PseudoVSADD_VI_M8_MASK, PseudoVSADD_VI_M8, PseudoVSADD_VI_M8_TU, 0x3 }, // 1392
  { PseudoVSADD_VI_MF2_MASK, PseudoVSADD_VI_MF2, PseudoVSADD_VI_MF2_TU, 0x3 }, // 1393
  { PseudoVSADD_VI_MF4_MASK, PseudoVSADD_VI_MF4, PseudoVSADD_VI_MF4_TU, 0x3 }, // 1394
  { PseudoVSADD_VI_MF8_MASK, PseudoVSADD_VI_MF8, PseudoVSADD_VI_MF8_TU, 0x3 }, // 1395
  { PseudoVSADD_VV_M1_MASK, PseudoVSADD_VV_M1, PseudoVSADD_VV_M1_TU, 0x3 }, // 1396
  { PseudoVSADD_VV_M2_MASK, PseudoVSADD_VV_M2, PseudoVSADD_VV_M2_TU, 0x3 }, // 1397
  { PseudoVSADD_VV_M4_MASK, PseudoVSADD_VV_M4, PseudoVSADD_VV_M4_TU, 0x3 }, // 1398
  { PseudoVSADD_VV_M8_MASK, PseudoVSADD_VV_M8, PseudoVSADD_VV_M8_TU, 0x3 }, // 1399
  { PseudoVSADD_VV_MF2_MASK, PseudoVSADD_VV_MF2, PseudoVSADD_VV_MF2_TU, 0x3 }, // 1400
  { PseudoVSADD_VV_MF4_MASK, PseudoVSADD_VV_MF4, PseudoVSADD_VV_MF4_TU, 0x3 }, // 1401
  { PseudoVSADD_VV_MF8_MASK, PseudoVSADD_VV_MF8, PseudoVSADD_VV_MF8_TU, 0x3 }, // 1402
  { PseudoVSADD_VX_M1_MASK, PseudoVSADD_VX_M1, PseudoVSADD_VX_M1_TU, 0x3 }, // 1403
  { PseudoVSADD_VX_M2_MASK, PseudoVSADD_VX_M2, PseudoVSADD_VX_M2_TU, 0x3 }, // 1404
  { PseudoVSADD_VX_M4_MASK, PseudoVSADD_VX_M4, PseudoVSADD_VX_M4_TU, 0x3 }, // 1405
  { PseudoVSADD_VX_M8_MASK, PseudoVSADD_VX_M8, PseudoVSADD_VX_M8_TU, 0x3 }, // 1406
  { PseudoVSADD_VX_MF2_MASK, PseudoVSADD_VX_MF2, PseudoVSADD_VX_MF2_TU, 0x3 }, // 1407
  { PseudoVSADD_VX_MF4_MASK, PseudoVSADD_VX_MF4, PseudoVSADD_VX_MF4_TU, 0x3 }, // 1408
  { PseudoVSADD_VX_MF8_MASK, PseudoVSADD_VX_MF8, PseudoVSADD_VX_MF8_TU, 0x3 }, // 1409
  { PseudoVSEXT_VF2_M1_MASK, PseudoVSEXT_VF2_M1, PseudoVSEXT_VF2_M1_TU, 0x2 }, // 1410
  { PseudoVSEXT_VF2_M2_MASK, PseudoVSEXT_VF2_M2, PseudoVSEXT_VF2_M2_TU, 0x2 }, // 1411
  { PseudoVSEXT_VF2_M4_MASK, PseudoVSEXT_VF2_M4, PseudoVSEXT_VF2_M4_TU, 0x2 }, // 1412
  { PseudoVSEXT_VF2_M8_MASK, PseudoVSEXT_VF2_M8, PseudoVSEXT_VF2_M8_TU, 0x2 }, // 1413
  { PseudoVSEXT_VF2_MF2_MASK, PseudoVSEXT_VF2_MF2, PseudoVSEXT_VF2_MF2_TU, 0x2 }, // 1414
  { PseudoVSEXT_VF2_MF4_MASK, PseudoVSEXT_VF2_MF4, PseudoVSEXT_VF2_MF4_TU, 0x2 }, // 1415
  { PseudoVSEXT_VF4_M1_MASK, PseudoVSEXT_VF4_M1, PseudoVSEXT_VF4_M1_TU, 0x2 }, // 1416
  { PseudoVSEXT_VF4_M2_MASK, PseudoVSEXT_VF4_M2, PseudoVSEXT_VF4_M2_TU, 0x2 }, // 1417
  { PseudoVSEXT_VF4_M4_MASK, PseudoVSEXT_VF4_M4, PseudoVSEXT_VF4_M4_TU, 0x2 }, // 1418
  { PseudoVSEXT_VF4_M8_MASK, PseudoVSEXT_VF4_M8, PseudoVSEXT_VF4_M8_TU, 0x2 }, // 1419
  { PseudoVSEXT_VF4_MF2_MASK, PseudoVSEXT_VF4_MF2, PseudoVSEXT_VF4_MF2_TU, 0x2 }, // 1420
  { PseudoVSEXT_VF8_M1_MASK, PseudoVSEXT_VF8_M1, PseudoVSEXT_VF8_M1_TU, 0x2 }, // 1421
  { PseudoVSEXT_VF8_M2_MASK, PseudoVSEXT_VF8_M2, PseudoVSEXT_VF8_M2_TU, 0x2 }, // 1422
  { PseudoVSEXT_VF8_M4_MASK, PseudoVSEXT_VF8_M4, PseudoVSEXT_VF8_M4_TU, 0x2 }, // 1423
  { PseudoVSEXT_VF8_M8_MASK, PseudoVSEXT_VF8_M8, PseudoVSEXT_VF8_M8_TU, 0x2 }, // 1424
  { PseudoVSLIDE1DOWN_VX_M1_MASK, PseudoVSLIDE1DOWN_VX_M1, PseudoVSLIDE1DOWN_VX_M1_TU, 0x3 }, // 1425
  { PseudoVSLIDE1DOWN_VX_M2_MASK, PseudoVSLIDE1DOWN_VX_M2, PseudoVSLIDE1DOWN_VX_M2_TU, 0x3 }, // 1426
  { PseudoVSLIDE1DOWN_VX_M4_MASK, PseudoVSLIDE1DOWN_VX_M4, PseudoVSLIDE1DOWN_VX_M4_TU, 0x3 }, // 1427
  { PseudoVSLIDE1DOWN_VX_M8_MASK, PseudoVSLIDE1DOWN_VX_M8, PseudoVSLIDE1DOWN_VX_M8_TU, 0x3 }, // 1428
  { PseudoVSLIDE1DOWN_VX_MF2_MASK, PseudoVSLIDE1DOWN_VX_MF2, PseudoVSLIDE1DOWN_VX_MF2_TU, 0x3 }, // 1429
  { PseudoVSLIDE1DOWN_VX_MF4_MASK, PseudoVSLIDE1DOWN_VX_MF4, PseudoVSLIDE1DOWN_VX_MF4_TU, 0x3 }, // 1430
  { PseudoVSLIDE1DOWN_VX_MF8_MASK, PseudoVSLIDE1DOWN_VX_MF8, PseudoVSLIDE1DOWN_VX_MF8_TU, 0x3 }, // 1431
  { PseudoVSLIDE1UP_VX_M1_MASK, PseudoVSLIDE1UP_VX_M1, PseudoVSLIDE1UP_VX_M1_TU, 0x3 }, // 1432
  { PseudoVSLIDE1UP_VX_M2_MASK, PseudoVSLIDE1UP_VX_M2, PseudoVSLIDE1UP_VX_M2_TU, 0x3 }, // 1433
  { PseudoVSLIDE1UP_VX_M4_MASK, PseudoVSLIDE1UP_VX_M4, PseudoVSLIDE1UP_VX_M4_TU, 0x3 }, // 1434
  { PseudoVSLIDE1UP_VX_M8_MASK, PseudoVSLIDE1UP_VX_M8, PseudoVSLIDE1UP_VX_M8_TU, 0x3 }, // 1435
  { PseudoVSLIDE1UP_VX_MF2_MASK, PseudoVSLIDE1UP_VX_MF2, PseudoVSLIDE1UP_VX_MF2_TU, 0x3 }, // 1436
  { PseudoVSLIDE1UP_VX_MF4_MASK, PseudoVSLIDE1UP_VX_MF4, PseudoVSLIDE1UP_VX_MF4_TU, 0x3 }, // 1437
  { PseudoVSLIDE1UP_VX_MF8_MASK, PseudoVSLIDE1UP_VX_MF8, PseudoVSLIDE1UP_VX_MF8_TU, 0x3 }, // 1438
  { PseudoVSLL_VI_M1_MASK, PseudoVSLL_VI_M1, PseudoVSLL_VI_M1_TU, 0x3 }, // 1439
  { PseudoVSLL_VI_M2_MASK, PseudoVSLL_VI_M2, PseudoVSLL_VI_M2_TU, 0x3 }, // 1440
  { PseudoVSLL_VI_M4_MASK, PseudoVSLL_VI_M4, PseudoVSLL_VI_M4_TU, 0x3 }, // 1441
  { PseudoVSLL_VI_M8_MASK, PseudoVSLL_VI_M8, PseudoVSLL_VI_M8_TU, 0x3 }, // 1442
  { PseudoVSLL_VI_MF2_MASK, PseudoVSLL_VI_MF2, PseudoVSLL_VI_MF2_TU, 0x3 }, // 1443
  { PseudoVSLL_VI_MF4_MASK, PseudoVSLL_VI_MF4, PseudoVSLL_VI_MF4_TU, 0x3 }, // 1444
  { PseudoVSLL_VI_MF8_MASK, PseudoVSLL_VI_MF8, PseudoVSLL_VI_MF8_TU, 0x3 }, // 1445
  { PseudoVSLL_VV_M1_MASK, PseudoVSLL_VV_M1, PseudoVSLL_VV_M1_TU, 0x3 }, // 1446
  { PseudoVSLL_VV_M2_MASK, PseudoVSLL_VV_M2, PseudoVSLL_VV_M2_TU, 0x3 }, // 1447
  { PseudoVSLL_VV_M4_MASK, PseudoVSLL_VV_M4, PseudoVSLL_VV_M4_TU, 0x3 }, // 1448
  { PseudoVSLL_VV_M8_MASK, PseudoVSLL_VV_M8, PseudoVSLL_VV_M8_TU, 0x3 }, // 1449
  { PseudoVSLL_VV_MF2_MASK, PseudoVSLL_VV_MF2, PseudoVSLL_VV_MF2_TU, 0x3 }, // 1450
  { PseudoVSLL_VV_MF4_MASK, PseudoVSLL_VV_MF4, PseudoVSLL_VV_MF4_TU, 0x3 }, // 1451
  { PseudoVSLL_VV_MF8_MASK, PseudoVSLL_VV_MF8, PseudoVSLL_VV_MF8_TU, 0x3 }, // 1452
  { PseudoVSLL_VX_M1_MASK, PseudoVSLL_VX_M1, PseudoVSLL_VX_M1_TU, 0x3 }, // 1453
  { PseudoVSLL_VX_M2_MASK, PseudoVSLL_VX_M2, PseudoVSLL_VX_M2_TU, 0x3 }, // 1454
  { PseudoVSLL_VX_M4_MASK, PseudoVSLL_VX_M4, PseudoVSLL_VX_M4_TU, 0x3 }, // 1455
  { PseudoVSLL_VX_M8_MASK, PseudoVSLL_VX_M8, PseudoVSLL_VX_M8_TU, 0x3 }, // 1456
  { PseudoVSLL_VX_MF2_MASK, PseudoVSLL_VX_MF2, PseudoVSLL_VX_MF2_TU, 0x3 }, // 1457
  { PseudoVSLL_VX_MF4_MASK, PseudoVSLL_VX_MF4, PseudoVSLL_VX_MF4_TU, 0x3 }, // 1458
  { PseudoVSLL_VX_MF8_MASK, PseudoVSLL_VX_MF8, PseudoVSLL_VX_MF8_TU, 0x3 }, // 1459
  { PseudoVSMUL_VV_M1_MASK, PseudoVSMUL_VV_M1, PseudoVSMUL_VV_M1_TU, 0x3 }, // 1460
  { PseudoVSMUL_VV_M2_MASK, PseudoVSMUL_VV_M2, PseudoVSMUL_VV_M2_TU, 0x3 }, // 1461
  { PseudoVSMUL_VV_M4_MASK, PseudoVSMUL_VV_M4, PseudoVSMUL_VV_M4_TU, 0x3 }, // 1462
  { PseudoVSMUL_VV_M8_MASK, PseudoVSMUL_VV_M8, PseudoVSMUL_VV_M8_TU, 0x3 }, // 1463
  { PseudoVSMUL_VV_MF2_MASK, PseudoVSMUL_VV_MF2, PseudoVSMUL_VV_MF2_TU, 0x3 }, // 1464
  { PseudoVSMUL_VV_MF4_MASK, PseudoVSMUL_VV_MF4, PseudoVSMUL_VV_MF4_TU, 0x3 }, // 1465
  { PseudoVSMUL_VV_MF8_MASK, PseudoVSMUL_VV_MF8, PseudoVSMUL_VV_MF8_TU, 0x3 }, // 1466
  { PseudoVSMUL_VX_M1_MASK, PseudoVSMUL_VX_M1, PseudoVSMUL_VX_M1_TU, 0x3 }, // 1467
  { PseudoVSMUL_VX_M2_MASK, PseudoVSMUL_VX_M2, PseudoVSMUL_VX_M2_TU, 0x3 }, // 1468
  { PseudoVSMUL_VX_M4_MASK, PseudoVSMUL_VX_M4, PseudoVSMUL_VX_M4_TU, 0x3 }, // 1469
  { PseudoVSMUL_VX_M8_MASK, PseudoVSMUL_VX_M8, PseudoVSMUL_VX_M8_TU, 0x3 }, // 1470
  { PseudoVSMUL_VX_MF2_MASK, PseudoVSMUL_VX_MF2, PseudoVSMUL_VX_MF2_TU, 0x3 }, // 1471
  { PseudoVSMUL_VX_MF4_MASK, PseudoVSMUL_VX_MF4, PseudoVSMUL_VX_MF4_TU, 0x3 }, // 1472
  { PseudoVSMUL_VX_MF8_MASK, PseudoVSMUL_VX_MF8, PseudoVSMUL_VX_MF8_TU, 0x3 }, // 1473
  { PseudoVSRA_VI_M1_MASK, PseudoVSRA_VI_M1, PseudoVSRA_VI_M1_TU, 0x3 }, // 1474
  { PseudoVSRA_VI_M2_MASK, PseudoVSRA_VI_M2, PseudoVSRA_VI_M2_TU, 0x3 }, // 1475
  { PseudoVSRA_VI_M4_MASK, PseudoVSRA_VI_M4, PseudoVSRA_VI_M4_TU, 0x3 }, // 1476
  { PseudoVSRA_VI_M8_MASK, PseudoVSRA_VI_M8, PseudoVSRA_VI_M8_TU, 0x3 }, // 1477
  { PseudoVSRA_VI_MF2_MASK, PseudoVSRA_VI_MF2, PseudoVSRA_VI_MF2_TU, 0x3 }, // 1478
  { PseudoVSRA_VI_MF4_MASK, PseudoVSRA_VI_MF4, PseudoVSRA_VI_MF4_TU, 0x3 }, // 1479
  { PseudoVSRA_VI_MF8_MASK, PseudoVSRA_VI_MF8, PseudoVSRA_VI_MF8_TU, 0x3 }, // 1480
  { PseudoVSRA_VV_M1_MASK, PseudoVSRA_VV_M1, PseudoVSRA_VV_M1_TU, 0x3 }, // 1481
  { PseudoVSRA_VV_M2_MASK, PseudoVSRA_VV_M2, PseudoVSRA_VV_M2_TU, 0x3 }, // 1482
  { PseudoVSRA_VV_M4_MASK, PseudoVSRA_VV_M4, PseudoVSRA_VV_M4_TU, 0x3 }, // 1483
  { PseudoVSRA_VV_M8_MASK, PseudoVSRA_VV_M8, PseudoVSRA_VV_M8_TU, 0x3 }, // 1484
  { PseudoVSRA_VV_MF2_MASK, PseudoVSRA_VV_MF2, PseudoVSRA_VV_MF2_TU, 0x3 }, // 1485
  { PseudoVSRA_VV_MF4_MASK, PseudoVSRA_VV_MF4, PseudoVSRA_VV_MF4_TU, 0x3 }, // 1486
  { PseudoVSRA_VV_MF8_MASK, PseudoVSRA_VV_MF8, PseudoVSRA_VV_MF8_TU, 0x3 }, // 1487
  { PseudoVSRA_VX_M1_MASK, PseudoVSRA_VX_M1, PseudoVSRA_VX_M1_TU, 0x3 }, // 1488
  { PseudoVSRA_VX_M2_MASK, PseudoVSRA_VX_M2, PseudoVSRA_VX_M2_TU, 0x3 }, // 1489
  { PseudoVSRA_VX_M4_MASK, PseudoVSRA_VX_M4, PseudoVSRA_VX_M4_TU, 0x3 }, // 1490
  { PseudoVSRA_VX_M8_MASK, PseudoVSRA_VX_M8, PseudoVSRA_VX_M8_TU, 0x3 }, // 1491
  { PseudoVSRA_VX_MF2_MASK, PseudoVSRA_VX_MF2, PseudoVSRA_VX_MF2_TU, 0x3 }, // 1492
  { PseudoVSRA_VX_MF4_MASK, PseudoVSRA_VX_MF4, PseudoVSRA_VX_MF4_TU, 0x3 }, // 1493
  { PseudoVSRA_VX_MF8_MASK, PseudoVSRA_VX_MF8, PseudoVSRA_VX_MF8_TU, 0x3 }, // 1494
  { PseudoVSRL_VI_M1_MASK, PseudoVSRL_VI_M1, PseudoVSRL_VI_M1_TU, 0x3 }, // 1495
  { PseudoVSRL_VI_M2_MASK, PseudoVSRL_VI_M2, PseudoVSRL_VI_M2_TU, 0x3 }, // 1496
  { PseudoVSRL_VI_M4_MASK, PseudoVSRL_VI_M4, PseudoVSRL_VI_M4_TU, 0x3 }, // 1497
  { PseudoVSRL_VI_M8_MASK, PseudoVSRL_VI_M8, PseudoVSRL_VI_M8_TU, 0x3 }, // 1498
  { PseudoVSRL_VI_MF2_MASK, PseudoVSRL_VI_MF2, PseudoVSRL_VI_MF2_TU, 0x3 }, // 1499
  { PseudoVSRL_VI_MF4_MASK, PseudoVSRL_VI_MF4, PseudoVSRL_VI_MF4_TU, 0x3 }, // 1500
  { PseudoVSRL_VI_MF8_MASK, PseudoVSRL_VI_MF8, PseudoVSRL_VI_MF8_TU, 0x3 }, // 1501
  { PseudoVSRL_VV_M1_MASK, PseudoVSRL_VV_M1, PseudoVSRL_VV_M1_TU, 0x3 }, // 1502
  { PseudoVSRL_VV_M2_MASK, PseudoVSRL_VV_M2, PseudoVSRL_VV_M2_TU, 0x3 }, // 1503
  { PseudoVSRL_VV_M4_MASK, PseudoVSRL_VV_M4, PseudoVSRL_VV_M4_TU, 0x3 }, // 1504
  { PseudoVSRL_VV_M8_MASK, PseudoVSRL_VV_M8, PseudoVSRL_VV_M8_TU, 0x3 }, // 1505
  { PseudoVSRL_VV_MF2_MASK, PseudoVSRL_VV_MF2, PseudoVSRL_VV_MF2_TU, 0x3 }, // 1506
  { PseudoVSRL_VV_MF4_MASK, PseudoVSRL_VV_MF4, PseudoVSRL_VV_MF4_TU, 0x3 }, // 1507
  { PseudoVSRL_VV_MF8_MASK, PseudoVSRL_VV_MF8, PseudoVSRL_VV_MF8_TU, 0x3 }, // 1508
  { PseudoVSRL_VX_M1_MASK, PseudoVSRL_VX_M1, PseudoVSRL_VX_M1_TU, 0x3 }, // 1509
  { PseudoVSRL_VX_M2_MASK, PseudoVSRL_VX_M2, PseudoVSRL_VX_M2_TU, 0x3 }, // 1510
  { PseudoVSRL_VX_M4_MASK, PseudoVSRL_VX_M4, PseudoVSRL_VX_M4_TU, 0x3 }, // 1511
  { PseudoVSRL_VX_M8_MASK, PseudoVSRL_VX_M8, PseudoVSRL_VX_M8_TU, 0x3 }, // 1512
  { PseudoVSRL_VX_MF2_MASK, PseudoVSRL_VX_MF2, PseudoVSRL_VX_MF2_TU, 0x3 }, // 1513
  { PseudoVSRL_VX_MF4_MASK, PseudoVSRL_VX_MF4, PseudoVSRL_VX_MF4_TU, 0x3 }, // 1514
  { PseudoVSRL_VX_MF8_MASK, PseudoVSRL_VX_MF8, PseudoVSRL_VX_MF8_TU, 0x3 }, // 1515
  { PseudoVSSRA_VI_M1_MASK, PseudoVSSRA_VI_M1, PseudoVSSRA_VI_M1_TU, 0x3 }, // 1516
  { PseudoVSSRA_VI_M2_MASK, PseudoVSSRA_VI_M2, PseudoVSSRA_VI_M2_TU, 0x3 }, // 1517
  { PseudoVSSRA_VI_M4_MASK, PseudoVSSRA_VI_M4, PseudoVSSRA_VI_M4_TU, 0x3 }, // 1518
  { PseudoVSSRA_VI_M8_MASK, PseudoVSSRA_VI_M8, PseudoVSSRA_VI_M8_TU, 0x3 }, // 1519
  { PseudoVSSRA_VI_MF2_MASK, PseudoVSSRA_VI_MF2, PseudoVSSRA_VI_MF2_TU, 0x3 }, // 1520
  { PseudoVSSRA_VI_MF4_MASK, PseudoVSSRA_VI_MF4, PseudoVSSRA_VI_MF4_TU, 0x3 }, // 1521
  { PseudoVSSRA_VI_MF8_MASK, PseudoVSSRA_VI_MF8, PseudoVSSRA_VI_MF8_TU, 0x3 }, // 1522
  { PseudoVSSRA_VV_M1_MASK, PseudoVSSRA_VV_M1, PseudoVSSRA_VV_M1_TU, 0x3 }, // 1523
  { PseudoVSSRA_VV_M2_MASK, PseudoVSSRA_VV_M2, PseudoVSSRA_VV_M2_TU, 0x3 }, // 1524
  { PseudoVSSRA_VV_M4_MASK, PseudoVSSRA_VV_M4, PseudoVSSRA_VV_M4_TU, 0x3 }, // 1525
  { PseudoVSSRA_VV_M8_MASK, PseudoVSSRA_VV_M8, PseudoVSSRA_VV_M8_TU, 0x3 }, // 1526
  { PseudoVSSRA_VV_MF2_MASK, PseudoVSSRA_VV_MF2, PseudoVSSRA_VV_MF2_TU, 0x3 }, // 1527
  { PseudoVSSRA_VV_MF4_MASK, PseudoVSSRA_VV_MF4, PseudoVSSRA_VV_MF4_TU, 0x3 }, // 1528
  { PseudoVSSRA_VV_MF8_MASK, PseudoVSSRA_VV_MF8, PseudoVSSRA_VV_MF8_TU, 0x3 }, // 1529
  { PseudoVSSRA_VX_M1_MASK, PseudoVSSRA_VX_M1, PseudoVSSRA_VX_M1_TU, 0x3 }, // 1530
  { PseudoVSSRA_VX_M2_MASK, PseudoVSSRA_VX_M2, PseudoVSSRA_VX_M2_TU, 0x3 }, // 1531
  { PseudoVSSRA_VX_M4_MASK, PseudoVSSRA_VX_M4, PseudoVSSRA_VX_M4_TU, 0x3 }, // 1532
  { PseudoVSSRA_VX_M8_MASK, PseudoVSSRA_VX_M8, PseudoVSSRA_VX_M8_TU, 0x3 }, // 1533
  { PseudoVSSRA_VX_MF2_MASK, PseudoVSSRA_VX_MF2, PseudoVSSRA_VX_MF2_TU, 0x3 }, // 1534
  { PseudoVSSRA_VX_MF4_MASK, PseudoVSSRA_VX_MF4, PseudoVSSRA_VX_MF4_TU, 0x3 }, // 1535
  { PseudoVSSRA_VX_MF8_MASK, PseudoVSSRA_VX_MF8, PseudoVSSRA_VX_MF8_TU, 0x3 }, // 1536
  { PseudoVSSRL_VI_M1_MASK, PseudoVSSRL_VI_M1, PseudoVSSRL_VI_M1_TU, 0x3 }, // 1537
  { PseudoVSSRL_VI_M2_MASK, PseudoVSSRL_VI_M2, PseudoVSSRL_VI_M2_TU, 0x3 }, // 1538
  { PseudoVSSRL_VI_M4_MASK, PseudoVSSRL_VI_M4, PseudoVSSRL_VI_M4_TU, 0x3 }, // 1539
  { PseudoVSSRL_VI_M8_MASK, PseudoVSSRL_VI_M8, PseudoVSSRL_VI_M8_TU, 0x3 }, // 1540
  { PseudoVSSRL_VI_MF2_MASK, PseudoVSSRL_VI_MF2, PseudoVSSRL_VI_MF2_TU, 0x3 }, // 1541
  { PseudoVSSRL_VI_MF4_MASK, PseudoVSSRL_VI_MF4, PseudoVSSRL_VI_MF4_TU, 0x3 }, // 1542
  { PseudoVSSRL_VI_MF8_MASK, PseudoVSSRL_VI_MF8, PseudoVSSRL_VI_MF8_TU, 0x3 }, // 1543
  { PseudoVSSRL_VV_M1_MASK, PseudoVSSRL_VV_M1, PseudoVSSRL_VV_M1_TU, 0x3 }, // 1544
  { PseudoVSSRL_VV_M2_MASK, PseudoVSSRL_VV_M2, PseudoVSSRL_VV_M2_TU, 0x3 }, // 1545
  { PseudoVSSRL_VV_M4_MASK, PseudoVSSRL_VV_M4, PseudoVSSRL_VV_M4_TU, 0x3 }, // 1546
  { PseudoVSSRL_VV_M8_MASK, PseudoVSSRL_VV_M8, PseudoVSSRL_VV_M8_TU, 0x3 }, // 1547
  { PseudoVSSRL_VV_MF2_MASK, PseudoVSSRL_VV_MF2, PseudoVSSRL_VV_MF2_TU, 0x3 }, // 1548
  { PseudoVSSRL_VV_MF4_MASK, PseudoVSSRL_VV_MF4, PseudoVSSRL_VV_MF4_TU, 0x3 }, // 1549
  { PseudoVSSRL_VV_MF8_MASK, PseudoVSSRL_VV_MF8, PseudoVSSRL_VV_MF8_TU, 0x3 }, // 1550
  { PseudoVSSRL_VX_M1_MASK, PseudoVSSRL_VX_M1, PseudoVSSRL_VX_M1_TU, 0x3 }, // 1551
  { PseudoVSSRL_VX_M2_MASK, PseudoVSSRL_VX_M2, PseudoVSSRL_VX_M2_TU, 0x3 }, // 1552
  { PseudoVSSRL_VX_M4_MASK, PseudoVSSRL_VX_M4, PseudoVSSRL_VX_M4_TU, 0x3 }, // 1553
  { PseudoVSSRL_VX_M8_MASK, PseudoVSSRL_VX_M8, PseudoVSSRL_VX_M8_TU, 0x3 }, // 1554
  { PseudoVSSRL_VX_MF2_MASK, PseudoVSSRL_VX_MF2, PseudoVSSRL_VX_MF2_TU, 0x3 }, // 1555
  { PseudoVSSRL_VX_MF4_MASK, PseudoVSSRL_VX_MF4, PseudoVSSRL_VX_MF4_TU, 0x3 }, // 1556
  { PseudoVSSRL_VX_MF8_MASK, PseudoVSSRL_VX_MF8, PseudoVSSRL_VX_MF8_TU, 0x3 }, // 1557
  { PseudoVSSUBU_VV_M1_MASK, PseudoVSSUBU_VV_M1, PseudoVSSUBU_VV_M1_TU, 0x3 }, // 1558
  { PseudoVSSUBU_VV_M2_MASK, PseudoVSSUBU_VV_M2, PseudoVSSUBU_VV_M2_TU, 0x3 }, // 1559
  { PseudoVSSUBU_VV_M4_MASK, PseudoVSSUBU_VV_M4, PseudoVSSUBU_VV_M4_TU, 0x3 }, // 1560
  { PseudoVSSUBU_VV_M8_MASK, PseudoVSSUBU_VV_M8, PseudoVSSUBU_VV_M8_TU, 0x3 }, // 1561
  { PseudoVSSUBU_VV_MF2_MASK, PseudoVSSUBU_VV_MF2, PseudoVSSUBU_VV_MF2_TU, 0x3 }, // 1562
  { PseudoVSSUBU_VV_MF4_MASK, PseudoVSSUBU_VV_MF4, PseudoVSSUBU_VV_MF4_TU, 0x3 }, // 1563
  { PseudoVSSUBU_VV_MF8_MASK, PseudoVSSUBU_VV_MF8, PseudoVSSUBU_VV_MF8_TU, 0x3 }, // 1564
  { PseudoVSSUBU_VX_M1_MASK, PseudoVSSUBU_VX_M1, PseudoVSSUBU_VX_M1_TU, 0x3 }, // 1565
  { PseudoVSSUBU_VX_M2_MASK, PseudoVSSUBU_VX_M2, PseudoVSSUBU_VX_M2_TU, 0x3 }, // 1566
  { PseudoVSSUBU_VX_M4_MASK, PseudoVSSUBU_VX_M4, PseudoVSSUBU_VX_M4_TU, 0x3 }, // 1567
  { PseudoVSSUBU_VX_M8_MASK, PseudoVSSUBU_VX_M8, PseudoVSSUBU_VX_M8_TU, 0x3 }, // 1568
  { PseudoVSSUBU_VX_MF2_MASK, PseudoVSSUBU_VX_MF2, PseudoVSSUBU_VX_MF2_TU, 0x3 }, // 1569
  { PseudoVSSUBU_VX_MF4_MASK, PseudoVSSUBU_VX_MF4, PseudoVSSUBU_VX_MF4_TU, 0x3 }, // 1570
  { PseudoVSSUBU_VX_MF8_MASK, PseudoVSSUBU_VX_MF8, PseudoVSSUBU_VX_MF8_TU, 0x3 }, // 1571
  { PseudoVSSUB_VV_M1_MASK, PseudoVSSUB_VV_M1, PseudoVSSUB_VV_M1_TU, 0x3 }, // 1572
  { PseudoVSSUB_VV_M2_MASK, PseudoVSSUB_VV_M2, PseudoVSSUB_VV_M2_TU, 0x3 }, // 1573
  { PseudoVSSUB_VV_M4_MASK, PseudoVSSUB_VV_M4, PseudoVSSUB_VV_M4_TU, 0x3 }, // 1574
  { PseudoVSSUB_VV_M8_MASK, PseudoVSSUB_VV_M8, PseudoVSSUB_VV_M8_TU, 0x3 }, // 1575
  { PseudoVSSUB_VV_MF2_MASK, PseudoVSSUB_VV_MF2, PseudoVSSUB_VV_MF2_TU, 0x3 }, // 1576
  { PseudoVSSUB_VV_MF4_MASK, PseudoVSSUB_VV_MF4, PseudoVSSUB_VV_MF4_TU, 0x3 }, // 1577
  { PseudoVSSUB_VV_MF8_MASK, PseudoVSSUB_VV_MF8, PseudoVSSUB_VV_MF8_TU, 0x3 }, // 1578
  { PseudoVSSUB_VX_M1_MASK, PseudoVSSUB_VX_M1, PseudoVSSUB_VX_M1_TU, 0x3 }, // 1579
  { PseudoVSSUB_VX_M2_MASK, PseudoVSSUB_VX_M2, PseudoVSSUB_VX_M2_TU, 0x3 }, // 1580
  { PseudoVSSUB_VX_M4_MASK, PseudoVSSUB_VX_M4, PseudoVSSUB_VX_M4_TU, 0x3 }, // 1581
  { PseudoVSSUB_VX_M8_MASK, PseudoVSSUB_VX_M8, PseudoVSSUB_VX_M8_TU, 0x3 }, // 1582
  { PseudoVSSUB_VX_MF2_MASK, PseudoVSSUB_VX_MF2, PseudoVSSUB_VX_MF2_TU, 0x3 }, // 1583
  { PseudoVSSUB_VX_MF4_MASK, PseudoVSSUB_VX_MF4, PseudoVSSUB_VX_MF4_TU, 0x3 }, // 1584
  { PseudoVSSUB_VX_MF8_MASK, PseudoVSSUB_VX_MF8, PseudoVSSUB_VX_MF8_TU, 0x3 }, // 1585
  { PseudoVSUB_VV_M1_MASK, PseudoVSUB_VV_M1, PseudoVSUB_VV_M1_TU, 0x3 }, // 1586
  { PseudoVSUB_VV_M2_MASK, PseudoVSUB_VV_M2, PseudoVSUB_VV_M2_TU, 0x3 }, // 1587
  { PseudoVSUB_VV_M4_MASK, PseudoVSUB_VV_M4, PseudoVSUB_VV_M4_TU, 0x3 }, // 1588
  { PseudoVSUB_VV_M8_MASK, PseudoVSUB_VV_M8, PseudoVSUB_VV_M8_TU, 0x3 }, // 1589
  { PseudoVSUB_VV_MF2_MASK, PseudoVSUB_VV_MF2, PseudoVSUB_VV_MF2_TU, 0x3 }, // 1590
  { PseudoVSUB_VV_MF4_MASK, PseudoVSUB_VV_MF4, PseudoVSUB_VV_MF4_TU, 0x3 }, // 1591
  { PseudoVSUB_VV_MF8_MASK, PseudoVSUB_VV_MF8, PseudoVSUB_VV_MF8_TU, 0x3 }, // 1592
  { PseudoVSUB_VX_M1_MASK, PseudoVSUB_VX_M1, PseudoVSUB_VX_M1_TU, 0x3 }, // 1593
  { PseudoVSUB_VX_M2_MASK, PseudoVSUB_VX_M2, PseudoVSUB_VX_M2_TU, 0x3 }, // 1594
  { PseudoVSUB_VX_M4_MASK, PseudoVSUB_VX_M4, PseudoVSUB_VX_M4_TU, 0x3 }, // 1595
  { PseudoVSUB_VX_M8_MASK, PseudoVSUB_VX_M8, PseudoVSUB_VX_M8_TU, 0x3 }, // 1596
  { PseudoVSUB_VX_MF2_MASK, PseudoVSUB_VX_MF2, PseudoVSUB_VX_MF2_TU, 0x3 }, // 1597
  { PseudoVSUB_VX_MF4_MASK, PseudoVSUB_VX_MF4, PseudoVSUB_VX_MF4_TU, 0x3 }, // 1598
  { PseudoVSUB_VX_MF8_MASK, PseudoVSUB_VX_MF8, PseudoVSUB_VX_MF8_TU, 0x3 }, // 1599
  { PseudoVWADDU_VV_M1_MASK, PseudoVWADDU_VV_M1, PseudoVWADDU_VV_M1_TU, 0x3 }, // 1600
  { PseudoVWADDU_VV_M2_MASK, PseudoVWADDU_VV_M2, PseudoVWADDU_VV_M2_TU, 0x3 }, // 1601
  { PseudoVWADDU_VV_M4_MASK, PseudoVWADDU_VV_M4, PseudoVWADDU_VV_M4_TU, 0x3 }, // 1602
  { PseudoVWADDU_VV_MF2_MASK, PseudoVWADDU_VV_MF2, PseudoVWADDU_VV_MF2_TU, 0x3 }, // 1603
  { PseudoVWADDU_VV_MF4_MASK, PseudoVWADDU_VV_MF4, PseudoVWADDU_VV_MF4_TU, 0x3 }, // 1604
  { PseudoVWADDU_VV_MF8_MASK, PseudoVWADDU_VV_MF8, PseudoVWADDU_VV_MF8_TU, 0x3 }, // 1605
  { PseudoVWADDU_VX_M1_MASK, PseudoVWADDU_VX_M1, PseudoVWADDU_VX_M1_TU, 0x3 }, // 1606
  { PseudoVWADDU_VX_M2_MASK, PseudoVWADDU_VX_M2, PseudoVWADDU_VX_M2_TU, 0x3 }, // 1607
  { PseudoVWADDU_VX_M4_MASK, PseudoVWADDU_VX_M4, PseudoVWADDU_VX_M4_TU, 0x3 }, // 1608
  { PseudoVWADDU_VX_MF2_MASK, PseudoVWADDU_VX_MF2, PseudoVWADDU_VX_MF2_TU, 0x3 }, // 1609
  { PseudoVWADDU_VX_MF4_MASK, PseudoVWADDU_VX_MF4, PseudoVWADDU_VX_MF4_TU, 0x3 }, // 1610
  { PseudoVWADDU_VX_MF8_MASK, PseudoVWADDU_VX_MF8, PseudoVWADDU_VX_MF8_TU, 0x3 }, // 1611
  { PseudoVWADDU_WV_M1_MASK, PseudoVWADDU_WV_M1, PseudoVWADDU_WV_M1_TU, 0x3 }, // 1612
  { PseudoVWADDU_WV_M2_MASK, PseudoVWADDU_WV_M2, PseudoVWADDU_WV_M2_TU, 0x3 }, // 1613
  { PseudoVWADDU_WV_M4_MASK, PseudoVWADDU_WV_M4, PseudoVWADDU_WV_M4_TU, 0x3 }, // 1614
  { PseudoVWADDU_WV_MF2_MASK, PseudoVWADDU_WV_MF2, PseudoVWADDU_WV_MF2_TU, 0x3 }, // 1615
  { PseudoVWADDU_WV_MF4_MASK, PseudoVWADDU_WV_MF4, PseudoVWADDU_WV_MF4_TU, 0x3 }, // 1616
  { PseudoVWADDU_WV_MF8_MASK, PseudoVWADDU_WV_MF8, PseudoVWADDU_WV_MF8_TU, 0x3 }, // 1617
  { PseudoVWADDU_WX_M1_MASK, PseudoVWADDU_WX_M1, PseudoVWADDU_WX_M1_TU, 0x3 }, // 1618
  { PseudoVWADDU_WX_M2_MASK, PseudoVWADDU_WX_M2, PseudoVWADDU_WX_M2_TU, 0x3 }, // 1619
  { PseudoVWADDU_WX_M4_MASK, PseudoVWADDU_WX_M4, PseudoVWADDU_WX_M4_TU, 0x3 }, // 1620
  { PseudoVWADDU_WX_MF2_MASK, PseudoVWADDU_WX_MF2, PseudoVWADDU_WX_MF2_TU, 0x3 }, // 1621
  { PseudoVWADDU_WX_MF4_MASK, PseudoVWADDU_WX_MF4, PseudoVWADDU_WX_MF4_TU, 0x3 }, // 1622
  { PseudoVWADDU_WX_MF8_MASK, PseudoVWADDU_WX_MF8, PseudoVWADDU_WX_MF8_TU, 0x3 }, // 1623
  { PseudoVWADD_VV_M1_MASK, PseudoVWADD_VV_M1, PseudoVWADD_VV_M1_TU, 0x3 }, // 1624
  { PseudoVWADD_VV_M2_MASK, PseudoVWADD_VV_M2, PseudoVWADD_VV_M2_TU, 0x3 }, // 1625
  { PseudoVWADD_VV_M4_MASK, PseudoVWADD_VV_M4, PseudoVWADD_VV_M4_TU, 0x3 }, // 1626
  { PseudoVWADD_VV_MF2_MASK, PseudoVWADD_VV_MF2, PseudoVWADD_VV_MF2_TU, 0x3 }, // 1627
  { PseudoVWADD_VV_MF4_MASK, PseudoVWADD_VV_MF4, PseudoVWADD_VV_MF4_TU, 0x3 }, // 1628
  { PseudoVWADD_VV_MF8_MASK, PseudoVWADD_VV_MF8, PseudoVWADD_VV_MF8_TU, 0x3 }, // 1629
  { PseudoVWADD_VX_M1_MASK, PseudoVWADD_VX_M1, PseudoVWADD_VX_M1_TU, 0x3 }, // 1630
  { PseudoVWADD_VX_M2_MASK, PseudoVWADD_VX_M2, PseudoVWADD_VX_M2_TU, 0x3 }, // 1631
  { PseudoVWADD_VX_M4_MASK, PseudoVWADD_VX_M4, PseudoVWADD_VX_M4_TU, 0x3 }, // 1632
  { PseudoVWADD_VX_MF2_MASK, PseudoVWADD_VX_MF2, PseudoVWADD_VX_MF2_TU, 0x3 }, // 1633
  { PseudoVWADD_VX_MF4_MASK, PseudoVWADD_VX_MF4, PseudoVWADD_VX_MF4_TU, 0x3 }, // 1634
  { PseudoVWADD_VX_MF8_MASK, PseudoVWADD_VX_MF8, PseudoVWADD_VX_MF8_TU, 0x3 }, // 1635
  { PseudoVWADD_WV_M1_MASK, PseudoVWADD_WV_M1, PseudoVWADD_WV_M1_TU, 0x3 }, // 1636
  { PseudoVWADD_WV_M2_MASK, PseudoVWADD_WV_M2, PseudoVWADD_WV_M2_TU, 0x3 }, // 1637
  { PseudoVWADD_WV_M4_MASK, PseudoVWADD_WV_M4, PseudoVWADD_WV_M4_TU, 0x3 }, // 1638
  { PseudoVWADD_WV_MF2_MASK, PseudoVWADD_WV_MF2, PseudoVWADD_WV_MF2_TU, 0x3 }, // 1639
  { PseudoVWADD_WV_MF4_MASK, PseudoVWADD_WV_MF4, PseudoVWADD_WV_MF4_TU, 0x3 }, // 1640
  { PseudoVWADD_WV_MF8_MASK, PseudoVWADD_WV_MF8, PseudoVWADD_WV_MF8_TU, 0x3 }, // 1641
  { PseudoVWADD_WX_M1_MASK, PseudoVWADD_WX_M1, PseudoVWADD_WX_M1_TU, 0x3 }, // 1642
  { PseudoVWADD_WX_M2_MASK, PseudoVWADD_WX_M2, PseudoVWADD_WX_M2_TU, 0x3 }, // 1643
  { PseudoVWADD_WX_M4_MASK, PseudoVWADD_WX_M4, PseudoVWADD_WX_M4_TU, 0x3 }, // 1644
  { PseudoVWADD_WX_MF2_MASK, PseudoVWADD_WX_MF2, PseudoVWADD_WX_MF2_TU, 0x3 }, // 1645
  { PseudoVWADD_WX_MF4_MASK, PseudoVWADD_WX_MF4, PseudoVWADD_WX_MF4_TU, 0x3 }, // 1646
  { PseudoVWADD_WX_MF8_MASK, PseudoVWADD_WX_MF8, PseudoVWADD_WX_MF8_TU, 0x3 }, // 1647
  { PseudoVWMULSU_VV_M1_MASK, PseudoVWMULSU_VV_M1, PseudoVWMULSU_VV_M1_TU, 0x3 }, // 1648
  { PseudoVWMULSU_VV_M2_MASK, PseudoVWMULSU_VV_M2, PseudoVWMULSU_VV_M2_TU, 0x3 }, // 1649
  { PseudoVWMULSU_VV_M4_MASK, PseudoVWMULSU_VV_M4, PseudoVWMULSU_VV_M4_TU, 0x3 }, // 1650
  { PseudoVWMULSU_VV_MF2_MASK, PseudoVWMULSU_VV_MF2, PseudoVWMULSU_VV_MF2_TU, 0x3 }, // 1651
  { PseudoVWMULSU_VV_MF4_MASK, PseudoVWMULSU_VV_MF4, PseudoVWMULSU_VV_MF4_TU, 0x3 }, // 1652
  { PseudoVWMULSU_VV_MF8_MASK, PseudoVWMULSU_VV_MF8, PseudoVWMULSU_VV_MF8_TU, 0x3 }, // 1653
  { PseudoVWMULSU_VX_M1_MASK, PseudoVWMULSU_VX_M1, PseudoVWMULSU_VX_M1_TU, 0x3 }, // 1654
  { PseudoVWMULSU_VX_M2_MASK, PseudoVWMULSU_VX_M2, PseudoVWMULSU_VX_M2_TU, 0x3 }, // 1655
  { PseudoVWMULSU_VX_M4_MASK, PseudoVWMULSU_VX_M4, PseudoVWMULSU_VX_M4_TU, 0x3 }, // 1656
  { PseudoVWMULSU_VX_MF2_MASK, PseudoVWMULSU_VX_MF2, PseudoVWMULSU_VX_MF2_TU, 0x3 }, // 1657
  { PseudoVWMULSU_VX_MF4_MASK, PseudoVWMULSU_VX_MF4, PseudoVWMULSU_VX_MF4_TU, 0x3 }, // 1658
  { PseudoVWMULSU_VX_MF8_MASK, PseudoVWMULSU_VX_MF8, PseudoVWMULSU_VX_MF8_TU, 0x3 }, // 1659
  { PseudoVWMULU_VV_M1_MASK, PseudoVWMULU_VV_M1, PseudoVWMULU_VV_M1_TU, 0x3 }, // 1660
  { PseudoVWMULU_VV_M2_MASK, PseudoVWMULU_VV_M2, PseudoVWMULU_VV_M2_TU, 0x3 }, // 1661
  { PseudoVWMULU_VV_M4_MASK, PseudoVWMULU_VV_M4, PseudoVWMULU_VV_M4_TU, 0x3 }, // 1662
  { PseudoVWMULU_VV_MF2_MASK, PseudoVWMULU_VV_MF2, PseudoVWMULU_VV_MF2_TU, 0x3 }, // 1663
  { PseudoVWMULU_VV_MF4_MASK, PseudoVWMULU_VV_MF4, PseudoVWMULU_VV_MF4_TU, 0x3 }, // 1664
  { PseudoVWMULU_VV_MF8_MASK, PseudoVWMULU_VV_MF8, PseudoVWMULU_VV_MF8_TU, 0x3 }, // 1665
  { PseudoVWMULU_VX_M1_MASK, PseudoVWMULU_VX_M1, PseudoVWMULU_VX_M1_TU, 0x3 }, // 1666
  { PseudoVWMULU_VX_M2_MASK, PseudoVWMULU_VX_M2, PseudoVWMULU_VX_M2_TU, 0x3 }, // 1667
  { PseudoVWMULU_VX_M4_MASK, PseudoVWMULU_VX_M4, PseudoVWMULU_VX_M4_TU, 0x3 }, // 1668
  { PseudoVWMULU_VX_MF2_MASK, PseudoVWMULU_VX_MF2, PseudoVWMULU_VX_MF2_TU, 0x3 }, // 1669
  { PseudoVWMULU_VX_MF4_MASK, PseudoVWMULU_VX_MF4, PseudoVWMULU_VX_MF4_TU, 0x3 }, // 1670
  { PseudoVWMULU_VX_MF8_MASK, PseudoVWMULU_VX_MF8, PseudoVWMULU_VX_MF8_TU, 0x3 }, // 1671
  { PseudoVWMUL_VV_M1_MASK, PseudoVWMUL_VV_M1, PseudoVWMUL_VV_M1_TU, 0x3 }, // 1672
  { PseudoVWMUL_VV_M2_MASK, PseudoVWMUL_VV_M2, PseudoVWMUL_VV_M2_TU, 0x3 }, // 1673
  { PseudoVWMUL_VV_M4_MASK, PseudoVWMUL_VV_M4, PseudoVWMUL_VV_M4_TU, 0x3 }, // 1674
  { PseudoVWMUL_VV_MF2_MASK, PseudoVWMUL_VV_MF2, PseudoVWMUL_VV_MF2_TU, 0x3 }, // 1675
  { PseudoVWMUL_VV_MF4_MASK, PseudoVWMUL_VV_MF4, PseudoVWMUL_VV_MF4_TU, 0x3 }, // 1676
  { PseudoVWMUL_VV_MF8_MASK, PseudoVWMUL_VV_MF8, PseudoVWMUL_VV_MF8_TU, 0x3 }, // 1677
  { PseudoVWMUL_VX_M1_MASK, PseudoVWMUL_VX_M1, PseudoVWMUL_VX_M1_TU, 0x3 }, // 1678
  { PseudoVWMUL_VX_M2_MASK, PseudoVWMUL_VX_M2, PseudoVWMUL_VX_M2_TU, 0x3 }, // 1679
  { PseudoVWMUL_VX_M4_MASK, PseudoVWMUL_VX_M4, PseudoVWMUL_VX_M4_TU, 0x3 }, // 1680
  { PseudoVWMUL_VX_MF2_MASK, PseudoVWMUL_VX_MF2, PseudoVWMUL_VX_MF2_TU, 0x3 }, // 1681
  { PseudoVWMUL_VX_MF4_MASK, PseudoVWMUL_VX_MF4, PseudoVWMUL_VX_MF4_TU, 0x3 }, // 1682
  { PseudoVWMUL_VX_MF8_MASK, PseudoVWMUL_VX_MF8, PseudoVWMUL_VX_MF8_TU, 0x3 }, // 1683
  { PseudoVWSUBU_VV_M1_MASK, PseudoVWSUBU_VV_M1, PseudoVWSUBU_VV_M1_TU, 0x3 }, // 1684
  { PseudoVWSUBU_VV_M2_MASK, PseudoVWSUBU_VV_M2, PseudoVWSUBU_VV_M2_TU, 0x3 }, // 1685
  { PseudoVWSUBU_VV_M4_MASK, PseudoVWSUBU_VV_M4, PseudoVWSUBU_VV_M4_TU, 0x3 }, // 1686
  { PseudoVWSUBU_VV_MF2_MASK, PseudoVWSUBU_VV_MF2, PseudoVWSUBU_VV_MF2_TU, 0x3 }, // 1687
  { PseudoVWSUBU_VV_MF4_MASK, PseudoVWSUBU_VV_MF4, PseudoVWSUBU_VV_MF4_TU, 0x3 }, // 1688
  { PseudoVWSUBU_VV_MF8_MASK, PseudoVWSUBU_VV_MF8, PseudoVWSUBU_VV_MF8_TU, 0x3 }, // 1689
  { PseudoVWSUBU_VX_M1_MASK, PseudoVWSUBU_VX_M1, PseudoVWSUBU_VX_M1_TU, 0x3 }, // 1690
  { PseudoVWSUBU_VX_M2_MASK, PseudoVWSUBU_VX_M2, PseudoVWSUBU_VX_M2_TU, 0x3 }, // 1691
  { PseudoVWSUBU_VX_M4_MASK, PseudoVWSUBU_VX_M4, PseudoVWSUBU_VX_M4_TU, 0x3 }, // 1692
  { PseudoVWSUBU_VX_MF2_MASK, PseudoVWSUBU_VX_MF2, PseudoVWSUBU_VX_MF2_TU, 0x3 }, // 1693
  { PseudoVWSUBU_VX_MF4_MASK, PseudoVWSUBU_VX_MF4, PseudoVWSUBU_VX_MF4_TU, 0x3 }, // 1694
  { PseudoVWSUBU_VX_MF8_MASK, PseudoVWSUBU_VX_MF8, PseudoVWSUBU_VX_MF8_TU, 0x3 }, // 1695
  { PseudoVWSUBU_WV_M1_MASK, PseudoVWSUBU_WV_M1, PseudoVWSUBU_WV_M1_TU, 0x3 }, // 1696
  { PseudoVWSUBU_WV_M2_MASK, PseudoVWSUBU_WV_M2, PseudoVWSUBU_WV_M2_TU, 0x3 }, // 1697
  { PseudoVWSUBU_WV_M4_MASK, PseudoVWSUBU_WV_M4, PseudoVWSUBU_WV_M4_TU, 0x3 }, // 1698
  { PseudoVWSUBU_WV_MF2_MASK, PseudoVWSUBU_WV_MF2, PseudoVWSUBU_WV_MF2_TU, 0x3 }, // 1699
  { PseudoVWSUBU_WV_MF4_MASK, PseudoVWSUBU_WV_MF4, PseudoVWSUBU_WV_MF4_TU, 0x3 }, // 1700
  { PseudoVWSUBU_WV_MF8_MASK, PseudoVWSUBU_WV_MF8, PseudoVWSUBU_WV_MF8_TU, 0x3 }, // 1701
  { PseudoVWSUBU_WX_M1_MASK, PseudoVWSUBU_WX_M1, PseudoVWSUBU_WX_M1_TU, 0x3 }, // 1702
  { PseudoVWSUBU_WX_M2_MASK, PseudoVWSUBU_WX_M2, PseudoVWSUBU_WX_M2_TU, 0x3 }, // 1703
  { PseudoVWSUBU_WX_M4_MASK, PseudoVWSUBU_WX_M4, PseudoVWSUBU_WX_M4_TU, 0x3 }, // 1704
  { PseudoVWSUBU_WX_MF2_MASK, PseudoVWSUBU_WX_MF2, PseudoVWSUBU_WX_MF2_TU, 0x3 }, // 1705
  { PseudoVWSUBU_WX_MF4_MASK, PseudoVWSUBU_WX_MF4, PseudoVWSUBU_WX_MF4_TU, 0x3 }, // 1706
  { PseudoVWSUBU_WX_MF8_MASK, PseudoVWSUBU_WX_MF8, PseudoVWSUBU_WX_MF8_TU, 0x3 }, // 1707
  { PseudoVWSUB_VV_M1_MASK, PseudoVWSUB_VV_M1, PseudoVWSUB_VV_M1_TU, 0x3 }, // 1708
  { PseudoVWSUB_VV_M2_MASK, PseudoVWSUB_VV_M2, PseudoVWSUB_VV_M2_TU, 0x3 }, // 1709
  { PseudoVWSUB_VV_M4_MASK, PseudoVWSUB_VV_M4, PseudoVWSUB_VV_M4_TU, 0x3 }, // 1710
  { PseudoVWSUB_VV_MF2_MASK, PseudoVWSUB_VV_MF2, PseudoVWSUB_VV_MF2_TU, 0x3 }, // 1711
  { PseudoVWSUB_VV_MF4_MASK, PseudoVWSUB_VV_MF4, PseudoVWSUB_VV_MF4_TU, 0x3 }, // 1712
  { PseudoVWSUB_VV_MF8_MASK, PseudoVWSUB_VV_MF8, PseudoVWSUB_VV_MF8_TU, 0x3 }, // 1713
  { PseudoVWSUB_VX_M1_MASK, PseudoVWSUB_VX_M1, PseudoVWSUB_VX_M1_TU, 0x3 }, // 1714
  { PseudoVWSUB_VX_M2_MASK, PseudoVWSUB_VX_M2, PseudoVWSUB_VX_M2_TU, 0x3 }, // 1715
  { PseudoVWSUB_VX_M4_MASK, PseudoVWSUB_VX_M4, PseudoVWSUB_VX_M4_TU, 0x3 }, // 1716
  { PseudoVWSUB_VX_MF2_MASK, PseudoVWSUB_VX_MF2, PseudoVWSUB_VX_MF2_TU, 0x3 }, // 1717
  { PseudoVWSUB_VX_MF4_MASK, PseudoVWSUB_VX_MF4, PseudoVWSUB_VX_MF4_TU, 0x3 }, // 1718
  { PseudoVWSUB_VX_MF8_MASK, PseudoVWSUB_VX_MF8, PseudoVWSUB_VX_MF8_TU, 0x3 }, // 1719
  { PseudoVWSUB_WV_M1_MASK, PseudoVWSUB_WV_M1, PseudoVWSUB_WV_M1_TU, 0x3 }, // 1720
  { PseudoVWSUB_WV_M2_MASK, PseudoVWSUB_WV_M2, PseudoVWSUB_WV_M2_TU, 0x3 }, // 1721
  { PseudoVWSUB_WV_M4_MASK, PseudoVWSUB_WV_M4, PseudoVWSUB_WV_M4_TU, 0x3 }, // 1722
  { PseudoVWSUB_WV_MF2_MASK, PseudoVWSUB_WV_MF2, PseudoVWSUB_WV_MF2_TU, 0x3 }, // 1723
  { PseudoVWSUB_WV_MF4_MASK, PseudoVWSUB_WV_MF4, PseudoVWSUB_WV_MF4_TU, 0x3 }, // 1724
  { PseudoVWSUB_WV_MF8_MASK, PseudoVWSUB_WV_MF8, PseudoVWSUB_WV_MF8_TU, 0x3 }, // 1725
  { PseudoVWSUB_WX_M1_MASK, PseudoVWSUB_WX_M1, PseudoVWSUB_WX_M1_TU, 0x3 }, // 1726
  { PseudoVWSUB_WX_M2_MASK, PseudoVWSUB_WX_M2, PseudoVWSUB_WX_M2_TU, 0x3 }, // 1727
  { PseudoVWSUB_WX_M4_MASK, PseudoVWSUB_WX_M4, PseudoVWSUB_WX_M4_TU, 0x3 }, // 1728
  { PseudoVWSUB_WX_MF2_MASK, PseudoVWSUB_WX_MF2, PseudoVWSUB_WX_MF2_TU, 0x3 }, // 1729
  { PseudoVWSUB_WX_MF4_MASK, PseudoVWSUB_WX_MF4, PseudoVWSUB_WX_MF4_TU, 0x3 }, // 1730
  { PseudoVWSUB_WX_MF8_MASK, PseudoVWSUB_WX_MF8, PseudoVWSUB_WX_MF8_TU, 0x3 }, // 1731
  { PseudoVXOR_VI_M1_MASK, PseudoVXOR_VI_M1, PseudoVXOR_VI_M1_TU, 0x3 }, // 1732
  { PseudoVXOR_VI_M2_MASK, PseudoVXOR_VI_M2, PseudoVXOR_VI_M2_TU, 0x3 }, // 1733
  { PseudoVXOR_VI_M4_MASK, PseudoVXOR_VI_M4, PseudoVXOR_VI_M4_TU, 0x3 }, // 1734
  { PseudoVXOR_VI_M8_MASK, PseudoVXOR_VI_M8, PseudoVXOR_VI_M8_TU, 0x3 }, // 1735
  { PseudoVXOR_VI_MF2_MASK, PseudoVXOR_VI_MF2, PseudoVXOR_VI_MF2_TU, 0x3 }, // 1736
  { PseudoVXOR_VI_MF4_MASK, PseudoVXOR_VI_MF4, PseudoVXOR_VI_MF4_TU, 0x3 }, // 1737
  { PseudoVXOR_VI_MF8_MASK, PseudoVXOR_VI_MF8, PseudoVXOR_VI_MF8_TU, 0x3 }, // 1738
  { PseudoVXOR_VV_M1_MASK, PseudoVXOR_VV_M1, PseudoVXOR_VV_M1_TU, 0x3 }, // 1739
  { PseudoVXOR_VV_M2_MASK, PseudoVXOR_VV_M2, PseudoVXOR_VV_M2_TU, 0x3 }, // 1740
  { PseudoVXOR_VV_M4_MASK, PseudoVXOR_VV_M4, PseudoVXOR_VV_M4_TU, 0x3 }, // 1741
  { PseudoVXOR_VV_M8_MASK, PseudoVXOR_VV_M8, PseudoVXOR_VV_M8_TU, 0x3 }, // 1742
  { PseudoVXOR_VV_MF2_MASK, PseudoVXOR_VV_MF2, PseudoVXOR_VV_MF2_TU, 0x3 }, // 1743
  { PseudoVXOR_VV_MF4_MASK, PseudoVXOR_VV_MF4, PseudoVXOR_VV_MF4_TU, 0x3 }, // 1744
  { PseudoVXOR_VV_MF8_MASK, PseudoVXOR_VV_MF8, PseudoVXOR_VV_MF8_TU, 0x3 }, // 1745
  { PseudoVXOR_VX_M1_MASK, PseudoVXOR_VX_M1, PseudoVXOR_VX_M1_TU, 0x3 }, // 1746
  { PseudoVXOR_VX_M2_MASK, PseudoVXOR_VX_M2, PseudoVXOR_VX_M2_TU, 0x3 }, // 1747
  { PseudoVXOR_VX_M4_MASK, PseudoVXOR_VX_M4, PseudoVXOR_VX_M4_TU, 0x3 }, // 1748
  { PseudoVXOR_VX_M8_MASK, PseudoVXOR_VX_M8, PseudoVXOR_VX_M8_TU, 0x3 }, // 1749
  { PseudoVXOR_VX_MF2_MASK, PseudoVXOR_VX_MF2, PseudoVXOR_VX_MF2_TU, 0x3 }, // 1750
  { PseudoVXOR_VX_MF4_MASK, PseudoVXOR_VX_MF4, PseudoVXOR_VX_MF4_TU, 0x3 }, // 1751
  { PseudoVXOR_VX_MF8_MASK, PseudoVXOR_VX_MF8, PseudoVXOR_VX_MF8_TU, 0x3 }, // 1752
  { PseudoVZEXT_VF2_M1_MASK, PseudoVZEXT_VF2_M1, PseudoVZEXT_VF2_M1_TU, 0x2 }, // 1753
  { PseudoVZEXT_VF2_M2_MASK, PseudoVZEXT_VF2_M2, PseudoVZEXT_VF2_M2_TU, 0x2 }, // 1754
  { PseudoVZEXT_VF2_M4_MASK, PseudoVZEXT_VF2_M4, PseudoVZEXT_VF2_M4_TU, 0x2 }, // 1755
  { PseudoVZEXT_VF2_M8_MASK, PseudoVZEXT_VF2_M8, PseudoVZEXT_VF2_M8_TU, 0x2 }, // 1756
  { PseudoVZEXT_VF2_MF2_MASK, PseudoVZEXT_VF2_MF2, PseudoVZEXT_VF2_MF2_TU, 0x2 }, // 1757
  { PseudoVZEXT_VF2_MF4_MASK, PseudoVZEXT_VF2_MF4, PseudoVZEXT_VF2_MF4_TU, 0x2 }, // 1758
  { PseudoVZEXT_VF4_M1_MASK, PseudoVZEXT_VF4_M1, PseudoVZEXT_VF4_M1_TU, 0x2 }, // 1759
  { PseudoVZEXT_VF4_M2_MASK, PseudoVZEXT_VF4_M2, PseudoVZEXT_VF4_M2_TU, 0x2 }, // 1760
  { PseudoVZEXT_VF4_M4_MASK, PseudoVZEXT_VF4_M4, PseudoVZEXT_VF4_M4_TU, 0x2 }, // 1761
  { PseudoVZEXT_VF4_M8_MASK, PseudoVZEXT_VF4_M8, PseudoVZEXT_VF4_M8_TU, 0x2 }, // 1762
  { PseudoVZEXT_VF4_MF2_MASK, PseudoVZEXT_VF4_MF2, PseudoVZEXT_VF4_MF2_TU, 0x2 }, // 1763
  { PseudoVZEXT_VF8_M1_MASK, PseudoVZEXT_VF8_M1, PseudoVZEXT_VF8_M1_TU, 0x2 }, // 1764
  { PseudoVZEXT_VF8_M2_MASK, PseudoVZEXT_VF8_M2, PseudoVZEXT_VF8_M2_TU, 0x2 }, // 1765
  { PseudoVZEXT_VF8_M4_MASK, PseudoVZEXT_VF8_M4, PseudoVZEXT_VF8_M4_TU, 0x2 }, // 1766
  { PseudoVZEXT_VF8_M8_MASK, PseudoVZEXT_VF8_M8, PseudoVZEXT_VF8_M8_TU, 0x2 }, // 1767
 };

const RISCVMaskedPseudoInfo *getMaskedPseudoInfo(unsigned MaskedPseudo) {
  struct KeyType {
    unsigned MaskedPseudo;
  };
  KeyType Key = {MaskedPseudo};
  auto Table = ArrayRef(RISCVMaskedPseudosTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const RISCVMaskedPseudoInfo &LHS, const KeyType &RHS) {
      if (LHS.MaskedPseudo < RHS.MaskedPseudo)
        return true;
      if (LHS.MaskedPseudo > RHS.MaskedPseudo)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.MaskedPseudo != Idx->MaskedPseudo)
    return nullptr;
  return &*Idx;
}

const RISCVMaskedPseudoInfo *lookupMaskedIntrinsicByUnmaskedTA(unsigned UnmaskedPseudo) {
  struct IndexType {
    unsigned UnmaskedPseudo;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { PseudoVAADDU_VV_M1, 0 },
    { PseudoVAADDU_VV_M2, 1 },
    { PseudoVAADDU_VV_M4, 2 },
    { PseudoVAADDU_VV_M8, 3 },
    { PseudoVAADDU_VV_MF2, 4 },
    { PseudoVAADDU_VV_MF4, 5 },
    { PseudoVAADDU_VV_MF8, 6 },
    { PseudoVAADDU_VX_M1, 7 },
    { PseudoVAADDU_VX_M2, 8 },
    { PseudoVAADDU_VX_M4, 9 },
    { PseudoVAADDU_VX_M8, 10 },
    { PseudoVAADDU_VX_MF2, 11 },
    { PseudoVAADDU_VX_MF4, 12 },
    { PseudoVAADDU_VX_MF8, 13 },
    { PseudoVAADD_VV_M1, 14 },
    { PseudoVAADD_VV_M2, 15 },
    { PseudoVAADD_VV_M4, 16 },
    { PseudoVAADD_VV_M8, 17 },
    { PseudoVAADD_VV_MF2, 18 },
    { PseudoVAADD_VV_MF4, 19 },
    { PseudoVAADD_VV_MF8, 20 },
    { PseudoVAADD_VX_M1, 21 },
    { PseudoVAADD_VX_M2, 22 },
    { PseudoVAADD_VX_M4, 23 },
    { PseudoVAADD_VX_M8, 24 },
    { PseudoVAADD_VX_MF2, 25 },
    { PseudoVAADD_VX_MF4, 26 },
    { PseudoVAADD_VX_MF8, 27 },
    { PseudoVADD_VI_M1, 28 },
    { PseudoVADD_VI_M2, 29 },
    { PseudoVADD_VI_M4, 30 },
    { PseudoVADD_VI_M8, 31 },
    { PseudoVADD_VI_MF2, 32 },
    { PseudoVADD_VI_MF4, 33 },
    { PseudoVADD_VI_MF8, 34 },
    { PseudoVADD_VV_M1, 35 },
    { PseudoVADD_VV_M2, 36 },
    { PseudoVADD_VV_M4, 37 },
    { PseudoVADD_VV_M8, 38 },
    { PseudoVADD_VV_MF2, 39 },
    { PseudoVADD_VV_MF4, 40 },
    { PseudoVADD_VV_MF8, 41 },
    { PseudoVADD_VX_M1, 42 },
    { PseudoVADD_VX_M2, 43 },
    { PseudoVADD_VX_M4, 44 },
    { PseudoVADD_VX_M8, 45 },
    { PseudoVADD_VX_MF2, 46 },
    { PseudoVADD_VX_MF4, 47 },
    { PseudoVADD_VX_MF8, 48 },
    { PseudoVAND_VI_M1, 49 },
    { PseudoVAND_VI_M2, 50 },
    { PseudoVAND_VI_M4, 51 },
    { PseudoVAND_VI_M8, 52 },
    { PseudoVAND_VI_MF2, 53 },
    { PseudoVAND_VI_MF4, 54 },
    { PseudoVAND_VI_MF8, 55 },
    { PseudoVAND_VV_M1, 56 },
    { PseudoVAND_VV_M2, 57 },
    { PseudoVAND_VV_M4, 58 },
    { PseudoVAND_VV_M8, 59 },
    { PseudoVAND_VV_MF2, 60 },
    { PseudoVAND_VV_MF4, 61 },
    { PseudoVAND_VV_MF8, 62 },
    { PseudoVAND_VX_M1, 63 },
    { PseudoVAND_VX_M2, 64 },
    { PseudoVAND_VX_M4, 65 },
    { PseudoVAND_VX_M8, 66 },
    { PseudoVAND_VX_MF2, 67 },
    { PseudoVAND_VX_MF4, 68 },
    { PseudoVAND_VX_MF8, 69 },
    { PseudoVASUBU_VV_M1, 70 },
    { PseudoVASUBU_VV_M2, 71 },
    { PseudoVASUBU_VV_M4, 72 },
    { PseudoVASUBU_VV_M8, 73 },
    { PseudoVASUBU_VV_MF2, 74 },
    { PseudoVASUBU_VV_MF4, 75 },
    { PseudoVASUBU_VV_MF8, 76 },
    { PseudoVASUBU_VX_M1, 77 },
    { PseudoVASUBU_VX_M2, 78 },
    { PseudoVASUBU_VX_M4, 79 },
    { PseudoVASUBU_VX_M8, 80 },
    { PseudoVASUBU_VX_MF2, 81 },
    { PseudoVASUBU_VX_MF4, 82 },
    { PseudoVASUBU_VX_MF8, 83 },
    { PseudoVASUB_VV_M1, 84 },
    { PseudoVASUB_VV_M2, 85 },
    { PseudoVASUB_VV_M4, 86 },
    { PseudoVASUB_VV_M8, 87 },
    { PseudoVASUB_VV_MF2, 88 },
    { PseudoVASUB_VV_MF4, 89 },
    { PseudoVASUB_VV_MF8, 90 },
    { PseudoVASUB_VX_M1, 91 },
    { PseudoVASUB_VX_M2, 92 },
    { PseudoVASUB_VX_M4, 93 },
    { PseudoVASUB_VX_M8, 94 },
    { PseudoVASUB_VX_MF2, 95 },
    { PseudoVASUB_VX_MF4, 96 },
    { PseudoVASUB_VX_MF8, 97 },
    { PseudoVDIVU_VV_M1, 98 },
    { PseudoVDIVU_VV_M2, 99 },
    { PseudoVDIVU_VV_M4, 100 },
    { PseudoVDIVU_VV_M8, 101 },
    { PseudoVDIVU_VV_MF2, 102 },
    { PseudoVDIVU_VV_MF4, 103 },
    { PseudoVDIVU_VV_MF8, 104 },
    { PseudoVDIVU_VX_M1, 105 },
    { PseudoVDIVU_VX_M2, 106 },
    { PseudoVDIVU_VX_M4, 107 },
    { PseudoVDIVU_VX_M8, 108 },
    { PseudoVDIVU_VX_MF2, 109 },
    { PseudoVDIVU_VX_MF4, 110 },
    { PseudoVDIVU_VX_MF8, 111 },
    { PseudoVDIV_VV_M1, 112 },
    { PseudoVDIV_VV_M2, 113 },
    { PseudoVDIV_VV_M4, 114 },
    { PseudoVDIV_VV_M8, 115 },
    { PseudoVDIV_VV_MF2, 116 },
    { PseudoVDIV_VV_MF4, 117 },
    { PseudoVDIV_VV_MF8, 118 },
    { PseudoVDIV_VX_M1, 119 },
    { PseudoVDIV_VX_M2, 120 },
    { PseudoVDIV_VX_M4, 121 },
    { PseudoVDIV_VX_M8, 122 },
    { PseudoVDIV_VX_MF2, 123 },
    { PseudoVDIV_VX_MF4, 124 },
    { PseudoVDIV_VX_MF8, 125 },
    { PseudoVFADD_VF16_M1, 126 },
    { PseudoVFADD_VF16_M2, 127 },
    { PseudoVFADD_VF16_M4, 128 },
    { PseudoVFADD_VF16_M8, 129 },
    { PseudoVFADD_VF16_MF2, 130 },
    { PseudoVFADD_VF16_MF4, 131 },
    { PseudoVFADD_VF32_M1, 132 },
    { PseudoVFADD_VF32_M2, 133 },
    { PseudoVFADD_VF32_M4, 134 },
    { PseudoVFADD_VF32_M8, 135 },
    { PseudoVFADD_VF32_MF2, 136 },
    { PseudoVFADD_VF64_M1, 137 },
    { PseudoVFADD_VF64_M2, 138 },
    { PseudoVFADD_VF64_M4, 139 },
    { PseudoVFADD_VF64_M8, 140 },
    { PseudoVFADD_VV_M1, 141 },
    { PseudoVFADD_VV_M2, 142 },
    { PseudoVFADD_VV_M4, 143 },
    { PseudoVFADD_VV_M8, 144 },
    { PseudoVFADD_VV_MF2, 145 },
    { PseudoVFADD_VV_MF4, 146 },
    { PseudoVFCLASS_V_M1, 147 },
    { PseudoVFCLASS_V_M2, 148 },
    { PseudoVFCLASS_V_M4, 149 },
    { PseudoVFCLASS_V_M8, 150 },
    { PseudoVFCLASS_V_MF2, 151 },
    { PseudoVFCLASS_V_MF4, 152 },
    { PseudoVFCVT_F_XU_V_M1, 153 },
    { PseudoVFCVT_F_XU_V_M2, 154 },
    { PseudoVFCVT_F_XU_V_M4, 155 },
    { PseudoVFCVT_F_XU_V_M8, 156 },
    { PseudoVFCVT_F_XU_V_MF2, 157 },
    { PseudoVFCVT_F_XU_V_MF4, 158 },
    { PseudoVFCVT_F_X_V_M1, 159 },
    { PseudoVFCVT_F_X_V_M2, 160 },
    { PseudoVFCVT_F_X_V_M4, 161 },
    { PseudoVFCVT_F_X_V_M8, 162 },
    { PseudoVFCVT_F_X_V_MF2, 163 },
    { PseudoVFCVT_F_X_V_MF4, 164 },
    { PseudoVFCVT_RTZ_XU_F_V_M1, 165 },
    { PseudoVFCVT_RTZ_XU_F_V_M2, 166 },
    { PseudoVFCVT_RTZ_XU_F_V_M4, 167 },
    { PseudoVFCVT_RTZ_XU_F_V_M8, 168 },
    { PseudoVFCVT_RTZ_XU_F_V_MF2, 169 },
    { PseudoVFCVT_RTZ_XU_F_V_MF4, 170 },
    { PseudoVFCVT_RTZ_X_F_V_M1, 171 },
    { PseudoVFCVT_RTZ_X_F_V_M2, 172 },
    { PseudoVFCVT_RTZ_X_F_V_M4, 173 },
    { PseudoVFCVT_RTZ_X_F_V_M8, 174 },
    { PseudoVFCVT_RTZ_X_F_V_MF2, 175 },
    { PseudoVFCVT_RTZ_X_F_V_MF4, 176 },
    { PseudoVFCVT_XU_F_V_M1, 177 },
    { PseudoVFCVT_XU_F_V_M2, 178 },
    { PseudoVFCVT_XU_F_V_M4, 179 },
    { PseudoVFCVT_XU_F_V_M8, 180 },
    { PseudoVFCVT_XU_F_V_MF2, 181 },
    { PseudoVFCVT_XU_F_V_MF4, 182 },
    { PseudoVFCVT_X_F_V_M1, 183 },
    { PseudoVFCVT_X_F_V_M2, 184 },
    { PseudoVFCVT_X_F_V_M4, 185 },
    { PseudoVFCVT_X_F_V_M8, 186 },
    { PseudoVFCVT_X_F_V_MF2, 187 },
    { PseudoVFCVT_X_F_V_MF4, 188 },
    { PseudoVFDIV_VF16_M1, 189 },
    { PseudoVFDIV_VF16_M2, 190 },
    { PseudoVFDIV_VF16_M4, 191 },
    { PseudoVFDIV_VF16_M8, 192 },
    { PseudoVFDIV_VF16_MF2, 193 },
    { PseudoVFDIV_VF16_MF4, 194 },
    { PseudoVFDIV_VF32_M1, 195 },
    { PseudoVFDIV_VF32_M2, 196 },
    { PseudoVFDIV_VF32_M4, 197 },
    { PseudoVFDIV_VF32_M8, 198 },
    { PseudoVFDIV_VF32_MF2, 199 },
    { PseudoVFDIV_VF64_M1, 200 },
    { PseudoVFDIV_VF64_M2, 201 },
    { PseudoVFDIV_VF64_M4, 202 },
    { PseudoVFDIV_VF64_M8, 203 },
    { PseudoVFDIV_VV_M1, 204 },
    { PseudoVFDIV_VV_M2, 205 },
    { PseudoVFDIV_VV_M4, 206 },
    { PseudoVFDIV_VV_M8, 207 },
    { PseudoVFDIV_VV_MF2, 208 },
    { PseudoVFDIV_VV_MF4, 209 },
    { PseudoVFMAX_VF16_M1, 210 },
    { PseudoVFMAX_VF16_M2, 211 },
    { PseudoVFMAX_VF16_M4, 212 },
    { PseudoVFMAX_VF16_M8, 213 },
    { PseudoVFMAX_VF16_MF2, 214 },
    { PseudoVFMAX_VF16_MF4, 215 },
    { PseudoVFMAX_VF32_M1, 216 },
    { PseudoVFMAX_VF32_M2, 217 },
    { PseudoVFMAX_VF32_M4, 218 },
    { PseudoVFMAX_VF32_M8, 219 },
    { PseudoVFMAX_VF32_MF2, 220 },
    { PseudoVFMAX_VF64_M1, 221 },
    { PseudoVFMAX_VF64_M2, 222 },
    { PseudoVFMAX_VF64_M4, 223 },
    { PseudoVFMAX_VF64_M8, 224 },
    { PseudoVFMAX_VV_M1, 225 },
    { PseudoVFMAX_VV_M2, 226 },
    { PseudoVFMAX_VV_M4, 227 },
    { PseudoVFMAX_VV_M8, 228 },
    { PseudoVFMAX_VV_MF2, 229 },
    { PseudoVFMAX_VV_MF4, 230 },
    { PseudoVFMIN_VF16_M1, 231 },
    { PseudoVFMIN_VF16_M2, 232 },
    { PseudoVFMIN_VF16_M4, 233 },
    { PseudoVFMIN_VF16_M8, 234 },
    { PseudoVFMIN_VF16_MF2, 235 },
    { PseudoVFMIN_VF16_MF4, 236 },
    { PseudoVFMIN_VF32_M1, 237 },
    { PseudoVFMIN_VF32_M2, 238 },
    { PseudoVFMIN_VF32_M4, 239 },
    { PseudoVFMIN_VF32_M8, 240 },
    { PseudoVFMIN_VF32_MF2, 241 },
    { PseudoVFMIN_VF64_M1, 242 },
    { PseudoVFMIN_VF64_M2, 243 },
    { PseudoVFMIN_VF64_M4, 244 },
    { PseudoVFMIN_VF64_M8, 245 },
    { PseudoVFMIN_VV_M1, 246 },
    { PseudoVFMIN_VV_M2, 247 },
    { PseudoVFMIN_VV_M4, 248 },
    { PseudoVFMIN_VV_M8, 249 },
    { PseudoVFMIN_VV_MF2, 250 },
    { PseudoVFMIN_VV_MF4, 251 },
    { PseudoVFMUL_VF16_M1, 252 },
    { PseudoVFMUL_VF16_M2, 253 },
    { PseudoVFMUL_VF16_M4, 254 },
    { PseudoVFMUL_VF16_M8, 255 },
    { PseudoVFMUL_VF16_MF2, 256 },
    { PseudoVFMUL_VF16_MF4, 257 },
    { PseudoVFMUL_VF32_M1, 258 },
    { PseudoVFMUL_VF32_M2, 259 },
    { PseudoVFMUL_VF32_M4, 260 },
    { PseudoVFMUL_VF32_M8, 261 },
    { PseudoVFMUL_VF32_MF2, 262 },
    { PseudoVFMUL_VF64_M1, 263 },
    { PseudoVFMUL_VF64_M2, 264 },
    { PseudoVFMUL_VF64_M4, 265 },
    { PseudoVFMUL_VF64_M8, 266 },
    { PseudoVFMUL_VV_M1, 267 },
    { PseudoVFMUL_VV_M2, 268 },
    { PseudoVFMUL_VV_M4, 269 },
    { PseudoVFMUL_VV_M8, 270 },
    { PseudoVFMUL_VV_MF2, 271 },
    { PseudoVFMUL_VV_MF4, 272 },
    { PseudoVFNCVT_F_F_W_M1, 273 },
    { PseudoVFNCVT_F_F_W_M2, 274 },
    { PseudoVFNCVT_F_F_W_M4, 275 },
    { PseudoVFNCVT_F_F_W_MF2, 276 },
    { PseudoVFNCVT_F_F_W_MF4, 277 },
    { PseudoVFNCVT_F_XU_W_M1, 278 },
    { PseudoVFNCVT_F_XU_W_M2, 279 },
    { PseudoVFNCVT_F_XU_W_M4, 280 },
    { PseudoVFNCVT_F_XU_W_MF2, 281 },
    { PseudoVFNCVT_F_XU_W_MF4, 282 },
    { PseudoVFNCVT_F_X_W_M1, 283 },
    { PseudoVFNCVT_F_X_W_M2, 284 },
    { PseudoVFNCVT_F_X_W_M4, 285 },
    { PseudoVFNCVT_F_X_W_MF2, 286 },
    { PseudoVFNCVT_F_X_W_MF4, 287 },
    { PseudoVFNCVT_ROD_F_F_W_M1, 288 },
    { PseudoVFNCVT_ROD_F_F_W_M2, 289 },
    { PseudoVFNCVT_ROD_F_F_W_M4, 290 },
    { PseudoVFNCVT_ROD_F_F_W_MF2, 291 },
    { PseudoVFNCVT_ROD_F_F_W_MF4, 292 },
    { PseudoVFNCVT_RTZ_XU_F_W_M1, 293 },
    { PseudoVFNCVT_RTZ_XU_F_W_M2, 294 },
    { PseudoVFNCVT_RTZ_XU_F_W_M4, 295 },
    { PseudoVFNCVT_RTZ_XU_F_W_MF2, 296 },
    { PseudoVFNCVT_RTZ_XU_F_W_MF4, 297 },
    { PseudoVFNCVT_RTZ_XU_F_W_MF8, 298 },
    { PseudoVFNCVT_RTZ_X_F_W_M1, 299 },
    { PseudoVFNCVT_RTZ_X_F_W_M2, 300 },
    { PseudoVFNCVT_RTZ_X_F_W_M4, 301 },
    { PseudoVFNCVT_RTZ_X_F_W_MF2, 302 },
    { PseudoVFNCVT_RTZ_X_F_W_MF4, 303 },
    { PseudoVFNCVT_RTZ_X_F_W_MF8, 304 },
    { PseudoVFNCVT_XU_F_W_M1, 305 },
    { PseudoVFNCVT_XU_F_W_M2, 306 },
    { PseudoVFNCVT_XU_F_W_M4, 307 },
    { PseudoVFNCVT_XU_F_W_MF2, 308 },
    { PseudoVFNCVT_XU_F_W_MF4, 309 },
    { PseudoVFNCVT_XU_F_W_MF8, 310 },
    { PseudoVFNCVT_X_F_W_M1, 311 },
    { PseudoVFNCVT_X_F_W_M2, 312 },
    { PseudoVFNCVT_X_F_W_M4, 313 },
    { PseudoVFNCVT_X_F_W_MF2, 314 },
    { PseudoVFNCVT_X_F_W_MF4, 315 },
    { PseudoVFNCVT_X_F_W_MF8, 316 },
    { PseudoVFRDIV_VF16_M1, 317 },
    { PseudoVFRDIV_VF16_M2, 318 },
    { PseudoVFRDIV_VF16_M4, 319 },
    { PseudoVFRDIV_VF16_M8, 320 },
    { PseudoVFRDIV_VF16_MF2, 321 },
    { PseudoVFRDIV_VF16_MF4, 322 },
    { PseudoVFRDIV_VF32_M1, 323 },
    { PseudoVFRDIV_VF32_M2, 324 },
    { PseudoVFRDIV_VF32_M4, 325 },
    { PseudoVFRDIV_VF32_M8, 326 },
    { PseudoVFRDIV_VF32_MF2, 327 },
    { PseudoVFRDIV_VF64_M1, 328 },
    { PseudoVFRDIV_VF64_M2, 329 },
    { PseudoVFRDIV_VF64_M4, 330 },
    { PseudoVFRDIV_VF64_M8, 331 },
    { PseudoVFREC7_V_M1, 332 },
    { PseudoVFREC7_V_M2, 333 },
    { PseudoVFREC7_V_M4, 334 },
    { PseudoVFREC7_V_M8, 335 },
    { PseudoVFREC7_V_MF2, 336 },
    { PseudoVFREC7_V_MF4, 337 },
    { PseudoVFRSQRT7_V_M1, 338 },
    { PseudoVFRSQRT7_V_M2, 339 },
    { PseudoVFRSQRT7_V_M4, 340 },
    { PseudoVFRSQRT7_V_M8, 341 },
    { PseudoVFRSQRT7_V_MF2, 342 },
    { PseudoVFRSQRT7_V_MF4, 343 },
    { PseudoVFRSUB_VF16_M1, 344 },
    { PseudoVFRSUB_VF16_M2, 345 },
    { PseudoVFRSUB_VF16_M4, 346 },
    { PseudoVFRSUB_VF16_M8, 347 },
    { PseudoVFRSUB_VF16_MF2, 348 },
    { PseudoVFRSUB_VF16_MF4, 349 },
    { PseudoVFRSUB_VF32_M1, 350 },
    { PseudoVFRSUB_VF32_M2, 351 },
    { PseudoVFRSUB_VF32_M4, 352 },
    { PseudoVFRSUB_VF32_M8, 353 },
    { PseudoVFRSUB_VF32_MF2, 354 },
    { PseudoVFRSUB_VF64_M1, 355 },
    { PseudoVFRSUB_VF64_M2, 356 },
    { PseudoVFRSUB_VF64_M4, 357 },
    { PseudoVFRSUB_VF64_M8, 358 },
    { PseudoVFSGNJN_VF16_M1, 359 },
    { PseudoVFSGNJN_VF16_M2, 360 },
    { PseudoVFSGNJN_VF16_M4, 361 },
    { PseudoVFSGNJN_VF16_M8, 362 },
    { PseudoVFSGNJN_VF16_MF2, 363 },
    { PseudoVFSGNJN_VF16_MF4, 364 },
    { PseudoVFSGNJN_VF32_M1, 365 },
    { PseudoVFSGNJN_VF32_M2, 366 },
    { PseudoVFSGNJN_VF32_M4, 367 },
    { PseudoVFSGNJN_VF32_M8, 368 },
    { PseudoVFSGNJN_VF32_MF2, 369 },
    { PseudoVFSGNJN_VF64_M1, 370 },
    { PseudoVFSGNJN_VF64_M2, 371 },
    { PseudoVFSGNJN_VF64_M4, 372 },
    { PseudoVFSGNJN_VF64_M8, 373 },
    { PseudoVFSGNJN_VV_M1, 374 },
    { PseudoVFSGNJN_VV_M2, 375 },
    { PseudoVFSGNJN_VV_M4, 376 },
    { PseudoVFSGNJN_VV_M8, 377 },
    { PseudoVFSGNJN_VV_MF2, 378 },
    { PseudoVFSGNJN_VV_MF4, 379 },
    { PseudoVFSGNJX_VF16_M1, 380 },
    { PseudoVFSGNJX_VF16_M2, 381 },
    { PseudoVFSGNJX_VF16_M4, 382 },
    { PseudoVFSGNJX_VF16_M8, 383 },
    { PseudoVFSGNJX_VF16_MF2, 384 },
    { PseudoVFSGNJX_VF16_MF4, 385 },
    { PseudoVFSGNJX_VF32_M1, 386 },
    { PseudoVFSGNJX_VF32_M2, 387 },
    { PseudoVFSGNJX_VF32_M4, 388 },
    { PseudoVFSGNJX_VF32_M8, 389 },
    { PseudoVFSGNJX_VF32_MF2, 390 },
    { PseudoVFSGNJX_VF64_M1, 391 },
    { PseudoVFSGNJX_VF64_M2, 392 },
    { PseudoVFSGNJX_VF64_M4, 393 },
    { PseudoVFSGNJX_VF64_M8, 394 },
    { PseudoVFSGNJX_VV_M1, 395 },
    { PseudoVFSGNJX_VV_M2, 396 },
    { PseudoVFSGNJX_VV_M4, 397 },
    { PseudoVFSGNJX_VV_M8, 398 },
    { PseudoVFSGNJX_VV_MF2, 399 },
    { PseudoVFSGNJX_VV_MF4, 400 },
    { PseudoVFSGNJ_VF16_M1, 401 },
    { PseudoVFSGNJ_VF16_M2, 402 },
    { PseudoVFSGNJ_VF16_M4, 403 },
    { PseudoVFSGNJ_VF16_M8, 404 },
    { PseudoVFSGNJ_VF16_MF2, 405 },
    { PseudoVFSGNJ_VF16_MF4, 406 },
    { PseudoVFSGNJ_VF32_M1, 407 },
    { PseudoVFSGNJ_VF32_M2, 408 },
    { PseudoVFSGNJ_VF32_M4, 409 },
    { PseudoVFSGNJ_VF32_M8, 410 },
    { PseudoVFSGNJ_VF32_MF2, 411 },
    { PseudoVFSGNJ_VF64_M1, 412 },
    { PseudoVFSGNJ_VF64_M2, 413 },
    { PseudoVFSGNJ_VF64_M4, 414 },
    { PseudoVFSGNJ_VF64_M8, 415 },
    { PseudoVFSGNJ_VV_M1, 416 },
    { PseudoVFSGNJ_VV_M2, 417 },
    { PseudoVFSGNJ_VV_M4, 418 },
    { PseudoVFSGNJ_VV_M8, 419 },
    { PseudoVFSGNJ_VV_MF2, 420 },
    { PseudoVFSGNJ_VV_MF4, 421 },
    { PseudoVFSLIDE1DOWN_VF16_M1, 422 },
    { PseudoVFSLIDE1DOWN_VF16_M2, 423 },
    { PseudoVFSLIDE1DOWN_VF16_M4, 424 },
    { PseudoVFSLIDE1DOWN_VF16_M8, 425 },
    { PseudoVFSLIDE1DOWN_VF16_MF2, 426 },
    { PseudoVFSLIDE1DOWN_VF16_MF4, 427 },
    { PseudoVFSLIDE1DOWN_VF32_M1, 428 },
    { PseudoVFSLIDE1DOWN_VF32_M2, 429 },
    { PseudoVFSLIDE1DOWN_VF32_M4, 430 },
    { PseudoVFSLIDE1DOWN_VF32_M8, 431 },
    { PseudoVFSLIDE1DOWN_VF32_MF2, 432 },
    { PseudoVFSLIDE1DOWN_VF64_M1, 433 },
    { PseudoVFSLIDE1DOWN_VF64_M2, 434 },
    { PseudoVFSLIDE1DOWN_VF64_M4, 435 },
    { PseudoVFSLIDE1DOWN_VF64_M8, 436 },
    { PseudoVFSLIDE1UP_VF16_M1, 437 },
    { PseudoVFSLIDE1UP_VF16_M2, 438 },
    { PseudoVFSLIDE1UP_VF16_M4, 439 },
    { PseudoVFSLIDE1UP_VF16_M8, 440 },
    { PseudoVFSLIDE1UP_VF16_MF2, 441 },
    { PseudoVFSLIDE1UP_VF16_MF4, 442 },
    { PseudoVFSLIDE1UP_VF32_M1, 443 },
    { PseudoVFSLIDE1UP_VF32_M2, 444 },
    { PseudoVFSLIDE1UP_VF32_M4, 445 },
    { PseudoVFSLIDE1UP_VF32_M8, 446 },
    { PseudoVFSLIDE1UP_VF32_MF2, 447 },
    { PseudoVFSLIDE1UP_VF64_M1, 448 },
    { PseudoVFSLIDE1UP_VF64_M2, 449 },
    { PseudoVFSLIDE1UP_VF64_M4, 450 },
    { PseudoVFSLIDE1UP_VF64_M8, 451 },
    { PseudoVFSQRT_V_M1, 452 },
    { PseudoVFSQRT_V_M2, 453 },
    { PseudoVFSQRT_V_M4, 454 },
    { PseudoVFSQRT_V_M8, 455 },
    { PseudoVFSQRT_V_MF2, 456 },
    { PseudoVFSQRT_V_MF4, 457 },
    { PseudoVFSUB_VF16_M1, 458 },
    { PseudoVFSUB_VF16_M2, 459 },
    { PseudoVFSUB_VF16_M4, 460 },
    { PseudoVFSUB_VF16_M8, 461 },
    { PseudoVFSUB_VF16_MF2, 462 },
    { PseudoVFSUB_VF16_MF4, 463 },
    { PseudoVFSUB_VF32_M1, 464 },
    { PseudoVFSUB_VF32_M2, 465 },
    { PseudoVFSUB_VF32_M4, 466 },
    { PseudoVFSUB_VF32_M8, 467 },
    { PseudoVFSUB_VF32_MF2, 468 },
    { PseudoVFSUB_VF64_M1, 469 },
    { PseudoVFSUB_VF64_M2, 470 },
    { PseudoVFSUB_VF64_M4, 471 },
    { PseudoVFSUB_VF64_M8, 472 },
    { PseudoVFSUB_VV_M1, 473 },
    { PseudoVFSUB_VV_M2, 474 },
    { PseudoVFSUB_VV_M4, 475 },
    { PseudoVFSUB_VV_M8, 476 },
    { PseudoVFSUB_VV_MF2, 477 },
    { PseudoVFSUB_VV_MF4, 478 },
    { PseudoVFWADD_VF16_M1, 479 },
    { PseudoVFWADD_VF16_M2, 480 },
    { PseudoVFWADD_VF16_M4, 481 },
    { PseudoVFWADD_VF16_MF2, 482 },
    { PseudoVFWADD_VF16_MF4, 483 },
    { PseudoVFWADD_VF32_M1, 484 },
    { PseudoVFWADD_VF32_M2, 485 },
    { PseudoVFWADD_VF32_M4, 486 },
    { PseudoVFWADD_VF32_MF2, 487 },
    { PseudoVFWADD_VV_M1, 488 },
    { PseudoVFWADD_VV_M2, 489 },
    { PseudoVFWADD_VV_M4, 490 },
    { PseudoVFWADD_VV_MF2, 491 },
    { PseudoVFWADD_VV_MF4, 492 },
    { PseudoVFWADD_WF16_M1, 493 },
    { PseudoVFWADD_WF16_M2, 494 },
    { PseudoVFWADD_WF16_M4, 495 },
    { PseudoVFWADD_WF16_MF2, 496 },
    { PseudoVFWADD_WF16_MF4, 497 },
    { PseudoVFWADD_WF32_M1, 498 },
    { PseudoVFWADD_WF32_M2, 499 },
    { PseudoVFWADD_WF32_M4, 500 },
    { PseudoVFWADD_WF32_MF2, 501 },
    { PseudoVFWADD_WV_M1, 502 },
    { PseudoVFWADD_WV_M2, 503 },
    { PseudoVFWADD_WV_M4, 504 },
    { PseudoVFWADD_WV_MF2, 505 },
    { PseudoVFWADD_WV_MF4, 506 },
    { PseudoVFWCVT_F_F_V_M1, 507 },
    { PseudoVFWCVT_F_F_V_M2, 508 },
    { PseudoVFWCVT_F_F_V_M4, 509 },
    { PseudoVFWCVT_F_F_V_MF2, 510 },
    { PseudoVFWCVT_F_F_V_MF4, 511 },
    { PseudoVFWCVT_F_XU_V_M1, 512 },
    { PseudoVFWCVT_F_XU_V_M2, 513 },
    { PseudoVFWCVT_F_XU_V_M4, 514 },
    { PseudoVFWCVT_F_XU_V_MF2, 515 },
    { PseudoVFWCVT_F_XU_V_MF4, 516 },
    { PseudoVFWCVT_F_XU_V_MF8, 517 },
    { PseudoVFWCVT_F_X_V_M1, 518 },
    { PseudoVFWCVT_F_X_V_M2, 519 },
    { PseudoVFWCVT_F_X_V_M4, 520 },
    { PseudoVFWCVT_F_X_V_MF2, 521 },
    { PseudoVFWCVT_F_X_V_MF4, 522 },
    { PseudoVFWCVT_F_X_V_MF8, 523 },
    { PseudoVFWCVT_RTZ_XU_F_V_M1, 524 },
    { PseudoVFWCVT_RTZ_XU_F_V_M2, 525 },
    { PseudoVFWCVT_RTZ_XU_F_V_M4, 526 },
    { PseudoVFWCVT_RTZ_XU_F_V_MF2, 527 },
    { PseudoVFWCVT_RTZ_XU_F_V_MF4, 528 },
    { PseudoVFWCVT_RTZ_X_F_V_M1, 529 },
    { PseudoVFWCVT_RTZ_X_F_V_M2, 530 },
    { PseudoVFWCVT_RTZ_X_F_V_M4, 531 },
    { PseudoVFWCVT_RTZ_X_F_V_MF2, 532 },
    { PseudoVFWCVT_RTZ_X_F_V_MF4, 533 },
    { PseudoVFWCVT_XU_F_V_M1, 534 },
    { PseudoVFWCVT_XU_F_V_M2, 535 },
    { PseudoVFWCVT_XU_F_V_M4, 536 },
    { PseudoVFWCVT_XU_F_V_MF2, 537 },
    { PseudoVFWCVT_XU_F_V_MF4, 538 },
    { PseudoVFWCVT_X_F_V_M1, 539 },
    { PseudoVFWCVT_X_F_V_M2, 540 },
    { PseudoVFWCVT_X_F_V_M4, 541 },
    { PseudoVFWCVT_X_F_V_MF2, 542 },
    { PseudoVFWCVT_X_F_V_MF4, 543 },
    { PseudoVFWMUL_VF16_M1, 544 },
    { PseudoVFWMUL_VF16_M2, 545 },
    { PseudoVFWMUL_VF16_M4, 546 },
    { PseudoVFWMUL_VF16_MF2, 547 },
    { PseudoVFWMUL_VF16_MF4, 548 },
    { PseudoVFWMUL_VF32_M1, 549 },
    { PseudoVFWMUL_VF32_M2, 550 },
    { PseudoVFWMUL_VF32_M4, 551 },
    { PseudoVFWMUL_VF32_MF2, 552 },
    { PseudoVFWMUL_VV_M1, 553 },
    { PseudoVFWMUL_VV_M2, 554 },
    { PseudoVFWMUL_VV_M4, 555 },
    { PseudoVFWMUL_VV_MF2, 556 },
    { PseudoVFWMUL_VV_MF4, 557 },
    { PseudoVFWSUB_VF16_M1, 558 },
    { PseudoVFWSUB_VF16_M2, 559 },
    { PseudoVFWSUB_VF16_M4, 560 },
    { PseudoVFWSUB_VF16_MF2, 561 },
    { PseudoVFWSUB_VF16_MF4, 562 },
    { PseudoVFWSUB_VF32_M1, 563 },
    { PseudoVFWSUB_VF32_M2, 564 },
    { PseudoVFWSUB_VF32_M4, 565 },
    { PseudoVFWSUB_VF32_MF2, 566 },
    { PseudoVFWSUB_VV_M1, 567 },
    { PseudoVFWSUB_VV_M2, 568 },
    { PseudoVFWSUB_VV_M4, 569 },
    { PseudoVFWSUB_VV_MF2, 570 },
    { PseudoVFWSUB_VV_MF4, 571 },
    { PseudoVFWSUB_WF16_M1, 572 },
    { PseudoVFWSUB_WF16_M2, 573 },
    { PseudoVFWSUB_WF16_M4, 574 },
    { PseudoVFWSUB_WF16_MF2, 575 },
    { PseudoVFWSUB_WF16_MF4, 576 },
    { PseudoVFWSUB_WF32_M1, 577 },
    { PseudoVFWSUB_WF32_M2, 578 },
    { PseudoVFWSUB_WF32_M4, 579 },
    { PseudoVFWSUB_WF32_MF2, 580 },
    { PseudoVFWSUB_WV_M1, 581 },
    { PseudoVFWSUB_WV_M2, 582 },
    { PseudoVFWSUB_WV_M4, 583 },
    { PseudoVFWSUB_WV_MF2, 584 },
    { PseudoVFWSUB_WV_MF4, 585 },
    { PseudoVID_V_M1, 586 },
    { PseudoVID_V_M2, 587 },
    { PseudoVID_V_M4, 588 },
    { PseudoVID_V_M8, 589 },
    { PseudoVID_V_MF2, 590 },
    { PseudoVID_V_MF4, 591 },
    { PseudoVID_V_MF8, 592 },
    { PseudoVIOTA_M_M1, 593 },
    { PseudoVIOTA_M_M2, 594 },
    { PseudoVIOTA_M_M4, 595 },
    { PseudoVIOTA_M_M8, 596 },
    { PseudoVIOTA_M_MF2, 597 },
    { PseudoVIOTA_M_MF4, 598 },
    { PseudoVIOTA_M_MF8, 599 },
    { PseudoVLE16FF_V_M1, 600 },
    { PseudoVLE16FF_V_M2, 601 },
    { PseudoVLE16FF_V_M4, 602 },
    { PseudoVLE16FF_V_M8, 603 },
    { PseudoVLE16FF_V_MF2, 604 },
    { PseudoVLE16FF_V_MF4, 605 },
    { PseudoVLE16_V_M1, 606 },
    { PseudoVLE16_V_M2, 607 },
    { PseudoVLE16_V_M4, 608 },
    { PseudoVLE16_V_M8, 609 },
    { PseudoVLE16_V_MF2, 610 },
    { PseudoVLE16_V_MF4, 611 },
    { PseudoVLE32FF_V_M1, 612 },
    { PseudoVLE32FF_V_M2, 613 },
    { PseudoVLE32FF_V_M4, 614 },
    { PseudoVLE32FF_V_M8, 615 },
    { PseudoVLE32FF_V_MF2, 616 },
    { PseudoVLE32_V_M1, 617 },
    { PseudoVLE32_V_M2, 618 },
    { PseudoVLE32_V_M4, 619 },
    { PseudoVLE32_V_M8, 620 },
    { PseudoVLE32_V_MF2, 621 },
    { PseudoVLE64FF_V_M1, 622 },
    { PseudoVLE64FF_V_M2, 623 },
    { PseudoVLE64FF_V_M4, 624 },
    { PseudoVLE64FF_V_M8, 625 },
    { PseudoVLE64_V_M1, 626 },
    { PseudoVLE64_V_M2, 627 },
    { PseudoVLE64_V_M4, 628 },
    { PseudoVLE64_V_M8, 629 },
    { PseudoVLE8FF_V_M1, 630 },
    { PseudoVLE8FF_V_M2, 631 },
    { PseudoVLE8FF_V_M4, 632 },
    { PseudoVLE8FF_V_M8, 633 },
    { PseudoVLE8FF_V_MF2, 634 },
    { PseudoVLE8FF_V_MF4, 635 },
    { PseudoVLE8FF_V_MF8, 636 },
    { PseudoVLE8_V_M1, 637 },
    { PseudoVLE8_V_M2, 638 },
    { PseudoVLE8_V_M4, 639 },
    { PseudoVLE8_V_M8, 640 },
    { PseudoVLE8_V_MF2, 641 },
    { PseudoVLE8_V_MF4, 642 },
    { PseudoVLE8_V_MF8, 643 },
    { PseudoVLOXEI16_V_M1_M1, 644 },
    { PseudoVLOXEI16_V_M1_M2, 645 },
    { PseudoVLOXEI16_V_M1_M4, 646 },
    { PseudoVLOXEI16_V_M1_MF2, 647 },
    { PseudoVLOXEI16_V_M2_M1, 648 },
    { PseudoVLOXEI16_V_M2_M2, 649 },
    { PseudoVLOXEI16_V_M2_M4, 650 },
    { PseudoVLOXEI16_V_M2_M8, 651 },
    { PseudoVLOXEI16_V_M4_M2, 652 },
    { PseudoVLOXEI16_V_M4_M4, 653 },
    { PseudoVLOXEI16_V_M4_M8, 654 },
    { PseudoVLOXEI16_V_M8_M4, 655 },
    { PseudoVLOXEI16_V_M8_M8, 656 },
    { PseudoVLOXEI16_V_MF2_M1, 657 },
    { PseudoVLOXEI16_V_MF2_M2, 658 },
    { PseudoVLOXEI16_V_MF2_MF2, 659 },
    { PseudoVLOXEI16_V_MF2_MF4, 660 },
    { PseudoVLOXEI16_V_MF4_M1, 661 },
    { PseudoVLOXEI16_V_MF4_MF2, 662 },
    { PseudoVLOXEI16_V_MF4_MF4, 663 },
    { PseudoVLOXEI16_V_MF4_MF8, 664 },
    { PseudoVLOXEI32_V_M1_M1, 665 },
    { PseudoVLOXEI32_V_M1_M2, 666 },
    { PseudoVLOXEI32_V_M1_MF2, 667 },
    { PseudoVLOXEI32_V_M1_MF4, 668 },
    { PseudoVLOXEI32_V_M2_M1, 669 },
    { PseudoVLOXEI32_V_M2_M2, 670 },
    { PseudoVLOXEI32_V_M2_M4, 671 },
    { PseudoVLOXEI32_V_M2_MF2, 672 },
    { PseudoVLOXEI32_V_M4_M1, 673 },
    { PseudoVLOXEI32_V_M4_M2, 674 },
    { PseudoVLOXEI32_V_M4_M4, 675 },
    { PseudoVLOXEI32_V_M4_M8, 676 },
    { PseudoVLOXEI32_V_M8_M2, 677 },
    { PseudoVLOXEI32_V_M8_M4, 678 },
    { PseudoVLOXEI32_V_M8_M8, 679 },
    { PseudoVLOXEI32_V_MF2_M1, 680 },
    { PseudoVLOXEI32_V_MF2_MF2, 681 },
    { PseudoVLOXEI32_V_MF2_MF4, 682 },
    { PseudoVLOXEI32_V_MF2_MF8, 683 },
    { PseudoVLOXEI64_V_M1_M1, 684 },
    { PseudoVLOXEI64_V_M1_MF2, 685 },
    { PseudoVLOXEI64_V_M1_MF4, 686 },
    { PseudoVLOXEI64_V_M1_MF8, 687 },
    { PseudoVLOXEI64_V_M2_M1, 688 },
    { PseudoVLOXEI64_V_M2_M2, 689 },
    { PseudoVLOXEI64_V_M2_MF2, 690 },
    { PseudoVLOXEI64_V_M2_MF4, 691 },
    { PseudoVLOXEI64_V_M4_M1, 692 },
    { PseudoVLOXEI64_V_M4_M2, 693 },
    { PseudoVLOXEI64_V_M4_M4, 694 },
    { PseudoVLOXEI64_V_M4_MF2, 695 },
    { PseudoVLOXEI64_V_M8_M1, 696 },
    { PseudoVLOXEI64_V_M8_M2, 697 },
    { PseudoVLOXEI64_V_M8_M4, 698 },
    { PseudoVLOXEI64_V_M8_M8, 699 },
    { PseudoVLOXEI8_V_M1_M1, 700 },
    { PseudoVLOXEI8_V_M1_M2, 701 },
    { PseudoVLOXEI8_V_M1_M4, 702 },
    { PseudoVLOXEI8_V_M1_M8, 703 },
    { PseudoVLOXEI8_V_M2_M2, 704 },
    { PseudoVLOXEI8_V_M2_M4, 705 },
    { PseudoVLOXEI8_V_M2_M8, 706 },
    { PseudoVLOXEI8_V_M4_M4, 707 },
    { PseudoVLOXEI8_V_M4_M8, 708 },
    { PseudoVLOXEI8_V_M8_M8, 709 },
    { PseudoVLOXEI8_V_MF2_M1, 710 },
    { PseudoVLOXEI8_V_MF2_M2, 711 },
    { PseudoVLOXEI8_V_MF2_M4, 712 },
    { PseudoVLOXEI8_V_MF2_MF2, 713 },
    { PseudoVLOXEI8_V_MF4_M1, 714 },
    { PseudoVLOXEI8_V_MF4_M2, 715 },
    { PseudoVLOXEI8_V_MF4_MF2, 716 },
    { PseudoVLOXEI8_V_MF4_MF4, 717 },
    { PseudoVLOXEI8_V_MF8_M1, 718 },
    { PseudoVLOXEI8_V_MF8_MF2, 719 },
    { PseudoVLOXEI8_V_MF8_MF4, 720 },
    { PseudoVLOXEI8_V_MF8_MF8, 721 },
    { PseudoVLSE16_V_M1, 722 },
    { PseudoVLSE16_V_M2, 723 },
    { PseudoVLSE16_V_M4, 724 },
    { PseudoVLSE16_V_M8, 725 },
    { PseudoVLSE16_V_MF2, 726 },
    { PseudoVLSE16_V_MF4, 727 },
    { PseudoVLSE32_V_M1, 728 },
    { PseudoVLSE32_V_M2, 729 },
    { PseudoVLSE32_V_M4, 730 },
    { PseudoVLSE32_V_M8, 731 },
    { PseudoVLSE32_V_MF2, 732 },
    { PseudoVLSE64_V_M1, 733 },
    { PseudoVLSE64_V_M2, 734 },
    { PseudoVLSE64_V_M4, 735 },
    { PseudoVLSE64_V_M8, 736 },
    { PseudoVLSE8_V_M1, 737 },
    { PseudoVLSE8_V_M2, 738 },
    { PseudoVLSE8_V_M4, 739 },
    { PseudoVLSE8_V_M8, 740 },
    { PseudoVLSE8_V_MF2, 741 },
    { PseudoVLSE8_V_MF4, 742 },
    { PseudoVLSE8_V_MF8, 743 },
    { PseudoVLUXEI16_V_M1_M1, 744 },
    { PseudoVLUXEI16_V_M1_M2, 745 },
    { PseudoVLUXEI16_V_M1_M4, 746 },
    { PseudoVLUXEI16_V_M1_MF2, 747 },
    { PseudoVLUXEI16_V_M2_M1, 748 },
    { PseudoVLUXEI16_V_M2_M2, 749 },
    { PseudoVLUXEI16_V_M2_M4, 750 },
    { PseudoVLUXEI16_V_M2_M8, 751 },
    { PseudoVLUXEI16_V_M4_M2, 752 },
    { PseudoVLUXEI16_V_M4_M4, 753 },
    { PseudoVLUXEI16_V_M4_M8, 754 },
    { PseudoVLUXEI16_V_M8_M4, 755 },
    { PseudoVLUXEI16_V_M8_M8, 756 },
    { PseudoVLUXEI16_V_MF2_M1, 757 },
    { PseudoVLUXEI16_V_MF2_M2, 758 },
    { PseudoVLUXEI16_V_MF2_MF2, 759 },
    { PseudoVLUXEI16_V_MF2_MF4, 760 },
    { PseudoVLUXEI16_V_MF4_M1, 761 },
    { PseudoVLUXEI16_V_MF4_MF2, 762 },
    { PseudoVLUXEI16_V_MF4_MF4, 763 },
    { PseudoVLUXEI16_V_MF4_MF8, 764 },
    { PseudoVLUXEI32_V_M1_M1, 765 },
    { PseudoVLUXEI32_V_M1_M2, 766 },
    { PseudoVLUXEI32_V_M1_MF2, 767 },
    { PseudoVLUXEI32_V_M1_MF4, 768 },
    { PseudoVLUXEI32_V_M2_M1, 769 },
    { PseudoVLUXEI32_V_M2_M2, 770 },
    { PseudoVLUXEI32_V_M2_M4, 771 },
    { PseudoVLUXEI32_V_M2_MF2, 772 },
    { PseudoVLUXEI32_V_M4_M1, 773 },
    { PseudoVLUXEI32_V_M4_M2, 774 },
    { PseudoVLUXEI32_V_M4_M4, 775 },
    { PseudoVLUXEI32_V_M4_M8, 776 },
    { PseudoVLUXEI32_V_M8_M2, 777 },
    { PseudoVLUXEI32_V_M8_M4, 778 },
    { PseudoVLUXEI32_V_M8_M8, 779 },
    { PseudoVLUXEI32_V_MF2_M1, 780 },
    { PseudoVLUXEI32_V_MF2_MF2, 781 },
    { PseudoVLUXEI32_V_MF2_MF4, 782 },
    { PseudoVLUXEI32_V_MF2_MF8, 783 },
    { PseudoVLUXEI64_V_M1_M1, 784 },
    { PseudoVLUXEI64_V_M1_MF2, 785 },
    { PseudoVLUXEI64_V_M1_MF4, 786 },
    { PseudoVLUXEI64_V_M1_MF8, 787 },
    { PseudoVLUXEI64_V_M2_M1, 788 },
    { PseudoVLUXEI64_V_M2_M2, 789 },
    { PseudoVLUXEI64_V_M2_MF2, 790 },
    { PseudoVLUXEI64_V_M2_MF4, 791 },
    { PseudoVLUXEI64_V_M4_M1, 792 },
    { PseudoVLUXEI64_V_M4_M2, 793 },
    { PseudoVLUXEI64_V_M4_M4, 794 },
    { PseudoVLUXEI64_V_M4_MF2, 795 },
    { PseudoVLUXEI64_V_M8_M1, 796 },
    { PseudoVLUXEI64_V_M8_M2, 797 },
    { PseudoVLUXEI64_V_M8_M4, 798 },
    { PseudoVLUXEI64_V_M8_M8, 799 },
    { PseudoVLUXEI8_V_M1_M1, 800 },
    { PseudoVLUXEI8_V_M1_M2, 801 },
    { PseudoVLUXEI8_V_M1_M4, 802 },
    { PseudoVLUXEI8_V_M1_M8, 803 },
    { PseudoVLUXEI8_V_M2_M2, 804 },
    { PseudoVLUXEI8_V_M2_M4, 805 },
    { PseudoVLUXEI8_V_M2_M8, 806 },
    { PseudoVLUXEI8_V_M4_M4, 807 },
    { PseudoVLUXEI8_V_M4_M8, 808 },
    { PseudoVLUXEI8_V_M8_M8, 809 },
    { PseudoVLUXEI8_V_MF2_M1, 810 },
    { PseudoVLUXEI8_V_MF2_M2, 811 },
    { PseudoVLUXEI8_V_MF2_M4, 812 },
    { PseudoVLUXEI8_V_MF2_MF2, 813 },
    { PseudoVLUXEI8_V_MF4_M1, 814 },
    { PseudoVLUXEI8_V_MF4_M2, 815 },
    { PseudoVLUXEI8_V_MF4_MF2, 816 },
    { PseudoVLUXEI8_V_MF4_MF4, 817 },
    { PseudoVLUXEI8_V_MF8_M1, 818 },
    { PseudoVLUXEI8_V_MF8_MF2, 819 },
    { PseudoVLUXEI8_V_MF8_MF4, 820 },
    { PseudoVLUXEI8_V_MF8_MF8, 821 },
    { PseudoVMAXU_VV_M1, 822 },
    { PseudoVMAXU_VV_M2, 823 },
    { PseudoVMAXU_VV_M4, 824 },
    { PseudoVMAXU_VV_M8, 825 },
    { PseudoVMAXU_VV_MF2, 826 },
    { PseudoVMAXU_VV_MF4, 827 },
    { PseudoVMAXU_VV_MF8, 828 },
    { PseudoVMAXU_VX_M1, 829 },
    { PseudoVMAXU_VX_M2, 830 },
    { PseudoVMAXU_VX_M4, 831 },
    { PseudoVMAXU_VX_M8, 832 },
    { PseudoVMAXU_VX_MF2, 833 },
    { PseudoVMAXU_VX_MF4, 834 },
    { PseudoVMAXU_VX_MF8, 835 },
    { PseudoVMAX_VV_M1, 836 },
    { PseudoVMAX_VV_M2, 837 },
    { PseudoVMAX_VV_M4, 838 },
    { PseudoVMAX_VV_M8, 839 },
    { PseudoVMAX_VV_MF2, 840 },
    { PseudoVMAX_VV_MF4, 841 },
    { PseudoVMAX_VV_MF8, 842 },
    { PseudoVMAX_VX_M1, 843 },
    { PseudoVMAX_VX_M2, 844 },
    { PseudoVMAX_VX_M4, 845 },
    { PseudoVMAX_VX_M8, 846 },
    { PseudoVMAX_VX_MF2, 847 },
    { PseudoVMAX_VX_MF4, 848 },
    { PseudoVMAX_VX_MF8, 849 },
    { PseudoVMFEQ_VF16_M1, 850 },
    { PseudoVMFEQ_VF16_M2, 851 },
    { PseudoVMFEQ_VF16_M4, 852 },
    { PseudoVMFEQ_VF16_M8, 853 },
    { PseudoVMFEQ_VF16_MF2, 854 },
    { PseudoVMFEQ_VF16_MF4, 855 },
    { PseudoVMFEQ_VF32_M1, 856 },
    { PseudoVMFEQ_VF32_M2, 857 },
    { PseudoVMFEQ_VF32_M4, 858 },
    { PseudoVMFEQ_VF32_M8, 859 },
    { PseudoVMFEQ_VF32_MF2, 860 },
    { PseudoVMFEQ_VF64_M1, 861 },
    { PseudoVMFEQ_VF64_M2, 862 },
    { PseudoVMFEQ_VF64_M4, 863 },
    { PseudoVMFEQ_VF64_M8, 864 },
    { PseudoVMFEQ_VV_M1, 865 },
    { PseudoVMFEQ_VV_M2, 866 },
    { PseudoVMFEQ_VV_M4, 867 },
    { PseudoVMFEQ_VV_M8, 868 },
    { PseudoVMFEQ_VV_MF2, 869 },
    { PseudoVMFEQ_VV_MF4, 870 },
    { PseudoVMFGE_VF16_M1, 871 },
    { PseudoVMFGE_VF16_M2, 872 },
    { PseudoVMFGE_VF16_M4, 873 },
    { PseudoVMFGE_VF16_M8, 874 },
    { PseudoVMFGE_VF16_MF2, 875 },
    { PseudoVMFGE_VF16_MF4, 876 },
    { PseudoVMFGE_VF32_M1, 877 },
    { PseudoVMFGE_VF32_M2, 878 },
    { PseudoVMFGE_VF32_M4, 879 },
    { PseudoVMFGE_VF32_M8, 880 },
    { PseudoVMFGE_VF32_MF2, 881 },
    { PseudoVMFGE_VF64_M1, 882 },
    { PseudoVMFGE_VF64_M2, 883 },
    { PseudoVMFGE_VF64_M4, 884 },
    { PseudoVMFGE_VF64_M8, 885 },
    { PseudoVMFGT_VF16_M1, 886 },
    { PseudoVMFGT_VF16_M2, 887 },
    { PseudoVMFGT_VF16_M4, 888 },
    { PseudoVMFGT_VF16_M8, 889 },
    { PseudoVMFGT_VF16_MF2, 890 },
    { PseudoVMFGT_VF16_MF4, 891 },
    { PseudoVMFGT_VF32_M1, 892 },
    { PseudoVMFGT_VF32_M2, 893 },
    { PseudoVMFGT_VF32_M4, 894 },
    { PseudoVMFGT_VF32_M8, 895 },
    { PseudoVMFGT_VF32_MF2, 896 },
    { PseudoVMFGT_VF64_M1, 897 },
    { PseudoVMFGT_VF64_M2, 898 },
    { PseudoVMFGT_VF64_M4, 899 },
    { PseudoVMFGT_VF64_M8, 900 },
    { PseudoVMFLE_VF16_M1, 901 },
    { PseudoVMFLE_VF16_M2, 902 },
    { PseudoVMFLE_VF16_M4, 903 },
    { PseudoVMFLE_VF16_M8, 904 },
    { PseudoVMFLE_VF16_MF2, 905 },
    { PseudoVMFLE_VF16_MF4, 906 },
    { PseudoVMFLE_VF32_M1, 907 },
    { PseudoVMFLE_VF32_M2, 908 },
    { PseudoVMFLE_VF32_M4, 909 },
    { PseudoVMFLE_VF32_M8, 910 },
    { PseudoVMFLE_VF32_MF2, 911 },
    { PseudoVMFLE_VF64_M1, 912 },
    { PseudoVMFLE_VF64_M2, 913 },
    { PseudoVMFLE_VF64_M4, 914 },
    { PseudoVMFLE_VF64_M8, 915 },
    { PseudoVMFLE_VV_M1, 916 },
    { PseudoVMFLE_VV_M2, 917 },
    { PseudoVMFLE_VV_M4, 918 },
    { PseudoVMFLE_VV_M8, 919 },
    { PseudoVMFLE_VV_MF2, 920 },
    { PseudoVMFLE_VV_MF4, 921 },
    { PseudoVMFLT_VF16_M1, 922 },
    { PseudoVMFLT_VF16_M2, 923 },
    { PseudoVMFLT_VF16_M4, 924 },
    { PseudoVMFLT_VF16_M8, 925 },
    { PseudoVMFLT_VF16_MF2, 926 },
    { PseudoVMFLT_VF16_MF4, 927 },
    { PseudoVMFLT_VF32_M1, 928 },
    { PseudoVMFLT_VF32_M2, 929 },
    { PseudoVMFLT_VF32_M4, 930 },
    { PseudoVMFLT_VF32_M8, 931 },
    { PseudoVMFLT_VF32_MF2, 932 },
    { PseudoVMFLT_VF64_M1, 933 },
    { PseudoVMFLT_VF64_M2, 934 },
    { PseudoVMFLT_VF64_M4, 935 },
    { PseudoVMFLT_VF64_M8, 936 },
    { PseudoVMFLT_VV_M1, 937 },
    { PseudoVMFLT_VV_M2, 938 },
    { PseudoVMFLT_VV_M4, 939 },
    { PseudoVMFLT_VV_M8, 940 },
    { PseudoVMFLT_VV_MF2, 941 },
    { PseudoVMFLT_VV_MF4, 942 },
    { PseudoVMFNE_VF16_M1, 943 },
    { PseudoVMFNE_VF16_M2, 944 },
    { PseudoVMFNE_VF16_M4, 945 },
    { PseudoVMFNE_VF16_M8, 946 },
    { PseudoVMFNE_VF16_MF2, 947 },
    { PseudoVMFNE_VF16_MF4, 948 },
    { PseudoVMFNE_VF32_M1, 949 },
    { PseudoVMFNE_VF32_M2, 950 },
    { PseudoVMFNE_VF32_M4, 951 },
    { PseudoVMFNE_VF32_M8, 952 },
    { PseudoVMFNE_VF32_MF2, 953 },
    { PseudoVMFNE_VF64_M1, 954 },
    { PseudoVMFNE_VF64_M2, 955 },
    { PseudoVMFNE_VF64_M4, 956 },
    { PseudoVMFNE_VF64_M8, 957 },
    { PseudoVMFNE_VV_M1, 958 },
    { PseudoVMFNE_VV_M2, 959 },
    { PseudoVMFNE_VV_M4, 960 },
    { PseudoVMFNE_VV_M8, 961 },
    { PseudoVMFNE_VV_MF2, 962 },
    { PseudoVMFNE_VV_MF4, 963 },
    { PseudoVMINU_VV_M1, 964 },
    { PseudoVMINU_VV_M2, 965 },
    { PseudoVMINU_VV_M4, 966 },
    { PseudoVMINU_VV_M8, 967 },
    { PseudoVMINU_VV_MF2, 968 },
    { PseudoVMINU_VV_MF4, 969 },
    { PseudoVMINU_VV_MF8, 970 },
    { PseudoVMINU_VX_M1, 971 },
    { PseudoVMINU_VX_M2, 972 },
    { PseudoVMINU_VX_M4, 973 },
    { PseudoVMINU_VX_M8, 974 },
    { PseudoVMINU_VX_MF2, 975 },
    { PseudoVMINU_VX_MF4, 976 },
    { PseudoVMINU_VX_MF8, 977 },
    { PseudoVMIN_VV_M1, 978 },
    { PseudoVMIN_VV_M2, 979 },
    { PseudoVMIN_VV_M4, 980 },
    { PseudoVMIN_VV_M8, 981 },
    { PseudoVMIN_VV_MF2, 982 },
    { PseudoVMIN_VV_MF4, 983 },
    { PseudoVMIN_VV_MF8, 984 },
    { PseudoVMIN_VX_M1, 985 },
    { PseudoVMIN_VX_M2, 986 },
    { PseudoVMIN_VX_M4, 987 },
    { PseudoVMIN_VX_M8, 988 },
    { PseudoVMIN_VX_MF2, 989 },
    { PseudoVMIN_VX_MF4, 990 },
    { PseudoVMIN_VX_MF8, 991 },
    { PseudoVMSEQ_VI_M1, 992 },
    { PseudoVMSEQ_VI_M2, 993 },
    { PseudoVMSEQ_VI_M4, 994 },
    { PseudoVMSEQ_VI_M8, 995 },
    { PseudoVMSEQ_VI_MF2, 996 },
    { PseudoVMSEQ_VI_MF4, 997 },
    { PseudoVMSEQ_VI_MF8, 998 },
    { PseudoVMSEQ_VV_M1, 999 },
    { PseudoVMSEQ_VV_M2, 1000 },
    { PseudoVMSEQ_VV_M4, 1001 },
    { PseudoVMSEQ_VV_M8, 1002 },
    { PseudoVMSEQ_VV_MF2, 1003 },
    { PseudoVMSEQ_VV_MF4, 1004 },
    { PseudoVMSEQ_VV_MF8, 1005 },
    { PseudoVMSEQ_VX_M1, 1006 },
    { PseudoVMSEQ_VX_M2, 1007 },
    { PseudoVMSEQ_VX_M4, 1008 },
    { PseudoVMSEQ_VX_M8, 1009 },
    { PseudoVMSEQ_VX_MF2, 1010 },
    { PseudoVMSEQ_VX_MF4, 1011 },
    { PseudoVMSEQ_VX_MF8, 1012 },
    { PseudoVMSGTU_VI_M1, 1013 },
    { PseudoVMSGTU_VI_M2, 1014 },
    { PseudoVMSGTU_VI_M4, 1015 },
    { PseudoVMSGTU_VI_M8, 1016 },
    { PseudoVMSGTU_VI_MF2, 1017 },
    { PseudoVMSGTU_VI_MF4, 1018 },
    { PseudoVMSGTU_VI_MF8, 1019 },
    { PseudoVMSGTU_VX_M1, 1020 },
    { PseudoVMSGTU_VX_M2, 1021 },
    { PseudoVMSGTU_VX_M4, 1022 },
    { PseudoVMSGTU_VX_M8, 1023 },
    { PseudoVMSGTU_VX_MF2, 1024 },
    { PseudoVMSGTU_VX_MF4, 1025 },
    { PseudoVMSGTU_VX_MF8, 1026 },
    { PseudoVMSGT_VI_M1, 1027 },
    { PseudoVMSGT_VI_M2, 1028 },
    { PseudoVMSGT_VI_M4, 1029 },
    { PseudoVMSGT_VI_M8, 1030 },
    { PseudoVMSGT_VI_MF2, 1031 },
    { PseudoVMSGT_VI_MF4, 1032 },
    { PseudoVMSGT_VI_MF8, 1033 },
    { PseudoVMSGT_VX_M1, 1034 },
    { PseudoVMSGT_VX_M2, 1035 },
    { PseudoVMSGT_VX_M4, 1036 },
    { PseudoVMSGT_VX_M8, 1037 },
    { PseudoVMSGT_VX_MF2, 1038 },
    { PseudoVMSGT_VX_MF4, 1039 },
    { PseudoVMSGT_VX_MF8, 1040 },
    { PseudoVMSLEU_VI_M1, 1041 },
    { PseudoVMSLEU_VI_M2, 1042 },
    { PseudoVMSLEU_VI_M4, 1043 },
    { PseudoVMSLEU_VI_M8, 1044 },
    { PseudoVMSLEU_VI_MF2, 1045 },
    { PseudoVMSLEU_VI_MF4, 1046 },
    { PseudoVMSLEU_VI_MF8, 1047 },
    { PseudoVMSLEU_VV_M1, 1048 },
    { PseudoVMSLEU_VV_M2, 1049 },
    { PseudoVMSLEU_VV_M4, 1050 },
    { PseudoVMSLEU_VV_M8, 1051 },
    { PseudoVMSLEU_VV_MF2, 1052 },
    { PseudoVMSLEU_VV_MF4, 1053 },
    { PseudoVMSLEU_VV_MF8, 1054 },
    { PseudoVMSLEU_VX_M1, 1055 },
    { PseudoVMSLEU_VX_M2, 1056 },
    { PseudoVMSLEU_VX_M4, 1057 },
    { PseudoVMSLEU_VX_M8, 1058 },
    { PseudoVMSLEU_VX_MF2, 1059 },
    { PseudoVMSLEU_VX_MF4, 1060 },
    { PseudoVMSLEU_VX_MF8, 1061 },
    { PseudoVMSLE_VI_M1, 1062 },
    { PseudoVMSLE_VI_M2, 1063 },
    { PseudoVMSLE_VI_M4, 1064 },
    { PseudoVMSLE_VI_M8, 1065 },
    { PseudoVMSLE_VI_MF2, 1066 },
    { PseudoVMSLE_VI_MF4, 1067 },
    { PseudoVMSLE_VI_MF8, 1068 },
    { PseudoVMSLE_VV_M1, 1069 },
    { PseudoVMSLE_VV_M2, 1070 },
    { PseudoVMSLE_VV_M4, 1071 },
    { PseudoVMSLE_VV_M8, 1072 },
    { PseudoVMSLE_VV_MF2, 1073 },
    { PseudoVMSLE_VV_MF4, 1074 },
    { PseudoVMSLE_VV_MF8, 1075 },
    { PseudoVMSLE_VX_M1, 1076 },
    { PseudoVMSLE_VX_M2, 1077 },
    { PseudoVMSLE_VX_M4, 1078 },
    { PseudoVMSLE_VX_M8, 1079 },
    { PseudoVMSLE_VX_MF2, 1080 },
    { PseudoVMSLE_VX_MF4, 1081 },
    { PseudoVMSLE_VX_MF8, 1082 },
    { PseudoVMSLTU_VV_M1, 1083 },
    { PseudoVMSLTU_VV_M2, 1084 },
    { PseudoVMSLTU_VV_M4, 1085 },
    { PseudoVMSLTU_VV_M8, 1086 },
    { PseudoVMSLTU_VV_MF2, 1087 },
    { PseudoVMSLTU_VV_MF4, 1088 },
    { PseudoVMSLTU_VV_MF8, 1089 },
    { PseudoVMSLTU_VX_M1, 1090 },
    { PseudoVMSLTU_VX_M2, 1091 },
    { PseudoVMSLTU_VX_M4, 1092 },
    { PseudoVMSLTU_VX_M8, 1093 },
    { PseudoVMSLTU_VX_MF2, 1094 },
    { PseudoVMSLTU_VX_MF4, 1095 },
    { PseudoVMSLTU_VX_MF8, 1096 },
    { PseudoVMSLT_VV_M1, 1097 },
    { PseudoVMSLT_VV_M2, 1098 },
    { PseudoVMSLT_VV_M4, 1099 },
    { PseudoVMSLT_VV_M8, 1100 },
    { PseudoVMSLT_VV_MF2, 1101 },
    { PseudoVMSLT_VV_MF4, 1102 },
    { PseudoVMSLT_VV_MF8, 1103 },
    { PseudoVMSLT_VX_M1, 1104 },
    { PseudoVMSLT_VX_M2, 1105 },
    { PseudoVMSLT_VX_M4, 1106 },
    { PseudoVMSLT_VX_M8, 1107 },
    { PseudoVMSLT_VX_MF2, 1108 },
    { PseudoVMSLT_VX_MF4, 1109 },
    { PseudoVMSLT_VX_MF8, 1110 },
    { PseudoVMSNE_VI_M1, 1111 },
    { PseudoVMSNE_VI_M2, 1112 },
    { PseudoVMSNE_VI_M4, 1113 },
    { PseudoVMSNE_VI_M8, 1114 },
    { PseudoVMSNE_VI_MF2, 1115 },
    { PseudoVMSNE_VI_MF4, 1116 },
    { PseudoVMSNE_VI_MF8, 1117 },
    { PseudoVMSNE_VV_M1, 1118 },
    { PseudoVMSNE_VV_M2, 1119 },
    { PseudoVMSNE_VV_M4, 1120 },
    { PseudoVMSNE_VV_M8, 1121 },
    { PseudoVMSNE_VV_MF2, 1122 },
    { PseudoVMSNE_VV_MF4, 1123 },
    { PseudoVMSNE_VV_MF8, 1124 },
    { PseudoVMSNE_VX_M1, 1125 },
    { PseudoVMSNE_VX_M2, 1126 },
    { PseudoVMSNE_VX_M4, 1127 },
    { PseudoVMSNE_VX_M8, 1128 },
    { PseudoVMSNE_VX_MF2, 1129 },
    { PseudoVMSNE_VX_MF4, 1130 },
    { PseudoVMSNE_VX_MF8, 1131 },
    { PseudoVMULHSU_VV_M1, 1132 },
    { PseudoVMULHSU_VV_M2, 1133 },
    { PseudoVMULHSU_VV_M4, 1134 },
    { PseudoVMULHSU_VV_M8, 1135 },
    { PseudoVMULHSU_VV_MF2, 1136 },
    { PseudoVMULHSU_VV_MF4, 1137 },
    { PseudoVMULHSU_VV_MF8, 1138 },
    { PseudoVMULHSU_VX_M1, 1139 },
    { PseudoVMULHSU_VX_M2, 1140 },
    { PseudoVMULHSU_VX_M4, 1141 },
    { PseudoVMULHSU_VX_M8, 1142 },
    { PseudoVMULHSU_VX_MF2, 1143 },
    { PseudoVMULHSU_VX_MF4, 1144 },
    { PseudoVMULHSU_VX_MF8, 1145 },
    { PseudoVMULHU_VV_M1, 1146 },
    { PseudoVMULHU_VV_M2, 1147 },
    { PseudoVMULHU_VV_M4, 1148 },
    { PseudoVMULHU_VV_M8, 1149 },
    { PseudoVMULHU_VV_MF2, 1150 },
    { PseudoVMULHU_VV_MF4, 1151 },
    { PseudoVMULHU_VV_MF8, 1152 },
    { PseudoVMULHU_VX_M1, 1153 },
    { PseudoVMULHU_VX_M2, 1154 },
    { PseudoVMULHU_VX_M4, 1155 },
    { PseudoVMULHU_VX_M8, 1156 },
    { PseudoVMULHU_VX_MF2, 1157 },
    { PseudoVMULHU_VX_MF4, 1158 },
    { PseudoVMULHU_VX_MF8, 1159 },
    { PseudoVMULH_VV_M1, 1160 },
    { PseudoVMULH_VV_M2, 1161 },
    { PseudoVMULH_VV_M4, 1162 },
    { PseudoVMULH_VV_M8, 1163 },
    { PseudoVMULH_VV_MF2, 1164 },
    { PseudoVMULH_VV_MF4, 1165 },
    { PseudoVMULH_VV_MF8, 1166 },
    { PseudoVMULH_VX_M1, 1167 },
    { PseudoVMULH_VX_M2, 1168 },
    { PseudoVMULH_VX_M4, 1169 },
    { PseudoVMULH_VX_M8, 1170 },
    { PseudoVMULH_VX_MF2, 1171 },
    { PseudoVMULH_VX_MF4, 1172 },
    { PseudoVMULH_VX_MF8, 1173 },
    { PseudoVMUL_VV_M1, 1174 },
    { PseudoVMUL_VV_M2, 1175 },
    { PseudoVMUL_VV_M4, 1176 },
    { PseudoVMUL_VV_M8, 1177 },
    { PseudoVMUL_VV_MF2, 1178 },
    { PseudoVMUL_VV_MF4, 1179 },
    { PseudoVMUL_VV_MF8, 1180 },
    { PseudoVMUL_VX_M1, 1181 },
    { PseudoVMUL_VX_M2, 1182 },
    { PseudoVMUL_VX_M4, 1183 },
    { PseudoVMUL_VX_M8, 1184 },
    { PseudoVMUL_VX_MF2, 1185 },
    { PseudoVMUL_VX_MF4, 1186 },
    { PseudoVMUL_VX_MF8, 1187 },
    { PseudoVNCLIPU_WI_M1, 1188 },
    { PseudoVNCLIPU_WI_M2, 1189 },
    { PseudoVNCLIPU_WI_M4, 1190 },
    { PseudoVNCLIPU_WI_MF2, 1191 },
    { PseudoVNCLIPU_WI_MF4, 1192 },
    { PseudoVNCLIPU_WI_MF8, 1193 },
    { PseudoVNCLIPU_WV_M1, 1194 },
    { PseudoVNCLIPU_WV_M2, 1195 },
    { PseudoVNCLIPU_WV_M4, 1196 },
    { PseudoVNCLIPU_WV_MF2, 1197 },
    { PseudoVNCLIPU_WV_MF4, 1198 },
    { PseudoVNCLIPU_WV_MF8, 1199 },
    { PseudoVNCLIPU_WX_M1, 1200 },
    { PseudoVNCLIPU_WX_M2, 1201 },
    { PseudoVNCLIPU_WX_M4, 1202 },
    { PseudoVNCLIPU_WX_MF2, 1203 },
    { PseudoVNCLIPU_WX_MF4, 1204 },
    { PseudoVNCLIPU_WX_MF8, 1205 },
    { PseudoVNCLIP_WI_M1, 1206 },
    { PseudoVNCLIP_WI_M2, 1207 },
    { PseudoVNCLIP_WI_M4, 1208 },
    { PseudoVNCLIP_WI_MF2, 1209 },
    { PseudoVNCLIP_WI_MF4, 1210 },
    { PseudoVNCLIP_WI_MF8, 1211 },
    { PseudoVNCLIP_WV_M1, 1212 },
    { PseudoVNCLIP_WV_M2, 1213 },
    { PseudoVNCLIP_WV_M4, 1214 },
    { PseudoVNCLIP_WV_MF2, 1215 },
    { PseudoVNCLIP_WV_MF4, 1216 },
    { PseudoVNCLIP_WV_MF8, 1217 },
    { PseudoVNCLIP_WX_M1, 1218 },
    { PseudoVNCLIP_WX_M2, 1219 },
    { PseudoVNCLIP_WX_M4, 1220 },
    { PseudoVNCLIP_WX_MF2, 1221 },
    { PseudoVNCLIP_WX_MF4, 1222 },
    { PseudoVNCLIP_WX_MF8, 1223 },
    { PseudoVNSRA_WI_M1, 1224 },
    { PseudoVNSRA_WI_M2, 1225 },
    { PseudoVNSRA_WI_M4, 1226 },
    { PseudoVNSRA_WI_MF2, 1227 },
    { PseudoVNSRA_WI_MF4, 1228 },
    { PseudoVNSRA_WI_MF8, 1229 },
    { PseudoVNSRA_WV_M1, 1230 },
    { PseudoVNSRA_WV_M2, 1231 },
    { PseudoVNSRA_WV_M4, 1232 },
    { PseudoVNSRA_WV_MF2, 1233 },
    { PseudoVNSRA_WV_MF4, 1234 },
    { PseudoVNSRA_WV_MF8, 1235 },
    { PseudoVNSRA_WX_M1, 1236 },
    { PseudoVNSRA_WX_M2, 1237 },
    { PseudoVNSRA_WX_M4, 1238 },
    { PseudoVNSRA_WX_MF2, 1239 },
    { PseudoVNSRA_WX_MF4, 1240 },
    { PseudoVNSRA_WX_MF8, 1241 },
    { PseudoVNSRL_WI_M1, 1242 },
    { PseudoVNSRL_WI_M2, 1243 },
    { PseudoVNSRL_WI_M4, 1244 },
    { PseudoVNSRL_WI_MF2, 1245 },
    { PseudoVNSRL_WI_MF4, 1246 },
    { PseudoVNSRL_WI_MF8, 1247 },
    { PseudoVNSRL_WV_M1, 1248 },
    { PseudoVNSRL_WV_M2, 1249 },
    { PseudoVNSRL_WV_M4, 1250 },
    { PseudoVNSRL_WV_MF2, 1251 },
    { PseudoVNSRL_WV_MF4, 1252 },
    { PseudoVNSRL_WV_MF8, 1253 },
    { PseudoVNSRL_WX_M1, 1254 },
    { PseudoVNSRL_WX_M2, 1255 },
    { PseudoVNSRL_WX_M4, 1256 },
    { PseudoVNSRL_WX_MF2, 1257 },
    { PseudoVNSRL_WX_MF4, 1258 },
    { PseudoVNSRL_WX_MF8, 1259 },
    { PseudoVOR_VI_M1, 1260 },
    { PseudoVOR_VI_M2, 1261 },
    { PseudoVOR_VI_M4, 1262 },
    { PseudoVOR_VI_M8, 1263 },
    { PseudoVOR_VI_MF2, 1264 },
    { PseudoVOR_VI_MF4, 1265 },
    { PseudoVOR_VI_MF8, 1266 },
    { PseudoVOR_VV_M1, 1267 },
    { PseudoVOR_VV_M2, 1268 },
    { PseudoVOR_VV_M4, 1269 },
    { PseudoVOR_VV_M8, 1270 },
    { PseudoVOR_VV_MF2, 1271 },
    { PseudoVOR_VV_MF4, 1272 },
    { PseudoVOR_VV_MF8, 1273 },
    { PseudoVOR_VX_M1, 1274 },
    { PseudoVOR_VX_M2, 1275 },
    { PseudoVOR_VX_M4, 1276 },
    { PseudoVOR_VX_M8, 1277 },
    { PseudoVOR_VX_MF2, 1278 },
    { PseudoVOR_VX_MF4, 1279 },
    { PseudoVOR_VX_MF8, 1280 },
    { PseudoVREMU_VV_M1, 1281 },
    { PseudoVREMU_VV_M2, 1282 },
    { PseudoVREMU_VV_M4, 1283 },
    { PseudoVREMU_VV_M8, 1284 },
    { PseudoVREMU_VV_MF2, 1285 },
    { PseudoVREMU_VV_MF4, 1286 },
    { PseudoVREMU_VV_MF8, 1287 },
    { PseudoVREMU_VX_M1, 1288 },
    { PseudoVREMU_VX_M2, 1289 },
    { PseudoVREMU_VX_M4, 1290 },
    { PseudoVREMU_VX_M8, 1291 },
    { PseudoVREMU_VX_MF2, 1292 },
    { PseudoVREMU_VX_MF4, 1293 },
    { PseudoVREMU_VX_MF8, 1294 },
    { PseudoVREM_VV_M1, 1295 },
    { PseudoVREM_VV_M2, 1296 },
    { PseudoVREM_VV_M4, 1297 },
    { PseudoVREM_VV_M8, 1298 },
    { PseudoVREM_VV_MF2, 1299 },
    { PseudoVREM_VV_MF4, 1300 },
    { PseudoVREM_VV_MF8, 1301 },
    { PseudoVREM_VX_M1, 1302 },
    { PseudoVREM_VX_M2, 1303 },
    { PseudoVREM_VX_M4, 1304 },
    { PseudoVREM_VX_M8, 1305 },
    { PseudoVREM_VX_MF2, 1306 },
    { PseudoVREM_VX_MF4, 1307 },
    { PseudoVREM_VX_MF8, 1308 },
    { PseudoVRGATHEREI16_VV_M1_M1, 1309 },
    { PseudoVRGATHEREI16_VV_M1_M2, 1310 },
    { PseudoVRGATHEREI16_VV_M1_MF2, 1311 },
    { PseudoVRGATHEREI16_VV_M1_MF4, 1312 },
    { PseudoVRGATHEREI16_VV_M2_M1, 1313 },
    { PseudoVRGATHEREI16_VV_M2_M2, 1314 },
    { PseudoVRGATHEREI16_VV_M2_M4, 1315 },
    { PseudoVRGATHEREI16_VV_M2_MF2, 1316 },
    { PseudoVRGATHEREI16_VV_M4_M1, 1317 },
    { PseudoVRGATHEREI16_VV_M4_M2, 1318 },
    { PseudoVRGATHEREI16_VV_M4_M4, 1319 },
    { PseudoVRGATHEREI16_VV_M4_M8, 1320 },
    { PseudoVRGATHEREI16_VV_M8_M2, 1321 },
    { PseudoVRGATHEREI16_VV_M8_M4, 1322 },
    { PseudoVRGATHEREI16_VV_M8_M8, 1323 },
    { PseudoVRGATHEREI16_VV_MF2_M1, 1324 },
    { PseudoVRGATHEREI16_VV_MF2_MF2, 1325 },
    { PseudoVRGATHEREI16_VV_MF2_MF4, 1326 },
    { PseudoVRGATHEREI16_VV_MF2_MF8, 1327 },
    { PseudoVRGATHEREI16_VV_MF4_MF2, 1328 },
    { PseudoVRGATHEREI16_VV_MF4_MF4, 1329 },
    { PseudoVRGATHEREI16_VV_MF4_MF8, 1330 },
    { PseudoVRGATHEREI16_VV_MF8_MF4, 1331 },
    { PseudoVRGATHEREI16_VV_MF8_MF8, 1332 },
    { PseudoVRGATHER_VI_M1, 1333 },
    { PseudoVRGATHER_VI_M2, 1334 },
    { PseudoVRGATHER_VI_M4, 1335 },
    { PseudoVRGATHER_VI_M8, 1336 },
    { PseudoVRGATHER_VI_MF2, 1337 },
    { PseudoVRGATHER_VI_MF4, 1338 },
    { PseudoVRGATHER_VI_MF8, 1339 },
    { PseudoVRGATHER_VV_M1, 1340 },
    { PseudoVRGATHER_VV_M2, 1341 },
    { PseudoVRGATHER_VV_M4, 1342 },
    { PseudoVRGATHER_VV_M8, 1343 },
    { PseudoVRGATHER_VV_MF2, 1344 },
    { PseudoVRGATHER_VV_MF4, 1345 },
    { PseudoVRGATHER_VV_MF8, 1346 },
    { PseudoVRGATHER_VX_M1, 1347 },
    { PseudoVRGATHER_VX_M2, 1348 },
    { PseudoVRGATHER_VX_M4, 1349 },
    { PseudoVRGATHER_VX_M8, 1350 },
    { PseudoVRGATHER_VX_MF2, 1351 },
    { PseudoVRGATHER_VX_MF4, 1352 },
    { PseudoVRGATHER_VX_MF8, 1353 },
    { PseudoVRSUB_VI_M1, 1354 },
    { PseudoVRSUB_VI_M2, 1355 },
    { PseudoVRSUB_VI_M4, 1356 },
    { PseudoVRSUB_VI_M8, 1357 },
    { PseudoVRSUB_VI_MF2, 1358 },
    { PseudoVRSUB_VI_MF4, 1359 },
    { PseudoVRSUB_VI_MF8, 1360 },
    { PseudoVRSUB_VX_M1, 1361 },
    { PseudoVRSUB_VX_M2, 1362 },
    { PseudoVRSUB_VX_M4, 1363 },
    { PseudoVRSUB_VX_M8, 1364 },
    { PseudoVRSUB_VX_MF2, 1365 },
    { PseudoVRSUB_VX_MF4, 1366 },
    { PseudoVRSUB_VX_MF8, 1367 },
    { PseudoVSADDU_VI_M1, 1368 },
    { PseudoVSADDU_VI_M2, 1369 },
    { PseudoVSADDU_VI_M4, 1370 },
    { PseudoVSADDU_VI_M8, 1371 },
    { PseudoVSADDU_VI_MF2, 1372 },
    { PseudoVSADDU_VI_MF4, 1373 },
    { PseudoVSADDU_VI_MF8, 1374 },
    { PseudoVSADDU_VV_M1, 1375 },
    { PseudoVSADDU_VV_M2, 1376 },
    { PseudoVSADDU_VV_M4, 1377 },
    { PseudoVSADDU_VV_M8, 1378 },
    { PseudoVSADDU_VV_MF2, 1379 },
    { PseudoVSADDU_VV_MF4, 1380 },
    { PseudoVSADDU_VV_MF8, 1381 },
    { PseudoVSADDU_VX_M1, 1382 },
    { PseudoVSADDU_VX_M2, 1383 },
    { PseudoVSADDU_VX_M4, 1384 },
    { PseudoVSADDU_VX_M8, 1385 },
    { PseudoVSADDU_VX_MF2, 1386 },
    { PseudoVSADDU_VX_MF4, 1387 },
    { PseudoVSADDU_VX_MF8, 1388 },
    { PseudoVSADD_VI_M1, 1389 },
    { PseudoVSADD_VI_M2, 1390 },
    { PseudoVSADD_VI_M4, 1391 },
    { PseudoVSADD_VI_M8, 1392 },
    { PseudoVSADD_VI_MF2, 1393 },
    { PseudoVSADD_VI_MF4, 1394 },
    { PseudoVSADD_VI_MF8, 1395 },
    { PseudoVSADD_VV_M1, 1396 },
    { PseudoVSADD_VV_M2, 1397 },
    { PseudoVSADD_VV_M4, 1398 },
    { PseudoVSADD_VV_M8, 1399 },
    { PseudoVSADD_VV_MF2, 1400 },
    { PseudoVSADD_VV_MF4, 1401 },
    { PseudoVSADD_VV_MF8, 1402 },
    { PseudoVSADD_VX_M1, 1403 },
    { PseudoVSADD_VX_M2, 1404 },
    { PseudoVSADD_VX_M4, 1405 },
    { PseudoVSADD_VX_M8, 1406 },
    { PseudoVSADD_VX_MF2, 1407 },
    { PseudoVSADD_VX_MF4, 1408 },
    { PseudoVSADD_VX_MF8, 1409 },
    { PseudoVSEXT_VF2_M1, 1410 },
    { PseudoVSEXT_VF2_M2, 1411 },
    { PseudoVSEXT_VF2_M4, 1412 },
    { PseudoVSEXT_VF2_M8, 1413 },
    { PseudoVSEXT_VF2_MF2, 1414 },
    { PseudoVSEXT_VF2_MF4, 1415 },
    { PseudoVSEXT_VF4_M1, 1416 },
    { PseudoVSEXT_VF4_M2, 1417 },
    { PseudoVSEXT_VF4_M4, 1418 },
    { PseudoVSEXT_VF4_M8, 1419 },
    { PseudoVSEXT_VF4_MF2, 1420 },
    { PseudoVSEXT_VF8_M1, 1421 },
    { PseudoVSEXT_VF8_M2, 1422 },
    { PseudoVSEXT_VF8_M4, 1423 },
    { PseudoVSEXT_VF8_M8, 1424 },
    { PseudoVSLIDE1DOWN_VX_M1, 1425 },
    { PseudoVSLIDE1DOWN_VX_M2, 1426 },
    { PseudoVSLIDE1DOWN_VX_M4, 1427 },
    { PseudoVSLIDE1DOWN_VX_M8, 1428 },
    { PseudoVSLIDE1DOWN_VX_MF2, 1429 },
    { PseudoVSLIDE1DOWN_VX_MF4, 1430 },
    { PseudoVSLIDE1DOWN_VX_MF8, 1431 },
    { PseudoVSLIDE1UP_VX_M1, 1432 },
    { PseudoVSLIDE1UP_VX_M2, 1433 },
    { PseudoVSLIDE1UP_VX_M4, 1434 },
    { PseudoVSLIDE1UP_VX_M8, 1435 },
    { PseudoVSLIDE1UP_VX_MF2, 1436 },
    { PseudoVSLIDE1UP_VX_MF4, 1437 },
    { PseudoVSLIDE1UP_VX_MF8, 1438 },
    { PseudoVSLL_VI_M1, 1439 },
    { PseudoVSLL_VI_M2, 1440 },
    { PseudoVSLL_VI_M4, 1441 },
    { PseudoVSLL_VI_M8, 1442 },
    { PseudoVSLL_VI_MF2, 1443 },
    { PseudoVSLL_VI_MF4, 1444 },
    { PseudoVSLL_VI_MF8, 1445 },
    { PseudoVSLL_VV_M1, 1446 },
    { PseudoVSLL_VV_M2, 1447 },
    { PseudoVSLL_VV_M4, 1448 },
    { PseudoVSLL_VV_M8, 1449 },
    { PseudoVSLL_VV_MF2, 1450 },
    { PseudoVSLL_VV_MF4, 1451 },
    { PseudoVSLL_VV_MF8, 1452 },
    { PseudoVSLL_VX_M1, 1453 },
    { PseudoVSLL_VX_M2, 1454 },
    { PseudoVSLL_VX_M4, 1455 },
    { PseudoVSLL_VX_M8, 1456 },
    { PseudoVSLL_VX_MF2, 1457 },
    { PseudoVSLL_VX_MF4, 1458 },
    { PseudoVSLL_VX_MF8, 1459 },
    { PseudoVSMUL_VV_M1, 1460 },
    { PseudoVSMUL_VV_M2, 1461 },
    { PseudoVSMUL_VV_M4, 1462 },
    { PseudoVSMUL_VV_M8, 1463 },
    { PseudoVSMUL_VV_MF2, 1464 },
    { PseudoVSMUL_VV_MF4, 1465 },
    { PseudoVSMUL_VV_MF8, 1466 },
    { PseudoVSMUL_VX_M1, 1467 },
    { PseudoVSMUL_VX_M2, 1468 },
    { PseudoVSMUL_VX_M4, 1469 },
    { PseudoVSMUL_VX_M8, 1470 },
    { PseudoVSMUL_VX_MF2, 1471 },
    { PseudoVSMUL_VX_MF4, 1472 },
    { PseudoVSMUL_VX_MF8, 1473 },
    { PseudoVSRA_VI_M1, 1474 },
    { PseudoVSRA_VI_M2, 1475 },
    { PseudoVSRA_VI_M4, 1476 },
    { PseudoVSRA_VI_M8, 1477 },
    { PseudoVSRA_VI_MF2, 1478 },
    { PseudoVSRA_VI_MF4, 1479 },
    { PseudoVSRA_VI_MF8, 1480 },
    { PseudoVSRA_VV_M1, 1481 },
    { PseudoVSRA_VV_M2, 1482 },
    { PseudoVSRA_VV_M4, 1483 },
    { PseudoVSRA_VV_M8, 1484 },
    { PseudoVSRA_VV_MF2, 1485 },
    { PseudoVSRA_VV_MF4, 1486 },
    { PseudoVSRA_VV_MF8, 1487 },
    { PseudoVSRA_VX_M1, 1488 },
    { PseudoVSRA_VX_M2, 1489 },
    { PseudoVSRA_VX_M4, 1490 },
    { PseudoVSRA_VX_M8, 1491 },
    { PseudoVSRA_VX_MF2, 1492 },
    { PseudoVSRA_VX_MF4, 1493 },
    { PseudoVSRA_VX_MF8, 1494 },
    { PseudoVSRL_VI_M1, 1495 },
    { PseudoVSRL_VI_M2, 1496 },
    { PseudoVSRL_VI_M4, 1497 },
    { PseudoVSRL_VI_M8, 1498 },
    { PseudoVSRL_VI_MF2, 1499 },
    { PseudoVSRL_VI_MF4, 1500 },
    { PseudoVSRL_VI_MF8, 1501 },
    { PseudoVSRL_VV_M1, 1502 },
    { PseudoVSRL_VV_M2, 1503 },
    { PseudoVSRL_VV_M4, 1504 },
    { PseudoVSRL_VV_M8, 1505 },
    { PseudoVSRL_VV_MF2, 1506 },
    { PseudoVSRL_VV_MF4, 1507 },
    { PseudoVSRL_VV_MF8, 1508 },
    { PseudoVSRL_VX_M1, 1509 },
    { PseudoVSRL_VX_M2, 1510 },
    { PseudoVSRL_VX_M4, 1511 },
    { PseudoVSRL_VX_M8, 1512 },
    { PseudoVSRL_VX_MF2, 1513 },
    { PseudoVSRL_VX_MF4, 1514 },
    { PseudoVSRL_VX_MF8, 1515 },
    { PseudoVSSRA_VI_M1, 1516 },
    { PseudoVSSRA_VI_M2, 1517 },
    { PseudoVSSRA_VI_M4, 1518 },
    { PseudoVSSRA_VI_M8, 1519 },
    { PseudoVSSRA_VI_MF2, 1520 },
    { PseudoVSSRA_VI_MF4, 1521 },
    { PseudoVSSRA_VI_MF8, 1522 },
    { PseudoVSSRA_VV_M1, 1523 },
    { PseudoVSSRA_VV_M2, 1524 },
    { PseudoVSSRA_VV_M4, 1525 },
    { PseudoVSSRA_VV_M8, 1526 },
    { PseudoVSSRA_VV_MF2, 1527 },
    { PseudoVSSRA_VV_MF4, 1528 },
    { PseudoVSSRA_VV_MF8, 1529 },
    { PseudoVSSRA_VX_M1, 1530 },
    { PseudoVSSRA_VX_M2, 1531 },
    { PseudoVSSRA_VX_M4, 1532 },
    { PseudoVSSRA_VX_M8, 1533 },
    { PseudoVSSRA_VX_MF2, 1534 },
    { PseudoVSSRA_VX_MF4, 1535 },
    { PseudoVSSRA_VX_MF8, 1536 },
    { PseudoVSSRL_VI_M1, 1537 },
    { PseudoVSSRL_VI_M2, 1538 },
    { PseudoVSSRL_VI_M4, 1539 },
    { PseudoVSSRL_VI_M8, 1540 },
    { PseudoVSSRL_VI_MF2, 1541 },
    { PseudoVSSRL_VI_MF4, 1542 },
    { PseudoVSSRL_VI_MF8, 1543 },
    { PseudoVSSRL_VV_M1, 1544 },
    { PseudoVSSRL_VV_M2, 1545 },
    { PseudoVSSRL_VV_M4, 1546 },
    { PseudoVSSRL_VV_M8, 1547 },
    { PseudoVSSRL_VV_MF2, 1548 },
    { PseudoVSSRL_VV_MF4, 1549 },
    { PseudoVSSRL_VV_MF8, 1550 },
    { PseudoVSSRL_VX_M1, 1551 },
    { PseudoVSSRL_VX_M2, 1552 },
    { PseudoVSSRL_VX_M4, 1553 },
    { PseudoVSSRL_VX_M8, 1554 },
    { PseudoVSSRL_VX_MF2, 1555 },
    { PseudoVSSRL_VX_MF4, 1556 },
    { PseudoVSSRL_VX_MF8, 1557 },
    { PseudoVSSUBU_VV_M1, 1558 },
    { PseudoVSSUBU_VV_M2, 1559 },
    { PseudoVSSUBU_VV_M4, 1560 },
    { PseudoVSSUBU_VV_M8, 1561 },
    { PseudoVSSUBU_VV_MF2, 1562 },
    { PseudoVSSUBU_VV_MF4, 1563 },
    { PseudoVSSUBU_VV_MF8, 1564 },
    { PseudoVSSUBU_VX_M1, 1565 },
    { PseudoVSSUBU_VX_M2, 1566 },
    { PseudoVSSUBU_VX_M4, 1567 },
    { PseudoVSSUBU_VX_M8, 1568 },
    { PseudoVSSUBU_VX_MF2, 1569 },
    { PseudoVSSUBU_VX_MF4, 1570 },
    { PseudoVSSUBU_VX_MF8, 1571 },
    { PseudoVSSUB_VV_M1, 1572 },
    { PseudoVSSUB_VV_M2, 1573 },
    { PseudoVSSUB_VV_M4, 1574 },
    { PseudoVSSUB_VV_M8, 1575 },
    { PseudoVSSUB_VV_MF2, 1576 },
    { PseudoVSSUB_VV_MF4, 1577 },
    { PseudoVSSUB_VV_MF8, 1578 },
    { PseudoVSSUB_VX_M1, 1579 },
    { PseudoVSSUB_VX_M2, 1580 },
    { PseudoVSSUB_VX_M4, 1581 },
    { PseudoVSSUB_VX_M8, 1582 },
    { PseudoVSSUB_VX_MF2, 1583 },
    { PseudoVSSUB_VX_MF4, 1584 },
    { PseudoVSSUB_VX_MF8, 1585 },
    { PseudoVSUB_VV_M1, 1586 },
    { PseudoVSUB_VV_M2, 1587 },
    { PseudoVSUB_VV_M4, 1588 },
    { PseudoVSUB_VV_M8, 1589 },
    { PseudoVSUB_VV_MF2, 1590 },
    { PseudoVSUB_VV_MF4, 1591 },
    { PseudoVSUB_VV_MF8, 1592 },
    { PseudoVSUB_VX_M1, 1593 },
    { PseudoVSUB_VX_M2, 1594 },
    { PseudoVSUB_VX_M4, 1595 },
    { PseudoVSUB_VX_M8, 1596 },
    { PseudoVSUB_VX_MF2, 1597 },
    { PseudoVSUB_VX_MF4, 1598 },
    { PseudoVSUB_VX_MF8, 1599 },
    { PseudoVWADDU_VV_M1, 1600 },
    { PseudoVWADDU_VV_M2, 1601 },
    { PseudoVWADDU_VV_M4, 1602 },
    { PseudoVWADDU_VV_MF2, 1603 },
    { PseudoVWADDU_VV_MF4, 1604 },
    { PseudoVWADDU_VV_MF8, 1605 },
    { PseudoVWADDU_VX_M1, 1606 },
    { PseudoVWADDU_VX_M2, 1607 },
    { PseudoVWADDU_VX_M4, 1608 },
    { PseudoVWADDU_VX_MF2, 1609 },
    { PseudoVWADDU_VX_MF4, 1610 },
    { PseudoVWADDU_VX_MF8, 1611 },
    { PseudoVWADDU_WV_M1, 1612 },
    { PseudoVWADDU_WV_M2, 1613 },
    { PseudoVWADDU_WV_M4, 1614 },
    { PseudoVWADDU_WV_MF2, 1615 },
    { PseudoVWADDU_WV_MF4, 1616 },
    { PseudoVWADDU_WV_MF8, 1617 },
    { PseudoVWADDU_WX_M1, 1618 },
    { PseudoVWADDU_WX_M2, 1619 },
    { PseudoVWADDU_WX_M4, 1620 },
    { PseudoVWADDU_WX_MF2, 1621 },
    { PseudoVWADDU_WX_MF4, 1622 },
    { PseudoVWADDU_WX_MF8, 1623 },
    { PseudoVWADD_VV_M1, 1624 },
    { PseudoVWADD_VV_M2, 1625 },
    { PseudoVWADD_VV_M4, 1626 },
    { PseudoVWADD_VV_MF2, 1627 },
    { PseudoVWADD_VV_MF4, 1628 },
    { PseudoVWADD_VV_MF8, 1629 },
    { PseudoVWADD_VX_M1, 1630 },
    { PseudoVWADD_VX_M2, 1631 },
    { PseudoVWADD_VX_M4, 1632 },
    { PseudoVWADD_VX_MF2, 1633 },
    { PseudoVWADD_VX_MF4, 1634 },
    { PseudoVWADD_VX_MF8, 1635 },
    { PseudoVWADD_WV_M1, 1636 },
    { PseudoVWADD_WV_M2, 1637 },
    { PseudoVWADD_WV_M4, 1638 },
    { PseudoVWADD_WV_MF2, 1639 },
    { PseudoVWADD_WV_MF4, 1640 },
    { PseudoVWADD_WV_MF8, 1641 },
    { PseudoVWADD_WX_M1, 1642 },
    { PseudoVWADD_WX_M2, 1643 },
    { PseudoVWADD_WX_M4, 1644 },
    { PseudoVWADD_WX_MF2, 1645 },
    { PseudoVWADD_WX_MF4, 1646 },
    { PseudoVWADD_WX_MF8, 1647 },
    { PseudoVWMULSU_VV_M1, 1648 },
    { PseudoVWMULSU_VV_M2, 1649 },
    { PseudoVWMULSU_VV_M4, 1650 },
    { PseudoVWMULSU_VV_MF2, 1651 },
    { PseudoVWMULSU_VV_MF4, 1652 },
    { PseudoVWMULSU_VV_MF8, 1653 },
    { PseudoVWMULSU_VX_M1, 1654 },
    { PseudoVWMULSU_VX_M2, 1655 },
    { PseudoVWMULSU_VX_M4, 1656 },
    { PseudoVWMULSU_VX_MF2, 1657 },
    { PseudoVWMULSU_VX_MF4, 1658 },
    { PseudoVWMULSU_VX_MF8, 1659 },
    { PseudoVWMULU_VV_M1, 1660 },
    { PseudoVWMULU_VV_M2, 1661 },
    { PseudoVWMULU_VV_M4, 1662 },
    { PseudoVWMULU_VV_MF2, 1663 },
    { PseudoVWMULU_VV_MF4, 1664 },
    { PseudoVWMULU_VV_MF8, 1665 },
    { PseudoVWMULU_VX_M1, 1666 },
    { PseudoVWMULU_VX_M2, 1667 },
    { PseudoVWMULU_VX_M4, 1668 },
    { PseudoVWMULU_VX_MF2, 1669 },
    { PseudoVWMULU_VX_MF4, 1670 },
    { PseudoVWMULU_VX_MF8, 1671 },
    { PseudoVWMUL_VV_M1, 1672 },
    { PseudoVWMUL_VV_M2, 1673 },
    { PseudoVWMUL_VV_M4, 1674 },
    { PseudoVWMUL_VV_MF2, 1675 },
    { PseudoVWMUL_VV_MF4, 1676 },
    { PseudoVWMUL_VV_MF8, 1677 },
    { PseudoVWMUL_VX_M1, 1678 },
    { PseudoVWMUL_VX_M2, 1679 },
    { PseudoVWMUL_VX_M4, 1680 },
    { PseudoVWMUL_VX_MF2, 1681 },
    { PseudoVWMUL_VX_MF4, 1682 },
    { PseudoVWMUL_VX_MF8, 1683 },
    { PseudoVWSUBU_VV_M1, 1684 },
    { PseudoVWSUBU_VV_M2, 1685 },
    { PseudoVWSUBU_VV_M4, 1686 },
    { PseudoVWSUBU_VV_MF2, 1687 },
    { PseudoVWSUBU_VV_MF4, 1688 },
    { PseudoVWSUBU_VV_MF8, 1689 },
    { PseudoVWSUBU_VX_M1, 1690 },
    { PseudoVWSUBU_VX_M2, 1691 },
    { PseudoVWSUBU_VX_M4, 1692 },
    { PseudoVWSUBU_VX_MF2, 1693 },
    { PseudoVWSUBU_VX_MF4, 1694 },
    { PseudoVWSUBU_VX_MF8, 1695 },
    { PseudoVWSUBU_WV_M1, 1696 },
    { PseudoVWSUBU_WV_M2, 1697 },
    { PseudoVWSUBU_WV_M4, 1698 },
    { PseudoVWSUBU_WV_MF2, 1699 },
    { PseudoVWSUBU_WV_MF4, 1700 },
    { PseudoVWSUBU_WV_MF8, 1701 },
    { PseudoVWSUBU_WX_M1, 1702 },
    { PseudoVWSUBU_WX_M2, 1703 },
    { PseudoVWSUBU_WX_M4, 1704 },
    { PseudoVWSUBU_WX_MF2, 1705 },
    { PseudoVWSUBU_WX_MF4, 1706 },
    { PseudoVWSUBU_WX_MF8, 1707 },
    { PseudoVWSUB_VV_M1, 1708 },
    { PseudoVWSUB_VV_M2, 1709 },
    { PseudoVWSUB_VV_M4, 1710 },
    { PseudoVWSUB_VV_MF2, 1711 },
    { PseudoVWSUB_VV_MF4, 1712 },
    { PseudoVWSUB_VV_MF8, 1713 },
    { PseudoVWSUB_VX_M1, 1714 },
    { PseudoVWSUB_VX_M2, 1715 },
    { PseudoVWSUB_VX_M4, 1716 },
    { PseudoVWSUB_VX_MF2, 1717 },
    { PseudoVWSUB_VX_MF4, 1718 },
    { PseudoVWSUB_VX_MF8, 1719 },
    { PseudoVWSUB_WV_M1, 1720 },
    { PseudoVWSUB_WV_M2, 1721 },
    { PseudoVWSUB_WV_M4, 1722 },
    { PseudoVWSUB_WV_MF2, 1723 },
    { PseudoVWSUB_WV_MF4, 1724 },
    { PseudoVWSUB_WV_MF8, 1725 },
    { PseudoVWSUB_WX_M1, 1726 },
    { PseudoVWSUB_WX_M2, 1727 },
    { PseudoVWSUB_WX_M4, 1728 },
    { PseudoVWSUB_WX_MF2, 1729 },
    { PseudoVWSUB_WX_MF4, 1730 },
    { PseudoVWSUB_WX_MF8, 1731 },
    { PseudoVXOR_VI_M1, 1732 },
    { PseudoVXOR_VI_M2, 1733 },
    { PseudoVXOR_VI_M4, 1734 },
    { PseudoVXOR_VI_M8, 1735 },
    { PseudoVXOR_VI_MF2, 1736 },
    { PseudoVXOR_VI_MF4, 1737 },
    { PseudoVXOR_VI_MF8, 1738 },
    { PseudoVXOR_VV_M1, 1739 },
    { PseudoVXOR_VV_M2, 1740 },
    { PseudoVXOR_VV_M4, 1741 },
    { PseudoVXOR_VV_M8, 1742 },
    { PseudoVXOR_VV_MF2, 1743 },
    { PseudoVXOR_VV_MF4, 1744 },
    { PseudoVXOR_VV_MF8, 1745 },
    { PseudoVXOR_VX_M1, 1746 },
    { PseudoVXOR_VX_M2, 1747 },
    { PseudoVXOR_VX_M4, 1748 },
    { PseudoVXOR_VX_M8, 1749 },
    { PseudoVXOR_VX_MF2, 1750 },
    { PseudoVXOR_VX_MF4, 1751 },
    { PseudoVXOR_VX_MF8, 1752 },
    { PseudoVZEXT_VF2_M1, 1753 },
    { PseudoVZEXT_VF2_M2, 1754 },
    { PseudoVZEXT_VF2_M4, 1755 },
    { PseudoVZEXT_VF2_M8, 1756 },
    { PseudoVZEXT_VF2_MF2, 1757 },
    { PseudoVZEXT_VF2_MF4, 1758 },
    { PseudoVZEXT_VF4_M1, 1759 },
    { PseudoVZEXT_VF4_M2, 1760 },
    { PseudoVZEXT_VF4_M4, 1761 },
    { PseudoVZEXT_VF4_M8, 1762 },
    { PseudoVZEXT_VF4_MF2, 1763 },
    { PseudoVZEXT_VF8_M1, 1764 },
    { PseudoVZEXT_VF8_M2, 1765 },
    { PseudoVZEXT_VF8_M4, 1766 },
    { PseudoVZEXT_VF8_M8, 1767 },
  };

  struct KeyType {
    unsigned UnmaskedPseudo;
  };
  KeyType Key = {UnmaskedPseudo};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.UnmaskedPseudo < RHS.UnmaskedPseudo)
        return true;
      if (LHS.UnmaskedPseudo > RHS.UnmaskedPseudo)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.UnmaskedPseudo != Idx->UnmaskedPseudo)
    return nullptr;
  return &RISCVMaskedPseudosTable[Idx->_index];
}
#endif

#ifdef GET_RISCVOpcodesList_DECL
const RISCVOpcode *lookupRISCVOpcodeByValue(uint8_t Value);
const RISCVOpcode *lookupRISCVOpcodeByName(StringRef Name);
#endif

#ifdef GET_RISCVOpcodesList_IMPL
constexpr RISCVOpcode RISCVOpcodesList[] = {
  { "LOAD", 0x3 }, // 0
  { "LOAD_FP", 0x7 }, // 1
  { "CUSTOM_0", 0xB }, // 2
  { "MISC_MEM", 0xF }, // 3
  { "OP_IMM", 0x13 }, // 4
  { "AUIPC", 0x17 }, // 5
  { "OP_IMM_32", 0x1B }, // 6
  { "STORE", 0x23 }, // 7
  { "STORE_FP", 0x27 }, // 8
  { "CUSTOM_1", 0x2B }, // 9
  { "AMO", 0x2F }, // 10
  { "OP", 0x33 }, // 11
  { "LUI", 0x37 }, // 12
  { "OP_32", 0x3B }, // 13
  { "MADD", 0x43 }, // 14
  { "MSUB", 0x47 }, // 15
  { "NMSUB", 0x4B }, // 16
  { "NMADD", 0x4F }, // 17
  { "OP_FP", 0x53 }, // 18
  { "OP_V", 0x57 }, // 19
  { "CUSTOM_2", 0x5B }, // 20
  { "BRANCH", 0x63 }, // 21
  { "JALR", 0x67 }, // 22
  { "JAL", 0x6F }, // 23
  { "SYSTEM", 0x73 }, // 24
  { "CUSTOM_3", 0x7B }, // 25
 };

const RISCVOpcode *lookupRISCVOpcodeByValue(uint8_t Value) {
  struct KeyType {
    uint8_t Value;
  };
  KeyType Key = {Value};
  auto Table = ArrayRef(RISCVOpcodesList);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const RISCVOpcode &LHS, const KeyType &RHS) {
      if (LHS.Value < RHS.Value)
        return true;
      if (LHS.Value > RHS.Value)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Value != Idx->Value)
    return nullptr;
  return &*Idx;
}

const RISCVOpcode *lookupRISCVOpcodeByName(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "AMO", 10 },
    { "AUIPC", 5 },
    { "BRANCH", 21 },
    { "CUSTOM_0", 2 },
    { "CUSTOM_1", 9 },
    { "CUSTOM_2", 20 },
    { "CUSTOM_3", 25 },
    { "JAL", 23 },
    { "JALR", 22 },
    { "LOAD", 0 },
    { "LOAD_FP", 1 },
    { "LUI", 12 },
    { "MADD", 14 },
    { "MISC_MEM", 3 },
    { "MSUB", 15 },
    { "NMADD", 17 },
    { "NMSUB", 16 },
    { "OP", 11 },
    { "OP_32", 13 },
    { "OP_FP", 18 },
    { "OP_IMM", 4 },
    { "OP_IMM_32", 6 },
    { "OP_V", 19 },
    { "STORE", 7 },
    { "STORE_FP", 8 },
    { "SYSTEM", 24 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;
  return &RISCVOpcodesList[Idx->_index];
}
#endif

#ifdef GET_RISCVVIntrinsicsTable_DECL
const RISCVVIntrinsicInfo *getRISCVVIntrinsicInfo(unsigned IntrinsicID);
#endif

#ifdef GET_RISCVVIntrinsicsTable_IMPL
constexpr RISCVVIntrinsicInfo RISCVVIntrinsicsTable[] = {
  { Intrinsic::riscv_th_vmaqa, 0x1, 0x3 }, // 0
  { Intrinsic::riscv_th_vmaqa_mask, 0x1, 0x4 }, // 1
  { Intrinsic::riscv_th_vmaqasu, 0x1, 0x3 }, // 2
  { Intrinsic::riscv_th_vmaqasu_mask, 0x1, 0x4 }, // 3
  { Intrinsic::riscv_th_vmaqau, 0x1, 0x3 }, // 4
  { Intrinsic::riscv_th_vmaqau_mask, 0x1, 0x4 }, // 5
  { Intrinsic::riscv_th_vmaqaus, 0x1, 0x3 }, // 6
  { Intrinsic::riscv_th_vmaqaus_mask, 0x1, 0x4 }, // 7
  { Intrinsic::riscv_vaadd, 0x2, 0x3 }, // 8
  { Intrinsic::riscv_vaadd_mask, 0x2, 0x4 }, // 9
  { Intrinsic::riscv_vaaddu, 0x2, 0x3 }, // 10
  { Intrinsic::riscv_vaaddu_mask, 0x2, 0x4 }, // 11
  { Intrinsic::riscv_vadc, 0x2, 0x4 }, // 12
  { Intrinsic::riscv_vadd, 0x2, 0x3 }, // 13
  { Intrinsic::riscv_vadd_mask, 0x2, 0x4 }, // 14
  { Intrinsic::riscv_vand, 0x2, 0x3 }, // 15
  { Intrinsic::riscv_vand_mask, 0x2, 0x4 }, // 16
  { Intrinsic::riscv_vasub, 0x2, 0x3 }, // 17
  { Intrinsic::riscv_vasub_mask, 0x2, 0x4 }, // 18
  { Intrinsic::riscv_vasubu, 0x2, 0x3 }, // 19
  { Intrinsic::riscv_vasubu_mask, 0x2, 0x4 }, // 20
  { Intrinsic::riscv_vcompress, 0xF, 0x3 }, // 21
  { Intrinsic::riscv_vcpop, 0xF, 0x1 }, // 22
  { Intrinsic::riscv_vcpop_mask, 0xF, 0x2 }, // 23
  { Intrinsic::riscv_vdiv, 0x2, 0x3 }, // 24
  { Intrinsic::riscv_vdiv_mask, 0x2, 0x4 }, // 25
  { Intrinsic::riscv_vdivu, 0x2, 0x3 }, // 26
  { Intrinsic::riscv_vdivu_mask, 0x2, 0x4 }, // 27
  { Intrinsic::riscv_vfadd, 0x2, 0x3 }, // 28
  { Intrinsic::riscv_vfadd_mask, 0x2, 0x4 }, // 29
  { Intrinsic::riscv_vfclass, 0xF, 0x1 }, // 30
  { Intrinsic::riscv_vfclass_mask, 0xF, 0x3 }, // 31
  { Intrinsic::riscv_vfcvt_f_x_v, 0xF, 0x2 }, // 32
  { Intrinsic::riscv_vfcvt_f_x_v_mask, 0xF, 0x3 }, // 33
  { Intrinsic::riscv_vfcvt_f_xu_v, 0xF, 0x2 }, // 34
  { Intrinsic::riscv_vfcvt_f_xu_v_mask, 0xF, 0x3 }, // 35
  { Intrinsic::riscv_vfcvt_rtz_x_f_v, 0xF, 0x2 }, // 36
  { Intrinsic::riscv_vfcvt_rtz_x_f_v_mask, 0xF, 0x3 }, // 37
  { Intrinsic::riscv_vfcvt_rtz_xu_f_v, 0xF, 0x2 }, // 38
  { Intrinsic::riscv_vfcvt_rtz_xu_f_v_mask, 0xF, 0x3 }, // 39
  { Intrinsic::riscv_vfcvt_x_f_v, 0xF, 0x2 }, // 40
  { Intrinsic::riscv_vfcvt_x_f_v_mask, 0xF, 0x3 }, // 41
  { Intrinsic::riscv_vfcvt_xu_f_v, 0xF, 0x2 }, // 42
  { Intrinsic::riscv_vfcvt_xu_f_v_mask, 0xF, 0x3 }, // 43
  { Intrinsic::riscv_vfdiv, 0x2, 0x3 }, // 44
  { Intrinsic::riscv_vfdiv_mask, 0x2, 0x4 }, // 45
  { Intrinsic::riscv_vfirst, 0xF, 0x1 }, // 46
  { Intrinsic::riscv_vfirst_mask, 0xF, 0x2 }, // 47
  { Intrinsic::riscv_vfmacc, 0x1, 0x3 }, // 48
  { Intrinsic::riscv_vfmacc_mask, 0x1, 0x4 }, // 49
  { Intrinsic::riscv_vfmadd, 0x1, 0x3 }, // 50
  { Intrinsic::riscv_vfmadd_mask, 0x1, 0x4 }, // 51
  { Intrinsic::riscv_vfmax, 0x2, 0x3 }, // 52
  { Intrinsic::riscv_vfmax_mask, 0x2, 0x4 }, // 53
  { Intrinsic::riscv_vfmerge, 0x2, 0x4 }, // 54
  { Intrinsic::riscv_vfmin, 0x2, 0x3 }, // 55
  { Intrinsic::riscv_vfmin_mask, 0x2, 0x4 }, // 56
  { Intrinsic::riscv_vfmsac, 0x1, 0x3 }, // 57
  { Intrinsic::riscv_vfmsac_mask, 0x1, 0x4 }, // 58
  { Intrinsic::riscv_vfmsub, 0x1, 0x3 }, // 59
  { Intrinsic::riscv_vfmsub_mask, 0x1, 0x4 }, // 60
  { Intrinsic::riscv_vfmul, 0x2, 0x3 }, // 61
  { Intrinsic::riscv_vfmul_mask, 0x2, 0x4 }, // 62
  { Intrinsic::riscv_vfmv_f_s, 0xF, 0x1F }, // 63
  { Intrinsic::riscv_vfmv_s_f, 0xF, 0x2 }, // 64
  { Intrinsic::riscv_vfmv_v_f, 0xF, 0x2 }, // 65
  { Intrinsic::riscv_vfncvt_f_f_w, 0xF, 0x2 }, // 66
  { Intrinsic::riscv_vfncvt_f_f_w_mask, 0xF, 0x3 }, // 67
  { Intrinsic::riscv_vfncvt_f_x_w, 0xF, 0x2 }, // 68
  { Intrinsic::riscv_vfncvt_f_x_w_mask, 0xF, 0x3 }, // 69
  { Intrinsic::riscv_vfncvt_f_xu_w, 0xF, 0x2 }, // 70
  { Intrinsic::riscv_vfncvt_f_xu_w_mask, 0xF, 0x3 }, // 71
  { Intrinsic::riscv_vfncvt_rod_f_f_w, 0xF, 0x2 }, // 72
  { Intrinsic::riscv_vfncvt_rod_f_f_w_mask, 0xF, 0x3 }, // 73
  { Intrinsic::riscv_vfncvt_rtz_x_f_w, 0xF, 0x2 }, // 74
  { Intrinsic::riscv_vfncvt_rtz_x_f_w_mask, 0xF, 0x3 }, // 75
  { Intrinsic::riscv_vfncvt_rtz_xu_f_w, 0xF, 0x2 }, // 76
  { Intrinsic::riscv_vfncvt_rtz_xu_f_w_mask, 0xF, 0x3 }, // 77
  { Intrinsic::riscv_vfncvt_x_f_w, 0xF, 0x2 }, // 78
  { Intrinsic::riscv_vfncvt_x_f_w_mask, 0xF, 0x3 }, // 79
  { Intrinsic::riscv_vfncvt_xu_f_w, 0xF, 0x2 }, // 80
  { Intrinsic::riscv_vfncvt_xu_f_w_mask, 0xF, 0x3 }, // 81
  { Intrinsic::riscv_vfnmacc, 0x1, 0x3 }, // 82
  { Intrinsic::riscv_vfnmacc_mask, 0x1, 0x4 }, // 83
  { Intrinsic::riscv_vfnmadd, 0x1, 0x3 }, // 84
  { Intrinsic::riscv_vfnmadd_mask, 0x1, 0x4 }, // 85
  { Intrinsic::riscv_vfnmsac, 0x1, 0x3 }, // 86
  { Intrinsic::riscv_vfnmsac_mask, 0x1, 0x4 }, // 87
  { Intrinsic::riscv_vfnmsub, 0x1, 0x3 }, // 88
  { Intrinsic::riscv_vfnmsub_mask, 0x1, 0x4 }, // 89
  { Intrinsic::riscv_vfrdiv, 0x2, 0x3 }, // 90
  { Intrinsic::riscv_vfrdiv_mask, 0x2, 0x4 }, // 91
  { Intrinsic::riscv_vfrec7, 0xF, 0x2 }, // 92
  { Intrinsic::riscv_vfrec7_mask, 0xF, 0x3 }, // 93
  { Intrinsic::riscv_vfredmax, 0xF, 0x3 }, // 94
  { Intrinsic::riscv_vfredmax_mask, 0xF, 0x4 }, // 95
  { Intrinsic::riscv_vfredmin, 0xF, 0x3 }, // 96
  { Intrinsic::riscv_vfredmin_mask, 0xF, 0x4 }, // 97
  { Intrinsic::riscv_vfredosum, 0xF, 0x3 }, // 98
  { Intrinsic::riscv_vfredosum_mask, 0xF, 0x4 }, // 99
  { Intrinsic::riscv_vfredusum, 0xF, 0x3 }, // 100
  { Intrinsic::riscv_vfredusum_mask, 0xF, 0x4 }, // 101
  { Intrinsic::riscv_vfrsqrt7, 0xF, 0x2 }, // 102
  { Intrinsic::riscv_vfrsqrt7_mask, 0xF, 0x3 }, // 103
  { Intrinsic::riscv_vfrsub, 0x2, 0x3 }, // 104
  { Intrinsic::riscv_vfrsub_mask, 0x2, 0x4 }, // 105
  { Intrinsic::riscv_vfsgnj, 0x2, 0x3 }, // 106
  { Intrinsic::riscv_vfsgnj_mask, 0x2, 0x4 }, // 107
  { Intrinsic::riscv_vfsgnjn, 0x2, 0x3 }, // 108
  { Intrinsic::riscv_vfsgnjn_mask, 0x2, 0x4 }, // 109
  { Intrinsic::riscv_vfsgnjx, 0x2, 0x3 }, // 110
  { Intrinsic::riscv_vfsgnjx_mask, 0x2, 0x4 }, // 111
  { Intrinsic::riscv_vfslide1down, 0x2, 0x3 }, // 112
  { Intrinsic::riscv_vfslide1down_mask, 0x2, 0x4 }, // 113
  { Intrinsic::riscv_vfslide1up, 0x2, 0x3 }, // 114
  { Intrinsic::riscv_vfslide1up_mask, 0x2, 0x4 }, // 115
  { Intrinsic::riscv_vfsqrt, 0xF, 0x2 }, // 116
  { Intrinsic::riscv_vfsqrt_mask, 0xF, 0x3 }, // 117
  { Intrinsic::riscv_vfsub, 0x2, 0x3 }, // 118
  { Intrinsic::riscv_vfsub_mask, 0x2, 0x4 }, // 119
  { Intrinsic::riscv_vfwadd, 0x2, 0x3 }, // 120
  { Intrinsic::riscv_vfwadd_mask, 0x2, 0x4 }, // 121
  { Intrinsic::riscv_vfwadd_w, 0x2, 0x3 }, // 122
  { Intrinsic::riscv_vfwadd_w_mask, 0x2, 0x4 }, // 123
  { Intrinsic::riscv_vfwcvt_f_f_v, 0xF, 0x2 }, // 124
  { Intrinsic::riscv_vfwcvt_f_f_v_mask, 0xF, 0x3 }, // 125
  { Intrinsic::riscv_vfwcvt_f_x_v, 0xF, 0x2 }, // 126
  { Intrinsic::riscv_vfwcvt_f_x_v_mask, 0xF, 0x3 }, // 127
  { Intrinsic::riscv_vfwcvt_f_xu_v, 0xF, 0x2 }, // 128
  { Intrinsic::riscv_vfwcvt_f_xu_v_mask, 0xF, 0x3 }, // 129
  { Intrinsic::riscv_vfwcvt_rtz_x_f_v, 0xF, 0x2 }, // 130
  { Intrinsic::riscv_vfwcvt_rtz_x_f_v_mask, 0xF, 0x3 }, // 131
  { Intrinsic::riscv_vfwcvt_rtz_xu_f_v, 0xF, 0x2 }, // 132
  { Intrinsic::riscv_vfwcvt_rtz_xu_f_v_mask, 0xF, 0x3 }, // 133
  { Intrinsic::riscv_vfwcvt_x_f_v, 0xF, 0x2 }, // 134
  { Intrinsic::riscv_vfwcvt_x_f_v_mask, 0xF, 0x3 }, // 135
  { Intrinsic::riscv_vfwcvt_xu_f_v, 0xF, 0x2 }, // 136
  { Intrinsic::riscv_vfwcvt_xu_f_v_mask, 0xF, 0x3 }, // 137
  { Intrinsic::riscv_vfwmacc, 0x1, 0x3 }, // 138
  { Intrinsic::riscv_vfwmacc_mask, 0x1, 0x4 }, // 139
  { Intrinsic::riscv_vfwmsac, 0x1, 0x3 }, // 140
  { Intrinsic::riscv_vfwmsac_mask, 0x1, 0x4 }, // 141
  { Intrinsic::riscv_vfwmul, 0x2, 0x3 }, // 142
  { Intrinsic::riscv_vfwmul_mask, 0x2, 0x4 }, // 143
  { Intrinsic::riscv_vfwnmacc, 0x1, 0x3 }, // 144
  { Intrinsic::riscv_vfwnmacc_mask, 0x1, 0x4 }, // 145
  { Intrinsic::riscv_vfwnmsac, 0x1, 0x3 }, // 146
  { Intrinsic::riscv_vfwnmsac_mask, 0x1, 0x4 }, // 147
  { Intrinsic::riscv_vfwredosum, 0xF, 0x3 }, // 148
  { Intrinsic::riscv_vfwredosum_mask, 0xF, 0x4 }, // 149
  { Intrinsic::riscv_vfwredusum, 0xF, 0x3 }, // 150
  { Intrinsic::riscv_vfwredusum_mask, 0xF, 0x4 }, // 151
  { Intrinsic::riscv_vfwsub, 0x2, 0x3 }, // 152
  { Intrinsic::riscv_vfwsub_mask, 0x2, 0x4 }, // 153
  { Intrinsic::riscv_vfwsub_w, 0x2, 0x3 }, // 154
  { Intrinsic::riscv_vfwsub_w_mask, 0x2, 0x4 }, // 155
  { Intrinsic::riscv_vid, 0xF, 0x1 }, // 156
  { Intrinsic::riscv_vid_mask, 0xF, 0x2 }, // 157
  { Intrinsic::riscv_viota, 0xF, 0x2 }, // 158
  { Intrinsic::riscv_viota_mask, 0xF, 0x3 }, // 159
  { Intrinsic::riscv_vle, 0xF, 0x2 }, // 160
  { Intrinsic::riscv_vle_mask, 0xF, 0x3 }, // 161
  { Intrinsic::riscv_vleff, 0xF, 0x2 }, // 162
  { Intrinsic::riscv_vleff_mask, 0xF, 0x3 }, // 163
  { Intrinsic::riscv_vlm, 0xF, 0x1 }, // 164
  { Intrinsic::riscv_vloxei, 0xF, 0x3 }, // 165
  { Intrinsic::riscv_vloxei_mask, 0xF, 0x4 }, // 166
  { Intrinsic::riscv_vloxseg2, 0xF, 0x4 }, // 167
  { Intrinsic::riscv_vloxseg2_mask, 0xF, 0x5 }, // 168
  { Intrinsic::riscv_vloxseg3, 0xF, 0x5 }, // 169
  { Intrinsic::riscv_vloxseg3_mask, 0xF, 0x6 }, // 170
  { Intrinsic::riscv_vloxseg4, 0xF, 0x6 }, // 171
  { Intrinsic::riscv_vloxseg4_mask, 0xF, 0x7 }, // 172
  { Intrinsic::riscv_vloxseg5, 0xF, 0x7 }, // 173
  { Intrinsic::riscv_vloxseg5_mask, 0xF, 0x8 }, // 174
  { Intrinsic::riscv_vloxseg6, 0xF, 0x8 }, // 175
  { Intrinsic::riscv_vloxseg6_mask, 0xF, 0x9 }, // 176
  { Intrinsic::riscv_vloxseg7, 0xF, 0x9 }, // 177
  { Intrinsic::riscv_vloxseg7_mask, 0xF, 0xA }, // 178
  { Intrinsic::riscv_vloxseg8, 0xF, 0xA }, // 179
  { Intrinsic::riscv_vloxseg8_mask, 0xF, 0xB }, // 180
  { Intrinsic::riscv_vlse, 0xF, 0x3 }, // 181
  { Intrinsic::riscv_vlse_mask, 0xF, 0x4 }, // 182
  { Intrinsic::riscv_vlseg2, 0xF, 0x3 }, // 183
  { Intrinsic::riscv_vlseg2_mask, 0xF, 0x4 }, // 184
  { Intrinsic::riscv_vlseg2ff, 0xF, 0x3 }, // 185
  { Intrinsic::riscv_vlseg2ff_mask, 0xF, 0x4 }, // 186
  { Intrinsic::riscv_vlseg3, 0xF, 0x4 }, // 187
  { Intrinsic::riscv_vlseg3_mask, 0xF, 0x5 }, // 188
  { Intrinsic::riscv_vlseg3ff, 0xF, 0x4 }, // 189
  { Intrinsic::riscv_vlseg3ff_mask, 0xF, 0x5 }, // 190
  { Intrinsic::riscv_vlseg4, 0xF, 0x5 }, // 191
  { Intrinsic::riscv_vlseg4_mask, 0xF, 0x6 }, // 192
  { Intrinsic::riscv_vlseg4ff, 0xF, 0x5 }, // 193
  { Intrinsic::riscv_vlseg4ff_mask, 0xF, 0x6 }, // 194
  { Intrinsic::riscv_vlseg5, 0xF, 0x6 }, // 195
  { Intrinsic::riscv_vlseg5_mask, 0xF, 0x7 }, // 196
  { Intrinsic::riscv_vlseg5ff, 0xF, 0x6 }, // 197
  { Intrinsic::riscv_vlseg5ff_mask, 0xF, 0x7 }, // 198
  { Intrinsic::riscv_vlseg6, 0xF, 0x7 }, // 199
  { Intrinsic::riscv_vlseg6_mask, 0xF, 0x8 }, // 200
  { Intrinsic::riscv_vlseg6ff, 0xF, 0x7 }, // 201
  { Intrinsic::riscv_vlseg6ff_mask, 0xF, 0x8 }, // 202
  { Intrinsic::riscv_vlseg7, 0xF, 0x8 }, // 203
  { Intrinsic::riscv_vlseg7_mask, 0xF, 0x9 }, // 204
  { Intrinsic::riscv_vlseg7ff, 0xF, 0x8 }, // 205
  { Intrinsic::riscv_vlseg7ff_mask, 0xF, 0x9 }, // 206
  { Intrinsic::riscv_vlseg8, 0xF, 0x9 }, // 207
  { Intrinsic::riscv_vlseg8_mask, 0xF, 0xA }, // 208
  { Intrinsic::riscv_vlseg8ff, 0xF, 0x9 }, // 209
  { Intrinsic::riscv_vlseg8ff_mask, 0xF, 0xA }, // 210
  { Intrinsic::riscv_vlsseg2, 0xF, 0x4 }, // 211
  { Intrinsic::riscv_vlsseg2_mask, 0xF, 0x5 }, // 212
  { Intrinsic::riscv_vlsseg3, 0xF, 0x5 }, // 213
  { Intrinsic::riscv_vlsseg3_mask, 0xF, 0x6 }, // 214
  { Intrinsic::riscv_vlsseg4, 0xF, 0x6 }, // 215
  { Intrinsic::riscv_vlsseg4_mask, 0xF, 0x7 }, // 216
  { Intrinsic::riscv_vlsseg5, 0xF, 0x7 }, // 217
  { Intrinsic::riscv_vlsseg5_mask, 0xF, 0x8 }, // 218
  { Intrinsic::riscv_vlsseg6, 0xF, 0x8 }, // 219
  { Intrinsic::riscv_vlsseg6_mask, 0xF, 0x9 }, // 220
  { Intrinsic::riscv_vlsseg7, 0xF, 0x9 }, // 221
  { Intrinsic::riscv_vlsseg7_mask, 0xF, 0xA }, // 222
  { Intrinsic::riscv_vlsseg8, 0xF, 0xA }, // 223
  { Intrinsic::riscv_vlsseg8_mask, 0xF, 0xB }, // 224
  { Intrinsic::riscv_vluxei, 0xF, 0x3 }, // 225
  { Intrinsic::riscv_vluxei_mask, 0xF, 0x4 }, // 226
  { Intrinsic::riscv_vluxseg2, 0xF, 0x4 }, // 227
  { Intrinsic::riscv_vluxseg2_mask, 0xF, 0x5 }, // 228
  { Intrinsic::riscv_vluxseg3, 0xF, 0x5 }, // 229
  { Intrinsic::riscv_vluxseg3_mask, 0xF, 0x6 }, // 230
  { Intrinsic::riscv_vluxseg4, 0xF, 0x6 }, // 231
  { Intrinsic::riscv_vluxseg4_mask, 0xF, 0x7 }, // 232
  { Intrinsic::riscv_vluxseg5, 0xF, 0x7 }, // 233
  { Intrinsic::riscv_vluxseg5_mask, 0xF, 0x8 }, // 234
  { Intrinsic::riscv_vluxseg6, 0xF, 0x8 }, // 235
  { Intrinsic::riscv_vluxseg6_mask, 0xF, 0x9 }, // 236
  { Intrinsic::riscv_vluxseg7, 0xF, 0x9 }, // 237
  { Intrinsic::riscv_vluxseg7_mask, 0xF, 0xA }, // 238
  { Intrinsic::riscv_vluxseg8, 0xF, 0xA }, // 239
  { Intrinsic::riscv_vluxseg8_mask, 0xF, 0xB }, // 240
  { Intrinsic::riscv_vmacc, 0x1, 0x3 }, // 241
  { Intrinsic::riscv_vmacc_mask, 0x1, 0x4 }, // 242
  { Intrinsic::riscv_vmadc, 0x1, 0x2 }, // 243
  { Intrinsic::riscv_vmadc_carry_in, 0x1, 0x3 }, // 244
  { Intrinsic::riscv_vmadd, 0x1, 0x3 }, // 245
  { Intrinsic::riscv_vmadd_mask, 0x1, 0x4 }, // 246
  { Intrinsic::riscv_vmand, 0xF, 0x2 }, // 247
  { Intrinsic::riscv_vmandn, 0xF, 0x2 }, // 248
  { Intrinsic::riscv_vmax, 0x2, 0x3 }, // 249
  { Intrinsic::riscv_vmax_mask, 0x2, 0x4 }, // 250
  { Intrinsic::riscv_vmaxu, 0x2, 0x3 }, // 251
  { Intrinsic::riscv_vmaxu_mask, 0x2, 0x4 }, // 252
  { Intrinsic::riscv_vmclr, 0xF, 0x1 }, // 253
  { Intrinsic::riscv_vmerge, 0x2, 0x4 }, // 254
  { Intrinsic::riscv_vmfeq, 0x1, 0x2 }, // 255
  { Intrinsic::riscv_vmfeq_mask, 0x2, 0x4 }, // 256
  { Intrinsic::riscv_vmfge, 0x1, 0x2 }, // 257
  { Intrinsic::riscv_vmfge_mask, 0x2, 0x4 }, // 258
  { Intrinsic::riscv_vmfgt, 0x1, 0x2 }, // 259
  { Intrinsic::riscv_vmfgt_mask, 0x2, 0x4 }, // 260
  { Intrinsic::riscv_vmfle, 0x1, 0x2 }, // 261
  { Intrinsic::riscv_vmfle_mask, 0x2, 0x4 }, // 262
  { Intrinsic::riscv_vmflt, 0x1, 0x2 }, // 263
  { Intrinsic::riscv_vmflt_mask, 0x2, 0x4 }, // 264
  { Intrinsic::riscv_vmfne, 0x1, 0x2 }, // 265
  { Intrinsic::riscv_vmfne_mask, 0x2, 0x4 }, // 266
  { Intrinsic::riscv_vmin, 0x2, 0x3 }, // 267
  { Intrinsic::riscv_vmin_mask, 0x2, 0x4 }, // 268
  { Intrinsic::riscv_vminu, 0x2, 0x3 }, // 269
  { Intrinsic::riscv_vminu_mask, 0x2, 0x4 }, // 270
  { Intrinsic::riscv_vmnand, 0xF, 0x2 }, // 271
  { Intrinsic::riscv_vmnor, 0xF, 0x2 }, // 272
  { Intrinsic::riscv_vmor, 0xF, 0x2 }, // 273
  { Intrinsic::riscv_vmorn, 0xF, 0x2 }, // 274
  { Intrinsic::riscv_vmsbc, 0x1, 0x2 }, // 275
  { Intrinsic::riscv_vmsbc_borrow_in, 0x1, 0x3 }, // 276
  { Intrinsic::riscv_vmsbf, 0xF, 0x1 }, // 277
  { Intrinsic::riscv_vmsbf_mask, 0xF, 0x3 }, // 278
  { Intrinsic::riscv_vmseq, 0x1, 0x2 }, // 279
  { Intrinsic::riscv_vmseq_mask, 0x2, 0x4 }, // 280
  { Intrinsic::riscv_vmset, 0xF, 0x1 }, // 281
  { Intrinsic::riscv_vmsge, 0x1, 0x2 }, // 282
  { Intrinsic::riscv_vmsge_mask, 0x2, 0x4 }, // 283
  { Intrinsic::riscv_vmsgeu, 0x1, 0x2 }, // 284
  { Intrinsic::riscv_vmsgeu_mask, 0x2, 0x4 }, // 285
  { Intrinsic::riscv_vmsgt, 0x1, 0x2 }, // 286
  { Intrinsic::riscv_vmsgt_mask, 0x2, 0x4 }, // 287
  { Intrinsic::riscv_vmsgtu, 0x1, 0x2 }, // 288
  { Intrinsic::riscv_vmsgtu_mask, 0x2, 0x4 }, // 289
  { Intrinsic::riscv_vmsif, 0xF, 0x1 }, // 290
  { Intrinsic::riscv_vmsif_mask, 0xF, 0x3 }, // 291
  { Intrinsic::riscv_vmsle, 0x1, 0x2 }, // 292
  { Intrinsic::riscv_vmsle_mask, 0x2, 0x4 }, // 293
  { Intrinsic::riscv_vmsleu, 0x1, 0x2 }, // 294
  { Intrinsic::riscv_vmsleu_mask, 0x2, 0x4 }, // 295
  { Intrinsic::riscv_vmslt, 0x1, 0x2 }, // 296
  { Intrinsic::riscv_vmslt_mask, 0x2, 0x4 }, // 297
  { Intrinsic::riscv_vmsltu, 0x1, 0x2 }, // 298
  { Intrinsic::riscv_vmsltu_mask, 0x2, 0x4 }, // 299
  { Intrinsic::riscv_vmsne, 0x1, 0x2 }, // 300
  { Intrinsic::riscv_vmsne_mask, 0x2, 0x4 }, // 301
  { Intrinsic::riscv_vmsof, 0xF, 0x1 }, // 302
  { Intrinsic::riscv_vmsof_mask, 0xF, 0x3 }, // 303
  { Intrinsic::riscv_vmul, 0x2, 0x3 }, // 304
  { Intrinsic::riscv_vmul_mask, 0x2, 0x4 }, // 305
  { Intrinsic::riscv_vmulh, 0x2, 0x3 }, // 306
  { Intrinsic::riscv_vmulh_mask, 0x2, 0x4 }, // 307
  { Intrinsic::riscv_vmulhsu, 0x2, 0x3 }, // 308
  { Intrinsic::riscv_vmulhsu_mask, 0x2, 0x4 }, // 309
  { Intrinsic::riscv_vmulhu, 0x2, 0x3 }, // 310
  { Intrinsic::riscv_vmulhu_mask, 0x2, 0x4 }, // 311
  { Intrinsic::riscv_vmv_s_x, 0xF, 0x2 }, // 312
  { Intrinsic::riscv_vmv_v_v, 0xF, 0x2 }, // 313
  { Intrinsic::riscv_vmv_v_x, 0xF, 0x2 }, // 314
  { Intrinsic::riscv_vmv_x_s, 0xF, 0x1F }, // 315
  { Intrinsic::riscv_vmxnor, 0xF, 0x2 }, // 316
  { Intrinsic::riscv_vmxor, 0xF, 0x2 }, // 317
  { Intrinsic::riscv_vnclip, 0xF, 0x3 }, // 318
  { Intrinsic::riscv_vnclip_mask, 0xF, 0x4 }, // 319
  { Intrinsic::riscv_vnclipu, 0xF, 0x3 }, // 320
  { Intrinsic::riscv_vnclipu_mask, 0xF, 0x4 }, // 321
  { Intrinsic::riscv_vnmsac, 0x1, 0x3 }, // 322
  { Intrinsic::riscv_vnmsac_mask, 0x1, 0x4 }, // 323
  { Intrinsic::riscv_vnmsub, 0x1, 0x3 }, // 324
  { Intrinsic::riscv_vnmsub_mask, 0x1, 0x4 }, // 325
  { Intrinsic::riscv_vnsra, 0xF, 0x3 }, // 326
  { Intrinsic::riscv_vnsra_mask, 0xF, 0x4 }, // 327
  { Intrinsic::riscv_vnsrl, 0xF, 0x3 }, // 328
  { Intrinsic::riscv_vnsrl_mask, 0xF, 0x4 }, // 329
  { Intrinsic::riscv_vor, 0x2, 0x3 }, // 330
  { Intrinsic::riscv_vor_mask, 0x2, 0x4 }, // 331
  { Intrinsic::riscv_vredand, 0xF, 0x3 }, // 332
  { Intrinsic::riscv_vredand_mask, 0xF, 0x4 }, // 333
  { Intrinsic::riscv_vredmax, 0xF, 0x3 }, // 334
  { Intrinsic::riscv_vredmax_mask, 0xF, 0x4 }, // 335
  { Intrinsic::riscv_vredmaxu, 0xF, 0x3 }, // 336
  { Intrinsic::riscv_vredmaxu_mask, 0xF, 0x4 }, // 337
  { Intrinsic::riscv_vredmin, 0xF, 0x3 }, // 338
  { Intrinsic::riscv_vredmin_mask, 0xF, 0x4 }, // 339
  { Intrinsic::riscv_vredminu, 0xF, 0x3 }, // 340
  { Intrinsic::riscv_vredminu_mask, 0xF, 0x4 }, // 341
  { Intrinsic::riscv_vredor, 0xF, 0x3 }, // 342
  { Intrinsic::riscv_vredor_mask, 0xF, 0x4 }, // 343
  { Intrinsic::riscv_vredsum, 0xF, 0x3 }, // 344
  { Intrinsic::riscv_vredsum_mask, 0xF, 0x4 }, // 345
  { Intrinsic::riscv_vredxor, 0xF, 0x3 }, // 346
  { Intrinsic::riscv_vredxor_mask, 0xF, 0x4 }, // 347
  { Intrinsic::riscv_vrem, 0x2, 0x3 }, // 348
  { Intrinsic::riscv_vrem_mask, 0x2, 0x4 }, // 349
  { Intrinsic::riscv_vremu, 0x2, 0x3 }, // 350
  { Intrinsic::riscv_vremu_mask, 0x2, 0x4 }, // 351
  { Intrinsic::riscv_vrgather_vv, 0xF, 0x3 }, // 352
  { Intrinsic::riscv_vrgather_vv_mask, 0xF, 0x4 }, // 353
  { Intrinsic::riscv_vrgather_vx, 0xF, 0x3 }, // 354
  { Intrinsic::riscv_vrgather_vx_mask, 0xF, 0x4 }, // 355
  { Intrinsic::riscv_vrgatherei16_vv, 0xF, 0x3 }, // 356
  { Intrinsic::riscv_vrgatherei16_vv_mask, 0xF, 0x4 }, // 357
  { Intrinsic::riscv_vrsub, 0x2, 0x3 }, // 358
  { Intrinsic::riscv_vrsub_mask, 0x2, 0x4 }, // 359
  { Intrinsic::riscv_vsadd, 0x2, 0x3 }, // 360
  { Intrinsic::riscv_vsadd_mask, 0x2, 0x4 }, // 361
  { Intrinsic::riscv_vsaddu, 0x2, 0x3 }, // 362
  { Intrinsic::riscv_vsaddu_mask, 0x2, 0x4 }, // 363
  { Intrinsic::riscv_vsbc, 0x2, 0x4 }, // 364
  { Intrinsic::riscv_vse, 0xF, 0x2 }, // 365
  { Intrinsic::riscv_vse_mask, 0xF, 0x3 }, // 366
  { Intrinsic::riscv_vsext, 0xF, 0x2 }, // 367
  { Intrinsic::riscv_vsext_mask, 0xF, 0x3 }, // 368
  { Intrinsic::riscv_vslide1down, 0x2, 0x3 }, // 369
  { Intrinsic::riscv_vslide1down_mask, 0x2, 0x4 }, // 370
  { Intrinsic::riscv_vslide1up, 0x2, 0x3 }, // 371
  { Intrinsic::riscv_vslide1up_mask, 0x2, 0x4 }, // 372
  { Intrinsic::riscv_vslidedown, 0xF, 0x3 }, // 373
  { Intrinsic::riscv_vslidedown_mask, 0xF, 0x4 }, // 374
  { Intrinsic::riscv_vslideup, 0xF, 0x3 }, // 375
  { Intrinsic::riscv_vslideup_mask, 0xF, 0x4 }, // 376
  { Intrinsic::riscv_vsll, 0xF, 0x3 }, // 377
  { Intrinsic::riscv_vsll_mask, 0xF, 0x4 }, // 378
  { Intrinsic::riscv_vsm, 0xF, 0x2 }, // 379
  { Intrinsic::riscv_vsmul, 0x2, 0x3 }, // 380
  { Intrinsic::riscv_vsmul_mask, 0x2, 0x4 }, // 381
  { Intrinsic::riscv_vsoxei, 0xF, 0x3 }, // 382
  { Intrinsic::riscv_vsoxei_mask, 0xF, 0x4 }, // 383
  { Intrinsic::riscv_vsoxseg2, 0xF, 0x4 }, // 384
  { Intrinsic::riscv_vsoxseg2_mask, 0xF, 0x5 }, // 385
  { Intrinsic::riscv_vsoxseg3, 0xF, 0x5 }, // 386
  { Intrinsic::riscv_vsoxseg3_mask, 0xF, 0x6 }, // 387
  { Intrinsic::riscv_vsoxseg4, 0xF, 0x6 }, // 388
  { Intrinsic::riscv_vsoxseg4_mask, 0xF, 0x7 }, // 389
  { Intrinsic::riscv_vsoxseg5, 0xF, 0x7 }, // 390
  { Intrinsic::riscv_vsoxseg5_mask, 0xF, 0x8 }, // 391
  { Intrinsic::riscv_vsoxseg6, 0xF, 0x8 }, // 392
  { Intrinsic::riscv_vsoxseg6_mask, 0xF, 0x9 }, // 393
  { Intrinsic::riscv_vsoxseg7, 0xF, 0x9 }, // 394
  { Intrinsic::riscv_vsoxseg7_mask, 0xF, 0xA }, // 395
  { Intrinsic::riscv_vsoxseg8, 0xF, 0xA }, // 396
  { Intrinsic::riscv_vsoxseg8_mask, 0xF, 0xB }, // 397
  { Intrinsic::riscv_vsra, 0xF, 0x3 }, // 398
  { Intrinsic::riscv_vsra_mask, 0xF, 0x4 }, // 399
  { Intrinsic::riscv_vsrl, 0xF, 0x3 }, // 400
  { Intrinsic::riscv_vsrl_mask, 0xF, 0x4 }, // 401
  { Intrinsic::riscv_vsse, 0xF, 0x3 }, // 402
  { Intrinsic::riscv_vsse_mask, 0xF, 0x4 }, // 403
  { Intrinsic::riscv_vsseg2, 0xF, 0x3 }, // 404
  { Intrinsic::riscv_vsseg2_mask, 0xF, 0x4 }, // 405
  { Intrinsic::riscv_vsseg3, 0xF, 0x4 }, // 406
  { Intrinsic::riscv_vsseg3_mask, 0xF, 0x5 }, // 407
  { Intrinsic::riscv_vsseg4, 0xF, 0x5 }, // 408
  { Intrinsic::riscv_vsseg4_mask, 0xF, 0x6 }, // 409
  { Intrinsic::riscv_vsseg5, 0xF, 0x6 }, // 410
  { Intrinsic::riscv_vsseg5_mask, 0xF, 0x7 }, // 411
  { Intrinsic::riscv_vsseg6, 0xF, 0x7 }, // 412
  { Intrinsic::riscv_vsseg6_mask, 0xF, 0x8 }, // 413
  { Intrinsic::riscv_vsseg7, 0xF, 0x8 }, // 414
  { Intrinsic::riscv_vsseg7_mask, 0xF, 0x9 }, // 415
  { Intrinsic::riscv_vsseg8, 0xF, 0x9 }, // 416
  { Intrinsic::riscv_vsseg8_mask, 0xF, 0xA }, // 417
  { Intrinsic::riscv_vssra, 0xF, 0x3 }, // 418
  { Intrinsic::riscv_vssra_mask, 0xF, 0x4 }, // 419
  { Intrinsic::riscv_vssrl, 0xF, 0x3 }, // 420
  { Intrinsic::riscv_vssrl_mask, 0xF, 0x4 }, // 421
  { Intrinsic::riscv_vssseg2, 0xF, 0x4 }, // 422
  { Intrinsic::riscv_vssseg2_mask, 0xF, 0x5 }, // 423
  { Intrinsic::riscv_vssseg3, 0xF, 0x5 }, // 424
  { Intrinsic::riscv_vssseg3_mask, 0xF, 0x6 }, // 425
  { Intrinsic::riscv_vssseg4, 0xF, 0x6 }, // 426
  { Intrinsic::riscv_vssseg4_mask, 0xF, 0x7 }, // 427
  { Intrinsic::riscv_vssseg5, 0xF, 0x7 }, // 428
  { Intrinsic::riscv_vssseg5_mask, 0xF, 0x8 }, // 429
  { Intrinsic::riscv_vssseg6, 0xF, 0x8 }, // 430
  { Intrinsic::riscv_vssseg6_mask, 0xF, 0x9 }, // 431
  { Intrinsic::riscv_vssseg7, 0xF, 0x9 }, // 432
  { Intrinsic::riscv_vssseg7_mask, 0xF, 0xA }, // 433
  { Intrinsic::riscv_vssseg8, 0xF, 0xA }, // 434
  { Intrinsic::riscv_vssseg8_mask, 0xF, 0xB }, // 435
  { Intrinsic::riscv_vssub, 0x2, 0x3 }, // 436
  { Intrinsic::riscv_vssub_mask, 0x2, 0x4 }, // 437
  { Intrinsic::riscv_vssubu, 0x2, 0x3 }, // 438
  { Intrinsic::riscv_vssubu_mask, 0x2, 0x4 }, // 439
  { Intrinsic::riscv_vsub, 0x2, 0x3 }, // 440
  { Intrinsic::riscv_vsub_mask, 0x2, 0x4 }, // 441
  { Intrinsic::riscv_vsuxei, 0xF, 0x3 }, // 442
  { Intrinsic::riscv_vsuxei_mask, 0xF, 0x4 }, // 443
  { Intrinsic::riscv_vsuxseg2, 0xF, 0x4 }, // 444
  { Intrinsic::riscv_vsuxseg2_mask, 0xF, 0x5 }, // 445
  { Intrinsic::riscv_vsuxseg3, 0xF, 0x5 }, // 446
  { Intrinsic::riscv_vsuxseg3_mask, 0xF, 0x6 }, // 447
  { Intrinsic::riscv_vsuxseg4, 0xF, 0x6 }, // 448
  { Intrinsic::riscv_vsuxseg4_mask, 0xF, 0x7 }, // 449
  { Intrinsic::riscv_vsuxseg5, 0xF, 0x7 }, // 450
  { Intrinsic::riscv_vsuxseg5_mask, 0xF, 0x8 }, // 451
  { Intrinsic::riscv_vsuxseg6, 0xF, 0x8 }, // 452
  { Intrinsic::riscv_vsuxseg6_mask, 0xF, 0x9 }, // 453
  { Intrinsic::riscv_vsuxseg7, 0xF, 0x9 }, // 454
  { Intrinsic::riscv_vsuxseg7_mask, 0xF, 0xA }, // 455
  { Intrinsic::riscv_vsuxseg8, 0xF, 0xA }, // 456
  { Intrinsic::riscv_vsuxseg8_mask, 0xF, 0xB }, // 457
  { Intrinsic::riscv_vwadd, 0x2, 0x3 }, // 458
  { Intrinsic::riscv_vwadd_mask, 0x2, 0x4 }, // 459
  { Intrinsic::riscv_vwadd_w, 0x2, 0x3 }, // 460
  { Intrinsic::riscv_vwadd_w_mask, 0x2, 0x4 }, // 461
  { Intrinsic::riscv_vwaddu, 0x2, 0x3 }, // 462
  { Intrinsic::riscv_vwaddu_mask, 0x2, 0x4 }, // 463
  { Intrinsic::riscv_vwaddu_w, 0x2, 0x3 }, // 464
  { Intrinsic::riscv_vwaddu_w_mask, 0x2, 0x4 }, // 465
  { Intrinsic::riscv_vwmacc, 0x1, 0x3 }, // 466
  { Intrinsic::riscv_vwmacc_mask, 0x1, 0x4 }, // 467
  { Intrinsic::riscv_vwmaccsu, 0x1, 0x3 }, // 468
  { Intrinsic::riscv_vwmaccsu_mask, 0x1, 0x4 }, // 469
  { Intrinsic::riscv_vwmaccu, 0x1, 0x3 }, // 470
  { Intrinsic::riscv_vwmaccu_mask, 0x1, 0x4 }, // 471
  { Intrinsic::riscv_vwmaccus, 0x1, 0x3 }, // 472
  { Intrinsic::riscv_vwmaccus_mask, 0x1, 0x4 }, // 473
  { Intrinsic::riscv_vwmul, 0x2, 0x3 }, // 474
  { Intrinsic::riscv_vwmul_mask, 0x2, 0x4 }, // 475
  { Intrinsic::riscv_vwmulsu, 0x2, 0x3 }, // 476
  { Intrinsic::riscv_vwmulsu_mask, 0x2, 0x4 }, // 477
  { Intrinsic::riscv_vwmulu, 0x2, 0x3 }, // 478
  { Intrinsic::riscv_vwmulu_mask, 0x2, 0x4 }, // 479
  { Intrinsic::riscv_vwredsum, 0xF, 0x3 }, // 480
  { Intrinsic::riscv_vwredsum_mask, 0xF, 0x4 }, // 481
  { Intrinsic::riscv_vwredsumu, 0xF, 0x3 }, // 482
  { Intrinsic::riscv_vwredsumu_mask, 0xF, 0x4 }, // 483
  { Intrinsic::riscv_vwsub, 0x2, 0x3 }, // 484
  { Intrinsic::riscv_vwsub_mask, 0x2, 0x4 }, // 485
  { Intrinsic::riscv_vwsub_w, 0x2, 0x3 }, // 486
  { Intrinsic::riscv_vwsub_w_mask, 0x2, 0x4 }, // 487
  { Intrinsic::riscv_vwsubu, 0x2, 0x3 }, // 488
  { Intrinsic::riscv_vwsubu_mask, 0x2, 0x4 }, // 489
  { Intrinsic::riscv_vwsubu_w, 0x2, 0x3 }, // 490
  { Intrinsic::riscv_vwsubu_w_mask, 0x2, 0x4 }, // 491
  { Intrinsic::riscv_vxor, 0x2, 0x3 }, // 492
  { Intrinsic::riscv_vxor_mask, 0x2, 0x4 }, // 493
  { Intrinsic::riscv_vzext, 0xF, 0x2 }, // 494
  { Intrinsic::riscv_vzext_mask, 0xF, 0x3 }, // 495
 };

const RISCVVIntrinsicInfo *getRISCVVIntrinsicInfo(unsigned IntrinsicID) {
  struct KeyType {
    unsigned IntrinsicID;
  };
  KeyType Key = {IntrinsicID};
  auto Table = ArrayRef(RISCVVIntrinsicsTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const RISCVVIntrinsicInfo &LHS, const KeyType &RHS) {
      if (LHS.IntrinsicID < RHS.IntrinsicID)
        return true;
      if (LHS.IntrinsicID > RHS.IntrinsicID)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.IntrinsicID != Idx->IntrinsicID)
    return nullptr;
  return &*Idx;
}
#endif

#ifdef GET_RISCVVInversePseudosTable_DECL
const PseudoInfo *getBaseInfo(unsigned BaseInstr, uint8_t VLMul);
#endif

#ifdef GET_RISCVVInversePseudosTable_IMPL
constexpr PseudoInfo RISCVVInversePseudosTable[] = {
  { PseudoTHVdotVMAQASU_VV_M1, THVdotVMAQASU_VV, 0x0 }, // 0
  { PseudoTHVdotVMAQASU_VV_M1_MASK, THVdotVMAQASU_VV, 0x0 }, // 1
  { PseudoTHVdotVMAQASU_VV_M2, THVdotVMAQASU_VV, 0x1 }, // 2
  { PseudoTHVdotVMAQASU_VV_M2_MASK, THVdotVMAQASU_VV, 0x1 }, // 3
  { PseudoTHVdotVMAQASU_VV_M4, THVdotVMAQASU_VV, 0x2 }, // 4
  { PseudoTHVdotVMAQASU_VV_M4_MASK, THVdotVMAQASU_VV, 0x2 }, // 5
  { PseudoTHVdotVMAQASU_VV_M8, THVdotVMAQASU_VV, 0x3 }, // 6
  { PseudoTHVdotVMAQASU_VV_M8_MASK, THVdotVMAQASU_VV, 0x3 }, // 7
  { PseudoTHVdotVMAQASU_VV_MF2, THVdotVMAQASU_VV, 0x7 }, // 8
  { PseudoTHVdotVMAQASU_VV_MF2_MASK, THVdotVMAQASU_VV, 0x7 }, // 9
  { PseudoTHVdotVMAQASU_VX_M1, THVdotVMAQASU_VX, 0x0 }, // 10
  { PseudoTHVdotVMAQASU_VX_M1_MASK, THVdotVMAQASU_VX, 0x0 }, // 11
  { PseudoTHVdotVMAQASU_VX_M2, THVdotVMAQASU_VX, 0x1 }, // 12
  { PseudoTHVdotVMAQASU_VX_M2_MASK, THVdotVMAQASU_VX, 0x1 }, // 13
  { PseudoTHVdotVMAQASU_VX_M4, THVdotVMAQASU_VX, 0x2 }, // 14
  { PseudoTHVdotVMAQASU_VX_M4_MASK, THVdotVMAQASU_VX, 0x2 }, // 15
  { PseudoTHVdotVMAQASU_VX_M8, THVdotVMAQASU_VX, 0x3 }, // 16
  { PseudoTHVdotVMAQASU_VX_M8_MASK, THVdotVMAQASU_VX, 0x3 }, // 17
  { PseudoTHVdotVMAQASU_VX_MF2, THVdotVMAQASU_VX, 0x7 }, // 18
  { PseudoTHVdotVMAQASU_VX_MF2_MASK, THVdotVMAQASU_VX, 0x7 }, // 19
  { PseudoTHVdotVMAQAUS_VX_M1, THVdotVMAQAUS_VX, 0x0 }, // 20
  { PseudoTHVdotVMAQAUS_VX_M1_MASK, THVdotVMAQAUS_VX, 0x0 }, // 21
  { PseudoTHVdotVMAQAUS_VX_M2, THVdotVMAQAUS_VX, 0x1 }, // 22
  { PseudoTHVdotVMAQAUS_VX_M2_MASK, THVdotVMAQAUS_VX, 0x1 }, // 23
  { PseudoTHVdotVMAQAUS_VX_M4, THVdotVMAQAUS_VX, 0x2 }, // 24
  { PseudoTHVdotVMAQAUS_VX_M4_MASK, THVdotVMAQAUS_VX, 0x2 }, // 25
  { PseudoTHVdotVMAQAUS_VX_M8, THVdotVMAQAUS_VX, 0x3 }, // 26
  { PseudoTHVdotVMAQAUS_VX_M8_MASK, THVdotVMAQAUS_VX, 0x3 }, // 27
  { PseudoTHVdotVMAQAUS_VX_MF2, THVdotVMAQAUS_VX, 0x7 }, // 28
  { PseudoTHVdotVMAQAUS_VX_MF2_MASK, THVdotVMAQAUS_VX, 0x7 }, // 29
  { PseudoTHVdotVMAQAU_VV_M1, THVdotVMAQAU_VV, 0x0 }, // 30
  { PseudoTHVdotVMAQAU_VV_M1_MASK, THVdotVMAQAU_VV, 0x0 }, // 31
  { PseudoTHVdotVMAQAU_VV_M2, THVdotVMAQAU_VV, 0x1 }, // 32
  { PseudoTHVdotVMAQAU_VV_M2_MASK, THVdotVMAQAU_VV, 0x1 }, // 33
  { PseudoTHVdotVMAQAU_VV_M4, THVdotVMAQAU_VV, 0x2 }, // 34
  { PseudoTHVdotVMAQAU_VV_M4_MASK, THVdotVMAQAU_VV, 0x2 }, // 35
  { PseudoTHVdotVMAQAU_VV_M8, THVdotVMAQAU_VV, 0x3 }, // 36
  { PseudoTHVdotVMAQAU_VV_M8_MASK, THVdotVMAQAU_VV, 0x3 }, // 37
  { PseudoTHVdotVMAQAU_VV_MF2, THVdotVMAQAU_VV, 0x7 }, // 38
  { PseudoTHVdotVMAQAU_VV_MF2_MASK, THVdotVMAQAU_VV, 0x7 }, // 39
  { PseudoTHVdotVMAQAU_VX_M1, THVdotVMAQAU_VX, 0x0 }, // 40
  { PseudoTHVdotVMAQAU_VX_M1_MASK, THVdotVMAQAU_VX, 0x0 }, // 41
  { PseudoTHVdotVMAQAU_VX_M2, THVdotVMAQAU_VX, 0x1 }, // 42
  { PseudoTHVdotVMAQAU_VX_M2_MASK, THVdotVMAQAU_VX, 0x1 }, // 43
  { PseudoTHVdotVMAQAU_VX_M4, THVdotVMAQAU_VX, 0x2 }, // 44
  { PseudoTHVdotVMAQAU_VX_M4_MASK, THVdotVMAQAU_VX, 0x2 }, // 45
  { PseudoTHVdotVMAQAU_VX_M8, THVdotVMAQAU_VX, 0x3 }, // 46
  { PseudoTHVdotVMAQAU_VX_M8_MASK, THVdotVMAQAU_VX, 0x3 }, // 47
  { PseudoTHVdotVMAQAU_VX_MF2, THVdotVMAQAU_VX, 0x7 }, // 48
  { PseudoTHVdotVMAQAU_VX_MF2_MASK, THVdotVMAQAU_VX, 0x7 }, // 49
  { PseudoTHVdotVMAQA_VV_M1, THVdotVMAQA_VV, 0x0 }, // 50
  { PseudoTHVdotVMAQA_VV_M1_MASK, THVdotVMAQA_VV, 0x0 }, // 51
  { PseudoTHVdotVMAQA_VV_M2, THVdotVMAQA_VV, 0x1 }, // 52
  { PseudoTHVdotVMAQA_VV_M2_MASK, THVdotVMAQA_VV, 0x1 }, // 53
  { PseudoTHVdotVMAQA_VV_M4, THVdotVMAQA_VV, 0x2 }, // 54
  { PseudoTHVdotVMAQA_VV_M4_MASK, THVdotVMAQA_VV, 0x2 }, // 55
  { PseudoTHVdotVMAQA_VV_M8, THVdotVMAQA_VV, 0x3 }, // 56
  { PseudoTHVdotVMAQA_VV_M8_MASK, THVdotVMAQA_VV, 0x3 }, // 57
  { PseudoTHVdotVMAQA_VV_MF2, THVdotVMAQA_VV, 0x7 }, // 58
  { PseudoTHVdotVMAQA_VV_MF2_MASK, THVdotVMAQA_VV, 0x7 }, // 59
  { PseudoTHVdotVMAQA_VX_M1, THVdotVMAQA_VX, 0x0 }, // 60
  { PseudoTHVdotVMAQA_VX_M1_MASK, THVdotVMAQA_VX, 0x0 }, // 61
  { PseudoTHVdotVMAQA_VX_M2, THVdotVMAQA_VX, 0x1 }, // 62
  { PseudoTHVdotVMAQA_VX_M2_MASK, THVdotVMAQA_VX, 0x1 }, // 63
  { PseudoTHVdotVMAQA_VX_M4, THVdotVMAQA_VX, 0x2 }, // 64
  { PseudoTHVdotVMAQA_VX_M4_MASK, THVdotVMAQA_VX, 0x2 }, // 65
  { PseudoTHVdotVMAQA_VX_M8, THVdotVMAQA_VX, 0x3 }, // 66
  { PseudoTHVdotVMAQA_VX_M8_MASK, THVdotVMAQA_VX, 0x3 }, // 67
  { PseudoTHVdotVMAQA_VX_MF2, THVdotVMAQA_VX, 0x7 }, // 68
  { PseudoTHVdotVMAQA_VX_MF2_MASK, THVdotVMAQA_VX, 0x7 }, // 69
  { PseudoVAADDU_VV_M1, VAADDU_VV, 0x0 }, // 70
  { PseudoVAADDU_VV_M1_MASK, VAADDU_VV, 0x0 }, // 71
  { PseudoVAADDU_VV_M1_TU, VAADDU_VV, 0x0 }, // 72
  { PseudoVAADDU_VV_M2, VAADDU_VV, 0x1 }, // 73
  { PseudoVAADDU_VV_M2_MASK, VAADDU_VV, 0x1 }, // 74
  { PseudoVAADDU_VV_M2_TU, VAADDU_VV, 0x1 }, // 75
  { PseudoVAADDU_VV_M4, VAADDU_VV, 0x2 }, // 76
  { PseudoVAADDU_VV_M4_MASK, VAADDU_VV, 0x2 }, // 77
  { PseudoVAADDU_VV_M4_TU, VAADDU_VV, 0x2 }, // 78
  { PseudoVAADDU_VV_M8, VAADDU_VV, 0x3 }, // 79
  { PseudoVAADDU_VV_M8_MASK, VAADDU_VV, 0x3 }, // 80
  { PseudoVAADDU_VV_M8_TU, VAADDU_VV, 0x3 }, // 81
  { PseudoVAADDU_VV_MF8, VAADDU_VV, 0x5 }, // 82
  { PseudoVAADDU_VV_MF8_MASK, VAADDU_VV, 0x5 }, // 83
  { PseudoVAADDU_VV_MF8_TU, VAADDU_VV, 0x5 }, // 84
  { PseudoVAADDU_VV_MF4, VAADDU_VV, 0x6 }, // 85
  { PseudoVAADDU_VV_MF4_MASK, VAADDU_VV, 0x6 }, // 86
  { PseudoVAADDU_VV_MF4_TU, VAADDU_VV, 0x6 }, // 87
  { PseudoVAADDU_VV_MF2, VAADDU_VV, 0x7 }, // 88
  { PseudoVAADDU_VV_MF2_MASK, VAADDU_VV, 0x7 }, // 89
  { PseudoVAADDU_VV_MF2_TU, VAADDU_VV, 0x7 }, // 90
  { PseudoVAADDU_VX_M1, VAADDU_VX, 0x0 }, // 91
  { PseudoVAADDU_VX_M1_MASK, VAADDU_VX, 0x0 }, // 92
  { PseudoVAADDU_VX_M1_TU, VAADDU_VX, 0x0 }, // 93
  { PseudoVAADDU_VX_M2, VAADDU_VX, 0x1 }, // 94
  { PseudoVAADDU_VX_M2_MASK, VAADDU_VX, 0x1 }, // 95
  { PseudoVAADDU_VX_M2_TU, VAADDU_VX, 0x1 }, // 96
  { PseudoVAADDU_VX_M4, VAADDU_VX, 0x2 }, // 97
  { PseudoVAADDU_VX_M4_MASK, VAADDU_VX, 0x2 }, // 98
  { PseudoVAADDU_VX_M4_TU, VAADDU_VX, 0x2 }, // 99
  { PseudoVAADDU_VX_M8, VAADDU_VX, 0x3 }, // 100
  { PseudoVAADDU_VX_M8_MASK, VAADDU_VX, 0x3 }, // 101
  { PseudoVAADDU_VX_M8_TU, VAADDU_VX, 0x3 }, // 102
  { PseudoVAADDU_VX_MF8, VAADDU_VX, 0x5 }, // 103
  { PseudoVAADDU_VX_MF8_MASK, VAADDU_VX, 0x5 }, // 104
  { PseudoVAADDU_VX_MF8_TU, VAADDU_VX, 0x5 }, // 105
  { PseudoVAADDU_VX_MF4, VAADDU_VX, 0x6 }, // 106
  { PseudoVAADDU_VX_MF4_MASK, VAADDU_VX, 0x6 }, // 107
  { PseudoVAADDU_VX_MF4_TU, VAADDU_VX, 0x6 }, // 108
  { PseudoVAADDU_VX_MF2, VAADDU_VX, 0x7 }, // 109
  { PseudoVAADDU_VX_MF2_MASK, VAADDU_VX, 0x7 }, // 110
  { PseudoVAADDU_VX_MF2_TU, VAADDU_VX, 0x7 }, // 111
  { PseudoVAADD_VV_M1, VAADD_VV, 0x0 }, // 112
  { PseudoVAADD_VV_M1_MASK, VAADD_VV, 0x0 }, // 113
  { PseudoVAADD_VV_M1_TU, VAADD_VV, 0x0 }, // 114
  { PseudoVAADD_VV_M2, VAADD_VV, 0x1 }, // 115
  { PseudoVAADD_VV_M2_MASK, VAADD_VV, 0x1 }, // 116
  { PseudoVAADD_VV_M2_TU, VAADD_VV, 0x1 }, // 117
  { PseudoVAADD_VV_M4, VAADD_VV, 0x2 }, // 118
  { PseudoVAADD_VV_M4_MASK, VAADD_VV, 0x2 }, // 119
  { PseudoVAADD_VV_M4_TU, VAADD_VV, 0x2 }, // 120
  { PseudoVAADD_VV_M8, VAADD_VV, 0x3 }, // 121
  { PseudoVAADD_VV_M8_MASK, VAADD_VV, 0x3 }, // 122
  { PseudoVAADD_VV_M8_TU, VAADD_VV, 0x3 }, // 123
  { PseudoVAADD_VV_MF8, VAADD_VV, 0x5 }, // 124
  { PseudoVAADD_VV_MF8_MASK, VAADD_VV, 0x5 }, // 125
  { PseudoVAADD_VV_MF8_TU, VAADD_VV, 0x5 }, // 126
  { PseudoVAADD_VV_MF4, VAADD_VV, 0x6 }, // 127
  { PseudoVAADD_VV_MF4_MASK, VAADD_VV, 0x6 }, // 128
  { PseudoVAADD_VV_MF4_TU, VAADD_VV, 0x6 }, // 129
  { PseudoVAADD_VV_MF2, VAADD_VV, 0x7 }, // 130
  { PseudoVAADD_VV_MF2_MASK, VAADD_VV, 0x7 }, // 131
  { PseudoVAADD_VV_MF2_TU, VAADD_VV, 0x7 }, // 132
  { PseudoVAADD_VX_M1, VAADD_VX, 0x0 }, // 133
  { PseudoVAADD_VX_M1_MASK, VAADD_VX, 0x0 }, // 134
  { PseudoVAADD_VX_M1_TU, VAADD_VX, 0x0 }, // 135
  { PseudoVAADD_VX_M2, VAADD_VX, 0x1 }, // 136
  { PseudoVAADD_VX_M2_MASK, VAADD_VX, 0x1 }, // 137
  { PseudoVAADD_VX_M2_TU, VAADD_VX, 0x1 }, // 138
  { PseudoVAADD_VX_M4, VAADD_VX, 0x2 }, // 139
  { PseudoVAADD_VX_M4_MASK, VAADD_VX, 0x2 }, // 140
  { PseudoVAADD_VX_M4_TU, VAADD_VX, 0x2 }, // 141
  { PseudoVAADD_VX_M8, VAADD_VX, 0x3 }, // 142
  { PseudoVAADD_VX_M8_MASK, VAADD_VX, 0x3 }, // 143
  { PseudoVAADD_VX_M8_TU, VAADD_VX, 0x3 }, // 144
  { PseudoVAADD_VX_MF8, VAADD_VX, 0x5 }, // 145
  { PseudoVAADD_VX_MF8_MASK, VAADD_VX, 0x5 }, // 146
  { PseudoVAADD_VX_MF8_TU, VAADD_VX, 0x5 }, // 147
  { PseudoVAADD_VX_MF4, VAADD_VX, 0x6 }, // 148
  { PseudoVAADD_VX_MF4_MASK, VAADD_VX, 0x6 }, // 149
  { PseudoVAADD_VX_MF4_TU, VAADD_VX, 0x6 }, // 150
  { PseudoVAADD_VX_MF2, VAADD_VX, 0x7 }, // 151
  { PseudoVAADD_VX_MF2_MASK, VAADD_VX, 0x7 }, // 152
  { PseudoVAADD_VX_MF2_TU, VAADD_VX, 0x7 }, // 153
  { PseudoVADC_VIM_M1, VADC_VIM, 0x0 }, // 154
  { PseudoVADC_VIM_M1_TU, VADC_VIM, 0x0 }, // 155
  { PseudoVADC_VIM_M2, VADC_VIM, 0x1 }, // 156
  { PseudoVADC_VIM_M2_TU, VADC_VIM, 0x1 }, // 157
  { PseudoVADC_VIM_M4, VADC_VIM, 0x2 }, // 158
  { PseudoVADC_VIM_M4_TU, VADC_VIM, 0x2 }, // 159
  { PseudoVADC_VIM_M8, VADC_VIM, 0x3 }, // 160
  { PseudoVADC_VIM_M8_TU, VADC_VIM, 0x3 }, // 161
  { PseudoVADC_VIM_MF8, VADC_VIM, 0x5 }, // 162
  { PseudoVADC_VIM_MF8_TU, VADC_VIM, 0x5 }, // 163
  { PseudoVADC_VIM_MF4, VADC_VIM, 0x6 }, // 164
  { PseudoVADC_VIM_MF4_TU, VADC_VIM, 0x6 }, // 165
  { PseudoVADC_VIM_MF2, VADC_VIM, 0x7 }, // 166
  { PseudoVADC_VIM_MF2_TU, VADC_VIM, 0x7 }, // 167
  { PseudoVADC_VVM_M1, VADC_VVM, 0x0 }, // 168
  { PseudoVADC_VVM_M1_TU, VADC_VVM, 0x0 }, // 169
  { PseudoVADC_VVM_M2, VADC_VVM, 0x1 }, // 170
  { PseudoVADC_VVM_M2_TU, VADC_VVM, 0x1 }, // 171
  { PseudoVADC_VVM_M4, VADC_VVM, 0x2 }, // 172
  { PseudoVADC_VVM_M4_TU, VADC_VVM, 0x2 }, // 173
  { PseudoVADC_VVM_M8, VADC_VVM, 0x3 }, // 174
  { PseudoVADC_VVM_M8_TU, VADC_VVM, 0x3 }, // 175
  { PseudoVADC_VVM_MF8, VADC_VVM, 0x5 }, // 176
  { PseudoVADC_VVM_MF8_TU, VADC_VVM, 0x5 }, // 177
  { PseudoVADC_VVM_MF4, VADC_VVM, 0x6 }, // 178
  { PseudoVADC_VVM_MF4_TU, VADC_VVM, 0x6 }, // 179
  { PseudoVADC_VVM_MF2, VADC_VVM, 0x7 }, // 180
  { PseudoVADC_VVM_MF2_TU, VADC_VVM, 0x7 }, // 181
  { PseudoVADC_VXM_M1, VADC_VXM, 0x0 }, // 182
  { PseudoVADC_VXM_M1_TU, VADC_VXM, 0x0 }, // 183
  { PseudoVADC_VXM_M2, VADC_VXM, 0x1 }, // 184
  { PseudoVADC_VXM_M2_TU, VADC_VXM, 0x1 }, // 185
  { PseudoVADC_VXM_M4, VADC_VXM, 0x2 }, // 186
  { PseudoVADC_VXM_M4_TU, VADC_VXM, 0x2 }, // 187
  { PseudoVADC_VXM_M8, VADC_VXM, 0x3 }, // 188
  { PseudoVADC_VXM_M8_TU, VADC_VXM, 0x3 }, // 189
  { PseudoVADC_VXM_MF8, VADC_VXM, 0x5 }, // 190
  { PseudoVADC_VXM_MF8_TU, VADC_VXM, 0x5 }, // 191
  { PseudoVADC_VXM_MF4, VADC_VXM, 0x6 }, // 192
  { PseudoVADC_VXM_MF4_TU, VADC_VXM, 0x6 }, // 193
  { PseudoVADC_VXM_MF2, VADC_VXM, 0x7 }, // 194
  { PseudoVADC_VXM_MF2_TU, VADC_VXM, 0x7 }, // 195
  { PseudoVADD_VI_M1, VADD_VI, 0x0 }, // 196
  { PseudoVADD_VI_M1_MASK, VADD_VI, 0x0 }, // 197
  { PseudoVADD_VI_M1_TU, VADD_VI, 0x0 }, // 198
  { PseudoVADD_VI_M2, VADD_VI, 0x1 }, // 199
  { PseudoVADD_VI_M2_MASK, VADD_VI, 0x1 }, // 200
  { PseudoVADD_VI_M2_TU, VADD_VI, 0x1 }, // 201
  { PseudoVADD_VI_M4, VADD_VI, 0x2 }, // 202
  { PseudoVADD_VI_M4_MASK, VADD_VI, 0x2 }, // 203
  { PseudoVADD_VI_M4_TU, VADD_VI, 0x2 }, // 204
  { PseudoVADD_VI_M8, VADD_VI, 0x3 }, // 205
  { PseudoVADD_VI_M8_MASK, VADD_VI, 0x3 }, // 206
  { PseudoVADD_VI_M8_TU, VADD_VI, 0x3 }, // 207
  { PseudoVADD_VI_MF8, VADD_VI, 0x5 }, // 208
  { PseudoVADD_VI_MF8_MASK, VADD_VI, 0x5 }, // 209
  { PseudoVADD_VI_MF8_TU, VADD_VI, 0x5 }, // 210
  { PseudoVADD_VI_MF4, VADD_VI, 0x6 }, // 211
  { PseudoVADD_VI_MF4_MASK, VADD_VI, 0x6 }, // 212
  { PseudoVADD_VI_MF4_TU, VADD_VI, 0x6 }, // 213
  { PseudoVADD_VI_MF2, VADD_VI, 0x7 }, // 214
  { PseudoVADD_VI_MF2_MASK, VADD_VI, 0x7 }, // 215
  { PseudoVADD_VI_MF2_TU, VADD_VI, 0x7 }, // 216
  { PseudoVADD_VV_M1, VADD_VV, 0x0 }, // 217
  { PseudoVADD_VV_M1_MASK, VADD_VV, 0x0 }, // 218
  { PseudoVADD_VV_M1_TU, VADD_VV, 0x0 }, // 219
  { PseudoVADD_VV_M2, VADD_VV, 0x1 }, // 220
  { PseudoVADD_VV_M2_MASK, VADD_VV, 0x1 }, // 221
  { PseudoVADD_VV_M2_TU, VADD_VV, 0x1 }, // 222
  { PseudoVADD_VV_M4, VADD_VV, 0x2 }, // 223
  { PseudoVADD_VV_M4_MASK, VADD_VV, 0x2 }, // 224
  { PseudoVADD_VV_M4_TU, VADD_VV, 0x2 }, // 225
  { PseudoVADD_VV_M8, VADD_VV, 0x3 }, // 226
  { PseudoVADD_VV_M8_MASK, VADD_VV, 0x3 }, // 227
  { PseudoVADD_VV_M8_TU, VADD_VV, 0x3 }, // 228
  { PseudoVADD_VV_MF8, VADD_VV, 0x5 }, // 229
  { PseudoVADD_VV_MF8_MASK, VADD_VV, 0x5 }, // 230
  { PseudoVADD_VV_MF8_TU, VADD_VV, 0x5 }, // 231
  { PseudoVADD_VV_MF4, VADD_VV, 0x6 }, // 232
  { PseudoVADD_VV_MF4_MASK, VADD_VV, 0x6 }, // 233
  { PseudoVADD_VV_MF4_TU, VADD_VV, 0x6 }, // 234
  { PseudoVADD_VV_MF2, VADD_VV, 0x7 }, // 235
  { PseudoVADD_VV_MF2_MASK, VADD_VV, 0x7 }, // 236
  { PseudoVADD_VV_MF2_TU, VADD_VV, 0x7 }, // 237
  { PseudoVADD_VX_M1, VADD_VX, 0x0 }, // 238
  { PseudoVADD_VX_M1_MASK, VADD_VX, 0x0 }, // 239
  { PseudoVADD_VX_M1_TU, VADD_VX, 0x0 }, // 240
  { PseudoVADD_VX_M2, VADD_VX, 0x1 }, // 241
  { PseudoVADD_VX_M2_MASK, VADD_VX, 0x1 }, // 242
  { PseudoVADD_VX_M2_TU, VADD_VX, 0x1 }, // 243
  { PseudoVADD_VX_M4, VADD_VX, 0x2 }, // 244
  { PseudoVADD_VX_M4_MASK, VADD_VX, 0x2 }, // 245
  { PseudoVADD_VX_M4_TU, VADD_VX, 0x2 }, // 246
  { PseudoVADD_VX_M8, VADD_VX, 0x3 }, // 247
  { PseudoVADD_VX_M8_MASK, VADD_VX, 0x3 }, // 248
  { PseudoVADD_VX_M8_TU, VADD_VX, 0x3 }, // 249
  { PseudoVADD_VX_MF8, VADD_VX, 0x5 }, // 250
  { PseudoVADD_VX_MF8_MASK, VADD_VX, 0x5 }, // 251
  { PseudoVADD_VX_MF8_TU, VADD_VX, 0x5 }, // 252
  { PseudoVADD_VX_MF4, VADD_VX, 0x6 }, // 253
  { PseudoVADD_VX_MF4_MASK, VADD_VX, 0x6 }, // 254
  { PseudoVADD_VX_MF4_TU, VADD_VX, 0x6 }, // 255
  { PseudoVADD_VX_MF2, VADD_VX, 0x7 }, // 256
  { PseudoVADD_VX_MF2_MASK, VADD_VX, 0x7 }, // 257
  { PseudoVADD_VX_MF2_TU, VADD_VX, 0x7 }, // 258
  { PseudoVAND_VI_M1, VAND_VI, 0x0 }, // 259
  { PseudoVAND_VI_M1_MASK, VAND_VI, 0x0 }, // 260
  { PseudoVAND_VI_M1_TU, VAND_VI, 0x0 }, // 261
  { PseudoVAND_VI_M2, VAND_VI, 0x1 }, // 262
  { PseudoVAND_VI_M2_MASK, VAND_VI, 0x1 }, // 263
  { PseudoVAND_VI_M2_TU, VAND_VI, 0x1 }, // 264
  { PseudoVAND_VI_M4, VAND_VI, 0x2 }, // 265
  { PseudoVAND_VI_M4_MASK, VAND_VI, 0x2 }, // 266
  { PseudoVAND_VI_M4_TU, VAND_VI, 0x2 }, // 267
  { PseudoVAND_VI_M8, VAND_VI, 0x3 }, // 268
  { PseudoVAND_VI_M8_MASK, VAND_VI, 0x3 }, // 269
  { PseudoVAND_VI_M8_TU, VAND_VI, 0x3 }, // 270
  { PseudoVAND_VI_MF8, VAND_VI, 0x5 }, // 271
  { PseudoVAND_VI_MF8_MASK, VAND_VI, 0x5 }, // 272
  { PseudoVAND_VI_MF8_TU, VAND_VI, 0x5 }, // 273
  { PseudoVAND_VI_MF4, VAND_VI, 0x6 }, // 274
  { PseudoVAND_VI_MF4_MASK, VAND_VI, 0x6 }, // 275
  { PseudoVAND_VI_MF4_TU, VAND_VI, 0x6 }, // 276
  { PseudoVAND_VI_MF2, VAND_VI, 0x7 }, // 277
  { PseudoVAND_VI_MF2_MASK, VAND_VI, 0x7 }, // 278
  { PseudoVAND_VI_MF2_TU, VAND_VI, 0x7 }, // 279
  { PseudoVAND_VV_M1, VAND_VV, 0x0 }, // 280
  { PseudoVAND_VV_M1_MASK, VAND_VV, 0x0 }, // 281
  { PseudoVAND_VV_M1_TU, VAND_VV, 0x0 }, // 282
  { PseudoVAND_VV_M2, VAND_VV, 0x1 }, // 283
  { PseudoVAND_VV_M2_MASK, VAND_VV, 0x1 }, // 284
  { PseudoVAND_VV_M2_TU, VAND_VV, 0x1 }, // 285
  { PseudoVAND_VV_M4, VAND_VV, 0x2 }, // 286
  { PseudoVAND_VV_M4_MASK, VAND_VV, 0x2 }, // 287
  { PseudoVAND_VV_M4_TU, VAND_VV, 0x2 }, // 288
  { PseudoVAND_VV_M8, VAND_VV, 0x3 }, // 289
  { PseudoVAND_VV_M8_MASK, VAND_VV, 0x3 }, // 290
  { PseudoVAND_VV_M8_TU, VAND_VV, 0x3 }, // 291
  { PseudoVAND_VV_MF8, VAND_VV, 0x5 }, // 292
  { PseudoVAND_VV_MF8_MASK, VAND_VV, 0x5 }, // 293
  { PseudoVAND_VV_MF8_TU, VAND_VV, 0x5 }, // 294
  { PseudoVAND_VV_MF4, VAND_VV, 0x6 }, // 295
  { PseudoVAND_VV_MF4_MASK, VAND_VV, 0x6 }, // 296
  { PseudoVAND_VV_MF4_TU, VAND_VV, 0x6 }, // 297
  { PseudoVAND_VV_MF2, VAND_VV, 0x7 }, // 298
  { PseudoVAND_VV_MF2_MASK, VAND_VV, 0x7 }, // 299
  { PseudoVAND_VV_MF2_TU, VAND_VV, 0x7 }, // 300
  { PseudoVAND_VX_M1, VAND_VX, 0x0 }, // 301
  { PseudoVAND_VX_M1_MASK, VAND_VX, 0x0 }, // 302
  { PseudoVAND_VX_M1_TU, VAND_VX, 0x0 }, // 303
  { PseudoVAND_VX_M2, VAND_VX, 0x1 }, // 304
  { PseudoVAND_VX_M2_MASK, VAND_VX, 0x1 }, // 305
  { PseudoVAND_VX_M2_TU, VAND_VX, 0x1 }, // 306
  { PseudoVAND_VX_M4, VAND_VX, 0x2 }, // 307
  { PseudoVAND_VX_M4_MASK, VAND_VX, 0x2 }, // 308
  { PseudoVAND_VX_M4_TU, VAND_VX, 0x2 }, // 309
  { PseudoVAND_VX_M8, VAND_VX, 0x3 }, // 310
  { PseudoVAND_VX_M8_MASK, VAND_VX, 0x3 }, // 311
  { PseudoVAND_VX_M8_TU, VAND_VX, 0x3 }, // 312
  { PseudoVAND_VX_MF8, VAND_VX, 0x5 }, // 313
  { PseudoVAND_VX_MF8_MASK, VAND_VX, 0x5 }, // 314
  { PseudoVAND_VX_MF8_TU, VAND_VX, 0x5 }, // 315
  { PseudoVAND_VX_MF4, VAND_VX, 0x6 }, // 316
  { PseudoVAND_VX_MF4_MASK, VAND_VX, 0x6 }, // 317
  { PseudoVAND_VX_MF4_TU, VAND_VX, 0x6 }, // 318
  { PseudoVAND_VX_MF2, VAND_VX, 0x7 }, // 319
  { PseudoVAND_VX_MF2_MASK, VAND_VX, 0x7 }, // 320
  { PseudoVAND_VX_MF2_TU, VAND_VX, 0x7 }, // 321
  { PseudoVASUBU_VV_M1, VASUBU_VV, 0x0 }, // 322
  { PseudoVASUBU_VV_M1_MASK, VASUBU_VV, 0x0 }, // 323
  { PseudoVASUBU_VV_M1_TU, VASUBU_VV, 0x0 }, // 324
  { PseudoVASUBU_VV_M2, VASUBU_VV, 0x1 }, // 325
  { PseudoVASUBU_VV_M2_MASK, VASUBU_VV, 0x1 }, // 326
  { PseudoVASUBU_VV_M2_TU, VASUBU_VV, 0x1 }, // 327
  { PseudoVASUBU_VV_M4, VASUBU_VV, 0x2 }, // 328
  { PseudoVASUBU_VV_M4_MASK, VASUBU_VV, 0x2 }, // 329
  { PseudoVASUBU_VV_M4_TU, VASUBU_VV, 0x2 }, // 330
  { PseudoVASUBU_VV_M8, VASUBU_VV, 0x3 }, // 331
  { PseudoVASUBU_VV_M8_MASK, VASUBU_VV, 0x3 }, // 332
  { PseudoVASUBU_VV_M8_TU, VASUBU_VV, 0x3 }, // 333
  { PseudoVASUBU_VV_MF8, VASUBU_VV, 0x5 }, // 334
  { PseudoVASUBU_VV_MF8_MASK, VASUBU_VV, 0x5 }, // 335
  { PseudoVASUBU_VV_MF8_TU, VASUBU_VV, 0x5 }, // 336
  { PseudoVASUBU_VV_MF4, VASUBU_VV, 0x6 }, // 337
  { PseudoVASUBU_VV_MF4_MASK, VASUBU_VV, 0x6 }, // 338
  { PseudoVASUBU_VV_MF4_TU, VASUBU_VV, 0x6 }, // 339
  { PseudoVASUBU_VV_MF2, VASUBU_VV, 0x7 }, // 340
  { PseudoVASUBU_VV_MF2_MASK, VASUBU_VV, 0x7 }, // 341
  { PseudoVASUBU_VV_MF2_TU, VASUBU_VV, 0x7 }, // 342
  { PseudoVASUBU_VX_M1, VASUBU_VX, 0x0 }, // 343
  { PseudoVASUBU_VX_M1_MASK, VASUBU_VX, 0x0 }, // 344
  { PseudoVASUBU_VX_M1_TU, VASUBU_VX, 0x0 }, // 345
  { PseudoVASUBU_VX_M2, VASUBU_VX, 0x1 }, // 346
  { PseudoVASUBU_VX_M2_MASK, VASUBU_VX, 0x1 }, // 347
  { PseudoVASUBU_VX_M2_TU, VASUBU_VX, 0x1 }, // 348
  { PseudoVASUBU_VX_M4, VASUBU_VX, 0x2 }, // 349
  { PseudoVASUBU_VX_M4_MASK, VASUBU_VX, 0x2 }, // 350
  { PseudoVASUBU_VX_M4_TU, VASUBU_VX, 0x2 }, // 351
  { PseudoVASUBU_VX_M8, VASUBU_VX, 0x3 }, // 352
  { PseudoVASUBU_VX_M8_MASK, VASUBU_VX, 0x3 }, // 353
  { PseudoVASUBU_VX_M8_TU, VASUBU_VX, 0x3 }, // 354
  { PseudoVASUBU_VX_MF8, VASUBU_VX, 0x5 }, // 355
  { PseudoVASUBU_VX_MF8_MASK, VASUBU_VX, 0x5 }, // 356
  { PseudoVASUBU_VX_MF8_TU, VASUBU_VX, 0x5 }, // 357
  { PseudoVASUBU_VX_MF4, VASUBU_VX, 0x6 }, // 358
  { PseudoVASUBU_VX_MF4_MASK, VASUBU_VX, 0x6 }, // 359
  { PseudoVASUBU_VX_MF4_TU, VASUBU_VX, 0x6 }, // 360
  { PseudoVASUBU_VX_MF2, VASUBU_VX, 0x7 }, // 361
  { PseudoVASUBU_VX_MF2_MASK, VASUBU_VX, 0x7 }, // 362
  { PseudoVASUBU_VX_MF2_TU, VASUBU_VX, 0x7 }, // 363
  { PseudoVASUB_VV_M1, VASUB_VV, 0x0 }, // 364
  { PseudoVASUB_VV_M1_MASK, VASUB_VV, 0x0 }, // 365
  { PseudoVASUB_VV_M1_TU, VASUB_VV, 0x0 }, // 366
  { PseudoVASUB_VV_M2, VASUB_VV, 0x1 }, // 367
  { PseudoVASUB_VV_M2_MASK, VASUB_VV, 0x1 }, // 368
  { PseudoVASUB_VV_M2_TU, VASUB_VV, 0x1 }, // 369
  { PseudoVASUB_VV_M4, VASUB_VV, 0x2 }, // 370
  { PseudoVASUB_VV_M4_MASK, VASUB_VV, 0x2 }, // 371
  { PseudoVASUB_VV_M4_TU, VASUB_VV, 0x2 }, // 372
  { PseudoVASUB_VV_M8, VASUB_VV, 0x3 }, // 373
  { PseudoVASUB_VV_M8_MASK, VASUB_VV, 0x3 }, // 374
  { PseudoVASUB_VV_M8_TU, VASUB_VV, 0x3 }, // 375
  { PseudoVASUB_VV_MF8, VASUB_VV, 0x5 }, // 376
  { PseudoVASUB_VV_MF8_MASK, VASUB_VV, 0x5 }, // 377
  { PseudoVASUB_VV_MF8_TU, VASUB_VV, 0x5 }, // 378
  { PseudoVASUB_VV_MF4, VASUB_VV, 0x6 }, // 379
  { PseudoVASUB_VV_MF4_MASK, VASUB_VV, 0x6 }, // 380
  { PseudoVASUB_VV_MF4_TU, VASUB_VV, 0x6 }, // 381
  { PseudoVASUB_VV_MF2, VASUB_VV, 0x7 }, // 382
  { PseudoVASUB_VV_MF2_MASK, VASUB_VV, 0x7 }, // 383
  { PseudoVASUB_VV_MF2_TU, VASUB_VV, 0x7 }, // 384
  { PseudoVASUB_VX_M1, VASUB_VX, 0x0 }, // 385
  { PseudoVASUB_VX_M1_MASK, VASUB_VX, 0x0 }, // 386
  { PseudoVASUB_VX_M1_TU, VASUB_VX, 0x0 }, // 387
  { PseudoVASUB_VX_M2, VASUB_VX, 0x1 }, // 388
  { PseudoVASUB_VX_M2_MASK, VASUB_VX, 0x1 }, // 389
  { PseudoVASUB_VX_M2_TU, VASUB_VX, 0x1 }, // 390
  { PseudoVASUB_VX_M4, VASUB_VX, 0x2 }, // 391
  { PseudoVASUB_VX_M4_MASK, VASUB_VX, 0x2 }, // 392
  { PseudoVASUB_VX_M4_TU, VASUB_VX, 0x2 }, // 393
  { PseudoVASUB_VX_M8, VASUB_VX, 0x3 }, // 394
  { PseudoVASUB_VX_M8_MASK, VASUB_VX, 0x3 }, // 395
  { PseudoVASUB_VX_M8_TU, VASUB_VX, 0x3 }, // 396
  { PseudoVASUB_VX_MF8, VASUB_VX, 0x5 }, // 397
  { PseudoVASUB_VX_MF8_MASK, VASUB_VX, 0x5 }, // 398
  { PseudoVASUB_VX_MF8_TU, VASUB_VX, 0x5 }, // 399
  { PseudoVASUB_VX_MF4, VASUB_VX, 0x6 }, // 400
  { PseudoVASUB_VX_MF4_MASK, VASUB_VX, 0x6 }, // 401
  { PseudoVASUB_VX_MF4_TU, VASUB_VX, 0x6 }, // 402
  { PseudoVASUB_VX_MF2, VASUB_VX, 0x7 }, // 403
  { PseudoVASUB_VX_MF2_MASK, VASUB_VX, 0x7 }, // 404
  { PseudoVASUB_VX_MF2_TU, VASUB_VX, 0x7 }, // 405
  { PseudoVCOMPRESS_VM_M1, VCOMPRESS_VM, 0x0 }, // 406
  { PseudoVCOMPRESS_VM_M2, VCOMPRESS_VM, 0x1 }, // 407
  { PseudoVCOMPRESS_VM_M4, VCOMPRESS_VM, 0x2 }, // 408
  { PseudoVCOMPRESS_VM_M8, VCOMPRESS_VM, 0x3 }, // 409
  { PseudoVCOMPRESS_VM_MF8, VCOMPRESS_VM, 0x5 }, // 410
  { PseudoVCOMPRESS_VM_MF4, VCOMPRESS_VM, 0x6 }, // 411
  { PseudoVCOMPRESS_VM_MF2, VCOMPRESS_VM, 0x7 }, // 412
  { PseudoVCPOP_M_B8, VCPOP_M, 0x0 }, // 413
  { PseudoVCPOP_M_B8_MASK, VCPOP_M, 0x0 }, // 414
  { PseudoVCPOP_M_B16, VCPOP_M, 0x1 }, // 415
  { PseudoVCPOP_M_B16_MASK, VCPOP_M, 0x1 }, // 416
  { PseudoVCPOP_M_B32, VCPOP_M, 0x2 }, // 417
  { PseudoVCPOP_M_B32_MASK, VCPOP_M, 0x2 }, // 418
  { PseudoVCPOP_M_B64, VCPOP_M, 0x3 }, // 419
  { PseudoVCPOP_M_B64_MASK, VCPOP_M, 0x3 }, // 420
  { PseudoVCPOP_M_B1, VCPOP_M, 0x5 }, // 421
  { PseudoVCPOP_M_B1_MASK, VCPOP_M, 0x5 }, // 422
  { PseudoVCPOP_M_B2, VCPOP_M, 0x6 }, // 423
  { PseudoVCPOP_M_B2_MASK, VCPOP_M, 0x6 }, // 424
  { PseudoVCPOP_M_B4, VCPOP_M, 0x7 }, // 425
  { PseudoVCPOP_M_B4_MASK, VCPOP_M, 0x7 }, // 426
  { PseudoVDIVU_VV_M1, VDIVU_VV, 0x0 }, // 427
  { PseudoVDIVU_VV_M1_MASK, VDIVU_VV, 0x0 }, // 428
  { PseudoVDIVU_VV_M1_TU, VDIVU_VV, 0x0 }, // 429
  { PseudoVDIVU_VV_M2, VDIVU_VV, 0x1 }, // 430
  { PseudoVDIVU_VV_M2_MASK, VDIVU_VV, 0x1 }, // 431
  { PseudoVDIVU_VV_M2_TU, VDIVU_VV, 0x1 }, // 432
  { PseudoVDIVU_VV_M4, VDIVU_VV, 0x2 }, // 433
  { PseudoVDIVU_VV_M4_MASK, VDIVU_VV, 0x2 }, // 434
  { PseudoVDIVU_VV_M4_TU, VDIVU_VV, 0x2 }, // 435
  { PseudoVDIVU_VV_M8, VDIVU_VV, 0x3 }, // 436
  { PseudoVDIVU_VV_M8_MASK, VDIVU_VV, 0x3 }, // 437
  { PseudoVDIVU_VV_M8_TU, VDIVU_VV, 0x3 }, // 438
  { PseudoVDIVU_VV_MF8, VDIVU_VV, 0x5 }, // 439
  { PseudoVDIVU_VV_MF8_MASK, VDIVU_VV, 0x5 }, // 440
  { PseudoVDIVU_VV_MF8_TU, VDIVU_VV, 0x5 }, // 441
  { PseudoVDIVU_VV_MF4, VDIVU_VV, 0x6 }, // 442
  { PseudoVDIVU_VV_MF4_MASK, VDIVU_VV, 0x6 }, // 443
  { PseudoVDIVU_VV_MF4_TU, VDIVU_VV, 0x6 }, // 444
  { PseudoVDIVU_VV_MF2, VDIVU_VV, 0x7 }, // 445
  { PseudoVDIVU_VV_MF2_MASK, VDIVU_VV, 0x7 }, // 446
  { PseudoVDIVU_VV_MF2_TU, VDIVU_VV, 0x7 }, // 447
  { PseudoVDIVU_VX_M1, VDIVU_VX, 0x0 }, // 448
  { PseudoVDIVU_VX_M1_MASK, VDIVU_VX, 0x0 }, // 449
  { PseudoVDIVU_VX_M1_TU, VDIVU_VX, 0x0 }, // 450
  { PseudoVDIVU_VX_M2, VDIVU_VX, 0x1 }, // 451
  { PseudoVDIVU_VX_M2_MASK, VDIVU_VX, 0x1 }, // 452
  { PseudoVDIVU_VX_M2_TU, VDIVU_VX, 0x1 }, // 453
  { PseudoVDIVU_VX_M4, VDIVU_VX, 0x2 }, // 454
  { PseudoVDIVU_VX_M4_MASK, VDIVU_VX, 0x2 }, // 455
  { PseudoVDIVU_VX_M4_TU, VDIVU_VX, 0x2 }, // 456
  { PseudoVDIVU_VX_M8, VDIVU_VX, 0x3 }, // 457
  { PseudoVDIVU_VX_M8_MASK, VDIVU_VX, 0x3 }, // 458
  { PseudoVDIVU_VX_M8_TU, VDIVU_VX, 0x3 }, // 459
  { PseudoVDIVU_VX_MF8, VDIVU_VX, 0x5 }, // 460
  { PseudoVDIVU_VX_MF8_MASK, VDIVU_VX, 0x5 }, // 461
  { PseudoVDIVU_VX_MF8_TU, VDIVU_VX, 0x5 }, // 462
  { PseudoVDIVU_VX_MF4, VDIVU_VX, 0x6 }, // 463
  { PseudoVDIVU_VX_MF4_MASK, VDIVU_VX, 0x6 }, // 464
  { PseudoVDIVU_VX_MF4_TU, VDIVU_VX, 0x6 }, // 465
  { PseudoVDIVU_VX_MF2, VDIVU_VX, 0x7 }, // 466
  { PseudoVDIVU_VX_MF2_MASK, VDIVU_VX, 0x7 }, // 467
  { PseudoVDIVU_VX_MF2_TU, VDIVU_VX, 0x7 }, // 468
  { PseudoVDIV_VV_M1, VDIV_VV, 0x0 }, // 469
  { PseudoVDIV_VV_M1_MASK, VDIV_VV, 0x0 }, // 470
  { PseudoVDIV_VV_M1_TU, VDIV_VV, 0x0 }, // 471
  { PseudoVDIV_VV_M2, VDIV_VV, 0x1 }, // 472
  { PseudoVDIV_VV_M2_MASK, VDIV_VV, 0x1 }, // 473
  { PseudoVDIV_VV_M2_TU, VDIV_VV, 0x1 }, // 474
  { PseudoVDIV_VV_M4, VDIV_VV, 0x2 }, // 475
  { PseudoVDIV_VV_M4_MASK, VDIV_VV, 0x2 }, // 476
  { PseudoVDIV_VV_M4_TU, VDIV_VV, 0x2 }, // 477
  { PseudoVDIV_VV_M8, VDIV_VV, 0x3 }, // 478
  { PseudoVDIV_VV_M8_MASK, VDIV_VV, 0x3 }, // 479
  { PseudoVDIV_VV_M8_TU, VDIV_VV, 0x3 }, // 480
  { PseudoVDIV_VV_MF8, VDIV_VV, 0x5 }, // 481
  { PseudoVDIV_VV_MF8_MASK, VDIV_VV, 0x5 }, // 482
  { PseudoVDIV_VV_MF8_TU, VDIV_VV, 0x5 }, // 483
  { PseudoVDIV_VV_MF4, VDIV_VV, 0x6 }, // 484
  { PseudoVDIV_VV_MF4_MASK, VDIV_VV, 0x6 }, // 485
  { PseudoVDIV_VV_MF4_TU, VDIV_VV, 0x6 }, // 486
  { PseudoVDIV_VV_MF2, VDIV_VV, 0x7 }, // 487
  { PseudoVDIV_VV_MF2_MASK, VDIV_VV, 0x7 }, // 488
  { PseudoVDIV_VV_MF2_TU, VDIV_VV, 0x7 }, // 489
  { PseudoVDIV_VX_M1, VDIV_VX, 0x0 }, // 490
  { PseudoVDIV_VX_M1_MASK, VDIV_VX, 0x0 }, // 491
  { PseudoVDIV_VX_M1_TU, VDIV_VX, 0x0 }, // 492
  { PseudoVDIV_VX_M2, VDIV_VX, 0x1 }, // 493
  { PseudoVDIV_VX_M2_MASK, VDIV_VX, 0x1 }, // 494
  { PseudoVDIV_VX_M2_TU, VDIV_VX, 0x1 }, // 495
  { PseudoVDIV_VX_M4, VDIV_VX, 0x2 }, // 496
  { PseudoVDIV_VX_M4_MASK, VDIV_VX, 0x2 }, // 497
  { PseudoVDIV_VX_M4_TU, VDIV_VX, 0x2 }, // 498
  { PseudoVDIV_VX_M8, VDIV_VX, 0x3 }, // 499
  { PseudoVDIV_VX_M8_MASK, VDIV_VX, 0x3 }, // 500
  { PseudoVDIV_VX_M8_TU, VDIV_VX, 0x3 }, // 501
  { PseudoVDIV_VX_MF8, VDIV_VX, 0x5 }, // 502
  { PseudoVDIV_VX_MF8_MASK, VDIV_VX, 0x5 }, // 503
  { PseudoVDIV_VX_MF8_TU, VDIV_VX, 0x5 }, // 504
  { PseudoVDIV_VX_MF4, VDIV_VX, 0x6 }, // 505
  { PseudoVDIV_VX_MF4_MASK, VDIV_VX, 0x6 }, // 506
  { PseudoVDIV_VX_MF4_TU, VDIV_VX, 0x6 }, // 507
  { PseudoVDIV_VX_MF2, VDIV_VX, 0x7 }, // 508
  { PseudoVDIV_VX_MF2_MASK, VDIV_VX, 0x7 }, // 509
  { PseudoVDIV_VX_MF2_TU, VDIV_VX, 0x7 }, // 510
  { PseudoVFADD_VF16_M1, VFADD_VF, 0x0 }, // 511
  { PseudoVFADD_VF16_M1_MASK, VFADD_VF, 0x0 }, // 512
  { PseudoVFADD_VF16_M1_TU, VFADD_VF, 0x0 }, // 513
  { PseudoVFADD_VF32_M1, VFADD_VF, 0x0 }, // 514
  { PseudoVFADD_VF32_M1_MASK, VFADD_VF, 0x0 }, // 515
  { PseudoVFADD_VF32_M1_TU, VFADD_VF, 0x0 }, // 516
  { PseudoVFADD_VF64_M1, VFADD_VF, 0x0 }, // 517
  { PseudoVFADD_VF64_M1_MASK, VFADD_VF, 0x0 }, // 518
  { PseudoVFADD_VF64_M1_TU, VFADD_VF, 0x0 }, // 519
  { PseudoVFADD_VF16_M2, VFADD_VF, 0x1 }, // 520
  { PseudoVFADD_VF16_M2_MASK, VFADD_VF, 0x1 }, // 521
  { PseudoVFADD_VF16_M2_TU, VFADD_VF, 0x1 }, // 522
  { PseudoVFADD_VF32_M2, VFADD_VF, 0x1 }, // 523
  { PseudoVFADD_VF32_M2_MASK, VFADD_VF, 0x1 }, // 524
  { PseudoVFADD_VF32_M2_TU, VFADD_VF, 0x1 }, // 525
  { PseudoVFADD_VF64_M2, VFADD_VF, 0x1 }, // 526
  { PseudoVFADD_VF64_M2_MASK, VFADD_VF, 0x1 }, // 527
  { PseudoVFADD_VF64_M2_TU, VFADD_VF, 0x1 }, // 528
  { PseudoVFADD_VF16_M4, VFADD_VF, 0x2 }, // 529
  { PseudoVFADD_VF16_M4_MASK, VFADD_VF, 0x2 }, // 530
  { PseudoVFADD_VF16_M4_TU, VFADD_VF, 0x2 }, // 531
  { PseudoVFADD_VF32_M4, VFADD_VF, 0x2 }, // 532
  { PseudoVFADD_VF32_M4_MASK, VFADD_VF, 0x2 }, // 533
  { PseudoVFADD_VF32_M4_TU, VFADD_VF, 0x2 }, // 534
  { PseudoVFADD_VF64_M4, VFADD_VF, 0x2 }, // 535
  { PseudoVFADD_VF64_M4_MASK, VFADD_VF, 0x2 }, // 536
  { PseudoVFADD_VF64_M4_TU, VFADD_VF, 0x2 }, // 537
  { PseudoVFADD_VF16_M8, VFADD_VF, 0x3 }, // 538
  { PseudoVFADD_VF16_M8_MASK, VFADD_VF, 0x3 }, // 539
  { PseudoVFADD_VF16_M8_TU, VFADD_VF, 0x3 }, // 540
  { PseudoVFADD_VF32_M8, VFADD_VF, 0x3 }, // 541
  { PseudoVFADD_VF32_M8_MASK, VFADD_VF, 0x3 }, // 542
  { PseudoVFADD_VF32_M8_TU, VFADD_VF, 0x3 }, // 543
  { PseudoVFADD_VF64_M8, VFADD_VF, 0x3 }, // 544
  { PseudoVFADD_VF64_M8_MASK, VFADD_VF, 0x3 }, // 545
  { PseudoVFADD_VF64_M8_TU, VFADD_VF, 0x3 }, // 546
  { PseudoVFADD_VF16_MF4, VFADD_VF, 0x6 }, // 547
  { PseudoVFADD_VF16_MF4_MASK, VFADD_VF, 0x6 }, // 548
  { PseudoVFADD_VF16_MF4_TU, VFADD_VF, 0x6 }, // 549
  { PseudoVFADD_VF16_MF2, VFADD_VF, 0x7 }, // 550
  { PseudoVFADD_VF16_MF2_MASK, VFADD_VF, 0x7 }, // 551
  { PseudoVFADD_VF16_MF2_TU, VFADD_VF, 0x7 }, // 552
  { PseudoVFADD_VF32_MF2, VFADD_VF, 0x7 }, // 553
  { PseudoVFADD_VF32_MF2_MASK, VFADD_VF, 0x7 }, // 554
  { PseudoVFADD_VF32_MF2_TU, VFADD_VF, 0x7 }, // 555
  { PseudoVFADD_VV_M1, VFADD_VV, 0x0 }, // 556
  { PseudoVFADD_VV_M1_MASK, VFADD_VV, 0x0 }, // 557
  { PseudoVFADD_VV_M1_TU, VFADD_VV, 0x0 }, // 558
  { PseudoVFADD_VV_M2, VFADD_VV, 0x1 }, // 559
  { PseudoVFADD_VV_M2_MASK, VFADD_VV, 0x1 }, // 560
  { PseudoVFADD_VV_M2_TU, VFADD_VV, 0x1 }, // 561
  { PseudoVFADD_VV_M4, VFADD_VV, 0x2 }, // 562
  { PseudoVFADD_VV_M4_MASK, VFADD_VV, 0x2 }, // 563
  { PseudoVFADD_VV_M4_TU, VFADD_VV, 0x2 }, // 564
  { PseudoVFADD_VV_M8, VFADD_VV, 0x3 }, // 565
  { PseudoVFADD_VV_M8_MASK, VFADD_VV, 0x3 }, // 566
  { PseudoVFADD_VV_M8_TU, VFADD_VV, 0x3 }, // 567
  { PseudoVFADD_VV_MF4, VFADD_VV, 0x6 }, // 568
  { PseudoVFADD_VV_MF4_MASK, VFADD_VV, 0x6 }, // 569
  { PseudoVFADD_VV_MF4_TU, VFADD_VV, 0x6 }, // 570
  { PseudoVFADD_VV_MF2, VFADD_VV, 0x7 }, // 571
  { PseudoVFADD_VV_MF2_MASK, VFADD_VV, 0x7 }, // 572
  { PseudoVFADD_VV_MF2_TU, VFADD_VV, 0x7 }, // 573
  { PseudoVFCLASS_V_M1, VFCLASS_V, 0x0 }, // 574
  { PseudoVFCLASS_V_M1_MASK, VFCLASS_V, 0x0 }, // 575
  { PseudoVFCLASS_V_M1_TU, VFCLASS_V, 0x0 }, // 576
  { PseudoVFCLASS_V_M2, VFCLASS_V, 0x1 }, // 577
  { PseudoVFCLASS_V_M2_MASK, VFCLASS_V, 0x1 }, // 578
  { PseudoVFCLASS_V_M2_TU, VFCLASS_V, 0x1 }, // 579
  { PseudoVFCLASS_V_M4, VFCLASS_V, 0x2 }, // 580
  { PseudoVFCLASS_V_M4_MASK, VFCLASS_V, 0x2 }, // 581
  { PseudoVFCLASS_V_M4_TU, VFCLASS_V, 0x2 }, // 582
  { PseudoVFCLASS_V_M8, VFCLASS_V, 0x3 }, // 583
  { PseudoVFCLASS_V_M8_MASK, VFCLASS_V, 0x3 }, // 584
  { PseudoVFCLASS_V_M8_TU, VFCLASS_V, 0x3 }, // 585
  { PseudoVFCLASS_V_MF4, VFCLASS_V, 0x6 }, // 586
  { PseudoVFCLASS_V_MF4_MASK, VFCLASS_V, 0x6 }, // 587
  { PseudoVFCLASS_V_MF4_TU, VFCLASS_V, 0x6 }, // 588
  { PseudoVFCLASS_V_MF2, VFCLASS_V, 0x7 }, // 589
  { PseudoVFCLASS_V_MF2_MASK, VFCLASS_V, 0x7 }, // 590
  { PseudoVFCLASS_V_MF2_TU, VFCLASS_V, 0x7 }, // 591
  { PseudoVFCVT_F_XU_V_M1, VFCVT_F_XU_V, 0x0 }, // 592
  { PseudoVFCVT_F_XU_V_M1_MASK, VFCVT_F_XU_V, 0x0 }, // 593
  { PseudoVFCVT_F_XU_V_M1_TU, VFCVT_F_XU_V, 0x0 }, // 594
  { PseudoVFCVT_F_XU_V_M2, VFCVT_F_XU_V, 0x1 }, // 595
  { PseudoVFCVT_F_XU_V_M2_MASK, VFCVT_F_XU_V, 0x1 }, // 596
  { PseudoVFCVT_F_XU_V_M2_TU, VFCVT_F_XU_V, 0x1 }, // 597
  { PseudoVFCVT_F_XU_V_M4, VFCVT_F_XU_V, 0x2 }, // 598
  { PseudoVFCVT_F_XU_V_M4_MASK, VFCVT_F_XU_V, 0x2 }, // 599
  { PseudoVFCVT_F_XU_V_M4_TU, VFCVT_F_XU_V, 0x2 }, // 600
  { PseudoVFCVT_F_XU_V_M8, VFCVT_F_XU_V, 0x3 }, // 601
  { PseudoVFCVT_F_XU_V_M8_MASK, VFCVT_F_XU_V, 0x3 }, // 602
  { PseudoVFCVT_F_XU_V_M8_TU, VFCVT_F_XU_V, 0x3 }, // 603
  { PseudoVFCVT_F_XU_V_MF4, VFCVT_F_XU_V, 0x6 }, // 604
  { PseudoVFCVT_F_XU_V_MF4_MASK, VFCVT_F_XU_V, 0x6 }, // 605
  { PseudoVFCVT_F_XU_V_MF4_TU, VFCVT_F_XU_V, 0x6 }, // 606
  { PseudoVFCVT_F_XU_V_MF2, VFCVT_F_XU_V, 0x7 }, // 607
  { PseudoVFCVT_F_XU_V_MF2_MASK, VFCVT_F_XU_V, 0x7 }, // 608
  { PseudoVFCVT_F_XU_V_MF2_TU, VFCVT_F_XU_V, 0x7 }, // 609
  { PseudoVFCVT_F_X_V_M1, VFCVT_F_X_V, 0x0 }, // 610
  { PseudoVFCVT_F_X_V_M1_MASK, VFCVT_F_X_V, 0x0 }, // 611
  { PseudoVFCVT_F_X_V_M1_TU, VFCVT_F_X_V, 0x0 }, // 612
  { PseudoVFCVT_F_X_V_M2, VFCVT_F_X_V, 0x1 }, // 613
  { PseudoVFCVT_F_X_V_M2_MASK, VFCVT_F_X_V, 0x1 }, // 614
  { PseudoVFCVT_F_X_V_M2_TU, VFCVT_F_X_V, 0x1 }, // 615
  { PseudoVFCVT_F_X_V_M4, VFCVT_F_X_V, 0x2 }, // 616
  { PseudoVFCVT_F_X_V_M4_MASK, VFCVT_F_X_V, 0x2 }, // 617
  { PseudoVFCVT_F_X_V_M4_TU, VFCVT_F_X_V, 0x2 }, // 618
  { PseudoVFCVT_F_X_V_M8, VFCVT_F_X_V, 0x3 }, // 619
  { PseudoVFCVT_F_X_V_M8_MASK, VFCVT_F_X_V, 0x3 }, // 620
  { PseudoVFCVT_F_X_V_M8_TU, VFCVT_F_X_V, 0x3 }, // 621
  { PseudoVFCVT_F_X_V_MF4, VFCVT_F_X_V, 0x6 }, // 622
  { PseudoVFCVT_F_X_V_MF4_MASK, VFCVT_F_X_V, 0x6 }, // 623
  { PseudoVFCVT_F_X_V_MF4_TU, VFCVT_F_X_V, 0x6 }, // 624
  { PseudoVFCVT_F_X_V_MF2, VFCVT_F_X_V, 0x7 }, // 625
  { PseudoVFCVT_F_X_V_MF2_MASK, VFCVT_F_X_V, 0x7 }, // 626
  { PseudoVFCVT_F_X_V_MF2_TU, VFCVT_F_X_V, 0x7 }, // 627
  { PseudoVFCVT_RTZ_XU_F_V_M1, VFCVT_RTZ_XU_F_V, 0x0 }, // 628
  { PseudoVFCVT_RTZ_XU_F_V_M1_MASK, VFCVT_RTZ_XU_F_V, 0x0 }, // 629
  { PseudoVFCVT_RTZ_XU_F_V_M1_TU, VFCVT_RTZ_XU_F_V, 0x0 }, // 630
  { PseudoVFCVT_RTZ_XU_F_V_M2, VFCVT_RTZ_XU_F_V, 0x1 }, // 631
  { PseudoVFCVT_RTZ_XU_F_V_M2_MASK, VFCVT_RTZ_XU_F_V, 0x1 }, // 632
  { PseudoVFCVT_RTZ_XU_F_V_M2_TU, VFCVT_RTZ_XU_F_V, 0x1 }, // 633
  { PseudoVFCVT_RTZ_XU_F_V_M4, VFCVT_RTZ_XU_F_V, 0x2 }, // 634
  { PseudoVFCVT_RTZ_XU_F_V_M4_MASK, VFCVT_RTZ_XU_F_V, 0x2 }, // 635
  { PseudoVFCVT_RTZ_XU_F_V_M4_TU, VFCVT_RTZ_XU_F_V, 0x2 }, // 636
  { PseudoVFCVT_RTZ_XU_F_V_M8, VFCVT_RTZ_XU_F_V, 0x3 }, // 637
  { PseudoVFCVT_RTZ_XU_F_V_M8_MASK, VFCVT_RTZ_XU_F_V, 0x3 }, // 638
  { PseudoVFCVT_RTZ_XU_F_V_M8_TU, VFCVT_RTZ_XU_F_V, 0x3 }, // 639
  { PseudoVFCVT_RTZ_XU_F_V_MF4, VFCVT_RTZ_XU_F_V, 0x6 }, // 640
  { PseudoVFCVT_RTZ_XU_F_V_MF4_MASK, VFCVT_RTZ_XU_F_V, 0x6 }, // 641
  { PseudoVFCVT_RTZ_XU_F_V_MF4_TU, VFCVT_RTZ_XU_F_V, 0x6 }, // 642
  { PseudoVFCVT_RTZ_XU_F_V_MF2, VFCVT_RTZ_XU_F_V, 0x7 }, // 643
  { PseudoVFCVT_RTZ_XU_F_V_MF2_MASK, VFCVT_RTZ_XU_F_V, 0x7 }, // 644
  { PseudoVFCVT_RTZ_XU_F_V_MF2_TU, VFCVT_RTZ_XU_F_V, 0x7 }, // 645
  { PseudoVFCVT_RTZ_X_F_V_M1, VFCVT_RTZ_X_F_V, 0x0 }, // 646
  { PseudoVFCVT_RTZ_X_F_V_M1_MASK, VFCVT_RTZ_X_F_V, 0x0 }, // 647
  { PseudoVFCVT_RTZ_X_F_V_M1_TU, VFCVT_RTZ_X_F_V, 0x0 }, // 648
  { PseudoVFCVT_RTZ_X_F_V_M2, VFCVT_RTZ_X_F_V, 0x1 }, // 649
  { PseudoVFCVT_RTZ_X_F_V_M2_MASK, VFCVT_RTZ_X_F_V, 0x1 }, // 650
  { PseudoVFCVT_RTZ_X_F_V_M2_TU, VFCVT_RTZ_X_F_V, 0x1 }, // 651
  { PseudoVFCVT_RTZ_X_F_V_M4, VFCVT_RTZ_X_F_V, 0x2 }, // 652
  { PseudoVFCVT_RTZ_X_F_V_M4_MASK, VFCVT_RTZ_X_F_V, 0x2 }, // 653
  { PseudoVFCVT_RTZ_X_F_V_M4_TU, VFCVT_RTZ_X_F_V, 0x2 }, // 654
  { PseudoVFCVT_RTZ_X_F_V_M8, VFCVT_RTZ_X_F_V, 0x3 }, // 655
  { PseudoVFCVT_RTZ_X_F_V_M8_MASK, VFCVT_RTZ_X_F_V, 0x3 }, // 656
  { PseudoVFCVT_RTZ_X_F_V_M8_TU, VFCVT_RTZ_X_F_V, 0x3 }, // 657
  { PseudoVFCVT_RTZ_X_F_V_MF4, VFCVT_RTZ_X_F_V, 0x6 }, // 658
  { PseudoVFCVT_RTZ_X_F_V_MF4_MASK, VFCVT_RTZ_X_F_V, 0x6 }, // 659
  { PseudoVFCVT_RTZ_X_F_V_MF4_TU, VFCVT_RTZ_X_F_V, 0x6 }, // 660
  { PseudoVFCVT_RTZ_X_F_V_MF2, VFCVT_RTZ_X_F_V, 0x7 }, // 661
  { PseudoVFCVT_RTZ_X_F_V_MF2_MASK, VFCVT_RTZ_X_F_V, 0x7 }, // 662
  { PseudoVFCVT_RTZ_X_F_V_MF2_TU, VFCVT_RTZ_X_F_V, 0x7 }, // 663
  { PseudoVFCVT_XU_F_V_M1, VFCVT_XU_F_V, 0x0 }, // 664
  { PseudoVFCVT_XU_F_V_M1_MASK, VFCVT_XU_F_V, 0x0 }, // 665
  { PseudoVFCVT_XU_F_V_M1_TU, VFCVT_XU_F_V, 0x0 }, // 666
  { PseudoVFCVT_XU_F_V_M2, VFCVT_XU_F_V, 0x1 }, // 667
  { PseudoVFCVT_XU_F_V_M2_MASK, VFCVT_XU_F_V, 0x1 }, // 668
  { PseudoVFCVT_XU_F_V_M2_TU, VFCVT_XU_F_V, 0x1 }, // 669
  { PseudoVFCVT_XU_F_V_M4, VFCVT_XU_F_V, 0x2 }, // 670
  { PseudoVFCVT_XU_F_V_M4_MASK, VFCVT_XU_F_V, 0x2 }, // 671
  { PseudoVFCVT_XU_F_V_M4_TU, VFCVT_XU_F_V, 0x2 }, // 672
  { PseudoVFCVT_XU_F_V_M8, VFCVT_XU_F_V, 0x3 }, // 673
  { PseudoVFCVT_XU_F_V_M8_MASK, VFCVT_XU_F_V, 0x3 }, // 674
  { PseudoVFCVT_XU_F_V_M8_TU, VFCVT_XU_F_V, 0x3 }, // 675
  { PseudoVFCVT_XU_F_V_MF4, VFCVT_XU_F_V, 0x6 }, // 676
  { PseudoVFCVT_XU_F_V_MF4_MASK, VFCVT_XU_F_V, 0x6 }, // 677
  { PseudoVFCVT_XU_F_V_MF4_TU, VFCVT_XU_F_V, 0x6 }, // 678
  { PseudoVFCVT_XU_F_V_MF2, VFCVT_XU_F_V, 0x7 }, // 679
  { PseudoVFCVT_XU_F_V_MF2_MASK, VFCVT_XU_F_V, 0x7 }, // 680
  { PseudoVFCVT_XU_F_V_MF2_TU, VFCVT_XU_F_V, 0x7 }, // 681
  { PseudoVFCVT_X_F_V_M1, VFCVT_X_F_V, 0x0 }, // 682
  { PseudoVFCVT_X_F_V_M1_MASK, VFCVT_X_F_V, 0x0 }, // 683
  { PseudoVFCVT_X_F_V_M1_TU, VFCVT_X_F_V, 0x0 }, // 684
  { PseudoVFCVT_X_F_V_M2, VFCVT_X_F_V, 0x1 }, // 685
  { PseudoVFCVT_X_F_V_M2_MASK, VFCVT_X_F_V, 0x1 }, // 686
  { PseudoVFCVT_X_F_V_M2_TU, VFCVT_X_F_V, 0x1 }, // 687
  { PseudoVFCVT_X_F_V_M4, VFCVT_X_F_V, 0x2 }, // 688
  { PseudoVFCVT_X_F_V_M4_MASK, VFCVT_X_F_V, 0x2 }, // 689
  { PseudoVFCVT_X_F_V_M4_TU, VFCVT_X_F_V, 0x2 }, // 690
  { PseudoVFCVT_X_F_V_M8, VFCVT_X_F_V, 0x3 }, // 691
  { PseudoVFCVT_X_F_V_M8_MASK, VFCVT_X_F_V, 0x3 }, // 692
  { PseudoVFCVT_X_F_V_M8_TU, VFCVT_X_F_V, 0x3 }, // 693
  { PseudoVFCVT_X_F_V_MF4, VFCVT_X_F_V, 0x6 }, // 694
  { PseudoVFCVT_X_F_V_MF4_MASK, VFCVT_X_F_V, 0x6 }, // 695
  { PseudoVFCVT_X_F_V_MF4_TU, VFCVT_X_F_V, 0x6 }, // 696
  { PseudoVFCVT_X_F_V_MF2, VFCVT_X_F_V, 0x7 }, // 697
  { PseudoVFCVT_X_F_V_MF2_MASK, VFCVT_X_F_V, 0x7 }, // 698
  { PseudoVFCVT_X_F_V_MF2_TU, VFCVT_X_F_V, 0x7 }, // 699
  { PseudoVFDIV_VF16_M1, VFDIV_VF, 0x0 }, // 700
  { PseudoVFDIV_VF16_M1_MASK, VFDIV_VF, 0x0 }, // 701
  { PseudoVFDIV_VF16_M1_TU, VFDIV_VF, 0x0 }, // 702
  { PseudoVFDIV_VF32_M1, VFDIV_VF, 0x0 }, // 703
  { PseudoVFDIV_VF32_M1_MASK, VFDIV_VF, 0x0 }, // 704
  { PseudoVFDIV_VF32_M1_TU, VFDIV_VF, 0x0 }, // 705
  { PseudoVFDIV_VF64_M1, VFDIV_VF, 0x0 }, // 706
  { PseudoVFDIV_VF64_M1_MASK, VFDIV_VF, 0x0 }, // 707
  { PseudoVFDIV_VF64_M1_TU, VFDIV_VF, 0x0 }, // 708
  { PseudoVFDIV_VF16_M2, VFDIV_VF, 0x1 }, // 709
  { PseudoVFDIV_VF16_M2_MASK, VFDIV_VF, 0x1 }, // 710
  { PseudoVFDIV_VF16_M2_TU, VFDIV_VF, 0x1 }, // 711
  { PseudoVFDIV_VF32_M2, VFDIV_VF, 0x1 }, // 712
  { PseudoVFDIV_VF32_M2_MASK, VFDIV_VF, 0x1 }, // 713
  { PseudoVFDIV_VF32_M2_TU, VFDIV_VF, 0x1 }, // 714
  { PseudoVFDIV_VF64_M2, VFDIV_VF, 0x1 }, // 715
  { PseudoVFDIV_VF64_M2_MASK, VFDIV_VF, 0x1 }, // 716
  { PseudoVFDIV_VF64_M2_TU, VFDIV_VF, 0x1 }, // 717
  { PseudoVFDIV_VF16_M4, VFDIV_VF, 0x2 }, // 718
  { PseudoVFDIV_VF16_M4_MASK, VFDIV_VF, 0x2 }, // 719
  { PseudoVFDIV_VF16_M4_TU, VFDIV_VF, 0x2 }, // 720
  { PseudoVFDIV_VF32_M4, VFDIV_VF, 0x2 }, // 721
  { PseudoVFDIV_VF32_M4_MASK, VFDIV_VF, 0x2 }, // 722
  { PseudoVFDIV_VF32_M4_TU, VFDIV_VF, 0x2 }, // 723
  { PseudoVFDIV_VF64_M4, VFDIV_VF, 0x2 }, // 724
  { PseudoVFDIV_VF64_M4_MASK, VFDIV_VF, 0x2 }, // 725
  { PseudoVFDIV_VF64_M4_TU, VFDIV_VF, 0x2 }, // 726
  { PseudoVFDIV_VF16_M8, VFDIV_VF, 0x3 }, // 727
  { PseudoVFDIV_VF16_M8_MASK, VFDIV_VF, 0x3 }, // 728
  { PseudoVFDIV_VF16_M8_TU, VFDIV_VF, 0x3 }, // 729
  { PseudoVFDIV_VF32_M8, VFDIV_VF, 0x3 }, // 730
  { PseudoVFDIV_VF32_M8_MASK, VFDIV_VF, 0x3 }, // 731
  { PseudoVFDIV_VF32_M8_TU, VFDIV_VF, 0x3 }, // 732
  { PseudoVFDIV_VF64_M8, VFDIV_VF, 0x3 }, // 733
  { PseudoVFDIV_VF64_M8_MASK, VFDIV_VF, 0x3 }, // 734
  { PseudoVFDIV_VF64_M8_TU, VFDIV_VF, 0x3 }, // 735
  { PseudoVFDIV_VF16_MF4, VFDIV_VF, 0x6 }, // 736
  { PseudoVFDIV_VF16_MF4_MASK, VFDIV_VF, 0x6 }, // 737
  { PseudoVFDIV_VF16_MF4_TU, VFDIV_VF, 0x6 }, // 738
  { PseudoVFDIV_VF16_MF2, VFDIV_VF, 0x7 }, // 739
  { PseudoVFDIV_VF16_MF2_MASK, VFDIV_VF, 0x7 }, // 740
  { PseudoVFDIV_VF16_MF2_TU, VFDIV_VF, 0x7 }, // 741
  { PseudoVFDIV_VF32_MF2, VFDIV_VF, 0x7 }, // 742
  { PseudoVFDIV_VF32_MF2_MASK, VFDIV_VF, 0x7 }, // 743
  { PseudoVFDIV_VF32_MF2_TU, VFDIV_VF, 0x7 }, // 744
  { PseudoVFDIV_VV_M1, VFDIV_VV, 0x0 }, // 745
  { PseudoVFDIV_VV_M1_MASK, VFDIV_VV, 0x0 }, // 746
  { PseudoVFDIV_VV_M1_TU, VFDIV_VV, 0x0 }, // 747
  { PseudoVFDIV_VV_M2, VFDIV_VV, 0x1 }, // 748
  { PseudoVFDIV_VV_M2_MASK, VFDIV_VV, 0x1 }, // 749
  { PseudoVFDIV_VV_M2_TU, VFDIV_VV, 0x1 }, // 750
  { PseudoVFDIV_VV_M4, VFDIV_VV, 0x2 }, // 751
  { PseudoVFDIV_VV_M4_MASK, VFDIV_VV, 0x2 }, // 752
  { PseudoVFDIV_VV_M4_TU, VFDIV_VV, 0x2 }, // 753
  { PseudoVFDIV_VV_M8, VFDIV_VV, 0x3 }, // 754
  { PseudoVFDIV_VV_M8_MASK, VFDIV_VV, 0x3 }, // 755
  { PseudoVFDIV_VV_M8_TU, VFDIV_VV, 0x3 }, // 756
  { PseudoVFDIV_VV_MF4, VFDIV_VV, 0x6 }, // 757
  { PseudoVFDIV_VV_MF4_MASK, VFDIV_VV, 0x6 }, // 758
  { PseudoVFDIV_VV_MF4_TU, VFDIV_VV, 0x6 }, // 759
  { PseudoVFDIV_VV_MF2, VFDIV_VV, 0x7 }, // 760
  { PseudoVFDIV_VV_MF2_MASK, VFDIV_VV, 0x7 }, // 761
  { PseudoVFDIV_VV_MF2_TU, VFDIV_VV, 0x7 }, // 762
  { PseudoVFIRST_M_B8, VFIRST_M, 0x0 }, // 763
  { PseudoVFIRST_M_B8_MASK, VFIRST_M, 0x0 }, // 764
  { PseudoVFIRST_M_B16, VFIRST_M, 0x1 }, // 765
  { PseudoVFIRST_M_B16_MASK, VFIRST_M, 0x1 }, // 766
  { PseudoVFIRST_M_B32, VFIRST_M, 0x2 }, // 767
  { PseudoVFIRST_M_B32_MASK, VFIRST_M, 0x2 }, // 768
  { PseudoVFIRST_M_B64, VFIRST_M, 0x3 }, // 769
  { PseudoVFIRST_M_B64_MASK, VFIRST_M, 0x3 }, // 770
  { PseudoVFIRST_M_B1, VFIRST_M, 0x5 }, // 771
  { PseudoVFIRST_M_B1_MASK, VFIRST_M, 0x5 }, // 772
  { PseudoVFIRST_M_B2, VFIRST_M, 0x6 }, // 773
  { PseudoVFIRST_M_B2_MASK, VFIRST_M, 0x6 }, // 774
  { PseudoVFIRST_M_B4, VFIRST_M, 0x7 }, // 775
  { PseudoVFIRST_M_B4_MASK, VFIRST_M, 0x7 }, // 776
  { PseudoVFMACC_VF16_M1, VFMACC_VF, 0x0 }, // 777
  { PseudoVFMACC_VF16_M1_MASK, VFMACC_VF, 0x0 }, // 778
  { PseudoVFMACC_VF32_M1, VFMACC_VF, 0x0 }, // 779
  { PseudoVFMACC_VF32_M1_MASK, VFMACC_VF, 0x0 }, // 780
  { PseudoVFMACC_VF64_M1, VFMACC_VF, 0x0 }, // 781
  { PseudoVFMACC_VF64_M1_MASK, VFMACC_VF, 0x0 }, // 782
  { PseudoVFMACC_VF16_M2, VFMACC_VF, 0x1 }, // 783
  { PseudoVFMACC_VF16_M2_MASK, VFMACC_VF, 0x1 }, // 784
  { PseudoVFMACC_VF32_M2, VFMACC_VF, 0x1 }, // 785
  { PseudoVFMACC_VF32_M2_MASK, VFMACC_VF, 0x1 }, // 786
  { PseudoVFMACC_VF64_M2, VFMACC_VF, 0x1 }, // 787
  { PseudoVFMACC_VF64_M2_MASK, VFMACC_VF, 0x1 }, // 788
  { PseudoVFMACC_VF16_M4, VFMACC_VF, 0x2 }, // 789
  { PseudoVFMACC_VF16_M4_MASK, VFMACC_VF, 0x2 }, // 790
  { PseudoVFMACC_VF32_M4, VFMACC_VF, 0x2 }, // 791
  { PseudoVFMACC_VF32_M4_MASK, VFMACC_VF, 0x2 }, // 792
  { PseudoVFMACC_VF64_M4, VFMACC_VF, 0x2 }, // 793
  { PseudoVFMACC_VF64_M4_MASK, VFMACC_VF, 0x2 }, // 794
  { PseudoVFMACC_VF16_M8, VFMACC_VF, 0x3 }, // 795
  { PseudoVFMACC_VF16_M8_MASK, VFMACC_VF, 0x3 }, // 796
  { PseudoVFMACC_VF32_M8, VFMACC_VF, 0x3 }, // 797
  { PseudoVFMACC_VF32_M8_MASK, VFMACC_VF, 0x3 }, // 798
  { PseudoVFMACC_VF64_M8, VFMACC_VF, 0x3 }, // 799
  { PseudoVFMACC_VF64_M8_MASK, VFMACC_VF, 0x3 }, // 800
  { PseudoVFMACC_VF16_MF4, VFMACC_VF, 0x6 }, // 801
  { PseudoVFMACC_VF16_MF4_MASK, VFMACC_VF, 0x6 }, // 802
  { PseudoVFMACC_VF16_MF2, VFMACC_VF, 0x7 }, // 803
  { PseudoVFMACC_VF16_MF2_MASK, VFMACC_VF, 0x7 }, // 804
  { PseudoVFMACC_VF32_MF2, VFMACC_VF, 0x7 }, // 805
  { PseudoVFMACC_VF32_MF2_MASK, VFMACC_VF, 0x7 }, // 806
  { PseudoVFMACC_VV_M1, VFMACC_VV, 0x0 }, // 807
  { PseudoVFMACC_VV_M1_MASK, VFMACC_VV, 0x0 }, // 808
  { PseudoVFMACC_VV_M2, VFMACC_VV, 0x1 }, // 809
  { PseudoVFMACC_VV_M2_MASK, VFMACC_VV, 0x1 }, // 810
  { PseudoVFMACC_VV_M4, VFMACC_VV, 0x2 }, // 811
  { PseudoVFMACC_VV_M4_MASK, VFMACC_VV, 0x2 }, // 812
  { PseudoVFMACC_VV_M8, VFMACC_VV, 0x3 }, // 813
  { PseudoVFMACC_VV_M8_MASK, VFMACC_VV, 0x3 }, // 814
  { PseudoVFMACC_VV_MF4, VFMACC_VV, 0x6 }, // 815
  { PseudoVFMACC_VV_MF4_MASK, VFMACC_VV, 0x6 }, // 816
  { PseudoVFMACC_VV_MF2, VFMACC_VV, 0x7 }, // 817
  { PseudoVFMACC_VV_MF2_MASK, VFMACC_VV, 0x7 }, // 818
  { PseudoVFMADD_VF16_M1, VFMADD_VF, 0x0 }, // 819
  { PseudoVFMADD_VF16_M1_MASK, VFMADD_VF, 0x0 }, // 820
  { PseudoVFMADD_VF32_M1, VFMADD_VF, 0x0 }, // 821
  { PseudoVFMADD_VF32_M1_MASK, VFMADD_VF, 0x0 }, // 822
  { PseudoVFMADD_VF64_M1, VFMADD_VF, 0x0 }, // 823
  { PseudoVFMADD_VF64_M1_MASK, VFMADD_VF, 0x0 }, // 824
  { PseudoVFMADD_VF16_M2, VFMADD_VF, 0x1 }, // 825
  { PseudoVFMADD_VF16_M2_MASK, VFMADD_VF, 0x1 }, // 826
  { PseudoVFMADD_VF32_M2, VFMADD_VF, 0x1 }, // 827
  { PseudoVFMADD_VF32_M2_MASK, VFMADD_VF, 0x1 }, // 828
  { PseudoVFMADD_VF64_M2, VFMADD_VF, 0x1 }, // 829
  { PseudoVFMADD_VF64_M2_MASK, VFMADD_VF, 0x1 }, // 830
  { PseudoVFMADD_VF16_M4, VFMADD_VF, 0x2 }, // 831
  { PseudoVFMADD_VF16_M4_MASK, VFMADD_VF, 0x2 }, // 832
  { PseudoVFMADD_VF32_M4, VFMADD_VF, 0x2 }, // 833
  { PseudoVFMADD_VF32_M4_MASK, VFMADD_VF, 0x2 }, // 834
  { PseudoVFMADD_VF64_M4, VFMADD_VF, 0x2 }, // 835
  { PseudoVFMADD_VF64_M4_MASK, VFMADD_VF, 0x2 }, // 836
  { PseudoVFMADD_VF16_M8, VFMADD_VF, 0x3 }, // 837
  { PseudoVFMADD_VF16_M8_MASK, VFMADD_VF, 0x3 }, // 838
  { PseudoVFMADD_VF32_M8, VFMADD_VF, 0x3 }, // 839
  { PseudoVFMADD_VF32_M8_MASK, VFMADD_VF, 0x3 }, // 840
  { PseudoVFMADD_VF64_M8, VFMADD_VF, 0x3 }, // 841
  { PseudoVFMADD_VF64_M8_MASK, VFMADD_VF, 0x3 }, // 842
  { PseudoVFMADD_VF16_MF4, VFMADD_VF, 0x6 }, // 843
  { PseudoVFMADD_VF16_MF4_MASK, VFMADD_VF, 0x6 }, // 844
  { PseudoVFMADD_VF16_MF2, VFMADD_VF, 0x7 }, // 845
  { PseudoVFMADD_VF16_MF2_MASK, VFMADD_VF, 0x7 }, // 846
  { PseudoVFMADD_VF32_MF2, VFMADD_VF, 0x7 }, // 847
  { PseudoVFMADD_VF32_MF2_MASK, VFMADD_VF, 0x7 }, // 848
  { PseudoVFMADD_VV_M1, VFMADD_VV, 0x0 }, // 849
  { PseudoVFMADD_VV_M1_MASK, VFMADD_VV, 0x0 }, // 850
  { PseudoVFMADD_VV_M2, VFMADD_VV, 0x1 }, // 851
  { PseudoVFMADD_VV_M2_MASK, VFMADD_VV, 0x1 }, // 852
  { PseudoVFMADD_VV_M4, VFMADD_VV, 0x2 }, // 853
  { PseudoVFMADD_VV_M4_MASK, VFMADD_VV, 0x2 }, // 854
  { PseudoVFMADD_VV_M8, VFMADD_VV, 0x3 }, // 855
  { PseudoVFMADD_VV_M8_MASK, VFMADD_VV, 0x3 }, // 856
  { PseudoVFMADD_VV_MF4, VFMADD_VV, 0x6 }, // 857
  { PseudoVFMADD_VV_MF4_MASK, VFMADD_VV, 0x6 }, // 858
  { PseudoVFMADD_VV_MF2, VFMADD_VV, 0x7 }, // 859
  { PseudoVFMADD_VV_MF2_MASK, VFMADD_VV, 0x7 }, // 860
  { PseudoVFMAX_VF16_M1, VFMAX_VF, 0x0 }, // 861
  { PseudoVFMAX_VF16_M1_MASK, VFMAX_VF, 0x0 }, // 862
  { PseudoVFMAX_VF16_M1_TU, VFMAX_VF, 0x0 }, // 863
  { PseudoVFMAX_VF32_M1, VFMAX_VF, 0x0 }, // 864
  { PseudoVFMAX_VF32_M1_MASK, VFMAX_VF, 0x0 }, // 865
  { PseudoVFMAX_VF32_M1_TU, VFMAX_VF, 0x0 }, // 866
  { PseudoVFMAX_VF64_M1, VFMAX_VF, 0x0 }, // 867
  { PseudoVFMAX_VF64_M1_MASK, VFMAX_VF, 0x0 }, // 868
  { PseudoVFMAX_VF64_M1_TU, VFMAX_VF, 0x0 }, // 869
  { PseudoVFMAX_VF16_M2, VFMAX_VF, 0x1 }, // 870
  { PseudoVFMAX_VF16_M2_MASK, VFMAX_VF, 0x1 }, // 871
  { PseudoVFMAX_VF16_M2_TU, VFMAX_VF, 0x1 }, // 872
  { PseudoVFMAX_VF32_M2, VFMAX_VF, 0x1 }, // 873
  { PseudoVFMAX_VF32_M2_MASK, VFMAX_VF, 0x1 }, // 874
  { PseudoVFMAX_VF32_M2_TU, VFMAX_VF, 0x1 }, // 875
  { PseudoVFMAX_VF64_M2, VFMAX_VF, 0x1 }, // 876
  { PseudoVFMAX_VF64_M2_MASK, VFMAX_VF, 0x1 }, // 877
  { PseudoVFMAX_VF64_M2_TU, VFMAX_VF, 0x1 }, // 878
  { PseudoVFMAX_VF16_M4, VFMAX_VF, 0x2 }, // 879
  { PseudoVFMAX_VF16_M4_MASK, VFMAX_VF, 0x2 }, // 880
  { PseudoVFMAX_VF16_M4_TU, VFMAX_VF, 0x2 }, // 881
  { PseudoVFMAX_VF32_M4, VFMAX_VF, 0x2 }, // 882
  { PseudoVFMAX_VF32_M4_MASK, VFMAX_VF, 0x2 }, // 883
  { PseudoVFMAX_VF32_M4_TU, VFMAX_VF, 0x2 }, // 884
  { PseudoVFMAX_VF64_M4, VFMAX_VF, 0x2 }, // 885
  { PseudoVFMAX_VF64_M4_MASK, VFMAX_VF, 0x2 }, // 886
  { PseudoVFMAX_VF64_M4_TU, VFMAX_VF, 0x2 }, // 887
  { PseudoVFMAX_VF16_M8, VFMAX_VF, 0x3 }, // 888
  { PseudoVFMAX_VF16_M8_MASK, VFMAX_VF, 0x3 }, // 889
  { PseudoVFMAX_VF16_M8_TU, VFMAX_VF, 0x3 }, // 890
  { PseudoVFMAX_VF32_M8, VFMAX_VF, 0x3 }, // 891
  { PseudoVFMAX_VF32_M8_MASK, VFMAX_VF, 0x3 }, // 892
  { PseudoVFMAX_VF32_M8_TU, VFMAX_VF, 0x3 }, // 893
  { PseudoVFMAX_VF64_M8, VFMAX_VF, 0x3 }, // 894
  { PseudoVFMAX_VF64_M8_MASK, VFMAX_VF, 0x3 }, // 895
  { PseudoVFMAX_VF64_M8_TU, VFMAX_VF, 0x3 }, // 896
  { PseudoVFMAX_VF16_MF4, VFMAX_VF, 0x6 }, // 897
  { PseudoVFMAX_VF16_MF4_MASK, VFMAX_VF, 0x6 }, // 898
  { PseudoVFMAX_VF16_MF4_TU, VFMAX_VF, 0x6 }, // 899
  { PseudoVFMAX_VF16_MF2, VFMAX_VF, 0x7 }, // 900
  { PseudoVFMAX_VF16_MF2_MASK, VFMAX_VF, 0x7 }, // 901
  { PseudoVFMAX_VF16_MF2_TU, VFMAX_VF, 0x7 }, // 902
  { PseudoVFMAX_VF32_MF2, VFMAX_VF, 0x7 }, // 903
  { PseudoVFMAX_VF32_MF2_MASK, VFMAX_VF, 0x7 }, // 904
  { PseudoVFMAX_VF32_MF2_TU, VFMAX_VF, 0x7 }, // 905
  { PseudoVFMAX_VV_M1, VFMAX_VV, 0x0 }, // 906
  { PseudoVFMAX_VV_M1_MASK, VFMAX_VV, 0x0 }, // 907
  { PseudoVFMAX_VV_M1_TU, VFMAX_VV, 0x0 }, // 908
  { PseudoVFMAX_VV_M2, VFMAX_VV, 0x1 }, // 909
  { PseudoVFMAX_VV_M2_MASK, VFMAX_VV, 0x1 }, // 910
  { PseudoVFMAX_VV_M2_TU, VFMAX_VV, 0x1 }, // 911
  { PseudoVFMAX_VV_M4, VFMAX_VV, 0x2 }, // 912
  { PseudoVFMAX_VV_M4_MASK, VFMAX_VV, 0x2 }, // 913
  { PseudoVFMAX_VV_M4_TU, VFMAX_VV, 0x2 }, // 914
  { PseudoVFMAX_VV_M8, VFMAX_VV, 0x3 }, // 915
  { PseudoVFMAX_VV_M8_MASK, VFMAX_VV, 0x3 }, // 916
  { PseudoVFMAX_VV_M8_TU, VFMAX_VV, 0x3 }, // 917
  { PseudoVFMAX_VV_MF4, VFMAX_VV, 0x6 }, // 918
  { PseudoVFMAX_VV_MF4_MASK, VFMAX_VV, 0x6 }, // 919
  { PseudoVFMAX_VV_MF4_TU, VFMAX_VV, 0x6 }, // 920
  { PseudoVFMAX_VV_MF2, VFMAX_VV, 0x7 }, // 921
  { PseudoVFMAX_VV_MF2_MASK, VFMAX_VV, 0x7 }, // 922
  { PseudoVFMAX_VV_MF2_TU, VFMAX_VV, 0x7 }, // 923
  { PseudoVFMERGE_VF16M_M1, VFMERGE_VFM, 0x0 }, // 924
  { PseudoVFMERGE_VF16M_M1_TU, VFMERGE_VFM, 0x0 }, // 925
  { PseudoVFMERGE_VF32M_M1, VFMERGE_VFM, 0x0 }, // 926
  { PseudoVFMERGE_VF32M_M1_TU, VFMERGE_VFM, 0x0 }, // 927
  { PseudoVFMERGE_VF64M_M1, VFMERGE_VFM, 0x0 }, // 928
  { PseudoVFMERGE_VF64M_M1_TU, VFMERGE_VFM, 0x0 }, // 929
  { PseudoVFMERGE_VF16M_M2, VFMERGE_VFM, 0x1 }, // 930
  { PseudoVFMERGE_VF16M_M2_TU, VFMERGE_VFM, 0x1 }, // 931
  { PseudoVFMERGE_VF32M_M2, VFMERGE_VFM, 0x1 }, // 932
  { PseudoVFMERGE_VF32M_M2_TU, VFMERGE_VFM, 0x1 }, // 933
  { PseudoVFMERGE_VF64M_M2, VFMERGE_VFM, 0x1 }, // 934
  { PseudoVFMERGE_VF64M_M2_TU, VFMERGE_VFM, 0x1 }, // 935
  { PseudoVFMERGE_VF16M_M4, VFMERGE_VFM, 0x2 }, // 936
  { PseudoVFMERGE_VF16M_M4_TU, VFMERGE_VFM, 0x2 }, // 937
  { PseudoVFMERGE_VF32M_M4, VFMERGE_VFM, 0x2 }, // 938
  { PseudoVFMERGE_VF32M_M4_TU, VFMERGE_VFM, 0x2 }, // 939
  { PseudoVFMERGE_VF64M_M4, VFMERGE_VFM, 0x2 }, // 940
  { PseudoVFMERGE_VF64M_M4_TU, VFMERGE_VFM, 0x2 }, // 941
  { PseudoVFMERGE_VF16M_M8, VFMERGE_VFM, 0x3 }, // 942
  { PseudoVFMERGE_VF16M_M8_TU, VFMERGE_VFM, 0x3 }, // 943
  { PseudoVFMERGE_VF32M_M8, VFMERGE_VFM, 0x3 }, // 944
  { PseudoVFMERGE_VF32M_M8_TU, VFMERGE_VFM, 0x3 }, // 945
  { PseudoVFMERGE_VF64M_M8, VFMERGE_VFM, 0x3 }, // 946
  { PseudoVFMERGE_VF64M_M8_TU, VFMERGE_VFM, 0x3 }, // 947
  { PseudoVFMERGE_VF16M_MF4, VFMERGE_VFM, 0x6 }, // 948
  { PseudoVFMERGE_VF16M_MF4_TU, VFMERGE_VFM, 0x6 }, // 949
  { PseudoVFMERGE_VF16M_MF2, VFMERGE_VFM, 0x7 }, // 950
  { PseudoVFMERGE_VF16M_MF2_TU, VFMERGE_VFM, 0x7 }, // 951
  { PseudoVFMERGE_VF32M_MF2, VFMERGE_VFM, 0x7 }, // 952
  { PseudoVFMERGE_VF32M_MF2_TU, VFMERGE_VFM, 0x7 }, // 953
  { PseudoVFMIN_VF16_M1, VFMIN_VF, 0x0 }, // 954
  { PseudoVFMIN_VF16_M1_MASK, VFMIN_VF, 0x0 }, // 955
  { PseudoVFMIN_VF16_M1_TU, VFMIN_VF, 0x0 }, // 956
  { PseudoVFMIN_VF32_M1, VFMIN_VF, 0x0 }, // 957
  { PseudoVFMIN_VF32_M1_MASK, VFMIN_VF, 0x0 }, // 958
  { PseudoVFMIN_VF32_M1_TU, VFMIN_VF, 0x0 }, // 959
  { PseudoVFMIN_VF64_M1, VFMIN_VF, 0x0 }, // 960
  { PseudoVFMIN_VF64_M1_MASK, VFMIN_VF, 0x0 }, // 961
  { PseudoVFMIN_VF64_M1_TU, VFMIN_VF, 0x0 }, // 962
  { PseudoVFMIN_VF16_M2, VFMIN_VF, 0x1 }, // 963
  { PseudoVFMIN_VF16_M2_MASK, VFMIN_VF, 0x1 }, // 964
  { PseudoVFMIN_VF16_M2_TU, VFMIN_VF, 0x1 }, // 965
  { PseudoVFMIN_VF32_M2, VFMIN_VF, 0x1 }, // 966
  { PseudoVFMIN_VF32_M2_MASK, VFMIN_VF, 0x1 }, // 967
  { PseudoVFMIN_VF32_M2_TU, VFMIN_VF, 0x1 }, // 968
  { PseudoVFMIN_VF64_M2, VFMIN_VF, 0x1 }, // 969
  { PseudoVFMIN_VF64_M2_MASK, VFMIN_VF, 0x1 }, // 970
  { PseudoVFMIN_VF64_M2_TU, VFMIN_VF, 0x1 }, // 971
  { PseudoVFMIN_VF16_M4, VFMIN_VF, 0x2 }, // 972
  { PseudoVFMIN_VF16_M4_MASK, VFMIN_VF, 0x2 }, // 973
  { PseudoVFMIN_VF16_M4_TU, VFMIN_VF, 0x2 }, // 974
  { PseudoVFMIN_VF32_M4, VFMIN_VF, 0x2 }, // 975
  { PseudoVFMIN_VF32_M4_MASK, VFMIN_VF, 0x2 }, // 976
  { PseudoVFMIN_VF32_M4_TU, VFMIN_VF, 0x2 }, // 977
  { PseudoVFMIN_VF64_M4, VFMIN_VF, 0x2 }, // 978
  { PseudoVFMIN_VF64_M4_MASK, VFMIN_VF, 0x2 }, // 979
  { PseudoVFMIN_VF64_M4_TU, VFMIN_VF, 0x2 }, // 980
  { PseudoVFMIN_VF16_M8, VFMIN_VF, 0x3 }, // 981
  { PseudoVFMIN_VF16_M8_MASK, VFMIN_VF, 0x3 }, // 982
  { PseudoVFMIN_VF16_M8_TU, VFMIN_VF, 0x3 }, // 983
  { PseudoVFMIN_VF32_M8, VFMIN_VF, 0x3 }, // 984
  { PseudoVFMIN_VF32_M8_MASK, VFMIN_VF, 0x3 }, // 985
  { PseudoVFMIN_VF32_M8_TU, VFMIN_VF, 0x3 }, // 986
  { PseudoVFMIN_VF64_M8, VFMIN_VF, 0x3 }, // 987
  { PseudoVFMIN_VF64_M8_MASK, VFMIN_VF, 0x3 }, // 988
  { PseudoVFMIN_VF64_M8_TU, VFMIN_VF, 0x3 }, // 989
  { PseudoVFMIN_VF16_MF4, VFMIN_VF, 0x6 }, // 990
  { PseudoVFMIN_VF16_MF4_MASK, VFMIN_VF, 0x6 }, // 991
  { PseudoVFMIN_VF16_MF4_TU, VFMIN_VF, 0x6 }, // 992
  { PseudoVFMIN_VF16_MF2, VFMIN_VF, 0x7 }, // 993
  { PseudoVFMIN_VF16_MF2_MASK, VFMIN_VF, 0x7 }, // 994
  { PseudoVFMIN_VF16_MF2_TU, VFMIN_VF, 0x7 }, // 995
  { PseudoVFMIN_VF32_MF2, VFMIN_VF, 0x7 }, // 996
  { PseudoVFMIN_VF32_MF2_MASK, VFMIN_VF, 0x7 }, // 997
  { PseudoVFMIN_VF32_MF2_TU, VFMIN_VF, 0x7 }, // 998
  { PseudoVFMIN_VV_M1, VFMIN_VV, 0x0 }, // 999
  { PseudoVFMIN_VV_M1_MASK, VFMIN_VV, 0x0 }, // 1000
  { PseudoVFMIN_VV_M1_TU, VFMIN_VV, 0x0 }, // 1001
  { PseudoVFMIN_VV_M2, VFMIN_VV, 0x1 }, // 1002
  { PseudoVFMIN_VV_M2_MASK, VFMIN_VV, 0x1 }, // 1003
  { PseudoVFMIN_VV_M2_TU, VFMIN_VV, 0x1 }, // 1004
  { PseudoVFMIN_VV_M4, VFMIN_VV, 0x2 }, // 1005
  { PseudoVFMIN_VV_M4_MASK, VFMIN_VV, 0x2 }, // 1006
  { PseudoVFMIN_VV_M4_TU, VFMIN_VV, 0x2 }, // 1007
  { PseudoVFMIN_VV_M8, VFMIN_VV, 0x3 }, // 1008
  { PseudoVFMIN_VV_M8_MASK, VFMIN_VV, 0x3 }, // 1009
  { PseudoVFMIN_VV_M8_TU, VFMIN_VV, 0x3 }, // 1010
  { PseudoVFMIN_VV_MF4, VFMIN_VV, 0x6 }, // 1011
  { PseudoVFMIN_VV_MF4_MASK, VFMIN_VV, 0x6 }, // 1012
  { PseudoVFMIN_VV_MF4_TU, VFMIN_VV, 0x6 }, // 1013
  { PseudoVFMIN_VV_MF2, VFMIN_VV, 0x7 }, // 1014
  { PseudoVFMIN_VV_MF2_MASK, VFMIN_VV, 0x7 }, // 1015
  { PseudoVFMIN_VV_MF2_TU, VFMIN_VV, 0x7 }, // 1016
  { PseudoVFMSAC_VF16_M1, VFMSAC_VF, 0x0 }, // 1017
  { PseudoVFMSAC_VF16_M1_MASK, VFMSAC_VF, 0x0 }, // 1018
  { PseudoVFMSAC_VF32_M1, VFMSAC_VF, 0x0 }, // 1019
  { PseudoVFMSAC_VF32_M1_MASK, VFMSAC_VF, 0x0 }, // 1020
  { PseudoVFMSAC_VF64_M1, VFMSAC_VF, 0x0 }, // 1021
  { PseudoVFMSAC_VF64_M1_MASK, VFMSAC_VF, 0x0 }, // 1022
  { PseudoVFMSAC_VF16_M2, VFMSAC_VF, 0x1 }, // 1023
  { PseudoVFMSAC_VF16_M2_MASK, VFMSAC_VF, 0x1 }, // 1024
  { PseudoVFMSAC_VF32_M2, VFMSAC_VF, 0x1 }, // 1025
  { PseudoVFMSAC_VF32_M2_MASK, VFMSAC_VF, 0x1 }, // 1026
  { PseudoVFMSAC_VF64_M2, VFMSAC_VF, 0x1 }, // 1027
  { PseudoVFMSAC_VF64_M2_MASK, VFMSAC_VF, 0x1 }, // 1028
  { PseudoVFMSAC_VF16_M4, VFMSAC_VF, 0x2 }, // 1029
  { PseudoVFMSAC_VF16_M4_MASK, VFMSAC_VF, 0x2 }, // 1030
  { PseudoVFMSAC_VF32_M4, VFMSAC_VF, 0x2 }, // 1031
  { PseudoVFMSAC_VF32_M4_MASK, VFMSAC_VF, 0x2 }, // 1032
  { PseudoVFMSAC_VF64_M4, VFMSAC_VF, 0x2 }, // 1033
  { PseudoVFMSAC_VF64_M4_MASK, VFMSAC_VF, 0x2 }, // 1034
  { PseudoVFMSAC_VF16_M8, VFMSAC_VF, 0x3 }, // 1035
  { PseudoVFMSAC_VF16_M8_MASK, VFMSAC_VF, 0x3 }, // 1036
  { PseudoVFMSAC_VF32_M8, VFMSAC_VF, 0x3 }, // 1037
  { PseudoVFMSAC_VF32_M8_MASK, VFMSAC_VF, 0x3 }, // 1038
  { PseudoVFMSAC_VF64_M8, VFMSAC_VF, 0x3 }, // 1039
  { PseudoVFMSAC_VF64_M8_MASK, VFMSAC_VF, 0x3 }, // 1040
  { PseudoVFMSAC_VF16_MF4, VFMSAC_VF, 0x6 }, // 1041
  { PseudoVFMSAC_VF16_MF4_MASK, VFMSAC_VF, 0x6 }, // 1042
  { PseudoVFMSAC_VF16_MF2, VFMSAC_VF, 0x7 }, // 1043
  { PseudoVFMSAC_VF16_MF2_MASK, VFMSAC_VF, 0x7 }, // 1044
  { PseudoVFMSAC_VF32_MF2, VFMSAC_VF, 0x7 }, // 1045
  { PseudoVFMSAC_VF32_MF2_MASK, VFMSAC_VF, 0x7 }, // 1046
  { PseudoVFMSAC_VV_M1, VFMSAC_VV, 0x0 }, // 1047
  { PseudoVFMSAC_VV_M1_MASK, VFMSAC_VV, 0x0 }, // 1048
  { PseudoVFMSAC_VV_M2, VFMSAC_VV, 0x1 }, // 1049
  { PseudoVFMSAC_VV_M2_MASK, VFMSAC_VV, 0x1 }, // 1050
  { PseudoVFMSAC_VV_M4, VFMSAC_VV, 0x2 }, // 1051
  { PseudoVFMSAC_VV_M4_MASK, VFMSAC_VV, 0x2 }, // 1052
  { PseudoVFMSAC_VV_M8, VFMSAC_VV, 0x3 }, // 1053
  { PseudoVFMSAC_VV_M8_MASK, VFMSAC_VV, 0x3 }, // 1054
  { PseudoVFMSAC_VV_MF4, VFMSAC_VV, 0x6 }, // 1055
  { PseudoVFMSAC_VV_MF4_MASK, VFMSAC_VV, 0x6 }, // 1056
  { PseudoVFMSAC_VV_MF2, VFMSAC_VV, 0x7 }, // 1057
  { PseudoVFMSAC_VV_MF2_MASK, VFMSAC_VV, 0x7 }, // 1058
  { PseudoVFMSUB_VF16_M1, VFMSUB_VF, 0x0 }, // 1059
  { PseudoVFMSUB_VF16_M1_MASK, VFMSUB_VF, 0x0 }, // 1060
  { PseudoVFMSUB_VF32_M1, VFMSUB_VF, 0x0 }, // 1061
  { PseudoVFMSUB_VF32_M1_MASK, VFMSUB_VF, 0x0 }, // 1062
  { PseudoVFMSUB_VF64_M1, VFMSUB_VF, 0x0 }, // 1063
  { PseudoVFMSUB_VF64_M1_MASK, VFMSUB_VF, 0x0 }, // 1064
  { PseudoVFMSUB_VF16_M2, VFMSUB_VF, 0x1 }, // 1065
  { PseudoVFMSUB_VF16_M2_MASK, VFMSUB_VF, 0x1 }, // 1066
  { PseudoVFMSUB_VF32_M2, VFMSUB_VF, 0x1 }, // 1067
  { PseudoVFMSUB_VF32_M2_MASK, VFMSUB_VF, 0x1 }, // 1068
  { PseudoVFMSUB_VF64_M2, VFMSUB_VF, 0x1 }, // 1069
  { PseudoVFMSUB_VF64_M2_MASK, VFMSUB_VF, 0x1 }, // 1070
  { PseudoVFMSUB_VF16_M4, VFMSUB_VF, 0x2 }, // 1071
  { PseudoVFMSUB_VF16_M4_MASK, VFMSUB_VF, 0x2 }, // 1072
  { PseudoVFMSUB_VF32_M4, VFMSUB_VF, 0x2 }, // 1073
  { PseudoVFMSUB_VF32_M4_MASK, VFMSUB_VF, 0x2 }, // 1074
  { PseudoVFMSUB_VF64_M4, VFMSUB_VF, 0x2 }, // 1075
  { PseudoVFMSUB_VF64_M4_MASK, VFMSUB_VF, 0x2 }, // 1076
  { PseudoVFMSUB_VF16_M8, VFMSUB_VF, 0x3 }, // 1077
  { PseudoVFMSUB_VF16_M8_MASK, VFMSUB_VF, 0x3 }, // 1078
  { PseudoVFMSUB_VF32_M8, VFMSUB_VF, 0x3 }, // 1079
  { PseudoVFMSUB_VF32_M8_MASK, VFMSUB_VF, 0x3 }, // 1080
  { PseudoVFMSUB_VF64_M8, VFMSUB_VF, 0x3 }, // 1081
  { PseudoVFMSUB_VF64_M8_MASK, VFMSUB_VF, 0x3 }, // 1082
  { PseudoVFMSUB_VF16_MF4, VFMSUB_VF, 0x6 }, // 1083
  { PseudoVFMSUB_VF16_MF4_MASK, VFMSUB_VF, 0x6 }, // 1084
  { PseudoVFMSUB_VF16_MF2, VFMSUB_VF, 0x7 }, // 1085
  { PseudoVFMSUB_VF16_MF2_MASK, VFMSUB_VF, 0x7 }, // 1086
  { PseudoVFMSUB_VF32_MF2, VFMSUB_VF, 0x7 }, // 1087
  { PseudoVFMSUB_VF32_MF2_MASK, VFMSUB_VF, 0x7 }, // 1088
  { PseudoVFMSUB_VV_M1, VFMSUB_VV, 0x0 }, // 1089
  { PseudoVFMSUB_VV_M1_MASK, VFMSUB_VV, 0x0 }, // 1090
  { PseudoVFMSUB_VV_M2, VFMSUB_VV, 0x1 }, // 1091
  { PseudoVFMSUB_VV_M2_MASK, VFMSUB_VV, 0x1 }, // 1092
  { PseudoVFMSUB_VV_M4, VFMSUB_VV, 0x2 }, // 1093
  { PseudoVFMSUB_VV_M4_MASK, VFMSUB_VV, 0x2 }, // 1094
  { PseudoVFMSUB_VV_M8, VFMSUB_VV, 0x3 }, // 1095
  { PseudoVFMSUB_VV_M8_MASK, VFMSUB_VV, 0x3 }, // 1096
  { PseudoVFMSUB_VV_MF4, VFMSUB_VV, 0x6 }, // 1097
  { PseudoVFMSUB_VV_MF4_MASK, VFMSUB_VV, 0x6 }, // 1098
  { PseudoVFMSUB_VV_MF2, VFMSUB_VV, 0x7 }, // 1099
  { PseudoVFMSUB_VV_MF2_MASK, VFMSUB_VV, 0x7 }, // 1100
  { PseudoVFMUL_VF16_M1, VFMUL_VF, 0x0 }, // 1101
  { PseudoVFMUL_VF16_M1_MASK, VFMUL_VF, 0x0 }, // 1102
  { PseudoVFMUL_VF16_M1_TU, VFMUL_VF, 0x0 }, // 1103
  { PseudoVFMUL_VF32_M1, VFMUL_VF, 0x0 }, // 1104
  { PseudoVFMUL_VF32_M1_MASK, VFMUL_VF, 0x0 }, // 1105
  { PseudoVFMUL_VF32_M1_TU, VFMUL_VF, 0x0 }, // 1106
  { PseudoVFMUL_VF64_M1, VFMUL_VF, 0x0 }, // 1107
  { PseudoVFMUL_VF64_M1_MASK, VFMUL_VF, 0x0 }, // 1108
  { PseudoVFMUL_VF64_M1_TU, VFMUL_VF, 0x0 }, // 1109
  { PseudoVFMUL_VF16_M2, VFMUL_VF, 0x1 }, // 1110
  { PseudoVFMUL_VF16_M2_MASK, VFMUL_VF, 0x1 }, // 1111
  { PseudoVFMUL_VF16_M2_TU, VFMUL_VF, 0x1 }, // 1112
  { PseudoVFMUL_VF32_M2, VFMUL_VF, 0x1 }, // 1113
  { PseudoVFMUL_VF32_M2_MASK, VFMUL_VF, 0x1 }, // 1114
  { PseudoVFMUL_VF32_M2_TU, VFMUL_VF, 0x1 }, // 1115
  { PseudoVFMUL_VF64_M2, VFMUL_VF, 0x1 }, // 1116
  { PseudoVFMUL_VF64_M2_MASK, VFMUL_VF, 0x1 }, // 1117
  { PseudoVFMUL_VF64_M2_TU, VFMUL_VF, 0x1 }, // 1118
  { PseudoVFMUL_VF16_M4, VFMUL_VF, 0x2 }, // 1119
  { PseudoVFMUL_VF16_M4_MASK, VFMUL_VF, 0x2 }, // 1120
  { PseudoVFMUL_VF16_M4_TU, VFMUL_VF, 0x2 }, // 1121
  { PseudoVFMUL_VF32_M4, VFMUL_VF, 0x2 }, // 1122
  { PseudoVFMUL_VF32_M4_MASK, VFMUL_VF, 0x2 }, // 1123
  { PseudoVFMUL_VF32_M4_TU, VFMUL_VF, 0x2 }, // 1124
  { PseudoVFMUL_VF64_M4, VFMUL_VF, 0x2 }, // 1125
  { PseudoVFMUL_VF64_M4_MASK, VFMUL_VF, 0x2 }, // 1126
  { PseudoVFMUL_VF64_M4_TU, VFMUL_VF, 0x2 }, // 1127
  { PseudoVFMUL_VF16_M8, VFMUL_VF, 0x3 }, // 1128
  { PseudoVFMUL_VF16_M8_MASK, VFMUL_VF, 0x3 }, // 1129
  { PseudoVFMUL_VF16_M8_TU, VFMUL_VF, 0x3 }, // 1130
  { PseudoVFMUL_VF32_M8, VFMUL_VF, 0x3 }, // 1131
  { PseudoVFMUL_VF32_M8_MASK, VFMUL_VF, 0x3 }, // 1132
  { PseudoVFMUL_VF32_M8_TU, VFMUL_VF, 0x3 }, // 1133
  { PseudoVFMUL_VF64_M8, VFMUL_VF, 0x3 }, // 1134
  { PseudoVFMUL_VF64_M8_MASK, VFMUL_VF, 0x3 }, // 1135
  { PseudoVFMUL_VF64_M8_TU, VFMUL_VF, 0x3 }, // 1136
  { PseudoVFMUL_VF16_MF4, VFMUL_VF, 0x6 }, // 1137
  { PseudoVFMUL_VF16_MF4_MASK, VFMUL_VF, 0x6 }, // 1138
  { PseudoVFMUL_VF16_MF4_TU, VFMUL_VF, 0x6 }, // 1139
  { PseudoVFMUL_VF16_MF2, VFMUL_VF, 0x7 }, // 1140
  { PseudoVFMUL_VF16_MF2_MASK, VFMUL_VF, 0x7 }, // 1141
  { PseudoVFMUL_VF16_MF2_TU, VFMUL_VF, 0x7 }, // 1142
  { PseudoVFMUL_VF32_MF2, VFMUL_VF, 0x7 }, // 1143
  { PseudoVFMUL_VF32_MF2_MASK, VFMUL_VF, 0x7 }, // 1144
  { PseudoVFMUL_VF32_MF2_TU, VFMUL_VF, 0x7 }, // 1145
  { PseudoVFMUL_VV_M1, VFMUL_VV, 0x0 }, // 1146
  { PseudoVFMUL_VV_M1_MASK, VFMUL_VV, 0x0 }, // 1147
  { PseudoVFMUL_VV_M1_TU, VFMUL_VV, 0x0 }, // 1148
  { PseudoVFMUL_VV_M2, VFMUL_VV, 0x1 }, // 1149
  { PseudoVFMUL_VV_M2_MASK, VFMUL_VV, 0x1 }, // 1150
  { PseudoVFMUL_VV_M2_TU, VFMUL_VV, 0x1 }, // 1151
  { PseudoVFMUL_VV_M4, VFMUL_VV, 0x2 }, // 1152
  { PseudoVFMUL_VV_M4_MASK, VFMUL_VV, 0x2 }, // 1153
  { PseudoVFMUL_VV_M4_TU, VFMUL_VV, 0x2 }, // 1154
  { PseudoVFMUL_VV_M8, VFMUL_VV, 0x3 }, // 1155
  { PseudoVFMUL_VV_M8_MASK, VFMUL_VV, 0x3 }, // 1156
  { PseudoVFMUL_VV_M8_TU, VFMUL_VV, 0x3 }, // 1157
  { PseudoVFMUL_VV_MF4, VFMUL_VV, 0x6 }, // 1158
  { PseudoVFMUL_VV_MF4_MASK, VFMUL_VV, 0x6 }, // 1159
  { PseudoVFMUL_VV_MF4_TU, VFMUL_VV, 0x6 }, // 1160
  { PseudoVFMUL_VV_MF2, VFMUL_VV, 0x7 }, // 1161
  { PseudoVFMUL_VV_MF2_MASK, VFMUL_VV, 0x7 }, // 1162
  { PseudoVFMUL_VV_MF2_TU, VFMUL_VV, 0x7 }, // 1163
  { PseudoVFMV_F16_S_M1, VFMV_F_S, 0x0 }, // 1164
  { PseudoVFMV_F32_S_M1, VFMV_F_S, 0x0 }, // 1165
  { PseudoVFMV_F64_S_M1, VFMV_F_S, 0x0 }, // 1166
  { PseudoVFMV_F16_S_M2, VFMV_F_S, 0x1 }, // 1167
  { PseudoVFMV_F32_S_M2, VFMV_F_S, 0x1 }, // 1168
  { PseudoVFMV_F64_S_M2, VFMV_F_S, 0x1 }, // 1169
  { PseudoVFMV_F16_S_M4, VFMV_F_S, 0x2 }, // 1170
  { PseudoVFMV_F32_S_M4, VFMV_F_S, 0x2 }, // 1171
  { PseudoVFMV_F64_S_M4, VFMV_F_S, 0x2 }, // 1172
  { PseudoVFMV_F16_S_M8, VFMV_F_S, 0x3 }, // 1173
  { PseudoVFMV_F32_S_M8, VFMV_F_S, 0x3 }, // 1174
  { PseudoVFMV_F64_S_M8, VFMV_F_S, 0x3 }, // 1175
  { PseudoVFMV_F16_S_MF4, VFMV_F_S, 0x6 }, // 1176
  { PseudoVFMV_F16_S_MF2, VFMV_F_S, 0x7 }, // 1177
  { PseudoVFMV_F32_S_MF2, VFMV_F_S, 0x7 }, // 1178
  { PseudoVFMV_S_F16_M1, VFMV_S_F, 0x0 }, // 1179
  { PseudoVFMV_S_F32_M1, VFMV_S_F, 0x0 }, // 1180
  { PseudoVFMV_S_F64_M1, VFMV_S_F, 0x0 }, // 1181
  { PseudoVFMV_S_F16_M2, VFMV_S_F, 0x1 }, // 1182
  { PseudoVFMV_S_F32_M2, VFMV_S_F, 0x1 }, // 1183
  { PseudoVFMV_S_F64_M2, VFMV_S_F, 0x1 }, // 1184
  { PseudoVFMV_S_F16_M4, VFMV_S_F, 0x2 }, // 1185
  { PseudoVFMV_S_F32_M4, VFMV_S_F, 0x2 }, // 1186
  { PseudoVFMV_S_F64_M4, VFMV_S_F, 0x2 }, // 1187
  { PseudoVFMV_S_F16_M8, VFMV_S_F, 0x3 }, // 1188
  { PseudoVFMV_S_F32_M8, VFMV_S_F, 0x3 }, // 1189
  { PseudoVFMV_S_F64_M8, VFMV_S_F, 0x3 }, // 1190
  { PseudoVFMV_S_F16_MF4, VFMV_S_F, 0x6 }, // 1191
  { PseudoVFMV_S_F16_MF2, VFMV_S_F, 0x7 }, // 1192
  { PseudoVFMV_S_F32_MF2, VFMV_S_F, 0x7 }, // 1193
  { PseudoVFMV_V_F16_M1, VFMV_V_F, 0x0 }, // 1194
  { PseudoVFMV_V_F16_M1_TU, VFMV_V_F, 0x0 }, // 1195
  { PseudoVFMV_V_F32_M1, VFMV_V_F, 0x0 }, // 1196
  { PseudoVFMV_V_F32_M1_TU, VFMV_V_F, 0x0 }, // 1197
  { PseudoVFMV_V_F64_M1, VFMV_V_F, 0x0 }, // 1198
  { PseudoVFMV_V_F64_M1_TU, VFMV_V_F, 0x0 }, // 1199
  { PseudoVFMV_V_F16_M2, VFMV_V_F, 0x1 }, // 1200
  { PseudoVFMV_V_F16_M2_TU, VFMV_V_F, 0x1 }, // 1201
  { PseudoVFMV_V_F32_M2, VFMV_V_F, 0x1 }, // 1202
  { PseudoVFMV_V_F32_M2_TU, VFMV_V_F, 0x1 }, // 1203
  { PseudoVFMV_V_F64_M2, VFMV_V_F, 0x1 }, // 1204
  { PseudoVFMV_V_F64_M2_TU, VFMV_V_F, 0x1 }, // 1205
  { PseudoVFMV_V_F16_M4, VFMV_V_F, 0x2 }, // 1206
  { PseudoVFMV_V_F16_M4_TU, VFMV_V_F, 0x2 }, // 1207
  { PseudoVFMV_V_F32_M4, VFMV_V_F, 0x2 }, // 1208
  { PseudoVFMV_V_F32_M4_TU, VFMV_V_F, 0x2 }, // 1209
  { PseudoVFMV_V_F64_M4, VFMV_V_F, 0x2 }, // 1210
  { PseudoVFMV_V_F64_M4_TU, VFMV_V_F, 0x2 }, // 1211
  { PseudoVFMV_V_F16_M8, VFMV_V_F, 0x3 }, // 1212
  { PseudoVFMV_V_F16_M8_TU, VFMV_V_F, 0x3 }, // 1213
  { PseudoVFMV_V_F32_M8, VFMV_V_F, 0x3 }, // 1214
  { PseudoVFMV_V_F32_M8_TU, VFMV_V_F, 0x3 }, // 1215
  { PseudoVFMV_V_F64_M8, VFMV_V_F, 0x3 }, // 1216
  { PseudoVFMV_V_F64_M8_TU, VFMV_V_F, 0x3 }, // 1217
  { PseudoVFMV_V_F16_MF4, VFMV_V_F, 0x6 }, // 1218
  { PseudoVFMV_V_F16_MF4_TU, VFMV_V_F, 0x6 }, // 1219
  { PseudoVFMV_V_F16_MF2, VFMV_V_F, 0x7 }, // 1220
  { PseudoVFMV_V_F16_MF2_TU, VFMV_V_F, 0x7 }, // 1221
  { PseudoVFMV_V_F32_MF2, VFMV_V_F, 0x7 }, // 1222
  { PseudoVFMV_V_F32_MF2_TU, VFMV_V_F, 0x7 }, // 1223
  { PseudoVFNCVT_F_F_W_M1, VFNCVT_F_F_W, 0x0 }, // 1224
  { PseudoVFNCVT_F_F_W_M1_MASK, VFNCVT_F_F_W, 0x0 }, // 1225
  { PseudoVFNCVT_F_F_W_M1_TU, VFNCVT_F_F_W, 0x0 }, // 1226
  { PseudoVFNCVT_F_F_W_M2, VFNCVT_F_F_W, 0x1 }, // 1227
  { PseudoVFNCVT_F_F_W_M2_MASK, VFNCVT_F_F_W, 0x1 }, // 1228
  { PseudoVFNCVT_F_F_W_M2_TU, VFNCVT_F_F_W, 0x1 }, // 1229
  { PseudoVFNCVT_F_F_W_M4, VFNCVT_F_F_W, 0x2 }, // 1230
  { PseudoVFNCVT_F_F_W_M4_MASK, VFNCVT_F_F_W, 0x2 }, // 1231
  { PseudoVFNCVT_F_F_W_M4_TU, VFNCVT_F_F_W, 0x2 }, // 1232
  { PseudoVFNCVT_F_F_W_MF4, VFNCVT_F_F_W, 0x6 }, // 1233
  { PseudoVFNCVT_F_F_W_MF4_MASK, VFNCVT_F_F_W, 0x6 }, // 1234
  { PseudoVFNCVT_F_F_W_MF4_TU, VFNCVT_F_F_W, 0x6 }, // 1235
  { PseudoVFNCVT_F_F_W_MF2, VFNCVT_F_F_W, 0x7 }, // 1236
  { PseudoVFNCVT_F_F_W_MF2_MASK, VFNCVT_F_F_W, 0x7 }, // 1237
  { PseudoVFNCVT_F_F_W_MF2_TU, VFNCVT_F_F_W, 0x7 }, // 1238
  { PseudoVFNCVT_F_XU_W_M1, VFNCVT_F_XU_W, 0x0 }, // 1239
  { PseudoVFNCVT_F_XU_W_M1_MASK, VFNCVT_F_XU_W, 0x0 }, // 1240
  { PseudoVFNCVT_F_XU_W_M1_TU, VFNCVT_F_XU_W, 0x0 }, // 1241
  { PseudoVFNCVT_F_XU_W_M2, VFNCVT_F_XU_W, 0x1 }, // 1242
  { PseudoVFNCVT_F_XU_W_M2_MASK, VFNCVT_F_XU_W, 0x1 }, // 1243
  { PseudoVFNCVT_F_XU_W_M2_TU, VFNCVT_F_XU_W, 0x1 }, // 1244
  { PseudoVFNCVT_F_XU_W_M4, VFNCVT_F_XU_W, 0x2 }, // 1245
  { PseudoVFNCVT_F_XU_W_M4_MASK, VFNCVT_F_XU_W, 0x2 }, // 1246
  { PseudoVFNCVT_F_XU_W_M4_TU, VFNCVT_F_XU_W, 0x2 }, // 1247
  { PseudoVFNCVT_F_XU_W_MF4, VFNCVT_F_XU_W, 0x6 }, // 1248
  { PseudoVFNCVT_F_XU_W_MF4_MASK, VFNCVT_F_XU_W, 0x6 }, // 1249
  { PseudoVFNCVT_F_XU_W_MF4_TU, VFNCVT_F_XU_W, 0x6 }, // 1250
  { PseudoVFNCVT_F_XU_W_MF2, VFNCVT_F_XU_W, 0x7 }, // 1251
  { PseudoVFNCVT_F_XU_W_MF2_MASK, VFNCVT_F_XU_W, 0x7 }, // 1252
  { PseudoVFNCVT_F_XU_W_MF2_TU, VFNCVT_F_XU_W, 0x7 }, // 1253
  { PseudoVFNCVT_F_X_W_M1, VFNCVT_F_X_W, 0x0 }, // 1254
  { PseudoVFNCVT_F_X_W_M1_MASK, VFNCVT_F_X_W, 0x0 }, // 1255
  { PseudoVFNCVT_F_X_W_M1_TU, VFNCVT_F_X_W, 0x0 }, // 1256
  { PseudoVFNCVT_F_X_W_M2, VFNCVT_F_X_W, 0x1 }, // 1257
  { PseudoVFNCVT_F_X_W_M2_MASK, VFNCVT_F_X_W, 0x1 }, // 1258
  { PseudoVFNCVT_F_X_W_M2_TU, VFNCVT_F_X_W, 0x1 }, // 1259
  { PseudoVFNCVT_F_X_W_M4, VFNCVT_F_X_W, 0x2 }, // 1260
  { PseudoVFNCVT_F_X_W_M4_MASK, VFNCVT_F_X_W, 0x2 }, // 1261
  { PseudoVFNCVT_F_X_W_M4_TU, VFNCVT_F_X_W, 0x2 }, // 1262
  { PseudoVFNCVT_F_X_W_MF4, VFNCVT_F_X_W, 0x6 }, // 1263
  { PseudoVFNCVT_F_X_W_MF4_MASK, VFNCVT_F_X_W, 0x6 }, // 1264
  { PseudoVFNCVT_F_X_W_MF4_TU, VFNCVT_F_X_W, 0x6 }, // 1265
  { PseudoVFNCVT_F_X_W_MF2, VFNCVT_F_X_W, 0x7 }, // 1266
  { PseudoVFNCVT_F_X_W_MF2_MASK, VFNCVT_F_X_W, 0x7 }, // 1267
  { PseudoVFNCVT_F_X_W_MF2_TU, VFNCVT_F_X_W, 0x7 }, // 1268
  { PseudoVFNCVT_ROD_F_F_W_M1, VFNCVT_ROD_F_F_W, 0x0 }, // 1269
  { PseudoVFNCVT_ROD_F_F_W_M1_MASK, VFNCVT_ROD_F_F_W, 0x0 }, // 1270
  { PseudoVFNCVT_ROD_F_F_W_M1_TU, VFNCVT_ROD_F_F_W, 0x0 }, // 1271
  { PseudoVFNCVT_ROD_F_F_W_M2, VFNCVT_ROD_F_F_W, 0x1 }, // 1272
  { PseudoVFNCVT_ROD_F_F_W_M2_MASK, VFNCVT_ROD_F_F_W, 0x1 }, // 1273
  { PseudoVFNCVT_ROD_F_F_W_M2_TU, VFNCVT_ROD_F_F_W, 0x1 }, // 1274
  { PseudoVFNCVT_ROD_F_F_W_M4, VFNCVT_ROD_F_F_W, 0x2 }, // 1275
  { PseudoVFNCVT_ROD_F_F_W_M4_MASK, VFNCVT_ROD_F_F_W, 0x2 }, // 1276
  { PseudoVFNCVT_ROD_F_F_W_M4_TU, VFNCVT_ROD_F_F_W, 0x2 }, // 1277
  { PseudoVFNCVT_ROD_F_F_W_MF4, VFNCVT_ROD_F_F_W, 0x6 }, // 1278
  { PseudoVFNCVT_ROD_F_F_W_MF4_MASK, VFNCVT_ROD_F_F_W, 0x6 }, // 1279
  { PseudoVFNCVT_ROD_F_F_W_MF4_TU, VFNCVT_ROD_F_F_W, 0x6 }, // 1280
  { PseudoVFNCVT_ROD_F_F_W_MF2, VFNCVT_ROD_F_F_W, 0x7 }, // 1281
  { PseudoVFNCVT_ROD_F_F_W_MF2_MASK, VFNCVT_ROD_F_F_W, 0x7 }, // 1282
  { PseudoVFNCVT_ROD_F_F_W_MF2_TU, VFNCVT_ROD_F_F_W, 0x7 }, // 1283
  { PseudoVFNCVT_RTZ_XU_F_W_M1, VFNCVT_RTZ_XU_F_W, 0x0 }, // 1284
  { PseudoVFNCVT_RTZ_XU_F_W_M1_MASK, VFNCVT_RTZ_XU_F_W, 0x0 }, // 1285
  { PseudoVFNCVT_RTZ_XU_F_W_M1_TU, VFNCVT_RTZ_XU_F_W, 0x0 }, // 1286
  { PseudoVFNCVT_RTZ_XU_F_W_M2, VFNCVT_RTZ_XU_F_W, 0x1 }, // 1287
  { PseudoVFNCVT_RTZ_XU_F_W_M2_MASK, VFNCVT_RTZ_XU_F_W, 0x1 }, // 1288
  { PseudoVFNCVT_RTZ_XU_F_W_M2_TU, VFNCVT_RTZ_XU_F_W, 0x1 }, // 1289
  { PseudoVFNCVT_RTZ_XU_F_W_M4, VFNCVT_RTZ_XU_F_W, 0x2 }, // 1290
  { PseudoVFNCVT_RTZ_XU_F_W_M4_MASK, VFNCVT_RTZ_XU_F_W, 0x2 }, // 1291
  { PseudoVFNCVT_RTZ_XU_F_W_M4_TU, VFNCVT_RTZ_XU_F_W, 0x2 }, // 1292
  { PseudoVFNCVT_RTZ_XU_F_W_MF8, VFNCVT_RTZ_XU_F_W, 0x5 }, // 1293
  { PseudoVFNCVT_RTZ_XU_F_W_MF8_MASK, VFNCVT_RTZ_XU_F_W, 0x5 }, // 1294
  { PseudoVFNCVT_RTZ_XU_F_W_MF8_TU, VFNCVT_RTZ_XU_F_W, 0x5 }, // 1295
  { PseudoVFNCVT_RTZ_XU_F_W_MF4, VFNCVT_RTZ_XU_F_W, 0x6 }, // 1296
  { PseudoVFNCVT_RTZ_XU_F_W_MF4_MASK, VFNCVT_RTZ_XU_F_W, 0x6 }, // 1297
  { PseudoVFNCVT_RTZ_XU_F_W_MF4_TU, VFNCVT_RTZ_XU_F_W, 0x6 }, // 1298
  { PseudoVFNCVT_RTZ_XU_F_W_MF2, VFNCVT_RTZ_XU_F_W, 0x7 }, // 1299
  { PseudoVFNCVT_RTZ_XU_F_W_MF2_MASK, VFNCVT_RTZ_XU_F_W, 0x7 }, // 1300
  { PseudoVFNCVT_RTZ_XU_F_W_MF2_TU, VFNCVT_RTZ_XU_F_W, 0x7 }, // 1301
  { PseudoVFNCVT_RTZ_X_F_W_M1, VFNCVT_RTZ_X_F_W, 0x0 }, // 1302
  { PseudoVFNCVT_RTZ_X_F_W_M1_MASK, VFNCVT_RTZ_X_F_W, 0x0 }, // 1303
  { PseudoVFNCVT_RTZ_X_F_W_M1_TU, VFNCVT_RTZ_X_F_W, 0x0 }, // 1304
  { PseudoVFNCVT_RTZ_X_F_W_M2, VFNCVT_RTZ_X_F_W, 0x1 }, // 1305
  { PseudoVFNCVT_RTZ_X_F_W_M2_MASK, VFNCVT_RTZ_X_F_W, 0x1 }, // 1306
  { PseudoVFNCVT_RTZ_X_F_W_M2_TU, VFNCVT_RTZ_X_F_W, 0x1 }, // 1307
  { PseudoVFNCVT_RTZ_X_F_W_M4, VFNCVT_RTZ_X_F_W, 0x2 }, // 1308
  { PseudoVFNCVT_RTZ_X_F_W_M4_MASK, VFNCVT_RTZ_X_F_W, 0x2 }, // 1309
  { PseudoVFNCVT_RTZ_X_F_W_M4_TU, VFNCVT_RTZ_X_F_W, 0x2 }, // 1310
  { PseudoVFNCVT_RTZ_X_F_W_MF8, VFNCVT_RTZ_X_F_W, 0x5 }, // 1311
  { PseudoVFNCVT_RTZ_X_F_W_MF8_MASK, VFNCVT_RTZ_X_F_W, 0x5 }, // 1312
  { PseudoVFNCVT_RTZ_X_F_W_MF8_TU, VFNCVT_RTZ_X_F_W, 0x5 }, // 1313
  { PseudoVFNCVT_RTZ_X_F_W_MF4, VFNCVT_RTZ_X_F_W, 0x6 }, // 1314
  { PseudoVFNCVT_RTZ_X_F_W_MF4_MASK, VFNCVT_RTZ_X_F_W, 0x6 }, // 1315
  { PseudoVFNCVT_RTZ_X_F_W_MF4_TU, VFNCVT_RTZ_X_F_W, 0x6 }, // 1316
  { PseudoVFNCVT_RTZ_X_F_W_MF2, VFNCVT_RTZ_X_F_W, 0x7 }, // 1317
  { PseudoVFNCVT_RTZ_X_F_W_MF2_MASK, VFNCVT_RTZ_X_F_W, 0x7 }, // 1318
  { PseudoVFNCVT_RTZ_X_F_W_MF2_TU, VFNCVT_RTZ_X_F_W, 0x7 }, // 1319
  { PseudoVFNCVT_XU_F_W_M1, VFNCVT_XU_F_W, 0x0 }, // 1320
  { PseudoVFNCVT_XU_F_W_M1_MASK, VFNCVT_XU_F_W, 0x0 }, // 1321
  { PseudoVFNCVT_XU_F_W_M1_TU, VFNCVT_XU_F_W, 0x0 }, // 1322
  { PseudoVFNCVT_XU_F_W_M2, VFNCVT_XU_F_W, 0x1 }, // 1323
  { PseudoVFNCVT_XU_F_W_M2_MASK, VFNCVT_XU_F_W, 0x1 }, // 1324
  { PseudoVFNCVT_XU_F_W_M2_TU, VFNCVT_XU_F_W, 0x1 }, // 1325
  { PseudoVFNCVT_XU_F_W_M4, VFNCVT_XU_F_W, 0x2 }, // 1326
  { PseudoVFNCVT_XU_F_W_M4_MASK, VFNCVT_XU_F_W, 0x2 }, // 1327
  { PseudoVFNCVT_XU_F_W_M4_TU, VFNCVT_XU_F_W, 0x2 }, // 1328
  { PseudoVFNCVT_XU_F_W_MF8, VFNCVT_XU_F_W, 0x5 }, // 1329
  { PseudoVFNCVT_XU_F_W_MF8_MASK, VFNCVT_XU_F_W, 0x5 }, // 1330
  { PseudoVFNCVT_XU_F_W_MF8_TU, VFNCVT_XU_F_W, 0x5 }, // 1331
  { PseudoVFNCVT_XU_F_W_MF4, VFNCVT_XU_F_W, 0x6 }, // 1332
  { PseudoVFNCVT_XU_F_W_MF4_MASK, VFNCVT_XU_F_W, 0x6 }, // 1333
  { PseudoVFNCVT_XU_F_W_MF4_TU, VFNCVT_XU_F_W, 0x6 }, // 1334
  { PseudoVFNCVT_XU_F_W_MF2, VFNCVT_XU_F_W, 0x7 }, // 1335
  { PseudoVFNCVT_XU_F_W_MF2_MASK, VFNCVT_XU_F_W, 0x7 }, // 1336
  { PseudoVFNCVT_XU_F_W_MF2_TU, VFNCVT_XU_F_W, 0x7 }, // 1337
  { PseudoVFNCVT_X_F_W_M1, VFNCVT_X_F_W, 0x0 }, // 1338
  { PseudoVFNCVT_X_F_W_M1_MASK, VFNCVT_X_F_W, 0x0 }, // 1339
  { PseudoVFNCVT_X_F_W_M1_TU, VFNCVT_X_F_W, 0x0 }, // 1340
  { PseudoVFNCVT_X_F_W_M2, VFNCVT_X_F_W, 0x1 }, // 1341
  { PseudoVFNCVT_X_F_W_M2_MASK, VFNCVT_X_F_W, 0x1 }, // 1342
  { PseudoVFNCVT_X_F_W_M2_TU, VFNCVT_X_F_W, 0x1 }, // 1343
  { PseudoVFNCVT_X_F_W_M4, VFNCVT_X_F_W, 0x2 }, // 1344
  { PseudoVFNCVT_X_F_W_M4_MASK, VFNCVT_X_F_W, 0x2 }, // 1345
  { PseudoVFNCVT_X_F_W_M4_TU, VFNCVT_X_F_W, 0x2 }, // 1346
  { PseudoVFNCVT_X_F_W_MF8, VFNCVT_X_F_W, 0x5 }, // 1347
  { PseudoVFNCVT_X_F_W_MF8_MASK, VFNCVT_X_F_W, 0x5 }, // 1348
  { PseudoVFNCVT_X_F_W_MF8_TU, VFNCVT_X_F_W, 0x5 }, // 1349
  { PseudoVFNCVT_X_F_W_MF4, VFNCVT_X_F_W, 0x6 }, // 1350
  { PseudoVFNCVT_X_F_W_MF4_MASK, VFNCVT_X_F_W, 0x6 }, // 1351
  { PseudoVFNCVT_X_F_W_MF4_TU, VFNCVT_X_F_W, 0x6 }, // 1352
  { PseudoVFNCVT_X_F_W_MF2, VFNCVT_X_F_W, 0x7 }, // 1353
  { PseudoVFNCVT_X_F_W_MF2_MASK, VFNCVT_X_F_W, 0x7 }, // 1354
  { PseudoVFNCVT_X_F_W_MF2_TU, VFNCVT_X_F_W, 0x7 }, // 1355
  { PseudoVFNMACC_VF16_M1, VFNMACC_VF, 0x0 }, // 1356
  { PseudoVFNMACC_VF16_M1_MASK, VFNMACC_VF, 0x0 }, // 1357
  { PseudoVFNMACC_VF32_M1, VFNMACC_VF, 0x0 }, // 1358
  { PseudoVFNMACC_VF32_M1_MASK, VFNMACC_VF, 0x0 }, // 1359
  { PseudoVFNMACC_VF64_M1, VFNMACC_VF, 0x0 }, // 1360
  { PseudoVFNMACC_VF64_M1_MASK, VFNMACC_VF, 0x0 }, // 1361
  { PseudoVFNMACC_VF16_M2, VFNMACC_VF, 0x1 }, // 1362
  { PseudoVFNMACC_VF16_M2_MASK, VFNMACC_VF, 0x1 }, // 1363
  { PseudoVFNMACC_VF32_M2, VFNMACC_VF, 0x1 }, // 1364
  { PseudoVFNMACC_VF32_M2_MASK, VFNMACC_VF, 0x1 }, // 1365
  { PseudoVFNMACC_VF64_M2, VFNMACC_VF, 0x1 }, // 1366
  { PseudoVFNMACC_VF64_M2_MASK, VFNMACC_VF, 0x1 }, // 1367
  { PseudoVFNMACC_VF16_M4, VFNMACC_VF, 0x2 }, // 1368
  { PseudoVFNMACC_VF16_M4_MASK, VFNMACC_VF, 0x2 }, // 1369
  { PseudoVFNMACC_VF32_M4, VFNMACC_VF, 0x2 }, // 1370
  { PseudoVFNMACC_VF32_M4_MASK, VFNMACC_VF, 0x2 }, // 1371
  { PseudoVFNMACC_VF64_M4, VFNMACC_VF, 0x2 }, // 1372
  { PseudoVFNMACC_VF64_M4_MASK, VFNMACC_VF, 0x2 }, // 1373
  { PseudoVFNMACC_VF16_M8, VFNMACC_VF, 0x3 }, // 1374
  { PseudoVFNMACC_VF16_M8_MASK, VFNMACC_VF, 0x3 }, // 1375
  { PseudoVFNMACC_VF32_M8, VFNMACC_VF, 0x3 }, // 1376
  { PseudoVFNMACC_VF32_M8_MASK, VFNMACC_VF, 0x3 }, // 1377
  { PseudoVFNMACC_VF64_M8, VFNMACC_VF, 0x3 }, // 1378
  { PseudoVFNMACC_VF64_M8_MASK, VFNMACC_VF, 0x3 }, // 1379
  { PseudoVFNMACC_VF16_MF4, VFNMACC_VF, 0x6 }, // 1380
  { PseudoVFNMACC_VF16_MF4_MASK, VFNMACC_VF, 0x6 }, // 1381
  { PseudoVFNMACC_VF16_MF2, VFNMACC_VF, 0x7 }, // 1382
  { PseudoVFNMACC_VF16_MF2_MASK, VFNMACC_VF, 0x7 }, // 1383
  { PseudoVFNMACC_VF32_MF2, VFNMACC_VF, 0x7 }, // 1384
  { PseudoVFNMACC_VF32_MF2_MASK, VFNMACC_VF, 0x7 }, // 1385
  { PseudoVFNMACC_VV_M1, VFNMACC_VV, 0x0 }, // 1386
  { PseudoVFNMACC_VV_M1_MASK, VFNMACC_VV, 0x0 }, // 1387
  { PseudoVFNMACC_VV_M2, VFNMACC_VV, 0x1 }, // 1388
  { PseudoVFNMACC_VV_M2_MASK, VFNMACC_VV, 0x1 }, // 1389
  { PseudoVFNMACC_VV_M4, VFNMACC_VV, 0x2 }, // 1390
  { PseudoVFNMACC_VV_M4_MASK, VFNMACC_VV, 0x2 }, // 1391
  { PseudoVFNMACC_VV_M8, VFNMACC_VV, 0x3 }, // 1392
  { PseudoVFNMACC_VV_M8_MASK, VFNMACC_VV, 0x3 }, // 1393
  { PseudoVFNMACC_VV_MF4, VFNMACC_VV, 0x6 }, // 1394
  { PseudoVFNMACC_VV_MF4_MASK, VFNMACC_VV, 0x6 }, // 1395
  { PseudoVFNMACC_VV_MF2, VFNMACC_VV, 0x7 }, // 1396
  { PseudoVFNMACC_VV_MF2_MASK, VFNMACC_VV, 0x7 }, // 1397
  { PseudoVFNMADD_VF16_M1, VFNMADD_VF, 0x0 }, // 1398
  { PseudoVFNMADD_VF16_M1_MASK, VFNMADD_VF, 0x0 }, // 1399
  { PseudoVFNMADD_VF32_M1, VFNMADD_VF, 0x0 }, // 1400
  { PseudoVFNMADD_VF32_M1_MASK, VFNMADD_VF, 0x0 }, // 1401
  { PseudoVFNMADD_VF64_M1, VFNMADD_VF, 0x0 }, // 1402
  { PseudoVFNMADD_VF64_M1_MASK, VFNMADD_VF, 0x0 }, // 1403
  { PseudoVFNMADD_VF16_M2, VFNMADD_VF, 0x1 }, // 1404
  { PseudoVFNMADD_VF16_M2_MASK, VFNMADD_VF, 0x1 }, // 1405
  { PseudoVFNMADD_VF32_M2, VFNMADD_VF, 0x1 }, // 1406
  { PseudoVFNMADD_VF32_M2_MASK, VFNMADD_VF, 0x1 }, // 1407
  { PseudoVFNMADD_VF64_M2, VFNMADD_VF, 0x1 }, // 1408
  { PseudoVFNMADD_VF64_M2_MASK, VFNMADD_VF, 0x1 }, // 1409
  { PseudoVFNMADD_VF16_M4, VFNMADD_VF, 0x2 }, // 1410
  { PseudoVFNMADD_VF16_M4_MASK, VFNMADD_VF, 0x2 }, // 1411
  { PseudoVFNMADD_VF32_M4, VFNMADD_VF, 0x2 }, // 1412
  { PseudoVFNMADD_VF32_M4_MASK, VFNMADD_VF, 0x2 }, // 1413
  { PseudoVFNMADD_VF64_M4, VFNMADD_VF, 0x2 }, // 1414
  { PseudoVFNMADD_VF64_M4_MASK, VFNMADD_VF, 0x2 }, // 1415
  { PseudoVFNMADD_VF16_M8, VFNMADD_VF, 0x3 }, // 1416
  { PseudoVFNMADD_VF16_M8_MASK, VFNMADD_VF, 0x3 }, // 1417
  { PseudoVFNMADD_VF32_M8, VFNMADD_VF, 0x3 }, // 1418
  { PseudoVFNMADD_VF32_M8_MASK, VFNMADD_VF, 0x3 }, // 1419
  { PseudoVFNMADD_VF64_M8, VFNMADD_VF, 0x3 }, // 1420
  { PseudoVFNMADD_VF64_M8_MASK, VFNMADD_VF, 0x3 }, // 1421
  { PseudoVFNMADD_VF16_MF4, VFNMADD_VF, 0x6 }, // 1422
  { PseudoVFNMADD_VF16_MF4_MASK, VFNMADD_VF, 0x6 }, // 1423
  { PseudoVFNMADD_VF16_MF2, VFNMADD_VF, 0x7 }, // 1424
  { PseudoVFNMADD_VF16_MF2_MASK, VFNMADD_VF, 0x7 }, // 1425
  { PseudoVFNMADD_VF32_MF2, VFNMADD_VF, 0x7 }, // 1426
  { PseudoVFNMADD_VF32_MF2_MASK, VFNMADD_VF, 0x7 }, // 1427
  { PseudoVFNMADD_VV_M1, VFNMADD_VV, 0x0 }, // 1428
  { PseudoVFNMADD_VV_M1_MASK, VFNMADD_VV, 0x0 }, // 1429
  { PseudoVFNMADD_VV_M2, VFNMADD_VV, 0x1 }, // 1430
  { PseudoVFNMADD_VV_M2_MASK, VFNMADD_VV, 0x1 }, // 1431
  { PseudoVFNMADD_VV_M4, VFNMADD_VV, 0x2 }, // 1432
  { PseudoVFNMADD_VV_M4_MASK, VFNMADD_VV, 0x2 }, // 1433
  { PseudoVFNMADD_VV_M8, VFNMADD_VV, 0x3 }, // 1434
  { PseudoVFNMADD_VV_M8_MASK, VFNMADD_VV, 0x3 }, // 1435
  { PseudoVFNMADD_VV_MF4, VFNMADD_VV, 0x6 }, // 1436
  { PseudoVFNMADD_VV_MF4_MASK, VFNMADD_VV, 0x6 }, // 1437
  { PseudoVFNMADD_VV_MF2, VFNMADD_VV, 0x7 }, // 1438
  { PseudoVFNMADD_VV_MF2_MASK, VFNMADD_VV, 0x7 }, // 1439
  { PseudoVFNMSAC_VF16_M1, VFNMSAC_VF, 0x0 }, // 1440
  { PseudoVFNMSAC_VF16_M1_MASK, VFNMSAC_VF, 0x0 }, // 1441
  { PseudoVFNMSAC_VF32_M1, VFNMSAC_VF, 0x0 }, // 1442
  { PseudoVFNMSAC_VF32_M1_MASK, VFNMSAC_VF, 0x0 }, // 1443
  { PseudoVFNMSAC_VF64_M1, VFNMSAC_VF, 0x0 }, // 1444
  { PseudoVFNMSAC_VF64_M1_MASK, VFNMSAC_VF, 0x0 }, // 1445
  { PseudoVFNMSAC_VF16_M2, VFNMSAC_VF, 0x1 }, // 1446
  { PseudoVFNMSAC_VF16_M2_MASK, VFNMSAC_VF, 0x1 }, // 1447
  { PseudoVFNMSAC_VF32_M2, VFNMSAC_VF, 0x1 }, // 1448
  { PseudoVFNMSAC_VF32_M2_MASK, VFNMSAC_VF, 0x1 }, // 1449
  { PseudoVFNMSAC_VF64_M2, VFNMSAC_VF, 0x1 }, // 1450
  { PseudoVFNMSAC_VF64_M2_MASK, VFNMSAC_VF, 0x1 }, // 1451
  { PseudoVFNMSAC_VF16_M4, VFNMSAC_VF, 0x2 }, // 1452
  { PseudoVFNMSAC_VF16_M4_MASK, VFNMSAC_VF, 0x2 }, // 1453
  { PseudoVFNMSAC_VF32_M4, VFNMSAC_VF, 0x2 }, // 1454
  { PseudoVFNMSAC_VF32_M4_MASK, VFNMSAC_VF, 0x2 }, // 1455
  { PseudoVFNMSAC_VF64_M4, VFNMSAC_VF, 0x2 }, // 1456
  { PseudoVFNMSAC_VF64_M4_MASK, VFNMSAC_VF, 0x2 }, // 1457
  { PseudoVFNMSAC_VF16_M8, VFNMSAC_VF, 0x3 }, // 1458
  { PseudoVFNMSAC_VF16_M8_MASK, VFNMSAC_VF, 0x3 }, // 1459
  { PseudoVFNMSAC_VF32_M8, VFNMSAC_VF, 0x3 }, // 1460
  { PseudoVFNMSAC_VF32_M8_MASK, VFNMSAC_VF, 0x3 }, // 1461
  { PseudoVFNMSAC_VF64_M8, VFNMSAC_VF, 0x3 }, // 1462
  { PseudoVFNMSAC_VF64_M8_MASK, VFNMSAC_VF, 0x3 }, // 1463
  { PseudoVFNMSAC_VF16_MF4, VFNMSAC_VF, 0x6 }, // 1464
  { PseudoVFNMSAC_VF16_MF4_MASK, VFNMSAC_VF, 0x6 }, // 1465
  { PseudoVFNMSAC_VF16_MF2, VFNMSAC_VF, 0x7 }, // 1466
  { PseudoVFNMSAC_VF16_MF2_MASK, VFNMSAC_VF, 0x7 }, // 1467
  { PseudoVFNMSAC_VF32_MF2, VFNMSAC_VF, 0x7 }, // 1468
  { PseudoVFNMSAC_VF32_MF2_MASK, VFNMSAC_VF, 0x7 }, // 1469
  { PseudoVFNMSAC_VV_M1, VFNMSAC_VV, 0x0 }, // 1470
  { PseudoVFNMSAC_VV_M1_MASK, VFNMSAC_VV, 0x0 }, // 1471
  { PseudoVFNMSAC_VV_M2, VFNMSAC_VV, 0x1 }, // 1472
  { PseudoVFNMSAC_VV_M2_MASK, VFNMSAC_VV, 0x1 }, // 1473
  { PseudoVFNMSAC_VV_M4, VFNMSAC_VV, 0x2 }, // 1474
  { PseudoVFNMSAC_VV_M4_MASK, VFNMSAC_VV, 0x2 }, // 1475
  { PseudoVFNMSAC_VV_M8, VFNMSAC_VV, 0x3 }, // 1476
  { PseudoVFNMSAC_VV_M8_MASK, VFNMSAC_VV, 0x3 }, // 1477
  { PseudoVFNMSAC_VV_MF4, VFNMSAC_VV, 0x6 }, // 1478
  { PseudoVFNMSAC_VV_MF4_MASK, VFNMSAC_VV, 0x6 }, // 1479
  { PseudoVFNMSAC_VV_MF2, VFNMSAC_VV, 0x7 }, // 1480
  { PseudoVFNMSAC_VV_MF2_MASK, VFNMSAC_VV, 0x7 }, // 1481
  { PseudoVFNMSUB_VF16_M1, VFNMSUB_VF, 0x0 }, // 1482
  { PseudoVFNMSUB_VF16_M1_MASK, VFNMSUB_VF, 0x0 }, // 1483
  { PseudoVFNMSUB_VF32_M1, VFNMSUB_VF, 0x0 }, // 1484
  { PseudoVFNMSUB_VF32_M1_MASK, VFNMSUB_VF, 0x0 }, // 1485
  { PseudoVFNMSUB_VF64_M1, VFNMSUB_VF, 0x0 }, // 1486
  { PseudoVFNMSUB_VF64_M1_MASK, VFNMSUB_VF, 0x0 }, // 1487
  { PseudoVFNMSUB_VF16_M2, VFNMSUB_VF, 0x1 }, // 1488
  { PseudoVFNMSUB_VF16_M2_MASK, VFNMSUB_VF, 0x1 }, // 1489
  { PseudoVFNMSUB_VF32_M2, VFNMSUB_VF, 0x1 }, // 1490
  { PseudoVFNMSUB_VF32_M2_MASK, VFNMSUB_VF, 0x1 }, // 1491
  { PseudoVFNMSUB_VF64_M2, VFNMSUB_VF, 0x1 }, // 1492
  { PseudoVFNMSUB_VF64_M2_MASK, VFNMSUB_VF, 0x1 }, // 1493
  { PseudoVFNMSUB_VF16_M4, VFNMSUB_VF, 0x2 }, // 1494
  { PseudoVFNMSUB_VF16_M4_MASK, VFNMSUB_VF, 0x2 }, // 1495
  { PseudoVFNMSUB_VF32_M4, VFNMSUB_VF, 0x2 }, // 1496
  { PseudoVFNMSUB_VF32_M4_MASK, VFNMSUB_VF, 0x2 }, // 1497
  { PseudoVFNMSUB_VF64_M4, VFNMSUB_VF, 0x2 }, // 1498
  { PseudoVFNMSUB_VF64_M4_MASK, VFNMSUB_VF, 0x2 }, // 1499
  { PseudoVFNMSUB_VF16_M8, VFNMSUB_VF, 0x3 }, // 1500
  { PseudoVFNMSUB_VF16_M8_MASK, VFNMSUB_VF, 0x3 }, // 1501
  { PseudoVFNMSUB_VF32_M8, VFNMSUB_VF, 0x3 }, // 1502
  { PseudoVFNMSUB_VF32_M8_MASK, VFNMSUB_VF, 0x3 }, // 1503
  { PseudoVFNMSUB_VF64_M8, VFNMSUB_VF, 0x3 }, // 1504
  { PseudoVFNMSUB_VF64_M8_MASK, VFNMSUB_VF, 0x3 }, // 1505
  { PseudoVFNMSUB_VF16_MF4, VFNMSUB_VF, 0x6 }, // 1506
  { PseudoVFNMSUB_VF16_MF4_MASK, VFNMSUB_VF, 0x6 }, // 1507
  { PseudoVFNMSUB_VF16_MF2, VFNMSUB_VF, 0x7 }, // 1508
  { PseudoVFNMSUB_VF16_MF2_MASK, VFNMSUB_VF, 0x7 }, // 1509
  { PseudoVFNMSUB_VF32_MF2, VFNMSUB_VF, 0x7 }, // 1510
  { PseudoVFNMSUB_VF32_MF2_MASK, VFNMSUB_VF, 0x7 }, // 1511
  { PseudoVFNMSUB_VV_M1, VFNMSUB_VV, 0x0 }, // 1512
  { PseudoVFNMSUB_VV_M1_MASK, VFNMSUB_VV, 0x0 }, // 1513
  { PseudoVFNMSUB_VV_M2, VFNMSUB_VV, 0x1 }, // 1514
  { PseudoVFNMSUB_VV_M2_MASK, VFNMSUB_VV, 0x1 }, // 1515
  { PseudoVFNMSUB_VV_M4, VFNMSUB_VV, 0x2 }, // 1516
  { PseudoVFNMSUB_VV_M4_MASK, VFNMSUB_VV, 0x2 }, // 1517
  { PseudoVFNMSUB_VV_M8, VFNMSUB_VV, 0x3 }, // 1518
  { PseudoVFNMSUB_VV_M8_MASK, VFNMSUB_VV, 0x3 }, // 1519
  { PseudoVFNMSUB_VV_MF4, VFNMSUB_VV, 0x6 }, // 1520
  { PseudoVFNMSUB_VV_MF4_MASK, VFNMSUB_VV, 0x6 }, // 1521
  { PseudoVFNMSUB_VV_MF2, VFNMSUB_VV, 0x7 }, // 1522
  { PseudoVFNMSUB_VV_MF2_MASK, VFNMSUB_VV, 0x7 }, // 1523
  { PseudoVFRDIV_VF16_M1, VFRDIV_VF, 0x0 }, // 1524
  { PseudoVFRDIV_VF16_M1_MASK, VFRDIV_VF, 0x0 }, // 1525
  { PseudoVFRDIV_VF16_M1_TU, VFRDIV_VF, 0x0 }, // 1526
  { PseudoVFRDIV_VF32_M1, VFRDIV_VF, 0x0 }, // 1527
  { PseudoVFRDIV_VF32_M1_MASK, VFRDIV_VF, 0x0 }, // 1528
  { PseudoVFRDIV_VF32_M1_TU, VFRDIV_VF, 0x0 }, // 1529
  { PseudoVFRDIV_VF64_M1, VFRDIV_VF, 0x0 }, // 1530
  { PseudoVFRDIV_VF64_M1_MASK, VFRDIV_VF, 0x0 }, // 1531
  { PseudoVFRDIV_VF64_M1_TU, VFRDIV_VF, 0x0 }, // 1532
  { PseudoVFRDIV_VF16_M2, VFRDIV_VF, 0x1 }, // 1533
  { PseudoVFRDIV_VF16_M2_MASK, VFRDIV_VF, 0x1 }, // 1534
  { PseudoVFRDIV_VF16_M2_TU, VFRDIV_VF, 0x1 }, // 1535
  { PseudoVFRDIV_VF32_M2, VFRDIV_VF, 0x1 }, // 1536
  { PseudoVFRDIV_VF32_M2_MASK, VFRDIV_VF, 0x1 }, // 1537
  { PseudoVFRDIV_VF32_M2_TU, VFRDIV_VF, 0x1 }, // 1538
  { PseudoVFRDIV_VF64_M2, VFRDIV_VF, 0x1 }, // 1539
  { PseudoVFRDIV_VF64_M2_MASK, VFRDIV_VF, 0x1 }, // 1540
  { PseudoVFRDIV_VF64_M2_TU, VFRDIV_VF, 0x1 }, // 1541
  { PseudoVFRDIV_VF16_M4, VFRDIV_VF, 0x2 }, // 1542
  { PseudoVFRDIV_VF16_M4_MASK, VFRDIV_VF, 0x2 }, // 1543
  { PseudoVFRDIV_VF16_M4_TU, VFRDIV_VF, 0x2 }, // 1544
  { PseudoVFRDIV_VF32_M4, VFRDIV_VF, 0x2 }, // 1545
  { PseudoVFRDIV_VF32_M4_MASK, VFRDIV_VF, 0x2 }, // 1546
  { PseudoVFRDIV_VF32_M4_TU, VFRDIV_VF, 0x2 }, // 1547
  { PseudoVFRDIV_VF64_M4, VFRDIV_VF, 0x2 }, // 1548
  { PseudoVFRDIV_VF64_M4_MASK, VFRDIV_VF, 0x2 }, // 1549
  { PseudoVFRDIV_VF64_M4_TU, VFRDIV_VF, 0x2 }, // 1550
  { PseudoVFRDIV_VF16_M8, VFRDIV_VF, 0x3 }, // 1551
  { PseudoVFRDIV_VF16_M8_MASK, VFRDIV_VF, 0x3 }, // 1552
  { PseudoVFRDIV_VF16_M8_TU, VFRDIV_VF, 0x3 }, // 1553
  { PseudoVFRDIV_VF32_M8, VFRDIV_VF, 0x3 }, // 1554
  { PseudoVFRDIV_VF32_M8_MASK, VFRDIV_VF, 0x3 }, // 1555
  { PseudoVFRDIV_VF32_M8_TU, VFRDIV_VF, 0x3 }, // 1556
  { PseudoVFRDIV_VF64_M8, VFRDIV_VF, 0x3 }, // 1557
  { PseudoVFRDIV_VF64_M8_MASK, VFRDIV_VF, 0x3 }, // 1558
  { PseudoVFRDIV_VF64_M8_TU, VFRDIV_VF, 0x3 }, // 1559
  { PseudoVFRDIV_VF16_MF4, VFRDIV_VF, 0x6 }, // 1560
  { PseudoVFRDIV_VF16_MF4_MASK, VFRDIV_VF, 0x6 }, // 1561
  { PseudoVFRDIV_VF16_MF4_TU, VFRDIV_VF, 0x6 }, // 1562
  { PseudoVFRDIV_VF16_MF2, VFRDIV_VF, 0x7 }, // 1563
  { PseudoVFRDIV_VF16_MF2_MASK, VFRDIV_VF, 0x7 }, // 1564
  { PseudoVFRDIV_VF16_MF2_TU, VFRDIV_VF, 0x7 }, // 1565
  { PseudoVFRDIV_VF32_MF2, VFRDIV_VF, 0x7 }, // 1566
  { PseudoVFRDIV_VF32_MF2_MASK, VFRDIV_VF, 0x7 }, // 1567
  { PseudoVFRDIV_VF32_MF2_TU, VFRDIV_VF, 0x7 }, // 1568
  { PseudoVFREC7_V_M1, VFREC7_V, 0x0 }, // 1569
  { PseudoVFREC7_V_M1_MASK, VFREC7_V, 0x0 }, // 1570
  { PseudoVFREC7_V_M1_TU, VFREC7_V, 0x0 }, // 1571
  { PseudoVFREC7_V_M2, VFREC7_V, 0x1 }, // 1572
  { PseudoVFREC7_V_M2_MASK, VFREC7_V, 0x1 }, // 1573
  { PseudoVFREC7_V_M2_TU, VFREC7_V, 0x1 }, // 1574
  { PseudoVFREC7_V_M4, VFREC7_V, 0x2 }, // 1575
  { PseudoVFREC7_V_M4_MASK, VFREC7_V, 0x2 }, // 1576
  { PseudoVFREC7_V_M4_TU, VFREC7_V, 0x2 }, // 1577
  { PseudoVFREC7_V_M8, VFREC7_V, 0x3 }, // 1578
  { PseudoVFREC7_V_M8_MASK, VFREC7_V, 0x3 }, // 1579
  { PseudoVFREC7_V_M8_TU, VFREC7_V, 0x3 }, // 1580
  { PseudoVFREC7_V_MF4, VFREC7_V, 0x6 }, // 1581
  { PseudoVFREC7_V_MF4_MASK, VFREC7_V, 0x6 }, // 1582
  { PseudoVFREC7_V_MF4_TU, VFREC7_V, 0x6 }, // 1583
  { PseudoVFREC7_V_MF2, VFREC7_V, 0x7 }, // 1584
  { PseudoVFREC7_V_MF2_MASK, VFREC7_V, 0x7 }, // 1585
  { PseudoVFREC7_V_MF2_TU, VFREC7_V, 0x7 }, // 1586
  { PseudoVFREDMAX_VS_M1, VFREDMAX_VS, 0x0 }, // 1587
  { PseudoVFREDMAX_VS_M1_MASK, VFREDMAX_VS, 0x0 }, // 1588
  { PseudoVFREDMAX_VS_M2, VFREDMAX_VS, 0x1 }, // 1589
  { PseudoVFREDMAX_VS_M2_MASK, VFREDMAX_VS, 0x1 }, // 1590
  { PseudoVFREDMAX_VS_M4, VFREDMAX_VS, 0x2 }, // 1591
  { PseudoVFREDMAX_VS_M4_MASK, VFREDMAX_VS, 0x2 }, // 1592
  { PseudoVFREDMAX_VS_M8, VFREDMAX_VS, 0x3 }, // 1593
  { PseudoVFREDMAX_VS_M8_MASK, VFREDMAX_VS, 0x3 }, // 1594
  { PseudoVFREDMAX_VS_MF4, VFREDMAX_VS, 0x6 }, // 1595
  { PseudoVFREDMAX_VS_MF4_MASK, VFREDMAX_VS, 0x6 }, // 1596
  { PseudoVFREDMAX_VS_MF2, VFREDMAX_VS, 0x7 }, // 1597
  { PseudoVFREDMAX_VS_MF2_MASK, VFREDMAX_VS, 0x7 }, // 1598
  { PseudoVFREDMIN_VS_M1, VFREDMIN_VS, 0x0 }, // 1599
  { PseudoVFREDMIN_VS_M1_MASK, VFREDMIN_VS, 0x0 }, // 1600
  { PseudoVFREDMIN_VS_M2, VFREDMIN_VS, 0x1 }, // 1601
  { PseudoVFREDMIN_VS_M2_MASK, VFREDMIN_VS, 0x1 }, // 1602
  { PseudoVFREDMIN_VS_M4, VFREDMIN_VS, 0x2 }, // 1603
  { PseudoVFREDMIN_VS_M4_MASK, VFREDMIN_VS, 0x2 }, // 1604
  { PseudoVFREDMIN_VS_M8, VFREDMIN_VS, 0x3 }, // 1605
  { PseudoVFREDMIN_VS_M8_MASK, VFREDMIN_VS, 0x3 }, // 1606
  { PseudoVFREDMIN_VS_MF4, VFREDMIN_VS, 0x6 }, // 1607
  { PseudoVFREDMIN_VS_MF4_MASK, VFREDMIN_VS, 0x6 }, // 1608
  { PseudoVFREDMIN_VS_MF2, VFREDMIN_VS, 0x7 }, // 1609
  { PseudoVFREDMIN_VS_MF2_MASK, VFREDMIN_VS, 0x7 }, // 1610
  { PseudoVFREDOSUM_VS_M1, VFREDOSUM_VS, 0x0 }, // 1611
  { PseudoVFREDOSUM_VS_M1_MASK, VFREDOSUM_VS, 0x0 }, // 1612
  { PseudoVFREDOSUM_VS_M2, VFREDOSUM_VS, 0x1 }, // 1613
  { PseudoVFREDOSUM_VS_M2_MASK, VFREDOSUM_VS, 0x1 }, // 1614
  { PseudoVFREDOSUM_VS_M4, VFREDOSUM_VS, 0x2 }, // 1615
  { PseudoVFREDOSUM_VS_M4_MASK, VFREDOSUM_VS, 0x2 }, // 1616
  { PseudoVFREDOSUM_VS_M8, VFREDOSUM_VS, 0x3 }, // 1617
  { PseudoVFREDOSUM_VS_M8_MASK, VFREDOSUM_VS, 0x3 }, // 1618
  { PseudoVFREDOSUM_VS_MF4, VFREDOSUM_VS, 0x6 }, // 1619
  { PseudoVFREDOSUM_VS_MF4_MASK, VFREDOSUM_VS, 0x6 }, // 1620
  { PseudoVFREDOSUM_VS_MF2, VFREDOSUM_VS, 0x7 }, // 1621
  { PseudoVFREDOSUM_VS_MF2_MASK, VFREDOSUM_VS, 0x7 }, // 1622
  { PseudoVFREDUSUM_VS_M1, VFREDUSUM_VS, 0x0 }, // 1623
  { PseudoVFREDUSUM_VS_M1_MASK, VFREDUSUM_VS, 0x0 }, // 1624
  { PseudoVFREDUSUM_VS_M2, VFREDUSUM_VS, 0x1 }, // 1625
  { PseudoVFREDUSUM_VS_M2_MASK, VFREDUSUM_VS, 0x1 }, // 1626
  { PseudoVFREDUSUM_VS_M4, VFREDUSUM_VS, 0x2 }, // 1627
  { PseudoVFREDUSUM_VS_M4_MASK, VFREDUSUM_VS, 0x2 }, // 1628
  { PseudoVFREDUSUM_VS_M8, VFREDUSUM_VS, 0x3 }, // 1629
  { PseudoVFREDUSUM_VS_M8_MASK, VFREDUSUM_VS, 0x3 }, // 1630
  { PseudoVFREDUSUM_VS_MF4, VFREDUSUM_VS, 0x6 }, // 1631
  { PseudoVFREDUSUM_VS_MF4_MASK, VFREDUSUM_VS, 0x6 }, // 1632
  { PseudoVFREDUSUM_VS_MF2, VFREDUSUM_VS, 0x7 }, // 1633
  { PseudoVFREDUSUM_VS_MF2_MASK, VFREDUSUM_VS, 0x7 }, // 1634
  { PseudoVFRSQRT7_V_M1, VFRSQRT7_V, 0x0 }, // 1635
  { PseudoVFRSQRT7_V_M1_MASK, VFRSQRT7_V, 0x0 }, // 1636
  { PseudoVFRSQRT7_V_M1_TU, VFRSQRT7_V, 0x0 }, // 1637
  { PseudoVFRSQRT7_V_M2, VFRSQRT7_V, 0x1 }, // 1638
  { PseudoVFRSQRT7_V_M2_MASK, VFRSQRT7_V, 0x1 }, // 1639
  { PseudoVFRSQRT7_V_M2_TU, VFRSQRT7_V, 0x1 }, // 1640
  { PseudoVFRSQRT7_V_M4, VFRSQRT7_V, 0x2 }, // 1641
  { PseudoVFRSQRT7_V_M4_MASK, VFRSQRT7_V, 0x2 }, // 1642
  { PseudoVFRSQRT7_V_M4_TU, VFRSQRT7_V, 0x2 }, // 1643
  { PseudoVFRSQRT7_V_M8, VFRSQRT7_V, 0x3 }, // 1644
  { PseudoVFRSQRT7_V_M8_MASK, VFRSQRT7_V, 0x3 }, // 1645
  { PseudoVFRSQRT7_V_M8_TU, VFRSQRT7_V, 0x3 }, // 1646
  { PseudoVFRSQRT7_V_MF4, VFRSQRT7_V, 0x6 }, // 1647
  { PseudoVFRSQRT7_V_MF4_MASK, VFRSQRT7_V, 0x6 }, // 1648
  { PseudoVFRSQRT7_V_MF4_TU, VFRSQRT7_V, 0x6 }, // 1649
  { PseudoVFRSQRT7_V_MF2, VFRSQRT7_V, 0x7 }, // 1650
  { PseudoVFRSQRT7_V_MF2_MASK, VFRSQRT7_V, 0x7 }, // 1651
  { PseudoVFRSQRT7_V_MF2_TU, VFRSQRT7_V, 0x7 }, // 1652
  { PseudoVFRSUB_VF16_M1, VFRSUB_VF, 0x0 }, // 1653
  { PseudoVFRSUB_VF16_M1_MASK, VFRSUB_VF, 0x0 }, // 1654
  { PseudoVFRSUB_VF16_M1_TU, VFRSUB_VF, 0x0 }, // 1655
  { PseudoVFRSUB_VF32_M1, VFRSUB_VF, 0x0 }, // 1656
  { PseudoVFRSUB_VF32_M1_MASK, VFRSUB_VF, 0x0 }, // 1657
  { PseudoVFRSUB_VF32_M1_TU, VFRSUB_VF, 0x0 }, // 1658
  { PseudoVFRSUB_VF64_M1, VFRSUB_VF, 0x0 }, // 1659
  { PseudoVFRSUB_VF64_M1_MASK, VFRSUB_VF, 0x0 }, // 1660
  { PseudoVFRSUB_VF64_M1_TU, VFRSUB_VF, 0x0 }, // 1661
  { PseudoVFRSUB_VF16_M2, VFRSUB_VF, 0x1 }, // 1662
  { PseudoVFRSUB_VF16_M2_MASK, VFRSUB_VF, 0x1 }, // 1663
  { PseudoVFRSUB_VF16_M2_TU, VFRSUB_VF, 0x1 }, // 1664
  { PseudoVFRSUB_VF32_M2, VFRSUB_VF, 0x1 }, // 1665
  { PseudoVFRSUB_VF32_M2_MASK, VFRSUB_VF, 0x1 }, // 1666
  { PseudoVFRSUB_VF32_M2_TU, VFRSUB_VF, 0x1 }, // 1667
  { PseudoVFRSUB_VF64_M2, VFRSUB_VF, 0x1 }, // 1668
  { PseudoVFRSUB_VF64_M2_MASK, VFRSUB_VF, 0x1 }, // 1669
  { PseudoVFRSUB_VF64_M2_TU, VFRSUB_VF, 0x1 }, // 1670
  { PseudoVFRSUB_VF16_M4, VFRSUB_VF, 0x2 }, // 1671
  { PseudoVFRSUB_VF16_M4_MASK, VFRSUB_VF, 0x2 }, // 1672
  { PseudoVFRSUB_VF16_M4_TU, VFRSUB_VF, 0x2 }, // 1673
  { PseudoVFRSUB_VF32_M4, VFRSUB_VF, 0x2 }, // 1674
  { PseudoVFRSUB_VF32_M4_MASK, VFRSUB_VF, 0x2 }, // 1675
  { PseudoVFRSUB_VF32_M4_TU, VFRSUB_VF, 0x2 }, // 1676
  { PseudoVFRSUB_VF64_M4, VFRSUB_VF, 0x2 }, // 1677
  { PseudoVFRSUB_VF64_M4_MASK, VFRSUB_VF, 0x2 }, // 1678
  { PseudoVFRSUB_VF64_M4_TU, VFRSUB_VF, 0x2 }, // 1679
  { PseudoVFRSUB_VF16_M8, VFRSUB_VF, 0x3 }, // 1680
  { PseudoVFRSUB_VF16_M8_MASK, VFRSUB_VF, 0x3 }, // 1681
  { PseudoVFRSUB_VF16_M8_TU, VFRSUB_VF, 0x3 }, // 1682
  { PseudoVFRSUB_VF32_M8, VFRSUB_VF, 0x3 }, // 1683
  { PseudoVFRSUB_VF32_M8_MASK, VFRSUB_VF, 0x3 }, // 1684
  { PseudoVFRSUB_VF32_M8_TU, VFRSUB_VF, 0x3 }, // 1685
  { PseudoVFRSUB_VF64_M8, VFRSUB_VF, 0x3 }, // 1686
  { PseudoVFRSUB_VF64_M8_MASK, VFRSUB_VF, 0x3 }, // 1687
  { PseudoVFRSUB_VF64_M8_TU, VFRSUB_VF, 0x3 }, // 1688
  { PseudoVFRSUB_VF16_MF4, VFRSUB_VF, 0x6 }, // 1689
  { PseudoVFRSUB_VF16_MF4_MASK, VFRSUB_VF, 0x6 }, // 1690
  { PseudoVFRSUB_VF16_MF4_TU, VFRSUB_VF, 0x6 }, // 1691
  { PseudoVFRSUB_VF16_MF2, VFRSUB_VF, 0x7 }, // 1692
  { PseudoVFRSUB_VF16_MF2_MASK, VFRSUB_VF, 0x7 }, // 1693
  { PseudoVFRSUB_VF16_MF2_TU, VFRSUB_VF, 0x7 }, // 1694
  { PseudoVFRSUB_VF32_MF2, VFRSUB_VF, 0x7 }, // 1695
  { PseudoVFRSUB_VF32_MF2_MASK, VFRSUB_VF, 0x7 }, // 1696
  { PseudoVFRSUB_VF32_MF2_TU, VFRSUB_VF, 0x7 }, // 1697
  { PseudoVFSGNJN_VF16_M1, VFSGNJN_VF, 0x0 }, // 1698
  { PseudoVFSGNJN_VF16_M1_MASK, VFSGNJN_VF, 0x0 }, // 1699
  { PseudoVFSGNJN_VF16_M1_TU, VFSGNJN_VF, 0x0 }, // 1700
  { PseudoVFSGNJN_VF32_M1, VFSGNJN_VF, 0x0 }, // 1701
  { PseudoVFSGNJN_VF32_M1_MASK, VFSGNJN_VF, 0x0 }, // 1702
  { PseudoVFSGNJN_VF32_M1_TU, VFSGNJN_VF, 0x0 }, // 1703
  { PseudoVFSGNJN_VF64_M1, VFSGNJN_VF, 0x0 }, // 1704
  { PseudoVFSGNJN_VF64_M1_MASK, VFSGNJN_VF, 0x0 }, // 1705
  { PseudoVFSGNJN_VF64_M1_TU, VFSGNJN_VF, 0x0 }, // 1706
  { PseudoVFSGNJN_VF16_M2, VFSGNJN_VF, 0x1 }, // 1707
  { PseudoVFSGNJN_VF16_M2_MASK, VFSGNJN_VF, 0x1 }, // 1708
  { PseudoVFSGNJN_VF16_M2_TU, VFSGNJN_VF, 0x1 }, // 1709
  { PseudoVFSGNJN_VF32_M2, VFSGNJN_VF, 0x1 }, // 1710
  { PseudoVFSGNJN_VF32_M2_MASK, VFSGNJN_VF, 0x1 }, // 1711
  { PseudoVFSGNJN_VF32_M2_TU, VFSGNJN_VF, 0x1 }, // 1712
  { PseudoVFSGNJN_VF64_M2, VFSGNJN_VF, 0x1 }, // 1713
  { PseudoVFSGNJN_VF64_M2_MASK, VFSGNJN_VF, 0x1 }, // 1714
  { PseudoVFSGNJN_VF64_M2_TU, VFSGNJN_VF, 0x1 }, // 1715
  { PseudoVFSGNJN_VF16_M4, VFSGNJN_VF, 0x2 }, // 1716
  { PseudoVFSGNJN_VF16_M4_MASK, VFSGNJN_VF, 0x2 }, // 1717
  { PseudoVFSGNJN_VF16_M4_TU, VFSGNJN_VF, 0x2 }, // 1718
  { PseudoVFSGNJN_VF32_M4, VFSGNJN_VF, 0x2 }, // 1719
  { PseudoVFSGNJN_VF32_M4_MASK, VFSGNJN_VF, 0x2 }, // 1720
  { PseudoVFSGNJN_VF32_M4_TU, VFSGNJN_VF, 0x2 }, // 1721
  { PseudoVFSGNJN_VF64_M4, VFSGNJN_VF, 0x2 }, // 1722
  { PseudoVFSGNJN_VF64_M4_MASK, VFSGNJN_VF, 0x2 }, // 1723
  { PseudoVFSGNJN_VF64_M4_TU, VFSGNJN_VF, 0x2 }, // 1724
  { PseudoVFSGNJN_VF16_M8, VFSGNJN_VF, 0x3 }, // 1725
  { PseudoVFSGNJN_VF16_M8_MASK, VFSGNJN_VF, 0x3 }, // 1726
  { PseudoVFSGNJN_VF16_M8_TU, VFSGNJN_VF, 0x3 }, // 1727
  { PseudoVFSGNJN_VF32_M8, VFSGNJN_VF, 0x3 }, // 1728
  { PseudoVFSGNJN_VF32_M8_MASK, VFSGNJN_VF, 0x3 }, // 1729
  { PseudoVFSGNJN_VF32_M8_TU, VFSGNJN_VF, 0x3 }, // 1730
  { PseudoVFSGNJN_VF64_M8, VFSGNJN_VF, 0x3 }, // 1731
  { PseudoVFSGNJN_VF64_M8_MASK, VFSGNJN_VF, 0x3 }, // 1732
  { PseudoVFSGNJN_VF64_M8_TU, VFSGNJN_VF, 0x3 }, // 1733
  { PseudoVFSGNJN_VF16_MF4, VFSGNJN_VF, 0x6 }, // 1734
  { PseudoVFSGNJN_VF16_MF4_MASK, VFSGNJN_VF, 0x6 }, // 1735
  { PseudoVFSGNJN_VF16_MF4_TU, VFSGNJN_VF, 0x6 }, // 1736
  { PseudoVFSGNJN_VF16_MF2, VFSGNJN_VF, 0x7 }, // 1737
  { PseudoVFSGNJN_VF16_MF2_MASK, VFSGNJN_VF, 0x7 }, // 1738
  { PseudoVFSGNJN_VF16_MF2_TU, VFSGNJN_VF, 0x7 }, // 1739
  { PseudoVFSGNJN_VF32_MF2, VFSGNJN_VF, 0x7 }, // 1740
  { PseudoVFSGNJN_VF32_MF2_MASK, VFSGNJN_VF, 0x7 }, // 1741
  { PseudoVFSGNJN_VF32_MF2_TU, VFSGNJN_VF, 0x7 }, // 1742
  { PseudoVFSGNJN_VV_M1, VFSGNJN_VV, 0x0 }, // 1743
  { PseudoVFSGNJN_VV_M1_MASK, VFSGNJN_VV, 0x0 }, // 1744
  { PseudoVFSGNJN_VV_M1_TU, VFSGNJN_VV, 0x0 }, // 1745
  { PseudoVFSGNJN_VV_M2, VFSGNJN_VV, 0x1 }, // 1746
  { PseudoVFSGNJN_VV_M2_MASK, VFSGNJN_VV, 0x1 }, // 1747
  { PseudoVFSGNJN_VV_M2_TU, VFSGNJN_VV, 0x1 }, // 1748
  { PseudoVFSGNJN_VV_M4, VFSGNJN_VV, 0x2 }, // 1749
  { PseudoVFSGNJN_VV_M4_MASK, VFSGNJN_VV, 0x2 }, // 1750
  { PseudoVFSGNJN_VV_M4_TU, VFSGNJN_VV, 0x2 }, // 1751
  { PseudoVFSGNJN_VV_M8, VFSGNJN_VV, 0x3 }, // 1752
  { PseudoVFSGNJN_VV_M8_MASK, VFSGNJN_VV, 0x3 }, // 1753
  { PseudoVFSGNJN_VV_M8_TU, VFSGNJN_VV, 0x3 }, // 1754
  { PseudoVFSGNJN_VV_MF4, VFSGNJN_VV, 0x6 }, // 1755
  { PseudoVFSGNJN_VV_MF4_MASK, VFSGNJN_VV, 0x6 }, // 1756
  { PseudoVFSGNJN_VV_MF4_TU, VFSGNJN_VV, 0x6 }, // 1757
  { PseudoVFSGNJN_VV_MF2, VFSGNJN_VV, 0x7 }, // 1758
  { PseudoVFSGNJN_VV_MF2_MASK, VFSGNJN_VV, 0x7 }, // 1759
  { PseudoVFSGNJN_VV_MF2_TU, VFSGNJN_VV, 0x7 }, // 1760
  { PseudoVFSGNJX_VF16_M1, VFSGNJX_VF, 0x0 }, // 1761
  { PseudoVFSGNJX_VF16_M1_MASK, VFSGNJX_VF, 0x0 }, // 1762
  { PseudoVFSGNJX_VF16_M1_TU, VFSGNJX_VF, 0x0 }, // 1763
  { PseudoVFSGNJX_VF32_M1, VFSGNJX_VF, 0x0 }, // 1764
  { PseudoVFSGNJX_VF32_M1_MASK, VFSGNJX_VF, 0x0 }, // 1765
  { PseudoVFSGNJX_VF32_M1_TU, VFSGNJX_VF, 0x0 }, // 1766
  { PseudoVFSGNJX_VF64_M1, VFSGNJX_VF, 0x0 }, // 1767
  { PseudoVFSGNJX_VF64_M1_MASK, VFSGNJX_VF, 0x0 }, // 1768
  { PseudoVFSGNJX_VF64_M1_TU, VFSGNJX_VF, 0x0 }, // 1769
  { PseudoVFSGNJX_VF16_M2, VFSGNJX_VF, 0x1 }, // 1770
  { PseudoVFSGNJX_VF16_M2_MASK, VFSGNJX_VF, 0x1 }, // 1771
  { PseudoVFSGNJX_VF16_M2_TU, VFSGNJX_VF, 0x1 }, // 1772
  { PseudoVFSGNJX_VF32_M2, VFSGNJX_VF, 0x1 }, // 1773
  { PseudoVFSGNJX_VF32_M2_MASK, VFSGNJX_VF, 0x1 }, // 1774
  { PseudoVFSGNJX_VF32_M2_TU, VFSGNJX_VF, 0x1 }, // 1775
  { PseudoVFSGNJX_VF64_M2, VFSGNJX_VF, 0x1 }, // 1776
  { PseudoVFSGNJX_VF64_M2_MASK, VFSGNJX_VF, 0x1 }, // 1777
  { PseudoVFSGNJX_VF64_M2_TU, VFSGNJX_VF, 0x1 }, // 1778
  { PseudoVFSGNJX_VF16_M4, VFSGNJX_VF, 0x2 }, // 1779
  { PseudoVFSGNJX_VF16_M4_MASK, VFSGNJX_VF, 0x2 }, // 1780
  { PseudoVFSGNJX_VF16_M4_TU, VFSGNJX_VF, 0x2 }, // 1781
  { PseudoVFSGNJX_VF32_M4, VFSGNJX_VF, 0x2 }, // 1782
  { PseudoVFSGNJX_VF32_M4_MASK, VFSGNJX_VF, 0x2 }, // 1783
  { PseudoVFSGNJX_VF32_M4_TU, VFSGNJX_VF, 0x2 }, // 1784
  { PseudoVFSGNJX_VF64_M4, VFSGNJX_VF, 0x2 }, // 1785
  { PseudoVFSGNJX_VF64_M4_MASK, VFSGNJX_VF, 0x2 }, // 1786
  { PseudoVFSGNJX_VF64_M4_TU, VFSGNJX_VF, 0x2 }, // 1787
  { PseudoVFSGNJX_VF16_M8, VFSGNJX_VF, 0x3 }, // 1788
  { PseudoVFSGNJX_VF16_M8_MASK, VFSGNJX_VF, 0x3 }, // 1789
  { PseudoVFSGNJX_VF16_M8_TU, VFSGNJX_VF, 0x3 }, // 1790
  { PseudoVFSGNJX_VF32_M8, VFSGNJX_VF, 0x3 }, // 1791
  { PseudoVFSGNJX_VF32_M8_MASK, VFSGNJX_VF, 0x3 }, // 1792
  { PseudoVFSGNJX_VF32_M8_TU, VFSGNJX_VF, 0x3 }, // 1793
  { PseudoVFSGNJX_VF64_M8, VFSGNJX_VF, 0x3 }, // 1794
  { PseudoVFSGNJX_VF64_M8_MASK, VFSGNJX_VF, 0x3 }, // 1795
  { PseudoVFSGNJX_VF64_M8_TU, VFSGNJX_VF, 0x3 }, // 1796
  { PseudoVFSGNJX_VF16_MF4, VFSGNJX_VF, 0x6 }, // 1797
  { PseudoVFSGNJX_VF16_MF4_MASK, VFSGNJX_VF, 0x6 }, // 1798
  { PseudoVFSGNJX_VF16_MF4_TU, VFSGNJX_VF, 0x6 }, // 1799
  { PseudoVFSGNJX_VF16_MF2, VFSGNJX_VF, 0x7 }, // 1800
  { PseudoVFSGNJX_VF16_MF2_MASK, VFSGNJX_VF, 0x7 }, // 1801
  { PseudoVFSGNJX_VF16_MF2_TU, VFSGNJX_VF, 0x7 }, // 1802
  { PseudoVFSGNJX_VF32_MF2, VFSGNJX_VF, 0x7 }, // 1803
  { PseudoVFSGNJX_VF32_MF2_MASK, VFSGNJX_VF, 0x7 }, // 1804
  { PseudoVFSGNJX_VF32_MF2_TU, VFSGNJX_VF, 0x7 }, // 1805
  { PseudoVFSGNJX_VV_M1, VFSGNJX_VV, 0x0 }, // 1806
  { PseudoVFSGNJX_VV_M1_MASK, VFSGNJX_VV, 0x0 }, // 1807
  { PseudoVFSGNJX_VV_M1_TU, VFSGNJX_VV, 0x0 }, // 1808
  { PseudoVFSGNJX_VV_M2, VFSGNJX_VV, 0x1 }, // 1809
  { PseudoVFSGNJX_VV_M2_MASK, VFSGNJX_VV, 0x1 }, // 1810
  { PseudoVFSGNJX_VV_M2_TU, VFSGNJX_VV, 0x1 }, // 1811
  { PseudoVFSGNJX_VV_M4, VFSGNJX_VV, 0x2 }, // 1812
  { PseudoVFSGNJX_VV_M4_MASK, VFSGNJX_VV, 0x2 }, // 1813
  { PseudoVFSGNJX_VV_M4_TU, VFSGNJX_VV, 0x2 }, // 1814
  { PseudoVFSGNJX_VV_M8, VFSGNJX_VV, 0x3 }, // 1815
  { PseudoVFSGNJX_VV_M8_MASK, VFSGNJX_VV, 0x3 }, // 1816
  { PseudoVFSGNJX_VV_M8_TU, VFSGNJX_VV, 0x3 }, // 1817
  { PseudoVFSGNJX_VV_MF4, VFSGNJX_VV, 0x6 }, // 1818
  { PseudoVFSGNJX_VV_MF4_MASK, VFSGNJX_VV, 0x6 }, // 1819
  { PseudoVFSGNJX_VV_MF4_TU, VFSGNJX_VV, 0x6 }, // 1820
  { PseudoVFSGNJX_VV_MF2, VFSGNJX_VV, 0x7 }, // 1821
  { PseudoVFSGNJX_VV_MF2_MASK, VFSGNJX_VV, 0x7 }, // 1822
  { PseudoVFSGNJX_VV_MF2_TU, VFSGNJX_VV, 0x7 }, // 1823
  { PseudoVFSGNJ_VF16_M1, VFSGNJ_VF, 0x0 }, // 1824
  { PseudoVFSGNJ_VF16_M1_MASK, VFSGNJ_VF, 0x0 }, // 1825
  { PseudoVFSGNJ_VF16_M1_TU, VFSGNJ_VF, 0x0 }, // 1826
  { PseudoVFSGNJ_VF32_M1, VFSGNJ_VF, 0x0 }, // 1827
  { PseudoVFSGNJ_VF32_M1_MASK, VFSGNJ_VF, 0x0 }, // 1828
  { PseudoVFSGNJ_VF32_M1_TU, VFSGNJ_VF, 0x0 }, // 1829
  { PseudoVFSGNJ_VF64_M1, VFSGNJ_VF, 0x0 }, // 1830
  { PseudoVFSGNJ_VF64_M1_MASK, VFSGNJ_VF, 0x0 }, // 1831
  { PseudoVFSGNJ_VF64_M1_TU, VFSGNJ_VF, 0x0 }, // 1832
  { PseudoVFSGNJ_VF16_M2, VFSGNJ_VF, 0x1 }, // 1833
  { PseudoVFSGNJ_VF16_M2_MASK, VFSGNJ_VF, 0x1 }, // 1834
  { PseudoVFSGNJ_VF16_M2_TU, VFSGNJ_VF, 0x1 }, // 1835
  { PseudoVFSGNJ_VF32_M2, VFSGNJ_VF, 0x1 }, // 1836
  { PseudoVFSGNJ_VF32_M2_MASK, VFSGNJ_VF, 0x1 }, // 1837
  { PseudoVFSGNJ_VF32_M2_TU, VFSGNJ_VF, 0x1 }, // 1838
  { PseudoVFSGNJ_VF64_M2, VFSGNJ_VF, 0x1 }, // 1839
  { PseudoVFSGNJ_VF64_M2_MASK, VFSGNJ_VF, 0x1 }, // 1840
  { PseudoVFSGNJ_VF64_M2_TU, VFSGNJ_VF, 0x1 }, // 1841
  { PseudoVFSGNJ_VF16_M4, VFSGNJ_VF, 0x2 }, // 1842
  { PseudoVFSGNJ_VF16_M4_MASK, VFSGNJ_VF, 0x2 }, // 1843
  { PseudoVFSGNJ_VF16_M4_TU, VFSGNJ_VF, 0x2 }, // 1844
  { PseudoVFSGNJ_VF32_M4, VFSGNJ_VF, 0x2 }, // 1845
  { PseudoVFSGNJ_VF32_M4_MASK, VFSGNJ_VF, 0x2 }, // 1846
  { PseudoVFSGNJ_VF32_M4_TU, VFSGNJ_VF, 0x2 }, // 1847
  { PseudoVFSGNJ_VF64_M4, VFSGNJ_VF, 0x2 }, // 1848
  { PseudoVFSGNJ_VF64_M4_MASK, VFSGNJ_VF, 0x2 }, // 1849
  { PseudoVFSGNJ_VF64_M4_TU, VFSGNJ_VF, 0x2 }, // 1850
  { PseudoVFSGNJ_VF16_M8, VFSGNJ_VF, 0x3 }, // 1851
  { PseudoVFSGNJ_VF16_M8_MASK, VFSGNJ_VF, 0x3 }, // 1852
  { PseudoVFSGNJ_VF16_M8_TU, VFSGNJ_VF, 0x3 }, // 1853
  { PseudoVFSGNJ_VF32_M8, VFSGNJ_VF, 0x3 }, // 1854
  { PseudoVFSGNJ_VF32_M8_MASK, VFSGNJ_VF, 0x3 }, // 1855
  { PseudoVFSGNJ_VF32_M8_TU, VFSGNJ_VF, 0x3 }, // 1856
  { PseudoVFSGNJ_VF64_M8, VFSGNJ_VF, 0x3 }, // 1857
  { PseudoVFSGNJ_VF64_M8_MASK, VFSGNJ_VF, 0x3 }, // 1858
  { PseudoVFSGNJ_VF64_M8_TU, VFSGNJ_VF, 0x3 }, // 1859
  { PseudoVFSGNJ_VF16_MF4, VFSGNJ_VF, 0x6 }, // 1860
  { PseudoVFSGNJ_VF16_MF4_MASK, VFSGNJ_VF, 0x6 }, // 1861
  { PseudoVFSGNJ_VF16_MF4_TU, VFSGNJ_VF, 0x6 }, // 1862
  { PseudoVFSGNJ_VF16_MF2, VFSGNJ_VF, 0x7 }, // 1863
  { PseudoVFSGNJ_VF16_MF2_MASK, VFSGNJ_VF, 0x7 }, // 1864
  { PseudoVFSGNJ_VF16_MF2_TU, VFSGNJ_VF, 0x7 }, // 1865
  { PseudoVFSGNJ_VF32_MF2, VFSGNJ_VF, 0x7 }, // 1866
  { PseudoVFSGNJ_VF32_MF2_MASK, VFSGNJ_VF, 0x7 }, // 1867
  { PseudoVFSGNJ_VF32_MF2_TU, VFSGNJ_VF, 0x7 }, // 1868
  { PseudoVFSGNJ_VV_M1, VFSGNJ_VV, 0x0 }, // 1869
  { PseudoVFSGNJ_VV_M1_MASK, VFSGNJ_VV, 0x0 }, // 1870
  { PseudoVFSGNJ_VV_M1_TU, VFSGNJ_VV, 0x0 }, // 1871
  { PseudoVFSGNJ_VV_M2, VFSGNJ_VV, 0x1 }, // 1872
  { PseudoVFSGNJ_VV_M2_MASK, VFSGNJ_VV, 0x1 }, // 1873
  { PseudoVFSGNJ_VV_M2_TU, VFSGNJ_VV, 0x1 }, // 1874
  { PseudoVFSGNJ_VV_M4, VFSGNJ_VV, 0x2 }, // 1875
  { PseudoVFSGNJ_VV_M4_MASK, VFSGNJ_VV, 0x2 }, // 1876
  { PseudoVFSGNJ_VV_M4_TU, VFSGNJ_VV, 0x2 }, // 1877
  { PseudoVFSGNJ_VV_M8, VFSGNJ_VV, 0x3 }, // 1878
  { PseudoVFSGNJ_VV_M8_MASK, VFSGNJ_VV, 0x3 }, // 1879
  { PseudoVFSGNJ_VV_M8_TU, VFSGNJ_VV, 0x3 }, // 1880
  { PseudoVFSGNJ_VV_MF4, VFSGNJ_VV, 0x6 }, // 1881
  { PseudoVFSGNJ_VV_MF4_MASK, VFSGNJ_VV, 0x6 }, // 1882
  { PseudoVFSGNJ_VV_MF4_TU, VFSGNJ_VV, 0x6 }, // 1883
  { PseudoVFSGNJ_VV_MF2, VFSGNJ_VV, 0x7 }, // 1884
  { PseudoVFSGNJ_VV_MF2_MASK, VFSGNJ_VV, 0x7 }, // 1885
  { PseudoVFSGNJ_VV_MF2_TU, VFSGNJ_VV, 0x7 }, // 1886
  { PseudoVFSLIDE1DOWN_VF16_M1, VFSLIDE1DOWN_VF, 0x0 }, // 1887
  { PseudoVFSLIDE1DOWN_VF16_M1_MASK, VFSLIDE1DOWN_VF, 0x0 }, // 1888
  { PseudoVFSLIDE1DOWN_VF16_M1_TU, VFSLIDE1DOWN_VF, 0x0 }, // 1889
  { PseudoVFSLIDE1DOWN_VF32_M1, VFSLIDE1DOWN_VF, 0x0 }, // 1890
  { PseudoVFSLIDE1DOWN_VF32_M1_MASK, VFSLIDE1DOWN_VF, 0x0 }, // 1891
  { PseudoVFSLIDE1DOWN_VF32_M1_TU, VFSLIDE1DOWN_VF, 0x0 }, // 1892
  { PseudoVFSLIDE1DOWN_VF64_M1, VFSLIDE1DOWN_VF, 0x0 }, // 1893
  { PseudoVFSLIDE1DOWN_VF64_M1_MASK, VFSLIDE1DOWN_VF, 0x0 }, // 1894
  { PseudoVFSLIDE1DOWN_VF64_M1_TU, VFSLIDE1DOWN_VF, 0x0 }, // 1895
  { PseudoVFSLIDE1DOWN_VF16_M2, VFSLIDE1DOWN_VF, 0x1 }, // 1896
  { PseudoVFSLIDE1DOWN_VF16_M2_MASK, VFSLIDE1DOWN_VF, 0x1 }, // 1897
  { PseudoVFSLIDE1DOWN_VF16_M2_TU, VFSLIDE1DOWN_VF, 0x1 }, // 1898
  { PseudoVFSLIDE1DOWN_VF32_M2, VFSLIDE1DOWN_VF, 0x1 }, // 1899
  { PseudoVFSLIDE1DOWN_VF32_M2_MASK, VFSLIDE1DOWN_VF, 0x1 }, // 1900
  { PseudoVFSLIDE1DOWN_VF32_M2_TU, VFSLIDE1DOWN_VF, 0x1 }, // 1901
  { PseudoVFSLIDE1DOWN_VF64_M2, VFSLIDE1DOWN_VF, 0x1 }, // 1902
  { PseudoVFSLIDE1DOWN_VF64_M2_MASK, VFSLIDE1DOWN_VF, 0x1 }, // 1903
  { PseudoVFSLIDE1DOWN_VF64_M2_TU, VFSLIDE1DOWN_VF, 0x1 }, // 1904
  { PseudoVFSLIDE1DOWN_VF16_M4, VFSLIDE1DOWN_VF, 0x2 }, // 1905
  { PseudoVFSLIDE1DOWN_VF16_M4_MASK, VFSLIDE1DOWN_VF, 0x2 }, // 1906
  { PseudoVFSLIDE1DOWN_VF16_M4_TU, VFSLIDE1DOWN_VF, 0x2 }, // 1907
  { PseudoVFSLIDE1DOWN_VF32_M4, VFSLIDE1DOWN_VF, 0x2 }, // 1908
  { PseudoVFSLIDE1DOWN_VF32_M4_MASK, VFSLIDE1DOWN_VF, 0x2 }, // 1909
  { PseudoVFSLIDE1DOWN_VF32_M4_TU, VFSLIDE1DOWN_VF, 0x2 }, // 1910
  { PseudoVFSLIDE1DOWN_VF64_M4, VFSLIDE1DOWN_VF, 0x2 }, // 1911
  { PseudoVFSLIDE1DOWN_VF64_M4_MASK, VFSLIDE1DOWN_VF, 0x2 }, // 1912
  { PseudoVFSLIDE1DOWN_VF64_M4_TU, VFSLIDE1DOWN_VF, 0x2 }, // 1913
  { PseudoVFSLIDE1DOWN_VF16_M8, VFSLIDE1DOWN_VF, 0x3 }, // 1914
  { PseudoVFSLIDE1DOWN_VF16_M8_MASK, VFSLIDE1DOWN_VF, 0x3 }, // 1915
  { PseudoVFSLIDE1DOWN_VF16_M8_TU, VFSLIDE1DOWN_VF, 0x3 }, // 1916
  { PseudoVFSLIDE1DOWN_VF32_M8, VFSLIDE1DOWN_VF, 0x3 }, // 1917
  { PseudoVFSLIDE1DOWN_VF32_M8_MASK, VFSLIDE1DOWN_VF, 0x3 }, // 1918
  { PseudoVFSLIDE1DOWN_VF32_M8_TU, VFSLIDE1DOWN_VF, 0x3 }, // 1919
  { PseudoVFSLIDE1DOWN_VF64_M8, VFSLIDE1DOWN_VF, 0x3 }, // 1920
  { PseudoVFSLIDE1DOWN_VF64_M8_MASK, VFSLIDE1DOWN_VF, 0x3 }, // 1921
  { PseudoVFSLIDE1DOWN_VF64_M8_TU, VFSLIDE1DOWN_VF, 0x3 }, // 1922
  { PseudoVFSLIDE1DOWN_VF16_MF4, VFSLIDE1DOWN_VF, 0x6 }, // 1923
  { PseudoVFSLIDE1DOWN_VF16_MF4_MASK, VFSLIDE1DOWN_VF, 0x6 }, // 1924
  { PseudoVFSLIDE1DOWN_VF16_MF4_TU, VFSLIDE1DOWN_VF, 0x6 }, // 1925
  { PseudoVFSLIDE1DOWN_VF16_MF2, VFSLIDE1DOWN_VF, 0x7 }, // 1926
  { PseudoVFSLIDE1DOWN_VF16_MF2_MASK, VFSLIDE1DOWN_VF, 0x7 }, // 1927
  { PseudoVFSLIDE1DOWN_VF16_MF2_TU, VFSLIDE1DOWN_VF, 0x7 }, // 1928
  { PseudoVFSLIDE1DOWN_VF32_MF2, VFSLIDE1DOWN_VF, 0x7 }, // 1929
  { PseudoVFSLIDE1DOWN_VF32_MF2_MASK, VFSLIDE1DOWN_VF, 0x7 }, // 1930
  { PseudoVFSLIDE1DOWN_VF32_MF2_TU, VFSLIDE1DOWN_VF, 0x7 }, // 1931
  { PseudoVFSLIDE1UP_VF16_M1, VFSLIDE1UP_VF, 0x0 }, // 1932
  { PseudoVFSLIDE1UP_VF16_M1_MASK, VFSLIDE1UP_VF, 0x0 }, // 1933
  { PseudoVFSLIDE1UP_VF16_M1_TU, VFSLIDE1UP_VF, 0x0 }, // 1934
  { PseudoVFSLIDE1UP_VF32_M1, VFSLIDE1UP_VF, 0x0 }, // 1935
  { PseudoVFSLIDE1UP_VF32_M1_MASK, VFSLIDE1UP_VF, 0x0 }, // 1936
  { PseudoVFSLIDE1UP_VF32_M1_TU, VFSLIDE1UP_VF, 0x0 }, // 1937
  { PseudoVFSLIDE1UP_VF64_M1, VFSLIDE1UP_VF, 0x0 }, // 1938
  { PseudoVFSLIDE1UP_VF64_M1_MASK, VFSLIDE1UP_VF, 0x0 }, // 1939
  { PseudoVFSLIDE1UP_VF64_M1_TU, VFSLIDE1UP_VF, 0x0 }, // 1940
  { PseudoVFSLIDE1UP_VF16_M2, VFSLIDE1UP_VF, 0x1 }, // 1941
  { PseudoVFSLIDE1UP_VF16_M2_MASK, VFSLIDE1UP_VF, 0x1 }, // 1942
  { PseudoVFSLIDE1UP_VF16_M2_TU, VFSLIDE1UP_VF, 0x1 }, // 1943
  { PseudoVFSLIDE1UP_VF32_M2, VFSLIDE1UP_VF, 0x1 }, // 1944
  { PseudoVFSLIDE1UP_VF32_M2_MASK, VFSLIDE1UP_VF, 0x1 }, // 1945
  { PseudoVFSLIDE1UP_VF32_M2_TU, VFSLIDE1UP_VF, 0x1 }, // 1946
  { PseudoVFSLIDE1UP_VF64_M2, VFSLIDE1UP_VF, 0x1 }, // 1947
  { PseudoVFSLIDE1UP_VF64_M2_MASK, VFSLIDE1UP_VF, 0x1 }, // 1948
  { PseudoVFSLIDE1UP_VF64_M2_TU, VFSLIDE1UP_VF, 0x1 }, // 1949
  { PseudoVFSLIDE1UP_VF16_M4, VFSLIDE1UP_VF, 0x2 }, // 1950
  { PseudoVFSLIDE1UP_VF16_M4_MASK, VFSLIDE1UP_VF, 0x2 }, // 1951
  { PseudoVFSLIDE1UP_VF16_M4_TU, VFSLIDE1UP_VF, 0x2 }, // 1952
  { PseudoVFSLIDE1UP_VF32_M4, VFSLIDE1UP_VF, 0x2 }, // 1953
  { PseudoVFSLIDE1UP_VF32_M4_MASK, VFSLIDE1UP_VF, 0x2 }, // 1954
  { PseudoVFSLIDE1UP_VF32_M4_TU, VFSLIDE1UP_VF, 0x2 }, // 1955
  { PseudoVFSLIDE1UP_VF64_M4, VFSLIDE1UP_VF, 0x2 }, // 1956
  { PseudoVFSLIDE1UP_VF64_M4_MASK, VFSLIDE1UP_VF, 0x2 }, // 1957
  { PseudoVFSLIDE1UP_VF64_M4_TU, VFSLIDE1UP_VF, 0x2 }, // 1958
  { PseudoVFSLIDE1UP_VF16_M8, VFSLIDE1UP_VF, 0x3 }, // 1959
  { PseudoVFSLIDE1UP_VF16_M8_MASK, VFSLIDE1UP_VF, 0x3 }, // 1960
  { PseudoVFSLIDE1UP_VF16_M8_TU, VFSLIDE1UP_VF, 0x3 }, // 1961
  { PseudoVFSLIDE1UP_VF32_M8, VFSLIDE1UP_VF, 0x3 }, // 1962
  { PseudoVFSLIDE1UP_VF32_M8_MASK, VFSLIDE1UP_VF, 0x3 }, // 1963
  { PseudoVFSLIDE1UP_VF32_M8_TU, VFSLIDE1UP_VF, 0x3 }, // 1964
  { PseudoVFSLIDE1UP_VF64_M8, VFSLIDE1UP_VF, 0x3 }, // 1965
  { PseudoVFSLIDE1UP_VF64_M8_MASK, VFSLIDE1UP_VF, 0x3 }, // 1966
  { PseudoVFSLIDE1UP_VF64_M8_TU, VFSLIDE1UP_VF, 0x3 }, // 1967
  { PseudoVFSLIDE1UP_VF16_MF4, VFSLIDE1UP_VF, 0x6 }, // 1968
  { PseudoVFSLIDE1UP_VF16_MF4_MASK, VFSLIDE1UP_VF, 0x6 }, // 1969
  { PseudoVFSLIDE1UP_VF16_MF4_TU, VFSLIDE1UP_VF, 0x6 }, // 1970
  { PseudoVFSLIDE1UP_VF16_MF2, VFSLIDE1UP_VF, 0x7 }, // 1971
  { PseudoVFSLIDE1UP_VF16_MF2_MASK, VFSLIDE1UP_VF, 0x7 }, // 1972
  { PseudoVFSLIDE1UP_VF16_MF2_TU, VFSLIDE1UP_VF, 0x7 }, // 1973
  { PseudoVFSLIDE1UP_VF32_MF2, VFSLIDE1UP_VF, 0x7 }, // 1974
  { PseudoVFSLIDE1UP_VF32_MF2_MASK, VFSLIDE1UP_VF, 0x7 }, // 1975
  { PseudoVFSLIDE1UP_VF32_MF2_TU, VFSLIDE1UP_VF, 0x7 }, // 1976
  { PseudoVFSQRT_V_M1, VFSQRT_V, 0x0 }, // 1977
  { PseudoVFSQRT_V_M1_MASK, VFSQRT_V, 0x0 }, // 1978
  { PseudoVFSQRT_V_M1_TU, VFSQRT_V, 0x0 }, // 1979
  { PseudoVFSQRT_V_M2, VFSQRT_V, 0x1 }, // 1980
  { PseudoVFSQRT_V_M2_MASK, VFSQRT_V, 0x1 }, // 1981
  { PseudoVFSQRT_V_M2_TU, VFSQRT_V, 0x1 }, // 1982
  { PseudoVFSQRT_V_M4, VFSQRT_V, 0x2 }, // 1983
  { PseudoVFSQRT_V_M4_MASK, VFSQRT_V, 0x2 }, // 1984
  { PseudoVFSQRT_V_M4_TU, VFSQRT_V, 0x2 }, // 1985
  { PseudoVFSQRT_V_M8, VFSQRT_V, 0x3 }, // 1986
  { PseudoVFSQRT_V_M8_MASK, VFSQRT_V, 0x3 }, // 1987
  { PseudoVFSQRT_V_M8_TU, VFSQRT_V, 0x3 }, // 1988
  { PseudoVFSQRT_V_MF4, VFSQRT_V, 0x6 }, // 1989
  { PseudoVFSQRT_V_MF4_MASK, VFSQRT_V, 0x6 }, // 1990
  { PseudoVFSQRT_V_MF4_TU, VFSQRT_V, 0x6 }, // 1991
  { PseudoVFSQRT_V_MF2, VFSQRT_V, 0x7 }, // 1992
  { PseudoVFSQRT_V_MF2_MASK, VFSQRT_V, 0x7 }, // 1993
  { PseudoVFSQRT_V_MF2_TU, VFSQRT_V, 0x7 }, // 1994
  { PseudoVFSUB_VF16_M1, VFSUB_VF, 0x0 }, // 1995
  { PseudoVFSUB_VF16_M1_MASK, VFSUB_VF, 0x0 }, // 1996
  { PseudoVFSUB_VF16_M1_TU, VFSUB_VF, 0x0 }, // 1997
  { PseudoVFSUB_VF32_M1, VFSUB_VF, 0x0 }, // 1998
  { PseudoVFSUB_VF32_M1_MASK, VFSUB_VF, 0x0 }, // 1999
  { PseudoVFSUB_VF32_M1_TU, VFSUB_VF, 0x0 }, // 2000
  { PseudoVFSUB_VF64_M1, VFSUB_VF, 0x0 }, // 2001
  { PseudoVFSUB_VF64_M1_MASK, VFSUB_VF, 0x0 }, // 2002
  { PseudoVFSUB_VF64_M1_TU, VFSUB_VF, 0x0 }, // 2003
  { PseudoVFSUB_VF16_M2, VFSUB_VF, 0x1 }, // 2004
  { PseudoVFSUB_VF16_M2_MASK, VFSUB_VF, 0x1 }, // 2005
  { PseudoVFSUB_VF16_M2_TU, VFSUB_VF, 0x1 }, // 2006
  { PseudoVFSUB_VF32_M2, VFSUB_VF, 0x1 }, // 2007
  { PseudoVFSUB_VF32_M2_MASK, VFSUB_VF, 0x1 }, // 2008
  { PseudoVFSUB_VF32_M2_TU, VFSUB_VF, 0x1 }, // 2009
  { PseudoVFSUB_VF64_M2, VFSUB_VF, 0x1 }, // 2010
  { PseudoVFSUB_VF64_M2_MASK, VFSUB_VF, 0x1 }, // 2011
  { PseudoVFSUB_VF64_M2_TU, VFSUB_VF, 0x1 }, // 2012
  { PseudoVFSUB_VF16_M4, VFSUB_VF, 0x2 }, // 2013
  { PseudoVFSUB_VF16_M4_MASK, VFSUB_VF, 0x2 }, // 2014
  { PseudoVFSUB_VF16_M4_TU, VFSUB_VF, 0x2 }, // 2015
  { PseudoVFSUB_VF32_M4, VFSUB_VF, 0x2 }, // 2016
  { PseudoVFSUB_VF32_M4_MASK, VFSUB_VF, 0x2 }, // 2017
  { PseudoVFSUB_VF32_M4_TU, VFSUB_VF, 0x2 }, // 2018
  { PseudoVFSUB_VF64_M4, VFSUB_VF, 0x2 }, // 2019
  { PseudoVFSUB_VF64_M4_MASK, VFSUB_VF, 0x2 }, // 2020
  { PseudoVFSUB_VF64_M4_TU, VFSUB_VF, 0x2 }, // 2021
  { PseudoVFSUB_VF16_M8, VFSUB_VF, 0x3 }, // 2022
  { PseudoVFSUB_VF16_M8_MASK, VFSUB_VF, 0x3 }, // 2023
  { PseudoVFSUB_VF16_M8_TU, VFSUB_VF, 0x3 }, // 2024
  { PseudoVFSUB_VF32_M8, VFSUB_VF, 0x3 }, // 2025
  { PseudoVFSUB_VF32_M8_MASK, VFSUB_VF, 0x3 }, // 2026
  { PseudoVFSUB_VF32_M8_TU, VFSUB_VF, 0x3 }, // 2027
  { PseudoVFSUB_VF64_M8, VFSUB_VF, 0x3 }, // 2028
  { PseudoVFSUB_VF64_M8_MASK, VFSUB_VF, 0x3 }, // 2029
  { PseudoVFSUB_VF64_M8_TU, VFSUB_VF, 0x3 }, // 2030
  { PseudoVFSUB_VF16_MF4, VFSUB_VF, 0x6 }, // 2031
  { PseudoVFSUB_VF16_MF4_MASK, VFSUB_VF, 0x6 }, // 2032
  { PseudoVFSUB_VF16_MF4_TU, VFSUB_VF, 0x6 }, // 2033
  { PseudoVFSUB_VF16_MF2, VFSUB_VF, 0x7 }, // 2034
  { PseudoVFSUB_VF16_MF2_MASK, VFSUB_VF, 0x7 }, // 2035
  { PseudoVFSUB_VF16_MF2_TU, VFSUB_VF, 0x7 }, // 2036
  { PseudoVFSUB_VF32_MF2, VFSUB_VF, 0x7 }, // 2037
  { PseudoVFSUB_VF32_MF2_MASK, VFSUB_VF, 0x7 }, // 2038
  { PseudoVFSUB_VF32_MF2_TU, VFSUB_VF, 0x7 }, // 2039
  { PseudoVFSUB_VV_M1, VFSUB_VV, 0x0 }, // 2040
  { PseudoVFSUB_VV_M1_MASK, VFSUB_VV, 0x0 }, // 2041
  { PseudoVFSUB_VV_M1_TU, VFSUB_VV, 0x0 }, // 2042
  { PseudoVFSUB_VV_M2, VFSUB_VV, 0x1 }, // 2043
  { PseudoVFSUB_VV_M2_MASK, VFSUB_VV, 0x1 }, // 2044
  { PseudoVFSUB_VV_M2_TU, VFSUB_VV, 0x1 }, // 2045
  { PseudoVFSUB_VV_M4, VFSUB_VV, 0x2 }, // 2046
  { PseudoVFSUB_VV_M4_MASK, VFSUB_VV, 0x2 }, // 2047
  { PseudoVFSUB_VV_M4_TU, VFSUB_VV, 0x2 }, // 2048
  { PseudoVFSUB_VV_M8, VFSUB_VV, 0x3 }, // 2049
  { PseudoVFSUB_VV_M8_MASK, VFSUB_VV, 0x3 }, // 2050
  { PseudoVFSUB_VV_M8_TU, VFSUB_VV, 0x3 }, // 2051
  { PseudoVFSUB_VV_MF4, VFSUB_VV, 0x6 }, // 2052
  { PseudoVFSUB_VV_MF4_MASK, VFSUB_VV, 0x6 }, // 2053
  { PseudoVFSUB_VV_MF4_TU, VFSUB_VV, 0x6 }, // 2054
  { PseudoVFSUB_VV_MF2, VFSUB_VV, 0x7 }, // 2055
  { PseudoVFSUB_VV_MF2_MASK, VFSUB_VV, 0x7 }, // 2056
  { PseudoVFSUB_VV_MF2_TU, VFSUB_VV, 0x7 }, // 2057
  { PseudoVFWADD_VF16_M1, VFWADD_VF, 0x0 }, // 2058
  { PseudoVFWADD_VF16_M1_MASK, VFWADD_VF, 0x0 }, // 2059
  { PseudoVFWADD_VF16_M1_TU, VFWADD_VF, 0x0 }, // 2060
  { PseudoVFWADD_VF32_M1, VFWADD_VF, 0x0 }, // 2061
  { PseudoVFWADD_VF32_M1_MASK, VFWADD_VF, 0x0 }, // 2062
  { PseudoVFWADD_VF32_M1_TU, VFWADD_VF, 0x0 }, // 2063
  { PseudoVFWADD_VF16_M2, VFWADD_VF, 0x1 }, // 2064
  { PseudoVFWADD_VF16_M2_MASK, VFWADD_VF, 0x1 }, // 2065
  { PseudoVFWADD_VF16_M2_TU, VFWADD_VF, 0x1 }, // 2066
  { PseudoVFWADD_VF32_M2, VFWADD_VF, 0x1 }, // 2067
  { PseudoVFWADD_VF32_M2_MASK, VFWADD_VF, 0x1 }, // 2068
  { PseudoVFWADD_VF32_M2_TU, VFWADD_VF, 0x1 }, // 2069
  { PseudoVFWADD_VF16_M4, VFWADD_VF, 0x2 }, // 2070
  { PseudoVFWADD_VF16_M4_MASK, VFWADD_VF, 0x2 }, // 2071
  { PseudoVFWADD_VF16_M4_TU, VFWADD_VF, 0x2 }, // 2072
  { PseudoVFWADD_VF32_M4, VFWADD_VF, 0x2 }, // 2073
  { PseudoVFWADD_VF32_M4_MASK, VFWADD_VF, 0x2 }, // 2074
  { PseudoVFWADD_VF32_M4_TU, VFWADD_VF, 0x2 }, // 2075
  { PseudoVFWADD_VF16_MF4, VFWADD_VF, 0x6 }, // 2076
  { PseudoVFWADD_VF16_MF4_MASK, VFWADD_VF, 0x6 }, // 2077
  { PseudoVFWADD_VF16_MF4_TU, VFWADD_VF, 0x6 }, // 2078
  { PseudoVFWADD_VF16_MF2, VFWADD_VF, 0x7 }, // 2079
  { PseudoVFWADD_VF16_MF2_MASK, VFWADD_VF, 0x7 }, // 2080
  { PseudoVFWADD_VF16_MF2_TU, VFWADD_VF, 0x7 }, // 2081
  { PseudoVFWADD_VF32_MF2, VFWADD_VF, 0x7 }, // 2082
  { PseudoVFWADD_VF32_MF2_MASK, VFWADD_VF, 0x7 }, // 2083
  { PseudoVFWADD_VF32_MF2_TU, VFWADD_VF, 0x7 }, // 2084
  { PseudoVFWADD_VV_M1, VFWADD_VV, 0x0 }, // 2085
  { PseudoVFWADD_VV_M1_MASK, VFWADD_VV, 0x0 }, // 2086
  { PseudoVFWADD_VV_M1_TU, VFWADD_VV, 0x0 }, // 2087
  { PseudoVFWADD_VV_M2, VFWADD_VV, 0x1 }, // 2088
  { PseudoVFWADD_VV_M2_MASK, VFWADD_VV, 0x1 }, // 2089
  { PseudoVFWADD_VV_M2_TU, VFWADD_VV, 0x1 }, // 2090
  { PseudoVFWADD_VV_M4, VFWADD_VV, 0x2 }, // 2091
  { PseudoVFWADD_VV_M4_MASK, VFWADD_VV, 0x2 }, // 2092
  { PseudoVFWADD_VV_M4_TU, VFWADD_VV, 0x2 }, // 2093
  { PseudoVFWADD_VV_MF4, VFWADD_VV, 0x6 }, // 2094
  { PseudoVFWADD_VV_MF4_MASK, VFWADD_VV, 0x6 }, // 2095
  { PseudoVFWADD_VV_MF4_TU, VFWADD_VV, 0x6 }, // 2096
  { PseudoVFWADD_VV_MF2, VFWADD_VV, 0x7 }, // 2097
  { PseudoVFWADD_VV_MF2_MASK, VFWADD_VV, 0x7 }, // 2098
  { PseudoVFWADD_VV_MF2_TU, VFWADD_VV, 0x7 }, // 2099
  { PseudoVFWADD_WF16_M1, VFWADD_WF, 0x0 }, // 2100
  { PseudoVFWADD_WF16_M1_MASK, VFWADD_WF, 0x0 }, // 2101
  { PseudoVFWADD_WF16_M1_TU, VFWADD_WF, 0x0 }, // 2102
  { PseudoVFWADD_WF32_M1, VFWADD_WF, 0x0 }, // 2103
  { PseudoVFWADD_WF32_M1_MASK, VFWADD_WF, 0x0 }, // 2104
  { PseudoVFWADD_WF32_M1_TU, VFWADD_WF, 0x0 }, // 2105
  { PseudoVFWADD_WF16_M2, VFWADD_WF, 0x1 }, // 2106
  { PseudoVFWADD_WF16_M2_MASK, VFWADD_WF, 0x1 }, // 2107
  { PseudoVFWADD_WF16_M2_TU, VFWADD_WF, 0x1 }, // 2108
  { PseudoVFWADD_WF32_M2, VFWADD_WF, 0x1 }, // 2109
  { PseudoVFWADD_WF32_M2_MASK, VFWADD_WF, 0x1 }, // 2110
  { PseudoVFWADD_WF32_M2_TU, VFWADD_WF, 0x1 }, // 2111
  { PseudoVFWADD_WF16_M4, VFWADD_WF, 0x2 }, // 2112
  { PseudoVFWADD_WF16_M4_MASK, VFWADD_WF, 0x2 }, // 2113
  { PseudoVFWADD_WF16_M4_TU, VFWADD_WF, 0x2 }, // 2114
  { PseudoVFWADD_WF32_M4, VFWADD_WF, 0x2 }, // 2115
  { PseudoVFWADD_WF32_M4_MASK, VFWADD_WF, 0x2 }, // 2116
  { PseudoVFWADD_WF32_M4_TU, VFWADD_WF, 0x2 }, // 2117
  { PseudoVFWADD_WF16_MF4, VFWADD_WF, 0x6 }, // 2118
  { PseudoVFWADD_WF16_MF4_MASK, VFWADD_WF, 0x6 }, // 2119
  { PseudoVFWADD_WF16_MF4_TU, VFWADD_WF, 0x6 }, // 2120
  { PseudoVFWADD_WF16_MF2, VFWADD_WF, 0x7 }, // 2121
  { PseudoVFWADD_WF16_MF2_MASK, VFWADD_WF, 0x7 }, // 2122
  { PseudoVFWADD_WF16_MF2_TU, VFWADD_WF, 0x7 }, // 2123
  { PseudoVFWADD_WF32_MF2, VFWADD_WF, 0x7 }, // 2124
  { PseudoVFWADD_WF32_MF2_MASK, VFWADD_WF, 0x7 }, // 2125
  { PseudoVFWADD_WF32_MF2_TU, VFWADD_WF, 0x7 }, // 2126
  { PseudoVFWADD_WV_M1, VFWADD_WV, 0x0 }, // 2127
  { PseudoVFWADD_WV_M1_MASK, VFWADD_WV, 0x0 }, // 2128
  { PseudoVFWADD_WV_M1_MASK_TIED, VFWADD_WV, 0x0 }, // 2129
  { PseudoVFWADD_WV_M1_TIED, VFWADD_WV, 0x0 }, // 2130
  { PseudoVFWADD_WV_M1_TU, VFWADD_WV, 0x0 }, // 2131
  { PseudoVFWADD_WV_M2, VFWADD_WV, 0x1 }, // 2132
  { PseudoVFWADD_WV_M2_MASK, VFWADD_WV, 0x1 }, // 2133
  { PseudoVFWADD_WV_M2_MASK_TIED, VFWADD_WV, 0x1 }, // 2134
  { PseudoVFWADD_WV_M2_TIED, VFWADD_WV, 0x1 }, // 2135
  { PseudoVFWADD_WV_M2_TU, VFWADD_WV, 0x1 }, // 2136
  { PseudoVFWADD_WV_M4, VFWADD_WV, 0x2 }, // 2137
  { PseudoVFWADD_WV_M4_MASK, VFWADD_WV, 0x2 }, // 2138
  { PseudoVFWADD_WV_M4_MASK_TIED, VFWADD_WV, 0x2 }, // 2139
  { PseudoVFWADD_WV_M4_TIED, VFWADD_WV, 0x2 }, // 2140
  { PseudoVFWADD_WV_M4_TU, VFWADD_WV, 0x2 }, // 2141
  { PseudoVFWADD_WV_MF4, VFWADD_WV, 0x6 }, // 2142
  { PseudoVFWADD_WV_MF4_MASK, VFWADD_WV, 0x6 }, // 2143
  { PseudoVFWADD_WV_MF4_MASK_TIED, VFWADD_WV, 0x6 }, // 2144
  { PseudoVFWADD_WV_MF4_TIED, VFWADD_WV, 0x6 }, // 2145
  { PseudoVFWADD_WV_MF4_TU, VFWADD_WV, 0x6 }, // 2146
  { PseudoVFWADD_WV_MF2, VFWADD_WV, 0x7 }, // 2147
  { PseudoVFWADD_WV_MF2_MASK, VFWADD_WV, 0x7 }, // 2148
  { PseudoVFWADD_WV_MF2_MASK_TIED, VFWADD_WV, 0x7 }, // 2149
  { PseudoVFWADD_WV_MF2_TIED, VFWADD_WV, 0x7 }, // 2150
  { PseudoVFWADD_WV_MF2_TU, VFWADD_WV, 0x7 }, // 2151
  { PseudoVFWCVT_F_F_V_M1, VFWCVT_F_F_V, 0x0 }, // 2152
  { PseudoVFWCVT_F_F_V_M1_MASK, VFWCVT_F_F_V, 0x0 }, // 2153
  { PseudoVFWCVT_F_F_V_M1_TU, VFWCVT_F_F_V, 0x0 }, // 2154
  { PseudoVFWCVT_F_F_V_M2, VFWCVT_F_F_V, 0x1 }, // 2155
  { PseudoVFWCVT_F_F_V_M2_MASK, VFWCVT_F_F_V, 0x1 }, // 2156
  { PseudoVFWCVT_F_F_V_M2_TU, VFWCVT_F_F_V, 0x1 }, // 2157
  { PseudoVFWCVT_F_F_V_M4, VFWCVT_F_F_V, 0x2 }, // 2158
  { PseudoVFWCVT_F_F_V_M4_MASK, VFWCVT_F_F_V, 0x2 }, // 2159
  { PseudoVFWCVT_F_F_V_M4_TU, VFWCVT_F_F_V, 0x2 }, // 2160
  { PseudoVFWCVT_F_F_V_MF4, VFWCVT_F_F_V, 0x6 }, // 2161
  { PseudoVFWCVT_F_F_V_MF4_MASK, VFWCVT_F_F_V, 0x6 }, // 2162
  { PseudoVFWCVT_F_F_V_MF4_TU, VFWCVT_F_F_V, 0x6 }, // 2163
  { PseudoVFWCVT_F_F_V_MF2, VFWCVT_F_F_V, 0x7 }, // 2164
  { PseudoVFWCVT_F_F_V_MF2_MASK, VFWCVT_F_F_V, 0x7 }, // 2165
  { PseudoVFWCVT_F_F_V_MF2_TU, VFWCVT_F_F_V, 0x7 }, // 2166
  { PseudoVFWCVT_F_XU_V_M1, VFWCVT_F_XU_V, 0x0 }, // 2167
  { PseudoVFWCVT_F_XU_V_M1_MASK, VFWCVT_F_XU_V, 0x0 }, // 2168
  { PseudoVFWCVT_F_XU_V_M1_TU, VFWCVT_F_XU_V, 0x0 }, // 2169
  { PseudoVFWCVT_F_XU_V_M2, VFWCVT_F_XU_V, 0x1 }, // 2170
  { PseudoVFWCVT_F_XU_V_M2_MASK, VFWCVT_F_XU_V, 0x1 }, // 2171
  { PseudoVFWCVT_F_XU_V_M2_TU, VFWCVT_F_XU_V, 0x1 }, // 2172
  { PseudoVFWCVT_F_XU_V_M4, VFWCVT_F_XU_V, 0x2 }, // 2173
  { PseudoVFWCVT_F_XU_V_M4_MASK, VFWCVT_F_XU_V, 0x2 }, // 2174
  { PseudoVFWCVT_F_XU_V_M4_TU, VFWCVT_F_XU_V, 0x2 }, // 2175
  { PseudoVFWCVT_F_XU_V_MF8, VFWCVT_F_XU_V, 0x5 }, // 2176
  { PseudoVFWCVT_F_XU_V_MF8_MASK, VFWCVT_F_XU_V, 0x5 }, // 2177
  { PseudoVFWCVT_F_XU_V_MF8_TU, VFWCVT_F_XU_V, 0x5 }, // 2178
  { PseudoVFWCVT_F_XU_V_MF4, VFWCVT_F_XU_V, 0x6 }, // 2179
  { PseudoVFWCVT_F_XU_V_MF4_MASK, VFWCVT_F_XU_V, 0x6 }, // 2180
  { PseudoVFWCVT_F_XU_V_MF4_TU, VFWCVT_F_XU_V, 0x6 }, // 2181
  { PseudoVFWCVT_F_XU_V_MF2, VFWCVT_F_XU_V, 0x7 }, // 2182
  { PseudoVFWCVT_F_XU_V_MF2_MASK, VFWCVT_F_XU_V, 0x7 }, // 2183
  { PseudoVFWCVT_F_XU_V_MF2_TU, VFWCVT_F_XU_V, 0x7 }, // 2184
  { PseudoVFWCVT_F_X_V_M1, VFWCVT_F_X_V, 0x0 }, // 2185
  { PseudoVFWCVT_F_X_V_M1_MASK, VFWCVT_F_X_V, 0x0 }, // 2186
  { PseudoVFWCVT_F_X_V_M1_TU, VFWCVT_F_X_V, 0x0 }, // 2187
  { PseudoVFWCVT_F_X_V_M2, VFWCVT_F_X_V, 0x1 }, // 2188
  { PseudoVFWCVT_F_X_V_M2_MASK, VFWCVT_F_X_V, 0x1 }, // 2189
  { PseudoVFWCVT_F_X_V_M2_TU, VFWCVT_F_X_V, 0x1 }, // 2190
  { PseudoVFWCVT_F_X_V_M4, VFWCVT_F_X_V, 0x2 }, // 2191
  { PseudoVFWCVT_F_X_V_M4_MASK, VFWCVT_F_X_V, 0x2 }, // 2192
  { PseudoVFWCVT_F_X_V_M4_TU, VFWCVT_F_X_V, 0x2 }, // 2193
  { PseudoVFWCVT_F_X_V_MF8, VFWCVT_F_X_V, 0x5 }, // 2194
  { PseudoVFWCVT_F_X_V_MF8_MASK, VFWCVT_F_X_V, 0x5 }, // 2195
  { PseudoVFWCVT_F_X_V_MF8_TU, VFWCVT_F_X_V, 0x5 }, // 2196
  { PseudoVFWCVT_F_X_V_MF4, VFWCVT_F_X_V, 0x6 }, // 2197
  { PseudoVFWCVT_F_X_V_MF4_MASK, VFWCVT_F_X_V, 0x6 }, // 2198
  { PseudoVFWCVT_F_X_V_MF4_TU, VFWCVT_F_X_V, 0x6 }, // 2199
  { PseudoVFWCVT_F_X_V_MF2, VFWCVT_F_X_V, 0x7 }, // 2200
  { PseudoVFWCVT_F_X_V_MF2_MASK, VFWCVT_F_X_V, 0x7 }, // 2201
  { PseudoVFWCVT_F_X_V_MF2_TU, VFWCVT_F_X_V, 0x7 }, // 2202
  { PseudoVFWCVT_RTZ_XU_F_V_M1, VFWCVT_RTZ_XU_F_V, 0x0 }, // 2203
  { PseudoVFWCVT_RTZ_XU_F_V_M1_MASK, VFWCVT_RTZ_XU_F_V, 0x0 }, // 2204
  { PseudoVFWCVT_RTZ_XU_F_V_M1_TU, VFWCVT_RTZ_XU_F_V, 0x0 }, // 2205
  { PseudoVFWCVT_RTZ_XU_F_V_M2, VFWCVT_RTZ_XU_F_V, 0x1 }, // 2206
  { PseudoVFWCVT_RTZ_XU_F_V_M2_MASK, VFWCVT_RTZ_XU_F_V, 0x1 }, // 2207
  { PseudoVFWCVT_RTZ_XU_F_V_M2_TU, VFWCVT_RTZ_XU_F_V, 0x1 }, // 2208
  { PseudoVFWCVT_RTZ_XU_F_V_M4, VFWCVT_RTZ_XU_F_V, 0x2 }, // 2209
  { PseudoVFWCVT_RTZ_XU_F_V_M4_MASK, VFWCVT_RTZ_XU_F_V, 0x2 }, // 2210
  { PseudoVFWCVT_RTZ_XU_F_V_M4_TU, VFWCVT_RTZ_XU_F_V, 0x2 }, // 2211
  { PseudoVFWCVT_RTZ_XU_F_V_MF4, VFWCVT_RTZ_XU_F_V, 0x6 }, // 2212
  { PseudoVFWCVT_RTZ_XU_F_V_MF4_MASK, VFWCVT_RTZ_XU_F_V, 0x6 }, // 2213
  { PseudoVFWCVT_RTZ_XU_F_V_MF4_TU, VFWCVT_RTZ_XU_F_V, 0x6 }, // 2214
  { PseudoVFWCVT_RTZ_XU_F_V_MF2, VFWCVT_RTZ_XU_F_V, 0x7 }, // 2215
  { PseudoVFWCVT_RTZ_XU_F_V_MF2_MASK, VFWCVT_RTZ_XU_F_V, 0x7 }, // 2216
  { PseudoVFWCVT_RTZ_XU_F_V_MF2_TU, VFWCVT_RTZ_XU_F_V, 0x7 }, // 2217
  { PseudoVFWCVT_RTZ_X_F_V_M1, VFWCVT_RTZ_X_F_V, 0x0 }, // 2218
  { PseudoVFWCVT_RTZ_X_F_V_M1_MASK, VFWCVT_RTZ_X_F_V, 0x0 }, // 2219
  { PseudoVFWCVT_RTZ_X_F_V_M1_TU, VFWCVT_RTZ_X_F_V, 0x0 }, // 2220
  { PseudoVFWCVT_RTZ_X_F_V_M2, VFWCVT_RTZ_X_F_V, 0x1 }, // 2221
  { PseudoVFWCVT_RTZ_X_F_V_M2_MASK, VFWCVT_RTZ_X_F_V, 0x1 }, // 2222
  { PseudoVFWCVT_RTZ_X_F_V_M2_TU, VFWCVT_RTZ_X_F_V, 0x1 }, // 2223
  { PseudoVFWCVT_RTZ_X_F_V_M4, VFWCVT_RTZ_X_F_V, 0x2 }, // 2224
  { PseudoVFWCVT_RTZ_X_F_V_M4_MASK, VFWCVT_RTZ_X_F_V, 0x2 }, // 2225
  { PseudoVFWCVT_RTZ_X_F_V_M4_TU, VFWCVT_RTZ_X_F_V, 0x2 }, // 2226
  { PseudoVFWCVT_RTZ_X_F_V_MF4, VFWCVT_RTZ_X_F_V, 0x6 }, // 2227
  { PseudoVFWCVT_RTZ_X_F_V_MF4_MASK, VFWCVT_RTZ_X_F_V, 0x6 }, // 2228
  { PseudoVFWCVT_RTZ_X_F_V_MF4_TU, VFWCVT_RTZ_X_F_V, 0x6 }, // 2229
  { PseudoVFWCVT_RTZ_X_F_V_MF2, VFWCVT_RTZ_X_F_V, 0x7 }, // 2230
  { PseudoVFWCVT_RTZ_X_F_V_MF2_MASK, VFWCVT_RTZ_X_F_V, 0x7 }, // 2231
  { PseudoVFWCVT_RTZ_X_F_V_MF2_TU, VFWCVT_RTZ_X_F_V, 0x7 }, // 2232
  { PseudoVFWCVT_XU_F_V_M1, VFWCVT_XU_F_V, 0x0 }, // 2233
  { PseudoVFWCVT_XU_F_V_M1_MASK, VFWCVT_XU_F_V, 0x0 }, // 2234
  { PseudoVFWCVT_XU_F_V_M1_TU, VFWCVT_XU_F_V, 0x0 }, // 2235
  { PseudoVFWCVT_XU_F_V_M2, VFWCVT_XU_F_V, 0x1 }, // 2236
  { PseudoVFWCVT_XU_F_V_M2_MASK, VFWCVT_XU_F_V, 0x1 }, // 2237
  { PseudoVFWCVT_XU_F_V_M2_TU, VFWCVT_XU_F_V, 0x1 }, // 2238
  { PseudoVFWCVT_XU_F_V_M4, VFWCVT_XU_F_V, 0x2 }, // 2239
  { PseudoVFWCVT_XU_F_V_M4_MASK, VFWCVT_XU_F_V, 0x2 }, // 2240
  { PseudoVFWCVT_XU_F_V_M4_TU, VFWCVT_XU_F_V, 0x2 }, // 2241
  { PseudoVFWCVT_XU_F_V_MF4, VFWCVT_XU_F_V, 0x6 }, // 2242
  { PseudoVFWCVT_XU_F_V_MF4_MASK, VFWCVT_XU_F_V, 0x6 }, // 2243
  { PseudoVFWCVT_XU_F_V_MF4_TU, VFWCVT_XU_F_V, 0x6 }, // 2244
  { PseudoVFWCVT_XU_F_V_MF2, VFWCVT_XU_F_V, 0x7 }, // 2245
  { PseudoVFWCVT_XU_F_V_MF2_MASK, VFWCVT_XU_F_V, 0x7 }, // 2246
  { PseudoVFWCVT_XU_F_V_MF2_TU, VFWCVT_XU_F_V, 0x7 }, // 2247
  { PseudoVFWCVT_X_F_V_M1, VFWCVT_X_F_V, 0x0 }, // 2248
  { PseudoVFWCVT_X_F_V_M1_MASK, VFWCVT_X_F_V, 0x0 }, // 2249
  { PseudoVFWCVT_X_F_V_M1_TU, VFWCVT_X_F_V, 0x0 }, // 2250
  { PseudoVFWCVT_X_F_V_M2, VFWCVT_X_F_V, 0x1 }, // 2251
  { PseudoVFWCVT_X_F_V_M2_MASK, VFWCVT_X_F_V, 0x1 }, // 2252
  { PseudoVFWCVT_X_F_V_M2_TU, VFWCVT_X_F_V, 0x1 }, // 2253
  { PseudoVFWCVT_X_F_V_M4, VFWCVT_X_F_V, 0x2 }, // 2254
  { PseudoVFWCVT_X_F_V_M4_MASK, VFWCVT_X_F_V, 0x2 }, // 2255
  { PseudoVFWCVT_X_F_V_M4_TU, VFWCVT_X_F_V, 0x2 }, // 2256
  { PseudoVFWCVT_X_F_V_MF4, VFWCVT_X_F_V, 0x6 }, // 2257
  { PseudoVFWCVT_X_F_V_MF4_MASK, VFWCVT_X_F_V, 0x6 }, // 2258
  { PseudoVFWCVT_X_F_V_MF4_TU, VFWCVT_X_F_V, 0x6 }, // 2259
  { PseudoVFWCVT_X_F_V_MF2, VFWCVT_X_F_V, 0x7 }, // 2260
  { PseudoVFWCVT_X_F_V_MF2_MASK, VFWCVT_X_F_V, 0x7 }, // 2261
  { PseudoVFWCVT_X_F_V_MF2_TU, VFWCVT_X_F_V, 0x7 }, // 2262
  { PseudoVFWMACC_VF16_M1, VFWMACC_VF, 0x0 }, // 2263
  { PseudoVFWMACC_VF16_M1_MASK, VFWMACC_VF, 0x0 }, // 2264
  { PseudoVFWMACC_VF32_M1, VFWMACC_VF, 0x0 }, // 2265
  { PseudoVFWMACC_VF32_M1_MASK, VFWMACC_VF, 0x0 }, // 2266
  { PseudoVFWMACC_VF16_M2, VFWMACC_VF, 0x1 }, // 2267
  { PseudoVFWMACC_VF16_M2_MASK, VFWMACC_VF, 0x1 }, // 2268
  { PseudoVFWMACC_VF32_M2, VFWMACC_VF, 0x1 }, // 2269
  { PseudoVFWMACC_VF32_M2_MASK, VFWMACC_VF, 0x1 }, // 2270
  { PseudoVFWMACC_VF16_M4, VFWMACC_VF, 0x2 }, // 2271
  { PseudoVFWMACC_VF16_M4_MASK, VFWMACC_VF, 0x2 }, // 2272
  { PseudoVFWMACC_VF32_M4, VFWMACC_VF, 0x2 }, // 2273
  { PseudoVFWMACC_VF32_M4_MASK, VFWMACC_VF, 0x2 }, // 2274
  { PseudoVFWMACC_VF16_MF4, VFWMACC_VF, 0x6 }, // 2275
  { PseudoVFWMACC_VF16_MF4_MASK, VFWMACC_VF, 0x6 }, // 2276
  { PseudoVFWMACC_VF16_MF2, VFWMACC_VF, 0x7 }, // 2277
  { PseudoVFWMACC_VF16_MF2_MASK, VFWMACC_VF, 0x7 }, // 2278
  { PseudoVFWMACC_VF32_MF2, VFWMACC_VF, 0x7 }, // 2279
  { PseudoVFWMACC_VF32_MF2_MASK, VFWMACC_VF, 0x7 }, // 2280
  { PseudoVFWMACC_VV_M1, VFWMACC_VV, 0x0 }, // 2281
  { PseudoVFWMACC_VV_M1_MASK, VFWMACC_VV, 0x0 }, // 2282
  { PseudoVFWMACC_VV_M2, VFWMACC_VV, 0x1 }, // 2283
  { PseudoVFWMACC_VV_M2_MASK, VFWMACC_VV, 0x1 }, // 2284
  { PseudoVFWMACC_VV_M4, VFWMACC_VV, 0x2 }, // 2285
  { PseudoVFWMACC_VV_M4_MASK, VFWMACC_VV, 0x2 }, // 2286
  { PseudoVFWMACC_VV_MF4, VFWMACC_VV, 0x6 }, // 2287
  { PseudoVFWMACC_VV_MF4_MASK, VFWMACC_VV, 0x6 }, // 2288
  { PseudoVFWMACC_VV_MF2, VFWMACC_VV, 0x7 }, // 2289
  { PseudoVFWMACC_VV_MF2_MASK, VFWMACC_VV, 0x7 }, // 2290
  { PseudoVFWMSAC_VF16_M1, VFWMSAC_VF, 0x0 }, // 2291
  { PseudoVFWMSAC_VF16_M1_MASK, VFWMSAC_VF, 0x0 }, // 2292
  { PseudoVFWMSAC_VF32_M1, VFWMSAC_VF, 0x0 }, // 2293
  { PseudoVFWMSAC_VF32_M1_MASK, VFWMSAC_VF, 0x0 }, // 2294
  { PseudoVFWMSAC_VF16_M2, VFWMSAC_VF, 0x1 }, // 2295
  { PseudoVFWMSAC_VF16_M2_MASK, VFWMSAC_VF, 0x1 }, // 2296
  { PseudoVFWMSAC_VF32_M2, VFWMSAC_VF, 0x1 }, // 2297
  { PseudoVFWMSAC_VF32_M2_MASK, VFWMSAC_VF, 0x1 }, // 2298
  { PseudoVFWMSAC_VF16_M4, VFWMSAC_VF, 0x2 }, // 2299
  { PseudoVFWMSAC_VF16_M4_MASK, VFWMSAC_VF, 0x2 }, // 2300
  { PseudoVFWMSAC_VF32_M4, VFWMSAC_VF, 0x2 }, // 2301
  { PseudoVFWMSAC_VF32_M4_MASK, VFWMSAC_VF, 0x2 }, // 2302
  { PseudoVFWMSAC_VF16_MF4, VFWMSAC_VF, 0x6 }, // 2303
  { PseudoVFWMSAC_VF16_MF4_MASK, VFWMSAC_VF, 0x6 }, // 2304
  { PseudoVFWMSAC_VF16_MF2, VFWMSAC_VF, 0x7 }, // 2305
  { PseudoVFWMSAC_VF16_MF2_MASK, VFWMSAC_VF, 0x7 }, // 2306
  { PseudoVFWMSAC_VF32_MF2, VFWMSAC_VF, 0x7 }, // 2307
  { PseudoVFWMSAC_VF32_MF2_MASK, VFWMSAC_VF, 0x7 }, // 2308
  { PseudoVFWMSAC_VV_M1, VFWMSAC_VV, 0x0 }, // 2309
  { PseudoVFWMSAC_VV_M1_MASK, VFWMSAC_VV, 0x0 }, // 2310
  { PseudoVFWMSAC_VV_M2, VFWMSAC_VV, 0x1 }, // 2311
  { PseudoVFWMSAC_VV_M2_MASK, VFWMSAC_VV, 0x1 }, // 2312
  { PseudoVFWMSAC_VV_M4, VFWMSAC_VV, 0x2 }, // 2313
  { PseudoVFWMSAC_VV_M4_MASK, VFWMSAC_VV, 0x2 }, // 2314
  { PseudoVFWMSAC_VV_MF4, VFWMSAC_VV, 0x6 }, // 2315
  { PseudoVFWMSAC_VV_MF4_MASK, VFWMSAC_VV, 0x6 }, // 2316
  { PseudoVFWMSAC_VV_MF2, VFWMSAC_VV, 0x7 }, // 2317
  { PseudoVFWMSAC_VV_MF2_MASK, VFWMSAC_VV, 0x7 }, // 2318
  { PseudoVFWMUL_VF16_M1, VFWMUL_VF, 0x0 }, // 2319
  { PseudoVFWMUL_VF16_M1_MASK, VFWMUL_VF, 0x0 }, // 2320
  { PseudoVFWMUL_VF16_M1_TU, VFWMUL_VF, 0x0 }, // 2321
  { PseudoVFWMUL_VF32_M1, VFWMUL_VF, 0x0 }, // 2322
  { PseudoVFWMUL_VF32_M1_MASK, VFWMUL_VF, 0x0 }, // 2323
  { PseudoVFWMUL_VF32_M1_TU, VFWMUL_VF, 0x0 }, // 2324
  { PseudoVFWMUL_VF16_M2, VFWMUL_VF, 0x1 }, // 2325
  { PseudoVFWMUL_VF16_M2_MASK, VFWMUL_VF, 0x1 }, // 2326
  { PseudoVFWMUL_VF16_M2_TU, VFWMUL_VF, 0x1 }, // 2327
  { PseudoVFWMUL_VF32_M2, VFWMUL_VF, 0x1 }, // 2328
  { PseudoVFWMUL_VF32_M2_MASK, VFWMUL_VF, 0x1 }, // 2329
  { PseudoVFWMUL_VF32_M2_TU, VFWMUL_VF, 0x1 }, // 2330
  { PseudoVFWMUL_VF16_M4, VFWMUL_VF, 0x2 }, // 2331
  { PseudoVFWMUL_VF16_M4_MASK, VFWMUL_VF, 0x2 }, // 2332
  { PseudoVFWMUL_VF16_M4_TU, VFWMUL_VF, 0x2 }, // 2333
  { PseudoVFWMUL_VF32_M4, VFWMUL_VF, 0x2 }, // 2334
  { PseudoVFWMUL_VF32_M4_MASK, VFWMUL_VF, 0x2 }, // 2335
  { PseudoVFWMUL_VF32_M4_TU, VFWMUL_VF, 0x2 }, // 2336
  { PseudoVFWMUL_VF16_MF4, VFWMUL_VF, 0x6 }, // 2337
  { PseudoVFWMUL_VF16_MF4_MASK, VFWMUL_VF, 0x6 }, // 2338
  { PseudoVFWMUL_VF16_MF4_TU, VFWMUL_VF, 0x6 }, // 2339
  { PseudoVFWMUL_VF16_MF2, VFWMUL_VF, 0x7 }, // 2340
  { PseudoVFWMUL_VF16_MF2_MASK, VFWMUL_VF, 0x7 }, // 2341
  { PseudoVFWMUL_VF16_MF2_TU, VFWMUL_VF, 0x7 }, // 2342
  { PseudoVFWMUL_VF32_MF2, VFWMUL_VF, 0x7 }, // 2343
  { PseudoVFWMUL_VF32_MF2_MASK, VFWMUL_VF, 0x7 }, // 2344
  { PseudoVFWMUL_VF32_MF2_TU, VFWMUL_VF, 0x7 }, // 2345
  { PseudoVFWMUL_VV_M1, VFWMUL_VV, 0x0 }, // 2346
  { PseudoVFWMUL_VV_M1_MASK, VFWMUL_VV, 0x0 }, // 2347
  { PseudoVFWMUL_VV_M1_TU, VFWMUL_VV, 0x0 }, // 2348
  { PseudoVFWMUL_VV_M2, VFWMUL_VV, 0x1 }, // 2349
  { PseudoVFWMUL_VV_M2_MASK, VFWMUL_VV, 0x1 }, // 2350
  { PseudoVFWMUL_VV_M2_TU, VFWMUL_VV, 0x1 }, // 2351
  { PseudoVFWMUL_VV_M4, VFWMUL_VV, 0x2 }, // 2352
  { PseudoVFWMUL_VV_M4_MASK, VFWMUL_VV, 0x2 }, // 2353
  { PseudoVFWMUL_VV_M4_TU, VFWMUL_VV, 0x2 }, // 2354
  { PseudoVFWMUL_VV_MF4, VFWMUL_VV, 0x6 }, // 2355
  { PseudoVFWMUL_VV_MF4_MASK, VFWMUL_VV, 0x6 }, // 2356
  { PseudoVFWMUL_VV_MF4_TU, VFWMUL_VV, 0x6 }, // 2357
  { PseudoVFWMUL_VV_MF2, VFWMUL_VV, 0x7 }, // 2358
  { PseudoVFWMUL_VV_MF2_MASK, VFWMUL_VV, 0x7 }, // 2359
  { PseudoVFWMUL_VV_MF2_TU, VFWMUL_VV, 0x7 }, // 2360
  { PseudoVFWNMACC_VF16_M1, VFWNMACC_VF, 0x0 }, // 2361
  { PseudoVFWNMACC_VF16_M1_MASK, VFWNMACC_VF, 0x0 }, // 2362
  { PseudoVFWNMACC_VF32_M1, VFWNMACC_VF, 0x0 }, // 2363
  { PseudoVFWNMACC_VF32_M1_MASK, VFWNMACC_VF, 0x0 }, // 2364
  { PseudoVFWNMACC_VF16_M2, VFWNMACC_VF, 0x1 }, // 2365
  { PseudoVFWNMACC_VF16_M2_MASK, VFWNMACC_VF, 0x1 }, // 2366
  { PseudoVFWNMACC_VF32_M2, VFWNMACC_VF, 0x1 }, // 2367
  { PseudoVFWNMACC_VF32_M2_MASK, VFWNMACC_VF, 0x1 }, // 2368
  { PseudoVFWNMACC_VF16_M4, VFWNMACC_VF, 0x2 }, // 2369
  { PseudoVFWNMACC_VF16_M4_MASK, VFWNMACC_VF, 0x2 }, // 2370
  { PseudoVFWNMACC_VF32_M4, VFWNMACC_VF, 0x2 }, // 2371
  { PseudoVFWNMACC_VF32_M4_MASK, VFWNMACC_VF, 0x2 }, // 2372
  { PseudoVFWNMACC_VF16_MF4, VFWNMACC_VF, 0x6 }, // 2373
  { PseudoVFWNMACC_VF16_MF4_MASK, VFWNMACC_VF, 0x6 }, // 2374
  { PseudoVFWNMACC_VF16_MF2, VFWNMACC_VF, 0x7 }, // 2375
  { PseudoVFWNMACC_VF16_MF2_MASK, VFWNMACC_VF, 0x7 }, // 2376
  { PseudoVFWNMACC_VF32_MF2, VFWNMACC_VF, 0x7 }, // 2377
  { PseudoVFWNMACC_VF32_MF2_MASK, VFWNMACC_VF, 0x7 }, // 2378
  { PseudoVFWNMACC_VV_M1, VFWNMACC_VV, 0x0 }, // 2379
  { PseudoVFWNMACC_VV_M1_MASK, VFWNMACC_VV, 0x0 }, // 2380
  { PseudoVFWNMACC_VV_M2, VFWNMACC_VV, 0x1 }, // 2381
  { PseudoVFWNMACC_VV_M2_MASK, VFWNMACC_VV, 0x1 }, // 2382
  { PseudoVFWNMACC_VV_M4, VFWNMACC_VV, 0x2 }, // 2383
  { PseudoVFWNMACC_VV_M4_MASK, VFWNMACC_VV, 0x2 }, // 2384
  { PseudoVFWNMACC_VV_MF4, VFWNMACC_VV, 0x6 }, // 2385
  { PseudoVFWNMACC_VV_MF4_MASK, VFWNMACC_VV, 0x6 }, // 2386
  { PseudoVFWNMACC_VV_MF2, VFWNMACC_VV, 0x7 }, // 2387
  { PseudoVFWNMACC_VV_MF2_MASK, VFWNMACC_VV, 0x7 }, // 2388
  { PseudoVFWNMSAC_VF16_M1, VFWNMSAC_VF, 0x0 }, // 2389
  { PseudoVFWNMSAC_VF16_M1_MASK, VFWNMSAC_VF, 0x0 }, // 2390
  { PseudoVFWNMSAC_VF32_M1, VFWNMSAC_VF, 0x0 }, // 2391
  { PseudoVFWNMSAC_VF32_M1_MASK, VFWNMSAC_VF, 0x0 }, // 2392
  { PseudoVFWNMSAC_VF16_M2, VFWNMSAC_VF, 0x1 }, // 2393
  { PseudoVFWNMSAC_VF16_M2_MASK, VFWNMSAC_VF, 0x1 }, // 2394
  { PseudoVFWNMSAC_VF32_M2, VFWNMSAC_VF, 0x1 }, // 2395
  { PseudoVFWNMSAC_VF32_M2_MASK, VFWNMSAC_VF, 0x1 }, // 2396
  { PseudoVFWNMSAC_VF16_M4, VFWNMSAC_VF, 0x2 }, // 2397
  { PseudoVFWNMSAC_VF16_M4_MASK, VFWNMSAC_VF, 0x2 }, // 2398
  { PseudoVFWNMSAC_VF32_M4, VFWNMSAC_VF, 0x2 }, // 2399
  { PseudoVFWNMSAC_VF32_M4_MASK, VFWNMSAC_VF, 0x2 }, // 2400
  { PseudoVFWNMSAC_VF16_MF4, VFWNMSAC_VF, 0x6 }, // 2401
  { PseudoVFWNMSAC_VF16_MF4_MASK, VFWNMSAC_VF, 0x6 }, // 2402
  { PseudoVFWNMSAC_VF16_MF2, VFWNMSAC_VF, 0x7 }, // 2403
  { PseudoVFWNMSAC_VF16_MF2_MASK, VFWNMSAC_VF, 0x7 }, // 2404
  { PseudoVFWNMSAC_VF32_MF2, VFWNMSAC_VF, 0x7 }, // 2405
  { PseudoVFWNMSAC_VF32_MF2_MASK, VFWNMSAC_VF, 0x7 }, // 2406
  { PseudoVFWNMSAC_VV_M1, VFWNMSAC_VV, 0x0 }, // 2407
  { PseudoVFWNMSAC_VV_M1_MASK, VFWNMSAC_VV, 0x0 }, // 2408
  { PseudoVFWNMSAC_VV_M2, VFWNMSAC_VV, 0x1 }, // 2409
  { PseudoVFWNMSAC_VV_M2_MASK, VFWNMSAC_VV, 0x1 }, // 2410
  { PseudoVFWNMSAC_VV_M4, VFWNMSAC_VV, 0x2 }, // 2411
  { PseudoVFWNMSAC_VV_M4_MASK, VFWNMSAC_VV, 0x2 }, // 2412
  { PseudoVFWNMSAC_VV_MF4, VFWNMSAC_VV, 0x6 }, // 2413
  { PseudoVFWNMSAC_VV_MF4_MASK, VFWNMSAC_VV, 0x6 }, // 2414
  { PseudoVFWNMSAC_VV_MF2, VFWNMSAC_VV, 0x7 }, // 2415
  { PseudoVFWNMSAC_VV_MF2_MASK, VFWNMSAC_VV, 0x7 }, // 2416
  { PseudoVFWREDOSUM_VS_M1, VFWREDOSUM_VS, 0x0 }, // 2417
  { PseudoVFWREDOSUM_VS_M1_MASK, VFWREDOSUM_VS, 0x0 }, // 2418
  { PseudoVFWREDOSUM_VS_M2, VFWREDOSUM_VS, 0x1 }, // 2419
  { PseudoVFWREDOSUM_VS_M2_MASK, VFWREDOSUM_VS, 0x1 }, // 2420
  { PseudoVFWREDOSUM_VS_M4, VFWREDOSUM_VS, 0x2 }, // 2421
  { PseudoVFWREDOSUM_VS_M4_MASK, VFWREDOSUM_VS, 0x2 }, // 2422
  { PseudoVFWREDOSUM_VS_M8, VFWREDOSUM_VS, 0x3 }, // 2423
  { PseudoVFWREDOSUM_VS_M8_MASK, VFWREDOSUM_VS, 0x3 }, // 2424
  { PseudoVFWREDOSUM_VS_MF4, VFWREDOSUM_VS, 0x6 }, // 2425
  { PseudoVFWREDOSUM_VS_MF4_MASK, VFWREDOSUM_VS, 0x6 }, // 2426
  { PseudoVFWREDOSUM_VS_MF2, VFWREDOSUM_VS, 0x7 }, // 2427
  { PseudoVFWREDOSUM_VS_MF2_MASK, VFWREDOSUM_VS, 0x7 }, // 2428
  { PseudoVFWREDUSUM_VS_M1, VFWREDUSUM_VS, 0x0 }, // 2429
  { PseudoVFWREDUSUM_VS_M1_MASK, VFWREDUSUM_VS, 0x0 }, // 2430
  { PseudoVFWREDUSUM_VS_M2, VFWREDUSUM_VS, 0x1 }, // 2431
  { PseudoVFWREDUSUM_VS_M2_MASK, VFWREDUSUM_VS, 0x1 }, // 2432
  { PseudoVFWREDUSUM_VS_M4, VFWREDUSUM_VS, 0x2 }, // 2433
  { PseudoVFWREDUSUM_VS_M4_MASK, VFWREDUSUM_VS, 0x2 }, // 2434
  { PseudoVFWREDUSUM_VS_M8, VFWREDUSUM_VS, 0x3 }, // 2435
  { PseudoVFWREDUSUM_VS_M8_MASK, VFWREDUSUM_VS, 0x3 }, // 2436
  { PseudoVFWREDUSUM_VS_MF4, VFWREDUSUM_VS, 0x6 }, // 2437
  { PseudoVFWREDUSUM_VS_MF4_MASK, VFWREDUSUM_VS, 0x6 }, // 2438
  { PseudoVFWREDUSUM_VS_MF2, VFWREDUSUM_VS, 0x7 }, // 2439
  { PseudoVFWREDUSUM_VS_MF2_MASK, VFWREDUSUM_VS, 0x7 }, // 2440
  { PseudoVFWSUB_VF16_M1, VFWSUB_VF, 0x0 }, // 2441
  { PseudoVFWSUB_VF16_M1_MASK, VFWSUB_VF, 0x0 }, // 2442
  { PseudoVFWSUB_VF16_M1_TU, VFWSUB_VF, 0x0 }, // 2443
  { PseudoVFWSUB_VF32_M1, VFWSUB_VF, 0x0 }, // 2444
  { PseudoVFWSUB_VF32_M1_MASK, VFWSUB_VF, 0x0 }, // 2445
  { PseudoVFWSUB_VF32_M1_TU, VFWSUB_VF, 0x0 }, // 2446
  { PseudoVFWSUB_VF16_M2, VFWSUB_VF, 0x1 }, // 2447
  { PseudoVFWSUB_VF16_M2_MASK, VFWSUB_VF, 0x1 }, // 2448
  { PseudoVFWSUB_VF16_M2_TU, VFWSUB_VF, 0x1 }, // 2449
  { PseudoVFWSUB_VF32_M2, VFWSUB_VF, 0x1 }, // 2450
  { PseudoVFWSUB_VF32_M2_MASK, VFWSUB_VF, 0x1 }, // 2451
  { PseudoVFWSUB_VF32_M2_TU, VFWSUB_VF, 0x1 }, // 2452
  { PseudoVFWSUB_VF16_M4, VFWSUB_VF, 0x2 }, // 2453
  { PseudoVFWSUB_VF16_M4_MASK, VFWSUB_VF, 0x2 }, // 2454
  { PseudoVFWSUB_VF16_M4_TU, VFWSUB_VF, 0x2 }, // 2455
  { PseudoVFWSUB_VF32_M4, VFWSUB_VF, 0x2 }, // 2456
  { PseudoVFWSUB_VF32_M4_MASK, VFWSUB_VF, 0x2 }, // 2457
  { PseudoVFWSUB_VF32_M4_TU, VFWSUB_VF, 0x2 }, // 2458
  { PseudoVFWSUB_VF16_MF4, VFWSUB_VF, 0x6 }, // 2459
  { PseudoVFWSUB_VF16_MF4_MASK, VFWSUB_VF, 0x6 }, // 2460
  { PseudoVFWSUB_VF16_MF4_TU, VFWSUB_VF, 0x6 }, // 2461
  { PseudoVFWSUB_VF16_MF2, VFWSUB_VF, 0x7 }, // 2462
  { PseudoVFWSUB_VF16_MF2_MASK, VFWSUB_VF, 0x7 }, // 2463
  { PseudoVFWSUB_VF16_MF2_TU, VFWSUB_VF, 0x7 }, // 2464
  { PseudoVFWSUB_VF32_MF2, VFWSUB_VF, 0x7 }, // 2465
  { PseudoVFWSUB_VF32_MF2_MASK, VFWSUB_VF, 0x7 }, // 2466
  { PseudoVFWSUB_VF32_MF2_TU, VFWSUB_VF, 0x7 }, // 2467
  { PseudoVFWSUB_VV_M1, VFWSUB_VV, 0x0 }, // 2468
  { PseudoVFWSUB_VV_M1_MASK, VFWSUB_VV, 0x0 }, // 2469
  { PseudoVFWSUB_VV_M1_TU, VFWSUB_VV, 0x0 }, // 2470
  { PseudoVFWSUB_VV_M2, VFWSUB_VV, 0x1 }, // 2471
  { PseudoVFWSUB_VV_M2_MASK, VFWSUB_VV, 0x1 }, // 2472
  { PseudoVFWSUB_VV_M2_TU, VFWSUB_VV, 0x1 }, // 2473
  { PseudoVFWSUB_VV_M4, VFWSUB_VV, 0x2 }, // 2474
  { PseudoVFWSUB_VV_M4_MASK, VFWSUB_VV, 0x2 }, // 2475
  { PseudoVFWSUB_VV_M4_TU, VFWSUB_VV, 0x2 }, // 2476
  { PseudoVFWSUB_VV_MF4, VFWSUB_VV, 0x6 }, // 2477
  { PseudoVFWSUB_VV_MF4_MASK, VFWSUB_VV, 0x6 }, // 2478
  { PseudoVFWSUB_VV_MF4_TU, VFWSUB_VV, 0x6 }, // 2479
  { PseudoVFWSUB_VV_MF2, VFWSUB_VV, 0x7 }, // 2480
  { PseudoVFWSUB_VV_MF2_MASK, VFWSUB_VV, 0x7 }, // 2481
  { PseudoVFWSUB_VV_MF2_TU, VFWSUB_VV, 0x7 }, // 2482
  { PseudoVFWSUB_WF16_M1, VFWSUB_WF, 0x0 }, // 2483
  { PseudoVFWSUB_WF16_M1_MASK, VFWSUB_WF, 0x0 }, // 2484
  { PseudoVFWSUB_WF16_M1_TU, VFWSUB_WF, 0x0 }, // 2485
  { PseudoVFWSUB_WF32_M1, VFWSUB_WF, 0x0 }, // 2486
  { PseudoVFWSUB_WF32_M1_MASK, VFWSUB_WF, 0x0 }, // 2487
  { PseudoVFWSUB_WF32_M1_TU, VFWSUB_WF, 0x0 }, // 2488
  { PseudoVFWSUB_WF16_M2, VFWSUB_WF, 0x1 }, // 2489
  { PseudoVFWSUB_WF16_M2_MASK, VFWSUB_WF, 0x1 }, // 2490
  { PseudoVFWSUB_WF16_M2_TU, VFWSUB_WF, 0x1 }, // 2491
  { PseudoVFWSUB_WF32_M2, VFWSUB_WF, 0x1 }, // 2492
  { PseudoVFWSUB_WF32_M2_MASK, VFWSUB_WF, 0x1 }, // 2493
  { PseudoVFWSUB_WF32_M2_TU, VFWSUB_WF, 0x1 }, // 2494
  { PseudoVFWSUB_WF16_M4, VFWSUB_WF, 0x2 }, // 2495
  { PseudoVFWSUB_WF16_M4_MASK, VFWSUB_WF, 0x2 }, // 2496
  { PseudoVFWSUB_WF16_M4_TU, VFWSUB_WF, 0x2 }, // 2497
  { PseudoVFWSUB_WF32_M4, VFWSUB_WF, 0x2 }, // 2498
  { PseudoVFWSUB_WF32_M4_MASK, VFWSUB_WF, 0x2 }, // 2499
  { PseudoVFWSUB_WF32_M4_TU, VFWSUB_WF, 0x2 }, // 2500
  { PseudoVFWSUB_WF16_MF4, VFWSUB_WF, 0x6 }, // 2501
  { PseudoVFWSUB_WF16_MF4_MASK, VFWSUB_WF, 0x6 }, // 2502
  { PseudoVFWSUB_WF16_MF4_TU, VFWSUB_WF, 0x6 }, // 2503
  { PseudoVFWSUB_WF16_MF2, VFWSUB_WF, 0x7 }, // 2504
  { PseudoVFWSUB_WF16_MF2_MASK, VFWSUB_WF, 0x7 }, // 2505
  { PseudoVFWSUB_WF16_MF2_TU, VFWSUB_WF, 0x7 }, // 2506
  { PseudoVFWSUB_WF32_MF2, VFWSUB_WF, 0x7 }, // 2507
  { PseudoVFWSUB_WF32_MF2_MASK, VFWSUB_WF, 0x7 }, // 2508
  { PseudoVFWSUB_WF32_MF2_TU, VFWSUB_WF, 0x7 }, // 2509
  { PseudoVFWSUB_WV_M1, VFWSUB_WV, 0x0 }, // 2510
  { PseudoVFWSUB_WV_M1_MASK, VFWSUB_WV, 0x0 }, // 2511
  { PseudoVFWSUB_WV_M1_MASK_TIED, VFWSUB_WV, 0x0 }, // 2512
  { PseudoVFWSUB_WV_M1_TIED, VFWSUB_WV, 0x0 }, // 2513
  { PseudoVFWSUB_WV_M1_TU, VFWSUB_WV, 0x0 }, // 2514
  { PseudoVFWSUB_WV_M2, VFWSUB_WV, 0x1 }, // 2515
  { PseudoVFWSUB_WV_M2_MASK, VFWSUB_WV, 0x1 }, // 2516
  { PseudoVFWSUB_WV_M2_MASK_TIED, VFWSUB_WV, 0x1 }, // 2517
  { PseudoVFWSUB_WV_M2_TIED, VFWSUB_WV, 0x1 }, // 2518
  { PseudoVFWSUB_WV_M2_TU, VFWSUB_WV, 0x1 }, // 2519
  { PseudoVFWSUB_WV_M4, VFWSUB_WV, 0x2 }, // 2520
  { PseudoVFWSUB_WV_M4_MASK, VFWSUB_WV, 0x2 }, // 2521
  { PseudoVFWSUB_WV_M4_MASK_TIED, VFWSUB_WV, 0x2 }, // 2522
  { PseudoVFWSUB_WV_M4_TIED, VFWSUB_WV, 0x2 }, // 2523
  { PseudoVFWSUB_WV_M4_TU, VFWSUB_WV, 0x2 }, // 2524
  { PseudoVFWSUB_WV_MF4, VFWSUB_WV, 0x6 }, // 2525
  { PseudoVFWSUB_WV_MF4_MASK, VFWSUB_WV, 0x6 }, // 2526
  { PseudoVFWSUB_WV_MF4_MASK_TIED, VFWSUB_WV, 0x6 }, // 2527
  { PseudoVFWSUB_WV_MF4_TIED, VFWSUB_WV, 0x6 }, // 2528
  { PseudoVFWSUB_WV_MF4_TU, VFWSUB_WV, 0x6 }, // 2529
  { PseudoVFWSUB_WV_MF2, VFWSUB_WV, 0x7 }, // 2530
  { PseudoVFWSUB_WV_MF2_MASK, VFWSUB_WV, 0x7 }, // 2531
  { PseudoVFWSUB_WV_MF2_MASK_TIED, VFWSUB_WV, 0x7 }, // 2532
  { PseudoVFWSUB_WV_MF2_TIED, VFWSUB_WV, 0x7 }, // 2533
  { PseudoVFWSUB_WV_MF2_TU, VFWSUB_WV, 0x7 }, // 2534
  { PseudoVID_V_M1, VID_V, 0x0 }, // 2535
  { PseudoVID_V_M1_MASK, VID_V, 0x0 }, // 2536
  { PseudoVID_V_M1_TU, VID_V, 0x0 }, // 2537
  { PseudoVID_V_M2, VID_V, 0x1 }, // 2538
  { PseudoVID_V_M2_MASK, VID_V, 0x1 }, // 2539
  { PseudoVID_V_M2_TU, VID_V, 0x1 }, // 2540
  { PseudoVID_V_M4, VID_V, 0x2 }, // 2541
  { PseudoVID_V_M4_MASK, VID_V, 0x2 }, // 2542
  { PseudoVID_V_M4_TU, VID_V, 0x2 }, // 2543
  { PseudoVID_V_M8, VID_V, 0x3 }, // 2544
  { PseudoVID_V_M8_MASK, VID_V, 0x3 }, // 2545
  { PseudoVID_V_M8_TU, VID_V, 0x3 }, // 2546
  { PseudoVID_V_MF8, VID_V, 0x5 }, // 2547
  { PseudoVID_V_MF8_MASK, VID_V, 0x5 }, // 2548
  { PseudoVID_V_MF8_TU, VID_V, 0x5 }, // 2549
  { PseudoVID_V_MF4, VID_V, 0x6 }, // 2550
  { PseudoVID_V_MF4_MASK, VID_V, 0x6 }, // 2551
  { PseudoVID_V_MF4_TU, VID_V, 0x6 }, // 2552
  { PseudoVID_V_MF2, VID_V, 0x7 }, // 2553
  { PseudoVID_V_MF2_MASK, VID_V, 0x7 }, // 2554
  { PseudoVID_V_MF2_TU, VID_V, 0x7 }, // 2555
  { PseudoVIOTA_M_M1, VIOTA_M, 0x0 }, // 2556
  { PseudoVIOTA_M_M1_MASK, VIOTA_M, 0x0 }, // 2557
  { PseudoVIOTA_M_M1_TU, VIOTA_M, 0x0 }, // 2558
  { PseudoVIOTA_M_M2, VIOTA_M, 0x1 }, // 2559
  { PseudoVIOTA_M_M2_MASK, VIOTA_M, 0x1 }, // 2560
  { PseudoVIOTA_M_M2_TU, VIOTA_M, 0x1 }, // 2561
  { PseudoVIOTA_M_M4, VIOTA_M, 0x2 }, // 2562
  { PseudoVIOTA_M_M4_MASK, VIOTA_M, 0x2 }, // 2563
  { PseudoVIOTA_M_M4_TU, VIOTA_M, 0x2 }, // 2564
  { PseudoVIOTA_M_M8, VIOTA_M, 0x3 }, // 2565
  { PseudoVIOTA_M_M8_MASK, VIOTA_M, 0x3 }, // 2566
  { PseudoVIOTA_M_M8_TU, VIOTA_M, 0x3 }, // 2567
  { PseudoVIOTA_M_MF8, VIOTA_M, 0x5 }, // 2568
  { PseudoVIOTA_M_MF8_MASK, VIOTA_M, 0x5 }, // 2569
  { PseudoVIOTA_M_MF8_TU, VIOTA_M, 0x5 }, // 2570
  { PseudoVIOTA_M_MF4, VIOTA_M, 0x6 }, // 2571
  { PseudoVIOTA_M_MF4_MASK, VIOTA_M, 0x6 }, // 2572
  { PseudoVIOTA_M_MF4_TU, VIOTA_M, 0x6 }, // 2573
  { PseudoVIOTA_M_MF2, VIOTA_M, 0x7 }, // 2574
  { PseudoVIOTA_M_MF2_MASK, VIOTA_M, 0x7 }, // 2575
  { PseudoVIOTA_M_MF2_TU, VIOTA_M, 0x7 }, // 2576
  { PseudoVLE16FF_V_M1, VLE16FF_V, 0x0 }, // 2577
  { PseudoVLE16FF_V_M1_MASK, VLE16FF_V, 0x0 }, // 2578
  { PseudoVLE16FF_V_M1_TU, VLE16FF_V, 0x0 }, // 2579
  { PseudoVLE16FF_V_M2, VLE16FF_V, 0x1 }, // 2580
  { PseudoVLE16FF_V_M2_MASK, VLE16FF_V, 0x1 }, // 2581
  { PseudoVLE16FF_V_M2_TU, VLE16FF_V, 0x1 }, // 2582
  { PseudoVLE16FF_V_M4, VLE16FF_V, 0x2 }, // 2583
  { PseudoVLE16FF_V_M4_MASK, VLE16FF_V, 0x2 }, // 2584
  { PseudoVLE16FF_V_M4_TU, VLE16FF_V, 0x2 }, // 2585
  { PseudoVLE16FF_V_M8, VLE16FF_V, 0x3 }, // 2586
  { PseudoVLE16FF_V_M8_MASK, VLE16FF_V, 0x3 }, // 2587
  { PseudoVLE16FF_V_M8_TU, VLE16FF_V, 0x3 }, // 2588
  { PseudoVLE16FF_V_MF4, VLE16FF_V, 0x6 }, // 2589
  { PseudoVLE16FF_V_MF4_MASK, VLE16FF_V, 0x6 }, // 2590
  { PseudoVLE16FF_V_MF4_TU, VLE16FF_V, 0x6 }, // 2591
  { PseudoVLE16FF_V_MF2, VLE16FF_V, 0x7 }, // 2592
  { PseudoVLE16FF_V_MF2_MASK, VLE16FF_V, 0x7 }, // 2593
  { PseudoVLE16FF_V_MF2_TU, VLE16FF_V, 0x7 }, // 2594
  { PseudoVLE16_V_M1, VLE16_V, 0x0 }, // 2595
  { PseudoVLE16_V_M1_MASK, VLE16_V, 0x0 }, // 2596
  { PseudoVLE16_V_M1_TU, VLE16_V, 0x0 }, // 2597
  { PseudoVLE16_V_M2, VLE16_V, 0x1 }, // 2598
  { PseudoVLE16_V_M2_MASK, VLE16_V, 0x1 }, // 2599
  { PseudoVLE16_V_M2_TU, VLE16_V, 0x1 }, // 2600
  { PseudoVLE16_V_M4, VLE16_V, 0x2 }, // 2601
  { PseudoVLE16_V_M4_MASK, VLE16_V, 0x2 }, // 2602
  { PseudoVLE16_V_M4_TU, VLE16_V, 0x2 }, // 2603
  { PseudoVLE16_V_M8, VLE16_V, 0x3 }, // 2604
  { PseudoVLE16_V_M8_MASK, VLE16_V, 0x3 }, // 2605
  { PseudoVLE16_V_M8_TU, VLE16_V, 0x3 }, // 2606
  { PseudoVLE16_V_MF4, VLE16_V, 0x6 }, // 2607
  { PseudoVLE16_V_MF4_MASK, VLE16_V, 0x6 }, // 2608
  { PseudoVLE16_V_MF4_TU, VLE16_V, 0x6 }, // 2609
  { PseudoVLE16_V_MF2, VLE16_V, 0x7 }, // 2610
  { PseudoVLE16_V_MF2_MASK, VLE16_V, 0x7 }, // 2611
  { PseudoVLE16_V_MF2_TU, VLE16_V, 0x7 }, // 2612
  { PseudoVLE32FF_V_M1, VLE32FF_V, 0x0 }, // 2613
  { PseudoVLE32FF_V_M1_MASK, VLE32FF_V, 0x0 }, // 2614
  { PseudoVLE32FF_V_M1_TU, VLE32FF_V, 0x0 }, // 2615
  { PseudoVLE32FF_V_M2, VLE32FF_V, 0x1 }, // 2616
  { PseudoVLE32FF_V_M2_MASK, VLE32FF_V, 0x1 }, // 2617
  { PseudoVLE32FF_V_M2_TU, VLE32FF_V, 0x1 }, // 2618
  { PseudoVLE32FF_V_M4, VLE32FF_V, 0x2 }, // 2619
  { PseudoVLE32FF_V_M4_MASK, VLE32FF_V, 0x2 }, // 2620
  { PseudoVLE32FF_V_M4_TU, VLE32FF_V, 0x2 }, // 2621
  { PseudoVLE32FF_V_M8, VLE32FF_V, 0x3 }, // 2622
  { PseudoVLE32FF_V_M8_MASK, VLE32FF_V, 0x3 }, // 2623
  { PseudoVLE32FF_V_M8_TU, VLE32FF_V, 0x3 }, // 2624
  { PseudoVLE32FF_V_MF2, VLE32FF_V, 0x7 }, // 2625
  { PseudoVLE32FF_V_MF2_MASK, VLE32FF_V, 0x7 }, // 2626
  { PseudoVLE32FF_V_MF2_TU, VLE32FF_V, 0x7 }, // 2627
  { PseudoVLE32_V_M1, VLE32_V, 0x0 }, // 2628
  { PseudoVLE32_V_M1_MASK, VLE32_V, 0x0 }, // 2629
  { PseudoVLE32_V_M1_TU, VLE32_V, 0x0 }, // 2630
  { PseudoVLE32_V_M2, VLE32_V, 0x1 }, // 2631
  { PseudoVLE32_V_M2_MASK, VLE32_V, 0x1 }, // 2632
  { PseudoVLE32_V_M2_TU, VLE32_V, 0x1 }, // 2633
  { PseudoVLE32_V_M4, VLE32_V, 0x2 }, // 2634
  { PseudoVLE32_V_M4_MASK, VLE32_V, 0x2 }, // 2635
  { PseudoVLE32_V_M4_TU, VLE32_V, 0x2 }, // 2636
  { PseudoVLE32_V_M8, VLE32_V, 0x3 }, // 2637
  { PseudoVLE32_V_M8_MASK, VLE32_V, 0x3 }, // 2638
  { PseudoVLE32_V_M8_TU, VLE32_V, 0x3 }, // 2639
  { PseudoVLE32_V_MF2, VLE32_V, 0x7 }, // 2640
  { PseudoVLE32_V_MF2_MASK, VLE32_V, 0x7 }, // 2641
  { PseudoVLE32_V_MF2_TU, VLE32_V, 0x7 }, // 2642
  { PseudoVLE64FF_V_M1, VLE64FF_V, 0x0 }, // 2643
  { PseudoVLE64FF_V_M1_MASK, VLE64FF_V, 0x0 }, // 2644
  { PseudoVLE64FF_V_M1_TU, VLE64FF_V, 0x0 }, // 2645
  { PseudoVLE64FF_V_M2, VLE64FF_V, 0x1 }, // 2646
  { PseudoVLE64FF_V_M2_MASK, VLE64FF_V, 0x1 }, // 2647
  { PseudoVLE64FF_V_M2_TU, VLE64FF_V, 0x1 }, // 2648
  { PseudoVLE64FF_V_M4, VLE64FF_V, 0x2 }, // 2649
  { PseudoVLE64FF_V_M4_MASK, VLE64FF_V, 0x2 }, // 2650
  { PseudoVLE64FF_V_M4_TU, VLE64FF_V, 0x2 }, // 2651
  { PseudoVLE64FF_V_M8, VLE64FF_V, 0x3 }, // 2652
  { PseudoVLE64FF_V_M8_MASK, VLE64FF_V, 0x3 }, // 2653
  { PseudoVLE64FF_V_M8_TU, VLE64FF_V, 0x3 }, // 2654
  { PseudoVLE64_V_M1, VLE64_V, 0x0 }, // 2655
  { PseudoVLE64_V_M1_MASK, VLE64_V, 0x0 }, // 2656
  { PseudoVLE64_V_M1_TU, VLE64_V, 0x0 }, // 2657
  { PseudoVLE64_V_M2, VLE64_V, 0x1 }, // 2658
  { PseudoVLE64_V_M2_MASK, VLE64_V, 0x1 }, // 2659
  { PseudoVLE64_V_M2_TU, VLE64_V, 0x1 }, // 2660
  { PseudoVLE64_V_M4, VLE64_V, 0x2 }, // 2661
  { PseudoVLE64_V_M4_MASK, VLE64_V, 0x2 }, // 2662
  { PseudoVLE64_V_M4_TU, VLE64_V, 0x2 }, // 2663
  { PseudoVLE64_V_M8, VLE64_V, 0x3 }, // 2664
  { PseudoVLE64_V_M8_MASK, VLE64_V, 0x3 }, // 2665
  { PseudoVLE64_V_M8_TU, VLE64_V, 0x3 }, // 2666
  { PseudoVLE8FF_V_M1, VLE8FF_V, 0x0 }, // 2667
  { PseudoVLE8FF_V_M1_MASK, VLE8FF_V, 0x0 }, // 2668
  { PseudoVLE8FF_V_M1_TU, VLE8FF_V, 0x0 }, // 2669
  { PseudoVLE8FF_V_M2, VLE8FF_V, 0x1 }, // 2670
  { PseudoVLE8FF_V_M2_MASK, VLE8FF_V, 0x1 }, // 2671
  { PseudoVLE8FF_V_M2_TU, VLE8FF_V, 0x1 }, // 2672
  { PseudoVLE8FF_V_M4, VLE8FF_V, 0x2 }, // 2673
  { PseudoVLE8FF_V_M4_MASK, VLE8FF_V, 0x2 }, // 2674
  { PseudoVLE8FF_V_M4_TU, VLE8FF_V, 0x2 }, // 2675
  { PseudoVLE8FF_V_M8, VLE8FF_V, 0x3 }, // 2676
  { PseudoVLE8FF_V_M8_MASK, VLE8FF_V, 0x3 }, // 2677
  { PseudoVLE8FF_V_M8_TU, VLE8FF_V, 0x3 }, // 2678
  { PseudoVLE8FF_V_MF8, VLE8FF_V, 0x5 }, // 2679
  { PseudoVLE8FF_V_MF8_MASK, VLE8FF_V, 0x5 }, // 2680
  { PseudoVLE8FF_V_MF8_TU, VLE8FF_V, 0x5 }, // 2681
  { PseudoVLE8FF_V_MF4, VLE8FF_V, 0x6 }, // 2682
  { PseudoVLE8FF_V_MF4_MASK, VLE8FF_V, 0x6 }, // 2683
  { PseudoVLE8FF_V_MF4_TU, VLE8FF_V, 0x6 }, // 2684
  { PseudoVLE8FF_V_MF2, VLE8FF_V, 0x7 }, // 2685
  { PseudoVLE8FF_V_MF2_MASK, VLE8FF_V, 0x7 }, // 2686
  { PseudoVLE8FF_V_MF2_TU, VLE8FF_V, 0x7 }, // 2687
  { PseudoVLE8_V_M1, VLE8_V, 0x0 }, // 2688
  { PseudoVLE8_V_M1_MASK, VLE8_V, 0x0 }, // 2689
  { PseudoVLE8_V_M1_TU, VLE8_V, 0x0 }, // 2690
  { PseudoVLE8_V_M2, VLE8_V, 0x1 }, // 2691
  { PseudoVLE8_V_M2_MASK, VLE8_V, 0x1 }, // 2692
  { PseudoVLE8_V_M2_TU, VLE8_V, 0x1 }, // 2693
  { PseudoVLE8_V_M4, VLE8_V, 0x2 }, // 2694
  { PseudoVLE8_V_M4_MASK, VLE8_V, 0x2 }, // 2695
  { PseudoVLE8_V_M4_TU, VLE8_V, 0x2 }, // 2696
  { PseudoVLE8_V_M8, VLE8_V, 0x3 }, // 2697
  { PseudoVLE8_V_M8_MASK, VLE8_V, 0x3 }, // 2698
  { PseudoVLE8_V_M8_TU, VLE8_V, 0x3 }, // 2699
  { PseudoVLE8_V_MF8, VLE8_V, 0x5 }, // 2700
  { PseudoVLE8_V_MF8_MASK, VLE8_V, 0x5 }, // 2701
  { PseudoVLE8_V_MF8_TU, VLE8_V, 0x5 }, // 2702
  { PseudoVLE8_V_MF4, VLE8_V, 0x6 }, // 2703
  { PseudoVLE8_V_MF4_MASK, VLE8_V, 0x6 }, // 2704
  { PseudoVLE8_V_MF4_TU, VLE8_V, 0x6 }, // 2705
  { PseudoVLE8_V_MF2, VLE8_V, 0x7 }, // 2706
  { PseudoVLE8_V_MF2_MASK, VLE8_V, 0x7 }, // 2707
  { PseudoVLE8_V_MF2_TU, VLE8_V, 0x7 }, // 2708
  { PseudoVLM_V_B8, VLM_V, 0x0 }, // 2709
  { PseudoVLM_V_B16, VLM_V, 0x1 }, // 2710
  { PseudoVLM_V_B32, VLM_V, 0x2 }, // 2711
  { PseudoVLM_V_B64, VLM_V, 0x3 }, // 2712
  { PseudoVLM_V_B1, VLM_V, 0x5 }, // 2713
  { PseudoVLM_V_B2, VLM_V, 0x6 }, // 2714
  { PseudoVLM_V_B4, VLM_V, 0x7 }, // 2715
  { PseudoVLOXEI16_V_M1_M1, VLOXEI16_V, 0x0 }, // 2716
  { PseudoVLOXEI16_V_M1_M1_MASK, VLOXEI16_V, 0x0 }, // 2717
  { PseudoVLOXEI16_V_M1_M1_TU, VLOXEI16_V, 0x0 }, // 2718
  { PseudoVLOXEI16_V_M2_M1, VLOXEI16_V, 0x0 }, // 2719
  { PseudoVLOXEI16_V_M2_M1_MASK, VLOXEI16_V, 0x0 }, // 2720
  { PseudoVLOXEI16_V_M2_M1_TU, VLOXEI16_V, 0x0 }, // 2721
  { PseudoVLOXEI16_V_MF2_M1, VLOXEI16_V, 0x0 }, // 2722
  { PseudoVLOXEI16_V_MF2_M1_MASK, VLOXEI16_V, 0x0 }, // 2723
  { PseudoVLOXEI16_V_MF2_M1_TU, VLOXEI16_V, 0x0 }, // 2724
  { PseudoVLOXEI16_V_MF4_M1, VLOXEI16_V, 0x0 }, // 2725
  { PseudoVLOXEI16_V_MF4_M1_MASK, VLOXEI16_V, 0x0 }, // 2726
  { PseudoVLOXEI16_V_MF4_M1_TU, VLOXEI16_V, 0x0 }, // 2727
  { PseudoVLOXEI16_V_M1_M2, VLOXEI16_V, 0x1 }, // 2728
  { PseudoVLOXEI16_V_M1_M2_MASK, VLOXEI16_V, 0x1 }, // 2729
  { PseudoVLOXEI16_V_M1_M2_TU, VLOXEI16_V, 0x1 }, // 2730
  { PseudoVLOXEI16_V_M2_M2, VLOXEI16_V, 0x1 }, // 2731
  { PseudoVLOXEI16_V_M2_M2_MASK, VLOXEI16_V, 0x1 }, // 2732
  { PseudoVLOXEI16_V_M2_M2_TU, VLOXEI16_V, 0x1 }, // 2733
  { PseudoVLOXEI16_V_M4_M2, VLOXEI16_V, 0x1 }, // 2734
  { PseudoVLOXEI16_V_M4_M2_MASK, VLOXEI16_V, 0x1 }, // 2735
  { PseudoVLOXEI16_V_M4_M2_TU, VLOXEI16_V, 0x1 }, // 2736
  { PseudoVLOXEI16_V_MF2_M2, VLOXEI16_V, 0x1 }, // 2737
  { PseudoVLOXEI16_V_MF2_M2_MASK, VLOXEI16_V, 0x1 }, // 2738
  { PseudoVLOXEI16_V_MF2_M2_TU, VLOXEI16_V, 0x1 }, // 2739
  { PseudoVLOXEI16_V_M1_M4, VLOXEI16_V, 0x2 }, // 2740
  { PseudoVLOXEI16_V_M1_M4_MASK, VLOXEI16_V, 0x2 }, // 2741
  { PseudoVLOXEI16_V_M1_M4_TU, VLOXEI16_V, 0x2 }, // 2742
  { PseudoVLOXEI16_V_M2_M4, VLOXEI16_V, 0x2 }, // 2743
  { PseudoVLOXEI16_V_M2_M4_MASK, VLOXEI16_V, 0x2 }, // 2744
  { PseudoVLOXEI16_V_M2_M4_TU, VLOXEI16_V, 0x2 }, // 2745
  { PseudoVLOXEI16_V_M4_M4, VLOXEI16_V, 0x2 }, // 2746
  { PseudoVLOXEI16_V_M4_M4_MASK, VLOXEI16_V, 0x2 }, // 2747
  { PseudoVLOXEI16_V_M4_M4_TU, VLOXEI16_V, 0x2 }, // 2748
  { PseudoVLOXEI16_V_M8_M4, VLOXEI16_V, 0x2 }, // 2749
  { PseudoVLOXEI16_V_M8_M4_MASK, VLOXEI16_V, 0x2 }, // 2750
  { PseudoVLOXEI16_V_M8_M4_TU, VLOXEI16_V, 0x2 }, // 2751
  { PseudoVLOXEI16_V_M2_M8, VLOXEI16_V, 0x3 }, // 2752
  { PseudoVLOXEI16_V_M2_M8_MASK, VLOXEI16_V, 0x3 }, // 2753
  { PseudoVLOXEI16_V_M2_M8_TU, VLOXEI16_V, 0x3 }, // 2754
  { PseudoVLOXEI16_V_M4_M8, VLOXEI16_V, 0x3 }, // 2755
  { PseudoVLOXEI16_V_M4_M8_MASK, VLOXEI16_V, 0x3 }, // 2756
  { PseudoVLOXEI16_V_M4_M8_TU, VLOXEI16_V, 0x3 }, // 2757
  { PseudoVLOXEI16_V_M8_M8, VLOXEI16_V, 0x3 }, // 2758
  { PseudoVLOXEI16_V_M8_M8_MASK, VLOXEI16_V, 0x3 }, // 2759
  { PseudoVLOXEI16_V_M8_M8_TU, VLOXEI16_V, 0x3 }, // 2760
  { PseudoVLOXEI16_V_MF4_MF8, VLOXEI16_V, 0x5 }, // 2761
  { PseudoVLOXEI16_V_MF4_MF8_MASK, VLOXEI16_V, 0x5 }, // 2762
  { PseudoVLOXEI16_V_MF4_MF8_TU, VLOXEI16_V, 0x5 }, // 2763
  { PseudoVLOXEI16_V_MF2_MF4, VLOXEI16_V, 0x6 }, // 2764
  { PseudoVLOXEI16_V_MF2_MF4_MASK, VLOXEI16_V, 0x6 }, // 2765
  { PseudoVLOXEI16_V_MF2_MF4_TU, VLOXEI16_V, 0x6 }, // 2766
  { PseudoVLOXEI16_V_MF4_MF4, VLOXEI16_V, 0x6 }, // 2767
  { PseudoVLOXEI16_V_MF4_MF4_MASK, VLOXEI16_V, 0x6 }, // 2768
  { PseudoVLOXEI16_V_MF4_MF4_TU, VLOXEI16_V, 0x6 }, // 2769
  { PseudoVLOXEI16_V_M1_MF2, VLOXEI16_V, 0x7 }, // 2770
  { PseudoVLOXEI16_V_M1_MF2_MASK, VLOXEI16_V, 0x7 }, // 2771
  { PseudoVLOXEI16_V_M1_MF2_TU, VLOXEI16_V, 0x7 }, // 2772
  { PseudoVLOXEI16_V_MF2_MF2, VLOXEI16_V, 0x7 }, // 2773
  { PseudoVLOXEI16_V_MF2_MF2_MASK, VLOXEI16_V, 0x7 }, // 2774
  { PseudoVLOXEI16_V_MF2_MF2_TU, VLOXEI16_V, 0x7 }, // 2775
  { PseudoVLOXEI16_V_MF4_MF2, VLOXEI16_V, 0x7 }, // 2776
  { PseudoVLOXEI16_V_MF4_MF2_MASK, VLOXEI16_V, 0x7 }, // 2777
  { PseudoVLOXEI16_V_MF4_MF2_TU, VLOXEI16_V, 0x7 }, // 2778
  { PseudoVLOXEI32_V_M1_M1, VLOXEI32_V, 0x0 }, // 2779
  { PseudoVLOXEI32_V_M1_M1_MASK, VLOXEI32_V, 0x0 }, // 2780
  { PseudoVLOXEI32_V_M1_M1_TU, VLOXEI32_V, 0x0 }, // 2781
  { PseudoVLOXEI32_V_M2_M1, VLOXEI32_V, 0x0 }, // 2782
  { PseudoVLOXEI32_V_M2_M1_MASK, VLOXEI32_V, 0x0 }, // 2783
  { PseudoVLOXEI32_V_M2_M1_TU, VLOXEI32_V, 0x0 }, // 2784
  { PseudoVLOXEI32_V_M4_M1, VLOXEI32_V, 0x0 }, // 2785
  { PseudoVLOXEI32_V_M4_M1_MASK, VLOXEI32_V, 0x0 }, // 2786
  { PseudoVLOXEI32_V_M4_M1_TU, VLOXEI32_V, 0x0 }, // 2787
  { PseudoVLOXEI32_V_MF2_M1, VLOXEI32_V, 0x0 }, // 2788
  { PseudoVLOXEI32_V_MF2_M1_MASK, VLOXEI32_V, 0x0 }, // 2789
  { PseudoVLOXEI32_V_MF2_M1_TU, VLOXEI32_V, 0x0 }, // 2790
  { PseudoVLOXEI32_V_M1_M2, VLOXEI32_V, 0x1 }, // 2791
  { PseudoVLOXEI32_V_M1_M2_MASK, VLOXEI32_V, 0x1 }, // 2792
  { PseudoVLOXEI32_V_M1_M2_TU, VLOXEI32_V, 0x1 }, // 2793
  { PseudoVLOXEI32_V_M2_M2, VLOXEI32_V, 0x1 }, // 2794
  { PseudoVLOXEI32_V_M2_M2_MASK, VLOXEI32_V, 0x1 }, // 2795
  { PseudoVLOXEI32_V_M2_M2_TU, VLOXEI32_V, 0x1 }, // 2796
  { PseudoVLOXEI32_V_M4_M2, VLOXEI32_V, 0x1 }, // 2797
  { PseudoVLOXEI32_V_M4_M2_MASK, VLOXEI32_V, 0x1 }, // 2798
  { PseudoVLOXEI32_V_M4_M2_TU, VLOXEI32_V, 0x1 }, // 2799
  { PseudoVLOXEI32_V_M8_M2, VLOXEI32_V, 0x1 }, // 2800
  { PseudoVLOXEI32_V_M8_M2_MASK, VLOXEI32_V, 0x1 }, // 2801
  { PseudoVLOXEI32_V_M8_M2_TU, VLOXEI32_V, 0x1 }, // 2802
  { PseudoVLOXEI32_V_M2_M4, VLOXEI32_V, 0x2 }, // 2803
  { PseudoVLOXEI32_V_M2_M4_MASK, VLOXEI32_V, 0x2 }, // 2804
  { PseudoVLOXEI32_V_M2_M4_TU, VLOXEI32_V, 0x2 }, // 2805
  { PseudoVLOXEI32_V_M4_M4, VLOXEI32_V, 0x2 }, // 2806
  { PseudoVLOXEI32_V_M4_M4_MASK, VLOXEI32_V, 0x2 }, // 2807
  { PseudoVLOXEI32_V_M4_M4_TU, VLOXEI32_V, 0x2 }, // 2808
  { PseudoVLOXEI32_V_M8_M4, VLOXEI32_V, 0x2 }, // 2809
  { PseudoVLOXEI32_V_M8_M4_MASK, VLOXEI32_V, 0x2 }, // 2810
  { PseudoVLOXEI32_V_M8_M4_TU, VLOXEI32_V, 0x2 }, // 2811
  { PseudoVLOXEI32_V_M4_M8, VLOXEI32_V, 0x3 }, // 2812
  { PseudoVLOXEI32_V_M4_M8_MASK, VLOXEI32_V, 0x3 }, // 2813
  { PseudoVLOXEI32_V_M4_M8_TU, VLOXEI32_V, 0x3 }, // 2814
  { PseudoVLOXEI32_V_M8_M8, VLOXEI32_V, 0x3 }, // 2815
  { PseudoVLOXEI32_V_M8_M8_MASK, VLOXEI32_V, 0x3 }, // 2816
  { PseudoVLOXEI32_V_M8_M8_TU, VLOXEI32_V, 0x3 }, // 2817
  { PseudoVLOXEI32_V_MF2_MF8, VLOXEI32_V, 0x5 }, // 2818
  { PseudoVLOXEI32_V_MF2_MF8_MASK, VLOXEI32_V, 0x5 }, // 2819
  { PseudoVLOXEI32_V_MF2_MF8_TU, VLOXEI32_V, 0x5 }, // 2820
  { PseudoVLOXEI32_V_M1_MF4, VLOXEI32_V, 0x6 }, // 2821
  { PseudoVLOXEI32_V_M1_MF4_MASK, VLOXEI32_V, 0x6 }, // 2822
  { PseudoVLOXEI32_V_M1_MF4_TU, VLOXEI32_V, 0x6 }, // 2823
  { PseudoVLOXEI32_V_MF2_MF4, VLOXEI32_V, 0x6 }, // 2824
  { PseudoVLOXEI32_V_MF2_MF4_MASK, VLOXEI32_V, 0x6 }, // 2825
  { PseudoVLOXEI32_V_MF2_MF4_TU, VLOXEI32_V, 0x6 }, // 2826
  { PseudoVLOXEI32_V_M1_MF2, VLOXEI32_V, 0x7 }, // 2827
  { PseudoVLOXEI32_V_M1_MF2_MASK, VLOXEI32_V, 0x7 }, // 2828
  { PseudoVLOXEI32_V_M1_MF2_TU, VLOXEI32_V, 0x7 }, // 2829
  { PseudoVLOXEI32_V_M2_MF2, VLOXEI32_V, 0x7 }, // 2830
  { PseudoVLOXEI32_V_M2_MF2_MASK, VLOXEI32_V, 0x7 }, // 2831
  { PseudoVLOXEI32_V_M2_MF2_TU, VLOXEI32_V, 0x7 }, // 2832
  { PseudoVLOXEI32_V_MF2_MF2, VLOXEI32_V, 0x7 }, // 2833
  { PseudoVLOXEI32_V_MF2_MF2_MASK, VLOXEI32_V, 0x7 }, // 2834
  { PseudoVLOXEI32_V_MF2_MF2_TU, VLOXEI32_V, 0x7 }, // 2835
  { PseudoVLOXEI64_V_M1_M1, VLOXEI64_V, 0x0 }, // 2836
  { PseudoVLOXEI64_V_M1_M1_MASK, VLOXEI64_V, 0x0 }, // 2837
  { PseudoVLOXEI64_V_M1_M1_TU, VLOXEI64_V, 0x0 }, // 2838
  { PseudoVLOXEI64_V_M2_M1, VLOXEI64_V, 0x0 }, // 2839
  { PseudoVLOXEI64_V_M2_M1_MASK, VLOXEI64_V, 0x0 }, // 2840
  { PseudoVLOXEI64_V_M2_M1_TU, VLOXEI64_V, 0x0 }, // 2841
  { PseudoVLOXEI64_V_M4_M1, VLOXEI64_V, 0x0 }, // 2842
  { PseudoVLOXEI64_V_M4_M1_MASK, VLOXEI64_V, 0x0 }, // 2843
  { PseudoVLOXEI64_V_M4_M1_TU, VLOXEI64_V, 0x0 }, // 2844
  { PseudoVLOXEI64_V_M8_M1, VLOXEI64_V, 0x0 }, // 2845
  { PseudoVLOXEI64_V_M8_M1_MASK, VLOXEI64_V, 0x0 }, // 2846
  { PseudoVLOXEI64_V_M8_M1_TU, VLOXEI64_V, 0x0 }, // 2847
  { PseudoVLOXEI64_V_M2_M2, VLOXEI64_V, 0x1 }, // 2848
  { PseudoVLOXEI64_V_M2_M2_MASK, VLOXEI64_V, 0x1 }, // 2849
  { PseudoVLOXEI64_V_M2_M2_TU, VLOXEI64_V, 0x1 }, // 2850
  { PseudoVLOXEI64_V_M4_M2, VLOXEI64_V, 0x1 }, // 2851
  { PseudoVLOXEI64_V_M4_M2_MASK, VLOXEI64_V, 0x1 }, // 2852
  { PseudoVLOXEI64_V_M4_M2_TU, VLOXEI64_V, 0x1 }, // 2853
  { PseudoVLOXEI64_V_M8_M2, VLOXEI64_V, 0x1 }, // 2854
  { PseudoVLOXEI64_V_M8_M2_MASK, VLOXEI64_V, 0x1 }, // 2855
  { PseudoVLOXEI64_V_M8_M2_TU, VLOXEI64_V, 0x1 }, // 2856
  { PseudoVLOXEI64_V_M4_M4, VLOXEI64_V, 0x2 }, // 2857
  { PseudoVLOXEI64_V_M4_M4_MASK, VLOXEI64_V, 0x2 }, // 2858
  { PseudoVLOXEI64_V_M4_M4_TU, VLOXEI64_V, 0x2 }, // 2859
  { PseudoVLOXEI64_V_M8_M4, VLOXEI64_V, 0x2 }, // 2860
  { PseudoVLOXEI64_V_M8_M4_MASK, VLOXEI64_V, 0x2 }, // 2861
  { PseudoVLOXEI64_V_M8_M4_TU, VLOXEI64_V, 0x2 }, // 2862
  { PseudoVLOXEI64_V_M8_M8, VLOXEI64_V, 0x3 }, // 2863
  { PseudoVLOXEI64_V_M8_M8_MASK, VLOXEI64_V, 0x3 }, // 2864
  { PseudoVLOXEI64_V_M8_M8_TU, VLOXEI64_V, 0x3 }, // 2865
  { PseudoVLOXEI64_V_M1_MF8, VLOXEI64_V, 0x5 }, // 2866
  { PseudoVLOXEI64_V_M1_MF8_MASK, VLOXEI64_V, 0x5 }, // 2867
  { PseudoVLOXEI64_V_M1_MF8_TU, VLOXEI64_V, 0x5 }, // 2868
  { PseudoVLOXEI64_V_M1_MF4, VLOXEI64_V, 0x6 }, // 2869
  { PseudoVLOXEI64_V_M1_MF4_MASK, VLOXEI64_V, 0x6 }, // 2870
  { PseudoVLOXEI64_V_M1_MF4_TU, VLOXEI64_V, 0x6 }, // 2871
  { PseudoVLOXEI64_V_M2_MF4, VLOXEI64_V, 0x6 }, // 2872
  { PseudoVLOXEI64_V_M2_MF4_MASK, VLOXEI64_V, 0x6 }, // 2873
  { PseudoVLOXEI64_V_M2_MF4_TU, VLOXEI64_V, 0x6 }, // 2874
  { PseudoVLOXEI64_V_M1_MF2, VLOXEI64_V, 0x7 }, // 2875
  { PseudoVLOXEI64_V_M1_MF2_MASK, VLOXEI64_V, 0x7 }, // 2876
  { PseudoVLOXEI64_V_M1_MF2_TU, VLOXEI64_V, 0x7 }, // 2877
  { PseudoVLOXEI64_V_M2_MF2, VLOXEI64_V, 0x7 }, // 2878
  { PseudoVLOXEI64_V_M2_MF2_MASK, VLOXEI64_V, 0x7 }, // 2879
  { PseudoVLOXEI64_V_M2_MF2_TU, VLOXEI64_V, 0x7 }, // 2880
  { PseudoVLOXEI64_V_M4_MF2, VLOXEI64_V, 0x7 }, // 2881
  { PseudoVLOXEI64_V_M4_MF2_MASK, VLOXEI64_V, 0x7 }, // 2882
  { PseudoVLOXEI64_V_M4_MF2_TU, VLOXEI64_V, 0x7 }, // 2883
  { PseudoVLOXEI8_V_M1_M1, VLOXEI8_V, 0x0 }, // 2884
  { PseudoVLOXEI8_V_M1_M1_MASK, VLOXEI8_V, 0x0 }, // 2885
  { PseudoVLOXEI8_V_M1_M1_TU, VLOXEI8_V, 0x0 }, // 2886
  { PseudoVLOXEI8_V_MF2_M1, VLOXEI8_V, 0x0 }, // 2887
  { PseudoVLOXEI8_V_MF2_M1_MASK, VLOXEI8_V, 0x0 }, // 2888
  { PseudoVLOXEI8_V_MF2_M1_TU, VLOXEI8_V, 0x0 }, // 2889
  { PseudoVLOXEI8_V_MF4_M1, VLOXEI8_V, 0x0 }, // 2890
  { PseudoVLOXEI8_V_MF4_M1_MASK, VLOXEI8_V, 0x0 }, // 2891
  { PseudoVLOXEI8_V_MF4_M1_TU, VLOXEI8_V, 0x0 }, // 2892
  { PseudoVLOXEI8_V_MF8_M1, VLOXEI8_V, 0x0 }, // 2893
  { PseudoVLOXEI8_V_MF8_M1_MASK, VLOXEI8_V, 0x0 }, // 2894
  { PseudoVLOXEI8_V_MF8_M1_TU, VLOXEI8_V, 0x0 }, // 2895
  { PseudoVLOXEI8_V_M1_M2, VLOXEI8_V, 0x1 }, // 2896
  { PseudoVLOXEI8_V_M1_M2_MASK, VLOXEI8_V, 0x1 }, // 2897
  { PseudoVLOXEI8_V_M1_M2_TU, VLOXEI8_V, 0x1 }, // 2898
  { PseudoVLOXEI8_V_M2_M2, VLOXEI8_V, 0x1 }, // 2899
  { PseudoVLOXEI8_V_M2_M2_MASK, VLOXEI8_V, 0x1 }, // 2900
  { PseudoVLOXEI8_V_M2_M2_TU, VLOXEI8_V, 0x1 }, // 2901
  { PseudoVLOXEI8_V_MF2_M2, VLOXEI8_V, 0x1 }, // 2902
  { PseudoVLOXEI8_V_MF2_M2_MASK, VLOXEI8_V, 0x1 }, // 2903
  { PseudoVLOXEI8_V_MF2_M2_TU, VLOXEI8_V, 0x1 }, // 2904
  { PseudoVLOXEI8_V_MF4_M2, VLOXEI8_V, 0x1 }, // 2905
  { PseudoVLOXEI8_V_MF4_M2_MASK, VLOXEI8_V, 0x1 }, // 2906
  { PseudoVLOXEI8_V_MF4_M2_TU, VLOXEI8_V, 0x1 }, // 2907
  { PseudoVLOXEI8_V_M1_M4, VLOXEI8_V, 0x2 }, // 2908
  { PseudoVLOXEI8_V_M1_M4_MASK, VLOXEI8_V, 0x2 }, // 2909
  { PseudoVLOXEI8_V_M1_M4_TU, VLOXEI8_V, 0x2 }, // 2910
  { PseudoVLOXEI8_V_M2_M4, VLOXEI8_V, 0x2 }, // 2911
  { PseudoVLOXEI8_V_M2_M4_MASK, VLOXEI8_V, 0x2 }, // 2912
  { PseudoVLOXEI8_V_M2_M4_TU, VLOXEI8_V, 0x2 }, // 2913
  { PseudoVLOXEI8_V_M4_M4, VLOXEI8_V, 0x2 }, // 2914
  { PseudoVLOXEI8_V_M4_M4_MASK, VLOXEI8_V, 0x2 }, // 2915
  { PseudoVLOXEI8_V_M4_M4_TU, VLOXEI8_V, 0x2 }, // 2916
  { PseudoVLOXEI8_V_MF2_M4, VLOXEI8_V, 0x2 }, // 2917
  { PseudoVLOXEI8_V_MF2_M4_MASK, VLOXEI8_V, 0x2 }, // 2918
  { PseudoVLOXEI8_V_MF2_M4_TU, VLOXEI8_V, 0x2 }, // 2919
  { PseudoVLOXEI8_V_M1_M8, VLOXEI8_V, 0x3 }, // 2920
  { PseudoVLOXEI8_V_M1_M8_MASK, VLOXEI8_V, 0x3 }, // 2921
  { PseudoVLOXEI8_V_M1_M8_TU, VLOXEI8_V, 0x3 }, // 2922
  { PseudoVLOXEI8_V_M2_M8, VLOXEI8_V, 0x3 }, // 2923
  { PseudoVLOXEI8_V_M2_M8_MASK, VLOXEI8_V, 0x3 }, // 2924
  { PseudoVLOXEI8_V_M2_M8_TU, VLOXEI8_V, 0x3 }, // 2925
  { PseudoVLOXEI8_V_M4_M8, VLOXEI8_V, 0x3 }, // 2926
  { PseudoVLOXEI8_V_M4_M8_MASK, VLOXEI8_V, 0x3 }, // 2927
  { PseudoVLOXEI8_V_M4_M8_TU, VLOXEI8_V, 0x3 }, // 2928
  { PseudoVLOXEI8_V_M8_M8, VLOXEI8_V, 0x3 }, // 2929
  { PseudoVLOXEI8_V_M8_M8_MASK, VLOXEI8_V, 0x3 }, // 2930
  { PseudoVLOXEI8_V_M8_M8_TU, VLOXEI8_V, 0x3 }, // 2931
  { PseudoVLOXEI8_V_MF8_MF8, VLOXEI8_V, 0x5 }, // 2932
  { PseudoVLOXEI8_V_MF8_MF8_MASK, VLOXEI8_V, 0x5 }, // 2933
  { PseudoVLOXEI8_V_MF8_MF8_TU, VLOXEI8_V, 0x5 }, // 2934
  { PseudoVLOXEI8_V_MF4_MF4, VLOXEI8_V, 0x6 }, // 2935
  { PseudoVLOXEI8_V_MF4_MF4_MASK, VLOXEI8_V, 0x6 }, // 2936
  { PseudoVLOXEI8_V_MF4_MF4_TU, VLOXEI8_V, 0x6 }, // 2937
  { PseudoVLOXEI8_V_MF8_MF4, VLOXEI8_V, 0x6 }, // 2938
  { PseudoVLOXEI8_V_MF8_MF4_MASK, VLOXEI8_V, 0x6 }, // 2939
  { PseudoVLOXEI8_V_MF8_MF4_TU, VLOXEI8_V, 0x6 }, // 2940
  { PseudoVLOXEI8_V_MF2_MF2, VLOXEI8_V, 0x7 }, // 2941
  { PseudoVLOXEI8_V_MF2_MF2_MASK, VLOXEI8_V, 0x7 }, // 2942
  { PseudoVLOXEI8_V_MF2_MF2_TU, VLOXEI8_V, 0x7 }, // 2943
  { PseudoVLOXEI8_V_MF4_MF2, VLOXEI8_V, 0x7 }, // 2944
  { PseudoVLOXEI8_V_MF4_MF2_MASK, VLOXEI8_V, 0x7 }, // 2945
  { PseudoVLOXEI8_V_MF4_MF2_TU, VLOXEI8_V, 0x7 }, // 2946
  { PseudoVLOXEI8_V_MF8_MF2, VLOXEI8_V, 0x7 }, // 2947
  { PseudoVLOXEI8_V_MF8_MF2_MASK, VLOXEI8_V, 0x7 }, // 2948
  { PseudoVLOXEI8_V_MF8_MF2_TU, VLOXEI8_V, 0x7 }, // 2949
  { PseudoVLOXSEG2EI16_V_M1_M1, VLOXSEG2EI16_V, 0x0 }, // 2950
  { PseudoVLOXSEG2EI16_V_M1_M1_MASK, VLOXSEG2EI16_V, 0x0 }, // 2951
  { PseudoVLOXSEG2EI16_V_M1_M1_TU, VLOXSEG2EI16_V, 0x0 }, // 2952
  { PseudoVLOXSEG2EI16_V_M2_M1, VLOXSEG2EI16_V, 0x0 }, // 2953
  { PseudoVLOXSEG2EI16_V_M2_M1_MASK, VLOXSEG2EI16_V, 0x0 }, // 2954
  { PseudoVLOXSEG2EI16_V_M2_M1_TU, VLOXSEG2EI16_V, 0x0 }, // 2955
  { PseudoVLOXSEG2EI16_V_MF2_M1, VLOXSEG2EI16_V, 0x0 }, // 2956
  { PseudoVLOXSEG2EI16_V_MF2_M1_MASK, VLOXSEG2EI16_V, 0x0 }, // 2957
  { PseudoVLOXSEG2EI16_V_MF2_M1_TU, VLOXSEG2EI16_V, 0x0 }, // 2958
  { PseudoVLOXSEG2EI16_V_MF4_M1, VLOXSEG2EI16_V, 0x0 }, // 2959
  { PseudoVLOXSEG2EI16_V_MF4_M1_MASK, VLOXSEG2EI16_V, 0x0 }, // 2960
  { PseudoVLOXSEG2EI16_V_MF4_M1_TU, VLOXSEG2EI16_V, 0x0 }, // 2961
  { PseudoVLOXSEG2EI16_V_M1_M2, VLOXSEG2EI16_V, 0x1 }, // 2962
  { PseudoVLOXSEG2EI16_V_M1_M2_MASK, VLOXSEG2EI16_V, 0x1 }, // 2963
  { PseudoVLOXSEG2EI16_V_M1_M2_TU, VLOXSEG2EI16_V, 0x1 }, // 2964
  { PseudoVLOXSEG2EI16_V_M2_M2, VLOXSEG2EI16_V, 0x1 }, // 2965
  { PseudoVLOXSEG2EI16_V_M2_M2_MASK, VLOXSEG2EI16_V, 0x1 }, // 2966
  { PseudoVLOXSEG2EI16_V_M2_M2_TU, VLOXSEG2EI16_V, 0x1 }, // 2967
  { PseudoVLOXSEG2EI16_V_M4_M2, VLOXSEG2EI16_V, 0x1 }, // 2968
  { PseudoVLOXSEG2EI16_V_M4_M2_MASK, VLOXSEG2EI16_V, 0x1 }, // 2969
  { PseudoVLOXSEG2EI16_V_M4_M2_TU, VLOXSEG2EI16_V, 0x1 }, // 2970
  { PseudoVLOXSEG2EI16_V_MF2_M2, VLOXSEG2EI16_V, 0x1 }, // 2971
  { PseudoVLOXSEG2EI16_V_MF2_M2_MASK, VLOXSEG2EI16_V, 0x1 }, // 2972
  { PseudoVLOXSEG2EI16_V_MF2_M2_TU, VLOXSEG2EI16_V, 0x1 }, // 2973
  { PseudoVLOXSEG2EI16_V_M1_M4, VLOXSEG2EI16_V, 0x2 }, // 2974
  { PseudoVLOXSEG2EI16_V_M1_M4_MASK, VLOXSEG2EI16_V, 0x2 }, // 2975
  { PseudoVLOXSEG2EI16_V_M1_M4_TU, VLOXSEG2EI16_V, 0x2 }, // 2976
  { PseudoVLOXSEG2EI16_V_M2_M4, VLOXSEG2EI16_V, 0x2 }, // 2977
  { PseudoVLOXSEG2EI16_V_M2_M4_MASK, VLOXSEG2EI16_V, 0x2 }, // 2978
  { PseudoVLOXSEG2EI16_V_M2_M4_TU, VLOXSEG2EI16_V, 0x2 }, // 2979
  { PseudoVLOXSEG2EI16_V_M4_M4, VLOXSEG2EI16_V, 0x2 }, // 2980
  { PseudoVLOXSEG2EI16_V_M4_M4_MASK, VLOXSEG2EI16_V, 0x2 }, // 2981
  { PseudoVLOXSEG2EI16_V_M4_M4_TU, VLOXSEG2EI16_V, 0x2 }, // 2982
  { PseudoVLOXSEG2EI16_V_M8_M4, VLOXSEG2EI16_V, 0x2 }, // 2983
  { PseudoVLOXSEG2EI16_V_M8_M4_MASK, VLOXSEG2EI16_V, 0x2 }, // 2984
  { PseudoVLOXSEG2EI16_V_M8_M4_TU, VLOXSEG2EI16_V, 0x2 }, // 2985
  { PseudoVLOXSEG2EI16_V_MF4_MF8, VLOXSEG2EI16_V, 0x5 }, // 2986
  { PseudoVLOXSEG2EI16_V_MF4_MF8_MASK, VLOXSEG2EI16_V, 0x5 }, // 2987
  { PseudoVLOXSEG2EI16_V_MF4_MF8_TU, VLOXSEG2EI16_V, 0x5 }, // 2988
  { PseudoVLOXSEG2EI16_V_MF2_MF4, VLOXSEG2EI16_V, 0x6 }, // 2989
  { PseudoVLOXSEG2EI16_V_MF2_MF4_MASK, VLOXSEG2EI16_V, 0x6 }, // 2990
  { PseudoVLOXSEG2EI16_V_MF2_MF4_TU, VLOXSEG2EI16_V, 0x6 }, // 2991
  { PseudoVLOXSEG2EI16_V_MF4_MF4, VLOXSEG2EI16_V, 0x6 }, // 2992
  { PseudoVLOXSEG2EI16_V_MF4_MF4_MASK, VLOXSEG2EI16_V, 0x6 }, // 2993
  { PseudoVLOXSEG2EI16_V_MF4_MF4_TU, VLOXSEG2EI16_V, 0x6 }, // 2994
  { PseudoVLOXSEG2EI16_V_M1_MF2, VLOXSEG2EI16_V, 0x7 }, // 2995
  { PseudoVLOXSEG2EI16_V_M1_MF2_MASK, VLOXSEG2EI16_V, 0x7 }, // 2996
  { PseudoVLOXSEG2EI16_V_M1_MF2_TU, VLOXSEG2EI16_V, 0x7 }, // 2997
  { PseudoVLOXSEG2EI16_V_MF2_MF2, VLOXSEG2EI16_V, 0x7 }, // 2998
  { PseudoVLOXSEG2EI16_V_MF2_MF2_MASK, VLOXSEG2EI16_V, 0x7 }, // 2999
  { PseudoVLOXSEG2EI16_V_MF2_MF2_TU, VLOXSEG2EI16_V, 0x7 }, // 3000
  { PseudoVLOXSEG2EI16_V_MF4_MF2, VLOXSEG2EI16_V, 0x7 }, // 3001
  { PseudoVLOXSEG2EI16_V_MF4_MF2_MASK, VLOXSEG2EI16_V, 0x7 }, // 3002
  { PseudoVLOXSEG2EI16_V_MF4_MF2_TU, VLOXSEG2EI16_V, 0x7 }, // 3003
  { PseudoVLOXSEG2EI32_V_M1_M1, VLOXSEG2EI32_V, 0x0 }, // 3004
  { PseudoVLOXSEG2EI32_V_M1_M1_MASK, VLOXSEG2EI32_V, 0x0 }, // 3005
  { PseudoVLOXSEG2EI32_V_M1_M1_TU, VLOXSEG2EI32_V, 0x0 }, // 3006
  { PseudoVLOXSEG2EI32_V_M2_M1, VLOXSEG2EI32_V, 0x0 }, // 3007
  { PseudoVLOXSEG2EI32_V_M2_M1_MASK, VLOXSEG2EI32_V, 0x0 }, // 3008
  { PseudoVLOXSEG2EI32_V_M2_M1_TU, VLOXSEG2EI32_V, 0x0 }, // 3009
  { PseudoVLOXSEG2EI32_V_M4_M1, VLOXSEG2EI32_V, 0x0 }, // 3010
  { PseudoVLOXSEG2EI32_V_M4_M1_MASK, VLOXSEG2EI32_V, 0x0 }, // 3011
  { PseudoVLOXSEG2EI32_V_M4_M1_TU, VLOXSEG2EI32_V, 0x0 }, // 3012
  { PseudoVLOXSEG2EI32_V_MF2_M1, VLOXSEG2EI32_V, 0x0 }, // 3013
  { PseudoVLOXSEG2EI32_V_MF2_M1_MASK, VLOXSEG2EI32_V, 0x0 }, // 3014
  { PseudoVLOXSEG2EI32_V_MF2_M1_TU, VLOXSEG2EI32_V, 0x0 }, // 3015
  { PseudoVLOXSEG2EI32_V_M1_M2, VLOXSEG2EI32_V, 0x1 }, // 3016
  { PseudoVLOXSEG2EI32_V_M1_M2_MASK, VLOXSEG2EI32_V, 0x1 }, // 3017
  { PseudoVLOXSEG2EI32_V_M1_M2_TU, VLOXSEG2EI32_V, 0x1 }, // 3018
  { PseudoVLOXSEG2EI32_V_M2_M2, VLOXSEG2EI32_V, 0x1 }, // 3019
  { PseudoVLOXSEG2EI32_V_M2_M2_MASK, VLOXSEG2EI32_V, 0x1 }, // 3020
  { PseudoVLOXSEG2EI32_V_M2_M2_TU, VLOXSEG2EI32_V, 0x1 }, // 3021
  { PseudoVLOXSEG2EI32_V_M4_M2, VLOXSEG2EI32_V, 0x1 }, // 3022
  { PseudoVLOXSEG2EI32_V_M4_M2_MASK, VLOXSEG2EI32_V, 0x1 }, // 3023
  { PseudoVLOXSEG2EI32_V_M4_M2_TU, VLOXSEG2EI32_V, 0x1 }, // 3024
  { PseudoVLOXSEG2EI32_V_M8_M2, VLOXSEG2EI32_V, 0x1 }, // 3025
  { PseudoVLOXSEG2EI32_V_M8_M2_MASK, VLOXSEG2EI32_V, 0x1 }, // 3026
  { PseudoVLOXSEG2EI32_V_M8_M2_TU, VLOXSEG2EI32_V, 0x1 }, // 3027
  { PseudoVLOXSEG2EI32_V_M2_M4, VLOXSEG2EI32_V, 0x2 }, // 3028
  { PseudoVLOXSEG2EI32_V_M2_M4_MASK, VLOXSEG2EI32_V, 0x2 }, // 3029
  { PseudoVLOXSEG2EI32_V_M2_M4_TU, VLOXSEG2EI32_V, 0x2 }, // 3030
  { PseudoVLOXSEG2EI32_V_M4_M4, VLOXSEG2EI32_V, 0x2 }, // 3031
  { PseudoVLOXSEG2EI32_V_M4_M4_MASK, VLOXSEG2EI32_V, 0x2 }, // 3032
  { PseudoVLOXSEG2EI32_V_M4_M4_TU, VLOXSEG2EI32_V, 0x2 }, // 3033
  { PseudoVLOXSEG2EI32_V_M8_M4, VLOXSEG2EI32_V, 0x2 }, // 3034
  { PseudoVLOXSEG2EI32_V_M8_M4_MASK, VLOXSEG2EI32_V, 0x2 }, // 3035
  { PseudoVLOXSEG2EI32_V_M8_M4_TU, VLOXSEG2EI32_V, 0x2 }, // 3036
  { PseudoVLOXSEG2EI32_V_MF2_MF8, VLOXSEG2EI32_V, 0x5 }, // 3037
  { PseudoVLOXSEG2EI32_V_MF2_MF8_MASK, VLOXSEG2EI32_V, 0x5 }, // 3038
  { PseudoVLOXSEG2EI32_V_MF2_MF8_TU, VLOXSEG2EI32_V, 0x5 }, // 3039
  { PseudoVLOXSEG2EI32_V_M1_MF4, VLOXSEG2EI32_V, 0x6 }, // 3040
  { PseudoVLOXSEG2EI32_V_M1_MF4_MASK, VLOXSEG2EI32_V, 0x6 }, // 3041
  { PseudoVLOXSEG2EI32_V_M1_MF4_TU, VLOXSEG2EI32_V, 0x6 }, // 3042
  { PseudoVLOXSEG2EI32_V_MF2_MF4, VLOXSEG2EI32_V, 0x6 }, // 3043
  { PseudoVLOXSEG2EI32_V_MF2_MF4_MASK, VLOXSEG2EI32_V, 0x6 }, // 3044
  { PseudoVLOXSEG2EI32_V_MF2_MF4_TU, VLOXSEG2EI32_V, 0x6 }, // 3045
  { PseudoVLOXSEG2EI32_V_M1_MF2, VLOXSEG2EI32_V, 0x7 }, // 3046
  { PseudoVLOXSEG2EI32_V_M1_MF2_MASK, VLOXSEG2EI32_V, 0x7 }, // 3047
  { PseudoVLOXSEG2EI32_V_M1_MF2_TU, VLOXSEG2EI32_V, 0x7 }, // 3048
  { PseudoVLOXSEG2EI32_V_M2_MF2, VLOXSEG2EI32_V, 0x7 }, // 3049
  { PseudoVLOXSEG2EI32_V_M2_MF2_MASK, VLOXSEG2EI32_V, 0x7 }, // 3050
  { PseudoVLOXSEG2EI32_V_M2_MF2_TU, VLOXSEG2EI32_V, 0x7 }, // 3051
  { PseudoVLOXSEG2EI32_V_MF2_MF2, VLOXSEG2EI32_V, 0x7 }, // 3052
  { PseudoVLOXSEG2EI32_V_MF2_MF2_MASK, VLOXSEG2EI32_V, 0x7 }, // 3053
  { PseudoVLOXSEG2EI32_V_MF2_MF2_TU, VLOXSEG2EI32_V, 0x7 }, // 3054
  { PseudoVLOXSEG2EI64_V_M1_M1, VLOXSEG2EI64_V, 0x0 }, // 3055
  { PseudoVLOXSEG2EI64_V_M1_M1_MASK, VLOXSEG2EI64_V, 0x0 }, // 3056
  { PseudoVLOXSEG2EI64_V_M1_M1_TU, VLOXSEG2EI64_V, 0x0 }, // 3057
  { PseudoVLOXSEG2EI64_V_M2_M1, VLOXSEG2EI64_V, 0x0 }, // 3058
  { PseudoVLOXSEG2EI64_V_M2_M1_MASK, VLOXSEG2EI64_V, 0x0 }, // 3059
  { PseudoVLOXSEG2EI64_V_M2_M1_TU, VLOXSEG2EI64_V, 0x0 }, // 3060
  { PseudoVLOXSEG2EI64_V_M4_M1, VLOXSEG2EI64_V, 0x0 }, // 3061
  { PseudoVLOXSEG2EI64_V_M4_M1_MASK, VLOXSEG2EI64_V, 0x0 }, // 3062
  { PseudoVLOXSEG2EI64_V_M4_M1_TU, VLOXSEG2EI64_V, 0x0 }, // 3063
  { PseudoVLOXSEG2EI64_V_M8_M1, VLOXSEG2EI64_V, 0x0 }, // 3064
  { PseudoVLOXSEG2EI64_V_M8_M1_MASK, VLOXSEG2EI64_V, 0x0 }, // 3065
  { PseudoVLOXSEG2EI64_V_M8_M1_TU, VLOXSEG2EI64_V, 0x0 }, // 3066
  { PseudoVLOXSEG2EI64_V_M2_M2, VLOXSEG2EI64_V, 0x1 }, // 3067
  { PseudoVLOXSEG2EI64_V_M2_M2_MASK, VLOXSEG2EI64_V, 0x1 }, // 3068
  { PseudoVLOXSEG2EI64_V_M2_M2_TU, VLOXSEG2EI64_V, 0x1 }, // 3069
  { PseudoVLOXSEG2EI64_V_M4_M2, VLOXSEG2EI64_V, 0x1 }, // 3070
  { PseudoVLOXSEG2EI64_V_M4_M2_MASK, VLOXSEG2EI64_V, 0x1 }, // 3071
  { PseudoVLOXSEG2EI64_V_M4_M2_TU, VLOXSEG2EI64_V, 0x1 }, // 3072
  { PseudoVLOXSEG2EI64_V_M8_M2, VLOXSEG2EI64_V, 0x1 }, // 3073
  { PseudoVLOXSEG2EI64_V_M8_M2_MASK, VLOXSEG2EI64_V, 0x1 }, // 3074
  { PseudoVLOXSEG2EI64_V_M8_M2_TU, VLOXSEG2EI64_V, 0x1 }, // 3075
  { PseudoVLOXSEG2EI64_V_M4_M4, VLOXSEG2EI64_V, 0x2 }, // 3076
  { PseudoVLOXSEG2EI64_V_M4_M4_MASK, VLOXSEG2EI64_V, 0x2 }, // 3077
  { PseudoVLOXSEG2EI64_V_M4_M4_TU, VLOXSEG2EI64_V, 0x2 }, // 3078
  { PseudoVLOXSEG2EI64_V_M8_M4, VLOXSEG2EI64_V, 0x2 }, // 3079
  { PseudoVLOXSEG2EI64_V_M8_M4_MASK, VLOXSEG2EI64_V, 0x2 }, // 3080
  { PseudoVLOXSEG2EI64_V_M8_M4_TU, VLOXSEG2EI64_V, 0x2 }, // 3081
  { PseudoVLOXSEG2EI64_V_M1_MF8, VLOXSEG2EI64_V, 0x5 }, // 3082
  { PseudoVLOXSEG2EI64_V_M1_MF8_MASK, VLOXSEG2EI64_V, 0x5 }, // 3083
  { PseudoVLOXSEG2EI64_V_M1_MF8_TU, VLOXSEG2EI64_V, 0x5 }, // 3084
  { PseudoVLOXSEG2EI64_V_M1_MF4, VLOXSEG2EI64_V, 0x6 }, // 3085
  { PseudoVLOXSEG2EI64_V_M1_MF4_MASK, VLOXSEG2EI64_V, 0x6 }, // 3086
  { PseudoVLOXSEG2EI64_V_M1_MF4_TU, VLOXSEG2EI64_V, 0x6 }, // 3087
  { PseudoVLOXSEG2EI64_V_M2_MF4, VLOXSEG2EI64_V, 0x6 }, // 3088
  { PseudoVLOXSEG2EI64_V_M2_MF4_MASK, VLOXSEG2EI64_V, 0x6 }, // 3089
  { PseudoVLOXSEG2EI64_V_M2_MF4_TU, VLOXSEG2EI64_V, 0x6 }, // 3090
  { PseudoVLOXSEG2EI64_V_M1_MF2, VLOXSEG2EI64_V, 0x7 }, // 3091
  { PseudoVLOXSEG2EI64_V_M1_MF2_MASK, VLOXSEG2EI64_V, 0x7 }, // 3092
  { PseudoVLOXSEG2EI64_V_M1_MF2_TU, VLOXSEG2EI64_V, 0x7 }, // 3093
  { PseudoVLOXSEG2EI64_V_M2_MF2, VLOXSEG2EI64_V, 0x7 }, // 3094
  { PseudoVLOXSEG2EI64_V_M2_MF2_MASK, VLOXSEG2EI64_V, 0x7 }, // 3095
  { PseudoVLOXSEG2EI64_V_M2_MF2_TU, VLOXSEG2EI64_V, 0x7 }, // 3096
  { PseudoVLOXSEG2EI64_V_M4_MF2, VLOXSEG2EI64_V, 0x7 }, // 3097
  { PseudoVLOXSEG2EI64_V_M4_MF2_MASK, VLOXSEG2EI64_V, 0x7 }, // 3098
  { PseudoVLOXSEG2EI64_V_M4_MF2_TU, VLOXSEG2EI64_V, 0x7 }, // 3099
  { PseudoVLOXSEG2EI8_V_M1_M1, VLOXSEG2EI8_V, 0x0 }, // 3100
  { PseudoVLOXSEG2EI8_V_M1_M1_MASK, VLOXSEG2EI8_V, 0x0 }, // 3101
  { PseudoVLOXSEG2EI8_V_M1_M1_TU, VLOXSEG2EI8_V, 0x0 }, // 3102
  { PseudoVLOXSEG2EI8_V_MF2_M1, VLOXSEG2EI8_V, 0x0 }, // 3103
  { PseudoVLOXSEG2EI8_V_MF2_M1_MASK, VLOXSEG2EI8_V, 0x0 }, // 3104
  { PseudoVLOXSEG2EI8_V_MF2_M1_TU, VLOXSEG2EI8_V, 0x0 }, // 3105
  { PseudoVLOXSEG2EI8_V_MF4_M1, VLOXSEG2EI8_V, 0x0 }, // 3106
  { PseudoVLOXSEG2EI8_V_MF4_M1_MASK, VLOXSEG2EI8_V, 0x0 }, // 3107
  { PseudoVLOXSEG2EI8_V_MF4_M1_TU, VLOXSEG2EI8_V, 0x0 }, // 3108
  { PseudoVLOXSEG2EI8_V_MF8_M1, VLOXSEG2EI8_V, 0x0 }, // 3109
  { PseudoVLOXSEG2EI8_V_MF8_M1_MASK, VLOXSEG2EI8_V, 0x0 }, // 3110
  { PseudoVLOXSEG2EI8_V_MF8_M1_TU, VLOXSEG2EI8_V, 0x0 }, // 3111
  { PseudoVLOXSEG2EI8_V_M1_M2, VLOXSEG2EI8_V, 0x1 }, // 3112
  { PseudoVLOXSEG2EI8_V_M1_M2_MASK, VLOXSEG2EI8_V, 0x1 }, // 3113
  { PseudoVLOXSEG2EI8_V_M1_M2_TU, VLOXSEG2EI8_V, 0x1 }, // 3114
  { PseudoVLOXSEG2EI8_V_M2_M2, VLOXSEG2EI8_V, 0x1 }, // 3115
  { PseudoVLOXSEG2EI8_V_M2_M2_MASK, VLOXSEG2EI8_V, 0x1 }, // 3116
  { PseudoVLOXSEG2EI8_V_M2_M2_TU, VLOXSEG2EI8_V, 0x1 }, // 3117
  { PseudoVLOXSEG2EI8_V_MF2_M2, VLOXSEG2EI8_V, 0x1 }, // 3118
  { PseudoVLOXSEG2EI8_V_MF2_M2_MASK, VLOXSEG2EI8_V, 0x1 }, // 3119
  { PseudoVLOXSEG2EI8_V_MF2_M2_TU, VLOXSEG2EI8_V, 0x1 }, // 3120
  { PseudoVLOXSEG2EI8_V_MF4_M2, VLOXSEG2EI8_V, 0x1 }, // 3121
  { PseudoVLOXSEG2EI8_V_MF4_M2_MASK, VLOXSEG2EI8_V, 0x1 }, // 3122
  { PseudoVLOXSEG2EI8_V_MF4_M2_TU, VLOXSEG2EI8_V, 0x1 }, // 3123
  { PseudoVLOXSEG2EI8_V_M1_M4, VLOXSEG2EI8_V, 0x2 }, // 3124
  { PseudoVLOXSEG2EI8_V_M1_M4_MASK, VLOXSEG2EI8_V, 0x2 }, // 3125
  { PseudoVLOXSEG2EI8_V_M1_M4_TU, VLOXSEG2EI8_V, 0x2 }, // 3126
  { PseudoVLOXSEG2EI8_V_M2_M4, VLOXSEG2EI8_V, 0x2 }, // 3127
  { PseudoVLOXSEG2EI8_V_M2_M4_MASK, VLOXSEG2EI8_V, 0x2 }, // 3128
  { PseudoVLOXSEG2EI8_V_M2_M4_TU, VLOXSEG2EI8_V, 0x2 }, // 3129
  { PseudoVLOXSEG2EI8_V_M4_M4, VLOXSEG2EI8_V, 0x2 }, // 3130
  { PseudoVLOXSEG2EI8_V_M4_M4_MASK, VLOXSEG2EI8_V, 0x2 }, // 3131
  { PseudoVLOXSEG2EI8_V_M4_M4_TU, VLOXSEG2EI8_V, 0x2 }, // 3132
  { PseudoVLOXSEG2EI8_V_MF2_M4, VLOXSEG2EI8_V, 0x2 }, // 3133
  { PseudoVLOXSEG2EI8_V_MF2_M4_MASK, VLOXSEG2EI8_V, 0x2 }, // 3134
  { PseudoVLOXSEG2EI8_V_MF2_M4_TU, VLOXSEG2EI8_V, 0x2 }, // 3135
  { PseudoVLOXSEG2EI8_V_MF8_MF8, VLOXSEG2EI8_V, 0x5 }, // 3136
  { PseudoVLOXSEG2EI8_V_MF8_MF8_MASK, VLOXSEG2EI8_V, 0x5 }, // 3137
  { PseudoVLOXSEG2EI8_V_MF8_MF8_TU, VLOXSEG2EI8_V, 0x5 }, // 3138
  { PseudoVLOXSEG2EI8_V_MF4_MF4, VLOXSEG2EI8_V, 0x6 }, // 3139
  { PseudoVLOXSEG2EI8_V_MF4_MF4_MASK, VLOXSEG2EI8_V, 0x6 }, // 3140
  { PseudoVLOXSEG2EI8_V_MF4_MF4_TU, VLOXSEG2EI8_V, 0x6 }, // 3141
  { PseudoVLOXSEG2EI8_V_MF8_MF4, VLOXSEG2EI8_V, 0x6 }, // 3142
  { PseudoVLOXSEG2EI8_V_MF8_MF4_MASK, VLOXSEG2EI8_V, 0x6 }, // 3143
  { PseudoVLOXSEG2EI8_V_MF8_MF4_TU, VLOXSEG2EI8_V, 0x6 }, // 3144
  { PseudoVLOXSEG2EI8_V_MF2_MF2, VLOXSEG2EI8_V, 0x7 }, // 3145
  { PseudoVLOXSEG2EI8_V_MF2_MF2_MASK, VLOXSEG2EI8_V, 0x7 }, // 3146
  { PseudoVLOXSEG2EI8_V_MF2_MF2_TU, VLOXSEG2EI8_V, 0x7 }, // 3147
  { PseudoVLOXSEG2EI8_V_MF4_MF2, VLOXSEG2EI8_V, 0x7 }, // 3148
  { PseudoVLOXSEG2EI8_V_MF4_MF2_MASK, VLOXSEG2EI8_V, 0x7 }, // 3149
  { PseudoVLOXSEG2EI8_V_MF4_MF2_TU, VLOXSEG2EI8_V, 0x7 }, // 3150
  { PseudoVLOXSEG2EI8_V_MF8_MF2, VLOXSEG2EI8_V, 0x7 }, // 3151
  { PseudoVLOXSEG2EI8_V_MF8_MF2_MASK, VLOXSEG2EI8_V, 0x7 }, // 3152
  { PseudoVLOXSEG2EI8_V_MF8_MF2_TU, VLOXSEG2EI8_V, 0x7 }, // 3153
  { PseudoVLOXSEG3EI16_V_M1_M1, VLOXSEG3EI16_V, 0x0 }, // 3154
  { PseudoVLOXSEG3EI16_V_M1_M1_MASK, VLOXSEG3EI16_V, 0x0 }, // 3155
  { PseudoVLOXSEG3EI16_V_M1_M1_TU, VLOXSEG3EI16_V, 0x0 }, // 3156
  { PseudoVLOXSEG3EI16_V_M2_M1, VLOXSEG3EI16_V, 0x0 }, // 3157
  { PseudoVLOXSEG3EI16_V_M2_M1_MASK, VLOXSEG3EI16_V, 0x0 }, // 3158
  { PseudoVLOXSEG3EI16_V_M2_M1_TU, VLOXSEG3EI16_V, 0x0 }, // 3159
  { PseudoVLOXSEG3EI16_V_MF2_M1, VLOXSEG3EI16_V, 0x0 }, // 3160
  { PseudoVLOXSEG3EI16_V_MF2_M1_MASK, VLOXSEG3EI16_V, 0x0 }, // 3161
  { PseudoVLOXSEG3EI16_V_MF2_M1_TU, VLOXSEG3EI16_V, 0x0 }, // 3162
  { PseudoVLOXSEG3EI16_V_MF4_M1, VLOXSEG3EI16_V, 0x0 }, // 3163
  { PseudoVLOXSEG3EI16_V_MF4_M1_MASK, VLOXSEG3EI16_V, 0x0 }, // 3164
  { PseudoVLOXSEG3EI16_V_MF4_M1_TU, VLOXSEG3EI16_V, 0x0 }, // 3165
  { PseudoVLOXSEG3EI16_V_M1_M2, VLOXSEG3EI16_V, 0x1 }, // 3166
  { PseudoVLOXSEG3EI16_V_M1_M2_MASK, VLOXSEG3EI16_V, 0x1 }, // 3167
  { PseudoVLOXSEG3EI16_V_M1_M2_TU, VLOXSEG3EI16_V, 0x1 }, // 3168
  { PseudoVLOXSEG3EI16_V_M2_M2, VLOXSEG3EI16_V, 0x1 }, // 3169
  { PseudoVLOXSEG3EI16_V_M2_M2_MASK, VLOXSEG3EI16_V, 0x1 }, // 3170
  { PseudoVLOXSEG3EI16_V_M2_M2_TU, VLOXSEG3EI16_V, 0x1 }, // 3171
  { PseudoVLOXSEG3EI16_V_M4_M2, VLOXSEG3EI16_V, 0x1 }, // 3172
  { PseudoVLOXSEG3EI16_V_M4_M2_MASK, VLOXSEG3EI16_V, 0x1 }, // 3173
  { PseudoVLOXSEG3EI16_V_M4_M2_TU, VLOXSEG3EI16_V, 0x1 }, // 3174
  { PseudoVLOXSEG3EI16_V_MF2_M2, VLOXSEG3EI16_V, 0x1 }, // 3175
  { PseudoVLOXSEG3EI16_V_MF2_M2_MASK, VLOXSEG3EI16_V, 0x1 }, // 3176
  { PseudoVLOXSEG3EI16_V_MF2_M2_TU, VLOXSEG3EI16_V, 0x1 }, // 3177
  { PseudoVLOXSEG3EI16_V_MF4_MF8, VLOXSEG3EI16_V, 0x5 }, // 3178
  { PseudoVLOXSEG3EI16_V_MF4_MF8_MASK, VLOXSEG3EI16_V, 0x5 }, // 3179
  { PseudoVLOXSEG3EI16_V_MF4_MF8_TU, VLOXSEG3EI16_V, 0x5 }, // 3180
  { PseudoVLOXSEG3EI16_V_MF2_MF4, VLOXSEG3EI16_V, 0x6 }, // 3181
  { PseudoVLOXSEG3EI16_V_MF2_MF4_MASK, VLOXSEG3EI16_V, 0x6 }, // 3182
  { PseudoVLOXSEG3EI16_V_MF2_MF4_TU, VLOXSEG3EI16_V, 0x6 }, // 3183
  { PseudoVLOXSEG3EI16_V_MF4_MF4, VLOXSEG3EI16_V, 0x6 }, // 3184
  { PseudoVLOXSEG3EI16_V_MF4_MF4_MASK, VLOXSEG3EI16_V, 0x6 }, // 3185
  { PseudoVLOXSEG3EI16_V_MF4_MF4_TU, VLOXSEG3EI16_V, 0x6 }, // 3186
  { PseudoVLOXSEG3EI16_V_M1_MF2, VLOXSEG3EI16_V, 0x7 }, // 3187
  { PseudoVLOXSEG3EI16_V_M1_MF2_MASK, VLOXSEG3EI16_V, 0x7 }, // 3188
  { PseudoVLOXSEG3EI16_V_M1_MF2_TU, VLOXSEG3EI16_V, 0x7 }, // 3189
  { PseudoVLOXSEG3EI16_V_MF2_MF2, VLOXSEG3EI16_V, 0x7 }, // 3190
  { PseudoVLOXSEG3EI16_V_MF2_MF2_MASK, VLOXSEG3EI16_V, 0x7 }, // 3191
  { PseudoVLOXSEG3EI16_V_MF2_MF2_TU, VLOXSEG3EI16_V, 0x7 }, // 3192
  { PseudoVLOXSEG3EI16_V_MF4_MF2, VLOXSEG3EI16_V, 0x7 }, // 3193
  { PseudoVLOXSEG3EI16_V_MF4_MF2_MASK, VLOXSEG3EI16_V, 0x7 }, // 3194
  { PseudoVLOXSEG3EI16_V_MF4_MF2_TU, VLOXSEG3EI16_V, 0x7 }, // 3195
  { PseudoVLOXSEG3EI32_V_M1_M1, VLOXSEG3EI32_V, 0x0 }, // 3196
  { PseudoVLOXSEG3EI32_V_M1_M1_MASK, VLOXSEG3EI32_V, 0x0 }, // 3197
  { PseudoVLOXSEG3EI32_V_M1_M1_TU, VLOXSEG3EI32_V, 0x0 }, // 3198
  { PseudoVLOXSEG3EI32_V_M2_M1, VLOXSEG3EI32_V, 0x0 }, // 3199
  { PseudoVLOXSEG3EI32_V_M2_M1_MASK, VLOXSEG3EI32_V, 0x0 }, // 3200
  { PseudoVLOXSEG3EI32_V_M2_M1_TU, VLOXSEG3EI32_V, 0x0 }, // 3201
  { PseudoVLOXSEG3EI32_V_M4_M1, VLOXSEG3EI32_V, 0x0 }, // 3202
  { PseudoVLOXSEG3EI32_V_M4_M1_MASK, VLOXSEG3EI32_V, 0x0 }, // 3203
  { PseudoVLOXSEG3EI32_V_M4_M1_TU, VLOXSEG3EI32_V, 0x0 }, // 3204
  { PseudoVLOXSEG3EI32_V_MF2_M1, VLOXSEG3EI32_V, 0x0 }, // 3205
  { PseudoVLOXSEG3EI32_V_MF2_M1_MASK, VLOXSEG3EI32_V, 0x0 }, // 3206
  { PseudoVLOXSEG3EI32_V_MF2_M1_TU, VLOXSEG3EI32_V, 0x0 }, // 3207
  { PseudoVLOXSEG3EI32_V_M1_M2, VLOXSEG3EI32_V, 0x1 }, // 3208
  { PseudoVLOXSEG3EI32_V_M1_M2_MASK, VLOXSEG3EI32_V, 0x1 }, // 3209
  { PseudoVLOXSEG3EI32_V_M1_M2_TU, VLOXSEG3EI32_V, 0x1 }, // 3210
  { PseudoVLOXSEG3EI32_V_M2_M2, VLOXSEG3EI32_V, 0x1 }, // 3211
  { PseudoVLOXSEG3EI32_V_M2_M2_MASK, VLOXSEG3EI32_V, 0x1 }, // 3212
  { PseudoVLOXSEG3EI32_V_M2_M2_TU, VLOXSEG3EI32_V, 0x1 }, // 3213
  { PseudoVLOXSEG3EI32_V_M4_M2, VLOXSEG3EI32_V, 0x1 }, // 3214
  { PseudoVLOXSEG3EI32_V_M4_M2_MASK, VLOXSEG3EI32_V, 0x1 }, // 3215
  { PseudoVLOXSEG3EI32_V_M4_M2_TU, VLOXSEG3EI32_V, 0x1 }, // 3216
  { PseudoVLOXSEG3EI32_V_M8_M2, VLOXSEG3EI32_V, 0x1 }, // 3217
  { PseudoVLOXSEG3EI32_V_M8_M2_MASK, VLOXSEG3EI32_V, 0x1 }, // 3218
  { PseudoVLOXSEG3EI32_V_M8_M2_TU, VLOXSEG3EI32_V, 0x1 }, // 3219
  { PseudoVLOXSEG3EI32_V_MF2_MF8, VLOXSEG3EI32_V, 0x5 }, // 3220
  { PseudoVLOXSEG3EI32_V_MF2_MF8_MASK, VLOXSEG3EI32_V, 0x5 }, // 3221
  { PseudoVLOXSEG3EI32_V_MF2_MF8_TU, VLOXSEG3EI32_V, 0x5 }, // 3222
  { PseudoVLOXSEG3EI32_V_M1_MF4, VLOXSEG3EI32_V, 0x6 }, // 3223
  { PseudoVLOXSEG3EI32_V_M1_MF4_MASK, VLOXSEG3EI32_V, 0x6 }, // 3224
  { PseudoVLOXSEG3EI32_V_M1_MF4_TU, VLOXSEG3EI32_V, 0x6 }, // 3225
  { PseudoVLOXSEG3EI32_V_MF2_MF4, VLOXSEG3EI32_V, 0x6 }, // 3226
  { PseudoVLOXSEG3EI32_V_MF2_MF4_MASK, VLOXSEG3EI32_V, 0x6 }, // 3227
  { PseudoVLOXSEG3EI32_V_MF2_MF4_TU, VLOXSEG3EI32_V, 0x6 }, // 3228
  { PseudoVLOXSEG3EI32_V_M1_MF2, VLOXSEG3EI32_V, 0x7 }, // 3229
  { PseudoVLOXSEG3EI32_V_M1_MF2_MASK, VLOXSEG3EI32_V, 0x7 }, // 3230
  { PseudoVLOXSEG3EI32_V_M1_MF2_TU, VLOXSEG3EI32_V, 0x7 }, // 3231
  { PseudoVLOXSEG3EI32_V_M2_MF2, VLOXSEG3EI32_V, 0x7 }, // 3232
  { PseudoVLOXSEG3EI32_V_M2_MF2_MASK, VLOXSEG3EI32_V, 0x7 }, // 3233
  { PseudoVLOXSEG3EI32_V_M2_MF2_TU, VLOXSEG3EI32_V, 0x7 }, // 3234
  { PseudoVLOXSEG3EI32_V_MF2_MF2, VLOXSEG3EI32_V, 0x7 }, // 3235
  { PseudoVLOXSEG3EI32_V_MF2_MF2_MASK, VLOXSEG3EI32_V, 0x7 }, // 3236
  { PseudoVLOXSEG3EI32_V_MF2_MF2_TU, VLOXSEG3EI32_V, 0x7 }, // 3237
  { PseudoVLOXSEG3EI64_V_M1_M1, VLOXSEG3EI64_V, 0x0 }, // 3238
  { PseudoVLOXSEG3EI64_V_M1_M1_MASK, VLOXSEG3EI64_V, 0x0 }, // 3239
  { PseudoVLOXSEG3EI64_V_M1_M1_TU, VLOXSEG3EI64_V, 0x0 }, // 3240
  { PseudoVLOXSEG3EI64_V_M2_M1, VLOXSEG3EI64_V, 0x0 }, // 3241
  { PseudoVLOXSEG3EI64_V_M2_M1_MASK, VLOXSEG3EI64_V, 0x0 }, // 3242
  { PseudoVLOXSEG3EI64_V_M2_M1_TU, VLOXSEG3EI64_V, 0x0 }, // 3243
  { PseudoVLOXSEG3EI64_V_M4_M1, VLOXSEG3EI64_V, 0x0 }, // 3244
  { PseudoVLOXSEG3EI64_V_M4_M1_MASK, VLOXSEG3EI64_V, 0x0 }, // 3245
  { PseudoVLOXSEG3EI64_V_M4_M1_TU, VLOXSEG3EI64_V, 0x0 }, // 3246
  { PseudoVLOXSEG3EI64_V_M8_M1, VLOXSEG3EI64_V, 0x0 }, // 3247
  { PseudoVLOXSEG3EI64_V_M8_M1_MASK, VLOXSEG3EI64_V, 0x0 }, // 3248
  { PseudoVLOXSEG3EI64_V_M8_M1_TU, VLOXSEG3EI64_V, 0x0 }, // 3249
  { PseudoVLOXSEG3EI64_V_M2_M2, VLOXSEG3EI64_V, 0x1 }, // 3250
  { PseudoVLOXSEG3EI64_V_M2_M2_MASK, VLOXSEG3EI64_V, 0x1 }, // 3251
  { PseudoVLOXSEG3EI64_V_M2_M2_TU, VLOXSEG3EI64_V, 0x1 }, // 3252
  { PseudoVLOXSEG3EI64_V_M4_M2, VLOXSEG3EI64_V, 0x1 }, // 3253
  { PseudoVLOXSEG3EI64_V_M4_M2_MASK, VLOXSEG3EI64_V, 0x1 }, // 3254
  { PseudoVLOXSEG3EI64_V_M4_M2_TU, VLOXSEG3EI64_V, 0x1 }, // 3255
  { PseudoVLOXSEG3EI64_V_M8_M2, VLOXSEG3EI64_V, 0x1 }, // 3256
  { PseudoVLOXSEG3EI64_V_M8_M2_MASK, VLOXSEG3EI64_V, 0x1 }, // 3257
  { PseudoVLOXSEG3EI64_V_M8_M2_TU, VLOXSEG3EI64_V, 0x1 }, // 3258
  { PseudoVLOXSEG3EI64_V_M1_MF8, VLOXSEG3EI64_V, 0x5 }, // 3259
  { PseudoVLOXSEG3EI64_V_M1_MF8_MASK, VLOXSEG3EI64_V, 0x5 }, // 3260
  { PseudoVLOXSEG3EI64_V_M1_MF8_TU, VLOXSEG3EI64_V, 0x5 }, // 3261
  { PseudoVLOXSEG3EI64_V_M1_MF4, VLOXSEG3EI64_V, 0x6 }, // 3262
  { PseudoVLOXSEG3EI64_V_M1_MF4_MASK, VLOXSEG3EI64_V, 0x6 }, // 3263
  { PseudoVLOXSEG3EI64_V_M1_MF4_TU, VLOXSEG3EI64_V, 0x6 }, // 3264
  { PseudoVLOXSEG3EI64_V_M2_MF4, VLOXSEG3EI64_V, 0x6 }, // 3265
  { PseudoVLOXSEG3EI64_V_M2_MF4_MASK, VLOXSEG3EI64_V, 0x6 }, // 3266
  { PseudoVLOXSEG3EI64_V_M2_MF4_TU, VLOXSEG3EI64_V, 0x6 }, // 3267
  { PseudoVLOXSEG3EI64_V_M1_MF2, VLOXSEG3EI64_V, 0x7 }, // 3268
  { PseudoVLOXSEG3EI64_V_M1_MF2_MASK, VLOXSEG3EI64_V, 0x7 }, // 3269
  { PseudoVLOXSEG3EI64_V_M1_MF2_TU, VLOXSEG3EI64_V, 0x7 }, // 3270
  { PseudoVLOXSEG3EI64_V_M2_MF2, VLOXSEG3EI64_V, 0x7 }, // 3271
  { PseudoVLOXSEG3EI64_V_M2_MF2_MASK, VLOXSEG3EI64_V, 0x7 }, // 3272
  { PseudoVLOXSEG3EI64_V_M2_MF2_TU, VLOXSEG3EI64_V, 0x7 }, // 3273
  { PseudoVLOXSEG3EI64_V_M4_MF2, VLOXSEG3EI64_V, 0x7 }, // 3274
  { PseudoVLOXSEG3EI64_V_M4_MF2_MASK, VLOXSEG3EI64_V, 0x7 }, // 3275
  { PseudoVLOXSEG3EI64_V_M4_MF2_TU, VLOXSEG3EI64_V, 0x7 }, // 3276
  { PseudoVLOXSEG3EI8_V_M1_M1, VLOXSEG3EI8_V, 0x0 }, // 3277
  { PseudoVLOXSEG3EI8_V_M1_M1_MASK, VLOXSEG3EI8_V, 0x0 }, // 3278
  { PseudoVLOXSEG3EI8_V_M1_M1_TU, VLOXSEG3EI8_V, 0x0 }, // 3279
  { PseudoVLOXSEG3EI8_V_MF2_M1, VLOXSEG3EI8_V, 0x0 }, // 3280
  { PseudoVLOXSEG3EI8_V_MF2_M1_MASK, VLOXSEG3EI8_V, 0x0 }, // 3281
  { PseudoVLOXSEG3EI8_V_MF2_M1_TU, VLOXSEG3EI8_V, 0x0 }, // 3282
  { PseudoVLOXSEG3EI8_V_MF4_M1, VLOXSEG3EI8_V, 0x0 }, // 3283
  { PseudoVLOXSEG3EI8_V_MF4_M1_MASK, VLOXSEG3EI8_V, 0x0 }, // 3284
  { PseudoVLOXSEG3EI8_V_MF4_M1_TU, VLOXSEG3EI8_V, 0x0 }, // 3285
  { PseudoVLOXSEG3EI8_V_MF8_M1, VLOXSEG3EI8_V, 0x0 }, // 3286
  { PseudoVLOXSEG3EI8_V_MF8_M1_MASK, VLOXSEG3EI8_V, 0x0 }, // 3287
  { PseudoVLOXSEG3EI8_V_MF8_M1_TU, VLOXSEG3EI8_V, 0x0 }, // 3288
  { PseudoVLOXSEG3EI8_V_M1_M2, VLOXSEG3EI8_V, 0x1 }, // 3289
  { PseudoVLOXSEG3EI8_V_M1_M2_MASK, VLOXSEG3EI8_V, 0x1 }, // 3290
  { PseudoVLOXSEG3EI8_V_M1_M2_TU, VLOXSEG3EI8_V, 0x1 }, // 3291
  { PseudoVLOXSEG3EI8_V_M2_M2, VLOXSEG3EI8_V, 0x1 }, // 3292
  { PseudoVLOXSEG3EI8_V_M2_M2_MASK, VLOXSEG3EI8_V, 0x1 }, // 3293
  { PseudoVLOXSEG3EI8_V_M2_M2_TU, VLOXSEG3EI8_V, 0x1 }, // 3294
  { PseudoVLOXSEG3EI8_V_MF2_M2, VLOXSEG3EI8_V, 0x1 }, // 3295
  { PseudoVLOXSEG3EI8_V_MF2_M2_MASK, VLOXSEG3EI8_V, 0x1 }, // 3296
  { PseudoVLOXSEG3EI8_V_MF2_M2_TU, VLOXSEG3EI8_V, 0x1 }, // 3297
  { PseudoVLOXSEG3EI8_V_MF4_M2, VLOXSEG3EI8_V, 0x1 }, // 3298
  { PseudoVLOXSEG3EI8_V_MF4_M2_MASK, VLOXSEG3EI8_V, 0x1 }, // 3299
  { PseudoVLOXSEG3EI8_V_MF4_M2_TU, VLOXSEG3EI8_V, 0x1 }, // 3300
  { PseudoVLOXSEG3EI8_V_MF8_MF8, VLOXSEG3EI8_V, 0x5 }, // 3301
  { PseudoVLOXSEG3EI8_V_MF8_MF8_MASK, VLOXSEG3EI8_V, 0x5 }, // 3302
  { PseudoVLOXSEG3EI8_V_MF8_MF8_TU, VLOXSEG3EI8_V, 0x5 }, // 3303
  { PseudoVLOXSEG3EI8_V_MF4_MF4, VLOXSEG3EI8_V, 0x6 }, // 3304
  { PseudoVLOXSEG3EI8_V_MF4_MF4_MASK, VLOXSEG3EI8_V, 0x6 }, // 3305
  { PseudoVLOXSEG3EI8_V_MF4_MF4_TU, VLOXSEG3EI8_V, 0x6 }, // 3306
  { PseudoVLOXSEG3EI8_V_MF8_MF4, VLOXSEG3EI8_V, 0x6 }, // 3307
  { PseudoVLOXSEG3EI8_V_MF8_MF4_MASK, VLOXSEG3EI8_V, 0x6 }, // 3308
  { PseudoVLOXSEG3EI8_V_MF8_MF4_TU, VLOXSEG3EI8_V, 0x6 }, // 3309
  { PseudoVLOXSEG3EI8_V_MF2_MF2, VLOXSEG3EI8_V, 0x7 }, // 3310
  { PseudoVLOXSEG3EI8_V_MF2_MF2_MASK, VLOXSEG3EI8_V, 0x7 }, // 3311
  { PseudoVLOXSEG3EI8_V_MF2_MF2_TU, VLOXSEG3EI8_V, 0x7 }, // 3312
  { PseudoVLOXSEG3EI8_V_MF4_MF2, VLOXSEG3EI8_V, 0x7 }, // 3313
  { PseudoVLOXSEG3EI8_V_MF4_MF2_MASK, VLOXSEG3EI8_V, 0x7 }, // 3314
  { PseudoVLOXSEG3EI8_V_MF4_MF2_TU, VLOXSEG3EI8_V, 0x7 }, // 3315
  { PseudoVLOXSEG3EI8_V_MF8_MF2, VLOXSEG3EI8_V, 0x7 }, // 3316
  { PseudoVLOXSEG3EI8_V_MF8_MF2_MASK, VLOXSEG3EI8_V, 0x7 }, // 3317
  { PseudoVLOXSEG3EI8_V_MF8_MF2_TU, VLOXSEG3EI8_V, 0x7 }, // 3318
  { PseudoVLOXSEG4EI16_V_M1_M1, VLOXSEG4EI16_V, 0x0 }, // 3319
  { PseudoVLOXSEG4EI16_V_M1_M1_MASK, VLOXSEG4EI16_V, 0x0 }, // 3320
  { PseudoVLOXSEG4EI16_V_M1_M1_TU, VLOXSEG4EI16_V, 0x0 }, // 3321
  { PseudoVLOXSEG4EI16_V_M2_M1, VLOXSEG4EI16_V, 0x0 }, // 3322
  { PseudoVLOXSEG4EI16_V_M2_M1_MASK, VLOXSEG4EI16_V, 0x0 }, // 3323
  { PseudoVLOXSEG4EI16_V_M2_M1_TU, VLOXSEG4EI16_V, 0x0 }, // 3324
  { PseudoVLOXSEG4EI16_V_MF2_M1, VLOXSEG4EI16_V, 0x0 }, // 3325
  { PseudoVLOXSEG4EI16_V_MF2_M1_MASK, VLOXSEG4EI16_V, 0x0 }, // 3326
  { PseudoVLOXSEG4EI16_V_MF2_M1_TU, VLOXSEG4EI16_V, 0x0 }, // 3327
  { PseudoVLOXSEG4EI16_V_MF4_M1, VLOXSEG4EI16_V, 0x0 }, // 3328
  { PseudoVLOXSEG4EI16_V_MF4_M1_MASK, VLOXSEG4EI16_V, 0x0 }, // 3329
  { PseudoVLOXSEG4EI16_V_MF4_M1_TU, VLOXSEG4EI16_V, 0x0 }, // 3330
  { PseudoVLOXSEG4EI16_V_M1_M2, VLOXSEG4EI16_V, 0x1 }, // 3331
  { PseudoVLOXSEG4EI16_V_M1_M2_MASK, VLOXSEG4EI16_V, 0x1 }, // 3332
  { PseudoVLOXSEG4EI16_V_M1_M2_TU, VLOXSEG4EI16_V, 0x1 }, // 3333
  { PseudoVLOXSEG4EI16_V_M2_M2, VLOXSEG4EI16_V, 0x1 }, // 3334
  { PseudoVLOXSEG4EI16_V_M2_M2_MASK, VLOXSEG4EI16_V, 0x1 }, // 3335
  { PseudoVLOXSEG4EI16_V_M2_M2_TU, VLOXSEG4EI16_V, 0x1 }, // 3336
  { PseudoVLOXSEG4EI16_V_M4_M2, VLOXSEG4EI16_V, 0x1 }, // 3337
  { PseudoVLOXSEG4EI16_V_M4_M2_MASK, VLOXSEG4EI16_V, 0x1 }, // 3338
  { PseudoVLOXSEG4EI16_V_M4_M2_TU, VLOXSEG4EI16_V, 0x1 }, // 3339
  { PseudoVLOXSEG4EI16_V_MF2_M2, VLOXSEG4EI16_V, 0x1 }, // 3340
  { PseudoVLOXSEG4EI16_V_MF2_M2_MASK, VLOXSEG4EI16_V, 0x1 }, // 3341
  { PseudoVLOXSEG4EI16_V_MF2_M2_TU, VLOXSEG4EI16_V, 0x1 }, // 3342
  { PseudoVLOXSEG4EI16_V_MF4_MF8, VLOXSEG4EI16_V, 0x5 }, // 3343
  { PseudoVLOXSEG4EI16_V_MF4_MF8_MASK, VLOXSEG4EI16_V, 0x5 }, // 3344
  { PseudoVLOXSEG4EI16_V_MF4_MF8_TU, VLOXSEG4EI16_V, 0x5 }, // 3345
  { PseudoVLOXSEG4EI16_V_MF2_MF4, VLOXSEG4EI16_V, 0x6 }, // 3346
  { PseudoVLOXSEG4EI16_V_MF2_MF4_MASK, VLOXSEG4EI16_V, 0x6 }, // 3347
  { PseudoVLOXSEG4EI16_V_MF2_MF4_TU, VLOXSEG4EI16_V, 0x6 }, // 3348
  { PseudoVLOXSEG4EI16_V_MF4_MF4, VLOXSEG4EI16_V, 0x6 }, // 3349
  { PseudoVLOXSEG4EI16_V_MF4_MF4_MASK, VLOXSEG4EI16_V, 0x6 }, // 3350
  { PseudoVLOXSEG4EI16_V_MF4_MF4_TU, VLOXSEG4EI16_V, 0x6 }, // 3351
  { PseudoVLOXSEG4EI16_V_M1_MF2, VLOXSEG4EI16_V, 0x7 }, // 3352
  { PseudoVLOXSEG4EI16_V_M1_MF2_MASK, VLOXSEG4EI16_V, 0x7 }, // 3353
  { PseudoVLOXSEG4EI16_V_M1_MF2_TU, VLOXSEG4EI16_V, 0x7 }, // 3354
  { PseudoVLOXSEG4EI16_V_MF2_MF2, VLOXSEG4EI16_V, 0x7 }, // 3355
  { PseudoVLOXSEG4EI16_V_MF2_MF2_MASK, VLOXSEG4EI16_V, 0x7 }, // 3356
  { PseudoVLOXSEG4EI16_V_MF2_MF2_TU, VLOXSEG4EI16_V, 0x7 }, // 3357
  { PseudoVLOXSEG4EI16_V_MF4_MF2, VLOXSEG4EI16_V, 0x7 }, // 3358
  { PseudoVLOXSEG4EI16_V_MF4_MF2_MASK, VLOXSEG4EI16_V, 0x7 }, // 3359
  { PseudoVLOXSEG4EI16_V_MF4_MF2_TU, VLOXSEG4EI16_V, 0x7 }, // 3360
  { PseudoVLOXSEG4EI32_V_M1_M1, VLOXSEG4EI32_V, 0x0 }, // 3361
  { PseudoVLOXSEG4EI32_V_M1_M1_MASK, VLOXSEG4EI32_V, 0x0 }, // 3362
  { PseudoVLOXSEG4EI32_V_M1_M1_TU, VLOXSEG4EI32_V, 0x0 }, // 3363
  { PseudoVLOXSEG4EI32_V_M2_M1, VLOXSEG4EI32_V, 0x0 }, // 3364
  { PseudoVLOXSEG4EI32_V_M2_M1_MASK, VLOXSEG4EI32_V, 0x0 }, // 3365
  { PseudoVLOXSEG4EI32_V_M2_M1_TU, VLOXSEG4EI32_V, 0x0 }, // 3366
  { PseudoVLOXSEG4EI32_V_M4_M1, VLOXSEG4EI32_V, 0x0 }, // 3367
  { PseudoVLOXSEG4EI32_V_M4_M1_MASK, VLOXSEG4EI32_V, 0x0 }, // 3368
  { PseudoVLOXSEG4EI32_V_M4_M1_TU, VLOXSEG4EI32_V, 0x0 }, // 3369
  { PseudoVLOXSEG4EI32_V_MF2_M1, VLOXSEG4EI32_V, 0x0 }, // 3370
  { PseudoVLOXSEG4EI32_V_MF2_M1_MASK, VLOXSEG4EI32_V, 0x0 }, // 3371
  { PseudoVLOXSEG4EI32_V_MF2_M1_TU, VLOXSEG4EI32_V, 0x0 }, // 3372
  { PseudoVLOXSEG4EI32_V_M1_M2, VLOXSEG4EI32_V, 0x1 }, // 3373
  { PseudoVLOXSEG4EI32_V_M1_M2_MASK, VLOXSEG4EI32_V, 0x1 }, // 3374
  { PseudoVLOXSEG4EI32_V_M1_M2_TU, VLOXSEG4EI32_V, 0x1 }, // 3375
  { PseudoVLOXSEG4EI32_V_M2_M2, VLOXSEG4EI32_V, 0x1 }, // 3376
  { PseudoVLOXSEG4EI32_V_M2_M2_MASK, VLOXSEG4EI32_V, 0x1 }, // 3377
  { PseudoVLOXSEG4EI32_V_M2_M2_TU, VLOXSEG4EI32_V, 0x1 }, // 3378
  { PseudoVLOXSEG4EI32_V_M4_M2, VLOXSEG4EI32_V, 0x1 }, // 3379
  { PseudoVLOXSEG4EI32_V_M4_M2_MASK, VLOXSEG4EI32_V, 0x1 }, // 3380
  { PseudoVLOXSEG4EI32_V_M4_M2_TU, VLOXSEG4EI32_V, 0x1 }, // 3381
  { PseudoVLOXSEG4EI32_V_M8_M2, VLOXSEG4EI32_V, 0x1 }, // 3382
  { PseudoVLOXSEG4EI32_V_M8_M2_MASK, VLOXSEG4EI32_V, 0x1 }, // 3383
  { PseudoVLOXSEG4EI32_V_M8_M2_TU, VLOXSEG4EI32_V, 0x1 }, // 3384
  { PseudoVLOXSEG4EI32_V_MF2_MF8, VLOXSEG4EI32_V, 0x5 }, // 3385
  { PseudoVLOXSEG4EI32_V_MF2_MF8_MASK, VLOXSEG4EI32_V, 0x5 }, // 3386
  { PseudoVLOXSEG4EI32_V_MF2_MF8_TU, VLOXSEG4EI32_V, 0x5 }, // 3387
  { PseudoVLOXSEG4EI32_V_M1_MF4, VLOXSEG4EI32_V, 0x6 }, // 3388
  { PseudoVLOXSEG4EI32_V_M1_MF4_MASK, VLOXSEG4EI32_V, 0x6 }, // 3389
  { PseudoVLOXSEG4EI32_V_M1_MF4_TU, VLOXSEG4EI32_V, 0x6 }, // 3390
  { PseudoVLOXSEG4EI32_V_MF2_MF4, VLOXSEG4EI32_V, 0x6 }, // 3391
  { PseudoVLOXSEG4EI32_V_MF2_MF4_MASK, VLOXSEG4EI32_V, 0x6 }, // 3392
  { PseudoVLOXSEG4EI32_V_MF2_MF4_TU, VLOXSEG4EI32_V, 0x6 }, // 3393
  { PseudoVLOXSEG4EI32_V_M1_MF2, VLOXSEG4EI32_V, 0x7 }, // 3394
  { PseudoVLOXSEG4EI32_V_M1_MF2_MASK, VLOXSEG4EI32_V, 0x7 }, // 3395
  { PseudoVLOXSEG4EI32_V_M1_MF2_TU, VLOXSEG4EI32_V, 0x7 }, // 3396
  { PseudoVLOXSEG4EI32_V_M2_MF2, VLOXSEG4EI32_V, 0x7 }, // 3397
  { PseudoVLOXSEG4EI32_V_M2_MF2_MASK, VLOXSEG4EI32_V, 0x7 }, // 3398
  { PseudoVLOXSEG4EI32_V_M2_MF2_TU, VLOXSEG4EI32_V, 0x7 }, // 3399
  { PseudoVLOXSEG4EI32_V_MF2_MF2, VLOXSEG4EI32_V, 0x7 }, // 3400
  { PseudoVLOXSEG4EI32_V_MF2_MF2_MASK, VLOXSEG4EI32_V, 0x7 }, // 3401
  { PseudoVLOXSEG4EI32_V_MF2_MF2_TU, VLOXSEG4EI32_V, 0x7 }, // 3402
  { PseudoVLOXSEG4EI64_V_M1_M1, VLOXSEG4EI64_V, 0x0 }, // 3403
  { PseudoVLOXSEG4EI64_V_M1_M1_MASK, VLOXSEG4EI64_V, 0x0 }, // 3404
  { PseudoVLOXSEG4EI64_V_M1_M1_TU, VLOXSEG4EI64_V, 0x0 }, // 3405
  { PseudoVLOXSEG4EI64_V_M2_M1, VLOXSEG4EI64_V, 0x0 }, // 3406
  { PseudoVLOXSEG4EI64_V_M2_M1_MASK, VLOXSEG4EI64_V, 0x0 }, // 3407
  { PseudoVLOXSEG4EI64_V_M2_M1_TU, VLOXSEG4EI64_V, 0x0 }, // 3408
  { PseudoVLOXSEG4EI64_V_M4_M1, VLOXSEG4EI64_V, 0x0 }, // 3409
  { PseudoVLOXSEG4EI64_V_M4_M1_MASK, VLOXSEG4EI64_V, 0x0 }, // 3410
  { PseudoVLOXSEG4EI64_V_M4_M1_TU, VLOXSEG4EI64_V, 0x0 }, // 3411
  { PseudoVLOXSEG4EI64_V_M8_M1, VLOXSEG4EI64_V, 0x0 }, // 3412
  { PseudoVLOXSEG4EI64_V_M8_M1_MASK, VLOXSEG4EI64_V, 0x0 }, // 3413
  { PseudoVLOXSEG4EI64_V_M8_M1_TU, VLOXSEG4EI64_V, 0x0 }, // 3414
  { PseudoVLOXSEG4EI64_V_M2_M2, VLOXSEG4EI64_V, 0x1 }, // 3415
  { PseudoVLOXSEG4EI64_V_M2_M2_MASK, VLOXSEG4EI64_V, 0x1 }, // 3416
  { PseudoVLOXSEG4EI64_V_M2_M2_TU, VLOXSEG4EI64_V, 0x1 }, // 3417
  { PseudoVLOXSEG4EI64_V_M4_M2, VLOXSEG4EI64_V, 0x1 }, // 3418
  { PseudoVLOXSEG4EI64_V_M4_M2_MASK, VLOXSEG4EI64_V, 0x1 }, // 3419
  { PseudoVLOXSEG4EI64_V_M4_M2_TU, VLOXSEG4EI64_V, 0x1 }, // 3420
  { PseudoVLOXSEG4EI64_V_M8_M2, VLOXSEG4EI64_V, 0x1 }, // 3421
  { PseudoVLOXSEG4EI64_V_M8_M2_MASK, VLOXSEG4EI64_V, 0x1 }, // 3422
  { PseudoVLOXSEG4EI64_V_M8_M2_TU, VLOXSEG4EI64_V, 0x1 }, // 3423
  { PseudoVLOXSEG4EI64_V_M1_MF8, VLOXSEG4EI64_V, 0x5 }, // 3424
  { PseudoVLOXSEG4EI64_V_M1_MF8_MASK, VLOXSEG4EI64_V, 0x5 }, // 3425
  { PseudoVLOXSEG4EI64_V_M1_MF8_TU, VLOXSEG4EI64_V, 0x5 }, // 3426
  { PseudoVLOXSEG4EI64_V_M1_MF4, VLOXSEG4EI64_V, 0x6 }, // 3427
  { PseudoVLOXSEG4EI64_V_M1_MF4_MASK, VLOXSEG4EI64_V, 0x6 }, // 3428
  { PseudoVLOXSEG4EI64_V_M1_MF4_TU, VLOXSEG4EI64_V, 0x6 }, // 3429
  { PseudoVLOXSEG4EI64_V_M2_MF4, VLOXSEG4EI64_V, 0x6 }, // 3430
  { PseudoVLOXSEG4EI64_V_M2_MF4_MASK, VLOXSEG4EI64_V, 0x6 }, // 3431
  { PseudoVLOXSEG4EI64_V_M2_MF4_TU, VLOXSEG4EI64_V, 0x6 }, // 3432
  { PseudoVLOXSEG4EI64_V_M1_MF2, VLOXSEG4EI64_V, 0x7 }, // 3433
  { PseudoVLOXSEG4EI64_V_M1_MF2_MASK, VLOXSEG4EI64_V, 0x7 }, // 3434
  { PseudoVLOXSEG4EI64_V_M1_MF2_TU, VLOXSEG4EI64_V, 0x7 }, // 3435
  { PseudoVLOXSEG4EI64_V_M2_MF2, VLOXSEG4EI64_V, 0x7 }, // 3436
  { PseudoVLOXSEG4EI64_V_M2_MF2_MASK, VLOXSEG4EI64_V, 0x7 }, // 3437
  { PseudoVLOXSEG4EI64_V_M2_MF2_TU, VLOXSEG4EI64_V, 0x7 }, // 3438
  { PseudoVLOXSEG4EI64_V_M4_MF2, VLOXSEG4EI64_V, 0x7 }, // 3439
  { PseudoVLOXSEG4EI64_V_M4_MF2_MASK, VLOXSEG4EI64_V, 0x7 }, // 3440
  { PseudoVLOXSEG4EI64_V_M4_MF2_TU, VLOXSEG4EI64_V, 0x7 }, // 3441
  { PseudoVLOXSEG4EI8_V_M1_M1, VLOXSEG4EI8_V, 0x0 }, // 3442
  { PseudoVLOXSEG4EI8_V_M1_M1_MASK, VLOXSEG4EI8_V, 0x0 }, // 3443
  { PseudoVLOXSEG4EI8_V_M1_M1_TU, VLOXSEG4EI8_V, 0x0 }, // 3444
  { PseudoVLOXSEG4EI8_V_MF2_M1, VLOXSEG4EI8_V, 0x0 }, // 3445
  { PseudoVLOXSEG4EI8_V_MF2_M1_MASK, VLOXSEG4EI8_V, 0x0 }, // 3446
  { PseudoVLOXSEG4EI8_V_MF2_M1_TU, VLOXSEG4EI8_V, 0x0 }, // 3447
  { PseudoVLOXSEG4EI8_V_MF4_M1, VLOXSEG4EI8_V, 0x0 }, // 3448
  { PseudoVLOXSEG4EI8_V_MF4_M1_MASK, VLOXSEG4EI8_V, 0x0 }, // 3449
  { PseudoVLOXSEG4EI8_V_MF4_M1_TU, VLOXSEG4EI8_V, 0x0 }, // 3450
  { PseudoVLOXSEG4EI8_V_MF8_M1, VLOXSEG4EI8_V, 0x0 }, // 3451
  { PseudoVLOXSEG4EI8_V_MF8_M1_MASK, VLOXSEG4EI8_V, 0x0 }, // 3452
  { PseudoVLOXSEG4EI8_V_MF8_M1_TU, VLOXSEG4EI8_V, 0x0 }, // 3453
  { PseudoVLOXSEG4EI8_V_M1_M2, VLOXSEG4EI8_V, 0x1 }, // 3454
  { PseudoVLOXSEG4EI8_V_M1_M2_MASK, VLOXSEG4EI8_V, 0x1 }, // 3455
  { PseudoVLOXSEG4EI8_V_M1_M2_TU, VLOXSEG4EI8_V, 0x1 }, // 3456
  { PseudoVLOXSEG4EI8_V_M2_M2, VLOXSEG4EI8_V, 0x1 }, // 3457
  { PseudoVLOXSEG4EI8_V_M2_M2_MASK, VLOXSEG4EI8_V, 0x1 }, // 3458
  { PseudoVLOXSEG4EI8_V_M2_M2_TU, VLOXSEG4EI8_V, 0x1 }, // 3459
  { PseudoVLOXSEG4EI8_V_MF2_M2, VLOXSEG4EI8_V, 0x1 }, // 3460
  { PseudoVLOXSEG4EI8_V_MF2_M2_MASK, VLOXSEG4EI8_V, 0x1 }, // 3461
  { PseudoVLOXSEG4EI8_V_MF2_M2_TU, VLOXSEG4EI8_V, 0x1 }, // 3462
  { PseudoVLOXSEG4EI8_V_MF4_M2, VLOXSEG4EI8_V, 0x1 }, // 3463
  { PseudoVLOXSEG4EI8_V_MF4_M2_MASK, VLOXSEG4EI8_V, 0x1 }, // 3464
  { PseudoVLOXSEG4EI8_V_MF4_M2_TU, VLOXSEG4EI8_V, 0x1 }, // 3465
  { PseudoVLOXSEG4EI8_V_MF8_MF8, VLOXSEG4EI8_V, 0x5 }, // 3466
  { PseudoVLOXSEG4EI8_V_MF8_MF8_MASK, VLOXSEG4EI8_V, 0x5 }, // 3467
  { PseudoVLOXSEG4EI8_V_MF8_MF8_TU, VLOXSEG4EI8_V, 0x5 }, // 3468
  { PseudoVLOXSEG4EI8_V_MF4_MF4, VLOXSEG4EI8_V, 0x6 }, // 3469
  { PseudoVLOXSEG4EI8_V_MF4_MF4_MASK, VLOXSEG4EI8_V, 0x6 }, // 3470
  { PseudoVLOXSEG4EI8_V_MF4_MF4_TU, VLOXSEG4EI8_V, 0x6 }, // 3471
  { PseudoVLOXSEG4EI8_V_MF8_MF4, VLOXSEG4EI8_V, 0x6 }, // 3472
  { PseudoVLOXSEG4EI8_V_MF8_MF4_MASK, VLOXSEG4EI8_V, 0x6 }, // 3473
  { PseudoVLOXSEG4EI8_V_MF8_MF4_TU, VLOXSEG4EI8_V, 0x6 }, // 3474
  { PseudoVLOXSEG4EI8_V_MF2_MF2, VLOXSEG4EI8_V, 0x7 }, // 3475
  { PseudoVLOXSEG4EI8_V_MF2_MF2_MASK, VLOXSEG4EI8_V, 0x7 }, // 3476
  { PseudoVLOXSEG4EI8_V_MF2_MF2_TU, VLOXSEG4EI8_V, 0x7 }, // 3477
  { PseudoVLOXSEG4EI8_V_MF4_MF2, VLOXSEG4EI8_V, 0x7 }, // 3478
  { PseudoVLOXSEG4EI8_V_MF4_MF2_MASK, VLOXSEG4EI8_V, 0x7 }, // 3479
  { PseudoVLOXSEG4EI8_V_MF4_MF2_TU, VLOXSEG4EI8_V, 0x7 }, // 3480
  { PseudoVLOXSEG4EI8_V_MF8_MF2, VLOXSEG4EI8_V, 0x7 }, // 3481
  { PseudoVLOXSEG4EI8_V_MF8_MF2_MASK, VLOXSEG4EI8_V, 0x7 }, // 3482
  { PseudoVLOXSEG4EI8_V_MF8_MF2_TU, VLOXSEG4EI8_V, 0x7 }, // 3483
  { PseudoVLOXSEG5EI16_V_M1_M1, VLOXSEG5EI16_V, 0x0 }, // 3484
  { PseudoVLOXSEG5EI16_V_M1_M1_MASK, VLOXSEG5EI16_V, 0x0 }, // 3485
  { PseudoVLOXSEG5EI16_V_M1_M1_TU, VLOXSEG5EI16_V, 0x0 }, // 3486
  { PseudoVLOXSEG5EI16_V_M2_M1, VLOXSEG5EI16_V, 0x0 }, // 3487
  { PseudoVLOXSEG5EI16_V_M2_M1_MASK, VLOXSEG5EI16_V, 0x0 }, // 3488
  { PseudoVLOXSEG5EI16_V_M2_M1_TU, VLOXSEG5EI16_V, 0x0 }, // 3489
  { PseudoVLOXSEG5EI16_V_MF2_M1, VLOXSEG5EI16_V, 0x0 }, // 3490
  { PseudoVLOXSEG5EI16_V_MF2_M1_MASK, VLOXSEG5EI16_V, 0x0 }, // 3491
  { PseudoVLOXSEG5EI16_V_MF2_M1_TU, VLOXSEG5EI16_V, 0x0 }, // 3492
  { PseudoVLOXSEG5EI16_V_MF4_M1, VLOXSEG5EI16_V, 0x0 }, // 3493
  { PseudoVLOXSEG5EI16_V_MF4_M1_MASK, VLOXSEG5EI16_V, 0x0 }, // 3494
  { PseudoVLOXSEG5EI16_V_MF4_M1_TU, VLOXSEG5EI16_V, 0x0 }, // 3495
  { PseudoVLOXSEG5EI16_V_MF4_MF8, VLOXSEG5EI16_V, 0x5 }, // 3496
  { PseudoVLOXSEG5EI16_V_MF4_MF8_MASK, VLOXSEG5EI16_V, 0x5 }, // 3497
  { PseudoVLOXSEG5EI16_V_MF4_MF8_TU, VLOXSEG5EI16_V, 0x5 }, // 3498
  { PseudoVLOXSEG5EI16_V_MF2_MF4, VLOXSEG5EI16_V, 0x6 }, // 3499
  { PseudoVLOXSEG5EI16_V_MF2_MF4_MASK, VLOXSEG5EI16_V, 0x6 }, // 3500
  { PseudoVLOXSEG5EI16_V_MF2_MF4_TU, VLOXSEG5EI16_V, 0x6 }, // 3501
  { PseudoVLOXSEG5EI16_V_MF4_MF4, VLOXSEG5EI16_V, 0x6 }, // 3502
  { PseudoVLOXSEG5EI16_V_MF4_MF4_MASK, VLOXSEG5EI16_V, 0x6 }, // 3503
  { PseudoVLOXSEG5EI16_V_MF4_MF4_TU, VLOXSEG5EI16_V, 0x6 }, // 3504
  { PseudoVLOXSEG5EI16_V_M1_MF2, VLOXSEG5EI16_V, 0x7 }, // 3505
  { PseudoVLOXSEG5EI16_V_M1_MF2_MASK, VLOXSEG5EI16_V, 0x7 }, // 3506
  { PseudoVLOXSEG5EI16_V_M1_MF2_TU, VLOXSEG5EI16_V, 0x7 }, // 3507
  { PseudoVLOXSEG5EI16_V_MF2_MF2, VLOXSEG5EI16_V, 0x7 }, // 3508
  { PseudoVLOXSEG5EI16_V_MF2_MF2_MASK, VLOXSEG5EI16_V, 0x7 }, // 3509
  { PseudoVLOXSEG5EI16_V_MF2_MF2_TU, VLOXSEG5EI16_V, 0x7 }, // 3510
  { PseudoVLOXSEG5EI16_V_MF4_MF2, VLOXSEG5EI16_V, 0x7 }, // 3511
  { PseudoVLOXSEG5EI16_V_MF4_MF2_MASK, VLOXSEG5EI16_V, 0x7 }, // 3512
  { PseudoVLOXSEG5EI16_V_MF4_MF2_TU, VLOXSEG5EI16_V, 0x7 }, // 3513
  { PseudoVLOXSEG5EI32_V_M1_M1, VLOXSEG5EI32_V, 0x0 }, // 3514
  { PseudoVLOXSEG5EI32_V_M1_M1_MASK, VLOXSEG5EI32_V, 0x0 }, // 3515
  { PseudoVLOXSEG5EI32_V_M1_M1_TU, VLOXSEG5EI32_V, 0x0 }, // 3516
  { PseudoVLOXSEG5EI32_V_M2_M1, VLOXSEG5EI32_V, 0x0 }, // 3517
  { PseudoVLOXSEG5EI32_V_M2_M1_MASK, VLOXSEG5EI32_V, 0x0 }, // 3518
  { PseudoVLOXSEG5EI32_V_M2_M1_TU, VLOXSEG5EI32_V, 0x0 }, // 3519
  { PseudoVLOXSEG5EI32_V_M4_M1, VLOXSEG5EI32_V, 0x0 }, // 3520
  { PseudoVLOXSEG5EI32_V_M4_M1_MASK, VLOXSEG5EI32_V, 0x0 }, // 3521
  { PseudoVLOXSEG5EI32_V_M4_M1_TU, VLOXSEG5EI32_V, 0x0 }, // 3522
  { PseudoVLOXSEG5EI32_V_MF2_M1, VLOXSEG5EI32_V, 0x0 }, // 3523
  { PseudoVLOXSEG5EI32_V_MF2_M1_MASK, VLOXSEG5EI32_V, 0x0 }, // 3524
  { PseudoVLOXSEG5EI32_V_MF2_M1_TU, VLOXSEG5EI32_V, 0x0 }, // 3525
  { PseudoVLOXSEG5EI32_V_MF2_MF8, VLOXSEG5EI32_V, 0x5 }, // 3526
  { PseudoVLOXSEG5EI32_V_MF2_MF8_MASK, VLOXSEG5EI32_V, 0x5 }, // 3527
  { PseudoVLOXSEG5EI32_V_MF2_MF8_TU, VLOXSEG5EI32_V, 0x5 }, // 3528
  { PseudoVLOXSEG5EI32_V_M1_MF4, VLOXSEG5EI32_V, 0x6 }, // 3529
  { PseudoVLOXSEG5EI32_V_M1_MF4_MASK, VLOXSEG5EI32_V, 0x6 }, // 3530
  { PseudoVLOXSEG5EI32_V_M1_MF4_TU, VLOXSEG5EI32_V, 0x6 }, // 3531
  { PseudoVLOXSEG5EI32_V_MF2_MF4, VLOXSEG5EI32_V, 0x6 }, // 3532
  { PseudoVLOXSEG5EI32_V_MF2_MF4_MASK, VLOXSEG5EI32_V, 0x6 }, // 3533
  { PseudoVLOXSEG5EI32_V_MF2_MF4_TU, VLOXSEG5EI32_V, 0x6 }, // 3534
  { PseudoVLOXSEG5EI32_V_M1_MF2, VLOXSEG5EI32_V, 0x7 }, // 3535
  { PseudoVLOXSEG5EI32_V_M1_MF2_MASK, VLOXSEG5EI32_V, 0x7 }, // 3536
  { PseudoVLOXSEG5EI32_V_M1_MF2_TU, VLOXSEG5EI32_V, 0x7 }, // 3537
  { PseudoVLOXSEG5EI32_V_M2_MF2, VLOXSEG5EI32_V, 0x7 }, // 3538
  { PseudoVLOXSEG5EI32_V_M2_MF2_MASK, VLOXSEG5EI32_V, 0x7 }, // 3539
  { PseudoVLOXSEG5EI32_V_M2_MF2_TU, VLOXSEG5EI32_V, 0x7 }, // 3540
  { PseudoVLOXSEG5EI32_V_MF2_MF2, VLOXSEG5EI32_V, 0x7 }, // 3541
  { PseudoVLOXSEG5EI32_V_MF2_MF2_MASK, VLOXSEG5EI32_V, 0x7 }, // 3542
  { PseudoVLOXSEG5EI32_V_MF2_MF2_TU, VLOXSEG5EI32_V, 0x7 }, // 3543
  { PseudoVLOXSEG5EI64_V_M1_M1, VLOXSEG5EI64_V, 0x0 }, // 3544
  { PseudoVLOXSEG5EI64_V_M1_M1_MASK, VLOXSEG5EI64_V, 0x0 }, // 3545
  { PseudoVLOXSEG5EI64_V_M1_M1_TU, VLOXSEG5EI64_V, 0x0 }, // 3546
  { PseudoVLOXSEG5EI64_V_M2_M1, VLOXSEG5EI64_V, 0x0 }, // 3547
  { PseudoVLOXSEG5EI64_V_M2_M1_MASK, VLOXSEG5EI64_V, 0x0 }, // 3548
  { PseudoVLOXSEG5EI64_V_M2_M1_TU, VLOXSEG5EI64_V, 0x0 }, // 3549
  { PseudoVLOXSEG5EI64_V_M4_M1, VLOXSEG5EI64_V, 0x0 }, // 3550
  { PseudoVLOXSEG5EI64_V_M4_M1_MASK, VLOXSEG5EI64_V, 0x0 }, // 3551
  { PseudoVLOXSEG5EI64_V_M4_M1_TU, VLOXSEG5EI64_V, 0x0 }, // 3552
  { PseudoVLOXSEG5EI64_V_M8_M1, VLOXSEG5EI64_V, 0x0 }, // 3553
  { PseudoVLOXSEG5EI64_V_M8_M1_MASK, VLOXSEG5EI64_V, 0x0 }, // 3554
  { PseudoVLOXSEG5EI64_V_M8_M1_TU, VLOXSEG5EI64_V, 0x0 }, // 3555
  { PseudoVLOXSEG5EI64_V_M1_MF8, VLOXSEG5EI64_V, 0x5 }, // 3556
  { PseudoVLOXSEG5EI64_V_M1_MF8_MASK, VLOXSEG5EI64_V, 0x5 }, // 3557
  { PseudoVLOXSEG5EI64_V_M1_MF8_TU, VLOXSEG5EI64_V, 0x5 }, // 3558
  { PseudoVLOXSEG5EI64_V_M1_MF4, VLOXSEG5EI64_V, 0x6 }, // 3559
  { PseudoVLOXSEG5EI64_V_M1_MF4_MASK, VLOXSEG5EI64_V, 0x6 }, // 3560
  { PseudoVLOXSEG5EI64_V_M1_MF4_TU, VLOXSEG5EI64_V, 0x6 }, // 3561
  { PseudoVLOXSEG5EI64_V_M2_MF4, VLOXSEG5EI64_V, 0x6 }, // 3562
  { PseudoVLOXSEG5EI64_V_M2_MF4_MASK, VLOXSEG5EI64_V, 0x6 }, // 3563
  { PseudoVLOXSEG5EI64_V_M2_MF4_TU, VLOXSEG5EI64_V, 0x6 }, // 3564
  { PseudoVLOXSEG5EI64_V_M1_MF2, VLOXSEG5EI64_V, 0x7 }, // 3565
  { PseudoVLOXSEG5EI64_V_M1_MF2_MASK, VLOXSEG5EI64_V, 0x7 }, // 3566
  { PseudoVLOXSEG5EI64_V_M1_MF2_TU, VLOXSEG5EI64_V, 0x7 }, // 3567
  { PseudoVLOXSEG5EI64_V_M2_MF2, VLOXSEG5EI64_V, 0x7 }, // 3568
  { PseudoVLOXSEG5EI64_V_M2_MF2_MASK, VLOXSEG5EI64_V, 0x7 }, // 3569
  { PseudoVLOXSEG5EI64_V_M2_MF2_TU, VLOXSEG5EI64_V, 0x7 }, // 3570
  { PseudoVLOXSEG5EI64_V_M4_MF2, VLOXSEG5EI64_V, 0x7 }, // 3571
  { PseudoVLOXSEG5EI64_V_M4_MF2_MASK, VLOXSEG5EI64_V, 0x7 }, // 3572
  { PseudoVLOXSEG5EI64_V_M4_MF2_TU, VLOXSEG5EI64_V, 0x7 }, // 3573
  { PseudoVLOXSEG5EI8_V_M1_M1, VLOXSEG5EI8_V, 0x0 }, // 3574
  { PseudoVLOXSEG5EI8_V_M1_M1_MASK, VLOXSEG5EI8_V, 0x0 }, // 3575
  { PseudoVLOXSEG5EI8_V_M1_M1_TU, VLOXSEG5EI8_V, 0x0 }, // 3576
  { PseudoVLOXSEG5EI8_V_MF2_M1, VLOXSEG5EI8_V, 0x0 }, // 3577
  { PseudoVLOXSEG5EI8_V_MF2_M1_MASK, VLOXSEG5EI8_V, 0x0 }, // 3578
  { PseudoVLOXSEG5EI8_V_MF2_M1_TU, VLOXSEG5EI8_V, 0x0 }, // 3579
  { PseudoVLOXSEG5EI8_V_MF4_M1, VLOXSEG5EI8_V, 0x0 }, // 3580
  { PseudoVLOXSEG5EI8_V_MF4_M1_MASK, VLOXSEG5EI8_V, 0x0 }, // 3581
  { PseudoVLOXSEG5EI8_V_MF4_M1_TU, VLOXSEG5EI8_V, 0x0 }, // 3582
  { PseudoVLOXSEG5EI8_V_MF8_M1, VLOXSEG5EI8_V, 0x0 }, // 3583
  { PseudoVLOXSEG5EI8_V_MF8_M1_MASK, VLOXSEG5EI8_V, 0x0 }, // 3584
  { PseudoVLOXSEG5EI8_V_MF8_M1_TU, VLOXSEG5EI8_V, 0x0 }, // 3585
  { PseudoVLOXSEG5EI8_V_MF8_MF8, VLOXSEG5EI8_V, 0x5 }, // 3586
  { PseudoVLOXSEG5EI8_V_MF8_MF8_MASK, VLOXSEG5EI8_V, 0x5 }, // 3587
  { PseudoVLOXSEG5EI8_V_MF8_MF8_TU, VLOXSEG5EI8_V, 0x5 }, // 3588
  { PseudoVLOXSEG5EI8_V_MF4_MF4, VLOXSEG5EI8_V, 0x6 }, // 3589
  { PseudoVLOXSEG5EI8_V_MF4_MF4_MASK, VLOXSEG5EI8_V, 0x6 }, // 3590
  { PseudoVLOXSEG5EI8_V_MF4_MF4_TU, VLOXSEG5EI8_V, 0x6 }, // 3591
  { PseudoVLOXSEG5EI8_V_MF8_MF4, VLOXSEG5EI8_V, 0x6 }, // 3592
  { PseudoVLOXSEG5EI8_V_MF8_MF4_MASK, VLOXSEG5EI8_V, 0x6 }, // 3593
  { PseudoVLOXSEG5EI8_V_MF8_MF4_TU, VLOXSEG5EI8_V, 0x6 }, // 3594
  { PseudoVLOXSEG5EI8_V_MF2_MF2, VLOXSEG5EI8_V, 0x7 }, // 3595
  { PseudoVLOXSEG5EI8_V_MF2_MF2_MASK, VLOXSEG5EI8_V, 0x7 }, // 3596
  { PseudoVLOXSEG5EI8_V_MF2_MF2_TU, VLOXSEG5EI8_V, 0x7 }, // 3597
  { PseudoVLOXSEG5EI8_V_MF4_MF2, VLOXSEG5EI8_V, 0x7 }, // 3598
  { PseudoVLOXSEG5EI8_V_MF4_MF2_MASK, VLOXSEG5EI8_V, 0x7 }, // 3599
  { PseudoVLOXSEG5EI8_V_MF4_MF2_TU, VLOXSEG5EI8_V, 0x7 }, // 3600
  { PseudoVLOXSEG5EI8_V_MF8_MF2, VLOXSEG5EI8_V, 0x7 }, // 3601
  { PseudoVLOXSEG5EI8_V_MF8_MF2_MASK, VLOXSEG5EI8_V, 0x7 }, // 3602
  { PseudoVLOXSEG5EI8_V_MF8_MF2_TU, VLOXSEG5EI8_V, 0x7 }, // 3603
  { PseudoVLOXSEG6EI16_V_M1_M1, VLOXSEG6EI16_V, 0x0 }, // 3604
  { PseudoVLOXSEG6EI16_V_M1_M1_MASK, VLOXSEG6EI16_V, 0x0 }, // 3605
  { PseudoVLOXSEG6EI16_V_M1_M1_TU, VLOXSEG6EI16_V, 0x0 }, // 3606
  { PseudoVLOXSEG6EI16_V_M2_M1, VLOXSEG6EI16_V, 0x0 }, // 3607
  { PseudoVLOXSEG6EI16_V_M2_M1_MASK, VLOXSEG6EI16_V, 0x0 }, // 3608
  { PseudoVLOXSEG6EI16_V_M2_M1_TU, VLOXSEG6EI16_V, 0x0 }, // 3609
  { PseudoVLOXSEG6EI16_V_MF2_M1, VLOXSEG6EI16_V, 0x0 }, // 3610
  { PseudoVLOXSEG6EI16_V_MF2_M1_MASK, VLOXSEG6EI16_V, 0x0 }, // 3611
  { PseudoVLOXSEG6EI16_V_MF2_M1_TU, VLOXSEG6EI16_V, 0x0 }, // 3612
  { PseudoVLOXSEG6EI16_V_MF4_M1, VLOXSEG6EI16_V, 0x0 }, // 3613
  { PseudoVLOXSEG6EI16_V_MF4_M1_MASK, VLOXSEG6EI16_V, 0x0 }, // 3614
  { PseudoVLOXSEG6EI16_V_MF4_M1_TU, VLOXSEG6EI16_V, 0x0 }, // 3615
  { PseudoVLOXSEG6EI16_V_MF4_MF8, VLOXSEG6EI16_V, 0x5 }, // 3616
  { PseudoVLOXSEG6EI16_V_MF4_MF8_MASK, VLOXSEG6EI16_V, 0x5 }, // 3617
  { PseudoVLOXSEG6EI16_V_MF4_MF8_TU, VLOXSEG6EI16_V, 0x5 }, // 3618
  { PseudoVLOXSEG6EI16_V_MF2_MF4, VLOXSEG6EI16_V, 0x6 }, // 3619
  { PseudoVLOXSEG6EI16_V_MF2_MF4_MASK, VLOXSEG6EI16_V, 0x6 }, // 3620
  { PseudoVLOXSEG6EI16_V_MF2_MF4_TU, VLOXSEG6EI16_V, 0x6 }, // 3621
  { PseudoVLOXSEG6EI16_V_MF4_MF4, VLOXSEG6EI16_V, 0x6 }, // 3622
  { PseudoVLOXSEG6EI16_V_MF4_MF4_MASK, VLOXSEG6EI16_V, 0x6 }, // 3623
  { PseudoVLOXSEG6EI16_V_MF4_MF4_TU, VLOXSEG6EI16_V, 0x6 }, // 3624
  { PseudoVLOXSEG6EI16_V_M1_MF2, VLOXSEG6EI16_V, 0x7 }, // 3625
  { PseudoVLOXSEG6EI16_V_M1_MF2_MASK, VLOXSEG6EI16_V, 0x7 }, // 3626
  { PseudoVLOXSEG6EI16_V_M1_MF2_TU, VLOXSEG6EI16_V, 0x7 }, // 3627
  { PseudoVLOXSEG6EI16_V_MF2_MF2, VLOXSEG6EI16_V, 0x7 }, // 3628
  { PseudoVLOXSEG6EI16_V_MF2_MF2_MASK, VLOXSEG6EI16_V, 0x7 }, // 3629
  { PseudoVLOXSEG6EI16_V_MF2_MF2_TU, VLOXSEG6EI16_V, 0x7 }, // 3630
  { PseudoVLOXSEG6EI16_V_MF4_MF2, VLOXSEG6EI16_V, 0x7 }, // 3631
  { PseudoVLOXSEG6EI16_V_MF4_MF2_MASK, VLOXSEG6EI16_V, 0x7 }, // 3632
  { PseudoVLOXSEG6EI16_V_MF4_MF2_TU, VLOXSEG6EI16_V, 0x7 }, // 3633
  { PseudoVLOXSEG6EI32_V_M1_M1, VLOXSEG6EI32_V, 0x0 }, // 3634
  { PseudoVLOXSEG6EI32_V_M1_M1_MASK, VLOXSEG6EI32_V, 0x0 }, // 3635
  { PseudoVLOXSEG6EI32_V_M1_M1_TU, VLOXSEG6EI32_V, 0x0 }, // 3636
  { PseudoVLOXSEG6EI32_V_M2_M1, VLOXSEG6EI32_V, 0x0 }, // 3637
  { PseudoVLOXSEG6EI32_V_M2_M1_MASK, VLOXSEG6EI32_V, 0x0 }, // 3638
  { PseudoVLOXSEG6EI32_V_M2_M1_TU, VLOXSEG6EI32_V, 0x0 }, // 3639
  { PseudoVLOXSEG6EI32_V_M4_M1, VLOXSEG6EI32_V, 0x0 }, // 3640
  { PseudoVLOXSEG6EI32_V_M4_M1_MASK, VLOXSEG6EI32_V, 0x0 }, // 3641
  { PseudoVLOXSEG6EI32_V_M4_M1_TU, VLOXSEG6EI32_V, 0x0 }, // 3642
  { PseudoVLOXSEG6EI32_V_MF2_M1, VLOXSEG6EI32_V, 0x0 }, // 3643
  { PseudoVLOXSEG6EI32_V_MF2_M1_MASK, VLOXSEG6EI32_V, 0x0 }, // 3644
  { PseudoVLOXSEG6EI32_V_MF2_M1_TU, VLOXSEG6EI32_V, 0x0 }, // 3645
  { PseudoVLOXSEG6EI32_V_MF2_MF8, VLOXSEG6EI32_V, 0x5 }, // 3646
  { PseudoVLOXSEG6EI32_V_MF2_MF8_MASK, VLOXSEG6EI32_V, 0x5 }, // 3647
  { PseudoVLOXSEG6EI32_V_MF2_MF8_TU, VLOXSEG6EI32_V, 0x5 }, // 3648
  { PseudoVLOXSEG6EI32_V_M1_MF4, VLOXSEG6EI32_V, 0x6 }, // 3649
  { PseudoVLOXSEG6EI32_V_M1_MF4_MASK, VLOXSEG6EI32_V, 0x6 }, // 3650
  { PseudoVLOXSEG6EI32_V_M1_MF4_TU, VLOXSEG6EI32_V, 0x6 }, // 3651
  { PseudoVLOXSEG6EI32_V_MF2_MF4, VLOXSEG6EI32_V, 0x6 }, // 3652
  { PseudoVLOXSEG6EI32_V_MF2_MF4_MASK, VLOXSEG6EI32_V, 0x6 }, // 3653
  { PseudoVLOXSEG6EI32_V_MF2_MF4_TU, VLOXSEG6EI32_V, 0x6 }, // 3654
  { PseudoVLOXSEG6EI32_V_M1_MF2, VLOXSEG6EI32_V, 0x7 }, // 3655
  { PseudoVLOXSEG6EI32_V_M1_MF2_MASK, VLOXSEG6EI32_V, 0x7 }, // 3656
  { PseudoVLOXSEG6EI32_V_M1_MF2_TU, VLOXSEG6EI32_V, 0x7 }, // 3657
  { PseudoVLOXSEG6EI32_V_M2_MF2, VLOXSEG6EI32_V, 0x7 }, // 3658
  { PseudoVLOXSEG6EI32_V_M2_MF2_MASK, VLOXSEG6EI32_V, 0x7 }, // 3659
  { PseudoVLOXSEG6EI32_V_M2_MF2_TU, VLOXSEG6EI32_V, 0x7 }, // 3660
  { PseudoVLOXSEG6EI32_V_MF2_MF2, VLOXSEG6EI32_V, 0x7 }, // 3661
  { PseudoVLOXSEG6EI32_V_MF2_MF2_MASK, VLOXSEG6EI32_V, 0x7 }, // 3662
  { PseudoVLOXSEG6EI32_V_MF2_MF2_TU, VLOXSEG6EI32_V, 0x7 }, // 3663
  { PseudoVLOXSEG6EI64_V_M1_M1, VLOXSEG6EI64_V, 0x0 }, // 3664
  { PseudoVLOXSEG6EI64_V_M1_M1_MASK, VLOXSEG6EI64_V, 0x0 }, // 3665
  { PseudoVLOXSEG6EI64_V_M1_M1_TU, VLOXSEG6EI64_V, 0x0 }, // 3666
  { PseudoVLOXSEG6EI64_V_M2_M1, VLOXSEG6EI64_V, 0x0 }, // 3667
  { PseudoVLOXSEG6EI64_V_M2_M1_MASK, VLOXSEG6EI64_V, 0x0 }, // 3668
  { PseudoVLOXSEG6EI64_V_M2_M1_TU, VLOXSEG6EI64_V, 0x0 }, // 3669
  { PseudoVLOXSEG6EI64_V_M4_M1, VLOXSEG6EI64_V, 0x0 }, // 3670
  { PseudoVLOXSEG6EI64_V_M4_M1_MASK, VLOXSEG6EI64_V, 0x0 }, // 3671
  { PseudoVLOXSEG6EI64_V_M4_M1_TU, VLOXSEG6EI64_V, 0x0 }, // 3672
  { PseudoVLOXSEG6EI64_V_M8_M1, VLOXSEG6EI64_V, 0x0 }, // 3673
  { PseudoVLOXSEG6EI64_V_M8_M1_MASK, VLOXSEG6EI64_V, 0x0 }, // 3674
  { PseudoVLOXSEG6EI64_V_M8_M1_TU, VLOXSEG6EI64_V, 0x0 }, // 3675
  { PseudoVLOXSEG6EI64_V_M1_MF8, VLOXSEG6EI64_V, 0x5 }, // 3676
  { PseudoVLOXSEG6EI64_V_M1_MF8_MASK, VLOXSEG6EI64_V, 0x5 }, // 3677
  { PseudoVLOXSEG6EI64_V_M1_MF8_TU, VLOXSEG6EI64_V, 0x5 }, // 3678
  { PseudoVLOXSEG6EI64_V_M1_MF4, VLOXSEG6EI64_V, 0x6 }, // 3679
  { PseudoVLOXSEG6EI64_V_M1_MF4_MASK, VLOXSEG6EI64_V, 0x6 }, // 3680
  { PseudoVLOXSEG6EI64_V_M1_MF4_TU, VLOXSEG6EI64_V, 0x6 }, // 3681
  { PseudoVLOXSEG6EI64_V_M2_MF4, VLOXSEG6EI64_V, 0x6 }, // 3682
  { PseudoVLOXSEG6EI64_V_M2_MF4_MASK, VLOXSEG6EI64_V, 0x6 }, // 3683
  { PseudoVLOXSEG6EI64_V_M2_MF4_TU, VLOXSEG6EI64_V, 0x6 }, // 3684
  { PseudoVLOXSEG6EI64_V_M1_MF2, VLOXSEG6EI64_V, 0x7 }, // 3685
  { PseudoVLOXSEG6EI64_V_M1_MF2_MASK, VLOXSEG6EI64_V, 0x7 }, // 3686
  { PseudoVLOXSEG6EI64_V_M1_MF2_TU, VLOXSEG6EI64_V, 0x7 }, // 3687
  { PseudoVLOXSEG6EI64_V_M2_MF2, VLOXSEG6EI64_V, 0x7 }, // 3688
  { PseudoVLOXSEG6EI64_V_M2_MF2_MASK, VLOXSEG6EI64_V, 0x7 }, // 3689
  { PseudoVLOXSEG6EI64_V_M2_MF2_TU, VLOXSEG6EI64_V, 0x7 }, // 3690
  { PseudoVLOXSEG6EI64_V_M4_MF2, VLOXSEG6EI64_V, 0x7 }, // 3691
  { PseudoVLOXSEG6EI64_V_M4_MF2_MASK, VLOXSEG6EI64_V, 0x7 }, // 3692
  { PseudoVLOXSEG6EI64_V_M4_MF2_TU, VLOXSEG6EI64_V, 0x7 }, // 3693
  { PseudoVLOXSEG6EI8_V_M1_M1, VLOXSEG6EI8_V, 0x0 }, // 3694
  { PseudoVLOXSEG6EI8_V_M1_M1_MASK, VLOXSEG6EI8_V, 0x0 }, // 3695
  { PseudoVLOXSEG6EI8_V_M1_M1_TU, VLOXSEG6EI8_V, 0x0 }, // 3696
  { PseudoVLOXSEG6EI8_V_MF2_M1, VLOXSEG6EI8_V, 0x0 }, // 3697
  { PseudoVLOXSEG6EI8_V_MF2_M1_MASK, VLOXSEG6EI8_V, 0x0 }, // 3698
  { PseudoVLOXSEG6EI8_V_MF2_M1_TU, VLOXSEG6EI8_V, 0x0 }, // 3699
  { PseudoVLOXSEG6EI8_V_MF4_M1, VLOXSEG6EI8_V, 0x0 }, // 3700
  { PseudoVLOXSEG6EI8_V_MF4_M1_MASK, VLOXSEG6EI8_V, 0x0 }, // 3701
  { PseudoVLOXSEG6EI8_V_MF4_M1_TU, VLOXSEG6EI8_V, 0x0 }, // 3702
  { PseudoVLOXSEG6EI8_V_MF8_M1, VLOXSEG6EI8_V, 0x0 }, // 3703
  { PseudoVLOXSEG6EI8_V_MF8_M1_MASK, VLOXSEG6EI8_V, 0x0 }, // 3704
  { PseudoVLOXSEG6EI8_V_MF8_M1_TU, VLOXSEG6EI8_V, 0x0 }, // 3705
  { PseudoVLOXSEG6EI8_V_MF8_MF8, VLOXSEG6EI8_V, 0x5 }, // 3706
  { PseudoVLOXSEG6EI8_V_MF8_MF8_MASK, VLOXSEG6EI8_V, 0x5 }, // 3707
  { PseudoVLOXSEG6EI8_V_MF8_MF8_TU, VLOXSEG6EI8_V, 0x5 }, // 3708
  { PseudoVLOXSEG6EI8_V_MF4_MF4, VLOXSEG6EI8_V, 0x6 }, // 3709
  { PseudoVLOXSEG6EI8_V_MF4_MF4_MASK, VLOXSEG6EI8_V, 0x6 }, // 3710
  { PseudoVLOXSEG6EI8_V_MF4_MF4_TU, VLOXSEG6EI8_V, 0x6 }, // 3711
  { PseudoVLOXSEG6EI8_V_MF8_MF4, VLOXSEG6EI8_V, 0x6 }, // 3712
  { PseudoVLOXSEG6EI8_V_MF8_MF4_MASK, VLOXSEG6EI8_V, 0x6 }, // 3713
  { PseudoVLOXSEG6EI8_V_MF8_MF4_TU, VLOXSEG6EI8_V, 0x6 }, // 3714
  { PseudoVLOXSEG6EI8_V_MF2_MF2, VLOXSEG6EI8_V, 0x7 }, // 3715
  { PseudoVLOXSEG6EI8_V_MF2_MF2_MASK, VLOXSEG6EI8_V, 0x7 }, // 3716
  { PseudoVLOXSEG6EI8_V_MF2_MF2_TU, VLOXSEG6EI8_V, 0x7 }, // 3717
  { PseudoVLOXSEG6EI8_V_MF4_MF2, VLOXSEG6EI8_V, 0x7 }, // 3718
  { PseudoVLOXSEG6EI8_V_MF4_MF2_MASK, VLOXSEG6EI8_V, 0x7 }, // 3719
  { PseudoVLOXSEG6EI8_V_MF4_MF2_TU, VLOXSEG6EI8_V, 0x7 }, // 3720
  { PseudoVLOXSEG6EI8_V_MF8_MF2, VLOXSEG6EI8_V, 0x7 }, // 3721
  { PseudoVLOXSEG6EI8_V_MF8_MF2_MASK, VLOXSEG6EI8_V, 0x7 }, // 3722
  { PseudoVLOXSEG6EI8_V_MF8_MF2_TU, VLOXSEG6EI8_V, 0x7 }, // 3723
  { PseudoVLOXSEG7EI16_V_M1_M1, VLOXSEG7EI16_V, 0x0 }, // 3724
  { PseudoVLOXSEG7EI16_V_M1_M1_MASK, VLOXSEG7EI16_V, 0x0 }, // 3725
  { PseudoVLOXSEG7EI16_V_M1_M1_TU, VLOXSEG7EI16_V, 0x0 }, // 3726
  { PseudoVLOXSEG7EI16_V_M2_M1, VLOXSEG7EI16_V, 0x0 }, // 3727
  { PseudoVLOXSEG7EI16_V_M2_M1_MASK, VLOXSEG7EI16_V, 0x0 }, // 3728
  { PseudoVLOXSEG7EI16_V_M2_M1_TU, VLOXSEG7EI16_V, 0x0 }, // 3729
  { PseudoVLOXSEG7EI16_V_MF2_M1, VLOXSEG7EI16_V, 0x0 }, // 3730
  { PseudoVLOXSEG7EI16_V_MF2_M1_MASK, VLOXSEG7EI16_V, 0x0 }, // 3731
  { PseudoVLOXSEG7EI16_V_MF2_M1_TU, VLOXSEG7EI16_V, 0x0 }, // 3732
  { PseudoVLOXSEG7EI16_V_MF4_M1, VLOXSEG7EI16_V, 0x0 }, // 3733
  { PseudoVLOXSEG7EI16_V_MF4_M1_MASK, VLOXSEG7EI16_V, 0x0 }, // 3734
  { PseudoVLOXSEG7EI16_V_MF4_M1_TU, VLOXSEG7EI16_V, 0x0 }, // 3735
  { PseudoVLOXSEG7EI16_V_MF4_MF8, VLOXSEG7EI16_V, 0x5 }, // 3736
  { PseudoVLOXSEG7EI16_V_MF4_MF8_MASK, VLOXSEG7EI16_V, 0x5 }, // 3737
  { PseudoVLOXSEG7EI16_V_MF4_MF8_TU, VLOXSEG7EI16_V, 0x5 }, // 3738
  { PseudoVLOXSEG7EI16_V_MF2_MF4, VLOXSEG7EI16_V, 0x6 }, // 3739
  { PseudoVLOXSEG7EI16_V_MF2_MF4_MASK, VLOXSEG7EI16_V, 0x6 }, // 3740
  { PseudoVLOXSEG7EI16_V_MF2_MF4_TU, VLOXSEG7EI16_V, 0x6 }, // 3741
  { PseudoVLOXSEG7EI16_V_MF4_MF4, VLOXSEG7EI16_V, 0x6 }, // 3742
  { PseudoVLOXSEG7EI16_V_MF4_MF4_MASK, VLOXSEG7EI16_V, 0x6 }, // 3743
  { PseudoVLOXSEG7EI16_V_MF4_MF4_TU, VLOXSEG7EI16_V, 0x6 }, // 3744
  { PseudoVLOXSEG7EI16_V_M1_MF2, VLOXSEG7EI16_V, 0x7 }, // 3745
  { PseudoVLOXSEG7EI16_V_M1_MF2_MASK, VLOXSEG7EI16_V, 0x7 }, // 3746
  { PseudoVLOXSEG7EI16_V_M1_MF2_TU, VLOXSEG7EI16_V, 0x7 }, // 3747
  { PseudoVLOXSEG7EI16_V_MF2_MF2, VLOXSEG7EI16_V, 0x7 }, // 3748
  { PseudoVLOXSEG7EI16_V_MF2_MF2_MASK, VLOXSEG7EI16_V, 0x7 }, // 3749
  { PseudoVLOXSEG7EI16_V_MF2_MF2_TU, VLOXSEG7EI16_V, 0x7 }, // 3750
  { PseudoVLOXSEG7EI16_V_MF4_MF2, VLOXSEG7EI16_V, 0x7 }, // 3751
  { PseudoVLOXSEG7EI16_V_MF4_MF2_MASK, VLOXSEG7EI16_V, 0x7 }, // 3752
  { PseudoVLOXSEG7EI16_V_MF4_MF2_TU, VLOXSEG7EI16_V, 0x7 }, // 3753
  { PseudoVLOXSEG7EI32_V_M1_M1, VLOXSEG7EI32_V, 0x0 }, // 3754
  { PseudoVLOXSEG7EI32_V_M1_M1_MASK, VLOXSEG7EI32_V, 0x0 }, // 3755
  { PseudoVLOXSEG7EI32_V_M1_M1_TU, VLOXSEG7EI32_V, 0x0 }, // 3756
  { PseudoVLOXSEG7EI32_V_M2_M1, VLOXSEG7EI32_V, 0x0 }, // 3757
  { PseudoVLOXSEG7EI32_V_M2_M1_MASK, VLOXSEG7EI32_V, 0x0 }, // 3758
  { PseudoVLOXSEG7EI32_V_M2_M1_TU, VLOXSEG7EI32_V, 0x0 }, // 3759
  { PseudoVLOXSEG7EI32_V_M4_M1, VLOXSEG7EI32_V, 0x0 }, // 3760
  { PseudoVLOXSEG7EI32_V_M4_M1_MASK, VLOXSEG7EI32_V, 0x0 }, // 3761
  { PseudoVLOXSEG7EI32_V_M4_M1_TU, VLOXSEG7EI32_V, 0x0 }, // 3762
  { PseudoVLOXSEG7EI32_V_MF2_M1, VLOXSEG7EI32_V, 0x0 }, // 3763
  { PseudoVLOXSEG7EI32_V_MF2_M1_MASK, VLOXSEG7EI32_V, 0x0 }, // 3764
  { PseudoVLOXSEG7EI32_V_MF2_M1_TU, VLOXSEG7EI32_V, 0x0 }, // 3765
  { PseudoVLOXSEG7EI32_V_MF2_MF8, VLOXSEG7EI32_V, 0x5 }, // 3766
  { PseudoVLOXSEG7EI32_V_MF2_MF8_MASK, VLOXSEG7EI32_V, 0x5 }, // 3767
  { PseudoVLOXSEG7EI32_V_MF2_MF8_TU, VLOXSEG7EI32_V, 0x5 }, // 3768
  { PseudoVLOXSEG7EI32_V_M1_MF4, VLOXSEG7EI32_V, 0x6 }, // 3769
  { PseudoVLOXSEG7EI32_V_M1_MF4_MASK, VLOXSEG7EI32_V, 0x6 }, // 3770
  { PseudoVLOXSEG7EI32_V_M1_MF4_TU, VLOXSEG7EI32_V, 0x6 }, // 3771
  { PseudoVLOXSEG7EI32_V_MF2_MF4, VLOXSEG7EI32_V, 0x6 }, // 3772
  { PseudoVLOXSEG7EI32_V_MF2_MF4_MASK, VLOXSEG7EI32_V, 0x6 }, // 3773
  { PseudoVLOXSEG7EI32_V_MF2_MF4_TU, VLOXSEG7EI32_V, 0x6 }, // 3774
  { PseudoVLOXSEG7EI32_V_M1_MF2, VLOXSEG7EI32_V, 0x7 }, // 3775
  { PseudoVLOXSEG7EI32_V_M1_MF2_MASK, VLOXSEG7EI32_V, 0x7 }, // 3776
  { PseudoVLOXSEG7EI32_V_M1_MF2_TU, VLOXSEG7EI32_V, 0x7 }, // 3777
  { PseudoVLOXSEG7EI32_V_M2_MF2, VLOXSEG7EI32_V, 0x7 }, // 3778
  { PseudoVLOXSEG7EI32_V_M2_MF2_MASK, VLOXSEG7EI32_V, 0x7 }, // 3779
  { PseudoVLOXSEG7EI32_V_M2_MF2_TU, VLOXSEG7EI32_V, 0x7 }, // 3780
  { PseudoVLOXSEG7EI32_V_MF2_MF2, VLOXSEG7EI32_V, 0x7 }, // 3781
  { PseudoVLOXSEG7EI32_V_MF2_MF2_MASK, VLOXSEG7EI32_V, 0x7 }, // 3782
  { PseudoVLOXSEG7EI32_V_MF2_MF2_TU, VLOXSEG7EI32_V, 0x7 }, // 3783
  { PseudoVLOXSEG7EI64_V_M1_M1, VLOXSEG7EI64_V, 0x0 }, // 3784
  { PseudoVLOXSEG7EI64_V_M1_M1_MASK, VLOXSEG7EI64_V, 0x0 }, // 3785
  { PseudoVLOXSEG7EI64_V_M1_M1_TU, VLOXSEG7EI64_V, 0x0 }, // 3786
  { PseudoVLOXSEG7EI64_V_M2_M1, VLOXSEG7EI64_V, 0x0 }, // 3787
  { PseudoVLOXSEG7EI64_V_M2_M1_MASK, VLOXSEG7EI64_V, 0x0 }, // 3788
  { PseudoVLOXSEG7EI64_V_M2_M1_TU, VLOXSEG7EI64_V, 0x0 }, // 3789
  { PseudoVLOXSEG7EI64_V_M4_M1, VLOXSEG7EI64_V, 0x0 }, // 3790
  { PseudoVLOXSEG7EI64_V_M4_M1_MASK, VLOXSEG7EI64_V, 0x0 }, // 3791
  { PseudoVLOXSEG7EI64_V_M4_M1_TU, VLOXSEG7EI64_V, 0x0 }, // 3792
  { PseudoVLOXSEG7EI64_V_M8_M1, VLOXSEG7EI64_V, 0x0 }, // 3793
  { PseudoVLOXSEG7EI64_V_M8_M1_MASK, VLOXSEG7EI64_V, 0x0 }, // 3794
  { PseudoVLOXSEG7EI64_V_M8_M1_TU, VLOXSEG7EI64_V, 0x0 }, // 3795
  { PseudoVLOXSEG7EI64_V_M1_MF8, VLOXSEG7EI64_V, 0x5 }, // 3796
  { PseudoVLOXSEG7EI64_V_M1_MF8_MASK, VLOXSEG7EI64_V, 0x5 }, // 3797
  { PseudoVLOXSEG7EI64_V_M1_MF8_TU, VLOXSEG7EI64_V, 0x5 }, // 3798
  { PseudoVLOXSEG7EI64_V_M1_MF4, VLOXSEG7EI64_V, 0x6 }, // 3799
  { PseudoVLOXSEG7EI64_V_M1_MF4_MASK, VLOXSEG7EI64_V, 0x6 }, // 3800
  { PseudoVLOXSEG7EI64_V_M1_MF4_TU, VLOXSEG7EI64_V, 0x6 }, // 3801
  { PseudoVLOXSEG7EI64_V_M2_MF4, VLOXSEG7EI64_V, 0x6 }, // 3802
  { PseudoVLOXSEG7EI64_V_M2_MF4_MASK, VLOXSEG7EI64_V, 0x6 }, // 3803
  { PseudoVLOXSEG7EI64_V_M2_MF4_TU, VLOXSEG7EI64_V, 0x6 }, // 3804
  { PseudoVLOXSEG7EI64_V_M1_MF2, VLOXSEG7EI64_V, 0x7 }, // 3805
  { PseudoVLOXSEG7EI64_V_M1_MF2_MASK, VLOXSEG7EI64_V, 0x7 }, // 3806
  { PseudoVLOXSEG7EI64_V_M1_MF2_TU, VLOXSEG7EI64_V, 0x7 }, // 3807
  { PseudoVLOXSEG7EI64_V_M2_MF2, VLOXSEG7EI64_V, 0x7 }, // 3808
  { PseudoVLOXSEG7EI64_V_M2_MF2_MASK, VLOXSEG7EI64_V, 0x7 }, // 3809
  { PseudoVLOXSEG7EI64_V_M2_MF2_TU, VLOXSEG7EI64_V, 0x7 }, // 3810
  { PseudoVLOXSEG7EI64_V_M4_MF2, VLOXSEG7EI64_V, 0x7 }, // 3811
  { PseudoVLOXSEG7EI64_V_M4_MF2_MASK, VLOXSEG7EI64_V, 0x7 }, // 3812
  { PseudoVLOXSEG7EI64_V_M4_MF2_TU, VLOXSEG7EI64_V, 0x7 }, // 3813
  { PseudoVLOXSEG7EI8_V_M1_M1, VLOXSEG7EI8_V, 0x0 }, // 3814
  { PseudoVLOXSEG7EI8_V_M1_M1_MASK, VLOXSEG7EI8_V, 0x0 }, // 3815
  { PseudoVLOXSEG7EI8_V_M1_M1_TU, VLOXSEG7EI8_V, 0x0 }, // 3816
  { PseudoVLOXSEG7EI8_V_MF2_M1, VLOXSEG7EI8_V, 0x0 }, // 3817
  { PseudoVLOXSEG7EI8_V_MF2_M1_MASK, VLOXSEG7EI8_V, 0x0 }, // 3818
  { PseudoVLOXSEG7EI8_V_MF2_M1_TU, VLOXSEG7EI8_V, 0x0 }, // 3819
  { PseudoVLOXSEG7EI8_V_MF4_M1, VLOXSEG7EI8_V, 0x0 }, // 3820
  { PseudoVLOXSEG7EI8_V_MF4_M1_MASK, VLOXSEG7EI8_V, 0x0 }, // 3821
  { PseudoVLOXSEG7EI8_V_MF4_M1_TU, VLOXSEG7EI8_V, 0x0 }, // 3822
  { PseudoVLOXSEG7EI8_V_MF8_M1, VLOXSEG7EI8_V, 0x0 }, // 3823
  { PseudoVLOXSEG7EI8_V_MF8_M1_MASK, VLOXSEG7EI8_V, 0x0 }, // 3824
  { PseudoVLOXSEG7EI8_V_MF8_M1_TU, VLOXSEG7EI8_V, 0x0 }, // 3825
  { PseudoVLOXSEG7EI8_V_MF8_MF8, VLOXSEG7EI8_V, 0x5 }, // 3826
  { PseudoVLOXSEG7EI8_V_MF8_MF8_MASK, VLOXSEG7EI8_V, 0x5 }, // 3827
  { PseudoVLOXSEG7EI8_V_MF8_MF8_TU, VLOXSEG7EI8_V, 0x5 }, // 3828
  { PseudoVLOXSEG7EI8_V_MF4_MF4, VLOXSEG7EI8_V, 0x6 }, // 3829
  { PseudoVLOXSEG7EI8_V_MF4_MF4_MASK, VLOXSEG7EI8_V, 0x6 }, // 3830
  { PseudoVLOXSEG7EI8_V_MF4_MF4_TU, VLOXSEG7EI8_V, 0x6 }, // 3831
  { PseudoVLOXSEG7EI8_V_MF8_MF4, VLOXSEG7EI8_V, 0x6 }, // 3832
  { PseudoVLOXSEG7EI8_V_MF8_MF4_MASK, VLOXSEG7EI8_V, 0x6 }, // 3833
  { PseudoVLOXSEG7EI8_V_MF8_MF4_TU, VLOXSEG7EI8_V, 0x6 }, // 3834
  { PseudoVLOXSEG7EI8_V_MF2_MF2, VLOXSEG7EI8_V, 0x7 }, // 3835
  { PseudoVLOXSEG7EI8_V_MF2_MF2_MASK, VLOXSEG7EI8_V, 0x7 }, // 3836
  { PseudoVLOXSEG7EI8_V_MF2_MF2_TU, VLOXSEG7EI8_V, 0x7 }, // 3837
  { PseudoVLOXSEG7EI8_V_MF4_MF2, VLOXSEG7EI8_V, 0x7 }, // 3838
  { PseudoVLOXSEG7EI8_V_MF4_MF2_MASK, VLOXSEG7EI8_V, 0x7 }, // 3839
  { PseudoVLOXSEG7EI8_V_MF4_MF2_TU, VLOXSEG7EI8_V, 0x7 }, // 3840
  { PseudoVLOXSEG7EI8_V_MF8_MF2, VLOXSEG7EI8_V, 0x7 }, // 3841
  { PseudoVLOXSEG7EI8_V_MF8_MF2_MASK, VLOXSEG7EI8_V, 0x7 }, // 3842
  { PseudoVLOXSEG7EI8_V_MF8_MF2_TU, VLOXSEG7EI8_V, 0x7 }, // 3843
  { PseudoVLOXSEG8EI16_V_M1_M1, VLOXSEG8EI16_V, 0x0 }, // 3844
  { PseudoVLOXSEG8EI16_V_M1_M1_MASK, VLOXSEG8EI16_V, 0x0 }, // 3845
  { PseudoVLOXSEG8EI16_V_M1_M1_TU, VLOXSEG8EI16_V, 0x0 }, // 3846
  { PseudoVLOXSEG8EI16_V_M2_M1, VLOXSEG8EI16_V, 0x0 }, // 3847
  { PseudoVLOXSEG8EI16_V_M2_M1_MASK, VLOXSEG8EI16_V, 0x0 }, // 3848
  { PseudoVLOXSEG8EI16_V_M2_M1_TU, VLOXSEG8EI16_V, 0x0 }, // 3849
  { PseudoVLOXSEG8EI16_V_MF2_M1, VLOXSEG8EI16_V, 0x0 }, // 3850
  { PseudoVLOXSEG8EI16_V_MF2_M1_MASK, VLOXSEG8EI16_V, 0x0 }, // 3851
  { PseudoVLOXSEG8EI16_V_MF2_M1_TU, VLOXSEG8EI16_V, 0x0 }, // 3852
  { PseudoVLOXSEG8EI16_V_MF4_M1, VLOXSEG8EI16_V, 0x0 }, // 3853
  { PseudoVLOXSEG8EI16_V_MF4_M1_MASK, VLOXSEG8EI16_V, 0x0 }, // 3854
  { PseudoVLOXSEG8EI16_V_MF4_M1_TU, VLOXSEG8EI16_V, 0x0 }, // 3855
  { PseudoVLOXSEG8EI16_V_MF4_MF8, VLOXSEG8EI16_V, 0x5 }, // 3856
  { PseudoVLOXSEG8EI16_V_MF4_MF8_MASK, VLOXSEG8EI16_V, 0x5 }, // 3857
  { PseudoVLOXSEG8EI16_V_MF4_MF8_TU, VLOXSEG8EI16_V, 0x5 }, // 3858
  { PseudoVLOXSEG8EI16_V_MF2_MF4, VLOXSEG8EI16_V, 0x6 }, // 3859
  { PseudoVLOXSEG8EI16_V_MF2_MF4_MASK, VLOXSEG8EI16_V, 0x6 }, // 3860
  { PseudoVLOXSEG8EI16_V_MF2_MF4_TU, VLOXSEG8EI16_V, 0x6 }, // 3861
  { PseudoVLOXSEG8EI16_V_MF4_MF4, VLOXSEG8EI16_V, 0x6 }, // 3862
  { PseudoVLOXSEG8EI16_V_MF4_MF4_MASK, VLOXSEG8EI16_V, 0x6 }, // 3863
  { PseudoVLOXSEG8EI16_V_MF4_MF4_TU, VLOXSEG8EI16_V, 0x6 }, // 3864
  { PseudoVLOXSEG8EI16_V_M1_MF2, VLOXSEG8EI16_V, 0x7 }, // 3865
  { PseudoVLOXSEG8EI16_V_M1_MF2_MASK, VLOXSEG8EI16_V, 0x7 }, // 3866
  { PseudoVLOXSEG8EI16_V_M1_MF2_TU, VLOXSEG8EI16_V, 0x7 }, // 3867
  { PseudoVLOXSEG8EI16_V_MF2_MF2, VLOXSEG8EI16_V, 0x7 }, // 3868
  { PseudoVLOXSEG8EI16_V_MF2_MF2_MASK, VLOXSEG8EI16_V, 0x7 }, // 3869
  { PseudoVLOXSEG8EI16_V_MF2_MF2_TU, VLOXSEG8EI16_V, 0x7 }, // 3870
  { PseudoVLOXSEG8EI16_V_MF4_MF2, VLOXSEG8EI16_V, 0x7 }, // 3871
  { PseudoVLOXSEG8EI16_V_MF4_MF2_MASK, VLOXSEG8EI16_V, 0x7 }, // 3872
  { PseudoVLOXSEG8EI16_V_MF4_MF2_TU, VLOXSEG8EI16_V, 0x7 }, // 3873
  { PseudoVLOXSEG8EI32_V_M1_M1, VLOXSEG8EI32_V, 0x0 }, // 3874
  { PseudoVLOXSEG8EI32_V_M1_M1_MASK, VLOXSEG8EI32_V, 0x0 }, // 3875
  { PseudoVLOXSEG8EI32_V_M1_M1_TU, VLOXSEG8EI32_V, 0x0 }, // 3876
  { PseudoVLOXSEG8EI32_V_M2_M1, VLOXSEG8EI32_V, 0x0 }, // 3877
  { PseudoVLOXSEG8EI32_V_M2_M1_MASK, VLOXSEG8EI32_V, 0x0 }, // 3878
  { PseudoVLOXSEG8EI32_V_M2_M1_TU, VLOXSEG8EI32_V, 0x0 }, // 3879
  { PseudoVLOXSEG8EI32_V_M4_M1, VLOXSEG8EI32_V, 0x0 }, // 3880
  { PseudoVLOXSEG8EI32_V_M4_M1_MASK, VLOXSEG8EI32_V, 0x0 }, // 3881
  { PseudoVLOXSEG8EI32_V_M4_M1_TU, VLOXSEG8EI32_V, 0x0 }, // 3882
  { PseudoVLOXSEG8EI32_V_MF2_M1, VLOXSEG8EI32_V, 0x0 }, // 3883
  { PseudoVLOXSEG8EI32_V_MF2_M1_MASK, VLOXSEG8EI32_V, 0x0 }, // 3884
  { PseudoVLOXSEG8EI32_V_MF2_M1_TU, VLOXSEG8EI32_V, 0x0 }, // 3885
  { PseudoVLOXSEG8EI32_V_MF2_MF8, VLOXSEG8EI32_V, 0x5 }, // 3886
  { PseudoVLOXSEG8EI32_V_MF2_MF8_MASK, VLOXSEG8EI32_V, 0x5 }, // 3887
  { PseudoVLOXSEG8EI32_V_MF2_MF8_TU, VLOXSEG8EI32_V, 0x5 }, // 3888
  { PseudoVLOXSEG8EI32_V_M1_MF4, VLOXSEG8EI32_V, 0x6 }, // 3889
  { PseudoVLOXSEG8EI32_V_M1_MF4_MASK, VLOXSEG8EI32_V, 0x6 }, // 3890
  { PseudoVLOXSEG8EI32_V_M1_MF4_TU, VLOXSEG8EI32_V, 0x6 }, // 3891
  { PseudoVLOXSEG8EI32_V_MF2_MF4, VLOXSEG8EI32_V, 0x6 }, // 3892
  { PseudoVLOXSEG8EI32_V_MF2_MF4_MASK, VLOXSEG8EI32_V, 0x6 }, // 3893
  { PseudoVLOXSEG8EI32_V_MF2_MF4_TU, VLOXSEG8EI32_V, 0x6 }, // 3894
  { PseudoVLOXSEG8EI32_V_M1_MF2, VLOXSEG8EI32_V, 0x7 }, // 3895
  { PseudoVLOXSEG8EI32_V_M1_MF2_MASK, VLOXSEG8EI32_V, 0x7 }, // 3896
  { PseudoVLOXSEG8EI32_V_M1_MF2_TU, VLOXSEG8EI32_V, 0x7 }, // 3897
  { PseudoVLOXSEG8EI32_V_M2_MF2, VLOXSEG8EI32_V, 0x7 }, // 3898
  { PseudoVLOXSEG8EI32_V_M2_MF2_MASK, VLOXSEG8EI32_V, 0x7 }, // 3899
  { PseudoVLOXSEG8EI32_V_M2_MF2_TU, VLOXSEG8EI32_V, 0x7 }, // 3900
  { PseudoVLOXSEG8EI32_V_MF2_MF2, VLOXSEG8EI32_V, 0x7 }, // 3901
  { PseudoVLOXSEG8EI32_V_MF2_MF2_MASK, VLOXSEG8EI32_V, 0x7 }, // 3902
  { PseudoVLOXSEG8EI32_V_MF2_MF2_TU, VLOXSEG8EI32_V, 0x7 }, // 3903
  { PseudoVLOXSEG8EI64_V_M1_M1, VLOXSEG8EI64_V, 0x0 }, // 3904
  { PseudoVLOXSEG8EI64_V_M1_M1_MASK, VLOXSEG8EI64_V, 0x0 }, // 3905
  { PseudoVLOXSEG8EI64_V_M1_M1_TU, VLOXSEG8EI64_V, 0x0 }, // 3906
  { PseudoVLOXSEG8EI64_V_M2_M1, VLOXSEG8EI64_V, 0x0 }, // 3907
  { PseudoVLOXSEG8EI64_V_M2_M1_MASK, VLOXSEG8EI64_V, 0x0 }, // 3908
  { PseudoVLOXSEG8EI64_V_M2_M1_TU, VLOXSEG8EI64_V, 0x0 }, // 3909
  { PseudoVLOXSEG8EI64_V_M4_M1, VLOXSEG8EI64_V, 0x0 }, // 3910
  { PseudoVLOXSEG8EI64_V_M4_M1_MASK, VLOXSEG8EI64_V, 0x0 }, // 3911
  { PseudoVLOXSEG8EI64_V_M4_M1_TU, VLOXSEG8EI64_V, 0x0 }, // 3912
  { PseudoVLOXSEG8EI64_V_M8_M1, VLOXSEG8EI64_V, 0x0 }, // 3913
  { PseudoVLOXSEG8EI64_V_M8_M1_MASK, VLOXSEG8EI64_V, 0x0 }, // 3914
  { PseudoVLOXSEG8EI64_V_M8_M1_TU, VLOXSEG8EI64_V, 0x0 }, // 3915
  { PseudoVLOXSEG8EI64_V_M1_MF8, VLOXSEG8EI64_V, 0x5 }, // 3916
  { PseudoVLOXSEG8EI64_V_M1_MF8_MASK, VLOXSEG8EI64_V, 0x5 }, // 3917
  { PseudoVLOXSEG8EI64_V_M1_MF8_TU, VLOXSEG8EI64_V, 0x5 }, // 3918
  { PseudoVLOXSEG8EI64_V_M1_MF4, VLOXSEG8EI64_V, 0x6 }, // 3919
  { PseudoVLOXSEG8EI64_V_M1_MF4_MASK, VLOXSEG8EI64_V, 0x6 }, // 3920
  { PseudoVLOXSEG8EI64_V_M1_MF4_TU, VLOXSEG8EI64_V, 0x6 }, // 3921
  { PseudoVLOXSEG8EI64_V_M2_MF4, VLOXSEG8EI64_V, 0x6 }, // 3922
  { PseudoVLOXSEG8EI64_V_M2_MF4_MASK, VLOXSEG8EI64_V, 0x6 }, // 3923
  { PseudoVLOXSEG8EI64_V_M2_MF4_TU, VLOXSEG8EI64_V, 0x6 }, // 3924
  { PseudoVLOXSEG8EI64_V_M1_MF2, VLOXSEG8EI64_V, 0x7 }, // 3925
  { PseudoVLOXSEG8EI64_V_M1_MF2_MASK, VLOXSEG8EI64_V, 0x7 }, // 3926
  { PseudoVLOXSEG8EI64_V_M1_MF2_TU, VLOXSEG8EI64_V, 0x7 }, // 3927
  { PseudoVLOXSEG8EI64_V_M2_MF2, VLOXSEG8EI64_V, 0x7 }, // 3928
  { PseudoVLOXSEG8EI64_V_M2_MF2_MASK, VLOXSEG8EI64_V, 0x7 }, // 3929
  { PseudoVLOXSEG8EI64_V_M2_MF2_TU, VLOXSEG8EI64_V, 0x7 }, // 3930
  { PseudoVLOXSEG8EI64_V_M4_MF2, VLOXSEG8EI64_V, 0x7 }, // 3931
  { PseudoVLOXSEG8EI64_V_M4_MF2_MASK, VLOXSEG8EI64_V, 0x7 }, // 3932
  { PseudoVLOXSEG8EI64_V_M4_MF2_TU, VLOXSEG8EI64_V, 0x7 }, // 3933
  { PseudoVLOXSEG8EI8_V_M1_M1, VLOXSEG8EI8_V, 0x0 }, // 3934
  { PseudoVLOXSEG8EI8_V_M1_M1_MASK, VLOXSEG8EI8_V, 0x0 }, // 3935
  { PseudoVLOXSEG8EI8_V_M1_M1_TU, VLOXSEG8EI8_V, 0x0 }, // 3936
  { PseudoVLOXSEG8EI8_V_MF2_M1, VLOXSEG8EI8_V, 0x0 }, // 3937
  { PseudoVLOXSEG8EI8_V_MF2_M1_MASK, VLOXSEG8EI8_V, 0x0 }, // 3938
  { PseudoVLOXSEG8EI8_V_MF2_M1_TU, VLOXSEG8EI8_V, 0x0 }, // 3939
  { PseudoVLOXSEG8EI8_V_MF4_M1, VLOXSEG8EI8_V, 0x0 }, // 3940
  { PseudoVLOXSEG8EI8_V_MF4_M1_MASK, VLOXSEG8EI8_V, 0x0 }, // 3941
  { PseudoVLOXSEG8EI8_V_MF4_M1_TU, VLOXSEG8EI8_V, 0x0 }, // 3942
  { PseudoVLOXSEG8EI8_V_MF8_M1, VLOXSEG8EI8_V, 0x0 }, // 3943
  { PseudoVLOXSEG8EI8_V_MF8_M1_MASK, VLOXSEG8EI8_V, 0x0 }, // 3944
  { PseudoVLOXSEG8EI8_V_MF8_M1_TU, VLOXSEG8EI8_V, 0x0 }, // 3945
  { PseudoVLOXSEG8EI8_V_MF8_MF8, VLOXSEG8EI8_V, 0x5 }, // 3946
  { PseudoVLOXSEG8EI8_V_MF8_MF8_MASK, VLOXSEG8EI8_V, 0x5 }, // 3947
  { PseudoVLOXSEG8EI8_V_MF8_MF8_TU, VLOXSEG8EI8_V, 0x5 }, // 3948
  { PseudoVLOXSEG8EI8_V_MF4_MF4, VLOXSEG8EI8_V, 0x6 }, // 3949
  { PseudoVLOXSEG8EI8_V_MF4_MF4_MASK, VLOXSEG8EI8_V, 0x6 }, // 3950
  { PseudoVLOXSEG8EI8_V_MF4_MF4_TU, VLOXSEG8EI8_V, 0x6 }, // 3951
  { PseudoVLOXSEG8EI8_V_MF8_MF4, VLOXSEG8EI8_V, 0x6 }, // 3952
  { PseudoVLOXSEG8EI8_V_MF8_MF4_MASK, VLOXSEG8EI8_V, 0x6 }, // 3953
  { PseudoVLOXSEG8EI8_V_MF8_MF4_TU, VLOXSEG8EI8_V, 0x6 }, // 3954
  { PseudoVLOXSEG8EI8_V_MF2_MF2, VLOXSEG8EI8_V, 0x7 }, // 3955
  { PseudoVLOXSEG8EI8_V_MF2_MF2_MASK, VLOXSEG8EI8_V, 0x7 }, // 3956
  { PseudoVLOXSEG8EI8_V_MF2_MF2_TU, VLOXSEG8EI8_V, 0x7 }, // 3957
  { PseudoVLOXSEG8EI8_V_MF4_MF2, VLOXSEG8EI8_V, 0x7 }, // 3958
  { PseudoVLOXSEG8EI8_V_MF4_MF2_MASK, VLOXSEG8EI8_V, 0x7 }, // 3959
  { PseudoVLOXSEG8EI8_V_MF4_MF2_TU, VLOXSEG8EI8_V, 0x7 }, // 3960
  { PseudoVLOXSEG8EI8_V_MF8_MF2, VLOXSEG8EI8_V, 0x7 }, // 3961
  { PseudoVLOXSEG8EI8_V_MF8_MF2_MASK, VLOXSEG8EI8_V, 0x7 }, // 3962
  { PseudoVLOXSEG8EI8_V_MF8_MF2_TU, VLOXSEG8EI8_V, 0x7 }, // 3963
  { PseudoVLSE16_V_M1, VLSE16_V, 0x0 }, // 3964
  { PseudoVLSE16_V_M1_MASK, VLSE16_V, 0x0 }, // 3965
  { PseudoVLSE16_V_M1_TU, VLSE16_V, 0x0 }, // 3966
  { PseudoVLSE16_V_M2, VLSE16_V, 0x1 }, // 3967
  { PseudoVLSE16_V_M2_MASK, VLSE16_V, 0x1 }, // 3968
  { PseudoVLSE16_V_M2_TU, VLSE16_V, 0x1 }, // 3969
  { PseudoVLSE16_V_M4, VLSE16_V, 0x2 }, // 3970
  { PseudoVLSE16_V_M4_MASK, VLSE16_V, 0x2 }, // 3971
  { PseudoVLSE16_V_M4_TU, VLSE16_V, 0x2 }, // 3972
  { PseudoVLSE16_V_M8, VLSE16_V, 0x3 }, // 3973
  { PseudoVLSE16_V_M8_MASK, VLSE16_V, 0x3 }, // 3974
  { PseudoVLSE16_V_M8_TU, VLSE16_V, 0x3 }, // 3975
  { PseudoVLSE16_V_MF4, VLSE16_V, 0x6 }, // 3976
  { PseudoVLSE16_V_MF4_MASK, VLSE16_V, 0x6 }, // 3977
  { PseudoVLSE16_V_MF4_TU, VLSE16_V, 0x6 }, // 3978
  { PseudoVLSE16_V_MF2, VLSE16_V, 0x7 }, // 3979
  { PseudoVLSE16_V_MF2_MASK, VLSE16_V, 0x7 }, // 3980
  { PseudoVLSE16_V_MF2_TU, VLSE16_V, 0x7 }, // 3981
  { PseudoVLSE32_V_M1, VLSE32_V, 0x0 }, // 3982
  { PseudoVLSE32_V_M1_MASK, VLSE32_V, 0x0 }, // 3983
  { PseudoVLSE32_V_M1_TU, VLSE32_V, 0x0 }, // 3984
  { PseudoVLSE32_V_M2, VLSE32_V, 0x1 }, // 3985
  { PseudoVLSE32_V_M2_MASK, VLSE32_V, 0x1 }, // 3986
  { PseudoVLSE32_V_M2_TU, VLSE32_V, 0x1 }, // 3987
  { PseudoVLSE32_V_M4, VLSE32_V, 0x2 }, // 3988
  { PseudoVLSE32_V_M4_MASK, VLSE32_V, 0x2 }, // 3989
  { PseudoVLSE32_V_M4_TU, VLSE32_V, 0x2 }, // 3990
  { PseudoVLSE32_V_M8, VLSE32_V, 0x3 }, // 3991
  { PseudoVLSE32_V_M8_MASK, VLSE32_V, 0x3 }, // 3992
  { PseudoVLSE32_V_M8_TU, VLSE32_V, 0x3 }, // 3993
  { PseudoVLSE32_V_MF2, VLSE32_V, 0x7 }, // 3994
  { PseudoVLSE32_V_MF2_MASK, VLSE32_V, 0x7 }, // 3995
  { PseudoVLSE32_V_MF2_TU, VLSE32_V, 0x7 }, // 3996
  { PseudoVLSE64_V_M1, VLSE64_V, 0x0 }, // 3997
  { PseudoVLSE64_V_M1_MASK, VLSE64_V, 0x0 }, // 3998
  { PseudoVLSE64_V_M1_TU, VLSE64_V, 0x0 }, // 3999
  { PseudoVLSE64_V_M2, VLSE64_V, 0x1 }, // 4000
  { PseudoVLSE64_V_M2_MASK, VLSE64_V, 0x1 }, // 4001
  { PseudoVLSE64_V_M2_TU, VLSE64_V, 0x1 }, // 4002
  { PseudoVLSE64_V_M4, VLSE64_V, 0x2 }, // 4003
  { PseudoVLSE64_V_M4_MASK, VLSE64_V, 0x2 }, // 4004
  { PseudoVLSE64_V_M4_TU, VLSE64_V, 0x2 }, // 4005
  { PseudoVLSE64_V_M8, VLSE64_V, 0x3 }, // 4006
  { PseudoVLSE64_V_M8_MASK, VLSE64_V, 0x3 }, // 4007
  { PseudoVLSE64_V_M8_TU, VLSE64_V, 0x3 }, // 4008
  { PseudoVLSE8_V_M1, VLSE8_V, 0x0 }, // 4009
  { PseudoVLSE8_V_M1_MASK, VLSE8_V, 0x0 }, // 4010
  { PseudoVLSE8_V_M1_TU, VLSE8_V, 0x0 }, // 4011
  { PseudoVLSE8_V_M2, VLSE8_V, 0x1 }, // 4012
  { PseudoVLSE8_V_M2_MASK, VLSE8_V, 0x1 }, // 4013
  { PseudoVLSE8_V_M2_TU, VLSE8_V, 0x1 }, // 4014
  { PseudoVLSE8_V_M4, VLSE8_V, 0x2 }, // 4015
  { PseudoVLSE8_V_M4_MASK, VLSE8_V, 0x2 }, // 4016
  { PseudoVLSE8_V_M4_TU, VLSE8_V, 0x2 }, // 4017
  { PseudoVLSE8_V_M8, VLSE8_V, 0x3 }, // 4018
  { PseudoVLSE8_V_M8_MASK, VLSE8_V, 0x3 }, // 4019
  { PseudoVLSE8_V_M8_TU, VLSE8_V, 0x3 }, // 4020
  { PseudoVLSE8_V_MF8, VLSE8_V, 0x5 }, // 4021
  { PseudoVLSE8_V_MF8_MASK, VLSE8_V, 0x5 }, // 4022
  { PseudoVLSE8_V_MF8_TU, VLSE8_V, 0x5 }, // 4023
  { PseudoVLSE8_V_MF4, VLSE8_V, 0x6 }, // 4024
  { PseudoVLSE8_V_MF4_MASK, VLSE8_V, 0x6 }, // 4025
  { PseudoVLSE8_V_MF4_TU, VLSE8_V, 0x6 }, // 4026
  { PseudoVLSE8_V_MF2, VLSE8_V, 0x7 }, // 4027
  { PseudoVLSE8_V_MF2_MASK, VLSE8_V, 0x7 }, // 4028
  { PseudoVLSE8_V_MF2_TU, VLSE8_V, 0x7 }, // 4029
  { PseudoVLSEG2E16FF_V_M1, VLSEG2E16FF_V, 0x0 }, // 4030
  { PseudoVLSEG2E16FF_V_M1_MASK, VLSEG2E16FF_V, 0x0 }, // 4031
  { PseudoVLSEG2E16FF_V_M1_TU, VLSEG2E16FF_V, 0x0 }, // 4032
  { PseudoVLSEG2E16FF_V_M2, VLSEG2E16FF_V, 0x1 }, // 4033
  { PseudoVLSEG2E16FF_V_M2_MASK, VLSEG2E16FF_V, 0x1 }, // 4034
  { PseudoVLSEG2E16FF_V_M2_TU, VLSEG2E16FF_V, 0x1 }, // 4035
  { PseudoVLSEG2E16FF_V_M4, VLSEG2E16FF_V, 0x2 }, // 4036
  { PseudoVLSEG2E16FF_V_M4_MASK, VLSEG2E16FF_V, 0x2 }, // 4037
  { PseudoVLSEG2E16FF_V_M4_TU, VLSEG2E16FF_V, 0x2 }, // 4038
  { PseudoVLSEG2E16FF_V_MF4, VLSEG2E16FF_V, 0x6 }, // 4039
  { PseudoVLSEG2E16FF_V_MF4_MASK, VLSEG2E16FF_V, 0x6 }, // 4040
  { PseudoVLSEG2E16FF_V_MF4_TU, VLSEG2E16FF_V, 0x6 }, // 4041
  { PseudoVLSEG2E16FF_V_MF2, VLSEG2E16FF_V, 0x7 }, // 4042
  { PseudoVLSEG2E16FF_V_MF2_MASK, VLSEG2E16FF_V, 0x7 }, // 4043
  { PseudoVLSEG2E16FF_V_MF2_TU, VLSEG2E16FF_V, 0x7 }, // 4044
  { PseudoVLSEG2E16_V_M1, VLSEG2E16_V, 0x0 }, // 4045
  { PseudoVLSEG2E16_V_M1_MASK, VLSEG2E16_V, 0x0 }, // 4046
  { PseudoVLSEG2E16_V_M1_TU, VLSEG2E16_V, 0x0 }, // 4047
  { PseudoVLSEG2E16_V_M2, VLSEG2E16_V, 0x1 }, // 4048
  { PseudoVLSEG2E16_V_M2_MASK, VLSEG2E16_V, 0x1 }, // 4049
  { PseudoVLSEG2E16_V_M2_TU, VLSEG2E16_V, 0x1 }, // 4050
  { PseudoVLSEG2E16_V_M4, VLSEG2E16_V, 0x2 }, // 4051
  { PseudoVLSEG2E16_V_M4_MASK, VLSEG2E16_V, 0x2 }, // 4052
  { PseudoVLSEG2E16_V_M4_TU, VLSEG2E16_V, 0x2 }, // 4053
  { PseudoVLSEG2E16_V_MF4, VLSEG2E16_V, 0x6 }, // 4054
  { PseudoVLSEG2E16_V_MF4_MASK, VLSEG2E16_V, 0x6 }, // 4055
  { PseudoVLSEG2E16_V_MF4_TU, VLSEG2E16_V, 0x6 }, // 4056
  { PseudoVLSEG2E16_V_MF2, VLSEG2E16_V, 0x7 }, // 4057
  { PseudoVLSEG2E16_V_MF2_MASK, VLSEG2E16_V, 0x7 }, // 4058
  { PseudoVLSEG2E16_V_MF2_TU, VLSEG2E16_V, 0x7 }, // 4059
  { PseudoVLSEG2E32FF_V_M1, VLSEG2E32FF_V, 0x0 }, // 4060
  { PseudoVLSEG2E32FF_V_M1_MASK, VLSEG2E32FF_V, 0x0 }, // 4061
  { PseudoVLSEG2E32FF_V_M1_TU, VLSEG2E32FF_V, 0x0 }, // 4062
  { PseudoVLSEG2E32FF_V_M2, VLSEG2E32FF_V, 0x1 }, // 4063
  { PseudoVLSEG2E32FF_V_M2_MASK, VLSEG2E32FF_V, 0x1 }, // 4064
  { PseudoVLSEG2E32FF_V_M2_TU, VLSEG2E32FF_V, 0x1 }, // 4065
  { PseudoVLSEG2E32FF_V_M4, VLSEG2E32FF_V, 0x2 }, // 4066
  { PseudoVLSEG2E32FF_V_M4_MASK, VLSEG2E32FF_V, 0x2 }, // 4067
  { PseudoVLSEG2E32FF_V_M4_TU, VLSEG2E32FF_V, 0x2 }, // 4068
  { PseudoVLSEG2E32FF_V_MF2, VLSEG2E32FF_V, 0x7 }, // 4069
  { PseudoVLSEG2E32FF_V_MF2_MASK, VLSEG2E32FF_V, 0x7 }, // 4070
  { PseudoVLSEG2E32FF_V_MF2_TU, VLSEG2E32FF_V, 0x7 }, // 4071
  { PseudoVLSEG2E32_V_M1, VLSEG2E32_V, 0x0 }, // 4072
  { PseudoVLSEG2E32_V_M1_MASK, VLSEG2E32_V, 0x0 }, // 4073
  { PseudoVLSEG2E32_V_M1_TU, VLSEG2E32_V, 0x0 }, // 4074
  { PseudoVLSEG2E32_V_M2, VLSEG2E32_V, 0x1 }, // 4075
  { PseudoVLSEG2E32_V_M2_MASK, VLSEG2E32_V, 0x1 }, // 4076
  { PseudoVLSEG2E32_V_M2_TU, VLSEG2E32_V, 0x1 }, // 4077
  { PseudoVLSEG2E32_V_M4, VLSEG2E32_V, 0x2 }, // 4078
  { PseudoVLSEG2E32_V_M4_MASK, VLSEG2E32_V, 0x2 }, // 4079
  { PseudoVLSEG2E32_V_M4_TU, VLSEG2E32_V, 0x2 }, // 4080
  { PseudoVLSEG2E32_V_MF2, VLSEG2E32_V, 0x7 }, // 4081
  { PseudoVLSEG2E32_V_MF2_MASK, VLSEG2E32_V, 0x7 }, // 4082
  { PseudoVLSEG2E32_V_MF2_TU, VLSEG2E32_V, 0x7 }, // 4083
  { PseudoVLSEG2E64FF_V_M1, VLSEG2E64FF_V, 0x0 }, // 4084
  { PseudoVLSEG2E64FF_V_M1_MASK, VLSEG2E64FF_V, 0x0 }, // 4085
  { PseudoVLSEG2E64FF_V_M1_TU, VLSEG2E64FF_V, 0x0 }, // 4086
  { PseudoVLSEG2E64FF_V_M2, VLSEG2E64FF_V, 0x1 }, // 4087
  { PseudoVLSEG2E64FF_V_M2_MASK, VLSEG2E64FF_V, 0x1 }, // 4088
  { PseudoVLSEG2E64FF_V_M2_TU, VLSEG2E64FF_V, 0x1 }, // 4089
  { PseudoVLSEG2E64FF_V_M4, VLSEG2E64FF_V, 0x2 }, // 4090
  { PseudoVLSEG2E64FF_V_M4_MASK, VLSEG2E64FF_V, 0x2 }, // 4091
  { PseudoVLSEG2E64FF_V_M4_TU, VLSEG2E64FF_V, 0x2 }, // 4092
  { PseudoVLSEG2E64_V_M1, VLSEG2E64_V, 0x0 }, // 4093
  { PseudoVLSEG2E64_V_M1_MASK, VLSEG2E64_V, 0x0 }, // 4094
  { PseudoVLSEG2E64_V_M1_TU, VLSEG2E64_V, 0x0 }, // 4095
  { PseudoVLSEG2E64_V_M2, VLSEG2E64_V, 0x1 }, // 4096
  { PseudoVLSEG2E64_V_M2_MASK, VLSEG2E64_V, 0x1 }, // 4097
  { PseudoVLSEG2E64_V_M2_TU, VLSEG2E64_V, 0x1 }, // 4098
  { PseudoVLSEG2E64_V_M4, VLSEG2E64_V, 0x2 }, // 4099
  { PseudoVLSEG2E64_V_M4_MASK, VLSEG2E64_V, 0x2 }, // 4100
  { PseudoVLSEG2E64_V_M4_TU, VLSEG2E64_V, 0x2 }, // 4101
  { PseudoVLSEG2E8FF_V_M1, VLSEG2E8FF_V, 0x0 }, // 4102
  { PseudoVLSEG2E8FF_V_M1_MASK, VLSEG2E8FF_V, 0x0 }, // 4103
  { PseudoVLSEG2E8FF_V_M1_TU, VLSEG2E8FF_V, 0x0 }, // 4104
  { PseudoVLSEG2E8FF_V_M2, VLSEG2E8FF_V, 0x1 }, // 4105
  { PseudoVLSEG2E8FF_V_M2_MASK, VLSEG2E8FF_V, 0x1 }, // 4106
  { PseudoVLSEG2E8FF_V_M2_TU, VLSEG2E8FF_V, 0x1 }, // 4107
  { PseudoVLSEG2E8FF_V_M4, VLSEG2E8FF_V, 0x2 }, // 4108
  { PseudoVLSEG2E8FF_V_M4_MASK, VLSEG2E8FF_V, 0x2 }, // 4109
  { PseudoVLSEG2E8FF_V_M4_TU, VLSEG2E8FF_V, 0x2 }, // 4110
  { PseudoVLSEG2E8FF_V_MF8, VLSEG2E8FF_V, 0x5 }, // 4111
  { PseudoVLSEG2E8FF_V_MF8_MASK, VLSEG2E8FF_V, 0x5 }, // 4112
  { PseudoVLSEG2E8FF_V_MF8_TU, VLSEG2E8FF_V, 0x5 }, // 4113
  { PseudoVLSEG2E8FF_V_MF4, VLSEG2E8FF_V, 0x6 }, // 4114
  { PseudoVLSEG2E8FF_V_MF4_MASK, VLSEG2E8FF_V, 0x6 }, // 4115
  { PseudoVLSEG2E8FF_V_MF4_TU, VLSEG2E8FF_V, 0x6 }, // 4116
  { PseudoVLSEG2E8FF_V_MF2, VLSEG2E8FF_V, 0x7 }, // 4117
  { PseudoVLSEG2E8FF_V_MF2_MASK, VLSEG2E8FF_V, 0x7 }, // 4118
  { PseudoVLSEG2E8FF_V_MF2_TU, VLSEG2E8FF_V, 0x7 }, // 4119
  { PseudoVLSEG2E8_V_M1, VLSEG2E8_V, 0x0 }, // 4120
  { PseudoVLSEG2E8_V_M1_MASK, VLSEG2E8_V, 0x0 }, // 4121
  { PseudoVLSEG2E8_V_M1_TU, VLSEG2E8_V, 0x0 }, // 4122
  { PseudoVLSEG2E8_V_M2, VLSEG2E8_V, 0x1 }, // 4123
  { PseudoVLSEG2E8_V_M2_MASK, VLSEG2E8_V, 0x1 }, // 4124
  { PseudoVLSEG2E8_V_M2_TU, VLSEG2E8_V, 0x1 }, // 4125
  { PseudoVLSEG2E8_V_M4, VLSEG2E8_V, 0x2 }, // 4126
  { PseudoVLSEG2E8_V_M4_MASK, VLSEG2E8_V, 0x2 }, // 4127
  { PseudoVLSEG2E8_V_M4_TU, VLSEG2E8_V, 0x2 }, // 4128
  { PseudoVLSEG2E8_V_MF8, VLSEG2E8_V, 0x5 }, // 4129
  { PseudoVLSEG2E8_V_MF8_MASK, VLSEG2E8_V, 0x5 }, // 4130
  { PseudoVLSEG2E8_V_MF8_TU, VLSEG2E8_V, 0x5 }, // 4131
  { PseudoVLSEG2E8_V_MF4, VLSEG2E8_V, 0x6 }, // 4132
  { PseudoVLSEG2E8_V_MF4_MASK, VLSEG2E8_V, 0x6 }, // 4133
  { PseudoVLSEG2E8_V_MF4_TU, VLSEG2E8_V, 0x6 }, // 4134
  { PseudoVLSEG2E8_V_MF2, VLSEG2E8_V, 0x7 }, // 4135
  { PseudoVLSEG2E8_V_MF2_MASK, VLSEG2E8_V, 0x7 }, // 4136
  { PseudoVLSEG2E8_V_MF2_TU, VLSEG2E8_V, 0x7 }, // 4137
  { PseudoVLSEG3E16FF_V_M1, VLSEG3E16FF_V, 0x0 }, // 4138
  { PseudoVLSEG3E16FF_V_M1_MASK, VLSEG3E16FF_V, 0x0 }, // 4139
  { PseudoVLSEG3E16FF_V_M1_TU, VLSEG3E16FF_V, 0x0 }, // 4140
  { PseudoVLSEG3E16FF_V_M2, VLSEG3E16FF_V, 0x1 }, // 4141
  { PseudoVLSEG3E16FF_V_M2_MASK, VLSEG3E16FF_V, 0x1 }, // 4142
  { PseudoVLSEG3E16FF_V_M2_TU, VLSEG3E16FF_V, 0x1 }, // 4143
  { PseudoVLSEG3E16FF_V_MF4, VLSEG3E16FF_V, 0x6 }, // 4144
  { PseudoVLSEG3E16FF_V_MF4_MASK, VLSEG3E16FF_V, 0x6 }, // 4145
  { PseudoVLSEG3E16FF_V_MF4_TU, VLSEG3E16FF_V, 0x6 }, // 4146
  { PseudoVLSEG3E16FF_V_MF2, VLSEG3E16FF_V, 0x7 }, // 4147
  { PseudoVLSEG3E16FF_V_MF2_MASK, VLSEG3E16FF_V, 0x7 }, // 4148
  { PseudoVLSEG3E16FF_V_MF2_TU, VLSEG3E16FF_V, 0x7 }, // 4149
  { PseudoVLSEG3E16_V_M1, VLSEG3E16_V, 0x0 }, // 4150
  { PseudoVLSEG3E16_V_M1_MASK, VLSEG3E16_V, 0x0 }, // 4151
  { PseudoVLSEG3E16_V_M1_TU, VLSEG3E16_V, 0x0 }, // 4152
  { PseudoVLSEG3E16_V_M2, VLSEG3E16_V, 0x1 }, // 4153
  { PseudoVLSEG3E16_V_M2_MASK, VLSEG3E16_V, 0x1 }, // 4154
  { PseudoVLSEG3E16_V_M2_TU, VLSEG3E16_V, 0x1 }, // 4155
  { PseudoVLSEG3E16_V_MF4, VLSEG3E16_V, 0x6 }, // 4156
  { PseudoVLSEG3E16_V_MF4_MASK, VLSEG3E16_V, 0x6 }, // 4157
  { PseudoVLSEG3E16_V_MF4_TU, VLSEG3E16_V, 0x6 }, // 4158
  { PseudoVLSEG3E16_V_MF2, VLSEG3E16_V, 0x7 }, // 4159
  { PseudoVLSEG3E16_V_MF2_MASK, VLSEG3E16_V, 0x7 }, // 4160
  { PseudoVLSEG3E16_V_MF2_TU, VLSEG3E16_V, 0x7 }, // 4161
  { PseudoVLSEG3E32FF_V_M1, VLSEG3E32FF_V, 0x0 }, // 4162
  { PseudoVLSEG3E32FF_V_M1_MASK, VLSEG3E32FF_V, 0x0 }, // 4163
  { PseudoVLSEG3E32FF_V_M1_TU, VLSEG3E32FF_V, 0x0 }, // 4164
  { PseudoVLSEG3E32FF_V_M2, VLSEG3E32FF_V, 0x1 }, // 4165
  { PseudoVLSEG3E32FF_V_M2_MASK, VLSEG3E32FF_V, 0x1 }, // 4166
  { PseudoVLSEG3E32FF_V_M2_TU, VLSEG3E32FF_V, 0x1 }, // 4167
  { PseudoVLSEG3E32FF_V_MF2, VLSEG3E32FF_V, 0x7 }, // 4168
  { PseudoVLSEG3E32FF_V_MF2_MASK, VLSEG3E32FF_V, 0x7 }, // 4169
  { PseudoVLSEG3E32FF_V_MF2_TU, VLSEG3E32FF_V, 0x7 }, // 4170
  { PseudoVLSEG3E32_V_M1, VLSEG3E32_V, 0x0 }, // 4171
  { PseudoVLSEG3E32_V_M1_MASK, VLSEG3E32_V, 0x0 }, // 4172
  { PseudoVLSEG3E32_V_M1_TU, VLSEG3E32_V, 0x0 }, // 4173
  { PseudoVLSEG3E32_V_M2, VLSEG3E32_V, 0x1 }, // 4174
  { PseudoVLSEG3E32_V_M2_MASK, VLSEG3E32_V, 0x1 }, // 4175
  { PseudoVLSEG3E32_V_M2_TU, VLSEG3E32_V, 0x1 }, // 4176
  { PseudoVLSEG3E32_V_MF2, VLSEG3E32_V, 0x7 }, // 4177
  { PseudoVLSEG3E32_V_MF2_MASK, VLSEG3E32_V, 0x7 }, // 4178
  { PseudoVLSEG3E32_V_MF2_TU, VLSEG3E32_V, 0x7 }, // 4179
  { PseudoVLSEG3E64FF_V_M1, VLSEG3E64FF_V, 0x0 }, // 4180
  { PseudoVLSEG3E64FF_V_M1_MASK, VLSEG3E64FF_V, 0x0 }, // 4181
  { PseudoVLSEG3E64FF_V_M1_TU, VLSEG3E64FF_V, 0x0 }, // 4182
  { PseudoVLSEG3E64FF_V_M2, VLSEG3E64FF_V, 0x1 }, // 4183
  { PseudoVLSEG3E64FF_V_M2_MASK, VLSEG3E64FF_V, 0x1 }, // 4184
  { PseudoVLSEG3E64FF_V_M2_TU, VLSEG3E64FF_V, 0x1 }, // 4185
  { PseudoVLSEG3E64_V_M1, VLSEG3E64_V, 0x0 }, // 4186
  { PseudoVLSEG3E64_V_M1_MASK, VLSEG3E64_V, 0x0 }, // 4187
  { PseudoVLSEG3E64_V_M1_TU, VLSEG3E64_V, 0x0 }, // 4188
  { PseudoVLSEG3E64_V_M2, VLSEG3E64_V, 0x1 }, // 4189
  { PseudoVLSEG3E64_V_M2_MASK, VLSEG3E64_V, 0x1 }, // 4190
  { PseudoVLSEG3E64_V_M2_TU, VLSEG3E64_V, 0x1 }, // 4191
  { PseudoVLSEG3E8FF_V_M1, VLSEG3E8FF_V, 0x0 }, // 4192
  { PseudoVLSEG3E8FF_V_M1_MASK, VLSEG3E8FF_V, 0x0 }, // 4193
  { PseudoVLSEG3E8FF_V_M1_TU, VLSEG3E8FF_V, 0x0 }, // 4194
  { PseudoVLSEG3E8FF_V_M2, VLSEG3E8FF_V, 0x1 }, // 4195
  { PseudoVLSEG3E8FF_V_M2_MASK, VLSEG3E8FF_V, 0x1 }, // 4196
  { PseudoVLSEG3E8FF_V_M2_TU, VLSEG3E8FF_V, 0x1 }, // 4197
  { PseudoVLSEG3E8FF_V_MF8, VLSEG3E8FF_V, 0x5 }, // 4198
  { PseudoVLSEG3E8FF_V_MF8_MASK, VLSEG3E8FF_V, 0x5 }, // 4199
  { PseudoVLSEG3E8FF_V_MF8_TU, VLSEG3E8FF_V, 0x5 }, // 4200
  { PseudoVLSEG3E8FF_V_MF4, VLSEG3E8FF_V, 0x6 }, // 4201
  { PseudoVLSEG3E8FF_V_MF4_MASK, VLSEG3E8FF_V, 0x6 }, // 4202
  { PseudoVLSEG3E8FF_V_MF4_TU, VLSEG3E8FF_V, 0x6 }, // 4203
  { PseudoVLSEG3E8FF_V_MF2, VLSEG3E8FF_V, 0x7 }, // 4204
  { PseudoVLSEG3E8FF_V_MF2_MASK, VLSEG3E8FF_V, 0x7 }, // 4205
  { PseudoVLSEG3E8FF_V_MF2_TU, VLSEG3E8FF_V, 0x7 }, // 4206
  { PseudoVLSEG3E8_V_M1, VLSEG3E8_V, 0x0 }, // 4207
  { PseudoVLSEG3E8_V_M1_MASK, VLSEG3E8_V, 0x0 }, // 4208
  { PseudoVLSEG3E8_V_M1_TU, VLSEG3E8_V, 0x0 }, // 4209
  { PseudoVLSEG3E8_V_M2, VLSEG3E8_V, 0x1 }, // 4210
  { PseudoVLSEG3E8_V_M2_MASK, VLSEG3E8_V, 0x1 }, // 4211
  { PseudoVLSEG3E8_V_M2_TU, VLSEG3E8_V, 0x1 }, // 4212
  { PseudoVLSEG3E8_V_MF8, VLSEG3E8_V, 0x5 }, // 4213
  { PseudoVLSEG3E8_V_MF8_MASK, VLSEG3E8_V, 0x5 }, // 4214
  { PseudoVLSEG3E8_V_MF8_TU, VLSEG3E8_V, 0x5 }, // 4215
  { PseudoVLSEG3E8_V_MF4, VLSEG3E8_V, 0x6 }, // 4216
  { PseudoVLSEG3E8_V_MF4_MASK, VLSEG3E8_V, 0x6 }, // 4217
  { PseudoVLSEG3E8_V_MF4_TU, VLSEG3E8_V, 0x6 }, // 4218
  { PseudoVLSEG3E8_V_MF2, VLSEG3E8_V, 0x7 }, // 4219
  { PseudoVLSEG3E8_V_MF2_MASK, VLSEG3E8_V, 0x7 }, // 4220
  { PseudoVLSEG3E8_V_MF2_TU, VLSEG3E8_V, 0x7 }, // 4221
  { PseudoVLSEG4E16FF_V_M1, VLSEG4E16FF_V, 0x0 }, // 4222
  { PseudoVLSEG4E16FF_V_M1_MASK, VLSEG4E16FF_V, 0x0 }, // 4223
  { PseudoVLSEG4E16FF_V_M1_TU, VLSEG4E16FF_V, 0x0 }, // 4224
  { PseudoVLSEG4E16FF_V_M2, VLSEG4E16FF_V, 0x1 }, // 4225
  { PseudoVLSEG4E16FF_V_M2_MASK, VLSEG4E16FF_V, 0x1 }, // 4226
  { PseudoVLSEG4E16FF_V_M2_TU, VLSEG4E16FF_V, 0x1 }, // 4227
  { PseudoVLSEG4E16FF_V_MF4, VLSEG4E16FF_V, 0x6 }, // 4228
  { PseudoVLSEG4E16FF_V_MF4_MASK, VLSEG4E16FF_V, 0x6 }, // 4229
  { PseudoVLSEG4E16FF_V_MF4_TU, VLSEG4E16FF_V, 0x6 }, // 4230
  { PseudoVLSEG4E16FF_V_MF2, VLSEG4E16FF_V, 0x7 }, // 4231
  { PseudoVLSEG4E16FF_V_MF2_MASK, VLSEG4E16FF_V, 0x7 }, // 4232
  { PseudoVLSEG4E16FF_V_MF2_TU, VLSEG4E16FF_V, 0x7 }, // 4233
  { PseudoVLSEG4E16_V_M1, VLSEG4E16_V, 0x0 }, // 4234
  { PseudoVLSEG4E16_V_M1_MASK, VLSEG4E16_V, 0x0 }, // 4235
  { PseudoVLSEG4E16_V_M1_TU, VLSEG4E16_V, 0x0 }, // 4236
  { PseudoVLSEG4E16_V_M2, VLSEG4E16_V, 0x1 }, // 4237
  { PseudoVLSEG4E16_V_M2_MASK, VLSEG4E16_V, 0x1 }, // 4238
  { PseudoVLSEG4E16_V_M2_TU, VLSEG4E16_V, 0x1 }, // 4239
  { PseudoVLSEG4E16_V_MF4, VLSEG4E16_V, 0x6 }, // 4240
  { PseudoVLSEG4E16_V_MF4_MASK, VLSEG4E16_V, 0x6 }, // 4241
  { PseudoVLSEG4E16_V_MF4_TU, VLSEG4E16_V, 0x6 }, // 4242
  { PseudoVLSEG4E16_V_MF2, VLSEG4E16_V, 0x7 }, // 4243
  { PseudoVLSEG4E16_V_MF2_MASK, VLSEG4E16_V, 0x7 }, // 4244
  { PseudoVLSEG4E16_V_MF2_TU, VLSEG4E16_V, 0x7 }, // 4245
  { PseudoVLSEG4E32FF_V_M1, VLSEG4E32FF_V, 0x0 }, // 4246
  { PseudoVLSEG4E32FF_V_M1_MASK, VLSEG4E32FF_V, 0x0 }, // 4247
  { PseudoVLSEG4E32FF_V_M1_TU, VLSEG4E32FF_V, 0x0 }, // 4248
  { PseudoVLSEG4E32FF_V_M2, VLSEG4E32FF_V, 0x1 }, // 4249
  { PseudoVLSEG4E32FF_V_M2_MASK, VLSEG4E32FF_V, 0x1 }, // 4250
  { PseudoVLSEG4E32FF_V_M2_TU, VLSEG4E32FF_V, 0x1 }, // 4251
  { PseudoVLSEG4E32FF_V_MF2, VLSEG4E32FF_V, 0x7 }, // 4252
  { PseudoVLSEG4E32FF_V_MF2_MASK, VLSEG4E32FF_V, 0x7 }, // 4253
  { PseudoVLSEG4E32FF_V_MF2_TU, VLSEG4E32FF_V, 0x7 }, // 4254
  { PseudoVLSEG4E32_V_M1, VLSEG4E32_V, 0x0 }, // 4255
  { PseudoVLSEG4E32_V_M1_MASK, VLSEG4E32_V, 0x0 }, // 4256
  { PseudoVLSEG4E32_V_M1_TU, VLSEG4E32_V, 0x0 }, // 4257
  { PseudoVLSEG4E32_V_M2, VLSEG4E32_V, 0x1 }, // 4258
  { PseudoVLSEG4E32_V_M2_MASK, VLSEG4E32_V, 0x1 }, // 4259
  { PseudoVLSEG4E32_V_M2_TU, VLSEG4E32_V, 0x1 }, // 4260
  { PseudoVLSEG4E32_V_MF2, VLSEG4E32_V, 0x7 }, // 4261
  { PseudoVLSEG4E32_V_MF2_MASK, VLSEG4E32_V, 0x7 }, // 4262
  { PseudoVLSEG4E32_V_MF2_TU, VLSEG4E32_V, 0x7 }, // 4263
  { PseudoVLSEG4E64FF_V_M1, VLSEG4E64FF_V, 0x0 }, // 4264
  { PseudoVLSEG4E64FF_V_M1_MASK, VLSEG4E64FF_V, 0x0 }, // 4265
  { PseudoVLSEG4E64FF_V_M1_TU, VLSEG4E64FF_V, 0x0 }, // 4266
  { PseudoVLSEG4E64FF_V_M2, VLSEG4E64FF_V, 0x1 }, // 4267
  { PseudoVLSEG4E64FF_V_M2_MASK, VLSEG4E64FF_V, 0x1 }, // 4268
  { PseudoVLSEG4E64FF_V_M2_TU, VLSEG4E64FF_V, 0x1 }, // 4269
  { PseudoVLSEG4E64_V_M1, VLSEG4E64_V, 0x0 }, // 4270
  { PseudoVLSEG4E64_V_M1_MASK, VLSEG4E64_V, 0x0 }, // 4271
  { PseudoVLSEG4E64_V_M1_TU, VLSEG4E64_V, 0x0 }, // 4272
  { PseudoVLSEG4E64_V_M2, VLSEG4E64_V, 0x1 }, // 4273
  { PseudoVLSEG4E64_V_M2_MASK, VLSEG4E64_V, 0x1 }, // 4274
  { PseudoVLSEG4E64_V_M2_TU, VLSEG4E64_V, 0x1 }, // 4275
  { PseudoVLSEG4E8FF_V_M1, VLSEG4E8FF_V, 0x0 }, // 4276
  { PseudoVLSEG4E8FF_V_M1_MASK, VLSEG4E8FF_V, 0x0 }, // 4277
  { PseudoVLSEG4E8FF_V_M1_TU, VLSEG4E8FF_V, 0x0 }, // 4278
  { PseudoVLSEG4E8FF_V_M2, VLSEG4E8FF_V, 0x1 }, // 4279
  { PseudoVLSEG4E8FF_V_M2_MASK, VLSEG4E8FF_V, 0x1 }, // 4280
  { PseudoVLSEG4E8FF_V_M2_TU, VLSEG4E8FF_V, 0x1 }, // 4281
  { PseudoVLSEG4E8FF_V_MF8, VLSEG4E8FF_V, 0x5 }, // 4282
  { PseudoVLSEG4E8FF_V_MF8_MASK, VLSEG4E8FF_V, 0x5 }, // 4283
  { PseudoVLSEG4E8FF_V_MF8_TU, VLSEG4E8FF_V, 0x5 }, // 4284
  { PseudoVLSEG4E8FF_V_MF4, VLSEG4E8FF_V, 0x6 }, // 4285
  { PseudoVLSEG4E8FF_V_MF4_MASK, VLSEG4E8FF_V, 0x6 }, // 4286
  { PseudoVLSEG4E8FF_V_MF4_TU, VLSEG4E8FF_V, 0x6 }, // 4287
  { PseudoVLSEG4E8FF_V_MF2, VLSEG4E8FF_V, 0x7 }, // 4288
  { PseudoVLSEG4E8FF_V_MF2_MASK, VLSEG4E8FF_V, 0x7 }, // 4289
  { PseudoVLSEG4E8FF_V_MF2_TU, VLSEG4E8FF_V, 0x7 }, // 4290
  { PseudoVLSEG4E8_V_M1, VLSEG4E8_V, 0x0 }, // 4291
  { PseudoVLSEG4E8_V_M1_MASK, VLSEG4E8_V, 0x0 }, // 4292
  { PseudoVLSEG4E8_V_M1_TU, VLSEG4E8_V, 0x0 }, // 4293
  { PseudoVLSEG4E8_V_M2, VLSEG4E8_V, 0x1 }, // 4294
  { PseudoVLSEG4E8_V_M2_MASK, VLSEG4E8_V, 0x1 }, // 4295
  { PseudoVLSEG4E8_V_M2_TU, VLSEG4E8_V, 0x1 }, // 4296
  { PseudoVLSEG4E8_V_MF8, VLSEG4E8_V, 0x5 }, // 4297
  { PseudoVLSEG4E8_V_MF8_MASK, VLSEG4E8_V, 0x5 }, // 4298
  { PseudoVLSEG4E8_V_MF8_TU, VLSEG4E8_V, 0x5 }, // 4299
  { PseudoVLSEG4E8_V_MF4, VLSEG4E8_V, 0x6 }, // 4300
  { PseudoVLSEG4E8_V_MF4_MASK, VLSEG4E8_V, 0x6 }, // 4301
  { PseudoVLSEG4E8_V_MF4_TU, VLSEG4E8_V, 0x6 }, // 4302
  { PseudoVLSEG4E8_V_MF2, VLSEG4E8_V, 0x7 }, // 4303
  { PseudoVLSEG4E8_V_MF2_MASK, VLSEG4E8_V, 0x7 }, // 4304
  { PseudoVLSEG4E8_V_MF2_TU, VLSEG4E8_V, 0x7 }, // 4305
  { PseudoVLSEG5E16FF_V_M1, VLSEG5E16FF_V, 0x0 }, // 4306
  { PseudoVLSEG5E16FF_V_M1_MASK, VLSEG5E16FF_V, 0x0 }, // 4307
  { PseudoVLSEG5E16FF_V_M1_TU, VLSEG5E16FF_V, 0x0 }, // 4308
  { PseudoVLSEG5E16FF_V_MF4, VLSEG5E16FF_V, 0x6 }, // 4309
  { PseudoVLSEG5E16FF_V_MF4_MASK, VLSEG5E16FF_V, 0x6 }, // 4310
  { PseudoVLSEG5E16FF_V_MF4_TU, VLSEG5E16FF_V, 0x6 }, // 4311
  { PseudoVLSEG5E16FF_V_MF2, VLSEG5E16FF_V, 0x7 }, // 4312
  { PseudoVLSEG5E16FF_V_MF2_MASK, VLSEG5E16FF_V, 0x7 }, // 4313
  { PseudoVLSEG5E16FF_V_MF2_TU, VLSEG5E16FF_V, 0x7 }, // 4314
  { PseudoVLSEG5E16_V_M1, VLSEG5E16_V, 0x0 }, // 4315
  { PseudoVLSEG5E16_V_M1_MASK, VLSEG5E16_V, 0x0 }, // 4316
  { PseudoVLSEG5E16_V_M1_TU, VLSEG5E16_V, 0x0 }, // 4317
  { PseudoVLSEG5E16_V_MF4, VLSEG5E16_V, 0x6 }, // 4318
  { PseudoVLSEG5E16_V_MF4_MASK, VLSEG5E16_V, 0x6 }, // 4319
  { PseudoVLSEG5E16_V_MF4_TU, VLSEG5E16_V, 0x6 }, // 4320
  { PseudoVLSEG5E16_V_MF2, VLSEG5E16_V, 0x7 }, // 4321
  { PseudoVLSEG5E16_V_MF2_MASK, VLSEG5E16_V, 0x7 }, // 4322
  { PseudoVLSEG5E16_V_MF2_TU, VLSEG5E16_V, 0x7 }, // 4323
  { PseudoVLSEG5E32FF_V_M1, VLSEG5E32FF_V, 0x0 }, // 4324
  { PseudoVLSEG5E32FF_V_M1_MASK, VLSEG5E32FF_V, 0x0 }, // 4325
  { PseudoVLSEG5E32FF_V_M1_TU, VLSEG5E32FF_V, 0x0 }, // 4326
  { PseudoVLSEG5E32FF_V_MF2, VLSEG5E32FF_V, 0x7 }, // 4327
  { PseudoVLSEG5E32FF_V_MF2_MASK, VLSEG5E32FF_V, 0x7 }, // 4328
  { PseudoVLSEG5E32FF_V_MF2_TU, VLSEG5E32FF_V, 0x7 }, // 4329
  { PseudoVLSEG5E32_V_M1, VLSEG5E32_V, 0x0 }, // 4330
  { PseudoVLSEG5E32_V_M1_MASK, VLSEG5E32_V, 0x0 }, // 4331
  { PseudoVLSEG5E32_V_M1_TU, VLSEG5E32_V, 0x0 }, // 4332
  { PseudoVLSEG5E32_V_MF2, VLSEG5E32_V, 0x7 }, // 4333
  { PseudoVLSEG5E32_V_MF2_MASK, VLSEG5E32_V, 0x7 }, // 4334
  { PseudoVLSEG5E32_V_MF2_TU, VLSEG5E32_V, 0x7 }, // 4335
  { PseudoVLSEG5E64FF_V_M1, VLSEG5E64FF_V, 0x0 }, // 4336
  { PseudoVLSEG5E64FF_V_M1_MASK, VLSEG5E64FF_V, 0x0 }, // 4337
  { PseudoVLSEG5E64FF_V_M1_TU, VLSEG5E64FF_V, 0x0 }, // 4338
  { PseudoVLSEG5E64_V_M1, VLSEG5E64_V, 0x0 }, // 4339
  { PseudoVLSEG5E64_V_M1_MASK, VLSEG5E64_V, 0x0 }, // 4340
  { PseudoVLSEG5E64_V_M1_TU, VLSEG5E64_V, 0x0 }, // 4341
  { PseudoVLSEG5E8FF_V_M1, VLSEG5E8FF_V, 0x0 }, // 4342
  { PseudoVLSEG5E8FF_V_M1_MASK, VLSEG5E8FF_V, 0x0 }, // 4343
  { PseudoVLSEG5E8FF_V_M1_TU, VLSEG5E8FF_V, 0x0 }, // 4344
  { PseudoVLSEG5E8FF_V_MF8, VLSEG5E8FF_V, 0x5 }, // 4345
  { PseudoVLSEG5E8FF_V_MF8_MASK, VLSEG5E8FF_V, 0x5 }, // 4346
  { PseudoVLSEG5E8FF_V_MF8_TU, VLSEG5E8FF_V, 0x5 }, // 4347
  { PseudoVLSEG5E8FF_V_MF4, VLSEG5E8FF_V, 0x6 }, // 4348
  { PseudoVLSEG5E8FF_V_MF4_MASK, VLSEG5E8FF_V, 0x6 }, // 4349
  { PseudoVLSEG5E8FF_V_MF4_TU, VLSEG5E8FF_V, 0x6 }, // 4350
  { PseudoVLSEG5E8FF_V_MF2, VLSEG5E8FF_V, 0x7 }, // 4351
  { PseudoVLSEG5E8FF_V_MF2_MASK, VLSEG5E8FF_V, 0x7 }, // 4352
  { PseudoVLSEG5E8FF_V_MF2_TU, VLSEG5E8FF_V, 0x7 }, // 4353
  { PseudoVLSEG5E8_V_M1, VLSEG5E8_V, 0x0 }, // 4354
  { PseudoVLSEG5E8_V_M1_MASK, VLSEG5E8_V, 0x0 }, // 4355
  { PseudoVLSEG5E8_V_M1_TU, VLSEG5E8_V, 0x0 }, // 4356
  { PseudoVLSEG5E8_V_MF8, VLSEG5E8_V, 0x5 }, // 4357
  { PseudoVLSEG5E8_V_MF8_MASK, VLSEG5E8_V, 0x5 }, // 4358
  { PseudoVLSEG5E8_V_MF8_TU, VLSEG5E8_V, 0x5 }, // 4359
  { PseudoVLSEG5E8_V_MF4, VLSEG5E8_V, 0x6 }, // 4360
  { PseudoVLSEG5E8_V_MF4_MASK, VLSEG5E8_V, 0x6 }, // 4361
  { PseudoVLSEG5E8_V_MF4_TU, VLSEG5E8_V, 0x6 }, // 4362
  { PseudoVLSEG5E8_V_MF2, VLSEG5E8_V, 0x7 }, // 4363
  { PseudoVLSEG5E8_V_MF2_MASK, VLSEG5E8_V, 0x7 }, // 4364
  { PseudoVLSEG5E8_V_MF2_TU, VLSEG5E8_V, 0x7 }, // 4365
  { PseudoVLSEG6E16FF_V_M1, VLSEG6E16FF_V, 0x0 }, // 4366
  { PseudoVLSEG6E16FF_V_M1_MASK, VLSEG6E16FF_V, 0x0 }, // 4367
  { PseudoVLSEG6E16FF_V_M1_TU, VLSEG6E16FF_V, 0x0 }, // 4368
  { PseudoVLSEG6E16FF_V_MF4, VLSEG6E16FF_V, 0x6 }, // 4369
  { PseudoVLSEG6E16FF_V_MF4_MASK, VLSEG6E16FF_V, 0x6 }, // 4370
  { PseudoVLSEG6E16FF_V_MF4_TU, VLSEG6E16FF_V, 0x6 }, // 4371
  { PseudoVLSEG6E16FF_V_MF2, VLSEG6E16FF_V, 0x7 }, // 4372
  { PseudoVLSEG6E16FF_V_MF2_MASK, VLSEG6E16FF_V, 0x7 }, // 4373
  { PseudoVLSEG6E16FF_V_MF2_TU, VLSEG6E16FF_V, 0x7 }, // 4374
  { PseudoVLSEG6E16_V_M1, VLSEG6E16_V, 0x0 }, // 4375
  { PseudoVLSEG6E16_V_M1_MASK, VLSEG6E16_V, 0x0 }, // 4376
  { PseudoVLSEG6E16_V_M1_TU, VLSEG6E16_V, 0x0 }, // 4377
  { PseudoVLSEG6E16_V_MF4, VLSEG6E16_V, 0x6 }, // 4378
  { PseudoVLSEG6E16_V_MF4_MASK, VLSEG6E16_V, 0x6 }, // 4379
  { PseudoVLSEG6E16_V_MF4_TU, VLSEG6E16_V, 0x6 }, // 4380
  { PseudoVLSEG6E16_V_MF2, VLSEG6E16_V, 0x7 }, // 4381
  { PseudoVLSEG6E16_V_MF2_MASK, VLSEG6E16_V, 0x7 }, // 4382
  { PseudoVLSEG6E16_V_MF2_TU, VLSEG6E16_V, 0x7 }, // 4383
  { PseudoVLSEG6E32FF_V_M1, VLSEG6E32FF_V, 0x0 }, // 4384
  { PseudoVLSEG6E32FF_V_M1_MASK, VLSEG6E32FF_V, 0x0 }, // 4385
  { PseudoVLSEG6E32FF_V_M1_TU, VLSEG6E32FF_V, 0x0 }, // 4386
  { PseudoVLSEG6E32FF_V_MF2, VLSEG6E32FF_V, 0x7 }, // 4387
  { PseudoVLSEG6E32FF_V_MF2_MASK, VLSEG6E32FF_V, 0x7 }, // 4388
  { PseudoVLSEG6E32FF_V_MF2_TU, VLSEG6E32FF_V, 0x7 }, // 4389
  { PseudoVLSEG6E32_V_M1, VLSEG6E32_V, 0x0 }, // 4390
  { PseudoVLSEG6E32_V_M1_MASK, VLSEG6E32_V, 0x0 }, // 4391
  { PseudoVLSEG6E32_V_M1_TU, VLSEG6E32_V, 0x0 }, // 4392
  { PseudoVLSEG6E32_V_MF2, VLSEG6E32_V, 0x7 }, // 4393
  { PseudoVLSEG6E32_V_MF2_MASK, VLSEG6E32_V, 0x7 }, // 4394
  { PseudoVLSEG6E32_V_MF2_TU, VLSEG6E32_V, 0x7 }, // 4395
  { PseudoVLSEG6E64FF_V_M1, VLSEG6E64FF_V, 0x0 }, // 4396
  { PseudoVLSEG6E64FF_V_M1_MASK, VLSEG6E64FF_V, 0x0 }, // 4397
  { PseudoVLSEG6E64FF_V_M1_TU, VLSEG6E64FF_V, 0x0 }, // 4398
  { PseudoVLSEG6E64_V_M1, VLSEG6E64_V, 0x0 }, // 4399
  { PseudoVLSEG6E64_V_M1_MASK, VLSEG6E64_V, 0x0 }, // 4400
  { PseudoVLSEG6E64_V_M1_TU, VLSEG6E64_V, 0x0 }, // 4401
  { PseudoVLSEG6E8FF_V_M1, VLSEG6E8FF_V, 0x0 }, // 4402
  { PseudoVLSEG6E8FF_V_M1_MASK, VLSEG6E8FF_V, 0x0 }, // 4403
  { PseudoVLSEG6E8FF_V_M1_TU, VLSEG6E8FF_V, 0x0 }, // 4404
  { PseudoVLSEG6E8FF_V_MF8, VLSEG6E8FF_V, 0x5 }, // 4405
  { PseudoVLSEG6E8FF_V_MF8_MASK, VLSEG6E8FF_V, 0x5 }, // 4406
  { PseudoVLSEG6E8FF_V_MF8_TU, VLSEG6E8FF_V, 0x5 }, // 4407
  { PseudoVLSEG6E8FF_V_MF4, VLSEG6E8FF_V, 0x6 }, // 4408
  { PseudoVLSEG6E8FF_V_MF4_MASK, VLSEG6E8FF_V, 0x6 }, // 4409
  { PseudoVLSEG6E8FF_V_MF4_TU, VLSEG6E8FF_V, 0x6 }, // 4410
  { PseudoVLSEG6E8FF_V_MF2, VLSEG6E8FF_V, 0x7 }, // 4411
  { PseudoVLSEG6E8FF_V_MF2_MASK, VLSEG6E8FF_V, 0x7 }, // 4412
  { PseudoVLSEG6E8FF_V_MF2_TU, VLSEG6E8FF_V, 0x7 }, // 4413
  { PseudoVLSEG6E8_V_M1, VLSEG6E8_V, 0x0 }, // 4414
  { PseudoVLSEG6E8_V_M1_MASK, VLSEG6E8_V, 0x0 }, // 4415
  { PseudoVLSEG6E8_V_M1_TU, VLSEG6E8_V, 0x0 }, // 4416
  { PseudoVLSEG6E8_V_MF8, VLSEG6E8_V, 0x5 }, // 4417
  { PseudoVLSEG6E8_V_MF8_MASK, VLSEG6E8_V, 0x5 }, // 4418
  { PseudoVLSEG6E8_V_MF8_TU, VLSEG6E8_V, 0x5 }, // 4419
  { PseudoVLSEG6E8_V_MF4, VLSEG6E8_V, 0x6 }, // 4420
  { PseudoVLSEG6E8_V_MF4_MASK, VLSEG6E8_V, 0x6 }, // 4421
  { PseudoVLSEG6E8_V_MF4_TU, VLSEG6E8_V, 0x6 }, // 4422
  { PseudoVLSEG6E8_V_MF2, VLSEG6E8_V, 0x7 }, // 4423
  { PseudoVLSEG6E8_V_MF2_MASK, VLSEG6E8_V, 0x7 }, // 4424
  { PseudoVLSEG6E8_V_MF2_TU, VLSEG6E8_V, 0x7 }, // 4425
  { PseudoVLSEG7E16FF_V_M1, VLSEG7E16FF_V, 0x0 }, // 4426
  { PseudoVLSEG7E16FF_V_M1_MASK, VLSEG7E16FF_V, 0x0 }, // 4427
  { PseudoVLSEG7E16FF_V_M1_TU, VLSEG7E16FF_V, 0x0 }, // 4428
  { PseudoVLSEG7E16FF_V_MF4, VLSEG7E16FF_V, 0x6 }, // 4429
  { PseudoVLSEG7E16FF_V_MF4_MASK, VLSEG7E16FF_V, 0x6 }, // 4430
  { PseudoVLSEG7E16FF_V_MF4_TU, VLSEG7E16FF_V, 0x6 }, // 4431
  { PseudoVLSEG7E16FF_V_MF2, VLSEG7E16FF_V, 0x7 }, // 4432
  { PseudoVLSEG7E16FF_V_MF2_MASK, VLSEG7E16FF_V, 0x7 }, // 4433
  { PseudoVLSEG7E16FF_V_MF2_TU, VLSEG7E16FF_V, 0x7 }, // 4434
  { PseudoVLSEG7E16_V_M1, VLSEG7E16_V, 0x0 }, // 4435
  { PseudoVLSEG7E16_V_M1_MASK, VLSEG7E16_V, 0x0 }, // 4436
  { PseudoVLSEG7E16_V_M1_TU, VLSEG7E16_V, 0x0 }, // 4437
  { PseudoVLSEG7E16_V_MF4, VLSEG7E16_V, 0x6 }, // 4438
  { PseudoVLSEG7E16_V_MF4_MASK, VLSEG7E16_V, 0x6 }, // 4439
  { PseudoVLSEG7E16_V_MF4_TU, VLSEG7E16_V, 0x6 }, // 4440
  { PseudoVLSEG7E16_V_MF2, VLSEG7E16_V, 0x7 }, // 4441
  { PseudoVLSEG7E16_V_MF2_MASK, VLSEG7E16_V, 0x7 }, // 4442
  { PseudoVLSEG7E16_V_MF2_TU, VLSEG7E16_V, 0x7 }, // 4443
  { PseudoVLSEG7E32FF_V_M1, VLSEG7E32FF_V, 0x0 }, // 4444
  { PseudoVLSEG7E32FF_V_M1_MASK, VLSEG7E32FF_V, 0x0 }, // 4445
  { PseudoVLSEG7E32FF_V_M1_TU, VLSEG7E32FF_V, 0x0 }, // 4446
  { PseudoVLSEG7E32FF_V_MF2, VLSEG7E32FF_V, 0x7 }, // 4447
  { PseudoVLSEG7E32FF_V_MF2_MASK, VLSEG7E32FF_V, 0x7 }, // 4448
  { PseudoVLSEG7E32FF_V_MF2_TU, VLSEG7E32FF_V, 0x7 }, // 4449
  { PseudoVLSEG7E32_V_M1, VLSEG7E32_V, 0x0 }, // 4450
  { PseudoVLSEG7E32_V_M1_MASK, VLSEG7E32_V, 0x0 }, // 4451
  { PseudoVLSEG7E32_V_M1_TU, VLSEG7E32_V, 0x0 }, // 4452
  { PseudoVLSEG7E32_V_MF2, VLSEG7E32_V, 0x7 }, // 4453
  { PseudoVLSEG7E32_V_MF2_MASK, VLSEG7E32_V, 0x7 }, // 4454
  { PseudoVLSEG7E32_V_MF2_TU, VLSEG7E32_V, 0x7 }, // 4455
  { PseudoVLSEG7E64FF_V_M1, VLSEG7E64FF_V, 0x0 }, // 4456
  { PseudoVLSEG7E64FF_V_M1_MASK, VLSEG7E64FF_V, 0x0 }, // 4457
  { PseudoVLSEG7E64FF_V_M1_TU, VLSEG7E64FF_V, 0x0 }, // 4458
  { PseudoVLSEG7E64_V_M1, VLSEG7E64_V, 0x0 }, // 4459
  { PseudoVLSEG7E64_V_M1_MASK, VLSEG7E64_V, 0x0 }, // 4460
  { PseudoVLSEG7E64_V_M1_TU, VLSEG7E64_V, 0x0 }, // 4461
  { PseudoVLSEG7E8FF_V_M1, VLSEG7E8FF_V, 0x0 }, // 4462
  { PseudoVLSEG7E8FF_V_M1_MASK, VLSEG7E8FF_V, 0x0 }, // 4463
  { PseudoVLSEG7E8FF_V_M1_TU, VLSEG7E8FF_V, 0x0 }, // 4464
  { PseudoVLSEG7E8FF_V_MF8, VLSEG7E8FF_V, 0x5 }, // 4465
  { PseudoVLSEG7E8FF_V_MF8_MASK, VLSEG7E8FF_V, 0x5 }, // 4466
  { PseudoVLSEG7E8FF_V_MF8_TU, VLSEG7E8FF_V, 0x5 }, // 4467
  { PseudoVLSEG7E8FF_V_MF4, VLSEG7E8FF_V, 0x6 }, // 4468
  { PseudoVLSEG7E8FF_V_MF4_MASK, VLSEG7E8FF_V, 0x6 }, // 4469
  { PseudoVLSEG7E8FF_V_MF4_TU, VLSEG7E8FF_V, 0x6 }, // 4470
  { PseudoVLSEG7E8FF_V_MF2, VLSEG7E8FF_V, 0x7 }, // 4471
  { PseudoVLSEG7E8FF_V_MF2_MASK, VLSEG7E8FF_V, 0x7 }, // 4472
  { PseudoVLSEG7E8FF_V_MF2_TU, VLSEG7E8FF_V, 0x7 }, // 4473
  { PseudoVLSEG7E8_V_M1, VLSEG7E8_V, 0x0 }, // 4474
  { PseudoVLSEG7E8_V_M1_MASK, VLSEG7E8_V, 0x0 }, // 4475
  { PseudoVLSEG7E8_V_M1_TU, VLSEG7E8_V, 0x0 }, // 4476
  { PseudoVLSEG7E8_V_MF8, VLSEG7E8_V, 0x5 }, // 4477
  { PseudoVLSEG7E8_V_MF8_MASK, VLSEG7E8_V, 0x5 }, // 4478
  { PseudoVLSEG7E8_V_MF8_TU, VLSEG7E8_V, 0x5 }, // 4479
  { PseudoVLSEG7E8_V_MF4, VLSEG7E8_V, 0x6 }, // 4480
  { PseudoVLSEG7E8_V_MF4_MASK, VLSEG7E8_V, 0x6 }, // 4481
  { PseudoVLSEG7E8_V_MF4_TU, VLSEG7E8_V, 0x6 }, // 4482
  { PseudoVLSEG7E8_V_MF2, VLSEG7E8_V, 0x7 }, // 4483
  { PseudoVLSEG7E8_V_MF2_MASK, VLSEG7E8_V, 0x7 }, // 4484
  { PseudoVLSEG7E8_V_MF2_TU, VLSEG7E8_V, 0x7 }, // 4485
  { PseudoVLSEG8E16FF_V_M1, VLSEG8E16FF_V, 0x0 }, // 4486
  { PseudoVLSEG8E16FF_V_M1_MASK, VLSEG8E16FF_V, 0x0 }, // 4487
  { PseudoVLSEG8E16FF_V_M1_TU, VLSEG8E16FF_V, 0x0 }, // 4488
  { PseudoVLSEG8E16FF_V_MF4, VLSEG8E16FF_V, 0x6 }, // 4489
  { PseudoVLSEG8E16FF_V_MF4_MASK, VLSEG8E16FF_V, 0x6 }, // 4490
  { PseudoVLSEG8E16FF_V_MF4_TU, VLSEG8E16FF_V, 0x6 }, // 4491
  { PseudoVLSEG8E16FF_V_MF2, VLSEG8E16FF_V, 0x7 }, // 4492
  { PseudoVLSEG8E16FF_V_MF2_MASK, VLSEG8E16FF_V, 0x7 }, // 4493
  { PseudoVLSEG8E16FF_V_MF2_TU, VLSEG8E16FF_V, 0x7 }, // 4494
  { PseudoVLSEG8E16_V_M1, VLSEG8E16_V, 0x0 }, // 4495
  { PseudoVLSEG8E16_V_M1_MASK, VLSEG8E16_V, 0x0 }, // 4496
  { PseudoVLSEG8E16_V_M1_TU, VLSEG8E16_V, 0x0 }, // 4497
  { PseudoVLSEG8E16_V_MF4, VLSEG8E16_V, 0x6 }, // 4498
  { PseudoVLSEG8E16_V_MF4_MASK, VLSEG8E16_V, 0x6 }, // 4499
  { PseudoVLSEG8E16_V_MF4_TU, VLSEG8E16_V, 0x6 }, // 4500
  { PseudoVLSEG8E16_V_MF2, VLSEG8E16_V, 0x7 }, // 4501
  { PseudoVLSEG8E16_V_MF2_MASK, VLSEG8E16_V, 0x7 }, // 4502
  { PseudoVLSEG8E16_V_MF2_TU, VLSEG8E16_V, 0x7 }, // 4503
  { PseudoVLSEG8E32FF_V_M1, VLSEG8E32FF_V, 0x0 }, // 4504
  { PseudoVLSEG8E32FF_V_M1_MASK, VLSEG8E32FF_V, 0x0 }, // 4505
  { PseudoVLSEG8E32FF_V_M1_TU, VLSEG8E32FF_V, 0x0 }, // 4506
  { PseudoVLSEG8E32FF_V_MF2, VLSEG8E32FF_V, 0x7 }, // 4507
  { PseudoVLSEG8E32FF_V_MF2_MASK, VLSEG8E32FF_V, 0x7 }, // 4508
  { PseudoVLSEG8E32FF_V_MF2_TU, VLSEG8E32FF_V, 0x7 }, // 4509
  { PseudoVLSEG8E32_V_M1, VLSEG8E32_V, 0x0 }, // 4510
  { PseudoVLSEG8E32_V_M1_MASK, VLSEG8E32_V, 0x0 }, // 4511
  { PseudoVLSEG8E32_V_M1_TU, VLSEG8E32_V, 0x0 }, // 4512
  { PseudoVLSEG8E32_V_MF2, VLSEG8E32_V, 0x7 }, // 4513
  { PseudoVLSEG8E32_V_MF2_MASK, VLSEG8E32_V, 0x7 }, // 4514
  { PseudoVLSEG8E32_V_MF2_TU, VLSEG8E32_V, 0x7 }, // 4515
  { PseudoVLSEG8E64FF_V_M1, VLSEG8E64FF_V, 0x0 }, // 4516
  { PseudoVLSEG8E64FF_V_M1_MASK, VLSEG8E64FF_V, 0x0 }, // 4517
  { PseudoVLSEG8E64FF_V_M1_TU, VLSEG8E64FF_V, 0x0 }, // 4518
  { PseudoVLSEG8E64_V_M1, VLSEG8E64_V, 0x0 }, // 4519
  { PseudoVLSEG8E64_V_M1_MASK, VLSEG8E64_V, 0x0 }, // 4520
  { PseudoVLSEG8E64_V_M1_TU, VLSEG8E64_V, 0x0 }, // 4521
  { PseudoVLSEG8E8FF_V_M1, VLSEG8E8FF_V, 0x0 }, // 4522
  { PseudoVLSEG8E8FF_V_M1_MASK, VLSEG8E8FF_V, 0x0 }, // 4523
  { PseudoVLSEG8E8FF_V_M1_TU, VLSEG8E8FF_V, 0x0 }, // 4524
  { PseudoVLSEG8E8FF_V_MF8, VLSEG8E8FF_V, 0x5 }, // 4525
  { PseudoVLSEG8E8FF_V_MF8_MASK, VLSEG8E8FF_V, 0x5 }, // 4526
  { PseudoVLSEG8E8FF_V_MF8_TU, VLSEG8E8FF_V, 0x5 }, // 4527
  { PseudoVLSEG8E8FF_V_MF4, VLSEG8E8FF_V, 0x6 }, // 4528
  { PseudoVLSEG8E8FF_V_MF4_MASK, VLSEG8E8FF_V, 0x6 }, // 4529
  { PseudoVLSEG8E8FF_V_MF4_TU, VLSEG8E8FF_V, 0x6 }, // 4530
  { PseudoVLSEG8E8FF_V_MF2, VLSEG8E8FF_V, 0x7 }, // 4531
  { PseudoVLSEG8E8FF_V_MF2_MASK, VLSEG8E8FF_V, 0x7 }, // 4532
  { PseudoVLSEG8E8FF_V_MF2_TU, VLSEG8E8FF_V, 0x7 }, // 4533
  { PseudoVLSEG8E8_V_M1, VLSEG8E8_V, 0x0 }, // 4534
  { PseudoVLSEG8E8_V_M1_MASK, VLSEG8E8_V, 0x0 }, // 4535
  { PseudoVLSEG8E8_V_M1_TU, VLSEG8E8_V, 0x0 }, // 4536
  { PseudoVLSEG8E8_V_MF8, VLSEG8E8_V, 0x5 }, // 4537
  { PseudoVLSEG8E8_V_MF8_MASK, VLSEG8E8_V, 0x5 }, // 4538
  { PseudoVLSEG8E8_V_MF8_TU, VLSEG8E8_V, 0x5 }, // 4539
  { PseudoVLSEG8E8_V_MF4, VLSEG8E8_V, 0x6 }, // 4540
  { PseudoVLSEG8E8_V_MF4_MASK, VLSEG8E8_V, 0x6 }, // 4541
  { PseudoVLSEG8E8_V_MF4_TU, VLSEG8E8_V, 0x6 }, // 4542
  { PseudoVLSEG8E8_V_MF2, VLSEG8E8_V, 0x7 }, // 4543
  { PseudoVLSEG8E8_V_MF2_MASK, VLSEG8E8_V, 0x7 }, // 4544
  { PseudoVLSEG8E8_V_MF2_TU, VLSEG8E8_V, 0x7 }, // 4545
  { PseudoVLSSEG2E16_V_M1, VLSSEG2E16_V, 0x0 }, // 4546
  { PseudoVLSSEG2E16_V_M1_MASK, VLSSEG2E16_V, 0x0 }, // 4547
  { PseudoVLSSEG2E16_V_M1_TU, VLSSEG2E16_V, 0x0 }, // 4548
  { PseudoVLSSEG2E16_V_M2, VLSSEG2E16_V, 0x1 }, // 4549
  { PseudoVLSSEG2E16_V_M2_MASK, VLSSEG2E16_V, 0x1 }, // 4550
  { PseudoVLSSEG2E16_V_M2_TU, VLSSEG2E16_V, 0x1 }, // 4551
  { PseudoVLSSEG2E16_V_M4, VLSSEG2E16_V, 0x2 }, // 4552
  { PseudoVLSSEG2E16_V_M4_MASK, VLSSEG2E16_V, 0x2 }, // 4553
  { PseudoVLSSEG2E16_V_M4_TU, VLSSEG2E16_V, 0x2 }, // 4554
  { PseudoVLSSEG2E16_V_MF4, VLSSEG2E16_V, 0x6 }, // 4555
  { PseudoVLSSEG2E16_V_MF4_MASK, VLSSEG2E16_V, 0x6 }, // 4556
  { PseudoVLSSEG2E16_V_MF4_TU, VLSSEG2E16_V, 0x6 }, // 4557
  { PseudoVLSSEG2E16_V_MF2, VLSSEG2E16_V, 0x7 }, // 4558
  { PseudoVLSSEG2E16_V_MF2_MASK, VLSSEG2E16_V, 0x7 }, // 4559
  { PseudoVLSSEG2E16_V_MF2_TU, VLSSEG2E16_V, 0x7 }, // 4560
  { PseudoVLSSEG2E32_V_M1, VLSSEG2E32_V, 0x0 }, // 4561
  { PseudoVLSSEG2E32_V_M1_MASK, VLSSEG2E32_V, 0x0 }, // 4562
  { PseudoVLSSEG2E32_V_M1_TU, VLSSEG2E32_V, 0x0 }, // 4563
  { PseudoVLSSEG2E32_V_M2, VLSSEG2E32_V, 0x1 }, // 4564
  { PseudoVLSSEG2E32_V_M2_MASK, VLSSEG2E32_V, 0x1 }, // 4565
  { PseudoVLSSEG2E32_V_M2_TU, VLSSEG2E32_V, 0x1 }, // 4566
  { PseudoVLSSEG2E32_V_M4, VLSSEG2E32_V, 0x2 }, // 4567
  { PseudoVLSSEG2E32_V_M4_MASK, VLSSEG2E32_V, 0x2 }, // 4568
  { PseudoVLSSEG2E32_V_M4_TU, VLSSEG2E32_V, 0x2 }, // 4569
  { PseudoVLSSEG2E32_V_MF2, VLSSEG2E32_V, 0x7 }, // 4570
  { PseudoVLSSEG2E32_V_MF2_MASK, VLSSEG2E32_V, 0x7 }, // 4571
  { PseudoVLSSEG2E32_V_MF2_TU, VLSSEG2E32_V, 0x7 }, // 4572
  { PseudoVLSSEG2E64_V_M1, VLSSEG2E64_V, 0x0 }, // 4573
  { PseudoVLSSEG2E64_V_M1_MASK, VLSSEG2E64_V, 0x0 }, // 4574
  { PseudoVLSSEG2E64_V_M1_TU, VLSSEG2E64_V, 0x0 }, // 4575
  { PseudoVLSSEG2E64_V_M2, VLSSEG2E64_V, 0x1 }, // 4576
  { PseudoVLSSEG2E64_V_M2_MASK, VLSSEG2E64_V, 0x1 }, // 4577
  { PseudoVLSSEG2E64_V_M2_TU, VLSSEG2E64_V, 0x1 }, // 4578
  { PseudoVLSSEG2E64_V_M4, VLSSEG2E64_V, 0x2 }, // 4579
  { PseudoVLSSEG2E64_V_M4_MASK, VLSSEG2E64_V, 0x2 }, // 4580
  { PseudoVLSSEG2E64_V_M4_TU, VLSSEG2E64_V, 0x2 }, // 4581
  { PseudoVLSSEG2E8_V_M1, VLSSEG2E8_V, 0x0 }, // 4582
  { PseudoVLSSEG2E8_V_M1_MASK, VLSSEG2E8_V, 0x0 }, // 4583
  { PseudoVLSSEG2E8_V_M1_TU, VLSSEG2E8_V, 0x0 }, // 4584
  { PseudoVLSSEG2E8_V_M2, VLSSEG2E8_V, 0x1 }, // 4585
  { PseudoVLSSEG2E8_V_M2_MASK, VLSSEG2E8_V, 0x1 }, // 4586
  { PseudoVLSSEG2E8_V_M2_TU, VLSSEG2E8_V, 0x1 }, // 4587
  { PseudoVLSSEG2E8_V_M4, VLSSEG2E8_V, 0x2 }, // 4588
  { PseudoVLSSEG2E8_V_M4_MASK, VLSSEG2E8_V, 0x2 }, // 4589
  { PseudoVLSSEG2E8_V_M4_TU, VLSSEG2E8_V, 0x2 }, // 4590
  { PseudoVLSSEG2E8_V_MF8, VLSSEG2E8_V, 0x5 }, // 4591
  { PseudoVLSSEG2E8_V_MF8_MASK, VLSSEG2E8_V, 0x5 }, // 4592
  { PseudoVLSSEG2E8_V_MF8_TU, VLSSEG2E8_V, 0x5 }, // 4593
  { PseudoVLSSEG2E8_V_MF4, VLSSEG2E8_V, 0x6 }, // 4594
  { PseudoVLSSEG2E8_V_MF4_MASK, VLSSEG2E8_V, 0x6 }, // 4595
  { PseudoVLSSEG2E8_V_MF4_TU, VLSSEG2E8_V, 0x6 }, // 4596
  { PseudoVLSSEG2E8_V_MF2, VLSSEG2E8_V, 0x7 }, // 4597
  { PseudoVLSSEG2E8_V_MF2_MASK, VLSSEG2E8_V, 0x7 }, // 4598
  { PseudoVLSSEG2E8_V_MF2_TU, VLSSEG2E8_V, 0x7 }, // 4599
  { PseudoVLSSEG3E16_V_M1, VLSSEG3E16_V, 0x0 }, // 4600
  { PseudoVLSSEG3E16_V_M1_MASK, VLSSEG3E16_V, 0x0 }, // 4601
  { PseudoVLSSEG3E16_V_M1_TU, VLSSEG3E16_V, 0x0 }, // 4602
  { PseudoVLSSEG3E16_V_M2, VLSSEG3E16_V, 0x1 }, // 4603
  { PseudoVLSSEG3E16_V_M2_MASK, VLSSEG3E16_V, 0x1 }, // 4604
  { PseudoVLSSEG3E16_V_M2_TU, VLSSEG3E16_V, 0x1 }, // 4605
  { PseudoVLSSEG3E16_V_MF4, VLSSEG3E16_V, 0x6 }, // 4606
  { PseudoVLSSEG3E16_V_MF4_MASK, VLSSEG3E16_V, 0x6 }, // 4607
  { PseudoVLSSEG3E16_V_MF4_TU, VLSSEG3E16_V, 0x6 }, // 4608
  { PseudoVLSSEG3E16_V_MF2, VLSSEG3E16_V, 0x7 }, // 4609
  { PseudoVLSSEG3E16_V_MF2_MASK, VLSSEG3E16_V, 0x7 }, // 4610
  { PseudoVLSSEG3E16_V_MF2_TU, VLSSEG3E16_V, 0x7 }, // 4611
  { PseudoVLSSEG3E32_V_M1, VLSSEG3E32_V, 0x0 }, // 4612
  { PseudoVLSSEG3E32_V_M1_MASK, VLSSEG3E32_V, 0x0 }, // 4613
  { PseudoVLSSEG3E32_V_M1_TU, VLSSEG3E32_V, 0x0 }, // 4614
  { PseudoVLSSEG3E32_V_M2, VLSSEG3E32_V, 0x1 }, // 4615
  { PseudoVLSSEG3E32_V_M2_MASK, VLSSEG3E32_V, 0x1 }, // 4616
  { PseudoVLSSEG3E32_V_M2_TU, VLSSEG3E32_V, 0x1 }, // 4617
  { PseudoVLSSEG3E32_V_MF2, VLSSEG3E32_V, 0x7 }, // 4618
  { PseudoVLSSEG3E32_V_MF2_MASK, VLSSEG3E32_V, 0x7 }, // 4619
  { PseudoVLSSEG3E32_V_MF2_TU, VLSSEG3E32_V, 0x7 }, // 4620
  { PseudoVLSSEG3E64_V_M1, VLSSEG3E64_V, 0x0 }, // 4621
  { PseudoVLSSEG3E64_V_M1_MASK, VLSSEG3E64_V, 0x0 }, // 4622
  { PseudoVLSSEG3E64_V_M1_TU, VLSSEG3E64_V, 0x0 }, // 4623
  { PseudoVLSSEG3E64_V_M2, VLSSEG3E64_V, 0x1 }, // 4624
  { PseudoVLSSEG3E64_V_M2_MASK, VLSSEG3E64_V, 0x1 }, // 4625
  { PseudoVLSSEG3E64_V_M2_TU, VLSSEG3E64_V, 0x1 }, // 4626
  { PseudoVLSSEG3E8_V_M1, VLSSEG3E8_V, 0x0 }, // 4627
  { PseudoVLSSEG3E8_V_M1_MASK, VLSSEG3E8_V, 0x0 }, // 4628
  { PseudoVLSSEG3E8_V_M1_TU, VLSSEG3E8_V, 0x0 }, // 4629
  { PseudoVLSSEG3E8_V_M2, VLSSEG3E8_V, 0x1 }, // 4630
  { PseudoVLSSEG3E8_V_M2_MASK, VLSSEG3E8_V, 0x1 }, // 4631
  { PseudoVLSSEG3E8_V_M2_TU, VLSSEG3E8_V, 0x1 }, // 4632
  { PseudoVLSSEG3E8_V_MF8, VLSSEG3E8_V, 0x5 }, // 4633
  { PseudoVLSSEG3E8_V_MF8_MASK, VLSSEG3E8_V, 0x5 }, // 4634
  { PseudoVLSSEG3E8_V_MF8_TU, VLSSEG3E8_V, 0x5 }, // 4635
  { PseudoVLSSEG3E8_V_MF4, VLSSEG3E8_V, 0x6 }, // 4636
  { PseudoVLSSEG3E8_V_MF4_MASK, VLSSEG3E8_V, 0x6 }, // 4637
  { PseudoVLSSEG3E8_V_MF4_TU, VLSSEG3E8_V, 0x6 }, // 4638
  { PseudoVLSSEG3E8_V_MF2, VLSSEG3E8_V, 0x7 }, // 4639
  { PseudoVLSSEG3E8_V_MF2_MASK, VLSSEG3E8_V, 0x7 }, // 4640
  { PseudoVLSSEG3E8_V_MF2_TU, VLSSEG3E8_V, 0x7 }, // 4641
  { PseudoVLSSEG4E16_V_M1, VLSSEG4E16_V, 0x0 }, // 4642
  { PseudoVLSSEG4E16_V_M1_MASK, VLSSEG4E16_V, 0x0 }, // 4643
  { PseudoVLSSEG4E16_V_M1_TU, VLSSEG4E16_V, 0x0 }, // 4644
  { PseudoVLSSEG4E16_V_M2, VLSSEG4E16_V, 0x1 }, // 4645
  { PseudoVLSSEG4E16_V_M2_MASK, VLSSEG4E16_V, 0x1 }, // 4646
  { PseudoVLSSEG4E16_V_M2_TU, VLSSEG4E16_V, 0x1 }, // 4647
  { PseudoVLSSEG4E16_V_MF4, VLSSEG4E16_V, 0x6 }, // 4648
  { PseudoVLSSEG4E16_V_MF4_MASK, VLSSEG4E16_V, 0x6 }, // 4649
  { PseudoVLSSEG4E16_V_MF4_TU, VLSSEG4E16_V, 0x6 }, // 4650
  { PseudoVLSSEG4E16_V_MF2, VLSSEG4E16_V, 0x7 }, // 4651
  { PseudoVLSSEG4E16_V_MF2_MASK, VLSSEG4E16_V, 0x7 }, // 4652
  { PseudoVLSSEG4E16_V_MF2_TU, VLSSEG4E16_V, 0x7 }, // 4653
  { PseudoVLSSEG4E32_V_M1, VLSSEG4E32_V, 0x0 }, // 4654
  { PseudoVLSSEG4E32_V_M1_MASK, VLSSEG4E32_V, 0x0 }, // 4655
  { PseudoVLSSEG4E32_V_M1_TU, VLSSEG4E32_V, 0x0 }, // 4656
  { PseudoVLSSEG4E32_V_M2, VLSSEG4E32_V, 0x1 }, // 4657
  { PseudoVLSSEG4E32_V_M2_MASK, VLSSEG4E32_V, 0x1 }, // 4658
  { PseudoVLSSEG4E32_V_M2_TU, VLSSEG4E32_V, 0x1 }, // 4659
  { PseudoVLSSEG4E32_V_MF2, VLSSEG4E32_V, 0x7 }, // 4660
  { PseudoVLSSEG4E32_V_MF2_MASK, VLSSEG4E32_V, 0x7 }, // 4661
  { PseudoVLSSEG4E32_V_MF2_TU, VLSSEG4E32_V, 0x7 }, // 4662
  { PseudoVLSSEG4E64_V_M1, VLSSEG4E64_V, 0x0 }, // 4663
  { PseudoVLSSEG4E64_V_M1_MASK, VLSSEG4E64_V, 0x0 }, // 4664
  { PseudoVLSSEG4E64_V_M1_TU, VLSSEG4E64_V, 0x0 }, // 4665
  { PseudoVLSSEG4E64_V_M2, VLSSEG4E64_V, 0x1 }, // 4666
  { PseudoVLSSEG4E64_V_M2_MASK, VLSSEG4E64_V, 0x1 }, // 4667
  { PseudoVLSSEG4E64_V_M2_TU, VLSSEG4E64_V, 0x1 }, // 4668
  { PseudoVLSSEG4E8_V_M1, VLSSEG4E8_V, 0x0 }, // 4669
  { PseudoVLSSEG4E8_V_M1_MASK, VLSSEG4E8_V, 0x0 }, // 4670
  { PseudoVLSSEG4E8_V_M1_TU, VLSSEG4E8_V, 0x0 }, // 4671
  { PseudoVLSSEG4E8_V_M2, VLSSEG4E8_V, 0x1 }, // 4672
  { PseudoVLSSEG4E8_V_M2_MASK, VLSSEG4E8_V, 0x1 }, // 4673
  { PseudoVLSSEG4E8_V_M2_TU, VLSSEG4E8_V, 0x1 }, // 4674
  { PseudoVLSSEG4E8_V_MF8, VLSSEG4E8_V, 0x5 }, // 4675
  { PseudoVLSSEG4E8_V_MF8_MASK, VLSSEG4E8_V, 0x5 }, // 4676
  { PseudoVLSSEG4E8_V_MF8_TU, VLSSEG4E8_V, 0x5 }, // 4677
  { PseudoVLSSEG4E8_V_MF4, VLSSEG4E8_V, 0x6 }, // 4678
  { PseudoVLSSEG4E8_V_MF4_MASK, VLSSEG4E8_V, 0x6 }, // 4679
  { PseudoVLSSEG4E8_V_MF4_TU, VLSSEG4E8_V, 0x6 }, // 4680
  { PseudoVLSSEG4E8_V_MF2, VLSSEG4E8_V, 0x7 }, // 4681
  { PseudoVLSSEG4E8_V_MF2_MASK, VLSSEG4E8_V, 0x7 }, // 4682
  { PseudoVLSSEG4E8_V_MF2_TU, VLSSEG4E8_V, 0x7 }, // 4683
  { PseudoVLSSEG5E16_V_M1, VLSSEG5E16_V, 0x0 }, // 4684
  { PseudoVLSSEG5E16_V_M1_MASK, VLSSEG5E16_V, 0x0 }, // 4685
  { PseudoVLSSEG5E16_V_M1_TU, VLSSEG5E16_V, 0x0 }, // 4686
  { PseudoVLSSEG5E16_V_MF4, VLSSEG5E16_V, 0x6 }, // 4687
  { PseudoVLSSEG5E16_V_MF4_MASK, VLSSEG5E16_V, 0x6 }, // 4688
  { PseudoVLSSEG5E16_V_MF4_TU, VLSSEG5E16_V, 0x6 }, // 4689
  { PseudoVLSSEG5E16_V_MF2, VLSSEG5E16_V, 0x7 }, // 4690
  { PseudoVLSSEG5E16_V_MF2_MASK, VLSSEG5E16_V, 0x7 }, // 4691
  { PseudoVLSSEG5E16_V_MF2_TU, VLSSEG5E16_V, 0x7 }, // 4692
  { PseudoVLSSEG5E32_V_M1, VLSSEG5E32_V, 0x0 }, // 4693
  { PseudoVLSSEG5E32_V_M1_MASK, VLSSEG5E32_V, 0x0 }, // 4694
  { PseudoVLSSEG5E32_V_M1_TU, VLSSEG5E32_V, 0x0 }, // 4695
  { PseudoVLSSEG5E32_V_MF2, VLSSEG5E32_V, 0x7 }, // 4696
  { PseudoVLSSEG5E32_V_MF2_MASK, VLSSEG5E32_V, 0x7 }, // 4697
  { PseudoVLSSEG5E32_V_MF2_TU, VLSSEG5E32_V, 0x7 }, // 4698
  { PseudoVLSSEG5E64_V_M1, VLSSEG5E64_V, 0x0 }, // 4699
  { PseudoVLSSEG5E64_V_M1_MASK, VLSSEG5E64_V, 0x0 }, // 4700
  { PseudoVLSSEG5E64_V_M1_TU, VLSSEG5E64_V, 0x0 }, // 4701
  { PseudoVLSSEG5E8_V_M1, VLSSEG5E8_V, 0x0 }, // 4702
  { PseudoVLSSEG5E8_V_M1_MASK, VLSSEG5E8_V, 0x0 }, // 4703
  { PseudoVLSSEG5E8_V_M1_TU, VLSSEG5E8_V, 0x0 }, // 4704
  { PseudoVLSSEG5E8_V_MF8, VLSSEG5E8_V, 0x5 }, // 4705
  { PseudoVLSSEG5E8_V_MF8_MASK, VLSSEG5E8_V, 0x5 }, // 4706
  { PseudoVLSSEG5E8_V_MF8_TU, VLSSEG5E8_V, 0x5 }, // 4707
  { PseudoVLSSEG5E8_V_MF4, VLSSEG5E8_V, 0x6 }, // 4708
  { PseudoVLSSEG5E8_V_MF4_MASK, VLSSEG5E8_V, 0x6 }, // 4709
  { PseudoVLSSEG5E8_V_MF4_TU, VLSSEG5E8_V, 0x6 }, // 4710
  { PseudoVLSSEG5E8_V_MF2, VLSSEG5E8_V, 0x7 }, // 4711
  { PseudoVLSSEG5E8_V_MF2_MASK, VLSSEG5E8_V, 0x7 }, // 4712
  { PseudoVLSSEG5E8_V_MF2_TU, VLSSEG5E8_V, 0x7 }, // 4713
  { PseudoVLSSEG6E16_V_M1, VLSSEG6E16_V, 0x0 }, // 4714
  { PseudoVLSSEG6E16_V_M1_MASK, VLSSEG6E16_V, 0x0 }, // 4715
  { PseudoVLSSEG6E16_V_M1_TU, VLSSEG6E16_V, 0x0 }, // 4716
  { PseudoVLSSEG6E16_V_MF4, VLSSEG6E16_V, 0x6 }, // 4717
  { PseudoVLSSEG6E16_V_MF4_MASK, VLSSEG6E16_V, 0x6 }, // 4718
  { PseudoVLSSEG6E16_V_MF4_TU, VLSSEG6E16_V, 0x6 }, // 4719
  { PseudoVLSSEG6E16_V_MF2, VLSSEG6E16_V, 0x7 }, // 4720
  { PseudoVLSSEG6E16_V_MF2_MASK, VLSSEG6E16_V, 0x7 }, // 4721
  { PseudoVLSSEG6E16_V_MF2_TU, VLSSEG6E16_V, 0x7 }, // 4722
  { PseudoVLSSEG6E32_V_M1, VLSSEG6E32_V, 0x0 }, // 4723
  { PseudoVLSSEG6E32_V_M1_MASK, VLSSEG6E32_V, 0x0 }, // 4724
  { PseudoVLSSEG6E32_V_M1_TU, VLSSEG6E32_V, 0x0 }, // 4725
  { PseudoVLSSEG6E32_V_MF2, VLSSEG6E32_V, 0x7 }, // 4726
  { PseudoVLSSEG6E32_V_MF2_MASK, VLSSEG6E32_V, 0x7 }, // 4727
  { PseudoVLSSEG6E32_V_MF2_TU, VLSSEG6E32_V, 0x7 }, // 4728
  { PseudoVLSSEG6E64_V_M1, VLSSEG6E64_V, 0x0 }, // 4729
  { PseudoVLSSEG6E64_V_M1_MASK, VLSSEG6E64_V, 0x0 }, // 4730
  { PseudoVLSSEG6E64_V_M1_TU, VLSSEG6E64_V, 0x0 }, // 4731
  { PseudoVLSSEG6E8_V_M1, VLSSEG6E8_V, 0x0 }, // 4732
  { PseudoVLSSEG6E8_V_M1_MASK, VLSSEG6E8_V, 0x0 }, // 4733
  { PseudoVLSSEG6E8_V_M1_TU, VLSSEG6E8_V, 0x0 }, // 4734
  { PseudoVLSSEG6E8_V_MF8, VLSSEG6E8_V, 0x5 }, // 4735
  { PseudoVLSSEG6E8_V_MF8_MASK, VLSSEG6E8_V, 0x5 }, // 4736
  { PseudoVLSSEG6E8_V_MF8_TU, VLSSEG6E8_V, 0x5 }, // 4737
  { PseudoVLSSEG6E8_V_MF4, VLSSEG6E8_V, 0x6 }, // 4738
  { PseudoVLSSEG6E8_V_MF4_MASK, VLSSEG6E8_V, 0x6 }, // 4739
  { PseudoVLSSEG6E8_V_MF4_TU, VLSSEG6E8_V, 0x6 }, // 4740
  { PseudoVLSSEG6E8_V_MF2, VLSSEG6E8_V, 0x7 }, // 4741
  { PseudoVLSSEG6E8_V_MF2_MASK, VLSSEG6E8_V, 0x7 }, // 4742
  { PseudoVLSSEG6E8_V_MF2_TU, VLSSEG6E8_V, 0x7 }, // 4743
  { PseudoVLSSEG7E16_V_M1, VLSSEG7E16_V, 0x0 }, // 4744
  { PseudoVLSSEG7E16_V_M1_MASK, VLSSEG7E16_V, 0x0 }, // 4745
  { PseudoVLSSEG7E16_V_M1_TU, VLSSEG7E16_V, 0x0 }, // 4746
  { PseudoVLSSEG7E16_V_MF4, VLSSEG7E16_V, 0x6 }, // 4747
  { PseudoVLSSEG7E16_V_MF4_MASK, VLSSEG7E16_V, 0x6 }, // 4748
  { PseudoVLSSEG7E16_V_MF4_TU, VLSSEG7E16_V, 0x6 }, // 4749
  { PseudoVLSSEG7E16_V_MF2, VLSSEG7E16_V, 0x7 }, // 4750
  { PseudoVLSSEG7E16_V_MF2_MASK, VLSSEG7E16_V, 0x7 }, // 4751
  { PseudoVLSSEG7E16_V_MF2_TU, VLSSEG7E16_V, 0x7 }, // 4752
  { PseudoVLSSEG7E32_V_M1, VLSSEG7E32_V, 0x0 }, // 4753
  { PseudoVLSSEG7E32_V_M1_MASK, VLSSEG7E32_V, 0x0 }, // 4754
  { PseudoVLSSEG7E32_V_M1_TU, VLSSEG7E32_V, 0x0 }, // 4755
  { PseudoVLSSEG7E32_V_MF2, VLSSEG7E32_V, 0x7 }, // 4756
  { PseudoVLSSEG7E32_V_MF2_MASK, VLSSEG7E32_V, 0x7 }, // 4757
  { PseudoVLSSEG7E32_V_MF2_TU, VLSSEG7E32_V, 0x7 }, // 4758
  { PseudoVLSSEG7E64_V_M1, VLSSEG7E64_V, 0x0 }, // 4759
  { PseudoVLSSEG7E64_V_M1_MASK, VLSSEG7E64_V, 0x0 }, // 4760
  { PseudoVLSSEG7E64_V_M1_TU, VLSSEG7E64_V, 0x0 }, // 4761
  { PseudoVLSSEG7E8_V_M1, VLSSEG7E8_V, 0x0 }, // 4762
  { PseudoVLSSEG7E8_V_M1_MASK, VLSSEG7E8_V, 0x0 }, // 4763
  { PseudoVLSSEG7E8_V_M1_TU, VLSSEG7E8_V, 0x0 }, // 4764
  { PseudoVLSSEG7E8_V_MF8, VLSSEG7E8_V, 0x5 }, // 4765
  { PseudoVLSSEG7E8_V_MF8_MASK, VLSSEG7E8_V, 0x5 }, // 4766
  { PseudoVLSSEG7E8_V_MF8_TU, VLSSEG7E8_V, 0x5 }, // 4767
  { PseudoVLSSEG7E8_V_MF4, VLSSEG7E8_V, 0x6 }, // 4768
  { PseudoVLSSEG7E8_V_MF4_MASK, VLSSEG7E8_V, 0x6 }, // 4769
  { PseudoVLSSEG7E8_V_MF4_TU, VLSSEG7E8_V, 0x6 }, // 4770
  { PseudoVLSSEG7E8_V_MF2, VLSSEG7E8_V, 0x7 }, // 4771
  { PseudoVLSSEG7E8_V_MF2_MASK, VLSSEG7E8_V, 0x7 }, // 4772
  { PseudoVLSSEG7E8_V_MF2_TU, VLSSEG7E8_V, 0x7 }, // 4773
  { PseudoVLSSEG8E16_V_M1, VLSSEG8E16_V, 0x0 }, // 4774
  { PseudoVLSSEG8E16_V_M1_MASK, VLSSEG8E16_V, 0x0 }, // 4775
  { PseudoVLSSEG8E16_V_M1_TU, VLSSEG8E16_V, 0x0 }, // 4776
  { PseudoVLSSEG8E16_V_MF4, VLSSEG8E16_V, 0x6 }, // 4777
  { PseudoVLSSEG8E16_V_MF4_MASK, VLSSEG8E16_V, 0x6 }, // 4778
  { PseudoVLSSEG8E16_V_MF4_TU, VLSSEG8E16_V, 0x6 }, // 4779
  { PseudoVLSSEG8E16_V_MF2, VLSSEG8E16_V, 0x7 }, // 4780
  { PseudoVLSSEG8E16_V_MF2_MASK, VLSSEG8E16_V, 0x7 }, // 4781
  { PseudoVLSSEG8E16_V_MF2_TU, VLSSEG8E16_V, 0x7 }, // 4782
  { PseudoVLSSEG8E32_V_M1, VLSSEG8E32_V, 0x0 }, // 4783
  { PseudoVLSSEG8E32_V_M1_MASK, VLSSEG8E32_V, 0x0 }, // 4784
  { PseudoVLSSEG8E32_V_M1_TU, VLSSEG8E32_V, 0x0 }, // 4785
  { PseudoVLSSEG8E32_V_MF2, VLSSEG8E32_V, 0x7 }, // 4786
  { PseudoVLSSEG8E32_V_MF2_MASK, VLSSEG8E32_V, 0x7 }, // 4787
  { PseudoVLSSEG8E32_V_MF2_TU, VLSSEG8E32_V, 0x7 }, // 4788
  { PseudoVLSSEG8E64_V_M1, VLSSEG8E64_V, 0x0 }, // 4789
  { PseudoVLSSEG8E64_V_M1_MASK, VLSSEG8E64_V, 0x0 }, // 4790
  { PseudoVLSSEG8E64_V_M1_TU, VLSSEG8E64_V, 0x0 }, // 4791
  { PseudoVLSSEG8E8_V_M1, VLSSEG8E8_V, 0x0 }, // 4792
  { PseudoVLSSEG8E8_V_M1_MASK, VLSSEG8E8_V, 0x0 }, // 4793
  { PseudoVLSSEG8E8_V_M1_TU, VLSSEG8E8_V, 0x0 }, // 4794
  { PseudoVLSSEG8E8_V_MF8, VLSSEG8E8_V, 0x5 }, // 4795
  { PseudoVLSSEG8E8_V_MF8_MASK, VLSSEG8E8_V, 0x5 }, // 4796
  { PseudoVLSSEG8E8_V_MF8_TU, VLSSEG8E8_V, 0x5 }, // 4797
  { PseudoVLSSEG8E8_V_MF4, VLSSEG8E8_V, 0x6 }, // 4798
  { PseudoVLSSEG8E8_V_MF4_MASK, VLSSEG8E8_V, 0x6 }, // 4799
  { PseudoVLSSEG8E8_V_MF4_TU, VLSSEG8E8_V, 0x6 }, // 4800
  { PseudoVLSSEG8E8_V_MF2, VLSSEG8E8_V, 0x7 }, // 4801
  { PseudoVLSSEG8E8_V_MF2_MASK, VLSSEG8E8_V, 0x7 }, // 4802
  { PseudoVLSSEG8E8_V_MF2_TU, VLSSEG8E8_V, 0x7 }, // 4803
  { PseudoVLUXEI16_V_M1_M1, VLUXEI16_V, 0x0 }, // 4804
  { PseudoVLUXEI16_V_M1_M1_MASK, VLUXEI16_V, 0x0 }, // 4805
  { PseudoVLUXEI16_V_M1_M1_TU, VLUXEI16_V, 0x0 }, // 4806
  { PseudoVLUXEI16_V_M2_M1, VLUXEI16_V, 0x0 }, // 4807
  { PseudoVLUXEI16_V_M2_M1_MASK, VLUXEI16_V, 0x0 }, // 4808
  { PseudoVLUXEI16_V_M2_M1_TU, VLUXEI16_V, 0x0 }, // 4809
  { PseudoVLUXEI16_V_MF2_M1, VLUXEI16_V, 0x0 }, // 4810
  { PseudoVLUXEI16_V_MF2_M1_MASK, VLUXEI16_V, 0x0 }, // 4811
  { PseudoVLUXEI16_V_MF2_M1_TU, VLUXEI16_V, 0x0 }, // 4812
  { PseudoVLUXEI16_V_MF4_M1, VLUXEI16_V, 0x0 }, // 4813
  { PseudoVLUXEI16_V_MF4_M1_MASK, VLUXEI16_V, 0x0 }, // 4814
  { PseudoVLUXEI16_V_MF4_M1_TU, VLUXEI16_V, 0x0 }, // 4815
  { PseudoVLUXEI16_V_M1_M2, VLUXEI16_V, 0x1 }, // 4816
  { PseudoVLUXEI16_V_M1_M2_MASK, VLUXEI16_V, 0x1 }, // 4817
  { PseudoVLUXEI16_V_M1_M2_TU, VLUXEI16_V, 0x1 }, // 4818
  { PseudoVLUXEI16_V_M2_M2, VLUXEI16_V, 0x1 }, // 4819
  { PseudoVLUXEI16_V_M2_M2_MASK, VLUXEI16_V, 0x1 }, // 4820
  { PseudoVLUXEI16_V_M2_M2_TU, VLUXEI16_V, 0x1 }, // 4821
  { PseudoVLUXEI16_V_M4_M2, VLUXEI16_V, 0x1 }, // 4822
  { PseudoVLUXEI16_V_M4_M2_MASK, VLUXEI16_V, 0x1 }, // 4823
  { PseudoVLUXEI16_V_M4_M2_TU, VLUXEI16_V, 0x1 }, // 4824
  { PseudoVLUXEI16_V_MF2_M2, VLUXEI16_V, 0x1 }, // 4825
  { PseudoVLUXEI16_V_MF2_M2_MASK, VLUXEI16_V, 0x1 }, // 4826
  { PseudoVLUXEI16_V_MF2_M2_TU, VLUXEI16_V, 0x1 }, // 4827
  { PseudoVLUXEI16_V_M1_M4, VLUXEI16_V, 0x2 }, // 4828
  { PseudoVLUXEI16_V_M1_M4_MASK, VLUXEI16_V, 0x2 }, // 4829
  { PseudoVLUXEI16_V_M1_M4_TU, VLUXEI16_V, 0x2 }, // 4830
  { PseudoVLUXEI16_V_M2_M4, VLUXEI16_V, 0x2 }, // 4831
  { PseudoVLUXEI16_V_M2_M4_MASK, VLUXEI16_V, 0x2 }, // 4832
  { PseudoVLUXEI16_V_M2_M4_TU, VLUXEI16_V, 0x2 }, // 4833
  { PseudoVLUXEI16_V_M4_M4, VLUXEI16_V, 0x2 }, // 4834
  { PseudoVLUXEI16_V_M4_M4_MASK, VLUXEI16_V, 0x2 }, // 4835
  { PseudoVLUXEI16_V_M4_M4_TU, VLUXEI16_V, 0x2 }, // 4836
  { PseudoVLUXEI16_V_M8_M4, VLUXEI16_V, 0x2 }, // 4837
  { PseudoVLUXEI16_V_M8_M4_MASK, VLUXEI16_V, 0x2 }, // 4838
  { PseudoVLUXEI16_V_M8_M4_TU, VLUXEI16_V, 0x2 }, // 4839
  { PseudoVLUXEI16_V_M2_M8, VLUXEI16_V, 0x3 }, // 4840
  { PseudoVLUXEI16_V_M2_M8_MASK, VLUXEI16_V, 0x3 }, // 4841
  { PseudoVLUXEI16_V_M2_M8_TU, VLUXEI16_V, 0x3 }, // 4842
  { PseudoVLUXEI16_V_M4_M8, VLUXEI16_V, 0x3 }, // 4843
  { PseudoVLUXEI16_V_M4_M8_MASK, VLUXEI16_V, 0x3 }, // 4844
  { PseudoVLUXEI16_V_M4_M8_TU, VLUXEI16_V, 0x3 }, // 4845
  { PseudoVLUXEI16_V_M8_M8, VLUXEI16_V, 0x3 }, // 4846
  { PseudoVLUXEI16_V_M8_M8_MASK, VLUXEI16_V, 0x3 }, // 4847
  { PseudoVLUXEI16_V_M8_M8_TU, VLUXEI16_V, 0x3 }, // 4848
  { PseudoVLUXEI16_V_MF4_MF8, VLUXEI16_V, 0x5 }, // 4849
  { PseudoVLUXEI16_V_MF4_MF8_MASK, VLUXEI16_V, 0x5 }, // 4850
  { PseudoVLUXEI16_V_MF4_MF8_TU, VLUXEI16_V, 0x5 }, // 4851
  { PseudoVLUXEI16_V_MF2_MF4, VLUXEI16_V, 0x6 }, // 4852
  { PseudoVLUXEI16_V_MF2_MF4_MASK, VLUXEI16_V, 0x6 }, // 4853
  { PseudoVLUXEI16_V_MF2_MF4_TU, VLUXEI16_V, 0x6 }, // 4854
  { PseudoVLUXEI16_V_MF4_MF4, VLUXEI16_V, 0x6 }, // 4855
  { PseudoVLUXEI16_V_MF4_MF4_MASK, VLUXEI16_V, 0x6 }, // 4856
  { PseudoVLUXEI16_V_MF4_MF4_TU, VLUXEI16_V, 0x6 }, // 4857
  { PseudoVLUXEI16_V_M1_MF2, VLUXEI16_V, 0x7 }, // 4858
  { PseudoVLUXEI16_V_M1_MF2_MASK, VLUXEI16_V, 0x7 }, // 4859
  { PseudoVLUXEI16_V_M1_MF2_TU, VLUXEI16_V, 0x7 }, // 4860
  { PseudoVLUXEI16_V_MF2_MF2, VLUXEI16_V, 0x7 }, // 4861
  { PseudoVLUXEI16_V_MF2_MF2_MASK, VLUXEI16_V, 0x7 }, // 4862
  { PseudoVLUXEI16_V_MF2_MF2_TU, VLUXEI16_V, 0x7 }, // 4863
  { PseudoVLUXEI16_V_MF4_MF2, VLUXEI16_V, 0x7 }, // 4864
  { PseudoVLUXEI16_V_MF4_MF2_MASK, VLUXEI16_V, 0x7 }, // 4865
  { PseudoVLUXEI16_V_MF4_MF2_TU, VLUXEI16_V, 0x7 }, // 4866
  { PseudoVLUXEI32_V_M1_M1, VLUXEI32_V, 0x0 }, // 4867
  { PseudoVLUXEI32_V_M1_M1_MASK, VLUXEI32_V, 0x0 }, // 4868
  { PseudoVLUXEI32_V_M1_M1_TU, VLUXEI32_V, 0x0 }, // 4869
  { PseudoVLUXEI32_V_M2_M1, VLUXEI32_V, 0x0 }, // 4870
  { PseudoVLUXEI32_V_M2_M1_MASK, VLUXEI32_V, 0x0 }, // 4871
  { PseudoVLUXEI32_V_M2_M1_TU, VLUXEI32_V, 0x0 }, // 4872
  { PseudoVLUXEI32_V_M4_M1, VLUXEI32_V, 0x0 }, // 4873
  { PseudoVLUXEI32_V_M4_M1_MASK, VLUXEI32_V, 0x0 }, // 4874
  { PseudoVLUXEI32_V_M4_M1_TU, VLUXEI32_V, 0x0 }, // 4875
  { PseudoVLUXEI32_V_MF2_M1, VLUXEI32_V, 0x0 }, // 4876
  { PseudoVLUXEI32_V_MF2_M1_MASK, VLUXEI32_V, 0x0 }, // 4877
  { PseudoVLUXEI32_V_MF2_M1_TU, VLUXEI32_V, 0x0 }, // 4878
  { PseudoVLUXEI32_V_M1_M2, VLUXEI32_V, 0x1 }, // 4879
  { PseudoVLUXEI32_V_M1_M2_MASK, VLUXEI32_V, 0x1 }, // 4880
  { PseudoVLUXEI32_V_M1_M2_TU, VLUXEI32_V, 0x1 }, // 4881
  { PseudoVLUXEI32_V_M2_M2, VLUXEI32_V, 0x1 }, // 4882
  { PseudoVLUXEI32_V_M2_M2_MASK, VLUXEI32_V, 0x1 }, // 4883
  { PseudoVLUXEI32_V_M2_M2_TU, VLUXEI32_V, 0x1 }, // 4884
  { PseudoVLUXEI32_V_M4_M2, VLUXEI32_V, 0x1 }, // 4885
  { PseudoVLUXEI32_V_M4_M2_MASK, VLUXEI32_V, 0x1 }, // 4886
  { PseudoVLUXEI32_V_M4_M2_TU, VLUXEI32_V, 0x1 }, // 4887
  { PseudoVLUXEI32_V_M8_M2, VLUXEI32_V, 0x1 }, // 4888
  { PseudoVLUXEI32_V_M8_M2_MASK, VLUXEI32_V, 0x1 }, // 4889
  { PseudoVLUXEI32_V_M8_M2_TU, VLUXEI32_V, 0x1 }, // 4890
  { PseudoVLUXEI32_V_M2_M4, VLUXEI32_V, 0x2 }, // 4891
  { PseudoVLUXEI32_V_M2_M4_MASK, VLUXEI32_V, 0x2 }, // 4892
  { PseudoVLUXEI32_V_M2_M4_TU, VLUXEI32_V, 0x2 }, // 4893
  { PseudoVLUXEI32_V_M4_M4, VLUXEI32_V, 0x2 }, // 4894
  { PseudoVLUXEI32_V_M4_M4_MASK, VLUXEI32_V, 0x2 }, // 4895
  { PseudoVLUXEI32_V_M4_M4_TU, VLUXEI32_V, 0x2 }, // 4896
  { PseudoVLUXEI32_V_M8_M4, VLUXEI32_V, 0x2 }, // 4897
  { PseudoVLUXEI32_V_M8_M4_MASK, VLUXEI32_V, 0x2 }, // 4898
  { PseudoVLUXEI32_V_M8_M4_TU, VLUXEI32_V, 0x2 }, // 4899
  { PseudoVLUXEI32_V_M4_M8, VLUXEI32_V, 0x3 }, // 4900
  { PseudoVLUXEI32_V_M4_M8_MASK, VLUXEI32_V, 0x3 }, // 4901
  { PseudoVLUXEI32_V_M4_M8_TU, VLUXEI32_V, 0x3 }, // 4902
  { PseudoVLUXEI32_V_M8_M8, VLUXEI32_V, 0x3 }, // 4903
  { PseudoVLUXEI32_V_M8_M8_MASK, VLUXEI32_V, 0x3 }, // 4904
  { PseudoVLUXEI32_V_M8_M8_TU, VLUXEI32_V, 0x3 }, // 4905
  { PseudoVLUXEI32_V_MF2_MF8, VLUXEI32_V, 0x5 }, // 4906
  { PseudoVLUXEI32_V_MF2_MF8_MASK, VLUXEI32_V, 0x5 }, // 4907
  { PseudoVLUXEI32_V_MF2_MF8_TU, VLUXEI32_V, 0x5 }, // 4908
  { PseudoVLUXEI32_V_M1_MF4, VLUXEI32_V, 0x6 }, // 4909
  { PseudoVLUXEI32_V_M1_MF4_MASK, VLUXEI32_V, 0x6 }, // 4910
  { PseudoVLUXEI32_V_M1_MF4_TU, VLUXEI32_V, 0x6 }, // 4911
  { PseudoVLUXEI32_V_MF2_MF4, VLUXEI32_V, 0x6 }, // 4912
  { PseudoVLUXEI32_V_MF2_MF4_MASK, VLUXEI32_V, 0x6 }, // 4913
  { PseudoVLUXEI32_V_MF2_MF4_TU, VLUXEI32_V, 0x6 }, // 4914
  { PseudoVLUXEI32_V_M1_MF2, VLUXEI32_V, 0x7 }, // 4915
  { PseudoVLUXEI32_V_M1_MF2_MASK, VLUXEI32_V, 0x7 }, // 4916
  { PseudoVLUXEI32_V_M1_MF2_TU, VLUXEI32_V, 0x7 }, // 4917
  { PseudoVLUXEI32_V_M2_MF2, VLUXEI32_V, 0x7 }, // 4918
  { PseudoVLUXEI32_V_M2_MF2_MASK, VLUXEI32_V, 0x7 }, // 4919
  { PseudoVLUXEI32_V_M2_MF2_TU, VLUXEI32_V, 0x7 }, // 4920
  { PseudoVLUXEI32_V_MF2_MF2, VLUXEI32_V, 0x7 }, // 4921
  { PseudoVLUXEI32_V_MF2_MF2_MASK, VLUXEI32_V, 0x7 }, // 4922
  { PseudoVLUXEI32_V_MF2_MF2_TU, VLUXEI32_V, 0x7 }, // 4923
  { PseudoVLUXEI64_V_M1_M1, VLUXEI64_V, 0x0 }, // 4924
  { PseudoVLUXEI64_V_M1_M1_MASK, VLUXEI64_V, 0x0 }, // 4925
  { PseudoVLUXEI64_V_M1_M1_TU, VLUXEI64_V, 0x0 }, // 4926
  { PseudoVLUXEI64_V_M2_M1, VLUXEI64_V, 0x0 }, // 4927
  { PseudoVLUXEI64_V_M2_M1_MASK, VLUXEI64_V, 0x0 }, // 4928
  { PseudoVLUXEI64_V_M2_M1_TU, VLUXEI64_V, 0x0 }, // 4929
  { PseudoVLUXEI64_V_M4_M1, VLUXEI64_V, 0x0 }, // 4930
  { PseudoVLUXEI64_V_M4_M1_MASK, VLUXEI64_V, 0x0 }, // 4931
  { PseudoVLUXEI64_V_M4_M1_TU, VLUXEI64_V, 0x0 }, // 4932
  { PseudoVLUXEI64_V_M8_M1, VLUXEI64_V, 0x0 }, // 4933
  { PseudoVLUXEI64_V_M8_M1_MASK, VLUXEI64_V, 0x0 }, // 4934
  { PseudoVLUXEI64_V_M8_M1_TU, VLUXEI64_V, 0x0 }, // 4935
  { PseudoVLUXEI64_V_M2_M2, VLUXEI64_V, 0x1 }, // 4936
  { PseudoVLUXEI64_V_M2_M2_MASK, VLUXEI64_V, 0x1 }, // 4937
  { PseudoVLUXEI64_V_M2_M2_TU, VLUXEI64_V, 0x1 }, // 4938
  { PseudoVLUXEI64_V_M4_M2, VLUXEI64_V, 0x1 }, // 4939
  { PseudoVLUXEI64_V_M4_M2_MASK, VLUXEI64_V, 0x1 }, // 4940
  { PseudoVLUXEI64_V_M4_M2_TU, VLUXEI64_V, 0x1 }, // 4941
  { PseudoVLUXEI64_V_M8_M2, VLUXEI64_V, 0x1 }, // 4942
  { PseudoVLUXEI64_V_M8_M2_MASK, VLUXEI64_V, 0x1 }, // 4943
  { PseudoVLUXEI64_V_M8_M2_TU, VLUXEI64_V, 0x1 }, // 4944
  { PseudoVLUXEI64_V_M4_M4, VLUXEI64_V, 0x2 }, // 4945
  { PseudoVLUXEI64_V_M4_M4_MASK, VLUXEI64_V, 0x2 }, // 4946
  { PseudoVLUXEI64_V_M4_M4_TU, VLUXEI64_V, 0x2 }, // 4947
  { PseudoVLUXEI64_V_M8_M4, VLUXEI64_V, 0x2 }, // 4948
  { PseudoVLUXEI64_V_M8_M4_MASK, VLUXEI64_V, 0x2 }, // 4949
  { PseudoVLUXEI64_V_M8_M4_TU, VLUXEI64_V, 0x2 }, // 4950
  { PseudoVLUXEI64_V_M8_M8, VLUXEI64_V, 0x3 }, // 4951
  { PseudoVLUXEI64_V_M8_M8_MASK, VLUXEI64_V, 0x3 }, // 4952
  { PseudoVLUXEI64_V_M8_M8_TU, VLUXEI64_V, 0x3 }, // 4953
  { PseudoVLUXEI64_V_M1_MF8, VLUXEI64_V, 0x5 }, // 4954
  { PseudoVLUXEI64_V_M1_MF8_MASK, VLUXEI64_V, 0x5 }, // 4955
  { PseudoVLUXEI64_V_M1_MF8_TU, VLUXEI64_V, 0x5 }, // 4956
  { PseudoVLUXEI64_V_M1_MF4, VLUXEI64_V, 0x6 }, // 4957
  { PseudoVLUXEI64_V_M1_MF4_MASK, VLUXEI64_V, 0x6 }, // 4958
  { PseudoVLUXEI64_V_M1_MF4_TU, VLUXEI64_V, 0x6 }, // 4959
  { PseudoVLUXEI64_V_M2_MF4, VLUXEI64_V, 0x6 }, // 4960
  { PseudoVLUXEI64_V_M2_MF4_MASK, VLUXEI64_V, 0x6 }, // 4961
  { PseudoVLUXEI64_V_M2_MF4_TU, VLUXEI64_V, 0x6 }, // 4962
  { PseudoVLUXEI64_V_M1_MF2, VLUXEI64_V, 0x7 }, // 4963
  { PseudoVLUXEI64_V_M1_MF2_MASK, VLUXEI64_V, 0x7 }, // 4964
  { PseudoVLUXEI64_V_M1_MF2_TU, VLUXEI64_V, 0x7 }, // 4965
  { PseudoVLUXEI64_V_M2_MF2, VLUXEI64_V, 0x7 }, // 4966
  { PseudoVLUXEI64_V_M2_MF2_MASK, VLUXEI64_V, 0x7 }, // 4967
  { PseudoVLUXEI64_V_M2_MF2_TU, VLUXEI64_V, 0x7 }, // 4968
  { PseudoVLUXEI64_V_M4_MF2, VLUXEI64_V, 0x7 }, // 4969
  { PseudoVLUXEI64_V_M4_MF2_MASK, VLUXEI64_V, 0x7 }, // 4970
  { PseudoVLUXEI64_V_M4_MF2_TU, VLUXEI64_V, 0x7 }, // 4971
  { PseudoVLUXEI8_V_M1_M1, VLUXEI8_V, 0x0 }, // 4972
  { PseudoVLUXEI8_V_M1_M1_MASK, VLUXEI8_V, 0x0 }, // 4973
  { PseudoVLUXEI8_V_M1_M1_TU, VLUXEI8_V, 0x0 }, // 4974
  { PseudoVLUXEI8_V_MF2_M1, VLUXEI8_V, 0x0 }, // 4975
  { PseudoVLUXEI8_V_MF2_M1_MASK, VLUXEI8_V, 0x0 }, // 4976
  { PseudoVLUXEI8_V_MF2_M1_TU, VLUXEI8_V, 0x0 }, // 4977
  { PseudoVLUXEI8_V_MF4_M1, VLUXEI8_V, 0x0 }, // 4978
  { PseudoVLUXEI8_V_MF4_M1_MASK, VLUXEI8_V, 0x0 }, // 4979
  { PseudoVLUXEI8_V_MF4_M1_TU, VLUXEI8_V, 0x0 }, // 4980
  { PseudoVLUXEI8_V_MF8_M1, VLUXEI8_V, 0x0 }, // 4981
  { PseudoVLUXEI8_V_MF8_M1_MASK, VLUXEI8_V, 0x0 }, // 4982
  { PseudoVLUXEI8_V_MF8_M1_TU, VLUXEI8_V, 0x0 }, // 4983
  { PseudoVLUXEI8_V_M1_M2, VLUXEI8_V, 0x1 }, // 4984
  { PseudoVLUXEI8_V_M1_M2_MASK, VLUXEI8_V, 0x1 }, // 4985
  { PseudoVLUXEI8_V_M1_M2_TU, VLUXEI8_V, 0x1 }, // 4986
  { PseudoVLUXEI8_V_M2_M2, VLUXEI8_V, 0x1 }, // 4987
  { PseudoVLUXEI8_V_M2_M2_MASK, VLUXEI8_V, 0x1 }, // 4988
  { PseudoVLUXEI8_V_M2_M2_TU, VLUXEI8_V, 0x1 }, // 4989
  { PseudoVLUXEI8_V_MF2_M2, VLUXEI8_V, 0x1 }, // 4990
  { PseudoVLUXEI8_V_MF2_M2_MASK, VLUXEI8_V, 0x1 }, // 4991
  { PseudoVLUXEI8_V_MF2_M2_TU, VLUXEI8_V, 0x1 }, // 4992
  { PseudoVLUXEI8_V_MF4_M2, VLUXEI8_V, 0x1 }, // 4993
  { PseudoVLUXEI8_V_MF4_M2_MASK, VLUXEI8_V, 0x1 }, // 4994
  { PseudoVLUXEI8_V_MF4_M2_TU, VLUXEI8_V, 0x1 }, // 4995
  { PseudoVLUXEI8_V_M1_M4, VLUXEI8_V, 0x2 }, // 4996
  { PseudoVLUXEI8_V_M1_M4_MASK, VLUXEI8_V, 0x2 }, // 4997
  { PseudoVLUXEI8_V_M1_M4_TU, VLUXEI8_V, 0x2 }, // 4998
  { PseudoVLUXEI8_V_M2_M4, VLUXEI8_V, 0x2 }, // 4999
  { PseudoVLUXEI8_V_M2_M4_MASK, VLUXEI8_V, 0x2 }, // 5000
  { PseudoVLUXEI8_V_M2_M4_TU, VLUXEI8_V, 0x2 }, // 5001
  { PseudoVLUXEI8_V_M4_M4, VLUXEI8_V, 0x2 }, // 5002
  { PseudoVLUXEI8_V_M4_M4_MASK, VLUXEI8_V, 0x2 }, // 5003
  { PseudoVLUXEI8_V_M4_M4_TU, VLUXEI8_V, 0x2 }, // 5004
  { PseudoVLUXEI8_V_MF2_M4, VLUXEI8_V, 0x2 }, // 5005
  { PseudoVLUXEI8_V_MF2_M4_MASK, VLUXEI8_V, 0x2 }, // 5006
  { PseudoVLUXEI8_V_MF2_M4_TU, VLUXEI8_V, 0x2 }, // 5007
  { PseudoVLUXEI8_V_M1_M8, VLUXEI8_V, 0x3 }, // 5008
  { PseudoVLUXEI8_V_M1_M8_MASK, VLUXEI8_V, 0x3 }, // 5009
  { PseudoVLUXEI8_V_M1_M8_TU, VLUXEI8_V, 0x3 }, // 5010
  { PseudoVLUXEI8_V_M2_M8, VLUXEI8_V, 0x3 }, // 5011
  { PseudoVLUXEI8_V_M2_M8_MASK, VLUXEI8_V, 0x3 }, // 5012
  { PseudoVLUXEI8_V_M2_M8_TU, VLUXEI8_V, 0x3 }, // 5013
  { PseudoVLUXEI8_V_M4_M8, VLUXEI8_V, 0x3 }, // 5014
  { PseudoVLUXEI8_V_M4_M8_MASK, VLUXEI8_V, 0x3 }, // 5015
  { PseudoVLUXEI8_V_M4_M8_TU, VLUXEI8_V, 0x3 }, // 5016
  { PseudoVLUXEI8_V_M8_M8, VLUXEI8_V, 0x3 }, // 5017
  { PseudoVLUXEI8_V_M8_M8_MASK, VLUXEI8_V, 0x3 }, // 5018
  { PseudoVLUXEI8_V_M8_M8_TU, VLUXEI8_V, 0x3 }, // 5019
  { PseudoVLUXEI8_V_MF8_MF8, VLUXEI8_V, 0x5 }, // 5020
  { PseudoVLUXEI8_V_MF8_MF8_MASK, VLUXEI8_V, 0x5 }, // 5021
  { PseudoVLUXEI8_V_MF8_MF8_TU, VLUXEI8_V, 0x5 }, // 5022
  { PseudoVLUXEI8_V_MF4_MF4, VLUXEI8_V, 0x6 }, // 5023
  { PseudoVLUXEI8_V_MF4_MF4_MASK, VLUXEI8_V, 0x6 }, // 5024
  { PseudoVLUXEI8_V_MF4_MF4_TU, VLUXEI8_V, 0x6 }, // 5025
  { PseudoVLUXEI8_V_MF8_MF4, VLUXEI8_V, 0x6 }, // 5026
  { PseudoVLUXEI8_V_MF8_MF4_MASK, VLUXEI8_V, 0x6 }, // 5027
  { PseudoVLUXEI8_V_MF8_MF4_TU, VLUXEI8_V, 0x6 }, // 5028
  { PseudoVLUXEI8_V_MF2_MF2, VLUXEI8_V, 0x7 }, // 5029
  { PseudoVLUXEI8_V_MF2_MF2_MASK, VLUXEI8_V, 0x7 }, // 5030
  { PseudoVLUXEI8_V_MF2_MF2_TU, VLUXEI8_V, 0x7 }, // 5031
  { PseudoVLUXEI8_V_MF4_MF2, VLUXEI8_V, 0x7 }, // 5032
  { PseudoVLUXEI8_V_MF4_MF2_MASK, VLUXEI8_V, 0x7 }, // 5033
  { PseudoVLUXEI8_V_MF4_MF2_TU, VLUXEI8_V, 0x7 }, // 5034
  { PseudoVLUXEI8_V_MF8_MF2, VLUXEI8_V, 0x7 }, // 5035
  { PseudoVLUXEI8_V_MF8_MF2_MASK, VLUXEI8_V, 0x7 }, // 5036
  { PseudoVLUXEI8_V_MF8_MF2_TU, VLUXEI8_V, 0x7 }, // 5037
  { PseudoVLUXSEG2EI16_V_M1_M1, VLUXSEG2EI16_V, 0x0 }, // 5038
  { PseudoVLUXSEG2EI16_V_M1_M1_MASK, VLUXSEG2EI16_V, 0x0 }, // 5039
  { PseudoVLUXSEG2EI16_V_M1_M1_TU, VLUXSEG2EI16_V, 0x0 }, // 5040
  { PseudoVLUXSEG2EI16_V_M2_M1, VLUXSEG2EI16_V, 0x0 }, // 5041
  { PseudoVLUXSEG2EI16_V_M2_M1_MASK, VLUXSEG2EI16_V, 0x0 }, // 5042
  { PseudoVLUXSEG2EI16_V_M2_M1_TU, VLUXSEG2EI16_V, 0x0 }, // 5043
  { PseudoVLUXSEG2EI16_V_MF2_M1, VLUXSEG2EI16_V, 0x0 }, // 5044
  { PseudoVLUXSEG2EI16_V_MF2_M1_MASK, VLUXSEG2EI16_V, 0x0 }, // 5045
  { PseudoVLUXSEG2EI16_V_MF2_M1_TU, VLUXSEG2EI16_V, 0x0 }, // 5046
  { PseudoVLUXSEG2EI16_V_MF4_M1, VLUXSEG2EI16_V, 0x0 }, // 5047
  { PseudoVLUXSEG2EI16_V_MF4_M1_MASK, VLUXSEG2EI16_V, 0x0 }, // 5048
  { PseudoVLUXSEG2EI16_V_MF4_M1_TU, VLUXSEG2EI16_V, 0x0 }, // 5049
  { PseudoVLUXSEG2EI16_V_M1_M2, VLUXSEG2EI16_V, 0x1 }, // 5050
  { PseudoVLUXSEG2EI16_V_M1_M2_MASK, VLUXSEG2EI16_V, 0x1 }, // 5051
  { PseudoVLUXSEG2EI16_V_M1_M2_TU, VLUXSEG2EI16_V, 0x1 }, // 5052
  { PseudoVLUXSEG2EI16_V_M2_M2, VLUXSEG2EI16_V, 0x1 }, // 5053
  { PseudoVLUXSEG2EI16_V_M2_M2_MASK, VLUXSEG2EI16_V, 0x1 }, // 5054
  { PseudoVLUXSEG2EI16_V_M2_M2_TU, VLUXSEG2EI16_V, 0x1 }, // 5055
  { PseudoVLUXSEG2EI16_V_M4_M2, VLUXSEG2EI16_V, 0x1 }, // 5056
  { PseudoVLUXSEG2EI16_V_M4_M2_MASK, VLUXSEG2EI16_V, 0x1 }, // 5057
  { PseudoVLUXSEG2EI16_V_M4_M2_TU, VLUXSEG2EI16_V, 0x1 }, // 5058
  { PseudoVLUXSEG2EI16_V_MF2_M2, VLUXSEG2EI16_V, 0x1 }, // 5059
  { PseudoVLUXSEG2EI16_V_MF2_M2_MASK, VLUXSEG2EI16_V, 0x1 }, // 5060
  { PseudoVLUXSEG2EI16_V_MF2_M2_TU, VLUXSEG2EI16_V, 0x1 }, // 5061
  { PseudoVLUXSEG2EI16_V_M1_M4, VLUXSEG2EI16_V, 0x2 }, // 5062
  { PseudoVLUXSEG2EI16_V_M1_M4_MASK, VLUXSEG2EI16_V, 0x2 }, // 5063
  { PseudoVLUXSEG2EI16_V_M1_M4_TU, VLUXSEG2EI16_V, 0x2 }, // 5064
  { PseudoVLUXSEG2EI16_V_M2_M4, VLUXSEG2EI16_V, 0x2 }, // 5065
  { PseudoVLUXSEG2EI16_V_M2_M4_MASK, VLUXSEG2EI16_V, 0x2 }, // 5066
  { PseudoVLUXSEG2EI16_V_M2_M4_TU, VLUXSEG2EI16_V, 0x2 }, // 5067
  { PseudoVLUXSEG2EI16_V_M4_M4, VLUXSEG2EI16_V, 0x2 }, // 5068
  { PseudoVLUXSEG2EI16_V_M4_M4_MASK, VLUXSEG2EI16_V, 0x2 }, // 5069
  { PseudoVLUXSEG2EI16_V_M4_M4_TU, VLUXSEG2EI16_V, 0x2 }, // 5070
  { PseudoVLUXSEG2EI16_V_M8_M4, VLUXSEG2EI16_V, 0x2 }, // 5071
  { PseudoVLUXSEG2EI16_V_M8_M4_MASK, VLUXSEG2EI16_V, 0x2 }, // 5072
  { PseudoVLUXSEG2EI16_V_M8_M4_TU, VLUXSEG2EI16_V, 0x2 }, // 5073
  { PseudoVLUXSEG2EI16_V_MF4_MF8, VLUXSEG2EI16_V, 0x5 }, // 5074
  { PseudoVLUXSEG2EI16_V_MF4_MF8_MASK, VLUXSEG2EI16_V, 0x5 }, // 5075
  { PseudoVLUXSEG2EI16_V_MF4_MF8_TU, VLUXSEG2EI16_V, 0x5 }, // 5076
  { PseudoVLUXSEG2EI16_V_MF2_MF4, VLUXSEG2EI16_V, 0x6 }, // 5077
  { PseudoVLUXSEG2EI16_V_MF2_MF4_MASK, VLUXSEG2EI16_V, 0x6 }, // 5078
  { PseudoVLUXSEG2EI16_V_MF2_MF4_TU, VLUXSEG2EI16_V, 0x6 }, // 5079
  { PseudoVLUXSEG2EI16_V_MF4_MF4, VLUXSEG2EI16_V, 0x6 }, // 5080
  { PseudoVLUXSEG2EI16_V_MF4_MF4_MASK, VLUXSEG2EI16_V, 0x6 }, // 5081
  { PseudoVLUXSEG2EI16_V_MF4_MF4_TU, VLUXSEG2EI16_V, 0x6 }, // 5082
  { PseudoVLUXSEG2EI16_V_M1_MF2, VLUXSEG2EI16_V, 0x7 }, // 5083
  { PseudoVLUXSEG2EI16_V_M1_MF2_MASK, VLUXSEG2EI16_V, 0x7 }, // 5084
  { PseudoVLUXSEG2EI16_V_M1_MF2_TU, VLUXSEG2EI16_V, 0x7 }, // 5085
  { PseudoVLUXSEG2EI16_V_MF2_MF2, VLUXSEG2EI16_V, 0x7 }, // 5086
  { PseudoVLUXSEG2EI16_V_MF2_MF2_MASK, VLUXSEG2EI16_V, 0x7 }, // 5087
  { PseudoVLUXSEG2EI16_V_MF2_MF2_TU, VLUXSEG2EI16_V, 0x7 }, // 5088
  { PseudoVLUXSEG2EI16_V_MF4_MF2, VLUXSEG2EI16_V, 0x7 }, // 5089
  { PseudoVLUXSEG2EI16_V_MF4_MF2_MASK, VLUXSEG2EI16_V, 0x7 }, // 5090
  { PseudoVLUXSEG2EI16_V_MF4_MF2_TU, VLUXSEG2EI16_V, 0x7 }, // 5091
  { PseudoVLUXSEG2EI32_V_M1_M1, VLUXSEG2EI32_V, 0x0 }, // 5092
  { PseudoVLUXSEG2EI32_V_M1_M1_MASK, VLUXSEG2EI32_V, 0x0 }, // 5093
  { PseudoVLUXSEG2EI32_V_M1_M1_TU, VLUXSEG2EI32_V, 0x0 }, // 5094
  { PseudoVLUXSEG2EI32_V_M2_M1, VLUXSEG2EI32_V, 0x0 }, // 5095
  { PseudoVLUXSEG2EI32_V_M2_M1_MASK, VLUXSEG2EI32_V, 0x0 }, // 5096
  { PseudoVLUXSEG2EI32_V_M2_M1_TU, VLUXSEG2EI32_V, 0x0 }, // 5097
  { PseudoVLUXSEG2EI32_V_M4_M1, VLUXSEG2EI32_V, 0x0 }, // 5098
  { PseudoVLUXSEG2EI32_V_M4_M1_MASK, VLUXSEG2EI32_V, 0x0 }, // 5099
  { PseudoVLUXSEG2EI32_V_M4_M1_TU, VLUXSEG2EI32_V, 0x0 }, // 5100
  { PseudoVLUXSEG2EI32_V_MF2_M1, VLUXSEG2EI32_V, 0x0 }, // 5101
  { PseudoVLUXSEG2EI32_V_MF2_M1_MASK, VLUXSEG2EI32_V, 0x0 }, // 5102
  { PseudoVLUXSEG2EI32_V_MF2_M1_TU, VLUXSEG2EI32_V, 0x0 }, // 5103
  { PseudoVLUXSEG2EI32_V_M1_M2, VLUXSEG2EI32_V, 0x1 }, // 5104
  { PseudoVLUXSEG2EI32_V_M1_M2_MASK, VLUXSEG2EI32_V, 0x1 }, // 5105
  { PseudoVLUXSEG2EI32_V_M1_M2_TU, VLUXSEG2EI32_V, 0x1 }, // 5106
  { PseudoVLUXSEG2EI32_V_M2_M2, VLUXSEG2EI32_V, 0x1 }, // 5107
  { PseudoVLUXSEG2EI32_V_M2_M2_MASK, VLUXSEG2EI32_V, 0x1 }, // 5108
  { PseudoVLUXSEG2EI32_V_M2_M2_TU, VLUXSEG2EI32_V, 0x1 }, // 5109
  { PseudoVLUXSEG2EI32_V_M4_M2, VLUXSEG2EI32_V, 0x1 }, // 5110
  { PseudoVLUXSEG2EI32_V_M4_M2_MASK, VLUXSEG2EI32_V, 0x1 }, // 5111
  { PseudoVLUXSEG2EI32_V_M4_M2_TU, VLUXSEG2EI32_V, 0x1 }, // 5112
  { PseudoVLUXSEG2EI32_V_M8_M2, VLUXSEG2EI32_V, 0x1 }, // 5113
  { PseudoVLUXSEG2EI32_V_M8_M2_MASK, VLUXSEG2EI32_V, 0x1 }, // 5114
  { PseudoVLUXSEG2EI32_V_M8_M2_TU, VLUXSEG2EI32_V, 0x1 }, // 5115
  { PseudoVLUXSEG2EI32_V_M2_M4, VLUXSEG2EI32_V, 0x2 }, // 5116
  { PseudoVLUXSEG2EI32_V_M2_M4_MASK, VLUXSEG2EI32_V, 0x2 }, // 5117
  { PseudoVLUXSEG2EI32_V_M2_M4_TU, VLUXSEG2EI32_V, 0x2 }, // 5118
  { PseudoVLUXSEG2EI32_V_M4_M4, VLUXSEG2EI32_V, 0x2 }, // 5119
  { PseudoVLUXSEG2EI32_V_M4_M4_MASK, VLUXSEG2EI32_V, 0x2 }, // 5120
  { PseudoVLUXSEG2EI32_V_M4_M4_TU, VLUXSEG2EI32_V, 0x2 }, // 5121
  { PseudoVLUXSEG2EI32_V_M8_M4, VLUXSEG2EI32_V, 0x2 }, // 5122
  { PseudoVLUXSEG2EI32_V_M8_M4_MASK, VLUXSEG2EI32_V, 0x2 }, // 5123
  { PseudoVLUXSEG2EI32_V_M8_M4_TU, VLUXSEG2EI32_V, 0x2 }, // 5124
  { PseudoVLUXSEG2EI32_V_MF2_MF8, VLUXSEG2EI32_V, 0x5 }, // 5125
  { PseudoVLUXSEG2EI32_V_MF2_MF8_MASK, VLUXSEG2EI32_V, 0x5 }, // 5126
  { PseudoVLUXSEG2EI32_V_MF2_MF8_TU, VLUXSEG2EI32_V, 0x5 }, // 5127
  { PseudoVLUXSEG2EI32_V_M1_MF4, VLUXSEG2EI32_V, 0x6 }, // 5128
  { PseudoVLUXSEG2EI32_V_M1_MF4_MASK, VLUXSEG2EI32_V, 0x6 }, // 5129
  { PseudoVLUXSEG2EI32_V_M1_MF4_TU, VLUXSEG2EI32_V, 0x6 }, // 5130
  { PseudoVLUXSEG2EI32_V_MF2_MF4, VLUXSEG2EI32_V, 0x6 }, // 5131
  { PseudoVLUXSEG2EI32_V_MF2_MF4_MASK, VLUXSEG2EI32_V, 0x6 }, // 5132
  { PseudoVLUXSEG2EI32_V_MF2_MF4_TU, VLUXSEG2EI32_V, 0x6 }, // 5133
  { PseudoVLUXSEG2EI32_V_M1_MF2, VLUXSEG2EI32_V, 0x7 }, // 5134
  { PseudoVLUXSEG2EI32_V_M1_MF2_MASK, VLUXSEG2EI32_V, 0x7 }, // 5135
  { PseudoVLUXSEG2EI32_V_M1_MF2_TU, VLUXSEG2EI32_V, 0x7 }, // 5136
  { PseudoVLUXSEG2EI32_V_M2_MF2, VLUXSEG2EI32_V, 0x7 }, // 5137
  { PseudoVLUXSEG2EI32_V_M2_MF2_MASK, VLUXSEG2EI32_V, 0x7 }, // 5138
  { PseudoVLUXSEG2EI32_V_M2_MF2_TU, VLUXSEG2EI32_V, 0x7 }, // 5139
  { PseudoVLUXSEG2EI32_V_MF2_MF2, VLUXSEG2EI32_V, 0x7 }, // 5140
  { PseudoVLUXSEG2EI32_V_MF2_MF2_MASK, VLUXSEG2EI32_V, 0x7 }, // 5141
  { PseudoVLUXSEG2EI32_V_MF2_MF2_TU, VLUXSEG2EI32_V, 0x7 }, // 5142
  { PseudoVLUXSEG2EI64_V_M1_M1, VLUXSEG2EI64_V, 0x0 }, // 5143
  { PseudoVLUXSEG2EI64_V_M1_M1_MASK, VLUXSEG2EI64_V, 0x0 }, // 5144
  { PseudoVLUXSEG2EI64_V_M1_M1_TU, VLUXSEG2EI64_V, 0x0 }, // 5145
  { PseudoVLUXSEG2EI64_V_M2_M1, VLUXSEG2EI64_V, 0x0 }, // 5146
  { PseudoVLUXSEG2EI64_V_M2_M1_MASK, VLUXSEG2EI64_V, 0x0 }, // 5147
  { PseudoVLUXSEG2EI64_V_M2_M1_TU, VLUXSEG2EI64_V, 0x0 }, // 5148
  { PseudoVLUXSEG2EI64_V_M4_M1, VLUXSEG2EI64_V, 0x0 }, // 5149
  { PseudoVLUXSEG2EI64_V_M4_M1_MASK, VLUXSEG2EI64_V, 0x0 }, // 5150
  { PseudoVLUXSEG2EI64_V_M4_M1_TU, VLUXSEG2EI64_V, 0x0 }, // 5151
  { PseudoVLUXSEG2EI64_V_M8_M1, VLUXSEG2EI64_V, 0x0 }, // 5152
  { PseudoVLUXSEG2EI64_V_M8_M1_MASK, VLUXSEG2EI64_V, 0x0 }, // 5153
  { PseudoVLUXSEG2EI64_V_M8_M1_TU, VLUXSEG2EI64_V, 0x0 }, // 5154
  { PseudoVLUXSEG2EI64_V_M2_M2, VLUXSEG2EI64_V, 0x1 }, // 5155
  { PseudoVLUXSEG2EI64_V_M2_M2_MASK, VLUXSEG2EI64_V, 0x1 }, // 5156
  { PseudoVLUXSEG2EI64_V_M2_M2_TU, VLUXSEG2EI64_V, 0x1 }, // 5157
  { PseudoVLUXSEG2EI64_V_M4_M2, VLUXSEG2EI64_V, 0x1 }, // 5158
  { PseudoVLUXSEG2EI64_V_M4_M2_MASK, VLUXSEG2EI64_V, 0x1 }, // 5159
  { PseudoVLUXSEG2EI64_V_M4_M2_TU, VLUXSEG2EI64_V, 0x1 }, // 5160
  { PseudoVLUXSEG2EI64_V_M8_M2, VLUXSEG2EI64_V, 0x1 }, // 5161
  { PseudoVLUXSEG2EI64_V_M8_M2_MASK, VLUXSEG2EI64_V, 0x1 }, // 5162
  { PseudoVLUXSEG2EI64_V_M8_M2_TU, VLUXSEG2EI64_V, 0x1 }, // 5163
  { PseudoVLUXSEG2EI64_V_M4_M4, VLUXSEG2EI64_V, 0x2 }, // 5164
  { PseudoVLUXSEG2EI64_V_M4_M4_MASK, VLUXSEG2EI64_V, 0x2 }, // 5165
  { PseudoVLUXSEG2EI64_V_M4_M4_TU, VLUXSEG2EI64_V, 0x2 }, // 5166
  { PseudoVLUXSEG2EI64_V_M8_M4, VLUXSEG2EI64_V, 0x2 }, // 5167
  { PseudoVLUXSEG2EI64_V_M8_M4_MASK, VLUXSEG2EI64_V, 0x2 }, // 5168
  { PseudoVLUXSEG2EI64_V_M8_M4_TU, VLUXSEG2EI64_V, 0x2 }, // 5169
  { PseudoVLUXSEG2EI64_V_M1_MF8, VLUXSEG2EI64_V, 0x5 }, // 5170
  { PseudoVLUXSEG2EI64_V_M1_MF8_MASK, VLUXSEG2EI64_V, 0x5 }, // 5171
  { PseudoVLUXSEG2EI64_V_M1_MF8_TU, VLUXSEG2EI64_V, 0x5 }, // 5172
  { PseudoVLUXSEG2EI64_V_M1_MF4, VLUXSEG2EI64_V, 0x6 }, // 5173
  { PseudoVLUXSEG2EI64_V_M1_MF4_MASK, VLUXSEG2EI64_V, 0x6 }, // 5174
  { PseudoVLUXSEG2EI64_V_M1_MF4_TU, VLUXSEG2EI64_V, 0x6 }, // 5175
  { PseudoVLUXSEG2EI64_V_M2_MF4, VLUXSEG2EI64_V, 0x6 }, // 5176
  { PseudoVLUXSEG2EI64_V_M2_MF4_MASK, VLUXSEG2EI64_V, 0x6 }, // 5177
  { PseudoVLUXSEG2EI64_V_M2_MF4_TU, VLUXSEG2EI64_V, 0x6 }, // 5178
  { PseudoVLUXSEG2EI64_V_M1_MF2, VLUXSEG2EI64_V, 0x7 }, // 5179
  { PseudoVLUXSEG2EI64_V_M1_MF2_MASK, VLUXSEG2EI64_V, 0x7 }, // 5180
  { PseudoVLUXSEG2EI64_V_M1_MF2_TU, VLUXSEG2EI64_V, 0x7 }, // 5181
  { PseudoVLUXSEG2EI64_V_M2_MF2, VLUXSEG2EI64_V, 0x7 }, // 5182
  { PseudoVLUXSEG2EI64_V_M2_MF2_MASK, VLUXSEG2EI64_V, 0x7 }, // 5183
  { PseudoVLUXSEG2EI64_V_M2_MF2_TU, VLUXSEG2EI64_V, 0x7 }, // 5184
  { PseudoVLUXSEG2EI64_V_M4_MF2, VLUXSEG2EI64_V, 0x7 }, // 5185
  { PseudoVLUXSEG2EI64_V_M4_MF2_MASK, VLUXSEG2EI64_V, 0x7 }, // 5186
  { PseudoVLUXSEG2EI64_V_M4_MF2_TU, VLUXSEG2EI64_V, 0x7 }, // 5187
  { PseudoVLUXSEG2EI8_V_M1_M1, VLUXSEG2EI8_V, 0x0 }, // 5188
  { PseudoVLUXSEG2EI8_V_M1_M1_MASK, VLUXSEG2EI8_V, 0x0 }, // 5189
  { PseudoVLUXSEG2EI8_V_M1_M1_TU, VLUXSEG2EI8_V, 0x0 }, // 5190
  { PseudoVLUXSEG2EI8_V_MF2_M1, VLUXSEG2EI8_V, 0x0 }, // 5191
  { PseudoVLUXSEG2EI8_V_MF2_M1_MASK, VLUXSEG2EI8_V, 0x0 }, // 5192
  { PseudoVLUXSEG2EI8_V_MF2_M1_TU, VLUXSEG2EI8_V, 0x0 }, // 5193
  { PseudoVLUXSEG2EI8_V_MF4_M1, VLUXSEG2EI8_V, 0x0 }, // 5194
  { PseudoVLUXSEG2EI8_V_MF4_M1_MASK, VLUXSEG2EI8_V, 0x0 }, // 5195
  { PseudoVLUXSEG2EI8_V_MF4_M1_TU, VLUXSEG2EI8_V, 0x0 }, // 5196
  { PseudoVLUXSEG2EI8_V_MF8_M1, VLUXSEG2EI8_V, 0x0 }, // 5197
  { PseudoVLUXSEG2EI8_V_MF8_M1_MASK, VLUXSEG2EI8_V, 0x0 }, // 5198
  { PseudoVLUXSEG2EI8_V_MF8_M1_TU, VLUXSEG2EI8_V, 0x0 }, // 5199
  { PseudoVLUXSEG2EI8_V_M1_M2, VLUXSEG2EI8_V, 0x1 }, // 5200
  { PseudoVLUXSEG2EI8_V_M1_M2_MASK, VLUXSEG2EI8_V, 0x1 }, // 5201
  { PseudoVLUXSEG2EI8_V_M1_M2_TU, VLUXSEG2EI8_V, 0x1 }, // 5202
  { PseudoVLUXSEG2EI8_V_M2_M2, VLUXSEG2EI8_V, 0x1 }, // 5203
  { PseudoVLUXSEG2EI8_V_M2_M2_MASK, VLUXSEG2EI8_V, 0x1 }, // 5204
  { PseudoVLUXSEG2EI8_V_M2_M2_TU, VLUXSEG2EI8_V, 0x1 }, // 5205
  { PseudoVLUXSEG2EI8_V_MF2_M2, VLUXSEG2EI8_V, 0x1 }, // 5206
  { PseudoVLUXSEG2EI8_V_MF2_M2_MASK, VLUXSEG2EI8_V, 0x1 }, // 5207
  { PseudoVLUXSEG2EI8_V_MF2_M2_TU, VLUXSEG2EI8_V, 0x1 }, // 5208
  { PseudoVLUXSEG2EI8_V_MF4_M2, VLUXSEG2EI8_V, 0x1 }, // 5209
  { PseudoVLUXSEG2EI8_V_MF4_M2_MASK, VLUXSEG2EI8_V, 0x1 }, // 5210
  { PseudoVLUXSEG2EI8_V_MF4_M2_TU, VLUXSEG2EI8_V, 0x1 }, // 5211
  { PseudoVLUXSEG2EI8_V_M1_M4, VLUXSEG2EI8_V, 0x2 }, // 5212
  { PseudoVLUXSEG2EI8_V_M1_M4_MASK, VLUXSEG2EI8_V, 0x2 }, // 5213
  { PseudoVLUXSEG2EI8_V_M1_M4_TU, VLUXSEG2EI8_V, 0x2 }, // 5214
  { PseudoVLUXSEG2EI8_V_M2_M4, VLUXSEG2EI8_V, 0x2 }, // 5215
  { PseudoVLUXSEG2EI8_V_M2_M4_MASK, VLUXSEG2EI8_V, 0x2 }, // 5216
  { PseudoVLUXSEG2EI8_V_M2_M4_TU, VLUXSEG2EI8_V, 0x2 }, // 5217
  { PseudoVLUXSEG2EI8_V_M4_M4, VLUXSEG2EI8_V, 0x2 }, // 5218
  { PseudoVLUXSEG2EI8_V_M4_M4_MASK, VLUXSEG2EI8_V, 0x2 }, // 5219
  { PseudoVLUXSEG2EI8_V_M4_M4_TU, VLUXSEG2EI8_V, 0x2 }, // 5220
  { PseudoVLUXSEG2EI8_V_MF2_M4, VLUXSEG2EI8_V, 0x2 }, // 5221
  { PseudoVLUXSEG2EI8_V_MF2_M4_MASK, VLUXSEG2EI8_V, 0x2 }, // 5222
  { PseudoVLUXSEG2EI8_V_MF2_M4_TU, VLUXSEG2EI8_V, 0x2 }, // 5223
  { PseudoVLUXSEG2EI8_V_MF8_MF8, VLUXSEG2EI8_V, 0x5 }, // 5224
  { PseudoVLUXSEG2EI8_V_MF8_MF8_MASK, VLUXSEG2EI8_V, 0x5 }, // 5225
  { PseudoVLUXSEG2EI8_V_MF8_MF8_TU, VLUXSEG2EI8_V, 0x5 }, // 5226
  { PseudoVLUXSEG2EI8_V_MF4_MF4, VLUXSEG2EI8_V, 0x6 }, // 5227
  { PseudoVLUXSEG2EI8_V_MF4_MF4_MASK, VLUXSEG2EI8_V, 0x6 }, // 5228
  { PseudoVLUXSEG2EI8_V_MF4_MF4_TU, VLUXSEG2EI8_V, 0x6 }, // 5229
  { PseudoVLUXSEG2EI8_V_MF8_MF4, VLUXSEG2EI8_V, 0x6 }, // 5230
  { PseudoVLUXSEG2EI8_V_MF8_MF4_MASK, VLUXSEG2EI8_V, 0x6 }, // 5231
  { PseudoVLUXSEG2EI8_V_MF8_MF4_TU, VLUXSEG2EI8_V, 0x6 }, // 5232
  { PseudoVLUXSEG2EI8_V_MF2_MF2, VLUXSEG2EI8_V, 0x7 }, // 5233
  { PseudoVLUXSEG2EI8_V_MF2_MF2_MASK, VLUXSEG2EI8_V, 0x7 }, // 5234
  { PseudoVLUXSEG2EI8_V_MF2_MF2_TU, VLUXSEG2EI8_V, 0x7 }, // 5235
  { PseudoVLUXSEG2EI8_V_MF4_MF2, VLUXSEG2EI8_V, 0x7 }, // 5236
  { PseudoVLUXSEG2EI8_V_MF4_MF2_MASK, VLUXSEG2EI8_V, 0x7 }, // 5237
  { PseudoVLUXSEG2EI8_V_MF4_MF2_TU, VLUXSEG2EI8_V, 0x7 }, // 5238
  { PseudoVLUXSEG2EI8_V_MF8_MF2, VLUXSEG2EI8_V, 0x7 }, // 5239
  { PseudoVLUXSEG2EI8_V_MF8_MF2_MASK, VLUXSEG2EI8_V, 0x7 }, // 5240
  { PseudoVLUXSEG2EI8_V_MF8_MF2_TU, VLUXSEG2EI8_V, 0x7 }, // 5241
  { PseudoVLUXSEG3EI16_V_M1_M1, VLUXSEG3EI16_V, 0x0 }, // 5242
  { PseudoVLUXSEG3EI16_V_M1_M1_MASK, VLUXSEG3EI16_V, 0x0 }, // 5243
  { PseudoVLUXSEG3EI16_V_M1_M1_TU, VLUXSEG3EI16_V, 0x0 }, // 5244
  { PseudoVLUXSEG3EI16_V_M2_M1, VLUXSEG3EI16_V, 0x0 }, // 5245
  { PseudoVLUXSEG3EI16_V_M2_M1_MASK, VLUXSEG3EI16_V, 0x0 }, // 5246
  { PseudoVLUXSEG3EI16_V_M2_M1_TU, VLUXSEG3EI16_V, 0x0 }, // 5247
  { PseudoVLUXSEG3EI16_V_MF2_M1, VLUXSEG3EI16_V, 0x0 }, // 5248
  { PseudoVLUXSEG3EI16_V_MF2_M1_MASK, VLUXSEG3EI16_V, 0x0 }, // 5249
  { PseudoVLUXSEG3EI16_V_MF2_M1_TU, VLUXSEG3EI16_V, 0x0 }, // 5250
  { PseudoVLUXSEG3EI16_V_MF4_M1, VLUXSEG3EI16_V, 0x0 }, // 5251
  { PseudoVLUXSEG3EI16_V_MF4_M1_MASK, VLUXSEG3EI16_V, 0x0 }, // 5252
  { PseudoVLUXSEG3EI16_V_MF4_M1_TU, VLUXSEG3EI16_V, 0x0 }, // 5253
  { PseudoVLUXSEG3EI16_V_M1_M2, VLUXSEG3EI16_V, 0x1 }, // 5254
  { PseudoVLUXSEG3EI16_V_M1_M2_MASK, VLUXSEG3EI16_V, 0x1 }, // 5255
  { PseudoVLUXSEG3EI16_V_M1_M2_TU, VLUXSEG3EI16_V, 0x1 }, // 5256
  { PseudoVLUXSEG3EI16_V_M2_M2, VLUXSEG3EI16_V, 0x1 }, // 5257
  { PseudoVLUXSEG3EI16_V_M2_M2_MASK, VLUXSEG3EI16_V, 0x1 }, // 5258
  { PseudoVLUXSEG3EI16_V_M2_M2_TU, VLUXSEG3EI16_V, 0x1 }, // 5259
  { PseudoVLUXSEG3EI16_V_M4_M2, VLUXSEG3EI16_V, 0x1 }, // 5260
  { PseudoVLUXSEG3EI16_V_M4_M2_MASK, VLUXSEG3EI16_V, 0x1 }, // 5261
  { PseudoVLUXSEG3EI16_V_M4_M2_TU, VLUXSEG3EI16_V, 0x1 }, // 5262
  { PseudoVLUXSEG3EI16_V_MF2_M2, VLUXSEG3EI16_V, 0x1 }, // 5263
  { PseudoVLUXSEG3EI16_V_MF2_M2_MASK, VLUXSEG3EI16_V, 0x1 }, // 5264
  { PseudoVLUXSEG3EI16_V_MF2_M2_TU, VLUXSEG3EI16_V, 0x1 }, // 5265
  { PseudoVLUXSEG3EI16_V_MF4_MF8, VLUXSEG3EI16_V, 0x5 }, // 5266
  { PseudoVLUXSEG3EI16_V_MF4_MF8_MASK, VLUXSEG3EI16_V, 0x5 }, // 5267
  { PseudoVLUXSEG3EI16_V_MF4_MF8_TU, VLUXSEG3EI16_V, 0x5 }, // 5268
  { PseudoVLUXSEG3EI16_V_MF2_MF4, VLUXSEG3EI16_V, 0x6 }, // 5269
  { PseudoVLUXSEG3EI16_V_MF2_MF4_MASK, VLUXSEG3EI16_V, 0x6 }, // 5270
  { PseudoVLUXSEG3EI16_V_MF2_MF4_TU, VLUXSEG3EI16_V, 0x6 }, // 5271
  { PseudoVLUXSEG3EI16_V_MF4_MF4, VLUXSEG3EI16_V, 0x6 }, // 5272
  { PseudoVLUXSEG3EI16_V_MF4_MF4_MASK, VLUXSEG3EI16_V, 0x6 }, // 5273
  { PseudoVLUXSEG3EI16_V_MF4_MF4_TU, VLUXSEG3EI16_V, 0x6 }, // 5274
  { PseudoVLUXSEG3EI16_V_M1_MF2, VLUXSEG3EI16_V, 0x7 }, // 5275
  { PseudoVLUXSEG3EI16_V_M1_MF2_MASK, VLUXSEG3EI16_V, 0x7 }, // 5276
  { PseudoVLUXSEG3EI16_V_M1_MF2_TU, VLUXSEG3EI16_V, 0x7 }, // 5277
  { PseudoVLUXSEG3EI16_V_MF2_MF2, VLUXSEG3EI16_V, 0x7 }, // 5278
  { PseudoVLUXSEG3EI16_V_MF2_MF2_MASK, VLUXSEG3EI16_V, 0x7 }, // 5279
  { PseudoVLUXSEG3EI16_V_MF2_MF2_TU, VLUXSEG3EI16_V, 0x7 }, // 5280
  { PseudoVLUXSEG3EI16_V_MF4_MF2, VLUXSEG3EI16_V, 0x7 }, // 5281
  { PseudoVLUXSEG3EI16_V_MF4_MF2_MASK, VLUXSEG3EI16_V, 0x7 }, // 5282
  { PseudoVLUXSEG3EI16_V_MF4_MF2_TU, VLUXSEG3EI16_V, 0x7 }, // 5283
  { PseudoVLUXSEG3EI32_V_M1_M1, VLUXSEG3EI32_V, 0x0 }, // 5284
  { PseudoVLUXSEG3EI32_V_M1_M1_MASK, VLUXSEG3EI32_V, 0x0 }, // 5285
  { PseudoVLUXSEG3EI32_V_M1_M1_TU, VLUXSEG3EI32_V, 0x0 }, // 5286
  { PseudoVLUXSEG3EI32_V_M2_M1, VLUXSEG3EI32_V, 0x0 }, // 5287
  { PseudoVLUXSEG3EI32_V_M2_M1_MASK, VLUXSEG3EI32_V, 0x0 }, // 5288
  { PseudoVLUXSEG3EI32_V_M2_M1_TU, VLUXSEG3EI32_V, 0x0 }, // 5289
  { PseudoVLUXSEG3EI32_V_M4_M1, VLUXSEG3EI32_V, 0x0 }, // 5290
  { PseudoVLUXSEG3EI32_V_M4_M1_MASK, VLUXSEG3EI32_V, 0x0 }, // 5291
  { PseudoVLUXSEG3EI32_V_M4_M1_TU, VLUXSEG3EI32_V, 0x0 }, // 5292
  { PseudoVLUXSEG3EI32_V_MF2_M1, VLUXSEG3EI32_V, 0x0 }, // 5293
  { PseudoVLUXSEG3EI32_V_MF2_M1_MASK, VLUXSEG3EI32_V, 0x0 }, // 5294
  { PseudoVLUXSEG3EI32_V_MF2_M1_TU, VLUXSEG3EI32_V, 0x0 }, // 5295
  { PseudoVLUXSEG3EI32_V_M1_M2, VLUXSEG3EI32_V, 0x1 }, // 5296
  { PseudoVLUXSEG3EI32_V_M1_M2_MASK, VLUXSEG3EI32_V, 0x1 }, // 5297
  { PseudoVLUXSEG3EI32_V_M1_M2_TU, VLUXSEG3EI32_V, 0x1 }, // 5298
  { PseudoVLUXSEG3EI32_V_M2_M2, VLUXSEG3EI32_V, 0x1 }, // 5299
  { PseudoVLUXSEG3EI32_V_M2_M2_MASK, VLUXSEG3EI32_V, 0x1 }, // 5300
  { PseudoVLUXSEG3EI32_V_M2_M2_TU, VLUXSEG3EI32_V, 0x1 }, // 5301
  { PseudoVLUXSEG3EI32_V_M4_M2, VLUXSEG3EI32_V, 0x1 }, // 5302
  { PseudoVLUXSEG3EI32_V_M4_M2_MASK, VLUXSEG3EI32_V, 0x1 }, // 5303
  { PseudoVLUXSEG3EI32_V_M4_M2_TU, VLUXSEG3EI32_V, 0x1 }, // 5304
  { PseudoVLUXSEG3EI32_V_M8_M2, VLUXSEG3EI32_V, 0x1 }, // 5305
  { PseudoVLUXSEG3EI32_V_M8_M2_MASK, VLUXSEG3EI32_V, 0x1 }, // 5306
  { PseudoVLUXSEG3EI32_V_M8_M2_TU, VLUXSEG3EI32_V, 0x1 }, // 5307
  { PseudoVLUXSEG3EI32_V_MF2_MF8, VLUXSEG3EI32_V, 0x5 }, // 5308
  { PseudoVLUXSEG3EI32_V_MF2_MF8_MASK, VLUXSEG3EI32_V, 0x5 }, // 5309
  { PseudoVLUXSEG3EI32_V_MF2_MF8_TU, VLUXSEG3EI32_V, 0x5 }, // 5310
  { PseudoVLUXSEG3EI32_V_M1_MF4, VLUXSEG3EI32_V, 0x6 }, // 5311
  { PseudoVLUXSEG3EI32_V_M1_MF4_MASK, VLUXSEG3EI32_V, 0x6 }, // 5312
  { PseudoVLUXSEG3EI32_V_M1_MF4_TU, VLUXSEG3EI32_V, 0x6 }, // 5313
  { PseudoVLUXSEG3EI32_V_MF2_MF4, VLUXSEG3EI32_V, 0x6 }, // 5314
  { PseudoVLUXSEG3EI32_V_MF2_MF4_MASK, VLUXSEG3EI32_V, 0x6 }, // 5315
  { PseudoVLUXSEG3EI32_V_MF2_MF4_TU, VLUXSEG3EI32_V, 0x6 }, // 5316
  { PseudoVLUXSEG3EI32_V_M1_MF2, VLUXSEG3EI32_V, 0x7 }, // 5317
  { PseudoVLUXSEG3EI32_V_M1_MF2_MASK, VLUXSEG3EI32_V, 0x7 }, // 5318
  { PseudoVLUXSEG3EI32_V_M1_MF2_TU, VLUXSEG3EI32_V, 0x7 }, // 5319
  { PseudoVLUXSEG3EI32_V_M2_MF2, VLUXSEG3EI32_V, 0x7 }, // 5320
  { PseudoVLUXSEG3EI32_V_M2_MF2_MASK, VLUXSEG3EI32_V, 0x7 }, // 5321
  { PseudoVLUXSEG3EI32_V_M2_MF2_TU, VLUXSEG3EI32_V, 0x7 }, // 5322
  { PseudoVLUXSEG3EI32_V_MF2_MF2, VLUXSEG3EI32_V, 0x7 }, // 5323
  { PseudoVLUXSEG3EI32_V_MF2_MF2_MASK, VLUXSEG3EI32_V, 0x7 }, // 5324
  { PseudoVLUXSEG3EI32_V_MF2_MF2_TU, VLUXSEG3EI32_V, 0x7 }, // 5325
  { PseudoVLUXSEG3EI64_V_M1_M1, VLUXSEG3EI64_V, 0x0 }, // 5326
  { PseudoVLUXSEG3EI64_V_M1_M1_MASK, VLUXSEG3EI64_V, 0x0 }, // 5327
  { PseudoVLUXSEG3EI64_V_M1_M1_TU, VLUXSEG3EI64_V, 0x0 }, // 5328
  { PseudoVLUXSEG3EI64_V_M2_M1, VLUXSEG3EI64_V, 0x0 }, // 5329
  { PseudoVLUXSEG3EI64_V_M2_M1_MASK, VLUXSEG3EI64_V, 0x0 }, // 5330
  { PseudoVLUXSEG3EI64_V_M2_M1_TU, VLUXSEG3EI64_V, 0x0 }, // 5331
  { PseudoVLUXSEG3EI64_V_M4_M1, VLUXSEG3EI64_V, 0x0 }, // 5332
  { PseudoVLUXSEG3EI64_V_M4_M1_MASK, VLUXSEG3EI64_V, 0x0 }, // 5333
  { PseudoVLUXSEG3EI64_V_M4_M1_TU, VLUXSEG3EI64_V, 0x0 }, // 5334
  { PseudoVLUXSEG3EI64_V_M8_M1, VLUXSEG3EI64_V, 0x0 }, // 5335
  { PseudoVLUXSEG3EI64_V_M8_M1_MASK, VLUXSEG3EI64_V, 0x0 }, // 5336
  { PseudoVLUXSEG3EI64_V_M8_M1_TU, VLUXSEG3EI64_V, 0x0 }, // 5337
  { PseudoVLUXSEG3EI64_V_M2_M2, VLUXSEG3EI64_V, 0x1 }, // 5338
  { PseudoVLUXSEG3EI64_V_M2_M2_MASK, VLUXSEG3EI64_V, 0x1 }, // 5339
  { PseudoVLUXSEG3EI64_V_M2_M2_TU, VLUXSEG3EI64_V, 0x1 }, // 5340
  { PseudoVLUXSEG3EI64_V_M4_M2, VLUXSEG3EI64_V, 0x1 }, // 5341
  { PseudoVLUXSEG3EI64_V_M4_M2_MASK, VLUXSEG3EI64_V, 0x1 }, // 5342
  { PseudoVLUXSEG3EI64_V_M4_M2_TU, VLUXSEG3EI64_V, 0x1 }, // 5343
  { PseudoVLUXSEG3EI64_V_M8_M2, VLUXSEG3EI64_V, 0x1 }, // 5344
  { PseudoVLUXSEG3EI64_V_M8_M2_MASK, VLUXSEG3EI64_V, 0x1 }, // 5345
  { PseudoVLUXSEG3EI64_V_M8_M2_TU, VLUXSEG3EI64_V, 0x1 }, // 5346
  { PseudoVLUXSEG3EI64_V_M1_MF8, VLUXSEG3EI64_V, 0x5 }, // 5347
  { PseudoVLUXSEG3EI64_V_M1_MF8_MASK, VLUXSEG3EI64_V, 0x5 }, // 5348
  { PseudoVLUXSEG3EI64_V_M1_MF8_TU, VLUXSEG3EI64_V, 0x5 }, // 5349
  { PseudoVLUXSEG3EI64_V_M1_MF4, VLUXSEG3EI64_V, 0x6 }, // 5350
  { PseudoVLUXSEG3EI64_V_M1_MF4_MASK, VLUXSEG3EI64_V, 0x6 }, // 5351
  { PseudoVLUXSEG3EI64_V_M1_MF4_TU, VLUXSEG3EI64_V, 0x6 }, // 5352
  { PseudoVLUXSEG3EI64_V_M2_MF4, VLUXSEG3EI64_V, 0x6 }, // 5353
  { PseudoVLUXSEG3EI64_V_M2_MF4_MASK, VLUXSEG3EI64_V, 0x6 }, // 5354
  { PseudoVLUXSEG3EI64_V_M2_MF4_TU, VLUXSEG3EI64_V, 0x6 }, // 5355
  { PseudoVLUXSEG3EI64_V_M1_MF2, VLUXSEG3EI64_V, 0x7 }, // 5356
  { PseudoVLUXSEG3EI64_V_M1_MF2_MASK, VLUXSEG3EI64_V, 0x7 }, // 5357
  { PseudoVLUXSEG3EI64_V_M1_MF2_TU, VLUXSEG3EI64_V, 0x7 }, // 5358
  { PseudoVLUXSEG3EI64_V_M2_MF2, VLUXSEG3EI64_V, 0x7 }, // 5359
  { PseudoVLUXSEG3EI64_V_M2_MF2_MASK, VLUXSEG3EI64_V, 0x7 }, // 5360
  { PseudoVLUXSEG3EI64_V_M2_MF2_TU, VLUXSEG3EI64_V, 0x7 }, // 5361
  { PseudoVLUXSEG3EI64_V_M4_MF2, VLUXSEG3EI64_V, 0x7 }, // 5362
  { PseudoVLUXSEG3EI64_V_M4_MF2_MASK, VLUXSEG3EI64_V, 0x7 }, // 5363
  { PseudoVLUXSEG3EI64_V_M4_MF2_TU, VLUXSEG3EI64_V, 0x7 }, // 5364
  { PseudoVLUXSEG3EI8_V_M1_M1, VLUXSEG3EI8_V, 0x0 }, // 5365
  { PseudoVLUXSEG3EI8_V_M1_M1_MASK, VLUXSEG3EI8_V, 0x0 }, // 5366
  { PseudoVLUXSEG3EI8_V_M1_M1_TU, VLUXSEG3EI8_V, 0x0 }, // 5367
  { PseudoVLUXSEG3EI8_V_MF2_M1, VLUXSEG3EI8_V, 0x0 }, // 5368
  { PseudoVLUXSEG3EI8_V_MF2_M1_MASK, VLUXSEG3EI8_V, 0x0 }, // 5369
  { PseudoVLUXSEG3EI8_V_MF2_M1_TU, VLUXSEG3EI8_V, 0x0 }, // 5370
  { PseudoVLUXSEG3EI8_V_MF4_M1, VLUXSEG3EI8_V, 0x0 }, // 5371
  { PseudoVLUXSEG3EI8_V_MF4_M1_MASK, VLUXSEG3EI8_V, 0x0 }, // 5372
  { PseudoVLUXSEG3EI8_V_MF4_M1_TU, VLUXSEG3EI8_V, 0x0 }, // 5373
  { PseudoVLUXSEG3EI8_V_MF8_M1, VLUXSEG3EI8_V, 0x0 }, // 5374
  { PseudoVLUXSEG3EI8_V_MF8_M1_MASK, VLUXSEG3EI8_V, 0x0 }, // 5375
  { PseudoVLUXSEG3EI8_V_MF8_M1_TU, VLUXSEG3EI8_V, 0x0 }, // 5376
  { PseudoVLUXSEG3EI8_V_M1_M2, VLUXSEG3EI8_V, 0x1 }, // 5377
  { PseudoVLUXSEG3EI8_V_M1_M2_MASK, VLUXSEG3EI8_V, 0x1 }, // 5378
  { PseudoVLUXSEG3EI8_V_M1_M2_TU, VLUXSEG3EI8_V, 0x1 }, // 5379
  { PseudoVLUXSEG3EI8_V_M2_M2, VLUXSEG3EI8_V, 0x1 }, // 5380
  { PseudoVLUXSEG3EI8_V_M2_M2_MASK, VLUXSEG3EI8_V, 0x1 }, // 5381
  { PseudoVLUXSEG3EI8_V_M2_M2_TU, VLUXSEG3EI8_V, 0x1 }, // 5382
  { PseudoVLUXSEG3EI8_V_MF2_M2, VLUXSEG3EI8_V, 0x1 }, // 5383
  { PseudoVLUXSEG3EI8_V_MF2_M2_MASK, VLUXSEG3EI8_V, 0x1 }, // 5384
  { PseudoVLUXSEG3EI8_V_MF2_M2_TU, VLUXSEG3EI8_V, 0x1 }, // 5385
  { PseudoVLUXSEG3EI8_V_MF4_M2, VLUXSEG3EI8_V, 0x1 }, // 5386
  { PseudoVLUXSEG3EI8_V_MF4_M2_MASK, VLUXSEG3EI8_V, 0x1 }, // 5387
  { PseudoVLUXSEG3EI8_V_MF4_M2_TU, VLUXSEG3EI8_V, 0x1 }, // 5388
  { PseudoVLUXSEG3EI8_V_MF8_MF8, VLUXSEG3EI8_V, 0x5 }, // 5389
  { PseudoVLUXSEG3EI8_V_MF8_MF8_MASK, VLUXSEG3EI8_V, 0x5 }, // 5390
  { PseudoVLUXSEG3EI8_V_MF8_MF8_TU, VLUXSEG3EI8_V, 0x5 }, // 5391
  { PseudoVLUXSEG3EI8_V_MF4_MF4, VLUXSEG3EI8_V, 0x6 }, // 5392
  { PseudoVLUXSEG3EI8_V_MF4_MF4_MASK, VLUXSEG3EI8_V, 0x6 }, // 5393
  { PseudoVLUXSEG3EI8_V_MF4_MF4_TU, VLUXSEG3EI8_V, 0x6 }, // 5394
  { PseudoVLUXSEG3EI8_V_MF8_MF4, VLUXSEG3EI8_V, 0x6 }, // 5395
  { PseudoVLUXSEG3EI8_V_MF8_MF4_MASK, VLUXSEG3EI8_V, 0x6 }, // 5396
  { PseudoVLUXSEG3EI8_V_MF8_MF4_TU, VLUXSEG3EI8_V, 0x6 }, // 5397
  { PseudoVLUXSEG3EI8_V_MF2_MF2, VLUXSEG3EI8_V, 0x7 }, // 5398
  { PseudoVLUXSEG3EI8_V_MF2_MF2_MASK, VLUXSEG3EI8_V, 0x7 }, // 5399
  { PseudoVLUXSEG3EI8_V_MF2_MF2_TU, VLUXSEG3EI8_V, 0x7 }, // 5400
  { PseudoVLUXSEG3EI8_V_MF4_MF2, VLUXSEG3EI8_V, 0x7 }, // 5401
  { PseudoVLUXSEG3EI8_V_MF4_MF2_MASK, VLUXSEG3EI8_V, 0x7 }, // 5402
  { PseudoVLUXSEG3EI8_V_MF4_MF2_TU, VLUXSEG3EI8_V, 0x7 }, // 5403
  { PseudoVLUXSEG3EI8_V_MF8_MF2, VLUXSEG3EI8_V, 0x7 }, // 5404
  { PseudoVLUXSEG3EI8_V_MF8_MF2_MASK, VLUXSEG3EI8_V, 0x7 }, // 5405
  { PseudoVLUXSEG3EI8_V_MF8_MF2_TU, VLUXSEG3EI8_V, 0x7 }, // 5406
  { PseudoVLUXSEG4EI16_V_M1_M1, VLUXSEG4EI16_V, 0x0 }, // 5407
  { PseudoVLUXSEG4EI16_V_M1_M1_MASK, VLUXSEG4EI16_V, 0x0 }, // 5408
  { PseudoVLUXSEG4EI16_V_M1_M1_TU, VLUXSEG4EI16_V, 0x0 }, // 5409
  { PseudoVLUXSEG4EI16_V_M2_M1, VLUXSEG4EI16_V, 0x0 }, // 5410
  { PseudoVLUXSEG4EI16_V_M2_M1_MASK, VLUXSEG4EI16_V, 0x0 }, // 5411
  { PseudoVLUXSEG4EI16_V_M2_M1_TU, VLUXSEG4EI16_V, 0x0 }, // 5412
  { PseudoVLUXSEG4EI16_V_MF2_M1, VLUXSEG4EI16_V, 0x0 }, // 5413
  { PseudoVLUXSEG4EI16_V_MF2_M1_MASK, VLUXSEG4EI16_V, 0x0 }, // 5414
  { PseudoVLUXSEG4EI16_V_MF2_M1_TU, VLUXSEG4EI16_V, 0x0 }, // 5415
  { PseudoVLUXSEG4EI16_V_MF4_M1, VLUXSEG4EI16_V, 0x0 }, // 5416
  { PseudoVLUXSEG4EI16_V_MF4_M1_MASK, VLUXSEG4EI16_V, 0x0 }, // 5417
  { PseudoVLUXSEG4EI16_V_MF4_M1_TU, VLUXSEG4EI16_V, 0x0 }, // 5418
  { PseudoVLUXSEG4EI16_V_M1_M2, VLUXSEG4EI16_V, 0x1 }, // 5419
  { PseudoVLUXSEG4EI16_V_M1_M2_MASK, VLUXSEG4EI16_V, 0x1 }, // 5420
  { PseudoVLUXSEG4EI16_V_M1_M2_TU, VLUXSEG4EI16_V, 0x1 }, // 5421
  { PseudoVLUXSEG4EI16_V_M2_M2, VLUXSEG4EI16_V, 0x1 }, // 5422
  { PseudoVLUXSEG4EI16_V_M2_M2_MASK, VLUXSEG4EI16_V, 0x1 }, // 5423
  { PseudoVLUXSEG4EI16_V_M2_M2_TU, VLUXSEG4EI16_V, 0x1 }, // 5424
  { PseudoVLUXSEG4EI16_V_M4_M2, VLUXSEG4EI16_V, 0x1 }, // 5425
  { PseudoVLUXSEG4EI16_V_M4_M2_MASK, VLUXSEG4EI16_V, 0x1 }, // 5426
  { PseudoVLUXSEG4EI16_V_M4_M2_TU, VLUXSEG4EI16_V, 0x1 }, // 5427
  { PseudoVLUXSEG4EI16_V_MF2_M2, VLUXSEG4EI16_V, 0x1 }, // 5428
  { PseudoVLUXSEG4EI16_V_MF2_M2_MASK, VLUXSEG4EI16_V, 0x1 }, // 5429
  { PseudoVLUXSEG4EI16_V_MF2_M2_TU, VLUXSEG4EI16_V, 0x1 }, // 5430
  { PseudoVLUXSEG4EI16_V_MF4_MF8, VLUXSEG4EI16_V, 0x5 }, // 5431
  { PseudoVLUXSEG4EI16_V_MF4_MF8_MASK, VLUXSEG4EI16_V, 0x5 }, // 5432
  { PseudoVLUXSEG4EI16_V_MF4_MF8_TU, VLUXSEG4EI16_V, 0x5 }, // 5433
  { PseudoVLUXSEG4EI16_V_MF2_MF4, VLUXSEG4EI16_V, 0x6 }, // 5434
  { PseudoVLUXSEG4EI16_V_MF2_MF4_MASK, VLUXSEG4EI16_V, 0x6 }, // 5435
  { PseudoVLUXSEG4EI16_V_MF2_MF4_TU, VLUXSEG4EI16_V, 0x6 }, // 5436
  { PseudoVLUXSEG4EI16_V_MF4_MF4, VLUXSEG4EI16_V, 0x6 }, // 5437
  { PseudoVLUXSEG4EI16_V_MF4_MF4_MASK, VLUXSEG4EI16_V, 0x6 }, // 5438
  { PseudoVLUXSEG4EI16_V_MF4_MF4_TU, VLUXSEG4EI16_V, 0x6 }, // 5439
  { PseudoVLUXSEG4EI16_V_M1_MF2, VLUXSEG4EI16_V, 0x7 }, // 5440
  { PseudoVLUXSEG4EI16_V_M1_MF2_MASK, VLUXSEG4EI16_V, 0x7 }, // 5441
  { PseudoVLUXSEG4EI16_V_M1_MF2_TU, VLUXSEG4EI16_V, 0x7 }, // 5442
  { PseudoVLUXSEG4EI16_V_MF2_MF2, VLUXSEG4EI16_V, 0x7 }, // 5443
  { PseudoVLUXSEG4EI16_V_MF2_MF2_MASK, VLUXSEG4EI16_V, 0x7 }, // 5444
  { PseudoVLUXSEG4EI16_V_MF2_MF2_TU, VLUXSEG4EI16_V, 0x7 }, // 5445
  { PseudoVLUXSEG4EI16_V_MF4_MF2, VLUXSEG4EI16_V, 0x7 }, // 5446
  { PseudoVLUXSEG4EI16_V_MF4_MF2_MASK, VLUXSEG4EI16_V, 0x7 }, // 5447
  { PseudoVLUXSEG4EI16_V_MF4_MF2_TU, VLUXSEG4EI16_V, 0x7 }, // 5448
  { PseudoVLUXSEG4EI32_V_M1_M1, VLUXSEG4EI32_V, 0x0 }, // 5449
  { PseudoVLUXSEG4EI32_V_M1_M1_MASK, VLUXSEG4EI32_V, 0x0 }, // 5450
  { PseudoVLUXSEG4EI32_V_M1_M1_TU, VLUXSEG4EI32_V, 0x0 }, // 5451
  { PseudoVLUXSEG4EI32_V_M2_M1, VLUXSEG4EI32_V, 0x0 }, // 5452
  { PseudoVLUXSEG4EI32_V_M2_M1_MASK, VLUXSEG4EI32_V, 0x0 }, // 5453
  { PseudoVLUXSEG4EI32_V_M2_M1_TU, VLUXSEG4EI32_V, 0x0 }, // 5454
  { PseudoVLUXSEG4EI32_V_M4_M1, VLUXSEG4EI32_V, 0x0 }, // 5455
  { PseudoVLUXSEG4EI32_V_M4_M1_MASK, VLUXSEG4EI32_V, 0x0 }, // 5456
  { PseudoVLUXSEG4EI32_V_M4_M1_TU, VLUXSEG4EI32_V, 0x0 }, // 5457
  { PseudoVLUXSEG4EI32_V_MF2_M1, VLUXSEG4EI32_V, 0x0 }, // 5458
  { PseudoVLUXSEG4EI32_V_MF2_M1_MASK, VLUXSEG4EI32_V, 0x0 }, // 5459
  { PseudoVLUXSEG4EI32_V_MF2_M1_TU, VLUXSEG4EI32_V, 0x0 }, // 5460
  { PseudoVLUXSEG4EI32_V_M1_M2, VLUXSEG4EI32_V, 0x1 }, // 5461
  { PseudoVLUXSEG4EI32_V_M1_M2_MASK, VLUXSEG4EI32_V, 0x1 }, // 5462
  { PseudoVLUXSEG4EI32_V_M1_M2_TU, VLUXSEG4EI32_V, 0x1 }, // 5463
  { PseudoVLUXSEG4EI32_V_M2_M2, VLUXSEG4EI32_V, 0x1 }, // 5464
  { PseudoVLUXSEG4EI32_V_M2_M2_MASK, VLUXSEG4EI32_V, 0x1 }, // 5465
  { PseudoVLUXSEG4EI32_V_M2_M2_TU, VLUXSEG4EI32_V, 0x1 }, // 5466
  { PseudoVLUXSEG4EI32_V_M4_M2, VLUXSEG4EI32_V, 0x1 }, // 5467
  { PseudoVLUXSEG4EI32_V_M4_M2_MASK, VLUXSEG4EI32_V, 0x1 }, // 5468
  { PseudoVLUXSEG4EI32_V_M4_M2_TU, VLUXSEG4EI32_V, 0x1 }, // 5469
  { PseudoVLUXSEG4EI32_V_M8_M2, VLUXSEG4EI32_V, 0x1 }, // 5470
  { PseudoVLUXSEG4EI32_V_M8_M2_MASK, VLUXSEG4EI32_V, 0x1 }, // 5471
  { PseudoVLUXSEG4EI32_V_M8_M2_TU, VLUXSEG4EI32_V, 0x1 }, // 5472
  { PseudoVLUXSEG4EI32_V_MF2_MF8, VLUXSEG4EI32_V, 0x5 }, // 5473
  { PseudoVLUXSEG4EI32_V_MF2_MF8_MASK, VLUXSEG4EI32_V, 0x5 }, // 5474
  { PseudoVLUXSEG4EI32_V_MF2_MF8_TU, VLUXSEG4EI32_V, 0x5 }, // 5475
  { PseudoVLUXSEG4EI32_V_M1_MF4, VLUXSEG4EI32_V, 0x6 }, // 5476
  { PseudoVLUXSEG4EI32_V_M1_MF4_MASK, VLUXSEG4EI32_V, 0x6 }, // 5477
  { PseudoVLUXSEG4EI32_V_M1_MF4_TU, VLUXSEG4EI32_V, 0x6 }, // 5478
  { PseudoVLUXSEG4EI32_V_MF2_MF4, VLUXSEG4EI32_V, 0x6 }, // 5479
  { PseudoVLUXSEG4EI32_V_MF2_MF4_MASK, VLUXSEG4EI32_V, 0x6 }, // 5480
  { PseudoVLUXSEG4EI32_V_MF2_MF4_TU, VLUXSEG4EI32_V, 0x6 }, // 5481
  { PseudoVLUXSEG4EI32_V_M1_MF2, VLUXSEG4EI32_V, 0x7 }, // 5482
  { PseudoVLUXSEG4EI32_V_M1_MF2_MASK, VLUXSEG4EI32_V, 0x7 }, // 5483
  { PseudoVLUXSEG4EI32_V_M1_MF2_TU, VLUXSEG4EI32_V, 0x7 }, // 5484
  { PseudoVLUXSEG4EI32_V_M2_MF2, VLUXSEG4EI32_V, 0x7 }, // 5485
  { PseudoVLUXSEG4EI32_V_M2_MF2_MASK, VLUXSEG4EI32_V, 0x7 }, // 5486
  { PseudoVLUXSEG4EI32_V_M2_MF2_TU, VLUXSEG4EI32_V, 0x7 }, // 5487
  { PseudoVLUXSEG4EI32_V_MF2_MF2, VLUXSEG4EI32_V, 0x7 }, // 5488
  { PseudoVLUXSEG4EI32_V_MF2_MF2_MASK, VLUXSEG4EI32_V, 0x7 }, // 5489
  { PseudoVLUXSEG4EI32_V_MF2_MF2_TU, VLUXSEG4EI32_V, 0x7 }, // 5490
  { PseudoVLUXSEG4EI64_V_M1_M1, VLUXSEG4EI64_V, 0x0 }, // 5491
  { PseudoVLUXSEG4EI64_V_M1_M1_MASK, VLUXSEG4EI64_V, 0x0 }, // 5492
  { PseudoVLUXSEG4EI64_V_M1_M1_TU, VLUXSEG4EI64_V, 0x0 }, // 5493
  { PseudoVLUXSEG4EI64_V_M2_M1, VLUXSEG4EI64_V, 0x0 }, // 5494
  { PseudoVLUXSEG4EI64_V_M2_M1_MASK, VLUXSEG4EI64_V, 0x0 }, // 5495
  { PseudoVLUXSEG4EI64_V_M2_M1_TU, VLUXSEG4EI64_V, 0x0 }, // 5496
  { PseudoVLUXSEG4EI64_V_M4_M1, VLUXSEG4EI64_V, 0x0 }, // 5497
  { PseudoVLUXSEG4EI64_V_M4_M1_MASK, VLUXSEG4EI64_V, 0x0 }, // 5498
  { PseudoVLUXSEG4EI64_V_M4_M1_TU, VLUXSEG4EI64_V, 0x0 }, // 5499
  { PseudoVLUXSEG4EI64_V_M8_M1, VLUXSEG4EI64_V, 0x0 }, // 5500
  { PseudoVLUXSEG4EI64_V_M8_M1_MASK, VLUXSEG4EI64_V, 0x0 }, // 5501
  { PseudoVLUXSEG4EI64_V_M8_M1_TU, VLUXSEG4EI64_V, 0x0 }, // 5502
  { PseudoVLUXSEG4EI64_V_M2_M2, VLUXSEG4EI64_V, 0x1 }, // 5503
  { PseudoVLUXSEG4EI64_V_M2_M2_MASK, VLUXSEG4EI64_V, 0x1 }, // 5504
  { PseudoVLUXSEG4EI64_V_M2_M2_TU, VLUXSEG4EI64_V, 0x1 }, // 5505
  { PseudoVLUXSEG4EI64_V_M4_M2, VLUXSEG4EI64_V, 0x1 }, // 5506
  { PseudoVLUXSEG4EI64_V_M4_M2_MASK, VLUXSEG4EI64_V, 0x1 }, // 5507
  { PseudoVLUXSEG4EI64_V_M4_M2_TU, VLUXSEG4EI64_V, 0x1 }, // 5508
  { PseudoVLUXSEG4EI64_V_M8_M2, VLUXSEG4EI64_V, 0x1 }, // 5509
  { PseudoVLUXSEG4EI64_V_M8_M2_MASK, VLUXSEG4EI64_V, 0x1 }, // 5510
  { PseudoVLUXSEG4EI64_V_M8_M2_TU, VLUXSEG4EI64_V, 0x1 }, // 5511
  { PseudoVLUXSEG4EI64_V_M1_MF8, VLUXSEG4EI64_V, 0x5 }, // 5512
  { PseudoVLUXSEG4EI64_V_M1_MF8_MASK, VLUXSEG4EI64_V, 0x5 }, // 5513
  { PseudoVLUXSEG4EI64_V_M1_MF8_TU, VLUXSEG4EI64_V, 0x5 }, // 5514
  { PseudoVLUXSEG4EI64_V_M1_MF4, VLUXSEG4EI64_V, 0x6 }, // 5515
  { PseudoVLUXSEG4EI64_V_M1_MF4_MASK, VLUXSEG4EI64_V, 0x6 }, // 5516
  { PseudoVLUXSEG4EI64_V_M1_MF4_TU, VLUXSEG4EI64_V, 0x6 }, // 5517
  { PseudoVLUXSEG4EI64_V_M2_MF4, VLUXSEG4EI64_V, 0x6 }, // 5518
  { PseudoVLUXSEG4EI64_V_M2_MF4_MASK, VLUXSEG4EI64_V, 0x6 }, // 5519
  { PseudoVLUXSEG4EI64_V_M2_MF4_TU, VLUXSEG4EI64_V, 0x6 }, // 5520
  { PseudoVLUXSEG4EI64_V_M1_MF2, VLUXSEG4EI64_V, 0x7 }, // 5521
  { PseudoVLUXSEG4EI64_V_M1_MF2_MASK, VLUXSEG4EI64_V, 0x7 }, // 5522
  { PseudoVLUXSEG4EI64_V_M1_MF2_TU, VLUXSEG4EI64_V, 0x7 }, // 5523
  { PseudoVLUXSEG4EI64_V_M2_MF2, VLUXSEG4EI64_V, 0x7 }, // 5524
  { PseudoVLUXSEG4EI64_V_M2_MF2_MASK, VLUXSEG4EI64_V, 0x7 }, // 5525
  { PseudoVLUXSEG4EI64_V_M2_MF2_TU, VLUXSEG4EI64_V, 0x7 }, // 5526
  { PseudoVLUXSEG4EI64_V_M4_MF2, VLUXSEG4EI64_V, 0x7 }, // 5527
  { PseudoVLUXSEG4EI64_V_M4_MF2_MASK, VLUXSEG4EI64_V, 0x7 }, // 5528
  { PseudoVLUXSEG4EI64_V_M4_MF2_TU, VLUXSEG4EI64_V, 0x7 }, // 5529
  { PseudoVLUXSEG4EI8_V_M1_M1, VLUXSEG4EI8_V, 0x0 }, // 5530
  { PseudoVLUXSEG4EI8_V_M1_M1_MASK, VLUXSEG4EI8_V, 0x0 }, // 5531
  { PseudoVLUXSEG4EI8_V_M1_M1_TU, VLUXSEG4EI8_V, 0x0 }, // 5532
  { PseudoVLUXSEG4EI8_V_MF2_M1, VLUXSEG4EI8_V, 0x0 }, // 5533
  { PseudoVLUXSEG4EI8_V_MF2_M1_MASK, VLUXSEG4EI8_V, 0x0 }, // 5534
  { PseudoVLUXSEG4EI8_V_MF2_M1_TU, VLUXSEG4EI8_V, 0x0 }, // 5535
  { PseudoVLUXSEG4EI8_V_MF4_M1, VLUXSEG4EI8_V, 0x0 }, // 5536
  { PseudoVLUXSEG4EI8_V_MF4_M1_MASK, VLUXSEG4EI8_V, 0x0 }, // 5537
  { PseudoVLUXSEG4EI8_V_MF4_M1_TU, VLUXSEG4EI8_V, 0x0 }, // 5538
  { PseudoVLUXSEG4EI8_V_MF8_M1, VLUXSEG4EI8_V, 0x0 }, // 5539
  { PseudoVLUXSEG4EI8_V_MF8_M1_MASK, VLUXSEG4EI8_V, 0x0 }, // 5540
  { PseudoVLUXSEG4EI8_V_MF8_M1_TU, VLUXSEG4EI8_V, 0x0 }, // 5541
  { PseudoVLUXSEG4EI8_V_M1_M2, VLUXSEG4EI8_V, 0x1 }, // 5542
  { PseudoVLUXSEG4EI8_V_M1_M2_MASK, VLUXSEG4EI8_V, 0x1 }, // 5543
  { PseudoVLUXSEG4EI8_V_M1_M2_TU, VLUXSEG4EI8_V, 0x1 }, // 5544
  { PseudoVLUXSEG4EI8_V_M2_M2, VLUXSEG4EI8_V, 0x1 }, // 5545
  { PseudoVLUXSEG4EI8_V_M2_M2_MASK, VLUXSEG4EI8_V, 0x1 }, // 5546
  { PseudoVLUXSEG4EI8_V_M2_M2_TU, VLUXSEG4EI8_V, 0x1 }, // 5547
  { PseudoVLUXSEG4EI8_V_MF2_M2, VLUXSEG4EI8_V, 0x1 }, // 5548
  { PseudoVLUXSEG4EI8_V_MF2_M2_MASK, VLUXSEG4EI8_V, 0x1 }, // 5549
  { PseudoVLUXSEG4EI8_V_MF2_M2_TU, VLUXSEG4EI8_V, 0x1 }, // 5550
  { PseudoVLUXSEG4EI8_V_MF4_M2, VLUXSEG4EI8_V, 0x1 }, // 5551
  { PseudoVLUXSEG4EI8_V_MF4_M2_MASK, VLUXSEG4EI8_V, 0x1 }, // 5552
  { PseudoVLUXSEG4EI8_V_MF4_M2_TU, VLUXSEG4EI8_V, 0x1 }, // 5553
  { PseudoVLUXSEG4EI8_V_MF8_MF8, VLUXSEG4EI8_V, 0x5 }, // 5554
  { PseudoVLUXSEG4EI8_V_MF8_MF8_MASK, VLUXSEG4EI8_V, 0x5 }, // 5555
  { PseudoVLUXSEG4EI8_V_MF8_MF8_TU, VLUXSEG4EI8_V, 0x5 }, // 5556
  { PseudoVLUXSEG4EI8_V_MF4_MF4, VLUXSEG4EI8_V, 0x6 }, // 5557
  { PseudoVLUXSEG4EI8_V_MF4_MF4_MASK, VLUXSEG4EI8_V, 0x6 }, // 5558
  { PseudoVLUXSEG4EI8_V_MF4_MF4_TU, VLUXSEG4EI8_V, 0x6 }, // 5559
  { PseudoVLUXSEG4EI8_V_MF8_MF4, VLUXSEG4EI8_V, 0x6 }, // 5560
  { PseudoVLUXSEG4EI8_V_MF8_MF4_MASK, VLUXSEG4EI8_V, 0x6 }, // 5561
  { PseudoVLUXSEG4EI8_V_MF8_MF4_TU, VLUXSEG4EI8_V, 0x6 }, // 5562
  { PseudoVLUXSEG4EI8_V_MF2_MF2, VLUXSEG4EI8_V, 0x7 }, // 5563
  { PseudoVLUXSEG4EI8_V_MF2_MF2_MASK, VLUXSEG4EI8_V, 0x7 }, // 5564
  { PseudoVLUXSEG4EI8_V_MF2_MF2_TU, VLUXSEG4EI8_V, 0x7 }, // 5565
  { PseudoVLUXSEG4EI8_V_MF4_MF2, VLUXSEG4EI8_V, 0x7 }, // 5566
  { PseudoVLUXSEG4EI8_V_MF4_MF2_MASK, VLUXSEG4EI8_V, 0x7 }, // 5567
  { PseudoVLUXSEG4EI8_V_MF4_MF2_TU, VLUXSEG4EI8_V, 0x7 }, // 5568
  { PseudoVLUXSEG4EI8_V_MF8_MF2, VLUXSEG4EI8_V, 0x7 }, // 5569
  { PseudoVLUXSEG4EI8_V_MF8_MF2_MASK, VLUXSEG4EI8_V, 0x7 }, // 5570
  { PseudoVLUXSEG4EI8_V_MF8_MF2_TU, VLUXSEG4EI8_V, 0x7 }, // 5571
  { PseudoVLUXSEG5EI16_V_M1_M1, VLUXSEG5EI16_V, 0x0 }, // 5572
  { PseudoVLUXSEG5EI16_V_M1_M1_MASK, VLUXSEG5EI16_V, 0x0 }, // 5573
  { PseudoVLUXSEG5EI16_V_M1_M1_TU, VLUXSEG5EI16_V, 0x0 }, // 5574
  { PseudoVLUXSEG5EI16_V_M2_M1, VLUXSEG5EI16_V, 0x0 }, // 5575
  { PseudoVLUXSEG5EI16_V_M2_M1_MASK, VLUXSEG5EI16_V, 0x0 }, // 5576
  { PseudoVLUXSEG5EI16_V_M2_M1_TU, VLUXSEG5EI16_V, 0x0 }, // 5577
  { PseudoVLUXSEG5EI16_V_MF2_M1, VLUXSEG5EI16_V, 0x0 }, // 5578
  { PseudoVLUXSEG5EI16_V_MF2_M1_MASK, VLUXSEG5EI16_V, 0x0 }, // 5579
  { PseudoVLUXSEG5EI16_V_MF2_M1_TU, VLUXSEG5EI16_V, 0x0 }, // 5580
  { PseudoVLUXSEG5EI16_V_MF4_M1, VLUXSEG5EI16_V, 0x0 }, // 5581
  { PseudoVLUXSEG5EI16_V_MF4_M1_MASK, VLUXSEG5EI16_V, 0x0 }, // 5582
  { PseudoVLUXSEG5EI16_V_MF4_M1_TU, VLUXSEG5EI16_V, 0x0 }, // 5583
  { PseudoVLUXSEG5EI16_V_MF4_MF8, VLUXSEG5EI16_V, 0x5 }, // 5584
  { PseudoVLUXSEG5EI16_V_MF4_MF8_MASK, VLUXSEG5EI16_V, 0x5 }, // 5585
  { PseudoVLUXSEG5EI16_V_MF4_MF8_TU, VLUXSEG5EI16_V, 0x5 }, // 5586
  { PseudoVLUXSEG5EI16_V_MF2_MF4, VLUXSEG5EI16_V, 0x6 }, // 5587
  { PseudoVLUXSEG5EI16_V_MF2_MF4_MASK, VLUXSEG5EI16_V, 0x6 }, // 5588
  { PseudoVLUXSEG5EI16_V_MF2_MF4_TU, VLUXSEG5EI16_V, 0x6 }, // 5589
  { PseudoVLUXSEG5EI16_V_MF4_MF4, VLUXSEG5EI16_V, 0x6 }, // 5590
  { PseudoVLUXSEG5EI16_V_MF4_MF4_MASK, VLUXSEG5EI16_V, 0x6 }, // 5591
  { PseudoVLUXSEG5EI16_V_MF4_MF4_TU, VLUXSEG5EI16_V, 0x6 }, // 5592
  { PseudoVLUXSEG5EI16_V_M1_MF2, VLUXSEG5EI16_V, 0x7 }, // 5593
  { PseudoVLUXSEG5EI16_V_M1_MF2_MASK, VLUXSEG5EI16_V, 0x7 }, // 5594
  { PseudoVLUXSEG5EI16_V_M1_MF2_TU, VLUXSEG5EI16_V, 0x7 }, // 5595
  { PseudoVLUXSEG5EI16_V_MF2_MF2, VLUXSEG5EI16_V, 0x7 }, // 5596
  { PseudoVLUXSEG5EI16_V_MF2_MF2_MASK, VLUXSEG5EI16_V, 0x7 }, // 5597
  { PseudoVLUXSEG5EI16_V_MF2_MF2_TU, VLUXSEG5EI16_V, 0x7 }, // 5598
  { PseudoVLUXSEG5EI16_V_MF4_MF2, VLUXSEG5EI16_V, 0x7 }, // 5599
  { PseudoVLUXSEG5EI16_V_MF4_MF2_MASK, VLUXSEG5EI16_V, 0x7 }, // 5600
  { PseudoVLUXSEG5EI16_V_MF4_MF2_TU, VLUXSEG5EI16_V, 0x7 }, // 5601
  { PseudoVLUXSEG5EI32_V_M1_M1, VLUXSEG5EI32_V, 0x0 }, // 5602
  { PseudoVLUXSEG5EI32_V_M1_M1_MASK, VLUXSEG5EI32_V, 0x0 }, // 5603
  { PseudoVLUXSEG5EI32_V_M1_M1_TU, VLUXSEG5EI32_V, 0x0 }, // 5604
  { PseudoVLUXSEG5EI32_V_M2_M1, VLUXSEG5EI32_V, 0x0 }, // 5605
  { PseudoVLUXSEG5EI32_V_M2_M1_MASK, VLUXSEG5EI32_V, 0x0 }, // 5606
  { PseudoVLUXSEG5EI32_V_M2_M1_TU, VLUXSEG5EI32_V, 0x0 }, // 5607
  { PseudoVLUXSEG5EI32_V_M4_M1, VLUXSEG5EI32_V, 0x0 }, // 5608
  { PseudoVLUXSEG5EI32_V_M4_M1_MASK, VLUXSEG5EI32_V, 0x0 }, // 5609
  { PseudoVLUXSEG5EI32_V_M4_M1_TU, VLUXSEG5EI32_V, 0x0 }, // 5610
  { PseudoVLUXSEG5EI32_V_MF2_M1, VLUXSEG5EI32_V, 0x0 }, // 5611
  { PseudoVLUXSEG5EI32_V_MF2_M1_MASK, VLUXSEG5EI32_V, 0x0 }, // 5612
  { PseudoVLUXSEG5EI32_V_MF2_M1_TU, VLUXSEG5EI32_V, 0x0 }, // 5613
  { PseudoVLUXSEG5EI32_V_MF2_MF8, VLUXSEG5EI32_V, 0x5 }, // 5614
  { PseudoVLUXSEG5EI32_V_MF2_MF8_MASK, VLUXSEG5EI32_V, 0x5 }, // 5615
  { PseudoVLUXSEG5EI32_V_MF2_MF8_TU, VLUXSEG5EI32_V, 0x5 }, // 5616
  { PseudoVLUXSEG5EI32_V_M1_MF4, VLUXSEG5EI32_V, 0x6 }, // 5617
  { PseudoVLUXSEG5EI32_V_M1_MF4_MASK, VLUXSEG5EI32_V, 0x6 }, // 5618
  { PseudoVLUXSEG5EI32_V_M1_MF4_TU, VLUXSEG5EI32_V, 0x6 }, // 5619
  { PseudoVLUXSEG5EI32_V_MF2_MF4, VLUXSEG5EI32_V, 0x6 }, // 5620
  { PseudoVLUXSEG5EI32_V_MF2_MF4_MASK, VLUXSEG5EI32_V, 0x6 }, // 5621
  { PseudoVLUXSEG5EI32_V_MF2_MF4_TU, VLUXSEG5EI32_V, 0x6 }, // 5622
  { PseudoVLUXSEG5EI32_V_M1_MF2, VLUXSEG5EI32_V, 0x7 }, // 5623
  { PseudoVLUXSEG5EI32_V_M1_MF2_MASK, VLUXSEG5EI32_V, 0x7 }, // 5624
  { PseudoVLUXSEG5EI32_V_M1_MF2_TU, VLUXSEG5EI32_V, 0x7 }, // 5625
  { PseudoVLUXSEG5EI32_V_M2_MF2, VLUXSEG5EI32_V, 0x7 }, // 5626
  { PseudoVLUXSEG5EI32_V_M2_MF2_MASK, VLUXSEG5EI32_V, 0x7 }, // 5627
  { PseudoVLUXSEG5EI32_V_M2_MF2_TU, VLUXSEG5EI32_V, 0x7 }, // 5628
  { PseudoVLUXSEG5EI32_V_MF2_MF2, VLUXSEG5EI32_V, 0x7 }, // 5629
  { PseudoVLUXSEG5EI32_V_MF2_MF2_MASK, VLUXSEG5EI32_V, 0x7 }, // 5630
  { PseudoVLUXSEG5EI32_V_MF2_MF2_TU, VLUXSEG5EI32_V, 0x7 }, // 5631
  { PseudoVLUXSEG5EI64_V_M1_M1, VLUXSEG5EI64_V, 0x0 }, // 5632
  { PseudoVLUXSEG5EI64_V_M1_M1_MASK, VLUXSEG5EI64_V, 0x0 }, // 5633
  { PseudoVLUXSEG5EI64_V_M1_M1_TU, VLUXSEG5EI64_V, 0x0 }, // 5634
  { PseudoVLUXSEG5EI64_V_M2_M1, VLUXSEG5EI64_V, 0x0 }, // 5635
  { PseudoVLUXSEG5EI64_V_M2_M1_MASK, VLUXSEG5EI64_V, 0x0 }, // 5636
  { PseudoVLUXSEG5EI64_V_M2_M1_TU, VLUXSEG5EI64_V, 0x0 }, // 5637
  { PseudoVLUXSEG5EI64_V_M4_M1, VLUXSEG5EI64_V, 0x0 }, // 5638
  { PseudoVLUXSEG5EI64_V_M4_M1_MASK, VLUXSEG5EI64_V, 0x0 }, // 5639
  { PseudoVLUXSEG5EI64_V_M4_M1_TU, VLUXSEG5EI64_V, 0x0 }, // 5640
  { PseudoVLUXSEG5EI64_V_M8_M1, VLUXSEG5EI64_V, 0x0 }, // 5641
  { PseudoVLUXSEG5EI64_V_M8_M1_MASK, VLUXSEG5EI64_V, 0x0 }, // 5642
  { PseudoVLUXSEG5EI64_V_M8_M1_TU, VLUXSEG5EI64_V, 0x0 }, // 5643
  { PseudoVLUXSEG5EI64_V_M1_MF8, VLUXSEG5EI64_V, 0x5 }, // 5644
  { PseudoVLUXSEG5EI64_V_M1_MF8_MASK, VLUXSEG5EI64_V, 0x5 }, // 5645
  { PseudoVLUXSEG5EI64_V_M1_MF8_TU, VLUXSEG5EI64_V, 0x5 }, // 5646
  { PseudoVLUXSEG5EI64_V_M1_MF4, VLUXSEG5EI64_V, 0x6 }, // 5647
  { PseudoVLUXSEG5EI64_V_M1_MF4_MASK, VLUXSEG5EI64_V, 0x6 }, // 5648
  { PseudoVLUXSEG5EI64_V_M1_MF4_TU, VLUXSEG5EI64_V, 0x6 }, // 5649
  { PseudoVLUXSEG5EI64_V_M2_MF4, VLUXSEG5EI64_V, 0x6 }, // 5650
  { PseudoVLUXSEG5EI64_V_M2_MF4_MASK, VLUXSEG5EI64_V, 0x6 }, // 5651
  { PseudoVLUXSEG5EI64_V_M2_MF4_TU, VLUXSEG5EI64_V, 0x6 }, // 5652
  { PseudoVLUXSEG5EI64_V_M1_MF2, VLUXSEG5EI64_V, 0x7 }, // 5653
  { PseudoVLUXSEG5EI64_V_M1_MF2_MASK, VLUXSEG5EI64_V, 0x7 }, // 5654
  { PseudoVLUXSEG5EI64_V_M1_MF2_TU, VLUXSEG5EI64_V, 0x7 }, // 5655
  { PseudoVLUXSEG5EI64_V_M2_MF2, VLUXSEG5EI64_V, 0x7 }, // 5656
  { PseudoVLUXSEG5EI64_V_M2_MF2_MASK, VLUXSEG5EI64_V, 0x7 }, // 5657
  { PseudoVLUXSEG5EI64_V_M2_MF2_TU, VLUXSEG5EI64_V, 0x7 }, // 5658
  { PseudoVLUXSEG5EI64_V_M4_MF2, VLUXSEG5EI64_V, 0x7 }, // 5659
  { PseudoVLUXSEG5EI64_V_M4_MF2_MASK, VLUXSEG5EI64_V, 0x7 }, // 5660
  { PseudoVLUXSEG5EI64_V_M4_MF2_TU, VLUXSEG5EI64_V, 0x7 }, // 5661
  { PseudoVLUXSEG5EI8_V_M1_M1, VLUXSEG5EI8_V, 0x0 }, // 5662
  { PseudoVLUXSEG5EI8_V_M1_M1_MASK, VLUXSEG5EI8_V, 0x0 }, // 5663
  { PseudoVLUXSEG5EI8_V_M1_M1_TU, VLUXSEG5EI8_V, 0x0 }, // 5664
  { PseudoVLUXSEG5EI8_V_MF2_M1, VLUXSEG5EI8_V, 0x0 }, // 5665
  { PseudoVLUXSEG5EI8_V_MF2_M1_MASK, VLUXSEG5EI8_V, 0x0 }, // 5666
  { PseudoVLUXSEG5EI8_V_MF2_M1_TU, VLUXSEG5EI8_V, 0x0 }, // 5667
  { PseudoVLUXSEG5EI8_V_MF4_M1, VLUXSEG5EI8_V, 0x0 }, // 5668
  { PseudoVLUXSEG5EI8_V_MF4_M1_MASK, VLUXSEG5EI8_V, 0x0 }, // 5669
  { PseudoVLUXSEG5EI8_V_MF4_M1_TU, VLUXSEG5EI8_V, 0x0 }, // 5670
  { PseudoVLUXSEG5EI8_V_MF8_M1, VLUXSEG5EI8_V, 0x0 }, // 5671
  { PseudoVLUXSEG5EI8_V_MF8_M1_MASK, VLUXSEG5EI8_V, 0x0 }, // 5672
  { PseudoVLUXSEG5EI8_V_MF8_M1_TU, VLUXSEG5EI8_V, 0x0 }, // 5673
  { PseudoVLUXSEG5EI8_V_MF8_MF8, VLUXSEG5EI8_V, 0x5 }, // 5674
  { PseudoVLUXSEG5EI8_V_MF8_MF8_MASK, VLUXSEG5EI8_V, 0x5 }, // 5675
  { PseudoVLUXSEG5EI8_V_MF8_MF8_TU, VLUXSEG5EI8_V, 0x5 }, // 5676
  { PseudoVLUXSEG5EI8_V_MF4_MF4, VLUXSEG5EI8_V, 0x6 }, // 5677
  { PseudoVLUXSEG5EI8_V_MF4_MF4_MASK, VLUXSEG5EI8_V, 0x6 }, // 5678
  { PseudoVLUXSEG5EI8_V_MF4_MF4_TU, VLUXSEG5EI8_V, 0x6 }, // 5679
  { PseudoVLUXSEG5EI8_V_MF8_MF4, VLUXSEG5EI8_V, 0x6 }, // 5680
  { PseudoVLUXSEG5EI8_V_MF8_MF4_MASK, VLUXSEG5EI8_V, 0x6 }, // 5681
  { PseudoVLUXSEG5EI8_V_MF8_MF4_TU, VLUXSEG5EI8_V, 0x6 }, // 5682
  { PseudoVLUXSEG5EI8_V_MF2_MF2, VLUXSEG5EI8_V, 0x7 }, // 5683
  { PseudoVLUXSEG5EI8_V_MF2_MF2_MASK, VLUXSEG5EI8_V, 0x7 }, // 5684
  { PseudoVLUXSEG5EI8_V_MF2_MF2_TU, VLUXSEG5EI8_V, 0x7 }, // 5685
  { PseudoVLUXSEG5EI8_V_MF4_MF2, VLUXSEG5EI8_V, 0x7 }, // 5686
  { PseudoVLUXSEG5EI8_V_MF4_MF2_MASK, VLUXSEG5EI8_V, 0x7 }, // 5687
  { PseudoVLUXSEG5EI8_V_MF4_MF2_TU, VLUXSEG5EI8_V, 0x7 }, // 5688
  { PseudoVLUXSEG5EI8_V_MF8_MF2, VLUXSEG5EI8_V, 0x7 }, // 5689
  { PseudoVLUXSEG5EI8_V_MF8_MF2_MASK, VLUXSEG5EI8_V, 0x7 }, // 5690
  { PseudoVLUXSEG5EI8_V_MF8_MF2_TU, VLUXSEG5EI8_V, 0x7 }, // 5691
  { PseudoVLUXSEG6EI16_V_M1_M1, VLUXSEG6EI16_V, 0x0 }, // 5692
  { PseudoVLUXSEG6EI16_V_M1_M1_MASK, VLUXSEG6EI16_V, 0x0 }, // 5693
  { PseudoVLUXSEG6EI16_V_M1_M1_TU, VLUXSEG6EI16_V, 0x0 }, // 5694
  { PseudoVLUXSEG6EI16_V_M2_M1, VLUXSEG6EI16_V, 0x0 }, // 5695
  { PseudoVLUXSEG6EI16_V_M2_M1_MASK, VLUXSEG6EI16_V, 0x0 }, // 5696
  { PseudoVLUXSEG6EI16_V_M2_M1_TU, VLUXSEG6EI16_V, 0x0 }, // 5697
  { PseudoVLUXSEG6EI16_V_MF2_M1, VLUXSEG6EI16_V, 0x0 }, // 5698
  { PseudoVLUXSEG6EI16_V_MF2_M1_MASK, VLUXSEG6EI16_V, 0x0 }, // 5699
  { PseudoVLUXSEG6EI16_V_MF2_M1_TU, VLUXSEG6EI16_V, 0x0 }, // 5700
  { PseudoVLUXSEG6EI16_V_MF4_M1, VLUXSEG6EI16_V, 0x0 }, // 5701
  { PseudoVLUXSEG6EI16_V_MF4_M1_MASK, VLUXSEG6EI16_V, 0x0 }, // 5702
  { PseudoVLUXSEG6EI16_V_MF4_M1_TU, VLUXSEG6EI16_V, 0x0 }, // 5703
  { PseudoVLUXSEG6EI16_V_MF4_MF8, VLUXSEG6EI16_V, 0x5 }, // 5704
  { PseudoVLUXSEG6EI16_V_MF4_MF8_MASK, VLUXSEG6EI16_V, 0x5 }, // 5705
  { PseudoVLUXSEG6EI16_V_MF4_MF8_TU, VLUXSEG6EI16_V, 0x5 }, // 5706
  { PseudoVLUXSEG6EI16_V_MF2_MF4, VLUXSEG6EI16_V, 0x6 }, // 5707
  { PseudoVLUXSEG6EI16_V_MF2_MF4_MASK, VLUXSEG6EI16_V, 0x6 }, // 5708
  { PseudoVLUXSEG6EI16_V_MF2_MF4_TU, VLUXSEG6EI16_V, 0x6 }, // 5709
  { PseudoVLUXSEG6EI16_V_MF4_MF4, VLUXSEG6EI16_V, 0x6 }, // 5710
  { PseudoVLUXSEG6EI16_V_MF4_MF4_MASK, VLUXSEG6EI16_V, 0x6 }, // 5711
  { PseudoVLUXSEG6EI16_V_MF4_MF4_TU, VLUXSEG6EI16_V, 0x6 }, // 5712
  { PseudoVLUXSEG6EI16_V_M1_MF2, VLUXSEG6EI16_V, 0x7 }, // 5713
  { PseudoVLUXSEG6EI16_V_M1_MF2_MASK, VLUXSEG6EI16_V, 0x7 }, // 5714
  { PseudoVLUXSEG6EI16_V_M1_MF2_TU, VLUXSEG6EI16_V, 0x7 }, // 5715
  { PseudoVLUXSEG6EI16_V_MF2_MF2, VLUXSEG6EI16_V, 0x7 }, // 5716
  { PseudoVLUXSEG6EI16_V_MF2_MF2_MASK, VLUXSEG6EI16_V, 0x7 }, // 5717
  { PseudoVLUXSEG6EI16_V_MF2_MF2_TU, VLUXSEG6EI16_V, 0x7 }, // 5718
  { PseudoVLUXSEG6EI16_V_MF4_MF2, VLUXSEG6EI16_V, 0x7 }, // 5719
  { PseudoVLUXSEG6EI16_V_MF4_MF2_MASK, VLUXSEG6EI16_V, 0x7 }, // 5720
  { PseudoVLUXSEG6EI16_V_MF4_MF2_TU, VLUXSEG6EI16_V, 0x7 }, // 5721
  { PseudoVLUXSEG6EI32_V_M1_M1, VLUXSEG6EI32_V, 0x0 }, // 5722
  { PseudoVLUXSEG6EI32_V_M1_M1_MASK, VLUXSEG6EI32_V, 0x0 }, // 5723
  { PseudoVLUXSEG6EI32_V_M1_M1_TU, VLUXSEG6EI32_V, 0x0 }, // 5724
  { PseudoVLUXSEG6EI32_V_M2_M1, VLUXSEG6EI32_V, 0x0 }, // 5725
  { PseudoVLUXSEG6EI32_V_M2_M1_MASK, VLUXSEG6EI32_V, 0x0 }, // 5726
  { PseudoVLUXSEG6EI32_V_M2_M1_TU, VLUXSEG6EI32_V, 0x0 }, // 5727
  { PseudoVLUXSEG6EI32_V_M4_M1, VLUXSEG6EI32_V, 0x0 }, // 5728
  { PseudoVLUXSEG6EI32_V_M4_M1_MASK, VLUXSEG6EI32_V, 0x0 }, // 5729
  { PseudoVLUXSEG6EI32_V_M4_M1_TU, VLUXSEG6EI32_V, 0x0 }, // 5730
  { PseudoVLUXSEG6EI32_V_MF2_M1, VLUXSEG6EI32_V, 0x0 }, // 5731
  { PseudoVLUXSEG6EI32_V_MF2_M1_MASK, VLUXSEG6EI32_V, 0x0 }, // 5732
  { PseudoVLUXSEG6EI32_V_MF2_M1_TU, VLUXSEG6EI32_V, 0x0 }, // 5733
  { PseudoVLUXSEG6EI32_V_MF2_MF8, VLUXSEG6EI32_V, 0x5 }, // 5734
  { PseudoVLUXSEG6EI32_V_MF2_MF8_MASK, VLUXSEG6EI32_V, 0x5 }, // 5735
  { PseudoVLUXSEG6EI32_V_MF2_MF8_TU, VLUXSEG6EI32_V, 0x5 }, // 5736
  { PseudoVLUXSEG6EI32_V_M1_MF4, VLUXSEG6EI32_V, 0x6 }, // 5737
  { PseudoVLUXSEG6EI32_V_M1_MF4_MASK, VLUXSEG6EI32_V, 0x6 }, // 5738
  { PseudoVLUXSEG6EI32_V_M1_MF4_TU, VLUXSEG6EI32_V, 0x6 }, // 5739
  { PseudoVLUXSEG6EI32_V_MF2_MF4, VLUXSEG6EI32_V, 0x6 }, // 5740
  { PseudoVLUXSEG6EI32_V_MF2_MF4_MASK, VLUXSEG6EI32_V, 0x6 }, // 5741
  { PseudoVLUXSEG6EI32_V_MF2_MF4_TU, VLUXSEG6EI32_V, 0x6 }, // 5742
  { PseudoVLUXSEG6EI32_V_M1_MF2, VLUXSEG6EI32_V, 0x7 }, // 5743
  { PseudoVLUXSEG6EI32_V_M1_MF2_MASK, VLUXSEG6EI32_V, 0x7 }, // 5744
  { PseudoVLUXSEG6EI32_V_M1_MF2_TU, VLUXSEG6EI32_V, 0x7 }, // 5745
  { PseudoVLUXSEG6EI32_V_M2_MF2, VLUXSEG6EI32_V, 0x7 }, // 5746
  { PseudoVLUXSEG6EI32_V_M2_MF2_MASK, VLUXSEG6EI32_V, 0x7 }, // 5747
  { PseudoVLUXSEG6EI32_V_M2_MF2_TU, VLUXSEG6EI32_V, 0x7 }, // 5748
  { PseudoVLUXSEG6EI32_V_MF2_MF2, VLUXSEG6EI32_V, 0x7 }, // 5749
  { PseudoVLUXSEG6EI32_V_MF2_MF2_MASK, VLUXSEG6EI32_V, 0x7 }, // 5750
  { PseudoVLUXSEG6EI32_V_MF2_MF2_TU, VLUXSEG6EI32_V, 0x7 }, // 5751
  { PseudoVLUXSEG6EI64_V_M1_M1, VLUXSEG6EI64_V, 0x0 }, // 5752
  { PseudoVLUXSEG6EI64_V_M1_M1_MASK, VLUXSEG6EI64_V, 0x0 }, // 5753
  { PseudoVLUXSEG6EI64_V_M1_M1_TU, VLUXSEG6EI64_V, 0x0 }, // 5754
  { PseudoVLUXSEG6EI64_V_M2_M1, VLUXSEG6EI64_V, 0x0 }, // 5755
  { PseudoVLUXSEG6EI64_V_M2_M1_MASK, VLUXSEG6EI64_V, 0x0 }, // 5756
  { PseudoVLUXSEG6EI64_V_M2_M1_TU, VLUXSEG6EI64_V, 0x0 }, // 5757
  { PseudoVLUXSEG6EI64_V_M4_M1, VLUXSEG6EI64_V, 0x0 }, // 5758
  { PseudoVLUXSEG6EI64_V_M4_M1_MASK, VLUXSEG6EI64_V, 0x0 }, // 5759
  { PseudoVLUXSEG6EI64_V_M4_M1_TU, VLUXSEG6EI64_V, 0x0 }, // 5760
  { PseudoVLUXSEG6EI64_V_M8_M1, VLUXSEG6EI64_V, 0x0 }, // 5761
  { PseudoVLUXSEG6EI64_V_M8_M1_MASK, VLUXSEG6EI64_V, 0x0 }, // 5762
  { PseudoVLUXSEG6EI64_V_M8_M1_TU, VLUXSEG6EI64_V, 0x0 }, // 5763
  { PseudoVLUXSEG6EI64_V_M1_MF8, VLUXSEG6EI64_V, 0x5 }, // 5764
  { PseudoVLUXSEG6EI64_V_M1_MF8_MASK, VLUXSEG6EI64_V, 0x5 }, // 5765
  { PseudoVLUXSEG6EI64_V_M1_MF8_TU, VLUXSEG6EI64_V, 0x5 }, // 5766
  { PseudoVLUXSEG6EI64_V_M1_MF4, VLUXSEG6EI64_V, 0x6 }, // 5767
  { PseudoVLUXSEG6EI64_V_M1_MF4_MASK, VLUXSEG6EI64_V, 0x6 }, // 5768
  { PseudoVLUXSEG6EI64_V_M1_MF4_TU, VLUXSEG6EI64_V, 0x6 }, // 5769
  { PseudoVLUXSEG6EI64_V_M2_MF4, VLUXSEG6EI64_V, 0x6 }, // 5770
  { PseudoVLUXSEG6EI64_V_M2_MF4_MASK, VLUXSEG6EI64_V, 0x6 }, // 5771
  { PseudoVLUXSEG6EI64_V_M2_MF4_TU, VLUXSEG6EI64_V, 0x6 }, // 5772
  { PseudoVLUXSEG6EI64_V_M1_MF2, VLUXSEG6EI64_V, 0x7 }, // 5773
  { PseudoVLUXSEG6EI64_V_M1_MF2_MASK, VLUXSEG6EI64_V, 0x7 }, // 5774
  { PseudoVLUXSEG6EI64_V_M1_MF2_TU, VLUXSEG6EI64_V, 0x7 }, // 5775
  { PseudoVLUXSEG6EI64_V_M2_MF2, VLUXSEG6EI64_V, 0x7 }, // 5776
  { PseudoVLUXSEG6EI64_V_M2_MF2_MASK, VLUXSEG6EI64_V, 0x7 }, // 5777
  { PseudoVLUXSEG6EI64_V_M2_MF2_TU, VLUXSEG6EI64_V, 0x7 }, // 5778
  { PseudoVLUXSEG6EI64_V_M4_MF2, VLUXSEG6EI64_V, 0x7 }, // 5779
  { PseudoVLUXSEG6EI64_V_M4_MF2_MASK, VLUXSEG6EI64_V, 0x7 }, // 5780
  { PseudoVLUXSEG6EI64_V_M4_MF2_TU, VLUXSEG6EI64_V, 0x7 }, // 5781
  { PseudoVLUXSEG6EI8_V_M1_M1, VLUXSEG6EI8_V, 0x0 }, // 5782
  { PseudoVLUXSEG6EI8_V_M1_M1_MASK, VLUXSEG6EI8_V, 0x0 }, // 5783
  { PseudoVLUXSEG6EI8_V_M1_M1_TU, VLUXSEG6EI8_V, 0x0 }, // 5784
  { PseudoVLUXSEG6EI8_V_MF2_M1, VLUXSEG6EI8_V, 0x0 }, // 5785
  { PseudoVLUXSEG6EI8_V_MF2_M1_MASK, VLUXSEG6EI8_V, 0x0 }, // 5786
  { PseudoVLUXSEG6EI8_V_MF2_M1_TU, VLUXSEG6EI8_V, 0x0 }, // 5787
  { PseudoVLUXSEG6EI8_V_MF4_M1, VLUXSEG6EI8_V, 0x0 }, // 5788
  { PseudoVLUXSEG6EI8_V_MF4_M1_MASK, VLUXSEG6EI8_V, 0x0 }, // 5789
  { PseudoVLUXSEG6EI8_V_MF4_M1_TU, VLUXSEG6EI8_V, 0x0 }, // 5790
  { PseudoVLUXSEG6EI8_V_MF8_M1, VLUXSEG6EI8_V, 0x0 }, // 5791
  { PseudoVLUXSEG6EI8_V_MF8_M1_MASK, VLUXSEG6EI8_V, 0x0 }, // 5792
  { PseudoVLUXSEG6EI8_V_MF8_M1_TU, VLUXSEG6EI8_V, 0x0 }, // 5793
  { PseudoVLUXSEG6EI8_V_MF8_MF8, VLUXSEG6EI8_V, 0x5 }, // 5794
  { PseudoVLUXSEG6EI8_V_MF8_MF8_MASK, VLUXSEG6EI8_V, 0x5 }, // 5795
  { PseudoVLUXSEG6EI8_V_MF8_MF8_TU, VLUXSEG6EI8_V, 0x5 }, // 5796
  { PseudoVLUXSEG6EI8_V_MF4_MF4, VLUXSEG6EI8_V, 0x6 }, // 5797
  { PseudoVLUXSEG6EI8_V_MF4_MF4_MASK, VLUXSEG6EI8_V, 0x6 }, // 5798
  { PseudoVLUXSEG6EI8_V_MF4_MF4_TU, VLUXSEG6EI8_V, 0x6 }, // 5799
  { PseudoVLUXSEG6EI8_V_MF8_MF4, VLUXSEG6EI8_V, 0x6 }, // 5800
  { PseudoVLUXSEG6EI8_V_MF8_MF4_MASK, VLUXSEG6EI8_V, 0x6 }, // 5801
  { PseudoVLUXSEG6EI8_V_MF8_MF4_TU, VLUXSEG6EI8_V, 0x6 }, // 5802
  { PseudoVLUXSEG6EI8_V_MF2_MF2, VLUXSEG6EI8_V, 0x7 }, // 5803
  { PseudoVLUXSEG6EI8_V_MF2_MF2_MASK, VLUXSEG6EI8_V, 0x7 }, // 5804
  { PseudoVLUXSEG6EI8_V_MF2_MF2_TU, VLUXSEG6EI8_V, 0x7 }, // 5805
  { PseudoVLUXSEG6EI8_V_MF4_MF2, VLUXSEG6EI8_V, 0x7 }, // 5806
  { PseudoVLUXSEG6EI8_V_MF4_MF2_MASK, VLUXSEG6EI8_V, 0x7 }, // 5807
  { PseudoVLUXSEG6EI8_V_MF4_MF2_TU, VLUXSEG6EI8_V, 0x7 }, // 5808
  { PseudoVLUXSEG6EI8_V_MF8_MF2, VLUXSEG6EI8_V, 0x7 }, // 5809
  { PseudoVLUXSEG6EI8_V_MF8_MF2_MASK, VLUXSEG6EI8_V, 0x7 }, // 5810
  { PseudoVLUXSEG6EI8_V_MF8_MF2_TU, VLUXSEG6EI8_V, 0x7 }, // 5811
  { PseudoVLUXSEG7EI16_V_M1_M1, VLUXSEG7EI16_V, 0x0 }, // 5812
  { PseudoVLUXSEG7EI16_V_M1_M1_MASK, VLUXSEG7EI16_V, 0x0 }, // 5813
  { PseudoVLUXSEG7EI16_V_M1_M1_TU, VLUXSEG7EI16_V, 0x0 }, // 5814
  { PseudoVLUXSEG7EI16_V_M2_M1, VLUXSEG7EI16_V, 0x0 }, // 5815
  { PseudoVLUXSEG7EI16_V_M2_M1_MASK, VLUXSEG7EI16_V, 0x0 }, // 5816
  { PseudoVLUXSEG7EI16_V_M2_M1_TU, VLUXSEG7EI16_V, 0x0 }, // 5817
  { PseudoVLUXSEG7EI16_V_MF2_M1, VLUXSEG7EI16_V, 0x0 }, // 5818
  { PseudoVLUXSEG7EI16_V_MF2_M1_MASK, VLUXSEG7EI16_V, 0x0 }, // 5819
  { PseudoVLUXSEG7EI16_V_MF2_M1_TU, VLUXSEG7EI16_V, 0x0 }, // 5820
  { PseudoVLUXSEG7EI16_V_MF4_M1, VLUXSEG7EI16_V, 0x0 }, // 5821
  { PseudoVLUXSEG7EI16_V_MF4_M1_MASK, VLUXSEG7EI16_V, 0x0 }, // 5822
  { PseudoVLUXSEG7EI16_V_MF4_M1_TU, VLUXSEG7EI16_V, 0x0 }, // 5823
  { PseudoVLUXSEG7EI16_V_MF4_MF8, VLUXSEG7EI16_V, 0x5 }, // 5824
  { PseudoVLUXSEG7EI16_V_MF4_MF8_MASK, VLUXSEG7EI16_V, 0x5 }, // 5825
  { PseudoVLUXSEG7EI16_V_MF4_MF8_TU, VLUXSEG7EI16_V, 0x5 }, // 5826
  { PseudoVLUXSEG7EI16_V_MF2_MF4, VLUXSEG7EI16_V, 0x6 }, // 5827
  { PseudoVLUXSEG7EI16_V_MF2_MF4_MASK, VLUXSEG7EI16_V, 0x6 }, // 5828
  { PseudoVLUXSEG7EI16_V_MF2_MF4_TU, VLUXSEG7EI16_V, 0x6 }, // 5829
  { PseudoVLUXSEG7EI16_V_MF4_MF4, VLUXSEG7EI16_V, 0x6 }, // 5830
  { PseudoVLUXSEG7EI16_V_MF4_MF4_MASK, VLUXSEG7EI16_V, 0x6 }, // 5831
  { PseudoVLUXSEG7EI16_V_MF4_MF4_TU, VLUXSEG7EI16_V, 0x6 }, // 5832
  { PseudoVLUXSEG7EI16_V_M1_MF2, VLUXSEG7EI16_V, 0x7 }, // 5833
  { PseudoVLUXSEG7EI16_V_M1_MF2_MASK, VLUXSEG7EI16_V, 0x7 }, // 5834
  { PseudoVLUXSEG7EI16_V_M1_MF2_TU, VLUXSEG7EI16_V, 0x7 }, // 5835
  { PseudoVLUXSEG7EI16_V_MF2_MF2, VLUXSEG7EI16_V, 0x7 }, // 5836
  { PseudoVLUXSEG7EI16_V_MF2_MF2_MASK, VLUXSEG7EI16_V, 0x7 }, // 5837
  { PseudoVLUXSEG7EI16_V_MF2_MF2_TU, VLUXSEG7EI16_V, 0x7 }, // 5838
  { PseudoVLUXSEG7EI16_V_MF4_MF2, VLUXSEG7EI16_V, 0x7 }, // 5839
  { PseudoVLUXSEG7EI16_V_MF4_MF2_MASK, VLUXSEG7EI16_V, 0x7 }, // 5840
  { PseudoVLUXSEG7EI16_V_MF4_MF2_TU, VLUXSEG7EI16_V, 0x7 }, // 5841
  { PseudoVLUXSEG7EI32_V_M1_M1, VLUXSEG7EI32_V, 0x0 }, // 5842
  { PseudoVLUXSEG7EI32_V_M1_M1_MASK, VLUXSEG7EI32_V, 0x0 }, // 5843
  { PseudoVLUXSEG7EI32_V_M1_M1_TU, VLUXSEG7EI32_V, 0x0 }, // 5844
  { PseudoVLUXSEG7EI32_V_M2_M1, VLUXSEG7EI32_V, 0x0 }, // 5845
  { PseudoVLUXSEG7EI32_V_M2_M1_MASK, VLUXSEG7EI32_V, 0x0 }, // 5846
  { PseudoVLUXSEG7EI32_V_M2_M1_TU, VLUXSEG7EI32_V, 0x0 }, // 5847
  { PseudoVLUXSEG7EI32_V_M4_M1, VLUXSEG7EI32_V, 0x0 }, // 5848
  { PseudoVLUXSEG7EI32_V_M4_M1_MASK, VLUXSEG7EI32_V, 0x0 }, // 5849
  { PseudoVLUXSEG7EI32_V_M4_M1_TU, VLUXSEG7EI32_V, 0x0 }, // 5850
  { PseudoVLUXSEG7EI32_V_MF2_M1, VLUXSEG7EI32_V, 0x0 }, // 5851
  { PseudoVLUXSEG7EI32_V_MF2_M1_MASK, VLUXSEG7EI32_V, 0x0 }, // 5852
  { PseudoVLUXSEG7EI32_V_MF2_M1_TU, VLUXSEG7EI32_V, 0x0 }, // 5853
  { PseudoVLUXSEG7EI32_V_MF2_MF8, VLUXSEG7EI32_V, 0x5 }, // 5854
  { PseudoVLUXSEG7EI32_V_MF2_MF8_MASK, VLUXSEG7EI32_V, 0x5 }, // 5855
  { PseudoVLUXSEG7EI32_V_MF2_MF8_TU, VLUXSEG7EI32_V, 0x5 }, // 5856
  { PseudoVLUXSEG7EI32_V_M1_MF4, VLUXSEG7EI32_V, 0x6 }, // 5857
  { PseudoVLUXSEG7EI32_V_M1_MF4_MASK, VLUXSEG7EI32_V, 0x6 }, // 5858
  { PseudoVLUXSEG7EI32_V_M1_MF4_TU, VLUXSEG7EI32_V, 0x6 }, // 5859
  { PseudoVLUXSEG7EI32_V_MF2_MF4, VLUXSEG7EI32_V, 0x6 }, // 5860
  { PseudoVLUXSEG7EI32_V_MF2_MF4_MASK, VLUXSEG7EI32_V, 0x6 }, // 5861
  { PseudoVLUXSEG7EI32_V_MF2_MF4_TU, VLUXSEG7EI32_V, 0x6 }, // 5862
  { PseudoVLUXSEG7EI32_V_M1_MF2, VLUXSEG7EI32_V, 0x7 }, // 5863
  { PseudoVLUXSEG7EI32_V_M1_MF2_MASK, VLUXSEG7EI32_V, 0x7 }, // 5864
  { PseudoVLUXSEG7EI32_V_M1_MF2_TU, VLUXSEG7EI32_V, 0x7 }, // 5865
  { PseudoVLUXSEG7EI32_V_M2_MF2, VLUXSEG7EI32_V, 0x7 }, // 5866
  { PseudoVLUXSEG7EI32_V_M2_MF2_MASK, VLUXSEG7EI32_V, 0x7 }, // 5867
  { PseudoVLUXSEG7EI32_V_M2_MF2_TU, VLUXSEG7EI32_V, 0x7 }, // 5868
  { PseudoVLUXSEG7EI32_V_MF2_MF2, VLUXSEG7EI32_V, 0x7 }, // 5869
  { PseudoVLUXSEG7EI32_V_MF2_MF2_MASK, VLUXSEG7EI32_V, 0x7 }, // 5870
  { PseudoVLUXSEG7EI32_V_MF2_MF2_TU, VLUXSEG7EI32_V, 0x7 }, // 5871
  { PseudoVLUXSEG7EI64_V_M1_M1, VLUXSEG7EI64_V, 0x0 }, // 5872
  { PseudoVLUXSEG7EI64_V_M1_M1_MASK, VLUXSEG7EI64_V, 0x0 }, // 5873
  { PseudoVLUXSEG7EI64_V_M1_M1_TU, VLUXSEG7EI64_V, 0x0 }, // 5874
  { PseudoVLUXSEG7EI64_V_M2_M1, VLUXSEG7EI64_V, 0x0 }, // 5875
  { PseudoVLUXSEG7EI64_V_M2_M1_MASK, VLUXSEG7EI64_V, 0x0 }, // 5876
  { PseudoVLUXSEG7EI64_V_M2_M1_TU, VLUXSEG7EI64_V, 0x0 }, // 5877
  { PseudoVLUXSEG7EI64_V_M4_M1, VLUXSEG7EI64_V, 0x0 }, // 5878
  { PseudoVLUXSEG7EI64_V_M4_M1_MASK, VLUXSEG7EI64_V, 0x0 }, // 5879
  { PseudoVLUXSEG7EI64_V_M4_M1_TU, VLUXSEG7EI64_V, 0x0 }, // 5880
  { PseudoVLUXSEG7EI64_V_M8_M1, VLUXSEG7EI64_V, 0x0 }, // 5881
  { PseudoVLUXSEG7EI64_V_M8_M1_MASK, VLUXSEG7EI64_V, 0x0 }, // 5882
  { PseudoVLUXSEG7EI64_V_M8_M1_TU, VLUXSEG7EI64_V, 0x0 }, // 5883
  { PseudoVLUXSEG7EI64_V_M1_MF8, VLUXSEG7EI64_V, 0x5 }, // 5884
  { PseudoVLUXSEG7EI64_V_M1_MF8_MASK, VLUXSEG7EI64_V, 0x5 }, // 5885
  { PseudoVLUXSEG7EI64_V_M1_MF8_TU, VLUXSEG7EI64_V, 0x5 }, // 5886
  { PseudoVLUXSEG7EI64_V_M1_MF4, VLUXSEG7EI64_V, 0x6 }, // 5887
  { PseudoVLUXSEG7EI64_V_M1_MF4_MASK, VLUXSEG7EI64_V, 0x6 }, // 5888
  { PseudoVLUXSEG7EI64_V_M1_MF4_TU, VLUXSEG7EI64_V, 0x6 }, // 5889
  { PseudoVLUXSEG7EI64_V_M2_MF4, VLUXSEG7EI64_V, 0x6 }, // 5890
  { PseudoVLUXSEG7EI64_V_M2_MF4_MASK, VLUXSEG7EI64_V, 0x6 }, // 5891
  { PseudoVLUXSEG7EI64_V_M2_MF4_TU, VLUXSEG7EI64_V, 0x6 }, // 5892
  { PseudoVLUXSEG7EI64_V_M1_MF2, VLUXSEG7EI64_V, 0x7 }, // 5893
  { PseudoVLUXSEG7EI64_V_M1_MF2_MASK, VLUXSEG7EI64_V, 0x7 }, // 5894
  { PseudoVLUXSEG7EI64_V_M1_MF2_TU, VLUXSEG7EI64_V, 0x7 }, // 5895
  { PseudoVLUXSEG7EI64_V_M2_MF2, VLUXSEG7EI64_V, 0x7 }, // 5896
  { PseudoVLUXSEG7EI64_V_M2_MF2_MASK, VLUXSEG7EI64_V, 0x7 }, // 5897
  { PseudoVLUXSEG7EI64_V_M2_MF2_TU, VLUXSEG7EI64_V, 0x7 }, // 5898
  { PseudoVLUXSEG7EI64_V_M4_MF2, VLUXSEG7EI64_V, 0x7 }, // 5899
  { PseudoVLUXSEG7EI64_V_M4_MF2_MASK, VLUXSEG7EI64_V, 0x7 }, // 5900
  { PseudoVLUXSEG7EI64_V_M4_MF2_TU, VLUXSEG7EI64_V, 0x7 }, // 5901
  { PseudoVLUXSEG7EI8_V_M1_M1, VLUXSEG7EI8_V, 0x0 }, // 5902
  { PseudoVLUXSEG7EI8_V_M1_M1_MASK, VLUXSEG7EI8_V, 0x0 }, // 5903
  { PseudoVLUXSEG7EI8_V_M1_M1_TU, VLUXSEG7EI8_V, 0x0 }, // 5904
  { PseudoVLUXSEG7EI8_V_MF2_M1, VLUXSEG7EI8_V, 0x0 }, // 5905
  { PseudoVLUXSEG7EI8_V_MF2_M1_MASK, VLUXSEG7EI8_V, 0x0 }, // 5906
  { PseudoVLUXSEG7EI8_V_MF2_M1_TU, VLUXSEG7EI8_V, 0x0 }, // 5907
  { PseudoVLUXSEG7EI8_V_MF4_M1, VLUXSEG7EI8_V, 0x0 }, // 5908
  { PseudoVLUXSEG7EI8_V_MF4_M1_MASK, VLUXSEG7EI8_V, 0x0 }, // 5909
  { PseudoVLUXSEG7EI8_V_MF4_M1_TU, VLUXSEG7EI8_V, 0x0 }, // 5910
  { PseudoVLUXSEG7EI8_V_MF8_M1, VLUXSEG7EI8_V, 0x0 }, // 5911
  { PseudoVLUXSEG7EI8_V_MF8_M1_MASK, VLUXSEG7EI8_V, 0x0 }, // 5912
  { PseudoVLUXSEG7EI8_V_MF8_M1_TU, VLUXSEG7EI8_V, 0x0 }, // 5913
  { PseudoVLUXSEG7EI8_V_MF8_MF8, VLUXSEG7EI8_V, 0x5 }, // 5914
  { PseudoVLUXSEG7EI8_V_MF8_MF8_MASK, VLUXSEG7EI8_V, 0x5 }, // 5915
  { PseudoVLUXSEG7EI8_V_MF8_MF8_TU, VLUXSEG7EI8_V, 0x5 }, // 5916
  { PseudoVLUXSEG7EI8_V_MF4_MF4, VLUXSEG7EI8_V, 0x6 }, // 5917
  { PseudoVLUXSEG7EI8_V_MF4_MF4_MASK, VLUXSEG7EI8_V, 0x6 }, // 5918
  { PseudoVLUXSEG7EI8_V_MF4_MF4_TU, VLUXSEG7EI8_V, 0x6 }, // 5919
  { PseudoVLUXSEG7EI8_V_MF8_MF4, VLUXSEG7EI8_V, 0x6 }, // 5920
  { PseudoVLUXSEG7EI8_V_MF8_MF4_MASK, VLUXSEG7EI8_V, 0x6 }, // 5921
  { PseudoVLUXSEG7EI8_V_MF8_MF4_TU, VLUXSEG7EI8_V, 0x6 }, // 5922
  { PseudoVLUXSEG7EI8_V_MF2_MF2, VLUXSEG7EI8_V, 0x7 }, // 5923
  { PseudoVLUXSEG7EI8_V_MF2_MF2_MASK, VLUXSEG7EI8_V, 0x7 }, // 5924
  { PseudoVLUXSEG7EI8_V_MF2_MF2_TU, VLUXSEG7EI8_V, 0x7 }, // 5925
  { PseudoVLUXSEG7EI8_V_MF4_MF2, VLUXSEG7EI8_V, 0x7 }, // 5926
  { PseudoVLUXSEG7EI8_V_MF4_MF2_MASK, VLUXSEG7EI8_V, 0x7 }, // 5927
  { PseudoVLUXSEG7EI8_V_MF4_MF2_TU, VLUXSEG7EI8_V, 0x7 }, // 5928
  { PseudoVLUXSEG7EI8_V_MF8_MF2, VLUXSEG7EI8_V, 0x7 }, // 5929
  { PseudoVLUXSEG7EI8_V_MF8_MF2_MASK, VLUXSEG7EI8_V, 0x7 }, // 5930
  { PseudoVLUXSEG7EI8_V_MF8_MF2_TU, VLUXSEG7EI8_V, 0x7 }, // 5931
  { PseudoVLUXSEG8EI16_V_M1_M1, VLUXSEG8EI16_V, 0x0 }, // 5932
  { PseudoVLUXSEG8EI16_V_M1_M1_MASK, VLUXSEG8EI16_V, 0x0 }, // 5933
  { PseudoVLUXSEG8EI16_V_M1_M1_TU, VLUXSEG8EI16_V, 0x0 }, // 5934
  { PseudoVLUXSEG8EI16_V_M2_M1, VLUXSEG8EI16_V, 0x0 }, // 5935
  { PseudoVLUXSEG8EI16_V_M2_M1_MASK, VLUXSEG8EI16_V, 0x0 }, // 5936
  { PseudoVLUXSEG8EI16_V_M2_M1_TU, VLUXSEG8EI16_V, 0x0 }, // 5937
  { PseudoVLUXSEG8EI16_V_MF2_M1, VLUXSEG8EI16_V, 0x0 }, // 5938
  { PseudoVLUXSEG8EI16_V_MF2_M1_MASK, VLUXSEG8EI16_V, 0x0 }, // 5939
  { PseudoVLUXSEG8EI16_V_MF2_M1_TU, VLUXSEG8EI16_V, 0x0 }, // 5940
  { PseudoVLUXSEG8EI16_V_MF4_M1, VLUXSEG8EI16_V, 0x0 }, // 5941
  { PseudoVLUXSEG8EI16_V_MF4_M1_MASK, VLUXSEG8EI16_V, 0x0 }, // 5942
  { PseudoVLUXSEG8EI16_V_MF4_M1_TU, VLUXSEG8EI16_V, 0x0 }, // 5943
  { PseudoVLUXSEG8EI16_V_MF4_MF8, VLUXSEG8EI16_V, 0x5 }, // 5944
  { PseudoVLUXSEG8EI16_V_MF4_MF8_MASK, VLUXSEG8EI16_V, 0x5 }, // 5945
  { PseudoVLUXSEG8EI16_V_MF4_MF8_TU, VLUXSEG8EI16_V, 0x5 }, // 5946
  { PseudoVLUXSEG8EI16_V_MF2_MF4, VLUXSEG8EI16_V, 0x6 }, // 5947
  { PseudoVLUXSEG8EI16_V_MF2_MF4_MASK, VLUXSEG8EI16_V, 0x6 }, // 5948
  { PseudoVLUXSEG8EI16_V_MF2_MF4_TU, VLUXSEG8EI16_V, 0x6 }, // 5949
  { PseudoVLUXSEG8EI16_V_MF4_MF4, VLUXSEG8EI16_V, 0x6 }, // 5950
  { PseudoVLUXSEG8EI16_V_MF4_MF4_MASK, VLUXSEG8EI16_V, 0x6 }, // 5951
  { PseudoVLUXSEG8EI16_V_MF4_MF4_TU, VLUXSEG8EI16_V, 0x6 }, // 5952
  { PseudoVLUXSEG8EI16_V_M1_MF2, VLUXSEG8EI16_V, 0x7 }, // 5953
  { PseudoVLUXSEG8EI16_V_M1_MF2_MASK, VLUXSEG8EI16_V, 0x7 }, // 5954
  { PseudoVLUXSEG8EI16_V_M1_MF2_TU, VLUXSEG8EI16_V, 0x7 }, // 5955
  { PseudoVLUXSEG8EI16_V_MF2_MF2, VLUXSEG8EI16_V, 0x7 }, // 5956
  { PseudoVLUXSEG8EI16_V_MF2_MF2_MASK, VLUXSEG8EI16_V, 0x7 }, // 5957
  { PseudoVLUXSEG8EI16_V_MF2_MF2_TU, VLUXSEG8EI16_V, 0x7 }, // 5958
  { PseudoVLUXSEG8EI16_V_MF4_MF2, VLUXSEG8EI16_V, 0x7 }, // 5959
  { PseudoVLUXSEG8EI16_V_MF4_MF2_MASK, VLUXSEG8EI16_V, 0x7 }, // 5960
  { PseudoVLUXSEG8EI16_V_MF4_MF2_TU, VLUXSEG8EI16_V, 0x7 }, // 5961
  { PseudoVLUXSEG8EI32_V_M1_M1, VLUXSEG8EI32_V, 0x0 }, // 5962
  { PseudoVLUXSEG8EI32_V_M1_M1_MASK, VLUXSEG8EI32_V, 0x0 }, // 5963
  { PseudoVLUXSEG8EI32_V_M1_M1_TU, VLUXSEG8EI32_V, 0x0 }, // 5964
  { PseudoVLUXSEG8EI32_V_M2_M1, VLUXSEG8EI32_V, 0x0 }, // 5965
  { PseudoVLUXSEG8EI32_V_M2_M1_MASK, VLUXSEG8EI32_V, 0x0 }, // 5966
  { PseudoVLUXSEG8EI32_V_M2_M1_TU, VLUXSEG8EI32_V, 0x0 }, // 5967
  { PseudoVLUXSEG8EI32_V_M4_M1, VLUXSEG8EI32_V, 0x0 }, // 5968
  { PseudoVLUXSEG8EI32_V_M4_M1_MASK, VLUXSEG8EI32_V, 0x0 }, // 5969
  { PseudoVLUXSEG8EI32_V_M4_M1_TU, VLUXSEG8EI32_V, 0x0 }, // 5970
  { PseudoVLUXSEG8EI32_V_MF2_M1, VLUXSEG8EI32_V, 0x0 }, // 5971
  { PseudoVLUXSEG8EI32_V_MF2_M1_MASK, VLUXSEG8EI32_V, 0x0 }, // 5972
  { PseudoVLUXSEG8EI32_V_MF2_M1_TU, VLUXSEG8EI32_V, 0x0 }, // 5973
  { PseudoVLUXSEG8EI32_V_MF2_MF8, VLUXSEG8EI32_V, 0x5 }, // 5974
  { PseudoVLUXSEG8EI32_V_MF2_MF8_MASK, VLUXSEG8EI32_V, 0x5 }, // 5975
  { PseudoVLUXSEG8EI32_V_MF2_MF8_TU, VLUXSEG8EI32_V, 0x5 }, // 5976
  { PseudoVLUXSEG8EI32_V_M1_MF4, VLUXSEG8EI32_V, 0x6 }, // 5977
  { PseudoVLUXSEG8EI32_V_M1_MF4_MASK, VLUXSEG8EI32_V, 0x6 }, // 5978
  { PseudoVLUXSEG8EI32_V_M1_MF4_TU, VLUXSEG8EI32_V, 0x6 }, // 5979
  { PseudoVLUXSEG8EI32_V_MF2_MF4, VLUXSEG8EI32_V, 0x6 }, // 5980
  { PseudoVLUXSEG8EI32_V_MF2_MF4_MASK, VLUXSEG8EI32_V, 0x6 }, // 5981
  { PseudoVLUXSEG8EI32_V_MF2_MF4_TU, VLUXSEG8EI32_V, 0x6 }, // 5982
  { PseudoVLUXSEG8EI32_V_M1_MF2, VLUXSEG8EI32_V, 0x7 }, // 5983
  { PseudoVLUXSEG8EI32_V_M1_MF2_MASK, VLUXSEG8EI32_V, 0x7 }, // 5984
  { PseudoVLUXSEG8EI32_V_M1_MF2_TU, VLUXSEG8EI32_V, 0x7 }, // 5985
  { PseudoVLUXSEG8EI32_V_M2_MF2, VLUXSEG8EI32_V, 0x7 }, // 5986
  { PseudoVLUXSEG8EI32_V_M2_MF2_MASK, VLUXSEG8EI32_V, 0x7 }, // 5987
  { PseudoVLUXSEG8EI32_V_M2_MF2_TU, VLUXSEG8EI32_V, 0x7 }, // 5988
  { PseudoVLUXSEG8EI32_V_MF2_MF2, VLUXSEG8EI32_V, 0x7 }, // 5989
  { PseudoVLUXSEG8EI32_V_MF2_MF2_MASK, VLUXSEG8EI32_V, 0x7 }, // 5990
  { PseudoVLUXSEG8EI32_V_MF2_MF2_TU, VLUXSEG8EI32_V, 0x7 }, // 5991
  { PseudoVLUXSEG8EI64_V_M1_M1, VLUXSEG8EI64_V, 0x0 }, // 5992
  { PseudoVLUXSEG8EI64_V_M1_M1_MASK, VLUXSEG8EI64_V, 0x0 }, // 5993
  { PseudoVLUXSEG8EI64_V_M1_M1_TU, VLUXSEG8EI64_V, 0x0 }, // 5994
  { PseudoVLUXSEG8EI64_V_M2_M1, VLUXSEG8EI64_V, 0x0 }, // 5995
  { PseudoVLUXSEG8EI64_V_M2_M1_MASK, VLUXSEG8EI64_V, 0x0 }, // 5996
  { PseudoVLUXSEG8EI64_V_M2_M1_TU, VLUXSEG8EI64_V, 0x0 }, // 5997
  { PseudoVLUXSEG8EI64_V_M4_M1, VLUXSEG8EI64_V, 0x0 }, // 5998
  { PseudoVLUXSEG8EI64_V_M4_M1_MASK, VLUXSEG8EI64_V, 0x0 }, // 5999
  { PseudoVLUXSEG8EI64_V_M4_M1_TU, VLUXSEG8EI64_V, 0x0 }, // 6000
  { PseudoVLUXSEG8EI64_V_M8_M1, VLUXSEG8EI64_V, 0x0 }, // 6001
  { PseudoVLUXSEG8EI64_V_M8_M1_MASK, VLUXSEG8EI64_V, 0x0 }, // 6002
  { PseudoVLUXSEG8EI64_V_M8_M1_TU, VLUXSEG8EI64_V, 0x0 }, // 6003
  { PseudoVLUXSEG8EI64_V_M1_MF8, VLUXSEG8EI64_V, 0x5 }, // 6004
  { PseudoVLUXSEG8EI64_V_M1_MF8_MASK, VLUXSEG8EI64_V, 0x5 }, // 6005
  { PseudoVLUXSEG8EI64_V_M1_MF8_TU, VLUXSEG8EI64_V, 0x5 }, // 6006
  { PseudoVLUXSEG8EI64_V_M1_MF4, VLUXSEG8EI64_V, 0x6 }, // 6007
  { PseudoVLUXSEG8EI64_V_M1_MF4_MASK, VLUXSEG8EI64_V, 0x6 }, // 6008
  { PseudoVLUXSEG8EI64_V_M1_MF4_TU, VLUXSEG8EI64_V, 0x6 }, // 6009
  { PseudoVLUXSEG8EI64_V_M2_MF4, VLUXSEG8EI64_V, 0x6 }, // 6010
  { PseudoVLUXSEG8EI64_V_M2_MF4_MASK, VLUXSEG8EI64_V, 0x6 }, // 6011
  { PseudoVLUXSEG8EI64_V_M2_MF4_TU, VLUXSEG8EI64_V, 0x6 }, // 6012
  { PseudoVLUXSEG8EI64_V_M1_MF2, VLUXSEG8EI64_V, 0x7 }, // 6013
  { PseudoVLUXSEG8EI64_V_M1_MF2_MASK, VLUXSEG8EI64_V, 0x7 }, // 6014
  { PseudoVLUXSEG8EI64_V_M1_MF2_TU, VLUXSEG8EI64_V, 0x7 }, // 6015
  { PseudoVLUXSEG8EI64_V_M2_MF2, VLUXSEG8EI64_V, 0x7 }, // 6016
  { PseudoVLUXSEG8EI64_V_M2_MF2_MASK, VLUXSEG8EI64_V, 0x7 }, // 6017
  { PseudoVLUXSEG8EI64_V_M2_MF2_TU, VLUXSEG8EI64_V, 0x7 }, // 6018
  { PseudoVLUXSEG8EI64_V_M4_MF2, VLUXSEG8EI64_V, 0x7 }, // 6019
  { PseudoVLUXSEG8EI64_V_M4_MF2_MASK, VLUXSEG8EI64_V, 0x7 }, // 6020
  { PseudoVLUXSEG8EI64_V_M4_MF2_TU, VLUXSEG8EI64_V, 0x7 }, // 6021
  { PseudoVLUXSEG8EI8_V_M1_M1, VLUXSEG8EI8_V, 0x0 }, // 6022
  { PseudoVLUXSEG8EI8_V_M1_M1_MASK, VLUXSEG8EI8_V, 0x0 }, // 6023
  { PseudoVLUXSEG8EI8_V_M1_M1_TU, VLUXSEG8EI8_V, 0x0 }, // 6024
  { PseudoVLUXSEG8EI8_V_MF2_M1, VLUXSEG8EI8_V, 0x0 }, // 6025
  { PseudoVLUXSEG8EI8_V_MF2_M1_MASK, VLUXSEG8EI8_V, 0x0 }, // 6026
  { PseudoVLUXSEG8EI8_V_MF2_M1_TU, VLUXSEG8EI8_V, 0x0 }, // 6027
  { PseudoVLUXSEG8EI8_V_MF4_M1, VLUXSEG8EI8_V, 0x0 }, // 6028
  { PseudoVLUXSEG8EI8_V_MF4_M1_MASK, VLUXSEG8EI8_V, 0x0 }, // 6029
  { PseudoVLUXSEG8EI8_V_MF4_M1_TU, VLUXSEG8EI8_V, 0x0 }, // 6030
  { PseudoVLUXSEG8EI8_V_MF8_M1, VLUXSEG8EI8_V, 0x0 }, // 6031
  { PseudoVLUXSEG8EI8_V_MF8_M1_MASK, VLUXSEG8EI8_V, 0x0 }, // 6032
  { PseudoVLUXSEG8EI8_V_MF8_M1_TU, VLUXSEG8EI8_V, 0x0 }, // 6033
  { PseudoVLUXSEG8EI8_V_MF8_MF8, VLUXSEG8EI8_V, 0x5 }, // 6034
  { PseudoVLUXSEG8EI8_V_MF8_MF8_MASK, VLUXSEG8EI8_V, 0x5 }, // 6035
  { PseudoVLUXSEG8EI8_V_MF8_MF8_TU, VLUXSEG8EI8_V, 0x5 }, // 6036
  { PseudoVLUXSEG8EI8_V_MF4_MF4, VLUXSEG8EI8_V, 0x6 }, // 6037
  { PseudoVLUXSEG8EI8_V_MF4_MF4_MASK, VLUXSEG8EI8_V, 0x6 }, // 6038
  { PseudoVLUXSEG8EI8_V_MF4_MF4_TU, VLUXSEG8EI8_V, 0x6 }, // 6039
  { PseudoVLUXSEG8EI8_V_MF8_MF4, VLUXSEG8EI8_V, 0x6 }, // 6040
  { PseudoVLUXSEG8EI8_V_MF8_MF4_MASK, VLUXSEG8EI8_V, 0x6 }, // 6041
  { PseudoVLUXSEG8EI8_V_MF8_MF4_TU, VLUXSEG8EI8_V, 0x6 }, // 6042
  { PseudoVLUXSEG8EI8_V_MF2_MF2, VLUXSEG8EI8_V, 0x7 }, // 6043
  { PseudoVLUXSEG8EI8_V_MF2_MF2_MASK, VLUXSEG8EI8_V, 0x7 }, // 6044
  { PseudoVLUXSEG8EI8_V_MF2_MF2_TU, VLUXSEG8EI8_V, 0x7 }, // 6045
  { PseudoVLUXSEG8EI8_V_MF4_MF2, VLUXSEG8EI8_V, 0x7 }, // 6046
  { PseudoVLUXSEG8EI8_V_MF4_MF2_MASK, VLUXSEG8EI8_V, 0x7 }, // 6047
  { PseudoVLUXSEG8EI8_V_MF4_MF2_TU, VLUXSEG8EI8_V, 0x7 }, // 6048
  { PseudoVLUXSEG8EI8_V_MF8_MF2, VLUXSEG8EI8_V, 0x7 }, // 6049
  { PseudoVLUXSEG8EI8_V_MF8_MF2_MASK, VLUXSEG8EI8_V, 0x7 }, // 6050
  { PseudoVLUXSEG8EI8_V_MF8_MF2_TU, VLUXSEG8EI8_V, 0x7 }, // 6051
  { PseudoVMACC_VV_M1, VMACC_VV, 0x0 }, // 6052
  { PseudoVMACC_VV_M1_MASK, VMACC_VV, 0x0 }, // 6053
  { PseudoVMACC_VV_M2, VMACC_VV, 0x1 }, // 6054
  { PseudoVMACC_VV_M2_MASK, VMACC_VV, 0x1 }, // 6055
  { PseudoVMACC_VV_M4, VMACC_VV, 0x2 }, // 6056
  { PseudoVMACC_VV_M4_MASK, VMACC_VV, 0x2 }, // 6057
  { PseudoVMACC_VV_M8, VMACC_VV, 0x3 }, // 6058
  { PseudoVMACC_VV_M8_MASK, VMACC_VV, 0x3 }, // 6059
  { PseudoVMACC_VV_MF8, VMACC_VV, 0x5 }, // 6060
  { PseudoVMACC_VV_MF8_MASK, VMACC_VV, 0x5 }, // 6061
  { PseudoVMACC_VV_MF4, VMACC_VV, 0x6 }, // 6062
  { PseudoVMACC_VV_MF4_MASK, VMACC_VV, 0x6 }, // 6063
  { PseudoVMACC_VV_MF2, VMACC_VV, 0x7 }, // 6064
  { PseudoVMACC_VV_MF2_MASK, VMACC_VV, 0x7 }, // 6065
  { PseudoVMACC_VX_M1, VMACC_VX, 0x0 }, // 6066
  { PseudoVMACC_VX_M1_MASK, VMACC_VX, 0x0 }, // 6067
  { PseudoVMACC_VX_M2, VMACC_VX, 0x1 }, // 6068
  { PseudoVMACC_VX_M2_MASK, VMACC_VX, 0x1 }, // 6069
  { PseudoVMACC_VX_M4, VMACC_VX, 0x2 }, // 6070
  { PseudoVMACC_VX_M4_MASK, VMACC_VX, 0x2 }, // 6071
  { PseudoVMACC_VX_M8, VMACC_VX, 0x3 }, // 6072
  { PseudoVMACC_VX_M8_MASK, VMACC_VX, 0x3 }, // 6073
  { PseudoVMACC_VX_MF8, VMACC_VX, 0x5 }, // 6074
  { PseudoVMACC_VX_MF8_MASK, VMACC_VX, 0x5 }, // 6075
  { PseudoVMACC_VX_MF4, VMACC_VX, 0x6 }, // 6076
  { PseudoVMACC_VX_MF4_MASK, VMACC_VX, 0x6 }, // 6077
  { PseudoVMACC_VX_MF2, VMACC_VX, 0x7 }, // 6078
  { PseudoVMACC_VX_MF2_MASK, VMACC_VX, 0x7 }, // 6079
  { PseudoVMADC_VI_M1, VMADC_VI, 0x0 }, // 6080
  { PseudoVMADC_VI_M2, VMADC_VI, 0x1 }, // 6081
  { PseudoVMADC_VI_M4, VMADC_VI, 0x2 }, // 6082
  { PseudoVMADC_VI_M8, VMADC_VI, 0x3 }, // 6083
  { PseudoVMADC_VI_MF8, VMADC_VI, 0x5 }, // 6084
  { PseudoVMADC_VI_MF4, VMADC_VI, 0x6 }, // 6085
  { PseudoVMADC_VI_MF2, VMADC_VI, 0x7 }, // 6086
  { PseudoVMADC_VIM_M1, VMADC_VIM, 0x0 }, // 6087
  { PseudoVMADC_VIM_M2, VMADC_VIM, 0x1 }, // 6088
  { PseudoVMADC_VIM_M4, VMADC_VIM, 0x2 }, // 6089
  { PseudoVMADC_VIM_M8, VMADC_VIM, 0x3 }, // 6090
  { PseudoVMADC_VIM_MF8, VMADC_VIM, 0x5 }, // 6091
  { PseudoVMADC_VIM_MF4, VMADC_VIM, 0x6 }, // 6092
  { PseudoVMADC_VIM_MF2, VMADC_VIM, 0x7 }, // 6093
  { PseudoVMADC_VV_M1, VMADC_VV, 0x0 }, // 6094
  { PseudoVMADC_VV_M2, VMADC_VV, 0x1 }, // 6095
  { PseudoVMADC_VV_M4, VMADC_VV, 0x2 }, // 6096
  { PseudoVMADC_VV_M8, VMADC_VV, 0x3 }, // 6097
  { PseudoVMADC_VV_MF8, VMADC_VV, 0x5 }, // 6098
  { PseudoVMADC_VV_MF4, VMADC_VV, 0x6 }, // 6099
  { PseudoVMADC_VV_MF2, VMADC_VV, 0x7 }, // 6100
  { PseudoVMADC_VVM_M1, VMADC_VVM, 0x0 }, // 6101
  { PseudoVMADC_VVM_M2, VMADC_VVM, 0x1 }, // 6102
  { PseudoVMADC_VVM_M4, VMADC_VVM, 0x2 }, // 6103
  { PseudoVMADC_VVM_M8, VMADC_VVM, 0x3 }, // 6104
  { PseudoVMADC_VVM_MF8, VMADC_VVM, 0x5 }, // 6105
  { PseudoVMADC_VVM_MF4, VMADC_VVM, 0x6 }, // 6106
  { PseudoVMADC_VVM_MF2, VMADC_VVM, 0x7 }, // 6107
  { PseudoVMADC_VX_M1, VMADC_VX, 0x0 }, // 6108
  { PseudoVMADC_VX_M2, VMADC_VX, 0x1 }, // 6109
  { PseudoVMADC_VX_M4, VMADC_VX, 0x2 }, // 6110
  { PseudoVMADC_VX_M8, VMADC_VX, 0x3 }, // 6111
  { PseudoVMADC_VX_MF8, VMADC_VX, 0x5 }, // 6112
  { PseudoVMADC_VX_MF4, VMADC_VX, 0x6 }, // 6113
  { PseudoVMADC_VX_MF2, VMADC_VX, 0x7 }, // 6114
  { PseudoVMADC_VXM_M1, VMADC_VXM, 0x0 }, // 6115
  { PseudoVMADC_VXM_M2, VMADC_VXM, 0x1 }, // 6116
  { PseudoVMADC_VXM_M4, VMADC_VXM, 0x2 }, // 6117
  { PseudoVMADC_VXM_M8, VMADC_VXM, 0x3 }, // 6118
  { PseudoVMADC_VXM_MF8, VMADC_VXM, 0x5 }, // 6119
  { PseudoVMADC_VXM_MF4, VMADC_VXM, 0x6 }, // 6120
  { PseudoVMADC_VXM_MF2, VMADC_VXM, 0x7 }, // 6121
  { PseudoVMADD_VV_M1, VMADD_VV, 0x0 }, // 6122
  { PseudoVMADD_VV_M1_MASK, VMADD_VV, 0x0 }, // 6123
  { PseudoVMADD_VV_M2, VMADD_VV, 0x1 }, // 6124
  { PseudoVMADD_VV_M2_MASK, VMADD_VV, 0x1 }, // 6125
  { PseudoVMADD_VV_M4, VMADD_VV, 0x2 }, // 6126
  { PseudoVMADD_VV_M4_MASK, VMADD_VV, 0x2 }, // 6127
  { PseudoVMADD_VV_M8, VMADD_VV, 0x3 }, // 6128
  { PseudoVMADD_VV_M8_MASK, VMADD_VV, 0x3 }, // 6129
  { PseudoVMADD_VV_MF8, VMADD_VV, 0x5 }, // 6130
  { PseudoVMADD_VV_MF8_MASK, VMADD_VV, 0x5 }, // 6131
  { PseudoVMADD_VV_MF4, VMADD_VV, 0x6 }, // 6132
  { PseudoVMADD_VV_MF4_MASK, VMADD_VV, 0x6 }, // 6133
  { PseudoVMADD_VV_MF2, VMADD_VV, 0x7 }, // 6134
  { PseudoVMADD_VV_MF2_MASK, VMADD_VV, 0x7 }, // 6135
  { PseudoVMADD_VX_M1, VMADD_VX, 0x0 }, // 6136
  { PseudoVMADD_VX_M1_MASK, VMADD_VX, 0x0 }, // 6137
  { PseudoVMADD_VX_M2, VMADD_VX, 0x1 }, // 6138
  { PseudoVMADD_VX_M2_MASK, VMADD_VX, 0x1 }, // 6139
  { PseudoVMADD_VX_M4, VMADD_VX, 0x2 }, // 6140
  { PseudoVMADD_VX_M4_MASK, VMADD_VX, 0x2 }, // 6141
  { PseudoVMADD_VX_M8, VMADD_VX, 0x3 }, // 6142
  { PseudoVMADD_VX_M8_MASK, VMADD_VX, 0x3 }, // 6143
  { PseudoVMADD_VX_MF8, VMADD_VX, 0x5 }, // 6144
  { PseudoVMADD_VX_MF8_MASK, VMADD_VX, 0x5 }, // 6145
  { PseudoVMADD_VX_MF4, VMADD_VX, 0x6 }, // 6146
  { PseudoVMADD_VX_MF4_MASK, VMADD_VX, 0x6 }, // 6147
  { PseudoVMADD_VX_MF2, VMADD_VX, 0x7 }, // 6148
  { PseudoVMADD_VX_MF2_MASK, VMADD_VX, 0x7 }, // 6149
  { PseudoVMANDN_MM_M1, VMANDN_MM, 0x0 }, // 6150
  { PseudoVMANDN_MM_M2, VMANDN_MM, 0x1 }, // 6151
  { PseudoVMANDN_MM_M4, VMANDN_MM, 0x2 }, // 6152
  { PseudoVMANDN_MM_M8, VMANDN_MM, 0x3 }, // 6153
  { PseudoVMANDN_MM_MF8, VMANDN_MM, 0x5 }, // 6154
  { PseudoVMANDN_MM_MF4, VMANDN_MM, 0x6 }, // 6155
  { PseudoVMANDN_MM_MF2, VMANDN_MM, 0x7 }, // 6156
  { PseudoVMAND_MM_M1, VMAND_MM, 0x0 }, // 6157
  { PseudoVMAND_MM_M2, VMAND_MM, 0x1 }, // 6158
  { PseudoVMAND_MM_M4, VMAND_MM, 0x2 }, // 6159
  { PseudoVMAND_MM_M8, VMAND_MM, 0x3 }, // 6160
  { PseudoVMAND_MM_MF8, VMAND_MM, 0x5 }, // 6161
  { PseudoVMAND_MM_MF4, VMAND_MM, 0x6 }, // 6162
  { PseudoVMAND_MM_MF2, VMAND_MM, 0x7 }, // 6163
  { PseudoVMAXU_VV_M1, VMAXU_VV, 0x0 }, // 6164
  { PseudoVMAXU_VV_M1_MASK, VMAXU_VV, 0x0 }, // 6165
  { PseudoVMAXU_VV_M1_TU, VMAXU_VV, 0x0 }, // 6166
  { PseudoVMAXU_VV_M2, VMAXU_VV, 0x1 }, // 6167
  { PseudoVMAXU_VV_M2_MASK, VMAXU_VV, 0x1 }, // 6168
  { PseudoVMAXU_VV_M2_TU, VMAXU_VV, 0x1 }, // 6169
  { PseudoVMAXU_VV_M4, VMAXU_VV, 0x2 }, // 6170
  { PseudoVMAXU_VV_M4_MASK, VMAXU_VV, 0x2 }, // 6171
  { PseudoVMAXU_VV_M4_TU, VMAXU_VV, 0x2 }, // 6172
  { PseudoVMAXU_VV_M8, VMAXU_VV, 0x3 }, // 6173
  { PseudoVMAXU_VV_M8_MASK, VMAXU_VV, 0x3 }, // 6174
  { PseudoVMAXU_VV_M8_TU, VMAXU_VV, 0x3 }, // 6175
  { PseudoVMAXU_VV_MF8, VMAXU_VV, 0x5 }, // 6176
  { PseudoVMAXU_VV_MF8_MASK, VMAXU_VV, 0x5 }, // 6177
  { PseudoVMAXU_VV_MF8_TU, VMAXU_VV, 0x5 }, // 6178
  { PseudoVMAXU_VV_MF4, VMAXU_VV, 0x6 }, // 6179
  { PseudoVMAXU_VV_MF4_MASK, VMAXU_VV, 0x6 }, // 6180
  { PseudoVMAXU_VV_MF4_TU, VMAXU_VV, 0x6 }, // 6181
  { PseudoVMAXU_VV_MF2, VMAXU_VV, 0x7 }, // 6182
  { PseudoVMAXU_VV_MF2_MASK, VMAXU_VV, 0x7 }, // 6183
  { PseudoVMAXU_VV_MF2_TU, VMAXU_VV, 0x7 }, // 6184
  { PseudoVMAXU_VX_M1, VMAXU_VX, 0x0 }, // 6185
  { PseudoVMAXU_VX_M1_MASK, VMAXU_VX, 0x0 }, // 6186
  { PseudoVMAXU_VX_M1_TU, VMAXU_VX, 0x0 }, // 6187
  { PseudoVMAXU_VX_M2, VMAXU_VX, 0x1 }, // 6188
  { PseudoVMAXU_VX_M2_MASK, VMAXU_VX, 0x1 }, // 6189
  { PseudoVMAXU_VX_M2_TU, VMAXU_VX, 0x1 }, // 6190
  { PseudoVMAXU_VX_M4, VMAXU_VX, 0x2 }, // 6191
  { PseudoVMAXU_VX_M4_MASK, VMAXU_VX, 0x2 }, // 6192
  { PseudoVMAXU_VX_M4_TU, VMAXU_VX, 0x2 }, // 6193
  { PseudoVMAXU_VX_M8, VMAXU_VX, 0x3 }, // 6194
  { PseudoVMAXU_VX_M8_MASK, VMAXU_VX, 0x3 }, // 6195
  { PseudoVMAXU_VX_M8_TU, VMAXU_VX, 0x3 }, // 6196
  { PseudoVMAXU_VX_MF8, VMAXU_VX, 0x5 }, // 6197
  { PseudoVMAXU_VX_MF8_MASK, VMAXU_VX, 0x5 }, // 6198
  { PseudoVMAXU_VX_MF8_TU, VMAXU_VX, 0x5 }, // 6199
  { PseudoVMAXU_VX_MF4, VMAXU_VX, 0x6 }, // 6200
  { PseudoVMAXU_VX_MF4_MASK, VMAXU_VX, 0x6 }, // 6201
  { PseudoVMAXU_VX_MF4_TU, VMAXU_VX, 0x6 }, // 6202
  { PseudoVMAXU_VX_MF2, VMAXU_VX, 0x7 }, // 6203
  { PseudoVMAXU_VX_MF2_MASK, VMAXU_VX, 0x7 }, // 6204
  { PseudoVMAXU_VX_MF2_TU, VMAXU_VX, 0x7 }, // 6205
  { PseudoVMAX_VV_M1, VMAX_VV, 0x0 }, // 6206
  { PseudoVMAX_VV_M1_MASK, VMAX_VV, 0x0 }, // 6207
  { PseudoVMAX_VV_M1_TU, VMAX_VV, 0x0 }, // 6208
  { PseudoVMAX_VV_M2, VMAX_VV, 0x1 }, // 6209
  { PseudoVMAX_VV_M2_MASK, VMAX_VV, 0x1 }, // 6210
  { PseudoVMAX_VV_M2_TU, VMAX_VV, 0x1 }, // 6211
  { PseudoVMAX_VV_M4, VMAX_VV, 0x2 }, // 6212
  { PseudoVMAX_VV_M4_MASK, VMAX_VV, 0x2 }, // 6213
  { PseudoVMAX_VV_M4_TU, VMAX_VV, 0x2 }, // 6214
  { PseudoVMAX_VV_M8, VMAX_VV, 0x3 }, // 6215
  { PseudoVMAX_VV_M8_MASK, VMAX_VV, 0x3 }, // 6216
  { PseudoVMAX_VV_M8_TU, VMAX_VV, 0x3 }, // 6217
  { PseudoVMAX_VV_MF8, VMAX_VV, 0x5 }, // 6218
  { PseudoVMAX_VV_MF8_MASK, VMAX_VV, 0x5 }, // 6219
  { PseudoVMAX_VV_MF8_TU, VMAX_VV, 0x5 }, // 6220
  { PseudoVMAX_VV_MF4, VMAX_VV, 0x6 }, // 6221
  { PseudoVMAX_VV_MF4_MASK, VMAX_VV, 0x6 }, // 6222
  { PseudoVMAX_VV_MF4_TU, VMAX_VV, 0x6 }, // 6223
  { PseudoVMAX_VV_MF2, VMAX_VV, 0x7 }, // 6224
  { PseudoVMAX_VV_MF2_MASK, VMAX_VV, 0x7 }, // 6225
  { PseudoVMAX_VV_MF2_TU, VMAX_VV, 0x7 }, // 6226
  { PseudoVMAX_VX_M1, VMAX_VX, 0x0 }, // 6227
  { PseudoVMAX_VX_M1_MASK, VMAX_VX, 0x0 }, // 6228
  { PseudoVMAX_VX_M1_TU, VMAX_VX, 0x0 }, // 6229
  { PseudoVMAX_VX_M2, VMAX_VX, 0x1 }, // 6230
  { PseudoVMAX_VX_M2_MASK, VMAX_VX, 0x1 }, // 6231
  { PseudoVMAX_VX_M2_TU, VMAX_VX, 0x1 }, // 6232
  { PseudoVMAX_VX_M4, VMAX_VX, 0x2 }, // 6233
  { PseudoVMAX_VX_M4_MASK, VMAX_VX, 0x2 }, // 6234
  { PseudoVMAX_VX_M4_TU, VMAX_VX, 0x2 }, // 6235
  { PseudoVMAX_VX_M8, VMAX_VX, 0x3 }, // 6236
  { PseudoVMAX_VX_M8_MASK, VMAX_VX, 0x3 }, // 6237
  { PseudoVMAX_VX_M8_TU, VMAX_VX, 0x3 }, // 6238
  { PseudoVMAX_VX_MF8, VMAX_VX, 0x5 }, // 6239
  { PseudoVMAX_VX_MF8_MASK, VMAX_VX, 0x5 }, // 6240
  { PseudoVMAX_VX_MF8_TU, VMAX_VX, 0x5 }, // 6241
  { PseudoVMAX_VX_MF4, VMAX_VX, 0x6 }, // 6242
  { PseudoVMAX_VX_MF4_MASK, VMAX_VX, 0x6 }, // 6243
  { PseudoVMAX_VX_MF4_TU, VMAX_VX, 0x6 }, // 6244
  { PseudoVMAX_VX_MF2, VMAX_VX, 0x7 }, // 6245
  { PseudoVMAX_VX_MF2_MASK, VMAX_VX, 0x7 }, // 6246
  { PseudoVMAX_VX_MF2_TU, VMAX_VX, 0x7 }, // 6247
  { PseudoVMERGE_VIM_M1, VMERGE_VIM, 0x0 }, // 6248
  { PseudoVMERGE_VIM_M1_TU, VMERGE_VIM, 0x0 }, // 6249
  { PseudoVMERGE_VIM_M2, VMERGE_VIM, 0x1 }, // 6250
  { PseudoVMERGE_VIM_M2_TU, VMERGE_VIM, 0x1 }, // 6251
  { PseudoVMERGE_VIM_M4, VMERGE_VIM, 0x2 }, // 6252
  { PseudoVMERGE_VIM_M4_TU, VMERGE_VIM, 0x2 }, // 6253
  { PseudoVMERGE_VIM_M8, VMERGE_VIM, 0x3 }, // 6254
  { PseudoVMERGE_VIM_M8_TU, VMERGE_VIM, 0x3 }, // 6255
  { PseudoVMERGE_VIM_MF8, VMERGE_VIM, 0x5 }, // 6256
  { PseudoVMERGE_VIM_MF8_TU, VMERGE_VIM, 0x5 }, // 6257
  { PseudoVMERGE_VIM_MF4, VMERGE_VIM, 0x6 }, // 6258
  { PseudoVMERGE_VIM_MF4_TU, VMERGE_VIM, 0x6 }, // 6259
  { PseudoVMERGE_VIM_MF2, VMERGE_VIM, 0x7 }, // 6260
  { PseudoVMERGE_VIM_MF2_TU, VMERGE_VIM, 0x7 }, // 6261
  { PseudoVMERGE_VVM_M1, VMERGE_VVM, 0x0 }, // 6262
  { PseudoVMERGE_VVM_M1_TU, VMERGE_VVM, 0x0 }, // 6263
  { PseudoVMERGE_VVM_M2, VMERGE_VVM, 0x1 }, // 6264
  { PseudoVMERGE_VVM_M2_TU, VMERGE_VVM, 0x1 }, // 6265
  { PseudoVMERGE_VVM_M4, VMERGE_VVM, 0x2 }, // 6266
  { PseudoVMERGE_VVM_M4_TU, VMERGE_VVM, 0x2 }, // 6267
  { PseudoVMERGE_VVM_M8, VMERGE_VVM, 0x3 }, // 6268
  { PseudoVMERGE_VVM_M8_TU, VMERGE_VVM, 0x3 }, // 6269
  { PseudoVMERGE_VVM_MF8, VMERGE_VVM, 0x5 }, // 6270
  { PseudoVMERGE_VVM_MF8_TU, VMERGE_VVM, 0x5 }, // 6271
  { PseudoVMERGE_VVM_MF4, VMERGE_VVM, 0x6 }, // 6272
  { PseudoVMERGE_VVM_MF4_TU, VMERGE_VVM, 0x6 }, // 6273
  { PseudoVMERGE_VVM_MF2, VMERGE_VVM, 0x7 }, // 6274
  { PseudoVMERGE_VVM_MF2_TU, VMERGE_VVM, 0x7 }, // 6275
  { PseudoVMERGE_VXM_M1, VMERGE_VXM, 0x0 }, // 6276
  { PseudoVMERGE_VXM_M1_TU, VMERGE_VXM, 0x0 }, // 6277
  { PseudoVMERGE_VXM_M2, VMERGE_VXM, 0x1 }, // 6278
  { PseudoVMERGE_VXM_M2_TU, VMERGE_VXM, 0x1 }, // 6279
  { PseudoVMERGE_VXM_M4, VMERGE_VXM, 0x2 }, // 6280
  { PseudoVMERGE_VXM_M4_TU, VMERGE_VXM, 0x2 }, // 6281
  { PseudoVMERGE_VXM_M8, VMERGE_VXM, 0x3 }, // 6282
  { PseudoVMERGE_VXM_M8_TU, VMERGE_VXM, 0x3 }, // 6283
  { PseudoVMERGE_VXM_MF8, VMERGE_VXM, 0x5 }, // 6284
  { PseudoVMERGE_VXM_MF8_TU, VMERGE_VXM, 0x5 }, // 6285
  { PseudoVMERGE_VXM_MF4, VMERGE_VXM, 0x6 }, // 6286
  { PseudoVMERGE_VXM_MF4_TU, VMERGE_VXM, 0x6 }, // 6287
  { PseudoVMERGE_VXM_MF2, VMERGE_VXM, 0x7 }, // 6288
  { PseudoVMERGE_VXM_MF2_TU, VMERGE_VXM, 0x7 }, // 6289
  { PseudoVMFEQ_VF16_M1, VMFEQ_VF, 0x0 }, // 6290
  { PseudoVMFEQ_VF16_M1_MASK, VMFEQ_VF, 0x0 }, // 6291
  { PseudoVMFEQ_VF32_M1, VMFEQ_VF, 0x0 }, // 6292
  { PseudoVMFEQ_VF32_M1_MASK, VMFEQ_VF, 0x0 }, // 6293
  { PseudoVMFEQ_VF64_M1, VMFEQ_VF, 0x0 }, // 6294
  { PseudoVMFEQ_VF64_M1_MASK, VMFEQ_VF, 0x0 }, // 6295
  { PseudoVMFEQ_VF16_M2, VMFEQ_VF, 0x1 }, // 6296
  { PseudoVMFEQ_VF16_M2_MASK, VMFEQ_VF, 0x1 }, // 6297
  { PseudoVMFEQ_VF32_M2, VMFEQ_VF, 0x1 }, // 6298
  { PseudoVMFEQ_VF32_M2_MASK, VMFEQ_VF, 0x1 }, // 6299
  { PseudoVMFEQ_VF64_M2, VMFEQ_VF, 0x1 }, // 6300
  { PseudoVMFEQ_VF64_M2_MASK, VMFEQ_VF, 0x1 }, // 6301
  { PseudoVMFEQ_VF16_M4, VMFEQ_VF, 0x2 }, // 6302
  { PseudoVMFEQ_VF16_M4_MASK, VMFEQ_VF, 0x2 }, // 6303
  { PseudoVMFEQ_VF32_M4, VMFEQ_VF, 0x2 }, // 6304
  { PseudoVMFEQ_VF32_M4_MASK, VMFEQ_VF, 0x2 }, // 6305
  { PseudoVMFEQ_VF64_M4, VMFEQ_VF, 0x2 }, // 6306
  { PseudoVMFEQ_VF64_M4_MASK, VMFEQ_VF, 0x2 }, // 6307
  { PseudoVMFEQ_VF16_M8, VMFEQ_VF, 0x3 }, // 6308
  { PseudoVMFEQ_VF16_M8_MASK, VMFEQ_VF, 0x3 }, // 6309
  { PseudoVMFEQ_VF32_M8, VMFEQ_VF, 0x3 }, // 6310
  { PseudoVMFEQ_VF32_M8_MASK, VMFEQ_VF, 0x3 }, // 6311
  { PseudoVMFEQ_VF64_M8, VMFEQ_VF, 0x3 }, // 6312
  { PseudoVMFEQ_VF64_M8_MASK, VMFEQ_VF, 0x3 }, // 6313
  { PseudoVMFEQ_VF16_MF4, VMFEQ_VF, 0x6 }, // 6314
  { PseudoVMFEQ_VF16_MF4_MASK, VMFEQ_VF, 0x6 }, // 6315
  { PseudoVMFEQ_VF16_MF2, VMFEQ_VF, 0x7 }, // 6316
  { PseudoVMFEQ_VF16_MF2_MASK, VMFEQ_VF, 0x7 }, // 6317
  { PseudoVMFEQ_VF32_MF2, VMFEQ_VF, 0x7 }, // 6318
  { PseudoVMFEQ_VF32_MF2_MASK, VMFEQ_VF, 0x7 }, // 6319
  { PseudoVMFEQ_VV_M1, VMFEQ_VV, 0x0 }, // 6320
  { PseudoVMFEQ_VV_M1_MASK, VMFEQ_VV, 0x0 }, // 6321
  { PseudoVMFEQ_VV_M2, VMFEQ_VV, 0x1 }, // 6322
  { PseudoVMFEQ_VV_M2_MASK, VMFEQ_VV, 0x1 }, // 6323
  { PseudoVMFEQ_VV_M4, VMFEQ_VV, 0x2 }, // 6324
  { PseudoVMFEQ_VV_M4_MASK, VMFEQ_VV, 0x2 }, // 6325
  { PseudoVMFEQ_VV_M8, VMFEQ_VV, 0x3 }, // 6326
  { PseudoVMFEQ_VV_M8_MASK, VMFEQ_VV, 0x3 }, // 6327
  { PseudoVMFEQ_VV_MF4, VMFEQ_VV, 0x6 }, // 6328
  { PseudoVMFEQ_VV_MF4_MASK, VMFEQ_VV, 0x6 }, // 6329
  { PseudoVMFEQ_VV_MF2, VMFEQ_VV, 0x7 }, // 6330
  { PseudoVMFEQ_VV_MF2_MASK, VMFEQ_VV, 0x7 }, // 6331
  { PseudoVMFGE_VF16_M1, VMFGE_VF, 0x0 }, // 6332
  { PseudoVMFGE_VF16_M1_MASK, VMFGE_VF, 0x0 }, // 6333
  { PseudoVMFGE_VF32_M1, VMFGE_VF, 0x0 }, // 6334
  { PseudoVMFGE_VF32_M1_MASK, VMFGE_VF, 0x0 }, // 6335
  { PseudoVMFGE_VF64_M1, VMFGE_VF, 0x0 }, // 6336
  { PseudoVMFGE_VF64_M1_MASK, VMFGE_VF, 0x0 }, // 6337
  { PseudoVMFGE_VF16_M2, VMFGE_VF, 0x1 }, // 6338
  { PseudoVMFGE_VF16_M2_MASK, VMFGE_VF, 0x1 }, // 6339
  { PseudoVMFGE_VF32_M2, VMFGE_VF, 0x1 }, // 6340
  { PseudoVMFGE_VF32_M2_MASK, VMFGE_VF, 0x1 }, // 6341
  { PseudoVMFGE_VF64_M2, VMFGE_VF, 0x1 }, // 6342
  { PseudoVMFGE_VF64_M2_MASK, VMFGE_VF, 0x1 }, // 6343
  { PseudoVMFGE_VF16_M4, VMFGE_VF, 0x2 }, // 6344
  { PseudoVMFGE_VF16_M4_MASK, VMFGE_VF, 0x2 }, // 6345
  { PseudoVMFGE_VF32_M4, VMFGE_VF, 0x2 }, // 6346
  { PseudoVMFGE_VF32_M4_MASK, VMFGE_VF, 0x2 }, // 6347
  { PseudoVMFGE_VF64_M4, VMFGE_VF, 0x2 }, // 6348
  { PseudoVMFGE_VF64_M4_MASK, VMFGE_VF, 0x2 }, // 6349
  { PseudoVMFGE_VF16_M8, VMFGE_VF, 0x3 }, // 6350
  { PseudoVMFGE_VF16_M8_MASK, VMFGE_VF, 0x3 }, // 6351
  { PseudoVMFGE_VF32_M8, VMFGE_VF, 0x3 }, // 6352
  { PseudoVMFGE_VF32_M8_MASK, VMFGE_VF, 0x3 }, // 6353
  { PseudoVMFGE_VF64_M8, VMFGE_VF, 0x3 }, // 6354
  { PseudoVMFGE_VF64_M8_MASK, VMFGE_VF, 0x3 }, // 6355
  { PseudoVMFGE_VF16_MF4, VMFGE_VF, 0x6 }, // 6356
  { PseudoVMFGE_VF16_MF4_MASK, VMFGE_VF, 0x6 }, // 6357
  { PseudoVMFGE_VF16_MF2, VMFGE_VF, 0x7 }, // 6358
  { PseudoVMFGE_VF16_MF2_MASK, VMFGE_VF, 0x7 }, // 6359
  { PseudoVMFGE_VF32_MF2, VMFGE_VF, 0x7 }, // 6360
  { PseudoVMFGE_VF32_MF2_MASK, VMFGE_VF, 0x7 }, // 6361
  { PseudoVMFGT_VF16_M1, VMFGT_VF, 0x0 }, // 6362
  { PseudoVMFGT_VF16_M1_MASK, VMFGT_VF, 0x0 }, // 6363
  { PseudoVMFGT_VF32_M1, VMFGT_VF, 0x0 }, // 6364
  { PseudoVMFGT_VF32_M1_MASK, VMFGT_VF, 0x0 }, // 6365
  { PseudoVMFGT_VF64_M1, VMFGT_VF, 0x0 }, // 6366
  { PseudoVMFGT_VF64_M1_MASK, VMFGT_VF, 0x0 }, // 6367
  { PseudoVMFGT_VF16_M2, VMFGT_VF, 0x1 }, // 6368
  { PseudoVMFGT_VF16_M2_MASK, VMFGT_VF, 0x1 }, // 6369
  { PseudoVMFGT_VF32_M2, VMFGT_VF, 0x1 }, // 6370
  { PseudoVMFGT_VF32_M2_MASK, VMFGT_VF, 0x1 }, // 6371
  { PseudoVMFGT_VF64_M2, VMFGT_VF, 0x1 }, // 6372
  { PseudoVMFGT_VF64_M2_MASK, VMFGT_VF, 0x1 }, // 6373
  { PseudoVMFGT_VF16_M4, VMFGT_VF, 0x2 }, // 6374
  { PseudoVMFGT_VF16_M4_MASK, VMFGT_VF, 0x2 }, // 6375
  { PseudoVMFGT_VF32_M4, VMFGT_VF, 0x2 }, // 6376
  { PseudoVMFGT_VF32_M4_MASK, VMFGT_VF, 0x2 }, // 6377
  { PseudoVMFGT_VF64_M4, VMFGT_VF, 0x2 }, // 6378
  { PseudoVMFGT_VF64_M4_MASK, VMFGT_VF, 0x2 }, // 6379
  { PseudoVMFGT_VF16_M8, VMFGT_VF, 0x3 }, // 6380
  { PseudoVMFGT_VF16_M8_MASK, VMFGT_VF, 0x3 }, // 6381
  { PseudoVMFGT_VF32_M8, VMFGT_VF, 0x3 }, // 6382
  { PseudoVMFGT_VF32_M8_MASK, VMFGT_VF, 0x3 }, // 6383
  { PseudoVMFGT_VF64_M8, VMFGT_VF, 0x3 }, // 6384
  { PseudoVMFGT_VF64_M8_MASK, VMFGT_VF, 0x3 }, // 6385
  { PseudoVMFGT_VF16_MF4, VMFGT_VF, 0x6 }, // 6386
  { PseudoVMFGT_VF16_MF4_MASK, VMFGT_VF, 0x6 }, // 6387
  { PseudoVMFGT_VF16_MF2, VMFGT_VF, 0x7 }, // 6388
  { PseudoVMFGT_VF16_MF2_MASK, VMFGT_VF, 0x7 }, // 6389
  { PseudoVMFGT_VF32_MF2, VMFGT_VF, 0x7 }, // 6390
  { PseudoVMFGT_VF32_MF2_MASK, VMFGT_VF, 0x7 }, // 6391
  { PseudoVMFLE_VF16_M1, VMFLE_VF, 0x0 }, // 6392
  { PseudoVMFLE_VF16_M1_MASK, VMFLE_VF, 0x0 }, // 6393
  { PseudoVMFLE_VF32_M1, VMFLE_VF, 0x0 }, // 6394
  { PseudoVMFLE_VF32_M1_MASK, VMFLE_VF, 0x0 }, // 6395
  { PseudoVMFLE_VF64_M1, VMFLE_VF, 0x0 }, // 6396
  { PseudoVMFLE_VF64_M1_MASK, VMFLE_VF, 0x0 }, // 6397
  { PseudoVMFLE_VF16_M2, VMFLE_VF, 0x1 }, // 6398
  { PseudoVMFLE_VF16_M2_MASK, VMFLE_VF, 0x1 }, // 6399
  { PseudoVMFLE_VF32_M2, VMFLE_VF, 0x1 }, // 6400
  { PseudoVMFLE_VF32_M2_MASK, VMFLE_VF, 0x1 }, // 6401
  { PseudoVMFLE_VF64_M2, VMFLE_VF, 0x1 }, // 6402
  { PseudoVMFLE_VF64_M2_MASK, VMFLE_VF, 0x1 }, // 6403
  { PseudoVMFLE_VF16_M4, VMFLE_VF, 0x2 }, // 6404
  { PseudoVMFLE_VF16_M4_MASK, VMFLE_VF, 0x2 }, // 6405
  { PseudoVMFLE_VF32_M4, VMFLE_VF, 0x2 }, // 6406
  { PseudoVMFLE_VF32_M4_MASK, VMFLE_VF, 0x2 }, // 6407
  { PseudoVMFLE_VF64_M4, VMFLE_VF, 0x2 }, // 6408
  { PseudoVMFLE_VF64_M4_MASK, VMFLE_VF, 0x2 }, // 6409
  { PseudoVMFLE_VF16_M8, VMFLE_VF, 0x3 }, // 6410
  { PseudoVMFLE_VF16_M8_MASK, VMFLE_VF, 0x3 }, // 6411
  { PseudoVMFLE_VF32_M8, VMFLE_VF, 0x3 }, // 6412
  { PseudoVMFLE_VF32_M8_MASK, VMFLE_VF, 0x3 }, // 6413
  { PseudoVMFLE_VF64_M8, VMFLE_VF, 0x3 }, // 6414
  { PseudoVMFLE_VF64_M8_MASK, VMFLE_VF, 0x3 }, // 6415
  { PseudoVMFLE_VF16_MF4, VMFLE_VF, 0x6 }, // 6416
  { PseudoVMFLE_VF16_MF4_MASK, VMFLE_VF, 0x6 }, // 6417
  { PseudoVMFLE_VF16_MF2, VMFLE_VF, 0x7 }, // 6418
  { PseudoVMFLE_VF16_MF2_MASK, VMFLE_VF, 0x7 }, // 6419
  { PseudoVMFLE_VF32_MF2, VMFLE_VF, 0x7 }, // 6420
  { PseudoVMFLE_VF32_MF2_MASK, VMFLE_VF, 0x7 }, // 6421
  { PseudoVMFLE_VV_M1, VMFLE_VV, 0x0 }, // 6422
  { PseudoVMFLE_VV_M1_MASK, VMFLE_VV, 0x0 }, // 6423
  { PseudoVMFLE_VV_M2, VMFLE_VV, 0x1 }, // 6424
  { PseudoVMFLE_VV_M2_MASK, VMFLE_VV, 0x1 }, // 6425
  { PseudoVMFLE_VV_M4, VMFLE_VV, 0x2 }, // 6426
  { PseudoVMFLE_VV_M4_MASK, VMFLE_VV, 0x2 }, // 6427
  { PseudoVMFLE_VV_M8, VMFLE_VV, 0x3 }, // 6428
  { PseudoVMFLE_VV_M8_MASK, VMFLE_VV, 0x3 }, // 6429
  { PseudoVMFLE_VV_MF4, VMFLE_VV, 0x6 }, // 6430
  { PseudoVMFLE_VV_MF4_MASK, VMFLE_VV, 0x6 }, // 6431
  { PseudoVMFLE_VV_MF2, VMFLE_VV, 0x7 }, // 6432
  { PseudoVMFLE_VV_MF2_MASK, VMFLE_VV, 0x7 }, // 6433
  { PseudoVMFLT_VF16_M1, VMFLT_VF, 0x0 }, // 6434
  { PseudoVMFLT_VF16_M1_MASK, VMFLT_VF, 0x0 }, // 6435
  { PseudoVMFLT_VF32_M1, VMFLT_VF, 0x0 }, // 6436
  { PseudoVMFLT_VF32_M1_MASK, VMFLT_VF, 0x0 }, // 6437
  { PseudoVMFLT_VF64_M1, VMFLT_VF, 0x0 }, // 6438
  { PseudoVMFLT_VF64_M1_MASK, VMFLT_VF, 0x0 }, // 6439
  { PseudoVMFLT_VF16_M2, VMFLT_VF, 0x1 }, // 6440
  { PseudoVMFLT_VF16_M2_MASK, VMFLT_VF, 0x1 }, // 6441
  { PseudoVMFLT_VF32_M2, VMFLT_VF, 0x1 }, // 6442
  { PseudoVMFLT_VF32_M2_MASK, VMFLT_VF, 0x1 }, // 6443
  { PseudoVMFLT_VF64_M2, VMFLT_VF, 0x1 }, // 6444
  { PseudoVMFLT_VF64_M2_MASK, VMFLT_VF, 0x1 }, // 6445
  { PseudoVMFLT_VF16_M4, VMFLT_VF, 0x2 }, // 6446
  { PseudoVMFLT_VF16_M4_MASK, VMFLT_VF, 0x2 }, // 6447
  { PseudoVMFLT_VF32_M4, VMFLT_VF, 0x2 }, // 6448
  { PseudoVMFLT_VF32_M4_MASK, VMFLT_VF, 0x2 }, // 6449
  { PseudoVMFLT_VF64_M4, VMFLT_VF, 0x2 }, // 6450
  { PseudoVMFLT_VF64_M4_MASK, VMFLT_VF, 0x2 }, // 6451
  { PseudoVMFLT_VF16_M8, VMFLT_VF, 0x3 }, // 6452
  { PseudoVMFLT_VF16_M8_MASK, VMFLT_VF, 0x3 }, // 6453
  { PseudoVMFLT_VF32_M8, VMFLT_VF, 0x3 }, // 6454
  { PseudoVMFLT_VF32_M8_MASK, VMFLT_VF, 0x3 }, // 6455
  { PseudoVMFLT_VF64_M8, VMFLT_VF, 0x3 }, // 6456
  { PseudoVMFLT_VF64_M8_MASK, VMFLT_VF, 0x3 }, // 6457
  { PseudoVMFLT_VF16_MF4, VMFLT_VF, 0x6 }, // 6458
  { PseudoVMFLT_VF16_MF4_MASK, VMFLT_VF, 0x6 }, // 6459
  { PseudoVMFLT_VF16_MF2, VMFLT_VF, 0x7 }, // 6460
  { PseudoVMFLT_VF16_MF2_MASK, VMFLT_VF, 0x7 }, // 6461
  { PseudoVMFLT_VF32_MF2, VMFLT_VF, 0x7 }, // 6462
  { PseudoVMFLT_VF32_MF2_MASK, VMFLT_VF, 0x7 }, // 6463
  { PseudoVMFLT_VV_M1, VMFLT_VV, 0x0 }, // 6464
  { PseudoVMFLT_VV_M1_MASK, VMFLT_VV, 0x0 }, // 6465
  { PseudoVMFLT_VV_M2, VMFLT_VV, 0x1 }, // 6466
  { PseudoVMFLT_VV_M2_MASK, VMFLT_VV, 0x1 }, // 6467
  { PseudoVMFLT_VV_M4, VMFLT_VV, 0x2 }, // 6468
  { PseudoVMFLT_VV_M4_MASK, VMFLT_VV, 0x2 }, // 6469
  { PseudoVMFLT_VV_M8, VMFLT_VV, 0x3 }, // 6470
  { PseudoVMFLT_VV_M8_MASK, VMFLT_VV, 0x3 }, // 6471
  { PseudoVMFLT_VV_MF4, VMFLT_VV, 0x6 }, // 6472
  { PseudoVMFLT_VV_MF4_MASK, VMFLT_VV, 0x6 }, // 6473
  { PseudoVMFLT_VV_MF2, VMFLT_VV, 0x7 }, // 6474
  { PseudoVMFLT_VV_MF2_MASK, VMFLT_VV, 0x7 }, // 6475
  { PseudoVMFNE_VF16_M1, VMFNE_VF, 0x0 }, // 6476
  { PseudoVMFNE_VF16_M1_MASK, VMFNE_VF, 0x0 }, // 6477
  { PseudoVMFNE_VF32_M1, VMFNE_VF, 0x0 }, // 6478
  { PseudoVMFNE_VF32_M1_MASK, VMFNE_VF, 0x0 }, // 6479
  { PseudoVMFNE_VF64_M1, VMFNE_VF, 0x0 }, // 6480
  { PseudoVMFNE_VF64_M1_MASK, VMFNE_VF, 0x0 }, // 6481
  { PseudoVMFNE_VF16_M2, VMFNE_VF, 0x1 }, // 6482
  { PseudoVMFNE_VF16_M2_MASK, VMFNE_VF, 0x1 }, // 6483
  { PseudoVMFNE_VF32_M2, VMFNE_VF, 0x1 }, // 6484
  { PseudoVMFNE_VF32_M2_MASK, VMFNE_VF, 0x1 }, // 6485
  { PseudoVMFNE_VF64_M2, VMFNE_VF, 0x1 }, // 6486
  { PseudoVMFNE_VF64_M2_MASK, VMFNE_VF, 0x1 }, // 6487
  { PseudoVMFNE_VF16_M4, VMFNE_VF, 0x2 }, // 6488
  { PseudoVMFNE_VF16_M4_MASK, VMFNE_VF, 0x2 }, // 6489
  { PseudoVMFNE_VF32_M4, VMFNE_VF, 0x2 }, // 6490
  { PseudoVMFNE_VF32_M4_MASK, VMFNE_VF, 0x2 }, // 6491
  { PseudoVMFNE_VF64_M4, VMFNE_VF, 0x2 }, // 6492
  { PseudoVMFNE_VF64_M4_MASK, VMFNE_VF, 0x2 }, // 6493
  { PseudoVMFNE_VF16_M8, VMFNE_VF, 0x3 }, // 6494
  { PseudoVMFNE_VF16_M8_MASK, VMFNE_VF, 0x3 }, // 6495
  { PseudoVMFNE_VF32_M8, VMFNE_VF, 0x3 }, // 6496
  { PseudoVMFNE_VF32_M8_MASK, VMFNE_VF, 0x3 }, // 6497
  { PseudoVMFNE_VF64_M8, VMFNE_VF, 0x3 }, // 6498
  { PseudoVMFNE_VF64_M8_MASK, VMFNE_VF, 0x3 }, // 6499
  { PseudoVMFNE_VF16_MF4, VMFNE_VF, 0x6 }, // 6500
  { PseudoVMFNE_VF16_MF4_MASK, VMFNE_VF, 0x6 }, // 6501
  { PseudoVMFNE_VF16_MF2, VMFNE_VF, 0x7 }, // 6502
  { PseudoVMFNE_VF16_MF2_MASK, VMFNE_VF, 0x7 }, // 6503
  { PseudoVMFNE_VF32_MF2, VMFNE_VF, 0x7 }, // 6504
  { PseudoVMFNE_VF32_MF2_MASK, VMFNE_VF, 0x7 }, // 6505
  { PseudoVMFNE_VV_M1, VMFNE_VV, 0x0 }, // 6506
  { PseudoVMFNE_VV_M1_MASK, VMFNE_VV, 0x0 }, // 6507
  { PseudoVMFNE_VV_M2, VMFNE_VV, 0x1 }, // 6508
  { PseudoVMFNE_VV_M2_MASK, VMFNE_VV, 0x1 }, // 6509
  { PseudoVMFNE_VV_M4, VMFNE_VV, 0x2 }, // 6510
  { PseudoVMFNE_VV_M4_MASK, VMFNE_VV, 0x2 }, // 6511
  { PseudoVMFNE_VV_M8, VMFNE_VV, 0x3 }, // 6512
  { PseudoVMFNE_VV_M8_MASK, VMFNE_VV, 0x3 }, // 6513
  { PseudoVMFNE_VV_MF4, VMFNE_VV, 0x6 }, // 6514
  { PseudoVMFNE_VV_MF4_MASK, VMFNE_VV, 0x6 }, // 6515
  { PseudoVMFNE_VV_MF2, VMFNE_VV, 0x7 }, // 6516
  { PseudoVMFNE_VV_MF2_MASK, VMFNE_VV, 0x7 }, // 6517
  { PseudoVMINU_VV_M1, VMINU_VV, 0x0 }, // 6518
  { PseudoVMINU_VV_M1_MASK, VMINU_VV, 0x0 }, // 6519
  { PseudoVMINU_VV_M1_TU, VMINU_VV, 0x0 }, // 6520
  { PseudoVMINU_VV_M2, VMINU_VV, 0x1 }, // 6521
  { PseudoVMINU_VV_M2_MASK, VMINU_VV, 0x1 }, // 6522
  { PseudoVMINU_VV_M2_TU, VMINU_VV, 0x1 }, // 6523
  { PseudoVMINU_VV_M4, VMINU_VV, 0x2 }, // 6524
  { PseudoVMINU_VV_M4_MASK, VMINU_VV, 0x2 }, // 6525
  { PseudoVMINU_VV_M4_TU, VMINU_VV, 0x2 }, // 6526
  { PseudoVMINU_VV_M8, VMINU_VV, 0x3 }, // 6527
  { PseudoVMINU_VV_M8_MASK, VMINU_VV, 0x3 }, // 6528
  { PseudoVMINU_VV_M8_TU, VMINU_VV, 0x3 }, // 6529
  { PseudoVMINU_VV_MF8, VMINU_VV, 0x5 }, // 6530
  { PseudoVMINU_VV_MF8_MASK, VMINU_VV, 0x5 }, // 6531
  { PseudoVMINU_VV_MF8_TU, VMINU_VV, 0x5 }, // 6532
  { PseudoVMINU_VV_MF4, VMINU_VV, 0x6 }, // 6533
  { PseudoVMINU_VV_MF4_MASK, VMINU_VV, 0x6 }, // 6534
  { PseudoVMINU_VV_MF4_TU, VMINU_VV, 0x6 }, // 6535
  { PseudoVMINU_VV_MF2, VMINU_VV, 0x7 }, // 6536
  { PseudoVMINU_VV_MF2_MASK, VMINU_VV, 0x7 }, // 6537
  { PseudoVMINU_VV_MF2_TU, VMINU_VV, 0x7 }, // 6538
  { PseudoVMINU_VX_M1, VMINU_VX, 0x0 }, // 6539
  { PseudoVMINU_VX_M1_MASK, VMINU_VX, 0x0 }, // 6540
  { PseudoVMINU_VX_M1_TU, VMINU_VX, 0x0 }, // 6541
  { PseudoVMINU_VX_M2, VMINU_VX, 0x1 }, // 6542
  { PseudoVMINU_VX_M2_MASK, VMINU_VX, 0x1 }, // 6543
  { PseudoVMINU_VX_M2_TU, VMINU_VX, 0x1 }, // 6544
  { PseudoVMINU_VX_M4, VMINU_VX, 0x2 }, // 6545
  { PseudoVMINU_VX_M4_MASK, VMINU_VX, 0x2 }, // 6546
  { PseudoVMINU_VX_M4_TU, VMINU_VX, 0x2 }, // 6547
  { PseudoVMINU_VX_M8, VMINU_VX, 0x3 }, // 6548
  { PseudoVMINU_VX_M8_MASK, VMINU_VX, 0x3 }, // 6549
  { PseudoVMINU_VX_M8_TU, VMINU_VX, 0x3 }, // 6550
  { PseudoVMINU_VX_MF8, VMINU_VX, 0x5 }, // 6551
  { PseudoVMINU_VX_MF8_MASK, VMINU_VX, 0x5 }, // 6552
  { PseudoVMINU_VX_MF8_TU, VMINU_VX, 0x5 }, // 6553
  { PseudoVMINU_VX_MF4, VMINU_VX, 0x6 }, // 6554
  { PseudoVMINU_VX_MF4_MASK, VMINU_VX, 0x6 }, // 6555
  { PseudoVMINU_VX_MF4_TU, VMINU_VX, 0x6 }, // 6556
  { PseudoVMINU_VX_MF2, VMINU_VX, 0x7 }, // 6557
  { PseudoVMINU_VX_MF2_MASK, VMINU_VX, 0x7 }, // 6558
  { PseudoVMINU_VX_MF2_TU, VMINU_VX, 0x7 }, // 6559
  { PseudoVMIN_VV_M1, VMIN_VV, 0x0 }, // 6560
  { PseudoVMIN_VV_M1_MASK, VMIN_VV, 0x0 }, // 6561
  { PseudoVMIN_VV_M1_TU, VMIN_VV, 0x0 }, // 6562
  { PseudoVMIN_VV_M2, VMIN_VV, 0x1 }, // 6563
  { PseudoVMIN_VV_M2_MASK, VMIN_VV, 0x1 }, // 6564
  { PseudoVMIN_VV_M2_TU, VMIN_VV, 0x1 }, // 6565
  { PseudoVMIN_VV_M4, VMIN_VV, 0x2 }, // 6566
  { PseudoVMIN_VV_M4_MASK, VMIN_VV, 0x2 }, // 6567
  { PseudoVMIN_VV_M4_TU, VMIN_VV, 0x2 }, // 6568
  { PseudoVMIN_VV_M8, VMIN_VV, 0x3 }, // 6569
  { PseudoVMIN_VV_M8_MASK, VMIN_VV, 0x3 }, // 6570
  { PseudoVMIN_VV_M8_TU, VMIN_VV, 0x3 }, // 6571
  { PseudoVMIN_VV_MF8, VMIN_VV, 0x5 }, // 6572
  { PseudoVMIN_VV_MF8_MASK, VMIN_VV, 0x5 }, // 6573
  { PseudoVMIN_VV_MF8_TU, VMIN_VV, 0x5 }, // 6574
  { PseudoVMIN_VV_MF4, VMIN_VV, 0x6 }, // 6575
  { PseudoVMIN_VV_MF4_MASK, VMIN_VV, 0x6 }, // 6576
  { PseudoVMIN_VV_MF4_TU, VMIN_VV, 0x6 }, // 6577
  { PseudoVMIN_VV_MF2, VMIN_VV, 0x7 }, // 6578
  { PseudoVMIN_VV_MF2_MASK, VMIN_VV, 0x7 }, // 6579
  { PseudoVMIN_VV_MF2_TU, VMIN_VV, 0x7 }, // 6580
  { PseudoVMIN_VX_M1, VMIN_VX, 0x0 }, // 6581
  { PseudoVMIN_VX_M1_MASK, VMIN_VX, 0x0 }, // 6582
  { PseudoVMIN_VX_M1_TU, VMIN_VX, 0x0 }, // 6583
  { PseudoVMIN_VX_M2, VMIN_VX, 0x1 }, // 6584
  { PseudoVMIN_VX_M2_MASK, VMIN_VX, 0x1 }, // 6585
  { PseudoVMIN_VX_M2_TU, VMIN_VX, 0x1 }, // 6586
  { PseudoVMIN_VX_M4, VMIN_VX, 0x2 }, // 6587
  { PseudoVMIN_VX_M4_MASK, VMIN_VX, 0x2 }, // 6588
  { PseudoVMIN_VX_M4_TU, VMIN_VX, 0x2 }, // 6589
  { PseudoVMIN_VX_M8, VMIN_VX, 0x3 }, // 6590
  { PseudoVMIN_VX_M8_MASK, VMIN_VX, 0x3 }, // 6591
  { PseudoVMIN_VX_M8_TU, VMIN_VX, 0x3 }, // 6592
  { PseudoVMIN_VX_MF8, VMIN_VX, 0x5 }, // 6593
  { PseudoVMIN_VX_MF8_MASK, VMIN_VX, 0x5 }, // 6594
  { PseudoVMIN_VX_MF8_TU, VMIN_VX, 0x5 }, // 6595
  { PseudoVMIN_VX_MF4, VMIN_VX, 0x6 }, // 6596
  { PseudoVMIN_VX_MF4_MASK, VMIN_VX, 0x6 }, // 6597
  { PseudoVMIN_VX_MF4_TU, VMIN_VX, 0x6 }, // 6598
  { PseudoVMIN_VX_MF2, VMIN_VX, 0x7 }, // 6599
  { PseudoVMIN_VX_MF2_MASK, VMIN_VX, 0x7 }, // 6600
  { PseudoVMIN_VX_MF2_TU, VMIN_VX, 0x7 }, // 6601
  { PseudoVMNAND_MM_M1, VMNAND_MM, 0x0 }, // 6602
  { PseudoVMNAND_MM_M2, VMNAND_MM, 0x1 }, // 6603
  { PseudoVMNAND_MM_M4, VMNAND_MM, 0x2 }, // 6604
  { PseudoVMNAND_MM_M8, VMNAND_MM, 0x3 }, // 6605
  { PseudoVMNAND_MM_MF8, VMNAND_MM, 0x5 }, // 6606
  { PseudoVMNAND_MM_MF4, VMNAND_MM, 0x6 }, // 6607
  { PseudoVMNAND_MM_MF2, VMNAND_MM, 0x7 }, // 6608
  { PseudoVMNOR_MM_M1, VMNOR_MM, 0x0 }, // 6609
  { PseudoVMNOR_MM_M2, VMNOR_MM, 0x1 }, // 6610
  { PseudoVMNOR_MM_M4, VMNOR_MM, 0x2 }, // 6611
  { PseudoVMNOR_MM_M8, VMNOR_MM, 0x3 }, // 6612
  { PseudoVMNOR_MM_MF8, VMNOR_MM, 0x5 }, // 6613
  { PseudoVMNOR_MM_MF4, VMNOR_MM, 0x6 }, // 6614
  { PseudoVMNOR_MM_MF2, VMNOR_MM, 0x7 }, // 6615
  { PseudoVMORN_MM_M1, VMORN_MM, 0x0 }, // 6616
  { PseudoVMORN_MM_M2, VMORN_MM, 0x1 }, // 6617
  { PseudoVMORN_MM_M4, VMORN_MM, 0x2 }, // 6618
  { PseudoVMORN_MM_M8, VMORN_MM, 0x3 }, // 6619
  { PseudoVMORN_MM_MF8, VMORN_MM, 0x5 }, // 6620
  { PseudoVMORN_MM_MF4, VMORN_MM, 0x6 }, // 6621
  { PseudoVMORN_MM_MF2, VMORN_MM, 0x7 }, // 6622
  { PseudoVMOR_MM_M1, VMOR_MM, 0x0 }, // 6623
  { PseudoVMOR_MM_M2, VMOR_MM, 0x1 }, // 6624
  { PseudoVMOR_MM_M4, VMOR_MM, 0x2 }, // 6625
  { PseudoVMOR_MM_M8, VMOR_MM, 0x3 }, // 6626
  { PseudoVMOR_MM_MF8, VMOR_MM, 0x5 }, // 6627
  { PseudoVMOR_MM_MF4, VMOR_MM, 0x6 }, // 6628
  { PseudoVMOR_MM_MF2, VMOR_MM, 0x7 }, // 6629
  { PseudoVMSBC_VV_M1, VMSBC_VV, 0x0 }, // 6630
  { PseudoVMSBC_VV_M2, VMSBC_VV, 0x1 }, // 6631
  { PseudoVMSBC_VV_M4, VMSBC_VV, 0x2 }, // 6632
  { PseudoVMSBC_VV_M8, VMSBC_VV, 0x3 }, // 6633
  { PseudoVMSBC_VV_MF8, VMSBC_VV, 0x5 }, // 6634
  { PseudoVMSBC_VV_MF4, VMSBC_VV, 0x6 }, // 6635
  { PseudoVMSBC_VV_MF2, VMSBC_VV, 0x7 }, // 6636
  { PseudoVMSBC_VVM_M1, VMSBC_VVM, 0x0 }, // 6637
  { PseudoVMSBC_VVM_M2, VMSBC_VVM, 0x1 }, // 6638
  { PseudoVMSBC_VVM_M4, VMSBC_VVM, 0x2 }, // 6639
  { PseudoVMSBC_VVM_M8, VMSBC_VVM, 0x3 }, // 6640
  { PseudoVMSBC_VVM_MF8, VMSBC_VVM, 0x5 }, // 6641
  { PseudoVMSBC_VVM_MF4, VMSBC_VVM, 0x6 }, // 6642
  { PseudoVMSBC_VVM_MF2, VMSBC_VVM, 0x7 }, // 6643
  { PseudoVMSBC_VX_M1, VMSBC_VX, 0x0 }, // 6644
  { PseudoVMSBC_VX_M2, VMSBC_VX, 0x1 }, // 6645
  { PseudoVMSBC_VX_M4, VMSBC_VX, 0x2 }, // 6646
  { PseudoVMSBC_VX_M8, VMSBC_VX, 0x3 }, // 6647
  { PseudoVMSBC_VX_MF8, VMSBC_VX, 0x5 }, // 6648
  { PseudoVMSBC_VX_MF4, VMSBC_VX, 0x6 }, // 6649
  { PseudoVMSBC_VX_MF2, VMSBC_VX, 0x7 }, // 6650
  { PseudoVMSBC_VXM_M1, VMSBC_VXM, 0x0 }, // 6651
  { PseudoVMSBC_VXM_M2, VMSBC_VXM, 0x1 }, // 6652
  { PseudoVMSBC_VXM_M4, VMSBC_VXM, 0x2 }, // 6653
  { PseudoVMSBC_VXM_M8, VMSBC_VXM, 0x3 }, // 6654
  { PseudoVMSBC_VXM_MF8, VMSBC_VXM, 0x5 }, // 6655
  { PseudoVMSBC_VXM_MF4, VMSBC_VXM, 0x6 }, // 6656
  { PseudoVMSBC_VXM_MF2, VMSBC_VXM, 0x7 }, // 6657
  { PseudoVMSBF_M_B8, VMSBF_M, 0x0 }, // 6658
  { PseudoVMSBF_M_B8_MASK, VMSBF_M, 0x0 }, // 6659
  { PseudoVMSBF_M_B16, VMSBF_M, 0x1 }, // 6660
  { PseudoVMSBF_M_B16_MASK, VMSBF_M, 0x1 }, // 6661
  { PseudoVMSBF_M_B32, VMSBF_M, 0x2 }, // 6662
  { PseudoVMSBF_M_B32_MASK, VMSBF_M, 0x2 }, // 6663
  { PseudoVMSBF_M_B64, VMSBF_M, 0x3 }, // 6664
  { PseudoVMSBF_M_B64_MASK, VMSBF_M, 0x3 }, // 6665
  { PseudoVMSBF_M_B1, VMSBF_M, 0x5 }, // 6666
  { PseudoVMSBF_M_B1_MASK, VMSBF_M, 0x5 }, // 6667
  { PseudoVMSBF_M_B2, VMSBF_M, 0x6 }, // 6668
  { PseudoVMSBF_M_B2_MASK, VMSBF_M, 0x6 }, // 6669
  { PseudoVMSBF_M_B4, VMSBF_M, 0x7 }, // 6670
  { PseudoVMSBF_M_B4_MASK, VMSBF_M, 0x7 }, // 6671
  { PseudoVMSEQ_VI_M1, VMSEQ_VI, 0x0 }, // 6672
  { PseudoVMSEQ_VI_M1_MASK, VMSEQ_VI, 0x0 }, // 6673
  { PseudoVMSEQ_VI_M2, VMSEQ_VI, 0x1 }, // 6674
  { PseudoVMSEQ_VI_M2_MASK, VMSEQ_VI, 0x1 }, // 6675
  { PseudoVMSEQ_VI_M4, VMSEQ_VI, 0x2 }, // 6676
  { PseudoVMSEQ_VI_M4_MASK, VMSEQ_VI, 0x2 }, // 6677
  { PseudoVMSEQ_VI_M8, VMSEQ_VI, 0x3 }, // 6678
  { PseudoVMSEQ_VI_M8_MASK, VMSEQ_VI, 0x3 }, // 6679
  { PseudoVMSEQ_VI_MF8, VMSEQ_VI, 0x5 }, // 6680
  { PseudoVMSEQ_VI_MF8_MASK, VMSEQ_VI, 0x5 }, // 6681
  { PseudoVMSEQ_VI_MF4, VMSEQ_VI, 0x6 }, // 6682
  { PseudoVMSEQ_VI_MF4_MASK, VMSEQ_VI, 0x6 }, // 6683
  { PseudoVMSEQ_VI_MF2, VMSEQ_VI, 0x7 }, // 6684
  { PseudoVMSEQ_VI_MF2_MASK, VMSEQ_VI, 0x7 }, // 6685
  { PseudoVMSEQ_VV_M1, VMSEQ_VV, 0x0 }, // 6686
  { PseudoVMSEQ_VV_M1_MASK, VMSEQ_VV, 0x0 }, // 6687
  { PseudoVMSEQ_VV_M2, VMSEQ_VV, 0x1 }, // 6688
  { PseudoVMSEQ_VV_M2_MASK, VMSEQ_VV, 0x1 }, // 6689
  { PseudoVMSEQ_VV_M4, VMSEQ_VV, 0x2 }, // 6690
  { PseudoVMSEQ_VV_M4_MASK, VMSEQ_VV, 0x2 }, // 6691
  { PseudoVMSEQ_VV_M8, VMSEQ_VV, 0x3 }, // 6692
  { PseudoVMSEQ_VV_M8_MASK, VMSEQ_VV, 0x3 }, // 6693
  { PseudoVMSEQ_VV_MF8, VMSEQ_VV, 0x5 }, // 6694
  { PseudoVMSEQ_VV_MF8_MASK, VMSEQ_VV, 0x5 }, // 6695
  { PseudoVMSEQ_VV_MF4, VMSEQ_VV, 0x6 }, // 6696
  { PseudoVMSEQ_VV_MF4_MASK, VMSEQ_VV, 0x6 }, // 6697
  { PseudoVMSEQ_VV_MF2, VMSEQ_VV, 0x7 }, // 6698
  { PseudoVMSEQ_VV_MF2_MASK, VMSEQ_VV, 0x7 }, // 6699
  { PseudoVMSEQ_VX_M1, VMSEQ_VX, 0x0 }, // 6700
  { PseudoVMSEQ_VX_M1_MASK, VMSEQ_VX, 0x0 }, // 6701
  { PseudoVMSEQ_VX_M2, VMSEQ_VX, 0x1 }, // 6702
  { PseudoVMSEQ_VX_M2_MASK, VMSEQ_VX, 0x1 }, // 6703
  { PseudoVMSEQ_VX_M4, VMSEQ_VX, 0x2 }, // 6704
  { PseudoVMSEQ_VX_M4_MASK, VMSEQ_VX, 0x2 }, // 6705
  { PseudoVMSEQ_VX_M8, VMSEQ_VX, 0x3 }, // 6706
  { PseudoVMSEQ_VX_M8_MASK, VMSEQ_VX, 0x3 }, // 6707
  { PseudoVMSEQ_VX_MF8, VMSEQ_VX, 0x5 }, // 6708
  { PseudoVMSEQ_VX_MF8_MASK, VMSEQ_VX, 0x5 }, // 6709
  { PseudoVMSEQ_VX_MF4, VMSEQ_VX, 0x6 }, // 6710
  { PseudoVMSEQ_VX_MF4_MASK, VMSEQ_VX, 0x6 }, // 6711
  { PseudoVMSEQ_VX_MF2, VMSEQ_VX, 0x7 }, // 6712
  { PseudoVMSEQ_VX_MF2_MASK, VMSEQ_VX, 0x7 }, // 6713
  { PseudoVMSGTU_VI_M1, VMSGTU_VI, 0x0 }, // 6714
  { PseudoVMSGTU_VI_M1_MASK, VMSGTU_VI, 0x0 }, // 6715
  { PseudoVMSGTU_VI_M2, VMSGTU_VI, 0x1 }, // 6716
  { PseudoVMSGTU_VI_M2_MASK, VMSGTU_VI, 0x1 }, // 6717
  { PseudoVMSGTU_VI_M4, VMSGTU_VI, 0x2 }, // 6718
  { PseudoVMSGTU_VI_M4_MASK, VMSGTU_VI, 0x2 }, // 6719
  { PseudoVMSGTU_VI_M8, VMSGTU_VI, 0x3 }, // 6720
  { PseudoVMSGTU_VI_M8_MASK, VMSGTU_VI, 0x3 }, // 6721
  { PseudoVMSGTU_VI_MF8, VMSGTU_VI, 0x5 }, // 6722
  { PseudoVMSGTU_VI_MF8_MASK, VMSGTU_VI, 0x5 }, // 6723
  { PseudoVMSGTU_VI_MF4, VMSGTU_VI, 0x6 }, // 6724
  { PseudoVMSGTU_VI_MF4_MASK, VMSGTU_VI, 0x6 }, // 6725
  { PseudoVMSGTU_VI_MF2, VMSGTU_VI, 0x7 }, // 6726
  { PseudoVMSGTU_VI_MF2_MASK, VMSGTU_VI, 0x7 }, // 6727
  { PseudoVMSGTU_VX_M1, VMSGTU_VX, 0x0 }, // 6728
  { PseudoVMSGTU_VX_M1_MASK, VMSGTU_VX, 0x0 }, // 6729
  { PseudoVMSGTU_VX_M2, VMSGTU_VX, 0x1 }, // 6730
  { PseudoVMSGTU_VX_M2_MASK, VMSGTU_VX, 0x1 }, // 6731
  { PseudoVMSGTU_VX_M4, VMSGTU_VX, 0x2 }, // 6732
  { PseudoVMSGTU_VX_M4_MASK, VMSGTU_VX, 0x2 }, // 6733
  { PseudoVMSGTU_VX_M8, VMSGTU_VX, 0x3 }, // 6734
  { PseudoVMSGTU_VX_M8_MASK, VMSGTU_VX, 0x3 }, // 6735
  { PseudoVMSGTU_VX_MF8, VMSGTU_VX, 0x5 }, // 6736
  { PseudoVMSGTU_VX_MF8_MASK, VMSGTU_VX, 0x5 }, // 6737
  { PseudoVMSGTU_VX_MF4, VMSGTU_VX, 0x6 }, // 6738
  { PseudoVMSGTU_VX_MF4_MASK, VMSGTU_VX, 0x6 }, // 6739
  { PseudoVMSGTU_VX_MF2, VMSGTU_VX, 0x7 }, // 6740
  { PseudoVMSGTU_VX_MF2_MASK, VMSGTU_VX, 0x7 }, // 6741
  { PseudoVMSGT_VI_M1, VMSGT_VI, 0x0 }, // 6742
  { PseudoVMSGT_VI_M1_MASK, VMSGT_VI, 0x0 }, // 6743
  { PseudoVMSGT_VI_M2, VMSGT_VI, 0x1 }, // 6744
  { PseudoVMSGT_VI_M2_MASK, VMSGT_VI, 0x1 }, // 6745
  { PseudoVMSGT_VI_M4, VMSGT_VI, 0x2 }, // 6746
  { PseudoVMSGT_VI_M4_MASK, VMSGT_VI, 0x2 }, // 6747
  { PseudoVMSGT_VI_M8, VMSGT_VI, 0x3 }, // 6748
  { PseudoVMSGT_VI_M8_MASK, VMSGT_VI, 0x3 }, // 6749
  { PseudoVMSGT_VI_MF8, VMSGT_VI, 0x5 }, // 6750
  { PseudoVMSGT_VI_MF8_MASK, VMSGT_VI, 0x5 }, // 6751
  { PseudoVMSGT_VI_MF4, VMSGT_VI, 0x6 }, // 6752
  { PseudoVMSGT_VI_MF4_MASK, VMSGT_VI, 0x6 }, // 6753
  { PseudoVMSGT_VI_MF2, VMSGT_VI, 0x7 }, // 6754
  { PseudoVMSGT_VI_MF2_MASK, VMSGT_VI, 0x7 }, // 6755
  { PseudoVMSGT_VX_M1, VMSGT_VX, 0x0 }, // 6756
  { PseudoVMSGT_VX_M1_MASK, VMSGT_VX, 0x0 }, // 6757
  { PseudoVMSGT_VX_M2, VMSGT_VX, 0x1 }, // 6758
  { PseudoVMSGT_VX_M2_MASK, VMSGT_VX, 0x1 }, // 6759
  { PseudoVMSGT_VX_M4, VMSGT_VX, 0x2 }, // 6760
  { PseudoVMSGT_VX_M4_MASK, VMSGT_VX, 0x2 }, // 6761
  { PseudoVMSGT_VX_M8, VMSGT_VX, 0x3 }, // 6762
  { PseudoVMSGT_VX_M8_MASK, VMSGT_VX, 0x3 }, // 6763
  { PseudoVMSGT_VX_MF8, VMSGT_VX, 0x5 }, // 6764
  { PseudoVMSGT_VX_MF8_MASK, VMSGT_VX, 0x5 }, // 6765
  { PseudoVMSGT_VX_MF4, VMSGT_VX, 0x6 }, // 6766
  { PseudoVMSGT_VX_MF4_MASK, VMSGT_VX, 0x6 }, // 6767
  { PseudoVMSGT_VX_MF2, VMSGT_VX, 0x7 }, // 6768
  { PseudoVMSGT_VX_MF2_MASK, VMSGT_VX, 0x7 }, // 6769
  { PseudoVMSIF_M_B8, VMSIF_M, 0x0 }, // 6770
  { PseudoVMSIF_M_B8_MASK, VMSIF_M, 0x0 }, // 6771
  { PseudoVMSIF_M_B16, VMSIF_M, 0x1 }, // 6772
  { PseudoVMSIF_M_B16_MASK, VMSIF_M, 0x1 }, // 6773
  { PseudoVMSIF_M_B32, VMSIF_M, 0x2 }, // 6774
  { PseudoVMSIF_M_B32_MASK, VMSIF_M, 0x2 }, // 6775
  { PseudoVMSIF_M_B64, VMSIF_M, 0x3 }, // 6776
  { PseudoVMSIF_M_B64_MASK, VMSIF_M, 0x3 }, // 6777
  { PseudoVMSIF_M_B1, VMSIF_M, 0x5 }, // 6778
  { PseudoVMSIF_M_B1_MASK, VMSIF_M, 0x5 }, // 6779
  { PseudoVMSIF_M_B2, VMSIF_M, 0x6 }, // 6780
  { PseudoVMSIF_M_B2_MASK, VMSIF_M, 0x6 }, // 6781
  { PseudoVMSIF_M_B4, VMSIF_M, 0x7 }, // 6782
  { PseudoVMSIF_M_B4_MASK, VMSIF_M, 0x7 }, // 6783
  { PseudoVMSLEU_VI_M1, VMSLEU_VI, 0x0 }, // 6784
  { PseudoVMSLEU_VI_M1_MASK, VMSLEU_VI, 0x0 }, // 6785
  { PseudoVMSLEU_VI_M2, VMSLEU_VI, 0x1 }, // 6786
  { PseudoVMSLEU_VI_M2_MASK, VMSLEU_VI, 0x1 }, // 6787
  { PseudoVMSLEU_VI_M4, VMSLEU_VI, 0x2 }, // 6788
  { PseudoVMSLEU_VI_M4_MASK, VMSLEU_VI, 0x2 }, // 6789
  { PseudoVMSLEU_VI_M8, VMSLEU_VI, 0x3 }, // 6790
  { PseudoVMSLEU_VI_M8_MASK, VMSLEU_VI, 0x3 }, // 6791
  { PseudoVMSLEU_VI_MF8, VMSLEU_VI, 0x5 }, // 6792
  { PseudoVMSLEU_VI_MF8_MASK, VMSLEU_VI, 0x5 }, // 6793
  { PseudoVMSLEU_VI_MF4, VMSLEU_VI, 0x6 }, // 6794
  { PseudoVMSLEU_VI_MF4_MASK, VMSLEU_VI, 0x6 }, // 6795
  { PseudoVMSLEU_VI_MF2, VMSLEU_VI, 0x7 }, // 6796
  { PseudoVMSLEU_VI_MF2_MASK, VMSLEU_VI, 0x7 }, // 6797
  { PseudoVMSLEU_VV_M1, VMSLEU_VV, 0x0 }, // 6798
  { PseudoVMSLEU_VV_M1_MASK, VMSLEU_VV, 0x0 }, // 6799
  { PseudoVMSLEU_VV_M2, VMSLEU_VV, 0x1 }, // 6800
  { PseudoVMSLEU_VV_M2_MASK, VMSLEU_VV, 0x1 }, // 6801
  { PseudoVMSLEU_VV_M4, VMSLEU_VV, 0x2 }, // 6802
  { PseudoVMSLEU_VV_M4_MASK, VMSLEU_VV, 0x2 }, // 6803
  { PseudoVMSLEU_VV_M8, VMSLEU_VV, 0x3 }, // 6804
  { PseudoVMSLEU_VV_M8_MASK, VMSLEU_VV, 0x3 }, // 6805
  { PseudoVMSLEU_VV_MF8, VMSLEU_VV, 0x5 }, // 6806
  { PseudoVMSLEU_VV_MF8_MASK, VMSLEU_VV, 0x5 }, // 6807
  { PseudoVMSLEU_VV_MF4, VMSLEU_VV, 0x6 }, // 6808
  { PseudoVMSLEU_VV_MF4_MASK, VMSLEU_VV, 0x6 }, // 6809
  { PseudoVMSLEU_VV_MF2, VMSLEU_VV, 0x7 }, // 6810
  { PseudoVMSLEU_VV_MF2_MASK, VMSLEU_VV, 0x7 }, // 6811
  { PseudoVMSLEU_VX_M1, VMSLEU_VX, 0x0 }, // 6812
  { PseudoVMSLEU_VX_M1_MASK, VMSLEU_VX, 0x0 }, // 6813
  { PseudoVMSLEU_VX_M2, VMSLEU_VX, 0x1 }, // 6814
  { PseudoVMSLEU_VX_M2_MASK, VMSLEU_VX, 0x1 }, // 6815
  { PseudoVMSLEU_VX_M4, VMSLEU_VX, 0x2 }, // 6816
  { PseudoVMSLEU_VX_M4_MASK, VMSLEU_VX, 0x2 }, // 6817
  { PseudoVMSLEU_VX_M8, VMSLEU_VX, 0x3 }, // 6818
  { PseudoVMSLEU_VX_M8_MASK, VMSLEU_VX, 0x3 }, // 6819
  { PseudoVMSLEU_VX_MF8, VMSLEU_VX, 0x5 }, // 6820
  { PseudoVMSLEU_VX_MF8_MASK, VMSLEU_VX, 0x5 }, // 6821
  { PseudoVMSLEU_VX_MF4, VMSLEU_VX, 0x6 }, // 6822
  { PseudoVMSLEU_VX_MF4_MASK, VMSLEU_VX, 0x6 }, // 6823
  { PseudoVMSLEU_VX_MF2, VMSLEU_VX, 0x7 }, // 6824
  { PseudoVMSLEU_VX_MF2_MASK, VMSLEU_VX, 0x7 }, // 6825
  { PseudoVMSLE_VI_M1, VMSLE_VI, 0x0 }, // 6826
  { PseudoVMSLE_VI_M1_MASK, VMSLE_VI, 0x0 }, // 6827
  { PseudoVMSLE_VI_M2, VMSLE_VI, 0x1 }, // 6828
  { PseudoVMSLE_VI_M2_MASK, VMSLE_VI, 0x1 }, // 6829
  { PseudoVMSLE_VI_M4, VMSLE_VI, 0x2 }, // 6830
  { PseudoVMSLE_VI_M4_MASK, VMSLE_VI, 0x2 }, // 6831
  { PseudoVMSLE_VI_M8, VMSLE_VI, 0x3 }, // 6832
  { PseudoVMSLE_VI_M8_MASK, VMSLE_VI, 0x3 }, // 6833
  { PseudoVMSLE_VI_MF8, VMSLE_VI, 0x5 }, // 6834
  { PseudoVMSLE_VI_MF8_MASK, VMSLE_VI, 0x5 }, // 6835
  { PseudoVMSLE_VI_MF4, VMSLE_VI, 0x6 }, // 6836
  { PseudoVMSLE_VI_MF4_MASK, VMSLE_VI, 0x6 }, // 6837
  { PseudoVMSLE_VI_MF2, VMSLE_VI, 0x7 }, // 6838
  { PseudoVMSLE_VI_MF2_MASK, VMSLE_VI, 0x7 }, // 6839
  { PseudoVMSLE_VV_M1, VMSLE_VV, 0x0 }, // 6840
  { PseudoVMSLE_VV_M1_MASK, VMSLE_VV, 0x0 }, // 6841
  { PseudoVMSLE_VV_M2, VMSLE_VV, 0x1 }, // 6842
  { PseudoVMSLE_VV_M2_MASK, VMSLE_VV, 0x1 }, // 6843
  { PseudoVMSLE_VV_M4, VMSLE_VV, 0x2 }, // 6844
  { PseudoVMSLE_VV_M4_MASK, VMSLE_VV, 0x2 }, // 6845
  { PseudoVMSLE_VV_M8, VMSLE_VV, 0x3 }, // 6846
  { PseudoVMSLE_VV_M8_MASK, VMSLE_VV, 0x3 }, // 6847
  { PseudoVMSLE_VV_MF8, VMSLE_VV, 0x5 }, // 6848
  { PseudoVMSLE_VV_MF8_MASK, VMSLE_VV, 0x5 }, // 6849
  { PseudoVMSLE_VV_MF4, VMSLE_VV, 0x6 }, // 6850
  { PseudoVMSLE_VV_MF4_MASK, VMSLE_VV, 0x6 }, // 6851
  { PseudoVMSLE_VV_MF2, VMSLE_VV, 0x7 }, // 6852
  { PseudoVMSLE_VV_MF2_MASK, VMSLE_VV, 0x7 }, // 6853
  { PseudoVMSLE_VX_M1, VMSLE_VX, 0x0 }, // 6854
  { PseudoVMSLE_VX_M1_MASK, VMSLE_VX, 0x0 }, // 6855
  { PseudoVMSLE_VX_M2, VMSLE_VX, 0x1 }, // 6856
  { PseudoVMSLE_VX_M2_MASK, VMSLE_VX, 0x1 }, // 6857
  { PseudoVMSLE_VX_M4, VMSLE_VX, 0x2 }, // 6858
  { PseudoVMSLE_VX_M4_MASK, VMSLE_VX, 0x2 }, // 6859
  { PseudoVMSLE_VX_M8, VMSLE_VX, 0x3 }, // 6860
  { PseudoVMSLE_VX_M8_MASK, VMSLE_VX, 0x3 }, // 6861
  { PseudoVMSLE_VX_MF8, VMSLE_VX, 0x5 }, // 6862
  { PseudoVMSLE_VX_MF8_MASK, VMSLE_VX, 0x5 }, // 6863
  { PseudoVMSLE_VX_MF4, VMSLE_VX, 0x6 }, // 6864
  { PseudoVMSLE_VX_MF4_MASK, VMSLE_VX, 0x6 }, // 6865
  { PseudoVMSLE_VX_MF2, VMSLE_VX, 0x7 }, // 6866
  { PseudoVMSLE_VX_MF2_MASK, VMSLE_VX, 0x7 }, // 6867
  { PseudoVMSLTU_VV_M1, VMSLTU_VV, 0x0 }, // 6868
  { PseudoVMSLTU_VV_M1_MASK, VMSLTU_VV, 0x0 }, // 6869
  { PseudoVMSLTU_VV_M2, VMSLTU_VV, 0x1 }, // 6870
  { PseudoVMSLTU_VV_M2_MASK, VMSLTU_VV, 0x1 }, // 6871
  { PseudoVMSLTU_VV_M4, VMSLTU_VV, 0x2 }, // 6872
  { PseudoVMSLTU_VV_M4_MASK, VMSLTU_VV, 0x2 }, // 6873
  { PseudoVMSLTU_VV_M8, VMSLTU_VV, 0x3 }, // 6874
  { PseudoVMSLTU_VV_M8_MASK, VMSLTU_VV, 0x3 }, // 6875
  { PseudoVMSLTU_VV_MF8, VMSLTU_VV, 0x5 }, // 6876
  { PseudoVMSLTU_VV_MF8_MASK, VMSLTU_VV, 0x5 }, // 6877
  { PseudoVMSLTU_VV_MF4, VMSLTU_VV, 0x6 }, // 6878
  { PseudoVMSLTU_VV_MF4_MASK, VMSLTU_VV, 0x6 }, // 6879
  { PseudoVMSLTU_VV_MF2, VMSLTU_VV, 0x7 }, // 6880
  { PseudoVMSLTU_VV_MF2_MASK, VMSLTU_VV, 0x7 }, // 6881
  { PseudoVMSLTU_VX_M1, VMSLTU_VX, 0x0 }, // 6882
  { PseudoVMSLTU_VX_M1_MASK, VMSLTU_VX, 0x0 }, // 6883
  { PseudoVMSLTU_VX_M2, VMSLTU_VX, 0x1 }, // 6884
  { PseudoVMSLTU_VX_M2_MASK, VMSLTU_VX, 0x1 }, // 6885
  { PseudoVMSLTU_VX_M4, VMSLTU_VX, 0x2 }, // 6886
  { PseudoVMSLTU_VX_M4_MASK, VMSLTU_VX, 0x2 }, // 6887
  { PseudoVMSLTU_VX_M8, VMSLTU_VX, 0x3 }, // 6888
  { PseudoVMSLTU_VX_M8_MASK, VMSLTU_VX, 0x3 }, // 6889
  { PseudoVMSLTU_VX_MF8, VMSLTU_VX, 0x5 }, // 6890
  { PseudoVMSLTU_VX_MF8_MASK, VMSLTU_VX, 0x5 }, // 6891
  { PseudoVMSLTU_VX_MF4, VMSLTU_VX, 0x6 }, // 6892
  { PseudoVMSLTU_VX_MF4_MASK, VMSLTU_VX, 0x6 }, // 6893
  { PseudoVMSLTU_VX_MF2, VMSLTU_VX, 0x7 }, // 6894
  { PseudoVMSLTU_VX_MF2_MASK, VMSLTU_VX, 0x7 }, // 6895
  { PseudoVMSLT_VV_M1, VMSLT_VV, 0x0 }, // 6896
  { PseudoVMSLT_VV_M1_MASK, VMSLT_VV, 0x0 }, // 6897
  { PseudoVMSLT_VV_M2, VMSLT_VV, 0x1 }, // 6898
  { PseudoVMSLT_VV_M2_MASK, VMSLT_VV, 0x1 }, // 6899
  { PseudoVMSLT_VV_M4, VMSLT_VV, 0x2 }, // 6900
  { PseudoVMSLT_VV_M4_MASK, VMSLT_VV, 0x2 }, // 6901
  { PseudoVMSLT_VV_M8, VMSLT_VV, 0x3 }, // 6902
  { PseudoVMSLT_VV_M8_MASK, VMSLT_VV, 0x3 }, // 6903
  { PseudoVMSLT_VV_MF8, VMSLT_VV, 0x5 }, // 6904
  { PseudoVMSLT_VV_MF8_MASK, VMSLT_VV, 0x5 }, // 6905
  { PseudoVMSLT_VV_MF4, VMSLT_VV, 0x6 }, // 6906
  { PseudoVMSLT_VV_MF4_MASK, VMSLT_VV, 0x6 }, // 6907
  { PseudoVMSLT_VV_MF2, VMSLT_VV, 0x7 }, // 6908
  { PseudoVMSLT_VV_MF2_MASK, VMSLT_VV, 0x7 }, // 6909
  { PseudoVMSLT_VX_M1, VMSLT_VX, 0x0 }, // 6910
  { PseudoVMSLT_VX_M1_MASK, VMSLT_VX, 0x0 }, // 6911
  { PseudoVMSLT_VX_M2, VMSLT_VX, 0x1 }, // 6912
  { PseudoVMSLT_VX_M2_MASK, VMSLT_VX, 0x1 }, // 6913
  { PseudoVMSLT_VX_M4, VMSLT_VX, 0x2 }, // 6914
  { PseudoVMSLT_VX_M4_MASK, VMSLT_VX, 0x2 }, // 6915
  { PseudoVMSLT_VX_M8, VMSLT_VX, 0x3 }, // 6916
  { PseudoVMSLT_VX_M8_MASK, VMSLT_VX, 0x3 }, // 6917
  { PseudoVMSLT_VX_MF8, VMSLT_VX, 0x5 }, // 6918
  { PseudoVMSLT_VX_MF8_MASK, VMSLT_VX, 0x5 }, // 6919
  { PseudoVMSLT_VX_MF4, VMSLT_VX, 0x6 }, // 6920
  { PseudoVMSLT_VX_MF4_MASK, VMSLT_VX, 0x6 }, // 6921
  { PseudoVMSLT_VX_MF2, VMSLT_VX, 0x7 }, // 6922
  { PseudoVMSLT_VX_MF2_MASK, VMSLT_VX, 0x7 }, // 6923
  { PseudoVMSNE_VI_M1, VMSNE_VI, 0x0 }, // 6924
  { PseudoVMSNE_VI_M1_MASK, VMSNE_VI, 0x0 }, // 6925
  { PseudoVMSNE_VI_M2, VMSNE_VI, 0x1 }, // 6926
  { PseudoVMSNE_VI_M2_MASK, VMSNE_VI, 0x1 }, // 6927
  { PseudoVMSNE_VI_M4, VMSNE_VI, 0x2 }, // 6928
  { PseudoVMSNE_VI_M4_MASK, VMSNE_VI, 0x2 }, // 6929
  { PseudoVMSNE_VI_M8, VMSNE_VI, 0x3 }, // 6930
  { PseudoVMSNE_VI_M8_MASK, VMSNE_VI, 0x3 }, // 6931
  { PseudoVMSNE_VI_MF8, VMSNE_VI, 0x5 }, // 6932
  { PseudoVMSNE_VI_MF8_MASK, VMSNE_VI, 0x5 }, // 6933
  { PseudoVMSNE_VI_MF4, VMSNE_VI, 0x6 }, // 6934
  { PseudoVMSNE_VI_MF4_MASK, VMSNE_VI, 0x6 }, // 6935
  { PseudoVMSNE_VI_MF2, VMSNE_VI, 0x7 }, // 6936
  { PseudoVMSNE_VI_MF2_MASK, VMSNE_VI, 0x7 }, // 6937
  { PseudoVMSNE_VV_M1, VMSNE_VV, 0x0 }, // 6938
  { PseudoVMSNE_VV_M1_MASK, VMSNE_VV, 0x0 }, // 6939
  { PseudoVMSNE_VV_M2, VMSNE_VV, 0x1 }, // 6940
  { PseudoVMSNE_VV_M2_MASK, VMSNE_VV, 0x1 }, // 6941
  { PseudoVMSNE_VV_M4, VMSNE_VV, 0x2 }, // 6942
  { PseudoVMSNE_VV_M4_MASK, VMSNE_VV, 0x2 }, // 6943
  { PseudoVMSNE_VV_M8, VMSNE_VV, 0x3 }, // 6944
  { PseudoVMSNE_VV_M8_MASK, VMSNE_VV, 0x3 }, // 6945
  { PseudoVMSNE_VV_MF8, VMSNE_VV, 0x5 }, // 6946
  { PseudoVMSNE_VV_MF8_MASK, VMSNE_VV, 0x5 }, // 6947
  { PseudoVMSNE_VV_MF4, VMSNE_VV, 0x6 }, // 6948
  { PseudoVMSNE_VV_MF4_MASK, VMSNE_VV, 0x6 }, // 6949
  { PseudoVMSNE_VV_MF2, VMSNE_VV, 0x7 }, // 6950
  { PseudoVMSNE_VV_MF2_MASK, VMSNE_VV, 0x7 }, // 6951
  { PseudoVMSNE_VX_M1, VMSNE_VX, 0x0 }, // 6952
  { PseudoVMSNE_VX_M1_MASK, VMSNE_VX, 0x0 }, // 6953
  { PseudoVMSNE_VX_M2, VMSNE_VX, 0x1 }, // 6954
  { PseudoVMSNE_VX_M2_MASK, VMSNE_VX, 0x1 }, // 6955
  { PseudoVMSNE_VX_M4, VMSNE_VX, 0x2 }, // 6956
  { PseudoVMSNE_VX_M4_MASK, VMSNE_VX, 0x2 }, // 6957
  { PseudoVMSNE_VX_M8, VMSNE_VX, 0x3 }, // 6958
  { PseudoVMSNE_VX_M8_MASK, VMSNE_VX, 0x3 }, // 6959
  { PseudoVMSNE_VX_MF8, VMSNE_VX, 0x5 }, // 6960
  { PseudoVMSNE_VX_MF8_MASK, VMSNE_VX, 0x5 }, // 6961
  { PseudoVMSNE_VX_MF4, VMSNE_VX, 0x6 }, // 6962
  { PseudoVMSNE_VX_MF4_MASK, VMSNE_VX, 0x6 }, // 6963
  { PseudoVMSNE_VX_MF2, VMSNE_VX, 0x7 }, // 6964
  { PseudoVMSNE_VX_MF2_MASK, VMSNE_VX, 0x7 }, // 6965
  { PseudoVMSOF_M_B8, VMSOF_M, 0x0 }, // 6966
  { PseudoVMSOF_M_B8_MASK, VMSOF_M, 0x0 }, // 6967
  { PseudoVMSOF_M_B16, VMSOF_M, 0x1 }, // 6968
  { PseudoVMSOF_M_B16_MASK, VMSOF_M, 0x1 }, // 6969
  { PseudoVMSOF_M_B32, VMSOF_M, 0x2 }, // 6970
  { PseudoVMSOF_M_B32_MASK, VMSOF_M, 0x2 }, // 6971
  { PseudoVMSOF_M_B64, VMSOF_M, 0x3 }, // 6972
  { PseudoVMSOF_M_B64_MASK, VMSOF_M, 0x3 }, // 6973
  { PseudoVMSOF_M_B1, VMSOF_M, 0x5 }, // 6974
  { PseudoVMSOF_M_B1_MASK, VMSOF_M, 0x5 }, // 6975
  { PseudoVMSOF_M_B2, VMSOF_M, 0x6 }, // 6976
  { PseudoVMSOF_M_B2_MASK, VMSOF_M, 0x6 }, // 6977
  { PseudoVMSOF_M_B4, VMSOF_M, 0x7 }, // 6978
  { PseudoVMSOF_M_B4_MASK, VMSOF_M, 0x7 }, // 6979
  { PseudoVMULHSU_VV_M1, VMULHSU_VV, 0x0 }, // 6980
  { PseudoVMULHSU_VV_M1_MASK, VMULHSU_VV, 0x0 }, // 6981
  { PseudoVMULHSU_VV_M1_TU, VMULHSU_VV, 0x0 }, // 6982
  { PseudoVMULHSU_VV_M2, VMULHSU_VV, 0x1 }, // 6983
  { PseudoVMULHSU_VV_M2_MASK, VMULHSU_VV, 0x1 }, // 6984
  { PseudoVMULHSU_VV_M2_TU, VMULHSU_VV, 0x1 }, // 6985
  { PseudoVMULHSU_VV_M4, VMULHSU_VV, 0x2 }, // 6986
  { PseudoVMULHSU_VV_M4_MASK, VMULHSU_VV, 0x2 }, // 6987
  { PseudoVMULHSU_VV_M4_TU, VMULHSU_VV, 0x2 }, // 6988
  { PseudoVMULHSU_VV_M8, VMULHSU_VV, 0x3 }, // 6989
  { PseudoVMULHSU_VV_M8_MASK, VMULHSU_VV, 0x3 }, // 6990
  { PseudoVMULHSU_VV_M8_TU, VMULHSU_VV, 0x3 }, // 6991
  { PseudoVMULHSU_VV_MF8, VMULHSU_VV, 0x5 }, // 6992
  { PseudoVMULHSU_VV_MF8_MASK, VMULHSU_VV, 0x5 }, // 6993
  { PseudoVMULHSU_VV_MF8_TU, VMULHSU_VV, 0x5 }, // 6994
  { PseudoVMULHSU_VV_MF4, VMULHSU_VV, 0x6 }, // 6995
  { PseudoVMULHSU_VV_MF4_MASK, VMULHSU_VV, 0x6 }, // 6996
  { PseudoVMULHSU_VV_MF4_TU, VMULHSU_VV, 0x6 }, // 6997
  { PseudoVMULHSU_VV_MF2, VMULHSU_VV, 0x7 }, // 6998
  { PseudoVMULHSU_VV_MF2_MASK, VMULHSU_VV, 0x7 }, // 6999
  { PseudoVMULHSU_VV_MF2_TU, VMULHSU_VV, 0x7 }, // 7000
  { PseudoVMULHSU_VX_M1, VMULHSU_VX, 0x0 }, // 7001
  { PseudoVMULHSU_VX_M1_MASK, VMULHSU_VX, 0x0 }, // 7002
  { PseudoVMULHSU_VX_M1_TU, VMULHSU_VX, 0x0 }, // 7003
  { PseudoVMULHSU_VX_M2, VMULHSU_VX, 0x1 }, // 7004
  { PseudoVMULHSU_VX_M2_MASK, VMULHSU_VX, 0x1 }, // 7005
  { PseudoVMULHSU_VX_M2_TU, VMULHSU_VX, 0x1 }, // 7006
  { PseudoVMULHSU_VX_M4, VMULHSU_VX, 0x2 }, // 7007
  { PseudoVMULHSU_VX_M4_MASK, VMULHSU_VX, 0x2 }, // 7008
  { PseudoVMULHSU_VX_M4_TU, VMULHSU_VX, 0x2 }, // 7009
  { PseudoVMULHSU_VX_M8, VMULHSU_VX, 0x3 }, // 7010
  { PseudoVMULHSU_VX_M8_MASK, VMULHSU_VX, 0x3 }, // 7011
  { PseudoVMULHSU_VX_M8_TU, VMULHSU_VX, 0x3 }, // 7012
  { PseudoVMULHSU_VX_MF8, VMULHSU_VX, 0x5 }, // 7013
  { PseudoVMULHSU_VX_MF8_MASK, VMULHSU_VX, 0x5 }, // 7014
  { PseudoVMULHSU_VX_MF8_TU, VMULHSU_VX, 0x5 }, // 7015
  { PseudoVMULHSU_VX_MF4, VMULHSU_VX, 0x6 }, // 7016
  { PseudoVMULHSU_VX_MF4_MASK, VMULHSU_VX, 0x6 }, // 7017
  { PseudoVMULHSU_VX_MF4_TU, VMULHSU_VX, 0x6 }, // 7018
  { PseudoVMULHSU_VX_MF2, VMULHSU_VX, 0x7 }, // 7019
  { PseudoVMULHSU_VX_MF2_MASK, VMULHSU_VX, 0x7 }, // 7020
  { PseudoVMULHSU_VX_MF2_TU, VMULHSU_VX, 0x7 }, // 7021
  { PseudoVMULHU_VV_M1, VMULHU_VV, 0x0 }, // 7022
  { PseudoVMULHU_VV_M1_MASK, VMULHU_VV, 0x0 }, // 7023
  { PseudoVMULHU_VV_M1_TU, VMULHU_VV, 0x0 }, // 7024
  { PseudoVMULHU_VV_M2, VMULHU_VV, 0x1 }, // 7025
  { PseudoVMULHU_VV_M2_MASK, VMULHU_VV, 0x1 }, // 7026
  { PseudoVMULHU_VV_M2_TU, VMULHU_VV, 0x1 }, // 7027
  { PseudoVMULHU_VV_M4, VMULHU_VV, 0x2 }, // 7028
  { PseudoVMULHU_VV_M4_MASK, VMULHU_VV, 0x2 }, // 7029
  { PseudoVMULHU_VV_M4_TU, VMULHU_VV, 0x2 }, // 7030
  { PseudoVMULHU_VV_M8, VMULHU_VV, 0x3 }, // 7031
  { PseudoVMULHU_VV_M8_MASK, VMULHU_VV, 0x3 }, // 7032
  { PseudoVMULHU_VV_M8_TU, VMULHU_VV, 0x3 }, // 7033
  { PseudoVMULHU_VV_MF8, VMULHU_VV, 0x5 }, // 7034
  { PseudoVMULHU_VV_MF8_MASK, VMULHU_VV, 0x5 }, // 7035
  { PseudoVMULHU_VV_MF8_TU, VMULHU_VV, 0x5 }, // 7036
  { PseudoVMULHU_VV_MF4, VMULHU_VV, 0x6 }, // 7037
  { PseudoVMULHU_VV_MF4_MASK, VMULHU_VV, 0x6 }, // 7038
  { PseudoVMULHU_VV_MF4_TU, VMULHU_VV, 0x6 }, // 7039
  { PseudoVMULHU_VV_MF2, VMULHU_VV, 0x7 }, // 7040
  { PseudoVMULHU_VV_MF2_MASK, VMULHU_VV, 0x7 }, // 7041
  { PseudoVMULHU_VV_MF2_TU, VMULHU_VV, 0x7 }, // 7042
  { PseudoVMULHU_VX_M1, VMULHU_VX, 0x0 }, // 7043
  { PseudoVMULHU_VX_M1_MASK, VMULHU_VX, 0x0 }, // 7044
  { PseudoVMULHU_VX_M1_TU, VMULHU_VX, 0x0 }, // 7045
  { PseudoVMULHU_VX_M2, VMULHU_VX, 0x1 }, // 7046
  { PseudoVMULHU_VX_M2_MASK, VMULHU_VX, 0x1 }, // 7047
  { PseudoVMULHU_VX_M2_TU, VMULHU_VX, 0x1 }, // 7048
  { PseudoVMULHU_VX_M4, VMULHU_VX, 0x2 }, // 7049
  { PseudoVMULHU_VX_M4_MASK, VMULHU_VX, 0x2 }, // 7050
  { PseudoVMULHU_VX_M4_TU, VMULHU_VX, 0x2 }, // 7051
  { PseudoVMULHU_VX_M8, VMULHU_VX, 0x3 }, // 7052
  { PseudoVMULHU_VX_M8_MASK, VMULHU_VX, 0x3 }, // 7053
  { PseudoVMULHU_VX_M8_TU, VMULHU_VX, 0x3 }, // 7054
  { PseudoVMULHU_VX_MF8, VMULHU_VX, 0x5 }, // 7055
  { PseudoVMULHU_VX_MF8_MASK, VMULHU_VX, 0x5 }, // 7056
  { PseudoVMULHU_VX_MF8_TU, VMULHU_VX, 0x5 }, // 7057
  { PseudoVMULHU_VX_MF4, VMULHU_VX, 0x6 }, // 7058
  { PseudoVMULHU_VX_MF4_MASK, VMULHU_VX, 0x6 }, // 7059
  { PseudoVMULHU_VX_MF4_TU, VMULHU_VX, 0x6 }, // 7060
  { PseudoVMULHU_VX_MF2, VMULHU_VX, 0x7 }, // 7061
  { PseudoVMULHU_VX_MF2_MASK, VMULHU_VX, 0x7 }, // 7062
  { PseudoVMULHU_VX_MF2_TU, VMULHU_VX, 0x7 }, // 7063
  { PseudoVMULH_VV_M1, VMULH_VV, 0x0 }, // 7064
  { PseudoVMULH_VV_M1_MASK, VMULH_VV, 0x0 }, // 7065
  { PseudoVMULH_VV_M1_TU, VMULH_VV, 0x0 }, // 7066
  { PseudoVMULH_VV_M2, VMULH_VV, 0x1 }, // 7067
  { PseudoVMULH_VV_M2_MASK, VMULH_VV, 0x1 }, // 7068
  { PseudoVMULH_VV_M2_TU, VMULH_VV, 0x1 }, // 7069
  { PseudoVMULH_VV_M4, VMULH_VV, 0x2 }, // 7070
  { PseudoVMULH_VV_M4_MASK, VMULH_VV, 0x2 }, // 7071
  { PseudoVMULH_VV_M4_TU, VMULH_VV, 0x2 }, // 7072
  { PseudoVMULH_VV_M8, VMULH_VV, 0x3 }, // 7073
  { PseudoVMULH_VV_M8_MASK, VMULH_VV, 0x3 }, // 7074
  { PseudoVMULH_VV_M8_TU, VMULH_VV, 0x3 }, // 7075
  { PseudoVMULH_VV_MF8, VMULH_VV, 0x5 }, // 7076
  { PseudoVMULH_VV_MF8_MASK, VMULH_VV, 0x5 }, // 7077
  { PseudoVMULH_VV_MF8_TU, VMULH_VV, 0x5 }, // 7078
  { PseudoVMULH_VV_MF4, VMULH_VV, 0x6 }, // 7079
  { PseudoVMULH_VV_MF4_MASK, VMULH_VV, 0x6 }, // 7080
  { PseudoVMULH_VV_MF4_TU, VMULH_VV, 0x6 }, // 7081
  { PseudoVMULH_VV_MF2, VMULH_VV, 0x7 }, // 7082
  { PseudoVMULH_VV_MF2_MASK, VMULH_VV, 0x7 }, // 7083
  { PseudoVMULH_VV_MF2_TU, VMULH_VV, 0x7 }, // 7084
  { PseudoVMULH_VX_M1, VMULH_VX, 0x0 }, // 7085
  { PseudoVMULH_VX_M1_MASK, VMULH_VX, 0x0 }, // 7086
  { PseudoVMULH_VX_M1_TU, VMULH_VX, 0x0 }, // 7087
  { PseudoVMULH_VX_M2, VMULH_VX, 0x1 }, // 7088
  { PseudoVMULH_VX_M2_MASK, VMULH_VX, 0x1 }, // 7089
  { PseudoVMULH_VX_M2_TU, VMULH_VX, 0x1 }, // 7090
  { PseudoVMULH_VX_M4, VMULH_VX, 0x2 }, // 7091
  { PseudoVMULH_VX_M4_MASK, VMULH_VX, 0x2 }, // 7092
  { PseudoVMULH_VX_M4_TU, VMULH_VX, 0x2 }, // 7093
  { PseudoVMULH_VX_M8, VMULH_VX, 0x3 }, // 7094
  { PseudoVMULH_VX_M8_MASK, VMULH_VX, 0x3 }, // 7095
  { PseudoVMULH_VX_M8_TU, VMULH_VX, 0x3 }, // 7096
  { PseudoVMULH_VX_MF8, VMULH_VX, 0x5 }, // 7097
  { PseudoVMULH_VX_MF8_MASK, VMULH_VX, 0x5 }, // 7098
  { PseudoVMULH_VX_MF8_TU, VMULH_VX, 0x5 }, // 7099
  { PseudoVMULH_VX_MF4, VMULH_VX, 0x6 }, // 7100
  { PseudoVMULH_VX_MF4_MASK, VMULH_VX, 0x6 }, // 7101
  { PseudoVMULH_VX_MF4_TU, VMULH_VX, 0x6 }, // 7102
  { PseudoVMULH_VX_MF2, VMULH_VX, 0x7 }, // 7103
  { PseudoVMULH_VX_MF2_MASK, VMULH_VX, 0x7 }, // 7104
  { PseudoVMULH_VX_MF2_TU, VMULH_VX, 0x7 }, // 7105
  { PseudoVMUL_VV_M1, VMUL_VV, 0x0 }, // 7106
  { PseudoVMUL_VV_M1_MASK, VMUL_VV, 0x0 }, // 7107
  { PseudoVMUL_VV_M1_TU, VMUL_VV, 0x0 }, // 7108
  { PseudoVMUL_VV_M2, VMUL_VV, 0x1 }, // 7109
  { PseudoVMUL_VV_M2_MASK, VMUL_VV, 0x1 }, // 7110
  { PseudoVMUL_VV_M2_TU, VMUL_VV, 0x1 }, // 7111
  { PseudoVMUL_VV_M4, VMUL_VV, 0x2 }, // 7112
  { PseudoVMUL_VV_M4_MASK, VMUL_VV, 0x2 }, // 7113
  { PseudoVMUL_VV_M4_TU, VMUL_VV, 0x2 }, // 7114
  { PseudoVMUL_VV_M8, VMUL_VV, 0x3 }, // 7115
  { PseudoVMUL_VV_M8_MASK, VMUL_VV, 0x3 }, // 7116
  { PseudoVMUL_VV_M8_TU, VMUL_VV, 0x3 }, // 7117
  { PseudoVMUL_VV_MF8, VMUL_VV, 0x5 }, // 7118
  { PseudoVMUL_VV_MF8_MASK, VMUL_VV, 0x5 }, // 7119
  { PseudoVMUL_VV_MF8_TU, VMUL_VV, 0x5 }, // 7120
  { PseudoVMUL_VV_MF4, VMUL_VV, 0x6 }, // 7121
  { PseudoVMUL_VV_MF4_MASK, VMUL_VV, 0x6 }, // 7122
  { PseudoVMUL_VV_MF4_TU, VMUL_VV, 0x6 }, // 7123
  { PseudoVMUL_VV_MF2, VMUL_VV, 0x7 }, // 7124
  { PseudoVMUL_VV_MF2_MASK, VMUL_VV, 0x7 }, // 7125
  { PseudoVMUL_VV_MF2_TU, VMUL_VV, 0x7 }, // 7126
  { PseudoVMUL_VX_M1, VMUL_VX, 0x0 }, // 7127
  { PseudoVMUL_VX_M1_MASK, VMUL_VX, 0x0 }, // 7128
  { PseudoVMUL_VX_M1_TU, VMUL_VX, 0x0 }, // 7129
  { PseudoVMUL_VX_M2, VMUL_VX, 0x1 }, // 7130
  { PseudoVMUL_VX_M2_MASK, VMUL_VX, 0x1 }, // 7131
  { PseudoVMUL_VX_M2_TU, VMUL_VX, 0x1 }, // 7132
  { PseudoVMUL_VX_M4, VMUL_VX, 0x2 }, // 7133
  { PseudoVMUL_VX_M4_MASK, VMUL_VX, 0x2 }, // 7134
  { PseudoVMUL_VX_M4_TU, VMUL_VX, 0x2 }, // 7135
  { PseudoVMUL_VX_M8, VMUL_VX, 0x3 }, // 7136
  { PseudoVMUL_VX_M8_MASK, VMUL_VX, 0x3 }, // 7137
  { PseudoVMUL_VX_M8_TU, VMUL_VX, 0x3 }, // 7138
  { PseudoVMUL_VX_MF8, VMUL_VX, 0x5 }, // 7139
  { PseudoVMUL_VX_MF8_MASK, VMUL_VX, 0x5 }, // 7140
  { PseudoVMUL_VX_MF8_TU, VMUL_VX, 0x5 }, // 7141
  { PseudoVMUL_VX_MF4, VMUL_VX, 0x6 }, // 7142
  { PseudoVMUL_VX_MF4_MASK, VMUL_VX, 0x6 }, // 7143
  { PseudoVMUL_VX_MF4_TU, VMUL_VX, 0x6 }, // 7144
  { PseudoVMUL_VX_MF2, VMUL_VX, 0x7 }, // 7145
  { PseudoVMUL_VX_MF2_MASK, VMUL_VX, 0x7 }, // 7146
  { PseudoVMUL_VX_MF2_TU, VMUL_VX, 0x7 }, // 7147
  { PseudoVMV_S_X_M1, VMV_S_X, 0x0 }, // 7148
  { PseudoVMV_S_X_M2, VMV_S_X, 0x1 }, // 7149
  { PseudoVMV_S_X_M4, VMV_S_X, 0x2 }, // 7150
  { PseudoVMV_S_X_M8, VMV_S_X, 0x3 }, // 7151
  { PseudoVMV_S_X_MF8, VMV_S_X, 0x5 }, // 7152
  { PseudoVMV_S_X_MF4, VMV_S_X, 0x6 }, // 7153
  { PseudoVMV_S_X_MF2, VMV_S_X, 0x7 }, // 7154
  { PseudoVMV_V_I_M1, VMV_V_I, 0x0 }, // 7155
  { PseudoVMV_V_I_M1_TU, VMV_V_I, 0x0 }, // 7156
  { PseudoVMV_V_I_M2, VMV_V_I, 0x1 }, // 7157
  { PseudoVMV_V_I_M2_TU, VMV_V_I, 0x1 }, // 7158
  { PseudoVMV_V_I_M4, VMV_V_I, 0x2 }, // 7159
  { PseudoVMV_V_I_M4_TU, VMV_V_I, 0x2 }, // 7160
  { PseudoVMV_V_I_M8, VMV_V_I, 0x3 }, // 7161
  { PseudoVMV_V_I_M8_TU, VMV_V_I, 0x3 }, // 7162
  { PseudoVMV_V_I_MF8, VMV_V_I, 0x5 }, // 7163
  { PseudoVMV_V_I_MF8_TU, VMV_V_I, 0x5 }, // 7164
  { PseudoVMV_V_I_MF4, VMV_V_I, 0x6 }, // 7165
  { PseudoVMV_V_I_MF4_TU, VMV_V_I, 0x6 }, // 7166
  { PseudoVMV_V_I_MF2, VMV_V_I, 0x7 }, // 7167
  { PseudoVMV_V_I_MF2_TU, VMV_V_I, 0x7 }, // 7168
  { PseudoVMV_V_V_M1, VMV_V_V, 0x0 }, // 7169
  { PseudoVMV_V_V_M1_TU, VMV_V_V, 0x0 }, // 7170
  { PseudoVMV_V_V_M2, VMV_V_V, 0x1 }, // 7171
  { PseudoVMV_V_V_M2_TU, VMV_V_V, 0x1 }, // 7172
  { PseudoVMV_V_V_M4, VMV_V_V, 0x2 }, // 7173
  { PseudoVMV_V_V_M4_TU, VMV_V_V, 0x2 }, // 7174
  { PseudoVMV_V_V_M8, VMV_V_V, 0x3 }, // 7175
  { PseudoVMV_V_V_M8_TU, VMV_V_V, 0x3 }, // 7176
  { PseudoVMV_V_V_MF8, VMV_V_V, 0x5 }, // 7177
  { PseudoVMV_V_V_MF8_TU, VMV_V_V, 0x5 }, // 7178
  { PseudoVMV_V_V_MF4, VMV_V_V, 0x6 }, // 7179
  { PseudoVMV_V_V_MF4_TU, VMV_V_V, 0x6 }, // 7180
  { PseudoVMV_V_V_MF2, VMV_V_V, 0x7 }, // 7181
  { PseudoVMV_V_V_MF2_TU, VMV_V_V, 0x7 }, // 7182
  { PseudoVMV_V_X_M1, VMV_V_X, 0x0 }, // 7183
  { PseudoVMV_V_X_M1_TU, VMV_V_X, 0x0 }, // 7184
  { PseudoVMV_V_X_M2, VMV_V_X, 0x1 }, // 7185
  { PseudoVMV_V_X_M2_TU, VMV_V_X, 0x1 }, // 7186
  { PseudoVMV_V_X_M4, VMV_V_X, 0x2 }, // 7187
  { PseudoVMV_V_X_M4_TU, VMV_V_X, 0x2 }, // 7188
  { PseudoVMV_V_X_M8, VMV_V_X, 0x3 }, // 7189
  { PseudoVMV_V_X_M8_TU, VMV_V_X, 0x3 }, // 7190
  { PseudoVMV_V_X_MF8, VMV_V_X, 0x5 }, // 7191
  { PseudoVMV_V_X_MF8_TU, VMV_V_X, 0x5 }, // 7192
  { PseudoVMV_V_X_MF4, VMV_V_X, 0x6 }, // 7193
  { PseudoVMV_V_X_MF4_TU, VMV_V_X, 0x6 }, // 7194
  { PseudoVMV_V_X_MF2, VMV_V_X, 0x7 }, // 7195
  { PseudoVMV_V_X_MF2_TU, VMV_V_X, 0x7 }, // 7196
  { PseudoVMV_X_S_M1, VMV_X_S, 0x0 }, // 7197
  { PseudoVMV_X_S_M2, VMV_X_S, 0x1 }, // 7198
  { PseudoVMV_X_S_M4, VMV_X_S, 0x2 }, // 7199
  { PseudoVMV_X_S_M8, VMV_X_S, 0x3 }, // 7200
  { PseudoVMV_X_S_MF8, VMV_X_S, 0x5 }, // 7201
  { PseudoVMV_X_S_MF4, VMV_X_S, 0x6 }, // 7202
  { PseudoVMV_X_S_MF2, VMV_X_S, 0x7 }, // 7203
  { PseudoVMSET_M_B8, VMXNOR_MM, 0x0 }, // 7204
  { PseudoVMXNOR_MM_M1, VMXNOR_MM, 0x0 }, // 7205
  { PseudoVMSET_M_B16, VMXNOR_MM, 0x1 }, // 7206
  { PseudoVMXNOR_MM_M2, VMXNOR_MM, 0x1 }, // 7207
  { PseudoVMSET_M_B32, VMXNOR_MM, 0x2 }, // 7208
  { PseudoVMXNOR_MM_M4, VMXNOR_MM, 0x2 }, // 7209
  { PseudoVMSET_M_B64, VMXNOR_MM, 0x3 }, // 7210
  { PseudoVMXNOR_MM_M8, VMXNOR_MM, 0x3 }, // 7211
  { PseudoVMSET_M_B1, VMXNOR_MM, 0x5 }, // 7212
  { PseudoVMXNOR_MM_MF8, VMXNOR_MM, 0x5 }, // 7213
  { PseudoVMSET_M_B2, VMXNOR_MM, 0x6 }, // 7214
  { PseudoVMXNOR_MM_MF4, VMXNOR_MM, 0x6 }, // 7215
  { PseudoVMSET_M_B4, VMXNOR_MM, 0x7 }, // 7216
  { PseudoVMXNOR_MM_MF2, VMXNOR_MM, 0x7 }, // 7217
  { PseudoVMCLR_M_B8, VMXOR_MM, 0x0 }, // 7218
  { PseudoVMXOR_MM_M1, VMXOR_MM, 0x0 }, // 7219
  { PseudoVMCLR_M_B16, VMXOR_MM, 0x1 }, // 7220
  { PseudoVMXOR_MM_M2, VMXOR_MM, 0x1 }, // 7221
  { PseudoVMCLR_M_B32, VMXOR_MM, 0x2 }, // 7222
  { PseudoVMXOR_MM_M4, VMXOR_MM, 0x2 }, // 7223
  { PseudoVMCLR_M_B64, VMXOR_MM, 0x3 }, // 7224
  { PseudoVMXOR_MM_M8, VMXOR_MM, 0x3 }, // 7225
  { PseudoVMCLR_M_B1, VMXOR_MM, 0x5 }, // 7226
  { PseudoVMXOR_MM_MF8, VMXOR_MM, 0x5 }, // 7227
  { PseudoVMCLR_M_B2, VMXOR_MM, 0x6 }, // 7228
  { PseudoVMXOR_MM_MF4, VMXOR_MM, 0x6 }, // 7229
  { PseudoVMCLR_M_B4, VMXOR_MM, 0x7 }, // 7230
  { PseudoVMXOR_MM_MF2, VMXOR_MM, 0x7 }, // 7231
  { PseudoVNCLIPU_WI_M1, VNCLIPU_WI, 0x0 }, // 7232
  { PseudoVNCLIPU_WI_M1_MASK, VNCLIPU_WI, 0x0 }, // 7233
  { PseudoVNCLIPU_WI_M1_TU, VNCLIPU_WI, 0x0 }, // 7234
  { PseudoVNCLIPU_WI_M2, VNCLIPU_WI, 0x1 }, // 7235
  { PseudoVNCLIPU_WI_M2_MASK, VNCLIPU_WI, 0x1 }, // 7236
  { PseudoVNCLIPU_WI_M2_TU, VNCLIPU_WI, 0x1 }, // 7237
  { PseudoVNCLIPU_WI_M4, VNCLIPU_WI, 0x2 }, // 7238
  { PseudoVNCLIPU_WI_M4_MASK, VNCLIPU_WI, 0x2 }, // 7239
  { PseudoVNCLIPU_WI_M4_TU, VNCLIPU_WI, 0x2 }, // 7240
  { PseudoVNCLIPU_WI_MF8, VNCLIPU_WI, 0x5 }, // 7241
  { PseudoVNCLIPU_WI_MF8_MASK, VNCLIPU_WI, 0x5 }, // 7242
  { PseudoVNCLIPU_WI_MF8_TU, VNCLIPU_WI, 0x5 }, // 7243
  { PseudoVNCLIPU_WI_MF4, VNCLIPU_WI, 0x6 }, // 7244
  { PseudoVNCLIPU_WI_MF4_MASK, VNCLIPU_WI, 0x6 }, // 7245
  { PseudoVNCLIPU_WI_MF4_TU, VNCLIPU_WI, 0x6 }, // 7246
  { PseudoVNCLIPU_WI_MF2, VNCLIPU_WI, 0x7 }, // 7247
  { PseudoVNCLIPU_WI_MF2_MASK, VNCLIPU_WI, 0x7 }, // 7248
  { PseudoVNCLIPU_WI_MF2_TU, VNCLIPU_WI, 0x7 }, // 7249
  { PseudoVNCLIPU_WV_M1, VNCLIPU_WV, 0x0 }, // 7250
  { PseudoVNCLIPU_WV_M1_MASK, VNCLIPU_WV, 0x0 }, // 7251
  { PseudoVNCLIPU_WV_M1_TU, VNCLIPU_WV, 0x0 }, // 7252
  { PseudoVNCLIPU_WV_M2, VNCLIPU_WV, 0x1 }, // 7253
  { PseudoVNCLIPU_WV_M2_MASK, VNCLIPU_WV, 0x1 }, // 7254
  { PseudoVNCLIPU_WV_M2_TU, VNCLIPU_WV, 0x1 }, // 7255
  { PseudoVNCLIPU_WV_M4, VNCLIPU_WV, 0x2 }, // 7256
  { PseudoVNCLIPU_WV_M4_MASK, VNCLIPU_WV, 0x2 }, // 7257
  { PseudoVNCLIPU_WV_M4_TU, VNCLIPU_WV, 0x2 }, // 7258
  { PseudoVNCLIPU_WV_MF8, VNCLIPU_WV, 0x5 }, // 7259
  { PseudoVNCLIPU_WV_MF8_MASK, VNCLIPU_WV, 0x5 }, // 7260
  { PseudoVNCLIPU_WV_MF8_TU, VNCLIPU_WV, 0x5 }, // 7261
  { PseudoVNCLIPU_WV_MF4, VNCLIPU_WV, 0x6 }, // 7262
  { PseudoVNCLIPU_WV_MF4_MASK, VNCLIPU_WV, 0x6 }, // 7263
  { PseudoVNCLIPU_WV_MF4_TU, VNCLIPU_WV, 0x6 }, // 7264
  { PseudoVNCLIPU_WV_MF2, VNCLIPU_WV, 0x7 }, // 7265
  { PseudoVNCLIPU_WV_MF2_MASK, VNCLIPU_WV, 0x7 }, // 7266
  { PseudoVNCLIPU_WV_MF2_TU, VNCLIPU_WV, 0x7 }, // 7267
  { PseudoVNCLIPU_WX_M1, VNCLIPU_WX, 0x0 }, // 7268
  { PseudoVNCLIPU_WX_M1_MASK, VNCLIPU_WX, 0x0 }, // 7269
  { PseudoVNCLIPU_WX_M1_TU, VNCLIPU_WX, 0x0 }, // 7270
  { PseudoVNCLIPU_WX_M2, VNCLIPU_WX, 0x1 }, // 7271
  { PseudoVNCLIPU_WX_M2_MASK, VNCLIPU_WX, 0x1 }, // 7272
  { PseudoVNCLIPU_WX_M2_TU, VNCLIPU_WX, 0x1 }, // 7273
  { PseudoVNCLIPU_WX_M4, VNCLIPU_WX, 0x2 }, // 7274
  { PseudoVNCLIPU_WX_M4_MASK, VNCLIPU_WX, 0x2 }, // 7275
  { PseudoVNCLIPU_WX_M4_TU, VNCLIPU_WX, 0x2 }, // 7276
  { PseudoVNCLIPU_WX_MF8, VNCLIPU_WX, 0x5 }, // 7277
  { PseudoVNCLIPU_WX_MF8_MASK, VNCLIPU_WX, 0x5 }, // 7278
  { PseudoVNCLIPU_WX_MF8_TU, VNCLIPU_WX, 0x5 }, // 7279
  { PseudoVNCLIPU_WX_MF4, VNCLIPU_WX, 0x6 }, // 7280
  { PseudoVNCLIPU_WX_MF4_MASK, VNCLIPU_WX, 0x6 }, // 7281
  { PseudoVNCLIPU_WX_MF4_TU, VNCLIPU_WX, 0x6 }, // 7282
  { PseudoVNCLIPU_WX_MF2, VNCLIPU_WX, 0x7 }, // 7283
  { PseudoVNCLIPU_WX_MF2_MASK, VNCLIPU_WX, 0x7 }, // 7284
  { PseudoVNCLIPU_WX_MF2_TU, VNCLIPU_WX, 0x7 }, // 7285
  { PseudoVNCLIP_WI_M1, VNCLIP_WI, 0x0 }, // 7286
  { PseudoVNCLIP_WI_M1_MASK, VNCLIP_WI, 0x0 }, // 7287
  { PseudoVNCLIP_WI_M1_TU, VNCLIP_WI, 0x0 }, // 7288
  { PseudoVNCLIP_WI_M2, VNCLIP_WI, 0x1 }, // 7289
  { PseudoVNCLIP_WI_M2_MASK, VNCLIP_WI, 0x1 }, // 7290
  { PseudoVNCLIP_WI_M2_TU, VNCLIP_WI, 0x1 }, // 7291
  { PseudoVNCLIP_WI_M4, VNCLIP_WI, 0x2 }, // 7292
  { PseudoVNCLIP_WI_M4_MASK, VNCLIP_WI, 0x2 }, // 7293
  { PseudoVNCLIP_WI_M4_TU, VNCLIP_WI, 0x2 }, // 7294
  { PseudoVNCLIP_WI_MF8, VNCLIP_WI, 0x5 }, // 7295
  { PseudoVNCLIP_WI_MF8_MASK, VNCLIP_WI, 0x5 }, // 7296
  { PseudoVNCLIP_WI_MF8_TU, VNCLIP_WI, 0x5 }, // 7297
  { PseudoVNCLIP_WI_MF4, VNCLIP_WI, 0x6 }, // 7298
  { PseudoVNCLIP_WI_MF4_MASK, VNCLIP_WI, 0x6 }, // 7299
  { PseudoVNCLIP_WI_MF4_TU, VNCLIP_WI, 0x6 }, // 7300
  { PseudoVNCLIP_WI_MF2, VNCLIP_WI, 0x7 }, // 7301
  { PseudoVNCLIP_WI_MF2_MASK, VNCLIP_WI, 0x7 }, // 7302
  { PseudoVNCLIP_WI_MF2_TU, VNCLIP_WI, 0x7 }, // 7303
  { PseudoVNCLIP_WV_M1, VNCLIP_WV, 0x0 }, // 7304
  { PseudoVNCLIP_WV_M1_MASK, VNCLIP_WV, 0x0 }, // 7305
  { PseudoVNCLIP_WV_M1_TU, VNCLIP_WV, 0x0 }, // 7306
  { PseudoVNCLIP_WV_M2, VNCLIP_WV, 0x1 }, // 7307
  { PseudoVNCLIP_WV_M2_MASK, VNCLIP_WV, 0x1 }, // 7308
  { PseudoVNCLIP_WV_M2_TU, VNCLIP_WV, 0x1 }, // 7309
  { PseudoVNCLIP_WV_M4, VNCLIP_WV, 0x2 }, // 7310
  { PseudoVNCLIP_WV_M4_MASK, VNCLIP_WV, 0x2 }, // 7311
  { PseudoVNCLIP_WV_M4_TU, VNCLIP_WV, 0x2 }, // 7312
  { PseudoVNCLIP_WV_MF8, VNCLIP_WV, 0x5 }, // 7313
  { PseudoVNCLIP_WV_MF8_MASK, VNCLIP_WV, 0x5 }, // 7314
  { PseudoVNCLIP_WV_MF8_TU, VNCLIP_WV, 0x5 }, // 7315
  { PseudoVNCLIP_WV_MF4, VNCLIP_WV, 0x6 }, // 7316
  { PseudoVNCLIP_WV_MF4_MASK, VNCLIP_WV, 0x6 }, // 7317
  { PseudoVNCLIP_WV_MF4_TU, VNCLIP_WV, 0x6 }, // 7318
  { PseudoVNCLIP_WV_MF2, VNCLIP_WV, 0x7 }, // 7319
  { PseudoVNCLIP_WV_MF2_MASK, VNCLIP_WV, 0x7 }, // 7320
  { PseudoVNCLIP_WV_MF2_TU, VNCLIP_WV, 0x7 }, // 7321
  { PseudoVNCLIP_WX_M1, VNCLIP_WX, 0x0 }, // 7322
  { PseudoVNCLIP_WX_M1_MASK, VNCLIP_WX, 0x0 }, // 7323
  { PseudoVNCLIP_WX_M1_TU, VNCLIP_WX, 0x0 }, // 7324
  { PseudoVNCLIP_WX_M2, VNCLIP_WX, 0x1 }, // 7325
  { PseudoVNCLIP_WX_M2_MASK, VNCLIP_WX, 0x1 }, // 7326
  { PseudoVNCLIP_WX_M2_TU, VNCLIP_WX, 0x1 }, // 7327
  { PseudoVNCLIP_WX_M4, VNCLIP_WX, 0x2 }, // 7328
  { PseudoVNCLIP_WX_M4_MASK, VNCLIP_WX, 0x2 }, // 7329
  { PseudoVNCLIP_WX_M4_TU, VNCLIP_WX, 0x2 }, // 7330
  { PseudoVNCLIP_WX_MF8, VNCLIP_WX, 0x5 }, // 7331
  { PseudoVNCLIP_WX_MF8_MASK, VNCLIP_WX, 0x5 }, // 7332
  { PseudoVNCLIP_WX_MF8_TU, VNCLIP_WX, 0x5 }, // 7333
  { PseudoVNCLIP_WX_MF4, VNCLIP_WX, 0x6 }, // 7334
  { PseudoVNCLIP_WX_MF4_MASK, VNCLIP_WX, 0x6 }, // 7335
  { PseudoVNCLIP_WX_MF4_TU, VNCLIP_WX, 0x6 }, // 7336
  { PseudoVNCLIP_WX_MF2, VNCLIP_WX, 0x7 }, // 7337
  { PseudoVNCLIP_WX_MF2_MASK, VNCLIP_WX, 0x7 }, // 7338
  { PseudoVNCLIP_WX_MF2_TU, VNCLIP_WX, 0x7 }, // 7339
  { PseudoVNMSAC_VV_M1, VNMSAC_VV, 0x0 }, // 7340
  { PseudoVNMSAC_VV_M1_MASK, VNMSAC_VV, 0x0 }, // 7341
  { PseudoVNMSAC_VV_M2, VNMSAC_VV, 0x1 }, // 7342
  { PseudoVNMSAC_VV_M2_MASK, VNMSAC_VV, 0x1 }, // 7343
  { PseudoVNMSAC_VV_M4, VNMSAC_VV, 0x2 }, // 7344
  { PseudoVNMSAC_VV_M4_MASK, VNMSAC_VV, 0x2 }, // 7345
  { PseudoVNMSAC_VV_M8, VNMSAC_VV, 0x3 }, // 7346
  { PseudoVNMSAC_VV_M8_MASK, VNMSAC_VV, 0x3 }, // 7347
  { PseudoVNMSAC_VV_MF8, VNMSAC_VV, 0x5 }, // 7348
  { PseudoVNMSAC_VV_MF8_MASK, VNMSAC_VV, 0x5 }, // 7349
  { PseudoVNMSAC_VV_MF4, VNMSAC_VV, 0x6 }, // 7350
  { PseudoVNMSAC_VV_MF4_MASK, VNMSAC_VV, 0x6 }, // 7351
  { PseudoVNMSAC_VV_MF2, VNMSAC_VV, 0x7 }, // 7352
  { PseudoVNMSAC_VV_MF2_MASK, VNMSAC_VV, 0x7 }, // 7353
  { PseudoVNMSAC_VX_M1, VNMSAC_VX, 0x0 }, // 7354
  { PseudoVNMSAC_VX_M1_MASK, VNMSAC_VX, 0x0 }, // 7355
  { PseudoVNMSAC_VX_M2, VNMSAC_VX, 0x1 }, // 7356
  { PseudoVNMSAC_VX_M2_MASK, VNMSAC_VX, 0x1 }, // 7357
  { PseudoVNMSAC_VX_M4, VNMSAC_VX, 0x2 }, // 7358
  { PseudoVNMSAC_VX_M4_MASK, VNMSAC_VX, 0x2 }, // 7359
  { PseudoVNMSAC_VX_M8, VNMSAC_VX, 0x3 }, // 7360
  { PseudoVNMSAC_VX_M8_MASK, VNMSAC_VX, 0x3 }, // 7361
  { PseudoVNMSAC_VX_MF8, VNMSAC_VX, 0x5 }, // 7362
  { PseudoVNMSAC_VX_MF8_MASK, VNMSAC_VX, 0x5 }, // 7363
  { PseudoVNMSAC_VX_MF4, VNMSAC_VX, 0x6 }, // 7364
  { PseudoVNMSAC_VX_MF4_MASK, VNMSAC_VX, 0x6 }, // 7365
  { PseudoVNMSAC_VX_MF2, VNMSAC_VX, 0x7 }, // 7366
  { PseudoVNMSAC_VX_MF2_MASK, VNMSAC_VX, 0x7 }, // 7367
  { PseudoVNMSUB_VV_M1, VNMSUB_VV, 0x0 }, // 7368
  { PseudoVNMSUB_VV_M1_MASK, VNMSUB_VV, 0x0 }, // 7369
  { PseudoVNMSUB_VV_M2, VNMSUB_VV, 0x1 }, // 7370
  { PseudoVNMSUB_VV_M2_MASK, VNMSUB_VV, 0x1 }, // 7371
  { PseudoVNMSUB_VV_M4, VNMSUB_VV, 0x2 }, // 7372
  { PseudoVNMSUB_VV_M4_MASK, VNMSUB_VV, 0x2 }, // 7373
  { PseudoVNMSUB_VV_M8, VNMSUB_VV, 0x3 }, // 7374
  { PseudoVNMSUB_VV_M8_MASK, VNMSUB_VV, 0x3 }, // 7375
  { PseudoVNMSUB_VV_MF8, VNMSUB_VV, 0x5 }, // 7376
  { PseudoVNMSUB_VV_MF8_MASK, VNMSUB_VV, 0x5 }, // 7377
  { PseudoVNMSUB_VV_MF4, VNMSUB_VV, 0x6 }, // 7378
  { PseudoVNMSUB_VV_MF4_MASK, VNMSUB_VV, 0x6 }, // 7379
  { PseudoVNMSUB_VV_MF2, VNMSUB_VV, 0x7 }, // 7380
  { PseudoVNMSUB_VV_MF2_MASK, VNMSUB_VV, 0x7 }, // 7381
  { PseudoVNMSUB_VX_M1, VNMSUB_VX, 0x0 }, // 7382
  { PseudoVNMSUB_VX_M1_MASK, VNMSUB_VX, 0x0 }, // 7383
  { PseudoVNMSUB_VX_M2, VNMSUB_VX, 0x1 }, // 7384
  { PseudoVNMSUB_VX_M2_MASK, VNMSUB_VX, 0x1 }, // 7385
  { PseudoVNMSUB_VX_M4, VNMSUB_VX, 0x2 }, // 7386
  { PseudoVNMSUB_VX_M4_MASK, VNMSUB_VX, 0x2 }, // 7387
  { PseudoVNMSUB_VX_M8, VNMSUB_VX, 0x3 }, // 7388
  { PseudoVNMSUB_VX_M8_MASK, VNMSUB_VX, 0x3 }, // 7389
  { PseudoVNMSUB_VX_MF8, VNMSUB_VX, 0x5 }, // 7390
  { PseudoVNMSUB_VX_MF8_MASK, VNMSUB_VX, 0x5 }, // 7391
  { PseudoVNMSUB_VX_MF4, VNMSUB_VX, 0x6 }, // 7392
  { PseudoVNMSUB_VX_MF4_MASK, VNMSUB_VX, 0x6 }, // 7393
  { PseudoVNMSUB_VX_MF2, VNMSUB_VX, 0x7 }, // 7394
  { PseudoVNMSUB_VX_MF2_MASK, VNMSUB_VX, 0x7 }, // 7395
  { PseudoVNSRA_WI_M1, VNSRA_WI, 0x0 }, // 7396
  { PseudoVNSRA_WI_M1_MASK, VNSRA_WI, 0x0 }, // 7397
  { PseudoVNSRA_WI_M1_TU, VNSRA_WI, 0x0 }, // 7398
  { PseudoVNSRA_WI_M2, VNSRA_WI, 0x1 }, // 7399
  { PseudoVNSRA_WI_M2_MASK, VNSRA_WI, 0x1 }, // 7400
  { PseudoVNSRA_WI_M2_TU, VNSRA_WI, 0x1 }, // 7401
  { PseudoVNSRA_WI_M4, VNSRA_WI, 0x2 }, // 7402
  { PseudoVNSRA_WI_M4_MASK, VNSRA_WI, 0x2 }, // 7403
  { PseudoVNSRA_WI_M4_TU, VNSRA_WI, 0x2 }, // 7404
  { PseudoVNSRA_WI_MF8, VNSRA_WI, 0x5 }, // 7405
  { PseudoVNSRA_WI_MF8_MASK, VNSRA_WI, 0x5 }, // 7406
  { PseudoVNSRA_WI_MF8_TU, VNSRA_WI, 0x5 }, // 7407
  { PseudoVNSRA_WI_MF4, VNSRA_WI, 0x6 }, // 7408
  { PseudoVNSRA_WI_MF4_MASK, VNSRA_WI, 0x6 }, // 7409
  { PseudoVNSRA_WI_MF4_TU, VNSRA_WI, 0x6 }, // 7410
  { PseudoVNSRA_WI_MF2, VNSRA_WI, 0x7 }, // 7411
  { PseudoVNSRA_WI_MF2_MASK, VNSRA_WI, 0x7 }, // 7412
  { PseudoVNSRA_WI_MF2_TU, VNSRA_WI, 0x7 }, // 7413
  { PseudoVNSRA_WV_M1, VNSRA_WV, 0x0 }, // 7414
  { PseudoVNSRA_WV_M1_MASK, VNSRA_WV, 0x0 }, // 7415
  { PseudoVNSRA_WV_M1_TU, VNSRA_WV, 0x0 }, // 7416
  { PseudoVNSRA_WV_M2, VNSRA_WV, 0x1 }, // 7417
  { PseudoVNSRA_WV_M2_MASK, VNSRA_WV, 0x1 }, // 7418
  { PseudoVNSRA_WV_M2_TU, VNSRA_WV, 0x1 }, // 7419
  { PseudoVNSRA_WV_M4, VNSRA_WV, 0x2 }, // 7420
  { PseudoVNSRA_WV_M4_MASK, VNSRA_WV, 0x2 }, // 7421
  { PseudoVNSRA_WV_M4_TU, VNSRA_WV, 0x2 }, // 7422
  { PseudoVNSRA_WV_MF8, VNSRA_WV, 0x5 }, // 7423
  { PseudoVNSRA_WV_MF8_MASK, VNSRA_WV, 0x5 }, // 7424
  { PseudoVNSRA_WV_MF8_TU, VNSRA_WV, 0x5 }, // 7425
  { PseudoVNSRA_WV_MF4, VNSRA_WV, 0x6 }, // 7426
  { PseudoVNSRA_WV_MF4_MASK, VNSRA_WV, 0x6 }, // 7427
  { PseudoVNSRA_WV_MF4_TU, VNSRA_WV, 0x6 }, // 7428
  { PseudoVNSRA_WV_MF2, VNSRA_WV, 0x7 }, // 7429
  { PseudoVNSRA_WV_MF2_MASK, VNSRA_WV, 0x7 }, // 7430
  { PseudoVNSRA_WV_MF2_TU, VNSRA_WV, 0x7 }, // 7431
  { PseudoVNSRA_WX_M1, VNSRA_WX, 0x0 }, // 7432
  { PseudoVNSRA_WX_M1_MASK, VNSRA_WX, 0x0 }, // 7433
  { PseudoVNSRA_WX_M1_TU, VNSRA_WX, 0x0 }, // 7434
  { PseudoVNSRA_WX_M2, VNSRA_WX, 0x1 }, // 7435
  { PseudoVNSRA_WX_M2_MASK, VNSRA_WX, 0x1 }, // 7436
  { PseudoVNSRA_WX_M2_TU, VNSRA_WX, 0x1 }, // 7437
  { PseudoVNSRA_WX_M4, VNSRA_WX, 0x2 }, // 7438
  { PseudoVNSRA_WX_M4_MASK, VNSRA_WX, 0x2 }, // 7439
  { PseudoVNSRA_WX_M4_TU, VNSRA_WX, 0x2 }, // 7440
  { PseudoVNSRA_WX_MF8, VNSRA_WX, 0x5 }, // 7441
  { PseudoVNSRA_WX_MF8_MASK, VNSRA_WX, 0x5 }, // 7442
  { PseudoVNSRA_WX_MF8_TU, VNSRA_WX, 0x5 }, // 7443
  { PseudoVNSRA_WX_MF4, VNSRA_WX, 0x6 }, // 7444
  { PseudoVNSRA_WX_MF4_MASK, VNSRA_WX, 0x6 }, // 7445
  { PseudoVNSRA_WX_MF4_TU, VNSRA_WX, 0x6 }, // 7446
  { PseudoVNSRA_WX_MF2, VNSRA_WX, 0x7 }, // 7447
  { PseudoVNSRA_WX_MF2_MASK, VNSRA_WX, 0x7 }, // 7448
  { PseudoVNSRA_WX_MF2_TU, VNSRA_WX, 0x7 }, // 7449
  { PseudoVNSRL_WI_M1, VNSRL_WI, 0x0 }, // 7450
  { PseudoVNSRL_WI_M1_MASK, VNSRL_WI, 0x0 }, // 7451
  { PseudoVNSRL_WI_M1_TU, VNSRL_WI, 0x0 }, // 7452
  { PseudoVNSRL_WI_M2, VNSRL_WI, 0x1 }, // 7453
  { PseudoVNSRL_WI_M2_MASK, VNSRL_WI, 0x1 }, // 7454
  { PseudoVNSRL_WI_M2_TU, VNSRL_WI, 0x1 }, // 7455
  { PseudoVNSRL_WI_M4, VNSRL_WI, 0x2 }, // 7456
  { PseudoVNSRL_WI_M4_MASK, VNSRL_WI, 0x2 }, // 7457
  { PseudoVNSRL_WI_M4_TU, VNSRL_WI, 0x2 }, // 7458
  { PseudoVNSRL_WI_MF8, VNSRL_WI, 0x5 }, // 7459
  { PseudoVNSRL_WI_MF8_MASK, VNSRL_WI, 0x5 }, // 7460
  { PseudoVNSRL_WI_MF8_TU, VNSRL_WI, 0x5 }, // 7461
  { PseudoVNSRL_WI_MF4, VNSRL_WI, 0x6 }, // 7462
  { PseudoVNSRL_WI_MF4_MASK, VNSRL_WI, 0x6 }, // 7463
  { PseudoVNSRL_WI_MF4_TU, VNSRL_WI, 0x6 }, // 7464
  { PseudoVNSRL_WI_MF2, VNSRL_WI, 0x7 }, // 7465
  { PseudoVNSRL_WI_MF2_MASK, VNSRL_WI, 0x7 }, // 7466
  { PseudoVNSRL_WI_MF2_TU, VNSRL_WI, 0x7 }, // 7467
  { PseudoVNSRL_WV_M1, VNSRL_WV, 0x0 }, // 7468
  { PseudoVNSRL_WV_M1_MASK, VNSRL_WV, 0x0 }, // 7469
  { PseudoVNSRL_WV_M1_TU, VNSRL_WV, 0x0 }, // 7470
  { PseudoVNSRL_WV_M2, VNSRL_WV, 0x1 }, // 7471
  { PseudoVNSRL_WV_M2_MASK, VNSRL_WV, 0x1 }, // 7472
  { PseudoVNSRL_WV_M2_TU, VNSRL_WV, 0x1 }, // 7473
  { PseudoVNSRL_WV_M4, VNSRL_WV, 0x2 }, // 7474
  { PseudoVNSRL_WV_M4_MASK, VNSRL_WV, 0x2 }, // 7475
  { PseudoVNSRL_WV_M4_TU, VNSRL_WV, 0x2 }, // 7476
  { PseudoVNSRL_WV_MF8, VNSRL_WV, 0x5 }, // 7477
  { PseudoVNSRL_WV_MF8_MASK, VNSRL_WV, 0x5 }, // 7478
  { PseudoVNSRL_WV_MF8_TU, VNSRL_WV, 0x5 }, // 7479
  { PseudoVNSRL_WV_MF4, VNSRL_WV, 0x6 }, // 7480
  { PseudoVNSRL_WV_MF4_MASK, VNSRL_WV, 0x6 }, // 7481
  { PseudoVNSRL_WV_MF4_TU, VNSRL_WV, 0x6 }, // 7482
  { PseudoVNSRL_WV_MF2, VNSRL_WV, 0x7 }, // 7483
  { PseudoVNSRL_WV_MF2_MASK, VNSRL_WV, 0x7 }, // 7484
  { PseudoVNSRL_WV_MF2_TU, VNSRL_WV, 0x7 }, // 7485
  { PseudoVNSRL_WX_M1, VNSRL_WX, 0x0 }, // 7486
  { PseudoVNSRL_WX_M1_MASK, VNSRL_WX, 0x0 }, // 7487
  { PseudoVNSRL_WX_M1_TU, VNSRL_WX, 0x0 }, // 7488
  { PseudoVNSRL_WX_M2, VNSRL_WX, 0x1 }, // 7489
  { PseudoVNSRL_WX_M2_MASK, VNSRL_WX, 0x1 }, // 7490
  { PseudoVNSRL_WX_M2_TU, VNSRL_WX, 0x1 }, // 7491
  { PseudoVNSRL_WX_M4, VNSRL_WX, 0x2 }, // 7492
  { PseudoVNSRL_WX_M4_MASK, VNSRL_WX, 0x2 }, // 7493
  { PseudoVNSRL_WX_M4_TU, VNSRL_WX, 0x2 }, // 7494
  { PseudoVNSRL_WX_MF8, VNSRL_WX, 0x5 }, // 7495
  { PseudoVNSRL_WX_MF8_MASK, VNSRL_WX, 0x5 }, // 7496
  { PseudoVNSRL_WX_MF8_TU, VNSRL_WX, 0x5 }, // 7497
  { PseudoVNSRL_WX_MF4, VNSRL_WX, 0x6 }, // 7498
  { PseudoVNSRL_WX_MF4_MASK, VNSRL_WX, 0x6 }, // 7499
  { PseudoVNSRL_WX_MF4_TU, VNSRL_WX, 0x6 }, // 7500
  { PseudoVNSRL_WX_MF2, VNSRL_WX, 0x7 }, // 7501
  { PseudoVNSRL_WX_MF2_MASK, VNSRL_WX, 0x7 }, // 7502
  { PseudoVNSRL_WX_MF2_TU, VNSRL_WX, 0x7 }, // 7503
  { PseudoVOR_VI_M1, VOR_VI, 0x0 }, // 7504
  { PseudoVOR_VI_M1_MASK, VOR_VI, 0x0 }, // 7505
  { PseudoVOR_VI_M1_TU, VOR_VI, 0x0 }, // 7506
  { PseudoVOR_VI_M2, VOR_VI, 0x1 }, // 7507
  { PseudoVOR_VI_M2_MASK, VOR_VI, 0x1 }, // 7508
  { PseudoVOR_VI_M2_TU, VOR_VI, 0x1 }, // 7509
  { PseudoVOR_VI_M4, VOR_VI, 0x2 }, // 7510
  { PseudoVOR_VI_M4_MASK, VOR_VI, 0x2 }, // 7511
  { PseudoVOR_VI_M4_TU, VOR_VI, 0x2 }, // 7512
  { PseudoVOR_VI_M8, VOR_VI, 0x3 }, // 7513
  { PseudoVOR_VI_M8_MASK, VOR_VI, 0x3 }, // 7514
  { PseudoVOR_VI_M8_TU, VOR_VI, 0x3 }, // 7515
  { PseudoVOR_VI_MF8, VOR_VI, 0x5 }, // 7516
  { PseudoVOR_VI_MF8_MASK, VOR_VI, 0x5 }, // 7517
  { PseudoVOR_VI_MF8_TU, VOR_VI, 0x5 }, // 7518
  { PseudoVOR_VI_MF4, VOR_VI, 0x6 }, // 7519
  { PseudoVOR_VI_MF4_MASK, VOR_VI, 0x6 }, // 7520
  { PseudoVOR_VI_MF4_TU, VOR_VI, 0x6 }, // 7521
  { PseudoVOR_VI_MF2, VOR_VI, 0x7 }, // 7522
  { PseudoVOR_VI_MF2_MASK, VOR_VI, 0x7 }, // 7523
  { PseudoVOR_VI_MF2_TU, VOR_VI, 0x7 }, // 7524
  { PseudoVOR_VV_M1, VOR_VV, 0x0 }, // 7525
  { PseudoVOR_VV_M1_MASK, VOR_VV, 0x0 }, // 7526
  { PseudoVOR_VV_M1_TU, VOR_VV, 0x0 }, // 7527
  { PseudoVOR_VV_M2, VOR_VV, 0x1 }, // 7528
  { PseudoVOR_VV_M2_MASK, VOR_VV, 0x1 }, // 7529
  { PseudoVOR_VV_M2_TU, VOR_VV, 0x1 }, // 7530
  { PseudoVOR_VV_M4, VOR_VV, 0x2 }, // 7531
  { PseudoVOR_VV_M4_MASK, VOR_VV, 0x2 }, // 7532
  { PseudoVOR_VV_M4_TU, VOR_VV, 0x2 }, // 7533
  { PseudoVOR_VV_M8, VOR_VV, 0x3 }, // 7534
  { PseudoVOR_VV_M8_MASK, VOR_VV, 0x3 }, // 7535
  { PseudoVOR_VV_M8_TU, VOR_VV, 0x3 }, // 7536
  { PseudoVOR_VV_MF8, VOR_VV, 0x5 }, // 7537
  { PseudoVOR_VV_MF8_MASK, VOR_VV, 0x5 }, // 7538
  { PseudoVOR_VV_MF8_TU, VOR_VV, 0x5 }, // 7539
  { PseudoVOR_VV_MF4, VOR_VV, 0x6 }, // 7540
  { PseudoVOR_VV_MF4_MASK, VOR_VV, 0x6 }, // 7541
  { PseudoVOR_VV_MF4_TU, VOR_VV, 0x6 }, // 7542
  { PseudoVOR_VV_MF2, VOR_VV, 0x7 }, // 7543
  { PseudoVOR_VV_MF2_MASK, VOR_VV, 0x7 }, // 7544
  { PseudoVOR_VV_MF2_TU, VOR_VV, 0x7 }, // 7545
  { PseudoVOR_VX_M1, VOR_VX, 0x0 }, // 7546
  { PseudoVOR_VX_M1_MASK, VOR_VX, 0x0 }, // 7547
  { PseudoVOR_VX_M1_TU, VOR_VX, 0x0 }, // 7548
  { PseudoVOR_VX_M2, VOR_VX, 0x1 }, // 7549
  { PseudoVOR_VX_M2_MASK, VOR_VX, 0x1 }, // 7550
  { PseudoVOR_VX_M2_TU, VOR_VX, 0x1 }, // 7551
  { PseudoVOR_VX_M4, VOR_VX, 0x2 }, // 7552
  { PseudoVOR_VX_M4_MASK, VOR_VX, 0x2 }, // 7553
  { PseudoVOR_VX_M4_TU, VOR_VX, 0x2 }, // 7554
  { PseudoVOR_VX_M8, VOR_VX, 0x3 }, // 7555
  { PseudoVOR_VX_M8_MASK, VOR_VX, 0x3 }, // 7556
  { PseudoVOR_VX_M8_TU, VOR_VX, 0x3 }, // 7557
  { PseudoVOR_VX_MF8, VOR_VX, 0x5 }, // 7558
  { PseudoVOR_VX_MF8_MASK, VOR_VX, 0x5 }, // 7559
  { PseudoVOR_VX_MF8_TU, VOR_VX, 0x5 }, // 7560
  { PseudoVOR_VX_MF4, VOR_VX, 0x6 }, // 7561
  { PseudoVOR_VX_MF4_MASK, VOR_VX, 0x6 }, // 7562
  { PseudoVOR_VX_MF4_TU, VOR_VX, 0x6 }, // 7563
  { PseudoVOR_VX_MF2, VOR_VX, 0x7 }, // 7564
  { PseudoVOR_VX_MF2_MASK, VOR_VX, 0x7 }, // 7565
  { PseudoVOR_VX_MF2_TU, VOR_VX, 0x7 }, // 7566
  { PseudoVREDAND_VS_M1, VREDAND_VS, 0x0 }, // 7567
  { PseudoVREDAND_VS_M1_MASK, VREDAND_VS, 0x0 }, // 7568
  { PseudoVREDAND_VS_M2, VREDAND_VS, 0x1 }, // 7569
  { PseudoVREDAND_VS_M2_MASK, VREDAND_VS, 0x1 }, // 7570
  { PseudoVREDAND_VS_M4, VREDAND_VS, 0x2 }, // 7571
  { PseudoVREDAND_VS_M4_MASK, VREDAND_VS, 0x2 }, // 7572
  { PseudoVREDAND_VS_M8, VREDAND_VS, 0x3 }, // 7573
  { PseudoVREDAND_VS_M8_MASK, VREDAND_VS, 0x3 }, // 7574
  { PseudoVREDAND_VS_MF8, VREDAND_VS, 0x5 }, // 7575
  { PseudoVREDAND_VS_MF8_MASK, VREDAND_VS, 0x5 }, // 7576
  { PseudoVREDAND_VS_MF4, VREDAND_VS, 0x6 }, // 7577
  { PseudoVREDAND_VS_MF4_MASK, VREDAND_VS, 0x6 }, // 7578
  { PseudoVREDAND_VS_MF2, VREDAND_VS, 0x7 }, // 7579
  { PseudoVREDAND_VS_MF2_MASK, VREDAND_VS, 0x7 }, // 7580
  { PseudoVREDMAXU_VS_M1, VREDMAXU_VS, 0x0 }, // 7581
  { PseudoVREDMAXU_VS_M1_MASK, VREDMAXU_VS, 0x0 }, // 7582
  { PseudoVREDMAXU_VS_M2, VREDMAXU_VS, 0x1 }, // 7583
  { PseudoVREDMAXU_VS_M2_MASK, VREDMAXU_VS, 0x1 }, // 7584
  { PseudoVREDMAXU_VS_M4, VREDMAXU_VS, 0x2 }, // 7585
  { PseudoVREDMAXU_VS_M4_MASK, VREDMAXU_VS, 0x2 }, // 7586
  { PseudoVREDMAXU_VS_M8, VREDMAXU_VS, 0x3 }, // 7587
  { PseudoVREDMAXU_VS_M8_MASK, VREDMAXU_VS, 0x3 }, // 7588
  { PseudoVREDMAXU_VS_MF8, VREDMAXU_VS, 0x5 }, // 7589
  { PseudoVREDMAXU_VS_MF8_MASK, VREDMAXU_VS, 0x5 }, // 7590
  { PseudoVREDMAXU_VS_MF4, VREDMAXU_VS, 0x6 }, // 7591
  { PseudoVREDMAXU_VS_MF4_MASK, VREDMAXU_VS, 0x6 }, // 7592
  { PseudoVREDMAXU_VS_MF2, VREDMAXU_VS, 0x7 }, // 7593
  { PseudoVREDMAXU_VS_MF2_MASK, VREDMAXU_VS, 0x7 }, // 7594
  { PseudoVREDMAX_VS_M1, VREDMAX_VS, 0x0 }, // 7595
  { PseudoVREDMAX_VS_M1_MASK, VREDMAX_VS, 0x0 }, // 7596
  { PseudoVREDMAX_VS_M2, VREDMAX_VS, 0x1 }, // 7597
  { PseudoVREDMAX_VS_M2_MASK, VREDMAX_VS, 0x1 }, // 7598
  { PseudoVREDMAX_VS_M4, VREDMAX_VS, 0x2 }, // 7599
  { PseudoVREDMAX_VS_M4_MASK, VREDMAX_VS, 0x2 }, // 7600
  { PseudoVREDMAX_VS_M8, VREDMAX_VS, 0x3 }, // 7601
  { PseudoVREDMAX_VS_M8_MASK, VREDMAX_VS, 0x3 }, // 7602
  { PseudoVREDMAX_VS_MF8, VREDMAX_VS, 0x5 }, // 7603
  { PseudoVREDMAX_VS_MF8_MASK, VREDMAX_VS, 0x5 }, // 7604
  { PseudoVREDMAX_VS_MF4, VREDMAX_VS, 0x6 }, // 7605
  { PseudoVREDMAX_VS_MF4_MASK, VREDMAX_VS, 0x6 }, // 7606
  { PseudoVREDMAX_VS_MF2, VREDMAX_VS, 0x7 }, // 7607
  { PseudoVREDMAX_VS_MF2_MASK, VREDMAX_VS, 0x7 }, // 7608
  { PseudoVREDMINU_VS_M1, VREDMINU_VS, 0x0 }, // 7609
  { PseudoVREDMINU_VS_M1_MASK, VREDMINU_VS, 0x0 }, // 7610
  { PseudoVREDMINU_VS_M2, VREDMINU_VS, 0x1 }, // 7611
  { PseudoVREDMINU_VS_M2_MASK, VREDMINU_VS, 0x1 }, // 7612
  { PseudoVREDMINU_VS_M4, VREDMINU_VS, 0x2 }, // 7613
  { PseudoVREDMINU_VS_M4_MASK, VREDMINU_VS, 0x2 }, // 7614
  { PseudoVREDMINU_VS_M8, VREDMINU_VS, 0x3 }, // 7615
  { PseudoVREDMINU_VS_M8_MASK, VREDMINU_VS, 0x3 }, // 7616
  { PseudoVREDMINU_VS_MF8, VREDMINU_VS, 0x5 }, // 7617
  { PseudoVREDMINU_VS_MF8_MASK, VREDMINU_VS, 0x5 }, // 7618
  { PseudoVREDMINU_VS_MF4, VREDMINU_VS, 0x6 }, // 7619
  { PseudoVREDMINU_VS_MF4_MASK, VREDMINU_VS, 0x6 }, // 7620
  { PseudoVREDMINU_VS_MF2, VREDMINU_VS, 0x7 }, // 7621
  { PseudoVREDMINU_VS_MF2_MASK, VREDMINU_VS, 0x7 }, // 7622
  { PseudoVREDMIN_VS_M1, VREDMIN_VS, 0x0 }, // 7623
  { PseudoVREDMIN_VS_M1_MASK, VREDMIN_VS, 0x0 }, // 7624
  { PseudoVREDMIN_VS_M2, VREDMIN_VS, 0x1 }, // 7625
  { PseudoVREDMIN_VS_M2_MASK, VREDMIN_VS, 0x1 }, // 7626
  { PseudoVREDMIN_VS_M4, VREDMIN_VS, 0x2 }, // 7627
  { PseudoVREDMIN_VS_M4_MASK, VREDMIN_VS, 0x2 }, // 7628
  { PseudoVREDMIN_VS_M8, VREDMIN_VS, 0x3 }, // 7629
  { PseudoVREDMIN_VS_M8_MASK, VREDMIN_VS, 0x3 }, // 7630
  { PseudoVREDMIN_VS_MF8, VREDMIN_VS, 0x5 }, // 7631
  { PseudoVREDMIN_VS_MF8_MASK, VREDMIN_VS, 0x5 }, // 7632
  { PseudoVREDMIN_VS_MF4, VREDMIN_VS, 0x6 }, // 7633
  { PseudoVREDMIN_VS_MF4_MASK, VREDMIN_VS, 0x6 }, // 7634
  { PseudoVREDMIN_VS_MF2, VREDMIN_VS, 0x7 }, // 7635
  { PseudoVREDMIN_VS_MF2_MASK, VREDMIN_VS, 0x7 }, // 7636
  { PseudoVREDOR_VS_M1, VREDOR_VS, 0x0 }, // 7637
  { PseudoVREDOR_VS_M1_MASK, VREDOR_VS, 0x0 }, // 7638
  { PseudoVREDOR_VS_M2, VREDOR_VS, 0x1 }, // 7639
  { PseudoVREDOR_VS_M2_MASK, VREDOR_VS, 0x1 }, // 7640
  { PseudoVREDOR_VS_M4, VREDOR_VS, 0x2 }, // 7641
  { PseudoVREDOR_VS_M4_MASK, VREDOR_VS, 0x2 }, // 7642
  { PseudoVREDOR_VS_M8, VREDOR_VS, 0x3 }, // 7643
  { PseudoVREDOR_VS_M8_MASK, VREDOR_VS, 0x3 }, // 7644
  { PseudoVREDOR_VS_MF8, VREDOR_VS, 0x5 }, // 7645
  { PseudoVREDOR_VS_MF8_MASK, VREDOR_VS, 0x5 }, // 7646
  { PseudoVREDOR_VS_MF4, VREDOR_VS, 0x6 }, // 7647
  { PseudoVREDOR_VS_MF4_MASK, VREDOR_VS, 0x6 }, // 7648
  { PseudoVREDOR_VS_MF2, VREDOR_VS, 0x7 }, // 7649
  { PseudoVREDOR_VS_MF2_MASK, VREDOR_VS, 0x7 }, // 7650
  { PseudoVREDSUM_VS_M1, VREDSUM_VS, 0x0 }, // 7651
  { PseudoVREDSUM_VS_M1_MASK, VREDSUM_VS, 0x0 }, // 7652
  { PseudoVREDSUM_VS_M2, VREDSUM_VS, 0x1 }, // 7653
  { PseudoVREDSUM_VS_M2_MASK, VREDSUM_VS, 0x1 }, // 7654
  { PseudoVREDSUM_VS_M4, VREDSUM_VS, 0x2 }, // 7655
  { PseudoVREDSUM_VS_M4_MASK, VREDSUM_VS, 0x2 }, // 7656
  { PseudoVREDSUM_VS_M8, VREDSUM_VS, 0x3 }, // 7657
  { PseudoVREDSUM_VS_M8_MASK, VREDSUM_VS, 0x3 }, // 7658
  { PseudoVREDSUM_VS_MF8, VREDSUM_VS, 0x5 }, // 7659
  { PseudoVREDSUM_VS_MF8_MASK, VREDSUM_VS, 0x5 }, // 7660
  { PseudoVREDSUM_VS_MF4, VREDSUM_VS, 0x6 }, // 7661
  { PseudoVREDSUM_VS_MF4_MASK, VREDSUM_VS, 0x6 }, // 7662
  { PseudoVREDSUM_VS_MF2, VREDSUM_VS, 0x7 }, // 7663
  { PseudoVREDSUM_VS_MF2_MASK, VREDSUM_VS, 0x7 }, // 7664
  { PseudoVREDXOR_VS_M1, VREDXOR_VS, 0x0 }, // 7665
  { PseudoVREDXOR_VS_M1_MASK, VREDXOR_VS, 0x0 }, // 7666
  { PseudoVREDXOR_VS_M2, VREDXOR_VS, 0x1 }, // 7667
  { PseudoVREDXOR_VS_M2_MASK, VREDXOR_VS, 0x1 }, // 7668
  { PseudoVREDXOR_VS_M4, VREDXOR_VS, 0x2 }, // 7669
  { PseudoVREDXOR_VS_M4_MASK, VREDXOR_VS, 0x2 }, // 7670
  { PseudoVREDXOR_VS_M8, VREDXOR_VS, 0x3 }, // 7671
  { PseudoVREDXOR_VS_M8_MASK, VREDXOR_VS, 0x3 }, // 7672
  { PseudoVREDXOR_VS_MF8, VREDXOR_VS, 0x5 }, // 7673
  { PseudoVREDXOR_VS_MF8_MASK, VREDXOR_VS, 0x5 }, // 7674
  { PseudoVREDXOR_VS_MF4, VREDXOR_VS, 0x6 }, // 7675
  { PseudoVREDXOR_VS_MF4_MASK, VREDXOR_VS, 0x6 }, // 7676
  { PseudoVREDXOR_VS_MF2, VREDXOR_VS, 0x7 }, // 7677
  { PseudoVREDXOR_VS_MF2_MASK, VREDXOR_VS, 0x7 }, // 7678
  { PseudoVREMU_VV_M1, VREMU_VV, 0x0 }, // 7679
  { PseudoVREMU_VV_M1_MASK, VREMU_VV, 0x0 }, // 7680
  { PseudoVREMU_VV_M1_TU, VREMU_VV, 0x0 }, // 7681
  { PseudoVREMU_VV_M2, VREMU_VV, 0x1 }, // 7682
  { PseudoVREMU_VV_M2_MASK, VREMU_VV, 0x1 }, // 7683
  { PseudoVREMU_VV_M2_TU, VREMU_VV, 0x1 }, // 7684
  { PseudoVREMU_VV_M4, VREMU_VV, 0x2 }, // 7685
  { PseudoVREMU_VV_M4_MASK, VREMU_VV, 0x2 }, // 7686
  { PseudoVREMU_VV_M4_TU, VREMU_VV, 0x2 }, // 7687
  { PseudoVREMU_VV_M8, VREMU_VV, 0x3 }, // 7688
  { PseudoVREMU_VV_M8_MASK, VREMU_VV, 0x3 }, // 7689
  { PseudoVREMU_VV_M8_TU, VREMU_VV, 0x3 }, // 7690
  { PseudoVREMU_VV_MF8, VREMU_VV, 0x5 }, // 7691
  { PseudoVREMU_VV_MF8_MASK, VREMU_VV, 0x5 }, // 7692
  { PseudoVREMU_VV_MF8_TU, VREMU_VV, 0x5 }, // 7693
  { PseudoVREMU_VV_MF4, VREMU_VV, 0x6 }, // 7694
  { PseudoVREMU_VV_MF4_MASK, VREMU_VV, 0x6 }, // 7695
  { PseudoVREMU_VV_MF4_TU, VREMU_VV, 0x6 }, // 7696
  { PseudoVREMU_VV_MF2, VREMU_VV, 0x7 }, // 7697
  { PseudoVREMU_VV_MF2_MASK, VREMU_VV, 0x7 }, // 7698
  { PseudoVREMU_VV_MF2_TU, VREMU_VV, 0x7 }, // 7699
  { PseudoVREMU_VX_M1, VREMU_VX, 0x0 }, // 7700
  { PseudoVREMU_VX_M1_MASK, VREMU_VX, 0x0 }, // 7701
  { PseudoVREMU_VX_M1_TU, VREMU_VX, 0x0 }, // 7702
  { PseudoVREMU_VX_M2, VREMU_VX, 0x1 }, // 7703
  { PseudoVREMU_VX_M2_MASK, VREMU_VX, 0x1 }, // 7704
  { PseudoVREMU_VX_M2_TU, VREMU_VX, 0x1 }, // 7705
  { PseudoVREMU_VX_M4, VREMU_VX, 0x2 }, // 7706
  { PseudoVREMU_VX_M4_MASK, VREMU_VX, 0x2 }, // 7707
  { PseudoVREMU_VX_M4_TU, VREMU_VX, 0x2 }, // 7708
  { PseudoVREMU_VX_M8, VREMU_VX, 0x3 }, // 7709
  { PseudoVREMU_VX_M8_MASK, VREMU_VX, 0x3 }, // 7710
  { PseudoVREMU_VX_M8_TU, VREMU_VX, 0x3 }, // 7711
  { PseudoVREMU_VX_MF8, VREMU_VX, 0x5 }, // 7712
  { PseudoVREMU_VX_MF8_MASK, VREMU_VX, 0x5 }, // 7713
  { PseudoVREMU_VX_MF8_TU, VREMU_VX, 0x5 }, // 7714
  { PseudoVREMU_VX_MF4, VREMU_VX, 0x6 }, // 7715
  { PseudoVREMU_VX_MF4_MASK, VREMU_VX, 0x6 }, // 7716
  { PseudoVREMU_VX_MF4_TU, VREMU_VX, 0x6 }, // 7717
  { PseudoVREMU_VX_MF2, VREMU_VX, 0x7 }, // 7718
  { PseudoVREMU_VX_MF2_MASK, VREMU_VX, 0x7 }, // 7719
  { PseudoVREMU_VX_MF2_TU, VREMU_VX, 0x7 }, // 7720
  { PseudoVREM_VV_M1, VREM_VV, 0x0 }, // 7721
  { PseudoVREM_VV_M1_MASK, VREM_VV, 0x0 }, // 7722
  { PseudoVREM_VV_M1_TU, VREM_VV, 0x0 }, // 7723
  { PseudoVREM_VV_M2, VREM_VV, 0x1 }, // 7724
  { PseudoVREM_VV_M2_MASK, VREM_VV, 0x1 }, // 7725
  { PseudoVREM_VV_M2_TU, VREM_VV, 0x1 }, // 7726
  { PseudoVREM_VV_M4, VREM_VV, 0x2 }, // 7727
  { PseudoVREM_VV_M4_MASK, VREM_VV, 0x2 }, // 7728
  { PseudoVREM_VV_M4_TU, VREM_VV, 0x2 }, // 7729
  { PseudoVREM_VV_M8, VREM_VV, 0x3 }, // 7730
  { PseudoVREM_VV_M8_MASK, VREM_VV, 0x3 }, // 7731
  { PseudoVREM_VV_M8_TU, VREM_VV, 0x3 }, // 7732
  { PseudoVREM_VV_MF8, VREM_VV, 0x5 }, // 7733
  { PseudoVREM_VV_MF8_MASK, VREM_VV, 0x5 }, // 7734
  { PseudoVREM_VV_MF8_TU, VREM_VV, 0x5 }, // 7735
  { PseudoVREM_VV_MF4, VREM_VV, 0x6 }, // 7736
  { PseudoVREM_VV_MF4_MASK, VREM_VV, 0x6 }, // 7737
  { PseudoVREM_VV_MF4_TU, VREM_VV, 0x6 }, // 7738
  { PseudoVREM_VV_MF2, VREM_VV, 0x7 }, // 7739
  { PseudoVREM_VV_MF2_MASK, VREM_VV, 0x7 }, // 7740
  { PseudoVREM_VV_MF2_TU, VREM_VV, 0x7 }, // 7741
  { PseudoVREM_VX_M1, VREM_VX, 0x0 }, // 7742
  { PseudoVREM_VX_M1_MASK, VREM_VX, 0x0 }, // 7743
  { PseudoVREM_VX_M1_TU, VREM_VX, 0x0 }, // 7744
  { PseudoVREM_VX_M2, VREM_VX, 0x1 }, // 7745
  { PseudoVREM_VX_M2_MASK, VREM_VX, 0x1 }, // 7746
  { PseudoVREM_VX_M2_TU, VREM_VX, 0x1 }, // 7747
  { PseudoVREM_VX_M4, VREM_VX, 0x2 }, // 7748
  { PseudoVREM_VX_M4_MASK, VREM_VX, 0x2 }, // 7749
  { PseudoVREM_VX_M4_TU, VREM_VX, 0x2 }, // 7750
  { PseudoVREM_VX_M8, VREM_VX, 0x3 }, // 7751
  { PseudoVREM_VX_M8_MASK, VREM_VX, 0x3 }, // 7752
  { PseudoVREM_VX_M8_TU, VREM_VX, 0x3 }, // 7753
  { PseudoVREM_VX_MF8, VREM_VX, 0x5 }, // 7754
  { PseudoVREM_VX_MF8_MASK, VREM_VX, 0x5 }, // 7755
  { PseudoVREM_VX_MF8_TU, VREM_VX, 0x5 }, // 7756
  { PseudoVREM_VX_MF4, VREM_VX, 0x6 }, // 7757
  { PseudoVREM_VX_MF4_MASK, VREM_VX, 0x6 }, // 7758
  { PseudoVREM_VX_MF4_TU, VREM_VX, 0x6 }, // 7759
  { PseudoVREM_VX_MF2, VREM_VX, 0x7 }, // 7760
  { PseudoVREM_VX_MF2_MASK, VREM_VX, 0x7 }, // 7761
  { PseudoVREM_VX_MF2_TU, VREM_VX, 0x7 }, // 7762
  { PseudoVRGATHEREI16_VV_M1_M1, VRGATHEREI16_VV, 0x0 }, // 7763
  { PseudoVRGATHEREI16_VV_M1_M1_MASK, VRGATHEREI16_VV, 0x0 }, // 7764
  { PseudoVRGATHEREI16_VV_M1_M1_TU, VRGATHEREI16_VV, 0x0 }, // 7765
  { PseudoVRGATHEREI16_VV_M1_M2, VRGATHEREI16_VV, 0x0 }, // 7766
  { PseudoVRGATHEREI16_VV_M1_M2_MASK, VRGATHEREI16_VV, 0x0 }, // 7767
  { PseudoVRGATHEREI16_VV_M1_M2_TU, VRGATHEREI16_VV, 0x0 }, // 7768
  { PseudoVRGATHEREI16_VV_M1_MF2, VRGATHEREI16_VV, 0x0 }, // 7769
  { PseudoVRGATHEREI16_VV_M1_MF2_MASK, VRGATHEREI16_VV, 0x0 }, // 7770
  { PseudoVRGATHEREI16_VV_M1_MF2_TU, VRGATHEREI16_VV, 0x0 }, // 7771
  { PseudoVRGATHEREI16_VV_M1_MF4, VRGATHEREI16_VV, 0x0 }, // 7772
  { PseudoVRGATHEREI16_VV_M1_MF4_MASK, VRGATHEREI16_VV, 0x0 }, // 7773
  { PseudoVRGATHEREI16_VV_M1_MF4_TU, VRGATHEREI16_VV, 0x0 }, // 7774
  { PseudoVRGATHEREI16_VV_M2_M1, VRGATHEREI16_VV, 0x1 }, // 7775
  { PseudoVRGATHEREI16_VV_M2_M1_MASK, VRGATHEREI16_VV, 0x1 }, // 7776
  { PseudoVRGATHEREI16_VV_M2_M1_TU, VRGATHEREI16_VV, 0x1 }, // 7777
  { PseudoVRGATHEREI16_VV_M2_M2, VRGATHEREI16_VV, 0x1 }, // 7778
  { PseudoVRGATHEREI16_VV_M2_M2_MASK, VRGATHEREI16_VV, 0x1 }, // 7779
  { PseudoVRGATHEREI16_VV_M2_M2_TU, VRGATHEREI16_VV, 0x1 }, // 7780
  { PseudoVRGATHEREI16_VV_M2_M4, VRGATHEREI16_VV, 0x1 }, // 7781
  { PseudoVRGATHEREI16_VV_M2_M4_MASK, VRGATHEREI16_VV, 0x1 }, // 7782
  { PseudoVRGATHEREI16_VV_M2_M4_TU, VRGATHEREI16_VV, 0x1 }, // 7783
  { PseudoVRGATHEREI16_VV_M2_MF2, VRGATHEREI16_VV, 0x1 }, // 7784
  { PseudoVRGATHEREI16_VV_M2_MF2_MASK, VRGATHEREI16_VV, 0x1 }, // 7785
  { PseudoVRGATHEREI16_VV_M2_MF2_TU, VRGATHEREI16_VV, 0x1 }, // 7786
  { PseudoVRGATHEREI16_VV_M4_M1, VRGATHEREI16_VV, 0x2 }, // 7787
  { PseudoVRGATHEREI16_VV_M4_M1_MASK, VRGATHEREI16_VV, 0x2 }, // 7788
  { PseudoVRGATHEREI16_VV_M4_M1_TU, VRGATHEREI16_VV, 0x2 }, // 7789
  { PseudoVRGATHEREI16_VV_M4_M2, VRGATHEREI16_VV, 0x2 }, // 7790
  { PseudoVRGATHEREI16_VV_M4_M2_MASK, VRGATHEREI16_VV, 0x2 }, // 7791
  { PseudoVRGATHEREI16_VV_M4_M2_TU, VRGATHEREI16_VV, 0x2 }, // 7792
  { PseudoVRGATHEREI16_VV_M4_M4, VRGATHEREI16_VV, 0x2 }, // 7793
  { PseudoVRGATHEREI16_VV_M4_M4_MASK, VRGATHEREI16_VV, 0x2 }, // 7794
  { PseudoVRGATHEREI16_VV_M4_M4_TU, VRGATHEREI16_VV, 0x2 }, // 7795
  { PseudoVRGATHEREI16_VV_M4_M8, VRGATHEREI16_VV, 0x2 }, // 7796
  { PseudoVRGATHEREI16_VV_M4_M8_MASK, VRGATHEREI16_VV, 0x2 }, // 7797
  { PseudoVRGATHEREI16_VV_M4_M8_TU, VRGATHEREI16_VV, 0x2 }, // 7798
  { PseudoVRGATHEREI16_VV_M8_M2, VRGATHEREI16_VV, 0x3 }, // 7799
  { PseudoVRGATHEREI16_VV_M8_M2_MASK, VRGATHEREI16_VV, 0x3 }, // 7800
  { PseudoVRGATHEREI16_VV_M8_M2_TU, VRGATHEREI16_VV, 0x3 }, // 7801
  { PseudoVRGATHEREI16_VV_M8_M4, VRGATHEREI16_VV, 0x3 }, // 7802
  { PseudoVRGATHEREI16_VV_M8_M4_MASK, VRGATHEREI16_VV, 0x3 }, // 7803
  { PseudoVRGATHEREI16_VV_M8_M4_TU, VRGATHEREI16_VV, 0x3 }, // 7804
  { PseudoVRGATHEREI16_VV_M8_M8, VRGATHEREI16_VV, 0x3 }, // 7805
  { PseudoVRGATHEREI16_VV_M8_M8_MASK, VRGATHEREI16_VV, 0x3 }, // 7806
  { PseudoVRGATHEREI16_VV_M8_M8_TU, VRGATHEREI16_VV, 0x3 }, // 7807
  { PseudoVRGATHEREI16_VV_MF8_MF4, VRGATHEREI16_VV, 0x5 }, // 7808
  { PseudoVRGATHEREI16_VV_MF8_MF4_MASK, VRGATHEREI16_VV, 0x5 }, // 7809
  { PseudoVRGATHEREI16_VV_MF8_MF4_TU, VRGATHEREI16_VV, 0x5 }, // 7810
  { PseudoVRGATHEREI16_VV_MF8_MF8, VRGATHEREI16_VV, 0x5 }, // 7811
  { PseudoVRGATHEREI16_VV_MF8_MF8_MASK, VRGATHEREI16_VV, 0x5 }, // 7812
  { PseudoVRGATHEREI16_VV_MF8_MF8_TU, VRGATHEREI16_VV, 0x5 }, // 7813
  { PseudoVRGATHEREI16_VV_MF4_MF2, VRGATHEREI16_VV, 0x6 }, // 7814
  { PseudoVRGATHEREI16_VV_MF4_MF2_MASK, VRGATHEREI16_VV, 0x6 }, // 7815
  { PseudoVRGATHEREI16_VV_MF4_MF2_TU, VRGATHEREI16_VV, 0x6 }, // 7816
  { PseudoVRGATHEREI16_VV_MF4_MF4, VRGATHEREI16_VV, 0x6 }, // 7817
  { PseudoVRGATHEREI16_VV_MF4_MF4_MASK, VRGATHEREI16_VV, 0x6 }, // 7818
  { PseudoVRGATHEREI16_VV_MF4_MF4_TU, VRGATHEREI16_VV, 0x6 }, // 7819
  { PseudoVRGATHEREI16_VV_MF4_MF8, VRGATHEREI16_VV, 0x6 }, // 7820
  { PseudoVRGATHEREI16_VV_MF4_MF8_MASK, VRGATHEREI16_VV, 0x6 }, // 7821
  { PseudoVRGATHEREI16_VV_MF4_MF8_TU, VRGATHEREI16_VV, 0x6 }, // 7822
  { PseudoVRGATHEREI16_VV_MF2_M1, VRGATHEREI16_VV, 0x7 }, // 7823
  { PseudoVRGATHEREI16_VV_MF2_M1_MASK, VRGATHEREI16_VV, 0x7 }, // 7824
  { PseudoVRGATHEREI16_VV_MF2_M1_TU, VRGATHEREI16_VV, 0x7 }, // 7825
  { PseudoVRGATHEREI16_VV_MF2_MF2, VRGATHEREI16_VV, 0x7 }, // 7826
  { PseudoVRGATHEREI16_VV_MF2_MF2_MASK, VRGATHEREI16_VV, 0x7 }, // 7827
  { PseudoVRGATHEREI16_VV_MF2_MF2_TU, VRGATHEREI16_VV, 0x7 }, // 7828
  { PseudoVRGATHEREI16_VV_MF2_MF4, VRGATHEREI16_VV, 0x7 }, // 7829
  { PseudoVRGATHEREI16_VV_MF2_MF4_MASK, VRGATHEREI16_VV, 0x7 }, // 7830
  { PseudoVRGATHEREI16_VV_MF2_MF4_TU, VRGATHEREI16_VV, 0x7 }, // 7831
  { PseudoVRGATHEREI16_VV_MF2_MF8, VRGATHEREI16_VV, 0x7 }, // 7832
  { PseudoVRGATHEREI16_VV_MF2_MF8_MASK, VRGATHEREI16_VV, 0x7 }, // 7833
  { PseudoVRGATHEREI16_VV_MF2_MF8_TU, VRGATHEREI16_VV, 0x7 }, // 7834
  { PseudoVRGATHER_VI_M1, VRGATHER_VI, 0x0 }, // 7835
  { PseudoVRGATHER_VI_M1_MASK, VRGATHER_VI, 0x0 }, // 7836
  { PseudoVRGATHER_VI_M1_TU, VRGATHER_VI, 0x0 }, // 7837
  { PseudoVRGATHER_VI_M2, VRGATHER_VI, 0x1 }, // 7838
  { PseudoVRGATHER_VI_M2_MASK, VRGATHER_VI, 0x1 }, // 7839
  { PseudoVRGATHER_VI_M2_TU, VRGATHER_VI, 0x1 }, // 7840
  { PseudoVRGATHER_VI_M4, VRGATHER_VI, 0x2 }, // 7841
  { PseudoVRGATHER_VI_M4_MASK, VRGATHER_VI, 0x2 }, // 7842
  { PseudoVRGATHER_VI_M4_TU, VRGATHER_VI, 0x2 }, // 7843
  { PseudoVRGATHER_VI_M8, VRGATHER_VI, 0x3 }, // 7844
  { PseudoVRGATHER_VI_M8_MASK, VRGATHER_VI, 0x3 }, // 7845
  { PseudoVRGATHER_VI_M8_TU, VRGATHER_VI, 0x3 }, // 7846
  { PseudoVRGATHER_VI_MF8, VRGATHER_VI, 0x5 }, // 7847
  { PseudoVRGATHER_VI_MF8_MASK, VRGATHER_VI, 0x5 }, // 7848
  { PseudoVRGATHER_VI_MF8_TU, VRGATHER_VI, 0x5 }, // 7849
  { PseudoVRGATHER_VI_MF4, VRGATHER_VI, 0x6 }, // 7850
  { PseudoVRGATHER_VI_MF4_MASK, VRGATHER_VI, 0x6 }, // 7851
  { PseudoVRGATHER_VI_MF4_TU, VRGATHER_VI, 0x6 }, // 7852
  { PseudoVRGATHER_VI_MF2, VRGATHER_VI, 0x7 }, // 7853
  { PseudoVRGATHER_VI_MF2_MASK, VRGATHER_VI, 0x7 }, // 7854
  { PseudoVRGATHER_VI_MF2_TU, VRGATHER_VI, 0x7 }, // 7855
  { PseudoVRGATHER_VV_M1, VRGATHER_VV, 0x0 }, // 7856
  { PseudoVRGATHER_VV_M1_MASK, VRGATHER_VV, 0x0 }, // 7857
  { PseudoVRGATHER_VV_M1_TU, VRGATHER_VV, 0x0 }, // 7858
  { PseudoVRGATHER_VV_M2, VRGATHER_VV, 0x1 }, // 7859
  { PseudoVRGATHER_VV_M2_MASK, VRGATHER_VV, 0x1 }, // 7860
  { PseudoVRGATHER_VV_M2_TU, VRGATHER_VV, 0x1 }, // 7861
  { PseudoVRGATHER_VV_M4, VRGATHER_VV, 0x2 }, // 7862
  { PseudoVRGATHER_VV_M4_MASK, VRGATHER_VV, 0x2 }, // 7863
  { PseudoVRGATHER_VV_M4_TU, VRGATHER_VV, 0x2 }, // 7864
  { PseudoVRGATHER_VV_M8, VRGATHER_VV, 0x3 }, // 7865
  { PseudoVRGATHER_VV_M8_MASK, VRGATHER_VV, 0x3 }, // 7866
  { PseudoVRGATHER_VV_M8_TU, VRGATHER_VV, 0x3 }, // 7867
  { PseudoVRGATHER_VV_MF8, VRGATHER_VV, 0x5 }, // 7868
  { PseudoVRGATHER_VV_MF8_MASK, VRGATHER_VV, 0x5 }, // 7869
  { PseudoVRGATHER_VV_MF8_TU, VRGATHER_VV, 0x5 }, // 7870
  { PseudoVRGATHER_VV_MF4, VRGATHER_VV, 0x6 }, // 7871
  { PseudoVRGATHER_VV_MF4_MASK, VRGATHER_VV, 0x6 }, // 7872
  { PseudoVRGATHER_VV_MF4_TU, VRGATHER_VV, 0x6 }, // 7873
  { PseudoVRGATHER_VV_MF2, VRGATHER_VV, 0x7 }, // 7874
  { PseudoVRGATHER_VV_MF2_MASK, VRGATHER_VV, 0x7 }, // 7875
  { PseudoVRGATHER_VV_MF2_TU, VRGATHER_VV, 0x7 }, // 7876
  { PseudoVRGATHER_VX_M1, VRGATHER_VX, 0x0 }, // 7877
  { PseudoVRGATHER_VX_M1_MASK, VRGATHER_VX, 0x0 }, // 7878
  { PseudoVRGATHER_VX_M1_TU, VRGATHER_VX, 0x0 }, // 7879
  { PseudoVRGATHER_VX_M2, VRGATHER_VX, 0x1 }, // 7880
  { PseudoVRGATHER_VX_M2_MASK, VRGATHER_VX, 0x1 }, // 7881
  { PseudoVRGATHER_VX_M2_TU, VRGATHER_VX, 0x1 }, // 7882
  { PseudoVRGATHER_VX_M4, VRGATHER_VX, 0x2 }, // 7883
  { PseudoVRGATHER_VX_M4_MASK, VRGATHER_VX, 0x2 }, // 7884
  { PseudoVRGATHER_VX_M4_TU, VRGATHER_VX, 0x2 }, // 7885
  { PseudoVRGATHER_VX_M8, VRGATHER_VX, 0x3 }, // 7886
  { PseudoVRGATHER_VX_M8_MASK, VRGATHER_VX, 0x3 }, // 7887
  { PseudoVRGATHER_VX_M8_TU, VRGATHER_VX, 0x3 }, // 7888
  { PseudoVRGATHER_VX_MF8, VRGATHER_VX, 0x5 }, // 7889
  { PseudoVRGATHER_VX_MF8_MASK, VRGATHER_VX, 0x5 }, // 7890
  { PseudoVRGATHER_VX_MF8_TU, VRGATHER_VX, 0x5 }, // 7891
  { PseudoVRGATHER_VX_MF4, VRGATHER_VX, 0x6 }, // 7892
  { PseudoVRGATHER_VX_MF4_MASK, VRGATHER_VX, 0x6 }, // 7893
  { PseudoVRGATHER_VX_MF4_TU, VRGATHER_VX, 0x6 }, // 7894
  { PseudoVRGATHER_VX_MF2, VRGATHER_VX, 0x7 }, // 7895
  { PseudoVRGATHER_VX_MF2_MASK, VRGATHER_VX, 0x7 }, // 7896
  { PseudoVRGATHER_VX_MF2_TU, VRGATHER_VX, 0x7 }, // 7897
  { PseudoVRSUB_VI_M1, VRSUB_VI, 0x0 }, // 7898
  { PseudoVRSUB_VI_M1_MASK, VRSUB_VI, 0x0 }, // 7899
  { PseudoVRSUB_VI_M1_TU, VRSUB_VI, 0x0 }, // 7900
  { PseudoVRSUB_VI_M2, VRSUB_VI, 0x1 }, // 7901
  { PseudoVRSUB_VI_M2_MASK, VRSUB_VI, 0x1 }, // 7902
  { PseudoVRSUB_VI_M2_TU, VRSUB_VI, 0x1 }, // 7903
  { PseudoVRSUB_VI_M4, VRSUB_VI, 0x2 }, // 7904
  { PseudoVRSUB_VI_M4_MASK, VRSUB_VI, 0x2 }, // 7905
  { PseudoVRSUB_VI_M4_TU, VRSUB_VI, 0x2 }, // 7906
  { PseudoVRSUB_VI_M8, VRSUB_VI, 0x3 }, // 7907
  { PseudoVRSUB_VI_M8_MASK, VRSUB_VI, 0x3 }, // 7908
  { PseudoVRSUB_VI_M8_TU, VRSUB_VI, 0x3 }, // 7909
  { PseudoVRSUB_VI_MF8, VRSUB_VI, 0x5 }, // 7910
  { PseudoVRSUB_VI_MF8_MASK, VRSUB_VI, 0x5 }, // 7911
  { PseudoVRSUB_VI_MF8_TU, VRSUB_VI, 0x5 }, // 7912
  { PseudoVRSUB_VI_MF4, VRSUB_VI, 0x6 }, // 7913
  { PseudoVRSUB_VI_MF4_MASK, VRSUB_VI, 0x6 }, // 7914
  { PseudoVRSUB_VI_MF4_TU, VRSUB_VI, 0x6 }, // 7915
  { PseudoVRSUB_VI_MF2, VRSUB_VI, 0x7 }, // 7916
  { PseudoVRSUB_VI_MF2_MASK, VRSUB_VI, 0x7 }, // 7917
  { PseudoVRSUB_VI_MF2_TU, VRSUB_VI, 0x7 }, // 7918
  { PseudoVRSUB_VX_M1, VRSUB_VX, 0x0 }, // 7919
  { PseudoVRSUB_VX_M1_MASK, VRSUB_VX, 0x0 }, // 7920
  { PseudoVRSUB_VX_M1_TU, VRSUB_VX, 0x0 }, // 7921
  { PseudoVRSUB_VX_M2, VRSUB_VX, 0x1 }, // 7922
  { PseudoVRSUB_VX_M2_MASK, VRSUB_VX, 0x1 }, // 7923
  { PseudoVRSUB_VX_M2_TU, VRSUB_VX, 0x1 }, // 7924
  { PseudoVRSUB_VX_M4, VRSUB_VX, 0x2 }, // 7925
  { PseudoVRSUB_VX_M4_MASK, VRSUB_VX, 0x2 }, // 7926
  { PseudoVRSUB_VX_M4_TU, VRSUB_VX, 0x2 }, // 7927
  { PseudoVRSUB_VX_M8, VRSUB_VX, 0x3 }, // 7928
  { PseudoVRSUB_VX_M8_MASK, VRSUB_VX, 0x3 }, // 7929
  { PseudoVRSUB_VX_M8_TU, VRSUB_VX, 0x3 }, // 7930
  { PseudoVRSUB_VX_MF8, VRSUB_VX, 0x5 }, // 7931
  { PseudoVRSUB_VX_MF8_MASK, VRSUB_VX, 0x5 }, // 7932
  { PseudoVRSUB_VX_MF8_TU, VRSUB_VX, 0x5 }, // 7933
  { PseudoVRSUB_VX_MF4, VRSUB_VX, 0x6 }, // 7934
  { PseudoVRSUB_VX_MF4_MASK, VRSUB_VX, 0x6 }, // 7935
  { PseudoVRSUB_VX_MF4_TU, VRSUB_VX, 0x6 }, // 7936
  { PseudoVRSUB_VX_MF2, VRSUB_VX, 0x7 }, // 7937
  { PseudoVRSUB_VX_MF2_MASK, VRSUB_VX, 0x7 }, // 7938
  { PseudoVRSUB_VX_MF2_TU, VRSUB_VX, 0x7 }, // 7939
  { PseudoVSADDU_VI_M1, VSADDU_VI, 0x0 }, // 7940
  { PseudoVSADDU_VI_M1_MASK, VSADDU_VI, 0x0 }, // 7941
  { PseudoVSADDU_VI_M1_TU, VSADDU_VI, 0x0 }, // 7942
  { PseudoVSADDU_VI_M2, VSADDU_VI, 0x1 }, // 7943
  { PseudoVSADDU_VI_M2_MASK, VSADDU_VI, 0x1 }, // 7944
  { PseudoVSADDU_VI_M2_TU, VSADDU_VI, 0x1 }, // 7945
  { PseudoVSADDU_VI_M4, VSADDU_VI, 0x2 }, // 7946
  { PseudoVSADDU_VI_M4_MASK, VSADDU_VI, 0x2 }, // 7947
  { PseudoVSADDU_VI_M4_TU, VSADDU_VI, 0x2 }, // 7948
  { PseudoVSADDU_VI_M8, VSADDU_VI, 0x3 }, // 7949
  { PseudoVSADDU_VI_M8_MASK, VSADDU_VI, 0x3 }, // 7950
  { PseudoVSADDU_VI_M8_TU, VSADDU_VI, 0x3 }, // 7951
  { PseudoVSADDU_VI_MF8, VSADDU_VI, 0x5 }, // 7952
  { PseudoVSADDU_VI_MF8_MASK, VSADDU_VI, 0x5 }, // 7953
  { PseudoVSADDU_VI_MF8_TU, VSADDU_VI, 0x5 }, // 7954
  { PseudoVSADDU_VI_MF4, VSADDU_VI, 0x6 }, // 7955
  { PseudoVSADDU_VI_MF4_MASK, VSADDU_VI, 0x6 }, // 7956
  { PseudoVSADDU_VI_MF4_TU, VSADDU_VI, 0x6 }, // 7957
  { PseudoVSADDU_VI_MF2, VSADDU_VI, 0x7 }, // 7958
  { PseudoVSADDU_VI_MF2_MASK, VSADDU_VI, 0x7 }, // 7959
  { PseudoVSADDU_VI_MF2_TU, VSADDU_VI, 0x7 }, // 7960
  { PseudoVSADDU_VV_M1, VSADDU_VV, 0x0 }, // 7961
  { PseudoVSADDU_VV_M1_MASK, VSADDU_VV, 0x0 }, // 7962
  { PseudoVSADDU_VV_M1_TU, VSADDU_VV, 0x0 }, // 7963
  { PseudoVSADDU_VV_M2, VSADDU_VV, 0x1 }, // 7964
  { PseudoVSADDU_VV_M2_MASK, VSADDU_VV, 0x1 }, // 7965
  { PseudoVSADDU_VV_M2_TU, VSADDU_VV, 0x1 }, // 7966
  { PseudoVSADDU_VV_M4, VSADDU_VV, 0x2 }, // 7967
  { PseudoVSADDU_VV_M4_MASK, VSADDU_VV, 0x2 }, // 7968
  { PseudoVSADDU_VV_M4_TU, VSADDU_VV, 0x2 }, // 7969
  { PseudoVSADDU_VV_M8, VSADDU_VV, 0x3 }, // 7970
  { PseudoVSADDU_VV_M8_MASK, VSADDU_VV, 0x3 }, // 7971
  { PseudoVSADDU_VV_M8_TU, VSADDU_VV, 0x3 }, // 7972
  { PseudoVSADDU_VV_MF8, VSADDU_VV, 0x5 }, // 7973
  { PseudoVSADDU_VV_MF8_MASK, VSADDU_VV, 0x5 }, // 7974
  { PseudoVSADDU_VV_MF8_TU, VSADDU_VV, 0x5 }, // 7975
  { PseudoVSADDU_VV_MF4, VSADDU_VV, 0x6 }, // 7976
  { PseudoVSADDU_VV_MF4_MASK, VSADDU_VV, 0x6 }, // 7977
  { PseudoVSADDU_VV_MF4_TU, VSADDU_VV, 0x6 }, // 7978
  { PseudoVSADDU_VV_MF2, VSADDU_VV, 0x7 }, // 7979
  { PseudoVSADDU_VV_MF2_MASK, VSADDU_VV, 0x7 }, // 7980
  { PseudoVSADDU_VV_MF2_TU, VSADDU_VV, 0x7 }, // 7981
  { PseudoVSADDU_VX_M1, VSADDU_VX, 0x0 }, // 7982
  { PseudoVSADDU_VX_M1_MASK, VSADDU_VX, 0x0 }, // 7983
  { PseudoVSADDU_VX_M1_TU, VSADDU_VX, 0x0 }, // 7984
  { PseudoVSADDU_VX_M2, VSADDU_VX, 0x1 }, // 7985
  { PseudoVSADDU_VX_M2_MASK, VSADDU_VX, 0x1 }, // 7986
  { PseudoVSADDU_VX_M2_TU, VSADDU_VX, 0x1 }, // 7987
  { PseudoVSADDU_VX_M4, VSADDU_VX, 0x2 }, // 7988
  { PseudoVSADDU_VX_M4_MASK, VSADDU_VX, 0x2 }, // 7989
  { PseudoVSADDU_VX_M4_TU, VSADDU_VX, 0x2 }, // 7990
  { PseudoVSADDU_VX_M8, VSADDU_VX, 0x3 }, // 7991
  { PseudoVSADDU_VX_M8_MASK, VSADDU_VX, 0x3 }, // 7992
  { PseudoVSADDU_VX_M8_TU, VSADDU_VX, 0x3 }, // 7993
  { PseudoVSADDU_VX_MF8, VSADDU_VX, 0x5 }, // 7994
  { PseudoVSADDU_VX_MF8_MASK, VSADDU_VX, 0x5 }, // 7995
  { PseudoVSADDU_VX_MF8_TU, VSADDU_VX, 0x5 }, // 7996
  { PseudoVSADDU_VX_MF4, VSADDU_VX, 0x6 }, // 7997
  { PseudoVSADDU_VX_MF4_MASK, VSADDU_VX, 0x6 }, // 7998
  { PseudoVSADDU_VX_MF4_TU, VSADDU_VX, 0x6 }, // 7999
  { PseudoVSADDU_VX_MF2, VSADDU_VX, 0x7 }, // 8000
  { PseudoVSADDU_VX_MF2_MASK, VSADDU_VX, 0x7 }, // 8001
  { PseudoVSADDU_VX_MF2_TU, VSADDU_VX, 0x7 }, // 8002
  { PseudoVSADD_VI_M1, VSADD_VI, 0x0 }, // 8003
  { PseudoVSADD_VI_M1_MASK, VSADD_VI, 0x0 }, // 8004
  { PseudoVSADD_VI_M1_TU, VSADD_VI, 0x0 }, // 8005
  { PseudoVSADD_VI_M2, VSADD_VI, 0x1 }, // 8006
  { PseudoVSADD_VI_M2_MASK, VSADD_VI, 0x1 }, // 8007
  { PseudoVSADD_VI_M2_TU, VSADD_VI, 0x1 }, // 8008
  { PseudoVSADD_VI_M4, VSADD_VI, 0x2 }, // 8009
  { PseudoVSADD_VI_M4_MASK, VSADD_VI, 0x2 }, // 8010
  { PseudoVSADD_VI_M4_TU, VSADD_VI, 0x2 }, // 8011
  { PseudoVSADD_VI_M8, VSADD_VI, 0x3 }, // 8012
  { PseudoVSADD_VI_M8_MASK, VSADD_VI, 0x3 }, // 8013
  { PseudoVSADD_VI_M8_TU, VSADD_VI, 0x3 }, // 8014
  { PseudoVSADD_VI_MF8, VSADD_VI, 0x5 }, // 8015
  { PseudoVSADD_VI_MF8_MASK, VSADD_VI, 0x5 }, // 8016
  { PseudoVSADD_VI_MF8_TU, VSADD_VI, 0x5 }, // 8017
  { PseudoVSADD_VI_MF4, VSADD_VI, 0x6 }, // 8018
  { PseudoVSADD_VI_MF4_MASK, VSADD_VI, 0x6 }, // 8019
  { PseudoVSADD_VI_MF4_TU, VSADD_VI, 0x6 }, // 8020
  { PseudoVSADD_VI_MF2, VSADD_VI, 0x7 }, // 8021
  { PseudoVSADD_VI_MF2_MASK, VSADD_VI, 0x7 }, // 8022
  { PseudoVSADD_VI_MF2_TU, VSADD_VI, 0x7 }, // 8023
  { PseudoVSADD_VV_M1, VSADD_VV, 0x0 }, // 8024
  { PseudoVSADD_VV_M1_MASK, VSADD_VV, 0x0 }, // 8025
  { PseudoVSADD_VV_M1_TU, VSADD_VV, 0x0 }, // 8026
  { PseudoVSADD_VV_M2, VSADD_VV, 0x1 }, // 8027
  { PseudoVSADD_VV_M2_MASK, VSADD_VV, 0x1 }, // 8028
  { PseudoVSADD_VV_M2_TU, VSADD_VV, 0x1 }, // 8029
  { PseudoVSADD_VV_M4, VSADD_VV, 0x2 }, // 8030
  { PseudoVSADD_VV_M4_MASK, VSADD_VV, 0x2 }, // 8031
  { PseudoVSADD_VV_M4_TU, VSADD_VV, 0x2 }, // 8032
  { PseudoVSADD_VV_M8, VSADD_VV, 0x3 }, // 8033
  { PseudoVSADD_VV_M8_MASK, VSADD_VV, 0x3 }, // 8034
  { PseudoVSADD_VV_M8_TU, VSADD_VV, 0x3 }, // 8035
  { PseudoVSADD_VV_MF8, VSADD_VV, 0x5 }, // 8036
  { PseudoVSADD_VV_MF8_MASK, VSADD_VV, 0x5 }, // 8037
  { PseudoVSADD_VV_MF8_TU, VSADD_VV, 0x5 }, // 8038
  { PseudoVSADD_VV_MF4, VSADD_VV, 0x6 }, // 8039
  { PseudoVSADD_VV_MF4_MASK, VSADD_VV, 0x6 }, // 8040
  { PseudoVSADD_VV_MF4_TU, VSADD_VV, 0x6 }, // 8041
  { PseudoVSADD_VV_MF2, VSADD_VV, 0x7 }, // 8042
  { PseudoVSADD_VV_MF2_MASK, VSADD_VV, 0x7 }, // 8043
  { PseudoVSADD_VV_MF2_TU, VSADD_VV, 0x7 }, // 8044
  { PseudoVSADD_VX_M1, VSADD_VX, 0x0 }, // 8045
  { PseudoVSADD_VX_M1_MASK, VSADD_VX, 0x0 }, // 8046
  { PseudoVSADD_VX_M1_TU, VSADD_VX, 0x0 }, // 8047
  { PseudoVSADD_VX_M2, VSADD_VX, 0x1 }, // 8048
  { PseudoVSADD_VX_M2_MASK, VSADD_VX, 0x1 }, // 8049
  { PseudoVSADD_VX_M2_TU, VSADD_VX, 0x1 }, // 8050
  { PseudoVSADD_VX_M4, VSADD_VX, 0x2 }, // 8051
  { PseudoVSADD_VX_M4_MASK, VSADD_VX, 0x2 }, // 8052
  { PseudoVSADD_VX_M4_TU, VSADD_VX, 0x2 }, // 8053
  { PseudoVSADD_VX_M8, VSADD_VX, 0x3 }, // 8054
  { PseudoVSADD_VX_M8_MASK, VSADD_VX, 0x3 }, // 8055
  { PseudoVSADD_VX_M8_TU, VSADD_VX, 0x3 }, // 8056
  { PseudoVSADD_VX_MF8, VSADD_VX, 0x5 }, // 8057
  { PseudoVSADD_VX_MF8_MASK, VSADD_VX, 0x5 }, // 8058
  { PseudoVSADD_VX_MF8_TU, VSADD_VX, 0x5 }, // 8059
  { PseudoVSADD_VX_MF4, VSADD_VX, 0x6 }, // 8060
  { PseudoVSADD_VX_MF4_MASK, VSADD_VX, 0x6 }, // 8061
  { PseudoVSADD_VX_MF4_TU, VSADD_VX, 0x6 }, // 8062
  { PseudoVSADD_VX_MF2, VSADD_VX, 0x7 }, // 8063
  { PseudoVSADD_VX_MF2_MASK, VSADD_VX, 0x7 }, // 8064
  { PseudoVSADD_VX_MF2_TU, VSADD_VX, 0x7 }, // 8065
  { PseudoVSBC_VVM_M1, VSBC_VVM, 0x0 }, // 8066
  { PseudoVSBC_VVM_M1_TU, VSBC_VVM, 0x0 }, // 8067
  { PseudoVSBC_VVM_M2, VSBC_VVM, 0x1 }, // 8068
  { PseudoVSBC_VVM_M2_TU, VSBC_VVM, 0x1 }, // 8069
  { PseudoVSBC_VVM_M4, VSBC_VVM, 0x2 }, // 8070
  { PseudoVSBC_VVM_M4_TU, VSBC_VVM, 0x2 }, // 8071
  { PseudoVSBC_VVM_M8, VSBC_VVM, 0x3 }, // 8072
  { PseudoVSBC_VVM_M8_TU, VSBC_VVM, 0x3 }, // 8073
  { PseudoVSBC_VVM_MF8, VSBC_VVM, 0x5 }, // 8074
  { PseudoVSBC_VVM_MF8_TU, VSBC_VVM, 0x5 }, // 8075
  { PseudoVSBC_VVM_MF4, VSBC_VVM, 0x6 }, // 8076
  { PseudoVSBC_VVM_MF4_TU, VSBC_VVM, 0x6 }, // 8077
  { PseudoVSBC_VVM_MF2, VSBC_VVM, 0x7 }, // 8078
  { PseudoVSBC_VVM_MF2_TU, VSBC_VVM, 0x7 }, // 8079
  { PseudoVSBC_VXM_M1, VSBC_VXM, 0x0 }, // 8080
  { PseudoVSBC_VXM_M1_TU, VSBC_VXM, 0x0 }, // 8081
  { PseudoVSBC_VXM_M2, VSBC_VXM, 0x1 }, // 8082
  { PseudoVSBC_VXM_M2_TU, VSBC_VXM, 0x1 }, // 8083
  { PseudoVSBC_VXM_M4, VSBC_VXM, 0x2 }, // 8084
  { PseudoVSBC_VXM_M4_TU, VSBC_VXM, 0x2 }, // 8085
  { PseudoVSBC_VXM_M8, VSBC_VXM, 0x3 }, // 8086
  { PseudoVSBC_VXM_M8_TU, VSBC_VXM, 0x3 }, // 8087
  { PseudoVSBC_VXM_MF8, VSBC_VXM, 0x5 }, // 8088
  { PseudoVSBC_VXM_MF8_TU, VSBC_VXM, 0x5 }, // 8089
  { PseudoVSBC_VXM_MF4, VSBC_VXM, 0x6 }, // 8090
  { PseudoVSBC_VXM_MF4_TU, VSBC_VXM, 0x6 }, // 8091
  { PseudoVSBC_VXM_MF2, VSBC_VXM, 0x7 }, // 8092
  { PseudoVSBC_VXM_MF2_TU, VSBC_VXM, 0x7 }, // 8093
  { PseudoVSE16_V_M1, VSE16_V, 0x0 }, // 8094
  { PseudoVSE16_V_M1_MASK, VSE16_V, 0x0 }, // 8095
  { PseudoVSE16_V_M2, VSE16_V, 0x1 }, // 8096
  { PseudoVSE16_V_M2_MASK, VSE16_V, 0x1 }, // 8097
  { PseudoVSE16_V_M4, VSE16_V, 0x2 }, // 8098
  { PseudoVSE16_V_M4_MASK, VSE16_V, 0x2 }, // 8099
  { PseudoVSE16_V_M8, VSE16_V, 0x3 }, // 8100
  { PseudoVSE16_V_M8_MASK, VSE16_V, 0x3 }, // 8101
  { PseudoVSE16_V_MF4, VSE16_V, 0x6 }, // 8102
  { PseudoVSE16_V_MF4_MASK, VSE16_V, 0x6 }, // 8103
  { PseudoVSE16_V_MF2, VSE16_V, 0x7 }, // 8104
  { PseudoVSE16_V_MF2_MASK, VSE16_V, 0x7 }, // 8105
  { PseudoVSE32_V_M1, VSE32_V, 0x0 }, // 8106
  { PseudoVSE32_V_M1_MASK, VSE32_V, 0x0 }, // 8107
  { PseudoVSE32_V_M2, VSE32_V, 0x1 }, // 8108
  { PseudoVSE32_V_M2_MASK, VSE32_V, 0x1 }, // 8109
  { PseudoVSE32_V_M4, VSE32_V, 0x2 }, // 8110
  { PseudoVSE32_V_M4_MASK, VSE32_V, 0x2 }, // 8111
  { PseudoVSE32_V_M8, VSE32_V, 0x3 }, // 8112
  { PseudoVSE32_V_M8_MASK, VSE32_V, 0x3 }, // 8113
  { PseudoVSE32_V_MF2, VSE32_V, 0x7 }, // 8114
  { PseudoVSE32_V_MF2_MASK, VSE32_V, 0x7 }, // 8115
  { PseudoVSE64_V_M1, VSE64_V, 0x0 }, // 8116
  { PseudoVSE64_V_M1_MASK, VSE64_V, 0x0 }, // 8117
  { PseudoVSE64_V_M2, VSE64_V, 0x1 }, // 8118
  { PseudoVSE64_V_M2_MASK, VSE64_V, 0x1 }, // 8119
  { PseudoVSE64_V_M4, VSE64_V, 0x2 }, // 8120
  { PseudoVSE64_V_M4_MASK, VSE64_V, 0x2 }, // 8121
  { PseudoVSE64_V_M8, VSE64_V, 0x3 }, // 8122
  { PseudoVSE64_V_M8_MASK, VSE64_V, 0x3 }, // 8123
  { PseudoVSE8_V_M1, VSE8_V, 0x0 }, // 8124
  { PseudoVSE8_V_M1_MASK, VSE8_V, 0x0 }, // 8125
  { PseudoVSE8_V_M2, VSE8_V, 0x1 }, // 8126
  { PseudoVSE8_V_M2_MASK, VSE8_V, 0x1 }, // 8127
  { PseudoVSE8_V_M4, VSE8_V, 0x2 }, // 8128
  { PseudoVSE8_V_M4_MASK, VSE8_V, 0x2 }, // 8129
  { PseudoVSE8_V_M8, VSE8_V, 0x3 }, // 8130
  { PseudoVSE8_V_M8_MASK, VSE8_V, 0x3 }, // 8131
  { PseudoVSE8_V_MF8, VSE8_V, 0x5 }, // 8132
  { PseudoVSE8_V_MF8_MASK, VSE8_V, 0x5 }, // 8133
  { PseudoVSE8_V_MF4, VSE8_V, 0x6 }, // 8134
  { PseudoVSE8_V_MF4_MASK, VSE8_V, 0x6 }, // 8135
  { PseudoVSE8_V_MF2, VSE8_V, 0x7 }, // 8136
  { PseudoVSE8_V_MF2_MASK, VSE8_V, 0x7 }, // 8137
  { PseudoVSEXT_VF2_M1, VSEXT_VF2, 0x0 }, // 8138
  { PseudoVSEXT_VF2_M1_MASK, VSEXT_VF2, 0x0 }, // 8139
  { PseudoVSEXT_VF2_M1_TU, VSEXT_VF2, 0x0 }, // 8140
  { PseudoVSEXT_VF2_M2, VSEXT_VF2, 0x1 }, // 8141
  { PseudoVSEXT_VF2_M2_MASK, VSEXT_VF2, 0x1 }, // 8142
  { PseudoVSEXT_VF2_M2_TU, VSEXT_VF2, 0x1 }, // 8143
  { PseudoVSEXT_VF2_M4, VSEXT_VF2, 0x2 }, // 8144
  { PseudoVSEXT_VF2_M4_MASK, VSEXT_VF2, 0x2 }, // 8145
  { PseudoVSEXT_VF2_M4_TU, VSEXT_VF2, 0x2 }, // 8146
  { PseudoVSEXT_VF2_M8, VSEXT_VF2, 0x3 }, // 8147
  { PseudoVSEXT_VF2_M8_MASK, VSEXT_VF2, 0x3 }, // 8148
  { PseudoVSEXT_VF2_M8_TU, VSEXT_VF2, 0x3 }, // 8149
  { PseudoVSEXT_VF2_MF4, VSEXT_VF2, 0x6 }, // 8150
  { PseudoVSEXT_VF2_MF4_MASK, VSEXT_VF2, 0x6 }, // 8151
  { PseudoVSEXT_VF2_MF4_TU, VSEXT_VF2, 0x6 }, // 8152
  { PseudoVSEXT_VF2_MF2, VSEXT_VF2, 0x7 }, // 8153
  { PseudoVSEXT_VF2_MF2_MASK, VSEXT_VF2, 0x7 }, // 8154
  { PseudoVSEXT_VF2_MF2_TU, VSEXT_VF2, 0x7 }, // 8155
  { PseudoVSEXT_VF4_M1, VSEXT_VF4, 0x0 }, // 8156
  { PseudoVSEXT_VF4_M1_MASK, VSEXT_VF4, 0x0 }, // 8157
  { PseudoVSEXT_VF4_M1_TU, VSEXT_VF4, 0x0 }, // 8158
  { PseudoVSEXT_VF4_M2, VSEXT_VF4, 0x1 }, // 8159
  { PseudoVSEXT_VF4_M2_MASK, VSEXT_VF4, 0x1 }, // 8160
  { PseudoVSEXT_VF4_M2_TU, VSEXT_VF4, 0x1 }, // 8161
  { PseudoVSEXT_VF4_M4, VSEXT_VF4, 0x2 }, // 8162
  { PseudoVSEXT_VF4_M4_MASK, VSEXT_VF4, 0x2 }, // 8163
  { PseudoVSEXT_VF4_M4_TU, VSEXT_VF4, 0x2 }, // 8164
  { PseudoVSEXT_VF4_M8, VSEXT_VF4, 0x3 }, // 8165
  { PseudoVSEXT_VF4_M8_MASK, VSEXT_VF4, 0x3 }, // 8166
  { PseudoVSEXT_VF4_M8_TU, VSEXT_VF4, 0x3 }, // 8167
  { PseudoVSEXT_VF4_MF2, VSEXT_VF4, 0x7 }, // 8168
  { PseudoVSEXT_VF4_MF2_MASK, VSEXT_VF4, 0x7 }, // 8169
  { PseudoVSEXT_VF4_MF2_TU, VSEXT_VF4, 0x7 }, // 8170
  { PseudoVSEXT_VF8_M1, VSEXT_VF8, 0x0 }, // 8171
  { PseudoVSEXT_VF8_M1_MASK, VSEXT_VF8, 0x0 }, // 8172
  { PseudoVSEXT_VF8_M1_TU, VSEXT_VF8, 0x0 }, // 8173
  { PseudoVSEXT_VF8_M2, VSEXT_VF8, 0x1 }, // 8174
  { PseudoVSEXT_VF8_M2_MASK, VSEXT_VF8, 0x1 }, // 8175
  { PseudoVSEXT_VF8_M2_TU, VSEXT_VF8, 0x1 }, // 8176
  { PseudoVSEXT_VF8_M4, VSEXT_VF8, 0x2 }, // 8177
  { PseudoVSEXT_VF8_M4_MASK, VSEXT_VF8, 0x2 }, // 8178
  { PseudoVSEXT_VF8_M4_TU, VSEXT_VF8, 0x2 }, // 8179
  { PseudoVSEXT_VF8_M8, VSEXT_VF8, 0x3 }, // 8180
  { PseudoVSEXT_VF8_M8_MASK, VSEXT_VF8, 0x3 }, // 8181
  { PseudoVSEXT_VF8_M8_TU, VSEXT_VF8, 0x3 }, // 8182
  { PseudoVSLIDE1DOWN_VX_M1, VSLIDE1DOWN_VX, 0x0 }, // 8183
  { PseudoVSLIDE1DOWN_VX_M1_MASK, VSLIDE1DOWN_VX, 0x0 }, // 8184
  { PseudoVSLIDE1DOWN_VX_M1_TU, VSLIDE1DOWN_VX, 0x0 }, // 8185
  { PseudoVSLIDE1DOWN_VX_M2, VSLIDE1DOWN_VX, 0x1 }, // 8186
  { PseudoVSLIDE1DOWN_VX_M2_MASK, VSLIDE1DOWN_VX, 0x1 }, // 8187
  { PseudoVSLIDE1DOWN_VX_M2_TU, VSLIDE1DOWN_VX, 0x1 }, // 8188
  { PseudoVSLIDE1DOWN_VX_M4, VSLIDE1DOWN_VX, 0x2 }, // 8189
  { PseudoVSLIDE1DOWN_VX_M4_MASK, VSLIDE1DOWN_VX, 0x2 }, // 8190
  { PseudoVSLIDE1DOWN_VX_M4_TU, VSLIDE1DOWN_VX, 0x2 }, // 8191
  { PseudoVSLIDE1DOWN_VX_M8, VSLIDE1DOWN_VX, 0x3 }, // 8192
  { PseudoVSLIDE1DOWN_VX_M8_MASK, VSLIDE1DOWN_VX, 0x3 }, // 8193
  { PseudoVSLIDE1DOWN_VX_M8_TU, VSLIDE1DOWN_VX, 0x3 }, // 8194
  { PseudoVSLIDE1DOWN_VX_MF8, VSLIDE1DOWN_VX, 0x5 }, // 8195
  { PseudoVSLIDE1DOWN_VX_MF8_MASK, VSLIDE1DOWN_VX, 0x5 }, // 8196
  { PseudoVSLIDE1DOWN_VX_MF8_TU, VSLIDE1DOWN_VX, 0x5 }, // 8197
  { PseudoVSLIDE1DOWN_VX_MF4, VSLIDE1DOWN_VX, 0x6 }, // 8198
  { PseudoVSLIDE1DOWN_VX_MF4_MASK, VSLIDE1DOWN_VX, 0x6 }, // 8199
  { PseudoVSLIDE1DOWN_VX_MF4_TU, VSLIDE1DOWN_VX, 0x6 }, // 8200
  { PseudoVSLIDE1DOWN_VX_MF2, VSLIDE1DOWN_VX, 0x7 }, // 8201
  { PseudoVSLIDE1DOWN_VX_MF2_MASK, VSLIDE1DOWN_VX, 0x7 }, // 8202
  { PseudoVSLIDE1DOWN_VX_MF2_TU, VSLIDE1DOWN_VX, 0x7 }, // 8203
  { PseudoVSLIDE1UP_VX_M1, VSLIDE1UP_VX, 0x0 }, // 8204
  { PseudoVSLIDE1UP_VX_M1_MASK, VSLIDE1UP_VX, 0x0 }, // 8205
  { PseudoVSLIDE1UP_VX_M1_TU, VSLIDE1UP_VX, 0x0 }, // 8206
  { PseudoVSLIDE1UP_VX_M2, VSLIDE1UP_VX, 0x1 }, // 8207
  { PseudoVSLIDE1UP_VX_M2_MASK, VSLIDE1UP_VX, 0x1 }, // 8208
  { PseudoVSLIDE1UP_VX_M2_TU, VSLIDE1UP_VX, 0x1 }, // 8209
  { PseudoVSLIDE1UP_VX_M4, VSLIDE1UP_VX, 0x2 }, // 8210
  { PseudoVSLIDE1UP_VX_M4_MASK, VSLIDE1UP_VX, 0x2 }, // 8211
  { PseudoVSLIDE1UP_VX_M4_TU, VSLIDE1UP_VX, 0x2 }, // 8212
  { PseudoVSLIDE1UP_VX_M8, VSLIDE1UP_VX, 0x3 }, // 8213
  { PseudoVSLIDE1UP_VX_M8_MASK, VSLIDE1UP_VX, 0x3 }, // 8214
  { PseudoVSLIDE1UP_VX_M8_TU, VSLIDE1UP_VX, 0x3 }, // 8215
  { PseudoVSLIDE1UP_VX_MF8, VSLIDE1UP_VX, 0x5 }, // 8216
  { PseudoVSLIDE1UP_VX_MF8_MASK, VSLIDE1UP_VX, 0x5 }, // 8217
  { PseudoVSLIDE1UP_VX_MF8_TU, VSLIDE1UP_VX, 0x5 }, // 8218
  { PseudoVSLIDE1UP_VX_MF4, VSLIDE1UP_VX, 0x6 }, // 8219
  { PseudoVSLIDE1UP_VX_MF4_MASK, VSLIDE1UP_VX, 0x6 }, // 8220
  { PseudoVSLIDE1UP_VX_MF4_TU, VSLIDE1UP_VX, 0x6 }, // 8221
  { PseudoVSLIDE1UP_VX_MF2, VSLIDE1UP_VX, 0x7 }, // 8222
  { PseudoVSLIDE1UP_VX_MF2_MASK, VSLIDE1UP_VX, 0x7 }, // 8223
  { PseudoVSLIDE1UP_VX_MF2_TU, VSLIDE1UP_VX, 0x7 }, // 8224
  { PseudoVSLIDEDOWN_VI_M1, VSLIDEDOWN_VI, 0x0 }, // 8225
  { PseudoVSLIDEDOWN_VI_M1_MASK, VSLIDEDOWN_VI, 0x0 }, // 8226
  { PseudoVSLIDEDOWN_VI_M2, VSLIDEDOWN_VI, 0x1 }, // 8227
  { PseudoVSLIDEDOWN_VI_M2_MASK, VSLIDEDOWN_VI, 0x1 }, // 8228
  { PseudoVSLIDEDOWN_VI_M4, VSLIDEDOWN_VI, 0x2 }, // 8229
  { PseudoVSLIDEDOWN_VI_M4_MASK, VSLIDEDOWN_VI, 0x2 }, // 8230
  { PseudoVSLIDEDOWN_VI_M8, VSLIDEDOWN_VI, 0x3 }, // 8231
  { PseudoVSLIDEDOWN_VI_M8_MASK, VSLIDEDOWN_VI, 0x3 }, // 8232
  { PseudoVSLIDEDOWN_VI_MF8, VSLIDEDOWN_VI, 0x5 }, // 8233
  { PseudoVSLIDEDOWN_VI_MF8_MASK, VSLIDEDOWN_VI, 0x5 }, // 8234
  { PseudoVSLIDEDOWN_VI_MF4, VSLIDEDOWN_VI, 0x6 }, // 8235
  { PseudoVSLIDEDOWN_VI_MF4_MASK, VSLIDEDOWN_VI, 0x6 }, // 8236
  { PseudoVSLIDEDOWN_VI_MF2, VSLIDEDOWN_VI, 0x7 }, // 8237
  { PseudoVSLIDEDOWN_VI_MF2_MASK, VSLIDEDOWN_VI, 0x7 }, // 8238
  { PseudoVSLIDEDOWN_VX_M1, VSLIDEDOWN_VX, 0x0 }, // 8239
  { PseudoVSLIDEDOWN_VX_M1_MASK, VSLIDEDOWN_VX, 0x0 }, // 8240
  { PseudoVSLIDEDOWN_VX_M2, VSLIDEDOWN_VX, 0x1 }, // 8241
  { PseudoVSLIDEDOWN_VX_M2_MASK, VSLIDEDOWN_VX, 0x1 }, // 8242
  { PseudoVSLIDEDOWN_VX_M4, VSLIDEDOWN_VX, 0x2 }, // 8243
  { PseudoVSLIDEDOWN_VX_M4_MASK, VSLIDEDOWN_VX, 0x2 }, // 8244
  { PseudoVSLIDEDOWN_VX_M8, VSLIDEDOWN_VX, 0x3 }, // 8245
  { PseudoVSLIDEDOWN_VX_M8_MASK, VSLIDEDOWN_VX, 0x3 }, // 8246
  { PseudoVSLIDEDOWN_VX_MF8, VSLIDEDOWN_VX, 0x5 }, // 8247
  { PseudoVSLIDEDOWN_VX_MF8_MASK, VSLIDEDOWN_VX, 0x5 }, // 8248
  { PseudoVSLIDEDOWN_VX_MF4, VSLIDEDOWN_VX, 0x6 }, // 8249
  { PseudoVSLIDEDOWN_VX_MF4_MASK, VSLIDEDOWN_VX, 0x6 }, // 8250
  { PseudoVSLIDEDOWN_VX_MF2, VSLIDEDOWN_VX, 0x7 }, // 8251
  { PseudoVSLIDEDOWN_VX_MF2_MASK, VSLIDEDOWN_VX, 0x7 }, // 8252
  { PseudoVSLIDEUP_VI_M1, VSLIDEUP_VI, 0x0 }, // 8253
  { PseudoVSLIDEUP_VI_M1_MASK, VSLIDEUP_VI, 0x0 }, // 8254
  { PseudoVSLIDEUP_VI_M2, VSLIDEUP_VI, 0x1 }, // 8255
  { PseudoVSLIDEUP_VI_M2_MASK, VSLIDEUP_VI, 0x1 }, // 8256
  { PseudoVSLIDEUP_VI_M4, VSLIDEUP_VI, 0x2 }, // 8257
  { PseudoVSLIDEUP_VI_M4_MASK, VSLIDEUP_VI, 0x2 }, // 8258
  { PseudoVSLIDEUP_VI_M8, VSLIDEUP_VI, 0x3 }, // 8259
  { PseudoVSLIDEUP_VI_M8_MASK, VSLIDEUP_VI, 0x3 }, // 8260
  { PseudoVSLIDEUP_VI_MF8, VSLIDEUP_VI, 0x5 }, // 8261
  { PseudoVSLIDEUP_VI_MF8_MASK, VSLIDEUP_VI, 0x5 }, // 8262
  { PseudoVSLIDEUP_VI_MF4, VSLIDEUP_VI, 0x6 }, // 8263
  { PseudoVSLIDEUP_VI_MF4_MASK, VSLIDEUP_VI, 0x6 }, // 8264
  { PseudoVSLIDEUP_VI_MF2, VSLIDEUP_VI, 0x7 }, // 8265
  { PseudoVSLIDEUP_VI_MF2_MASK, VSLIDEUP_VI, 0x7 }, // 8266
  { PseudoVSLIDEUP_VX_M1, VSLIDEUP_VX, 0x0 }, // 8267
  { PseudoVSLIDEUP_VX_M1_MASK, VSLIDEUP_VX, 0x0 }, // 8268
  { PseudoVSLIDEUP_VX_M2, VSLIDEUP_VX, 0x1 }, // 8269
  { PseudoVSLIDEUP_VX_M2_MASK, VSLIDEUP_VX, 0x1 }, // 8270
  { PseudoVSLIDEUP_VX_M4, VSLIDEUP_VX, 0x2 }, // 8271
  { PseudoVSLIDEUP_VX_M4_MASK, VSLIDEUP_VX, 0x2 }, // 8272
  { PseudoVSLIDEUP_VX_M8, VSLIDEUP_VX, 0x3 }, // 8273
  { PseudoVSLIDEUP_VX_M8_MASK, VSLIDEUP_VX, 0x3 }, // 8274
  { PseudoVSLIDEUP_VX_MF8, VSLIDEUP_VX, 0x5 }, // 8275
  { PseudoVSLIDEUP_VX_MF8_MASK, VSLIDEUP_VX, 0x5 }, // 8276
  { PseudoVSLIDEUP_VX_MF4, VSLIDEUP_VX, 0x6 }, // 8277
  { PseudoVSLIDEUP_VX_MF4_MASK, VSLIDEUP_VX, 0x6 }, // 8278
  { PseudoVSLIDEUP_VX_MF2, VSLIDEUP_VX, 0x7 }, // 8279
  { PseudoVSLIDEUP_VX_MF2_MASK, VSLIDEUP_VX, 0x7 }, // 8280
  { PseudoVSLL_VI_M1, VSLL_VI, 0x0 }, // 8281
  { PseudoVSLL_VI_M1_MASK, VSLL_VI, 0x0 }, // 8282
  { PseudoVSLL_VI_M1_TU, VSLL_VI, 0x0 }, // 8283
  { PseudoVSLL_VI_M2, VSLL_VI, 0x1 }, // 8284
  { PseudoVSLL_VI_M2_MASK, VSLL_VI, 0x1 }, // 8285
  { PseudoVSLL_VI_M2_TU, VSLL_VI, 0x1 }, // 8286
  { PseudoVSLL_VI_M4, VSLL_VI, 0x2 }, // 8287
  { PseudoVSLL_VI_M4_MASK, VSLL_VI, 0x2 }, // 8288
  { PseudoVSLL_VI_M4_TU, VSLL_VI, 0x2 }, // 8289
  { PseudoVSLL_VI_M8, VSLL_VI, 0x3 }, // 8290
  { PseudoVSLL_VI_M8_MASK, VSLL_VI, 0x3 }, // 8291
  { PseudoVSLL_VI_M8_TU, VSLL_VI, 0x3 }, // 8292
  { PseudoVSLL_VI_MF8, VSLL_VI, 0x5 }, // 8293
  { PseudoVSLL_VI_MF8_MASK, VSLL_VI, 0x5 }, // 8294
  { PseudoVSLL_VI_MF8_TU, VSLL_VI, 0x5 }, // 8295
  { PseudoVSLL_VI_MF4, VSLL_VI, 0x6 }, // 8296
  { PseudoVSLL_VI_MF4_MASK, VSLL_VI, 0x6 }, // 8297
  { PseudoVSLL_VI_MF4_TU, VSLL_VI, 0x6 }, // 8298
  { PseudoVSLL_VI_MF2, VSLL_VI, 0x7 }, // 8299
  { PseudoVSLL_VI_MF2_MASK, VSLL_VI, 0x7 }, // 8300
  { PseudoVSLL_VI_MF2_TU, VSLL_VI, 0x7 }, // 8301
  { PseudoVSLL_VV_M1, VSLL_VV, 0x0 }, // 8302
  { PseudoVSLL_VV_M1_MASK, VSLL_VV, 0x0 }, // 8303
  { PseudoVSLL_VV_M1_TU, VSLL_VV, 0x0 }, // 8304
  { PseudoVSLL_VV_M2, VSLL_VV, 0x1 }, // 8305
  { PseudoVSLL_VV_M2_MASK, VSLL_VV, 0x1 }, // 8306
  { PseudoVSLL_VV_M2_TU, VSLL_VV, 0x1 }, // 8307
  { PseudoVSLL_VV_M4, VSLL_VV, 0x2 }, // 8308
  { PseudoVSLL_VV_M4_MASK, VSLL_VV, 0x2 }, // 8309
  { PseudoVSLL_VV_M4_TU, VSLL_VV, 0x2 }, // 8310
  { PseudoVSLL_VV_M8, VSLL_VV, 0x3 }, // 8311
  { PseudoVSLL_VV_M8_MASK, VSLL_VV, 0x3 }, // 8312
  { PseudoVSLL_VV_M8_TU, VSLL_VV, 0x3 }, // 8313
  { PseudoVSLL_VV_MF8, VSLL_VV, 0x5 }, // 8314
  { PseudoVSLL_VV_MF8_MASK, VSLL_VV, 0x5 }, // 8315
  { PseudoVSLL_VV_MF8_TU, VSLL_VV, 0x5 }, // 8316
  { PseudoVSLL_VV_MF4, VSLL_VV, 0x6 }, // 8317
  { PseudoVSLL_VV_MF4_MASK, VSLL_VV, 0x6 }, // 8318
  { PseudoVSLL_VV_MF4_TU, VSLL_VV, 0x6 }, // 8319
  { PseudoVSLL_VV_MF2, VSLL_VV, 0x7 }, // 8320
  { PseudoVSLL_VV_MF2_MASK, VSLL_VV, 0x7 }, // 8321
  { PseudoVSLL_VV_MF2_TU, VSLL_VV, 0x7 }, // 8322
  { PseudoVSLL_VX_M1, VSLL_VX, 0x0 }, // 8323
  { PseudoVSLL_VX_M1_MASK, VSLL_VX, 0x0 }, // 8324
  { PseudoVSLL_VX_M1_TU, VSLL_VX, 0x0 }, // 8325
  { PseudoVSLL_VX_M2, VSLL_VX, 0x1 }, // 8326
  { PseudoVSLL_VX_M2_MASK, VSLL_VX, 0x1 }, // 8327
  { PseudoVSLL_VX_M2_TU, VSLL_VX, 0x1 }, // 8328
  { PseudoVSLL_VX_M4, VSLL_VX, 0x2 }, // 8329
  { PseudoVSLL_VX_M4_MASK, VSLL_VX, 0x2 }, // 8330
  { PseudoVSLL_VX_M4_TU, VSLL_VX, 0x2 }, // 8331
  { PseudoVSLL_VX_M8, VSLL_VX, 0x3 }, // 8332
  { PseudoVSLL_VX_M8_MASK, VSLL_VX, 0x3 }, // 8333
  { PseudoVSLL_VX_M8_TU, VSLL_VX, 0x3 }, // 8334
  { PseudoVSLL_VX_MF8, VSLL_VX, 0x5 }, // 8335
  { PseudoVSLL_VX_MF8_MASK, VSLL_VX, 0x5 }, // 8336
  { PseudoVSLL_VX_MF8_TU, VSLL_VX, 0x5 }, // 8337
  { PseudoVSLL_VX_MF4, VSLL_VX, 0x6 }, // 8338
  { PseudoVSLL_VX_MF4_MASK, VSLL_VX, 0x6 }, // 8339
  { PseudoVSLL_VX_MF4_TU, VSLL_VX, 0x6 }, // 8340
  { PseudoVSLL_VX_MF2, VSLL_VX, 0x7 }, // 8341
  { PseudoVSLL_VX_MF2_MASK, VSLL_VX, 0x7 }, // 8342
  { PseudoVSLL_VX_MF2_TU, VSLL_VX, 0x7 }, // 8343
  { PseudoVSMUL_VV_M1, VSMUL_VV, 0x0 }, // 8344
  { PseudoVSMUL_VV_M1_MASK, VSMUL_VV, 0x0 }, // 8345
  { PseudoVSMUL_VV_M1_TU, VSMUL_VV, 0x0 }, // 8346
  { PseudoVSMUL_VV_M2, VSMUL_VV, 0x1 }, // 8347
  { PseudoVSMUL_VV_M2_MASK, VSMUL_VV, 0x1 }, // 8348
  { PseudoVSMUL_VV_M2_TU, VSMUL_VV, 0x1 }, // 8349
  { PseudoVSMUL_VV_M4, VSMUL_VV, 0x2 }, // 8350
  { PseudoVSMUL_VV_M4_MASK, VSMUL_VV, 0x2 }, // 8351
  { PseudoVSMUL_VV_M4_TU, VSMUL_VV, 0x2 }, // 8352
  { PseudoVSMUL_VV_M8, VSMUL_VV, 0x3 }, // 8353
  { PseudoVSMUL_VV_M8_MASK, VSMUL_VV, 0x3 }, // 8354
  { PseudoVSMUL_VV_M8_TU, VSMUL_VV, 0x3 }, // 8355
  { PseudoVSMUL_VV_MF8, VSMUL_VV, 0x5 }, // 8356
  { PseudoVSMUL_VV_MF8_MASK, VSMUL_VV, 0x5 }, // 8357
  { PseudoVSMUL_VV_MF8_TU, VSMUL_VV, 0x5 }, // 8358
  { PseudoVSMUL_VV_MF4, VSMUL_VV, 0x6 }, // 8359
  { PseudoVSMUL_VV_MF4_MASK, VSMUL_VV, 0x6 }, // 8360
  { PseudoVSMUL_VV_MF4_TU, VSMUL_VV, 0x6 }, // 8361
  { PseudoVSMUL_VV_MF2, VSMUL_VV, 0x7 }, // 8362
  { PseudoVSMUL_VV_MF2_MASK, VSMUL_VV, 0x7 }, // 8363
  { PseudoVSMUL_VV_MF2_TU, VSMUL_VV, 0x7 }, // 8364
  { PseudoVSMUL_VX_M1, VSMUL_VX, 0x0 }, // 8365
  { PseudoVSMUL_VX_M1_MASK, VSMUL_VX, 0x0 }, // 8366
  { PseudoVSMUL_VX_M1_TU, VSMUL_VX, 0x0 }, // 8367
  { PseudoVSMUL_VX_M2, VSMUL_VX, 0x1 }, // 8368
  { PseudoVSMUL_VX_M2_MASK, VSMUL_VX, 0x1 }, // 8369
  { PseudoVSMUL_VX_M2_TU, VSMUL_VX, 0x1 }, // 8370
  { PseudoVSMUL_VX_M4, VSMUL_VX, 0x2 }, // 8371
  { PseudoVSMUL_VX_M4_MASK, VSMUL_VX, 0x2 }, // 8372
  { PseudoVSMUL_VX_M4_TU, VSMUL_VX, 0x2 }, // 8373
  { PseudoVSMUL_VX_M8, VSMUL_VX, 0x3 }, // 8374
  { PseudoVSMUL_VX_M8_MASK, VSMUL_VX, 0x3 }, // 8375
  { PseudoVSMUL_VX_M8_TU, VSMUL_VX, 0x3 }, // 8376
  { PseudoVSMUL_VX_MF8, VSMUL_VX, 0x5 }, // 8377
  { PseudoVSMUL_VX_MF8_MASK, VSMUL_VX, 0x5 }, // 8378
  { PseudoVSMUL_VX_MF8_TU, VSMUL_VX, 0x5 }, // 8379
  { PseudoVSMUL_VX_MF4, VSMUL_VX, 0x6 }, // 8380
  { PseudoVSMUL_VX_MF4_MASK, VSMUL_VX, 0x6 }, // 8381
  { PseudoVSMUL_VX_MF4_TU, VSMUL_VX, 0x6 }, // 8382
  { PseudoVSMUL_VX_MF2, VSMUL_VX, 0x7 }, // 8383
  { PseudoVSMUL_VX_MF2_MASK, VSMUL_VX, 0x7 }, // 8384
  { PseudoVSMUL_VX_MF2_TU, VSMUL_VX, 0x7 }, // 8385
  { PseudoVSM_V_B8, VSM_V, 0x0 }, // 8386
  { PseudoVSM_V_B16, VSM_V, 0x1 }, // 8387
  { PseudoVSM_V_B32, VSM_V, 0x2 }, // 8388
  { PseudoVSM_V_B64, VSM_V, 0x3 }, // 8389
  { PseudoVSM_V_B1, VSM_V, 0x5 }, // 8390
  { PseudoVSM_V_B2, VSM_V, 0x6 }, // 8391
  { PseudoVSM_V_B4, VSM_V, 0x7 }, // 8392
  { PseudoVSOXEI16_V_M1_M1, VSOXEI16_V, 0x0 }, // 8393
  { PseudoVSOXEI16_V_M1_M1_MASK, VSOXEI16_V, 0x0 }, // 8394
  { PseudoVSOXEI16_V_M2_M1, VSOXEI16_V, 0x0 }, // 8395
  { PseudoVSOXEI16_V_M2_M1_MASK, VSOXEI16_V, 0x0 }, // 8396
  { PseudoVSOXEI16_V_MF2_M1, VSOXEI16_V, 0x0 }, // 8397
  { PseudoVSOXEI16_V_MF2_M1_MASK, VSOXEI16_V, 0x0 }, // 8398
  { PseudoVSOXEI16_V_MF4_M1, VSOXEI16_V, 0x0 }, // 8399
  { PseudoVSOXEI16_V_MF4_M1_MASK, VSOXEI16_V, 0x0 }, // 8400
  { PseudoVSOXEI16_V_M1_M2, VSOXEI16_V, 0x1 }, // 8401
  { PseudoVSOXEI16_V_M1_M2_MASK, VSOXEI16_V, 0x1 }, // 8402
  { PseudoVSOXEI16_V_M2_M2, VSOXEI16_V, 0x1 }, // 8403
  { PseudoVSOXEI16_V_M2_M2_MASK, VSOXEI16_V, 0x1 }, // 8404
  { PseudoVSOXEI16_V_M4_M2, VSOXEI16_V, 0x1 }, // 8405
  { PseudoVSOXEI16_V_M4_M2_MASK, VSOXEI16_V, 0x1 }, // 8406
  { PseudoVSOXEI16_V_MF2_M2, VSOXEI16_V, 0x1 }, // 8407
  { PseudoVSOXEI16_V_MF2_M2_MASK, VSOXEI16_V, 0x1 }, // 8408
  { PseudoVSOXEI16_V_M1_M4, VSOXEI16_V, 0x2 }, // 8409
  { PseudoVSOXEI16_V_M1_M4_MASK, VSOXEI16_V, 0x2 }, // 8410
  { PseudoVSOXEI16_V_M2_M4, VSOXEI16_V, 0x2 }, // 8411
  { PseudoVSOXEI16_V_M2_M4_MASK, VSOXEI16_V, 0x2 }, // 8412
  { PseudoVSOXEI16_V_M4_M4, VSOXEI16_V, 0x2 }, // 8413
  { PseudoVSOXEI16_V_M4_M4_MASK, VSOXEI16_V, 0x2 }, // 8414
  { PseudoVSOXEI16_V_M8_M4, VSOXEI16_V, 0x2 }, // 8415
  { PseudoVSOXEI16_V_M8_M4_MASK, VSOXEI16_V, 0x2 }, // 8416
  { PseudoVSOXEI16_V_M2_M8, VSOXEI16_V, 0x3 }, // 8417
  { PseudoVSOXEI16_V_M2_M8_MASK, VSOXEI16_V, 0x3 }, // 8418
  { PseudoVSOXEI16_V_M4_M8, VSOXEI16_V, 0x3 }, // 8419
  { PseudoVSOXEI16_V_M4_M8_MASK, VSOXEI16_V, 0x3 }, // 8420
  { PseudoVSOXEI16_V_M8_M8, VSOXEI16_V, 0x3 }, // 8421
  { PseudoVSOXEI16_V_M8_M8_MASK, VSOXEI16_V, 0x3 }, // 8422
  { PseudoVSOXEI16_V_MF4_MF8, VSOXEI16_V, 0x5 }, // 8423
  { PseudoVSOXEI16_V_MF4_MF8_MASK, VSOXEI16_V, 0x5 }, // 8424
  { PseudoVSOXEI16_V_MF2_MF4, VSOXEI16_V, 0x6 }, // 8425
  { PseudoVSOXEI16_V_MF2_MF4_MASK, VSOXEI16_V, 0x6 }, // 8426
  { PseudoVSOXEI16_V_MF4_MF4, VSOXEI16_V, 0x6 }, // 8427
  { PseudoVSOXEI16_V_MF4_MF4_MASK, VSOXEI16_V, 0x6 }, // 8428
  { PseudoVSOXEI16_V_M1_MF2, VSOXEI16_V, 0x7 }, // 8429
  { PseudoVSOXEI16_V_M1_MF2_MASK, VSOXEI16_V, 0x7 }, // 8430
  { PseudoVSOXEI16_V_MF2_MF2, VSOXEI16_V, 0x7 }, // 8431
  { PseudoVSOXEI16_V_MF2_MF2_MASK, VSOXEI16_V, 0x7 }, // 8432
  { PseudoVSOXEI16_V_MF4_MF2, VSOXEI16_V, 0x7 }, // 8433
  { PseudoVSOXEI16_V_MF4_MF2_MASK, VSOXEI16_V, 0x7 }, // 8434
  { PseudoVSOXEI32_V_M1_M1, VSOXEI32_V, 0x0 }, // 8435
  { PseudoVSOXEI32_V_M1_M1_MASK, VSOXEI32_V, 0x0 }, // 8436
  { PseudoVSOXEI32_V_M2_M1, VSOXEI32_V, 0x0 }, // 8437
  { PseudoVSOXEI32_V_M2_M1_MASK, VSOXEI32_V, 0x0 }, // 8438
  { PseudoVSOXEI32_V_M4_M1, VSOXEI32_V, 0x0 }, // 8439
  { PseudoVSOXEI32_V_M4_M1_MASK, VSOXEI32_V, 0x0 }, // 8440
  { PseudoVSOXEI32_V_MF2_M1, VSOXEI32_V, 0x0 }, // 8441
  { PseudoVSOXEI32_V_MF2_M1_MASK, VSOXEI32_V, 0x0 }, // 8442
  { PseudoVSOXEI32_V_M1_M2, VSOXEI32_V, 0x1 }, // 8443
  { PseudoVSOXEI32_V_M1_M2_MASK, VSOXEI32_V, 0x1 }, // 8444
  { PseudoVSOXEI32_V_M2_M2, VSOXEI32_V, 0x1 }, // 8445
  { PseudoVSOXEI32_V_M2_M2_MASK, VSOXEI32_V, 0x1 }, // 8446
  { PseudoVSOXEI32_V_M4_M2, VSOXEI32_V, 0x1 }, // 8447
  { PseudoVSOXEI32_V_M4_M2_MASK, VSOXEI32_V, 0x1 }, // 8448
  { PseudoVSOXEI32_V_M8_M2, VSOXEI32_V, 0x1 }, // 8449
  { PseudoVSOXEI32_V_M8_M2_MASK, VSOXEI32_V, 0x1 }, // 8450
  { PseudoVSOXEI32_V_M2_M4, VSOXEI32_V, 0x2 }, // 8451
  { PseudoVSOXEI32_V_M2_M4_MASK, VSOXEI32_V, 0x2 }, // 8452
  { PseudoVSOXEI32_V_M4_M4, VSOXEI32_V, 0x2 }, // 8453
  { PseudoVSOXEI32_V_M4_M4_MASK, VSOXEI32_V, 0x2 }, // 8454
  { PseudoVSOXEI32_V_M8_M4, VSOXEI32_V, 0x2 }, // 8455
  { PseudoVSOXEI32_V_M8_M4_MASK, VSOXEI32_V, 0x2 }, // 8456
  { PseudoVSOXEI32_V_M4_M8, VSOXEI32_V, 0x3 }, // 8457
  { PseudoVSOXEI32_V_M4_M8_MASK, VSOXEI32_V, 0x3 }, // 8458
  { PseudoVSOXEI32_V_M8_M8, VSOXEI32_V, 0x3 }, // 8459
  { PseudoVSOXEI32_V_M8_M8_MASK, VSOXEI32_V, 0x3 }, // 8460
  { PseudoVSOXEI32_V_MF2_MF8, VSOXEI32_V, 0x5 }, // 8461
  { PseudoVSOXEI32_V_MF2_MF8_MASK, VSOXEI32_V, 0x5 }, // 8462
  { PseudoVSOXEI32_V_M1_MF4, VSOXEI32_V, 0x6 }, // 8463
  { PseudoVSOXEI32_V_M1_MF4_MASK, VSOXEI32_V, 0x6 }, // 8464
  { PseudoVSOXEI32_V_MF2_MF4, VSOXEI32_V, 0x6 }, // 8465
  { PseudoVSOXEI32_V_MF2_MF4_MASK, VSOXEI32_V, 0x6 }, // 8466
  { PseudoVSOXEI32_V_M1_MF2, VSOXEI32_V, 0x7 }, // 8467
  { PseudoVSOXEI32_V_M1_MF2_MASK, VSOXEI32_V, 0x7 }, // 8468
  { PseudoVSOXEI32_V_M2_MF2, VSOXEI32_V, 0x7 }, // 8469
  { PseudoVSOXEI32_V_M2_MF2_MASK, VSOXEI32_V, 0x7 }, // 8470
  { PseudoVSOXEI32_V_MF2_MF2, VSOXEI32_V, 0x7 }, // 8471
  { PseudoVSOXEI32_V_MF2_MF2_MASK, VSOXEI32_V, 0x7 }, // 8472
  { PseudoVSOXEI64_V_M1_M1, VSOXEI64_V, 0x0 }, // 8473
  { PseudoVSOXEI64_V_M1_M1_MASK, VSOXEI64_V, 0x0 }, // 8474
  { PseudoVSOXEI64_V_M2_M1, VSOXEI64_V, 0x0 }, // 8475
  { PseudoVSOXEI64_V_M2_M1_MASK, VSOXEI64_V, 0x0 }, // 8476
  { PseudoVSOXEI64_V_M4_M1, VSOXEI64_V, 0x0 }, // 8477
  { PseudoVSOXEI64_V_M4_M1_MASK, VSOXEI64_V, 0x0 }, // 8478
  { PseudoVSOXEI64_V_M8_M1, VSOXEI64_V, 0x0 }, // 8479
  { PseudoVSOXEI64_V_M8_M1_MASK, VSOXEI64_V, 0x0 }, // 8480
  { PseudoVSOXEI64_V_M2_M2, VSOXEI64_V, 0x1 }, // 8481
  { PseudoVSOXEI64_V_M2_M2_MASK, VSOXEI64_V, 0x1 }, // 8482
  { PseudoVSOXEI64_V_M4_M2, VSOXEI64_V, 0x1 }, // 8483
  { PseudoVSOXEI64_V_M4_M2_MASK, VSOXEI64_V, 0x1 }, // 8484
  { PseudoVSOXEI64_V_M8_M2, VSOXEI64_V, 0x1 }, // 8485
  { PseudoVSOXEI64_V_M8_M2_MASK, VSOXEI64_V, 0x1 }, // 8486
  { PseudoVSOXEI64_V_M4_M4, VSOXEI64_V, 0x2 }, // 8487
  { PseudoVSOXEI64_V_M4_M4_MASK, VSOXEI64_V, 0x2 }, // 8488
  { PseudoVSOXEI64_V_M8_M4, VSOXEI64_V, 0x2 }, // 8489
  { PseudoVSOXEI64_V_M8_M4_MASK, VSOXEI64_V, 0x2 }, // 8490
  { PseudoVSOXEI64_V_M8_M8, VSOXEI64_V, 0x3 }, // 8491
  { PseudoVSOXEI64_V_M8_M8_MASK, VSOXEI64_V, 0x3 }, // 8492
  { PseudoVSOXEI64_V_M1_MF8, VSOXEI64_V, 0x5 }, // 8493
  { PseudoVSOXEI64_V_M1_MF8_MASK, VSOXEI64_V, 0x5 }, // 8494
  { PseudoVSOXEI64_V_M1_MF4, VSOXEI64_V, 0x6 }, // 8495
  { PseudoVSOXEI64_V_M1_MF4_MASK, VSOXEI64_V, 0x6 }, // 8496
  { PseudoVSOXEI64_V_M2_MF4, VSOXEI64_V, 0x6 }, // 8497
  { PseudoVSOXEI64_V_M2_MF4_MASK, VSOXEI64_V, 0x6 }, // 8498
  { PseudoVSOXEI64_V_M1_MF2, VSOXEI64_V, 0x7 }, // 8499
  { PseudoVSOXEI64_V_M1_MF2_MASK, VSOXEI64_V, 0x7 }, // 8500
  { PseudoVSOXEI64_V_M2_MF2, VSOXEI64_V, 0x7 }, // 8501
  { PseudoVSOXEI64_V_M2_MF2_MASK, VSOXEI64_V, 0x7 }, // 8502
  { PseudoVSOXEI64_V_M4_MF2, VSOXEI64_V, 0x7 }, // 8503
  { PseudoVSOXEI64_V_M4_MF2_MASK, VSOXEI64_V, 0x7 }, // 8504
  { PseudoVSOXEI8_V_M1_M1, VSOXEI8_V, 0x0 }, // 8505
  { PseudoVSOXEI8_V_M1_M1_MASK, VSOXEI8_V, 0x0 }, // 8506
  { PseudoVSOXEI8_V_MF2_M1, VSOXEI8_V, 0x0 }, // 8507
  { PseudoVSOXEI8_V_MF2_M1_MASK, VSOXEI8_V, 0x0 }, // 8508
  { PseudoVSOXEI8_V_MF4_M1, VSOXEI8_V, 0x0 }, // 8509
  { PseudoVSOXEI8_V_MF4_M1_MASK, VSOXEI8_V, 0x0 }, // 8510
  { PseudoVSOXEI8_V_MF8_M1, VSOXEI8_V, 0x0 }, // 8511
  { PseudoVSOXEI8_V_MF8_M1_MASK, VSOXEI8_V, 0x0 }, // 8512
  { PseudoVSOXEI8_V_M1_M2, VSOXEI8_V, 0x1 }, // 8513
  { PseudoVSOXEI8_V_M1_M2_MASK, VSOXEI8_V, 0x1 }, // 8514
  { PseudoVSOXEI8_V_M2_M2, VSOXEI8_V, 0x1 }, // 8515
  { PseudoVSOXEI8_V_M2_M2_MASK, VSOXEI8_V, 0x1 }, // 8516
  { PseudoVSOXEI8_V_MF2_M2, VSOXEI8_V, 0x1 }, // 8517
  { PseudoVSOXEI8_V_MF2_M2_MASK, VSOXEI8_V, 0x1 }, // 8518
  { PseudoVSOXEI8_V_MF4_M2, VSOXEI8_V, 0x1 }, // 8519
  { PseudoVSOXEI8_V_MF4_M2_MASK, VSOXEI8_V, 0x1 }, // 8520
  { PseudoVSOXEI8_V_M1_M4, VSOXEI8_V, 0x2 }, // 8521
  { PseudoVSOXEI8_V_M1_M4_MASK, VSOXEI8_V, 0x2 }, // 8522
  { PseudoVSOXEI8_V_M2_M4, VSOXEI8_V, 0x2 }, // 8523
  { PseudoVSOXEI8_V_M2_M4_MASK, VSOXEI8_V, 0x2 }, // 8524
  { PseudoVSOXEI8_V_M4_M4, VSOXEI8_V, 0x2 }, // 8525
  { PseudoVSOXEI8_V_M4_M4_MASK, VSOXEI8_V, 0x2 }, // 8526
  { PseudoVSOXEI8_V_MF2_M4, VSOXEI8_V, 0x2 }, // 8527
  { PseudoVSOXEI8_V_MF2_M4_MASK, VSOXEI8_V, 0x2 }, // 8528
  { PseudoVSOXEI8_V_M1_M8, VSOXEI8_V, 0x3 }, // 8529
  { PseudoVSOXEI8_V_M1_M8_MASK, VSOXEI8_V, 0x3 }, // 8530
  { PseudoVSOXEI8_V_M2_M8, VSOXEI8_V, 0x3 }, // 8531
  { PseudoVSOXEI8_V_M2_M8_MASK, VSOXEI8_V, 0x3 }, // 8532
  { PseudoVSOXEI8_V_M4_M8, VSOXEI8_V, 0x3 }, // 8533
  { PseudoVSOXEI8_V_M4_M8_MASK, VSOXEI8_V, 0x3 }, // 8534
  { PseudoVSOXEI8_V_M8_M8, VSOXEI8_V, 0x3 }, // 8535
  { PseudoVSOXEI8_V_M8_M8_MASK, VSOXEI8_V, 0x3 }, // 8536
  { PseudoVSOXEI8_V_MF8_MF8, VSOXEI8_V, 0x5 }, // 8537
  { PseudoVSOXEI8_V_MF8_MF8_MASK, VSOXEI8_V, 0x5 }, // 8538
  { PseudoVSOXEI8_V_MF4_MF4, VSOXEI8_V, 0x6 }, // 8539
  { PseudoVSOXEI8_V_MF4_MF4_MASK, VSOXEI8_V, 0x6 }, // 8540
  { PseudoVSOXEI8_V_MF8_MF4, VSOXEI8_V, 0x6 }, // 8541
  { PseudoVSOXEI8_V_MF8_MF4_MASK, VSOXEI8_V, 0x6 }, // 8542
  { PseudoVSOXEI8_V_MF2_MF2, VSOXEI8_V, 0x7 }, // 8543
  { PseudoVSOXEI8_V_MF2_MF2_MASK, VSOXEI8_V, 0x7 }, // 8544
  { PseudoVSOXEI8_V_MF4_MF2, VSOXEI8_V, 0x7 }, // 8545
  { PseudoVSOXEI8_V_MF4_MF2_MASK, VSOXEI8_V, 0x7 }, // 8546
  { PseudoVSOXEI8_V_MF8_MF2, VSOXEI8_V, 0x7 }, // 8547
  { PseudoVSOXEI8_V_MF8_MF2_MASK, VSOXEI8_V, 0x7 }, // 8548
  { PseudoVSOXSEG2EI16_V_M1_M1, VSOXSEG2EI16_V, 0x0 }, // 8549
  { PseudoVSOXSEG2EI16_V_M1_M1_MASK, VSOXSEG2EI16_V, 0x0 }, // 8550
  { PseudoVSOXSEG2EI16_V_M2_M1, VSOXSEG2EI16_V, 0x0 }, // 8551
  { PseudoVSOXSEG2EI16_V_M2_M1_MASK, VSOXSEG2EI16_V, 0x0 }, // 8552
  { PseudoVSOXSEG2EI16_V_MF2_M1, VSOXSEG2EI16_V, 0x0 }, // 8553
  { PseudoVSOXSEG2EI16_V_MF2_M1_MASK, VSOXSEG2EI16_V, 0x0 }, // 8554
  { PseudoVSOXSEG2EI16_V_MF4_M1, VSOXSEG2EI16_V, 0x0 }, // 8555
  { PseudoVSOXSEG2EI16_V_MF4_M1_MASK, VSOXSEG2EI16_V, 0x0 }, // 8556
  { PseudoVSOXSEG2EI16_V_M1_M2, VSOXSEG2EI16_V, 0x1 }, // 8557
  { PseudoVSOXSEG2EI16_V_M1_M2_MASK, VSOXSEG2EI16_V, 0x1 }, // 8558
  { PseudoVSOXSEG2EI16_V_M2_M2, VSOXSEG2EI16_V, 0x1 }, // 8559
  { PseudoVSOXSEG2EI16_V_M2_M2_MASK, VSOXSEG2EI16_V, 0x1 }, // 8560
  { PseudoVSOXSEG2EI16_V_M4_M2, VSOXSEG2EI16_V, 0x1 }, // 8561
  { PseudoVSOXSEG2EI16_V_M4_M2_MASK, VSOXSEG2EI16_V, 0x1 }, // 8562
  { PseudoVSOXSEG2EI16_V_MF2_M2, VSOXSEG2EI16_V, 0x1 }, // 8563
  { PseudoVSOXSEG2EI16_V_MF2_M2_MASK, VSOXSEG2EI16_V, 0x1 }, // 8564
  { PseudoVSOXSEG2EI16_V_M1_M4, VSOXSEG2EI16_V, 0x2 }, // 8565
  { PseudoVSOXSEG2EI16_V_M1_M4_MASK, VSOXSEG2EI16_V, 0x2 }, // 8566
  { PseudoVSOXSEG2EI16_V_M2_M4, VSOXSEG2EI16_V, 0x2 }, // 8567
  { PseudoVSOXSEG2EI16_V_M2_M4_MASK, VSOXSEG2EI16_V, 0x2 }, // 8568
  { PseudoVSOXSEG2EI16_V_M4_M4, VSOXSEG2EI16_V, 0x2 }, // 8569
  { PseudoVSOXSEG2EI16_V_M4_M4_MASK, VSOXSEG2EI16_V, 0x2 }, // 8570
  { PseudoVSOXSEG2EI16_V_M8_M4, VSOXSEG2EI16_V, 0x2 }, // 8571
  { PseudoVSOXSEG2EI16_V_M8_M4_MASK, VSOXSEG2EI16_V, 0x2 }, // 8572
  { PseudoVSOXSEG2EI16_V_MF4_MF8, VSOXSEG2EI16_V, 0x5 }, // 8573
  { PseudoVSOXSEG2EI16_V_MF4_MF8_MASK, VSOXSEG2EI16_V, 0x5 }, // 8574
  { PseudoVSOXSEG2EI16_V_MF2_MF4, VSOXSEG2EI16_V, 0x6 }, // 8575
  { PseudoVSOXSEG2EI16_V_MF2_MF4_MASK, VSOXSEG2EI16_V, 0x6 }, // 8576
  { PseudoVSOXSEG2EI16_V_MF4_MF4, VSOXSEG2EI16_V, 0x6 }, // 8577
  { PseudoVSOXSEG2EI16_V_MF4_MF4_MASK, VSOXSEG2EI16_V, 0x6 }, // 8578
  { PseudoVSOXSEG2EI16_V_M1_MF2, VSOXSEG2EI16_V, 0x7 }, // 8579
  { PseudoVSOXSEG2EI16_V_M1_MF2_MASK, VSOXSEG2EI16_V, 0x7 }, // 8580
  { PseudoVSOXSEG2EI16_V_MF2_MF2, VSOXSEG2EI16_V, 0x7 }, // 8581
  { PseudoVSOXSEG2EI16_V_MF2_MF2_MASK, VSOXSEG2EI16_V, 0x7 }, // 8582
  { PseudoVSOXSEG2EI16_V_MF4_MF2, VSOXSEG2EI16_V, 0x7 }, // 8583
  { PseudoVSOXSEG2EI16_V_MF4_MF2_MASK, VSOXSEG2EI16_V, 0x7 }, // 8584
  { PseudoVSOXSEG2EI32_V_M1_M1, VSOXSEG2EI32_V, 0x0 }, // 8585
  { PseudoVSOXSEG2EI32_V_M1_M1_MASK, VSOXSEG2EI32_V, 0x0 }, // 8586
  { PseudoVSOXSEG2EI32_V_M2_M1, VSOXSEG2EI32_V, 0x0 }, // 8587
  { PseudoVSOXSEG2EI32_V_M2_M1_MASK, VSOXSEG2EI32_V, 0x0 }, // 8588
  { PseudoVSOXSEG2EI32_V_M4_M1, VSOXSEG2EI32_V, 0x0 }, // 8589
  { PseudoVSOXSEG2EI32_V_M4_M1_MASK, VSOXSEG2EI32_V, 0x0 }, // 8590
  { PseudoVSOXSEG2EI32_V_MF2_M1, VSOXSEG2EI32_V, 0x0 }, // 8591
  { PseudoVSOXSEG2EI32_V_MF2_M1_MASK, VSOXSEG2EI32_V, 0x0 }, // 8592
  { PseudoVSOXSEG2EI32_V_M1_M2, VSOXSEG2EI32_V, 0x1 }, // 8593
  { PseudoVSOXSEG2EI32_V_M1_M2_MASK, VSOXSEG2EI32_V, 0x1 }, // 8594
  { PseudoVSOXSEG2EI32_V_M2_M2, VSOXSEG2EI32_V, 0x1 }, // 8595
  { PseudoVSOXSEG2EI32_V_M2_M2_MASK, VSOXSEG2EI32_V, 0x1 }, // 8596
  { PseudoVSOXSEG2EI32_V_M4_M2, VSOXSEG2EI32_V, 0x1 }, // 8597
  { PseudoVSOXSEG2EI32_V_M4_M2_MASK, VSOXSEG2EI32_V, 0x1 }, // 8598
  { PseudoVSOXSEG2EI32_V_M8_M2, VSOXSEG2EI32_V, 0x1 }, // 8599
  { PseudoVSOXSEG2EI32_V_M8_M2_MASK, VSOXSEG2EI32_V, 0x1 }, // 8600
  { PseudoVSOXSEG2EI32_V_M2_M4, VSOXSEG2EI32_V, 0x2 }, // 8601
  { PseudoVSOXSEG2EI32_V_M2_M4_MASK, VSOXSEG2EI32_V, 0x2 }, // 8602
  { PseudoVSOXSEG2EI32_V_M4_M4, VSOXSEG2EI32_V, 0x2 }, // 8603
  { PseudoVSOXSEG2EI32_V_M4_M4_MASK, VSOXSEG2EI32_V, 0x2 }, // 8604
  { PseudoVSOXSEG2EI32_V_M8_M4, VSOXSEG2EI32_V, 0x2 }, // 8605
  { PseudoVSOXSEG2EI32_V_M8_M4_MASK, VSOXSEG2EI32_V, 0x2 }, // 8606
  { PseudoVSOXSEG2EI32_V_MF2_MF8, VSOXSEG2EI32_V, 0x5 }, // 8607
  { PseudoVSOXSEG2EI32_V_MF2_MF8_MASK, VSOXSEG2EI32_V, 0x5 }, // 8608
  { PseudoVSOXSEG2EI32_V_M1_MF4, VSOXSEG2EI32_V, 0x6 }, // 8609
  { PseudoVSOXSEG2EI32_V_M1_MF4_MASK, VSOXSEG2EI32_V, 0x6 }, // 8610
  { PseudoVSOXSEG2EI32_V_MF2_MF4, VSOXSEG2EI32_V, 0x6 }, // 8611
  { PseudoVSOXSEG2EI32_V_MF2_MF4_MASK, VSOXSEG2EI32_V, 0x6 }, // 8612
  { PseudoVSOXSEG2EI32_V_M1_MF2, VSOXSEG2EI32_V, 0x7 }, // 8613
  { PseudoVSOXSEG2EI32_V_M1_MF2_MASK, VSOXSEG2EI32_V, 0x7 }, // 8614
  { PseudoVSOXSEG2EI32_V_M2_MF2, VSOXSEG2EI32_V, 0x7 }, // 8615
  { PseudoVSOXSEG2EI32_V_M2_MF2_MASK, VSOXSEG2EI32_V, 0x7 }, // 8616
  { PseudoVSOXSEG2EI32_V_MF2_MF2, VSOXSEG2EI32_V, 0x7 }, // 8617
  { PseudoVSOXSEG2EI32_V_MF2_MF2_MASK, VSOXSEG2EI32_V, 0x7 }, // 8618
  { PseudoVSOXSEG2EI64_V_M1_M1, VSOXSEG2EI64_V, 0x0 }, // 8619
  { PseudoVSOXSEG2EI64_V_M1_M1_MASK, VSOXSEG2EI64_V, 0x0 }, // 8620
  { PseudoVSOXSEG2EI64_V_M2_M1, VSOXSEG2EI64_V, 0x0 }, // 8621
  { PseudoVSOXSEG2EI64_V_M2_M1_MASK, VSOXSEG2EI64_V, 0x0 }, // 8622
  { PseudoVSOXSEG2EI64_V_M4_M1, VSOXSEG2EI64_V, 0x0 }, // 8623
  { PseudoVSOXSEG2EI64_V_M4_M1_MASK, VSOXSEG2EI64_V, 0x0 }, // 8624
  { PseudoVSOXSEG2EI64_V_M8_M1, VSOXSEG2EI64_V, 0x0 }, // 8625
  { PseudoVSOXSEG2EI64_V_M8_M1_MASK, VSOXSEG2EI64_V, 0x0 }, // 8626
  { PseudoVSOXSEG2EI64_V_M2_M2, VSOXSEG2EI64_V, 0x1 }, // 8627
  { PseudoVSOXSEG2EI64_V_M2_M2_MASK, VSOXSEG2EI64_V, 0x1 }, // 8628
  { PseudoVSOXSEG2EI64_V_M4_M2, VSOXSEG2EI64_V, 0x1 }, // 8629
  { PseudoVSOXSEG2EI64_V_M4_M2_MASK, VSOXSEG2EI64_V, 0x1 }, // 8630
  { PseudoVSOXSEG2EI64_V_M8_M2, VSOXSEG2EI64_V, 0x1 }, // 8631
  { PseudoVSOXSEG2EI64_V_M8_M2_MASK, VSOXSEG2EI64_V, 0x1 }, // 8632
  { PseudoVSOXSEG2EI64_V_M4_M4, VSOXSEG2EI64_V, 0x2 }, // 8633
  { PseudoVSOXSEG2EI64_V_M4_M4_MASK, VSOXSEG2EI64_V, 0x2 }, // 8634
  { PseudoVSOXSEG2EI64_V_M8_M4, VSOXSEG2EI64_V, 0x2 }, // 8635
  { PseudoVSOXSEG2EI64_V_M8_M4_MASK, VSOXSEG2EI64_V, 0x2 }, // 8636
  { PseudoVSOXSEG2EI64_V_M1_MF8, VSOXSEG2EI64_V, 0x5 }, // 8637
  { PseudoVSOXSEG2EI64_V_M1_MF8_MASK, VSOXSEG2EI64_V, 0x5 }, // 8638
  { PseudoVSOXSEG2EI64_V_M1_MF4, VSOXSEG2EI64_V, 0x6 }, // 8639
  { PseudoVSOXSEG2EI64_V_M1_MF4_MASK, VSOXSEG2EI64_V, 0x6 }, // 8640
  { PseudoVSOXSEG2EI64_V_M2_MF4, VSOXSEG2EI64_V, 0x6 }, // 8641
  { PseudoVSOXSEG2EI64_V_M2_MF4_MASK, VSOXSEG2EI64_V, 0x6 }, // 8642
  { PseudoVSOXSEG2EI64_V_M1_MF2, VSOXSEG2EI64_V, 0x7 }, // 8643
  { PseudoVSOXSEG2EI64_V_M1_MF2_MASK, VSOXSEG2EI64_V, 0x7 }, // 8644
  { PseudoVSOXSEG2EI64_V_M2_MF2, VSOXSEG2EI64_V, 0x7 }, // 8645
  { PseudoVSOXSEG2EI64_V_M2_MF2_MASK, VSOXSEG2EI64_V, 0x7 }, // 8646
  { PseudoVSOXSEG2EI64_V_M4_MF2, VSOXSEG2EI64_V, 0x7 }, // 8647
  { PseudoVSOXSEG2EI64_V_M4_MF2_MASK, VSOXSEG2EI64_V, 0x7 }, // 8648
  { PseudoVSOXSEG2EI8_V_M1_M1, VSOXSEG2EI8_V, 0x0 }, // 8649
  { PseudoVSOXSEG2EI8_V_M1_M1_MASK, VSOXSEG2EI8_V, 0x0 }, // 8650
  { PseudoVSOXSEG2EI8_V_MF2_M1, VSOXSEG2EI8_V, 0x0 }, // 8651
  { PseudoVSOXSEG2EI8_V_MF2_M1_MASK, VSOXSEG2EI8_V, 0x0 }, // 8652
  { PseudoVSOXSEG2EI8_V_MF4_M1, VSOXSEG2EI8_V, 0x0 }, // 8653
  { PseudoVSOXSEG2EI8_V_MF4_M1_MASK, VSOXSEG2EI8_V, 0x0 }, // 8654
  { PseudoVSOXSEG2EI8_V_MF8_M1, VSOXSEG2EI8_V, 0x0 }, // 8655
  { PseudoVSOXSEG2EI8_V_MF8_M1_MASK, VSOXSEG2EI8_V, 0x0 }, // 8656
  { PseudoVSOXSEG2EI8_V_M1_M2, VSOXSEG2EI8_V, 0x1 }, // 8657
  { PseudoVSOXSEG2EI8_V_M1_M2_MASK, VSOXSEG2EI8_V, 0x1 }, // 8658
  { PseudoVSOXSEG2EI8_V_M2_M2, VSOXSEG2EI8_V, 0x1 }, // 8659
  { PseudoVSOXSEG2EI8_V_M2_M2_MASK, VSOXSEG2EI8_V, 0x1 }, // 8660
  { PseudoVSOXSEG2EI8_V_MF2_M2, VSOXSEG2EI8_V, 0x1 }, // 8661
  { PseudoVSOXSEG2EI8_V_MF2_M2_MASK, VSOXSEG2EI8_V, 0x1 }, // 8662
  { PseudoVSOXSEG2EI8_V_MF4_M2, VSOXSEG2EI8_V, 0x1 }, // 8663
  { PseudoVSOXSEG2EI8_V_MF4_M2_MASK, VSOXSEG2EI8_V, 0x1 }, // 8664
  { PseudoVSOXSEG2EI8_V_M1_M4, VSOXSEG2EI8_V, 0x2 }, // 8665
  { PseudoVSOXSEG2EI8_V_M1_M4_MASK, VSOXSEG2EI8_V, 0x2 }, // 8666
  { PseudoVSOXSEG2EI8_V_M2_M4, VSOXSEG2EI8_V, 0x2 }, // 8667
  { PseudoVSOXSEG2EI8_V_M2_M4_MASK, VSOXSEG2EI8_V, 0x2 }, // 8668
  { PseudoVSOXSEG2EI8_V_M4_M4, VSOXSEG2EI8_V, 0x2 }, // 8669
  { PseudoVSOXSEG2EI8_V_M4_M4_MASK, VSOXSEG2EI8_V, 0x2 }, // 8670
  { PseudoVSOXSEG2EI8_V_MF2_M4, VSOXSEG2EI8_V, 0x2 }, // 8671
  { PseudoVSOXSEG2EI8_V_MF2_M4_MASK, VSOXSEG2EI8_V, 0x2 }, // 8672
  { PseudoVSOXSEG2EI8_V_MF8_MF8, VSOXSEG2EI8_V, 0x5 }, // 8673
  { PseudoVSOXSEG2EI8_V_MF8_MF8_MASK, VSOXSEG2EI8_V, 0x5 }, // 8674
  { PseudoVSOXSEG2EI8_V_MF4_MF4, VSOXSEG2EI8_V, 0x6 }, // 8675
  { PseudoVSOXSEG2EI8_V_MF4_MF4_MASK, VSOXSEG2EI8_V, 0x6 }, // 8676
  { PseudoVSOXSEG2EI8_V_MF8_MF4, VSOXSEG2EI8_V, 0x6 }, // 8677
  { PseudoVSOXSEG2EI8_V_MF8_MF4_MASK, VSOXSEG2EI8_V, 0x6 }, // 8678
  { PseudoVSOXSEG2EI8_V_MF2_MF2, VSOXSEG2EI8_V, 0x7 }, // 8679
  { PseudoVSOXSEG2EI8_V_MF2_MF2_MASK, VSOXSEG2EI8_V, 0x7 }, // 8680
  { PseudoVSOXSEG2EI8_V_MF4_MF2, VSOXSEG2EI8_V, 0x7 }, // 8681
  { PseudoVSOXSEG2EI8_V_MF4_MF2_MASK, VSOXSEG2EI8_V, 0x7 }, // 8682
  { PseudoVSOXSEG2EI8_V_MF8_MF2, VSOXSEG2EI8_V, 0x7 }, // 8683
  { PseudoVSOXSEG2EI8_V_MF8_MF2_MASK, VSOXSEG2EI8_V, 0x7 }, // 8684
  { PseudoVSOXSEG3EI16_V_M1_M1, VSOXSEG3EI16_V, 0x0 }, // 8685
  { PseudoVSOXSEG3EI16_V_M1_M1_MASK, VSOXSEG3EI16_V, 0x0 }, // 8686
  { PseudoVSOXSEG3EI16_V_M2_M1, VSOXSEG3EI16_V, 0x0 }, // 8687
  { PseudoVSOXSEG3EI16_V_M2_M1_MASK, VSOXSEG3EI16_V, 0x0 }, // 8688
  { PseudoVSOXSEG3EI16_V_MF2_M1, VSOXSEG3EI16_V, 0x0 }, // 8689
  { PseudoVSOXSEG3EI16_V_MF2_M1_MASK, VSOXSEG3EI16_V, 0x0 }, // 8690
  { PseudoVSOXSEG3EI16_V_MF4_M1, VSOXSEG3EI16_V, 0x0 }, // 8691
  { PseudoVSOXSEG3EI16_V_MF4_M1_MASK, VSOXSEG3EI16_V, 0x0 }, // 8692
  { PseudoVSOXSEG3EI16_V_M1_M2, VSOXSEG3EI16_V, 0x1 }, // 8693
  { PseudoVSOXSEG3EI16_V_M1_M2_MASK, VSOXSEG3EI16_V, 0x1 }, // 8694
  { PseudoVSOXSEG3EI16_V_M2_M2, VSOXSEG3EI16_V, 0x1 }, // 8695
  { PseudoVSOXSEG3EI16_V_M2_M2_MASK, VSOXSEG3EI16_V, 0x1 }, // 8696
  { PseudoVSOXSEG3EI16_V_M4_M2, VSOXSEG3EI16_V, 0x1 }, // 8697
  { PseudoVSOXSEG3EI16_V_M4_M2_MASK, VSOXSEG3EI16_V, 0x1 }, // 8698
  { PseudoVSOXSEG3EI16_V_MF2_M2, VSOXSEG3EI16_V, 0x1 }, // 8699
  { PseudoVSOXSEG3EI16_V_MF2_M2_MASK, VSOXSEG3EI16_V, 0x1 }, // 8700
  { PseudoVSOXSEG3EI16_V_MF4_MF8, VSOXSEG3EI16_V, 0x5 }, // 8701
  { PseudoVSOXSEG3EI16_V_MF4_MF8_MASK, VSOXSEG3EI16_V, 0x5 }, // 8702
  { PseudoVSOXSEG3EI16_V_MF2_MF4, VSOXSEG3EI16_V, 0x6 }, // 8703
  { PseudoVSOXSEG3EI16_V_MF2_MF4_MASK, VSOXSEG3EI16_V, 0x6 }, // 8704
  { PseudoVSOXSEG3EI16_V_MF4_MF4, VSOXSEG3EI16_V, 0x6 }, // 8705
  { PseudoVSOXSEG3EI16_V_MF4_MF4_MASK, VSOXSEG3EI16_V, 0x6 }, // 8706
  { PseudoVSOXSEG3EI16_V_M1_MF2, VSOXSEG3EI16_V, 0x7 }, // 8707
  { PseudoVSOXSEG3EI16_V_M1_MF2_MASK, VSOXSEG3EI16_V, 0x7 }, // 8708
  { PseudoVSOXSEG3EI16_V_MF2_MF2, VSOXSEG3EI16_V, 0x7 }, // 8709
  { PseudoVSOXSEG3EI16_V_MF2_MF2_MASK, VSOXSEG3EI16_V, 0x7 }, // 8710
  { PseudoVSOXSEG3EI16_V_MF4_MF2, VSOXSEG3EI16_V, 0x7 }, // 8711
  { PseudoVSOXSEG3EI16_V_MF4_MF2_MASK, VSOXSEG3EI16_V, 0x7 }, // 8712
  { PseudoVSOXSEG3EI32_V_M1_M1, VSOXSEG3EI32_V, 0x0 }, // 8713
  { PseudoVSOXSEG3EI32_V_M1_M1_MASK, VSOXSEG3EI32_V, 0x0 }, // 8714
  { PseudoVSOXSEG3EI32_V_M2_M1, VSOXSEG3EI32_V, 0x0 }, // 8715
  { PseudoVSOXSEG3EI32_V_M2_M1_MASK, VSOXSEG3EI32_V, 0x0 }, // 8716
  { PseudoVSOXSEG3EI32_V_M4_M1, VSOXSEG3EI32_V, 0x0 }, // 8717
  { PseudoVSOXSEG3EI32_V_M4_M1_MASK, VSOXSEG3EI32_V, 0x0 }, // 8718
  { PseudoVSOXSEG3EI32_V_MF2_M1, VSOXSEG3EI32_V, 0x0 }, // 8719
  { PseudoVSOXSEG3EI32_V_MF2_M1_MASK, VSOXSEG3EI32_V, 0x0 }, // 8720
  { PseudoVSOXSEG3EI32_V_M1_M2, VSOXSEG3EI32_V, 0x1 }, // 8721
  { PseudoVSOXSEG3EI32_V_M1_M2_MASK, VSOXSEG3EI32_V, 0x1 }, // 8722
  { PseudoVSOXSEG3EI32_V_M2_M2, VSOXSEG3EI32_V, 0x1 }, // 8723
  { PseudoVSOXSEG3EI32_V_M2_M2_MASK, VSOXSEG3EI32_V, 0x1 }, // 8724
  { PseudoVSOXSEG3EI32_V_M4_M2, VSOXSEG3EI32_V, 0x1 }, // 8725
  { PseudoVSOXSEG3EI32_V_M4_M2_MASK, VSOXSEG3EI32_V, 0x1 }, // 8726
  { PseudoVSOXSEG3EI32_V_M8_M2, VSOXSEG3EI32_V, 0x1 }, // 8727
  { PseudoVSOXSEG3EI32_V_M8_M2_MASK, VSOXSEG3EI32_V, 0x1 }, // 8728
  { PseudoVSOXSEG3EI32_V_MF2_MF8, VSOXSEG3EI32_V, 0x5 }, // 8729
  { PseudoVSOXSEG3EI32_V_MF2_MF8_MASK, VSOXSEG3EI32_V, 0x5 }, // 8730
  { PseudoVSOXSEG3EI32_V_M1_MF4, VSOXSEG3EI32_V, 0x6 }, // 8731
  { PseudoVSOXSEG3EI32_V_M1_MF4_MASK, VSOXSEG3EI32_V, 0x6 }, // 8732
  { PseudoVSOXSEG3EI32_V_MF2_MF4, VSOXSEG3EI32_V, 0x6 }, // 8733
  { PseudoVSOXSEG3EI32_V_MF2_MF4_MASK, VSOXSEG3EI32_V, 0x6 }, // 8734
  { PseudoVSOXSEG3EI32_V_M1_MF2, VSOXSEG3EI32_V, 0x7 }, // 8735
  { PseudoVSOXSEG3EI32_V_M1_MF2_MASK, VSOXSEG3EI32_V, 0x7 }, // 8736
  { PseudoVSOXSEG3EI32_V_M2_MF2, VSOXSEG3EI32_V, 0x7 }, // 8737
  { PseudoVSOXSEG3EI32_V_M2_MF2_MASK, VSOXSEG3EI32_V, 0x7 }, // 8738
  { PseudoVSOXSEG3EI32_V_MF2_MF2, VSOXSEG3EI32_V, 0x7 }, // 8739
  { PseudoVSOXSEG3EI32_V_MF2_MF2_MASK, VSOXSEG3EI32_V, 0x7 }, // 8740
  { PseudoVSOXSEG3EI64_V_M1_M1, VSOXSEG3EI64_V, 0x0 }, // 8741
  { PseudoVSOXSEG3EI64_V_M1_M1_MASK, VSOXSEG3EI64_V, 0x0 }, // 8742
  { PseudoVSOXSEG3EI64_V_M2_M1, VSOXSEG3EI64_V, 0x0 }, // 8743
  { PseudoVSOXSEG3EI64_V_M2_M1_MASK, VSOXSEG3EI64_V, 0x0 }, // 8744
  { PseudoVSOXSEG3EI64_V_M4_M1, VSOXSEG3EI64_V, 0x0 }, // 8745
  { PseudoVSOXSEG3EI64_V_M4_M1_MASK, VSOXSEG3EI64_V, 0x0 }, // 8746
  { PseudoVSOXSEG3EI64_V_M8_M1, VSOXSEG3EI64_V, 0x0 }, // 8747
  { PseudoVSOXSEG3EI64_V_M8_M1_MASK, VSOXSEG3EI64_V, 0x0 }, // 8748
  { PseudoVSOXSEG3EI64_V_M2_M2, VSOXSEG3EI64_V, 0x1 }, // 8749
  { PseudoVSOXSEG3EI64_V_M2_M2_MASK, VSOXSEG3EI64_V, 0x1 }, // 8750
  { PseudoVSOXSEG3EI64_V_M4_M2, VSOXSEG3EI64_V, 0x1 }, // 8751
  { PseudoVSOXSEG3EI64_V_M4_M2_MASK, VSOXSEG3EI64_V, 0x1 }, // 8752
  { PseudoVSOXSEG3EI64_V_M8_M2, VSOXSEG3EI64_V, 0x1 }, // 8753
  { PseudoVSOXSEG3EI64_V_M8_M2_MASK, VSOXSEG3EI64_V, 0x1 }, // 8754
  { PseudoVSOXSEG3EI64_V_M1_MF8, VSOXSEG3EI64_V, 0x5 }, // 8755
  { PseudoVSOXSEG3EI64_V_M1_MF8_MASK, VSOXSEG3EI64_V, 0x5 }, // 8756
  { PseudoVSOXSEG3EI64_V_M1_MF4, VSOXSEG3EI64_V, 0x6 }, // 8757
  { PseudoVSOXSEG3EI64_V_M1_MF4_MASK, VSOXSEG3EI64_V, 0x6 }, // 8758
  { PseudoVSOXSEG3EI64_V_M2_MF4, VSOXSEG3EI64_V, 0x6 }, // 8759
  { PseudoVSOXSEG3EI64_V_M2_MF4_MASK, VSOXSEG3EI64_V, 0x6 }, // 8760
  { PseudoVSOXSEG3EI64_V_M1_MF2, VSOXSEG3EI64_V, 0x7 }, // 8761
  { PseudoVSOXSEG3EI64_V_M1_MF2_MASK, VSOXSEG3EI64_V, 0x7 }, // 8762
  { PseudoVSOXSEG3EI64_V_M2_MF2, VSOXSEG3EI64_V, 0x7 }, // 8763
  { PseudoVSOXSEG3EI64_V_M2_MF2_MASK, VSOXSEG3EI64_V, 0x7 }, // 8764
  { PseudoVSOXSEG3EI64_V_M4_MF2, VSOXSEG3EI64_V, 0x7 }, // 8765
  { PseudoVSOXSEG3EI64_V_M4_MF2_MASK, VSOXSEG3EI64_V, 0x7 }, // 8766
  { PseudoVSOXSEG3EI8_V_M1_M1, VSOXSEG3EI8_V, 0x0 }, // 8767
  { PseudoVSOXSEG3EI8_V_M1_M1_MASK, VSOXSEG3EI8_V, 0x0 }, // 8768
  { PseudoVSOXSEG3EI8_V_MF2_M1, VSOXSEG3EI8_V, 0x0 }, // 8769
  { PseudoVSOXSEG3EI8_V_MF2_M1_MASK, VSOXSEG3EI8_V, 0x0 }, // 8770
  { PseudoVSOXSEG3EI8_V_MF4_M1, VSOXSEG3EI8_V, 0x0 }, // 8771
  { PseudoVSOXSEG3EI8_V_MF4_M1_MASK, VSOXSEG3EI8_V, 0x0 }, // 8772
  { PseudoVSOXSEG3EI8_V_MF8_M1, VSOXSEG3EI8_V, 0x0 }, // 8773
  { PseudoVSOXSEG3EI8_V_MF8_M1_MASK, VSOXSEG3EI8_V, 0x0 }, // 8774
  { PseudoVSOXSEG3EI8_V_M1_M2, VSOXSEG3EI8_V, 0x1 }, // 8775
  { PseudoVSOXSEG3EI8_V_M1_M2_MASK, VSOXSEG3EI8_V, 0x1 }, // 8776
  { PseudoVSOXSEG3EI8_V_M2_M2, VSOXSEG3EI8_V, 0x1 }, // 8777
  { PseudoVSOXSEG3EI8_V_M2_M2_MASK, VSOXSEG3EI8_V, 0x1 }, // 8778
  { PseudoVSOXSEG3EI8_V_MF2_M2, VSOXSEG3EI8_V, 0x1 }, // 8779
  { PseudoVSOXSEG3EI8_V_MF2_M2_MASK, VSOXSEG3EI8_V, 0x1 }, // 8780
  { PseudoVSOXSEG3EI8_V_MF4_M2, VSOXSEG3EI8_V, 0x1 }, // 8781
  { PseudoVSOXSEG3EI8_V_MF4_M2_MASK, VSOXSEG3EI8_V, 0x1 }, // 8782
  { PseudoVSOXSEG3EI8_V_MF8_MF8, VSOXSEG3EI8_V, 0x5 }, // 8783
  { PseudoVSOXSEG3EI8_V_MF8_MF8_MASK, VSOXSEG3EI8_V, 0x5 }, // 8784
  { PseudoVSOXSEG3EI8_V_MF4_MF4, VSOXSEG3EI8_V, 0x6 }, // 8785
  { PseudoVSOXSEG3EI8_V_MF4_MF4_MASK, VSOXSEG3EI8_V, 0x6 }, // 8786
  { PseudoVSOXSEG3EI8_V_MF8_MF4, VSOXSEG3EI8_V, 0x6 }, // 8787
  { PseudoVSOXSEG3EI8_V_MF8_MF4_MASK, VSOXSEG3EI8_V, 0x6 }, // 8788
  { PseudoVSOXSEG3EI8_V_MF2_MF2, VSOXSEG3EI8_V, 0x7 }, // 8789
  { PseudoVSOXSEG3EI8_V_MF2_MF2_MASK, VSOXSEG3EI8_V, 0x7 }, // 8790
  { PseudoVSOXSEG3EI8_V_MF4_MF2, VSOXSEG3EI8_V, 0x7 }, // 8791
  { PseudoVSOXSEG3EI8_V_MF4_MF2_MASK, VSOXSEG3EI8_V, 0x7 }, // 8792
  { PseudoVSOXSEG3EI8_V_MF8_MF2, VSOXSEG3EI8_V, 0x7 }, // 8793
  { PseudoVSOXSEG3EI8_V_MF8_MF2_MASK, VSOXSEG3EI8_V, 0x7 }, // 8794
  { PseudoVSOXSEG4EI16_V_M1_M1, VSOXSEG4EI16_V, 0x0 }, // 8795
  { PseudoVSOXSEG4EI16_V_M1_M1_MASK, VSOXSEG4EI16_V, 0x0 }, // 8796
  { PseudoVSOXSEG4EI16_V_M2_M1, VSOXSEG4EI16_V, 0x0 }, // 8797
  { PseudoVSOXSEG4EI16_V_M2_M1_MASK, VSOXSEG4EI16_V, 0x0 }, // 8798
  { PseudoVSOXSEG4EI16_V_MF2_M1, VSOXSEG4EI16_V, 0x0 }, // 8799
  { PseudoVSOXSEG4EI16_V_MF2_M1_MASK, VSOXSEG4EI16_V, 0x0 }, // 8800
  { PseudoVSOXSEG4EI16_V_MF4_M1, VSOXSEG4EI16_V, 0x0 }, // 8801
  { PseudoVSOXSEG4EI16_V_MF4_M1_MASK, VSOXSEG4EI16_V, 0x0 }, // 8802
  { PseudoVSOXSEG4EI16_V_M1_M2, VSOXSEG4EI16_V, 0x1 }, // 8803
  { PseudoVSOXSEG4EI16_V_M1_M2_MASK, VSOXSEG4EI16_V, 0x1 }, // 8804
  { PseudoVSOXSEG4EI16_V_M2_M2, VSOXSEG4EI16_V, 0x1 }, // 8805
  { PseudoVSOXSEG4EI16_V_M2_M2_MASK, VSOXSEG4EI16_V, 0x1 }, // 8806
  { PseudoVSOXSEG4EI16_V_M4_M2, VSOXSEG4EI16_V, 0x1 }, // 8807
  { PseudoVSOXSEG4EI16_V_M4_M2_MASK, VSOXSEG4EI16_V, 0x1 }, // 8808
  { PseudoVSOXSEG4EI16_V_MF2_M2, VSOXSEG4EI16_V, 0x1 }, // 8809
  { PseudoVSOXSEG4EI16_V_MF2_M2_MASK, VSOXSEG4EI16_V, 0x1 }, // 8810
  { PseudoVSOXSEG4EI16_V_MF4_MF8, VSOXSEG4EI16_V, 0x5 }, // 8811
  { PseudoVSOXSEG4EI16_V_MF4_MF8_MASK, VSOXSEG4EI16_V, 0x5 }, // 8812
  { PseudoVSOXSEG4EI16_V_MF2_MF4, VSOXSEG4EI16_V, 0x6 }, // 8813
  { PseudoVSOXSEG4EI16_V_MF2_MF4_MASK, VSOXSEG4EI16_V, 0x6 }, // 8814
  { PseudoVSOXSEG4EI16_V_MF4_MF4, VSOXSEG4EI16_V, 0x6 }, // 8815
  { PseudoVSOXSEG4EI16_V_MF4_MF4_MASK, VSOXSEG4EI16_V, 0x6 }, // 8816
  { PseudoVSOXSEG4EI16_V_M1_MF2, VSOXSEG4EI16_V, 0x7 }, // 8817
  { PseudoVSOXSEG4EI16_V_M1_MF2_MASK, VSOXSEG4EI16_V, 0x7 }, // 8818
  { PseudoVSOXSEG4EI16_V_MF2_MF2, VSOXSEG4EI16_V, 0x7 }, // 8819
  { PseudoVSOXSEG4EI16_V_MF2_MF2_MASK, VSOXSEG4EI16_V, 0x7 }, // 8820
  { PseudoVSOXSEG4EI16_V_MF4_MF2, VSOXSEG4EI16_V, 0x7 }, // 8821
  { PseudoVSOXSEG4EI16_V_MF4_MF2_MASK, VSOXSEG4EI16_V, 0x7 }, // 8822
  { PseudoVSOXSEG4EI32_V_M1_M1, VSOXSEG4EI32_V, 0x0 }, // 8823
  { PseudoVSOXSEG4EI32_V_M1_M1_MASK, VSOXSEG4EI32_V, 0x0 }, // 8824
  { PseudoVSOXSEG4EI32_V_M2_M1, VSOXSEG4EI32_V, 0x0 }, // 8825
  { PseudoVSOXSEG4EI32_V_M2_M1_MASK, VSOXSEG4EI32_V, 0x0 }, // 8826
  { PseudoVSOXSEG4EI32_V_M4_M1, VSOXSEG4EI32_V, 0x0 }, // 8827
  { PseudoVSOXSEG4EI32_V_M4_M1_MASK, VSOXSEG4EI32_V, 0x0 }, // 8828
  { PseudoVSOXSEG4EI32_V_MF2_M1, VSOXSEG4EI32_V, 0x0 }, // 8829
  { PseudoVSOXSEG4EI32_V_MF2_M1_MASK, VSOXSEG4EI32_V, 0x0 }, // 8830
  { PseudoVSOXSEG4EI32_V_M1_M2, VSOXSEG4EI32_V, 0x1 }, // 8831
  { PseudoVSOXSEG4EI32_V_M1_M2_MASK, VSOXSEG4EI32_V, 0x1 }, // 8832
  { PseudoVSOXSEG4EI32_V_M2_M2, VSOXSEG4EI32_V, 0x1 }, // 8833
  { PseudoVSOXSEG4EI32_V_M2_M2_MASK, VSOXSEG4EI32_V, 0x1 }, // 8834
  { PseudoVSOXSEG4EI32_V_M4_M2, VSOXSEG4EI32_V, 0x1 }, // 8835
  { PseudoVSOXSEG4EI32_V_M4_M2_MASK, VSOXSEG4EI32_V, 0x1 }, // 8836
  { PseudoVSOXSEG4EI32_V_M8_M2, VSOXSEG4EI32_V, 0x1 }, // 8837
  { PseudoVSOXSEG4EI32_V_M8_M2_MASK, VSOXSEG4EI32_V, 0x1 }, // 8838
  { PseudoVSOXSEG4EI32_V_MF2_MF8, VSOXSEG4EI32_V, 0x5 }, // 8839
  { PseudoVSOXSEG4EI32_V_MF2_MF8_MASK, VSOXSEG4EI32_V, 0x5 }, // 8840
  { PseudoVSOXSEG4EI32_V_M1_MF4, VSOXSEG4EI32_V, 0x6 }, // 8841
  { PseudoVSOXSEG4EI32_V_M1_MF4_MASK, VSOXSEG4EI32_V, 0x6 }, // 8842
  { PseudoVSOXSEG4EI32_V_MF2_MF4, VSOXSEG4EI32_V, 0x6 }, // 8843
  { PseudoVSOXSEG4EI32_V_MF2_MF4_MASK, VSOXSEG4EI32_V, 0x6 }, // 8844
  { PseudoVSOXSEG4EI32_V_M1_MF2, VSOXSEG4EI32_V, 0x7 }, // 8845
  { PseudoVSOXSEG4EI32_V_M1_MF2_MASK, VSOXSEG4EI32_V, 0x7 }, // 8846
  { PseudoVSOXSEG4EI32_V_M2_MF2, VSOXSEG4EI32_V, 0x7 }, // 8847
  { PseudoVSOXSEG4EI32_V_M2_MF2_MASK, VSOXSEG4EI32_V, 0x7 }, // 8848
  { PseudoVSOXSEG4EI32_V_MF2_MF2, VSOXSEG4EI32_V, 0x7 }, // 8849
  { PseudoVSOXSEG4EI32_V_MF2_MF2_MASK, VSOXSEG4EI32_V, 0x7 }, // 8850
  { PseudoVSOXSEG4EI64_V_M1_M1, VSOXSEG4EI64_V, 0x0 }, // 8851
  { PseudoVSOXSEG4EI64_V_M1_M1_MASK, VSOXSEG4EI64_V, 0x0 }, // 8852
  { PseudoVSOXSEG4EI64_V_M2_M1, VSOXSEG4EI64_V, 0x0 }, // 8853
  { PseudoVSOXSEG4EI64_V_M2_M1_MASK, VSOXSEG4EI64_V, 0x0 }, // 8854
  { PseudoVSOXSEG4EI64_V_M4_M1, VSOXSEG4EI64_V, 0x0 }, // 8855
  { PseudoVSOXSEG4EI64_V_M4_M1_MASK, VSOXSEG4EI64_V, 0x0 }, // 8856
  { PseudoVSOXSEG4EI64_V_M8_M1, VSOXSEG4EI64_V, 0x0 }, // 8857
  { PseudoVSOXSEG4EI64_V_M8_M1_MASK, VSOXSEG4EI64_V, 0x0 }, // 8858
  { PseudoVSOXSEG4EI64_V_M2_M2, VSOXSEG4EI64_V, 0x1 }, // 8859
  { PseudoVSOXSEG4EI64_V_M2_M2_MASK, VSOXSEG4EI64_V, 0x1 }, // 8860
  { PseudoVSOXSEG4EI64_V_M4_M2, VSOXSEG4EI64_V, 0x1 }, // 8861
  { PseudoVSOXSEG4EI64_V_M4_M2_MASK, VSOXSEG4EI64_V, 0x1 }, // 8862
  { PseudoVSOXSEG4EI64_V_M8_M2, VSOXSEG4EI64_V, 0x1 }, // 8863
  { PseudoVSOXSEG4EI64_V_M8_M2_MASK, VSOXSEG4EI64_V, 0x1 }, // 8864
  { PseudoVSOXSEG4EI64_V_M1_MF8, VSOXSEG4EI64_V, 0x5 }, // 8865
  { PseudoVSOXSEG4EI64_V_M1_MF8_MASK, VSOXSEG4EI64_V, 0x5 }, // 8866
  { PseudoVSOXSEG4EI64_V_M1_MF4, VSOXSEG4EI64_V, 0x6 }, // 8867
  { PseudoVSOXSEG4EI64_V_M1_MF4_MASK, VSOXSEG4EI64_V, 0x6 }, // 8868
  { PseudoVSOXSEG4EI64_V_M2_MF4, VSOXSEG4EI64_V, 0x6 }, // 8869
  { PseudoVSOXSEG4EI64_V_M2_MF4_MASK, VSOXSEG4EI64_V, 0x6 }, // 8870
  { PseudoVSOXSEG4EI64_V_M1_MF2, VSOXSEG4EI64_V, 0x7 }, // 8871
  { PseudoVSOXSEG4EI64_V_M1_MF2_MASK, VSOXSEG4EI64_V, 0x7 }, // 8872
  { PseudoVSOXSEG4EI64_V_M2_MF2, VSOXSEG4EI64_V, 0x7 }, // 8873
  { PseudoVSOXSEG4EI64_V_M2_MF2_MASK, VSOXSEG4EI64_V, 0x7 }, // 8874
  { PseudoVSOXSEG4EI64_V_M4_MF2, VSOXSEG4EI64_V, 0x7 }, // 8875
  { PseudoVSOXSEG4EI64_V_M4_MF2_MASK, VSOXSEG4EI64_V, 0x7 }, // 8876
  { PseudoVSOXSEG4EI8_V_M1_M1, VSOXSEG4EI8_V, 0x0 }, // 8877
  { PseudoVSOXSEG4EI8_V_M1_M1_MASK, VSOXSEG4EI8_V, 0x0 }, // 8878
  { PseudoVSOXSEG4EI8_V_MF2_M1, VSOXSEG4EI8_V, 0x0 }, // 8879
  { PseudoVSOXSEG4EI8_V_MF2_M1_MASK, VSOXSEG4EI8_V, 0x0 }, // 8880
  { PseudoVSOXSEG4EI8_V_MF4_M1, VSOXSEG4EI8_V, 0x0 }, // 8881
  { PseudoVSOXSEG4EI8_V_MF4_M1_MASK, VSOXSEG4EI8_V, 0x0 }, // 8882
  { PseudoVSOXSEG4EI8_V_MF8_M1, VSOXSEG4EI8_V, 0x0 }, // 8883
  { PseudoVSOXSEG4EI8_V_MF8_M1_MASK, VSOXSEG4EI8_V, 0x0 }, // 8884
  { PseudoVSOXSEG4EI8_V_M1_M2, VSOXSEG4EI8_V, 0x1 }, // 8885
  { PseudoVSOXSEG4EI8_V_M1_M2_MASK, VSOXSEG4EI8_V, 0x1 }, // 8886
  { PseudoVSOXSEG4EI8_V_M2_M2, VSOXSEG4EI8_V, 0x1 }, // 8887
  { PseudoVSOXSEG4EI8_V_M2_M2_MASK, VSOXSEG4EI8_V, 0x1 }, // 8888
  { PseudoVSOXSEG4EI8_V_MF2_M2, VSOXSEG4EI8_V, 0x1 }, // 8889
  { PseudoVSOXSEG4EI8_V_MF2_M2_MASK, VSOXSEG4EI8_V, 0x1 }, // 8890
  { PseudoVSOXSEG4EI8_V_MF4_M2, VSOXSEG4EI8_V, 0x1 }, // 8891
  { PseudoVSOXSEG4EI8_V_MF4_M2_MASK, VSOXSEG4EI8_V, 0x1 }, // 8892
  { PseudoVSOXSEG4EI8_V_MF8_MF8, VSOXSEG4EI8_V, 0x5 }, // 8893
  { PseudoVSOXSEG4EI8_V_MF8_MF8_MASK, VSOXSEG4EI8_V, 0x5 }, // 8894
  { PseudoVSOXSEG4EI8_V_MF4_MF4, VSOXSEG4EI8_V, 0x6 }, // 8895
  { PseudoVSOXSEG4EI8_V_MF4_MF4_MASK, VSOXSEG4EI8_V, 0x6 }, // 8896
  { PseudoVSOXSEG4EI8_V_MF8_MF4, VSOXSEG4EI8_V, 0x6 }, // 8897
  { PseudoVSOXSEG4EI8_V_MF8_MF4_MASK, VSOXSEG4EI8_V, 0x6 }, // 8898
  { PseudoVSOXSEG4EI8_V_MF2_MF2, VSOXSEG4EI8_V, 0x7 }, // 8899
  { PseudoVSOXSEG4EI8_V_MF2_MF2_MASK, VSOXSEG4EI8_V, 0x7 }, // 8900
  { PseudoVSOXSEG4EI8_V_MF4_MF2, VSOXSEG4EI8_V, 0x7 }, // 8901
  { PseudoVSOXSEG4EI8_V_MF4_MF2_MASK, VSOXSEG4EI8_V, 0x7 }, // 8902
  { PseudoVSOXSEG4EI8_V_MF8_MF2, VSOXSEG4EI8_V, 0x7 }, // 8903
  { PseudoVSOXSEG4EI8_V_MF8_MF2_MASK, VSOXSEG4EI8_V, 0x7 }, // 8904
  { PseudoVSOXSEG5EI16_V_M1_M1, VSOXSEG5EI16_V, 0x0 }, // 8905
  { PseudoVSOXSEG5EI16_V_M1_M1_MASK, VSOXSEG5EI16_V, 0x0 }, // 8906
  { PseudoVSOXSEG5EI16_V_M2_M1, VSOXSEG5EI16_V, 0x0 }, // 8907
  { PseudoVSOXSEG5EI16_V_M2_M1_MASK, VSOXSEG5EI16_V, 0x0 }, // 8908
  { PseudoVSOXSEG5EI16_V_MF2_M1, VSOXSEG5EI16_V, 0x0 }, // 8909
  { PseudoVSOXSEG5EI16_V_MF2_M1_MASK, VSOXSEG5EI16_V, 0x0 }, // 8910
  { PseudoVSOXSEG5EI16_V_MF4_M1, VSOXSEG5EI16_V, 0x0 }, // 8911
  { PseudoVSOXSEG5EI16_V_MF4_M1_MASK, VSOXSEG5EI16_V, 0x0 }, // 8912
  { PseudoVSOXSEG5EI16_V_MF4_MF8, VSOXSEG5EI16_V, 0x5 }, // 8913
  { PseudoVSOXSEG5EI16_V_MF4_MF8_MASK, VSOXSEG5EI16_V, 0x5 }, // 8914
  { PseudoVSOXSEG5EI16_V_MF2_MF4, VSOXSEG5EI16_V, 0x6 }, // 8915
  { PseudoVSOXSEG5EI16_V_MF2_MF4_MASK, VSOXSEG5EI16_V, 0x6 }, // 8916
  { PseudoVSOXSEG5EI16_V_MF4_MF4, VSOXSEG5EI16_V, 0x6 }, // 8917
  { PseudoVSOXSEG5EI16_V_MF4_MF4_MASK, VSOXSEG5EI16_V, 0x6 }, // 8918
  { PseudoVSOXSEG5EI16_V_M1_MF2, VSOXSEG5EI16_V, 0x7 }, // 8919
  { PseudoVSOXSEG5EI16_V_M1_MF2_MASK, VSOXSEG5EI16_V, 0x7 }, // 8920
  { PseudoVSOXSEG5EI16_V_MF2_MF2, VSOXSEG5EI16_V, 0x7 }, // 8921
  { PseudoVSOXSEG5EI16_V_MF2_MF2_MASK, VSOXSEG5EI16_V, 0x7 }, // 8922
  { PseudoVSOXSEG5EI16_V_MF4_MF2, VSOXSEG5EI16_V, 0x7 }, // 8923
  { PseudoVSOXSEG5EI16_V_MF4_MF2_MASK, VSOXSEG5EI16_V, 0x7 }, // 8924
  { PseudoVSOXSEG5EI32_V_M1_M1, VSOXSEG5EI32_V, 0x0 }, // 8925
  { PseudoVSOXSEG5EI32_V_M1_M1_MASK, VSOXSEG5EI32_V, 0x0 }, // 8926
  { PseudoVSOXSEG5EI32_V_M2_M1, VSOXSEG5EI32_V, 0x0 }, // 8927
  { PseudoVSOXSEG5EI32_V_M2_M1_MASK, VSOXSEG5EI32_V, 0x0 }, // 8928
  { PseudoVSOXSEG5EI32_V_M4_M1, VSOXSEG5EI32_V, 0x0 }, // 8929
  { PseudoVSOXSEG5EI32_V_M4_M1_MASK, VSOXSEG5EI32_V, 0x0 }, // 8930
  { PseudoVSOXSEG5EI32_V_MF2_M1, VSOXSEG5EI32_V, 0x0 }, // 8931
  { PseudoVSOXSEG5EI32_V_MF2_M1_MASK, VSOXSEG5EI32_V, 0x0 }, // 8932
  { PseudoVSOXSEG5EI32_V_MF2_MF8, VSOXSEG5EI32_V, 0x5 }, // 8933
  { PseudoVSOXSEG5EI32_V_MF2_MF8_MASK, VSOXSEG5EI32_V, 0x5 }, // 8934
  { PseudoVSOXSEG5EI32_V_M1_MF4, VSOXSEG5EI32_V, 0x6 }, // 8935
  { PseudoVSOXSEG5EI32_V_M1_MF4_MASK, VSOXSEG5EI32_V, 0x6 }, // 8936
  { PseudoVSOXSEG5EI32_V_MF2_MF4, VSOXSEG5EI32_V, 0x6 }, // 8937
  { PseudoVSOXSEG5EI32_V_MF2_MF4_MASK, VSOXSEG5EI32_V, 0x6 }, // 8938
  { PseudoVSOXSEG5EI32_V_M1_MF2, VSOXSEG5EI32_V, 0x7 }, // 8939
  { PseudoVSOXSEG5EI32_V_M1_MF2_MASK, VSOXSEG5EI32_V, 0x7 }, // 8940
  { PseudoVSOXSEG5EI32_V_M2_MF2, VSOXSEG5EI32_V, 0x7 }, // 8941
  { PseudoVSOXSEG5EI32_V_M2_MF2_MASK, VSOXSEG5EI32_V, 0x7 }, // 8942
  { PseudoVSOXSEG5EI32_V_MF2_MF2, VSOXSEG5EI32_V, 0x7 }, // 8943
  { PseudoVSOXSEG5EI32_V_MF2_MF2_MASK, VSOXSEG5EI32_V, 0x7 }, // 8944
  { PseudoVSOXSEG5EI64_V_M1_M1, VSOXSEG5EI64_V, 0x0 }, // 8945
  { PseudoVSOXSEG5EI64_V_M1_M1_MASK, VSOXSEG5EI64_V, 0x0 }, // 8946
  { PseudoVSOXSEG5EI64_V_M2_M1, VSOXSEG5EI64_V, 0x0 }, // 8947
  { PseudoVSOXSEG5EI64_V_M2_M1_MASK, VSOXSEG5EI64_V, 0x0 }, // 8948
  { PseudoVSOXSEG5EI64_V_M4_M1, VSOXSEG5EI64_V, 0x0 }, // 8949
  { PseudoVSOXSEG5EI64_V_M4_M1_MASK, VSOXSEG5EI64_V, 0x0 }, // 8950
  { PseudoVSOXSEG5EI64_V_M8_M1, VSOXSEG5EI64_V, 0x0 }, // 8951
  { PseudoVSOXSEG5EI64_V_M8_M1_MASK, VSOXSEG5EI64_V, 0x0 }, // 8952
  { PseudoVSOXSEG5EI64_V_M1_MF8, VSOXSEG5EI64_V, 0x5 }, // 8953
  { PseudoVSOXSEG5EI64_V_M1_MF8_MASK, VSOXSEG5EI64_V, 0x5 }, // 8954
  { PseudoVSOXSEG5EI64_V_M1_MF4, VSOXSEG5EI64_V, 0x6 }, // 8955
  { PseudoVSOXSEG5EI64_V_M1_MF4_MASK, VSOXSEG5EI64_V, 0x6 }, // 8956
  { PseudoVSOXSEG5EI64_V_M2_MF4, VSOXSEG5EI64_V, 0x6 }, // 8957
  { PseudoVSOXSEG5EI64_V_M2_MF4_MASK, VSOXSEG5EI64_V, 0x6 }, // 8958
  { PseudoVSOXSEG5EI64_V_M1_MF2, VSOXSEG5EI64_V, 0x7 }, // 8959
  { PseudoVSOXSEG5EI64_V_M1_MF2_MASK, VSOXSEG5EI64_V, 0x7 }, // 8960
  { PseudoVSOXSEG5EI64_V_M2_MF2, VSOXSEG5EI64_V, 0x7 }, // 8961
  { PseudoVSOXSEG5EI64_V_M2_MF2_MASK, VSOXSEG5EI64_V, 0x7 }, // 8962
  { PseudoVSOXSEG5EI64_V_M4_MF2, VSOXSEG5EI64_V, 0x7 }, // 8963
  { PseudoVSOXSEG5EI64_V_M4_MF2_MASK, VSOXSEG5EI64_V, 0x7 }, // 8964
  { PseudoVSOXSEG5EI8_V_M1_M1, VSOXSEG5EI8_V, 0x0 }, // 8965
  { PseudoVSOXSEG5EI8_V_M1_M1_MASK, VSOXSEG5EI8_V, 0x0 }, // 8966
  { PseudoVSOXSEG5EI8_V_MF2_M1, VSOXSEG5EI8_V, 0x0 }, // 8967
  { PseudoVSOXSEG5EI8_V_MF2_M1_MASK, VSOXSEG5EI8_V, 0x0 }, // 8968
  { PseudoVSOXSEG5EI8_V_MF4_M1, VSOXSEG5EI8_V, 0x0 }, // 8969
  { PseudoVSOXSEG5EI8_V_MF4_M1_MASK, VSOXSEG5EI8_V, 0x0 }, // 8970
  { PseudoVSOXSEG5EI8_V_MF8_M1, VSOXSEG5EI8_V, 0x0 }, // 8971
  { PseudoVSOXSEG5EI8_V_MF8_M1_MASK, VSOXSEG5EI8_V, 0x0 }, // 8972
  { PseudoVSOXSEG5EI8_V_MF8_MF8, VSOXSEG5EI8_V, 0x5 }, // 8973
  { PseudoVSOXSEG5EI8_V_MF8_MF8_MASK, VSOXSEG5EI8_V, 0x5 }, // 8974
  { PseudoVSOXSEG5EI8_V_MF4_MF4, VSOXSEG5EI8_V, 0x6 }, // 8975
  { PseudoVSOXSEG5EI8_V_MF4_MF4_MASK, VSOXSEG5EI8_V, 0x6 }, // 8976
  { PseudoVSOXSEG5EI8_V_MF8_MF4, VSOXSEG5EI8_V, 0x6 }, // 8977
  { PseudoVSOXSEG5EI8_V_MF8_MF4_MASK, VSOXSEG5EI8_V, 0x6 }, // 8978
  { PseudoVSOXSEG5EI8_V_MF2_MF2, VSOXSEG5EI8_V, 0x7 }, // 8979
  { PseudoVSOXSEG5EI8_V_MF2_MF2_MASK, VSOXSEG5EI8_V, 0x7 }, // 8980
  { PseudoVSOXSEG5EI8_V_MF4_MF2, VSOXSEG5EI8_V, 0x7 }, // 8981
  { PseudoVSOXSEG5EI8_V_MF4_MF2_MASK, VSOXSEG5EI8_V, 0x7 }, // 8982
  { PseudoVSOXSEG5EI8_V_MF8_MF2, VSOXSEG5EI8_V, 0x7 }, // 8983
  { PseudoVSOXSEG5EI8_V_MF8_MF2_MASK, VSOXSEG5EI8_V, 0x7 }, // 8984
  { PseudoVSOXSEG6EI16_V_M1_M1, VSOXSEG6EI16_V, 0x0 }, // 8985
  { PseudoVSOXSEG6EI16_V_M1_M1_MASK, VSOXSEG6EI16_V, 0x0 }, // 8986
  { PseudoVSOXSEG6EI16_V_M2_M1, VSOXSEG6EI16_V, 0x0 }, // 8987
  { PseudoVSOXSEG6EI16_V_M2_M1_MASK, VSOXSEG6EI16_V, 0x0 }, // 8988
  { PseudoVSOXSEG6EI16_V_MF2_M1, VSOXSEG6EI16_V, 0x0 }, // 8989
  { PseudoVSOXSEG6EI16_V_MF2_M1_MASK, VSOXSEG6EI16_V, 0x0 }, // 8990
  { PseudoVSOXSEG6EI16_V_MF4_M1, VSOXSEG6EI16_V, 0x0 }, // 8991
  { PseudoVSOXSEG6EI16_V_MF4_M1_MASK, VSOXSEG6EI16_V, 0x0 }, // 8992
  { PseudoVSOXSEG6EI16_V_MF4_MF8, VSOXSEG6EI16_V, 0x5 }, // 8993
  { PseudoVSOXSEG6EI16_V_MF4_MF8_MASK, VSOXSEG6EI16_V, 0x5 }, // 8994
  { PseudoVSOXSEG6EI16_V_MF2_MF4, VSOXSEG6EI16_V, 0x6 }, // 8995
  { PseudoVSOXSEG6EI16_V_MF2_MF4_MASK, VSOXSEG6EI16_V, 0x6 }, // 8996
  { PseudoVSOXSEG6EI16_V_MF4_MF4, VSOXSEG6EI16_V, 0x6 }, // 8997
  { PseudoVSOXSEG6EI16_V_MF4_MF4_MASK, VSOXSEG6EI16_V, 0x6 }, // 8998
  { PseudoVSOXSEG6EI16_V_M1_MF2, VSOXSEG6EI16_V, 0x7 }, // 8999
  { PseudoVSOXSEG6EI16_V_M1_MF2_MASK, VSOXSEG6EI16_V, 0x7 }, // 9000
  { PseudoVSOXSEG6EI16_V_MF2_MF2, VSOXSEG6EI16_V, 0x7 }, // 9001
  { PseudoVSOXSEG6EI16_V_MF2_MF2_MASK, VSOXSEG6EI16_V, 0x7 }, // 9002
  { PseudoVSOXSEG6EI16_V_MF4_MF2, VSOXSEG6EI16_V, 0x7 }, // 9003
  { PseudoVSOXSEG6EI16_V_MF4_MF2_MASK, VSOXSEG6EI16_V, 0x7 }, // 9004
  { PseudoVSOXSEG6EI32_V_M1_M1, VSOXSEG6EI32_V, 0x0 }, // 9005
  { PseudoVSOXSEG6EI32_V_M1_M1_MASK, VSOXSEG6EI32_V, 0x0 }, // 9006
  { PseudoVSOXSEG6EI32_V_M2_M1, VSOXSEG6EI32_V, 0x0 }, // 9007
  { PseudoVSOXSEG6EI32_V_M2_M1_MASK, VSOXSEG6EI32_V, 0x0 }, // 9008
  { PseudoVSOXSEG6EI32_V_M4_M1, VSOXSEG6EI32_V, 0x0 }, // 9009
  { PseudoVSOXSEG6EI32_V_M4_M1_MASK, VSOXSEG6EI32_V, 0x0 }, // 9010
  { PseudoVSOXSEG6EI32_V_MF2_M1, VSOXSEG6EI32_V, 0x0 }, // 9011
  { PseudoVSOXSEG6EI32_V_MF2_M1_MASK, VSOXSEG6EI32_V, 0x0 }, // 9012
  { PseudoVSOXSEG6EI32_V_MF2_MF8, VSOXSEG6EI32_V, 0x5 }, // 9013
  { PseudoVSOXSEG6EI32_V_MF2_MF8_MASK, VSOXSEG6EI32_V, 0x5 }, // 9014
  { PseudoVSOXSEG6EI32_V_M1_MF4, VSOXSEG6EI32_V, 0x6 }, // 9015
  { PseudoVSOXSEG6EI32_V_M1_MF4_MASK, VSOXSEG6EI32_V, 0x6 }, // 9016
  { PseudoVSOXSEG6EI32_V_MF2_MF4, VSOXSEG6EI32_V, 0x6 }, // 9017
  { PseudoVSOXSEG6EI32_V_MF2_MF4_MASK, VSOXSEG6EI32_V, 0x6 }, // 9018
  { PseudoVSOXSEG6EI32_V_M1_MF2, VSOXSEG6EI32_V, 0x7 }, // 9019
  { PseudoVSOXSEG6EI32_V_M1_MF2_MASK, VSOXSEG6EI32_V, 0x7 }, // 9020
  { PseudoVSOXSEG6EI32_V_M2_MF2, VSOXSEG6EI32_V, 0x7 }, // 9021
  { PseudoVSOXSEG6EI32_V_M2_MF2_MASK, VSOXSEG6EI32_V, 0x7 }, // 9022
  { PseudoVSOXSEG6EI32_V_MF2_MF2, VSOXSEG6EI32_V, 0x7 }, // 9023
  { PseudoVSOXSEG6EI32_V_MF2_MF2_MASK, VSOXSEG6EI32_V, 0x7 }, // 9024
  { PseudoVSOXSEG6EI64_V_M1_M1, VSOXSEG6EI64_V, 0x0 }, // 9025
  { PseudoVSOXSEG6EI64_V_M1_M1_MASK, VSOXSEG6EI64_V, 0x0 }, // 9026
  { PseudoVSOXSEG6EI64_V_M2_M1, VSOXSEG6EI64_V, 0x0 }, // 9027
  { PseudoVSOXSEG6EI64_V_M2_M1_MASK, VSOXSEG6EI64_V, 0x0 }, // 9028
  { PseudoVSOXSEG6EI64_V_M4_M1, VSOXSEG6EI64_V, 0x0 }, // 9029
  { PseudoVSOXSEG6EI64_V_M4_M1_MASK, VSOXSEG6EI64_V, 0x0 }, // 9030
  { PseudoVSOXSEG6EI64_V_M8_M1, VSOXSEG6EI64_V, 0x0 }, // 9031
  { PseudoVSOXSEG6EI64_V_M8_M1_MASK, VSOXSEG6EI64_V, 0x0 }, // 9032
  { PseudoVSOXSEG6EI64_V_M1_MF8, VSOXSEG6EI64_V, 0x5 }, // 9033
  { PseudoVSOXSEG6EI64_V_M1_MF8_MASK, VSOXSEG6EI64_V, 0x5 }, // 9034
  { PseudoVSOXSEG6EI64_V_M1_MF4, VSOXSEG6EI64_V, 0x6 }, // 9035
  { PseudoVSOXSEG6EI64_V_M1_MF4_MASK, VSOXSEG6EI64_V, 0x6 }, // 9036
  { PseudoVSOXSEG6EI64_V_M2_MF4, VSOXSEG6EI64_V, 0x6 }, // 9037
  { PseudoVSOXSEG6EI64_V_M2_MF4_MASK, VSOXSEG6EI64_V, 0x6 }, // 9038
  { PseudoVSOXSEG6EI64_V_M1_MF2, VSOXSEG6EI64_V, 0x7 }, // 9039
  { PseudoVSOXSEG6EI64_V_M1_MF2_MASK, VSOXSEG6EI64_V, 0x7 }, // 9040
  { PseudoVSOXSEG6EI64_V_M2_MF2, VSOXSEG6EI64_V, 0x7 }, // 9041
  { PseudoVSOXSEG6EI64_V_M2_MF2_MASK, VSOXSEG6EI64_V, 0x7 }, // 9042
  { PseudoVSOXSEG6EI64_V_M4_MF2, VSOXSEG6EI64_V, 0x7 }, // 9043
  { PseudoVSOXSEG6EI64_V_M4_MF2_MASK, VSOXSEG6EI64_V, 0x7 }, // 9044
  { PseudoVSOXSEG6EI8_V_M1_M1, VSOXSEG6EI8_V, 0x0 }, // 9045
  { PseudoVSOXSEG6EI8_V_M1_M1_MASK, VSOXSEG6EI8_V, 0x0 }, // 9046
  { PseudoVSOXSEG6EI8_V_MF2_M1, VSOXSEG6EI8_V, 0x0 }, // 9047
  { PseudoVSOXSEG6EI8_V_MF2_M1_MASK, VSOXSEG6EI8_V, 0x0 }, // 9048
  { PseudoVSOXSEG6EI8_V_MF4_M1, VSOXSEG6EI8_V, 0x0 }, // 9049
  { PseudoVSOXSEG6EI8_V_MF4_M1_MASK, VSOXSEG6EI8_V, 0x0 }, // 9050
  { PseudoVSOXSEG6EI8_V_MF8_M1, VSOXSEG6EI8_V, 0x0 }, // 9051
  { PseudoVSOXSEG6EI8_V_MF8_M1_MASK, VSOXSEG6EI8_V, 0x0 }, // 9052
  { PseudoVSOXSEG6EI8_V_MF8_MF8, VSOXSEG6EI8_V, 0x5 }, // 9053
  { PseudoVSOXSEG6EI8_V_MF8_MF8_MASK, VSOXSEG6EI8_V, 0x5 }, // 9054
  { PseudoVSOXSEG6EI8_V_MF4_MF4, VSOXSEG6EI8_V, 0x6 }, // 9055
  { PseudoVSOXSEG6EI8_V_MF4_MF4_MASK, VSOXSEG6EI8_V, 0x6 }, // 9056
  { PseudoVSOXSEG6EI8_V_MF8_MF4, VSOXSEG6EI8_V, 0x6 }, // 9057
  { PseudoVSOXSEG6EI8_V_MF8_MF4_MASK, VSOXSEG6EI8_V, 0x6 }, // 9058
  { PseudoVSOXSEG6EI8_V_MF2_MF2, VSOXSEG6EI8_V, 0x7 }, // 9059
  { PseudoVSOXSEG6EI8_V_MF2_MF2_MASK, VSOXSEG6EI8_V, 0x7 }, // 9060
  { PseudoVSOXSEG6EI8_V_MF4_MF2, VSOXSEG6EI8_V, 0x7 }, // 9061
  { PseudoVSOXSEG6EI8_V_MF4_MF2_MASK, VSOXSEG6EI8_V, 0x7 }, // 9062
  { PseudoVSOXSEG6EI8_V_MF8_MF2, VSOXSEG6EI8_V, 0x7 }, // 9063
  { PseudoVSOXSEG6EI8_V_MF8_MF2_MASK, VSOXSEG6EI8_V, 0x7 }, // 9064
  { PseudoVSOXSEG7EI16_V_M1_M1, VSOXSEG7EI16_V, 0x0 }, // 9065
  { PseudoVSOXSEG7EI16_V_M1_M1_MASK, VSOXSEG7EI16_V, 0x0 }, // 9066
  { PseudoVSOXSEG7EI16_V_M2_M1, VSOXSEG7EI16_V, 0x0 }, // 9067
  { PseudoVSOXSEG7EI16_V_M2_M1_MASK, VSOXSEG7EI16_V, 0x0 }, // 9068
  { PseudoVSOXSEG7EI16_V_MF2_M1, VSOXSEG7EI16_V, 0x0 }, // 9069
  { PseudoVSOXSEG7EI16_V_MF2_M1_MASK, VSOXSEG7EI16_V, 0x0 }, // 9070
  { PseudoVSOXSEG7EI16_V_MF4_M1, VSOXSEG7EI16_V, 0x0 }, // 9071
  { PseudoVSOXSEG7EI16_V_MF4_M1_MASK, VSOXSEG7EI16_V, 0x0 }, // 9072
  { PseudoVSOXSEG7EI16_V_MF4_MF8, VSOXSEG7EI16_V, 0x5 }, // 9073
  { PseudoVSOXSEG7EI16_V_MF4_MF8_MASK, VSOXSEG7EI16_V, 0x5 }, // 9074
  { PseudoVSOXSEG7EI16_V_MF2_MF4, VSOXSEG7EI16_V, 0x6 }, // 9075
  { PseudoVSOXSEG7EI16_V_MF2_MF4_MASK, VSOXSEG7EI16_V, 0x6 }, // 9076
  { PseudoVSOXSEG7EI16_V_MF4_MF4, VSOXSEG7EI16_V, 0x6 }, // 9077
  { PseudoVSOXSEG7EI16_V_MF4_MF4_MASK, VSOXSEG7EI16_V, 0x6 }, // 9078
  { PseudoVSOXSEG7EI16_V_M1_MF2, VSOXSEG7EI16_V, 0x7 }, // 9079
  { PseudoVSOXSEG7EI16_V_M1_MF2_MASK, VSOXSEG7EI16_V, 0x7 }, // 9080
  { PseudoVSOXSEG7EI16_V_MF2_MF2, VSOXSEG7EI16_V, 0x7 }, // 9081
  { PseudoVSOXSEG7EI16_V_MF2_MF2_MASK, VSOXSEG7EI16_V, 0x7 }, // 9082
  { PseudoVSOXSEG7EI16_V_MF4_MF2, VSOXSEG7EI16_V, 0x7 }, // 9083
  { PseudoVSOXSEG7EI16_V_MF4_MF2_MASK, VSOXSEG7EI16_V, 0x7 }, // 9084
  { PseudoVSOXSEG7EI32_V_M1_M1, VSOXSEG7EI32_V, 0x0 }, // 9085
  { PseudoVSOXSEG7EI32_V_M1_M1_MASK, VSOXSEG7EI32_V, 0x0 }, // 9086
  { PseudoVSOXSEG7EI32_V_M2_M1, VSOXSEG7EI32_V, 0x0 }, // 9087
  { PseudoVSOXSEG7EI32_V_M2_M1_MASK, VSOXSEG7EI32_V, 0x0 }, // 9088
  { PseudoVSOXSEG7EI32_V_M4_M1, VSOXSEG7EI32_V, 0x0 }, // 9089
  { PseudoVSOXSEG7EI32_V_M4_M1_MASK, VSOXSEG7EI32_V, 0x0 }, // 9090
  { PseudoVSOXSEG7EI32_V_MF2_M1, VSOXSEG7EI32_V, 0x0 }, // 9091
  { PseudoVSOXSEG7EI32_V_MF2_M1_MASK, VSOXSEG7EI32_V, 0x0 }, // 9092
  { PseudoVSOXSEG7EI32_V_MF2_MF8, VSOXSEG7EI32_V, 0x5 }, // 9093
  { PseudoVSOXSEG7EI32_V_MF2_MF8_MASK, VSOXSEG7EI32_V, 0x5 }, // 9094
  { PseudoVSOXSEG7EI32_V_M1_MF4, VSOXSEG7EI32_V, 0x6 }, // 9095
  { PseudoVSOXSEG7EI32_V_M1_MF4_MASK, VSOXSEG7EI32_V, 0x6 }, // 9096
  { PseudoVSOXSEG7EI32_V_MF2_MF4, VSOXSEG7EI32_V, 0x6 }, // 9097
  { PseudoVSOXSEG7EI32_V_MF2_MF4_MASK, VSOXSEG7EI32_V, 0x6 }, // 9098
  { PseudoVSOXSEG7EI32_V_M1_MF2, VSOXSEG7EI32_V, 0x7 }, // 9099
  { PseudoVSOXSEG7EI32_V_M1_MF2_MASK, VSOXSEG7EI32_V, 0x7 }, // 9100
  { PseudoVSOXSEG7EI32_V_M2_MF2, VSOXSEG7EI32_V, 0x7 }, // 9101
  { PseudoVSOXSEG7EI32_V_M2_MF2_MASK, VSOXSEG7EI32_V, 0x7 }, // 9102
  { PseudoVSOXSEG7EI32_V_MF2_MF2, VSOXSEG7EI32_V, 0x7 }, // 9103
  { PseudoVSOXSEG7EI32_V_MF2_MF2_MASK, VSOXSEG7EI32_V, 0x7 }, // 9104
  { PseudoVSOXSEG7EI64_V_M1_M1, VSOXSEG7EI64_V, 0x0 }, // 9105
  { PseudoVSOXSEG7EI64_V_M1_M1_MASK, VSOXSEG7EI64_V, 0x0 }, // 9106
  { PseudoVSOXSEG7EI64_V_M2_M1, VSOXSEG7EI64_V, 0x0 }, // 9107
  { PseudoVSOXSEG7EI64_V_M2_M1_MASK, VSOXSEG7EI64_V, 0x0 }, // 9108
  { PseudoVSOXSEG7EI64_V_M4_M1, VSOXSEG7EI64_V, 0x0 }, // 9109
  { PseudoVSOXSEG7EI64_V_M4_M1_MASK, VSOXSEG7EI64_V, 0x0 }, // 9110
  { PseudoVSOXSEG7EI64_V_M8_M1, VSOXSEG7EI64_V, 0x0 }, // 9111
  { PseudoVSOXSEG7EI64_V_M8_M1_MASK, VSOXSEG7EI64_V, 0x0 }, // 9112
  { PseudoVSOXSEG7EI64_V_M1_MF8, VSOXSEG7EI64_V, 0x5 }, // 9113
  { PseudoVSOXSEG7EI64_V_M1_MF8_MASK, VSOXSEG7EI64_V, 0x5 }, // 9114
  { PseudoVSOXSEG7EI64_V_M1_MF4, VSOXSEG7EI64_V, 0x6 }, // 9115
  { PseudoVSOXSEG7EI64_V_M1_MF4_MASK, VSOXSEG7EI64_V, 0x6 }, // 9116
  { PseudoVSOXSEG7EI64_V_M2_MF4, VSOXSEG7EI64_V, 0x6 }, // 9117
  { PseudoVSOXSEG7EI64_V_M2_MF4_MASK, VSOXSEG7EI64_V, 0x6 }, // 9118
  { PseudoVSOXSEG7EI64_V_M1_MF2, VSOXSEG7EI64_V, 0x7 }, // 9119
  { PseudoVSOXSEG7EI64_V_M1_MF2_MASK, VSOXSEG7EI64_V, 0x7 }, // 9120
  { PseudoVSOXSEG7EI64_V_M2_MF2, VSOXSEG7EI64_V, 0x7 }, // 9121
  { PseudoVSOXSEG7EI64_V_M2_MF2_MASK, VSOXSEG7EI64_V, 0x7 }, // 9122
  { PseudoVSOXSEG7EI64_V_M4_MF2, VSOXSEG7EI64_V, 0x7 }, // 9123
  { PseudoVSOXSEG7EI64_V_M4_MF2_MASK, VSOXSEG7EI64_V, 0x7 }, // 9124
  { PseudoVSOXSEG7EI8_V_M1_M1, VSOXSEG7EI8_V, 0x0 }, // 9125
  { PseudoVSOXSEG7EI8_V_M1_M1_MASK, VSOXSEG7EI8_V, 0x0 }, // 9126
  { PseudoVSOXSEG7EI8_V_MF2_M1, VSOXSEG7EI8_V, 0x0 }, // 9127
  { PseudoVSOXSEG7EI8_V_MF2_M1_MASK, VSOXSEG7EI8_V, 0x0 }, // 9128
  { PseudoVSOXSEG7EI8_V_MF4_M1, VSOXSEG7EI8_V, 0x0 }, // 9129
  { PseudoVSOXSEG7EI8_V_MF4_M1_MASK, VSOXSEG7EI8_V, 0x0 }, // 9130
  { PseudoVSOXSEG7EI8_V_MF8_M1, VSOXSEG7EI8_V, 0x0 }, // 9131
  { PseudoVSOXSEG7EI8_V_MF8_M1_MASK, VSOXSEG7EI8_V, 0x0 }, // 9132
  { PseudoVSOXSEG7EI8_V_MF8_MF8, VSOXSEG7EI8_V, 0x5 }, // 9133
  { PseudoVSOXSEG7EI8_V_MF8_MF8_MASK, VSOXSEG7EI8_V, 0x5 }, // 9134
  { PseudoVSOXSEG7EI8_V_MF4_MF4, VSOXSEG7EI8_V, 0x6 }, // 9135
  { PseudoVSOXSEG7EI8_V_MF4_MF4_MASK, VSOXSEG7EI8_V, 0x6 }, // 9136
  { PseudoVSOXSEG7EI8_V_MF8_MF4, VSOXSEG7EI8_V, 0x6 }, // 9137
  { PseudoVSOXSEG7EI8_V_MF8_MF4_MASK, VSOXSEG7EI8_V, 0x6 }, // 9138
  { PseudoVSOXSEG7EI8_V_MF2_MF2, VSOXSEG7EI8_V, 0x7 }, // 9139
  { PseudoVSOXSEG7EI8_V_MF2_MF2_MASK, VSOXSEG7EI8_V, 0x7 }, // 9140
  { PseudoVSOXSEG7EI8_V_MF4_MF2, VSOXSEG7EI8_V, 0x7 }, // 9141
  { PseudoVSOXSEG7EI8_V_MF4_MF2_MASK, VSOXSEG7EI8_V, 0x7 }, // 9142
  { PseudoVSOXSEG7EI8_V_MF8_MF2, VSOXSEG7EI8_V, 0x7 }, // 9143
  { PseudoVSOXSEG7EI8_V_MF8_MF2_MASK, VSOXSEG7EI8_V, 0x7 }, // 9144
  { PseudoVSOXSEG8EI16_V_M1_M1, VSOXSEG8EI16_V, 0x0 }, // 9145
  { PseudoVSOXSEG8EI16_V_M1_M1_MASK, VSOXSEG8EI16_V, 0x0 }, // 9146
  { PseudoVSOXSEG8EI16_V_M2_M1, VSOXSEG8EI16_V, 0x0 }, // 9147
  { PseudoVSOXSEG8EI16_V_M2_M1_MASK, VSOXSEG8EI16_V, 0x0 }, // 9148
  { PseudoVSOXSEG8EI16_V_MF2_M1, VSOXSEG8EI16_V, 0x0 }, // 9149
  { PseudoVSOXSEG8EI16_V_MF2_M1_MASK, VSOXSEG8EI16_V, 0x0 }, // 9150
  { PseudoVSOXSEG8EI16_V_MF4_M1, VSOXSEG8EI16_V, 0x0 }, // 9151
  { PseudoVSOXSEG8EI16_V_MF4_M1_MASK, VSOXSEG8EI16_V, 0x0 }, // 9152
  { PseudoVSOXSEG8EI16_V_MF4_MF8, VSOXSEG8EI16_V, 0x5 }, // 9153
  { PseudoVSOXSEG8EI16_V_MF4_MF8_MASK, VSOXSEG8EI16_V, 0x5 }, // 9154
  { PseudoVSOXSEG8EI16_V_MF2_MF4, VSOXSEG8EI16_V, 0x6 }, // 9155
  { PseudoVSOXSEG8EI16_V_MF2_MF4_MASK, VSOXSEG8EI16_V, 0x6 }, // 9156
  { PseudoVSOXSEG8EI16_V_MF4_MF4, VSOXSEG8EI16_V, 0x6 }, // 9157
  { PseudoVSOXSEG8EI16_V_MF4_MF4_MASK, VSOXSEG8EI16_V, 0x6 }, // 9158
  { PseudoVSOXSEG8EI16_V_M1_MF2, VSOXSEG8EI16_V, 0x7 }, // 9159
  { PseudoVSOXSEG8EI16_V_M1_MF2_MASK, VSOXSEG8EI16_V, 0x7 }, // 9160
  { PseudoVSOXSEG8EI16_V_MF2_MF2, VSOXSEG8EI16_V, 0x7 }, // 9161
  { PseudoVSOXSEG8EI16_V_MF2_MF2_MASK, VSOXSEG8EI16_V, 0x7 }, // 9162
  { PseudoVSOXSEG8EI16_V_MF4_MF2, VSOXSEG8EI16_V, 0x7 }, // 9163
  { PseudoVSOXSEG8EI16_V_MF4_MF2_MASK, VSOXSEG8EI16_V, 0x7 }, // 9164
  { PseudoVSOXSEG8EI32_V_M1_M1, VSOXSEG8EI32_V, 0x0 }, // 9165
  { PseudoVSOXSEG8EI32_V_M1_M1_MASK, VSOXSEG8EI32_V, 0x0 }, // 9166
  { PseudoVSOXSEG8EI32_V_M2_M1, VSOXSEG8EI32_V, 0x0 }, // 9167
  { PseudoVSOXSEG8EI32_V_M2_M1_MASK, VSOXSEG8EI32_V, 0x0 }, // 9168
  { PseudoVSOXSEG8EI32_V_M4_M1, VSOXSEG8EI32_V, 0x0 }, // 9169
  { PseudoVSOXSEG8EI32_V_M4_M1_MASK, VSOXSEG8EI32_V, 0x0 }, // 9170
  { PseudoVSOXSEG8EI32_V_MF2_M1, VSOXSEG8EI32_V, 0x0 }, // 9171
  { PseudoVSOXSEG8EI32_V_MF2_M1_MASK, VSOXSEG8EI32_V, 0x0 }, // 9172
  { PseudoVSOXSEG8EI32_V_MF2_MF8, VSOXSEG8EI32_V, 0x5 }, // 9173
  { PseudoVSOXSEG8EI32_V_MF2_MF8_MASK, VSOXSEG8EI32_V, 0x5 }, // 9174
  { PseudoVSOXSEG8EI32_V_M1_MF4, VSOXSEG8EI32_V, 0x6 }, // 9175
  { PseudoVSOXSEG8EI32_V_M1_MF4_MASK, VSOXSEG8EI32_V, 0x6 }, // 9176
  { PseudoVSOXSEG8EI32_V_MF2_MF4, VSOXSEG8EI32_V, 0x6 }, // 9177
  { PseudoVSOXSEG8EI32_V_MF2_MF4_MASK, VSOXSEG8EI32_V, 0x6 }, // 9178
  { PseudoVSOXSEG8EI32_V_M1_MF2, VSOXSEG8EI32_V, 0x7 }, // 9179
  { PseudoVSOXSEG8EI32_V_M1_MF2_MASK, VSOXSEG8EI32_V, 0x7 }, // 9180
  { PseudoVSOXSEG8EI32_V_M2_MF2, VSOXSEG8EI32_V, 0x7 }, // 9181
  { PseudoVSOXSEG8EI32_V_M2_MF2_MASK, VSOXSEG8EI32_V, 0x7 }, // 9182
  { PseudoVSOXSEG8EI32_V_MF2_MF2, VSOXSEG8EI32_V, 0x7 }, // 9183
  { PseudoVSOXSEG8EI32_V_MF2_MF2_MASK, VSOXSEG8EI32_V, 0x7 }, // 9184
  { PseudoVSOXSEG8EI64_V_M1_M1, VSOXSEG8EI64_V, 0x0 }, // 9185
  { PseudoVSOXSEG8EI64_V_M1_M1_MASK, VSOXSEG8EI64_V, 0x0 }, // 9186
  { PseudoVSOXSEG8EI64_V_M2_M1, VSOXSEG8EI64_V, 0x0 }, // 9187
  { PseudoVSOXSEG8EI64_V_M2_M1_MASK, VSOXSEG8EI64_V, 0x0 }, // 9188
  { PseudoVSOXSEG8EI64_V_M4_M1, VSOXSEG8EI64_V, 0x0 }, // 9189
  { PseudoVSOXSEG8EI64_V_M4_M1_MASK, VSOXSEG8EI64_V, 0x0 }, // 9190
  { PseudoVSOXSEG8EI64_V_M8_M1, VSOXSEG8EI64_V, 0x0 }, // 9191
  { PseudoVSOXSEG8EI64_V_M8_M1_MASK, VSOXSEG8EI64_V, 0x0 }, // 9192
  { PseudoVSOXSEG8EI64_V_M1_MF8, VSOXSEG8EI64_V, 0x5 }, // 9193
  { PseudoVSOXSEG8EI64_V_M1_MF8_MASK, VSOXSEG8EI64_V, 0x5 }, // 9194
  { PseudoVSOXSEG8EI64_V_M1_MF4, VSOXSEG8EI64_V, 0x6 }, // 9195
  { PseudoVSOXSEG8EI64_V_M1_MF4_MASK, VSOXSEG8EI64_V, 0x6 }, // 9196
  { PseudoVSOXSEG8EI64_V_M2_MF4, VSOXSEG8EI64_V, 0x6 }, // 9197
  { PseudoVSOXSEG8EI64_V_M2_MF4_MASK, VSOXSEG8EI64_V, 0x6 }, // 9198
  { PseudoVSOXSEG8EI64_V_M1_MF2, VSOXSEG8EI64_V, 0x7 }, // 9199
  { PseudoVSOXSEG8EI64_V_M1_MF2_MASK, VSOXSEG8EI64_V, 0x7 }, // 9200
  { PseudoVSOXSEG8EI64_V_M2_MF2, VSOXSEG8EI64_V, 0x7 }, // 9201
  { PseudoVSOXSEG8EI64_V_M2_MF2_MASK, VSOXSEG8EI64_V, 0x7 }, // 9202
  { PseudoVSOXSEG8EI64_V_M4_MF2, VSOXSEG8EI64_V, 0x7 }, // 9203
  { PseudoVSOXSEG8EI64_V_M4_MF2_MASK, VSOXSEG8EI64_V, 0x7 }, // 9204
  { PseudoVSOXSEG8EI8_V_M1_M1, VSOXSEG8EI8_V, 0x0 }, // 9205
  { PseudoVSOXSEG8EI8_V_M1_M1_MASK, VSOXSEG8EI8_V, 0x0 }, // 9206
  { PseudoVSOXSEG8EI8_V_MF2_M1, VSOXSEG8EI8_V, 0x0 }, // 9207
  { PseudoVSOXSEG8EI8_V_MF2_M1_MASK, VSOXSEG8EI8_V, 0x0 }, // 9208
  { PseudoVSOXSEG8EI8_V_MF4_M1, VSOXSEG8EI8_V, 0x0 }, // 9209
  { PseudoVSOXSEG8EI8_V_MF4_M1_MASK, VSOXSEG8EI8_V, 0x0 }, // 9210
  { PseudoVSOXSEG8EI8_V_MF8_M1, VSOXSEG8EI8_V, 0x0 }, // 9211
  { PseudoVSOXSEG8EI8_V_MF8_M1_MASK, VSOXSEG8EI8_V, 0x0 }, // 9212
  { PseudoVSOXSEG8EI8_V_MF8_MF8, VSOXSEG8EI8_V, 0x5 }, // 9213
  { PseudoVSOXSEG8EI8_V_MF8_MF8_MASK, VSOXSEG8EI8_V, 0x5 }, // 9214
  { PseudoVSOXSEG8EI8_V_MF4_MF4, VSOXSEG8EI8_V, 0x6 }, // 9215
  { PseudoVSOXSEG8EI8_V_MF4_MF4_MASK, VSOXSEG8EI8_V, 0x6 }, // 9216
  { PseudoVSOXSEG8EI8_V_MF8_MF4, VSOXSEG8EI8_V, 0x6 }, // 9217
  { PseudoVSOXSEG8EI8_V_MF8_MF4_MASK, VSOXSEG8EI8_V, 0x6 }, // 9218
  { PseudoVSOXSEG8EI8_V_MF2_MF2, VSOXSEG8EI8_V, 0x7 }, // 9219
  { PseudoVSOXSEG8EI8_V_MF2_MF2_MASK, VSOXSEG8EI8_V, 0x7 }, // 9220
  { PseudoVSOXSEG8EI8_V_MF4_MF2, VSOXSEG8EI8_V, 0x7 }, // 9221
  { PseudoVSOXSEG8EI8_V_MF4_MF2_MASK, VSOXSEG8EI8_V, 0x7 }, // 9222
  { PseudoVSOXSEG8EI8_V_MF8_MF2, VSOXSEG8EI8_V, 0x7 }, // 9223
  { PseudoVSOXSEG8EI8_V_MF8_MF2_MASK, VSOXSEG8EI8_V, 0x7 }, // 9224
  { PseudoVSRA_VI_M1, VSRA_VI, 0x0 }, // 9225
  { PseudoVSRA_VI_M1_MASK, VSRA_VI, 0x0 }, // 9226
  { PseudoVSRA_VI_M1_TU, VSRA_VI, 0x0 }, // 9227
  { PseudoVSRA_VI_M2, VSRA_VI, 0x1 }, // 9228
  { PseudoVSRA_VI_M2_MASK, VSRA_VI, 0x1 }, // 9229
  { PseudoVSRA_VI_M2_TU, VSRA_VI, 0x1 }, // 9230
  { PseudoVSRA_VI_M4, VSRA_VI, 0x2 }, // 9231
  { PseudoVSRA_VI_M4_MASK, VSRA_VI, 0x2 }, // 9232
  { PseudoVSRA_VI_M4_TU, VSRA_VI, 0x2 }, // 9233
  { PseudoVSRA_VI_M8, VSRA_VI, 0x3 }, // 9234
  { PseudoVSRA_VI_M8_MASK, VSRA_VI, 0x3 }, // 9235
  { PseudoVSRA_VI_M8_TU, VSRA_VI, 0x3 }, // 9236
  { PseudoVSRA_VI_MF8, VSRA_VI, 0x5 }, // 9237
  { PseudoVSRA_VI_MF8_MASK, VSRA_VI, 0x5 }, // 9238
  { PseudoVSRA_VI_MF8_TU, VSRA_VI, 0x5 }, // 9239
  { PseudoVSRA_VI_MF4, VSRA_VI, 0x6 }, // 9240
  { PseudoVSRA_VI_MF4_MASK, VSRA_VI, 0x6 }, // 9241
  { PseudoVSRA_VI_MF4_TU, VSRA_VI, 0x6 }, // 9242
  { PseudoVSRA_VI_MF2, VSRA_VI, 0x7 }, // 9243
  { PseudoVSRA_VI_MF2_MASK, VSRA_VI, 0x7 }, // 9244
  { PseudoVSRA_VI_MF2_TU, VSRA_VI, 0x7 }, // 9245
  { PseudoVSRA_VV_M1, VSRA_VV, 0x0 }, // 9246
  { PseudoVSRA_VV_M1_MASK, VSRA_VV, 0x0 }, // 9247
  { PseudoVSRA_VV_M1_TU, VSRA_VV, 0x0 }, // 9248
  { PseudoVSRA_VV_M2, VSRA_VV, 0x1 }, // 9249
  { PseudoVSRA_VV_M2_MASK, VSRA_VV, 0x1 }, // 9250
  { PseudoVSRA_VV_M2_TU, VSRA_VV, 0x1 }, // 9251
  { PseudoVSRA_VV_M4, VSRA_VV, 0x2 }, // 9252
  { PseudoVSRA_VV_M4_MASK, VSRA_VV, 0x2 }, // 9253
  { PseudoVSRA_VV_M4_TU, VSRA_VV, 0x2 }, // 9254
  { PseudoVSRA_VV_M8, VSRA_VV, 0x3 }, // 9255
  { PseudoVSRA_VV_M8_MASK, VSRA_VV, 0x3 }, // 9256
  { PseudoVSRA_VV_M8_TU, VSRA_VV, 0x3 }, // 9257
  { PseudoVSRA_VV_MF8, VSRA_VV, 0x5 }, // 9258
  { PseudoVSRA_VV_MF8_MASK, VSRA_VV, 0x5 }, // 9259
  { PseudoVSRA_VV_MF8_TU, VSRA_VV, 0x5 }, // 9260
  { PseudoVSRA_VV_MF4, VSRA_VV, 0x6 }, // 9261
  { PseudoVSRA_VV_MF4_MASK, VSRA_VV, 0x6 }, // 9262
  { PseudoVSRA_VV_MF4_TU, VSRA_VV, 0x6 }, // 9263
  { PseudoVSRA_VV_MF2, VSRA_VV, 0x7 }, // 9264
  { PseudoVSRA_VV_MF2_MASK, VSRA_VV, 0x7 }, // 9265
  { PseudoVSRA_VV_MF2_TU, VSRA_VV, 0x7 }, // 9266
  { PseudoVSRA_VX_M1, VSRA_VX, 0x0 }, // 9267
  { PseudoVSRA_VX_M1_MASK, VSRA_VX, 0x0 }, // 9268
  { PseudoVSRA_VX_M1_TU, VSRA_VX, 0x0 }, // 9269
  { PseudoVSRA_VX_M2, VSRA_VX, 0x1 }, // 9270
  { PseudoVSRA_VX_M2_MASK, VSRA_VX, 0x1 }, // 9271
  { PseudoVSRA_VX_M2_TU, VSRA_VX, 0x1 }, // 9272
  { PseudoVSRA_VX_M4, VSRA_VX, 0x2 }, // 9273
  { PseudoVSRA_VX_M4_MASK, VSRA_VX, 0x2 }, // 9274
  { PseudoVSRA_VX_M4_TU, VSRA_VX, 0x2 }, // 9275
  { PseudoVSRA_VX_M8, VSRA_VX, 0x3 }, // 9276
  { PseudoVSRA_VX_M8_MASK, VSRA_VX, 0x3 }, // 9277
  { PseudoVSRA_VX_M8_TU, VSRA_VX, 0x3 }, // 9278
  { PseudoVSRA_VX_MF8, VSRA_VX, 0x5 }, // 9279
  { PseudoVSRA_VX_MF8_MASK, VSRA_VX, 0x5 }, // 9280
  { PseudoVSRA_VX_MF8_TU, VSRA_VX, 0x5 }, // 9281
  { PseudoVSRA_VX_MF4, VSRA_VX, 0x6 }, // 9282
  { PseudoVSRA_VX_MF4_MASK, VSRA_VX, 0x6 }, // 9283
  { PseudoVSRA_VX_MF4_TU, VSRA_VX, 0x6 }, // 9284
  { PseudoVSRA_VX_MF2, VSRA_VX, 0x7 }, // 9285
  { PseudoVSRA_VX_MF2_MASK, VSRA_VX, 0x7 }, // 9286
  { PseudoVSRA_VX_MF2_TU, VSRA_VX, 0x7 }, // 9287
  { PseudoVSRL_VI_M1, VSRL_VI, 0x0 }, // 9288
  { PseudoVSRL_VI_M1_MASK, VSRL_VI, 0x0 }, // 9289
  { PseudoVSRL_VI_M1_TU, VSRL_VI, 0x0 }, // 9290
  { PseudoVSRL_VI_M2, VSRL_VI, 0x1 }, // 9291
  { PseudoVSRL_VI_M2_MASK, VSRL_VI, 0x1 }, // 9292
  { PseudoVSRL_VI_M2_TU, VSRL_VI, 0x1 }, // 9293
  { PseudoVSRL_VI_M4, VSRL_VI, 0x2 }, // 9294
  { PseudoVSRL_VI_M4_MASK, VSRL_VI, 0x2 }, // 9295
  { PseudoVSRL_VI_M4_TU, VSRL_VI, 0x2 }, // 9296
  { PseudoVSRL_VI_M8, VSRL_VI, 0x3 }, // 9297
  { PseudoVSRL_VI_M8_MASK, VSRL_VI, 0x3 }, // 9298
  { PseudoVSRL_VI_M8_TU, VSRL_VI, 0x3 }, // 9299
  { PseudoVSRL_VI_MF8, VSRL_VI, 0x5 }, // 9300
  { PseudoVSRL_VI_MF8_MASK, VSRL_VI, 0x5 }, // 9301
  { PseudoVSRL_VI_MF8_TU, VSRL_VI, 0x5 }, // 9302
  { PseudoVSRL_VI_MF4, VSRL_VI, 0x6 }, // 9303
  { PseudoVSRL_VI_MF4_MASK, VSRL_VI, 0x6 }, // 9304
  { PseudoVSRL_VI_MF4_TU, VSRL_VI, 0x6 }, // 9305
  { PseudoVSRL_VI_MF2, VSRL_VI, 0x7 }, // 9306
  { PseudoVSRL_VI_MF2_MASK, VSRL_VI, 0x7 }, // 9307
  { PseudoVSRL_VI_MF2_TU, VSRL_VI, 0x7 }, // 9308
  { PseudoVSRL_VV_M1, VSRL_VV, 0x0 }, // 9309
  { PseudoVSRL_VV_M1_MASK, VSRL_VV, 0x0 }, // 9310
  { PseudoVSRL_VV_M1_TU, VSRL_VV, 0x0 }, // 9311
  { PseudoVSRL_VV_M2, VSRL_VV, 0x1 }, // 9312
  { PseudoVSRL_VV_M2_MASK, VSRL_VV, 0x1 }, // 9313
  { PseudoVSRL_VV_M2_TU, VSRL_VV, 0x1 }, // 9314
  { PseudoVSRL_VV_M4, VSRL_VV, 0x2 }, // 9315
  { PseudoVSRL_VV_M4_MASK, VSRL_VV, 0x2 }, // 9316
  { PseudoVSRL_VV_M4_TU, VSRL_VV, 0x2 }, // 9317
  { PseudoVSRL_VV_M8, VSRL_VV, 0x3 }, // 9318
  { PseudoVSRL_VV_M8_MASK, VSRL_VV, 0x3 }, // 9319
  { PseudoVSRL_VV_M8_TU, VSRL_VV, 0x3 }, // 9320
  { PseudoVSRL_VV_MF8, VSRL_VV, 0x5 }, // 9321
  { PseudoVSRL_VV_MF8_MASK, VSRL_VV, 0x5 }, // 9322
  { PseudoVSRL_VV_MF8_TU, VSRL_VV, 0x5 }, // 9323
  { PseudoVSRL_VV_MF4, VSRL_VV, 0x6 }, // 9324
  { PseudoVSRL_VV_MF4_MASK, VSRL_VV, 0x6 }, // 9325
  { PseudoVSRL_VV_MF4_TU, VSRL_VV, 0x6 }, // 9326
  { PseudoVSRL_VV_MF2, VSRL_VV, 0x7 }, // 9327
  { PseudoVSRL_VV_MF2_MASK, VSRL_VV, 0x7 }, // 9328
  { PseudoVSRL_VV_MF2_TU, VSRL_VV, 0x7 }, // 9329
  { PseudoVSRL_VX_M1, VSRL_VX, 0x0 }, // 9330
  { PseudoVSRL_VX_M1_MASK, VSRL_VX, 0x0 }, // 9331
  { PseudoVSRL_VX_M1_TU, VSRL_VX, 0x0 }, // 9332
  { PseudoVSRL_VX_M2, VSRL_VX, 0x1 }, // 9333
  { PseudoVSRL_VX_M2_MASK, VSRL_VX, 0x1 }, // 9334
  { PseudoVSRL_VX_M2_TU, VSRL_VX, 0x1 }, // 9335
  { PseudoVSRL_VX_M4, VSRL_VX, 0x2 }, // 9336
  { PseudoVSRL_VX_M4_MASK, VSRL_VX, 0x2 }, // 9337
  { PseudoVSRL_VX_M4_TU, VSRL_VX, 0x2 }, // 9338
  { PseudoVSRL_VX_M8, VSRL_VX, 0x3 }, // 9339
  { PseudoVSRL_VX_M8_MASK, VSRL_VX, 0x3 }, // 9340
  { PseudoVSRL_VX_M8_TU, VSRL_VX, 0x3 }, // 9341
  { PseudoVSRL_VX_MF8, VSRL_VX, 0x5 }, // 9342
  { PseudoVSRL_VX_MF8_MASK, VSRL_VX, 0x5 }, // 9343
  { PseudoVSRL_VX_MF8_TU, VSRL_VX, 0x5 }, // 9344
  { PseudoVSRL_VX_MF4, VSRL_VX, 0x6 }, // 9345
  { PseudoVSRL_VX_MF4_MASK, VSRL_VX, 0x6 }, // 9346
  { PseudoVSRL_VX_MF4_TU, VSRL_VX, 0x6 }, // 9347
  { PseudoVSRL_VX_MF2, VSRL_VX, 0x7 }, // 9348
  { PseudoVSRL_VX_MF2_MASK, VSRL_VX, 0x7 }, // 9349
  { PseudoVSRL_VX_MF2_TU, VSRL_VX, 0x7 }, // 9350
  { PseudoVSSE16_V_M1, VSSE16_V, 0x0 }, // 9351
  { PseudoVSSE16_V_M1_MASK, VSSE16_V, 0x0 }, // 9352
  { PseudoVSSE16_V_M2, VSSE16_V, 0x1 }, // 9353
  { PseudoVSSE16_V_M2_MASK, VSSE16_V, 0x1 }, // 9354
  { PseudoVSSE16_V_M4, VSSE16_V, 0x2 }, // 9355
  { PseudoVSSE16_V_M4_MASK, VSSE16_V, 0x2 }, // 9356
  { PseudoVSSE16_V_M8, VSSE16_V, 0x3 }, // 9357
  { PseudoVSSE16_V_M8_MASK, VSSE16_V, 0x3 }, // 9358
  { PseudoVSSE16_V_MF4, VSSE16_V, 0x6 }, // 9359
  { PseudoVSSE16_V_MF4_MASK, VSSE16_V, 0x6 }, // 9360
  { PseudoVSSE16_V_MF2, VSSE16_V, 0x7 }, // 9361
  { PseudoVSSE16_V_MF2_MASK, VSSE16_V, 0x7 }, // 9362
  { PseudoVSSE32_V_M1, VSSE32_V, 0x0 }, // 9363
  { PseudoVSSE32_V_M1_MASK, VSSE32_V, 0x0 }, // 9364
  { PseudoVSSE32_V_M2, VSSE32_V, 0x1 }, // 9365
  { PseudoVSSE32_V_M2_MASK, VSSE32_V, 0x1 }, // 9366
  { PseudoVSSE32_V_M4, VSSE32_V, 0x2 }, // 9367
  { PseudoVSSE32_V_M4_MASK, VSSE32_V, 0x2 }, // 9368
  { PseudoVSSE32_V_M8, VSSE32_V, 0x3 }, // 9369
  { PseudoVSSE32_V_M8_MASK, VSSE32_V, 0x3 }, // 9370
  { PseudoVSSE32_V_MF2, VSSE32_V, 0x7 }, // 9371
  { PseudoVSSE32_V_MF2_MASK, VSSE32_V, 0x7 }, // 9372
  { PseudoVSSE64_V_M1, VSSE64_V, 0x0 }, // 9373
  { PseudoVSSE64_V_M1_MASK, VSSE64_V, 0x0 }, // 9374
  { PseudoVSSE64_V_M2, VSSE64_V, 0x1 }, // 9375
  { PseudoVSSE64_V_M2_MASK, VSSE64_V, 0x1 }, // 9376
  { PseudoVSSE64_V_M4, VSSE64_V, 0x2 }, // 9377
  { PseudoVSSE64_V_M4_MASK, VSSE64_V, 0x2 }, // 9378
  { PseudoVSSE64_V_M8, VSSE64_V, 0x3 }, // 9379
  { PseudoVSSE64_V_M8_MASK, VSSE64_V, 0x3 }, // 9380
  { PseudoVSSE8_V_M1, VSSE8_V, 0x0 }, // 9381
  { PseudoVSSE8_V_M1_MASK, VSSE8_V, 0x0 }, // 9382
  { PseudoVSSE8_V_M2, VSSE8_V, 0x1 }, // 9383
  { PseudoVSSE8_V_M2_MASK, VSSE8_V, 0x1 }, // 9384
  { PseudoVSSE8_V_M4, VSSE8_V, 0x2 }, // 9385
  { PseudoVSSE8_V_M4_MASK, VSSE8_V, 0x2 }, // 9386
  { PseudoVSSE8_V_M8, VSSE8_V, 0x3 }, // 9387
  { PseudoVSSE8_V_M8_MASK, VSSE8_V, 0x3 }, // 9388
  { PseudoVSSE8_V_MF8, VSSE8_V, 0x5 }, // 9389
  { PseudoVSSE8_V_MF8_MASK, VSSE8_V, 0x5 }, // 9390
  { PseudoVSSE8_V_MF4, VSSE8_V, 0x6 }, // 9391
  { PseudoVSSE8_V_MF4_MASK, VSSE8_V, 0x6 }, // 9392
  { PseudoVSSE8_V_MF2, VSSE8_V, 0x7 }, // 9393
  { PseudoVSSE8_V_MF2_MASK, VSSE8_V, 0x7 }, // 9394
  { PseudoVSSEG2E16_V_M1, VSSEG2E16_V, 0x0 }, // 9395
  { PseudoVSSEG2E16_V_M1_MASK, VSSEG2E16_V, 0x0 }, // 9396
  { PseudoVSSEG2E16_V_M2, VSSEG2E16_V, 0x1 }, // 9397
  { PseudoVSSEG2E16_V_M2_MASK, VSSEG2E16_V, 0x1 }, // 9398
  { PseudoVSSEG2E16_V_M4, VSSEG2E16_V, 0x2 }, // 9399
  { PseudoVSSEG2E16_V_M4_MASK, VSSEG2E16_V, 0x2 }, // 9400
  { PseudoVSSEG2E16_V_MF4, VSSEG2E16_V, 0x6 }, // 9401
  { PseudoVSSEG2E16_V_MF4_MASK, VSSEG2E16_V, 0x6 }, // 9402
  { PseudoVSSEG2E16_V_MF2, VSSEG2E16_V, 0x7 }, // 9403
  { PseudoVSSEG2E16_V_MF2_MASK, VSSEG2E16_V, 0x7 }, // 9404
  { PseudoVSSEG2E32_V_M1, VSSEG2E32_V, 0x0 }, // 9405
  { PseudoVSSEG2E32_V_M1_MASK, VSSEG2E32_V, 0x0 }, // 9406
  { PseudoVSSEG2E32_V_M2, VSSEG2E32_V, 0x1 }, // 9407
  { PseudoVSSEG2E32_V_M2_MASK, VSSEG2E32_V, 0x1 }, // 9408
  { PseudoVSSEG2E32_V_M4, VSSEG2E32_V, 0x2 }, // 9409
  { PseudoVSSEG2E32_V_M4_MASK, VSSEG2E32_V, 0x2 }, // 9410
  { PseudoVSSEG2E32_V_MF2, VSSEG2E32_V, 0x7 }, // 9411
  { PseudoVSSEG2E32_V_MF2_MASK, VSSEG2E32_V, 0x7 }, // 9412
  { PseudoVSSEG2E64_V_M1, VSSEG2E64_V, 0x0 }, // 9413
  { PseudoVSSEG2E64_V_M1_MASK, VSSEG2E64_V, 0x0 }, // 9414
  { PseudoVSSEG2E64_V_M2, VSSEG2E64_V, 0x1 }, // 9415
  { PseudoVSSEG2E64_V_M2_MASK, VSSEG2E64_V, 0x1 }, // 9416
  { PseudoVSSEG2E64_V_M4, VSSEG2E64_V, 0x2 }, // 9417
  { PseudoVSSEG2E64_V_M4_MASK, VSSEG2E64_V, 0x2 }, // 9418
  { PseudoVSSEG2E8_V_M1, VSSEG2E8_V, 0x0 }, // 9419
  { PseudoVSSEG2E8_V_M1_MASK, VSSEG2E8_V, 0x0 }, // 9420
  { PseudoVSSEG2E8_V_M2, VSSEG2E8_V, 0x1 }, // 9421
  { PseudoVSSEG2E8_V_M2_MASK, VSSEG2E8_V, 0x1 }, // 9422
  { PseudoVSSEG2E8_V_M4, VSSEG2E8_V, 0x2 }, // 9423
  { PseudoVSSEG2E8_V_M4_MASK, VSSEG2E8_V, 0x2 }, // 9424
  { PseudoVSSEG2E8_V_MF8, VSSEG2E8_V, 0x5 }, // 9425
  { PseudoVSSEG2E8_V_MF8_MASK, VSSEG2E8_V, 0x5 }, // 9426
  { PseudoVSSEG2E8_V_MF4, VSSEG2E8_V, 0x6 }, // 9427
  { PseudoVSSEG2E8_V_MF4_MASK, VSSEG2E8_V, 0x6 }, // 9428
  { PseudoVSSEG2E8_V_MF2, VSSEG2E8_V, 0x7 }, // 9429
  { PseudoVSSEG2E8_V_MF2_MASK, VSSEG2E8_V, 0x7 }, // 9430
  { PseudoVSSEG3E16_V_M1, VSSEG3E16_V, 0x0 }, // 9431
  { PseudoVSSEG3E16_V_M1_MASK, VSSEG3E16_V, 0x0 }, // 9432
  { PseudoVSSEG3E16_V_M2, VSSEG3E16_V, 0x1 }, // 9433
  { PseudoVSSEG3E16_V_M2_MASK, VSSEG3E16_V, 0x1 }, // 9434
  { PseudoVSSEG3E16_V_MF4, VSSEG3E16_V, 0x6 }, // 9435
  { PseudoVSSEG3E16_V_MF4_MASK, VSSEG3E16_V, 0x6 }, // 9436
  { PseudoVSSEG3E16_V_MF2, VSSEG3E16_V, 0x7 }, // 9437
  { PseudoVSSEG3E16_V_MF2_MASK, VSSEG3E16_V, 0x7 }, // 9438
  { PseudoVSSEG3E32_V_M1, VSSEG3E32_V, 0x0 }, // 9439
  { PseudoVSSEG3E32_V_M1_MASK, VSSEG3E32_V, 0x0 }, // 9440
  { PseudoVSSEG3E32_V_M2, VSSEG3E32_V, 0x1 }, // 9441
  { PseudoVSSEG3E32_V_M2_MASK, VSSEG3E32_V, 0x1 }, // 9442
  { PseudoVSSEG3E32_V_MF2, VSSEG3E32_V, 0x7 }, // 9443
  { PseudoVSSEG3E32_V_MF2_MASK, VSSEG3E32_V, 0x7 }, // 9444
  { PseudoVSSEG3E64_V_M1, VSSEG3E64_V, 0x0 }, // 9445
  { PseudoVSSEG3E64_V_M1_MASK, VSSEG3E64_V, 0x0 }, // 9446
  { PseudoVSSEG3E64_V_M2, VSSEG3E64_V, 0x1 }, // 9447
  { PseudoVSSEG3E64_V_M2_MASK, VSSEG3E64_V, 0x1 }, // 9448
  { PseudoVSSEG3E8_V_M1, VSSEG3E8_V, 0x0 }, // 9449
  { PseudoVSSEG3E8_V_M1_MASK, VSSEG3E8_V, 0x0 }, // 9450
  { PseudoVSSEG3E8_V_M2, VSSEG3E8_V, 0x1 }, // 9451
  { PseudoVSSEG3E8_V_M2_MASK, VSSEG3E8_V, 0x1 }, // 9452
  { PseudoVSSEG3E8_V_MF8, VSSEG3E8_V, 0x5 }, // 9453
  { PseudoVSSEG3E8_V_MF8_MASK, VSSEG3E8_V, 0x5 }, // 9454
  { PseudoVSSEG3E8_V_MF4, VSSEG3E8_V, 0x6 }, // 9455
  { PseudoVSSEG3E8_V_MF4_MASK, VSSEG3E8_V, 0x6 }, // 9456
  { PseudoVSSEG3E8_V_MF2, VSSEG3E8_V, 0x7 }, // 9457
  { PseudoVSSEG3E8_V_MF2_MASK, VSSEG3E8_V, 0x7 }, // 9458
  { PseudoVSSEG4E16_V_M1, VSSEG4E16_V, 0x0 }, // 9459
  { PseudoVSSEG4E16_V_M1_MASK, VSSEG4E16_V, 0x0 }, // 9460
  { PseudoVSSEG4E16_V_M2, VSSEG4E16_V, 0x1 }, // 9461
  { PseudoVSSEG4E16_V_M2_MASK, VSSEG4E16_V, 0x1 }, // 9462
  { PseudoVSSEG4E16_V_MF4, VSSEG4E16_V, 0x6 }, // 9463
  { PseudoVSSEG4E16_V_MF4_MASK, VSSEG4E16_V, 0x6 }, // 9464
  { PseudoVSSEG4E16_V_MF2, VSSEG4E16_V, 0x7 }, // 9465
  { PseudoVSSEG4E16_V_MF2_MASK, VSSEG4E16_V, 0x7 }, // 9466
  { PseudoVSSEG4E32_V_M1, VSSEG4E32_V, 0x0 }, // 9467
  { PseudoVSSEG4E32_V_M1_MASK, VSSEG4E32_V, 0x0 }, // 9468
  { PseudoVSSEG4E32_V_M2, VSSEG4E32_V, 0x1 }, // 9469
  { PseudoVSSEG4E32_V_M2_MASK, VSSEG4E32_V, 0x1 }, // 9470
  { PseudoVSSEG4E32_V_MF2, VSSEG4E32_V, 0x7 }, // 9471
  { PseudoVSSEG4E32_V_MF2_MASK, VSSEG4E32_V, 0x7 }, // 9472
  { PseudoVSSEG4E64_V_M1, VSSEG4E64_V, 0x0 }, // 9473
  { PseudoVSSEG4E64_V_M1_MASK, VSSEG4E64_V, 0x0 }, // 9474
  { PseudoVSSEG4E64_V_M2, VSSEG4E64_V, 0x1 }, // 9475
  { PseudoVSSEG4E64_V_M2_MASK, VSSEG4E64_V, 0x1 }, // 9476
  { PseudoVSSEG4E8_V_M1, VSSEG4E8_V, 0x0 }, // 9477
  { PseudoVSSEG4E8_V_M1_MASK, VSSEG4E8_V, 0x0 }, // 9478
  { PseudoVSSEG4E8_V_M2, VSSEG4E8_V, 0x1 }, // 9479
  { PseudoVSSEG4E8_V_M2_MASK, VSSEG4E8_V, 0x1 }, // 9480
  { PseudoVSSEG4E8_V_MF8, VSSEG4E8_V, 0x5 }, // 9481
  { PseudoVSSEG4E8_V_MF8_MASK, VSSEG4E8_V, 0x5 }, // 9482
  { PseudoVSSEG4E8_V_MF4, VSSEG4E8_V, 0x6 }, // 9483
  { PseudoVSSEG4E8_V_MF4_MASK, VSSEG4E8_V, 0x6 }, // 9484
  { PseudoVSSEG4E8_V_MF2, VSSEG4E8_V, 0x7 }, // 9485
  { PseudoVSSEG4E8_V_MF2_MASK, VSSEG4E8_V, 0x7 }, // 9486
  { PseudoVSSEG5E16_V_M1, VSSEG5E16_V, 0x0 }, // 9487
  { PseudoVSSEG5E16_V_M1_MASK, VSSEG5E16_V, 0x0 }, // 9488
  { PseudoVSSEG5E16_V_MF4, VSSEG5E16_V, 0x6 }, // 9489
  { PseudoVSSEG5E16_V_MF4_MASK, VSSEG5E16_V, 0x6 }, // 9490
  { PseudoVSSEG5E16_V_MF2, VSSEG5E16_V, 0x7 }, // 9491
  { PseudoVSSEG5E16_V_MF2_MASK, VSSEG5E16_V, 0x7 }, // 9492
  { PseudoVSSEG5E32_V_M1, VSSEG5E32_V, 0x0 }, // 9493
  { PseudoVSSEG5E32_V_M1_MASK, VSSEG5E32_V, 0x0 }, // 9494
  { PseudoVSSEG5E32_V_MF2, VSSEG5E32_V, 0x7 }, // 9495
  { PseudoVSSEG5E32_V_MF2_MASK, VSSEG5E32_V, 0x7 }, // 9496
  { PseudoVSSEG5E64_V_M1, VSSEG5E64_V, 0x0 }, // 9497
  { PseudoVSSEG5E64_V_M1_MASK, VSSEG5E64_V, 0x0 }, // 9498
  { PseudoVSSEG5E8_V_M1, VSSEG5E8_V, 0x0 }, // 9499
  { PseudoVSSEG5E8_V_M1_MASK, VSSEG5E8_V, 0x0 }, // 9500
  { PseudoVSSEG5E8_V_MF8, VSSEG5E8_V, 0x5 }, // 9501
  { PseudoVSSEG5E8_V_MF8_MASK, VSSEG5E8_V, 0x5 }, // 9502
  { PseudoVSSEG5E8_V_MF4, VSSEG5E8_V, 0x6 }, // 9503
  { PseudoVSSEG5E8_V_MF4_MASK, VSSEG5E8_V, 0x6 }, // 9504
  { PseudoVSSEG5E8_V_MF2, VSSEG5E8_V, 0x7 }, // 9505
  { PseudoVSSEG5E8_V_MF2_MASK, VSSEG5E8_V, 0x7 }, // 9506
  { PseudoVSSEG6E16_V_M1, VSSEG6E16_V, 0x0 }, // 9507
  { PseudoVSSEG6E16_V_M1_MASK, VSSEG6E16_V, 0x0 }, // 9508
  { PseudoVSSEG6E16_V_MF4, VSSEG6E16_V, 0x6 }, // 9509
  { PseudoVSSEG6E16_V_MF4_MASK, VSSEG6E16_V, 0x6 }, // 9510
  { PseudoVSSEG6E16_V_MF2, VSSEG6E16_V, 0x7 }, // 9511
  { PseudoVSSEG6E16_V_MF2_MASK, VSSEG6E16_V, 0x7 }, // 9512
  { PseudoVSSEG6E32_V_M1, VSSEG6E32_V, 0x0 }, // 9513
  { PseudoVSSEG6E32_V_M1_MASK, VSSEG6E32_V, 0x0 }, // 9514
  { PseudoVSSEG6E32_V_MF2, VSSEG6E32_V, 0x7 }, // 9515
  { PseudoVSSEG6E32_V_MF2_MASK, VSSEG6E32_V, 0x7 }, // 9516
  { PseudoVSSEG6E64_V_M1, VSSEG6E64_V, 0x0 }, // 9517
  { PseudoVSSEG6E64_V_M1_MASK, VSSEG6E64_V, 0x0 }, // 9518
  { PseudoVSSEG6E8_V_M1, VSSEG6E8_V, 0x0 }, // 9519
  { PseudoVSSEG6E8_V_M1_MASK, VSSEG6E8_V, 0x0 }, // 9520
  { PseudoVSSEG6E8_V_MF8, VSSEG6E8_V, 0x5 }, // 9521
  { PseudoVSSEG6E8_V_MF8_MASK, VSSEG6E8_V, 0x5 }, // 9522
  { PseudoVSSEG6E8_V_MF4, VSSEG6E8_V, 0x6 }, // 9523
  { PseudoVSSEG6E8_V_MF4_MASK, VSSEG6E8_V, 0x6 }, // 9524
  { PseudoVSSEG6E8_V_MF2, VSSEG6E8_V, 0x7 }, // 9525
  { PseudoVSSEG6E8_V_MF2_MASK, VSSEG6E8_V, 0x7 }, // 9526
  { PseudoVSSEG7E16_V_M1, VSSEG7E16_V, 0x0 }, // 9527
  { PseudoVSSEG7E16_V_M1_MASK, VSSEG7E16_V, 0x0 }, // 9528
  { PseudoVSSEG7E16_V_MF4, VSSEG7E16_V, 0x6 }, // 9529
  { PseudoVSSEG7E16_V_MF4_MASK, VSSEG7E16_V, 0x6 }, // 9530
  { PseudoVSSEG7E16_V_MF2, VSSEG7E16_V, 0x7 }, // 9531
  { PseudoVSSEG7E16_V_MF2_MASK, VSSEG7E16_V, 0x7 }, // 9532
  { PseudoVSSEG7E32_V_M1, VSSEG7E32_V, 0x0 }, // 9533
  { PseudoVSSEG7E32_V_M1_MASK, VSSEG7E32_V, 0x0 }, // 9534
  { PseudoVSSEG7E32_V_MF2, VSSEG7E32_V, 0x7 }, // 9535
  { PseudoVSSEG7E32_V_MF2_MASK, VSSEG7E32_V, 0x7 }, // 9536
  { PseudoVSSEG7E64_V_M1, VSSEG7E64_V, 0x0 }, // 9537
  { PseudoVSSEG7E64_V_M1_MASK, VSSEG7E64_V, 0x0 }, // 9538
  { PseudoVSSEG7E8_V_M1, VSSEG7E8_V, 0x0 }, // 9539
  { PseudoVSSEG7E8_V_M1_MASK, VSSEG7E8_V, 0x0 }, // 9540
  { PseudoVSSEG7E8_V_MF8, VSSEG7E8_V, 0x5 }, // 9541
  { PseudoVSSEG7E8_V_MF8_MASK, VSSEG7E8_V, 0x5 }, // 9542
  { PseudoVSSEG7E8_V_MF4, VSSEG7E8_V, 0x6 }, // 9543
  { PseudoVSSEG7E8_V_MF4_MASK, VSSEG7E8_V, 0x6 }, // 9544
  { PseudoVSSEG7E8_V_MF2, VSSEG7E8_V, 0x7 }, // 9545
  { PseudoVSSEG7E8_V_MF2_MASK, VSSEG7E8_V, 0x7 }, // 9546
  { PseudoVSSEG8E16_V_M1, VSSEG8E16_V, 0x0 }, // 9547
  { PseudoVSSEG8E16_V_M1_MASK, VSSEG8E16_V, 0x0 }, // 9548
  { PseudoVSSEG8E16_V_MF4, VSSEG8E16_V, 0x6 }, // 9549
  { PseudoVSSEG8E16_V_MF4_MASK, VSSEG8E16_V, 0x6 }, // 9550
  { PseudoVSSEG8E16_V_MF2, VSSEG8E16_V, 0x7 }, // 9551
  { PseudoVSSEG8E16_V_MF2_MASK, VSSEG8E16_V, 0x7 }, // 9552
  { PseudoVSSEG8E32_V_M1, VSSEG8E32_V, 0x0 }, // 9553
  { PseudoVSSEG8E32_V_M1_MASK, VSSEG8E32_V, 0x0 }, // 9554
  { PseudoVSSEG8E32_V_MF2, VSSEG8E32_V, 0x7 }, // 9555
  { PseudoVSSEG8E32_V_MF2_MASK, VSSEG8E32_V, 0x7 }, // 9556
  { PseudoVSSEG8E64_V_M1, VSSEG8E64_V, 0x0 }, // 9557
  { PseudoVSSEG8E64_V_M1_MASK, VSSEG8E64_V, 0x0 }, // 9558
  { PseudoVSSEG8E8_V_M1, VSSEG8E8_V, 0x0 }, // 9559
  { PseudoVSSEG8E8_V_M1_MASK, VSSEG8E8_V, 0x0 }, // 9560
  { PseudoVSSEG8E8_V_MF8, VSSEG8E8_V, 0x5 }, // 9561
  { PseudoVSSEG8E8_V_MF8_MASK, VSSEG8E8_V, 0x5 }, // 9562
  { PseudoVSSEG8E8_V_MF4, VSSEG8E8_V, 0x6 }, // 9563
  { PseudoVSSEG8E8_V_MF4_MASK, VSSEG8E8_V, 0x6 }, // 9564
  { PseudoVSSEG8E8_V_MF2, VSSEG8E8_V, 0x7 }, // 9565
  { PseudoVSSEG8E8_V_MF2_MASK, VSSEG8E8_V, 0x7 }, // 9566
  { PseudoVSSRA_VI_M1, VSSRA_VI, 0x0 }, // 9567
  { PseudoVSSRA_VI_M1_MASK, VSSRA_VI, 0x0 }, // 9568
  { PseudoVSSRA_VI_M1_TU, VSSRA_VI, 0x0 }, // 9569
  { PseudoVSSRA_VI_M2, VSSRA_VI, 0x1 }, // 9570
  { PseudoVSSRA_VI_M2_MASK, VSSRA_VI, 0x1 }, // 9571
  { PseudoVSSRA_VI_M2_TU, VSSRA_VI, 0x1 }, // 9572
  { PseudoVSSRA_VI_M4, VSSRA_VI, 0x2 }, // 9573
  { PseudoVSSRA_VI_M4_MASK, VSSRA_VI, 0x2 }, // 9574
  { PseudoVSSRA_VI_M4_TU, VSSRA_VI, 0x2 }, // 9575
  { PseudoVSSRA_VI_M8, VSSRA_VI, 0x3 }, // 9576
  { PseudoVSSRA_VI_M8_MASK, VSSRA_VI, 0x3 }, // 9577
  { PseudoVSSRA_VI_M8_TU, VSSRA_VI, 0x3 }, // 9578
  { PseudoVSSRA_VI_MF8, VSSRA_VI, 0x5 }, // 9579
  { PseudoVSSRA_VI_MF8_MASK, VSSRA_VI, 0x5 }, // 9580
  { PseudoVSSRA_VI_MF8_TU, VSSRA_VI, 0x5 }, // 9581
  { PseudoVSSRA_VI_MF4, VSSRA_VI, 0x6 }, // 9582
  { PseudoVSSRA_VI_MF4_MASK, VSSRA_VI, 0x6 }, // 9583
  { PseudoVSSRA_VI_MF4_TU, VSSRA_VI, 0x6 }, // 9584
  { PseudoVSSRA_VI_MF2, VSSRA_VI, 0x7 }, // 9585
  { PseudoVSSRA_VI_MF2_MASK, VSSRA_VI, 0x7 }, // 9586
  { PseudoVSSRA_VI_MF2_TU, VSSRA_VI, 0x7 }, // 9587
  { PseudoVSSRA_VV_M1, VSSRA_VV, 0x0 }, // 9588
  { PseudoVSSRA_VV_M1_MASK, VSSRA_VV, 0x0 }, // 9589
  { PseudoVSSRA_VV_M1_TU, VSSRA_VV, 0x0 }, // 9590
  { PseudoVSSRA_VV_M2, VSSRA_VV, 0x1 }, // 9591
  { PseudoVSSRA_VV_M2_MASK, VSSRA_VV, 0x1 }, // 9592
  { PseudoVSSRA_VV_M2_TU, VSSRA_VV, 0x1 }, // 9593
  { PseudoVSSRA_VV_M4, VSSRA_VV, 0x2 }, // 9594
  { PseudoVSSRA_VV_M4_MASK, VSSRA_VV, 0x2 }, // 9595
  { PseudoVSSRA_VV_M4_TU, VSSRA_VV, 0x2 }, // 9596
  { PseudoVSSRA_VV_M8, VSSRA_VV, 0x3 }, // 9597
  { PseudoVSSRA_VV_M8_MASK, VSSRA_VV, 0x3 }, // 9598
  { PseudoVSSRA_VV_M8_TU, VSSRA_VV, 0x3 }, // 9599
  { PseudoVSSRA_VV_MF8, VSSRA_VV, 0x5 }, // 9600
  { PseudoVSSRA_VV_MF8_MASK, VSSRA_VV, 0x5 }, // 9601
  { PseudoVSSRA_VV_MF8_TU, VSSRA_VV, 0x5 }, // 9602
  { PseudoVSSRA_VV_MF4, VSSRA_VV, 0x6 }, // 9603
  { PseudoVSSRA_VV_MF4_MASK, VSSRA_VV, 0x6 }, // 9604
  { PseudoVSSRA_VV_MF4_TU, VSSRA_VV, 0x6 }, // 9605
  { PseudoVSSRA_VV_MF2, VSSRA_VV, 0x7 }, // 9606
  { PseudoVSSRA_VV_MF2_MASK, VSSRA_VV, 0x7 }, // 9607
  { PseudoVSSRA_VV_MF2_TU, VSSRA_VV, 0x7 }, // 9608
  { PseudoVSSRA_VX_M1, VSSRA_VX, 0x0 }, // 9609
  { PseudoVSSRA_VX_M1_MASK, VSSRA_VX, 0x0 }, // 9610
  { PseudoVSSRA_VX_M1_TU, VSSRA_VX, 0x0 }, // 9611
  { PseudoVSSRA_VX_M2, VSSRA_VX, 0x1 }, // 9612
  { PseudoVSSRA_VX_M2_MASK, VSSRA_VX, 0x1 }, // 9613
  { PseudoVSSRA_VX_M2_TU, VSSRA_VX, 0x1 }, // 9614
  { PseudoVSSRA_VX_M4, VSSRA_VX, 0x2 }, // 9615
  { PseudoVSSRA_VX_M4_MASK, VSSRA_VX, 0x2 }, // 9616
  { PseudoVSSRA_VX_M4_TU, VSSRA_VX, 0x2 }, // 9617
  { PseudoVSSRA_VX_M8, VSSRA_VX, 0x3 }, // 9618
  { PseudoVSSRA_VX_M8_MASK, VSSRA_VX, 0x3 }, // 9619
  { PseudoVSSRA_VX_M8_TU, VSSRA_VX, 0x3 }, // 9620
  { PseudoVSSRA_VX_MF8, VSSRA_VX, 0x5 }, // 9621
  { PseudoVSSRA_VX_MF8_MASK, VSSRA_VX, 0x5 }, // 9622
  { PseudoVSSRA_VX_MF8_TU, VSSRA_VX, 0x5 }, // 9623
  { PseudoVSSRA_VX_MF4, VSSRA_VX, 0x6 }, // 9624
  { PseudoVSSRA_VX_MF4_MASK, VSSRA_VX, 0x6 }, // 9625
  { PseudoVSSRA_VX_MF4_TU, VSSRA_VX, 0x6 }, // 9626
  { PseudoVSSRA_VX_MF2, VSSRA_VX, 0x7 }, // 9627
  { PseudoVSSRA_VX_MF2_MASK, VSSRA_VX, 0x7 }, // 9628
  { PseudoVSSRA_VX_MF2_TU, VSSRA_VX, 0x7 }, // 9629
  { PseudoVSSRL_VI_M1, VSSRL_VI, 0x0 }, // 9630
  { PseudoVSSRL_VI_M1_MASK, VSSRL_VI, 0x0 }, // 9631
  { PseudoVSSRL_VI_M1_TU, VSSRL_VI, 0x0 }, // 9632
  { PseudoVSSRL_VI_M2, VSSRL_VI, 0x1 }, // 9633
  { PseudoVSSRL_VI_M2_MASK, VSSRL_VI, 0x1 }, // 9634
  { PseudoVSSRL_VI_M2_TU, VSSRL_VI, 0x1 }, // 9635
  { PseudoVSSRL_VI_M4, VSSRL_VI, 0x2 }, // 9636
  { PseudoVSSRL_VI_M4_MASK, VSSRL_VI, 0x2 }, // 9637
  { PseudoVSSRL_VI_M4_TU, VSSRL_VI, 0x2 }, // 9638
  { PseudoVSSRL_VI_M8, VSSRL_VI, 0x3 }, // 9639
  { PseudoVSSRL_VI_M8_MASK, VSSRL_VI, 0x3 }, // 9640
  { PseudoVSSRL_VI_M8_TU, VSSRL_VI, 0x3 }, // 9641
  { PseudoVSSRL_VI_MF8, VSSRL_VI, 0x5 }, // 9642
  { PseudoVSSRL_VI_MF8_MASK, VSSRL_VI, 0x5 }, // 9643
  { PseudoVSSRL_VI_MF8_TU, VSSRL_VI, 0x5 }, // 9644
  { PseudoVSSRL_VI_MF4, VSSRL_VI, 0x6 }, // 9645
  { PseudoVSSRL_VI_MF4_MASK, VSSRL_VI, 0x6 }, // 9646
  { PseudoVSSRL_VI_MF4_TU, VSSRL_VI, 0x6 }, // 9647
  { PseudoVSSRL_VI_MF2, VSSRL_VI, 0x7 }, // 9648
  { PseudoVSSRL_VI_MF2_MASK, VSSRL_VI, 0x7 }, // 9649
  { PseudoVSSRL_VI_MF2_TU, VSSRL_VI, 0x7 }, // 9650
  { PseudoVSSRL_VV_M1, VSSRL_VV, 0x0 }, // 9651
  { PseudoVSSRL_VV_M1_MASK, VSSRL_VV, 0x0 }, // 9652
  { PseudoVSSRL_VV_M1_TU, VSSRL_VV, 0x0 }, // 9653
  { PseudoVSSRL_VV_M2, VSSRL_VV, 0x1 }, // 9654
  { PseudoVSSRL_VV_M2_MASK, VSSRL_VV, 0x1 }, // 9655
  { PseudoVSSRL_VV_M2_TU, VSSRL_VV, 0x1 }, // 9656
  { PseudoVSSRL_VV_M4, VSSRL_VV, 0x2 }, // 9657
  { PseudoVSSRL_VV_M4_MASK, VSSRL_VV, 0x2 }, // 9658
  { PseudoVSSRL_VV_M4_TU, VSSRL_VV, 0x2 }, // 9659
  { PseudoVSSRL_VV_M8, VSSRL_VV, 0x3 }, // 9660
  { PseudoVSSRL_VV_M8_MASK, VSSRL_VV, 0x3 }, // 9661
  { PseudoVSSRL_VV_M8_TU, VSSRL_VV, 0x3 }, // 9662
  { PseudoVSSRL_VV_MF8, VSSRL_VV, 0x5 }, // 9663
  { PseudoVSSRL_VV_MF8_MASK, VSSRL_VV, 0x5 }, // 9664
  { PseudoVSSRL_VV_MF8_TU, VSSRL_VV, 0x5 }, // 9665
  { PseudoVSSRL_VV_MF4, VSSRL_VV, 0x6 }, // 9666
  { PseudoVSSRL_VV_MF4_MASK, VSSRL_VV, 0x6 }, // 9667
  { PseudoVSSRL_VV_MF4_TU, VSSRL_VV, 0x6 }, // 9668
  { PseudoVSSRL_VV_MF2, VSSRL_VV, 0x7 }, // 9669
  { PseudoVSSRL_VV_MF2_MASK, VSSRL_VV, 0x7 }, // 9670
  { PseudoVSSRL_VV_MF2_TU, VSSRL_VV, 0x7 }, // 9671
  { PseudoVSSRL_VX_M1, VSSRL_VX, 0x0 }, // 9672
  { PseudoVSSRL_VX_M1_MASK, VSSRL_VX, 0x0 }, // 9673
  { PseudoVSSRL_VX_M1_TU, VSSRL_VX, 0x0 }, // 9674
  { PseudoVSSRL_VX_M2, VSSRL_VX, 0x1 }, // 9675
  { PseudoVSSRL_VX_M2_MASK, VSSRL_VX, 0x1 }, // 9676
  { PseudoVSSRL_VX_M2_TU, VSSRL_VX, 0x1 }, // 9677
  { PseudoVSSRL_VX_M4, VSSRL_VX, 0x2 }, // 9678
  { PseudoVSSRL_VX_M4_MASK, VSSRL_VX, 0x2 }, // 9679
  { PseudoVSSRL_VX_M4_TU, VSSRL_VX, 0x2 }, // 9680
  { PseudoVSSRL_VX_M8, VSSRL_VX, 0x3 }, // 9681
  { PseudoVSSRL_VX_M8_MASK, VSSRL_VX, 0x3 }, // 9682
  { PseudoVSSRL_VX_M8_TU, VSSRL_VX, 0x3 }, // 9683
  { PseudoVSSRL_VX_MF8, VSSRL_VX, 0x5 }, // 9684
  { PseudoVSSRL_VX_MF8_MASK, VSSRL_VX, 0x5 }, // 9685
  { PseudoVSSRL_VX_MF8_TU, VSSRL_VX, 0x5 }, // 9686
  { PseudoVSSRL_VX_MF4, VSSRL_VX, 0x6 }, // 9687
  { PseudoVSSRL_VX_MF4_MASK, VSSRL_VX, 0x6 }, // 9688
  { PseudoVSSRL_VX_MF4_TU, VSSRL_VX, 0x6 }, // 9689
  { PseudoVSSRL_VX_MF2, VSSRL_VX, 0x7 }, // 9690
  { PseudoVSSRL_VX_MF2_MASK, VSSRL_VX, 0x7 }, // 9691
  { PseudoVSSRL_VX_MF2_TU, VSSRL_VX, 0x7 }, // 9692
  { PseudoVSSSEG2E16_V_M1, VSSSEG2E16_V, 0x0 }, // 9693
  { PseudoVSSSEG2E16_V_M1_MASK, VSSSEG2E16_V, 0x0 }, // 9694
  { PseudoVSSSEG2E16_V_M2, VSSSEG2E16_V, 0x1 }, // 9695
  { PseudoVSSSEG2E16_V_M2_MASK, VSSSEG2E16_V, 0x1 }, // 9696
  { PseudoVSSSEG2E16_V_M4, VSSSEG2E16_V, 0x2 }, // 9697
  { PseudoVSSSEG2E16_V_M4_MASK, VSSSEG2E16_V, 0x2 }, // 9698
  { PseudoVSSSEG2E16_V_MF4, VSSSEG2E16_V, 0x6 }, // 9699
  { PseudoVSSSEG2E16_V_MF4_MASK, VSSSEG2E16_V, 0x6 }, // 9700
  { PseudoVSSSEG2E16_V_MF2, VSSSEG2E16_V, 0x7 }, // 9701
  { PseudoVSSSEG2E16_V_MF2_MASK, VSSSEG2E16_V, 0x7 }, // 9702
  { PseudoVSSSEG2E32_V_M1, VSSSEG2E32_V, 0x0 }, // 9703
  { PseudoVSSSEG2E32_V_M1_MASK, VSSSEG2E32_V, 0x0 }, // 9704
  { PseudoVSSSEG2E32_V_M2, VSSSEG2E32_V, 0x1 }, // 9705
  { PseudoVSSSEG2E32_V_M2_MASK, VSSSEG2E32_V, 0x1 }, // 9706
  { PseudoVSSSEG2E32_V_M4, VSSSEG2E32_V, 0x2 }, // 9707
  { PseudoVSSSEG2E32_V_M4_MASK, VSSSEG2E32_V, 0x2 }, // 9708
  { PseudoVSSSEG2E32_V_MF2, VSSSEG2E32_V, 0x7 }, // 9709
  { PseudoVSSSEG2E32_V_MF2_MASK, VSSSEG2E32_V, 0x7 }, // 9710
  { PseudoVSSSEG2E64_V_M1, VSSSEG2E64_V, 0x0 }, // 9711
  { PseudoVSSSEG2E64_V_M1_MASK, VSSSEG2E64_V, 0x0 }, // 9712
  { PseudoVSSSEG2E64_V_M2, VSSSEG2E64_V, 0x1 }, // 9713
  { PseudoVSSSEG2E64_V_M2_MASK, VSSSEG2E64_V, 0x1 }, // 9714
  { PseudoVSSSEG2E64_V_M4, VSSSEG2E64_V, 0x2 }, // 9715
  { PseudoVSSSEG2E64_V_M4_MASK, VSSSEG2E64_V, 0x2 }, // 9716
  { PseudoVSSSEG2E8_V_M1, VSSSEG2E8_V, 0x0 }, // 9717
  { PseudoVSSSEG2E8_V_M1_MASK, VSSSEG2E8_V, 0x0 }, // 9718
  { PseudoVSSSEG2E8_V_M2, VSSSEG2E8_V, 0x1 }, // 9719
  { PseudoVSSSEG2E8_V_M2_MASK, VSSSEG2E8_V, 0x1 }, // 9720
  { PseudoVSSSEG2E8_V_M4, VSSSEG2E8_V, 0x2 }, // 9721
  { PseudoVSSSEG2E8_V_M4_MASK, VSSSEG2E8_V, 0x2 }, // 9722
  { PseudoVSSSEG2E8_V_MF8, VSSSEG2E8_V, 0x5 }, // 9723
  { PseudoVSSSEG2E8_V_MF8_MASK, VSSSEG2E8_V, 0x5 }, // 9724
  { PseudoVSSSEG2E8_V_MF4, VSSSEG2E8_V, 0x6 }, // 9725
  { PseudoVSSSEG2E8_V_MF4_MASK, VSSSEG2E8_V, 0x6 }, // 9726
  { PseudoVSSSEG2E8_V_MF2, VSSSEG2E8_V, 0x7 }, // 9727
  { PseudoVSSSEG2E8_V_MF2_MASK, VSSSEG2E8_V, 0x7 }, // 9728
  { PseudoVSSSEG3E16_V_M1, VSSSEG3E16_V, 0x0 }, // 9729
  { PseudoVSSSEG3E16_V_M1_MASK, VSSSEG3E16_V, 0x0 }, // 9730
  { PseudoVSSSEG3E16_V_M2, VSSSEG3E16_V, 0x1 }, // 9731
  { PseudoVSSSEG3E16_V_M2_MASK, VSSSEG3E16_V, 0x1 }, // 9732
  { PseudoVSSSEG3E16_V_MF4, VSSSEG3E16_V, 0x6 }, // 9733
  { PseudoVSSSEG3E16_V_MF4_MASK, VSSSEG3E16_V, 0x6 }, // 9734
  { PseudoVSSSEG3E16_V_MF2, VSSSEG3E16_V, 0x7 }, // 9735
  { PseudoVSSSEG3E16_V_MF2_MASK, VSSSEG3E16_V, 0x7 }, // 9736
  { PseudoVSSSEG3E32_V_M1, VSSSEG3E32_V, 0x0 }, // 9737
  { PseudoVSSSEG3E32_V_M1_MASK, VSSSEG3E32_V, 0x0 }, // 9738
  { PseudoVSSSEG3E32_V_M2, VSSSEG3E32_V, 0x1 }, // 9739
  { PseudoVSSSEG3E32_V_M2_MASK, VSSSEG3E32_V, 0x1 }, // 9740
  { PseudoVSSSEG3E32_V_MF2, VSSSEG3E32_V, 0x7 }, // 9741
  { PseudoVSSSEG3E32_V_MF2_MASK, VSSSEG3E32_V, 0x7 }, // 9742
  { PseudoVSSSEG3E64_V_M1, VSSSEG3E64_V, 0x0 }, // 9743
  { PseudoVSSSEG3E64_V_M1_MASK, VSSSEG3E64_V, 0x0 }, // 9744
  { PseudoVSSSEG3E64_V_M2, VSSSEG3E64_V, 0x1 }, // 9745
  { PseudoVSSSEG3E64_V_M2_MASK, VSSSEG3E64_V, 0x1 }, // 9746
  { PseudoVSSSEG3E8_V_M1, VSSSEG3E8_V, 0x0 }, // 9747
  { PseudoVSSSEG3E8_V_M1_MASK, VSSSEG3E8_V, 0x0 }, // 9748
  { PseudoVSSSEG3E8_V_M2, VSSSEG3E8_V, 0x1 }, // 9749
  { PseudoVSSSEG3E8_V_M2_MASK, VSSSEG3E8_V, 0x1 }, // 9750
  { PseudoVSSSEG3E8_V_MF8, VSSSEG3E8_V, 0x5 }, // 9751
  { PseudoVSSSEG3E8_V_MF8_MASK, VSSSEG3E8_V, 0x5 }, // 9752
  { PseudoVSSSEG3E8_V_MF4, VSSSEG3E8_V, 0x6 }, // 9753
  { PseudoVSSSEG3E8_V_MF4_MASK, VSSSEG3E8_V, 0x6 }, // 9754
  { PseudoVSSSEG3E8_V_MF2, VSSSEG3E8_V, 0x7 }, // 9755
  { PseudoVSSSEG3E8_V_MF2_MASK, VSSSEG3E8_V, 0x7 }, // 9756
  { PseudoVSSSEG4E16_V_M1, VSSSEG4E16_V, 0x0 }, // 9757
  { PseudoVSSSEG4E16_V_M1_MASK, VSSSEG4E16_V, 0x0 }, // 9758
  { PseudoVSSSEG4E16_V_M2, VSSSEG4E16_V, 0x1 }, // 9759
  { PseudoVSSSEG4E16_V_M2_MASK, VSSSEG4E16_V, 0x1 }, // 9760
  { PseudoVSSSEG4E16_V_MF4, VSSSEG4E16_V, 0x6 }, // 9761
  { PseudoVSSSEG4E16_V_MF4_MASK, VSSSEG4E16_V, 0x6 }, // 9762
  { PseudoVSSSEG4E16_V_MF2, VSSSEG4E16_V, 0x7 }, // 9763
  { PseudoVSSSEG4E16_V_MF2_MASK, VSSSEG4E16_V, 0x7 }, // 9764
  { PseudoVSSSEG4E32_V_M1, VSSSEG4E32_V, 0x0 }, // 9765
  { PseudoVSSSEG4E32_V_M1_MASK, VSSSEG4E32_V, 0x0 }, // 9766
  { PseudoVSSSEG4E32_V_M2, VSSSEG4E32_V, 0x1 }, // 9767
  { PseudoVSSSEG4E32_V_M2_MASK, VSSSEG4E32_V, 0x1 }, // 9768
  { PseudoVSSSEG4E32_V_MF2, VSSSEG4E32_V, 0x7 }, // 9769
  { PseudoVSSSEG4E32_V_MF2_MASK, VSSSEG4E32_V, 0x7 }, // 9770
  { PseudoVSSSEG4E64_V_M1, VSSSEG4E64_V, 0x0 }, // 9771
  { PseudoVSSSEG4E64_V_M1_MASK, VSSSEG4E64_V, 0x0 }, // 9772
  { PseudoVSSSEG4E64_V_M2, VSSSEG4E64_V, 0x1 }, // 9773
  { PseudoVSSSEG4E64_V_M2_MASK, VSSSEG4E64_V, 0x1 }, // 9774
  { PseudoVSSSEG4E8_V_M1, VSSSEG4E8_V, 0x0 }, // 9775
  { PseudoVSSSEG4E8_V_M1_MASK, VSSSEG4E8_V, 0x0 }, // 9776
  { PseudoVSSSEG4E8_V_M2, VSSSEG4E8_V, 0x1 }, // 9777
  { PseudoVSSSEG4E8_V_M2_MASK, VSSSEG4E8_V, 0x1 }, // 9778
  { PseudoVSSSEG4E8_V_MF8, VSSSEG4E8_V, 0x5 }, // 9779
  { PseudoVSSSEG4E8_V_MF8_MASK, VSSSEG4E8_V, 0x5 }, // 9780
  { PseudoVSSSEG4E8_V_MF4, VSSSEG4E8_V, 0x6 }, // 9781
  { PseudoVSSSEG4E8_V_MF4_MASK, VSSSEG4E8_V, 0x6 }, // 9782
  { PseudoVSSSEG4E8_V_MF2, VSSSEG4E8_V, 0x7 }, // 9783
  { PseudoVSSSEG4E8_V_MF2_MASK, VSSSEG4E8_V, 0x7 }, // 9784
  { PseudoVSSSEG5E16_V_M1, VSSSEG5E16_V, 0x0 }, // 9785
  { PseudoVSSSEG5E16_V_M1_MASK, VSSSEG5E16_V, 0x0 }, // 9786
  { PseudoVSSSEG5E16_V_MF4, VSSSEG5E16_V, 0x6 }, // 9787
  { PseudoVSSSEG5E16_V_MF4_MASK, VSSSEG5E16_V, 0x6 }, // 9788
  { PseudoVSSSEG5E16_V_MF2, VSSSEG5E16_V, 0x7 }, // 9789
  { PseudoVSSSEG5E16_V_MF2_MASK, VSSSEG5E16_V, 0x7 }, // 9790
  { PseudoVSSSEG5E32_V_M1, VSSSEG5E32_V, 0x0 }, // 9791
  { PseudoVSSSEG5E32_V_M1_MASK, VSSSEG5E32_V, 0x0 }, // 9792
  { PseudoVSSSEG5E32_V_MF2, VSSSEG5E32_V, 0x7 }, // 9793
  { PseudoVSSSEG5E32_V_MF2_MASK, VSSSEG5E32_V, 0x7 }, // 9794
  { PseudoVSSSEG5E64_V_M1, VSSSEG5E64_V, 0x0 }, // 9795
  { PseudoVSSSEG5E64_V_M1_MASK, VSSSEG5E64_V, 0x0 }, // 9796
  { PseudoVSSSEG5E8_V_M1, VSSSEG5E8_V, 0x0 }, // 9797
  { PseudoVSSSEG5E8_V_M1_MASK, VSSSEG5E8_V, 0x0 }, // 9798
  { PseudoVSSSEG5E8_V_MF8, VSSSEG5E8_V, 0x5 }, // 9799
  { PseudoVSSSEG5E8_V_MF8_MASK, VSSSEG5E8_V, 0x5 }, // 9800
  { PseudoVSSSEG5E8_V_MF4, VSSSEG5E8_V, 0x6 }, // 9801
  { PseudoVSSSEG5E8_V_MF4_MASK, VSSSEG5E8_V, 0x6 }, // 9802
  { PseudoVSSSEG5E8_V_MF2, VSSSEG5E8_V, 0x7 }, // 9803
  { PseudoVSSSEG5E8_V_MF2_MASK, VSSSEG5E8_V, 0x7 }, // 9804
  { PseudoVSSSEG6E16_V_M1, VSSSEG6E16_V, 0x0 }, // 9805
  { PseudoVSSSEG6E16_V_M1_MASK, VSSSEG6E16_V, 0x0 }, // 9806
  { PseudoVSSSEG6E16_V_MF4, VSSSEG6E16_V, 0x6 }, // 9807
  { PseudoVSSSEG6E16_V_MF4_MASK, VSSSEG6E16_V, 0x6 }, // 9808
  { PseudoVSSSEG6E16_V_MF2, VSSSEG6E16_V, 0x7 }, // 9809
  { PseudoVSSSEG6E16_V_MF2_MASK, VSSSEG6E16_V, 0x7 }, // 9810
  { PseudoVSSSEG6E32_V_M1, VSSSEG6E32_V, 0x0 }, // 9811
  { PseudoVSSSEG6E32_V_M1_MASK, VSSSEG6E32_V, 0x0 }, // 9812
  { PseudoVSSSEG6E32_V_MF2, VSSSEG6E32_V, 0x7 }, // 9813
  { PseudoVSSSEG6E32_V_MF2_MASK, VSSSEG6E32_V, 0x7 }, // 9814
  { PseudoVSSSEG6E64_V_M1, VSSSEG6E64_V, 0x0 }, // 9815
  { PseudoVSSSEG6E64_V_M1_MASK, VSSSEG6E64_V, 0x0 }, // 9816
  { PseudoVSSSEG6E8_V_M1, VSSSEG6E8_V, 0x0 }, // 9817
  { PseudoVSSSEG6E8_V_M1_MASK, VSSSEG6E8_V, 0x0 }, // 9818
  { PseudoVSSSEG6E8_V_MF8, VSSSEG6E8_V, 0x5 }, // 9819
  { PseudoVSSSEG6E8_V_MF8_MASK, VSSSEG6E8_V, 0x5 }, // 9820
  { PseudoVSSSEG6E8_V_MF4, VSSSEG6E8_V, 0x6 }, // 9821
  { PseudoVSSSEG6E8_V_MF4_MASK, VSSSEG6E8_V, 0x6 }, // 9822
  { PseudoVSSSEG6E8_V_MF2, VSSSEG6E8_V, 0x7 }, // 9823
  { PseudoVSSSEG6E8_V_MF2_MASK, VSSSEG6E8_V, 0x7 }, // 9824
  { PseudoVSSSEG7E16_V_M1, VSSSEG7E16_V, 0x0 }, // 9825
  { PseudoVSSSEG7E16_V_M1_MASK, VSSSEG7E16_V, 0x0 }, // 9826
  { PseudoVSSSEG7E16_V_MF4, VSSSEG7E16_V, 0x6 }, // 9827
  { PseudoVSSSEG7E16_V_MF4_MASK, VSSSEG7E16_V, 0x6 }, // 9828
  { PseudoVSSSEG7E16_V_MF2, VSSSEG7E16_V, 0x7 }, // 9829
  { PseudoVSSSEG7E16_V_MF2_MASK, VSSSEG7E16_V, 0x7 }, // 9830
  { PseudoVSSSEG7E32_V_M1, VSSSEG7E32_V, 0x0 }, // 9831
  { PseudoVSSSEG7E32_V_M1_MASK, VSSSEG7E32_V, 0x0 }, // 9832
  { PseudoVSSSEG7E32_V_MF2, VSSSEG7E32_V, 0x7 }, // 9833
  { PseudoVSSSEG7E32_V_MF2_MASK, VSSSEG7E32_V, 0x7 }, // 9834
  { PseudoVSSSEG7E64_V_M1, VSSSEG7E64_V, 0x0 }, // 9835
  { PseudoVSSSEG7E64_V_M1_MASK, VSSSEG7E64_V, 0x0 }, // 9836
  { PseudoVSSSEG7E8_V_M1, VSSSEG7E8_V, 0x0 }, // 9837
  { PseudoVSSSEG7E8_V_M1_MASK, VSSSEG7E8_V, 0x0 }, // 9838
  { PseudoVSSSEG7E8_V_MF8, VSSSEG7E8_V, 0x5 }, // 9839
  { PseudoVSSSEG7E8_V_MF8_MASK, VSSSEG7E8_V, 0x5 }, // 9840
  { PseudoVSSSEG7E8_V_MF4, VSSSEG7E8_V, 0x6 }, // 9841
  { PseudoVSSSEG7E8_V_MF4_MASK, VSSSEG7E8_V, 0x6 }, // 9842
  { PseudoVSSSEG7E8_V_MF2, VSSSEG7E8_V, 0x7 }, // 9843
  { PseudoVSSSEG7E8_V_MF2_MASK, VSSSEG7E8_V, 0x7 }, // 9844
  { PseudoVSSSEG8E16_V_M1, VSSSEG8E16_V, 0x0 }, // 9845
  { PseudoVSSSEG8E16_V_M1_MASK, VSSSEG8E16_V, 0x0 }, // 9846
  { PseudoVSSSEG8E16_V_MF4, VSSSEG8E16_V, 0x6 }, // 9847
  { PseudoVSSSEG8E16_V_MF4_MASK, VSSSEG8E16_V, 0x6 }, // 9848
  { PseudoVSSSEG8E16_V_MF2, VSSSEG8E16_V, 0x7 }, // 9849
  { PseudoVSSSEG8E16_V_MF2_MASK, VSSSEG8E16_V, 0x7 }, // 9850
  { PseudoVSSSEG8E32_V_M1, VSSSEG8E32_V, 0x0 }, // 9851
  { PseudoVSSSEG8E32_V_M1_MASK, VSSSEG8E32_V, 0x0 }, // 9852
  { PseudoVSSSEG8E32_V_MF2, VSSSEG8E32_V, 0x7 }, // 9853
  { PseudoVSSSEG8E32_V_MF2_MASK, VSSSEG8E32_V, 0x7 }, // 9854
  { PseudoVSSSEG8E64_V_M1, VSSSEG8E64_V, 0x0 }, // 9855
  { PseudoVSSSEG8E64_V_M1_MASK, VSSSEG8E64_V, 0x0 }, // 9856
  { PseudoVSSSEG8E8_V_M1, VSSSEG8E8_V, 0x0 }, // 9857
  { PseudoVSSSEG8E8_V_M1_MASK, VSSSEG8E8_V, 0x0 }, // 9858
  { PseudoVSSSEG8E8_V_MF8, VSSSEG8E8_V, 0x5 }, // 9859
  { PseudoVSSSEG8E8_V_MF8_MASK, VSSSEG8E8_V, 0x5 }, // 9860
  { PseudoVSSSEG8E8_V_MF4, VSSSEG8E8_V, 0x6 }, // 9861
  { PseudoVSSSEG8E8_V_MF4_MASK, VSSSEG8E8_V, 0x6 }, // 9862
  { PseudoVSSSEG8E8_V_MF2, VSSSEG8E8_V, 0x7 }, // 9863
  { PseudoVSSSEG8E8_V_MF2_MASK, VSSSEG8E8_V, 0x7 }, // 9864
  { PseudoVSSUBU_VV_M1, VSSUBU_VV, 0x0 }, // 9865
  { PseudoVSSUBU_VV_M1_MASK, VSSUBU_VV, 0x0 }, // 9866
  { PseudoVSSUBU_VV_M1_TU, VSSUBU_VV, 0x0 }, // 9867
  { PseudoVSSUBU_VV_M2, VSSUBU_VV, 0x1 }, // 9868
  { PseudoVSSUBU_VV_M2_MASK, VSSUBU_VV, 0x1 }, // 9869
  { PseudoVSSUBU_VV_M2_TU, VSSUBU_VV, 0x1 }, // 9870
  { PseudoVSSUBU_VV_M4, VSSUBU_VV, 0x2 }, // 9871
  { PseudoVSSUBU_VV_M4_MASK, VSSUBU_VV, 0x2 }, // 9872
  { PseudoVSSUBU_VV_M4_TU, VSSUBU_VV, 0x2 }, // 9873
  { PseudoVSSUBU_VV_M8, VSSUBU_VV, 0x3 }, // 9874
  { PseudoVSSUBU_VV_M8_MASK, VSSUBU_VV, 0x3 }, // 9875
  { PseudoVSSUBU_VV_M8_TU, VSSUBU_VV, 0x3 }, // 9876
  { PseudoVSSUBU_VV_MF8, VSSUBU_VV, 0x5 }, // 9877
  { PseudoVSSUBU_VV_MF8_MASK, VSSUBU_VV, 0x5 }, // 9878
  { PseudoVSSUBU_VV_MF8_TU, VSSUBU_VV, 0x5 }, // 9879
  { PseudoVSSUBU_VV_MF4, VSSUBU_VV, 0x6 }, // 9880
  { PseudoVSSUBU_VV_MF4_MASK, VSSUBU_VV, 0x6 }, // 9881
  { PseudoVSSUBU_VV_MF4_TU, VSSUBU_VV, 0x6 }, // 9882
  { PseudoVSSUBU_VV_MF2, VSSUBU_VV, 0x7 }, // 9883
  { PseudoVSSUBU_VV_MF2_MASK, VSSUBU_VV, 0x7 }, // 9884
  { PseudoVSSUBU_VV_MF2_TU, VSSUBU_VV, 0x7 }, // 9885
  { PseudoVSSUBU_VX_M1, VSSUBU_VX, 0x0 }, // 9886
  { PseudoVSSUBU_VX_M1_MASK, VSSUBU_VX, 0x0 }, // 9887
  { PseudoVSSUBU_VX_M1_TU, VSSUBU_VX, 0x0 }, // 9888
  { PseudoVSSUBU_VX_M2, VSSUBU_VX, 0x1 }, // 9889
  { PseudoVSSUBU_VX_M2_MASK, VSSUBU_VX, 0x1 }, // 9890
  { PseudoVSSUBU_VX_M2_TU, VSSUBU_VX, 0x1 }, // 9891
  { PseudoVSSUBU_VX_M4, VSSUBU_VX, 0x2 }, // 9892
  { PseudoVSSUBU_VX_M4_MASK, VSSUBU_VX, 0x2 }, // 9893
  { PseudoVSSUBU_VX_M4_TU, VSSUBU_VX, 0x2 }, // 9894
  { PseudoVSSUBU_VX_M8, VSSUBU_VX, 0x3 }, // 9895
  { PseudoVSSUBU_VX_M8_MASK, VSSUBU_VX, 0x3 }, // 9896
  { PseudoVSSUBU_VX_M8_TU, VSSUBU_VX, 0x3 }, // 9897
  { PseudoVSSUBU_VX_MF8, VSSUBU_VX, 0x5 }, // 9898
  { PseudoVSSUBU_VX_MF8_MASK, VSSUBU_VX, 0x5 }, // 9899
  { PseudoVSSUBU_VX_MF8_TU, VSSUBU_VX, 0x5 }, // 9900
  { PseudoVSSUBU_VX_MF4, VSSUBU_VX, 0x6 }, // 9901
  { PseudoVSSUBU_VX_MF4_MASK, VSSUBU_VX, 0x6 }, // 9902
  { PseudoVSSUBU_VX_MF4_TU, VSSUBU_VX, 0x6 }, // 9903
  { PseudoVSSUBU_VX_MF2, VSSUBU_VX, 0x7 }, // 9904
  { PseudoVSSUBU_VX_MF2_MASK, VSSUBU_VX, 0x7 }, // 9905
  { PseudoVSSUBU_VX_MF2_TU, VSSUBU_VX, 0x7 }, // 9906
  { PseudoVSSUB_VV_M1, VSSUB_VV, 0x0 }, // 9907
  { PseudoVSSUB_VV_M1_MASK, VSSUB_VV, 0x0 }, // 9908
  { PseudoVSSUB_VV_M1_TU, VSSUB_VV, 0x0 }, // 9909
  { PseudoVSSUB_VV_M2, VSSUB_VV, 0x1 }, // 9910
  { PseudoVSSUB_VV_M2_MASK, VSSUB_VV, 0x1 }, // 9911
  { PseudoVSSUB_VV_M2_TU, VSSUB_VV, 0x1 }, // 9912
  { PseudoVSSUB_VV_M4, VSSUB_VV, 0x2 }, // 9913
  { PseudoVSSUB_VV_M4_MASK, VSSUB_VV, 0x2 }, // 9914
  { PseudoVSSUB_VV_M4_TU, VSSUB_VV, 0x2 }, // 9915
  { PseudoVSSUB_VV_M8, VSSUB_VV, 0x3 }, // 9916
  { PseudoVSSUB_VV_M8_MASK, VSSUB_VV, 0x3 }, // 9917
  { PseudoVSSUB_VV_M8_TU, VSSUB_VV, 0x3 }, // 9918
  { PseudoVSSUB_VV_MF8, VSSUB_VV, 0x5 }, // 9919
  { PseudoVSSUB_VV_MF8_MASK, VSSUB_VV, 0x5 }, // 9920
  { PseudoVSSUB_VV_MF8_TU, VSSUB_VV, 0x5 }, // 9921
  { PseudoVSSUB_VV_MF4, VSSUB_VV, 0x6 }, // 9922
  { PseudoVSSUB_VV_MF4_MASK, VSSUB_VV, 0x6 }, // 9923
  { PseudoVSSUB_VV_MF4_TU, VSSUB_VV, 0x6 }, // 9924
  { PseudoVSSUB_VV_MF2, VSSUB_VV, 0x7 }, // 9925
  { PseudoVSSUB_VV_MF2_MASK, VSSUB_VV, 0x7 }, // 9926
  { PseudoVSSUB_VV_MF2_TU, VSSUB_VV, 0x7 }, // 9927
  { PseudoVSSUB_VX_M1, VSSUB_VX, 0x0 }, // 9928
  { PseudoVSSUB_VX_M1_MASK, VSSUB_VX, 0x0 }, // 9929
  { PseudoVSSUB_VX_M1_TU, VSSUB_VX, 0x0 }, // 9930
  { PseudoVSSUB_VX_M2, VSSUB_VX, 0x1 }, // 9931
  { PseudoVSSUB_VX_M2_MASK, VSSUB_VX, 0x1 }, // 9932
  { PseudoVSSUB_VX_M2_TU, VSSUB_VX, 0x1 }, // 9933
  { PseudoVSSUB_VX_M4, VSSUB_VX, 0x2 }, // 9934
  { PseudoVSSUB_VX_M4_MASK, VSSUB_VX, 0x2 }, // 9935
  { PseudoVSSUB_VX_M4_TU, VSSUB_VX, 0x2 }, // 9936
  { PseudoVSSUB_VX_M8, VSSUB_VX, 0x3 }, // 9937
  { PseudoVSSUB_VX_M8_MASK, VSSUB_VX, 0x3 }, // 9938
  { PseudoVSSUB_VX_M8_TU, VSSUB_VX, 0x3 }, // 9939
  { PseudoVSSUB_VX_MF8, VSSUB_VX, 0x5 }, // 9940
  { PseudoVSSUB_VX_MF8_MASK, VSSUB_VX, 0x5 }, // 9941
  { PseudoVSSUB_VX_MF8_TU, VSSUB_VX, 0x5 }, // 9942
  { PseudoVSSUB_VX_MF4, VSSUB_VX, 0x6 }, // 9943
  { PseudoVSSUB_VX_MF4_MASK, VSSUB_VX, 0x6 }, // 9944
  { PseudoVSSUB_VX_MF4_TU, VSSUB_VX, 0x6 }, // 9945
  { PseudoVSSUB_VX_MF2, VSSUB_VX, 0x7 }, // 9946
  { PseudoVSSUB_VX_MF2_MASK, VSSUB_VX, 0x7 }, // 9947
  { PseudoVSSUB_VX_MF2_TU, VSSUB_VX, 0x7 }, // 9948
  { PseudoVSUB_VV_M1, VSUB_VV, 0x0 }, // 9949
  { PseudoVSUB_VV_M1_MASK, VSUB_VV, 0x0 }, // 9950
  { PseudoVSUB_VV_M1_TU, VSUB_VV, 0x0 }, // 9951
  { PseudoVSUB_VV_M2, VSUB_VV, 0x1 }, // 9952
  { PseudoVSUB_VV_M2_MASK, VSUB_VV, 0x1 }, // 9953
  { PseudoVSUB_VV_M2_TU, VSUB_VV, 0x1 }, // 9954
  { PseudoVSUB_VV_M4, VSUB_VV, 0x2 }, // 9955
  { PseudoVSUB_VV_M4_MASK, VSUB_VV, 0x2 }, // 9956
  { PseudoVSUB_VV_M4_TU, VSUB_VV, 0x2 }, // 9957
  { PseudoVSUB_VV_M8, VSUB_VV, 0x3 }, // 9958
  { PseudoVSUB_VV_M8_MASK, VSUB_VV, 0x3 }, // 9959
  { PseudoVSUB_VV_M8_TU, VSUB_VV, 0x3 }, // 9960
  { PseudoVSUB_VV_MF8, VSUB_VV, 0x5 }, // 9961
  { PseudoVSUB_VV_MF8_MASK, VSUB_VV, 0x5 }, // 9962
  { PseudoVSUB_VV_MF8_TU, VSUB_VV, 0x5 }, // 9963
  { PseudoVSUB_VV_MF4, VSUB_VV, 0x6 }, // 9964
  { PseudoVSUB_VV_MF4_MASK, VSUB_VV, 0x6 }, // 9965
  { PseudoVSUB_VV_MF4_TU, VSUB_VV, 0x6 }, // 9966
  { PseudoVSUB_VV_MF2, VSUB_VV, 0x7 }, // 9967
  { PseudoVSUB_VV_MF2_MASK, VSUB_VV, 0x7 }, // 9968
  { PseudoVSUB_VV_MF2_TU, VSUB_VV, 0x7 }, // 9969
  { PseudoVSUB_VX_M1, VSUB_VX, 0x0 }, // 9970
  { PseudoVSUB_VX_M1_MASK, VSUB_VX, 0x0 }, // 9971
  { PseudoVSUB_VX_M1_TU, VSUB_VX, 0x0 }, // 9972
  { PseudoVSUB_VX_M2, VSUB_VX, 0x1 }, // 9973
  { PseudoVSUB_VX_M2_MASK, VSUB_VX, 0x1 }, // 9974
  { PseudoVSUB_VX_M2_TU, VSUB_VX, 0x1 }, // 9975
  { PseudoVSUB_VX_M4, VSUB_VX, 0x2 }, // 9976
  { PseudoVSUB_VX_M4_MASK, VSUB_VX, 0x2 }, // 9977
  { PseudoVSUB_VX_M4_TU, VSUB_VX, 0x2 }, // 9978
  { PseudoVSUB_VX_M8, VSUB_VX, 0x3 }, // 9979
  { PseudoVSUB_VX_M8_MASK, VSUB_VX, 0x3 }, // 9980
  { PseudoVSUB_VX_M8_TU, VSUB_VX, 0x3 }, // 9981
  { PseudoVSUB_VX_MF8, VSUB_VX, 0x5 }, // 9982
  { PseudoVSUB_VX_MF8_MASK, VSUB_VX, 0x5 }, // 9983
  { PseudoVSUB_VX_MF8_TU, VSUB_VX, 0x5 }, // 9984
  { PseudoVSUB_VX_MF4, VSUB_VX, 0x6 }, // 9985
  { PseudoVSUB_VX_MF4_MASK, VSUB_VX, 0x6 }, // 9986
  { PseudoVSUB_VX_MF4_TU, VSUB_VX, 0x6 }, // 9987
  { PseudoVSUB_VX_MF2, VSUB_VX, 0x7 }, // 9988
  { PseudoVSUB_VX_MF2_MASK, VSUB_VX, 0x7 }, // 9989
  { PseudoVSUB_VX_MF2_TU, VSUB_VX, 0x7 }, // 9990
  { PseudoVSUXEI16_V_M1_M1, VSUXEI16_V, 0x0 }, // 9991
  { PseudoVSUXEI16_V_M1_M1_MASK, VSUXEI16_V, 0x0 }, // 9992
  { PseudoVSUXEI16_V_M2_M1, VSUXEI16_V, 0x0 }, // 9993
  { PseudoVSUXEI16_V_M2_M1_MASK, VSUXEI16_V, 0x0 }, // 9994
  { PseudoVSUXEI16_V_MF2_M1, VSUXEI16_V, 0x0 }, // 9995
  { PseudoVSUXEI16_V_MF2_M1_MASK, VSUXEI16_V, 0x0 }, // 9996
  { PseudoVSUXEI16_V_MF4_M1, VSUXEI16_V, 0x0 }, // 9997
  { PseudoVSUXEI16_V_MF4_M1_MASK, VSUXEI16_V, 0x0 }, // 9998
  { PseudoVSUXEI16_V_M1_M2, VSUXEI16_V, 0x1 }, // 9999
  { PseudoVSUXEI16_V_M1_M2_MASK, VSUXEI16_V, 0x1 }, // 10000
  { PseudoVSUXEI16_V_M2_M2, VSUXEI16_V, 0x1 }, // 10001
  { PseudoVSUXEI16_V_M2_M2_MASK, VSUXEI16_V, 0x1 }, // 10002
  { PseudoVSUXEI16_V_M4_M2, VSUXEI16_V, 0x1 }, // 10003
  { PseudoVSUXEI16_V_M4_M2_MASK, VSUXEI16_V, 0x1 }, // 10004
  { PseudoVSUXEI16_V_MF2_M2, VSUXEI16_V, 0x1 }, // 10005
  { PseudoVSUXEI16_V_MF2_M2_MASK, VSUXEI16_V, 0x1 }, // 10006
  { PseudoVSUXEI16_V_M1_M4, VSUXEI16_V, 0x2 }, // 10007
  { PseudoVSUXEI16_V_M1_M4_MASK, VSUXEI16_V, 0x2 }, // 10008
  { PseudoVSUXEI16_V_M2_M4, VSUXEI16_V, 0x2 }, // 10009
  { PseudoVSUXEI16_V_M2_M4_MASK, VSUXEI16_V, 0x2 }, // 10010
  { PseudoVSUXEI16_V_M4_M4, VSUXEI16_V, 0x2 }, // 10011
  { PseudoVSUXEI16_V_M4_M4_MASK, VSUXEI16_V, 0x2 }, // 10012
  { PseudoVSUXEI16_V_M8_M4, VSUXEI16_V, 0x2 }, // 10013
  { PseudoVSUXEI16_V_M8_M4_MASK, VSUXEI16_V, 0x2 }, // 10014
  { PseudoVSUXEI16_V_M2_M8, VSUXEI16_V, 0x3 }, // 10015
  { PseudoVSUXEI16_V_M2_M8_MASK, VSUXEI16_V, 0x3 }, // 10016
  { PseudoVSUXEI16_V_M4_M8, VSUXEI16_V, 0x3 }, // 10017
  { PseudoVSUXEI16_V_M4_M8_MASK, VSUXEI16_V, 0x3 }, // 10018
  { PseudoVSUXEI16_V_M8_M8, VSUXEI16_V, 0x3 }, // 10019
  { PseudoVSUXEI16_V_M8_M8_MASK, VSUXEI16_V, 0x3 }, // 10020
  { PseudoVSUXEI16_V_MF4_MF8, VSUXEI16_V, 0x5 }, // 10021
  { PseudoVSUXEI16_V_MF4_MF8_MASK, VSUXEI16_V, 0x5 }, // 10022
  { PseudoVSUXEI16_V_MF2_MF4, VSUXEI16_V, 0x6 }, // 10023
  { PseudoVSUXEI16_V_MF2_MF4_MASK, VSUXEI16_V, 0x6 }, // 10024
  { PseudoVSUXEI16_V_MF4_MF4, VSUXEI16_V, 0x6 }, // 10025
  { PseudoVSUXEI16_V_MF4_MF4_MASK, VSUXEI16_V, 0x6 }, // 10026
  { PseudoVSUXEI16_V_M1_MF2, VSUXEI16_V, 0x7 }, // 10027
  { PseudoVSUXEI16_V_M1_MF2_MASK, VSUXEI16_V, 0x7 }, // 10028
  { PseudoVSUXEI16_V_MF2_MF2, VSUXEI16_V, 0x7 }, // 10029
  { PseudoVSUXEI16_V_MF2_MF2_MASK, VSUXEI16_V, 0x7 }, // 10030
  { PseudoVSUXEI16_V_MF4_MF2, VSUXEI16_V, 0x7 }, // 10031
  { PseudoVSUXEI16_V_MF4_MF2_MASK, VSUXEI16_V, 0x7 }, // 10032
  { PseudoVSUXEI32_V_M1_M1, VSUXEI32_V, 0x0 }, // 10033
  { PseudoVSUXEI32_V_M1_M1_MASK, VSUXEI32_V, 0x0 }, // 10034
  { PseudoVSUXEI32_V_M2_M1, VSUXEI32_V, 0x0 }, // 10035
  { PseudoVSUXEI32_V_M2_M1_MASK, VSUXEI32_V, 0x0 }, // 10036
  { PseudoVSUXEI32_V_M4_M1, VSUXEI32_V, 0x0 }, // 10037
  { PseudoVSUXEI32_V_M4_M1_MASK, VSUXEI32_V, 0x0 }, // 10038
  { PseudoVSUXEI32_V_MF2_M1, VSUXEI32_V, 0x0 }, // 10039
  { PseudoVSUXEI32_V_MF2_M1_MASK, VSUXEI32_V, 0x0 }, // 10040
  { PseudoVSUXEI32_V_M1_M2, VSUXEI32_V, 0x1 }, // 10041
  { PseudoVSUXEI32_V_M1_M2_MASK, VSUXEI32_V, 0x1 }, // 10042
  { PseudoVSUXEI32_V_M2_M2, VSUXEI32_V, 0x1 }, // 10043
  { PseudoVSUXEI32_V_M2_M2_MASK, VSUXEI32_V, 0x1 }, // 10044
  { PseudoVSUXEI32_V_M4_M2, VSUXEI32_V, 0x1 }, // 10045
  { PseudoVSUXEI32_V_M4_M2_MASK, VSUXEI32_V, 0x1 }, // 10046
  { PseudoVSUXEI32_V_M8_M2, VSUXEI32_V, 0x1 }, // 10047
  { PseudoVSUXEI32_V_M8_M2_MASK, VSUXEI32_V, 0x1 }, // 10048
  { PseudoVSUXEI32_V_M2_M4, VSUXEI32_V, 0x2 }, // 10049
  { PseudoVSUXEI32_V_M2_M4_MASK, VSUXEI32_V, 0x2 }, // 10050
  { PseudoVSUXEI32_V_M4_M4, VSUXEI32_V, 0x2 }, // 10051
  { PseudoVSUXEI32_V_M4_M4_MASK, VSUXEI32_V, 0x2 }, // 10052
  { PseudoVSUXEI32_V_M8_M4, VSUXEI32_V, 0x2 }, // 10053
  { PseudoVSUXEI32_V_M8_M4_MASK, VSUXEI32_V, 0x2 }, // 10054
  { PseudoVSUXEI32_V_M4_M8, VSUXEI32_V, 0x3 }, // 10055
  { PseudoVSUXEI32_V_M4_M8_MASK, VSUXEI32_V, 0x3 }, // 10056
  { PseudoVSUXEI32_V_M8_M8, VSUXEI32_V, 0x3 }, // 10057
  { PseudoVSUXEI32_V_M8_M8_MASK, VSUXEI32_V, 0x3 }, // 10058
  { PseudoVSUXEI32_V_MF2_MF8, VSUXEI32_V, 0x5 }, // 10059
  { PseudoVSUXEI32_V_MF2_MF8_MASK, VSUXEI32_V, 0x5 }, // 10060
  { PseudoVSUXEI32_V_M1_MF4, VSUXEI32_V, 0x6 }, // 10061
  { PseudoVSUXEI32_V_M1_MF4_MASK, VSUXEI32_V, 0x6 }, // 10062
  { PseudoVSUXEI32_V_MF2_MF4, VSUXEI32_V, 0x6 }, // 10063
  { PseudoVSUXEI32_V_MF2_MF4_MASK, VSUXEI32_V, 0x6 }, // 10064
  { PseudoVSUXEI32_V_M1_MF2, VSUXEI32_V, 0x7 }, // 10065
  { PseudoVSUXEI32_V_M1_MF2_MASK, VSUXEI32_V, 0x7 }, // 10066
  { PseudoVSUXEI32_V_M2_MF2, VSUXEI32_V, 0x7 }, // 10067
  { PseudoVSUXEI32_V_M2_MF2_MASK, VSUXEI32_V, 0x7 }, // 10068
  { PseudoVSUXEI32_V_MF2_MF2, VSUXEI32_V, 0x7 }, // 10069
  { PseudoVSUXEI32_V_MF2_MF2_MASK, VSUXEI32_V, 0x7 }, // 10070
  { PseudoVSUXEI64_V_M1_M1, VSUXEI64_V, 0x0 }, // 10071
  { PseudoVSUXEI64_V_M1_M1_MASK, VSUXEI64_V, 0x0 }, // 10072
  { PseudoVSUXEI64_V_M2_M1, VSUXEI64_V, 0x0 }, // 10073
  { PseudoVSUXEI64_V_M2_M1_MASK, VSUXEI64_V, 0x0 }, // 10074
  { PseudoVSUXEI64_V_M4_M1, VSUXEI64_V, 0x0 }, // 10075
  { PseudoVSUXEI64_V_M4_M1_MASK, VSUXEI64_V, 0x0 }, // 10076
  { PseudoVSUXEI64_V_M8_M1, VSUXEI64_V, 0x0 }, // 10077
  { PseudoVSUXEI64_V_M8_M1_MASK, VSUXEI64_V, 0x0 }, // 10078
  { PseudoVSUXEI64_V_M2_M2, VSUXEI64_V, 0x1 }, // 10079
  { PseudoVSUXEI64_V_M2_M2_MASK, VSUXEI64_V, 0x1 }, // 10080
  { PseudoVSUXEI64_V_M4_M2, VSUXEI64_V, 0x1 }, // 10081
  { PseudoVSUXEI64_V_M4_M2_MASK, VSUXEI64_V, 0x1 }, // 10082
  { PseudoVSUXEI64_V_M8_M2, VSUXEI64_V, 0x1 }, // 10083
  { PseudoVSUXEI64_V_M8_M2_MASK, VSUXEI64_V, 0x1 }, // 10084
  { PseudoVSUXEI64_V_M4_M4, VSUXEI64_V, 0x2 }, // 10085
  { PseudoVSUXEI64_V_M4_M4_MASK, VSUXEI64_V, 0x2 }, // 10086
  { PseudoVSUXEI64_V_M8_M4, VSUXEI64_V, 0x2 }, // 10087
  { PseudoVSUXEI64_V_M8_M4_MASK, VSUXEI64_V, 0x2 }, // 10088
  { PseudoVSUXEI64_V_M8_M8, VSUXEI64_V, 0x3 }, // 10089
  { PseudoVSUXEI64_V_M8_M8_MASK, VSUXEI64_V, 0x3 }, // 10090
  { PseudoVSUXEI64_V_M1_MF8, VSUXEI64_V, 0x5 }, // 10091
  { PseudoVSUXEI64_V_M1_MF8_MASK, VSUXEI64_V, 0x5 }, // 10092
  { PseudoVSUXEI64_V_M1_MF4, VSUXEI64_V, 0x6 }, // 10093
  { PseudoVSUXEI64_V_M1_MF4_MASK, VSUXEI64_V, 0x6 }, // 10094
  { PseudoVSUXEI64_V_M2_MF4, VSUXEI64_V, 0x6 }, // 10095
  { PseudoVSUXEI64_V_M2_MF4_MASK, VSUXEI64_V, 0x6 }, // 10096
  { PseudoVSUXEI64_V_M1_MF2, VSUXEI64_V, 0x7 }, // 10097
  { PseudoVSUXEI64_V_M1_MF2_MASK, VSUXEI64_V, 0x7 }, // 10098
  { PseudoVSUXEI64_V_M2_MF2, VSUXEI64_V, 0x7 }, // 10099
  { PseudoVSUXEI64_V_M2_MF2_MASK, VSUXEI64_V, 0x7 }, // 10100
  { PseudoVSUXEI64_V_M4_MF2, VSUXEI64_V, 0x7 }, // 10101
  { PseudoVSUXEI64_V_M4_MF2_MASK, VSUXEI64_V, 0x7 }, // 10102
  { PseudoVSUXEI8_V_M1_M1, VSUXEI8_V, 0x0 }, // 10103
  { PseudoVSUXEI8_V_M1_M1_MASK, VSUXEI8_V, 0x0 }, // 10104
  { PseudoVSUXEI8_V_MF2_M1, VSUXEI8_V, 0x0 }, // 10105
  { PseudoVSUXEI8_V_MF2_M1_MASK, VSUXEI8_V, 0x0 }, // 10106
  { PseudoVSUXEI8_V_MF4_M1, VSUXEI8_V, 0x0 }, // 10107
  { PseudoVSUXEI8_V_MF4_M1_MASK, VSUXEI8_V, 0x0 }, // 10108
  { PseudoVSUXEI8_V_MF8_M1, VSUXEI8_V, 0x0 }, // 10109
  { PseudoVSUXEI8_V_MF8_M1_MASK, VSUXEI8_V, 0x0 }, // 10110
  { PseudoVSUXEI8_V_M1_M2, VSUXEI8_V, 0x1 }, // 10111
  { PseudoVSUXEI8_V_M1_M2_MASK, VSUXEI8_V, 0x1 }, // 10112
  { PseudoVSUXEI8_V_M2_M2, VSUXEI8_V, 0x1 }, // 10113
  { PseudoVSUXEI8_V_M2_M2_MASK, VSUXEI8_V, 0x1 }, // 10114
  { PseudoVSUXEI8_V_MF2_M2, VSUXEI8_V, 0x1 }, // 10115
  { PseudoVSUXEI8_V_MF2_M2_MASK, VSUXEI8_V, 0x1 }, // 10116
  { PseudoVSUXEI8_V_MF4_M2, VSUXEI8_V, 0x1 }, // 10117
  { PseudoVSUXEI8_V_MF4_M2_MASK, VSUXEI8_V, 0x1 }, // 10118
  { PseudoVSUXEI8_V_M1_M4, VSUXEI8_V, 0x2 }, // 10119
  { PseudoVSUXEI8_V_M1_M4_MASK, VSUXEI8_V, 0x2 }, // 10120
  { PseudoVSUXEI8_V_M2_M4, VSUXEI8_V, 0x2 }, // 10121
  { PseudoVSUXEI8_V_M2_M4_MASK, VSUXEI8_V, 0x2 }, // 10122
  { PseudoVSUXEI8_V_M4_M4, VSUXEI8_V, 0x2 }, // 10123
  { PseudoVSUXEI8_V_M4_M4_MASK, VSUXEI8_V, 0x2 }, // 10124
  { PseudoVSUXEI8_V_MF2_M4, VSUXEI8_V, 0x2 }, // 10125
  { PseudoVSUXEI8_V_MF2_M4_MASK, VSUXEI8_V, 0x2 }, // 10126
  { PseudoVSUXEI8_V_M1_M8, VSUXEI8_V, 0x3 }, // 10127
  { PseudoVSUXEI8_V_M1_M8_MASK, VSUXEI8_V, 0x3 }, // 10128
  { PseudoVSUXEI8_V_M2_M8, VSUXEI8_V, 0x3 }, // 10129
  { PseudoVSUXEI8_V_M2_M8_MASK, VSUXEI8_V, 0x3 }, // 10130
  { PseudoVSUXEI8_V_M4_M8, VSUXEI8_V, 0x3 }, // 10131
  { PseudoVSUXEI8_V_M4_M8_MASK, VSUXEI8_V, 0x3 }, // 10132
  { PseudoVSUXEI8_V_M8_M8, VSUXEI8_V, 0x3 }, // 10133
  { PseudoVSUXEI8_V_M8_M8_MASK, VSUXEI8_V, 0x3 }, // 10134
  { PseudoVSUXEI8_V_MF8_MF8, VSUXEI8_V, 0x5 }, // 10135
  { PseudoVSUXEI8_V_MF8_MF8_MASK, VSUXEI8_V, 0x5 }, // 10136
  { PseudoVSUXEI8_V_MF4_MF4, VSUXEI8_V, 0x6 }, // 10137
  { PseudoVSUXEI8_V_MF4_MF4_MASK, VSUXEI8_V, 0x6 }, // 10138
  { PseudoVSUXEI8_V_MF8_MF4, VSUXEI8_V, 0x6 }, // 10139
  { PseudoVSUXEI8_V_MF8_MF4_MASK, VSUXEI8_V, 0x6 }, // 10140
  { PseudoVSUXEI8_V_MF2_MF2, VSUXEI8_V, 0x7 }, // 10141
  { PseudoVSUXEI8_V_MF2_MF2_MASK, VSUXEI8_V, 0x7 }, // 10142
  { PseudoVSUXEI8_V_MF4_MF2, VSUXEI8_V, 0x7 }, // 10143
  { PseudoVSUXEI8_V_MF4_MF2_MASK, VSUXEI8_V, 0x7 }, // 10144
  { PseudoVSUXEI8_V_MF8_MF2, VSUXEI8_V, 0x7 }, // 10145
  { PseudoVSUXEI8_V_MF8_MF2_MASK, VSUXEI8_V, 0x7 }, // 10146
  { PseudoVSUXSEG2EI16_V_M1_M1, VSUXSEG2EI16_V, 0x0 }, // 10147
  { PseudoVSUXSEG2EI16_V_M1_M1_MASK, VSUXSEG2EI16_V, 0x0 }, // 10148
  { PseudoVSUXSEG2EI16_V_M2_M1, VSUXSEG2EI16_V, 0x0 }, // 10149
  { PseudoVSUXSEG2EI16_V_M2_M1_MASK, VSUXSEG2EI16_V, 0x0 }, // 10150
  { PseudoVSUXSEG2EI16_V_MF2_M1, VSUXSEG2EI16_V, 0x0 }, // 10151
  { PseudoVSUXSEG2EI16_V_MF2_M1_MASK, VSUXSEG2EI16_V, 0x0 }, // 10152
  { PseudoVSUXSEG2EI16_V_MF4_M1, VSUXSEG2EI16_V, 0x0 }, // 10153
  { PseudoVSUXSEG2EI16_V_MF4_M1_MASK, VSUXSEG2EI16_V, 0x0 }, // 10154
  { PseudoVSUXSEG2EI16_V_M1_M2, VSUXSEG2EI16_V, 0x1 }, // 10155
  { PseudoVSUXSEG2EI16_V_M1_M2_MASK, VSUXSEG2EI16_V, 0x1 }, // 10156
  { PseudoVSUXSEG2EI16_V_M2_M2, VSUXSEG2EI16_V, 0x1 }, // 10157
  { PseudoVSUXSEG2EI16_V_M2_M2_MASK, VSUXSEG2EI16_V, 0x1 }, // 10158
  { PseudoVSUXSEG2EI16_V_M4_M2, VSUXSEG2EI16_V, 0x1 }, // 10159
  { PseudoVSUXSEG2EI16_V_M4_M2_MASK, VSUXSEG2EI16_V, 0x1 }, // 10160
  { PseudoVSUXSEG2EI16_V_MF2_M2, VSUXSEG2EI16_V, 0x1 }, // 10161
  { PseudoVSUXSEG2EI16_V_MF2_M2_MASK, VSUXSEG2EI16_V, 0x1 }, // 10162
  { PseudoVSUXSEG2EI16_V_M1_M4, VSUXSEG2EI16_V, 0x2 }, // 10163
  { PseudoVSUXSEG2EI16_V_M1_M4_MASK, VSUXSEG2EI16_V, 0x2 }, // 10164
  { PseudoVSUXSEG2EI16_V_M2_M4, VSUXSEG2EI16_V, 0x2 }, // 10165
  { PseudoVSUXSEG2EI16_V_M2_M4_MASK, VSUXSEG2EI16_V, 0x2 }, // 10166
  { PseudoVSUXSEG2EI16_V_M4_M4, VSUXSEG2EI16_V, 0x2 }, // 10167
  { PseudoVSUXSEG2EI16_V_M4_M4_MASK, VSUXSEG2EI16_V, 0x2 }, // 10168
  { PseudoVSUXSEG2EI16_V_M8_M4, VSUXSEG2EI16_V, 0x2 }, // 10169
  { PseudoVSUXSEG2EI16_V_M8_M4_MASK, VSUXSEG2EI16_V, 0x2 }, // 10170
  { PseudoVSUXSEG2EI16_V_MF4_MF8, VSUXSEG2EI16_V, 0x5 }, // 10171
  { PseudoVSUXSEG2EI16_V_MF4_MF8_MASK, VSUXSEG2EI16_V, 0x5 }, // 10172
  { PseudoVSUXSEG2EI16_V_MF2_MF4, VSUXSEG2EI16_V, 0x6 }, // 10173
  { PseudoVSUXSEG2EI16_V_MF2_MF4_MASK, VSUXSEG2EI16_V, 0x6 }, // 10174
  { PseudoVSUXSEG2EI16_V_MF4_MF4, VSUXSEG2EI16_V, 0x6 }, // 10175
  { PseudoVSUXSEG2EI16_V_MF4_MF4_MASK, VSUXSEG2EI16_V, 0x6 }, // 10176
  { PseudoVSUXSEG2EI16_V_M1_MF2, VSUXSEG2EI16_V, 0x7 }, // 10177
  { PseudoVSUXSEG2EI16_V_M1_MF2_MASK, VSUXSEG2EI16_V, 0x7 }, // 10178
  { PseudoVSUXSEG2EI16_V_MF2_MF2, VSUXSEG2EI16_V, 0x7 }, // 10179
  { PseudoVSUXSEG2EI16_V_MF2_MF2_MASK, VSUXSEG2EI16_V, 0x7 }, // 10180
  { PseudoVSUXSEG2EI16_V_MF4_MF2, VSUXSEG2EI16_V, 0x7 }, // 10181
  { PseudoVSUXSEG2EI16_V_MF4_MF2_MASK, VSUXSEG2EI16_V, 0x7 }, // 10182
  { PseudoVSUXSEG2EI32_V_M1_M1, VSUXSEG2EI32_V, 0x0 }, // 10183
  { PseudoVSUXSEG2EI32_V_M1_M1_MASK, VSUXSEG2EI32_V, 0x0 }, // 10184
  { PseudoVSUXSEG2EI32_V_M2_M1, VSUXSEG2EI32_V, 0x0 }, // 10185
  { PseudoVSUXSEG2EI32_V_M2_M1_MASK, VSUXSEG2EI32_V, 0x0 }, // 10186
  { PseudoVSUXSEG2EI32_V_M4_M1, VSUXSEG2EI32_V, 0x0 }, // 10187
  { PseudoVSUXSEG2EI32_V_M4_M1_MASK, VSUXSEG2EI32_V, 0x0 }, // 10188
  { PseudoVSUXSEG2EI32_V_MF2_M1, VSUXSEG2EI32_V, 0x0 }, // 10189
  { PseudoVSUXSEG2EI32_V_MF2_M1_MASK, VSUXSEG2EI32_V, 0x0 }, // 10190
  { PseudoVSUXSEG2EI32_V_M1_M2, VSUXSEG2EI32_V, 0x1 }, // 10191
  { PseudoVSUXSEG2EI32_V_M1_M2_MASK, VSUXSEG2EI32_V, 0x1 }, // 10192
  { PseudoVSUXSEG2EI32_V_M2_M2, VSUXSEG2EI32_V, 0x1 }, // 10193
  { PseudoVSUXSEG2EI32_V_M2_M2_MASK, VSUXSEG2EI32_V, 0x1 }, // 10194
  { PseudoVSUXSEG2EI32_V_M4_M2, VSUXSEG2EI32_V, 0x1 }, // 10195
  { PseudoVSUXSEG2EI32_V_M4_M2_MASK, VSUXSEG2EI32_V, 0x1 }, // 10196
  { PseudoVSUXSEG2EI32_V_M8_M2, VSUXSEG2EI32_V, 0x1 }, // 10197
  { PseudoVSUXSEG2EI32_V_M8_M2_MASK, VSUXSEG2EI32_V, 0x1 }, // 10198
  { PseudoVSUXSEG2EI32_V_M2_M4, VSUXSEG2EI32_V, 0x2 }, // 10199
  { PseudoVSUXSEG2EI32_V_M2_M4_MASK, VSUXSEG2EI32_V, 0x2 }, // 10200
  { PseudoVSUXSEG2EI32_V_M4_M4, VSUXSEG2EI32_V, 0x2 }, // 10201
  { PseudoVSUXSEG2EI32_V_M4_M4_MASK, VSUXSEG2EI32_V, 0x2 }, // 10202
  { PseudoVSUXSEG2EI32_V_M8_M4, VSUXSEG2EI32_V, 0x2 }, // 10203
  { PseudoVSUXSEG2EI32_V_M8_M4_MASK, VSUXSEG2EI32_V, 0x2 }, // 10204
  { PseudoVSUXSEG2EI32_V_MF2_MF8, VSUXSEG2EI32_V, 0x5 }, // 10205
  { PseudoVSUXSEG2EI32_V_MF2_MF8_MASK, VSUXSEG2EI32_V, 0x5 }, // 10206
  { PseudoVSUXSEG2EI32_V_M1_MF4, VSUXSEG2EI32_V, 0x6 }, // 10207
  { PseudoVSUXSEG2EI32_V_M1_MF4_MASK, VSUXSEG2EI32_V, 0x6 }, // 10208
  { PseudoVSUXSEG2EI32_V_MF2_MF4, VSUXSEG2EI32_V, 0x6 }, // 10209
  { PseudoVSUXSEG2EI32_V_MF2_MF4_MASK, VSUXSEG2EI32_V, 0x6 }, // 10210
  { PseudoVSUXSEG2EI32_V_M1_MF2, VSUXSEG2EI32_V, 0x7 }, // 10211
  { PseudoVSUXSEG2EI32_V_M1_MF2_MASK, VSUXSEG2EI32_V, 0x7 }, // 10212
  { PseudoVSUXSEG2EI32_V_M2_MF2, VSUXSEG2EI32_V, 0x7 }, // 10213
  { PseudoVSUXSEG2EI32_V_M2_MF2_MASK, VSUXSEG2EI32_V, 0x7 }, // 10214
  { PseudoVSUXSEG2EI32_V_MF2_MF2, VSUXSEG2EI32_V, 0x7 }, // 10215
  { PseudoVSUXSEG2EI32_V_MF2_MF2_MASK, VSUXSEG2EI32_V, 0x7 }, // 10216
  { PseudoVSUXSEG2EI64_V_M1_M1, VSUXSEG2EI64_V, 0x0 }, // 10217
  { PseudoVSUXSEG2EI64_V_M1_M1_MASK, VSUXSEG2EI64_V, 0x0 }, // 10218
  { PseudoVSUXSEG2EI64_V_M2_M1, VSUXSEG2EI64_V, 0x0 }, // 10219
  { PseudoVSUXSEG2EI64_V_M2_M1_MASK, VSUXSEG2EI64_V, 0x0 }, // 10220
  { PseudoVSUXSEG2EI64_V_M4_M1, VSUXSEG2EI64_V, 0x0 }, // 10221
  { PseudoVSUXSEG2EI64_V_M4_M1_MASK, VSUXSEG2EI64_V, 0x0 }, // 10222
  { PseudoVSUXSEG2EI64_V_M8_M1, VSUXSEG2EI64_V, 0x0 }, // 10223
  { PseudoVSUXSEG2EI64_V_M8_M1_MASK, VSUXSEG2EI64_V, 0x0 }, // 10224
  { PseudoVSUXSEG2EI64_V_M2_M2, VSUXSEG2EI64_V, 0x1 }, // 10225
  { PseudoVSUXSEG2EI64_V_M2_M2_MASK, VSUXSEG2EI64_V, 0x1 }, // 10226
  { PseudoVSUXSEG2EI64_V_M4_M2, VSUXSEG2EI64_V, 0x1 }, // 10227
  { PseudoVSUXSEG2EI64_V_M4_M2_MASK, VSUXSEG2EI64_V, 0x1 }, // 10228
  { PseudoVSUXSEG2EI64_V_M8_M2, VSUXSEG2EI64_V, 0x1 }, // 10229
  { PseudoVSUXSEG2EI64_V_M8_M2_MASK, VSUXSEG2EI64_V, 0x1 }, // 10230
  { PseudoVSUXSEG2EI64_V_M4_M4, VSUXSEG2EI64_V, 0x2 }, // 10231
  { PseudoVSUXSEG2EI64_V_M4_M4_MASK, VSUXSEG2EI64_V, 0x2 }, // 10232
  { PseudoVSUXSEG2EI64_V_M8_M4, VSUXSEG2EI64_V, 0x2 }, // 10233
  { PseudoVSUXSEG2EI64_V_M8_M4_MASK, VSUXSEG2EI64_V, 0x2 }, // 10234
  { PseudoVSUXSEG2EI64_V_M1_MF8, VSUXSEG2EI64_V, 0x5 }, // 10235
  { PseudoVSUXSEG2EI64_V_M1_MF8_MASK, VSUXSEG2EI64_V, 0x5 }, // 10236
  { PseudoVSUXSEG2EI64_V_M1_MF4, VSUXSEG2EI64_V, 0x6 }, // 10237
  { PseudoVSUXSEG2EI64_V_M1_MF4_MASK, VSUXSEG2EI64_V, 0x6 }, // 10238
  { PseudoVSUXSEG2EI64_V_M2_MF4, VSUXSEG2EI64_V, 0x6 }, // 10239
  { PseudoVSUXSEG2EI64_V_M2_MF4_MASK, VSUXSEG2EI64_V, 0x6 }, // 10240
  { PseudoVSUXSEG2EI64_V_M1_MF2, VSUXSEG2EI64_V, 0x7 }, // 10241
  { PseudoVSUXSEG2EI64_V_M1_MF2_MASK, VSUXSEG2EI64_V, 0x7 }, // 10242
  { PseudoVSUXSEG2EI64_V_M2_MF2, VSUXSEG2EI64_V, 0x7 }, // 10243
  { PseudoVSUXSEG2EI64_V_M2_MF2_MASK, VSUXSEG2EI64_V, 0x7 }, // 10244
  { PseudoVSUXSEG2EI64_V_M4_MF2, VSUXSEG2EI64_V, 0x7 }, // 10245
  { PseudoVSUXSEG2EI64_V_M4_MF2_MASK, VSUXSEG2EI64_V, 0x7 }, // 10246
  { PseudoVSUXSEG2EI8_V_M1_M1, VSUXSEG2EI8_V, 0x0 }, // 10247
  { PseudoVSUXSEG2EI8_V_M1_M1_MASK, VSUXSEG2EI8_V, 0x0 }, // 10248
  { PseudoVSUXSEG2EI8_V_MF2_M1, VSUXSEG2EI8_V, 0x0 }, // 10249
  { PseudoVSUXSEG2EI8_V_MF2_M1_MASK, VSUXSEG2EI8_V, 0x0 }, // 10250
  { PseudoVSUXSEG2EI8_V_MF4_M1, VSUXSEG2EI8_V, 0x0 }, // 10251
  { PseudoVSUXSEG2EI8_V_MF4_M1_MASK, VSUXSEG2EI8_V, 0x0 }, // 10252
  { PseudoVSUXSEG2EI8_V_MF8_M1, VSUXSEG2EI8_V, 0x0 }, // 10253
  { PseudoVSUXSEG2EI8_V_MF8_M1_MASK, VSUXSEG2EI8_V, 0x0 }, // 10254
  { PseudoVSUXSEG2EI8_V_M1_M2, VSUXSEG2EI8_V, 0x1 }, // 10255
  { PseudoVSUXSEG2EI8_V_M1_M2_MASK, VSUXSEG2EI8_V, 0x1 }, // 10256
  { PseudoVSUXSEG2EI8_V_M2_M2, VSUXSEG2EI8_V, 0x1 }, // 10257
  { PseudoVSUXSEG2EI8_V_M2_M2_MASK, VSUXSEG2EI8_V, 0x1 }, // 10258
  { PseudoVSUXSEG2EI8_V_MF2_M2, VSUXSEG2EI8_V, 0x1 }, // 10259
  { PseudoVSUXSEG2EI8_V_MF2_M2_MASK, VSUXSEG2EI8_V, 0x1 }, // 10260
  { PseudoVSUXSEG2EI8_V_MF4_M2, VSUXSEG2EI8_V, 0x1 }, // 10261
  { PseudoVSUXSEG2EI8_V_MF4_M2_MASK, VSUXSEG2EI8_V, 0x1 }, // 10262
  { PseudoVSUXSEG2EI8_V_M1_M4, VSUXSEG2EI8_V, 0x2 }, // 10263
  { PseudoVSUXSEG2EI8_V_M1_M4_MASK, VSUXSEG2EI8_V, 0x2 }, // 10264
  { PseudoVSUXSEG2EI8_V_M2_M4, VSUXSEG2EI8_V, 0x2 }, // 10265
  { PseudoVSUXSEG2EI8_V_M2_M4_MASK, VSUXSEG2EI8_V, 0x2 }, // 10266
  { PseudoVSUXSEG2EI8_V_M4_M4, VSUXSEG2EI8_V, 0x2 }, // 10267
  { PseudoVSUXSEG2EI8_V_M4_M4_MASK, VSUXSEG2EI8_V, 0x2 }, // 10268
  { PseudoVSUXSEG2EI8_V_MF2_M4, VSUXSEG2EI8_V, 0x2 }, // 10269
  { PseudoVSUXSEG2EI8_V_MF2_M4_MASK, VSUXSEG2EI8_V, 0x2 }, // 10270
  { PseudoVSUXSEG2EI8_V_MF8_MF8, VSUXSEG2EI8_V, 0x5 }, // 10271
  { PseudoVSUXSEG2EI8_V_MF8_MF8_MASK, VSUXSEG2EI8_V, 0x5 }, // 10272
  { PseudoVSUXSEG2EI8_V_MF4_MF4, VSUXSEG2EI8_V, 0x6 }, // 10273
  { PseudoVSUXSEG2EI8_V_MF4_MF4_MASK, VSUXSEG2EI8_V, 0x6 }, // 10274
  { PseudoVSUXSEG2EI8_V_MF8_MF4, VSUXSEG2EI8_V, 0x6 }, // 10275
  { PseudoVSUXSEG2EI8_V_MF8_MF4_MASK, VSUXSEG2EI8_V, 0x6 }, // 10276
  { PseudoVSUXSEG2EI8_V_MF2_MF2, VSUXSEG2EI8_V, 0x7 }, // 10277
  { PseudoVSUXSEG2EI8_V_MF2_MF2_MASK, VSUXSEG2EI8_V, 0x7 }, // 10278
  { PseudoVSUXSEG2EI8_V_MF4_MF2, VSUXSEG2EI8_V, 0x7 }, // 10279
  { PseudoVSUXSEG2EI8_V_MF4_MF2_MASK, VSUXSEG2EI8_V, 0x7 }, // 10280
  { PseudoVSUXSEG2EI8_V_MF8_MF2, VSUXSEG2EI8_V, 0x7 }, // 10281
  { PseudoVSUXSEG2EI8_V_MF8_MF2_MASK, VSUXSEG2EI8_V, 0x7 }, // 10282
  { PseudoVSUXSEG3EI16_V_M1_M1, VSUXSEG3EI16_V, 0x0 }, // 10283
  { PseudoVSUXSEG3EI16_V_M1_M1_MASK, VSUXSEG3EI16_V, 0x0 }, // 10284
  { PseudoVSUXSEG3EI16_V_M2_M1, VSUXSEG3EI16_V, 0x0 }, // 10285
  { PseudoVSUXSEG3EI16_V_M2_M1_MASK, VSUXSEG3EI16_V, 0x0 }, // 10286
  { PseudoVSUXSEG3EI16_V_MF2_M1, VSUXSEG3EI16_V, 0x0 }, // 10287
  { PseudoVSUXSEG3EI16_V_MF2_M1_MASK, VSUXSEG3EI16_V, 0x0 }, // 10288
  { PseudoVSUXSEG3EI16_V_MF4_M1, VSUXSEG3EI16_V, 0x0 }, // 10289
  { PseudoVSUXSEG3EI16_V_MF4_M1_MASK, VSUXSEG3EI16_V, 0x0 }, // 10290
  { PseudoVSUXSEG3EI16_V_M1_M2, VSUXSEG3EI16_V, 0x1 }, // 10291
  { PseudoVSUXSEG3EI16_V_M1_M2_MASK, VSUXSEG3EI16_V, 0x1 }, // 10292
  { PseudoVSUXSEG3EI16_V_M2_M2, VSUXSEG3EI16_V, 0x1 }, // 10293
  { PseudoVSUXSEG3EI16_V_M2_M2_MASK, VSUXSEG3EI16_V, 0x1 }, // 10294
  { PseudoVSUXSEG3EI16_V_M4_M2, VSUXSEG3EI16_V, 0x1 }, // 10295
  { PseudoVSUXSEG3EI16_V_M4_M2_MASK, VSUXSEG3EI16_V, 0x1 }, // 10296
  { PseudoVSUXSEG3EI16_V_MF2_M2, VSUXSEG3EI16_V, 0x1 }, // 10297
  { PseudoVSUXSEG3EI16_V_MF2_M2_MASK, VSUXSEG3EI16_V, 0x1 }, // 10298
  { PseudoVSUXSEG3EI16_V_MF4_MF8, VSUXSEG3EI16_V, 0x5 }, // 10299
  { PseudoVSUXSEG3EI16_V_MF4_MF8_MASK, VSUXSEG3EI16_V, 0x5 }, // 10300
  { PseudoVSUXSEG3EI16_V_MF2_MF4, VSUXSEG3EI16_V, 0x6 }, // 10301
  { PseudoVSUXSEG3EI16_V_MF2_MF4_MASK, VSUXSEG3EI16_V, 0x6 }, // 10302
  { PseudoVSUXSEG3EI16_V_MF4_MF4, VSUXSEG3EI16_V, 0x6 }, // 10303
  { PseudoVSUXSEG3EI16_V_MF4_MF4_MASK, VSUXSEG3EI16_V, 0x6 }, // 10304
  { PseudoVSUXSEG3EI16_V_M1_MF2, VSUXSEG3EI16_V, 0x7 }, // 10305
  { PseudoVSUXSEG3EI16_V_M1_MF2_MASK, VSUXSEG3EI16_V, 0x7 }, // 10306
  { PseudoVSUXSEG3EI16_V_MF2_MF2, VSUXSEG3EI16_V, 0x7 }, // 10307
  { PseudoVSUXSEG3EI16_V_MF2_MF2_MASK, VSUXSEG3EI16_V, 0x7 }, // 10308
  { PseudoVSUXSEG3EI16_V_MF4_MF2, VSUXSEG3EI16_V, 0x7 }, // 10309
  { PseudoVSUXSEG3EI16_V_MF4_MF2_MASK, VSUXSEG3EI16_V, 0x7 }, // 10310
  { PseudoVSUXSEG3EI32_V_M1_M1, VSUXSEG3EI32_V, 0x0 }, // 10311
  { PseudoVSUXSEG3EI32_V_M1_M1_MASK, VSUXSEG3EI32_V, 0x0 }, // 10312
  { PseudoVSUXSEG3EI32_V_M2_M1, VSUXSEG3EI32_V, 0x0 }, // 10313
  { PseudoVSUXSEG3EI32_V_M2_M1_MASK, VSUXSEG3EI32_V, 0x0 }, // 10314
  { PseudoVSUXSEG3EI32_V_M4_M1, VSUXSEG3EI32_V, 0x0 }, // 10315
  { PseudoVSUXSEG3EI32_V_M4_M1_MASK, VSUXSEG3EI32_V, 0x0 }, // 10316
  { PseudoVSUXSEG3EI32_V_MF2_M1, VSUXSEG3EI32_V, 0x0 }, // 10317
  { PseudoVSUXSEG3EI32_V_MF2_M1_MASK, VSUXSEG3EI32_V, 0x0 }, // 10318
  { PseudoVSUXSEG3EI32_V_M1_M2, VSUXSEG3EI32_V, 0x1 }, // 10319
  { PseudoVSUXSEG3EI32_V_M1_M2_MASK, VSUXSEG3EI32_V, 0x1 }, // 10320
  { PseudoVSUXSEG3EI32_V_M2_M2, VSUXSEG3EI32_V, 0x1 }, // 10321
  { PseudoVSUXSEG3EI32_V_M2_M2_MASK, VSUXSEG3EI32_V, 0x1 }, // 10322
  { PseudoVSUXSEG3EI32_V_M4_M2, VSUXSEG3EI32_V, 0x1 }, // 10323
  { PseudoVSUXSEG3EI32_V_M4_M2_MASK, VSUXSEG3EI32_V, 0x1 }, // 10324
  { PseudoVSUXSEG3EI32_V_M8_M2, VSUXSEG3EI32_V, 0x1 }, // 10325
  { PseudoVSUXSEG3EI32_V_M8_M2_MASK, VSUXSEG3EI32_V, 0x1 }, // 10326
  { PseudoVSUXSEG3EI32_V_MF2_MF8, VSUXSEG3EI32_V, 0x5 }, // 10327
  { PseudoVSUXSEG3EI32_V_MF2_MF8_MASK, VSUXSEG3EI32_V, 0x5 }, // 10328
  { PseudoVSUXSEG3EI32_V_M1_MF4, VSUXSEG3EI32_V, 0x6 }, // 10329
  { PseudoVSUXSEG3EI32_V_M1_MF4_MASK, VSUXSEG3EI32_V, 0x6 }, // 10330
  { PseudoVSUXSEG3EI32_V_MF2_MF4, VSUXSEG3EI32_V, 0x6 }, // 10331
  { PseudoVSUXSEG3EI32_V_MF2_MF4_MASK, VSUXSEG3EI32_V, 0x6 }, // 10332
  { PseudoVSUXSEG3EI32_V_M1_MF2, VSUXSEG3EI32_V, 0x7 }, // 10333
  { PseudoVSUXSEG3EI32_V_M1_MF2_MASK, VSUXSEG3EI32_V, 0x7 }, // 10334
  { PseudoVSUXSEG3EI32_V_M2_MF2, VSUXSEG3EI32_V, 0x7 }, // 10335
  { PseudoVSUXSEG3EI32_V_M2_MF2_MASK, VSUXSEG3EI32_V, 0x7 }, // 10336
  { PseudoVSUXSEG3EI32_V_MF2_MF2, VSUXSEG3EI32_V, 0x7 }, // 10337
  { PseudoVSUXSEG3EI32_V_MF2_MF2_MASK, VSUXSEG3EI32_V, 0x7 }, // 10338
  { PseudoVSUXSEG3EI64_V_M1_M1, VSUXSEG3EI64_V, 0x0 }, // 10339
  { PseudoVSUXSEG3EI64_V_M1_M1_MASK, VSUXSEG3EI64_V, 0x0 }, // 10340
  { PseudoVSUXSEG3EI64_V_M2_M1, VSUXSEG3EI64_V, 0x0 }, // 10341
  { PseudoVSUXSEG3EI64_V_M2_M1_MASK, VSUXSEG3EI64_V, 0x0 }, // 10342
  { PseudoVSUXSEG3EI64_V_M4_M1, VSUXSEG3EI64_V, 0x0 }, // 10343
  { PseudoVSUXSEG3EI64_V_M4_M1_MASK, VSUXSEG3EI64_V, 0x0 }, // 10344
  { PseudoVSUXSEG3EI64_V_M8_M1, VSUXSEG3EI64_V, 0x0 }, // 10345
  { PseudoVSUXSEG3EI64_V_M8_M1_MASK, VSUXSEG3EI64_V, 0x0 }, // 10346
  { PseudoVSUXSEG3EI64_V_M2_M2, VSUXSEG3EI64_V, 0x1 }, // 10347
  { PseudoVSUXSEG3EI64_V_M2_M2_MASK, VSUXSEG3EI64_V, 0x1 }, // 10348
  { PseudoVSUXSEG3EI64_V_M4_M2, VSUXSEG3EI64_V, 0x1 }, // 10349
  { PseudoVSUXSEG3EI64_V_M4_M2_MASK, VSUXSEG3EI64_V, 0x1 }, // 10350
  { PseudoVSUXSEG3EI64_V_M8_M2, VSUXSEG3EI64_V, 0x1 }, // 10351
  { PseudoVSUXSEG3EI64_V_M8_M2_MASK, VSUXSEG3EI64_V, 0x1 }, // 10352
  { PseudoVSUXSEG3EI64_V_M1_MF8, VSUXSEG3EI64_V, 0x5 }, // 10353
  { PseudoVSUXSEG3EI64_V_M1_MF8_MASK, VSUXSEG3EI64_V, 0x5 }, // 10354
  { PseudoVSUXSEG3EI64_V_M1_MF4, VSUXSEG3EI64_V, 0x6 }, // 10355
  { PseudoVSUXSEG3EI64_V_M1_MF4_MASK, VSUXSEG3EI64_V, 0x6 }, // 10356
  { PseudoVSUXSEG3EI64_V_M2_MF4, VSUXSEG3EI64_V, 0x6 }, // 10357
  { PseudoVSUXSEG3EI64_V_M2_MF4_MASK, VSUXSEG3EI64_V, 0x6 }, // 10358
  { PseudoVSUXSEG3EI64_V_M1_MF2, VSUXSEG3EI64_V, 0x7 }, // 10359
  { PseudoVSUXSEG3EI64_V_M1_MF2_MASK, VSUXSEG3EI64_V, 0x7 }, // 10360
  { PseudoVSUXSEG3EI64_V_M2_MF2, VSUXSEG3EI64_V, 0x7 }, // 10361
  { PseudoVSUXSEG3EI64_V_M2_MF2_MASK, VSUXSEG3EI64_V, 0x7 }, // 10362
  { PseudoVSUXSEG3EI64_V_M4_MF2, VSUXSEG3EI64_V, 0x7 }, // 10363
  { PseudoVSUXSEG3EI64_V_M4_MF2_MASK, VSUXSEG3EI64_V, 0x7 }, // 10364
  { PseudoVSUXSEG3EI8_V_M1_M1, VSUXSEG3EI8_V, 0x0 }, // 10365
  { PseudoVSUXSEG3EI8_V_M1_M1_MASK, VSUXSEG3EI8_V, 0x0 }, // 10366
  { PseudoVSUXSEG3EI8_V_MF2_M1, VSUXSEG3EI8_V, 0x0 }, // 10367
  { PseudoVSUXSEG3EI8_V_MF2_M1_MASK, VSUXSEG3EI8_V, 0x0 }, // 10368
  { PseudoVSUXSEG3EI8_V_MF4_M1, VSUXSEG3EI8_V, 0x0 }, // 10369
  { PseudoVSUXSEG3EI8_V_MF4_M1_MASK, VSUXSEG3EI8_V, 0x0 }, // 10370
  { PseudoVSUXSEG3EI8_V_MF8_M1, VSUXSEG3EI8_V, 0x0 }, // 10371
  { PseudoVSUXSEG3EI8_V_MF8_M1_MASK, VSUXSEG3EI8_V, 0x0 }, // 10372
  { PseudoVSUXSEG3EI8_V_M1_M2, VSUXSEG3EI8_V, 0x1 }, // 10373
  { PseudoVSUXSEG3EI8_V_M1_M2_MASK, VSUXSEG3EI8_V, 0x1 }, // 10374
  { PseudoVSUXSEG3EI8_V_M2_M2, VSUXSEG3EI8_V, 0x1 }, // 10375
  { PseudoVSUXSEG3EI8_V_M2_M2_MASK, VSUXSEG3EI8_V, 0x1 }, // 10376
  { PseudoVSUXSEG3EI8_V_MF2_M2, VSUXSEG3EI8_V, 0x1 }, // 10377
  { PseudoVSUXSEG3EI8_V_MF2_M2_MASK, VSUXSEG3EI8_V, 0x1 }, // 10378
  { PseudoVSUXSEG3EI8_V_MF4_M2, VSUXSEG3EI8_V, 0x1 }, // 10379
  { PseudoVSUXSEG3EI8_V_MF4_M2_MASK, VSUXSEG3EI8_V, 0x1 }, // 10380
  { PseudoVSUXSEG3EI8_V_MF8_MF8, VSUXSEG3EI8_V, 0x5 }, // 10381
  { PseudoVSUXSEG3EI8_V_MF8_MF8_MASK, VSUXSEG3EI8_V, 0x5 }, // 10382
  { PseudoVSUXSEG3EI8_V_MF4_MF4, VSUXSEG3EI8_V, 0x6 }, // 10383
  { PseudoVSUXSEG3EI8_V_MF4_MF4_MASK, VSUXSEG3EI8_V, 0x6 }, // 10384
  { PseudoVSUXSEG3EI8_V_MF8_MF4, VSUXSEG3EI8_V, 0x6 }, // 10385
  { PseudoVSUXSEG3EI8_V_MF8_MF4_MASK, VSUXSEG3EI8_V, 0x6 }, // 10386
  { PseudoVSUXSEG3EI8_V_MF2_MF2, VSUXSEG3EI8_V, 0x7 }, // 10387
  { PseudoVSUXSEG3EI8_V_MF2_MF2_MASK, VSUXSEG3EI8_V, 0x7 }, // 10388
  { PseudoVSUXSEG3EI8_V_MF4_MF2, VSUXSEG3EI8_V, 0x7 }, // 10389
  { PseudoVSUXSEG3EI8_V_MF4_MF2_MASK, VSUXSEG3EI8_V, 0x7 }, // 10390
  { PseudoVSUXSEG3EI8_V_MF8_MF2, VSUXSEG3EI8_V, 0x7 }, // 10391
  { PseudoVSUXSEG3EI8_V_MF8_MF2_MASK, VSUXSEG3EI8_V, 0x7 }, // 10392
  { PseudoVSUXSEG4EI16_V_M1_M1, VSUXSEG4EI16_V, 0x0 }, // 10393
  { PseudoVSUXSEG4EI16_V_M1_M1_MASK, VSUXSEG4EI16_V, 0x0 }, // 10394
  { PseudoVSUXSEG4EI16_V_M2_M1, VSUXSEG4EI16_V, 0x0 }, // 10395
  { PseudoVSUXSEG4EI16_V_M2_M1_MASK, VSUXSEG4EI16_V, 0x0 }, // 10396
  { PseudoVSUXSEG4EI16_V_MF2_M1, VSUXSEG4EI16_V, 0x0 }, // 10397
  { PseudoVSUXSEG4EI16_V_MF2_M1_MASK, VSUXSEG4EI16_V, 0x0 }, // 10398
  { PseudoVSUXSEG4EI16_V_MF4_M1, VSUXSEG4EI16_V, 0x0 }, // 10399
  { PseudoVSUXSEG4EI16_V_MF4_M1_MASK, VSUXSEG4EI16_V, 0x0 }, // 10400
  { PseudoVSUXSEG4EI16_V_M1_M2, VSUXSEG4EI16_V, 0x1 }, // 10401
  { PseudoVSUXSEG4EI16_V_M1_M2_MASK, VSUXSEG4EI16_V, 0x1 }, // 10402
  { PseudoVSUXSEG4EI16_V_M2_M2, VSUXSEG4EI16_V, 0x1 }, // 10403
  { PseudoVSUXSEG4EI16_V_M2_M2_MASK, VSUXSEG4EI16_V, 0x1 }, // 10404
  { PseudoVSUXSEG4EI16_V_M4_M2, VSUXSEG4EI16_V, 0x1 }, // 10405
  { PseudoVSUXSEG4EI16_V_M4_M2_MASK, VSUXSEG4EI16_V, 0x1 }, // 10406
  { PseudoVSUXSEG4EI16_V_MF2_M2, VSUXSEG4EI16_V, 0x1 }, // 10407
  { PseudoVSUXSEG4EI16_V_MF2_M2_MASK, VSUXSEG4EI16_V, 0x1 }, // 10408
  { PseudoVSUXSEG4EI16_V_MF4_MF8, VSUXSEG4EI16_V, 0x5 }, // 10409
  { PseudoVSUXSEG4EI16_V_MF4_MF8_MASK, VSUXSEG4EI16_V, 0x5 }, // 10410
  { PseudoVSUXSEG4EI16_V_MF2_MF4, VSUXSEG4EI16_V, 0x6 }, // 10411
  { PseudoVSUXSEG4EI16_V_MF2_MF4_MASK, VSUXSEG4EI16_V, 0x6 }, // 10412
  { PseudoVSUXSEG4EI16_V_MF4_MF4, VSUXSEG4EI16_V, 0x6 }, // 10413
  { PseudoVSUXSEG4EI16_V_MF4_MF4_MASK, VSUXSEG4EI16_V, 0x6 }, // 10414
  { PseudoVSUXSEG4EI16_V_M1_MF2, VSUXSEG4EI16_V, 0x7 }, // 10415
  { PseudoVSUXSEG4EI16_V_M1_MF2_MASK, VSUXSEG4EI16_V, 0x7 }, // 10416
  { PseudoVSUXSEG4EI16_V_MF2_MF2, VSUXSEG4EI16_V, 0x7 }, // 10417
  { PseudoVSUXSEG4EI16_V_MF2_MF2_MASK, VSUXSEG4EI16_V, 0x7 }, // 10418
  { PseudoVSUXSEG4EI16_V_MF4_MF2, VSUXSEG4EI16_V, 0x7 }, // 10419
  { PseudoVSUXSEG4EI16_V_MF4_MF2_MASK, VSUXSEG4EI16_V, 0x7 }, // 10420
  { PseudoVSUXSEG4EI32_V_M1_M1, VSUXSEG4EI32_V, 0x0 }, // 10421
  { PseudoVSUXSEG4EI32_V_M1_M1_MASK, VSUXSEG4EI32_V, 0x0 }, // 10422
  { PseudoVSUXSEG4EI32_V_M2_M1, VSUXSEG4EI32_V, 0x0 }, // 10423
  { PseudoVSUXSEG4EI32_V_M2_M1_MASK, VSUXSEG4EI32_V, 0x0 }, // 10424
  { PseudoVSUXSEG4EI32_V_M4_M1, VSUXSEG4EI32_V, 0x0 }, // 10425
  { PseudoVSUXSEG4EI32_V_M4_M1_MASK, VSUXSEG4EI32_V, 0x0 }, // 10426
  { PseudoVSUXSEG4EI32_V_MF2_M1, VSUXSEG4EI32_V, 0x0 }, // 10427
  { PseudoVSUXSEG4EI32_V_MF2_M1_MASK, VSUXSEG4EI32_V, 0x0 }, // 10428
  { PseudoVSUXSEG4EI32_V_M1_M2, VSUXSEG4EI32_V, 0x1 }, // 10429
  { PseudoVSUXSEG4EI32_V_M1_M2_MASK, VSUXSEG4EI32_V, 0x1 }, // 10430
  { PseudoVSUXSEG4EI32_V_M2_M2, VSUXSEG4EI32_V, 0x1 }, // 10431
  { PseudoVSUXSEG4EI32_V_M2_M2_MASK, VSUXSEG4EI32_V, 0x1 }, // 10432
  { PseudoVSUXSEG4EI32_V_M4_M2, VSUXSEG4EI32_V, 0x1 }, // 10433
  { PseudoVSUXSEG4EI32_V_M4_M2_MASK, VSUXSEG4EI32_V, 0x1 }, // 10434
  { PseudoVSUXSEG4EI32_V_M8_M2, VSUXSEG4EI32_V, 0x1 }, // 10435
  { PseudoVSUXSEG4EI32_V_M8_M2_MASK, VSUXSEG4EI32_V, 0x1 }, // 10436
  { PseudoVSUXSEG4EI32_V_MF2_MF8, VSUXSEG4EI32_V, 0x5 }, // 10437
  { PseudoVSUXSEG4EI32_V_MF2_MF8_MASK, VSUXSEG4EI32_V, 0x5 }, // 10438
  { PseudoVSUXSEG4EI32_V_M1_MF4, VSUXSEG4EI32_V, 0x6 }, // 10439
  { PseudoVSUXSEG4EI32_V_M1_MF4_MASK, VSUXSEG4EI32_V, 0x6 }, // 10440
  { PseudoVSUXSEG4EI32_V_MF2_MF4, VSUXSEG4EI32_V, 0x6 }, // 10441
  { PseudoVSUXSEG4EI32_V_MF2_MF4_MASK, VSUXSEG4EI32_V, 0x6 }, // 10442
  { PseudoVSUXSEG4EI32_V_M1_MF2, VSUXSEG4EI32_V, 0x7 }, // 10443
  { PseudoVSUXSEG4EI32_V_M1_MF2_MASK, VSUXSEG4EI32_V, 0x7 }, // 10444
  { PseudoVSUXSEG4EI32_V_M2_MF2, VSUXSEG4EI32_V, 0x7 }, // 10445
  { PseudoVSUXSEG4EI32_V_M2_MF2_MASK, VSUXSEG4EI32_V, 0x7 }, // 10446
  { PseudoVSUXSEG4EI32_V_MF2_MF2, VSUXSEG4EI32_V, 0x7 }, // 10447
  { PseudoVSUXSEG4EI32_V_MF2_MF2_MASK, VSUXSEG4EI32_V, 0x7 }, // 10448
  { PseudoVSUXSEG4EI64_V_M1_M1, VSUXSEG4EI64_V, 0x0 }, // 10449
  { PseudoVSUXSEG4EI64_V_M1_M1_MASK, VSUXSEG4EI64_V, 0x0 }, // 10450
  { PseudoVSUXSEG4EI64_V_M2_M1, VSUXSEG4EI64_V, 0x0 }, // 10451
  { PseudoVSUXSEG4EI64_V_M2_M1_MASK, VSUXSEG4EI64_V, 0x0 }, // 10452
  { PseudoVSUXSEG4EI64_V_M4_M1, VSUXSEG4EI64_V, 0x0 }, // 10453
  { PseudoVSUXSEG4EI64_V_M4_M1_MASK, VSUXSEG4EI64_V, 0x0 }, // 10454
  { PseudoVSUXSEG4EI64_V_M8_M1, VSUXSEG4EI64_V, 0x0 }, // 10455
  { PseudoVSUXSEG4EI64_V_M8_M1_MASK, VSUXSEG4EI64_V, 0x0 }, // 10456
  { PseudoVSUXSEG4EI64_V_M2_M2, VSUXSEG4EI64_V, 0x1 }, // 10457
  { PseudoVSUXSEG4EI64_V_M2_M2_MASK, VSUXSEG4EI64_V, 0x1 }, // 10458
  { PseudoVSUXSEG4EI64_V_M4_M2, VSUXSEG4EI64_V, 0x1 }, // 10459
  { PseudoVSUXSEG4EI64_V_M4_M2_MASK, VSUXSEG4EI64_V, 0x1 }, // 10460
  { PseudoVSUXSEG4EI64_V_M8_M2, VSUXSEG4EI64_V, 0x1 }, // 10461
  { PseudoVSUXSEG4EI64_V_M8_M2_MASK, VSUXSEG4EI64_V, 0x1 }, // 10462
  { PseudoVSUXSEG4EI64_V_M1_MF8, VSUXSEG4EI64_V, 0x5 }, // 10463
  { PseudoVSUXSEG4EI64_V_M1_MF8_MASK, VSUXSEG4EI64_V, 0x5 }, // 10464
  { PseudoVSUXSEG4EI64_V_M1_MF4, VSUXSEG4EI64_V, 0x6 }, // 10465
  { PseudoVSUXSEG4EI64_V_M1_MF4_MASK, VSUXSEG4EI64_V, 0x6 }, // 10466
  { PseudoVSUXSEG4EI64_V_M2_MF4, VSUXSEG4EI64_V, 0x6 }, // 10467
  { PseudoVSUXSEG4EI64_V_M2_MF4_MASK, VSUXSEG4EI64_V, 0x6 }, // 10468
  { PseudoVSUXSEG4EI64_V_M1_MF2, VSUXSEG4EI64_V, 0x7 }, // 10469
  { PseudoVSUXSEG4EI64_V_M1_MF2_MASK, VSUXSEG4EI64_V, 0x7 }, // 10470
  { PseudoVSUXSEG4EI64_V_M2_MF2, VSUXSEG4EI64_V, 0x7 }, // 10471
  { PseudoVSUXSEG4EI64_V_M2_MF2_MASK, VSUXSEG4EI64_V, 0x7 }, // 10472
  { PseudoVSUXSEG4EI64_V_M4_MF2, VSUXSEG4EI64_V, 0x7 }, // 10473
  { PseudoVSUXSEG4EI64_V_M4_MF2_MASK, VSUXSEG4EI64_V, 0x7 }, // 10474
  { PseudoVSUXSEG4EI8_V_M1_M1, VSUXSEG4EI8_V, 0x0 }, // 10475
  { PseudoVSUXSEG4EI8_V_M1_M1_MASK, VSUXSEG4EI8_V, 0x0 }, // 10476
  { PseudoVSUXSEG4EI8_V_MF2_M1, VSUXSEG4EI8_V, 0x0 }, // 10477
  { PseudoVSUXSEG4EI8_V_MF2_M1_MASK, VSUXSEG4EI8_V, 0x0 }, // 10478
  { PseudoVSUXSEG4EI8_V_MF4_M1, VSUXSEG4EI8_V, 0x0 }, // 10479
  { PseudoVSUXSEG4EI8_V_MF4_M1_MASK, VSUXSEG4EI8_V, 0x0 }, // 10480
  { PseudoVSUXSEG4EI8_V_MF8_M1, VSUXSEG4EI8_V, 0x0 }, // 10481
  { PseudoVSUXSEG4EI8_V_MF8_M1_MASK, VSUXSEG4EI8_V, 0x0 }, // 10482
  { PseudoVSUXSEG4EI8_V_M1_M2, VSUXSEG4EI8_V, 0x1 }, // 10483
  { PseudoVSUXSEG4EI8_V_M1_M2_MASK, VSUXSEG4EI8_V, 0x1 }, // 10484
  { PseudoVSUXSEG4EI8_V_M2_M2, VSUXSEG4EI8_V, 0x1 }, // 10485
  { PseudoVSUXSEG4EI8_V_M2_M2_MASK, VSUXSEG4EI8_V, 0x1 }, // 10486
  { PseudoVSUXSEG4EI8_V_MF2_M2, VSUXSEG4EI8_V, 0x1 }, // 10487
  { PseudoVSUXSEG4EI8_V_MF2_M2_MASK, VSUXSEG4EI8_V, 0x1 }, // 10488
  { PseudoVSUXSEG4EI8_V_MF4_M2, VSUXSEG4EI8_V, 0x1 }, // 10489
  { PseudoVSUXSEG4EI8_V_MF4_M2_MASK, VSUXSEG4EI8_V, 0x1 }, // 10490
  { PseudoVSUXSEG4EI8_V_MF8_MF8, VSUXSEG4EI8_V, 0x5 }, // 10491
  { PseudoVSUXSEG4EI8_V_MF8_MF8_MASK, VSUXSEG4EI8_V, 0x5 }, // 10492
  { PseudoVSUXSEG4EI8_V_MF4_MF4, VSUXSEG4EI8_V, 0x6 }, // 10493
  { PseudoVSUXSEG4EI8_V_MF4_MF4_MASK, VSUXSEG4EI8_V, 0x6 }, // 10494
  { PseudoVSUXSEG4EI8_V_MF8_MF4, VSUXSEG4EI8_V, 0x6 }, // 10495
  { PseudoVSUXSEG4EI8_V_MF8_MF4_MASK, VSUXSEG4EI8_V, 0x6 }, // 10496
  { PseudoVSUXSEG4EI8_V_MF2_MF2, VSUXSEG4EI8_V, 0x7 }, // 10497
  { PseudoVSUXSEG4EI8_V_MF2_MF2_MASK, VSUXSEG4EI8_V, 0x7 }, // 10498
  { PseudoVSUXSEG4EI8_V_MF4_MF2, VSUXSEG4EI8_V, 0x7 }, // 10499
  { PseudoVSUXSEG4EI8_V_MF4_MF2_MASK, VSUXSEG4EI8_V, 0x7 }, // 10500
  { PseudoVSUXSEG4EI8_V_MF8_MF2, VSUXSEG4EI8_V, 0x7 }, // 10501
  { PseudoVSUXSEG4EI8_V_MF8_MF2_MASK, VSUXSEG4EI8_V, 0x7 }, // 10502
  { PseudoVSUXSEG5EI16_V_M1_M1, VSUXSEG5EI16_V, 0x0 }, // 10503
  { PseudoVSUXSEG5EI16_V_M1_M1_MASK, VSUXSEG5EI16_V, 0x0 }, // 10504
  { PseudoVSUXSEG5EI16_V_M2_M1, VSUXSEG5EI16_V, 0x0 }, // 10505
  { PseudoVSUXSEG5EI16_V_M2_M1_MASK, VSUXSEG5EI16_V, 0x0 }, // 10506
  { PseudoVSUXSEG5EI16_V_MF2_M1, VSUXSEG5EI16_V, 0x0 }, // 10507
  { PseudoVSUXSEG5EI16_V_MF2_M1_MASK, VSUXSEG5EI16_V, 0x0 }, // 10508
  { PseudoVSUXSEG5EI16_V_MF4_M1, VSUXSEG5EI16_V, 0x0 }, // 10509
  { PseudoVSUXSEG5EI16_V_MF4_M1_MASK, VSUXSEG5EI16_V, 0x0 }, // 10510
  { PseudoVSUXSEG5EI16_V_MF4_MF8, VSUXSEG5EI16_V, 0x5 }, // 10511
  { PseudoVSUXSEG5EI16_V_MF4_MF8_MASK, VSUXSEG5EI16_V, 0x5 }, // 10512
  { PseudoVSUXSEG5EI16_V_MF2_MF4, VSUXSEG5EI16_V, 0x6 }, // 10513
  { PseudoVSUXSEG5EI16_V_MF2_MF4_MASK, VSUXSEG5EI16_V, 0x6 }, // 10514
  { PseudoVSUXSEG5EI16_V_MF4_MF4, VSUXSEG5EI16_V, 0x6 }, // 10515
  { PseudoVSUXSEG5EI16_V_MF4_MF4_MASK, VSUXSEG5EI16_V, 0x6 }, // 10516
  { PseudoVSUXSEG5EI16_V_M1_MF2, VSUXSEG5EI16_V, 0x7 }, // 10517
  { PseudoVSUXSEG5EI16_V_M1_MF2_MASK, VSUXSEG5EI16_V, 0x7 }, // 10518
  { PseudoVSUXSEG5EI16_V_MF2_MF2, VSUXSEG5EI16_V, 0x7 }, // 10519
  { PseudoVSUXSEG5EI16_V_MF2_MF2_MASK, VSUXSEG5EI16_V, 0x7 }, // 10520
  { PseudoVSUXSEG5EI16_V_MF4_MF2, VSUXSEG5EI16_V, 0x7 }, // 10521
  { PseudoVSUXSEG5EI16_V_MF4_MF2_MASK, VSUXSEG5EI16_V, 0x7 }, // 10522
  { PseudoVSUXSEG5EI32_V_M1_M1, VSUXSEG5EI32_V, 0x0 }, // 10523
  { PseudoVSUXSEG5EI32_V_M1_M1_MASK, VSUXSEG5EI32_V, 0x0 }, // 10524
  { PseudoVSUXSEG5EI32_V_M2_M1, VSUXSEG5EI32_V, 0x0 }, // 10525
  { PseudoVSUXSEG5EI32_V_M2_M1_MASK, VSUXSEG5EI32_V, 0x0 }, // 10526
  { PseudoVSUXSEG5EI32_V_M4_M1, VSUXSEG5EI32_V, 0x0 }, // 10527
  { PseudoVSUXSEG5EI32_V_M4_M1_MASK, VSUXSEG5EI32_V, 0x0 }, // 10528
  { PseudoVSUXSEG5EI32_V_MF2_M1, VSUXSEG5EI32_V, 0x0 }, // 10529
  { PseudoVSUXSEG5EI32_V_MF2_M1_MASK, VSUXSEG5EI32_V, 0x0 }, // 10530
  { PseudoVSUXSEG5EI32_V_MF2_MF8, VSUXSEG5EI32_V, 0x5 }, // 10531
  { PseudoVSUXSEG5EI32_V_MF2_MF8_MASK, VSUXSEG5EI32_V, 0x5 }, // 10532
  { PseudoVSUXSEG5EI32_V_M1_MF4, VSUXSEG5EI32_V, 0x6 }, // 10533
  { PseudoVSUXSEG5EI32_V_M1_MF4_MASK, VSUXSEG5EI32_V, 0x6 }, // 10534
  { PseudoVSUXSEG5EI32_V_MF2_MF4, VSUXSEG5EI32_V, 0x6 }, // 10535
  { PseudoVSUXSEG5EI32_V_MF2_MF4_MASK, VSUXSEG5EI32_V, 0x6 }, // 10536
  { PseudoVSUXSEG5EI32_V_M1_MF2, VSUXSEG5EI32_V, 0x7 }, // 10537
  { PseudoVSUXSEG5EI32_V_M1_MF2_MASK, VSUXSEG5EI32_V, 0x7 }, // 10538
  { PseudoVSUXSEG5EI32_V_M2_MF2, VSUXSEG5EI32_V, 0x7 }, // 10539
  { PseudoVSUXSEG5EI32_V_M2_MF2_MASK, VSUXSEG5EI32_V, 0x7 }, // 10540
  { PseudoVSUXSEG5EI32_V_MF2_MF2, VSUXSEG5EI32_V, 0x7 }, // 10541
  { PseudoVSUXSEG5EI32_V_MF2_MF2_MASK, VSUXSEG5EI32_V, 0x7 }, // 10542
  { PseudoVSUXSEG5EI64_V_M1_M1, VSUXSEG5EI64_V, 0x0 }, // 10543
  { PseudoVSUXSEG5EI64_V_M1_M1_MASK, VSUXSEG5EI64_V, 0x0 }, // 10544
  { PseudoVSUXSEG5EI64_V_M2_M1, VSUXSEG5EI64_V, 0x0 }, // 10545
  { PseudoVSUXSEG5EI64_V_M2_M1_MASK, VSUXSEG5EI64_V, 0x0 }, // 10546
  { PseudoVSUXSEG5EI64_V_M4_M1, VSUXSEG5EI64_V, 0x0 }, // 10547
  { PseudoVSUXSEG5EI64_V_M4_M1_MASK, VSUXSEG5EI64_V, 0x0 }, // 10548
  { PseudoVSUXSEG5EI64_V_M8_M1, VSUXSEG5EI64_V, 0x0 }, // 10549
  { PseudoVSUXSEG5EI64_V_M8_M1_MASK, VSUXSEG5EI64_V, 0x0 }, // 10550
  { PseudoVSUXSEG5EI64_V_M1_MF8, VSUXSEG5EI64_V, 0x5 }, // 10551
  { PseudoVSUXSEG5EI64_V_M1_MF8_MASK, VSUXSEG5EI64_V, 0x5 }, // 10552
  { PseudoVSUXSEG5EI64_V_M1_MF4, VSUXSEG5EI64_V, 0x6 }, // 10553
  { PseudoVSUXSEG5EI64_V_M1_MF4_MASK, VSUXSEG5EI64_V, 0x6 }, // 10554
  { PseudoVSUXSEG5EI64_V_M2_MF4, VSUXSEG5EI64_V, 0x6 }, // 10555
  { PseudoVSUXSEG5EI64_V_M2_MF4_MASK, VSUXSEG5EI64_V, 0x6 }, // 10556
  { PseudoVSUXSEG5EI64_V_M1_MF2, VSUXSEG5EI64_V, 0x7 }, // 10557
  { PseudoVSUXSEG5EI64_V_M1_MF2_MASK, VSUXSEG5EI64_V, 0x7 }, // 10558
  { PseudoVSUXSEG5EI64_V_M2_MF2, VSUXSEG5EI64_V, 0x7 }, // 10559
  { PseudoVSUXSEG5EI64_V_M2_MF2_MASK, VSUXSEG5EI64_V, 0x7 }, // 10560
  { PseudoVSUXSEG5EI64_V_M4_MF2, VSUXSEG5EI64_V, 0x7 }, // 10561
  { PseudoVSUXSEG5EI64_V_M4_MF2_MASK, VSUXSEG5EI64_V, 0x7 }, // 10562
  { PseudoVSUXSEG5EI8_V_M1_M1, VSUXSEG5EI8_V, 0x0 }, // 10563
  { PseudoVSUXSEG5EI8_V_M1_M1_MASK, VSUXSEG5EI8_V, 0x0 }, // 10564
  { PseudoVSUXSEG5EI8_V_MF2_M1, VSUXSEG5EI8_V, 0x0 }, // 10565
  { PseudoVSUXSEG5EI8_V_MF2_M1_MASK, VSUXSEG5EI8_V, 0x0 }, // 10566
  { PseudoVSUXSEG5EI8_V_MF4_M1, VSUXSEG5EI8_V, 0x0 }, // 10567
  { PseudoVSUXSEG5EI8_V_MF4_M1_MASK, VSUXSEG5EI8_V, 0x0 }, // 10568
  { PseudoVSUXSEG5EI8_V_MF8_M1, VSUXSEG5EI8_V, 0x0 }, // 10569
  { PseudoVSUXSEG5EI8_V_MF8_M1_MASK, VSUXSEG5EI8_V, 0x0 }, // 10570
  { PseudoVSUXSEG5EI8_V_MF8_MF8, VSUXSEG5EI8_V, 0x5 }, // 10571
  { PseudoVSUXSEG5EI8_V_MF8_MF8_MASK, VSUXSEG5EI8_V, 0x5 }, // 10572
  { PseudoVSUXSEG5EI8_V_MF4_MF4, VSUXSEG5EI8_V, 0x6 }, // 10573
  { PseudoVSUXSEG5EI8_V_MF4_MF4_MASK, VSUXSEG5EI8_V, 0x6 }, // 10574
  { PseudoVSUXSEG5EI8_V_MF8_MF4, VSUXSEG5EI8_V, 0x6 }, // 10575
  { PseudoVSUXSEG5EI8_V_MF8_MF4_MASK, VSUXSEG5EI8_V, 0x6 }, // 10576
  { PseudoVSUXSEG5EI8_V_MF2_MF2, VSUXSEG5EI8_V, 0x7 }, // 10577
  { PseudoVSUXSEG5EI8_V_MF2_MF2_MASK, VSUXSEG5EI8_V, 0x7 }, // 10578
  { PseudoVSUXSEG5EI8_V_MF4_MF2, VSUXSEG5EI8_V, 0x7 }, // 10579
  { PseudoVSUXSEG5EI8_V_MF4_MF2_MASK, VSUXSEG5EI8_V, 0x7 }, // 10580
  { PseudoVSUXSEG5EI8_V_MF8_MF2, VSUXSEG5EI8_V, 0x7 }, // 10581
  { PseudoVSUXSEG5EI8_V_MF8_MF2_MASK, VSUXSEG5EI8_V, 0x7 }, // 10582
  { PseudoVSUXSEG6EI16_V_M1_M1, VSUXSEG6EI16_V, 0x0 }, // 10583
  { PseudoVSUXSEG6EI16_V_M1_M1_MASK, VSUXSEG6EI16_V, 0x0 }, // 10584
  { PseudoVSUXSEG6EI16_V_M2_M1, VSUXSEG6EI16_V, 0x0 }, // 10585
  { PseudoVSUXSEG6EI16_V_M2_M1_MASK, VSUXSEG6EI16_V, 0x0 }, // 10586
  { PseudoVSUXSEG6EI16_V_MF2_M1, VSUXSEG6EI16_V, 0x0 }, // 10587
  { PseudoVSUXSEG6EI16_V_MF2_M1_MASK, VSUXSEG6EI16_V, 0x0 }, // 10588
  { PseudoVSUXSEG6EI16_V_MF4_M1, VSUXSEG6EI16_V, 0x0 }, // 10589
  { PseudoVSUXSEG6EI16_V_MF4_M1_MASK, VSUXSEG6EI16_V, 0x0 }, // 10590
  { PseudoVSUXSEG6EI16_V_MF4_MF8, VSUXSEG6EI16_V, 0x5 }, // 10591
  { PseudoVSUXSEG6EI16_V_MF4_MF8_MASK, VSUXSEG6EI16_V, 0x5 }, // 10592
  { PseudoVSUXSEG6EI16_V_MF2_MF4, VSUXSEG6EI16_V, 0x6 }, // 10593
  { PseudoVSUXSEG6EI16_V_MF2_MF4_MASK, VSUXSEG6EI16_V, 0x6 }, // 10594
  { PseudoVSUXSEG6EI16_V_MF4_MF4, VSUXSEG6EI16_V, 0x6 }, // 10595
  { PseudoVSUXSEG6EI16_V_MF4_MF4_MASK, VSUXSEG6EI16_V, 0x6 }, // 10596
  { PseudoVSUXSEG6EI16_V_M1_MF2, VSUXSEG6EI16_V, 0x7 }, // 10597
  { PseudoVSUXSEG6EI16_V_M1_MF2_MASK, VSUXSEG6EI16_V, 0x7 }, // 10598
  { PseudoVSUXSEG6EI16_V_MF2_MF2, VSUXSEG6EI16_V, 0x7 }, // 10599
  { PseudoVSUXSEG6EI16_V_MF2_MF2_MASK, VSUXSEG6EI16_V, 0x7 }, // 10600
  { PseudoVSUXSEG6EI16_V_MF4_MF2, VSUXSEG6EI16_V, 0x7 }, // 10601
  { PseudoVSUXSEG6EI16_V_MF4_MF2_MASK, VSUXSEG6EI16_V, 0x7 }, // 10602
  { PseudoVSUXSEG6EI32_V_M1_M1, VSUXSEG6EI32_V, 0x0 }, // 10603
  { PseudoVSUXSEG6EI32_V_M1_M1_MASK, VSUXSEG6EI32_V, 0x0 }, // 10604
  { PseudoVSUXSEG6EI32_V_M2_M1, VSUXSEG6EI32_V, 0x0 }, // 10605
  { PseudoVSUXSEG6EI32_V_M2_M1_MASK, VSUXSEG6EI32_V, 0x0 }, // 10606
  { PseudoVSUXSEG6EI32_V_M4_M1, VSUXSEG6EI32_V, 0x0 }, // 10607
  { PseudoVSUXSEG6EI32_V_M4_M1_MASK, VSUXSEG6EI32_V, 0x0 }, // 10608
  { PseudoVSUXSEG6EI32_V_MF2_M1, VSUXSEG6EI32_V, 0x0 }, // 10609
  { PseudoVSUXSEG6EI32_V_MF2_M1_MASK, VSUXSEG6EI32_V, 0x0 }, // 10610
  { PseudoVSUXSEG6EI32_V_MF2_MF8, VSUXSEG6EI32_V, 0x5 }, // 10611
  { PseudoVSUXSEG6EI32_V_MF2_MF8_MASK, VSUXSEG6EI32_V, 0x5 }, // 10612
  { PseudoVSUXSEG6EI32_V_M1_MF4, VSUXSEG6EI32_V, 0x6 }, // 10613
  { PseudoVSUXSEG6EI32_V_M1_MF4_MASK, VSUXSEG6EI32_V, 0x6 }, // 10614
  { PseudoVSUXSEG6EI32_V_MF2_MF4, VSUXSEG6EI32_V, 0x6 }, // 10615
  { PseudoVSUXSEG6EI32_V_MF2_MF4_MASK, VSUXSEG6EI32_V, 0x6 }, // 10616
  { PseudoVSUXSEG6EI32_V_M1_MF2, VSUXSEG6EI32_V, 0x7 }, // 10617
  { PseudoVSUXSEG6EI32_V_M1_MF2_MASK, VSUXSEG6EI32_V, 0x7 }, // 10618
  { PseudoVSUXSEG6EI32_V_M2_MF2, VSUXSEG6EI32_V, 0x7 }, // 10619
  { PseudoVSUXSEG6EI32_V_M2_MF2_MASK, VSUXSEG6EI32_V, 0x7 }, // 10620
  { PseudoVSUXSEG6EI32_V_MF2_MF2, VSUXSEG6EI32_V, 0x7 }, // 10621
  { PseudoVSUXSEG6EI32_V_MF2_MF2_MASK, VSUXSEG6EI32_V, 0x7 }, // 10622
  { PseudoVSUXSEG6EI64_V_M1_M1, VSUXSEG6EI64_V, 0x0 }, // 10623
  { PseudoVSUXSEG6EI64_V_M1_M1_MASK, VSUXSEG6EI64_V, 0x0 }, // 10624
  { PseudoVSUXSEG6EI64_V_M2_M1, VSUXSEG6EI64_V, 0x0 }, // 10625
  { PseudoVSUXSEG6EI64_V_M2_M1_MASK, VSUXSEG6EI64_V, 0x0 }, // 10626
  { PseudoVSUXSEG6EI64_V_M4_M1, VSUXSEG6EI64_V, 0x0 }, // 10627
  { PseudoVSUXSEG6EI64_V_M4_M1_MASK, VSUXSEG6EI64_V, 0x0 }, // 10628
  { PseudoVSUXSEG6EI64_V_M8_M1, VSUXSEG6EI64_V, 0x0 }, // 10629
  { PseudoVSUXSEG6EI64_V_M8_M1_MASK, VSUXSEG6EI64_V, 0x0 }, // 10630
  { PseudoVSUXSEG6EI64_V_M1_MF8, VSUXSEG6EI64_V, 0x5 }, // 10631
  { PseudoVSUXSEG6EI64_V_M1_MF8_MASK, VSUXSEG6EI64_V, 0x5 }, // 10632
  { PseudoVSUXSEG6EI64_V_M1_MF4, VSUXSEG6EI64_V, 0x6 }, // 10633
  { PseudoVSUXSEG6EI64_V_M1_MF4_MASK, VSUXSEG6EI64_V, 0x6 }, // 10634
  { PseudoVSUXSEG6EI64_V_M2_MF4, VSUXSEG6EI64_V, 0x6 }, // 10635
  { PseudoVSUXSEG6EI64_V_M2_MF4_MASK, VSUXSEG6EI64_V, 0x6 }, // 10636
  { PseudoVSUXSEG6EI64_V_M1_MF2, VSUXSEG6EI64_V, 0x7 }, // 10637
  { PseudoVSUXSEG6EI64_V_M1_MF2_MASK, VSUXSEG6EI64_V, 0x7 }, // 10638
  { PseudoVSUXSEG6EI64_V_M2_MF2, VSUXSEG6EI64_V, 0x7 }, // 10639
  { PseudoVSUXSEG6EI64_V_M2_MF2_MASK, VSUXSEG6EI64_V, 0x7 }, // 10640
  { PseudoVSUXSEG6EI64_V_M4_MF2, VSUXSEG6EI64_V, 0x7 }, // 10641
  { PseudoVSUXSEG6EI64_V_M4_MF2_MASK, VSUXSEG6EI64_V, 0x7 }, // 10642
  { PseudoVSUXSEG6EI8_V_M1_M1, VSUXSEG6EI8_V, 0x0 }, // 10643
  { PseudoVSUXSEG6EI8_V_M1_M1_MASK, VSUXSEG6EI8_V, 0x0 }, // 10644
  { PseudoVSUXSEG6EI8_V_MF2_M1, VSUXSEG6EI8_V, 0x0 }, // 10645
  { PseudoVSUXSEG6EI8_V_MF2_M1_MASK, VSUXSEG6EI8_V, 0x0 }, // 10646
  { PseudoVSUXSEG6EI8_V_MF4_M1, VSUXSEG6EI8_V, 0x0 }, // 10647
  { PseudoVSUXSEG6EI8_V_MF4_M1_MASK, VSUXSEG6EI8_V, 0x0 }, // 10648
  { PseudoVSUXSEG6EI8_V_MF8_M1, VSUXSEG6EI8_V, 0x0 }, // 10649
  { PseudoVSUXSEG6EI8_V_MF8_M1_MASK, VSUXSEG6EI8_V, 0x0 }, // 10650
  { PseudoVSUXSEG6EI8_V_MF8_MF8, VSUXSEG6EI8_V, 0x5 }, // 10651
  { PseudoVSUXSEG6EI8_V_MF8_MF8_MASK, VSUXSEG6EI8_V, 0x5 }, // 10652
  { PseudoVSUXSEG6EI8_V_MF4_MF4, VSUXSEG6EI8_V, 0x6 }, // 10653
  { PseudoVSUXSEG6EI8_V_MF4_MF4_MASK, VSUXSEG6EI8_V, 0x6 }, // 10654
  { PseudoVSUXSEG6EI8_V_MF8_MF4, VSUXSEG6EI8_V, 0x6 }, // 10655
  { PseudoVSUXSEG6EI8_V_MF8_MF4_MASK, VSUXSEG6EI8_V, 0x6 }, // 10656
  { PseudoVSUXSEG6EI8_V_MF2_MF2, VSUXSEG6EI8_V, 0x7 }, // 10657
  { PseudoVSUXSEG6EI8_V_MF2_MF2_MASK, VSUXSEG6EI8_V, 0x7 }, // 10658
  { PseudoVSUXSEG6EI8_V_MF4_MF2, VSUXSEG6EI8_V, 0x7 }, // 10659
  { PseudoVSUXSEG6EI8_V_MF4_MF2_MASK, VSUXSEG6EI8_V, 0x7 }, // 10660
  { PseudoVSUXSEG6EI8_V_MF8_MF2, VSUXSEG6EI8_V, 0x7 }, // 10661
  { PseudoVSUXSEG6EI8_V_MF8_MF2_MASK, VSUXSEG6EI8_V, 0x7 }, // 10662
  { PseudoVSUXSEG7EI16_V_M1_M1, VSUXSEG7EI16_V, 0x0 }, // 10663
  { PseudoVSUXSEG7EI16_V_M1_M1_MASK, VSUXSEG7EI16_V, 0x0 }, // 10664
  { PseudoVSUXSEG7EI16_V_M2_M1, VSUXSEG7EI16_V, 0x0 }, // 10665
  { PseudoVSUXSEG7EI16_V_M2_M1_MASK, VSUXSEG7EI16_V, 0x0 }, // 10666
  { PseudoVSUXSEG7EI16_V_MF2_M1, VSUXSEG7EI16_V, 0x0 }, // 10667
  { PseudoVSUXSEG7EI16_V_MF2_M1_MASK, VSUXSEG7EI16_V, 0x0 }, // 10668
  { PseudoVSUXSEG7EI16_V_MF4_M1, VSUXSEG7EI16_V, 0x0 }, // 10669
  { PseudoVSUXSEG7EI16_V_MF4_M1_MASK, VSUXSEG7EI16_V, 0x0 }, // 10670
  { PseudoVSUXSEG7EI16_V_MF4_MF8, VSUXSEG7EI16_V, 0x5 }, // 10671
  { PseudoVSUXSEG7EI16_V_MF4_MF8_MASK, VSUXSEG7EI16_V, 0x5 }, // 10672
  { PseudoVSUXSEG7EI16_V_MF2_MF4, VSUXSEG7EI16_V, 0x6 }, // 10673
  { PseudoVSUXSEG7EI16_V_MF2_MF4_MASK, VSUXSEG7EI16_V, 0x6 }, // 10674
  { PseudoVSUXSEG7EI16_V_MF4_MF4, VSUXSEG7EI16_V, 0x6 }, // 10675
  { PseudoVSUXSEG7EI16_V_MF4_MF4_MASK, VSUXSEG7EI16_V, 0x6 }, // 10676
  { PseudoVSUXSEG7EI16_V_M1_MF2, VSUXSEG7EI16_V, 0x7 }, // 10677
  { PseudoVSUXSEG7EI16_V_M1_MF2_MASK, VSUXSEG7EI16_V, 0x7 }, // 10678
  { PseudoVSUXSEG7EI16_V_MF2_MF2, VSUXSEG7EI16_V, 0x7 }, // 10679
  { PseudoVSUXSEG7EI16_V_MF2_MF2_MASK, VSUXSEG7EI16_V, 0x7 }, // 10680
  { PseudoVSUXSEG7EI16_V_MF4_MF2, VSUXSEG7EI16_V, 0x7 }, // 10681
  { PseudoVSUXSEG7EI16_V_MF4_MF2_MASK, VSUXSEG7EI16_V, 0x7 }, // 10682
  { PseudoVSUXSEG7EI32_V_M1_M1, VSUXSEG7EI32_V, 0x0 }, // 10683
  { PseudoVSUXSEG7EI32_V_M1_M1_MASK, VSUXSEG7EI32_V, 0x0 }, // 10684
  { PseudoVSUXSEG7EI32_V_M2_M1, VSUXSEG7EI32_V, 0x0 }, // 10685
  { PseudoVSUXSEG7EI32_V_M2_M1_MASK, VSUXSEG7EI32_V, 0x0 }, // 10686
  { PseudoVSUXSEG7EI32_V_M4_M1, VSUXSEG7EI32_V, 0x0 }, // 10687
  { PseudoVSUXSEG7EI32_V_M4_M1_MASK, VSUXSEG7EI32_V, 0x0 }, // 10688
  { PseudoVSUXSEG7EI32_V_MF2_M1, VSUXSEG7EI32_V, 0x0 }, // 10689
  { PseudoVSUXSEG7EI32_V_MF2_M1_MASK, VSUXSEG7EI32_V, 0x0 }, // 10690
  { PseudoVSUXSEG7EI32_V_MF2_MF8, VSUXSEG7EI32_V, 0x5 }, // 10691
  { PseudoVSUXSEG7EI32_V_MF2_MF8_MASK, VSUXSEG7EI32_V, 0x5 }, // 10692
  { PseudoVSUXSEG7EI32_V_M1_MF4, VSUXSEG7EI32_V, 0x6 }, // 10693
  { PseudoVSUXSEG7EI32_V_M1_MF4_MASK, VSUXSEG7EI32_V, 0x6 }, // 10694
  { PseudoVSUXSEG7EI32_V_MF2_MF4, VSUXSEG7EI32_V, 0x6 }, // 10695
  { PseudoVSUXSEG7EI32_V_MF2_MF4_MASK, VSUXSEG7EI32_V, 0x6 }, // 10696
  { PseudoVSUXSEG7EI32_V_M1_MF2, VSUXSEG7EI32_V, 0x7 }, // 10697
  { PseudoVSUXSEG7EI32_V_M1_MF2_MASK, VSUXSEG7EI32_V, 0x7 }, // 10698
  { PseudoVSUXSEG7EI32_V_M2_MF2, VSUXSEG7EI32_V, 0x7 }, // 10699
  { PseudoVSUXSEG7EI32_V_M2_MF2_MASK, VSUXSEG7EI32_V, 0x7 }, // 10700
  { PseudoVSUXSEG7EI32_V_MF2_MF2, VSUXSEG7EI32_V, 0x7 }, // 10701
  { PseudoVSUXSEG7EI32_V_MF2_MF2_MASK, VSUXSEG7EI32_V, 0x7 }, // 10702
  { PseudoVSUXSEG7EI64_V_M1_M1, VSUXSEG7EI64_V, 0x0 }, // 10703
  { PseudoVSUXSEG7EI64_V_M1_M1_MASK, VSUXSEG7EI64_V, 0x0 }, // 10704
  { PseudoVSUXSEG7EI64_V_M2_M1, VSUXSEG7EI64_V, 0x0 }, // 10705
  { PseudoVSUXSEG7EI64_V_M2_M1_MASK, VSUXSEG7EI64_V, 0x0 }, // 10706
  { PseudoVSUXSEG7EI64_V_M4_M1, VSUXSEG7EI64_V, 0x0 }, // 10707
  { PseudoVSUXSEG7EI64_V_M4_M1_MASK, VSUXSEG7EI64_V, 0x0 }, // 10708
  { PseudoVSUXSEG7EI64_V_M8_M1, VSUXSEG7EI64_V, 0x0 }, // 10709
  { PseudoVSUXSEG7EI64_V_M8_M1_MASK, VSUXSEG7EI64_V, 0x0 }, // 10710
  { PseudoVSUXSEG7EI64_V_M1_MF8, VSUXSEG7EI64_V, 0x5 }, // 10711
  { PseudoVSUXSEG7EI64_V_M1_MF8_MASK, VSUXSEG7EI64_V, 0x5 }, // 10712
  { PseudoVSUXSEG7EI64_V_M1_MF4, VSUXSEG7EI64_V, 0x6 }, // 10713
  { PseudoVSUXSEG7EI64_V_M1_MF4_MASK, VSUXSEG7EI64_V, 0x6 }, // 10714
  { PseudoVSUXSEG7EI64_V_M2_MF4, VSUXSEG7EI64_V, 0x6 }, // 10715
  { PseudoVSUXSEG7EI64_V_M2_MF4_MASK, VSUXSEG7EI64_V, 0x6 }, // 10716
  { PseudoVSUXSEG7EI64_V_M1_MF2, VSUXSEG7EI64_V, 0x7 }, // 10717
  { PseudoVSUXSEG7EI64_V_M1_MF2_MASK, VSUXSEG7EI64_V, 0x7 }, // 10718
  { PseudoVSUXSEG7EI64_V_M2_MF2, VSUXSEG7EI64_V, 0x7 }, // 10719
  { PseudoVSUXSEG7EI64_V_M2_MF2_MASK, VSUXSEG7EI64_V, 0x7 }, // 10720
  { PseudoVSUXSEG7EI64_V_M4_MF2, VSUXSEG7EI64_V, 0x7 }, // 10721
  { PseudoVSUXSEG7EI64_V_M4_MF2_MASK, VSUXSEG7EI64_V, 0x7 }, // 10722
  { PseudoVSUXSEG7EI8_V_M1_M1, VSUXSEG7EI8_V, 0x0 }, // 10723
  { PseudoVSUXSEG7EI8_V_M1_M1_MASK, VSUXSEG7EI8_V, 0x0 }, // 10724
  { PseudoVSUXSEG7EI8_V_MF2_M1, VSUXSEG7EI8_V, 0x0 }, // 10725
  { PseudoVSUXSEG7EI8_V_MF2_M1_MASK, VSUXSEG7EI8_V, 0x0 }, // 10726
  { PseudoVSUXSEG7EI8_V_MF4_M1, VSUXSEG7EI8_V, 0x0 }, // 10727
  { PseudoVSUXSEG7EI8_V_MF4_M1_MASK, VSUXSEG7EI8_V, 0x0 }, // 10728
  { PseudoVSUXSEG7EI8_V_MF8_M1, VSUXSEG7EI8_V, 0x0 }, // 10729
  { PseudoVSUXSEG7EI8_V_MF8_M1_MASK, VSUXSEG7EI8_V, 0x0 }, // 10730
  { PseudoVSUXSEG7EI8_V_MF8_MF8, VSUXSEG7EI8_V, 0x5 }, // 10731
  { PseudoVSUXSEG7EI8_V_MF8_MF8_MASK, VSUXSEG7EI8_V, 0x5 }, // 10732
  { PseudoVSUXSEG7EI8_V_MF4_MF4, VSUXSEG7EI8_V, 0x6 }, // 10733
  { PseudoVSUXSEG7EI8_V_MF4_MF4_MASK, VSUXSEG7EI8_V, 0x6 }, // 10734
  { PseudoVSUXSEG7EI8_V_MF8_MF4, VSUXSEG7EI8_V, 0x6 }, // 10735
  { PseudoVSUXSEG7EI8_V_MF8_MF4_MASK, VSUXSEG7EI8_V, 0x6 }, // 10736
  { PseudoVSUXSEG7EI8_V_MF2_MF2, VSUXSEG7EI8_V, 0x7 }, // 10737
  { PseudoVSUXSEG7EI8_V_MF2_MF2_MASK, VSUXSEG7EI8_V, 0x7 }, // 10738
  { PseudoVSUXSEG7EI8_V_MF4_MF2, VSUXSEG7EI8_V, 0x7 }, // 10739
  { PseudoVSUXSEG7EI8_V_MF4_MF2_MASK, VSUXSEG7EI8_V, 0x7 }, // 10740
  { PseudoVSUXSEG7EI8_V_MF8_MF2, VSUXSEG7EI8_V, 0x7 }, // 10741
  { PseudoVSUXSEG7EI8_V_MF8_MF2_MASK, VSUXSEG7EI8_V, 0x7 }, // 10742
  { PseudoVSUXSEG8EI16_V_M1_M1, VSUXSEG8EI16_V, 0x0 }, // 10743
  { PseudoVSUXSEG8EI16_V_M1_M1_MASK, VSUXSEG8EI16_V, 0x0 }, // 10744
  { PseudoVSUXSEG8EI16_V_M2_M1, VSUXSEG8EI16_V, 0x0 }, // 10745
  { PseudoVSUXSEG8EI16_V_M2_M1_MASK, VSUXSEG8EI16_V, 0x0 }, // 10746
  { PseudoVSUXSEG8EI16_V_MF2_M1, VSUXSEG8EI16_V, 0x0 }, // 10747
  { PseudoVSUXSEG8EI16_V_MF2_M1_MASK, VSUXSEG8EI16_V, 0x0 }, // 10748
  { PseudoVSUXSEG8EI16_V_MF4_M1, VSUXSEG8EI16_V, 0x0 }, // 10749
  { PseudoVSUXSEG8EI16_V_MF4_M1_MASK, VSUXSEG8EI16_V, 0x0 }, // 10750
  { PseudoVSUXSEG8EI16_V_MF4_MF8, VSUXSEG8EI16_V, 0x5 }, // 10751
  { PseudoVSUXSEG8EI16_V_MF4_MF8_MASK, VSUXSEG8EI16_V, 0x5 }, // 10752
  { PseudoVSUXSEG8EI16_V_MF2_MF4, VSUXSEG8EI16_V, 0x6 }, // 10753
  { PseudoVSUXSEG8EI16_V_MF2_MF4_MASK, VSUXSEG8EI16_V, 0x6 }, // 10754
  { PseudoVSUXSEG8EI16_V_MF4_MF4, VSUXSEG8EI16_V, 0x6 }, // 10755
  { PseudoVSUXSEG8EI16_V_MF4_MF4_MASK, VSUXSEG8EI16_V, 0x6 }, // 10756
  { PseudoVSUXSEG8EI16_V_M1_MF2, VSUXSEG8EI16_V, 0x7 }, // 10757
  { PseudoVSUXSEG8EI16_V_M1_MF2_MASK, VSUXSEG8EI16_V, 0x7 }, // 10758
  { PseudoVSUXSEG8EI16_V_MF2_MF2, VSUXSEG8EI16_V, 0x7 }, // 10759
  { PseudoVSUXSEG8EI16_V_MF2_MF2_MASK, VSUXSEG8EI16_V, 0x7 }, // 10760
  { PseudoVSUXSEG8EI16_V_MF4_MF2, VSUXSEG8EI16_V, 0x7 }, // 10761
  { PseudoVSUXSEG8EI16_V_MF4_MF2_MASK, VSUXSEG8EI16_V, 0x7 }, // 10762
  { PseudoVSUXSEG8EI32_V_M1_M1, VSUXSEG8EI32_V, 0x0 }, // 10763
  { PseudoVSUXSEG8EI32_V_M1_M1_MASK, VSUXSEG8EI32_V, 0x0 }, // 10764
  { PseudoVSUXSEG8EI32_V_M2_M1, VSUXSEG8EI32_V, 0x0 }, // 10765
  { PseudoVSUXSEG8EI32_V_M2_M1_MASK, VSUXSEG8EI32_V, 0x0 }, // 10766
  { PseudoVSUXSEG8EI32_V_M4_M1, VSUXSEG8EI32_V, 0x0 }, // 10767
  { PseudoVSUXSEG8EI32_V_M4_M1_MASK, VSUXSEG8EI32_V, 0x0 }, // 10768
  { PseudoVSUXSEG8EI32_V_MF2_M1, VSUXSEG8EI32_V, 0x0 }, // 10769
  { PseudoVSUXSEG8EI32_V_MF2_M1_MASK, VSUXSEG8EI32_V, 0x0 }, // 10770
  { PseudoVSUXSEG8EI32_V_MF2_MF8, VSUXSEG8EI32_V, 0x5 }, // 10771
  { PseudoVSUXSEG8EI32_V_MF2_MF8_MASK, VSUXSEG8EI32_V, 0x5 }, // 10772
  { PseudoVSUXSEG8EI32_V_M1_MF4, VSUXSEG8EI32_V, 0x6 }, // 10773
  { PseudoVSUXSEG8EI32_V_M1_MF4_MASK, VSUXSEG8EI32_V, 0x6 }, // 10774
  { PseudoVSUXSEG8EI32_V_MF2_MF4, VSUXSEG8EI32_V, 0x6 }, // 10775
  { PseudoVSUXSEG8EI32_V_MF2_MF4_MASK, VSUXSEG8EI32_V, 0x6 }, // 10776
  { PseudoVSUXSEG8EI32_V_M1_MF2, VSUXSEG8EI32_V, 0x7 }, // 10777
  { PseudoVSUXSEG8EI32_V_M1_MF2_MASK, VSUXSEG8EI32_V, 0x7 }, // 10778
  { PseudoVSUXSEG8EI32_V_M2_MF2, VSUXSEG8EI32_V, 0x7 }, // 10779
  { PseudoVSUXSEG8EI32_V_M2_MF2_MASK, VSUXSEG8EI32_V, 0x7 }, // 10780
  { PseudoVSUXSEG8EI32_V_MF2_MF2, VSUXSEG8EI32_V, 0x7 }, // 10781
  { PseudoVSUXSEG8EI32_V_MF2_MF2_MASK, VSUXSEG8EI32_V, 0x7 }, // 10782
  { PseudoVSUXSEG8EI64_V_M1_M1, VSUXSEG8EI64_V, 0x0 }, // 10783
  { PseudoVSUXSEG8EI64_V_M1_M1_MASK, VSUXSEG8EI64_V, 0x0 }, // 10784
  { PseudoVSUXSEG8EI64_V_M2_M1, VSUXSEG8EI64_V, 0x0 }, // 10785
  { PseudoVSUXSEG8EI64_V_M2_M1_MASK, VSUXSEG8EI64_V, 0x0 }, // 10786
  { PseudoVSUXSEG8EI64_V_M4_M1, VSUXSEG8EI64_V, 0x0 }, // 10787
  { PseudoVSUXSEG8EI64_V_M4_M1_MASK, VSUXSEG8EI64_V, 0x0 }, // 10788
  { PseudoVSUXSEG8EI64_V_M8_M1, VSUXSEG8EI64_V, 0x0 }, // 10789
  { PseudoVSUXSEG8EI64_V_M8_M1_MASK, VSUXSEG8EI64_V, 0x0 }, // 10790
  { PseudoVSUXSEG8EI64_V_M1_MF8, VSUXSEG8EI64_V, 0x5 }, // 10791
  { PseudoVSUXSEG8EI64_V_M1_MF8_MASK, VSUXSEG8EI64_V, 0x5 }, // 10792
  { PseudoVSUXSEG8EI64_V_M1_MF4, VSUXSEG8EI64_V, 0x6 }, // 10793
  { PseudoVSUXSEG8EI64_V_M1_MF4_MASK, VSUXSEG8EI64_V, 0x6 }, // 10794
  { PseudoVSUXSEG8EI64_V_M2_MF4, VSUXSEG8EI64_V, 0x6 }, // 10795
  { PseudoVSUXSEG8EI64_V_M2_MF4_MASK, VSUXSEG8EI64_V, 0x6 }, // 10796
  { PseudoVSUXSEG8EI64_V_M1_MF2, VSUXSEG8EI64_V, 0x7 }, // 10797
  { PseudoVSUXSEG8EI64_V_M1_MF2_MASK, VSUXSEG8EI64_V, 0x7 }, // 10798
  { PseudoVSUXSEG8EI64_V_M2_MF2, VSUXSEG8EI64_V, 0x7 }, // 10799
  { PseudoVSUXSEG8EI64_V_M2_MF2_MASK, VSUXSEG8EI64_V, 0x7 }, // 10800
  { PseudoVSUXSEG8EI64_V_M4_MF2, VSUXSEG8EI64_V, 0x7 }, // 10801
  { PseudoVSUXSEG8EI64_V_M4_MF2_MASK, VSUXSEG8EI64_V, 0x7 }, // 10802
  { PseudoVSUXSEG8EI8_V_M1_M1, VSUXSEG8EI8_V, 0x0 }, // 10803
  { PseudoVSUXSEG8EI8_V_M1_M1_MASK, VSUXSEG8EI8_V, 0x0 }, // 10804
  { PseudoVSUXSEG8EI8_V_MF2_M1, VSUXSEG8EI8_V, 0x0 }, // 10805
  { PseudoVSUXSEG8EI8_V_MF2_M1_MASK, VSUXSEG8EI8_V, 0x0 }, // 10806
  { PseudoVSUXSEG8EI8_V_MF4_M1, VSUXSEG8EI8_V, 0x0 }, // 10807
  { PseudoVSUXSEG8EI8_V_MF4_M1_MASK, VSUXSEG8EI8_V, 0x0 }, // 10808
  { PseudoVSUXSEG8EI8_V_MF8_M1, VSUXSEG8EI8_V, 0x0 }, // 10809
  { PseudoVSUXSEG8EI8_V_MF8_M1_MASK, VSUXSEG8EI8_V, 0x0 }, // 10810
  { PseudoVSUXSEG8EI8_V_MF8_MF8, VSUXSEG8EI8_V, 0x5 }, // 10811
  { PseudoVSUXSEG8EI8_V_MF8_MF8_MASK, VSUXSEG8EI8_V, 0x5 }, // 10812
  { PseudoVSUXSEG8EI8_V_MF4_MF4, VSUXSEG8EI8_V, 0x6 }, // 10813
  { PseudoVSUXSEG8EI8_V_MF4_MF4_MASK, VSUXSEG8EI8_V, 0x6 }, // 10814
  { PseudoVSUXSEG8EI8_V_MF8_MF4, VSUXSEG8EI8_V, 0x6 }, // 10815
  { PseudoVSUXSEG8EI8_V_MF8_MF4_MASK, VSUXSEG8EI8_V, 0x6 }, // 10816
  { PseudoVSUXSEG8EI8_V_MF2_MF2, VSUXSEG8EI8_V, 0x7 }, // 10817
  { PseudoVSUXSEG8EI8_V_MF2_MF2_MASK, VSUXSEG8EI8_V, 0x7 }, // 10818
  { PseudoVSUXSEG8EI8_V_MF4_MF2, VSUXSEG8EI8_V, 0x7 }, // 10819
  { PseudoVSUXSEG8EI8_V_MF4_MF2_MASK, VSUXSEG8EI8_V, 0x7 }, // 10820
  { PseudoVSUXSEG8EI8_V_MF8_MF2, VSUXSEG8EI8_V, 0x7 }, // 10821
  { PseudoVSUXSEG8EI8_V_MF8_MF2_MASK, VSUXSEG8EI8_V, 0x7 }, // 10822
  { PseudoVWADDU_VV_M1, VWADDU_VV, 0x0 }, // 10823
  { PseudoVWADDU_VV_M1_MASK, VWADDU_VV, 0x0 }, // 10824
  { PseudoVWADDU_VV_M1_TU, VWADDU_VV, 0x0 }, // 10825
  { PseudoVWADDU_VV_M2, VWADDU_VV, 0x1 }, // 10826
  { PseudoVWADDU_VV_M2_MASK, VWADDU_VV, 0x1 }, // 10827
  { PseudoVWADDU_VV_M2_TU, VWADDU_VV, 0x1 }, // 10828
  { PseudoVWADDU_VV_M4, VWADDU_VV, 0x2 }, // 10829
  { PseudoVWADDU_VV_M4_MASK, VWADDU_VV, 0x2 }, // 10830
  { PseudoVWADDU_VV_M4_TU, VWADDU_VV, 0x2 }, // 10831
  { PseudoVWADDU_VV_MF8, VWADDU_VV, 0x5 }, // 10832
  { PseudoVWADDU_VV_MF8_MASK, VWADDU_VV, 0x5 }, // 10833
  { PseudoVWADDU_VV_MF8_TU, VWADDU_VV, 0x5 }, // 10834
  { PseudoVWADDU_VV_MF4, VWADDU_VV, 0x6 }, // 10835
  { PseudoVWADDU_VV_MF4_MASK, VWADDU_VV, 0x6 }, // 10836
  { PseudoVWADDU_VV_MF4_TU, VWADDU_VV, 0x6 }, // 10837
  { PseudoVWADDU_VV_MF2, VWADDU_VV, 0x7 }, // 10838
  { PseudoVWADDU_VV_MF2_MASK, VWADDU_VV, 0x7 }, // 10839
  { PseudoVWADDU_VV_MF2_TU, VWADDU_VV, 0x7 }, // 10840
  { PseudoVWADDU_VX_M1, VWADDU_VX, 0x0 }, // 10841
  { PseudoVWADDU_VX_M1_MASK, VWADDU_VX, 0x0 }, // 10842
  { PseudoVWADDU_VX_M1_TU, VWADDU_VX, 0x0 }, // 10843
  { PseudoVWADDU_VX_M2, VWADDU_VX, 0x1 }, // 10844
  { PseudoVWADDU_VX_M2_MASK, VWADDU_VX, 0x1 }, // 10845
  { PseudoVWADDU_VX_M2_TU, VWADDU_VX, 0x1 }, // 10846
  { PseudoVWADDU_VX_M4, VWADDU_VX, 0x2 }, // 10847
  { PseudoVWADDU_VX_M4_MASK, VWADDU_VX, 0x2 }, // 10848
  { PseudoVWADDU_VX_M4_TU, VWADDU_VX, 0x2 }, // 10849
  { PseudoVWADDU_VX_MF8, VWADDU_VX, 0x5 }, // 10850
  { PseudoVWADDU_VX_MF8_MASK, VWADDU_VX, 0x5 }, // 10851
  { PseudoVWADDU_VX_MF8_TU, VWADDU_VX, 0x5 }, // 10852
  { PseudoVWADDU_VX_MF4, VWADDU_VX, 0x6 }, // 10853
  { PseudoVWADDU_VX_MF4_MASK, VWADDU_VX, 0x6 }, // 10854
  { PseudoVWADDU_VX_MF4_TU, VWADDU_VX, 0x6 }, // 10855
  { PseudoVWADDU_VX_MF2, VWADDU_VX, 0x7 }, // 10856
  { PseudoVWADDU_VX_MF2_MASK, VWADDU_VX, 0x7 }, // 10857
  { PseudoVWADDU_VX_MF2_TU, VWADDU_VX, 0x7 }, // 10858
  { PseudoVWADDU_WV_M1, VWADDU_WV, 0x0 }, // 10859
  { PseudoVWADDU_WV_M1_MASK, VWADDU_WV, 0x0 }, // 10860
  { PseudoVWADDU_WV_M1_MASK_TIED, VWADDU_WV, 0x0 }, // 10861
  { PseudoVWADDU_WV_M1_TIED, VWADDU_WV, 0x0 }, // 10862
  { PseudoVWADDU_WV_M1_TU, VWADDU_WV, 0x0 }, // 10863
  { PseudoVWADDU_WV_M2, VWADDU_WV, 0x1 }, // 10864
  { PseudoVWADDU_WV_M2_MASK, VWADDU_WV, 0x1 }, // 10865
  { PseudoVWADDU_WV_M2_MASK_TIED, VWADDU_WV, 0x1 }, // 10866
  { PseudoVWADDU_WV_M2_TIED, VWADDU_WV, 0x1 }, // 10867
  { PseudoVWADDU_WV_M2_TU, VWADDU_WV, 0x1 }, // 10868
  { PseudoVWADDU_WV_M4, VWADDU_WV, 0x2 }, // 10869
  { PseudoVWADDU_WV_M4_MASK, VWADDU_WV, 0x2 }, // 10870
  { PseudoVWADDU_WV_M4_MASK_TIED, VWADDU_WV, 0x2 }, // 10871
  { PseudoVWADDU_WV_M4_TIED, VWADDU_WV, 0x2 }, // 10872
  { PseudoVWADDU_WV_M4_TU, VWADDU_WV, 0x2 }, // 10873
  { PseudoVWADDU_WV_MF8, VWADDU_WV, 0x5 }, // 10874
  { PseudoVWADDU_WV_MF8_MASK, VWADDU_WV, 0x5 }, // 10875
  { PseudoVWADDU_WV_MF8_MASK_TIED, VWADDU_WV, 0x5 }, // 10876
  { PseudoVWADDU_WV_MF8_TIED, VWADDU_WV, 0x5 }, // 10877
  { PseudoVWADDU_WV_MF8_TU, VWADDU_WV, 0x5 }, // 10878
  { PseudoVWADDU_WV_MF4, VWADDU_WV, 0x6 }, // 10879
  { PseudoVWADDU_WV_MF4_MASK, VWADDU_WV, 0x6 }, // 10880
  { PseudoVWADDU_WV_MF4_MASK_TIED, VWADDU_WV, 0x6 }, // 10881
  { PseudoVWADDU_WV_MF4_TIED, VWADDU_WV, 0x6 }, // 10882
  { PseudoVWADDU_WV_MF4_TU, VWADDU_WV, 0x6 }, // 10883
  { PseudoVWADDU_WV_MF2, VWADDU_WV, 0x7 }, // 10884
  { PseudoVWADDU_WV_MF2_MASK, VWADDU_WV, 0x7 }, // 10885
  { PseudoVWADDU_WV_MF2_MASK_TIED, VWADDU_WV, 0x7 }, // 10886
  { PseudoVWADDU_WV_MF2_TIED, VWADDU_WV, 0x7 }, // 10887
  { PseudoVWADDU_WV_MF2_TU, VWADDU_WV, 0x7 }, // 10888
  { PseudoVWADDU_WX_M1, VWADDU_WX, 0x0 }, // 10889
  { PseudoVWADDU_WX_M1_MASK, VWADDU_WX, 0x0 }, // 10890
  { PseudoVWADDU_WX_M1_TU, VWADDU_WX, 0x0 }, // 10891
  { PseudoVWADDU_WX_M2, VWADDU_WX, 0x1 }, // 10892
  { PseudoVWADDU_WX_M2_MASK, VWADDU_WX, 0x1 }, // 10893
  { PseudoVWADDU_WX_M2_TU, VWADDU_WX, 0x1 }, // 10894
  { PseudoVWADDU_WX_M4, VWADDU_WX, 0x2 }, // 10895
  { PseudoVWADDU_WX_M4_MASK, VWADDU_WX, 0x2 }, // 10896
  { PseudoVWADDU_WX_M4_TU, VWADDU_WX, 0x2 }, // 10897
  { PseudoVWADDU_WX_MF8, VWADDU_WX, 0x5 }, // 10898
  { PseudoVWADDU_WX_MF8_MASK, VWADDU_WX, 0x5 }, // 10899
  { PseudoVWADDU_WX_MF8_TU, VWADDU_WX, 0x5 }, // 10900
  { PseudoVWADDU_WX_MF4, VWADDU_WX, 0x6 }, // 10901
  { PseudoVWADDU_WX_MF4_MASK, VWADDU_WX, 0x6 }, // 10902
  { PseudoVWADDU_WX_MF4_TU, VWADDU_WX, 0x6 }, // 10903
  { PseudoVWADDU_WX_MF2, VWADDU_WX, 0x7 }, // 10904
  { PseudoVWADDU_WX_MF2_MASK, VWADDU_WX, 0x7 }, // 10905
  { PseudoVWADDU_WX_MF2_TU, VWADDU_WX, 0x7 }, // 10906
  { PseudoVWADD_VV_M1, VWADD_VV, 0x0 }, // 10907
  { PseudoVWADD_VV_M1_MASK, VWADD_VV, 0x0 }, // 10908
  { PseudoVWADD_VV_M1_TU, VWADD_VV, 0x0 }, // 10909
  { PseudoVWADD_VV_M2, VWADD_VV, 0x1 }, // 10910
  { PseudoVWADD_VV_M2_MASK, VWADD_VV, 0x1 }, // 10911
  { PseudoVWADD_VV_M2_TU, VWADD_VV, 0x1 }, // 10912
  { PseudoVWADD_VV_M4, VWADD_VV, 0x2 }, // 10913
  { PseudoVWADD_VV_M4_MASK, VWADD_VV, 0x2 }, // 10914
  { PseudoVWADD_VV_M4_TU, VWADD_VV, 0x2 }, // 10915
  { PseudoVWADD_VV_MF8, VWADD_VV, 0x5 }, // 10916
  { PseudoVWADD_VV_MF8_MASK, VWADD_VV, 0x5 }, // 10917
  { PseudoVWADD_VV_MF8_TU, VWADD_VV, 0x5 }, // 10918
  { PseudoVWADD_VV_MF4, VWADD_VV, 0x6 }, // 10919
  { PseudoVWADD_VV_MF4_MASK, VWADD_VV, 0x6 }, // 10920
  { PseudoVWADD_VV_MF4_TU, VWADD_VV, 0x6 }, // 10921
  { PseudoVWADD_VV_MF2, VWADD_VV, 0x7 }, // 10922
  { PseudoVWADD_VV_MF2_MASK, VWADD_VV, 0x7 }, // 10923
  { PseudoVWADD_VV_MF2_TU, VWADD_VV, 0x7 }, // 10924
  { PseudoVWADD_VX_M1, VWADD_VX, 0x0 }, // 10925
  { PseudoVWADD_VX_M1_MASK, VWADD_VX, 0x0 }, // 10926
  { PseudoVWADD_VX_M1_TU, VWADD_VX, 0x0 }, // 10927
  { PseudoVWADD_VX_M2, VWADD_VX, 0x1 }, // 10928
  { PseudoVWADD_VX_M2_MASK, VWADD_VX, 0x1 }, // 10929
  { PseudoVWADD_VX_M2_TU, VWADD_VX, 0x1 }, // 10930
  { PseudoVWADD_VX_M4, VWADD_VX, 0x2 }, // 10931
  { PseudoVWADD_VX_M4_MASK, VWADD_VX, 0x2 }, // 10932
  { PseudoVWADD_VX_M4_TU, VWADD_VX, 0x2 }, // 10933
  { PseudoVWADD_VX_MF8, VWADD_VX, 0x5 }, // 10934
  { PseudoVWADD_VX_MF8_MASK, VWADD_VX, 0x5 }, // 10935
  { PseudoVWADD_VX_MF8_TU, VWADD_VX, 0x5 }, // 10936
  { PseudoVWADD_VX_MF4, VWADD_VX, 0x6 }, // 10937
  { PseudoVWADD_VX_MF4_MASK, VWADD_VX, 0x6 }, // 10938
  { PseudoVWADD_VX_MF4_TU, VWADD_VX, 0x6 }, // 10939
  { PseudoVWADD_VX_MF2, VWADD_VX, 0x7 }, // 10940
  { PseudoVWADD_VX_MF2_MASK, VWADD_VX, 0x7 }, // 10941
  { PseudoVWADD_VX_MF2_TU, VWADD_VX, 0x7 }, // 10942
  { PseudoVWADD_WV_M1, VWADD_WV, 0x0 }, // 10943
  { PseudoVWADD_WV_M1_MASK, VWADD_WV, 0x0 }, // 10944
  { PseudoVWADD_WV_M1_MASK_TIED, VWADD_WV, 0x0 }, // 10945
  { PseudoVWADD_WV_M1_TIED, VWADD_WV, 0x0 }, // 10946
  { PseudoVWADD_WV_M1_TU, VWADD_WV, 0x0 }, // 10947
  { PseudoVWADD_WV_M2, VWADD_WV, 0x1 }, // 10948
  { PseudoVWADD_WV_M2_MASK, VWADD_WV, 0x1 }, // 10949
  { PseudoVWADD_WV_M2_MASK_TIED, VWADD_WV, 0x1 }, // 10950
  { PseudoVWADD_WV_M2_TIED, VWADD_WV, 0x1 }, // 10951
  { PseudoVWADD_WV_M2_TU, VWADD_WV, 0x1 }, // 10952
  { PseudoVWADD_WV_M4, VWADD_WV, 0x2 }, // 10953
  { PseudoVWADD_WV_M4_MASK, VWADD_WV, 0x2 }, // 10954
  { PseudoVWADD_WV_M4_MASK_TIED, VWADD_WV, 0x2 }, // 10955
  { PseudoVWADD_WV_M4_TIED, VWADD_WV, 0x2 }, // 10956
  { PseudoVWADD_WV_M4_TU, VWADD_WV, 0x2 }, // 10957
  { PseudoVWADD_WV_MF8, VWADD_WV, 0x5 }, // 10958
  { PseudoVWADD_WV_MF8_MASK, VWADD_WV, 0x5 }, // 10959
  { PseudoVWADD_WV_MF8_MASK_TIED, VWADD_WV, 0x5 }, // 10960
  { PseudoVWADD_WV_MF8_TIED, VWADD_WV, 0x5 }, // 10961
  { PseudoVWADD_WV_MF8_TU, VWADD_WV, 0x5 }, // 10962
  { PseudoVWADD_WV_MF4, VWADD_WV, 0x6 }, // 10963
  { PseudoVWADD_WV_MF4_MASK, VWADD_WV, 0x6 }, // 10964
  { PseudoVWADD_WV_MF4_MASK_TIED, VWADD_WV, 0x6 }, // 10965
  { PseudoVWADD_WV_MF4_TIED, VWADD_WV, 0x6 }, // 10966
  { PseudoVWADD_WV_MF4_TU, VWADD_WV, 0x6 }, // 10967
  { PseudoVWADD_WV_MF2, VWADD_WV, 0x7 }, // 10968
  { PseudoVWADD_WV_MF2_MASK, VWADD_WV, 0x7 }, // 10969
  { PseudoVWADD_WV_MF2_MASK_TIED, VWADD_WV, 0x7 }, // 10970
  { PseudoVWADD_WV_MF2_TIED, VWADD_WV, 0x7 }, // 10971
  { PseudoVWADD_WV_MF2_TU, VWADD_WV, 0x7 }, // 10972
  { PseudoVWADD_WX_M1, VWADD_WX, 0x0 }, // 10973
  { PseudoVWADD_WX_M1_MASK, VWADD_WX, 0x0 }, // 10974
  { PseudoVWADD_WX_M1_TU, VWADD_WX, 0x0 }, // 10975
  { PseudoVWADD_WX_M2, VWADD_WX, 0x1 }, // 10976
  { PseudoVWADD_WX_M2_MASK, VWADD_WX, 0x1 }, // 10977
  { PseudoVWADD_WX_M2_TU, VWADD_WX, 0x1 }, // 10978
  { PseudoVWADD_WX_M4, VWADD_WX, 0x2 }, // 10979
  { PseudoVWADD_WX_M4_MASK, VWADD_WX, 0x2 }, // 10980
  { PseudoVWADD_WX_M4_TU, VWADD_WX, 0x2 }, // 10981
  { PseudoVWADD_WX_MF8, VWADD_WX, 0x5 }, // 10982
  { PseudoVWADD_WX_MF8_MASK, VWADD_WX, 0x5 }, // 10983
  { PseudoVWADD_WX_MF8_TU, VWADD_WX, 0x5 }, // 10984
  { PseudoVWADD_WX_MF4, VWADD_WX, 0x6 }, // 10985
  { PseudoVWADD_WX_MF4_MASK, VWADD_WX, 0x6 }, // 10986
  { PseudoVWADD_WX_MF4_TU, VWADD_WX, 0x6 }, // 10987
  { PseudoVWADD_WX_MF2, VWADD_WX, 0x7 }, // 10988
  { PseudoVWADD_WX_MF2_MASK, VWADD_WX, 0x7 }, // 10989
  { PseudoVWADD_WX_MF2_TU, VWADD_WX, 0x7 }, // 10990
  { PseudoVWMACCSU_VV_M1, VWMACCSU_VV, 0x0 }, // 10991
  { PseudoVWMACCSU_VV_M1_MASK, VWMACCSU_VV, 0x0 }, // 10992
  { PseudoVWMACCSU_VV_M2, VWMACCSU_VV, 0x1 }, // 10993
  { PseudoVWMACCSU_VV_M2_MASK, VWMACCSU_VV, 0x1 }, // 10994
  { PseudoVWMACCSU_VV_M4, VWMACCSU_VV, 0x2 }, // 10995
  { PseudoVWMACCSU_VV_M4_MASK, VWMACCSU_VV, 0x2 }, // 10996
  { PseudoVWMACCSU_VV_MF8, VWMACCSU_VV, 0x5 }, // 10997
  { PseudoVWMACCSU_VV_MF8_MASK, VWMACCSU_VV, 0x5 }, // 10998
  { PseudoVWMACCSU_VV_MF4, VWMACCSU_VV, 0x6 }, // 10999
  { PseudoVWMACCSU_VV_MF4_MASK, VWMACCSU_VV, 0x6 }, // 11000
  { PseudoVWMACCSU_VV_MF2, VWMACCSU_VV, 0x7 }, // 11001
  { PseudoVWMACCSU_VV_MF2_MASK, VWMACCSU_VV, 0x7 }, // 11002
  { PseudoVWMACCSU_VX_M1, VWMACCSU_VX, 0x0 }, // 11003
  { PseudoVWMACCSU_VX_M1_MASK, VWMACCSU_VX, 0x0 }, // 11004
  { PseudoVWMACCSU_VX_M2, VWMACCSU_VX, 0x1 }, // 11005
  { PseudoVWMACCSU_VX_M2_MASK, VWMACCSU_VX, 0x1 }, // 11006
  { PseudoVWMACCSU_VX_M4, VWMACCSU_VX, 0x2 }, // 11007
  { PseudoVWMACCSU_VX_M4_MASK, VWMACCSU_VX, 0x2 }, // 11008
  { PseudoVWMACCSU_VX_MF8, VWMACCSU_VX, 0x5 }, // 11009
  { PseudoVWMACCSU_VX_MF8_MASK, VWMACCSU_VX, 0x5 }, // 11010
  { PseudoVWMACCSU_VX_MF4, VWMACCSU_VX, 0x6 }, // 11011
  { PseudoVWMACCSU_VX_MF4_MASK, VWMACCSU_VX, 0x6 }, // 11012
  { PseudoVWMACCSU_VX_MF2, VWMACCSU_VX, 0x7 }, // 11013
  { PseudoVWMACCSU_VX_MF2_MASK, VWMACCSU_VX, 0x7 }, // 11014
  { PseudoVWMACCUS_VX_M1, VWMACCUS_VX, 0x0 }, // 11015
  { PseudoVWMACCUS_VX_M1_MASK, VWMACCUS_VX, 0x0 }, // 11016
  { PseudoVWMACCUS_VX_M2, VWMACCUS_VX, 0x1 }, // 11017
  { PseudoVWMACCUS_VX_M2_MASK, VWMACCUS_VX, 0x1 }, // 11018
  { PseudoVWMACCUS_VX_M4, VWMACCUS_VX, 0x2 }, // 11019
  { PseudoVWMACCUS_VX_M4_MASK, VWMACCUS_VX, 0x2 }, // 11020
  { PseudoVWMACCUS_VX_MF8, VWMACCUS_VX, 0x5 }, // 11021
  { PseudoVWMACCUS_VX_MF8_MASK, VWMACCUS_VX, 0x5 }, // 11022
  { PseudoVWMACCUS_VX_MF4, VWMACCUS_VX, 0x6 }, // 11023
  { PseudoVWMACCUS_VX_MF4_MASK, VWMACCUS_VX, 0x6 }, // 11024
  { PseudoVWMACCUS_VX_MF2, VWMACCUS_VX, 0x7 }, // 11025
  { PseudoVWMACCUS_VX_MF2_MASK, VWMACCUS_VX, 0x7 }, // 11026
  { PseudoVWMACCU_VV_M1, VWMACCU_VV, 0x0 }, // 11027
  { PseudoVWMACCU_VV_M1_MASK, VWMACCU_VV, 0x0 }, // 11028
  { PseudoVWMACCU_VV_M2, VWMACCU_VV, 0x1 }, // 11029
  { PseudoVWMACCU_VV_M2_MASK, VWMACCU_VV, 0x1 }, // 11030
  { PseudoVWMACCU_VV_M4, VWMACCU_VV, 0x2 }, // 11031
  { PseudoVWMACCU_VV_M4_MASK, VWMACCU_VV, 0x2 }, // 11032
  { PseudoVWMACCU_VV_MF8, VWMACCU_VV, 0x5 }, // 11033
  { PseudoVWMACCU_VV_MF8_MASK, VWMACCU_VV, 0x5 }, // 11034
  { PseudoVWMACCU_VV_MF4, VWMACCU_VV, 0x6 }, // 11035
  { PseudoVWMACCU_VV_MF4_MASK, VWMACCU_VV, 0x6 }, // 11036
  { PseudoVWMACCU_VV_MF2, VWMACCU_VV, 0x7 }, // 11037
  { PseudoVWMACCU_VV_MF2_MASK, VWMACCU_VV, 0x7 }, // 11038
  { PseudoVWMACCU_VX_M1, VWMACCU_VX, 0x0 }, // 11039
  { PseudoVWMACCU_VX_M1_MASK, VWMACCU_VX, 0x0 }, // 11040
  { PseudoVWMACCU_VX_M2, VWMACCU_VX, 0x1 }, // 11041
  { PseudoVWMACCU_VX_M2_MASK, VWMACCU_VX, 0x1 }, // 11042
  { PseudoVWMACCU_VX_M4, VWMACCU_VX, 0x2 }, // 11043
  { PseudoVWMACCU_VX_M4_MASK, VWMACCU_VX, 0x2 }, // 11044
  { PseudoVWMACCU_VX_MF8, VWMACCU_VX, 0x5 }, // 11045
  { PseudoVWMACCU_VX_MF8_MASK, VWMACCU_VX, 0x5 }, // 11046
  { PseudoVWMACCU_VX_MF4, VWMACCU_VX, 0x6 }, // 11047
  { PseudoVWMACCU_VX_MF4_MASK, VWMACCU_VX, 0x6 }, // 11048
  { PseudoVWMACCU_VX_MF2, VWMACCU_VX, 0x7 }, // 11049
  { PseudoVWMACCU_VX_MF2_MASK, VWMACCU_VX, 0x7 }, // 11050
  { PseudoVWMACC_VV_M1, VWMACC_VV, 0x0 }, // 11051
  { PseudoVWMACC_VV_M1_MASK, VWMACC_VV, 0x0 }, // 11052
  { PseudoVWMACC_VV_M2, VWMACC_VV, 0x1 }, // 11053
  { PseudoVWMACC_VV_M2_MASK, VWMACC_VV, 0x1 }, // 11054
  { PseudoVWMACC_VV_M4, VWMACC_VV, 0x2 }, // 11055
  { PseudoVWMACC_VV_M4_MASK, VWMACC_VV, 0x2 }, // 11056
  { PseudoVWMACC_VV_MF8, VWMACC_VV, 0x5 }, // 11057
  { PseudoVWMACC_VV_MF8_MASK, VWMACC_VV, 0x5 }, // 11058
  { PseudoVWMACC_VV_MF4, VWMACC_VV, 0x6 }, // 11059
  { PseudoVWMACC_VV_MF4_MASK, VWMACC_VV, 0x6 }, // 11060
  { PseudoVWMACC_VV_MF2, VWMACC_VV, 0x7 }, // 11061
  { PseudoVWMACC_VV_MF2_MASK, VWMACC_VV, 0x7 }, // 11062
  { PseudoVWMACC_VX_M1, VWMACC_VX, 0x0 }, // 11063
  { PseudoVWMACC_VX_M1_MASK, VWMACC_VX, 0x0 }, // 11064
  { PseudoVWMACC_VX_M2, VWMACC_VX, 0x1 }, // 11065
  { PseudoVWMACC_VX_M2_MASK, VWMACC_VX, 0x1 }, // 11066
  { PseudoVWMACC_VX_M4, VWMACC_VX, 0x2 }, // 11067
  { PseudoVWMACC_VX_M4_MASK, VWMACC_VX, 0x2 }, // 11068
  { PseudoVWMACC_VX_MF8, VWMACC_VX, 0x5 }, // 11069
  { PseudoVWMACC_VX_MF8_MASK, VWMACC_VX, 0x5 }, // 11070
  { PseudoVWMACC_VX_MF4, VWMACC_VX, 0x6 }, // 11071
  { PseudoVWMACC_VX_MF4_MASK, VWMACC_VX, 0x6 }, // 11072
  { PseudoVWMACC_VX_MF2, VWMACC_VX, 0x7 }, // 11073
  { PseudoVWMACC_VX_MF2_MASK, VWMACC_VX, 0x7 }, // 11074
  { PseudoVWMULSU_VV_M1, VWMULSU_VV, 0x0 }, // 11075
  { PseudoVWMULSU_VV_M1_MASK, VWMULSU_VV, 0x0 }, // 11076
  { PseudoVWMULSU_VV_M1_TU, VWMULSU_VV, 0x0 }, // 11077
  { PseudoVWMULSU_VV_M2, VWMULSU_VV, 0x1 }, // 11078
  { PseudoVWMULSU_VV_M2_MASK, VWMULSU_VV, 0x1 }, // 11079
  { PseudoVWMULSU_VV_M2_TU, VWMULSU_VV, 0x1 }, // 11080
  { PseudoVWMULSU_VV_M4, VWMULSU_VV, 0x2 }, // 11081
  { PseudoVWMULSU_VV_M4_MASK, VWMULSU_VV, 0x2 }, // 11082
  { PseudoVWMULSU_VV_M4_TU, VWMULSU_VV, 0x2 }, // 11083
  { PseudoVWMULSU_VV_MF8, VWMULSU_VV, 0x5 }, // 11084
  { PseudoVWMULSU_VV_MF8_MASK, VWMULSU_VV, 0x5 }, // 11085
  { PseudoVWMULSU_VV_MF8_TU, VWMULSU_VV, 0x5 }, // 11086
  { PseudoVWMULSU_VV_MF4, VWMULSU_VV, 0x6 }, // 11087
  { PseudoVWMULSU_VV_MF4_MASK, VWMULSU_VV, 0x6 }, // 11088
  { PseudoVWMULSU_VV_MF4_TU, VWMULSU_VV, 0x6 }, // 11089
  { PseudoVWMULSU_VV_MF2, VWMULSU_VV, 0x7 }, // 11090
  { PseudoVWMULSU_VV_MF2_MASK, VWMULSU_VV, 0x7 }, // 11091
  { PseudoVWMULSU_VV_MF2_TU, VWMULSU_VV, 0x7 }, // 11092
  { PseudoVWMULSU_VX_M1, VWMULSU_VX, 0x0 }, // 11093
  { PseudoVWMULSU_VX_M1_MASK, VWMULSU_VX, 0x0 }, // 11094
  { PseudoVWMULSU_VX_M1_TU, VWMULSU_VX, 0x0 }, // 11095
  { PseudoVWMULSU_VX_M2, VWMULSU_VX, 0x1 }, // 11096
  { PseudoVWMULSU_VX_M2_MASK, VWMULSU_VX, 0x1 }, // 11097
  { PseudoVWMULSU_VX_M2_TU, VWMULSU_VX, 0x1 }, // 11098
  { PseudoVWMULSU_VX_M4, VWMULSU_VX, 0x2 }, // 11099
  { PseudoVWMULSU_VX_M4_MASK, VWMULSU_VX, 0x2 }, // 11100
  { PseudoVWMULSU_VX_M4_TU, VWMULSU_VX, 0x2 }, // 11101
  { PseudoVWMULSU_VX_MF8, VWMULSU_VX, 0x5 }, // 11102
  { PseudoVWMULSU_VX_MF8_MASK, VWMULSU_VX, 0x5 }, // 11103
  { PseudoVWMULSU_VX_MF8_TU, VWMULSU_VX, 0x5 }, // 11104
  { PseudoVWMULSU_VX_MF4, VWMULSU_VX, 0x6 }, // 11105
  { PseudoVWMULSU_VX_MF4_MASK, VWMULSU_VX, 0x6 }, // 11106
  { PseudoVWMULSU_VX_MF4_TU, VWMULSU_VX, 0x6 }, // 11107
  { PseudoVWMULSU_VX_MF2, VWMULSU_VX, 0x7 }, // 11108
  { PseudoVWMULSU_VX_MF2_MASK, VWMULSU_VX, 0x7 }, // 11109
  { PseudoVWMULSU_VX_MF2_TU, VWMULSU_VX, 0x7 }, // 11110
  { PseudoVWMULU_VV_M1, VWMULU_VV, 0x0 }, // 11111
  { PseudoVWMULU_VV_M1_MASK, VWMULU_VV, 0x0 }, // 11112
  { PseudoVWMULU_VV_M1_TU, VWMULU_VV, 0x0 }, // 11113
  { PseudoVWMULU_VV_M2, VWMULU_VV, 0x1 }, // 11114
  { PseudoVWMULU_VV_M2_MASK, VWMULU_VV, 0x1 }, // 11115
  { PseudoVWMULU_VV_M2_TU, VWMULU_VV, 0x1 }, // 11116
  { PseudoVWMULU_VV_M4, VWMULU_VV, 0x2 }, // 11117
  { PseudoVWMULU_VV_M4_MASK, VWMULU_VV, 0x2 }, // 11118
  { PseudoVWMULU_VV_M4_TU, VWMULU_VV, 0x2 }, // 11119
  { PseudoVWMULU_VV_MF8, VWMULU_VV, 0x5 }, // 11120
  { PseudoVWMULU_VV_MF8_MASK, VWMULU_VV, 0x5 }, // 11121
  { PseudoVWMULU_VV_MF8_TU, VWMULU_VV, 0x5 }, // 11122
  { PseudoVWMULU_VV_MF4, VWMULU_VV, 0x6 }, // 11123
  { PseudoVWMULU_VV_MF4_MASK, VWMULU_VV, 0x6 }, // 11124
  { PseudoVWMULU_VV_MF4_TU, VWMULU_VV, 0x6 }, // 11125
  { PseudoVWMULU_VV_MF2, VWMULU_VV, 0x7 }, // 11126
  { PseudoVWMULU_VV_MF2_MASK, VWMULU_VV, 0x7 }, // 11127
  { PseudoVWMULU_VV_MF2_TU, VWMULU_VV, 0x7 }, // 11128
  { PseudoVWMULU_VX_M1, VWMULU_VX, 0x0 }, // 11129
  { PseudoVWMULU_VX_M1_MASK, VWMULU_VX, 0x0 }, // 11130
  { PseudoVWMULU_VX_M1_TU, VWMULU_VX, 0x0 }, // 11131
  { PseudoVWMULU_VX_M2, VWMULU_VX, 0x1 }, // 11132
  { PseudoVWMULU_VX_M2_MASK, VWMULU_VX, 0x1 }, // 11133
  { PseudoVWMULU_VX_M2_TU, VWMULU_VX, 0x1 }, // 11134
  { PseudoVWMULU_VX_M4, VWMULU_VX, 0x2 }, // 11135
  { PseudoVWMULU_VX_M4_MASK, VWMULU_VX, 0x2 }, // 11136
  { PseudoVWMULU_VX_M4_TU, VWMULU_VX, 0x2 }, // 11137
  { PseudoVWMULU_VX_MF8, VWMULU_VX, 0x5 }, // 11138
  { PseudoVWMULU_VX_MF8_MASK, VWMULU_VX, 0x5 }, // 11139
  { PseudoVWMULU_VX_MF8_TU, VWMULU_VX, 0x5 }, // 11140
  { PseudoVWMULU_VX_MF4, VWMULU_VX, 0x6 }, // 11141
  { PseudoVWMULU_VX_MF4_MASK, VWMULU_VX, 0x6 }, // 11142
  { PseudoVWMULU_VX_MF4_TU, VWMULU_VX, 0x6 }, // 11143
  { PseudoVWMULU_VX_MF2, VWMULU_VX, 0x7 }, // 11144
  { PseudoVWMULU_VX_MF2_MASK, VWMULU_VX, 0x7 }, // 11145
  { PseudoVWMULU_VX_MF2_TU, VWMULU_VX, 0x7 }, // 11146
  { PseudoVWMUL_VV_M1, VWMUL_VV, 0x0 }, // 11147
  { PseudoVWMUL_VV_M1_MASK, VWMUL_VV, 0x0 }, // 11148
  { PseudoVWMUL_VV_M1_TU, VWMUL_VV, 0x0 }, // 11149
  { PseudoVWMUL_VV_M2, VWMUL_VV, 0x1 }, // 11150
  { PseudoVWMUL_VV_M2_MASK, VWMUL_VV, 0x1 }, // 11151
  { PseudoVWMUL_VV_M2_TU, VWMUL_VV, 0x1 }, // 11152
  { PseudoVWMUL_VV_M4, VWMUL_VV, 0x2 }, // 11153
  { PseudoVWMUL_VV_M4_MASK, VWMUL_VV, 0x2 }, // 11154
  { PseudoVWMUL_VV_M4_TU, VWMUL_VV, 0x2 }, // 11155
  { PseudoVWMUL_VV_MF8, VWMUL_VV, 0x5 }, // 11156
  { PseudoVWMUL_VV_MF8_MASK, VWMUL_VV, 0x5 }, // 11157
  { PseudoVWMUL_VV_MF8_TU, VWMUL_VV, 0x5 }, // 11158
  { PseudoVWMUL_VV_MF4, VWMUL_VV, 0x6 }, // 11159
  { PseudoVWMUL_VV_MF4_MASK, VWMUL_VV, 0x6 }, // 11160
  { PseudoVWMUL_VV_MF4_TU, VWMUL_VV, 0x6 }, // 11161
  { PseudoVWMUL_VV_MF2, VWMUL_VV, 0x7 }, // 11162
  { PseudoVWMUL_VV_MF2_MASK, VWMUL_VV, 0x7 }, // 11163
  { PseudoVWMUL_VV_MF2_TU, VWMUL_VV, 0x7 }, // 11164
  { PseudoVWMUL_VX_M1, VWMUL_VX, 0x0 }, // 11165
  { PseudoVWMUL_VX_M1_MASK, VWMUL_VX, 0x0 }, // 11166
  { PseudoVWMUL_VX_M1_TU, VWMUL_VX, 0x0 }, // 11167
  { PseudoVWMUL_VX_M2, VWMUL_VX, 0x1 }, // 11168
  { PseudoVWMUL_VX_M2_MASK, VWMUL_VX, 0x1 }, // 11169
  { PseudoVWMUL_VX_M2_TU, VWMUL_VX, 0x1 }, // 11170
  { PseudoVWMUL_VX_M4, VWMUL_VX, 0x2 }, // 11171
  { PseudoVWMUL_VX_M4_MASK, VWMUL_VX, 0x2 }, // 11172
  { PseudoVWMUL_VX_M4_TU, VWMUL_VX, 0x2 }, // 11173
  { PseudoVWMUL_VX_MF8, VWMUL_VX, 0x5 }, // 11174
  { PseudoVWMUL_VX_MF8_MASK, VWMUL_VX, 0x5 }, // 11175
  { PseudoVWMUL_VX_MF8_TU, VWMUL_VX, 0x5 }, // 11176
  { PseudoVWMUL_VX_MF4, VWMUL_VX, 0x6 }, // 11177
  { PseudoVWMUL_VX_MF4_MASK, VWMUL_VX, 0x6 }, // 11178
  { PseudoVWMUL_VX_MF4_TU, VWMUL_VX, 0x6 }, // 11179
  { PseudoVWMUL_VX_MF2, VWMUL_VX, 0x7 }, // 11180
  { PseudoVWMUL_VX_MF2_MASK, VWMUL_VX, 0x7 }, // 11181
  { PseudoVWMUL_VX_MF2_TU, VWMUL_VX, 0x7 }, // 11182
  { PseudoVWREDSUMU_VS_M1, VWREDSUMU_VS, 0x0 }, // 11183
  { PseudoVWREDSUMU_VS_M1_MASK, VWREDSUMU_VS, 0x0 }, // 11184
  { PseudoVWREDSUMU_VS_M2, VWREDSUMU_VS, 0x1 }, // 11185
  { PseudoVWREDSUMU_VS_M2_MASK, VWREDSUMU_VS, 0x1 }, // 11186
  { PseudoVWREDSUMU_VS_M4, VWREDSUMU_VS, 0x2 }, // 11187
  { PseudoVWREDSUMU_VS_M4_MASK, VWREDSUMU_VS, 0x2 }, // 11188
  { PseudoVWREDSUMU_VS_M8, VWREDSUMU_VS, 0x3 }, // 11189
  { PseudoVWREDSUMU_VS_M8_MASK, VWREDSUMU_VS, 0x3 }, // 11190
  { PseudoVWREDSUMU_VS_MF8, VWREDSUMU_VS, 0x5 }, // 11191
  { PseudoVWREDSUMU_VS_MF8_MASK, VWREDSUMU_VS, 0x5 }, // 11192
  { PseudoVWREDSUMU_VS_MF4, VWREDSUMU_VS, 0x6 }, // 11193
  { PseudoVWREDSUMU_VS_MF4_MASK, VWREDSUMU_VS, 0x6 }, // 11194
  { PseudoVWREDSUMU_VS_MF2, VWREDSUMU_VS, 0x7 }, // 11195
  { PseudoVWREDSUMU_VS_MF2_MASK, VWREDSUMU_VS, 0x7 }, // 11196
  { PseudoVWREDSUM_VS_M1, VWREDSUM_VS, 0x0 }, // 11197
  { PseudoVWREDSUM_VS_M1_MASK, VWREDSUM_VS, 0x0 }, // 11198
  { PseudoVWREDSUM_VS_M2, VWREDSUM_VS, 0x1 }, // 11199
  { PseudoVWREDSUM_VS_M2_MASK, VWREDSUM_VS, 0x1 }, // 11200
  { PseudoVWREDSUM_VS_M4, VWREDSUM_VS, 0x2 }, // 11201
  { PseudoVWREDSUM_VS_M4_MASK, VWREDSUM_VS, 0x2 }, // 11202
  { PseudoVWREDSUM_VS_M8, VWREDSUM_VS, 0x3 }, // 11203
  { PseudoVWREDSUM_VS_M8_MASK, VWREDSUM_VS, 0x3 }, // 11204
  { PseudoVWREDSUM_VS_MF8, VWREDSUM_VS, 0x5 }, // 11205
  { PseudoVWREDSUM_VS_MF8_MASK, VWREDSUM_VS, 0x5 }, // 11206
  { PseudoVWREDSUM_VS_MF4, VWREDSUM_VS, 0x6 }, // 11207
  { PseudoVWREDSUM_VS_MF4_MASK, VWREDSUM_VS, 0x6 }, // 11208
  { PseudoVWREDSUM_VS_MF2, VWREDSUM_VS, 0x7 }, // 11209
  { PseudoVWREDSUM_VS_MF2_MASK, VWREDSUM_VS, 0x7 }, // 11210
  { PseudoVWSUBU_VV_M1, VWSUBU_VV, 0x0 }, // 11211
  { PseudoVWSUBU_VV_M1_MASK, VWSUBU_VV, 0x0 }, // 11212
  { PseudoVWSUBU_VV_M1_TU, VWSUBU_VV, 0x0 }, // 11213
  { PseudoVWSUBU_VV_M2, VWSUBU_VV, 0x1 }, // 11214
  { PseudoVWSUBU_VV_M2_MASK, VWSUBU_VV, 0x1 }, // 11215
  { PseudoVWSUBU_VV_M2_TU, VWSUBU_VV, 0x1 }, // 11216
  { PseudoVWSUBU_VV_M4, VWSUBU_VV, 0x2 }, // 11217
  { PseudoVWSUBU_VV_M4_MASK, VWSUBU_VV, 0x2 }, // 11218
  { PseudoVWSUBU_VV_M4_TU, VWSUBU_VV, 0x2 }, // 11219
  { PseudoVWSUBU_VV_MF8, VWSUBU_VV, 0x5 }, // 11220
  { PseudoVWSUBU_VV_MF8_MASK, VWSUBU_VV, 0x5 }, // 11221
  { PseudoVWSUBU_VV_MF8_TU, VWSUBU_VV, 0x5 }, // 11222
  { PseudoVWSUBU_VV_MF4, VWSUBU_VV, 0x6 }, // 11223
  { PseudoVWSUBU_VV_MF4_MASK, VWSUBU_VV, 0x6 }, // 11224
  { PseudoVWSUBU_VV_MF4_TU, VWSUBU_VV, 0x6 }, // 11225
  { PseudoVWSUBU_VV_MF2, VWSUBU_VV, 0x7 }, // 11226
  { PseudoVWSUBU_VV_MF2_MASK, VWSUBU_VV, 0x7 }, // 11227
  { PseudoVWSUBU_VV_MF2_TU, VWSUBU_VV, 0x7 }, // 11228
  { PseudoVWSUBU_VX_M1, VWSUBU_VX, 0x0 }, // 11229
  { PseudoVWSUBU_VX_M1_MASK, VWSUBU_VX, 0x0 }, // 11230
  { PseudoVWSUBU_VX_M1_TU, VWSUBU_VX, 0x0 }, // 11231
  { PseudoVWSUBU_VX_M2, VWSUBU_VX, 0x1 }, // 11232
  { PseudoVWSUBU_VX_M2_MASK, VWSUBU_VX, 0x1 }, // 11233
  { PseudoVWSUBU_VX_M2_TU, VWSUBU_VX, 0x1 }, // 11234
  { PseudoVWSUBU_VX_M4, VWSUBU_VX, 0x2 }, // 11235
  { PseudoVWSUBU_VX_M4_MASK, VWSUBU_VX, 0x2 }, // 11236
  { PseudoVWSUBU_VX_M4_TU, VWSUBU_VX, 0x2 }, // 11237
  { PseudoVWSUBU_VX_MF8, VWSUBU_VX, 0x5 }, // 11238
  { PseudoVWSUBU_VX_MF8_MASK, VWSUBU_VX, 0x5 }, // 11239
  { PseudoVWSUBU_VX_MF8_TU, VWSUBU_VX, 0x5 }, // 11240
  { PseudoVWSUBU_VX_MF4, VWSUBU_VX, 0x6 }, // 11241
  { PseudoVWSUBU_VX_MF4_MASK, VWSUBU_VX, 0x6 }, // 11242
  { PseudoVWSUBU_VX_MF4_TU, VWSUBU_VX, 0x6 }, // 11243
  { PseudoVWSUBU_VX_MF2, VWSUBU_VX, 0x7 }, // 11244
  { PseudoVWSUBU_VX_MF2_MASK, VWSUBU_VX, 0x7 }, // 11245
  { PseudoVWSUBU_VX_MF2_TU, VWSUBU_VX, 0x7 }, // 11246
  { PseudoVWSUBU_WV_M1, VWSUBU_WV, 0x0 }, // 11247
  { PseudoVWSUBU_WV_M1_MASK, VWSUBU_WV, 0x0 }, // 11248
  { PseudoVWSUBU_WV_M1_MASK_TIED, VWSUBU_WV, 0x0 }, // 11249
  { PseudoVWSUBU_WV_M1_TIED, VWSUBU_WV, 0x0 }, // 11250
  { PseudoVWSUBU_WV_M1_TU, VWSUBU_WV, 0x0 }, // 11251
  { PseudoVWSUBU_WV_M2, VWSUBU_WV, 0x1 }, // 11252
  { PseudoVWSUBU_WV_M2_MASK, VWSUBU_WV, 0x1 }, // 11253
  { PseudoVWSUBU_WV_M2_MASK_TIED, VWSUBU_WV, 0x1 }, // 11254
  { PseudoVWSUBU_WV_M2_TIED, VWSUBU_WV, 0x1 }, // 11255
  { PseudoVWSUBU_WV_M2_TU, VWSUBU_WV, 0x1 }, // 11256
  { PseudoVWSUBU_WV_M4, VWSUBU_WV, 0x2 }, // 11257
  { PseudoVWSUBU_WV_M4_MASK, VWSUBU_WV, 0x2 }, // 11258
  { PseudoVWSUBU_WV_M4_MASK_TIED, VWSUBU_WV, 0x2 }, // 11259
  { PseudoVWSUBU_WV_M4_TIED, VWSUBU_WV, 0x2 }, // 11260
  { PseudoVWSUBU_WV_M4_TU, VWSUBU_WV, 0x2 }, // 11261
  { PseudoVWSUBU_WV_MF8, VWSUBU_WV, 0x5 }, // 11262
  { PseudoVWSUBU_WV_MF8_MASK, VWSUBU_WV, 0x5 }, // 11263
  { PseudoVWSUBU_WV_MF8_MASK_TIED, VWSUBU_WV, 0x5 }, // 11264
  { PseudoVWSUBU_WV_MF8_TIED, VWSUBU_WV, 0x5 }, // 11265
  { PseudoVWSUBU_WV_MF8_TU, VWSUBU_WV, 0x5 }, // 11266
  { PseudoVWSUBU_WV_MF4, VWSUBU_WV, 0x6 }, // 11267
  { PseudoVWSUBU_WV_MF4_MASK, VWSUBU_WV, 0x6 }, // 11268
  { PseudoVWSUBU_WV_MF4_MASK_TIED, VWSUBU_WV, 0x6 }, // 11269
  { PseudoVWSUBU_WV_MF4_TIED, VWSUBU_WV, 0x6 }, // 11270
  { PseudoVWSUBU_WV_MF4_TU, VWSUBU_WV, 0x6 }, // 11271
  { PseudoVWSUBU_WV_MF2, VWSUBU_WV, 0x7 }, // 11272
  { PseudoVWSUBU_WV_MF2_MASK, VWSUBU_WV, 0x7 }, // 11273
  { PseudoVWSUBU_WV_MF2_MASK_TIED, VWSUBU_WV, 0x7 }, // 11274
  { PseudoVWSUBU_WV_MF2_TIED, VWSUBU_WV, 0x7 }, // 11275
  { PseudoVWSUBU_WV_MF2_TU, VWSUBU_WV, 0x7 }, // 11276
  { PseudoVWSUBU_WX_M1, VWSUBU_WX, 0x0 }, // 11277
  { PseudoVWSUBU_WX_M1_MASK, VWSUBU_WX, 0x0 }, // 11278
  { PseudoVWSUBU_WX_M1_TU, VWSUBU_WX, 0x0 }, // 11279
  { PseudoVWSUBU_WX_M2, VWSUBU_WX, 0x1 }, // 11280
  { PseudoVWSUBU_WX_M2_MASK, VWSUBU_WX, 0x1 }, // 11281
  { PseudoVWSUBU_WX_M2_TU, VWSUBU_WX, 0x1 }, // 11282
  { PseudoVWSUBU_WX_M4, VWSUBU_WX, 0x2 }, // 11283
  { PseudoVWSUBU_WX_M4_MASK, VWSUBU_WX, 0x2 }, // 11284
  { PseudoVWSUBU_WX_M4_TU, VWSUBU_WX, 0x2 }, // 11285
  { PseudoVWSUBU_WX_MF8, VWSUBU_WX, 0x5 }, // 11286
  { PseudoVWSUBU_WX_MF8_MASK, VWSUBU_WX, 0x5 }, // 11287
  { PseudoVWSUBU_WX_MF8_TU, VWSUBU_WX, 0x5 }, // 11288
  { PseudoVWSUBU_WX_MF4, VWSUBU_WX, 0x6 }, // 11289
  { PseudoVWSUBU_WX_MF4_MASK, VWSUBU_WX, 0x6 }, // 11290
  { PseudoVWSUBU_WX_MF4_TU, VWSUBU_WX, 0x6 }, // 11291
  { PseudoVWSUBU_WX_MF2, VWSUBU_WX, 0x7 }, // 11292
  { PseudoVWSUBU_WX_MF2_MASK, VWSUBU_WX, 0x7 }, // 11293
  { PseudoVWSUBU_WX_MF2_TU, VWSUBU_WX, 0x7 }, // 11294
  { PseudoVWSUB_VV_M1, VWSUB_VV, 0x0 }, // 11295
  { PseudoVWSUB_VV_M1_MASK, VWSUB_VV, 0x0 }, // 11296
  { PseudoVWSUB_VV_M1_TU, VWSUB_VV, 0x0 }, // 11297
  { PseudoVWSUB_VV_M2, VWSUB_VV, 0x1 }, // 11298
  { PseudoVWSUB_VV_M2_MASK, VWSUB_VV, 0x1 }, // 11299
  { PseudoVWSUB_VV_M2_TU, VWSUB_VV, 0x1 }, // 11300
  { PseudoVWSUB_VV_M4, VWSUB_VV, 0x2 }, // 11301
  { PseudoVWSUB_VV_M4_MASK, VWSUB_VV, 0x2 }, // 11302
  { PseudoVWSUB_VV_M4_TU, VWSUB_VV, 0x2 }, // 11303
  { PseudoVWSUB_VV_MF8, VWSUB_VV, 0x5 }, // 11304
  { PseudoVWSUB_VV_MF8_MASK, VWSUB_VV, 0x5 }, // 11305
  { PseudoVWSUB_VV_MF8_TU, VWSUB_VV, 0x5 }, // 11306
  { PseudoVWSUB_VV_MF4, VWSUB_VV, 0x6 }, // 11307
  { PseudoVWSUB_VV_MF4_MASK, VWSUB_VV, 0x6 }, // 11308
  { PseudoVWSUB_VV_MF4_TU, VWSUB_VV, 0x6 }, // 11309
  { PseudoVWSUB_VV_MF2, VWSUB_VV, 0x7 }, // 11310
  { PseudoVWSUB_VV_MF2_MASK, VWSUB_VV, 0x7 }, // 11311
  { PseudoVWSUB_VV_MF2_TU, VWSUB_VV, 0x7 }, // 11312
  { PseudoVWSUB_VX_M1, VWSUB_VX, 0x0 }, // 11313
  { PseudoVWSUB_VX_M1_MASK, VWSUB_VX, 0x0 }, // 11314
  { PseudoVWSUB_VX_M1_TU, VWSUB_VX, 0x0 }, // 11315
  { PseudoVWSUB_VX_M2, VWSUB_VX, 0x1 }, // 11316
  { PseudoVWSUB_VX_M2_MASK, VWSUB_VX, 0x1 }, // 11317
  { PseudoVWSUB_VX_M2_TU, VWSUB_VX, 0x1 }, // 11318
  { PseudoVWSUB_VX_M4, VWSUB_VX, 0x2 }, // 11319
  { PseudoVWSUB_VX_M4_MASK, VWSUB_VX, 0x2 }, // 11320
  { PseudoVWSUB_VX_M4_TU, VWSUB_VX, 0x2 }, // 11321
  { PseudoVWSUB_VX_MF8, VWSUB_VX, 0x5 }, // 11322
  { PseudoVWSUB_VX_MF8_MASK, VWSUB_VX, 0x5 }, // 11323
  { PseudoVWSUB_VX_MF8_TU, VWSUB_VX, 0x5 }, // 11324
  { PseudoVWSUB_VX_MF4, VWSUB_VX, 0x6 }, // 11325
  { PseudoVWSUB_VX_MF4_MASK, VWSUB_VX, 0x6 }, // 11326
  { PseudoVWSUB_VX_MF4_TU, VWSUB_VX, 0x6 }, // 11327
  { PseudoVWSUB_VX_MF2, VWSUB_VX, 0x7 }, // 11328
  { PseudoVWSUB_VX_MF2_MASK, VWSUB_VX, 0x7 }, // 11329
  { PseudoVWSUB_VX_MF2_TU, VWSUB_VX, 0x7 }, // 11330
  { PseudoVWSUB_WV_M1, VWSUB_WV, 0x0 }, // 11331
  { PseudoVWSUB_WV_M1_MASK, VWSUB_WV, 0x0 }, // 11332
  { PseudoVWSUB_WV_M1_MASK_TIED, VWSUB_WV, 0x0 }, // 11333
  { PseudoVWSUB_WV_M1_TIED, VWSUB_WV, 0x0 }, // 11334
  { PseudoVWSUB_WV_M1_TU, VWSUB_WV, 0x0 }, // 11335
  { PseudoVWSUB_WV_M2, VWSUB_WV, 0x1 }, // 11336
  { PseudoVWSUB_WV_M2_MASK, VWSUB_WV, 0x1 }, // 11337
  { PseudoVWSUB_WV_M2_MASK_TIED, VWSUB_WV, 0x1 }, // 11338
  { PseudoVWSUB_WV_M2_TIED, VWSUB_WV, 0x1 }, // 11339
  { PseudoVWSUB_WV_M2_TU, VWSUB_WV, 0x1 }, // 11340
  { PseudoVWSUB_WV_M4, VWSUB_WV, 0x2 }, // 11341
  { PseudoVWSUB_WV_M4_MASK, VWSUB_WV, 0x2 }, // 11342
  { PseudoVWSUB_WV_M4_MASK_TIED, VWSUB_WV, 0x2 }, // 11343
  { PseudoVWSUB_WV_M4_TIED, VWSUB_WV, 0x2 }, // 11344
  { PseudoVWSUB_WV_M4_TU, VWSUB_WV, 0x2 }, // 11345
  { PseudoVWSUB_WV_MF8, VWSUB_WV, 0x5 }, // 11346
  { PseudoVWSUB_WV_MF8_MASK, VWSUB_WV, 0x5 }, // 11347
  { PseudoVWSUB_WV_MF8_MASK_TIED, VWSUB_WV, 0x5 }, // 11348
  { PseudoVWSUB_WV_MF8_TIED, VWSUB_WV, 0x5 }, // 11349
  { PseudoVWSUB_WV_MF8_TU, VWSUB_WV, 0x5 }, // 11350
  { PseudoVWSUB_WV_MF4, VWSUB_WV, 0x6 }, // 11351
  { PseudoVWSUB_WV_MF4_MASK, VWSUB_WV, 0x6 }, // 11352
  { PseudoVWSUB_WV_MF4_MASK_TIED, VWSUB_WV, 0x6 }, // 11353
  { PseudoVWSUB_WV_MF4_TIED, VWSUB_WV, 0x6 }, // 11354
  { PseudoVWSUB_WV_MF4_TU, VWSUB_WV, 0x6 }, // 11355
  { PseudoVWSUB_WV_MF2, VWSUB_WV, 0x7 }, // 11356
  { PseudoVWSUB_WV_MF2_MASK, VWSUB_WV, 0x7 }, // 11357
  { PseudoVWSUB_WV_MF2_MASK_TIED, VWSUB_WV, 0x7 }, // 11358
  { PseudoVWSUB_WV_MF2_TIED, VWSUB_WV, 0x7 }, // 11359
  { PseudoVWSUB_WV_MF2_TU, VWSUB_WV, 0x7 }, // 11360
  { PseudoVWSUB_WX_M1, VWSUB_WX, 0x0 }, // 11361
  { PseudoVWSUB_WX_M1_MASK, VWSUB_WX, 0x0 }, // 11362
  { PseudoVWSUB_WX_M1_TU, VWSUB_WX, 0x0 }, // 11363
  { PseudoVWSUB_WX_M2, VWSUB_WX, 0x1 }, // 11364
  { PseudoVWSUB_WX_M2_MASK, VWSUB_WX, 0x1 }, // 11365
  { PseudoVWSUB_WX_M2_TU, VWSUB_WX, 0x1 }, // 11366
  { PseudoVWSUB_WX_M4, VWSUB_WX, 0x2 }, // 11367
  { PseudoVWSUB_WX_M4_MASK, VWSUB_WX, 0x2 }, // 11368
  { PseudoVWSUB_WX_M4_TU, VWSUB_WX, 0x2 }, // 11369
  { PseudoVWSUB_WX_MF8, VWSUB_WX, 0x5 }, // 11370
  { PseudoVWSUB_WX_MF8_MASK, VWSUB_WX, 0x5 }, // 11371
  { PseudoVWSUB_WX_MF8_TU, VWSUB_WX, 0x5 }, // 11372
  { PseudoVWSUB_WX_MF4, VWSUB_WX, 0x6 }, // 11373
  { PseudoVWSUB_WX_MF4_MASK, VWSUB_WX, 0x6 }, // 11374
  { PseudoVWSUB_WX_MF4_TU, VWSUB_WX, 0x6 }, // 11375
  { PseudoVWSUB_WX_MF2, VWSUB_WX, 0x7 }, // 11376
  { PseudoVWSUB_WX_MF2_MASK, VWSUB_WX, 0x7 }, // 11377
  { PseudoVWSUB_WX_MF2_TU, VWSUB_WX, 0x7 }, // 11378
  { PseudoVXOR_VI_M1, VXOR_VI, 0x0 }, // 11379
  { PseudoVXOR_VI_M1_MASK, VXOR_VI, 0x0 }, // 11380
  { PseudoVXOR_VI_M1_TU, VXOR_VI, 0x0 }, // 11381
  { PseudoVXOR_VI_M2, VXOR_VI, 0x1 }, // 11382
  { PseudoVXOR_VI_M2_MASK, VXOR_VI, 0x1 }, // 11383
  { PseudoVXOR_VI_M2_TU, VXOR_VI, 0x1 }, // 11384
  { PseudoVXOR_VI_M4, VXOR_VI, 0x2 }, // 11385
  { PseudoVXOR_VI_M4_MASK, VXOR_VI, 0x2 }, // 11386
  { PseudoVXOR_VI_M4_TU, VXOR_VI, 0x2 }, // 11387
  { PseudoVXOR_VI_M8, VXOR_VI, 0x3 }, // 11388
  { PseudoVXOR_VI_M8_MASK, VXOR_VI, 0x3 }, // 11389
  { PseudoVXOR_VI_M8_TU, VXOR_VI, 0x3 }, // 11390
  { PseudoVXOR_VI_MF8, VXOR_VI, 0x5 }, // 11391
  { PseudoVXOR_VI_MF8_MASK, VXOR_VI, 0x5 }, // 11392
  { PseudoVXOR_VI_MF8_TU, VXOR_VI, 0x5 }, // 11393
  { PseudoVXOR_VI_MF4, VXOR_VI, 0x6 }, // 11394
  { PseudoVXOR_VI_MF4_MASK, VXOR_VI, 0x6 }, // 11395
  { PseudoVXOR_VI_MF4_TU, VXOR_VI, 0x6 }, // 11396
  { PseudoVXOR_VI_MF2, VXOR_VI, 0x7 }, // 11397
  { PseudoVXOR_VI_MF2_MASK, VXOR_VI, 0x7 }, // 11398
  { PseudoVXOR_VI_MF2_TU, VXOR_VI, 0x7 }, // 11399
  { PseudoVXOR_VV_M1, VXOR_VV, 0x0 }, // 11400
  { PseudoVXOR_VV_M1_MASK, VXOR_VV, 0x0 }, // 11401
  { PseudoVXOR_VV_M1_TU, VXOR_VV, 0x0 }, // 11402
  { PseudoVXOR_VV_M2, VXOR_VV, 0x1 }, // 11403
  { PseudoVXOR_VV_M2_MASK, VXOR_VV, 0x1 }, // 11404
  { PseudoVXOR_VV_M2_TU, VXOR_VV, 0x1 }, // 11405
  { PseudoVXOR_VV_M4, VXOR_VV, 0x2 }, // 11406
  { PseudoVXOR_VV_M4_MASK, VXOR_VV, 0x2 }, // 11407
  { PseudoVXOR_VV_M4_TU, VXOR_VV, 0x2 }, // 11408
  { PseudoVXOR_VV_M8, VXOR_VV, 0x3 }, // 11409
  { PseudoVXOR_VV_M8_MASK, VXOR_VV, 0x3 }, // 11410
  { PseudoVXOR_VV_M8_TU, VXOR_VV, 0x3 }, // 11411
  { PseudoVXOR_VV_MF8, VXOR_VV, 0x5 }, // 11412
  { PseudoVXOR_VV_MF8_MASK, VXOR_VV, 0x5 }, // 11413
  { PseudoVXOR_VV_MF8_TU, VXOR_VV, 0x5 }, // 11414
  { PseudoVXOR_VV_MF4, VXOR_VV, 0x6 }, // 11415
  { PseudoVXOR_VV_MF4_MASK, VXOR_VV, 0x6 }, // 11416
  { PseudoVXOR_VV_MF4_TU, VXOR_VV, 0x6 }, // 11417
  { PseudoVXOR_VV_MF2, VXOR_VV, 0x7 }, // 11418
  { PseudoVXOR_VV_MF2_MASK, VXOR_VV, 0x7 }, // 11419
  { PseudoVXOR_VV_MF2_TU, VXOR_VV, 0x7 }, // 11420
  { PseudoVXOR_VX_M1, VXOR_VX, 0x0 }, // 11421
  { PseudoVXOR_VX_M1_MASK, VXOR_VX, 0x0 }, // 11422
  { PseudoVXOR_VX_M1_TU, VXOR_VX, 0x0 }, // 11423
  { PseudoVXOR_VX_M2, VXOR_VX, 0x1 }, // 11424
  { PseudoVXOR_VX_M2_MASK, VXOR_VX, 0x1 }, // 11425
  { PseudoVXOR_VX_M2_TU, VXOR_VX, 0x1 }, // 11426
  { PseudoVXOR_VX_M4, VXOR_VX, 0x2 }, // 11427
  { PseudoVXOR_VX_M4_MASK, VXOR_VX, 0x2 }, // 11428
  { PseudoVXOR_VX_M4_TU, VXOR_VX, 0x2 }, // 11429
  { PseudoVXOR_VX_M8, VXOR_VX, 0x3 }, // 11430
  { PseudoVXOR_VX_M8_MASK, VXOR_VX, 0x3 }, // 11431
  { PseudoVXOR_VX_M8_TU, VXOR_VX, 0x3 }, // 11432
  { PseudoVXOR_VX_MF8, VXOR_VX, 0x5 }, // 11433
  { PseudoVXOR_VX_MF8_MASK, VXOR_VX, 0x5 }, // 11434
  { PseudoVXOR_VX_MF8_TU, VXOR_VX, 0x5 }, // 11435
  { PseudoVXOR_VX_MF4, VXOR_VX, 0x6 }, // 11436
  { PseudoVXOR_VX_MF4_MASK, VXOR_VX, 0x6 }, // 11437
  { PseudoVXOR_VX_MF4_TU, VXOR_VX, 0x6 }, // 11438
  { PseudoVXOR_VX_MF2, VXOR_VX, 0x7 }, // 11439
  { PseudoVXOR_VX_MF2_MASK, VXOR_VX, 0x7 }, // 11440
  { PseudoVXOR_VX_MF2_TU, VXOR_VX, 0x7 }, // 11441
  { PseudoVZEXT_VF2_M1, VZEXT_VF2, 0x0 }, // 11442
  { PseudoVZEXT_VF2_M1_MASK, VZEXT_VF2, 0x0 }, // 11443
  { PseudoVZEXT_VF2_M1_TU, VZEXT_VF2, 0x0 }, // 11444
  { PseudoVZEXT_VF2_M2, VZEXT_VF2, 0x1 }, // 11445
  { PseudoVZEXT_VF2_M2_MASK, VZEXT_VF2, 0x1 }, // 11446
  { PseudoVZEXT_VF2_M2_TU, VZEXT_VF2, 0x1 }, // 11447
  { PseudoVZEXT_VF2_M4, VZEXT_VF2, 0x2 }, // 11448
  { PseudoVZEXT_VF2_M4_MASK, VZEXT_VF2, 0x2 }, // 11449
  { PseudoVZEXT_VF2_M4_TU, VZEXT_VF2, 0x2 }, // 11450
  { PseudoVZEXT_VF2_M8, VZEXT_VF2, 0x3 }, // 11451
  { PseudoVZEXT_VF2_M8_MASK, VZEXT_VF2, 0x3 }, // 11452
  { PseudoVZEXT_VF2_M8_TU, VZEXT_VF2, 0x3 }, // 11453
  { PseudoVZEXT_VF2_MF4, VZEXT_VF2, 0x6 }, // 11454
  { PseudoVZEXT_VF2_MF4_MASK, VZEXT_VF2, 0x6 }, // 11455
  { PseudoVZEXT_VF2_MF4_TU, VZEXT_VF2, 0x6 }, // 11456
  { PseudoVZEXT_VF2_MF2, VZEXT_VF2, 0x7 }, // 11457
  { PseudoVZEXT_VF2_MF2_MASK, VZEXT_VF2, 0x7 }, // 11458
  { PseudoVZEXT_VF2_MF2_TU, VZEXT_VF2, 0x7 }, // 11459
  { PseudoVZEXT_VF4_M1, VZEXT_VF4, 0x0 }, // 11460
  { PseudoVZEXT_VF4_M1_MASK, VZEXT_VF4, 0x0 }, // 11461
  { PseudoVZEXT_VF4_M1_TU, VZEXT_VF4, 0x0 }, // 11462
  { PseudoVZEXT_VF4_M2, VZEXT_VF4, 0x1 }, // 11463
  { PseudoVZEXT_VF4_M2_MASK, VZEXT_VF4, 0x1 }, // 11464
  { PseudoVZEXT_VF4_M2_TU, VZEXT_VF4, 0x1 }, // 11465
  { PseudoVZEXT_VF4_M4, VZEXT_VF4, 0x2 }, // 11466
  { PseudoVZEXT_VF4_M4_MASK, VZEXT_VF4, 0x2 }, // 11467
  { PseudoVZEXT_VF4_M4_TU, VZEXT_VF4, 0x2 }, // 11468
  { PseudoVZEXT_VF4_M8, VZEXT_VF4, 0x3 }, // 11469
  { PseudoVZEXT_VF4_M8_MASK, VZEXT_VF4, 0x3 }, // 11470
  { PseudoVZEXT_VF4_M8_TU, VZEXT_VF4, 0x3 }, // 11471
  { PseudoVZEXT_VF4_MF2, VZEXT_VF4, 0x7 }, // 11472
  { PseudoVZEXT_VF4_MF2_MASK, VZEXT_VF4, 0x7 }, // 11473
  { PseudoVZEXT_VF4_MF2_TU, VZEXT_VF4, 0x7 }, // 11474
  { PseudoVZEXT_VF8_M1, VZEXT_VF8, 0x0 }, // 11475
  { PseudoVZEXT_VF8_M1_MASK, VZEXT_VF8, 0x0 }, // 11476
  { PseudoVZEXT_VF8_M1_TU, VZEXT_VF8, 0x0 }, // 11477
  { PseudoVZEXT_VF8_M2, VZEXT_VF8, 0x1 }, // 11478
  { PseudoVZEXT_VF8_M2_MASK, VZEXT_VF8, 0x1 }, // 11479
  { PseudoVZEXT_VF8_M2_TU, VZEXT_VF8, 0x1 }, // 11480
  { PseudoVZEXT_VF8_M4, VZEXT_VF8, 0x2 }, // 11481
  { PseudoVZEXT_VF8_M4_MASK, VZEXT_VF8, 0x2 }, // 11482
  { PseudoVZEXT_VF8_M4_TU, VZEXT_VF8, 0x2 }, // 11483
  { PseudoVZEXT_VF8_M8, VZEXT_VF8, 0x3 }, // 11484
  { PseudoVZEXT_VF8_M8_MASK, VZEXT_VF8, 0x3 }, // 11485
  { PseudoVZEXT_VF8_M8_TU, VZEXT_VF8, 0x3 }, // 11486
 };

const PseudoInfo *getBaseInfo(unsigned BaseInstr, uint8_t VLMul) {
  if ((BaseInstr < THVdotVMAQASU_VV) ||
      (BaseInstr > VZEXT_VF8))
    return nullptr;

  struct KeyType {
    unsigned BaseInstr;
    uint8_t VLMul;
  };
  KeyType Key = {BaseInstr, VLMul};
  auto Table = ArrayRef(RISCVVInversePseudosTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const PseudoInfo &LHS, const KeyType &RHS) {
      if (LHS.BaseInstr < RHS.BaseInstr)
        return true;
      if (LHS.BaseInstr > RHS.BaseInstr)
        return false;
      if (LHS.VLMul < RHS.VLMul)
        return true;
      if (LHS.VLMul > RHS.VLMul)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.BaseInstr != Idx->BaseInstr ||
      Key.VLMul != Idx->VLMul)
    return nullptr;
  return &*Idx;
}
#endif

#ifdef GET_RISCVVLETable_DECL
const VLEPseudo *getVLEPseudo(uint8_t Masked, uint8_t IsTU, uint8_t Strided, uint8_t FF, uint8_t Log2SEW, uint8_t LMUL);
#endif

#ifdef GET_RISCVVLETable_IMPL
constexpr VLEPseudo RISCVVLETable[] = {
  { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, PseudoVLM_V_B8 }, // 0
  { 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, PseudoVLM_V_B16 }, // 1
  { 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, PseudoVLM_V_B32 }, // 2
  { 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, PseudoVLM_V_B64 }, // 3
  { 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, PseudoVLM_V_B1 }, // 4
  { 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, PseudoVLM_V_B2 }, // 5
  { 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, PseudoVLM_V_B4 }, // 6
  { 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, PseudoVLE8_V_M1 }, // 7
  { 0x0, 0x0, 0x0, 0x0, 0x3, 0x1, PseudoVLE8_V_M2 }, // 8
  { 0x0, 0x0, 0x0, 0x0, 0x3, 0x2, PseudoVLE8_V_M4 }, // 9
  { 0x0, 0x0, 0x0, 0x0, 0x3, 0x3, PseudoVLE8_V_M8 }, // 10
  { 0x0, 0x0, 0x0, 0x0, 0x3, 0x5, PseudoVLE8_V_MF8 }, // 11
  { 0x0, 0x0, 0x0, 0x0, 0x3, 0x6, PseudoVLE8_V_MF4 }, // 12
  { 0x0, 0x0, 0x0, 0x0, 0x3, 0x7, PseudoVLE8_V_MF2 }, // 13
  { 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, PseudoVLE16_V_M1 }, // 14
  { 0x0, 0x0, 0x0, 0x0, 0x4, 0x1, PseudoVLE16_V_M2 }, // 15
  { 0x0, 0x0, 0x0, 0x0, 0x4, 0x2, PseudoVLE16_V_M4 }, // 16
  { 0x0, 0x0, 0x0, 0x0, 0x4, 0x3, PseudoVLE16_V_M8 }, // 17
  { 0x0, 0x0, 0x0, 0x0, 0x4, 0x6, PseudoVLE16_V_MF4 }, // 18
  { 0x0, 0x0, 0x0, 0x0, 0x4, 0x7, PseudoVLE16_V_MF2 }, // 19
  { 0x0, 0x0, 0x0, 0x0, 0x5, 0x0, PseudoVLE32_V_M1 }, // 20
  { 0x0, 0x0, 0x0, 0x0, 0x5, 0x1, PseudoVLE32_V_M2 }, // 21
  { 0x0, 0x0, 0x0, 0x0, 0x5, 0x2, PseudoVLE32_V_M4 }, // 22
  { 0x0, 0x0, 0x0, 0x0, 0x5, 0x3, PseudoVLE32_V_M8 }, // 23
  { 0x0, 0x0, 0x0, 0x0, 0x5, 0x7, PseudoVLE32_V_MF2 }, // 24
  { 0x0, 0x0, 0x0, 0x0, 0x6, 0x0, PseudoVLE64_V_M1 }, // 25
  { 0x0, 0x0, 0x0, 0x0, 0x6, 0x1, PseudoVLE64_V_M2 }, // 26
  { 0x0, 0x0, 0x0, 0x0, 0x6, 0x2, PseudoVLE64_V_M4 }, // 27
  { 0x0, 0x0, 0x0, 0x0, 0x6, 0x3, PseudoVLE64_V_M8 }, // 28
  { 0x0, 0x0, 0x0, 0x1, 0x3, 0x0, PseudoVLE8FF_V_M1 }, // 29
  { 0x0, 0x0, 0x0, 0x1, 0x3, 0x1, PseudoVLE8FF_V_M2 }, // 30
  { 0x0, 0x0, 0x0, 0x1, 0x3, 0x2, PseudoVLE8FF_V_M4 }, // 31
  { 0x0, 0x0, 0x0, 0x1, 0x3, 0x3, PseudoVLE8FF_V_M8 }, // 32
  { 0x0, 0x0, 0x0, 0x1, 0x3, 0x5, PseudoVLE8FF_V_MF8 }, // 33
  { 0x0, 0x0, 0x0, 0x1, 0x3, 0x6, PseudoVLE8FF_V_MF4 }, // 34
  { 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, PseudoVLE8FF_V_MF2 }, // 35
  { 0x0, 0x0, 0x0, 0x1, 0x4, 0x0, PseudoVLE16FF_V_M1 }, // 36
  { 0x0, 0x0, 0x0, 0x1, 0x4, 0x1, PseudoVLE16FF_V_M2 }, // 37
  { 0x0, 0x0, 0x0, 0x1, 0x4, 0x2, PseudoVLE16FF_V_M4 }, // 38
  { 0x0, 0x0, 0x0, 0x1, 0x4, 0x3, PseudoVLE16FF_V_M8 }, // 39
  { 0x0, 0x0, 0x0, 0x1, 0x4, 0x6, PseudoVLE16FF_V_MF4 }, // 40
  { 0x0, 0x0, 0x0, 0x1, 0x4, 0x7, PseudoVLE16FF_V_MF2 }, // 41
  { 0x0, 0x0, 0x0, 0x1, 0x5, 0x0, PseudoVLE32FF_V_M1 }, // 42
  { 0x0, 0x0, 0x0, 0x1, 0x5, 0x1, PseudoVLE32FF_V_M2 }, // 43
  { 0x0, 0x0, 0x0, 0x1, 0x5, 0x2, PseudoVLE32FF_V_M4 }, // 44
  { 0x0, 0x0, 0x0, 0x1, 0x5, 0x3, PseudoVLE32FF_V_M8 }, // 45
  { 0x0, 0x0, 0x0, 0x1, 0x5, 0x7, PseudoVLE32FF_V_MF2 }, // 46
  { 0x0, 0x0, 0x0, 0x1, 0x6, 0x0, PseudoVLE64FF_V_M1 }, // 47
  { 0x0, 0x0, 0x0, 0x1, 0x6, 0x1, PseudoVLE64FF_V_M2 }, // 48
  { 0x0, 0x0, 0x0, 0x1, 0x6, 0x2, PseudoVLE64FF_V_M4 }, // 49
  { 0x0, 0x0, 0x0, 0x1, 0x6, 0x3, PseudoVLE64FF_V_M8 }, // 50
  { 0x0, 0x0, 0x1, 0x0, 0x3, 0x0, PseudoVLSE8_V_M1 }, // 51
  { 0x0, 0x0, 0x1, 0x0, 0x3, 0x1, PseudoVLSE8_V_M2 }, // 52
  { 0x0, 0x0, 0x1, 0x0, 0x3, 0x2, PseudoVLSE8_V_M4 }, // 53
  { 0x0, 0x0, 0x1, 0x0, 0x3, 0x3, PseudoVLSE8_V_M8 }, // 54
  { 0x0, 0x0, 0x1, 0x0, 0x3, 0x5, PseudoVLSE8_V_MF8 }, // 55
  { 0x0, 0x0, 0x1, 0x0, 0x3, 0x6, PseudoVLSE8_V_MF4 }, // 56
  { 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, PseudoVLSE8_V_MF2 }, // 57
  { 0x0, 0x0, 0x1, 0x0, 0x4, 0x0, PseudoVLSE16_V_M1 }, // 58
  { 0x0, 0x0, 0x1, 0x0, 0x4, 0x1, PseudoVLSE16_V_M2 }, // 59
  { 0x0, 0x0, 0x1, 0x0, 0x4, 0x2, PseudoVLSE16_V_M4 }, // 60
  { 0x0, 0x0, 0x1, 0x0, 0x4, 0x3, PseudoVLSE16_V_M8 }, // 61
  { 0x0, 0x0, 0x1, 0x0, 0x4, 0x6, PseudoVLSE16_V_MF4 }, // 62
  { 0x0, 0x0, 0x1, 0x0, 0x4, 0x7, PseudoVLSE16_V_MF2 }, // 63
  { 0x0, 0x0, 0x1, 0x0, 0x5, 0x0, PseudoVLSE32_V_M1 }, // 64
  { 0x0, 0x0, 0x1, 0x0, 0x5, 0x1, PseudoVLSE32_V_M2 }, // 65
  { 0x0, 0x0, 0x1, 0x0, 0x5, 0x2, PseudoVLSE32_V_M4 }, // 66
  { 0x0, 0x0, 0x1, 0x0, 0x5, 0x3, PseudoVLSE32_V_M8 }, // 67
  { 0x0, 0x0, 0x1, 0x0, 0x5, 0x7, PseudoVLSE32_V_MF2 }, // 68
  { 0x0, 0x0, 0x1, 0x0, 0x6, 0x0, PseudoVLSE64_V_M1 }, // 69
  { 0x0, 0x0, 0x1, 0x0, 0x6, 0x1, PseudoVLSE64_V_M2 }, // 70
  { 0x0, 0x0, 0x1, 0x0, 0x6, 0x2, PseudoVLSE64_V_M4 }, // 71
  { 0x0, 0x0, 0x1, 0x0, 0x6, 0x3, PseudoVLSE64_V_M8 }, // 72
  { 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, PseudoVLE8_V_M1_TU }, // 73
  { 0x0, 0x1, 0x0, 0x0, 0x3, 0x1, PseudoVLE8_V_M2_TU }, // 74
  { 0x0, 0x1, 0x0, 0x0, 0x3, 0x2, PseudoVLE8_V_M4_TU }, // 75
  { 0x0, 0x1, 0x0, 0x0, 0x3, 0x3, PseudoVLE8_V_M8_TU }, // 76
  { 0x0, 0x1, 0x0, 0x0, 0x3, 0x5, PseudoVLE8_V_MF8_TU }, // 77
  { 0x0, 0x1, 0x0, 0x0, 0x3, 0x6, PseudoVLE8_V_MF4_TU }, // 78
  { 0x0, 0x1, 0x0, 0x0, 0x3, 0x7, PseudoVLE8_V_MF2_TU }, // 79
  { 0x0, 0x1, 0x0, 0x0, 0x4, 0x0, PseudoVLE16_V_M1_TU }, // 80
  { 0x0, 0x1, 0x0, 0x0, 0x4, 0x1, PseudoVLE16_V_M2_TU }, // 81
  { 0x0, 0x1, 0x0, 0x0, 0x4, 0x2, PseudoVLE16_V_M4_TU }, // 82
  { 0x0, 0x1, 0x0, 0x0, 0x4, 0x3, PseudoVLE16_V_M8_TU }, // 83
  { 0x0, 0x1, 0x0, 0x0, 0x4, 0x6, PseudoVLE16_V_MF4_TU }, // 84
  { 0x0, 0x1, 0x0, 0x0, 0x4, 0x7, PseudoVLE16_V_MF2_TU }, // 85
  { 0x0, 0x1, 0x0, 0x0, 0x5, 0x0, PseudoVLE32_V_M1_TU }, // 86
  { 0x0, 0x1, 0x0, 0x0, 0x5, 0x1, PseudoVLE32_V_M2_TU }, // 87
  { 0x0, 0x1, 0x0, 0x0, 0x5, 0x2, PseudoVLE32_V_M4_TU }, // 88
  { 0x0, 0x1, 0x0, 0x0, 0x5, 0x3, PseudoVLE32_V_M8_TU }, // 89
  { 0x0, 0x1, 0x0, 0x0, 0x5, 0x7, PseudoVLE32_V_MF2_TU }, // 90
  { 0x0, 0x1, 0x0, 0x0, 0x6, 0x0, PseudoVLE64_V_M1_TU }, // 91
  { 0x0, 0x1, 0x0, 0x0, 0x6, 0x1, PseudoVLE64_V_M2_TU }, // 92
  { 0x0, 0x1, 0x0, 0x0, 0x6, 0x2, PseudoVLE64_V_M4_TU }, // 93
  { 0x0, 0x1, 0x0, 0x0, 0x6, 0x3, PseudoVLE64_V_M8_TU }, // 94
  { 0x0, 0x1, 0x0, 0x1, 0x3, 0x0, PseudoVLE8FF_V_M1_TU }, // 95
  { 0x0, 0x1, 0x0, 0x1, 0x3, 0x1, PseudoVLE8FF_V_M2_TU }, // 96
  { 0x0, 0x1, 0x0, 0x1, 0x3, 0x2, PseudoVLE8FF_V_M4_TU }, // 97
  { 0x0, 0x1, 0x0, 0x1, 0x3, 0x3, PseudoVLE8FF_V_M8_TU }, // 98
  { 0x0, 0x1, 0x0, 0x1, 0x3, 0x5, PseudoVLE8FF_V_MF8_TU }, // 99
  { 0x0, 0x1, 0x0, 0x1, 0x3, 0x6, PseudoVLE8FF_V_MF4_TU }, // 100
  { 0x0, 0x1, 0x0, 0x1, 0x3, 0x7, PseudoVLE8FF_V_MF2_TU }, // 101
  { 0x0, 0x1, 0x0, 0x1, 0x4, 0x0, PseudoVLE16FF_V_M1_TU }, // 102
  { 0x0, 0x1, 0x0, 0x1, 0x4, 0x1, PseudoVLE16FF_V_M2_TU }, // 103
  { 0x0, 0x1, 0x0, 0x1, 0x4, 0x2, PseudoVLE16FF_V_M4_TU }, // 104
  { 0x0, 0x1, 0x0, 0x1, 0x4, 0x3, PseudoVLE16FF_V_M8_TU }, // 105
  { 0x0, 0x1, 0x0, 0x1, 0x4, 0x6, PseudoVLE16FF_V_MF4_TU }, // 106
  { 0x0, 0x1, 0x0, 0x1, 0x4, 0x7, PseudoVLE16FF_V_MF2_TU }, // 107
  { 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, PseudoVLE32FF_V_M1_TU }, // 108
  { 0x0, 0x1, 0x0, 0x1, 0x5, 0x1, PseudoVLE32FF_V_M2_TU }, // 109
  { 0x0, 0x1, 0x0, 0x1, 0x5, 0x2, PseudoVLE32FF_V_M4_TU }, // 110
  { 0x0, 0x1, 0x0, 0x1, 0x5, 0x3, PseudoVLE32FF_V_M8_TU }, // 111
  { 0x0, 0x1, 0x0, 0x1, 0x5, 0x7, PseudoVLE32FF_V_MF2_TU }, // 112
  { 0x0, 0x1, 0x0, 0x1, 0x6, 0x0, PseudoVLE64FF_V_M1_TU }, // 113
  { 0x0, 0x1, 0x0, 0x1, 0x6, 0x1, PseudoVLE64FF_V_M2_TU }, // 114
  { 0x0, 0x1, 0x0, 0x1, 0x6, 0x2, PseudoVLE64FF_V_M4_TU }, // 115
  { 0x0, 0x1, 0x0, 0x1, 0x6, 0x3, PseudoVLE64FF_V_M8_TU }, // 116
  { 0x0, 0x1, 0x1, 0x0, 0x3, 0x0, PseudoVLSE8_V_M1_TU }, // 117
  { 0x0, 0x1, 0x1, 0x0, 0x3, 0x1, PseudoVLSE8_V_M2_TU }, // 118
  { 0x0, 0x1, 0x1, 0x0, 0x3, 0x2, PseudoVLSE8_V_M4_TU }, // 119
  { 0x0, 0x1, 0x1, 0x0, 0x3, 0x3, PseudoVLSE8_V_M8_TU }, // 120
  { 0x0, 0x1, 0x1, 0x0, 0x3, 0x5, PseudoVLSE8_V_MF8_TU }, // 121
  { 0x0, 0x1, 0x1, 0x0, 0x3, 0x6, PseudoVLSE8_V_MF4_TU }, // 122
  { 0x0, 0x1, 0x1, 0x0, 0x3, 0x7, PseudoVLSE8_V_MF2_TU }, // 123
  { 0x0, 0x1, 0x1, 0x0, 0x4, 0x0, PseudoVLSE16_V_M1_TU }, // 124
  { 0x0, 0x1, 0x1, 0x0, 0x4, 0x1, PseudoVLSE16_V_M2_TU }, // 125
  { 0x0, 0x1, 0x1, 0x0, 0x4, 0x2, PseudoVLSE16_V_M4_TU }, // 126
  { 0x0, 0x1, 0x1, 0x0, 0x4, 0x3, PseudoVLSE16_V_M8_TU }, // 127
  { 0x0, 0x1, 0x1, 0x0, 0x4, 0x6, PseudoVLSE16_V_MF4_TU }, // 128
  { 0x0, 0x1, 0x1, 0x0, 0x4, 0x7, PseudoVLSE16_V_MF2_TU }, // 129
  { 0x0, 0x1, 0x1, 0x0, 0x5, 0x0, PseudoVLSE32_V_M1_TU }, // 130
  { 0x0, 0x1, 0x1, 0x0, 0x5, 0x1, PseudoVLSE32_V_M2_TU }, // 131
  { 0x0, 0x1, 0x1, 0x0, 0x5, 0x2, PseudoVLSE32_V_M4_TU }, // 132
  { 0x0, 0x1, 0x1, 0x0, 0x5, 0x3, PseudoVLSE32_V_M8_TU }, // 133
  { 0x0, 0x1, 0x1, 0x0, 0x5, 0x7, PseudoVLSE32_V_MF2_TU }, // 134
  { 0x0, 0x1, 0x1, 0x0, 0x6, 0x0, PseudoVLSE64_V_M1_TU }, // 135
  { 0x0, 0x1, 0x1, 0x0, 0x6, 0x1, PseudoVLSE64_V_M2_TU }, // 136
  { 0x0, 0x1, 0x1, 0x0, 0x6, 0x2, PseudoVLSE64_V_M4_TU }, // 137
  { 0x0, 0x1, 0x1, 0x0, 0x6, 0x3, PseudoVLSE64_V_M8_TU }, // 138
  { 0x1, 0x1, 0x0, 0x0, 0x3, 0x0, PseudoVLE8_V_M1_MASK }, // 139
  { 0x1, 0x1, 0x0, 0x0, 0x3, 0x1, PseudoVLE8_V_M2_MASK }, // 140
  { 0x1, 0x1, 0x0, 0x0, 0x3, 0x2, PseudoVLE8_V_M4_MASK }, // 141
  { 0x1, 0x1, 0x0, 0x0, 0x3, 0x3, PseudoVLE8_V_M8_MASK }, // 142
  { 0x1, 0x1, 0x0, 0x0, 0x3, 0x5, PseudoVLE8_V_MF8_MASK }, // 143
  { 0x1, 0x1, 0x0, 0x0, 0x3, 0x6, PseudoVLE8_V_MF4_MASK }, // 144
  { 0x1, 0x1, 0x0, 0x0, 0x3, 0x7, PseudoVLE8_V_MF2_MASK }, // 145
  { 0x1, 0x1, 0x0, 0x0, 0x4, 0x0, PseudoVLE16_V_M1_MASK }, // 146
  { 0x1, 0x1, 0x0, 0x0, 0x4, 0x1, PseudoVLE16_V_M2_MASK }, // 147
  { 0x1, 0x1, 0x0, 0x0, 0x4, 0x2, PseudoVLE16_V_M4_MASK }, // 148
  { 0x1, 0x1, 0x0, 0x0, 0x4, 0x3, PseudoVLE16_V_M8_MASK }, // 149
  { 0x1, 0x1, 0x0, 0x0, 0x4, 0x6, PseudoVLE16_V_MF4_MASK }, // 150
  { 0x1, 0x1, 0x0, 0x0, 0x4, 0x7, PseudoVLE16_V_MF2_MASK }, // 151
  { 0x1, 0x1, 0x0, 0x0, 0x5, 0x0, PseudoVLE32_V_M1_MASK }, // 152
  { 0x1, 0x1, 0x0, 0x0, 0x5, 0x1, PseudoVLE32_V_M2_MASK }, // 153
  { 0x1, 0x1, 0x0, 0x0, 0x5, 0x2, PseudoVLE32_V_M4_MASK }, // 154
  { 0x1, 0x1, 0x0, 0x0, 0x5, 0x3, PseudoVLE32_V_M8_MASK }, // 155
  { 0x1, 0x1, 0x0, 0x0, 0x5, 0x7, PseudoVLE32_V_MF2_MASK }, // 156
  { 0x1, 0x1, 0x0, 0x0, 0x6, 0x0, PseudoVLE64_V_M1_MASK }, // 157
  { 0x1, 0x1, 0x0, 0x0, 0x6, 0x1, PseudoVLE64_V_M2_MASK }, // 158
  { 0x1, 0x1, 0x0, 0x0, 0x6, 0x2, PseudoVLE64_V_M4_MASK }, // 159
  { 0x1, 0x1, 0x0, 0x0, 0x6, 0x3, PseudoVLE64_V_M8_MASK }, // 160
  { 0x1, 0x1, 0x0, 0x1, 0x3, 0x0, PseudoVLE8FF_V_M1_MASK }, // 161
  { 0x1, 0x1, 0x0, 0x1, 0x3, 0x1, PseudoVLE8FF_V_M2_MASK }, // 162
  { 0x1, 0x1, 0x0, 0x1, 0x3, 0x2, PseudoVLE8FF_V_M4_MASK }, // 163
  { 0x1, 0x1, 0x0, 0x1, 0x3, 0x3, PseudoVLE8FF_V_M8_MASK }, // 164
  { 0x1, 0x1, 0x0, 0x1, 0x3, 0x5, PseudoVLE8FF_V_MF8_MASK }, // 165
  { 0x1, 0x1, 0x0, 0x1, 0x3, 0x6, PseudoVLE8FF_V_MF4_MASK }, // 166
  { 0x1, 0x1, 0x0, 0x1, 0x3, 0x7, PseudoVLE8FF_V_MF2_MASK }, // 167
  { 0x1, 0x1, 0x0, 0x1, 0x4, 0x0, PseudoVLE16FF_V_M1_MASK }, // 168
  { 0x1, 0x1, 0x0, 0x1, 0x4, 0x1, PseudoVLE16FF_V_M2_MASK }, // 169
  { 0x1, 0x1, 0x0, 0x1, 0x4, 0x2, PseudoVLE16FF_V_M4_MASK }, // 170
  { 0x1, 0x1, 0x0, 0x1, 0x4, 0x3, PseudoVLE16FF_V_M8_MASK }, // 171
  { 0x1, 0x1, 0x0, 0x1, 0x4, 0x6, PseudoVLE16FF_V_MF4_MASK }, // 172
  { 0x1, 0x1, 0x0, 0x1, 0x4, 0x7, PseudoVLE16FF_V_MF2_MASK }, // 173
  { 0x1, 0x1, 0x0, 0x1, 0x5, 0x0, PseudoVLE32FF_V_M1_MASK }, // 174
  { 0x1, 0x1, 0x0, 0x1, 0x5, 0x1, PseudoVLE32FF_V_M2_MASK }, // 175
  { 0x1, 0x1, 0x0, 0x1, 0x5, 0x2, PseudoVLE32FF_V_M4_MASK }, // 176
  { 0x1, 0x1, 0x0, 0x1, 0x5, 0x3, PseudoVLE32FF_V_M8_MASK }, // 177
  { 0x1, 0x1, 0x0, 0x1, 0x5, 0x7, PseudoVLE32FF_V_MF2_MASK }, // 178
  { 0x1, 0x1, 0x0, 0x1, 0x6, 0x0, PseudoVLE64FF_V_M1_MASK }, // 179
  { 0x1, 0x1, 0x0, 0x1, 0x6, 0x1, PseudoVLE64FF_V_M2_MASK }, // 180
  { 0x1, 0x1, 0x0, 0x1, 0x6, 0x2, PseudoVLE64FF_V_M4_MASK }, // 181
  { 0x1, 0x1, 0x0, 0x1, 0x6, 0x3, PseudoVLE64FF_V_M8_MASK }, // 182
  { 0x1, 0x1, 0x1, 0x0, 0x3, 0x0, PseudoVLSE8_V_M1_MASK }, // 183
  { 0x1, 0x1, 0x1, 0x0, 0x3, 0x1, PseudoVLSE8_V_M2_MASK }, // 184
  { 0x1, 0x1, 0x1, 0x0, 0x3, 0x2, PseudoVLSE8_V_M4_MASK }, // 185
  { 0x1, 0x1, 0x1, 0x0, 0x3, 0x3, PseudoVLSE8_V_M8_MASK }, // 186
  { 0x1, 0x1, 0x1, 0x0, 0x3, 0x5, PseudoVLSE8_V_MF8_MASK }, // 187
  { 0x1, 0x1, 0x1, 0x0, 0x3, 0x6, PseudoVLSE8_V_MF4_MASK }, // 188
  { 0x1, 0x1, 0x1, 0x0, 0x3, 0x7, PseudoVLSE8_V_MF2_MASK }, // 189
  { 0x1, 0x1, 0x1, 0x0, 0x4, 0x0, PseudoVLSE16_V_M1_MASK }, // 190
  { 0x1, 0x1, 0x1, 0x0, 0x4, 0x1, PseudoVLSE16_V_M2_MASK }, // 191
  { 0x1, 0x1, 0x1, 0x0, 0x4, 0x2, PseudoVLSE16_V_M4_MASK }, // 192
  { 0x1, 0x1, 0x1, 0x0, 0x4, 0x3, PseudoVLSE16_V_M8_MASK }, // 193
  { 0x1, 0x1, 0x1, 0x0, 0x4, 0x6, PseudoVLSE16_V_MF4_MASK }, // 194
  { 0x1, 0x1, 0x1, 0x0, 0x4, 0x7, PseudoVLSE16_V_MF2_MASK }, // 195
  { 0x1, 0x1, 0x1, 0x0, 0x5, 0x0, PseudoVLSE32_V_M1_MASK }, // 196
  { 0x1, 0x1, 0x1, 0x0, 0x5, 0x1, PseudoVLSE32_V_M2_MASK }, // 197
  { 0x1, 0x1, 0x1, 0x0, 0x5, 0x2, PseudoVLSE32_V_M4_MASK }, // 198
  { 0x1, 0x1, 0x1, 0x0, 0x5, 0x3, PseudoVLSE32_V_M8_MASK }, // 199
  { 0x1, 0x1, 0x1, 0x0, 0x5, 0x7, PseudoVLSE32_V_MF2_MASK }, // 200
  { 0x1, 0x1, 0x1, 0x0, 0x6, 0x0, PseudoVLSE64_V_M1_MASK }, // 201
  { 0x1, 0x1, 0x1, 0x0, 0x6, 0x1, PseudoVLSE64_V_M2_MASK }, // 202
  { 0x1, 0x1, 0x1, 0x0, 0x6, 0x2, PseudoVLSE64_V_M4_MASK }, // 203
  { 0x1, 0x1, 0x1, 0x0, 0x6, 0x3, PseudoVLSE64_V_M8_MASK }, // 204
 };

const VLEPseudo *getVLEPseudo(uint8_t Masked, uint8_t IsTU, uint8_t Strided, uint8_t FF, uint8_t Log2SEW, uint8_t LMUL) {
  struct KeyType {
    uint8_t Masked;
    uint8_t IsTU;
    uint8_t Strided;
    uint8_t FF;
    uint8_t Log2SEW;
    uint8_t LMUL;
  };
  KeyType Key = {Masked, IsTU, Strided, FF, Log2SEW, LMUL};
  auto Table = ArrayRef(RISCVVLETable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const VLEPseudo &LHS, const KeyType &RHS) {
      if (LHS.Masked < RHS.Masked)
        return true;
      if (LHS.Masked > RHS.Masked)
        return false;
      if (LHS.IsTU < RHS.IsTU)
        return true;
      if (LHS.IsTU > RHS.IsTU)
        return false;
      if (LHS.Strided < RHS.Strided)
        return true;
      if (LHS.Strided > RHS.Strided)
        return false;
      if (LHS.FF < RHS.FF)
        return true;
      if (LHS.FF > RHS.FF)
        return false;
      if (LHS.Log2SEW < RHS.Log2SEW)
        return true;
      if (LHS.Log2SEW > RHS.Log2SEW)
        return false;
      if (LHS.LMUL < RHS.LMUL)
        return true;
      if (LHS.LMUL > RHS.LMUL)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Masked != Idx->Masked ||
      Key.IsTU != Idx->IsTU ||
      Key.Strided != Idx->Strided ||
      Key.FF != Idx->FF ||
      Key.Log2SEW != Idx->Log2SEW ||
      Key.LMUL != Idx->LMUL)
    return nullptr;
  return &*Idx;
}
#endif

#ifdef GET_RISCVVLSEGTable_DECL
const VLSEGPseudo *getVLSEGPseudo(uint8_t NF, uint8_t Masked, uint8_t IsTU, uint8_t Strided, uint8_t FF, uint8_t Log2SEW, uint8_t LMUL);
#endif

#ifdef GET_RISCVVLSEGTable_IMPL
constexpr VLSEGPseudo RISCVVLSEGTable[] = {
  { 0x2, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG2E8_V_M1 }, // 0
  { 0x2, 0x0, 0x0, 0x0, 0x0, 0x3, 0x1, PseudoVLSEG2E8_V_M2 }, // 1
  { 0x2, 0x0, 0x0, 0x0, 0x0, 0x3, 0x2, PseudoVLSEG2E8_V_M4 }, // 2
  { 0x2, 0x0, 0x0, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG2E8_V_MF8 }, // 3
  { 0x2, 0x0, 0x0, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG2E8_V_MF4 }, // 4
  { 0x2, 0x0, 0x0, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG2E8_V_MF2 }, // 5
  { 0x2, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG2E16_V_M1 }, // 6
  { 0x2, 0x0, 0x0, 0x0, 0x0, 0x4, 0x1, PseudoVLSEG2E16_V_M2 }, // 7
  { 0x2, 0x0, 0x0, 0x0, 0x0, 0x4, 0x2, PseudoVLSEG2E16_V_M4 }, // 8
  { 0x2, 0x0, 0x0, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG2E16_V_MF4 }, // 9
  { 0x2, 0x0, 0x0, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG2E16_V_MF2 }, // 10
  { 0x2, 0x0, 0x0, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG2E32_V_M1 }, // 11
  { 0x2, 0x0, 0x0, 0x0, 0x0, 0x5, 0x1, PseudoVLSEG2E32_V_M2 }, // 12
  { 0x2, 0x0, 0x0, 0x0, 0x0, 0x5, 0x2, PseudoVLSEG2E32_V_M4 }, // 13
  { 0x2, 0x0, 0x0, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG2E32_V_MF2 }, // 14
  { 0x2, 0x0, 0x0, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG2E64_V_M1 }, // 15
  { 0x2, 0x0, 0x0, 0x0, 0x0, 0x6, 0x1, PseudoVLSEG2E64_V_M2 }, // 16
  { 0x2, 0x0, 0x0, 0x0, 0x0, 0x6, 0x2, PseudoVLSEG2E64_V_M4 }, // 17
  { 0x2, 0x0, 0x0, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG2E8FF_V_M1 }, // 18
  { 0x2, 0x0, 0x0, 0x0, 0x1, 0x3, 0x1, PseudoVLSEG2E8FF_V_M2 }, // 19
  { 0x2, 0x0, 0x0, 0x0, 0x1, 0x3, 0x2, PseudoVLSEG2E8FF_V_M4 }, // 20
  { 0x2, 0x0, 0x0, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG2E8FF_V_MF8 }, // 21
  { 0x2, 0x0, 0x0, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG2E8FF_V_MF4 }, // 22
  { 0x2, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG2E8FF_V_MF2 }, // 23
  { 0x2, 0x0, 0x0, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG2E16FF_V_M1 }, // 24
  { 0x2, 0x0, 0x0, 0x0, 0x1, 0x4, 0x1, PseudoVLSEG2E16FF_V_M2 }, // 25
  { 0x2, 0x0, 0x0, 0x0, 0x1, 0x4, 0x2, PseudoVLSEG2E16FF_V_M4 }, // 26
  { 0x2, 0x0, 0x0, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG2E16FF_V_MF4 }, // 27
  { 0x2, 0x0, 0x0, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG2E16FF_V_MF2 }, // 28
  { 0x2, 0x0, 0x0, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG2E32FF_V_M1 }, // 29
  { 0x2, 0x0, 0x0, 0x0, 0x1, 0x5, 0x1, PseudoVLSEG2E32FF_V_M2 }, // 30
  { 0x2, 0x0, 0x0, 0x0, 0x1, 0x5, 0x2, PseudoVLSEG2E32FF_V_M4 }, // 31
  { 0x2, 0x0, 0x0, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG2E32FF_V_MF2 }, // 32
  { 0x2, 0x0, 0x0, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG2E64FF_V_M1 }, // 33
  { 0x2, 0x0, 0x0, 0x0, 0x1, 0x6, 0x1, PseudoVLSEG2E64FF_V_M2 }, // 34
  { 0x2, 0x0, 0x0, 0x0, 0x1, 0x6, 0x2, PseudoVLSEG2E64FF_V_M4 }, // 35
  { 0x2, 0x0, 0x0, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG2E8_V_M1 }, // 36
  { 0x2, 0x0, 0x0, 0x1, 0x0, 0x3, 0x1, PseudoVLSSEG2E8_V_M2 }, // 37
  { 0x2, 0x0, 0x0, 0x1, 0x0, 0x3, 0x2, PseudoVLSSEG2E8_V_M4 }, // 38
  { 0x2, 0x0, 0x0, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG2E8_V_MF8 }, // 39
  { 0x2, 0x0, 0x0, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG2E8_V_MF4 }, // 40
  { 0x2, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG2E8_V_MF2 }, // 41
  { 0x2, 0x0, 0x0, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG2E16_V_M1 }, // 42
  { 0x2, 0x0, 0x0, 0x1, 0x0, 0x4, 0x1, PseudoVLSSEG2E16_V_M2 }, // 43
  { 0x2, 0x0, 0x0, 0x1, 0x0, 0x4, 0x2, PseudoVLSSEG2E16_V_M4 }, // 44
  { 0x2, 0x0, 0x0, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG2E16_V_MF4 }, // 45
  { 0x2, 0x0, 0x0, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG2E16_V_MF2 }, // 46
  { 0x2, 0x0, 0x0, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG2E32_V_M1 }, // 47
  { 0x2, 0x0, 0x0, 0x1, 0x0, 0x5, 0x1, PseudoVLSSEG2E32_V_M2 }, // 48
  { 0x2, 0x0, 0x0, 0x1, 0x0, 0x5, 0x2, PseudoVLSSEG2E32_V_M4 }, // 49
  { 0x2, 0x0, 0x0, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG2E32_V_MF2 }, // 50
  { 0x2, 0x0, 0x0, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG2E64_V_M1 }, // 51
  { 0x2, 0x0, 0x0, 0x1, 0x0, 0x6, 0x1, PseudoVLSSEG2E64_V_M2 }, // 52
  { 0x2, 0x0, 0x0, 0x1, 0x0, 0x6, 0x2, PseudoVLSSEG2E64_V_M4 }, // 53
  { 0x2, 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG2E8_V_M1_TU }, // 54
  { 0x2, 0x0, 0x1, 0x0, 0x0, 0x3, 0x1, PseudoVLSEG2E8_V_M2_TU }, // 55
  { 0x2, 0x0, 0x1, 0x0, 0x0, 0x3, 0x2, PseudoVLSEG2E8_V_M4_TU }, // 56
  { 0x2, 0x0, 0x1, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG2E8_V_MF8_TU }, // 57
  { 0x2, 0x0, 0x1, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG2E8_V_MF4_TU }, // 58
  { 0x2, 0x0, 0x1, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG2E8_V_MF2_TU }, // 59
  { 0x2, 0x0, 0x1, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG2E16_V_M1_TU }, // 60
  { 0x2, 0x0, 0x1, 0x0, 0x0, 0x4, 0x1, PseudoVLSEG2E16_V_M2_TU }, // 61
  { 0x2, 0x0, 0x1, 0x0, 0x0, 0x4, 0x2, PseudoVLSEG2E16_V_M4_TU }, // 62
  { 0x2, 0x0, 0x1, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG2E16_V_MF4_TU }, // 63
  { 0x2, 0x0, 0x1, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG2E16_V_MF2_TU }, // 64
  { 0x2, 0x0, 0x1, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG2E32_V_M1_TU }, // 65
  { 0x2, 0x0, 0x1, 0x0, 0x0, 0x5, 0x1, PseudoVLSEG2E32_V_M2_TU }, // 66
  { 0x2, 0x0, 0x1, 0x0, 0x0, 0x5, 0x2, PseudoVLSEG2E32_V_M4_TU }, // 67
  { 0x2, 0x0, 0x1, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG2E32_V_MF2_TU }, // 68
  { 0x2, 0x0, 0x1, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG2E64_V_M1_TU }, // 69
  { 0x2, 0x0, 0x1, 0x0, 0x0, 0x6, 0x1, PseudoVLSEG2E64_V_M2_TU }, // 70
  { 0x2, 0x0, 0x1, 0x0, 0x0, 0x6, 0x2, PseudoVLSEG2E64_V_M4_TU }, // 71
  { 0x2, 0x0, 0x1, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG2E8FF_V_M1_TU }, // 72
  { 0x2, 0x0, 0x1, 0x0, 0x1, 0x3, 0x1, PseudoVLSEG2E8FF_V_M2_TU }, // 73
  { 0x2, 0x0, 0x1, 0x0, 0x1, 0x3, 0x2, PseudoVLSEG2E8FF_V_M4_TU }, // 74
  { 0x2, 0x0, 0x1, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG2E8FF_V_MF8_TU }, // 75
  { 0x2, 0x0, 0x1, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG2E8FF_V_MF4_TU }, // 76
  { 0x2, 0x0, 0x1, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG2E8FF_V_MF2_TU }, // 77
  { 0x2, 0x0, 0x1, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG2E16FF_V_M1_TU }, // 78
  { 0x2, 0x0, 0x1, 0x0, 0x1, 0x4, 0x1, PseudoVLSEG2E16FF_V_M2_TU }, // 79
  { 0x2, 0x0, 0x1, 0x0, 0x1, 0x4, 0x2, PseudoVLSEG2E16FF_V_M4_TU }, // 80
  { 0x2, 0x0, 0x1, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG2E16FF_V_MF4_TU }, // 81
  { 0x2, 0x0, 0x1, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG2E16FF_V_MF2_TU }, // 82
  { 0x2, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG2E32FF_V_M1_TU }, // 83
  { 0x2, 0x0, 0x1, 0x0, 0x1, 0x5, 0x1, PseudoVLSEG2E32FF_V_M2_TU }, // 84
  { 0x2, 0x0, 0x1, 0x0, 0x1, 0x5, 0x2, PseudoVLSEG2E32FF_V_M4_TU }, // 85
  { 0x2, 0x0, 0x1, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG2E32FF_V_MF2_TU }, // 86
  { 0x2, 0x0, 0x1, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG2E64FF_V_M1_TU }, // 87
  { 0x2, 0x0, 0x1, 0x0, 0x1, 0x6, 0x1, PseudoVLSEG2E64FF_V_M2_TU }, // 88
  { 0x2, 0x0, 0x1, 0x0, 0x1, 0x6, 0x2, PseudoVLSEG2E64FF_V_M4_TU }, // 89
  { 0x2, 0x0, 0x1, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG2E8_V_M1_TU }, // 90
  { 0x2, 0x0, 0x1, 0x1, 0x0, 0x3, 0x1, PseudoVLSSEG2E8_V_M2_TU }, // 91
  { 0x2, 0x0, 0x1, 0x1, 0x0, 0x3, 0x2, PseudoVLSSEG2E8_V_M4_TU }, // 92
  { 0x2, 0x0, 0x1, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG2E8_V_MF8_TU }, // 93
  { 0x2, 0x0, 0x1, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG2E8_V_MF4_TU }, // 94
  { 0x2, 0x0, 0x1, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG2E8_V_MF2_TU }, // 95
  { 0x2, 0x0, 0x1, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG2E16_V_M1_TU }, // 96
  { 0x2, 0x0, 0x1, 0x1, 0x0, 0x4, 0x1, PseudoVLSSEG2E16_V_M2_TU }, // 97
  { 0x2, 0x0, 0x1, 0x1, 0x0, 0x4, 0x2, PseudoVLSSEG2E16_V_M4_TU }, // 98
  { 0x2, 0x0, 0x1, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG2E16_V_MF4_TU }, // 99
  { 0x2, 0x0, 0x1, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG2E16_V_MF2_TU }, // 100
  { 0x2, 0x0, 0x1, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG2E32_V_M1_TU }, // 101
  { 0x2, 0x0, 0x1, 0x1, 0x0, 0x5, 0x1, PseudoVLSSEG2E32_V_M2_TU }, // 102
  { 0x2, 0x0, 0x1, 0x1, 0x0, 0x5, 0x2, PseudoVLSSEG2E32_V_M4_TU }, // 103
  { 0x2, 0x0, 0x1, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG2E32_V_MF2_TU }, // 104
  { 0x2, 0x0, 0x1, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG2E64_V_M1_TU }, // 105
  { 0x2, 0x0, 0x1, 0x1, 0x0, 0x6, 0x1, PseudoVLSSEG2E64_V_M2_TU }, // 106
  { 0x2, 0x0, 0x1, 0x1, 0x0, 0x6, 0x2, PseudoVLSSEG2E64_V_M4_TU }, // 107
  { 0x2, 0x1, 0x1, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG2E8_V_M1_MASK }, // 108
  { 0x2, 0x1, 0x1, 0x0, 0x0, 0x3, 0x1, PseudoVLSEG2E8_V_M2_MASK }, // 109
  { 0x2, 0x1, 0x1, 0x0, 0x0, 0x3, 0x2, PseudoVLSEG2E8_V_M4_MASK }, // 110
  { 0x2, 0x1, 0x1, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG2E8_V_MF8_MASK }, // 111
  { 0x2, 0x1, 0x1, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG2E8_V_MF4_MASK }, // 112
  { 0x2, 0x1, 0x1, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG2E8_V_MF2_MASK }, // 113
  { 0x2, 0x1, 0x1, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG2E16_V_M1_MASK }, // 114
  { 0x2, 0x1, 0x1, 0x0, 0x0, 0x4, 0x1, PseudoVLSEG2E16_V_M2_MASK }, // 115
  { 0x2, 0x1, 0x1, 0x0, 0x0, 0x4, 0x2, PseudoVLSEG2E16_V_M4_MASK }, // 116
  { 0x2, 0x1, 0x1, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG2E16_V_MF4_MASK }, // 117
  { 0x2, 0x1, 0x1, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG2E16_V_MF2_MASK }, // 118
  { 0x2, 0x1, 0x1, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG2E32_V_M1_MASK }, // 119
  { 0x2, 0x1, 0x1, 0x0, 0x0, 0x5, 0x1, PseudoVLSEG2E32_V_M2_MASK }, // 120
  { 0x2, 0x1, 0x1, 0x0, 0x0, 0x5, 0x2, PseudoVLSEG2E32_V_M4_MASK }, // 121
  { 0x2, 0x1, 0x1, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG2E32_V_MF2_MASK }, // 122
  { 0x2, 0x1, 0x1, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG2E64_V_M1_MASK }, // 123
  { 0x2, 0x1, 0x1, 0x0, 0x0, 0x6, 0x1, PseudoVLSEG2E64_V_M2_MASK }, // 124
  { 0x2, 0x1, 0x1, 0x0, 0x0, 0x6, 0x2, PseudoVLSEG2E64_V_M4_MASK }, // 125
  { 0x2, 0x1, 0x1, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG2E8FF_V_M1_MASK }, // 126
  { 0x2, 0x1, 0x1, 0x0, 0x1, 0x3, 0x1, PseudoVLSEG2E8FF_V_M2_MASK }, // 127
  { 0x2, 0x1, 0x1, 0x0, 0x1, 0x3, 0x2, PseudoVLSEG2E8FF_V_M4_MASK }, // 128
  { 0x2, 0x1, 0x1, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG2E8FF_V_MF8_MASK }, // 129
  { 0x2, 0x1, 0x1, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG2E8FF_V_MF4_MASK }, // 130
  { 0x2, 0x1, 0x1, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG2E8FF_V_MF2_MASK }, // 131
  { 0x2, 0x1, 0x1, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG2E16FF_V_M1_MASK }, // 132
  { 0x2, 0x1, 0x1, 0x0, 0x1, 0x4, 0x1, PseudoVLSEG2E16FF_V_M2_MASK }, // 133
  { 0x2, 0x1, 0x1, 0x0, 0x1, 0x4, 0x2, PseudoVLSEG2E16FF_V_M4_MASK }, // 134
  { 0x2, 0x1, 0x1, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG2E16FF_V_MF4_MASK }, // 135
  { 0x2, 0x1, 0x1, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG2E16FF_V_MF2_MASK }, // 136
  { 0x2, 0x1, 0x1, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG2E32FF_V_M1_MASK }, // 137
  { 0x2, 0x1, 0x1, 0x0, 0x1, 0x5, 0x1, PseudoVLSEG2E32FF_V_M2_MASK }, // 138
  { 0x2, 0x1, 0x1, 0x0, 0x1, 0x5, 0x2, PseudoVLSEG2E32FF_V_M4_MASK }, // 139
  { 0x2, 0x1, 0x1, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG2E32FF_V_MF2_MASK }, // 140
  { 0x2, 0x1, 0x1, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG2E64FF_V_M1_MASK }, // 141
  { 0x2, 0x1, 0x1, 0x0, 0x1, 0x6, 0x1, PseudoVLSEG2E64FF_V_M2_MASK }, // 142
  { 0x2, 0x1, 0x1, 0x0, 0x1, 0x6, 0x2, PseudoVLSEG2E64FF_V_M4_MASK }, // 143
  { 0x2, 0x1, 0x1, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG2E8_V_M1_MASK }, // 144
  { 0x2, 0x1, 0x1, 0x1, 0x0, 0x3, 0x1, PseudoVLSSEG2E8_V_M2_MASK }, // 145
  { 0x2, 0x1, 0x1, 0x1, 0x0, 0x3, 0x2, PseudoVLSSEG2E8_V_M4_MASK }, // 146
  { 0x2, 0x1, 0x1, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG2E8_V_MF8_MASK }, // 147
  { 0x2, 0x1, 0x1, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG2E8_V_MF4_MASK }, // 148
  { 0x2, 0x1, 0x1, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG2E8_V_MF2_MASK }, // 149
  { 0x2, 0x1, 0x1, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG2E16_V_M1_MASK }, // 150
  { 0x2, 0x1, 0x1, 0x1, 0x0, 0x4, 0x1, PseudoVLSSEG2E16_V_M2_MASK }, // 151
  { 0x2, 0x1, 0x1, 0x1, 0x0, 0x4, 0x2, PseudoVLSSEG2E16_V_M4_MASK }, // 152
  { 0x2, 0x1, 0x1, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG2E16_V_MF4_MASK }, // 153
  { 0x2, 0x1, 0x1, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG2E16_V_MF2_MASK }, // 154
  { 0x2, 0x1, 0x1, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG2E32_V_M1_MASK }, // 155
  { 0x2, 0x1, 0x1, 0x1, 0x0, 0x5, 0x1, PseudoVLSSEG2E32_V_M2_MASK }, // 156
  { 0x2, 0x1, 0x1, 0x1, 0x0, 0x5, 0x2, PseudoVLSSEG2E32_V_M4_MASK }, // 157
  { 0x2, 0x1, 0x1, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG2E32_V_MF2_MASK }, // 158
  { 0x2, 0x1, 0x1, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG2E64_V_M1_MASK }, // 159
  { 0x2, 0x1, 0x1, 0x1, 0x0, 0x6, 0x1, PseudoVLSSEG2E64_V_M2_MASK }, // 160
  { 0x2, 0x1, 0x1, 0x1, 0x0, 0x6, 0x2, PseudoVLSSEG2E64_V_M4_MASK }, // 161
  { 0x3, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG3E8_V_M1 }, // 162
  { 0x3, 0x0, 0x0, 0x0, 0x0, 0x3, 0x1, PseudoVLSEG3E8_V_M2 }, // 163
  { 0x3, 0x0, 0x0, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG3E8_V_MF8 }, // 164
  { 0x3, 0x0, 0x0, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG3E8_V_MF4 }, // 165
  { 0x3, 0x0, 0x0, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG3E8_V_MF2 }, // 166
  { 0x3, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG3E16_V_M1 }, // 167
  { 0x3, 0x0, 0x0, 0x0, 0x0, 0x4, 0x1, PseudoVLSEG3E16_V_M2 }, // 168
  { 0x3, 0x0, 0x0, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG3E16_V_MF4 }, // 169
  { 0x3, 0x0, 0x0, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG3E16_V_MF2 }, // 170
  { 0x3, 0x0, 0x0, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG3E32_V_M1 }, // 171
  { 0x3, 0x0, 0x0, 0x0, 0x0, 0x5, 0x1, PseudoVLSEG3E32_V_M2 }, // 172
  { 0x3, 0x0, 0x0, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG3E32_V_MF2 }, // 173
  { 0x3, 0x0, 0x0, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG3E64_V_M1 }, // 174
  { 0x3, 0x0, 0x0, 0x0, 0x0, 0x6, 0x1, PseudoVLSEG3E64_V_M2 }, // 175
  { 0x3, 0x0, 0x0, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG3E8FF_V_M1 }, // 176
  { 0x3, 0x0, 0x0, 0x0, 0x1, 0x3, 0x1, PseudoVLSEG3E8FF_V_M2 }, // 177
  { 0x3, 0x0, 0x0, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG3E8FF_V_MF8 }, // 178
  { 0x3, 0x0, 0x0, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG3E8FF_V_MF4 }, // 179
  { 0x3, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG3E8FF_V_MF2 }, // 180
  { 0x3, 0x0, 0x0, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG3E16FF_V_M1 }, // 181
  { 0x3, 0x0, 0x0, 0x0, 0x1, 0x4, 0x1, PseudoVLSEG3E16FF_V_M2 }, // 182
  { 0x3, 0x0, 0x0, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG3E16FF_V_MF4 }, // 183
  { 0x3, 0x0, 0x0, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG3E16FF_V_MF2 }, // 184
  { 0x3, 0x0, 0x0, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG3E32FF_V_M1 }, // 185
  { 0x3, 0x0, 0x0, 0x0, 0x1, 0x5, 0x1, PseudoVLSEG3E32FF_V_M2 }, // 186
  { 0x3, 0x0, 0x0, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG3E32FF_V_MF2 }, // 187
  { 0x3, 0x0, 0x0, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG3E64FF_V_M1 }, // 188
  { 0x3, 0x0, 0x0, 0x0, 0x1, 0x6, 0x1, PseudoVLSEG3E64FF_V_M2 }, // 189
  { 0x3, 0x0, 0x0, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG3E8_V_M1 }, // 190
  { 0x3, 0x0, 0x0, 0x1, 0x0, 0x3, 0x1, PseudoVLSSEG3E8_V_M2 }, // 191
  { 0x3, 0x0, 0x0, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG3E8_V_MF8 }, // 192
  { 0x3, 0x0, 0x0, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG3E8_V_MF4 }, // 193
  { 0x3, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG3E8_V_MF2 }, // 194
  { 0x3, 0x0, 0x0, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG3E16_V_M1 }, // 195
  { 0x3, 0x0, 0x0, 0x1, 0x0, 0x4, 0x1, PseudoVLSSEG3E16_V_M2 }, // 196
  { 0x3, 0x0, 0x0, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG3E16_V_MF4 }, // 197
  { 0x3, 0x0, 0x0, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG3E16_V_MF2 }, // 198
  { 0x3, 0x0, 0x0, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG3E32_V_M1 }, // 199
  { 0x3, 0x0, 0x0, 0x1, 0x0, 0x5, 0x1, PseudoVLSSEG3E32_V_M2 }, // 200
  { 0x3, 0x0, 0x0, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG3E32_V_MF2 }, // 201
  { 0x3, 0x0, 0x0, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG3E64_V_M1 }, // 202
  { 0x3, 0x0, 0x0, 0x1, 0x0, 0x6, 0x1, PseudoVLSSEG3E64_V_M2 }, // 203
  { 0x3, 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG3E8_V_M1_TU }, // 204
  { 0x3, 0x0, 0x1, 0x0, 0x0, 0x3, 0x1, PseudoVLSEG3E8_V_M2_TU }, // 205
  { 0x3, 0x0, 0x1, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG3E8_V_MF8_TU }, // 206
  { 0x3, 0x0, 0x1, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG3E8_V_MF4_TU }, // 207
  { 0x3, 0x0, 0x1, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG3E8_V_MF2_TU }, // 208
  { 0x3, 0x0, 0x1, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG3E16_V_M1_TU }, // 209
  { 0x3, 0x0, 0x1, 0x0, 0x0, 0x4, 0x1, PseudoVLSEG3E16_V_M2_TU }, // 210
  { 0x3, 0x0, 0x1, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG3E16_V_MF4_TU }, // 211
  { 0x3, 0x0, 0x1, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG3E16_V_MF2_TU }, // 212
  { 0x3, 0x0, 0x1, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG3E32_V_M1_TU }, // 213
  { 0x3, 0x0, 0x1, 0x0, 0x0, 0x5, 0x1, PseudoVLSEG3E32_V_M2_TU }, // 214
  { 0x3, 0x0, 0x1, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG3E32_V_MF2_TU }, // 215
  { 0x3, 0x0, 0x1, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG3E64_V_M1_TU }, // 216
  { 0x3, 0x0, 0x1, 0x0, 0x0, 0x6, 0x1, PseudoVLSEG3E64_V_M2_TU }, // 217
  { 0x3, 0x0, 0x1, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG3E8FF_V_M1_TU }, // 218
  { 0x3, 0x0, 0x1, 0x0, 0x1, 0x3, 0x1, PseudoVLSEG3E8FF_V_M2_TU }, // 219
  { 0x3, 0x0, 0x1, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG3E8FF_V_MF8_TU }, // 220
  { 0x3, 0x0, 0x1, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG3E8FF_V_MF4_TU }, // 221
  { 0x3, 0x0, 0x1, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG3E8FF_V_MF2_TU }, // 222
  { 0x3, 0x0, 0x1, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG3E16FF_V_M1_TU }, // 223
  { 0x3, 0x0, 0x1, 0x0, 0x1, 0x4, 0x1, PseudoVLSEG3E16FF_V_M2_TU }, // 224
  { 0x3, 0x0, 0x1, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG3E16FF_V_MF4_TU }, // 225
  { 0x3, 0x0, 0x1, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG3E16FF_V_MF2_TU }, // 226
  { 0x3, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG3E32FF_V_M1_TU }, // 227
  { 0x3, 0x0, 0x1, 0x0, 0x1, 0x5, 0x1, PseudoVLSEG3E32FF_V_M2_TU }, // 228
  { 0x3, 0x0, 0x1, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG3E32FF_V_MF2_TU }, // 229
  { 0x3, 0x0, 0x1, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG3E64FF_V_M1_TU }, // 230
  { 0x3, 0x0, 0x1, 0x0, 0x1, 0x6, 0x1, PseudoVLSEG3E64FF_V_M2_TU }, // 231
  { 0x3, 0x0, 0x1, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG3E8_V_M1_TU }, // 232
  { 0x3, 0x0, 0x1, 0x1, 0x0, 0x3, 0x1, PseudoVLSSEG3E8_V_M2_TU }, // 233
  { 0x3, 0x0, 0x1, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG3E8_V_MF8_TU }, // 234
  { 0x3, 0x0, 0x1, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG3E8_V_MF4_TU }, // 235
  { 0x3, 0x0, 0x1, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG3E8_V_MF2_TU }, // 236
  { 0x3, 0x0, 0x1, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG3E16_V_M1_TU }, // 237
  { 0x3, 0x0, 0x1, 0x1, 0x0, 0x4, 0x1, PseudoVLSSEG3E16_V_M2_TU }, // 238
  { 0x3, 0x0, 0x1, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG3E16_V_MF4_TU }, // 239
  { 0x3, 0x0, 0x1, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG3E16_V_MF2_TU }, // 240
  { 0x3, 0x0, 0x1, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG3E32_V_M1_TU }, // 241
  { 0x3, 0x0, 0x1, 0x1, 0x0, 0x5, 0x1, PseudoVLSSEG3E32_V_M2_TU }, // 242
  { 0x3, 0x0, 0x1, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG3E32_V_MF2_TU }, // 243
  { 0x3, 0x0, 0x1, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG3E64_V_M1_TU }, // 244
  { 0x3, 0x0, 0x1, 0x1, 0x0, 0x6, 0x1, PseudoVLSSEG3E64_V_M2_TU }, // 245
  { 0x3, 0x1, 0x1, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG3E8_V_M1_MASK }, // 246
  { 0x3, 0x1, 0x1, 0x0, 0x0, 0x3, 0x1, PseudoVLSEG3E8_V_M2_MASK }, // 247
  { 0x3, 0x1, 0x1, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG3E8_V_MF8_MASK }, // 248
  { 0x3, 0x1, 0x1, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG3E8_V_MF4_MASK }, // 249
  { 0x3, 0x1, 0x1, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG3E8_V_MF2_MASK }, // 250
  { 0x3, 0x1, 0x1, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG3E16_V_M1_MASK }, // 251
  { 0x3, 0x1, 0x1, 0x0, 0x0, 0x4, 0x1, PseudoVLSEG3E16_V_M2_MASK }, // 252
  { 0x3, 0x1, 0x1, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG3E16_V_MF4_MASK }, // 253
  { 0x3, 0x1, 0x1, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG3E16_V_MF2_MASK }, // 254
  { 0x3, 0x1, 0x1, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG3E32_V_M1_MASK }, // 255
  { 0x3, 0x1, 0x1, 0x0, 0x0, 0x5, 0x1, PseudoVLSEG3E32_V_M2_MASK }, // 256
  { 0x3, 0x1, 0x1, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG3E32_V_MF2_MASK }, // 257
  { 0x3, 0x1, 0x1, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG3E64_V_M1_MASK }, // 258
  { 0x3, 0x1, 0x1, 0x0, 0x0, 0x6, 0x1, PseudoVLSEG3E64_V_M2_MASK }, // 259
  { 0x3, 0x1, 0x1, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG3E8FF_V_M1_MASK }, // 260
  { 0x3, 0x1, 0x1, 0x0, 0x1, 0x3, 0x1, PseudoVLSEG3E8FF_V_M2_MASK }, // 261
  { 0x3, 0x1, 0x1, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG3E8FF_V_MF8_MASK }, // 262
  { 0x3, 0x1, 0x1, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG3E8FF_V_MF4_MASK }, // 263
  { 0x3, 0x1, 0x1, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG3E8FF_V_MF2_MASK }, // 264
  { 0x3, 0x1, 0x1, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG3E16FF_V_M1_MASK }, // 265
  { 0x3, 0x1, 0x1, 0x0, 0x1, 0x4, 0x1, PseudoVLSEG3E16FF_V_M2_MASK }, // 266
  { 0x3, 0x1, 0x1, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG3E16FF_V_MF4_MASK }, // 267
  { 0x3, 0x1, 0x1, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG3E16FF_V_MF2_MASK }, // 268
  { 0x3, 0x1, 0x1, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG3E32FF_V_M1_MASK }, // 269
  { 0x3, 0x1, 0x1, 0x0, 0x1, 0x5, 0x1, PseudoVLSEG3E32FF_V_M2_MASK }, // 270
  { 0x3, 0x1, 0x1, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG3E32FF_V_MF2_MASK }, // 271
  { 0x3, 0x1, 0x1, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG3E64FF_V_M1_MASK }, // 272
  { 0x3, 0x1, 0x1, 0x0, 0x1, 0x6, 0x1, PseudoVLSEG3E64FF_V_M2_MASK }, // 273
  { 0x3, 0x1, 0x1, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG3E8_V_M1_MASK }, // 274
  { 0x3, 0x1, 0x1, 0x1, 0x0, 0x3, 0x1, PseudoVLSSEG3E8_V_M2_MASK }, // 275
  { 0x3, 0x1, 0x1, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG3E8_V_MF8_MASK }, // 276
  { 0x3, 0x1, 0x1, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG3E8_V_MF4_MASK }, // 277
  { 0x3, 0x1, 0x1, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG3E8_V_MF2_MASK }, // 278
  { 0x3, 0x1, 0x1, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG3E16_V_M1_MASK }, // 279
  { 0x3, 0x1, 0x1, 0x1, 0x0, 0x4, 0x1, PseudoVLSSEG3E16_V_M2_MASK }, // 280
  { 0x3, 0x1, 0x1, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG3E16_V_MF4_MASK }, // 281
  { 0x3, 0x1, 0x1, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG3E16_V_MF2_MASK }, // 282
  { 0x3, 0x1, 0x1, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG3E32_V_M1_MASK }, // 283
  { 0x3, 0x1, 0x1, 0x1, 0x0, 0x5, 0x1, PseudoVLSSEG3E32_V_M2_MASK }, // 284
  { 0x3, 0x1, 0x1, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG3E32_V_MF2_MASK }, // 285
  { 0x3, 0x1, 0x1, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG3E64_V_M1_MASK }, // 286
  { 0x3, 0x1, 0x1, 0x1, 0x0, 0x6, 0x1, PseudoVLSSEG3E64_V_M2_MASK }, // 287
  { 0x4, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG4E8_V_M1 }, // 288
  { 0x4, 0x0, 0x0, 0x0, 0x0, 0x3, 0x1, PseudoVLSEG4E8_V_M2 }, // 289
  { 0x4, 0x0, 0x0, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG4E8_V_MF8 }, // 290
  { 0x4, 0x0, 0x0, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG4E8_V_MF4 }, // 291
  { 0x4, 0x0, 0x0, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG4E8_V_MF2 }, // 292
  { 0x4, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG4E16_V_M1 }, // 293
  { 0x4, 0x0, 0x0, 0x0, 0x0, 0x4, 0x1, PseudoVLSEG4E16_V_M2 }, // 294
  { 0x4, 0x0, 0x0, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG4E16_V_MF4 }, // 295
  { 0x4, 0x0, 0x0, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG4E16_V_MF2 }, // 296
  { 0x4, 0x0, 0x0, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG4E32_V_M1 }, // 297
  { 0x4, 0x0, 0x0, 0x0, 0x0, 0x5, 0x1, PseudoVLSEG4E32_V_M2 }, // 298
  { 0x4, 0x0, 0x0, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG4E32_V_MF2 }, // 299
  { 0x4, 0x0, 0x0, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG4E64_V_M1 }, // 300
  { 0x4, 0x0, 0x0, 0x0, 0x0, 0x6, 0x1, PseudoVLSEG4E64_V_M2 }, // 301
  { 0x4, 0x0, 0x0, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG4E8FF_V_M1 }, // 302
  { 0x4, 0x0, 0x0, 0x0, 0x1, 0x3, 0x1, PseudoVLSEG4E8FF_V_M2 }, // 303
  { 0x4, 0x0, 0x0, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG4E8FF_V_MF8 }, // 304
  { 0x4, 0x0, 0x0, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG4E8FF_V_MF4 }, // 305
  { 0x4, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG4E8FF_V_MF2 }, // 306
  { 0x4, 0x0, 0x0, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG4E16FF_V_M1 }, // 307
  { 0x4, 0x0, 0x0, 0x0, 0x1, 0x4, 0x1, PseudoVLSEG4E16FF_V_M2 }, // 308
  { 0x4, 0x0, 0x0, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG4E16FF_V_MF4 }, // 309
  { 0x4, 0x0, 0x0, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG4E16FF_V_MF2 }, // 310
  { 0x4, 0x0, 0x0, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG4E32FF_V_M1 }, // 311
  { 0x4, 0x0, 0x0, 0x0, 0x1, 0x5, 0x1, PseudoVLSEG4E32FF_V_M2 }, // 312
  { 0x4, 0x0, 0x0, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG4E32FF_V_MF2 }, // 313
  { 0x4, 0x0, 0x0, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG4E64FF_V_M1 }, // 314
  { 0x4, 0x0, 0x0, 0x0, 0x1, 0x6, 0x1, PseudoVLSEG4E64FF_V_M2 }, // 315
  { 0x4, 0x0, 0x0, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG4E8_V_M1 }, // 316
  { 0x4, 0x0, 0x0, 0x1, 0x0, 0x3, 0x1, PseudoVLSSEG4E8_V_M2 }, // 317
  { 0x4, 0x0, 0x0, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG4E8_V_MF8 }, // 318
  { 0x4, 0x0, 0x0, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG4E8_V_MF4 }, // 319
  { 0x4, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG4E8_V_MF2 }, // 320
  { 0x4, 0x0, 0x0, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG4E16_V_M1 }, // 321
  { 0x4, 0x0, 0x0, 0x1, 0x0, 0x4, 0x1, PseudoVLSSEG4E16_V_M2 }, // 322
  { 0x4, 0x0, 0x0, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG4E16_V_MF4 }, // 323
  { 0x4, 0x0, 0x0, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG4E16_V_MF2 }, // 324
  { 0x4, 0x0, 0x0, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG4E32_V_M1 }, // 325
  { 0x4, 0x0, 0x0, 0x1, 0x0, 0x5, 0x1, PseudoVLSSEG4E32_V_M2 }, // 326
  { 0x4, 0x0, 0x0, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG4E32_V_MF2 }, // 327
  { 0x4, 0x0, 0x0, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG4E64_V_M1 }, // 328
  { 0x4, 0x0, 0x0, 0x1, 0x0, 0x6, 0x1, PseudoVLSSEG4E64_V_M2 }, // 329
  { 0x4, 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG4E8_V_M1_TU }, // 330
  { 0x4, 0x0, 0x1, 0x0, 0x0, 0x3, 0x1, PseudoVLSEG4E8_V_M2_TU }, // 331
  { 0x4, 0x0, 0x1, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG4E8_V_MF8_TU }, // 332
  { 0x4, 0x0, 0x1, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG4E8_V_MF4_TU }, // 333
  { 0x4, 0x0, 0x1, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG4E8_V_MF2_TU }, // 334
  { 0x4, 0x0, 0x1, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG4E16_V_M1_TU }, // 335
  { 0x4, 0x0, 0x1, 0x0, 0x0, 0x4, 0x1, PseudoVLSEG4E16_V_M2_TU }, // 336
  { 0x4, 0x0, 0x1, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG4E16_V_MF4_TU }, // 337
  { 0x4, 0x0, 0x1, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG4E16_V_MF2_TU }, // 338
  { 0x4, 0x0, 0x1, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG4E32_V_M1_TU }, // 339
  { 0x4, 0x0, 0x1, 0x0, 0x0, 0x5, 0x1, PseudoVLSEG4E32_V_M2_TU }, // 340
  { 0x4, 0x0, 0x1, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG4E32_V_MF2_TU }, // 341
  { 0x4, 0x0, 0x1, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG4E64_V_M1_TU }, // 342
  { 0x4, 0x0, 0x1, 0x0, 0x0, 0x6, 0x1, PseudoVLSEG4E64_V_M2_TU }, // 343
  { 0x4, 0x0, 0x1, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG4E8FF_V_M1_TU }, // 344
  { 0x4, 0x0, 0x1, 0x0, 0x1, 0x3, 0x1, PseudoVLSEG4E8FF_V_M2_TU }, // 345
  { 0x4, 0x0, 0x1, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG4E8FF_V_MF8_TU }, // 346
  { 0x4, 0x0, 0x1, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG4E8FF_V_MF4_TU }, // 347
  { 0x4, 0x0, 0x1, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG4E8FF_V_MF2_TU }, // 348
  { 0x4, 0x0, 0x1, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG4E16FF_V_M1_TU }, // 349
  { 0x4, 0x0, 0x1, 0x0, 0x1, 0x4, 0x1, PseudoVLSEG4E16FF_V_M2_TU }, // 350
  { 0x4, 0x0, 0x1, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG4E16FF_V_MF4_TU }, // 351
  { 0x4, 0x0, 0x1, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG4E16FF_V_MF2_TU }, // 352
  { 0x4, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG4E32FF_V_M1_TU }, // 353
  { 0x4, 0x0, 0x1, 0x0, 0x1, 0x5, 0x1, PseudoVLSEG4E32FF_V_M2_TU }, // 354
  { 0x4, 0x0, 0x1, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG4E32FF_V_MF2_TU }, // 355
  { 0x4, 0x0, 0x1, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG4E64FF_V_M1_TU }, // 356
  { 0x4, 0x0, 0x1, 0x0, 0x1, 0x6, 0x1, PseudoVLSEG4E64FF_V_M2_TU }, // 357
  { 0x4, 0x0, 0x1, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG4E8_V_M1_TU }, // 358
  { 0x4, 0x0, 0x1, 0x1, 0x0, 0x3, 0x1, PseudoVLSSEG4E8_V_M2_TU }, // 359
  { 0x4, 0x0, 0x1, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG4E8_V_MF8_TU }, // 360
  { 0x4, 0x0, 0x1, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG4E8_V_MF4_TU }, // 361
  { 0x4, 0x0, 0x1, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG4E8_V_MF2_TU }, // 362
  { 0x4, 0x0, 0x1, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG4E16_V_M1_TU }, // 363
  { 0x4, 0x0, 0x1, 0x1, 0x0, 0x4, 0x1, PseudoVLSSEG4E16_V_M2_TU }, // 364
  { 0x4, 0x0, 0x1, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG4E16_V_MF4_TU }, // 365
  { 0x4, 0x0, 0x1, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG4E16_V_MF2_TU }, // 366
  { 0x4, 0x0, 0x1, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG4E32_V_M1_TU }, // 367
  { 0x4, 0x0, 0x1, 0x1, 0x0, 0x5, 0x1, PseudoVLSSEG4E32_V_M2_TU }, // 368
  { 0x4, 0x0, 0x1, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG4E32_V_MF2_TU }, // 369
  { 0x4, 0x0, 0x1, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG4E64_V_M1_TU }, // 370
  { 0x4, 0x0, 0x1, 0x1, 0x0, 0x6, 0x1, PseudoVLSSEG4E64_V_M2_TU }, // 371
  { 0x4, 0x1, 0x1, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG4E8_V_M1_MASK }, // 372
  { 0x4, 0x1, 0x1, 0x0, 0x0, 0x3, 0x1, PseudoVLSEG4E8_V_M2_MASK }, // 373
  { 0x4, 0x1, 0x1, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG4E8_V_MF8_MASK }, // 374
  { 0x4, 0x1, 0x1, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG4E8_V_MF4_MASK }, // 375
  { 0x4, 0x1, 0x1, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG4E8_V_MF2_MASK }, // 376
  { 0x4, 0x1, 0x1, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG4E16_V_M1_MASK }, // 377
  { 0x4, 0x1, 0x1, 0x0, 0x0, 0x4, 0x1, PseudoVLSEG4E16_V_M2_MASK }, // 378
  { 0x4, 0x1, 0x1, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG4E16_V_MF4_MASK }, // 379
  { 0x4, 0x1, 0x1, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG4E16_V_MF2_MASK }, // 380
  { 0x4, 0x1, 0x1, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG4E32_V_M1_MASK }, // 381
  { 0x4, 0x1, 0x1, 0x0, 0x0, 0x5, 0x1, PseudoVLSEG4E32_V_M2_MASK }, // 382
  { 0x4, 0x1, 0x1, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG4E32_V_MF2_MASK }, // 383
  { 0x4, 0x1, 0x1, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG4E64_V_M1_MASK }, // 384
  { 0x4, 0x1, 0x1, 0x0, 0x0, 0x6, 0x1, PseudoVLSEG4E64_V_M2_MASK }, // 385
  { 0x4, 0x1, 0x1, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG4E8FF_V_M1_MASK }, // 386
  { 0x4, 0x1, 0x1, 0x0, 0x1, 0x3, 0x1, PseudoVLSEG4E8FF_V_M2_MASK }, // 387
  { 0x4, 0x1, 0x1, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG4E8FF_V_MF8_MASK }, // 388
  { 0x4, 0x1, 0x1, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG4E8FF_V_MF4_MASK }, // 389
  { 0x4, 0x1, 0x1, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG4E8FF_V_MF2_MASK }, // 390
  { 0x4, 0x1, 0x1, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG4E16FF_V_M1_MASK }, // 391
  { 0x4, 0x1, 0x1, 0x0, 0x1, 0x4, 0x1, PseudoVLSEG4E16FF_V_M2_MASK }, // 392
  { 0x4, 0x1, 0x1, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG4E16FF_V_MF4_MASK }, // 393
  { 0x4, 0x1, 0x1, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG4E16FF_V_MF2_MASK }, // 394
  { 0x4, 0x1, 0x1, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG4E32FF_V_M1_MASK }, // 395
  { 0x4, 0x1, 0x1, 0x0, 0x1, 0x5, 0x1, PseudoVLSEG4E32FF_V_M2_MASK }, // 396
  { 0x4, 0x1, 0x1, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG4E32FF_V_MF2_MASK }, // 397
  { 0x4, 0x1, 0x1, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG4E64FF_V_M1_MASK }, // 398
  { 0x4, 0x1, 0x1, 0x0, 0x1, 0x6, 0x1, PseudoVLSEG4E64FF_V_M2_MASK }, // 399
  { 0x4, 0x1, 0x1, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG4E8_V_M1_MASK }, // 400
  { 0x4, 0x1, 0x1, 0x1, 0x0, 0x3, 0x1, PseudoVLSSEG4E8_V_M2_MASK }, // 401
  { 0x4, 0x1, 0x1, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG4E8_V_MF8_MASK }, // 402
  { 0x4, 0x1, 0x1, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG4E8_V_MF4_MASK }, // 403
  { 0x4, 0x1, 0x1, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG4E8_V_MF2_MASK }, // 404
  { 0x4, 0x1, 0x1, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG4E16_V_M1_MASK }, // 405
  { 0x4, 0x1, 0x1, 0x1, 0x0, 0x4, 0x1, PseudoVLSSEG4E16_V_M2_MASK }, // 406
  { 0x4, 0x1, 0x1, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG4E16_V_MF4_MASK }, // 407
  { 0x4, 0x1, 0x1, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG4E16_V_MF2_MASK }, // 408
  { 0x4, 0x1, 0x1, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG4E32_V_M1_MASK }, // 409
  { 0x4, 0x1, 0x1, 0x1, 0x0, 0x5, 0x1, PseudoVLSSEG4E32_V_M2_MASK }, // 410
  { 0x4, 0x1, 0x1, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG4E32_V_MF2_MASK }, // 411
  { 0x4, 0x1, 0x1, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG4E64_V_M1_MASK }, // 412
  { 0x4, 0x1, 0x1, 0x1, 0x0, 0x6, 0x1, PseudoVLSSEG4E64_V_M2_MASK }, // 413
  { 0x5, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG5E8_V_M1 }, // 414
  { 0x5, 0x0, 0x0, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG5E8_V_MF8 }, // 415
  { 0x5, 0x0, 0x0, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG5E8_V_MF4 }, // 416
  { 0x5, 0x0, 0x0, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG5E8_V_MF2 }, // 417
  { 0x5, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG5E16_V_M1 }, // 418
  { 0x5, 0x0, 0x0, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG5E16_V_MF4 }, // 419
  { 0x5, 0x0, 0x0, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG5E16_V_MF2 }, // 420
  { 0x5, 0x0, 0x0, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG5E32_V_M1 }, // 421
  { 0x5, 0x0, 0x0, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG5E32_V_MF2 }, // 422
  { 0x5, 0x0, 0x0, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG5E64_V_M1 }, // 423
  { 0x5, 0x0, 0x0, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG5E8FF_V_M1 }, // 424
  { 0x5, 0x0, 0x0, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG5E8FF_V_MF8 }, // 425
  { 0x5, 0x0, 0x0, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG5E8FF_V_MF4 }, // 426
  { 0x5, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG5E8FF_V_MF2 }, // 427
  { 0x5, 0x0, 0x0, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG5E16FF_V_M1 }, // 428
  { 0x5, 0x0, 0x0, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG5E16FF_V_MF4 }, // 429
  { 0x5, 0x0, 0x0, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG5E16FF_V_MF2 }, // 430
  { 0x5, 0x0, 0x0, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG5E32FF_V_M1 }, // 431
  { 0x5, 0x0, 0x0, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG5E32FF_V_MF2 }, // 432
  { 0x5, 0x0, 0x0, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG5E64FF_V_M1 }, // 433
  { 0x5, 0x0, 0x0, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG5E8_V_M1 }, // 434
  { 0x5, 0x0, 0x0, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG5E8_V_MF8 }, // 435
  { 0x5, 0x0, 0x0, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG5E8_V_MF4 }, // 436
  { 0x5, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG5E8_V_MF2 }, // 437
  { 0x5, 0x0, 0x0, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG5E16_V_M1 }, // 438
  { 0x5, 0x0, 0x0, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG5E16_V_MF4 }, // 439
  { 0x5, 0x0, 0x0, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG5E16_V_MF2 }, // 440
  { 0x5, 0x0, 0x0, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG5E32_V_M1 }, // 441
  { 0x5, 0x0, 0x0, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG5E32_V_MF2 }, // 442
  { 0x5, 0x0, 0x0, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG5E64_V_M1 }, // 443
  { 0x5, 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG5E8_V_M1_TU }, // 444
  { 0x5, 0x0, 0x1, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG5E8_V_MF8_TU }, // 445
  { 0x5, 0x0, 0x1, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG5E8_V_MF4_TU }, // 446
  { 0x5, 0x0, 0x1, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG5E8_V_MF2_TU }, // 447
  { 0x5, 0x0, 0x1, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG5E16_V_M1_TU }, // 448
  { 0x5, 0x0, 0x1, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG5E16_V_MF4_TU }, // 449
  { 0x5, 0x0, 0x1, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG5E16_V_MF2_TU }, // 450
  { 0x5, 0x0, 0x1, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG5E32_V_M1_TU }, // 451
  { 0x5, 0x0, 0x1, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG5E32_V_MF2_TU }, // 452
  { 0x5, 0x0, 0x1, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG5E64_V_M1_TU }, // 453
  { 0x5, 0x0, 0x1, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG5E8FF_V_M1_TU }, // 454
  { 0x5, 0x0, 0x1, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG5E8FF_V_MF8_TU }, // 455
  { 0x5, 0x0, 0x1, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG5E8FF_V_MF4_TU }, // 456
  { 0x5, 0x0, 0x1, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG5E8FF_V_MF2_TU }, // 457
  { 0x5, 0x0, 0x1, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG5E16FF_V_M1_TU }, // 458
  { 0x5, 0x0, 0x1, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG5E16FF_V_MF4_TU }, // 459
  { 0x5, 0x0, 0x1, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG5E16FF_V_MF2_TU }, // 460
  { 0x5, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG5E32FF_V_M1_TU }, // 461
  { 0x5, 0x0, 0x1, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG5E32FF_V_MF2_TU }, // 462
  { 0x5, 0x0, 0x1, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG5E64FF_V_M1_TU }, // 463
  { 0x5, 0x0, 0x1, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG5E8_V_M1_TU }, // 464
  { 0x5, 0x0, 0x1, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG5E8_V_MF8_TU }, // 465
  { 0x5, 0x0, 0x1, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG5E8_V_MF4_TU }, // 466
  { 0x5, 0x0, 0x1, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG5E8_V_MF2_TU }, // 467
  { 0x5, 0x0, 0x1, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG5E16_V_M1_TU }, // 468
  { 0x5, 0x0, 0x1, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG5E16_V_MF4_TU }, // 469
  { 0x5, 0x0, 0x1, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG5E16_V_MF2_TU }, // 470
  { 0x5, 0x0, 0x1, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG5E32_V_M1_TU }, // 471
  { 0x5, 0x0, 0x1, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG5E32_V_MF2_TU }, // 472
  { 0x5, 0x0, 0x1, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG5E64_V_M1_TU }, // 473
  { 0x5, 0x1, 0x1, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG5E8_V_M1_MASK }, // 474
  { 0x5, 0x1, 0x1, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG5E8_V_MF8_MASK }, // 475
  { 0x5, 0x1, 0x1, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG5E8_V_MF4_MASK }, // 476
  { 0x5, 0x1, 0x1, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG5E8_V_MF2_MASK }, // 477
  { 0x5, 0x1, 0x1, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG5E16_V_M1_MASK }, // 478
  { 0x5, 0x1, 0x1, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG5E16_V_MF4_MASK }, // 479
  { 0x5, 0x1, 0x1, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG5E16_V_MF2_MASK }, // 480
  { 0x5, 0x1, 0x1, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG5E32_V_M1_MASK }, // 481
  { 0x5, 0x1, 0x1, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG5E32_V_MF2_MASK }, // 482
  { 0x5, 0x1, 0x1, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG5E64_V_M1_MASK }, // 483
  { 0x5, 0x1, 0x1, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG5E8FF_V_M1_MASK }, // 484
  { 0x5, 0x1, 0x1, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG5E8FF_V_MF8_MASK }, // 485
  { 0x5, 0x1, 0x1, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG5E8FF_V_MF4_MASK }, // 486
  { 0x5, 0x1, 0x1, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG5E8FF_V_MF2_MASK }, // 487
  { 0x5, 0x1, 0x1, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG5E16FF_V_M1_MASK }, // 488
  { 0x5, 0x1, 0x1, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG5E16FF_V_MF4_MASK }, // 489
  { 0x5, 0x1, 0x1, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG5E16FF_V_MF2_MASK }, // 490
  { 0x5, 0x1, 0x1, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG5E32FF_V_M1_MASK }, // 491
  { 0x5, 0x1, 0x1, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG5E32FF_V_MF2_MASK }, // 492
  { 0x5, 0x1, 0x1, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG5E64FF_V_M1_MASK }, // 493
  { 0x5, 0x1, 0x1, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG5E8_V_M1_MASK }, // 494
  { 0x5, 0x1, 0x1, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG5E8_V_MF8_MASK }, // 495
  { 0x5, 0x1, 0x1, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG5E8_V_MF4_MASK }, // 496
  { 0x5, 0x1, 0x1, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG5E8_V_MF2_MASK }, // 497
  { 0x5, 0x1, 0x1, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG5E16_V_M1_MASK }, // 498
  { 0x5, 0x1, 0x1, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG5E16_V_MF4_MASK }, // 499
  { 0x5, 0x1, 0x1, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG5E16_V_MF2_MASK }, // 500
  { 0x5, 0x1, 0x1, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG5E32_V_M1_MASK }, // 501
  { 0x5, 0x1, 0x1, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG5E32_V_MF2_MASK }, // 502
  { 0x5, 0x1, 0x1, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG5E64_V_M1_MASK }, // 503
  { 0x6, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG6E8_V_M1 }, // 504
  { 0x6, 0x0, 0x0, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG6E8_V_MF8 }, // 505
  { 0x6, 0x0, 0x0, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG6E8_V_MF4 }, // 506
  { 0x6, 0x0, 0x0, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG6E8_V_MF2 }, // 507
  { 0x6, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG6E16_V_M1 }, // 508
  { 0x6, 0x0, 0x0, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG6E16_V_MF4 }, // 509
  { 0x6, 0x0, 0x0, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG6E16_V_MF2 }, // 510
  { 0x6, 0x0, 0x0, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG6E32_V_M1 }, // 511
  { 0x6, 0x0, 0x0, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG6E32_V_MF2 }, // 512
  { 0x6, 0x0, 0x0, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG6E64_V_M1 }, // 513
  { 0x6, 0x0, 0x0, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG6E8FF_V_M1 }, // 514
  { 0x6, 0x0, 0x0, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG6E8FF_V_MF8 }, // 515
  { 0x6, 0x0, 0x0, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG6E8FF_V_MF4 }, // 516
  { 0x6, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG6E8FF_V_MF2 }, // 517
  { 0x6, 0x0, 0x0, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG6E16FF_V_M1 }, // 518
  { 0x6, 0x0, 0x0, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG6E16FF_V_MF4 }, // 519
  { 0x6, 0x0, 0x0, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG6E16FF_V_MF2 }, // 520
  { 0x6, 0x0, 0x0, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG6E32FF_V_M1 }, // 521
  { 0x6, 0x0, 0x0, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG6E32FF_V_MF2 }, // 522
  { 0x6, 0x0, 0x0, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG6E64FF_V_M1 }, // 523
  { 0x6, 0x0, 0x0, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG6E8_V_M1 }, // 524
  { 0x6, 0x0, 0x0, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG6E8_V_MF8 }, // 525
  { 0x6, 0x0, 0x0, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG6E8_V_MF4 }, // 526
  { 0x6, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG6E8_V_MF2 }, // 527
  { 0x6, 0x0, 0x0, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG6E16_V_M1 }, // 528
  { 0x6, 0x0, 0x0, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG6E16_V_MF4 }, // 529
  { 0x6, 0x0, 0x0, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG6E16_V_MF2 }, // 530
  { 0x6, 0x0, 0x0, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG6E32_V_M1 }, // 531
  { 0x6, 0x0, 0x0, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG6E32_V_MF2 }, // 532
  { 0x6, 0x0, 0x0, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG6E64_V_M1 }, // 533
  { 0x6, 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG6E8_V_M1_TU }, // 534
  { 0x6, 0x0, 0x1, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG6E8_V_MF8_TU }, // 535
  { 0x6, 0x0, 0x1, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG6E8_V_MF4_TU }, // 536
  { 0x6, 0x0, 0x1, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG6E8_V_MF2_TU }, // 537
  { 0x6, 0x0, 0x1, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG6E16_V_M1_TU }, // 538
  { 0x6, 0x0, 0x1, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG6E16_V_MF4_TU }, // 539
  { 0x6, 0x0, 0x1, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG6E16_V_MF2_TU }, // 540
  { 0x6, 0x0, 0x1, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG6E32_V_M1_TU }, // 541
  { 0x6, 0x0, 0x1, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG6E32_V_MF2_TU }, // 542
  { 0x6, 0x0, 0x1, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG6E64_V_M1_TU }, // 543
  { 0x6, 0x0, 0x1, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG6E8FF_V_M1_TU }, // 544
  { 0x6, 0x0, 0x1, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG6E8FF_V_MF8_TU }, // 545
  { 0x6, 0x0, 0x1, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG6E8FF_V_MF4_TU }, // 546
  { 0x6, 0x0, 0x1, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG6E8FF_V_MF2_TU }, // 547
  { 0x6, 0x0, 0x1, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG6E16FF_V_M1_TU }, // 548
  { 0x6, 0x0, 0x1, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG6E16FF_V_MF4_TU }, // 549
  { 0x6, 0x0, 0x1, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG6E16FF_V_MF2_TU }, // 550
  { 0x6, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG6E32FF_V_M1_TU }, // 551
  { 0x6, 0x0, 0x1, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG6E32FF_V_MF2_TU }, // 552
  { 0x6, 0x0, 0x1, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG6E64FF_V_M1_TU }, // 553
  { 0x6, 0x0, 0x1, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG6E8_V_M1_TU }, // 554
  { 0x6, 0x0, 0x1, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG6E8_V_MF8_TU }, // 555
  { 0x6, 0x0, 0x1, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG6E8_V_MF4_TU }, // 556
  { 0x6, 0x0, 0x1, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG6E8_V_MF2_TU }, // 557
  { 0x6, 0x0, 0x1, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG6E16_V_M1_TU }, // 558
  { 0x6, 0x0, 0x1, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG6E16_V_MF4_TU }, // 559
  { 0x6, 0x0, 0x1, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG6E16_V_MF2_TU }, // 560
  { 0x6, 0x0, 0x1, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG6E32_V_M1_TU }, // 561
  { 0x6, 0x0, 0x1, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG6E32_V_MF2_TU }, // 562
  { 0x6, 0x0, 0x1, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG6E64_V_M1_TU }, // 563
  { 0x6, 0x1, 0x1, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG6E8_V_M1_MASK }, // 564
  { 0x6, 0x1, 0x1, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG6E8_V_MF8_MASK }, // 565
  { 0x6, 0x1, 0x1, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG6E8_V_MF4_MASK }, // 566
  { 0x6, 0x1, 0x1, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG6E8_V_MF2_MASK }, // 567
  { 0x6, 0x1, 0x1, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG6E16_V_M1_MASK }, // 568
  { 0x6, 0x1, 0x1, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG6E16_V_MF4_MASK }, // 569
  { 0x6, 0x1, 0x1, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG6E16_V_MF2_MASK }, // 570
  { 0x6, 0x1, 0x1, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG6E32_V_M1_MASK }, // 571
  { 0x6, 0x1, 0x1, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG6E32_V_MF2_MASK }, // 572
  { 0x6, 0x1, 0x1, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG6E64_V_M1_MASK }, // 573
  { 0x6, 0x1, 0x1, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG6E8FF_V_M1_MASK }, // 574
  { 0x6, 0x1, 0x1, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG6E8FF_V_MF8_MASK }, // 575
  { 0x6, 0x1, 0x1, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG6E8FF_V_MF4_MASK }, // 576
  { 0x6, 0x1, 0x1, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG6E8FF_V_MF2_MASK }, // 577
  { 0x6, 0x1, 0x1, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG6E16FF_V_M1_MASK }, // 578
  { 0x6, 0x1, 0x1, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG6E16FF_V_MF4_MASK }, // 579
  { 0x6, 0x1, 0x1, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG6E16FF_V_MF2_MASK }, // 580
  { 0x6, 0x1, 0x1, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG6E32FF_V_M1_MASK }, // 581
  { 0x6, 0x1, 0x1, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG6E32FF_V_MF2_MASK }, // 582
  { 0x6, 0x1, 0x1, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG6E64FF_V_M1_MASK }, // 583
  { 0x6, 0x1, 0x1, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG6E8_V_M1_MASK }, // 584
  { 0x6, 0x1, 0x1, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG6E8_V_MF8_MASK }, // 585
  { 0x6, 0x1, 0x1, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG6E8_V_MF4_MASK }, // 586
  { 0x6, 0x1, 0x1, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG6E8_V_MF2_MASK }, // 587
  { 0x6, 0x1, 0x1, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG6E16_V_M1_MASK }, // 588
  { 0x6, 0x1, 0x1, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG6E16_V_MF4_MASK }, // 589
  { 0x6, 0x1, 0x1, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG6E16_V_MF2_MASK }, // 590
  { 0x6, 0x1, 0x1, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG6E32_V_M1_MASK }, // 591
  { 0x6, 0x1, 0x1, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG6E32_V_MF2_MASK }, // 592
  { 0x6, 0x1, 0x1, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG6E64_V_M1_MASK }, // 593
  { 0x7, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG7E8_V_M1 }, // 594
  { 0x7, 0x0, 0x0, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG7E8_V_MF8 }, // 595
  { 0x7, 0x0, 0x0, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG7E8_V_MF4 }, // 596
  { 0x7, 0x0, 0x0, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG7E8_V_MF2 }, // 597
  { 0x7, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG7E16_V_M1 }, // 598
  { 0x7, 0x0, 0x0, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG7E16_V_MF4 }, // 599
  { 0x7, 0x0, 0x0, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG7E16_V_MF2 }, // 600
  { 0x7, 0x0, 0x0, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG7E32_V_M1 }, // 601
  { 0x7, 0x0, 0x0, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG7E32_V_MF2 }, // 602
  { 0x7, 0x0, 0x0, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG7E64_V_M1 }, // 603
  { 0x7, 0x0, 0x0, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG7E8FF_V_M1 }, // 604
  { 0x7, 0x0, 0x0, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG7E8FF_V_MF8 }, // 605
  { 0x7, 0x0, 0x0, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG7E8FF_V_MF4 }, // 606
  { 0x7, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG7E8FF_V_MF2 }, // 607
  { 0x7, 0x0, 0x0, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG7E16FF_V_M1 }, // 608
  { 0x7, 0x0, 0x0, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG7E16FF_V_MF4 }, // 609
  { 0x7, 0x0, 0x0, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG7E16FF_V_MF2 }, // 610
  { 0x7, 0x0, 0x0, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG7E32FF_V_M1 }, // 611
  { 0x7, 0x0, 0x0, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG7E32FF_V_MF2 }, // 612
  { 0x7, 0x0, 0x0, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG7E64FF_V_M1 }, // 613
  { 0x7, 0x0, 0x0, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG7E8_V_M1 }, // 614
  { 0x7, 0x0, 0x0, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG7E8_V_MF8 }, // 615
  { 0x7, 0x0, 0x0, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG7E8_V_MF4 }, // 616
  { 0x7, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG7E8_V_MF2 }, // 617
  { 0x7, 0x0, 0x0, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG7E16_V_M1 }, // 618
  { 0x7, 0x0, 0x0, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG7E16_V_MF4 }, // 619
  { 0x7, 0x0, 0x0, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG7E16_V_MF2 }, // 620
  { 0x7, 0x0, 0x0, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG7E32_V_M1 }, // 621
  { 0x7, 0x0, 0x0, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG7E32_V_MF2 }, // 622
  { 0x7, 0x0, 0x0, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG7E64_V_M1 }, // 623
  { 0x7, 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG7E8_V_M1_TU }, // 624
  { 0x7, 0x0, 0x1, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG7E8_V_MF8_TU }, // 625
  { 0x7, 0x0, 0x1, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG7E8_V_MF4_TU }, // 626
  { 0x7, 0x0, 0x1, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG7E8_V_MF2_TU }, // 627
  { 0x7, 0x0, 0x1, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG7E16_V_M1_TU }, // 628
  { 0x7, 0x0, 0x1, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG7E16_V_MF4_TU }, // 629
  { 0x7, 0x0, 0x1, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG7E16_V_MF2_TU }, // 630
  { 0x7, 0x0, 0x1, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG7E32_V_M1_TU }, // 631
  { 0x7, 0x0, 0x1, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG7E32_V_MF2_TU }, // 632
  { 0x7, 0x0, 0x1, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG7E64_V_M1_TU }, // 633
  { 0x7, 0x0, 0x1, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG7E8FF_V_M1_TU }, // 634
  { 0x7, 0x0, 0x1, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG7E8FF_V_MF8_TU }, // 635
  { 0x7, 0x0, 0x1, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG7E8FF_V_MF4_TU }, // 636
  { 0x7, 0x0, 0x1, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG7E8FF_V_MF2_TU }, // 637
  { 0x7, 0x0, 0x1, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG7E16FF_V_M1_TU }, // 638
  { 0x7, 0x0, 0x1, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG7E16FF_V_MF4_TU }, // 639
  { 0x7, 0x0, 0x1, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG7E16FF_V_MF2_TU }, // 640
  { 0x7, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG7E32FF_V_M1_TU }, // 641
  { 0x7, 0x0, 0x1, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG7E32FF_V_MF2_TU }, // 642
  { 0x7, 0x0, 0x1, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG7E64FF_V_M1_TU }, // 643
  { 0x7, 0x0, 0x1, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG7E8_V_M1_TU }, // 644
  { 0x7, 0x0, 0x1, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG7E8_V_MF8_TU }, // 645
  { 0x7, 0x0, 0x1, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG7E8_V_MF4_TU }, // 646
  { 0x7, 0x0, 0x1, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG7E8_V_MF2_TU }, // 647
  { 0x7, 0x0, 0x1, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG7E16_V_M1_TU }, // 648
  { 0x7, 0x0, 0x1, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG7E16_V_MF4_TU }, // 649
  { 0x7, 0x0, 0x1, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG7E16_V_MF2_TU }, // 650
  { 0x7, 0x0, 0x1, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG7E32_V_M1_TU }, // 651
  { 0x7, 0x0, 0x1, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG7E32_V_MF2_TU }, // 652
  { 0x7, 0x0, 0x1, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG7E64_V_M1_TU }, // 653
  { 0x7, 0x1, 0x1, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG7E8_V_M1_MASK }, // 654
  { 0x7, 0x1, 0x1, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG7E8_V_MF8_MASK }, // 655
  { 0x7, 0x1, 0x1, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG7E8_V_MF4_MASK }, // 656
  { 0x7, 0x1, 0x1, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG7E8_V_MF2_MASK }, // 657
  { 0x7, 0x1, 0x1, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG7E16_V_M1_MASK }, // 658
  { 0x7, 0x1, 0x1, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG7E16_V_MF4_MASK }, // 659
  { 0x7, 0x1, 0x1, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG7E16_V_MF2_MASK }, // 660
  { 0x7, 0x1, 0x1, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG7E32_V_M1_MASK }, // 661
  { 0x7, 0x1, 0x1, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG7E32_V_MF2_MASK }, // 662
  { 0x7, 0x1, 0x1, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG7E64_V_M1_MASK }, // 663
  { 0x7, 0x1, 0x1, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG7E8FF_V_M1_MASK }, // 664
  { 0x7, 0x1, 0x1, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG7E8FF_V_MF8_MASK }, // 665
  { 0x7, 0x1, 0x1, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG7E8FF_V_MF4_MASK }, // 666
  { 0x7, 0x1, 0x1, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG7E8FF_V_MF2_MASK }, // 667
  { 0x7, 0x1, 0x1, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG7E16FF_V_M1_MASK }, // 668
  { 0x7, 0x1, 0x1, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG7E16FF_V_MF4_MASK }, // 669
  { 0x7, 0x1, 0x1, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG7E16FF_V_MF2_MASK }, // 670
  { 0x7, 0x1, 0x1, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG7E32FF_V_M1_MASK }, // 671
  { 0x7, 0x1, 0x1, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG7E32FF_V_MF2_MASK }, // 672
  { 0x7, 0x1, 0x1, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG7E64FF_V_M1_MASK }, // 673
  { 0x7, 0x1, 0x1, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG7E8_V_M1_MASK }, // 674
  { 0x7, 0x1, 0x1, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG7E8_V_MF8_MASK }, // 675
  { 0x7, 0x1, 0x1, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG7E8_V_MF4_MASK }, // 676
  { 0x7, 0x1, 0x1, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG7E8_V_MF2_MASK }, // 677
  { 0x7, 0x1, 0x1, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG7E16_V_M1_MASK }, // 678
  { 0x7, 0x1, 0x1, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG7E16_V_MF4_MASK }, // 679
  { 0x7, 0x1, 0x1, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG7E16_V_MF2_MASK }, // 680
  { 0x7, 0x1, 0x1, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG7E32_V_M1_MASK }, // 681
  { 0x7, 0x1, 0x1, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG7E32_V_MF2_MASK }, // 682
  { 0x7, 0x1, 0x1, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG7E64_V_M1_MASK }, // 683
  { 0x8, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG8E8_V_M1 }, // 684
  { 0x8, 0x0, 0x0, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG8E8_V_MF8 }, // 685
  { 0x8, 0x0, 0x0, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG8E8_V_MF4 }, // 686
  { 0x8, 0x0, 0x0, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG8E8_V_MF2 }, // 687
  { 0x8, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG8E16_V_M1 }, // 688
  { 0x8, 0x0, 0x0, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG8E16_V_MF4 }, // 689
  { 0x8, 0x0, 0x0, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG8E16_V_MF2 }, // 690
  { 0x8, 0x0, 0x0, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG8E32_V_M1 }, // 691
  { 0x8, 0x0, 0x0, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG8E32_V_MF2 }, // 692
  { 0x8, 0x0, 0x0, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG8E64_V_M1 }, // 693
  { 0x8, 0x0, 0x0, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG8E8FF_V_M1 }, // 694
  { 0x8, 0x0, 0x0, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG8E8FF_V_MF8 }, // 695
  { 0x8, 0x0, 0x0, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG8E8FF_V_MF4 }, // 696
  { 0x8, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG8E8FF_V_MF2 }, // 697
  { 0x8, 0x0, 0x0, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG8E16FF_V_M1 }, // 698
  { 0x8, 0x0, 0x0, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG8E16FF_V_MF4 }, // 699
  { 0x8, 0x0, 0x0, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG8E16FF_V_MF2 }, // 700
  { 0x8, 0x0, 0x0, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG8E32FF_V_M1 }, // 701
  { 0x8, 0x0, 0x0, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG8E32FF_V_MF2 }, // 702
  { 0x8, 0x0, 0x0, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG8E64FF_V_M1 }, // 703
  { 0x8, 0x0, 0x0, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG8E8_V_M1 }, // 704
  { 0x8, 0x0, 0x0, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG8E8_V_MF8 }, // 705
  { 0x8, 0x0, 0x0, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG8E8_V_MF4 }, // 706
  { 0x8, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG8E8_V_MF2 }, // 707
  { 0x8, 0x0, 0x0, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG8E16_V_M1 }, // 708
  { 0x8, 0x0, 0x0, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG8E16_V_MF4 }, // 709
  { 0x8, 0x0, 0x0, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG8E16_V_MF2 }, // 710
  { 0x8, 0x0, 0x0, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG8E32_V_M1 }, // 711
  { 0x8, 0x0, 0x0, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG8E32_V_MF2 }, // 712
  { 0x8, 0x0, 0x0, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG8E64_V_M1 }, // 713
  { 0x8, 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG8E8_V_M1_TU }, // 714
  { 0x8, 0x0, 0x1, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG8E8_V_MF8_TU }, // 715
  { 0x8, 0x0, 0x1, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG8E8_V_MF4_TU }, // 716
  { 0x8, 0x0, 0x1, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG8E8_V_MF2_TU }, // 717
  { 0x8, 0x0, 0x1, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG8E16_V_M1_TU }, // 718
  { 0x8, 0x0, 0x1, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG8E16_V_MF4_TU }, // 719
  { 0x8, 0x0, 0x1, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG8E16_V_MF2_TU }, // 720
  { 0x8, 0x0, 0x1, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG8E32_V_M1_TU }, // 721
  { 0x8, 0x0, 0x1, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG8E32_V_MF2_TU }, // 722
  { 0x8, 0x0, 0x1, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG8E64_V_M1_TU }, // 723
  { 0x8, 0x0, 0x1, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG8E8FF_V_M1_TU }, // 724
  { 0x8, 0x0, 0x1, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG8E8FF_V_MF8_TU }, // 725
  { 0x8, 0x0, 0x1, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG8E8FF_V_MF4_TU }, // 726
  { 0x8, 0x0, 0x1, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG8E8FF_V_MF2_TU }, // 727
  { 0x8, 0x0, 0x1, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG8E16FF_V_M1_TU }, // 728
  { 0x8, 0x0, 0x1, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG8E16FF_V_MF4_TU }, // 729
  { 0x8, 0x0, 0x1, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG8E16FF_V_MF2_TU }, // 730
  { 0x8, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG8E32FF_V_M1_TU }, // 731
  { 0x8, 0x0, 0x1, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG8E32FF_V_MF2_TU }, // 732
  { 0x8, 0x0, 0x1, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG8E64FF_V_M1_TU }, // 733
  { 0x8, 0x0, 0x1, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG8E8_V_M1_TU }, // 734
  { 0x8, 0x0, 0x1, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG8E8_V_MF8_TU }, // 735
  { 0x8, 0x0, 0x1, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG8E8_V_MF4_TU }, // 736
  { 0x8, 0x0, 0x1, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG8E8_V_MF2_TU }, // 737
  { 0x8, 0x0, 0x1, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG8E16_V_M1_TU }, // 738
  { 0x8, 0x0, 0x1, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG8E16_V_MF4_TU }, // 739
  { 0x8, 0x0, 0x1, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG8E16_V_MF2_TU }, // 740
  { 0x8, 0x0, 0x1, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG8E32_V_M1_TU }, // 741
  { 0x8, 0x0, 0x1, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG8E32_V_MF2_TU }, // 742
  { 0x8, 0x0, 0x1, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG8E64_V_M1_TU }, // 743
  { 0x8, 0x1, 0x1, 0x0, 0x0, 0x3, 0x0, PseudoVLSEG8E8_V_M1_MASK }, // 744
  { 0x8, 0x1, 0x1, 0x0, 0x0, 0x3, 0x5, PseudoVLSEG8E8_V_MF8_MASK }, // 745
  { 0x8, 0x1, 0x1, 0x0, 0x0, 0x3, 0x6, PseudoVLSEG8E8_V_MF4_MASK }, // 746
  { 0x8, 0x1, 0x1, 0x0, 0x0, 0x3, 0x7, PseudoVLSEG8E8_V_MF2_MASK }, // 747
  { 0x8, 0x1, 0x1, 0x0, 0x0, 0x4, 0x0, PseudoVLSEG8E16_V_M1_MASK }, // 748
  { 0x8, 0x1, 0x1, 0x0, 0x0, 0x4, 0x6, PseudoVLSEG8E16_V_MF4_MASK }, // 749
  { 0x8, 0x1, 0x1, 0x0, 0x0, 0x4, 0x7, PseudoVLSEG8E16_V_MF2_MASK }, // 750
  { 0x8, 0x1, 0x1, 0x0, 0x0, 0x5, 0x0, PseudoVLSEG8E32_V_M1_MASK }, // 751
  { 0x8, 0x1, 0x1, 0x0, 0x0, 0x5, 0x7, PseudoVLSEG8E32_V_MF2_MASK }, // 752
  { 0x8, 0x1, 0x1, 0x0, 0x0, 0x6, 0x0, PseudoVLSEG8E64_V_M1_MASK }, // 753
  { 0x8, 0x1, 0x1, 0x0, 0x1, 0x3, 0x0, PseudoVLSEG8E8FF_V_M1_MASK }, // 754
  { 0x8, 0x1, 0x1, 0x0, 0x1, 0x3, 0x5, PseudoVLSEG8E8FF_V_MF8_MASK }, // 755
  { 0x8, 0x1, 0x1, 0x0, 0x1, 0x3, 0x6, PseudoVLSEG8E8FF_V_MF4_MASK }, // 756
  { 0x8, 0x1, 0x1, 0x0, 0x1, 0x3, 0x7, PseudoVLSEG8E8FF_V_MF2_MASK }, // 757
  { 0x8, 0x1, 0x1, 0x0, 0x1, 0x4, 0x0, PseudoVLSEG8E16FF_V_M1_MASK }, // 758
  { 0x8, 0x1, 0x1, 0x0, 0x1, 0x4, 0x6, PseudoVLSEG8E16FF_V_MF4_MASK }, // 759
  { 0x8, 0x1, 0x1, 0x0, 0x1, 0x4, 0x7, PseudoVLSEG8E16FF_V_MF2_MASK }, // 760
  { 0x8, 0x1, 0x1, 0x0, 0x1, 0x5, 0x0, PseudoVLSEG8E32FF_V_M1_MASK }, // 761
  { 0x8, 0x1, 0x1, 0x0, 0x1, 0x5, 0x7, PseudoVLSEG8E32FF_V_MF2_MASK }, // 762
  { 0x8, 0x1, 0x1, 0x0, 0x1, 0x6, 0x0, PseudoVLSEG8E64FF_V_M1_MASK }, // 763
  { 0x8, 0x1, 0x1, 0x1, 0x0, 0x3, 0x0, PseudoVLSSEG8E8_V_M1_MASK }, // 764
  { 0x8, 0x1, 0x1, 0x1, 0x0, 0x3, 0x5, PseudoVLSSEG8E8_V_MF8_MASK }, // 765
  { 0x8, 0x1, 0x1, 0x1, 0x0, 0x3, 0x6, PseudoVLSSEG8E8_V_MF4_MASK }, // 766
  { 0x8, 0x1, 0x1, 0x1, 0x0, 0x3, 0x7, PseudoVLSSEG8E8_V_MF2_MASK }, // 767
  { 0x8, 0x1, 0x1, 0x1, 0x0, 0x4, 0x0, PseudoVLSSEG8E16_V_M1_MASK }, // 768
  { 0x8, 0x1, 0x1, 0x1, 0x0, 0x4, 0x6, PseudoVLSSEG8E16_V_MF4_MASK }, // 769
  { 0x8, 0x1, 0x1, 0x1, 0x0, 0x4, 0x7, PseudoVLSSEG8E16_V_MF2_MASK }, // 770
  { 0x8, 0x1, 0x1, 0x1, 0x0, 0x5, 0x0, PseudoVLSSEG8E32_V_M1_MASK }, // 771
  { 0x8, 0x1, 0x1, 0x1, 0x0, 0x5, 0x7, PseudoVLSSEG8E32_V_MF2_MASK }, // 772
  { 0x8, 0x1, 0x1, 0x1, 0x0, 0x6, 0x0, PseudoVLSSEG8E64_V_M1_MASK }, // 773
 };

const VLSEGPseudo *getVLSEGPseudo(uint8_t NF, uint8_t Masked, uint8_t IsTU, uint8_t Strided, uint8_t FF, uint8_t Log2SEW, uint8_t LMUL) {
  struct KeyType {
    uint8_t NF;
    uint8_t Masked;
    uint8_t IsTU;
    uint8_t Strided;
    uint8_t FF;
    uint8_t Log2SEW;
    uint8_t LMUL;
  };
  KeyType Key = {NF, Masked, IsTU, Strided, FF, Log2SEW, LMUL};
  auto Table = ArrayRef(RISCVVLSEGTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const VLSEGPseudo &LHS, const KeyType &RHS) {
      if (LHS.NF < RHS.NF)
        return true;
      if (LHS.NF > RHS.NF)
        return false;
      if (LHS.Masked < RHS.Masked)
        return true;
      if (LHS.Masked > RHS.Masked)
        return false;
      if (LHS.IsTU < RHS.IsTU)
        return true;
      if (LHS.IsTU > RHS.IsTU)
        return false;
      if (LHS.Strided < RHS.Strided)
        return true;
      if (LHS.Strided > RHS.Strided)
        return false;
      if (LHS.FF < RHS.FF)
        return true;
      if (LHS.FF > RHS.FF)
        return false;
      if (LHS.Log2SEW < RHS.Log2SEW)
        return true;
      if (LHS.Log2SEW > RHS.Log2SEW)
        return false;
      if (LHS.LMUL < RHS.LMUL)
        return true;
      if (LHS.LMUL > RHS.LMUL)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.NF != Idx->NF ||
      Key.Masked != Idx->Masked ||
      Key.IsTU != Idx->IsTU ||
      Key.Strided != Idx->Strided ||
      Key.FF != Idx->FF ||
      Key.Log2SEW != Idx->Log2SEW ||
      Key.LMUL != Idx->LMUL)
    return nullptr;
  return &*Idx;
}
#endif

#ifdef GET_RISCVVLXSEGTable_DECL
const VLXSEGPseudo *getVLXSEGPseudo(uint8_t NF, uint8_t Masked, uint8_t IsTU, uint8_t Ordered, uint8_t Log2SEW, uint8_t LMUL, uint8_t IndexLMUL);
#endif

#ifdef GET_RISCVVLXSEGTable_IMPL
constexpr VLXSEGPseudo RISCVVLXSEGTable[] = {
  { 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, PseudoVLUXSEG2EI8_V_M1_M1 }, // 0
  { 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x5, PseudoVLUXSEG2EI8_V_MF8_M1 }, // 1
  { 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x6, PseudoVLUXSEG2EI8_V_MF4_M1 }, // 2
  { 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x7, PseudoVLUXSEG2EI8_V_MF2_M1 }, // 3
  { 0x2, 0x0, 0x0, 0x0, 0x3, 0x1, 0x0, PseudoVLUXSEG2EI8_V_M1_M2 }, // 4
  { 0x2, 0x0, 0x0, 0x0, 0x3, 0x1, 0x1, PseudoVLUXSEG2EI8_V_M2_M2 }, // 5
  { 0x2, 0x0, 0x0, 0x0, 0x3, 0x1, 0x6, PseudoVLUXSEG2EI8_V_MF4_M2 }, // 6
  { 0x2, 0x0, 0x0, 0x0, 0x3, 0x1, 0x7, PseudoVLUXSEG2EI8_V_MF2_M2 }, // 7
  { 0x2, 0x0, 0x0, 0x0, 0x3, 0x2, 0x0, PseudoVLUXSEG2EI8_V_M1_M4 }, // 8
  { 0x2, 0x0, 0x0, 0x0, 0x3, 0x2, 0x1, PseudoVLUXSEG2EI8_V_M2_M4 }, // 9
  { 0x2, 0x0, 0x0, 0x0, 0x3, 0x2, 0x2, PseudoVLUXSEG2EI8_V_M4_M4 }, // 10
  { 0x2, 0x0, 0x0, 0x0, 0x3, 0x2, 0x7, PseudoVLUXSEG2EI8_V_MF2_M4 }, // 11
  { 0x2, 0x0, 0x0, 0x0, 0x3, 0x5, 0x5, PseudoVLUXSEG2EI8_V_MF8_MF8 }, // 12
  { 0x2, 0x0, 0x0, 0x0, 0x3, 0x6, 0x5, PseudoVLUXSEG2EI8_V_MF8_MF4 }, // 13
  { 0x2, 0x0, 0x0, 0x0, 0x3, 0x6, 0x6, PseudoVLUXSEG2EI8_V_MF4_MF4 }, // 14
  { 0x2, 0x0, 0x0, 0x0, 0x3, 0x7, 0x5, PseudoVLUXSEG2EI8_V_MF8_MF2 }, // 15
  { 0x2, 0x0, 0x0, 0x0, 0x3, 0x7, 0x6, PseudoVLUXSEG2EI8_V_MF4_MF2 }, // 16
  { 0x2, 0x0, 0x0, 0x0, 0x3, 0x7, 0x7, PseudoVLUXSEG2EI8_V_MF2_MF2 }, // 17
  { 0x2, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, PseudoVLUXSEG2EI16_V_M1_M1 }, // 18
  { 0x2, 0x0, 0x0, 0x0, 0x4, 0x0, 0x1, PseudoVLUXSEG2EI16_V_M2_M1 }, // 19
  { 0x2, 0x0, 0x0, 0x0, 0x4, 0x0, 0x6, PseudoVLUXSEG2EI16_V_MF4_M1 }, // 20
  { 0x2, 0x0, 0x0, 0x0, 0x4, 0x0, 0x7, PseudoVLUXSEG2EI16_V_MF2_M1 }, // 21
  { 0x2, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, PseudoVLUXSEG2EI16_V_M1_M2 }, // 22
  { 0x2, 0x0, 0x0, 0x0, 0x4, 0x1, 0x1, PseudoVLUXSEG2EI16_V_M2_M2 }, // 23
  { 0x2, 0x0, 0x0, 0x0, 0x4, 0x1, 0x2, PseudoVLUXSEG2EI16_V_M4_M2 }, // 24
  { 0x2, 0x0, 0x0, 0x0, 0x4, 0x1, 0x7, PseudoVLUXSEG2EI16_V_MF2_M2 }, // 25
  { 0x2, 0x0, 0x0, 0x0, 0x4, 0x2, 0x0, PseudoVLUXSEG2EI16_V_M1_M4 }, // 26
  { 0x2, 0x0, 0x0, 0x0, 0x4, 0x2, 0x1, PseudoVLUXSEG2EI16_V_M2_M4 }, // 27
  { 0x2, 0x0, 0x0, 0x0, 0x4, 0x2, 0x2, PseudoVLUXSEG2EI16_V_M4_M4 }, // 28
  { 0x2, 0x0, 0x0, 0x0, 0x4, 0x2, 0x3, PseudoVLUXSEG2EI16_V_M8_M4 }, // 29
  { 0x2, 0x0, 0x0, 0x0, 0x4, 0x5, 0x6, PseudoVLUXSEG2EI16_V_MF4_MF8 }, // 30
  { 0x2, 0x0, 0x0, 0x0, 0x4, 0x6, 0x6, PseudoVLUXSEG2EI16_V_MF4_MF4 }, // 31
  { 0x2, 0x0, 0x0, 0x0, 0x4, 0x6, 0x7, PseudoVLUXSEG2EI16_V_MF2_MF4 }, // 32
  { 0x2, 0x0, 0x0, 0x0, 0x4, 0x7, 0x0, PseudoVLUXSEG2EI16_V_M1_MF2 }, // 33
  { 0x2, 0x0, 0x0, 0x0, 0x4, 0x7, 0x6, PseudoVLUXSEG2EI16_V_MF4_MF2 }, // 34
  { 0x2, 0x0, 0x0, 0x0, 0x4, 0x7, 0x7, PseudoVLUXSEG2EI16_V_MF2_MF2 }, // 35
  { 0x2, 0x0, 0x0, 0x0, 0x5, 0x0, 0x0, PseudoVLUXSEG2EI32_V_M1_M1 }, // 36
  { 0x2, 0x0, 0x0, 0x0, 0x5, 0x0, 0x1, PseudoVLUXSEG2EI32_V_M2_M1 }, // 37
  { 0x2, 0x0, 0x0, 0x0, 0x5, 0x0, 0x2, PseudoVLUXSEG2EI32_V_M4_M1 }, // 38
  { 0x2, 0x0, 0x0, 0x0, 0x5, 0x0, 0x7, PseudoVLUXSEG2EI32_V_MF2_M1 }, // 39
  { 0x2, 0x0, 0x0, 0x0, 0x5, 0x1, 0x0, PseudoVLUXSEG2EI32_V_M1_M2 }, // 40
  { 0x2, 0x0, 0x0, 0x0, 0x5, 0x1, 0x1, PseudoVLUXSEG2EI32_V_M2_M2 }, // 41
  { 0x2, 0x0, 0x0, 0x0, 0x5, 0x1, 0x2, PseudoVLUXSEG2EI32_V_M4_M2 }, // 42
  { 0x2, 0x0, 0x0, 0x0, 0x5, 0x1, 0x3, PseudoVLUXSEG2EI32_V_M8_M2 }, // 43
  { 0x2, 0x0, 0x0, 0x0, 0x5, 0x2, 0x1, PseudoVLUXSEG2EI32_V_M2_M4 }, // 44
  { 0x2, 0x0, 0x0, 0x0, 0x5, 0x2, 0x2, PseudoVLUXSEG2EI32_V_M4_M4 }, // 45
  { 0x2, 0x0, 0x0, 0x0, 0x5, 0x2, 0x3, PseudoVLUXSEG2EI32_V_M8_M4 }, // 46
  { 0x2, 0x0, 0x0, 0x0, 0x5, 0x5, 0x7, PseudoVLUXSEG2EI32_V_MF2_MF8 }, // 47
  { 0x2, 0x0, 0x0, 0x0, 0x5, 0x6, 0x0, PseudoVLUXSEG2EI32_V_M1_MF4 }, // 48
  { 0x2, 0x0, 0x0, 0x0, 0x5, 0x6, 0x7, PseudoVLUXSEG2EI32_V_MF2_MF4 }, // 49
  { 0x2, 0x0, 0x0, 0x0, 0x5, 0x7, 0x0, PseudoVLUXSEG2EI32_V_M1_MF2 }, // 50
  { 0x2, 0x0, 0x0, 0x0, 0x5, 0x7, 0x1, PseudoVLUXSEG2EI32_V_M2_MF2 }, // 51
  { 0x2, 0x0, 0x0, 0x0, 0x5, 0x7, 0x7, PseudoVLUXSEG2EI32_V_MF2_MF2 }, // 52
  { 0x2, 0x0, 0x0, 0x0, 0x6, 0x0, 0x0, PseudoVLUXSEG2EI64_V_M1_M1 }, // 53
  { 0x2, 0x0, 0x0, 0x0, 0x6, 0x0, 0x1, PseudoVLUXSEG2EI64_V_M2_M1 }, // 54
  { 0x2, 0x0, 0x0, 0x0, 0x6, 0x0, 0x2, PseudoVLUXSEG2EI64_V_M4_M1 }, // 55
  { 0x2, 0x0, 0x0, 0x0, 0x6, 0x0, 0x3, PseudoVLUXSEG2EI64_V_M8_M1 }, // 56
  { 0x2, 0x0, 0x0, 0x0, 0x6, 0x1, 0x1, PseudoVLUXSEG2EI64_V_M2_M2 }, // 57
  { 0x2, 0x0, 0x0, 0x0, 0x6, 0x1, 0x2, PseudoVLUXSEG2EI64_V_M4_M2 }, // 58
  { 0x2, 0x0, 0x0, 0x0, 0x6, 0x1, 0x3, PseudoVLUXSEG2EI64_V_M8_M2 }, // 59
  { 0x2, 0x0, 0x0, 0x0, 0x6, 0x2, 0x2, PseudoVLUXSEG2EI64_V_M4_M4 }, // 60
  { 0x2, 0x0, 0x0, 0x0, 0x6, 0x2, 0x3, PseudoVLUXSEG2EI64_V_M8_M4 }, // 61
  { 0x2, 0x0, 0x0, 0x0, 0x6, 0x5, 0x0, PseudoVLUXSEG2EI64_V_M1_MF8 }, // 62
  { 0x2, 0x0, 0x0, 0x0, 0x6, 0x6, 0x0, PseudoVLUXSEG2EI64_V_M1_MF4 }, // 63
  { 0x2, 0x0, 0x0, 0x0, 0x6, 0x6, 0x1, PseudoVLUXSEG2EI64_V_M2_MF4 }, // 64
  { 0x2, 0x0, 0x0, 0x0, 0x6, 0x7, 0x0, PseudoVLUXSEG2EI64_V_M1_MF2 }, // 65
  { 0x2, 0x0, 0x0, 0x0, 0x6, 0x7, 0x1, PseudoVLUXSEG2EI64_V_M2_MF2 }, // 66
  { 0x2, 0x0, 0x0, 0x0, 0x6, 0x7, 0x2, PseudoVLUXSEG2EI64_V_M4_MF2 }, // 67
  { 0x2, 0x0, 0x0, 0x1, 0x3, 0x0, 0x0, PseudoVLOXSEG2EI8_V_M1_M1 }, // 68
  { 0x2, 0x0, 0x0, 0x1, 0x3, 0x0, 0x5, PseudoVLOXSEG2EI8_V_MF8_M1 }, // 69
  { 0x2, 0x0, 0x0, 0x1, 0x3, 0x0, 0x6, PseudoVLOXSEG2EI8_V_MF4_M1 }, // 70
  { 0x2, 0x0, 0x0, 0x1, 0x3, 0x0, 0x7, PseudoVLOXSEG2EI8_V_MF2_M1 }, // 71
  { 0x2, 0x0, 0x0, 0x1, 0x3, 0x1, 0x0, PseudoVLOXSEG2EI8_V_M1_M2 }, // 72
  { 0x2, 0x0, 0x0, 0x1, 0x3, 0x1, 0x1, PseudoVLOXSEG2EI8_V_M2_M2 }, // 73
  { 0x2, 0x0, 0x0, 0x1, 0x3, 0x1, 0x6, PseudoVLOXSEG2EI8_V_MF4_M2 }, // 74
  { 0x2, 0x0, 0x0, 0x1, 0x3, 0x1, 0x7, PseudoVLOXSEG2EI8_V_MF2_M2 }, // 75
  { 0x2, 0x0, 0x0, 0x1, 0x3, 0x2, 0x0, PseudoVLOXSEG2EI8_V_M1_M4 }, // 76
  { 0x2, 0x0, 0x0, 0x1, 0x3, 0x2, 0x1, PseudoVLOXSEG2EI8_V_M2_M4 }, // 77
  { 0x2, 0x0, 0x0, 0x1, 0x3, 0x2, 0x2, PseudoVLOXSEG2EI8_V_M4_M4 }, // 78
  { 0x2, 0x0, 0x0, 0x1, 0x3, 0x2, 0x7, PseudoVLOXSEG2EI8_V_MF2_M4 }, // 79
  { 0x2, 0x0, 0x0, 0x1, 0x3, 0x5, 0x5, PseudoVLOXSEG2EI8_V_MF8_MF8 }, // 80
  { 0x2, 0x0, 0x0, 0x1, 0x3, 0x6, 0x5, PseudoVLOXSEG2EI8_V_MF8_MF4 }, // 81
  { 0x2, 0x0, 0x0, 0x1, 0x3, 0x6, 0x6, PseudoVLOXSEG2EI8_V_MF4_MF4 }, // 82
  { 0x2, 0x0, 0x0, 0x1, 0x3, 0x7, 0x5, PseudoVLOXSEG2EI8_V_MF8_MF2 }, // 83
  { 0x2, 0x0, 0x0, 0x1, 0x3, 0x7, 0x6, PseudoVLOXSEG2EI8_V_MF4_MF2 }, // 84
  { 0x2, 0x0, 0x0, 0x1, 0x3, 0x7, 0x7, PseudoVLOXSEG2EI8_V_MF2_MF2 }, // 85
  { 0x2, 0x0, 0x0, 0x1, 0x4, 0x0, 0x0, PseudoVLOXSEG2EI16_V_M1_M1 }, // 86
  { 0x2, 0x0, 0x0, 0x1, 0x4, 0x0, 0x1, PseudoVLOXSEG2EI16_V_M2_M1 }, // 87
  { 0x2, 0x0, 0x0, 0x1, 0x4, 0x0, 0x6, PseudoVLOXSEG2EI16_V_MF4_M1 }, // 88
  { 0x2, 0x0, 0x0, 0x1, 0x4, 0x0, 0x7, PseudoVLOXSEG2EI16_V_MF2_M1 }, // 89
  { 0x2, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, PseudoVLOXSEG2EI16_V_M1_M2 }, // 90
  { 0x2, 0x0, 0x0, 0x1, 0x4, 0x1, 0x1, PseudoVLOXSEG2EI16_V_M2_M2 }, // 91
  { 0x2, 0x0, 0x0, 0x1, 0x4, 0x1, 0x2, PseudoVLOXSEG2EI16_V_M4_M2 }, // 92
  { 0x2, 0x0, 0x0, 0x1, 0x4, 0x1, 0x7, PseudoVLOXSEG2EI16_V_MF2_M2 }, // 93
  { 0x2, 0x0, 0x0, 0x1, 0x4, 0x2, 0x0, PseudoVLOXSEG2EI16_V_M1_M4 }, // 94
  { 0x2, 0x0, 0x0, 0x1, 0x4, 0x2, 0x1, PseudoVLOXSEG2EI16_V_M2_M4 }, // 95
  { 0x2, 0x0, 0x0, 0x1, 0x4, 0x2, 0x2, PseudoVLOXSEG2EI16_V_M4_M4 }, // 96
  { 0x2, 0x0, 0x0, 0x1, 0x4, 0x2, 0x3, PseudoVLOXSEG2EI16_V_M8_M4 }, // 97
  { 0x2, 0x0, 0x0, 0x1, 0x4, 0x5, 0x6, PseudoVLOXSEG2EI16_V_MF4_MF8 }, // 98
  { 0x2, 0x0, 0x0, 0x1, 0x4, 0x6, 0x6, PseudoVLOXSEG2EI16_V_MF4_MF4 }, // 99
  { 0x2, 0x0, 0x0, 0x1, 0x4, 0x6, 0x7, PseudoVLOXSEG2EI16_V_MF2_MF4 }, // 100
  { 0x2, 0x0, 0x0, 0x1, 0x4, 0x7, 0x0, PseudoVLOXSEG2EI16_V_M1_MF2 }, // 101
  { 0x2, 0x0, 0x0, 0x1, 0x4, 0x7, 0x6, PseudoVLOXSEG2EI16_V_MF4_MF2 }, // 102
  { 0x2, 0x0, 0x0, 0x1, 0x4, 0x7, 0x7, PseudoVLOXSEG2EI16_V_MF2_MF2 }, // 103
  { 0x2, 0x0, 0x0, 0x1, 0x5, 0x0, 0x0, PseudoVLOXSEG2EI32_V_M1_M1 }, // 104
  { 0x2, 0x0, 0x0, 0x1, 0x5, 0x0, 0x1, PseudoVLOXSEG2EI32_V_M2_M1 }, // 105
  { 0x2, 0x0, 0x0, 0x1, 0x5, 0x0, 0x2, PseudoVLOXSEG2EI32_V_M4_M1 }, // 106
  { 0x2, 0x0, 0x0, 0x1, 0x5, 0x0, 0x7, PseudoVLOXSEG2EI32_V_MF2_M1 }, // 107
  { 0x2, 0x0, 0x0, 0x1, 0x5, 0x1, 0x0, PseudoVLOXSEG2EI32_V_M1_M2 }, // 108
  { 0x2, 0x0, 0x0, 0x1, 0x5, 0x1, 0x1, PseudoVLOXSEG2EI32_V_M2_M2 }, // 109
  { 0x2, 0x0, 0x0, 0x1, 0x5, 0x1, 0x2, PseudoVLOXSEG2EI32_V_M4_M2 }, // 110
  { 0x2, 0x0, 0x0, 0x1, 0x5, 0x1, 0x3, PseudoVLOXSEG2EI32_V_M8_M2 }, // 111
  { 0x2, 0x0, 0x0, 0x1, 0x5, 0x2, 0x1, PseudoVLOXSEG2EI32_V_M2_M4 }, // 112
  { 0x2, 0x0, 0x0, 0x1, 0x5, 0x2, 0x2, PseudoVLOXSEG2EI32_V_M4_M4 }, // 113
  { 0x2, 0x0, 0x0, 0x1, 0x5, 0x2, 0x3, PseudoVLOXSEG2EI32_V_M8_M4 }, // 114
  { 0x2, 0x0, 0x0, 0x1, 0x5, 0x5, 0x7, PseudoVLOXSEG2EI32_V_MF2_MF8 }, // 115
  { 0x2, 0x0, 0x0, 0x1, 0x5, 0x6, 0x0, PseudoVLOXSEG2EI32_V_M1_MF4 }, // 116
  { 0x2, 0x0, 0x0, 0x1, 0x5, 0x6, 0x7, PseudoVLOXSEG2EI32_V_MF2_MF4 }, // 117
  { 0x2, 0x0, 0x0, 0x1, 0x5, 0x7, 0x0, PseudoVLOXSEG2EI32_V_M1_MF2 }, // 118
  { 0x2, 0x0, 0x0, 0x1, 0x5, 0x7, 0x1, PseudoVLOXSEG2EI32_V_M2_MF2 }, // 119
  { 0x2, 0x0, 0x0, 0x1, 0x5, 0x7, 0x7, PseudoVLOXSEG2EI32_V_MF2_MF2 }, // 120
  { 0x2, 0x0, 0x0, 0x1, 0x6, 0x0, 0x0, PseudoVLOXSEG2EI64_V_M1_M1 }, // 121
  { 0x2, 0x0, 0x0, 0x1, 0x6, 0x0, 0x1, PseudoVLOXSEG2EI64_V_M2_M1 }, // 122
  { 0x2, 0x0, 0x0, 0x1, 0x6, 0x0, 0x2, PseudoVLOXSEG2EI64_V_M4_M1 }, // 123
  { 0x2, 0x0, 0x0, 0x1, 0x6, 0x0, 0x3, PseudoVLOXSEG2EI64_V_M8_M1 }, // 124
  { 0x2, 0x0, 0x0, 0x1, 0x6, 0x1, 0x1, PseudoVLOXSEG2EI64_V_M2_M2 }, // 125
  { 0x2, 0x0, 0x0, 0x1, 0x6, 0x1, 0x2, PseudoVLOXSEG2EI64_V_M4_M2 }, // 126
  { 0x2, 0x0, 0x0, 0x1, 0x6, 0x1, 0x3, PseudoVLOXSEG2EI64_V_M8_M2 }, // 127
  { 0x2,