

/** @defgroup G_TUTORIAL1 Tutorial 1 (Basic Usage of AqBanking)
 * @ingroup G_TUTORIALS
 * @brief Basic usage of AqBanking
 *
 * This tutorial simply creates an instance of AqBanking, initializes and
 * deinitializes it.
 *
 * You must either choose a frontend to be used with AqBanking or create
 * one yourself by implementing the user interface callbacks of AqBanking.
 *
 * However, for simplicity reasons we use the console frontend CBanking
 * which implements these callbacks for you.
 *
 * There are other frontends, e.g. G2Banking for GTK2/Gnome, QBanking for
 * QT3 or KDE3 or KBanking for KDE3.
 *
 * @include "tutorial1.c"
 */

/** @defgroup G_TUTORIAL2 Tutorial 2 (Extended Usage of AqBanking)
 * @ingroup G_TUTORIALS
 * @brief Extended usage of AqBanking
 *
 * This tutorial shows the list of accounts currently known to AqBanking.
 *
 * It also gives an introduction into the usage of XXX_List2's and list2
 * iterators.
 *
 * You must either choose a frontend to be used with AqBanking or create
 * one yourself by implementing the user interface callbacks of AqBanking.
 *
 * However, for simplicity reasons we use the console frontend CBanking
 * which implements these callbacks for you.
 *
 * There are other frontends, e.g. G2Banking for GTK2/Gnome, QBanking for
 * QT3 or KDE3 or KBanking for KDE3.
 *
 * @include "tutorial2.c"
 */

/** @defgroup G_TUTORIAL3 Tutorial 3 (Working With Jobs)
 * @ingroup G_TUTORIALS
 * @brief Working with jobs
 *
 * This tutorial shows how to use jobs in AqBanking.
 * In this example we retrieve transaction statements for a given account.
 *
 * You must either choose a frontend to be used with AqBanking or create
 * one yourself by implementing the user interface callbacks of AqBanking.
 *
 * However, for simplicity reasons we use the console frontend CBanking
 * which implements these callbacks for you.
 *
 * There are other frontends, e.g. G2Banking for GTK2/Gnome, QBanking for
 * QT3 or KDE3 or KBanking for KDE3.
 *
 * @include "tutorial3.c"
 */


