# Foenix F256 line machine definitions

## Supported file formats
| Format | Option name |
|---|---|
| Binary | -fbin |
| Foenix .PGZ | -ffxpgz |
| Foenix F256 Kernel User Program | -ffxkup |
| Foenix F256 Kernel User Program, slot padding | -ffxkupp |

### Foenix executable (-ffxpgz)

This is an executable format which can be loaded and executed by the F256 `pexec` mechanism.

### Foenix F256 Kernel User Program (-fxkup, -fxkupp)

A Kernel User Program may be flashed and run from a slot in flash memory. It can also be executed by the F256 DOS. The padded version is mostly useful for flash, as it is padded up to an 8 KiB slot size. The unpadded one is mostly useful for executing the program from DOS, as it will only take up the space it needs on disk.

Kernel user programs require a different memory layout than the regular F256 layout built into the linker. The following layout is suitable. Code and data will be placed in slots 1 to 4, while using the other slots for BSS, except the IO slot.

```
POOL zp $0000 0 $0100
POOL low_ram $0200 0 $1E00
POOL ram $200A 0 ($8000-$000A) $200A
POOL dos $A000 0 $2000
POOL io $C000 0 $2000
POOL hram $E000 0 $2000

GROUP HOME hram
GROUP CODE ram
GROUP DATA ram
GROUP BSS low_ram dos hram ram
GROUP IO io
GROUP ZP zp

FORMATS KUP KUPP
```

Kernel User Programs contain a header, which is generated by the linker. The header is followed by the program's name, which is used to locate the program in flash memory. This name must be specified in an assembly source file, and can be done with a section:

```
    SECTION "Name",CODE[$200A],ROOT
    DB  "myprogram",0
```


## Pools
The built-in machine definition declares several pools covering different areas of the address space. The IO hole at $C000-$DFFF is excluded in this configuration. More advanced configurations can be defined by the user by providing a linker machine definition file.

| Pool | Area | Description |
|---|---|---|
| ZERO_PAGE | $10-$FF | Zero page. |
| MAIN_RAM | $200-$BFFF | Main memory area. |
| HIGH_RAM | $E000-$FFFF | High memory area. |

The HIGH_RAM pool covers vectors and is useful for code common to all MMU configurations.

## Groups

| Group | Pools |
|---|---|
| HOME | HIGH_RAM |
| CODE | MAIN_RAM, HIGH_RAM |
| DATA | MAIN_RAM |
| BSS | MAIN_RAM |
| ZP| ZERO_PAGE |
