/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.basex.core.Context;
import org.basex.core.Databases;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.cmd.ABackup;
import org.basex.core.cmd.DropDB;
import org.basex.core.cmd.Open;
import org.basex.core.locks.LockList;
import org.basex.io.IOFile;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class Restore
extends ABackup {
    private int total;
    private int curr;
    private boolean closed;

    public Restore(String name) {
        super(name != null ? name : "");
    }

    @Override
    protected boolean run() {
        String name = this.args[0];
        if (!name.isEmpty() && !Databases.validName(name)) {
            return this.error(Text.NAME_INVALID_X, name);
        }
        StringList backups = this.context.databases.backups(name);
        if (backups.isEmpty()) {
            return this.error(Text.BACKUP_NOT_FOUND_X, name);
        }
        String backup = (String)backups.get(0);
        String db = Databases.name(backup);
        if (!db.isEmpty()) {
            if (!this.closed) {
                this.closed = Restore.close(this.context, db);
            }
            if (this.context.pinned(db)) {
                return this.error(Text.DB_PINNED_X, db);
            }
        }
        try {
            Restore.restore(db, backup, this.soptions, this);
            return db.isEmpty() || !this.closed || new Open(db).run(this.context) ? this.info(Text.DB_RESTORED_X, backup, this.jc().performance) : this.error(Text.DB_NOT_RESTORED_X, db);
        }
        catch (IOException ex) {
            Util.debug(ex);
            return this.error(Text.DB_NOT_RESTORED_X, db);
        }
    }

    public static void restore(String db, String backup, StaticOptions sopts, Restore cmd) throws IOException {
        DropDB.drop(db, sopts);
        IOFile dbPath = sopts.dbPath();
        IOFile file = new IOFile(dbPath, backup + ".zip");
        if (cmd != null) {
            try (ZipFile zip = new ZipFile(file.file());){
                cmd.total = zip.size();
            }
        }
        try (FileInputStream is = file.inputStream();
             ZipInputStream in = new ZipInputStream(is);){
            ZipEntry ze;
            while ((ze = in.getNextEntry()) != null) {
                IOFile trg = new IOFile(dbPath, ze.getName());
                if (ze.isDirectory()) {
                    trg.md();
                } else {
                    trg.parent().md();
                    trg.write(in);
                }
                if (cmd == null) continue;
                ++cmd.curr;
            }
        }
    }

    @Override
    public void addLocks() {
        LockList list = this.jc().locks.writes;
        String name = this.args[0];
        String db = Databases.name(name);
        if (db.isEmpty()) {
            list.addGlobal();
        } else {
            list.add(name).add(db);
        }
    }

    @Override
    public String shortInfo() {
        return Text.RESTORE + "...";
    }

    @Override
    public boolean newData(Context ctx) {
        this.closed = Restore.close(ctx, this.args[0]);
        return this.closed;
    }

    @Override
    public boolean supportsProg() {
        return true;
    }

    @Override
    public double progressInfo() {
        return (double)this.curr / (double)this.total;
    }
}

