/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Arith;
import org.basex.query.expr.Calc;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.IntPos;
import org.basex.query.expr.MixedPos;
import org.basex.query.expr.Range;
import org.basex.query.expr.SimplePos;
import org.basex.query.expr.Single;
import org.basex.query.func.Function;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;
import org.basex.util.list.ElementList;
import org.basex.util.list.IntList;
import org.basex.util.list.LongList;
import org.basex.util.list.ObjectList;

public final class Pos
extends Single {
    private Pos(InputInfo info, Expr expr) {
        super(info, expr, SeqType.BOOLEAN_O);
    }

    public static Expr get(Expr positions, CmpV.OpV op, InputInfo info, CompileContext cc, Expr ref) throws QueryException {
        Expr pos = positions.optimizePos(op, cc);
        if (pos instanceof Bln) {
            return pos;
        }
        if (op == CmpV.OpV.EQ) {
            if (cc.values(true, pos)) {
                pos = Pos.ddo((Value)pos);
            }
            if (pos == Empty.VALUE) {
                return Bln.FALSE;
            }
            if (pos instanceof RangeSeq) {
                RangeSeq rs = (RangeSeq)pos;
                return IntPos.get(rs.min(), rs.max(), info);
            }
            if (pos instanceof Range) {
                Range rng = (Range)pos;
                if (rng.ints) {
                    if (pos.isSimple()) {
                        return new SimplePos(info, pos.args());
                    }
                    return ref instanceof Pos ? null : new Pos(info, pos);
                }
            }
        }
        if (pos instanceof ANum) {
            ANum num = (ANum)pos;
            long p = num.itr();
            boolean exact = (double)p == num.dbl();
            switch (op) {
                case EQ: {
                    return exact ? IntPos.get(p, p, info) : Bln.FALSE;
                }
                case GE: {
                    return IntPos.get(exact ? p : p + 1L, Long.MAX_VALUE, info);
                }
                case GT: {
                    return IntPos.get(p + 1L, Long.MAX_VALUE, info);
                }
                case LE: {
                    return IntPos.get(1L, p, info);
                }
                case LT: {
                    return IntPos.get(1L, exact ? p - 1L : p, info);
                }
                case NE: {
                    return exact ? (p < 2L ? IntPos.get(p + 1L, Long.MAX_VALUE, info) : null) : Bln.TRUE;
                }
            }
        }
        SeqType st = pos.seqType();
        Type type = st.type;
        boolean integer = type.instanceOf(AtomType.INTEGER);
        if (st.zeroOrOne() && type.isNumberOrUntyped()) {
            Expr min = null;
            Expr max = null;
            switch (op) {
                case EQ: {
                    min = pos;
                    break;
                }
                case GE: {
                    min = pos;
                    max = Itr.MAX;
                    break;
                }
                case GT: {
                    min = new Arith(info, integer ? pos : cc.function(Function.FLOOR, info, pos), (Expr)Itr.ONE, Calc.ADD).optimize(cc);
                    max = Itr.MAX;
                    break;
                }
                case LE: {
                    min = Itr.ONE;
                    max = pos;
                    break;
                }
                case LT: {
                    min = Itr.ONE;
                    max = new Arith(info, integer ? pos : cc.function(Function.CEILING, info, pos), (Expr)Itr.ONE, Calc.SUBTRACT).optimize(cc);
                    break;
                }
            }
            if (min != null) {
                if (pos.isSimple()) {
                    return SimplePos.get(min, max, info);
                }
                if (max == null) {
                    return ref instanceof Pos ? null : new Pos(info, min);
                }
                if (integer) {
                    return Pos.get(new Range(info, min, max).optimize(cc), CmpV.OpV.EQ, info, cc, ref);
                }
            }
        }
        if (op == CmpV.OpV.EQ && pos.isSimple()) {
            return ref instanceof MixedPos ? null : new MixedPos(info, pos);
        }
        return null;
    }

    public static Value ddo(Value value) throws QueryException {
        ElementList il;
        if (value instanceof RangeSeq) {
            return value;
        }
        boolean small = true;
        LongList list = new LongList();
        for (Item item : value) {
            double d = item.dbl(null);
            long l = (long)d;
            if (l <= 0L || d != (double)l) continue;
            list.add(l);
            small = small && l == (long)((int)l);
        }
        list.ddo();
        if (small) {
            il = new IntList(list.size());
            for (long l : list.finish()) {
                ((IntList)il).add((int)l);
            }
            return IntSeq.get(((IntList)il).finish());
        }
        il = new ItemList(list.size());
        for (long l : list.finish()) {
            ((ObjectList)il).add(Itr.get(l));
        }
        return ((ItemList)il).value();
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        return super.compile(cc).optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.expr = this.expr.simplifyFor(CompileContext.Simplify.NUMBER, cc).simplifyFor(CompileContext.Simplify.DISTINCT, cc);
        Expr ex = Pos.get(this.expr, CmpV.OpV.EQ, this.info, cc, this);
        return ex != null ? cc.replaceWith(this, ex) : this;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        return Bln.get(this.test(qc, ii, 0L));
    }

    @Override
    public boolean test(QueryContext qc, InputInfo ii, long pos) throws QueryException {
        this.ctxValue(qc);
        Value value = this.expr.value(qc);
        if (value.isEmpty()) {
            return false;
        }
        long p = qc.focus.pos;
        long vs = value.size();
        double min = this.toDouble(value.itemAt(0L));
        double max = vs == 1L ? min : this.toDouble(value.itemAt(vs - 1L));
        return (double)p >= min && (double)p <= max;
    }

    @Override
    public Pos copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new Pos(this.info, this.expr.copy(cc, vm)));
    }

    @Override
    public boolean has(Flag ... flags) {
        return Flag.POS.oneOf(flags) || Flag.CTX.oneOf(flags) || super.has(flags);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr ex;
        if (mode == CompileContext.Simplify.PREDICATE && (ex = this.expr.simplifyFor(mode, cc)) != this.expr) {
            return ex;
        }
        return this.simplify(mode, cc);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Pos && super.equals(obj);
    }

    @Override
    public String description() {
        return "positional access";
    }

    @Override
    public void toString(QueryString qs) {
        qs.function(Function.POSITION, new Object[0]).token("=").token(this.expr);
    }
}

