/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import org.basex.io.out.ArrayOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.archive.ArchiveFn;
import org.basex.query.func.archive.ArchiveOut;
import org.basex.query.func.archive.ArchiveText;
import org.basex.query.func.archive.CreateOptions;
import org.basex.query.iter.Iter;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.util.InputInfo;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;

public class ArchiveCreate
extends ArchiveFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        ArrayOutput ao = new ArrayOutput();
        this.create(ao, qc);
        return B64.get(ao.finish());
    }

    public final void create(OutputStream os, QueryContext qc) throws QueryException {
        Map<String, Map.Entry<Item, Item>> files = this.toFiles(this.arg(0), this.arg(1), qc);
        CreateOptions options = this.toOptions(this.arg(2), new CreateOptions(), qc);
        this.create(files, options, os, qc);
    }

    final void create(Map<String, Map.Entry<Item, Item>> entries, CreateOptions opts, OutputStream os, QueryContext qc) throws QueryException {
        String format = opts.get(CreateOptions.FORMAT).toLowerCase(Locale.ENGLISH);
        if (format.equals("gzip") && entries.size() > 1) {
            throw QueryError.ARCHIVE_SINGLE_X.get(this.info, format);
        }
        int level = this.level(opts);
        try (ArchiveOut out = ArchiveOut.get(format, this.info, os);){
            out.level(level);
            try {
                for (Map.Entry<Item, Item> entry : entries.values()) {
                    this.add(entry, out, level, "", qc);
                }
            }
            catch (IOException ex) {
                throw QueryError.ARCHIVE_ERROR_X.get(this.info, ex);
            }
        }
    }

    final int level(CreateOptions options) throws QueryException {
        int level = 8;
        String format = options.get(CreateOptions.FORMAT);
        String alg = options.get(CreateOptions.ALGORITHM);
        if (alg != null) {
            if (format.equals("zip") && !Strings.eq(alg, "stored", "deflate") || format.equals("gzip") && !Strings.eq(alg, "deflate")) {
                throw QueryError.ARCHIVE_FORMAT_X_X.get(this.info, CreateOptions.ALGORITHM.name(), alg);
            }
            if (Strings.eq(alg, "stored")) {
                level = 0;
            }
        }
        return level;
    }

    final void add(Map.Entry<Item, Item> file, ArchiveOut out, int level, String root, QueryContext qc) throws QueryException, IOException {
        int lvl;
        Item header = file.getKey();
        ZipEntry ze = new ZipEntry(root + this.name(header));
        long time = this.timestamp(header, qc);
        if (time >= 0L) {
            ze.setTime(time);
        }
        out.level((lvl = this.level(header)) >= 0 ? lvl : level);
        Item content = file.getValue();
        if (content instanceof Bin) {
            Bin bin = (Bin)content;
            out.write(ze, bin, this.info);
        } else if (content != XQArray.empty()) {
            out.write(ze, this.encode(this.toBytes(content, qc), this.encoding(header), false, qc));
        }
    }

    final Map<String, Map.Entry<Item, Item>> toFiles(Expr entries, Expr contents, QueryContext qc) throws QueryException {
        Iter entrs = entries.iter(qc);
        Iter cntnts = contents.iter(qc);
        LinkedHashMap<String, Map.Entry<Item, Item>> files = new LinkedHashMap<String, Map.Entry<Item, Item>>();
        int e = 0;
        int c = 0;
        while (true) {
            Item entry = qc.next(entrs);
            Item content = cntnts.next();
            if (entry == null || content == null) {
                if (content != null) {
                    do {
                        ++c;
                    } while (cntnts.next() != null);
                }
                if (entry != null) {
                    do {
                        ++e;
                    } while (entrs.next() != null);
                }
                if (e == c) break;
                throw QueryError.ARCHIVE_NUMBER_X_X.get(this.info, e, c);
            }
            files.put(this.toString(entry, qc), new AbstractMap.SimpleEntry<Item, Item>(entry, content));
            ++e;
            ++c;
        }
        return files;
    }

    final String name(Item header) throws QueryException {
        String name = Token.string(header.string(this.info));
        if (name.isEmpty()) {
            throw QueryError.ARCHIVE_NAME.get(this.info, new Object[0]);
        }
        return Prop.WIN ? name.replace('\\', '/') : name;
    }

    final int level(Item header) throws QueryException {
        ANode node;
        byte[] value;
        if (header instanceof ANode && (value = (node = (ANode)header).attribute(ArchiveText.Q_LEVEL)) != null) {
            int level = Token.toInt(value);
            if (level < 0 || level > 9) {
                throw QueryError.ARCHIVE_LEVEL_X.get(this.info, new Object[]{value});
            }
            return level;
        }
        return -1;
    }

    final long timestamp(Item header, QueryContext qc) throws QueryException {
        if (header instanceof ANode) {
            ANode node = (ANode)header;
            byte[] value = node.attribute(ArchiveText.Q_LAST_MODIFIED);
            try {
                if (value != null) {
                    return this.toMs(new Dtm(value, this.info), qc);
                }
            }
            catch (QueryException ex) {
                Util.debug(ex);
                throw QueryError.ARCHIVE_TIMESTAMP_X.get(this.info, new Object[]{value});
            }
        }
        return -1L;
    }

    final String encoding(Item header) throws QueryException {
        ANode node;
        byte[] value;
        if (header instanceof ANode && (value = (node = (ANode)header).attribute(ArchiveText.Q_ENCODING)) != null) {
            return this.toEncodingOrNull(Token.string(value), QueryError.ARCHIVE_ENCODE1_X);
        }
        return "UTF-8";
    }
}

