/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core;

public class TextContainer {
    private char[] buffer;
    private int offset;
    private int length;

    public TextContainer() {
        this(new char[5120]);
    }

    public TextContainer(char[] initialBuffer) {
        this(initialBuffer, 0);
    }

    public TextContainer(char[] initialBuffer, int length) {
        this(initialBuffer, 0, length);
    }

    public TextContainer(char[] initialBuffer, int offset, int length) {
        this.buffer = initialBuffer;
        this.offset = offset;
        this.length = length;
    }

    public final void append(char[] characters) {
        this.append(characters, characters.length);
    }

    public final void append(char[] characters, int length) {
        this.append(characters, 0, length);
    }

    public final void append(char[] characters, int xoffset, int xlength) {
        while (this.offset + this.length + xoffset + xlength >= this.buffer.length) {
            this.growBuffer();
        }
        System.arraycopy(characters, xoffset, this.buffer, this.offset + this.length, xlength);
        this.length += xlength;
    }

    private final void growBuffer() {
        char[] newBuffer = new char[this.buffer.length << 1];
        System.arraycopy(this.buffer, this.offset, newBuffer, 0, this.length);
        this.buffer = newBuffer;
        this.offset = 0;
    }

    public final void append(char character) {
        if (this.offset + this.length + 1 == this.buffer.length) {
            this.growBuffer();
        }
        this.buffer[this.length++] = character;
    }

    public char[] toCharArray() {
        char[] takeaway = new char[this.length];
        System.arraycopy(this.buffer, this.offset, takeaway, 0, this.length);
        return takeaway;
    }

    public String toString() {
        return new String(this.buffer, this.offset, this.length);
    }

    public char[] getRawCharArray() {
        return this.buffer;
    }

    public void setRawCharArray(char[] buffer) {
        this.buffer = buffer;
    }

    public char charAt(int index) {
        return this.buffer[this.offset + index];
    }

    public int length() {
        return this.length;
    }

    public int offset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getRawPosition() {
        return this.length;
    }

    public void setRawPosition(int position) {
        this.length = position;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void reset() {
        this.offset = 0;
        this.length = 0;
    }
}

