/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.xqitem;

import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.util.Properties;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQItemAccessor;
import javax.xml.xquery.XQItemType;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public abstract class XQItemBase
implements XQItem,
XQItemAccessor,
Cloneable {
    protected XQItemType xqItemType = null;
    protected String nodeUriString = null;
    protected URI nodeUri = null;

    public boolean getBoolean() throws XQException {
        throw new XQExceptionImpl(this.getItemTypeAsString() + " can not be cast to a boolean.", "XQJIA01");
    }

    public byte getByte() throws XQException {
        throw new XQExceptionImpl(this.getItemTypeAsString() + " can not be cast to a byte.", "XQJIA02");
    }

    public double getDouble() throws XQException {
        throw new XQExceptionImpl(this.getItemTypeAsString() + " can not be cast to a double.", "XQJIA03");
    }

    public float getFloat() throws XQException {
        throw new XQExceptionImpl(this.getItemTypeAsString() + " can not be cast to a float.", "XQJIA04");
    }

    public int getInt() throws XQException {
        throw new XQExceptionImpl(this.getItemTypeAsString() + " can not be cast to a int.", "XQJIA05");
    }

    public XQItemType getItemType() throws XQException {
        return this.xqItemType;
    }

    public String getAtomicValue() throws XQException {
        throw new XQExceptionImpl(this.getItemTypeAsString() + " can not be converted into a atomic value.", "XQJIA06");
    }

    public long getLong() throws XQException {
        throw new XQExceptionImpl(this.getItemTypeAsString() + " can not be cast to a long.", "XQJIA07");
    }

    public Node getNode() throws XQException {
        throw new XQExceptionImpl(this.getItemTypeAsString() + " can not be cast to a Node.", "XQJIA08");
    }

    public URI getNodeUri() throws XQException {
        if (this.nodeUri != null) {
            return this.nodeUri;
        }
        if (this.nodeUriString == null) {
            this.nodeUri = URI.create("");
            return this.nodeUri;
        }
        this.nodeUri = URI.create(this.nodeUriString);
        return this.nodeUri;
    }

    public Object getObject() throws XQException {
        throw new XQExceptionImpl(this.getItemTypeAsString() + " can not be cast to an Object.", "XQJIA10");
    }

    public XMLStreamReader getItemAsStream() throws XQException {
        throw new XQExceptionImpl(this.getItemTypeAsString() + " can not be streamed via an XMLStreamReader.", "XQJIA11");
    }

    public String getItemAsString(Properties properties) throws XQException {
        throw new XQExceptionImpl(this.getItemTypeAsString() + " can not be cast to a String.", "XQJIA12");
    }

    public short getShort() throws XQException {
        throw new XQExceptionImpl(this.getItemTypeAsString() + " can not be cast a short.", "XQJIA13");
    }

    public boolean instanceOf(XQItemType ancestor) throws XQException {
        return XQToolkit.isInstanceOf(ancestor, this.xqItemType);
    }

    public abstract void writeItem(OutputStream var1, Properties var2) throws XQException;

    public abstract void writeItem(Writer var1, Properties var2) throws XQException;

    public void writeItemToSAX(ContentHandler contenthandler) throws XQException {
        throw new XQExceptionImpl(this.getItemTypeAsString() + " can not be written to a SAX ContentHandler.", "XQJIA14");
    }

    public void writeItemToResult(Result result) throws XQException {
        throw new XQExceptionImpl(this.getItemTypeAsString() + " can not be cast written to a JAXP Result.", "XQJIA15");
    }

    public void close() throws XQException {
    }

    public boolean isClosed() {
        return false;
    }

    public void setItemType(XQItemType xqItemType) {
        this.xqItemType = xqItemType;
    }

    public String getItemTypeAsString() throws XQException {
        if (this.xqItemType == null) {
            return "Undefined type";
        }
        return XQToolkit.getXQItemTypeAsString(this.xqItemType);
    }

    public void setNodeUri(String lexicalString) {
        this.nodeUriString = lexicalString;
        if (this.nodeUriString == null) {
            this.nodeUri = null;
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

