/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import java.util.HashSet;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.index.resource.ResourceType;
import org.basex.index.resource.Resources;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.db.DbList;
import org.basex.query.iter.Iter;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.node.FNode;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.list.IntList;

public final class DbDir
extends DbList {
    @Override
    Iter resources(String name, QueryContext qc) throws QueryException {
        Data data = this.toData(name, qc);
        String string = this.toString(this.arg(1), qc);
        Object path = MetaData.normPath(string);
        if (path == null) {
            throw QueryError.DB_PATH_X.get(this.info, string);
        }
        if (!((String)path).isEmpty() && !Strings.endsWith((String)path, '/')) {
            path = (String)path + "/";
        }
        ValueBuilder vb = new ValueBuilder(qc);
        HashSet<String> set = new HashSet<String>();
        Resources resources = data.resources;
        IntList docs = resources.docs((String)path, true);
        long ds = docs.size();
        long ts = data.meta.time;
        int d = 0;
        while ((long)d < ds) {
            boolean dir;
            int pre = docs.get(d);
            String nm = Token.string(Token.substring(data.text(pre, true), ((String)path).length()));
            int i = nm.indexOf(47);
            boolean bl = dir = i >= 0;
            if (dir) {
                nm = nm.substring(0, i);
            }
            if (set.add(nm)) {
                vb.add(DbDir.elem(dir, nm, ts, data.size(pre, 0), ResourceType.XML));
            }
            ++d;
        }
        if (!data.inMemory()) {
            for (ResourceType type : Resources.BINARIES) {
                IOFile bin = data.meta.file((String)path, type);
                for (IOFile file : bin.children()) {
                    String nm;
                    boolean dir = file.isDir();
                    String string2 = nm = dir ? file.name() : type.dbPath(file.name());
                    if (!set.add(nm)) continue;
                    vb.add(DbDir.elem(file.isDir(), nm, file.timeStamp(), file.length(), type));
                }
            }
        }
        return vb.value(this).iter();
    }

    private static FNode elem(boolean dir, String path, long date, long size, ResourceType type) {
        return dir ? DbDir.dir(path, date) : DbDir.resource(path, date, size, type);
    }
}

