/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.out;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.io.IOFile;

public final class BufferOutput
extends OutputStream {
    private final int bufsize;
    private final byte[] buffer;
    private final OutputStream out;
    private int pos;

    public static BufferOutput get(OutputStream os) {
        BufferOutput bo;
        return os instanceof BufferOutput ? (bo = (BufferOutput)os) : new BufferOutput(os);
    }

    public BufferOutput(IOFile file) throws IOException {
        this(file.outputStream());
    }

    BufferOutput(OutputStream out) {
        this(out, 4096);
    }

    BufferOutput(OutputStream out, int bufsize) {
        this.out = out;
        this.bufsize = bufsize;
        this.buffer = new byte[bufsize];
    }

    @Override
    public void write(int b) throws IOException {
        if (this.pos == this.bufsize) {
            this.flush();
        }
        this.buffer[this.pos++] = (byte)b;
    }

    @Override
    public void flush() throws IOException {
        this.out.write(this.buffer, 0, this.pos);
        this.pos = 0;
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.out.close();
        }
    }
}

