/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.io.IOFile;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.BlnSeq;
import org.basex.query.value.seq.BytSeq;
import org.basex.query.value.seq.DblSeq;
import org.basex.query.value.seq.DecSeq;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.FltSeq;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.seq.ShrSeq;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.seq.StrSeq;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.TokenList;

public final class Stores
implements Closeable {
    private static final String NAME = "store";
    private final HashMap<String, Store> stores = new HashMap();
    private final Context context;
    private static final int SEQUENCE = 63;
    private static final MethodHandle[] METHODS;
    private static final Map<Class<?>, Integer> CLASS_IDS;

    public Stores(Context context) {
        this.context = context;
    }

    public synchronized Value keys(String name, InputInfo info, QueryContext qc) throws QueryException {
        Store store = this.get(name, false, info, qc);
        if (store != null) {
            TokenList list = new TokenList(store.map.size());
            for (String key : store.map.keySet()) {
                list.add(key);
            }
            return StrSeq.get(list);
        }
        return Empty.VALUE;
    }

    public synchronized Value get(String key, String name, InputInfo info, QueryContext qc) throws QueryException {
        Value value;
        Store store = this.get(name, false, info, qc);
        if (store != null && (value = store.map.get(key)) != null) {
            return value;
        }
        return Empty.VALUE;
    }

    public synchronized void put(String key, Value value, String name, InputInfo info, QueryContext qc) throws QueryException {
        Store store = this.get(name, true, info, qc);
        if (value.isEmpty()) {
            store.map.remove(key);
        } else {
            store.map.put(key, value);
        }
        store.dirty = true;
    }

    public synchronized void remove(String key, String name, InputInfo info, QueryContext qc) throws QueryException {
        this.put(key, Empty.VALUE, name, info, qc);
    }

    public synchronized void clear() {
        this.stores.clear();
        for (String name : this.listStores()) {
            this.storeFile(name).delete();
        }
    }

    public synchronized void close(String name, InputInfo info) throws QueryException {
        try {
            this.writeStore(name, false);
        }
        catch (IOException ex) {
            throw QueryError.STORE_IO_X.get(info, ex);
        }
        this.stores.remove(name);
    }

    public synchronized Value list() {
        TreeSet<String> names = this.listStores();
        for (Map.Entry<String, Store> entry : this.stores.entrySet()) {
            if (entry.getValue().map.isEmpty()) {
                names.remove(entry.getKey());
                continue;
            }
            names.add(entry.getKey());
        }
        names.remove("");
        TokenList list = new TokenList(names.size());
        for (String name : names) {
            list.add(name);
        }
        return StrSeq.get(list);
    }

    public synchronized void read(String name, InputInfo info, QueryContext qc) throws QueryException {
        if (this.storeFile(name).exists()) {
            this.readStore(name, info, qc);
        } else {
            this.stores.remove(name);
        }
    }

    public synchronized void write(String name, InputInfo info) throws QueryException {
        try {
            this.writeStore(name, true);
        }
        catch (IOException ex) {
            throw QueryError.STORE_IO_X.get(info, ex);
        }
    }

    public synchronized void delete(String name) {
        this.stores.remove(name);
        this.storeFile(name).delete();
    }

    @Override
    public synchronized void close() {
        if (this.context.soptions.get(StaticOptions.WRITESTORE).booleanValue()) {
            for (String name : this.stores.keySet()) {
                try {
                    this.writeStore(name, false);
                }
                catch (IOException | QueryException ex) {
                    Util.stack(ex);
                }
            }
        }
    }

    private Store get(String name, boolean create, InputInfo info, QueryContext qc) throws QueryException {
        if (!this.stores.containsKey(name)) {
            if (this.storeFile(name).exists()) {
                this.readStore(name, info, qc);
            } else if (create) {
                this.stores.put(name, new Store());
            }
        }
        return this.stores.get(name);
    }

    private void readStore(String name, InputInfo info, QueryContext qc) throws QueryException {
        HashMap<String, Value> map = new HashMap<String, Value>();
        try (DataInput in = new DataInput(this.storeFile(name));){
            for (int s = in.readNum() - 1; s >= 0; --s) {
                map.put(Token.string(in.readToken()), Stores.read(in, qc));
            }
        }
        catch (IOException ex) {
            throw QueryError.STORE_IO_X.get(info, ex);
        }
        this.stores.put(name, new Store(map));
    }

    private void writeStore(String name, boolean enforce) throws IOException, QueryException {
        Store entry = this.stores.get(name);
        IOFile file = this.storeFile(name);
        if (entry != null && (entry.dirty || enforce)) {
            HashMap<String, Value> map = entry.map;
            if (map.isEmpty()) {
                file.delete();
            } else {
                file.parent().md();
                try (DataOutput out = new DataOutput(file);){
                    out.writeNum(map.size());
                    for (Map.Entry<String, Value> e : map.entrySet()) {
                        out.writeToken(Token.token(e.getKey()));
                        Stores.write(out, e.getValue());
                    }
                }
            }
            entry.dirty = false;
        }
    }

    private synchronized TreeSet<String> listStores() {
        TreeSet<String> names = new TreeSet<String>();
        for (IOFile file : this.context.soptions.dbPath().children()) {
            String name = file.name();
            if (!name.matches("store(-.+|)\\.basex")) continue;
            names.add(name.replaceAll("^store-?|\\.basex", ""));
        }
        return names;
    }

    private IOFile storeFile(String name) {
        TokenBuilder tb = new TokenBuilder().add(NAME);
        if (!Stores.standardStore(name)) {
            tb.add(45).add(name);
        }
        return this.context.soptions.dbPath(tb.add(".basex").toString());
    }

    private static boolean standardStore(String name) {
        return name.isEmpty();
    }

    public static synchronized void write(DataOutput out, Value value) throws IOException, QueryException {
        out.writeNum(value.seqType().type.index());
        long size = value.size();
        out.writeLong(size);
        if (size == 1L) {
            value.write(out);
        } else if (size > 1L) {
            Integer classId = CLASS_IDS.get(value.getClass());
            if (classId == null) {
                out.writeNum(63);
                boolean same = value.refineType();
                out.writeBool(same);
                for (Item item : value) {
                    if (!same) {
                        out.writeNum(item.type.index());
                    }
                    item.write(out);
                }
            } else {
                out.writeNum(classId);
                value.write(out);
            }
        }
    }

    public static synchronized Value read(DataInput in, QueryContext qc) throws IOException, QueryException {
        qc.checkStop();
        int id = in.readNum();
        Type type = Types.type(id);
        long size = in.readLong();
        if (size == 0L) {
            return Empty.VALUE;
        }
        if (size == 1L) {
            return type.read(in, qc);
        }
        int classId = in.readNum();
        if (classId == 63) {
            ValueBuilder vb = new ValueBuilder(qc, size);
            boolean same = in.readBool();
            for (long s = 0L; s < size; ++s) {
                Type tp = same ? type : Types.type(in.readNum());
                vb.add(tp.read(in, qc));
            }
            return vb.value(type);
        }
        try {
            return METHODS[classId].invoke(in, type, qc);
        }
        catch (Throwable th) {
            throw new IOException(th);
        }
    }

    static {
        CLASS_IDS = new HashMap();
        try {
            Class[] classes = new Class[]{BlnSeq.class, BytSeq.class, DblSeq.class, DecSeq.class, FltSeq.class, IntSeq.class, ShrSeq.class, StrSeq.class, SingletonSeq.class, RangeSeq.class};
            METHODS = new MethodHandle[classes.length];
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            MethodType mt = MethodType.methodType(Value.class, DataInput.class, Type.class, QueryContext.class);
            for (int c = classes.length - 1; c >= 0; --c) {
                CLASS_IDS.put(classes[c], c);
                Stores.METHODS[c] = lookup.findStatic(classes[c], "read", mt);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException ex) {
            Util.stack(ex);
            throw Util.notExpected(ex, new Object[0]);
        }
    }

    private static final class Store {
        private final HashMap<String, Value> map;
        private boolean dirty;

        private Store() {
            this(new HashMap<String, Value>());
        }

        private Store(HashMap<String, Value> map) {
            this.map = map;
        }
    }
}

