/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.Arrays;
import java.util.Collections;
import java.util.function.Predicate;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpOp;
import org.basex.query.expr.Expr;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class CmpV
extends Cmp {
    private CmpOp op;

    public CmpV(InputInfo info, Expr expr1, Expr expr2, CmpOp op) {
        super(info, expr1, expr2, Types.BOOLEAN_ZO);
        this.op = op;
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        Expr expr;
        this.exprs = this.simplifyAll(CompileContext.Simplify.STRING, cc);
        if (this.values(false, cc)) {
            return cc.preEval(this);
        }
        if (this.swap()) {
            cc.info("swap operands: %", this);
            Collections.reverse(Arrays.asList(this.exprs));
            this.op = this.op.swap();
        }
        if ((expr = this.emptyExpr()) == this) {
            expr = this.toGeneral(cc, true);
        }
        if (expr == this) {
            expr = this.opt(cc);
        }
        if (expr == this) {
            SeqType st1 = this.exprs[0].seqType();
            SeqType st2 = this.exprs[1].seqType();
            if (st1.oneOrMore() && !st1.mayBeArray() && st2.oneOrMore() && !st2.mayBeArray()) {
                this.exprType.assign(Occ.EXACTLY_ONE);
            }
        }
        return cc.replaceWith(this, expr);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr expr = this;
        if (mode.oneOf(CompileContext.Simplify.EBV, CompileContext.Simplify.PREDICATE)) {
            expr = this.toGeneral(cc, false);
        }
        return cc.simplify(this, expr, mode);
    }

    private Expr toGeneral(CompileContext cc, boolean single) throws QueryException {
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        SeqType st1 = expr1.seqType();
        SeqType st2 = expr2.seqType();
        Predicate<SeqType> p = st -> single ? st.one() : st.zeroOrOne();
        if (p.test(st1) && p.test(st2) && CmpG.compatible(st1, st2, this.op)) {
            return new CmpG(this.info, expr1, expr2, this.op).optimize(cc);
        }
        return this;
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item1 = this.exprs[0].atomItem(qc, this.info);
        if (item1 == Empty.VALUE) {
            return Empty.VALUE;
        }
        Item item2 = this.exprs[1].atomItem(qc, this.info);
        if (item2 == Empty.VALUE) {
            return Empty.VALUE;
        }
        return Bln.get(this.test(item1, item2));
    }

    @Override
    public boolean test(QueryContext qc, InputInfo ii, long pos) throws QueryException {
        Item item1 = this.exprs[0].atomItem(qc, this.info);
        if (item1 == Empty.VALUE) {
            return false;
        }
        Item item2 = this.exprs[1].atomItem(qc, this.info);
        if (item2 == Empty.VALUE) {
            return false;
        }
        return this.test(item1, item2);
    }

    private boolean test(Item item1, Item item2) throws QueryException {
        if (item1.comparable(item2)) {
            return this.op.eval(item1.compare(item2, null, false, this.info));
        }
        throw QueryError.compareError(item1, item2, this.info);
    }

    @Override
    public Expr invert() {
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        SeqType st1 = expr1.seqType();
        SeqType st2 = expr2.seqType();
        return st1.one() && !st1.mayBeArray() && st2.one() && !st2.mayBeArray() ? new CmpV(this.info, expr1, expr2, this.op.invert()) : null;
    }

    @Override
    public CmpOp cmpOp() {
        return this.op;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new CmpV(this.info, this.exprs[0].copy(cc, vm), this.exprs[1].copy(cc, vm), this.op));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof CmpV)) return false;
        CmpV cmp = (CmpV)obj;
        if (this.op != cmp.op) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public String description() {
        return "'" + this.op.toValueString() + "' comparison";
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "op", this.op.toValueString()), this.exprs);
    }

    @Override
    public void toString(QueryString qs) {
        qs.tokens(this.exprs, " " + this.op.toValueString() + " ", true);
    }
}

