/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import java.util.function.Function;
import org.basex.query.expr.ft.ThesEntry;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Token;
import org.basex.util.hash.TokenObjectMap;

public final class Thesaurus {
    private static final byte[] ENTRY = Token.token("entry");
    private static final byte[] RELATIONSHIP = Token.token("relationship");
    private static final byte[] SYNONYM = Token.token("synonym");
    private static final byte[] TERM = Token.token("term");
    private final TokenObjectMap<ThesEntry> entries = new TokenObjectMap();
    private static final TokenObjectMap<byte[]> RSHIPS = new TokenObjectMap();

    public Thesaurus(ANode root) {
        for (ANode entry : Thesaurus.elements(root, ENTRY, true)) {
            this.build(entry);
        }
    }

    ThesEntry get(byte[] term) {
        return this.entries.get(term);
    }

    private void build(ANode entry) {
        Function<ANode, ThesEntry> find = node -> {
            byte[] term = Thesaurus.value(node, TERM);
            return this.entries.computeIfAbsent(term, () -> new ThesEntry(term));
        };
        ThesEntry term = find.apply(entry);
        for (ANode synonym : Thesaurus.elements(entry, SYNONYM, false)) {
            ThesEntry syn = find.apply(synonym);
            byte[] value = Thesaurus.value(synonym, RELATIONSHIP);
            term.add(syn, value);
            byte[] rship = RSHIPS.get(value);
            if (rship != null) {
                syn.add(term, rship);
            }
            this.build(synonym);
        }
    }

    private static ANodeList elements(ANode node, byte[] name, boolean desc) {
        ANodeList list = new ANodeList();
        for (ANode element : desc ? node.descendantIter(false) : node.childIter()) {
            if (element.type != NodeType.ELEMENT || !Token.eq(element.qname().local(), name)) continue;
            list.add(element.finish());
        }
        return list;
    }

    private static byte[] value(ANode node, byte[] name) {
        ANodeList elements = Thesaurus.elements(node, name, false);
        return elements.isEmpty() ? Token.EMPTY : ((ANode)elements.peek()).string();
    }

    static {
        RSHIPS.put(Token.token("NT"), Token.token("BT"));
        RSHIPS.put(Token.token("BT"), Token.token("BT"));
        RSHIPS.put(Token.token("BTG"), Token.token("NTG"));
        RSHIPS.put(Token.token("NTG"), Token.token("BTG"));
        RSHIPS.put(Token.token("BTP"), Token.token("NTP"));
        RSHIPS.put(Token.token("NTP"), Token.token("BTP"));
        RSHIPS.put(Token.token("USE"), Token.token("UF"));
        RSHIPS.put(Token.token("UF"), Token.token("USE"));
        RSHIPS.put(Token.token("RT"), Token.token("RT"));
    }
}

