/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Locale;
import org.basex.io.IOFile;
import org.basex.io.out.ArrayOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.archive.ArchiveCreate;
import org.basex.query.func.archive.ArchiveOut;
import org.basex.query.func.archive.CreateFromOptions;
import org.basex.query.func.archive.CreateOptions;
import org.basex.query.value.Value;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.InputInfo;
import org.basex.util.list.TokenList;

public final class ArchiveCreateFrom
extends ArchiveCreate {
    @Override
    public B64 item(QueryContext qc, InputInfo ii) throws QueryException {
        IOFile root = new IOFile(this.toPath(this.arg(0), qc));
        CreateFromOptions options = this.toOptions(this.arg(1), new CreateFromOptions(), qc);
        Value entries = this.arg(2).value(qc);
        boolean recursive = options.get(CreateFromOptions.RECURSIVE);
        boolean rootDir = options.get(CreateFromOptions.ROOT_DIR);
        if (!root.isDir()) {
            throw QueryError.FILE_NO_DIR_X.get(this.info, root);
        }
        if (entries.isEmpty()) {
            TokenList tl = new TokenList();
            if (recursive) {
                for (String file : root.descendants()) {
                    tl.add(file);
                }
            } else {
                for (IOFile file : root.children()) {
                    if (file.isDir()) continue;
                    tl.add(file.name());
                }
            }
            entries = StrSeq.get(tl);
        }
        int level = this.level(options);
        String format = options.get(CreateOptions.FORMAT).toLowerCase(Locale.ENGLISH);
        String dir = rootDir && root.parent() != null ? root.name() + "/" : "";
        ArrayOutput ao = new ArrayOutput();
        try (ArchiveOut out = ArchiveOut.get(format, this.info, ao);){
            out.level(level);
            try {
                for (Item item : entries) {
                    IOFile file = new IOFile(root, this.toString(item, qc));
                    if (!file.exists()) {
                        throw QueryError.FILE_NOT_FOUND_X.get(this.info, file);
                    }
                    if (file.isDir()) {
                        throw QueryError.FILE_IS_DIR_X.get(this.info, file);
                    }
                    this.add(new AbstractMap.SimpleEntry<Item, Item>(item, B64.get(file.read())), out, level, dir, qc);
                }
            }
            catch (IOException ex) {
                throw QueryError.ARCHIVE_ERROR_X.get(this.info, ex);
            }
        }
        return B64.get(ao.finish());
    }
}

