/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;

@BugPattern(summary="Prefer ASTHelpers instead of calling this API directly", severity=BugPattern.SeverityLevel.WARNING)
public class ASTHelpersSuggestions
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Supplier<Type> MODULE_SYMBOL = Suppliers.typeFromString((String)"com.sun.tools.javac.code.Symbol.ModuleSymbol");
    private static final Matcher<ExpressionTree> SYMBOL = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("com.sun.tools.javac.code.Symbol").namedAnyOf(new String[]{"isDirectlyOrIndirectlyLocal", "isLocal", "packge", "getEnclosedElements"}), MethodMatchers.instanceMethod().onClass((TypePredicate & Serializable)(t, s) -> ASTHelpers.isSubtype((Type)((Type)MODULE_SYMBOL.get(s)), (Type)t, (VisitorState)s)).namedAnyOf(new String[]{"isStatic"})});
    private static final Matcher<ExpressionTree> SCOPE = MethodMatchers.instanceMethod().onDescendantOf("com.sun.tools.javac.code.Scope");
    private static final ImmutableMap<String, String> NAMES = ImmutableMap.of((Object)"packge", (Object)"enclosingPackage", (Object)"isDirectlyOrIndirectlyLocal", (Object)"isLocal");
    private static final Supplier<Type> COM_SUN_TOOLS_JAVAC_UTIL_FILTER = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("com.sun.tools.javac.util.Filter"));
    private static final Supplier<Type> JAVA_UTIL_FUNCTION_PREDICATE = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("java.util.function.Predicate"));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (receiver == null) {
            return Description.NO_MATCH;
        }
        Symbol.ClassSymbol outermost = ASTHelpers.outermostClass((Symbol)ASTHelpers.getSymbol((ClassTree)((ClassTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), ClassTree.class))));
        if (outermost.getQualifiedName().contentEquals("com.google.errorprone.util.ASTHelpers")) {
            return Description.NO_MATCH;
        }
        if (SYMBOL.matches((Tree)tree, state)) {
            Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
            String name = ((Name)sym.getSimpleName()).toString();
            name = (String)NAMES.getOrDefault((Object)name, (Object)name);
            return this.describeMatch(tree, (Fix)SuggestedFix.builder().addStaticImport("com.google.errorprone.util.ASTHelpers." + name).prefixWith((Tree)tree, name + "(").replace(state.getEndPosition((Tree)receiver), state.getEndPosition((Tree)tree), ")").build());
        }
        if (SCOPE.matches((Tree)tree, state)) {
            Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
            Type filter = (Type)COM_SUN_TOOLS_JAVAC_UTIL_FILTER.get(state);
            Type predicate = (Type)JAVA_UTIL_FUNCTION_PREDICATE.get(state);
            if (sym.getParameters().stream().anyMatch(p -> ASTHelpers.isSameType((Type)filter, (Type)p.asType(), (VisitorState)state) || ASTHelpers.isSameType((Type)predicate, (Type)p.asType(), (VisitorState)state))) {
                return this.describeMatch(tree, (Fix)SuggestedFix.builder().addStaticImport("com.google.errorprone.util.ASTHelpers.scope").prefixWith((Tree)receiver, "scope(").postfixWith((Tree)receiver, ")").build());
            }
        }
        return Description.NO_MATCH;
    }
}

