/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SimpleTreeVisitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.lang.model.element.Name;

public class ControlFlowVisitor
extends SimpleTreeVisitor<Result, BreakContext> {
    public static final ControlFlowVisitor INSTANCE = new ControlFlowVisitor();

    private ControlFlowVisitor() {
    }

    public Result visitStatement(StatementTree node) {
        return node.accept(this, new BreakContext());
    }

    public Result visitStatements(Iterable<? extends StatementTree> nodes) {
        return this.visitStatements(nodes, new BreakContext());
    }

    private Result visitStatements(Iterable<? extends StatementTree> nodes, BreakContext cxt) {
        Result result = Result.NEVER_EXITS;
        for (StatementTree statementTree : nodes) {
            result = result.then(statementTree.accept(this, cxt));
        }
        return result;
    }

    @Override
    protected Result defaultAction(Tree node, BreakContext cxt) {
        return Result.NEVER_EXITS;
    }

    @Override
    public Result visitBlock(BlockTree node, BreakContext cxt) {
        return this.visitStatements(node.getStatements(), cxt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result visitDoWhileLoop(DoWhileLoopTree node, BreakContext cxt) {
        ++cxt.loopDepth;
        try {
            Result result = node.getStatement().accept(this, cxt).or(Result.NEVER_EXITS);
            return result;
        }
        finally {
            --cxt.loopDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result visitWhileLoop(WhileLoopTree node, BreakContext cxt) {
        ++cxt.loopDepth;
        try {
            Result result = node.getStatement().accept(this, cxt).or(Result.NEVER_EXITS);
            return result;
        }
        finally {
            --cxt.loopDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result visitForLoop(ForLoopTree node, BreakContext cxt) {
        ++cxt.loopDepth;
        try {
            Result result = node.getStatement().accept(this, cxt).or(Result.NEVER_EXITS);
            return result;
        }
        finally {
            --cxt.loopDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result visitEnhancedForLoop(EnhancedForLoopTree node, BreakContext cxt) {
        ++cxt.loopDepth;
        try {
            Result result = node.getStatement().accept(this, cxt).or(Result.NEVER_EXITS);
            return result;
        }
        finally {
            --cxt.loopDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result visitSwitch(SwitchTree node, BreakContext cxt) {
        Result result = null;
        boolean seenDefault = false;
        ++cxt.loopDepth;
        try {
            for (CaseTree caseTree : node.getCases()) {
                if (caseTree.getExpression() == null) {
                    seenDefault = true;
                }
                if (result == null) {
                    result = caseTree.accept(this, cxt);
                    continue;
                }
                result = result.or(caseTree.accept(this, cxt));
            }
            if (!seenDefault) {
                result = result.or(Result.NEVER_EXITS);
            }
            Iterator<? extends CaseTree> iterator = result;
            return iterator;
        }
        finally {
            --cxt.loopDepth;
        }
    }

    @Override
    public Result visitCase(CaseTree node, BreakContext cxt) {
        return this.visitStatements(node.getStatements(), cxt);
    }

    @Override
    public Result visitSynchronized(SynchronizedTree node, BreakContext cxt) {
        return node.getBlock().accept(this, cxt);
    }

    @Override
    public Result visitTry(TryTree node, BreakContext cxt) {
        Result result = node.getBlock().accept(this, cxt);
        for (CatchTree catchTree : node.getCatches()) {
            result = result.or(catchTree.accept(this, cxt));
        }
        if (node.getFinallyBlock() != null) {
            result = result.then(node.getFinallyBlock().accept(this, cxt));
        }
        return result;
    }

    @Override
    public Result visitCatch(CatchTree node, BreakContext cxt) {
        return node.getBlock().accept(this, cxt);
    }

    @Override
    public Result visitIf(IfTree node, BreakContext cxt) {
        Result thenResult = node.getThenStatement().accept(this, cxt);
        Result elseResult = node.getElseStatement() == null ? Result.NEVER_EXITS : node.getElseStatement().accept(this, cxt);
        return thenResult.or(elseResult);
    }

    @Override
    public Result visitExpressionStatement(ExpressionStatementTree node, BreakContext cxt) {
        return Result.NEVER_EXITS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result visitLabeledStatement(LabeledStatementTree node, BreakContext cxt) {
        cxt.enter(node.getLabel());
        try {
            Result result = node.getStatement().accept(this, cxt);
            return result;
        }
        finally {
            cxt.exit(node.getLabel());
        }
    }

    @Override
    public Result visitBreak(BreakTree node, BreakContext cxt) {
        if (cxt.internalLabels.contains(node.getLabel()) || node.getLabel() == null && cxt.loopDepth > 0) {
            return Result.NEVER_EXITS;
        }
        return Result.MAY_BREAK_OR_RETURN;
    }

    @Override
    public Result visitContinue(ContinueTree node, BreakContext cxt) {
        if (cxt.internalLabels.contains(node.getLabel()) || node.getLabel() == null && cxt.loopDepth > 0) {
            return Result.NEVER_EXITS;
        }
        return Result.MAY_BREAK_OR_RETURN;
    }

    @Override
    public Result visitReturn(ReturnTree node, BreakContext cxt) {
        return Result.ALWAYS_RETURNS;
    }

    @Override
    public Result visitThrow(ThrowTree node, BreakContext cxt) {
        return Result.ALWAYS_RETURNS;
    }

    static class BreakContext {
        final Set<Name> internalLabels = new HashSet<Name>();
        int loopDepth = 0;

        private BreakContext() {
        }

        void enter(Name label) {
            this.internalLabels.add(label);
        }

        void exit(Name label) {
            this.internalLabels.remove(label);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Result {
        NEVER_EXITS{

            @Override
            Result or(Result other) {
                switch (other) {
                    case MAY_BREAK_OR_RETURN: 
                    case NEVER_EXITS: {
                        return other;
                    }
                }
                return MAY_RETURN;
            }

            @Override
            Result then(Result other) {
                return other;
            }
        }
        ,
        MAY_BREAK_OR_RETURN{

            @Override
            Result or(Result other) {
                return MAY_BREAK_OR_RETURN;
            }

            @Override
            Result then(Result other) {
                return MAY_BREAK_OR_RETURN;
            }
        }
        ,
        MAY_RETURN{

            @Override
            Result or(Result other) {
                return other == MAY_BREAK_OR_RETURN ? MAY_BREAK_OR_RETURN : MAY_RETURN;
            }

            @Override
            Result then(Result other) {
                switch (other) {
                    case MAY_BREAK_OR_RETURN: 
                    case ALWAYS_RETURNS: {
                        return other;
                    }
                }
                return MAY_RETURN;
            }
        }
        ,
        ALWAYS_RETURNS{

            @Override
            Result or(Result other) {
                switch (other) {
                    case MAY_BREAK_OR_RETURN: 
                    case ALWAYS_RETURNS: {
                        return other;
                    }
                }
                return MAY_RETURN;
            }

            @Override
            Result then(Result other) {
                return ALWAYS_RETURNS;
            }
        };


        abstract Result or(Result var1);

        abstract Result then(Result var1);
    }
}

