/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google.errorprone.annotations.FormatMethod;
import com.google.auto.value.processor.AbortProcessingException;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

class ErrorReporter {
    private final Messager messager;
    private int errorCount;

    ErrorReporter(ProcessingEnvironment processingEnv) {
        this.messager = processingEnv.getMessager();
    }

    @FormatMethod
    void reportNote(Element e, String format, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(format, args), e);
    }

    @FormatMethod
    void reportWarning(Element e, String format, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, String.format(format, args), e);
    }

    @FormatMethod
    void reportError(Element e, String format, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(format, args), e);
        ++this.errorCount;
    }

    @FormatMethod
    AbortProcessingException abortWithError(Element e, String format, Object ... args) {
        this.reportError(e, format, args);
        throw new AbortProcessingException();
    }

    int errorCount() {
        return this.errorCount;
    }

    void abortIfAnyError() {
        if (this.errorCount > 0) {
            throw new AbortProcessingException();
        }
    }
}

