/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.model.BenchmarkSpec;
import com.google.caliper.model.InstrumentSpec;
import com.google.caliper.model.Measurement;
import com.google.caliper.model.Scenario;
import com.google.caliper.model.Trial;
import com.google.caliper.model.VmSpec;
import com.google.caliper.runner.worker.trial.TrialFailureException;
import com.google.caliper.runner.worker.trial.TrialResult;
import com.google.caliper.util.Stdout;
import com.google.common.base.Function;
import com.google.common.base.Stopwatch;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.math.Quantiles;
import com.google.common.math.Stats;
import java.io.Closeable;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

final class ConsoleOutput
implements Closeable {
    private final PrintWriter stdout;
    private final Set<InstrumentSpec> instrumentSpecs = Sets.newHashSet();
    private final Set<VmSpec> vmSpecs = Sets.newHashSet();
    private final Set<BenchmarkSpec> benchmarkSpecs = Sets.newHashSet();
    private int numMeasurements = 0;
    private int trialsCompleted = 0;
    private final int numberOfTrials;
    private final Stopwatch stopwatch;

    ConsoleOutput(@Stdout PrintWriter stdout, int numberOfTrials, Stopwatch stopwatch) {
        this.stdout = stdout;
        this.numberOfTrials = numberOfTrials;
        this.stopwatch = stopwatch;
    }

    void processFailedTrial(TrialFailureException e) {
        ++this.trialsCompleted;
        String string = String.valueOf(e.getMessage());
        this.stdout.println(string.length() != 0 ? "ERROR: Trial failed to complete (its results will not be included in the run):\n  ".concat(string) : new String("ERROR: Trial failed to complete (its results will not be included in the run):\n  "));
        this.stdout.flush();
    }

    void processTrial(TrialResult result) {
        ++this.trialsCompleted;
        this.stdout.printf("Trial Report (%d of %d):%n  Experiment %s%n", this.trialsCompleted, this.numberOfTrials, result.getExperiment());
        if (!result.getTrialMessages().isEmpty()) {
            this.stdout.println("  Messages:");
            for (String message : result.getTrialMessages()) {
                this.stdout.print("    ");
                this.stdout.println(message);
            }
        }
        Trial trial = result.getTrial();
        ImmutableListMultimap measurementsIndex = new ImmutableListMultimap.Builder().orderKeysBy((Comparator)Ordering.natural()).putAll((Multimap)Multimaps.index((Iterable)trial.measurements(), (Function)new Function<Measurement, String>(this){

            public String apply(Measurement input) {
                return input.description();
            }
        })).build();
        this.stdout.println("  Results:");
        for (Map.Entry entry : measurementsIndex.asMap().entrySet()) {
            Collection measurements = (Collection)entry.getValue();
            ImmutableSet units = FluentIterable.from((Iterable)measurements).transform((Function)new Function<Measurement, String>(this){

                public String apply(Measurement input) {
                    return input.value().unit();
                }
            }).toSet();
            double[] weightedValues = new double[measurements.size()];
            int i = 0;
            for (Measurement measurement : measurements) {
                weightedValues[i] = measurement.value().magnitude() / measurement.weight();
                ++i;
            }
            Map quartiles = Quantiles.quartiles().indexes(new int[]{1, 2, 3}).computeInPlace(weightedValues);
            Stats stats = Stats.of((double[])weightedValues);
            String unit = (String)Iterables.getOnlyElement((Iterable)units);
            this.stdout.printf("    %s%s: min=%.2f, 1st qu.=%.2f, median=%.2f, mean=%.2f, 3rd qu.=%.2f, max=%.2f%n", entry.getKey(), unit.isEmpty() ? "" : new StringBuilder(2 + String.valueOf(unit).length()).append("(").append(unit).append(")").toString(), stats.min(), quartiles.get(1), quartiles.get(2), stats.mean(), quartiles.get(3), stats.max());
        }
        this.instrumentSpecs.add(trial.instrumentSpec());
        Scenario scenario = trial.scenario();
        this.vmSpecs.add(scenario.vmSpec());
        this.benchmarkSpecs.add(scenario.benchmarkSpec());
        this.numMeasurements += trial.measurements().size();
    }

    @Override
    public void close() {
        if (this.trialsCompleted == this.numberOfTrials) {
            this.stdout.printf("Collected %d measurements from:%n", this.numMeasurements);
            this.stdout.printf("  %d instrument(s)%n", this.instrumentSpecs.size());
            this.stdout.printf("  %d virtual machine(s)%n", this.vmSpecs.size());
            this.stdout.printf("  %d benchmark(s)%n", this.benchmarkSpecs.size());
            this.stdout.println();
            this.stdout.format("Execution complete: %s.%n", this.stopwatch.stop());
            this.stdout.flush();
        }
    }
}

