/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.options;

import com.google.caliper.runner.options.CaliperOptions;
import com.google.caliper.runner.options.CommandLineParser;
import com.google.caliper.util.InvalidCommandException;
import com.google.caliper.util.ShortDuration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@VisibleForTesting
public final class ParsedOptions
implements CaliperOptions {
    private final ImmutableList<String> args;
    private final boolean requireBenchmarkClassName;
    @CommandLineParser.Option(value={"-n", "--dry-run"})
    private boolean dryRun;
    private int localPort = 0;
    @CommandLineParser.Option(value={"-d", "--delimiter"})
    private String delimiter = ",";
    private ImmutableSet<String> benchmarkNames = ImmutableSet.of();
    @CommandLineParser.Option(value={"-p", "--print-config"})
    private boolean printConfiguration = false;
    private int trials = 1;
    private ShortDuration timeLimit = ShortDuration.of((long)5L, (TimeUnit)TimeUnit.MINUTES);
    private String runName = "";
    private String deviceName = "default";
    private ImmutableSet<String> vmNames = ImmutableSet.of();
    private ImmutableSet<String> instrumentNames = ImmutableSet.of();
    private Multimap<String, String> mutableUserParameters = ArrayListMultimap.create();
    private Multimap<String, String> mutableVmArguments = ArrayListMultimap.create();
    private final Map<String, String> mutableConfigProperties = Maps.newHashMap();
    private final Map<String, String> workerClasspaths = Maps.newHashMap();
    private static final ImmutableSet<String> VALID_VM_TYPES = ImmutableSet.of((Object)"jvm", (Object)"android");
    private File caliperDirectory = new File(System.getProperty("user.home"), ".caliper");
    private Optional<File> caliperConfigFile = Optional.absent();
    private ImmutableList<String> adbArgs = ImmutableList.of();
    @CommandLineParser.Option(value={"--print-worker-log"})
    private boolean printWorkerLog = false;
    private String benchmarkClassName;
    private static final ImmutableList<String> USAGE = ImmutableList.of((Object)"Usage:", (Object)" java com.google.caliper.runner.CaliperMain <benchmark_class_name> [options...]", (Object)"", (Object)"Options:", (Object)" -h, --help         print this message", (Object)" -n, --dry-run      instead of measuring, execute a single rep for each scenario", (Object)"                    in-process", (Object)" -b, --benchmark    comma-separated list of benchmark methods to run; 'foo' is", (Object)"                    an alias for 'timeFoo' (default: all found in class)", (Object)" -e, --device       name of the configured device to run the benchmarks on; currently", (Object)"                    only 'local' is supported (default: local)", (Object)" -m, --vm           comma-separated list of VMs to test on; possible values are", (Object[])new String[]{"                    configured in Caliper's configuration file (default:", "                    whichever VM caliper itself is running in, only)", " -i, --instrument   comma-separated list of measuring instruments to use; possible ", "                    values are configured in Caliper's configuration file ", "                    (default: the default set of instruments from the global or user ", "                    configuration file)", " -t, --trials       number of independent trials to perform per benchmark scenario; ", "                    a positive integer (default: 1)", " -l, --time-limit   maximum length of time allowed for a single trial; use 0 to allow ", "                    trials to run indefinitely. (default: 30s) ", " -r, --run-name     a user-friendly string used to identify the run", " -p, --print-config print the effective configuration that will be used by Caliper", " -d, --delimiter    separator used in options that take multiple values (default: ',')", " -c, --config       location of Caliper's configuration file (default:", "                    $HOME/.caliper/config.properties)", " --directory        location of Caliper's configuration and data directory ", "                    (default: $HOME/.caliper)", " --worker-classpath[-<vmtype>]", "                    the classpath to use for benchmark workers with the specified", "                    <vmtype> (e.g. --worker-classpath-jvm). The worker classpath must ", "                    include the benchmark class to be run, its dependencies, and the ", "                    Caliper worker code. If the run only targets a single VM type, the ", "                    '-<vmtype>' can be dropped. For now, if no worker classpath is ", "                    provided and the benchmark is running on the local device, the ", "                    classpath of the runner process may be used as a default. This is ", "                    for compatibility reasons and may not be supported in the future.", " --adb-args         additional arguments to pass to adb when using an adb-connected ", "                    device. This is primarily intended for use with things like -P ", "                    (setting the port to use for the adb instance); while it could ", "                    also be used for args such as -d that select the device to use, ", "                    prefer using --device for that.", " --print-worker-log if an error occurs in a worker, print the log for that worker ", "                    rather than the path to the log file; primarily for use in tests ", "                    when running in a CI environment where the log files may not be ", "                    easily accessible.", "", " -Dparam=val1,val2,...", "     Specifies the values to inject into the 'param' field of the benchmark", "     class; if multiple values or parameters are specified in this way, caliper", "     will try all possible combinations.", "", " -CconfigProperty=value", "     Specifies a value for any property that could otherwise be specified in ", "     $HOME/.caliper/config.properties. Properties specified on the command line", "     will override those specified in the file.", "", "See https://github.com/google/caliper/wiki/CommandLineOptions for more details.", ""});

    public static ParsedOptions from(String[] args, boolean requireBenchmarkClassName) throws InvalidCommandException {
        ParsedOptions options = new ParsedOptions(args, requireBenchmarkClassName);
        CommandLineParser<ParsedOptions> parser = CommandLineParser.forClass(ParsedOptions.class);
        try {
            parser.parseAndInject(args, options);
        }
        catch (InvalidCommandException e) {
            e.setUsage(USAGE);
            throw e;
        }
        return options;
    }

    private ParsedOptions(String[] args, boolean requireBenchmarkClassName) {
        this.args = ImmutableList.copyOf((Object[])args);
        this.requireBenchmarkClassName = requireBenchmarkClassName;
    }

    @Override
    public ImmutableList<String> allArgs() {
        return this.args;
    }

    @Override
    public boolean dryRun() {
        return this.dryRun;
    }

    private void dryRunIncompatible(String optionName) throws InvalidCommandException {
        if (this.dryRun) {
            String string = String.valueOf(optionName);
            throw new InvalidCommandException(string.length() != 0 ? "Option not available in dry-run mode: ".concat(string) : new String("Option not available in dry-run mode: "), new Object[0]);
        }
    }

    @CommandLineParser.Option(value={"-L", "--local_port"})
    private void setLocalPort(int localPort) {
        if (localPort < 1) {
            throw new InvalidCommandException(new StringBuilder(42).append("local_port must be at least 1: ").append(localPort).toString(), new Object[0]);
        }
        this.localPort = localPort;
    }

    @Override
    public int localPort() {
        return this.localPort;
    }

    private ImmutableSet<String> split(String string) {
        return ImmutableSet.copyOf((Iterable)Splitter.on((String)this.delimiter).split((CharSequence)string));
    }

    @CommandLineParser.Option(value={"-b", "--benchmark"})
    private void setBenchmarkNames(String benchmarksString) {
        this.benchmarkNames = this.split(benchmarksString);
    }

    @Override
    public ImmutableSet<String> benchmarkMethodNames() {
        return this.benchmarkNames;
    }

    @Override
    public boolean printConfiguration() {
        return this.printConfiguration;
    }

    @CommandLineParser.Option(value={"-t", "--trials"})
    private void setTrials(int trials) throws InvalidCommandException {
        this.dryRunIncompatible("trials");
        if (trials < 1) {
            throw new InvalidCommandException(new StringBuilder(38).append("trials must be at least 1: ").append(trials).toString(), new Object[0]);
        }
        this.trials = trials;
    }

    @Override
    public int trialsPerScenario() {
        return this.trials;
    }

    @CommandLineParser.Option(value={"-l", "--time-limit"})
    private void setTimeLimit(String timeLimitString) throws InvalidCommandException {
        try {
            this.timeLimit = ShortDuration.valueOf((String)timeLimitString);
            if (this.timeLimit.equals(ShortDuration.zero())) {
                this.timeLimit = ShortDuration.of((long)Long.MAX_VALUE, (TimeUnit)TimeUnit.NANOSECONDS);
            }
        }
        catch (IllegalArgumentException e) {
            String string = String.valueOf(timeLimitString);
            throw new InvalidCommandException(string.length() != 0 ? "Invalid time limit: ".concat(string) : new String("Invalid time limit: "), new Object[0]);
        }
    }

    @Override
    public ShortDuration timeLimit() {
        return this.timeLimit;
    }

    @CommandLineParser.Option(value={"-r", "--run-name"})
    private void setRunName(String runName) {
        this.runName = (String)Preconditions.checkNotNull((Object)runName);
    }

    @Override
    public String runName() {
        return this.runName;
    }

    @CommandLineParser.Option(value={"-e", "--device"})
    private void setDeviceName(String deviceName) {
        if (deviceName.indexOf(64) != -1) {
            throw new InvalidCommandException("device names may not contain '@': %s", new Object[]{deviceName});
        }
        this.deviceName = deviceName;
    }

    @Override
    public String deviceName() {
        return this.deviceName;
    }

    @CommandLineParser.Option(value={"-m", "--vm"})
    private void setVms(String vmsString) throws InvalidCommandException {
        this.dryRunIncompatible("vm");
        this.vmNames = this.split(vmsString);
        for (String name : this.vmNames) {
            if (name.indexOf(64) == -1) continue;
            throw new InvalidCommandException("VM names may not contain '@': %s", new Object[]{name});
        }
    }

    @Override
    public ImmutableSet<String> vmNames() {
        return this.vmNames;
    }

    @CommandLineParser.Option(value={"-i", "--instrument"})
    private void setInstruments(String instrumentsString) {
        this.instrumentNames = this.split(instrumentsString);
    }

    @Override
    public ImmutableSet<String> instrumentNames() {
        return this.instrumentNames;
    }

    @CommandLineParser.Option(value={"-D"})
    private void addParameterSpec(String nameAndValues) throws InvalidCommandException {
        this.addToMultimap(nameAndValues, this.mutableUserParameters);
    }

    @Override
    public ImmutableSetMultimap<String, String> userParameters() {
        return new ImmutableSetMultimap.Builder().orderKeysBy((Comparator)Ordering.natural()).putAll(this.mutableUserParameters).build();
    }

    @CommandLineParser.Option(value={"-J"})
    private void addVmArgumentsSpec(String nameAndValues) throws InvalidCommandException {
        this.dryRunIncompatible("-J");
        this.addToMultimap(nameAndValues, this.mutableVmArguments);
    }

    @Override
    public ImmutableSetMultimap<String, String> vmArguments() {
        return new ImmutableSetMultimap.Builder().orderKeysBy((Comparator)Ordering.natural()).putAll(this.mutableVmArguments).build();
    }

    @CommandLineParser.Option(value={"-C"})
    private void addConfigProperty(String nameAndValue) throws InvalidCommandException {
        List<String> tokens = ParsedOptions.splitProperty(nameAndValue);
        this.mutableConfigProperties.put(tokens.get(0), tokens.get(1));
    }

    @Override
    public ImmutableMap<String, String> configProperties() {
        return ImmutableMap.copyOf(this.mutableConfigProperties);
    }

    @CommandLineParser.Option(value={"--worker-classpath"})
    private void setDefaultWorkerClasspath(String classpath) {
        this.putWorkerClasspath("android", classpath);
        this.putWorkerClasspath("jvm", classpath);
    }

    @CommandLineParser.Option(value={"--worker-classpath-android"})
    private void setAndroidWorkerClasspath(String classpath) {
        this.putWorkerClasspath("android", classpath);
    }

    @CommandLineParser.Option(value={"--worker-classpath-jvm"})
    private void setJvmWorkerClasspath(String classpath) {
        this.putWorkerClasspath("jvm", classpath);
    }

    private void putWorkerClasspath(String key, String classpath) {
        if (this.workerClasspaths.containsKey(key)) {
            throw new InvalidCommandException("Provide either --worker-classpath or --worker-classpath-<vmtype>; not both", new Object[0]);
        }
        this.workerClasspaths.put(key, classpath);
    }

    @Override
    public Optional<String> workerClasspath(String vmType) {
        vmType = vmType.toLowerCase();
        Preconditions.checkArgument((boolean)VALID_VM_TYPES.contains((Object)vmType), (String)"invalid VM type: %s", (Object)vmType);
        return Optional.fromNullable((Object)this.workerClasspaths.get(vmType));
    }

    @CommandLineParser.Option(value={"--directory"})
    private void setCaliperDirectory(String path) {
        this.caliperDirectory = new File(path);
    }

    @Override
    public File caliperDirectory() {
        return this.caliperDirectory;
    }

    @CommandLineParser.Option(value={"-c", "--config"})
    private void setCaliperConfigFile(String filename) {
        this.caliperConfigFile = Optional.of((Object)new File(filename));
    }

    @Override
    public File caliperConfigFile() {
        return (File)this.caliperConfigFile.or((Object)new File(this.caliperDirectory, "config.properties"));
    }

    @CommandLineParser.Option(value={"--adb-args"})
    private void setAdbArgs(String args) {
        this.adbArgs = ImmutableList.copyOf((Iterable)Splitter.on((char)' ').split((CharSequence)args));
    }

    @Override
    public ImmutableList<String> adbArgs() {
        return this.adbArgs;
    }

    @Override
    public boolean printWorkerLog() {
        return this.printWorkerLog;
    }

    @CommandLineParser.Leftovers
    private void setLeftovers(ImmutableList<String> leftovers) throws InvalidCommandException {
        if (this.requireBenchmarkClassName) {
            if (leftovers.isEmpty()) {
                throw new InvalidCommandException("No benchmark class specified", new Object[0]);
            }
            if (leftovers.size() > 1) {
                String string = String.valueOf(leftovers);
                throw new InvalidCommandException(new StringBuilder(39 + String.valueOf(string).length()).append("Extra stuff, expected only class name: ").append(string).toString(), new Object[0]);
            }
            this.benchmarkClassName = (String)leftovers.get(0);
        } else if (!leftovers.isEmpty()) {
            String string = String.valueOf(leftovers);
            throw new InvalidCommandException(new StringBuilder(50 + String.valueOf(string).length()).append("Extra stuff, did not expect non-option arguments: ").append(string).toString(), new Object[0]);
        }
    }

    @Override
    public String benchmarkClassName() {
        return this.benchmarkClassName;
    }

    private static List<String> splitProperty(String propertyString) throws InvalidCommandException {
        ImmutableList tokens = ImmutableList.copyOf((Iterable)Splitter.on((char)'=').limit(2).split((CharSequence)propertyString));
        if (tokens.size() != 2) {
            String string = String.valueOf(propertyString);
            throw new InvalidCommandException(string.length() != 0 ? "no '=' found in: ".concat(string) : new String("no '=' found in: "), new Object[0]);
        }
        return tokens;
    }

    private void addToMultimap(String nameAndValues, Multimap<String, String> multimap) throws InvalidCommandException {
        List<String> tokens = ParsedOptions.splitProperty(nameAndValues);
        String name = tokens.get(0);
        String values = tokens.get(1);
        if (multimap.containsKey((Object)name)) {
            String string = String.valueOf(name);
            throw new InvalidCommandException(string.length() != 0 ? "multiple parameter sets for: ".concat(string) : new String("multiple parameter sets for: "), new Object[0]);
        }
        multimap.putAll((Object)name, this.split(values));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("benchmarkClassName", (Object)this.benchmarkClassName()).add("benchmarkMethodNames", this.benchmarkMethodNames()).add("benchmarkParameters", this.userParameters()).add("dryRun", this.dryRun()).add("instrumentNames", this.instrumentNames()).add("vms", this.vmNames()).add("vmArguments", this.vmArguments()).add("trials", this.trialsPerScenario()).add("printConfig", this.printConfiguration()).add("delimiter", (Object)this.delimiter).add("caliperConfigFile", this.caliperConfigFile).toString();
    }
}

