/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.target;

import com.google.auto.value.AutoValue;
import com.google.caliper.runner.config.VmConfig;
import com.google.caliper.runner.config.VmType;
import com.google.caliper.runner.target.AutoValue_AndroidVm;
import com.google.caliper.runner.target.Vm;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;

@AutoValue
public abstract class AndroidVm
extends Vm {
    public static AndroidVm create(VmConfig config, String classpath, String nativeLibraryPath) {
        return new AutoValue_AndroidVm(VmType.ANDROID, config, classpath, nativeLibraryPath);
    }

    AndroidVm() {
    }

    @Override
    public String executable() {
        return (String)this.config().executable().or((Object)"dalvikvm");
    }

    @Override
    public ImmutableSet<String> trialArgs() {
        return ImmutableSet.of();
    }

    @Override
    public ImmutableList<String> lastArgs() {
        return this.executable().equals("app_process") ? ImmutableList.of((Object)"/system/bin") : ImmutableList.of();
    }

    public abstract String nativeLibraryPath();

    @Override
    public ImmutableList<String> classpathArgs() {
        String string = String.valueOf(this.classpath());
        String string2 = String.valueOf(this.nativeLibraryPath());
        return ImmutableList.of((Object)(string.length() != 0 ? "-Djava.class.path=".concat(string) : new String("-Djava.class.path=")), (Object)(string2.length() != 0 ? "-Djava.library.path=".concat(string2) : new String("-Djava.library.path=")));
    }

    @Override
    public Predicate<String> vmPropertiesToRetain() {
        return Predicates.alwaysFalse();
    }
}

