/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.target;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;
import java.util.Set;

final class EffectiveClassPath {
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private static final String JAVA_CLASS_PATH = System.getProperty("java.class.path");

    private EffectiveClassPath() {
    }

    static String getClassPathForClassLoader(ClassLoader classLoader) {
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        for (String entry : Splitter.on((String)PATH_SEPARATOR).split((CharSequence)JAVA_CLASS_PATH)) {
            files.add(new File(entry));
        }
        files.addAll(EffectiveClassPath.getClassPathFiles(classLoader));
        return Joiner.on((String)PATH_SEPARATOR).join(files);
    }

    private static Set<File> getClassPathFiles(ClassLoader classLoader) {
        ImmutableSet.Builder files = ImmutableSet.builder();
        ClassLoader parent = classLoader.getParent();
        if (parent != null) {
            files.addAll(EffectiveClassPath.getClassPathFiles(parent));
        }
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            for (URL url : urlClassLoader.getURLs()) {
                try {
                    files.add((Object)new File(url.toURI()));
                }
                catch (URISyntaxException uRISyntaxException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return files.build();
    }
}

