/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.bytecode;

import com.google.common.base.MoreObjects;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.turbine.binder.bound.AnnotationMetadata;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.bytecode.BytecodeBinder;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.FieldSymbol;
import com.google.turbine.binder.sym.MethodSymbol;
import com.google.turbine.binder.sym.ParamSymbol;
import com.google.turbine.binder.sym.RecordComponentSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.bytecode.ClassFile;
import com.google.turbine.bytecode.ClassReader;
import com.google.turbine.bytecode.sig.Sig;
import com.google.turbine.bytecode.sig.SigParser;
import com.google.turbine.model.Const;
import com.google.turbine.model.TurbineElementType;
import com.google.turbine.model.TurbineTyKind;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import java.lang.annotation.RetentionPolicy;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class BytecodeBoundClass
implements TypeBoundClass {
    private final ClassSymbol sym;
    private final Env<ClassSymbol, BytecodeBoundClass> env;
    private final Supplier<ClassFile> classFile;
    private final @Nullable String jarFile;
    private final Supplier<TurbineTyKind> kind = Suppliers.memoize((Supplier)new Supplier<TurbineTyKind>(){

        public TurbineTyKind get() {
            int access = BytecodeBoundClass.this.access();
            if ((access & 0x2000) == 8192) {
                return TurbineTyKind.ANNOTATION;
            }
            if ((access & 0x200) == 512) {
                return TurbineTyKind.INTERFACE;
            }
            if ((access & 0x4000) == 16384) {
                return TurbineTyKind.ENUM;
            }
            return TurbineTyKind.CLASS;
        }
    });
    private final Supplier<@Nullable ClassSymbol> owner = Suppliers.memoize((Supplier)new Supplier<ClassSymbol>(){

        public @Nullable ClassSymbol get() {
            for (ClassFile.InnerClass inner : ((ClassFile)BytecodeBoundClass.this.classFile.get()).innerClasses()) {
                if (!BytecodeBoundClass.this.sym.binaryName().equals(inner.innerClass())) continue;
                return new ClassSymbol(inner.outerClass());
            }
            return null;
        }
    });
    private final Supplier<ImmutableMap<String, ClassSymbol>> children = Suppliers.memoize((Supplier)new Supplier<ImmutableMap<String, ClassSymbol>>(){

        public ImmutableMap<String, ClassSymbol> get() {
            ImmutableMap.Builder result = ImmutableMap.builder();
            for (ClassFile.InnerClass inner : ((ClassFile)BytecodeBoundClass.this.classFile.get()).innerClasses()) {
                if (inner.innerName() == null || !BytecodeBoundClass.this.sym.binaryName().equals(inner.outerClass())) continue;
                result.put((Object)inner.innerName(), (Object)new ClassSymbol(inner.innerClass()));
            }
            return result.buildOrThrow();
        }
    });
    private final Supplier<Integer> access = Suppliers.memoize((Supplier)new Supplier<Integer>(){

        public Integer get() {
            int access = ((ClassFile)BytecodeBoundClass.this.classFile.get()).access();
            for (ClassFile.InnerClass inner : ((ClassFile)BytecodeBoundClass.this.classFile.get()).innerClasses()) {
                if (!BytecodeBoundClass.this.sym.binaryName().equals(inner.innerClass())) continue;
                access = inner.access();
            }
            return access;
        }
    });
    private final Supplier<@Nullable Sig.ClassSig> sig = Suppliers.memoize((Supplier)new Supplier<Sig.ClassSig>(){

        public @Nullable Sig.ClassSig get() {
            String signature = ((ClassFile)BytecodeBoundClass.this.classFile.get()).signature();
            if (signature == null) {
                return null;
            }
            return new SigParser(signature).parseClassSig();
        }
    });
    private final Supplier<ImmutableMap<String, TyVarSymbol>> tyParams = Suppliers.memoize((Supplier)new Supplier<ImmutableMap<String, TyVarSymbol>>(){

        public ImmutableMap<String, TyVarSymbol> get() {
            Sig.ClassSig csig = (Sig.ClassSig)BytecodeBoundClass.this.sig.get();
            if (csig == null || csig.tyParams().isEmpty()) {
                return ImmutableMap.of();
            }
            ImmutableMap.Builder result = ImmutableMap.builder();
            for (Sig.TyParamSig p : csig.tyParams()) {
                result.put((Object)p.name(), (Object)new TyVarSymbol(BytecodeBoundClass.this.sym, p.name()));
            }
            return result.buildOrThrow();
        }
    });
    private final Supplier<@Nullable ClassSymbol> superclass = Suppliers.memoize((Supplier)new Supplier<ClassSymbol>(){

        public @Nullable ClassSymbol get() {
            String superclass = ((ClassFile)BytecodeBoundClass.this.classFile.get()).superName();
            if (superclass == null) {
                return null;
            }
            return new ClassSymbol(superclass);
        }
    });
    private final Supplier<ImmutableList<ClassSymbol>> interfaces = Suppliers.memoize((Supplier)new Supplier<ImmutableList<ClassSymbol>>(){

        public ImmutableList<ClassSymbol> get() {
            ImmutableList.Builder result = ImmutableList.builder();
            for (String i : ((ClassFile)BytecodeBoundClass.this.classFile.get()).interfaces()) {
                result.add((Object)new ClassSymbol(i));
            }
            return result.build();
        }
    });
    private final Supplier<@Nullable Type.ClassTy> superClassType = Suppliers.memoize((Supplier)new Supplier<Type.ClassTy>(){

        public @Nullable Type.ClassTy get() {
            if (BytecodeBoundClass.this.superclass() == null) {
                return null;
            }
            ImmutableList<ClassFile.TypeAnnotationInfo> typeAnnotations = BytecodeBoundClass.this.typeAnnotationsForSupertype(65535);
            if (BytecodeBoundClass.this.sig.get() == null || ((Sig.ClassSig)BytecodeBoundClass.this.sig.get()).superClass() == null) {
                return BytecodeBinder.asNonParametricClassTy(BytecodeBoundClass.this.superclass(), typeAnnotations, BytecodeBoundClass.this.makeScope(BytecodeBoundClass.this.env, BytecodeBoundClass.this.sym, (Map<String, TyVarSymbol>)ImmutableMap.of()));
            }
            return BytecodeBinder.bindClassTy(((Sig.ClassSig)BytecodeBoundClass.this.sig.get()).superClass(), BytecodeBoundClass.this.makeScope(BytecodeBoundClass.this.env, BytecodeBoundClass.this.sym, (Map<String, TyVarSymbol>)ImmutableMap.of()), typeAnnotations);
        }
    });
    private final Supplier<ImmutableList<Type>> interfaceTypes = Suppliers.memoize((Supplier)new Supplier<ImmutableList<Type>>(){

        public ImmutableList<Type> get() {
            ImmutableList<Sig.ClassTySig> sigs;
            ImmutableList<ClassSymbol> interfaces = BytecodeBoundClass.this.interfaces();
            if (interfaces.isEmpty()) {
                return ImmutableList.of();
            }
            ImmutableList.Builder result = ImmutableList.builder();
            BytecodeBinder.Scope scope = BytecodeBoundClass.this.makeScope(BytecodeBoundClass.this.env, BytecodeBoundClass.this.sym, (Map<String, TyVarSymbol>)ImmutableMap.of());
            ImmutableList<Sig.ClassTySig> immutableList = sigs = BytecodeBoundClass.this.sig.get() == null ? null : ((Sig.ClassSig)BytecodeBoundClass.this.sig.get()).interfaces();
            if (sigs == null) {
                for (int i = 0; i < interfaces.size(); ++i) {
                    result.add((Object)BytecodeBinder.asNonParametricClassTy((ClassSymbol)interfaces.get(i), BytecodeBoundClass.this.typeAnnotationsForSupertype(i), scope));
                }
            } else {
                for (int i = 0; i < sigs.size(); ++i) {
                    result.add((Object)BytecodeBinder.bindClassTy((Sig.ClassTySig)sigs.get(i), scope, BytecodeBoundClass.this.typeAnnotationsForSupertype(i)));
                }
            }
            return result.build();
        }
    });
    private final Supplier<ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo>> typeParameterTypes = Suppliers.memoize((Supplier)new Supplier<ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo>>(){

        public ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> get() {
            if (BytecodeBoundClass.this.sig.get() == null) {
                return ImmutableMap.of();
            }
            BytecodeBinder.Scope scope = BytecodeBoundClass.this.makeScope(BytecodeBoundClass.this.env, BytecodeBoundClass.this.sym, (Map<String, TyVarSymbol>)BytecodeBoundClass.this.typeParameters());
            return BytecodeBoundClass.bindTypeParams(((Sig.ClassSig)BytecodeBoundClass.this.sig.get()).tyParams(), BytecodeBoundClass.this.typeParameters(), scope, ClassFile.TypeAnnotationInfo.TargetType.CLASS_TYPE_PARAMETER, ClassFile.TypeAnnotationInfo.TargetType.CLASS_TYPE_PARAMETER_BOUND, ((ClassFile)BytecodeBoundClass.this.classFile.get()).typeAnnotations());
        }
    });
    private final Supplier<ImmutableList<TypeBoundClass.FieldInfo>> fields = Suppliers.memoize((Supplier)new Supplier<ImmutableList<TypeBoundClass.FieldInfo>>(){

        public ImmutableList<TypeBoundClass.FieldInfo> get() {
            ImmutableList.Builder fields = ImmutableList.builder();
            for (ClassFile.FieldInfo cfi : ((ClassFile)BytecodeBoundClass.this.classFile.get()).fields()) {
                FieldSymbol fieldSym = new FieldSymbol(BytecodeBoundClass.this.sym, cfi.name());
                Type type = BytecodeBinder.bindTy(new SigParser((String)MoreObjects.firstNonNull((Object)cfi.signature(), (Object)cfi.descriptor())).parseType(), BytecodeBoundClass.this.makeScope(BytecodeBoundClass.this.env, BytecodeBoundClass.this.sym, (Map<String, TyVarSymbol>)ImmutableMap.of()), BytecodeBoundClass.typeAnnotationsForTarget(cfi.typeAnnotations(), ClassFile.TypeAnnotationInfo.TargetType.FIELD));
                int access = cfi.access();
                Const.Value value = cfi.value();
                if (value != null) {
                    value = BytecodeBinder.bindConstValue(type, value);
                }
                ImmutableList<AnnoInfo> annotations = BytecodeBinder.bindAnnotations(cfi.annotations(), BytecodeBoundClass.this.makeScope(BytecodeBoundClass.this.env, BytecodeBoundClass.this.sym, (Map<String, TyVarSymbol>)ImmutableMap.of()));
                fields.add((Object)new TypeBoundClass.FieldInfo(fieldSym, type, access, annotations, null, value));
            }
            return fields.build();
        }
    });
    private final Supplier<ImmutableList<TypeBoundClass.MethodInfo>> methods = Suppliers.memoize((Supplier)new Supplier<ImmutableList<TypeBoundClass.MethodInfo>>(){

        public ImmutableList<TypeBoundClass.MethodInfo> get() {
            ImmutableList.Builder methods = ImmutableList.builder();
            int idx = 0;
            ClassFile cf = (ClassFile)BytecodeBoundClass.this.classFile.get();
            for (ClassFile.MethodInfo m : cf.methods()) {
                if (m.name().equals("<clinit>")) continue;
                methods.add((Object)BytecodeBoundClass.this.bindMethod(cf, idx++, m));
            }
            return methods.build();
        }
    });
    private final Supplier<ImmutableList<TypeBoundClass.RecordComponentInfo>> components = Suppliers.memoize((Supplier)new Supplier<ImmutableList<TypeBoundClass.RecordComponentInfo>>(){

        public ImmutableList<TypeBoundClass.RecordComponentInfo> get() {
            ClassFile.RecordInfo record = ((ClassFile)BytecodeBoundClass.this.classFile.get()).record();
            if (record == null) {
                return ImmutableList.of();
            }
            ImmutableList.Builder result = ImmutableList.builder();
            for (ClassFile.RecordInfo.RecordComponentInfo component : record.recordComponents()) {
                Type type = BytecodeBinder.bindTy(new SigParser((String)MoreObjects.firstNonNull((Object)component.signature(), (Object)component.descriptor())).parseType(), BytecodeBoundClass.this.makeScope(BytecodeBoundClass.this.env, BytecodeBoundClass.this.sym, (Map<String, TyVarSymbol>)ImmutableMap.of()), BytecodeBoundClass.typeAnnotationsForTarget(component.typeAnnotations(), ClassFile.TypeAnnotationInfo.TargetType.FIELD));
                result.add((Object)new TypeBoundClass.RecordComponentInfo(new RecordComponentSymbol(BytecodeBoundClass.this.sym, component.name()), type, BytecodeBinder.bindAnnotations(component.annotations(), BytecodeBoundClass.this.makeScope(BytecodeBoundClass.this.env, BytecodeBoundClass.this.sym, (Map<String, TyVarSymbol>)ImmutableMap.of())), 0));
            }
            return result.build();
        }
    });
    private final Supplier<@Nullable AnnotationMetadata> annotationMetadata = Suppliers.memoize((Supplier)new Supplier<AnnotationMetadata>(){

        public @Nullable AnnotationMetadata get() {
            if ((BytecodeBoundClass.this.access() & 0x2000) != 8192) {
                return null;
            }
            RetentionPolicy retention = null;
            ImmutableSet<TurbineElementType> target = null;
            ClassSymbol repeatable = null;
            for (ClassFile.AnnotationInfo annotation : ((ClassFile)BytecodeBoundClass.this.classFile.get()).annotations()) {
                switch (annotation.typeName()) {
                    case "Ljava/lang/annotation/Retention;": {
                        retention = BytecodeBoundClass.bindRetention(annotation);
                        break;
                    }
                    case "Ljava/lang/annotation/Target;": {
                        target = BytecodeBoundClass.bindTarget(annotation);
                        break;
                    }
                    case "Ljava/lang/annotation/Repeatable;": {
                        repeatable = BytecodeBoundClass.bindRepeatable(annotation);
                        break;
                    }
                }
            }
            return new AnnotationMetadata(retention, target, repeatable);
        }
    });
    private final Supplier<ImmutableList<AnnoInfo>> annotations = Suppliers.memoize((Supplier)new Supplier<ImmutableList<AnnoInfo>>(){

        public ImmutableList<AnnoInfo> get() {
            return BytecodeBinder.bindAnnotations(((ClassFile)BytecodeBoundClass.this.classFile.get()).annotations(), BytecodeBoundClass.this.makeScope(BytecodeBoundClass.this.env, BytecodeBoundClass.this.sym, (Map<String, TyVarSymbol>)ImmutableMap.of()));
        }
    });
    private final Supplier<ImmutableMap<ClassSymbol, ClassFile.InnerClass>> innerClasses = Suppliers.memoize((Supplier)new Supplier<ImmutableMap<ClassSymbol, ClassFile.InnerClass>>(){

        public ImmutableMap<ClassSymbol, ClassFile.InnerClass> get() {
            ImmutableMap.Builder result = ImmutableMap.builder();
            for (ClassFile.InnerClass inner : ((ClassFile)BytecodeBoundClass.this.classFile.get()).innerClasses()) {
                result.put((Object)new ClassSymbol(inner.innerClass()), (Object)inner);
            }
            return result.buildOrThrow();
        }
    });

    public static Supplier<BytecodeBoundClass> lazy(final ClassSymbol sym, final Supplier<byte[]> bytes, final Env<ClassSymbol, BytecodeBoundClass> env, final Path path) {
        return Suppliers.memoize((Supplier)new Supplier<BytecodeBoundClass>(){

            public BytecodeBoundClass get() {
                return new BytecodeBoundClass(sym, (Supplier<byte[]>)bytes, env, path.toString());
            }
        });
    }

    public BytecodeBoundClass(final ClassSymbol sym, final Supplier<byte[]> bytes, Env<ClassSymbol, BytecodeBoundClass> env, final @Nullable String jarFile) {
        this.sym = sym;
        this.env = env;
        this.jarFile = jarFile;
        this.classFile = Suppliers.memoize((Supplier)new Supplier<ClassFile>(){

            public ClassFile get() {
                ClassFile cf = ClassReader.read(jarFile + "!" + sym.binaryName(), (byte[])bytes.get());
                Verify.verify((boolean)cf.name().equals(sym.binaryName()), (String)"expected class data for %s, saw %s instead", (Object)sym.binaryName(), (Object)cf.name());
                return cf;
            }
        });
    }

    @Override
    public TurbineTyKind kind() {
        return (TurbineTyKind)((Object)this.kind.get());
    }

    @Override
    public @Nullable ClassSymbol owner() {
        return (ClassSymbol)this.owner.get();
    }

    @Override
    public ImmutableMap<String, ClassSymbol> children() {
        return (ImmutableMap)this.children.get();
    }

    @Override
    public int access() {
        return (Integer)this.access.get();
    }

    @Override
    public ImmutableMap<String, TyVarSymbol> typeParameters() {
        return (ImmutableMap)this.tyParams.get();
    }

    @Override
    public @Nullable ClassSymbol superclass() {
        return (ClassSymbol)this.superclass.get();
    }

    @Override
    public ImmutableList<ClassSymbol> interfaces() {
        return (ImmutableList)this.interfaces.get();
    }

    @Override
    public @Nullable Type.ClassTy superClassType() {
        return (Type.ClassTy)this.superClassType.get();
    }

    @Override
    public ImmutableList<Type> interfaceTypes() {
        return (ImmutableList)this.interfaceTypes.get();
    }

    @Override
    public ImmutableList<ClassSymbol> permits() {
        return ImmutableList.of();
    }

    private static ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> bindTypeParams(ImmutableList<Sig.TyParamSig> tyParamSigs, ImmutableMap<String, TyVarSymbol> tyParams, BytecodeBinder.Scope scope, ClassFile.TypeAnnotationInfo.TargetType typeParameterTarget, ClassFile.TypeAnnotationInfo.TargetType typeParameterBoundTarget, ImmutableList<ClassFile.TypeAnnotationInfo> typeAnnotations) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (int i = 0; i < tyParamSigs.size(); ++i) {
            Sig.TyParamSig p = (Sig.TyParamSig)tyParamSigs.get(i);
            result.put((Object)Objects.requireNonNull((TyVarSymbol)tyParams.get((Object)p.name())), (Object)BytecodeBoundClass.bindTyParam(p, scope, i, typeParameterTarget, typeParameterBoundTarget, typeAnnotations));
        }
        return result.buildOrThrow();
    }

    private static TypeBoundClass.TyVarInfo bindTyParam(Sig.TyParamSig sig, BytecodeBinder.Scope scope, int typeParameterIndex, ClassFile.TypeAnnotationInfo.TargetType typeParameterTarget, ClassFile.TypeAnnotationInfo.TargetType typeParameterBoundTarget, ImmutableList<ClassFile.TypeAnnotationInfo> typeAnnotations) {
        ImmutableList.Builder bounds = ImmutableList.builder();
        if (sig.classBound() != null) {
            bounds.add((Object)BytecodeBinder.bindTy(sig.classBound(), scope, BytecodeBoundClass.typeAnnotationsForTarget(typeAnnotations, typeParameterBoundTarget, ClassFile.TypeAnnotationInfo.TypeParameterBoundTarget.create(typeParameterIndex, 0))));
        }
        int boundIndex = 1;
        for (Sig.TySig t : sig.interfaceBounds()) {
            bounds.add((Object)BytecodeBinder.bindTy(t, scope, BytecodeBoundClass.typeAnnotationsForTarget(typeAnnotations, typeParameterBoundTarget, ClassFile.TypeAnnotationInfo.TypeParameterBoundTarget.create(typeParameterIndex, boundIndex++))));
        }
        return new TypeBoundClass.TyVarInfo(Type.IntersectionTy.create((ImmutableList<Type>)bounds.build()), null, BytecodeBoundClass.bindTyVarAnnotations(scope, typeParameterIndex, typeParameterTarget, typeAnnotations));
    }

    private static ImmutableList<AnnoInfo> bindTyVarAnnotations(BytecodeBinder.Scope scope, int typeParameterIndex, ClassFile.TypeAnnotationInfo.TargetType typeParameterTarget, ImmutableList<ClassFile.TypeAnnotationInfo> typeAnnotations) {
        ImmutableList.Builder result = ImmutableList.builder();
        ClassFile.TypeAnnotationInfo.TypeParameterTarget target = ClassFile.TypeAnnotationInfo.TypeParameterTarget.create(typeParameterIndex);
        for (ClassFile.TypeAnnotationInfo typeAnnotation : typeAnnotations) {
            if (!typeAnnotation.targetType().equals((Object)typeParameterTarget) || !typeAnnotation.target().equals(target) || !typeAnnotation.path().equals(ClassFile.TypeAnnotationInfo.TypePath.root())) continue;
            result.add((Object)BytecodeBinder.bindAnnotationValue(typeAnnotation.anno(), scope).info());
        }
        return result.build();
    }

    @Override
    public ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> typeParameterTypes() {
        return (ImmutableMap)this.typeParameterTypes.get();
    }

    @Override
    public ImmutableList<TypeBoundClass.FieldInfo> fields() {
        return (ImmutableList)this.fields.get();
    }

    private TypeBoundClass.MethodInfo bindMethod(ClassFile classFile, int methodIdx, ClassFile.MethodInfo m) {
        int access;
        MethodSymbol methodSymbol = new MethodSymbol(methodIdx, this.sym, m.name());
        Sig.MethodSig sig = new SigParser((String)MoreObjects.firstNonNull((Object)m.signature(), (Object)m.descriptor())).parseMethodSig();
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Sig.TyParamSig p : sig.tyParams()) {
            result.put((Object)p.name(), (Object)new TyVarSymbol(methodSymbol, p.name()));
        }
        ImmutableMap tyParams = result.buildOrThrow();
        BytecodeBinder.Scope scope = this.makeScope(this.env, this.sym, (Map<String, TyVarSymbol>)tyParams);
        ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> tyParamTypes = BytecodeBoundClass.bindTypeParams(sig.tyParams(), (ImmutableMap<String, TyVarSymbol>)tyParams, scope, ClassFile.TypeAnnotationInfo.TargetType.METHOD_TYPE_PARAMETER, ClassFile.TypeAnnotationInfo.TargetType.METHOD_TYPE_PARAMETER_BOUND, m.typeAnnotations());
        scope = this.makeScope(this.env, this.sym, (Map<String, TyVarSymbol>)tyParams);
        Type ret = BytecodeBinder.bindTy(sig.returnType(), scope, BytecodeBoundClass.typeAnnotationsForTarget(m.typeAnnotations(), ClassFile.TypeAnnotationInfo.TargetType.METHOD_RETURN));
        ImmutableList.Builder formals = ImmutableList.builder();
        int idx = 0;
        for (Sig.TySig tySig : sig.params()) {
            Object name;
            access = 0;
            if (idx < m.parameters().size()) {
                ClassFile.MethodInfo.ParameterInfo paramInfo = (ClassFile.MethodInfo.ParameterInfo)m.parameters().get(idx);
                name = paramInfo.name();
            } else {
                name = "arg" + idx;
            }
            ImmutableList<AnnoInfo> annotations = idx < m.parameterAnnotations().size() ? BytecodeBinder.bindAnnotations((List)m.parameterAnnotations().get(idx), scope) : ImmutableList.of();
            formals.add((Object)new TypeBoundClass.ParamInfo(new ParamSymbol(methodSymbol, (String)name), BytecodeBinder.bindTy(tySig, scope, BytecodeBoundClass.typeAnnotationsForTarget(m.typeAnnotations(), ClassFile.TypeAnnotationInfo.TargetType.METHOD_FORMAL_PARAMETER, ClassFile.TypeAnnotationInfo.FormalParameterTarget.create(idx))), annotations, access));
            ++idx;
        }
        ImmutableList.Builder exceptions = ImmutableList.builder();
        if (!sig.exceptions().isEmpty()) {
            exceptionTypes = sig.exceptions();
            for (i = 0; i < exceptionTypes.size(); ++i) {
                exceptions.add((Object)BytecodeBinder.bindTy((Sig.TySig)exceptionTypes.get(i), scope, BytecodeBoundClass.typeAnnotationsForThrows(m.typeAnnotations(), i)));
            }
        } else {
            exceptionTypes = m.exceptions();
            for (i = 0; i < m.exceptions().size(); ++i) {
                exceptions.add((Object)BytecodeBinder.asNonParametricClassTy(new ClassSymbol((String)exceptionTypes.get(i)), BytecodeBoundClass.typeAnnotationsForThrows(m.typeAnnotations(), i), scope));
            }
        }
        Const defaultValue = m.defaultValue() != null ? BytecodeBinder.bindValue(m.defaultValue(), scope) : null;
        ImmutableList<AnnoInfo> annotations = BytecodeBinder.bindAnnotations(m.annotations(), scope);
        access = m.access();
        if ((classFile.access() & 0x200) == 512 && (access & 0x408) == 0) {
            access |= 0x10000;
        }
        TypeBoundClass.ParamInfo receiver = null;
        ImmutableList<ClassFile.TypeAnnotationInfo> receiverAnnotations = BytecodeBoundClass.typeAnnotationsForTarget(m.typeAnnotations(), ClassFile.TypeAnnotationInfo.TargetType.METHOD_RECEIVER_PARAMETER);
        if (!receiverAnnotations.isEmpty()) {
            receiver = new TypeBoundClass.ParamInfo(new ParamSymbol(methodSymbol, "this"), BytecodeBinder.asNonParametricClassTy(this.sym, receiverAnnotations, scope), (ImmutableList<AnnoInfo>)ImmutableList.of(), 0);
        }
        return new TypeBoundClass.MethodInfo(methodSymbol, tyParamTypes, ret, (ImmutableList<TypeBoundClass.ParamInfo>)formals.build(), (ImmutableList<Type>)exceptions.build(), access, defaultValue, null, annotations, receiver);
    }

    @Override
    public ImmutableList<TypeBoundClass.MethodInfo> methods() {
        return (ImmutableList)this.methods.get();
    }

    @Override
    public ImmutableList<TypeBoundClass.RecordComponentInfo> components() {
        return (ImmutableList)this.components.get();
    }

    private static @Nullable RetentionPolicy bindRetention(ClassFile.AnnotationInfo annotation) {
        ClassFile.AnnotationInfo.ElementValue val = annotation.elementValuePairs().get("value");
        if (val == null) {
            return null;
        }
        if (val.kind() != ClassFile.AnnotationInfo.ElementValue.Kind.ENUM) {
            return null;
        }
        ClassFile.AnnotationInfo.ElementValue.EnumConstValue enumVal = (ClassFile.AnnotationInfo.ElementValue.EnumConstValue)val;
        if (!enumVal.typeName().equals("Ljava/lang/annotation/RetentionPolicy;")) {
            return null;
        }
        return RetentionPolicy.valueOf(enumVal.constName());
    }

    private static ImmutableSet<TurbineElementType> bindTarget(ClassFile.AnnotationInfo annotation) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        ClassFile.AnnotationInfo.ElementValue val = annotation.elementValuePairs().get("value");
        Objects.requireNonNull(val);
        switch (val.kind()) {
            case ARRAY: {
                for (ClassFile.AnnotationInfo.ElementValue element : ((ClassFile.AnnotationInfo.ElementValue.ArrayValue)val).elements()) {
                    if (element.kind() != ClassFile.AnnotationInfo.ElementValue.Kind.ENUM) continue;
                    BytecodeBoundClass.bindTargetElement((ImmutableSet.Builder<TurbineElementType>)result, (ClassFile.AnnotationInfo.ElementValue.EnumConstValue)element);
                }
                break;
            }
            case ENUM: {
                BytecodeBoundClass.bindTargetElement((ImmutableSet.Builder<TurbineElementType>)result, (ClassFile.AnnotationInfo.ElementValue.EnumConstValue)val);
                break;
            }
        }
        return result.build();
    }

    private static void bindTargetElement(ImmutableSet.Builder<TurbineElementType> target, ClassFile.AnnotationInfo.ElementValue.EnumConstValue enumVal) {
        if (enumVal.typeName().equals("Ljava/lang/annotation/ElementType;")) {
            target.add((Object)TurbineElementType.valueOf(enumVal.constName()));
        }
    }

    private static @Nullable ClassSymbol bindRepeatable(ClassFile.AnnotationInfo annotation) {
        ClassFile.AnnotationInfo.ElementValue val = annotation.elementValuePairs().get("value");
        if (val == null) {
            return null;
        }
        switch (val.kind()) {
            case CLASS: {
                String className = ((ClassFile.AnnotationInfo.ElementValue.ConstTurbineClassValue)val).className();
                return new ClassSymbol(className.substring(1, className.length() - 1));
            }
        }
        return null;
    }

    @Override
    public @Nullable AnnotationMetadata annotationMetadata() {
        return (AnnotationMetadata)this.annotationMetadata.get();
    }

    @Override
    public ImmutableList<AnnoInfo> annotations() {
        return (ImmutableList)this.annotations.get();
    }

    private static ImmutableList<ClassFile.TypeAnnotationInfo> typeAnnotationsForThrows(ImmutableList<ClassFile.TypeAnnotationInfo> typeAnnotations, int index) {
        return BytecodeBoundClass.typeAnnotationsForTarget(typeAnnotations, ClassFile.TypeAnnotationInfo.TargetType.METHOD_THROWS, ClassFile.TypeAnnotationInfo.ThrowsTarget.create(index));
    }

    private ImmutableList<ClassFile.TypeAnnotationInfo> typeAnnotationsForSupertype(int index) {
        return BytecodeBoundClass.typeAnnotationsForTarget(((ClassFile)this.classFile.get()).typeAnnotations(), ClassFile.TypeAnnotationInfo.TargetType.SUPERTYPE, ClassFile.TypeAnnotationInfo.SuperTypeTarget.create(index));
    }

    private static ImmutableList<ClassFile.TypeAnnotationInfo> typeAnnotationsForTarget(ImmutableList<ClassFile.TypeAnnotationInfo> annotations, ClassFile.TypeAnnotationInfo.TargetType target) {
        return BytecodeBoundClass.typeAnnotationsForTarget(annotations, target, ClassFile.TypeAnnotationInfo.EMPTY_TARGET);
    }

    private static ImmutableList<ClassFile.TypeAnnotationInfo> typeAnnotationsForTarget(ImmutableList<ClassFile.TypeAnnotationInfo> typeAnnotations, ClassFile.TypeAnnotationInfo.TargetType targetType, ClassFile.TypeAnnotationInfo.Target target) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (ClassFile.TypeAnnotationInfo typeAnnotation : typeAnnotations) {
            if (!typeAnnotation.targetType().equals((Object)targetType) || !typeAnnotation.target().equals(target)) continue;
            result.add((Object)typeAnnotation);
        }
        return result.build();
    }

    private BytecodeBinder.Scope makeScope(final Env<ClassSymbol, BytecodeBoundClass> env, final ClassSymbol sym, final Map<String, TyVarSymbol> typeVariables) {
        return new BytecodeBinder.Scope(){

            @Override
            public TyVarSymbol apply(String input) {
                TyVarSymbol result = (TyVarSymbol)typeVariables.get(input);
                if (result != null) {
                    return result;
                }
                ClassSymbol curr = sym;
                while (curr != null) {
                    BytecodeBoundClass info = (BytecodeBoundClass)env.get(curr);
                    if (info == null) {
                        throw new AssertionError(curr);
                    }
                    result = (TyVarSymbol)info.typeParameters().get((Object)input);
                    if (result != null) {
                        return result;
                    }
                    curr = info.owner();
                }
                throw new AssertionError((Object)input);
            }

            @Override
            public @Nullable ClassSymbol outer(ClassSymbol sym2) {
                ClassFile.InnerClass inner = (ClassFile.InnerClass)((ImmutableMap)BytecodeBoundClass.this.innerClasses.get()).get((Object)sym2);
                if (inner == null) {
                    return null;
                }
                if ((inner.access() & 8) == 8) {
                    return null;
                }
                return new ClassSymbol(inner.outerClass());
            }
        };
    }

    public @Nullable String jarFile() {
        String transitiveJar = ((ClassFile)this.classFile.get()).transitiveJar();
        if (transitiveJar != null) {
            return transitiveJar;
        }
        return this.jarFile;
    }

    public ClassFile classFile() {
        return (ClassFile)this.classFile.get();
    }
}

