/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.model;

import com.google.caliper.model.ExcludeFromJson;
import com.google.caliper.model.PersistentHashing;
import com.google.caliper.model.StringMapFunnel;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.hash.Funnel;
import com.google.common.hash.HashFunction;
import com.google.common.hash.PrimitiveSink;
import java.util.Map;
import java.util.SortedMap;
import java.util.logging.Logger;

public final class Host {
    static final Host DEFAULT = new Host();
    private static final Logger logger = Logger.getLogger(Host.class.getName());
    @ExcludeFromJson
    private int id;
    private SortedMap<String, String> properties;
    @ExcludeFromJson
    private int hash;

    private Host() {
        this.properties = Maps.newTreeMap();
    }

    private Host(Builder builder) {
        this.properties = Maps.newTreeMap((SortedMap)builder.properties);
        this.initHash(builder.hashFunction);
    }

    public ImmutableSortedMap<String, String> properties() {
        return ImmutableSortedMap.copyOf(this.properties);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Host) {
            Host that = (Host)obj;
            return this.properties.equals(that.properties);
        }
        return false;
    }

    private void initHash(HashFunction hashFunction) {
        if (this.hash == 0) {
            this.hash = hashFunction.hashObject((Object)this, (Funnel)HostFunnel.INSTANCE).asInt();
        }
    }

    private void initHash() {
        this.initHash(PersistentHashing.getPersistentHashFunction());
    }

    public int hashCode() {
        this.initHash();
        return this.hash;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("properties", this.properties).toString();
    }

    public static final class Builder {
        private final SortedMap<String, String> properties = Maps.newTreeMap();
        private HashFunction hashFunction = PersistentHashing.getPersistentHashFunction();

        public Builder addProperty(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public Builder addAllProperties(Map<String, String> properties) {
            this.properties.putAll(properties);
            return this;
        }

        @VisibleForTesting
        public Builder hashFunctionForTesting(HashFunction hashFunction) {
            logger.warning("somebody is setting the hash function. this should only be used in tests");
            this.hashFunction = (HashFunction)Preconditions.checkNotNull((Object)hashFunction);
            return this;
        }

        public Host build() {
            return new Host(this);
        }
    }

    static enum HostFunnel implements Funnel<Host>
    {
        INSTANCE;


        public void funnel(Host from, PrimitiveSink into) {
            StringMapFunnel.INSTANCE.funnel(from.properties, into);
        }
    }
}

