/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.fixes;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.fixes.AdjustedPosition;
import com.google.errorprone.fixes.AutoValue_SuggestedFix;
import com.google.errorprone.fixes.AutoValue_SuggestedFix_PostfixInsertion;
import com.google.errorprone.fixes.AutoValue_SuggestedFix_PrefixInsertion;
import com.google.errorprone.fixes.AutoValue_SuggestedFix_ReplacementFix;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.IndexedPosition;
import com.google.errorprone.fixes.Replacement;
import com.google.errorprone.fixes.Replacements;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.JCDiagnostic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.Nullable;

@AutoValue
public abstract class SuggestedFix
implements Fix {
    private static final SuggestedFix EMPTY = SuggestedFix.builder().build();

    abstract ImmutableList<FixOperation> fixes();

    private static SuggestedFix create(Builder builder) {
        return new AutoValue_SuggestedFix(builder.coalescePolicy, (ImmutableList<FixOperation>)ImmutableList.copyOf(builder.fixes), (ImmutableSet<String>)ImmutableSet.copyOf(builder.importsToAdd), (ImmutableSet<String>)ImmutableSet.copyOf(builder.importsToRemove), builder.shortDescription);
    }

    @Override
    public boolean isEmpty() {
        return this.fixes().isEmpty() && this.getImportsToAdd().isEmpty() && this.getImportsToRemove().isEmpty();
    }

    @Override
    public abstract ImmutableSet<String> getImportsToAdd();

    @Override
    public abstract ImmutableSet<String> getImportsToRemove();

    @Override
    public String toString(JCTree.JCCompilationUnit compilationUnit) {
        StringBuilder result = new StringBuilder("replace ");
        for (Replacement replacement : this.getReplacements(compilationUnit.endPositions)) {
            result.append(String.format("position %d:%d with \"%s\" ", replacement.startPosition(), replacement.endPosition(), replacement.replaceWith()));
        }
        return result.toString();
    }

    @Override
    public abstract String getShortDescription();

    @Memoized
    public abstract int hashCode();

    @Override
    public ImmutableSet<Replacement> getReplacements(EndPosTable endPositions) {
        if (endPositions == null) {
            throw new IllegalArgumentException("Cannot produce correct replacements without endPositions.");
        }
        Replacements replacements = new Replacements();
        for (FixOperation fix : this.fixes()) {
            replacements.add(fix.getReplacement(endPositions), this.getCoalescePolicy());
        }
        return replacements.ascending();
    }

    public static SuggestedFix replace(Tree tree, String replaceWith) {
        return SuggestedFix.builder().replace(tree, replaceWith).build();
    }

    public static SuggestedFix replace(int startPos, int endPos, String replaceWith) {
        return SuggestedFix.builder().replace(startPos, endPos, replaceWith).build();
    }

    public static SuggestedFix replace(Tree node, String replaceWith, int startPosAdjustment, int endPosAdjustment) {
        return SuggestedFix.builder().replace(node, replaceWith, startPosAdjustment, endPosAdjustment).build();
    }

    public static SuggestedFix prefixWith(Tree node, String prefix) {
        return SuggestedFix.builder().prefixWith(node, prefix).build();
    }

    public static SuggestedFix postfixWith(Tree node, String postfix) {
        return SuggestedFix.builder().postfixWith(node, postfix).build();
    }

    public static SuggestedFix delete(Tree node) {
        return SuggestedFix.builder().delete(node).build();
    }

    public static SuggestedFix swap(Tree node1, Tree node2) {
        return SuggestedFix.builder().swap(node1, node2).build();
    }

    public static SuggestedFix emptyFix() {
        return EMPTY;
    }

    public static SuggestedFix merge(SuggestedFix first, SuggestedFix second, SuggestedFix ... more) {
        Builder builder = SuggestedFix.builder().merge(first).merge(second);
        for (SuggestedFix fix : more) {
            builder.merge(fix);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return SuggestedFix.builder().merge(this);
    }

    public static class Builder {
        private final List<FixOperation> fixes = new ArrayList<FixOperation>();
        private final Set<String> importsToAdd = new LinkedHashSet<String>();
        private final Set<String> importsToRemove = new LinkedHashSet<String>();
        private Replacements.CoalescePolicy coalescePolicy = Replacements.CoalescePolicy.EXISTING_FIRST;
        private String shortDescription = "";

        protected Builder() {
        }

        public boolean isEmpty() {
            return this.fixes.isEmpty() && this.importsToAdd.isEmpty() && this.importsToRemove.isEmpty();
        }

        public SuggestedFix build() {
            return SuggestedFix.create(this);
        }

        @CanIgnoreReturnValue
        private Builder with(FixOperation fix) {
            this.fixes.add(fix);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setShortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCoalescePolicy(Replacements.CoalescePolicy coalescePolicy) {
            this.coalescePolicy = coalescePolicy;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder replace(Tree node, String replaceWith) {
            Builder.checkNotSyntheticConstructor(node);
            return this.with(ReplacementFix.create((JCDiagnostic.DiagnosticPosition)((Object)node), replaceWith));
        }

        @CanIgnoreReturnValue
        public Builder replace(int startPos, int endPos, String replaceWith) {
            IndexedPosition pos = new IndexedPosition(startPos, endPos);
            return this.with(ReplacementFix.create(pos, replaceWith));
        }

        @CanIgnoreReturnValue
        public Builder replace(Tree node, String replaceWith, int startPosAdjustment, int endPosAdjustment) {
            Builder.checkNotSyntheticConstructor(node);
            return this.with(ReplacementFix.create(new AdjustedPosition((JCTree)node, startPosAdjustment, endPosAdjustment), replaceWith));
        }

        @CanIgnoreReturnValue
        public Builder prefixWith(Tree node, String prefix) {
            Builder.checkNotSyntheticConstructor(node);
            return this.with(PrefixInsertion.create((JCDiagnostic.DiagnosticPosition)((Object)node), prefix));
        }

        @CanIgnoreReturnValue
        public Builder postfixWith(Tree node, String postfix) {
            Builder.checkNotSyntheticConstructor(node);
            return this.with(PostfixInsertion.create((JCDiagnostic.DiagnosticPosition)((Object)node), postfix));
        }

        @CanIgnoreReturnValue
        public Builder delete(Tree node) {
            Builder.checkNotSyntheticConstructor(node);
            return this.replace(node, "");
        }

        @CanIgnoreReturnValue
        public Builder swap(Tree node1, Tree node2) {
            Builder.checkNotSyntheticConstructor(node1);
            Builder.checkNotSyntheticConstructor(node2);
            this.fixes.add(ReplacementFix.create((JCDiagnostic.DiagnosticPosition)((Object)node1), node2.toString()));
            this.fixes.add(ReplacementFix.create((JCDiagnostic.DiagnosticPosition)((Object)node2), node1.toString()));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addImport(String importString) {
            this.importsToAdd.add("import " + importString);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addStaticImport(String importString) {
            this.importsToAdd.add("import static " + importString);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder removeImport(String importString) {
            this.importsToRemove.add("import " + importString);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder removeStaticImport(String importString) {
            this.importsToRemove.add("import static " + importString);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder merge(@Nullable Builder other) {
            if (other == null) {
                return this;
            }
            if (this.shortDescription.isEmpty()) {
                this.shortDescription = other.shortDescription;
            }
            this.fixes.addAll(other.fixes);
            this.importsToAdd.addAll(other.importsToAdd);
            this.importsToRemove.addAll(other.importsToRemove);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder merge(@Nullable SuggestedFix other) {
            if (other == null) {
                return this;
            }
            if (this.shortDescription.isEmpty()) {
                this.shortDescription = other.getShortDescription();
            }
            this.fixes.addAll((Collection<FixOperation>)other.fixes());
            this.importsToAdd.addAll((Collection<String>)other.getImportsToAdd());
            this.importsToRemove.addAll((Collection<String>)other.getImportsToRemove());
            return this;
        }

        private static void checkNotSyntheticConstructor(Tree tree) {
            if (tree instanceof MethodTree && ASTHelpers.isGeneratedConstructor((MethodTree)tree)) {
                throw new IllegalArgumentException("Cannot edit synthetic AST nodes");
            }
        }
    }

    static interface FixOperation {
        public Replacement getReplacement(EndPosTable var1);
    }

    @AutoValue
    static abstract class ReplacementFix
    implements FixOperation {
        ReplacementFix() {
        }

        abstract JCDiagnostic.DiagnosticPosition original();

        abstract String replacement();

        public static ReplacementFix create(JCDiagnostic.DiagnosticPosition original, String replacement) {
            Preconditions.checkArgument((original.getStartPosition() >= 0 ? 1 : 0) != 0, (Object)"invalid start position");
            return new AutoValue_SuggestedFix_ReplacementFix(original, replacement);
        }

        @Override
        public Replacement getReplacement(EndPosTable endPositions) {
            return Replacement.create(this.original().getStartPosition(), this.original().getEndPosition(endPositions), this.replacement());
        }
    }

    @AutoValue
    static abstract class PrefixInsertion
    extends InsertionFix {
        PrefixInsertion() {
        }

        public static PrefixInsertion create(JCDiagnostic.DiagnosticPosition position, String insertion) {
            Preconditions.checkArgument((position.getStartPosition() >= 0 ? 1 : 0) != 0, (Object)"invalid start position");
            return new AutoValue_SuggestedFix_PrefixInsertion(position, insertion);
        }

        @Override
        protected int getInsertionIndex(EndPosTable endPositions) {
            return this.position().getStartPosition();
        }
    }

    @AutoValue
    static abstract class PostfixInsertion
    extends InsertionFix {
        PostfixInsertion() {
        }

        public static PostfixInsertion create(JCDiagnostic.DiagnosticPosition position, String insertion) {
            Preconditions.checkArgument((position.getStartPosition() >= 0 ? 1 : 0) != 0, (Object)"invalid start position");
            return new AutoValue_SuggestedFix_PostfixInsertion(position, insertion);
        }

        @Override
        protected int getInsertionIndex(EndPosTable endPositions) {
            return this.position().getEndPosition(endPositions);
        }
    }

    static abstract class InsertionFix
    implements FixOperation {
        InsertionFix() {
        }

        protected abstract int getInsertionIndex(EndPosTable var1);

        protected abstract JCDiagnostic.DiagnosticPosition position();

        protected abstract String insertion();

        @Override
        public Replacement getReplacement(EndPosTable endPositions) {
            int insertionIndex = this.getInsertionIndex(endPositions);
            return Replacement.create(insertionIndex, insertionIndex, this.insertion());
        }
    }
}

