;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: foreach %s %t wasm-opt --signature-pruning --closed-world -all -S -o - | filecheck %s

;; Test that configureAll is respected: referred functions are not pruned.

(module
  ;; CHECK:      (type $externs (array (mut externref)))
  (type $externs (array (mut externref)))

  ;; CHECK:      (type $funcs (array (mut funcref)))
  (type $funcs (array (mut funcref)))

  ;; CHECK:      (type $bytes (array (mut i8)))
  (type $bytes (array (mut i8)))


  ;; CHECK:      (type $configureAll (func (param (ref null $externs) (ref null $funcs) (ref null $bytes) externref)))
  (type $configureAll (func (param (ref null $externs)) (param (ref null $funcs)) (param (ref null $bytes)) (param externref)))

  (type $struct (struct))

  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $any-2 (func))

    ;; CHECK:       (type $any-1 (func (param anyref)))
    (type $any-1 (func (param anyref)))

    ;; use brands to allow $any-1/2 to be optimized separately.
    (type $brand1 (struct))
  )

  (rec
    (type $any-2 (func (param anyref)))

    (type $brand2 (struct))
    (type $brand3 (struct))
  )

  ;; CHECK:       (type $6 (func (result i32)))

  ;; CHECK:       (type $7 (func))

  ;; CHECK:      (import "wasm:js-prototypes" "configureAll" (func $configureAll (type $configureAll) (param (ref null $externs) (ref null $funcs) (ref null $bytes) externref)))
  (import "wasm:js-prototypes" "configureAll" (func $configureAll (type $configureAll)))


  ;; CHECK:      (data $bytes "12345678")

  ;; CHECK:      (elem $externs externref (item (ref.null noextern)))
  (elem $externs externref
    (ref.null extern)
  )

  ;; CHECK:      (elem $funcs func $foo $bar)
  (elem $funcs funcref
    (ref.func $foo)
    (ref.func $bar)
  )

  (data $bytes "12345678")

  ;; CHECK:      (start $start)
  (start $start)

  ;; CHECK:      (func $start (type $7)
  ;; CHECK-NEXT:  (call $configureAll
  ;; CHECK-NEXT:   (array.new_elem $externs $externs
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (array.new_elem $funcs $funcs
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (array.new_data $bytes $bytes
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 8)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (ref.null noextern)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $start
    (call $configureAll
      (array.new_elem $externs $externs
        (i32.const 0) (i32.const 1))
      (array.new_elem $funcs $funcs
        (i32.const 0) (i32.const 2))
      (array.new_data $bytes $bytes
        (i32.const 0) (i32.const 8))
      (ref.null extern)
    )
  )

  ;; CHECK:      (func $foo (type $6) (result i32)
  ;; CHECK-NEXT:  (i32.const 42)
  ;; CHECK-NEXT: )
  (func $foo (result i32)
    ;; Nothing to do here anyhow, but do not error.
    (i32.const 42)
  )

  ;; CHECK:      (func $bar (type $any-1) (param $x anyref)
  ;; CHECK-NEXT: )
  (func $bar (type $any-1) (param $x anyref)
    ;; The param is unused, but will not be pruned (turned into a local) due to
    ;; configureAll.
  )

  ;; CHECK:      (func $unconfigured (type $any-2)
  ;; CHECK-NEXT:  (local $0 anyref)
  ;; CHECK-NEXT: )
  (func $unconfigured (type $any-2) (param $x anyref)
    ;; This is not referred to by configureAll, and can be pruned.
  )
)
