<!--
SPDX-FileCopyrightText: 2020 Ilaï Deutel
SPDX-License-Identifier: MIT OR Apache-2.0
-->

# Security Policy

## Reporting a vulnerability

Security reports are welcome. Security vulnerabilities can be reported
privately, via either:

- [GitHub security vulnerability report feature](https://docs.github.com/en/code-security/security-advisories/guidance-on-reporting-and-writing-information-about-vulnerabilities/privately-reporting-a-security-vulnerability#privately-reporting-a-security-vulnerability);
  or
- [this Google form](https://forms.gle/pEzZbbpuCfoSynX69),

at your option.

Security issues should **not** be reported via the public GitHub Issue tracker
or discussions.

If the issue is confirmed as a vulnerability, we will open a Security Advisory.
This project follows a 90 day disclosure timeline.

If you would like to encrypt your vulnerability reports, you may use the
author's
[public GPG key](https://keys.openpgp.org/vks/v1/by-fingerprint/102588418FF7E165696490A206E8A973494808A2)
([Keyoxide profile](https://keyoxide.org/102588418ff7e165696490a206e8a973494808a2)).

## Vulnerability disclosures

Security issues will be announced via the
[project's release notes](https://github.com/ilai-deutel/kibi/releases) and
GitHub's [security advisory](https://github.com/ilai-deutel/kibi/security)
system.
