/*
 *    This file is part of CasADi.
 *
 *    CasADi -- A symbolic framework for dynamic optimization.
 *    Copyright (C) 2010-2023 Joel Andersson, Joris Gillis, Moritz Diehl,
 *                            KU Leuven. All rights reserved.
 *    Copyright (C) 2011-2014 Greg Horn
 *
 *    CasADi is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 3 of the License, or (at your option) any later version.
 *
 *    CasADi is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with CasADi; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */


      #include "bonmin_interface.hpp"
      #include <string>

      const std::string casadi::BonminInterface::meta_doc=
      "\n"
"\n"
"\n"
"When in warmstart mode, output NLPSOL_LAM_X may be used as input\n"
"\n"
"NOTE: Even when max_iter == 0, it is not guaranteed that \n"
"input(NLPSOL_X0) == output(NLPSOL_X). Indeed if bounds on X or \n"
"constraints are unmet, they will differ.\n"
"\n"
"For a good tutorial on BONMIN, see https://drops.dagstuhl.de/storage/16dagstuhl-seminar-proceedings/dsp-\n"
"vol09061/DagSemProc.09061.16/DagSemProc.09061.16.pdf \n"
"\n"
"A good resource about the algorithms in BONMIN is: Wachter and L. T. \n"
"Biegler, On the Implementation of an Interior-Point Filter Line-Search\n"
" Algorithm for Large-Scale Nonlinear Programming, Mathematical \n"
"Programming 106(1), pp. 25-57, 2006 (As Research Report RC 23149, IBM \n"
"T. J. Watson Research Center, Yorktown, USA\n"
"\n"
"Caveats:\n"
"with default options, multipliers for the decision variables are wrong\n"
" for equality constraints. Change the 'fixed_variable_treatment' to \n"
"'make_constraint' or 'relax_bounds' to obtain correct results.\n"
"\n"
"Extra doc: https://github.com/casadi/casadi/wiki/L_223 \n"
"\n"
"\n"
"\n"
">List of available options\n"
"\n"
"+-------------------------+-----------------------+------------------------+\n"
"|           Id            |         Type          |      Description       |\n"
"+=========================+=======================+========================+\n"
"| bonmin                  | OT_DICT               | Options to be passed   |\n"
"|                         |                       | to BONMIN              |\n"
"+-------------------------+-----------------------+------------------------+\n"
"| con_integer_md          | OT_DICT               | Integer metadata (a    |\n"
"|                         |                       | dictionary with lists  |\n"
"|                         |                       | of integers) about     |\n"
"|                         |                       | constraints to be      |\n"
"|                         |                       | passed to BONMIN       |\n"
"+-------------------------+-----------------------+------------------------+\n"
"| con_numeric_md          | OT_DICT               | Numeric metadata (a    |\n"
"|                         |                       | dictionary with lists  |\n"
"|                         |                       | of reals) about        |\n"
"|                         |                       | constraints to be      |\n"
"|                         |                       | passed to BONMIN       |\n"
"+-------------------------+-----------------------+------------------------+\n"
"| con_string_md           | OT_DICT               | String metadata (a     |\n"
"|                         |                       | dictionary with lists  |\n"
"|                         |                       | of strings) about      |\n"
"|                         |                       | constraints to be      |\n"
"|                         |                       | passed to BONMIN       |\n"
"+-------------------------+-----------------------+------------------------+\n"
"| grad_f                  | OT_FUNCTION           | Function for           |\n"
"|                         |                       | calculating the        |\n"
"|                         |                       | gradient of the        |\n"
"|                         |                       | objective (column,     |\n"
"|                         |                       | autogenerated by       |\n"
"|                         |                       | default)               |\n"
"+-------------------------+-----------------------+------------------------+\n"
"| grad_f_options          | OT_DICT               | Options for the        |\n"
"|                         |                       | autogenerated gradient |\n"
"|                         |                       | of the objective.      |\n"
"+-------------------------+-----------------------+------------------------+\n"
"| hess_lag                | OT_FUNCTION           | Function for           |\n"
"|                         |                       | calculating the        |\n"
"|                         |                       | Hessian of the         |\n"
"|                         |                       | Lagrangian             |\n"
"|                         |                       | (autogenerated by      |\n"
"|                         |                       | default)               |\n"
"+-------------------------+-----------------------+------------------------+\n"
"| hess_lag_options        | OT_DICT               | Options for the        |\n"
"|                         |                       | autogenerated Hessian  |\n"
"|                         |                       | of the Lagrangian.     |\n"
"+-------------------------+-----------------------+------------------------+\n"
"| jac_g                   | OT_FUNCTION           | Function for           |\n"
"|                         |                       | calculating the        |\n"
"|                         |                       | Jacobian of the        |\n"
"|                         |                       | constraints            |\n"
"|                         |                       | (autogenerated by      |\n"
"|                         |                       | default)               |\n"
"+-------------------------+-----------------------+------------------------+\n"
"| jac_g_options           | OT_DICT               | Options for the        |\n"
"|                         |                       | autogenerated Jacobian |\n"
"|                         |                       | of the constraints.    |\n"
"+-------------------------+-----------------------+------------------------+\n"
"| pass_nonlinear_constrai | OT_BOOL               | Pass list of           |\n"
"| nts                     |                       | constraints entering   |\n"
"|                         |                       | nonlinearly to BONMIN  |\n"
"+-------------------------+-----------------------+------------------------+\n"
"| pass_nonlinear_variable | OT_BOOL               | Pass list of variables |\n"
"| s                       |                       | entering nonlinearly   |\n"
"|                         |                       | to BONMIN              |\n"
"+-------------------------+-----------------------+------------------------+\n"
"| sos1_groups             | OT_INTVECTORVECTOR    | Options for the        |\n"
"|                         |                       | autogenerated gradient |\n"
"|                         |                       | of the objective.      |\n"
"+-------------------------+-----------------------+------------------------+\n"
"| sos1_priorities         | OT_INTVECTOR          | Options for the        |\n"
"|                         |                       | autogenerated gradient |\n"
"|                         |                       | of the objective.      |\n"
"+-------------------------+-----------------------+------------------------+\n"
"| sos1_weights            | OT_DOUBLEVECTORVECTOR | Options for the        |\n"
"|                         |                       | autogenerated gradient |\n"
"|                         |                       | of the objective.      |\n"
"+-------------------------+-----------------------+------------------------+\n"
"| var_integer_md          | OT_DICT               | Integer metadata (a    |\n"
"|                         |                       | dictionary with lists  |\n"
"|                         |                       | of integers) about     |\n"
"|                         |                       | variables to be passed |\n"
"|                         |                       | to BONMIN              |\n"
"+-------------------------+-----------------------+------------------------+\n"
"| var_numeric_md          | OT_DICT               | Numeric metadata (a    |\n"
"|                         |                       | dictionary with lists  |\n"
"|                         |                       | of reals) about        |\n"
"|                         |                       | variables to be passed |\n"
"|                         |                       | to BONMIN              |\n"
"+-------------------------+-----------------------+------------------------+\n"
"| var_string_md           | OT_DICT               | String metadata (a     |\n"
"|                         |                       | dictionary with lists  |\n"
"|                         |                       | of strings) about      |\n"
"|                         |                       | variables to be passed |\n"
"|                         |                       | to BONMIN              |\n"
"+-------------------------+-----------------------+------------------------+\n"
"\n"
"\n"
"\n"
"\n"
;
