//===----------------------------------------------------------------------===//
// Copyright © 2025-2026 Apple Inc. and the container project authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//   https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//===----------------------------------------------------------------------===//

// DO NOT EDIT.
// swift-format-ignore-file
// swiftlint:disable all
//
// Generated by the Swift generator plugin for the protocol buffer compiler.
// Source: Builder.proto
//
// For information on using the generated types, please see the documentation:
//   https://github.com/apple/swift-protobuf/

import Foundation
import SwiftProtobuf

// If the compiler emits an error on this type, it is because this file
// was generated by a version of the `protoc` Swift plug-in that is
// incompatible with the version of SwiftProtobuf to which you are linking.
// Please ensure that you are building against the same version of the API
// that was used to generate this file.
fileprivate struct _GeneratedWithProtocGenSwiftVersion: SwiftProtobuf.ProtobufAPIVersionCheck {
  struct _2: SwiftProtobuf.ProtobufAPIVersion_2 {}
  typealias Version = _2
}

public enum Com_Apple_Container_Build_V1_TransferDirection: SwiftProtobuf.Enum, Swift.CaseIterable {
  public typealias RawValue = Int
  case into // = 0
  case outof // = 1
  case UNRECOGNIZED(Int)

  public init() {
    self = .into
  }

  public init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .into
    case 1: self = .outof
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  public var rawValue: Int {
    switch self {
    case .into: return 0
    case .outof: return 1
    case .UNRECOGNIZED(let i): return i
    }
  }

  // The compiler won't synthesize support with the UNRECOGNIZED case.
  public static let allCases: [Com_Apple_Container_Build_V1_TransferDirection] = [
    .into,
    .outof,
  ]

}

/// Standard input/output.
public enum Com_Apple_Container_Build_V1_Stdio: SwiftProtobuf.Enum, Swift.CaseIterable {
  public typealias RawValue = Int
  case stdin // = 0
  case stdout // = 1
  case stderr // = 2
  case UNRECOGNIZED(Int)

  public init() {
    self = .stdin
  }

  public init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .stdin
    case 1: self = .stdout
    case 2: self = .stderr
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  public var rawValue: Int {
    switch self {
    case .stdin: return 0
    case .stdout: return 1
    case .stderr: return 2
    case .UNRECOGNIZED(let i): return i
    }
  }

  // The compiler won't synthesize support with the UNRECOGNIZED case.
  public static let allCases: [Com_Apple_Container_Build_V1_Stdio] = [
    .stdin,
    .stdout,
    .stderr,
  ]

}

/// Build error type.
public enum Com_Apple_Container_Build_V1_BuildErrorType: SwiftProtobuf.Enum, Swift.CaseIterable {
  public typealias RawValue = Int
  case buildFailed // = 0
  case `internal` // = 1
  case UNRECOGNIZED(Int)

  public init() {
    self = .buildFailed
  }

  public init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .buildFailed
    case 1: self = .internal
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  public var rawValue: Int {
    switch self {
    case .buildFailed: return 0
    case .internal: return 1
    case .UNRECOGNIZED(let i): return i
    }
  }

  // The compiler won't synthesize support with the UNRECOGNIZED case.
  public static let allCases: [Com_Apple_Container_Build_V1_BuildErrorType] = [
    .buildFailed,
    .internal,
  ]

}

public struct Com_Apple_Container_Build_V1_InfoRequest: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  public var unknownFields = SwiftProtobuf.UnknownStorage()

  public init() {}
}

public struct Com_Apple_Container_Build_V1_InfoResponse: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  public var unknownFields = SwiftProtobuf.UnknownStorage()

  public init() {}
}

public struct Com_Apple_Container_Build_V1_CreateBuildRequest: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// The name of the build stage.
  public var stageName: String = String()

  /// The tag of the image to be created.
  public var tag: String = String()

  /// Any additional metadata to be associated with the build.
  public var metadata: Dictionary<String,String> = [:]

  /// Additional build arguments.
  public var buildArgs: [String] = []

  /// Enable debug logging.
  public var debug: Bool = false

  public var unknownFields = SwiftProtobuf.UnknownStorage()

  public init() {}
}

public struct Com_Apple_Container_Build_V1_CreateBuildResponse: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// A unique ID for the build.
  public var buildID: String = String()

  /// Any additional metadata to be associated with the build.
  public var metadata: Dictionary<String,String> = [:]

  public var unknownFields = SwiftProtobuf.UnknownStorage()

  public init() {}
}

public struct Com_Apple_Container_Build_V1_ClientStream: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// A unique ID for the build.
  public var buildID: String {
    get {return _storage._buildID}
    set {_uniqueStorage()._buildID = newValue}
  }

  /// The packet type.
  public var packetType: OneOf_PacketType? {
    get {return _storage._packetType}
    set {_uniqueStorage()._packetType = newValue}
  }

  public var signal: Com_Apple_Container_Build_V1_Signal {
    get {
      if case .signal(let v)? = _storage._packetType {return v}
      return Com_Apple_Container_Build_V1_Signal()
    }
    set {_uniqueStorage()._packetType = .signal(newValue)}
  }

  public var command: Com_Apple_Container_Build_V1_Run {
    get {
      if case .command(let v)? = _storage._packetType {return v}
      return Com_Apple_Container_Build_V1_Run()
    }
    set {_uniqueStorage()._packetType = .command(newValue)}
  }

  public var buildTransfer: Com_Apple_Container_Build_V1_BuildTransfer {
    get {
      if case .buildTransfer(let v)? = _storage._packetType {return v}
      return Com_Apple_Container_Build_V1_BuildTransfer()
    }
    set {_uniqueStorage()._packetType = .buildTransfer(newValue)}
  }

  public var imageTransfer: Com_Apple_Container_Build_V1_ImageTransfer {
    get {
      if case .imageTransfer(let v)? = _storage._packetType {return v}
      return Com_Apple_Container_Build_V1_ImageTransfer()
    }
    set {_uniqueStorage()._packetType = .imageTransfer(newValue)}
  }

  public var unknownFields = SwiftProtobuf.UnknownStorage()

  /// The packet type.
  public enum OneOf_PacketType: Equatable, Sendable {
    case signal(Com_Apple_Container_Build_V1_Signal)
    case command(Com_Apple_Container_Build_V1_Run)
    case buildTransfer(Com_Apple_Container_Build_V1_BuildTransfer)
    case imageTransfer(Com_Apple_Container_Build_V1_ImageTransfer)

  }

  public init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

public struct Com_Apple_Container_Build_V1_Signal: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// A POSIX signal to send to the build process.
  /// Can be used for cancelling builds.
  public var signal: Int32 = 0

  public var unknownFields = SwiftProtobuf.UnknownStorage()

  public init() {}
}

public struct Com_Apple_Container_Build_V1_Run: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// A unique ID for the execution.
  public var id: String = String()

  /// The type of command to execute.
  public var command: String = String()

  public var unknownFields = SwiftProtobuf.UnknownStorage()

  public init() {}
}

public struct Com_Apple_Container_Build_V1_RunComplete: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// A unique ID for the execution.
  public var id: String = String()

  public var unknownFields = SwiftProtobuf.UnknownStorage()

  public init() {}
}

public struct Com_Apple_Container_Build_V1_BuildTransfer: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// A unique ID for the transfer.
  public var id: String = String()

  /// The direction for transferring data (either to the server or from the
  /// server).
  public var direction: Com_Apple_Container_Build_V1_TransferDirection = .into

  /// The absolute path to the source from the server perspective.
  public var source: String {
    get {return _source ?? String()}
    set {_source = newValue}
  }
  /// Returns true if `source` has been explicitly set.
  public var hasSource: Bool {return self._source != nil}
  /// Clears the value of `source`. Subsequent reads from it will return its default value.
  public mutating func clearSource() {self._source = nil}

  /// The absolute path for the destination from the server perspective.
  public var destination: String {
    get {return _destination ?? String()}
    set {_destination = newValue}
  }
  /// Returns true if `destination` has been explicitly set.
  public var hasDestination: Bool {return self._destination != nil}
  /// Clears the value of `destination`. Subsequent reads from it will return its default value.
  public mutating func clearDestination() {self._destination = nil}

  /// The actual data bytes to be transferred.
  public var data: Data = Data()

  /// Signal to indicate that the transfer of data for the request has finished.
  public var complete: Bool = false

  /// Boolean to indicate if the content is a directory.
  public var isDirectory: Bool = false

  /// Metadata for the transfer.
  public var metadata: Dictionary<String,String> = [:]

  public var unknownFields = SwiftProtobuf.UnknownStorage()

  public init() {}

  fileprivate var _source: String? = nil
  fileprivate var _destination: String? = nil
}

public struct Com_Apple_Container_Build_V1_ImageTransfer: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// A unique ID for the transfer.
  public var id: String = String()

  /// The direction for transferring data (either to the server or from the
  /// server).
  public var direction: Com_Apple_Container_Build_V1_TransferDirection = .into

  /// The tag for the image.
  public var tag: String = String()

  /// The descriptor for the image content.
  public var descriptor: Com_Apple_Container_Build_V1_Descriptor {
    get {return _descriptor ?? Com_Apple_Container_Build_V1_Descriptor()}
    set {_descriptor = newValue}
  }
  /// Returns true if `descriptor` has been explicitly set.
  public var hasDescriptor: Bool {return self._descriptor != nil}
  /// Clears the value of `descriptor`. Subsequent reads from it will return its default value.
  public mutating func clearDescriptor() {self._descriptor = nil}

  /// The actual data bytes to be transferred.
  public var data: Data = Data()

  /// Signal to indicate that the transfer of data for the request has finished.
  public var complete: Bool = false

  /// Metadata for the image.
  public var metadata: Dictionary<String,String> = [:]

  public var unknownFields = SwiftProtobuf.UnknownStorage()

  public init() {}

  fileprivate var _descriptor: Com_Apple_Container_Build_V1_Descriptor? = nil
}

public struct Com_Apple_Container_Build_V1_ServerStream: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// A unique ID for the build.
  public var buildID: String {
    get {return _storage._buildID}
    set {_uniqueStorage()._buildID = newValue}
  }

  /// The packet type.
  public var packetType: OneOf_PacketType? {
    get {return _storage._packetType}
    set {_uniqueStorage()._packetType = newValue}
  }

  public var io: Com_Apple_Container_Build_V1_IO {
    get {
      if case .io(let v)? = _storage._packetType {return v}
      return Com_Apple_Container_Build_V1_IO()
    }
    set {_uniqueStorage()._packetType = .io(newValue)}
  }

  public var buildError: Com_Apple_Container_Build_V1_BuildError {
    get {
      if case .buildError(let v)? = _storage._packetType {return v}
      return Com_Apple_Container_Build_V1_BuildError()
    }
    set {_uniqueStorage()._packetType = .buildError(newValue)}
  }

  public var commandComplete: Com_Apple_Container_Build_V1_RunComplete {
    get {
      if case .commandComplete(let v)? = _storage._packetType {return v}
      return Com_Apple_Container_Build_V1_RunComplete()
    }
    set {_uniqueStorage()._packetType = .commandComplete(newValue)}
  }

  public var buildTransfer: Com_Apple_Container_Build_V1_BuildTransfer {
    get {
      if case .buildTransfer(let v)? = _storage._packetType {return v}
      return Com_Apple_Container_Build_V1_BuildTransfer()
    }
    set {_uniqueStorage()._packetType = .buildTransfer(newValue)}
  }

  public var imageTransfer: Com_Apple_Container_Build_V1_ImageTransfer {
    get {
      if case .imageTransfer(let v)? = _storage._packetType {return v}
      return Com_Apple_Container_Build_V1_ImageTransfer()
    }
    set {_uniqueStorage()._packetType = .imageTransfer(newValue)}
  }

  public var unknownFields = SwiftProtobuf.UnknownStorage()

  /// The packet type.
  public enum OneOf_PacketType: Equatable, Sendable {
    case io(Com_Apple_Container_Build_V1_IO)
    case buildError(Com_Apple_Container_Build_V1_BuildError)
    case commandComplete(Com_Apple_Container_Build_V1_RunComplete)
    case buildTransfer(Com_Apple_Container_Build_V1_BuildTransfer)
    case imageTransfer(Com_Apple_Container_Build_V1_ImageTransfer)

  }

  public init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

public struct Com_Apple_Container_Build_V1_IO: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// The type of IO.
  public var type: Com_Apple_Container_Build_V1_Stdio = .stdin

  /// The IO data bytes.
  public var data: Data = Data()

  public var unknownFields = SwiftProtobuf.UnknownStorage()

  public init() {}
}

public struct Com_Apple_Container_Build_V1_BuildError: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// The type of build error.
  public var type: Com_Apple_Container_Build_V1_BuildErrorType = .buildFailed

  /// Additional message for the build failure.
  public var message: String = String()

  public var unknownFields = SwiftProtobuf.UnknownStorage()

  public init() {}
}

/// OCI Platform metadata.
public struct Com_Apple_Container_Build_V1_Platform: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  public var architecture: String = String()

  public var os: String = String()

  public var osVersion: String = String()

  public var osFeatures: [String] = []

  public var variant: String = String()

  public var unknownFields = SwiftProtobuf.UnknownStorage()

  public init() {}
}

/// OCI Descriptor metadata.
public struct Com_Apple_Container_Build_V1_Descriptor: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  public var mediaType: String = String()

  public var digest: String = String()

  public var size: Int64 = 0

  public var urls: [String] = []

  public var annotations: Dictionary<String,String> = [:]

  public var platform: Com_Apple_Container_Build_V1_Platform {
    get {return _platform ?? Com_Apple_Container_Build_V1_Platform()}
    set {_platform = newValue}
  }
  /// Returns true if `platform` has been explicitly set.
  public var hasPlatform: Bool {return self._platform != nil}
  /// Clears the value of `platform`. Subsequent reads from it will return its default value.
  public mutating func clearPlatform() {self._platform = nil}

  public var unknownFields = SwiftProtobuf.UnknownStorage()

  public init() {}

  fileprivate var _platform: Com_Apple_Container_Build_V1_Platform? = nil
}

// MARK: - Code below here is support for the SwiftProtobuf runtime.

fileprivate let _protobuf_package = "com.apple.container.build.v1"

extension Com_Apple_Container_Build_V1_TransferDirection: SwiftProtobuf._ProtoNameProviding {
  public static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "INTO"),
    1: .same(proto: "OUTOF"),
  ]
}

extension Com_Apple_Container_Build_V1_Stdio: SwiftProtobuf._ProtoNameProviding {
  public static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "STDIN"),
    1: .same(proto: "STDOUT"),
    2: .same(proto: "STDERR"),
  ]
}

extension Com_Apple_Container_Build_V1_BuildErrorType: SwiftProtobuf._ProtoNameProviding {
  public static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "BUILD_FAILED"),
    1: .same(proto: "INTERNAL"),
  ]
}

extension Com_Apple_Container_Build_V1_InfoRequest: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  public static let protoMessageName: String = _protobuf_package + ".InfoRequest"
  public static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  public mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    // Load everything into unknown fields
    while try decoder.nextFieldNumber() != nil {}
  }

  public func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  public static func ==(lhs: Com_Apple_Container_Build_V1_InfoRequest, rhs: Com_Apple_Container_Build_V1_InfoRequest) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Container_Build_V1_InfoResponse: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  public static let protoMessageName: String = _protobuf_package + ".InfoResponse"
  public static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  public mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    // Load everything into unknown fields
    while try decoder.nextFieldNumber() != nil {}
  }

  public func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  public static func ==(lhs: Com_Apple_Container_Build_V1_InfoResponse, rhs: Com_Apple_Container_Build_V1_InfoResponse) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Container_Build_V1_CreateBuildRequest: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  public static let protoMessageName: String = _protobuf_package + ".CreateBuildRequest"
  public static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "stage_name"),
    2: .same(proto: "tag"),
    3: .same(proto: "metadata"),
    4: .standard(proto: "build_args"),
    5: .same(proto: "debug"),
  ]

  public mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.stageName) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.tag) }()
      case 3: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: &self.metadata) }()
      case 4: try { try decoder.decodeRepeatedStringField(value: &self.buildArgs) }()
      case 5: try { try decoder.decodeSingularBoolField(value: &self.debug) }()
      default: break
      }
    }
  }

  public func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.stageName.isEmpty {
      try visitor.visitSingularStringField(value: self.stageName, fieldNumber: 1)
    }
    if !self.tag.isEmpty {
      try visitor.visitSingularStringField(value: self.tag, fieldNumber: 2)
    }
    if !self.metadata.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: self.metadata, fieldNumber: 3)
    }
    if !self.buildArgs.isEmpty {
      try visitor.visitRepeatedStringField(value: self.buildArgs, fieldNumber: 4)
    }
    if self.debug != false {
      try visitor.visitSingularBoolField(value: self.debug, fieldNumber: 5)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  public static func ==(lhs: Com_Apple_Container_Build_V1_CreateBuildRequest, rhs: Com_Apple_Container_Build_V1_CreateBuildRequest) -> Bool {
    if lhs.stageName != rhs.stageName {return false}
    if lhs.tag != rhs.tag {return false}
    if lhs.metadata != rhs.metadata {return false}
    if lhs.buildArgs != rhs.buildArgs {return false}
    if lhs.debug != rhs.debug {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Container_Build_V1_CreateBuildResponse: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  public static let protoMessageName: String = _protobuf_package + ".CreateBuildResponse"
  public static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "build_id"),
    2: .same(proto: "metadata"),
  ]

  public mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.buildID) }()
      case 2: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: &self.metadata) }()
      default: break
      }
    }
  }

  public func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.buildID.isEmpty {
      try visitor.visitSingularStringField(value: self.buildID, fieldNumber: 1)
    }
    if !self.metadata.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: self.metadata, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  public static func ==(lhs: Com_Apple_Container_Build_V1_CreateBuildResponse, rhs: Com_Apple_Container_Build_V1_CreateBuildResponse) -> Bool {
    if lhs.buildID != rhs.buildID {return false}
    if lhs.metadata != rhs.metadata {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Container_Build_V1_ClientStream: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  public static let protoMessageName: String = _protobuf_package + ".ClientStream"
  public static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "build_id"),
    2: .same(proto: "signal"),
    3: .same(proto: "command"),
    4: .standard(proto: "build_transfer"),
    5: .standard(proto: "image_transfer"),
  ]

  fileprivate class _StorageClass {
    var _buildID: String = String()
    var _packetType: Com_Apple_Container_Build_V1_ClientStream.OneOf_PacketType?

      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _buildID = source._buildID
      _packetType = source._packetType
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  public mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularStringField(value: &_storage._buildID) }()
        case 2: try {
          var v: Com_Apple_Container_Build_V1_Signal?
          var hadOneofValue = false
          if let current = _storage._packetType {
            hadOneofValue = true
            if case .signal(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._packetType = .signal(v)
          }
        }()
        case 3: try {
          var v: Com_Apple_Container_Build_V1_Run?
          var hadOneofValue = false
          if let current = _storage._packetType {
            hadOneofValue = true
            if case .command(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._packetType = .command(v)
          }
        }()
        case 4: try {
          var v: Com_Apple_Container_Build_V1_BuildTransfer?
          var hadOneofValue = false
          if let current = _storage._packetType {
            hadOneofValue = true
            if case .buildTransfer(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._packetType = .buildTransfer(v)
          }
        }()
        case 5: try {
          var v: Com_Apple_Container_Build_V1_ImageTransfer?
          var hadOneofValue = false
          if let current = _storage._packetType {
            hadOneofValue = true
            if case .imageTransfer(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._packetType = .imageTransfer(v)
          }
        }()
        default: break
        }
      }
    }
  }

  public func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      if !_storage._buildID.isEmpty {
        try visitor.visitSingularStringField(value: _storage._buildID, fieldNumber: 1)
      }
      switch _storage._packetType {
      case .signal?: try {
        guard case .signal(let v)? = _storage._packetType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
      }()
      case .command?: try {
        guard case .command(let v)? = _storage._packetType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
      }()
      case .buildTransfer?: try {
        guard case .buildTransfer(let v)? = _storage._packetType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
      }()
      case .imageTransfer?: try {
        guard case .imageTransfer(let v)? = _storage._packetType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
      }()
      case nil: break
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  public static func ==(lhs: Com_Apple_Container_Build_V1_ClientStream, rhs: Com_Apple_Container_Build_V1_ClientStream) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._buildID != rhs_storage._buildID {return false}
        if _storage._packetType != rhs_storage._packetType {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Container_Build_V1_Signal: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  public static let protoMessageName: String = _protobuf_package + ".Signal"
  public static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "signal"),
  ]

  public mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt32Field(value: &self.signal) }()
      default: break
      }
    }
  }

  public func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.signal != 0 {
      try visitor.visitSingularInt32Field(value: self.signal, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  public static func ==(lhs: Com_Apple_Container_Build_V1_Signal, rhs: Com_Apple_Container_Build_V1_Signal) -> Bool {
    if lhs.signal != rhs.signal {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Container_Build_V1_Run: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  public static let protoMessageName: String = _protobuf_package + ".Run"
  public static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "id"),
    2: .same(proto: "command"),
  ]

  public mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.id) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.command) }()
      default: break
      }
    }
  }

  public func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.id.isEmpty {
      try visitor.visitSingularStringField(value: self.id, fieldNumber: 1)
    }
    if !self.command.isEmpty {
      try visitor.visitSingularStringField(value: self.command, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  public static func ==(lhs: Com_Apple_Container_Build_V1_Run, rhs: Com_Apple_Container_Build_V1_Run) -> Bool {
    if lhs.id != rhs.id {return false}
    if lhs.command != rhs.command {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Container_Build_V1_RunComplete: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  public static let protoMessageName: String = _protobuf_package + ".RunComplete"
  public static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "id"),
  ]

  public mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.id) }()
      default: break
      }
    }
  }

  public func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.id.isEmpty {
      try visitor.visitSingularStringField(value: self.id, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  public static func ==(lhs: Com_Apple_Container_Build_V1_RunComplete, rhs: Com_Apple_Container_Build_V1_RunComplete) -> Bool {
    if lhs.id != rhs.id {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Container_Build_V1_BuildTransfer: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  public static let protoMessageName: String = _protobuf_package + ".BuildTransfer"
  public static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "id"),
    2: .same(proto: "direction"),
    3: .same(proto: "source"),
    4: .same(proto: "destination"),
    5: .same(proto: "data"),
    6: .same(proto: "complete"),
    7: .standard(proto: "is_directory"),
    8: .same(proto: "metadata"),
  ]

  public mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.id) }()
      case 2: try { try decoder.decodeSingularEnumField(value: &self.direction) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self._source) }()
      case 4: try { try decoder.decodeSingularStringField(value: &self._destination) }()
      case 5: try { try decoder.decodeSingularBytesField(value: &self.data) }()
      case 6: try { try decoder.decodeSingularBoolField(value: &self.complete) }()
      case 7: try { try decoder.decodeSingularBoolField(value: &self.isDirectory) }()
      case 8: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: &self.metadata) }()
      default: break
      }
    }
  }

  public func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.id.isEmpty {
      try visitor.visitSingularStringField(value: self.id, fieldNumber: 1)
    }
    if self.direction != .into {
      try visitor.visitSingularEnumField(value: self.direction, fieldNumber: 2)
    }
    try { if let v = self._source {
      try visitor.visitSingularStringField(value: v, fieldNumber: 3)
    } }()
    try { if let v = self._destination {
      try visitor.visitSingularStringField(value: v, fieldNumber: 4)
    } }()
    if !self.data.isEmpty {
      try visitor.visitSingularBytesField(value: self.data, fieldNumber: 5)
    }
    if self.complete != false {
      try visitor.visitSingularBoolField(value: self.complete, fieldNumber: 6)
    }
    if self.isDirectory != false {
      try visitor.visitSingularBoolField(value: self.isDirectory, fieldNumber: 7)
    }
    if !self.metadata.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: self.metadata, fieldNumber: 8)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  public static func ==(lhs: Com_Apple_Container_Build_V1_BuildTransfer, rhs: Com_Apple_Container_Build_V1_BuildTransfer) -> Bool {
    if lhs.id != rhs.id {return false}
    if lhs.direction != rhs.direction {return false}
    if lhs._source != rhs._source {return false}
    if lhs._destination != rhs._destination {return false}
    if lhs.data != rhs.data {return false}
    if lhs.complete != rhs.complete {return false}
    if lhs.isDirectory != rhs.isDirectory {return false}
    if lhs.metadata != rhs.metadata {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Container_Build_V1_ImageTransfer: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  public static let protoMessageName: String = _protobuf_package + ".ImageTransfer"
  public static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "id"),
    2: .same(proto: "direction"),
    3: .same(proto: "tag"),
    4: .same(proto: "descriptor"),
    5: .same(proto: "data"),
    6: .same(proto: "complete"),
    7: .same(proto: "metadata"),
  ]

  public mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.id) }()
      case 2: try { try decoder.decodeSingularEnumField(value: &self.direction) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self.tag) }()
      case 4: try { try decoder.decodeSingularMessageField(value: &self._descriptor) }()
      case 5: try { try decoder.decodeSingularBytesField(value: &self.data) }()
      case 6: try { try decoder.decodeSingularBoolField(value: &self.complete) }()
      case 7: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: &self.metadata) }()
      default: break
      }
    }
  }

  public func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.id.isEmpty {
      try visitor.visitSingularStringField(value: self.id, fieldNumber: 1)
    }
    if self.direction != .into {
      try visitor.visitSingularEnumField(value: self.direction, fieldNumber: 2)
    }
    if !self.tag.isEmpty {
      try visitor.visitSingularStringField(value: self.tag, fieldNumber: 3)
    }
    try { if let v = self._descriptor {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    } }()
    if !self.data.isEmpty {
      try visitor.visitSingularBytesField(value: self.data, fieldNumber: 5)
    }
    if self.complete != false {
      try visitor.visitSingularBoolField(value: self.complete, fieldNumber: 6)
    }
    if !self.metadata.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: self.metadata, fieldNumber: 7)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  public static func ==(lhs: Com_Apple_Container_Build_V1_ImageTransfer, rhs: Com_Apple_Container_Build_V1_ImageTransfer) -> Bool {
    if lhs.id != rhs.id {return false}
    if lhs.direction != rhs.direction {return false}
    if lhs.tag != rhs.tag {return false}
    if lhs._descriptor != rhs._descriptor {return false}
    if lhs.data != rhs.data {return false}
    if lhs.complete != rhs.complete {return false}
    if lhs.metadata != rhs.metadata {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Container_Build_V1_ServerStream: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  public static let protoMessageName: String = _protobuf_package + ".ServerStream"
  public static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "build_id"),
    2: .same(proto: "io"),
    3: .standard(proto: "build_error"),
    4: .standard(proto: "command_complete"),
    5: .standard(proto: "build_transfer"),
    6: .standard(proto: "image_transfer"),
  ]

  fileprivate class _StorageClass {
    var _buildID: String = String()
    var _packetType: Com_Apple_Container_Build_V1_ServerStream.OneOf_PacketType?

      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _buildID = source._buildID
      _packetType = source._packetType
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  public mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularStringField(value: &_storage._buildID) }()
        case 2: try {
          var v: Com_Apple_Container_Build_V1_IO?
          var hadOneofValue = false
          if let current = _storage._packetType {
            hadOneofValue = true
            if case .io(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._packetType = .io(v)
          }
        }()
        case 3: try {
          var v: Com_Apple_Container_Build_V1_BuildError?
          var hadOneofValue = false
          if let current = _storage._packetType {
            hadOneofValue = true
            if case .buildError(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._packetType = .buildError(v)
          }
        }()
        case 4: try {
          var v: Com_Apple_Container_Build_V1_RunComplete?
          var hadOneofValue = false
          if let current = _storage._packetType {
            hadOneofValue = true
            if case .commandComplete(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._packetType = .commandComplete(v)
          }
        }()
        case 5: try {
          var v: Com_Apple_Container_Build_V1_BuildTransfer?
          var hadOneofValue = false
          if let current = _storage._packetType {
            hadOneofValue = true
            if case .buildTransfer(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._packetType = .buildTransfer(v)
          }
        }()
        case 6: try {
          var v: Com_Apple_Container_Build_V1_ImageTransfer?
          var hadOneofValue = false
          if let current = _storage._packetType {
            hadOneofValue = true
            if case .imageTransfer(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._packetType = .imageTransfer(v)
          }
        }()
        default: break
        }
      }
    }
  }

  public func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      if !_storage._buildID.isEmpty {
        try visitor.visitSingularStringField(value: _storage._buildID, fieldNumber: 1)
      }
      switch _storage._packetType {
      case .io?: try {
        guard case .io(let v)? = _storage._packetType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
      }()
      case .buildError?: try {
        guard case .buildError(let v)? = _storage._packetType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
      }()
      case .commandComplete?: try {
        guard case .commandComplete(let v)? = _storage._packetType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
      }()
      case .buildTransfer?: try {
        guard case .buildTransfer(let v)? = _storage._packetType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
      }()
      case .imageTransfer?: try {
        guard case .imageTransfer(let v)? = _storage._packetType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 6)
      }()
      case nil: break
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  public static func ==(lhs: Com_Apple_Container_Build_V1_ServerStream, rhs: Com_Apple_Container_Build_V1_ServerStream) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._buildID != rhs_storage._buildID {return false}
        if _storage._packetType != rhs_storage._packetType {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Container_Build_V1_IO: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  public static let protoMessageName: String = _protobuf_package + ".IO"
  public static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "type"),
    2: .same(proto: "data"),
  ]

  public mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.type) }()
      case 2: try { try decoder.decodeSingularBytesField(value: &self.data) }()
      default: break
      }
    }
  }

  public func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.type != .stdin {
      try visitor.visitSingularEnumField(value: self.type, fieldNumber: 1)
    }
    if !self.data.isEmpty {
      try visitor.visitSingularBytesField(value: self.data, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  public static func ==(lhs: Com_Apple_Container_Build_V1_IO, rhs: Com_Apple_Container_Build_V1_IO) -> Bool {
    if lhs.type != rhs.type {return false}
    if lhs.data != rhs.data {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Container_Build_V1_BuildError: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  public static let protoMessageName: String = _protobuf_package + ".BuildError"
  public static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "type"),
    2: .same(proto: "message"),
  ]

  public mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.type) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.message) }()
      default: break
      }
    }
  }

  public func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.type != .buildFailed {
      try visitor.visitSingularEnumField(value: self.type, fieldNumber: 1)
    }
    if !self.message.isEmpty {
      try visitor.visitSingularStringField(value: self.message, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  public static func ==(lhs: Com_Apple_Container_Build_V1_BuildError, rhs: Com_Apple_Container_Build_V1_BuildError) -> Bool {
    if lhs.type != rhs.type {return false}
    if lhs.message != rhs.message {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Container_Build_V1_Platform: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  public static let protoMessageName: String = _protobuf_package + ".Platform"
  public static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "architecture"),
    2: .same(proto: "os"),
    3: .standard(proto: "os_version"),
    4: .standard(proto: "os_features"),
    5: .same(proto: "variant"),
  ]

  public mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.architecture) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.os) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self.osVersion) }()
      case 4: try { try decoder.decodeRepeatedStringField(value: &self.osFeatures) }()
      case 5: try { try decoder.decodeSingularStringField(value: &self.variant) }()
      default: break
      }
    }
  }

  public func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.architecture.isEmpty {
      try visitor.visitSingularStringField(value: self.architecture, fieldNumber: 1)
    }
    if !self.os.isEmpty {
      try visitor.visitSingularStringField(value: self.os, fieldNumber: 2)
    }
    if !self.osVersion.isEmpty {
      try visitor.visitSingularStringField(value: self.osVersion, fieldNumber: 3)
    }
    if !self.osFeatures.isEmpty {
      try visitor.visitRepeatedStringField(value: self.osFeatures, fieldNumber: 4)
    }
    if !self.variant.isEmpty {
      try visitor.visitSingularStringField(value: self.variant, fieldNumber: 5)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  public static func ==(lhs: Com_Apple_Container_Build_V1_Platform, rhs: Com_Apple_Container_Build_V1_Platform) -> Bool {
    if lhs.architecture != rhs.architecture {return false}
    if lhs.os != rhs.os {return false}
    if lhs.osVersion != rhs.osVersion {return false}
    if lhs.osFeatures != rhs.osFeatures {return false}
    if lhs.variant != rhs.variant {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Com_Apple_Container_Build_V1_Descriptor: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  public static let protoMessageName: String = _protobuf_package + ".Descriptor"
  public static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "media_type"),
    2: .same(proto: "digest"),
    3: .same(proto: "size"),
    4: .same(proto: "urls"),
    5: .same(proto: "annotations"),
    6: .same(proto: "platform"),
  ]

  public mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.mediaType) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.digest) }()
      case 3: try { try decoder.decodeSingularInt64Field(value: &self.size) }()
      case 4: try { try decoder.decodeRepeatedStringField(value: &self.urls) }()
      case 5: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: &self.annotations) }()
      case 6: try { try decoder.decodeSingularMessageField(value: &self._platform) }()
      default: break
      }
    }
  }

  public func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.mediaType.isEmpty {
      try visitor.visitSingularStringField(value: self.mediaType, fieldNumber: 1)
    }
    if !self.digest.isEmpty {
      try visitor.visitSingularStringField(value: self.digest, fieldNumber: 2)
    }
    if self.size != 0 {
      try visitor.visitSingularInt64Field(value: self.size, fieldNumber: 3)
    }
    if !self.urls.isEmpty {
      try visitor.visitRepeatedStringField(value: self.urls, fieldNumber: 4)
    }
    if !self.annotations.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: self.annotations, fieldNumber: 5)
    }
    try { if let v = self._platform {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 6)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  public static func ==(lhs: Com_Apple_Container_Build_V1_Descriptor, rhs: Com_Apple_Container_Build_V1_Descriptor) -> Bool {
    if lhs.mediaType != rhs.mediaType {return false}
    if lhs.digest != rhs.digest {return false}
    if lhs.size != rhs.size {return false}
    if lhs.urls != rhs.urls {return false}
    if lhs.annotations != rhs.annotations {return false}
    if lhs._platform != rhs._platform {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}
