; master library - DOS - COPY
;
; Description:
;	t@C̃Rs[
;
; Function/Procedures:
;	int dos_copy( int src_fd, int dest_fd, unsigned long copy_len ) ;
;
; Parameters:
;	src_fd    Rs[t@Cnh
;	dest_fd   Rs[t@Cnh
;	copy_len  Rs[oCg( 0ffffffffhȂEOF܂ )
;
; Returns:
;	NoError			
;
;	GeneralFailure		ǂݍݎs(copy_lenɖȂ)
;	GeneralFailure		ݎs(fBXNs?)
;
;	InsufficientMemory	ƃs
;	AccessDenied		ǂ炩̃t@Cnh̃ANZX
;	InvalidHandle		ǂ炩̃t@Cnh
;
; Binding Target:
;	Microsoft-C / Turbo-C / Turbo Pascal
;
; Running Target:
;	MS-DOS 2.1 or later
;
; Requiring Resources:
;	CPU: 8086
;
; Notes:
;	@copy_len = 0ffffffffh ̏ꍇ̂݁Ar srd_fd  EOF ɒBꍇ
;	ł NoError Ԃ܂B
;
; Assembly Language Note:
;	NoError̂Ƃ cy=0, ȊO cy=1ɂȂĂ܂B
;
; Compiler/Assembler:
;	TASM 3.0
;	OPTASM 1.6
;
; Author:
;	ˏF
;
; Revision History:
;	93/ 8/ 1 Initial: doscopy.asm/master.lib 0.20
;	93/ 8/26 [M0.21] BUGFIX ̉łĂȂ(^^;
;	93/ 9/14 [M0.21] obt@TCY32K珇 2K܂ŔĒ
;	93/11/17 [M0.21] (;_;)Pȃ~XBTCYw肵玸sĂ

	.MODEL SMALL
	include func.inc
	include super.inc

	.CODE
	EXTRN	SMEM_WGET:CALLMODEL
	EXTRN	SMEM_RELEASE:CALLMODEL
BUFSIZE equ 32768
MIN_BUFSIZE equ 2048

func DOS_COPY	; dos_copy() {
	push	BP
	mov	BP,SP
	push	SI
	push	DI

	; 
	src_fd	= (RETSIZE+4)*2
	dest_fd	= (RETSIZE+3)*2
	copy_len = (RETSIZE+1)*2

	mov	CX,BUFSIZE
ALLOCLOOP:
	push	CX
	_call	SMEM_WGET
	jnc	short GO

	shr	CX,1
	cmp	CX,MIN_BUFSIZE
	jnc	short ALLOCLOOP
	jmp	short MEM_ERROR
GO:

	push	DS
	mov	DS,AX

	mov	DI,[BP+copy_len+2]
	mov	SI,[BP+copy_len]
L:
	test	DI,DI
	jnz	short GO_MAX
	cmp	CX,SI
	jbe	short GO_MAX
	mov	CX,SI
GO_MAX:
	xor	DX,DX
	mov	BX,[BP+src_fd]
	mov	AH,3fh		; read handle
	int	21h
	sbb	DX,DX
	xor	AX,DX
	sub	AX,DX
	jc	short ERROR
	cmp	AX,CX
	jz	short CONT

	mov	CX,AX
	mov	AX,[BP+copy_len]
	and	AX,[BP+copy_len+2]
	inc	AX
	mov	AX,GeneralFailure
	stc
	jnz	short ERROR

	xor	DI,DI
	mov	SI,CX

CONT:
	xor	DX,DX
	mov	BX,[BP+dest_fd]
	mov	AH,40h		; write handle
	int	21h
	sbb	DX,DX
	xor	AX,DX
	sub	AX,DX
	jc	short ERROR

	cmp	AX,CX
	mov	AX,GeneralFailure
	stc
	jne	short ERROR

	sub	SI,CX
	sbb	DI,0
	jnz	short L
	cmp	SI,DI		; 0
	jne	short L

	mov	AX,SI		; 0 (= NoError)

ERROR:
	mov	BX,DS
	pop	DS
	push	BX
	_call	SMEM_RELEASE
MEM_ERROR:
	pop	DI
	pop	SI
	pop	BP
	ret	8
endfunc		; }

END
