//===----------------------------------------------------------------------===//
//                         DuckDB
//
// function/scalar/list_functions.hpp
//
//
//===----------------------------------------------------------------------===//
// This file is automatically generated by scripts/generate_functions.py
// Do not edit this file manually, your changes will be overwritten
//===----------------------------------------------------------------------===//

#pragma once

#include "duckdb/function/function_set.hpp"

namespace duckdb {

struct ListSelectFun {
	static constexpr const char *Name = "list_select";
	static constexpr const char *Parameters = "value_list,index_list";
	static constexpr const char *Description = "Returns a list based on the elements selected by the `index_list`.";
	static constexpr const char *Example = "list_select([10, 20, 30, 40], [1, 4])";
	static constexpr const char *Categories = "list";

	static ScalarFunction GetFunction();
};

struct ArraySelectFun {
	using ALIAS = ListSelectFun;

	static constexpr const char *Name = "array_select";
};

struct ListWhereFun {
	static constexpr const char *Name = "list_where";
	static constexpr const char *Parameters = "value_list,mask_list";
	static constexpr const char *Description = "Returns a list with the `BOOLEAN`s in `mask_list` applied as a mask to the `value_list`.";
	static constexpr const char *Example = "list_where([10, 20, 30, 40], [true, false, false, true])";
	static constexpr const char *Categories = "list";

	static ScalarFunction GetFunction();
};

struct ArrayWhereFun {
	using ALIAS = ListWhereFun;

	static constexpr const char *Name = "array_where";
};

struct ListContainsFun {
	static constexpr const char *Name = "list_contains";
	static constexpr const char *Parameters = "list,element";
	static constexpr const char *Description = "Returns true if the list contains the element.";
	static constexpr const char *Example = "list_contains([1, 2, NULL], 1)";
	static constexpr const char *Categories = "list";

	static ScalarFunction GetFunction();
};

struct ArrayContainsFun {
	using ALIAS = ListContainsFun;

	static constexpr const char *Name = "array_contains";
};

struct ListHasFun {
	using ALIAS = ListContainsFun;

	static constexpr const char *Name = "list_has";
};

struct ArrayHasFun {
	using ALIAS = ListContainsFun;

	static constexpr const char *Name = "array_has";
};

struct ListPositionFun {
	static constexpr const char *Name = "list_position";
	static constexpr const char *Parameters = "list,element";
	static constexpr const char *Description = "Returns the index of the `element` if the `list` contains the `element`. If the `element` is not found, it returns `NULL`.";
	static constexpr const char *Example = "list_position([1, 2, NULL], 2)";
	static constexpr const char *Categories = "list";

	static ScalarFunction GetFunction();
};

struct ListIndexofFun {
	using ALIAS = ListPositionFun;

	static constexpr const char *Name = "list_indexof";
};

struct ArrayPositionFun {
	using ALIAS = ListPositionFun;

	static constexpr const char *Name = "array_position";
};

struct ArrayIndexofFun {
	using ALIAS = ListPositionFun;

	static constexpr const char *Name = "array_indexof";
};

struct ListZipFun {
	static constexpr const char *Name = "list_zip";
	static constexpr const char *Parameters = "list_1,...,truncate";
	static constexpr const char *Description = "Zips n `LIST`s to a new `LIST` whose length will be that of the longest list. Its elements are structs of n elements from each list `list_1`, …, `list_n`, missing elements are replaced with `NULL`. If `truncate` is set, all lists are truncated to the smallest list length.";
	static constexpr const char *Example = "list_zip([1, 2], [3, 4], [5, 6])\002list_zip([1, 2], [3, 4], [5, 6, 7])\002list_zip([1, 2], [3, 4], [5, 6, 7], true)";
	static constexpr const char *Categories = "list";

	static ScalarFunction GetFunction();
};

struct ArrayZipFun {
	using ALIAS = ListZipFun;

	static constexpr const char *Name = "array_zip";
};

struct ListExtractFun {
	static constexpr const char *Name = "list_extract";
	static constexpr const char *Parameters = "list,index";
	static constexpr const char *Description = "Extract the `index`th (1-based) value from the list.";
	static constexpr const char *Example = "list_extract([4, 5, 6], 3)";
	static constexpr const char *Categories = "list";

	static ScalarFunctionSet GetFunctions();
};

struct ListElementFun {
	using ALIAS = ListExtractFun;

	static constexpr const char *Name = "list_element";
};

struct ListResizeFun {
	static constexpr const char *Name = "list_resize";
	static constexpr const char *Parameters = "list,size[,value]";
	static constexpr const char *Description = "Resizes the `list` to contain `size` elements. Initializes new elements with `value` or `NULL` if `value` is not set.";
	static constexpr const char *Example = "list_resize([1, 2, 3], 5, 0)";
	static constexpr const char *Categories = "list";

	static ScalarFunctionSet GetFunctions();
};

struct ArrayResizeFun {
	using ALIAS = ListResizeFun;

	static constexpr const char *Name = "array_resize";
};

struct ArrayExtractFun {
	static constexpr const char *Name = "array_extract";
	static constexpr const char *Parameters = "string::VARCHAR,index::ANY\001struct::STRUCT,entry::VARCHAR\001struct::STRUCT,index::ANY\001list::ANY[],index::ANY";
	static constexpr const char *Description = "Extracts a single character from a `string` using a (1-based) `index`.\001Extracts the named `entry` from the `STRUCT`.\001Extracts the entry from an unnamed `STRUCT` (tuple) using an index (1-based).\001Extracts the `index`th (1-based) value from the `list`.";
	static constexpr const char *Example = "array_extract('DuckDB', 2)\001array_extract({'i': 3, 'v2': 3, 'v3': 0}, 'i')\001array_extract(row(42, 84), 1)\001array_extract([4, 5, 6], 3)";
	static constexpr const char *Categories = "string\001struct\001struct\001list";

	static ScalarFunctionSet GetFunctions();
};

} // namespace duckdb
