/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.oceanbase;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.community.database.oceanbase.OceanBaseConnection;
import org.flywaydb.community.database.oceanbase.OceanBaseJdbcUtils;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.database.mysql.MySQLConnection;
import org.flywaydb.database.mysql.MySQLDatabase;

public class OceanBaseDatabase
extends MySQLDatabase {
    public OceanBaseDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    protected MySQLConnection doGetConnection(Connection connection) {
        return new OceanBaseConnection(this, connection);
    }

    protected boolean isCreateTableAsSelectAllowed() {
        return true;
    }

    public void ensureSupported(Configuration configuration) {
        this.ensureDatabaseIsRecentEnough("1.4");
        this.recommendFlywayUpgradeIfNecessary("5.0");
    }

    protected MigrationVersion determineVersion() {
        String versionNumber;
        try {
            versionNumber = OceanBaseJdbcUtils.getVersionNumber(this.rawMainJdbcConnection);
        }
        catch (SQLException e) {
            throw new FlywayException("Failed to get version number", (Throwable)e);
        }
        return MigrationVersion.fromVersion((String)versionNumber);
    }
}

