/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.dsi.dataengine.filters;

import com.databricks.client.dsi.core.impl.DSIDriver;
import com.databricks.client.dsi.core.interfaces.IEnvironment;
import com.databricks.client.dsi.dataengine.filters.IFilter;
import com.databricks.client.dsi.dataengine.filters.IdentifierFilter;
import com.databricks.client.dsi.dataengine.filters.IsNullOrEmptyFilter;
import com.databricks.client.dsi.dataengine.filters.SmallIntFilter;
import com.databricks.client.dsi.dataengine.filters.StringFilter;
import com.databricks.client.dsi.dataengine.filters.StringListFilter;
import com.databricks.client.dsi.dataengine.filters.StringPatternFilter;
import com.databricks.client.dsi.dataengine.interfaces.IMetadataFilterFactory;
import com.databricks.client.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.databricks.client.dsi.dataengine.utilities.MetadataSourceID;
import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.dsi.exceptions.NumericOverflowException;
import com.databricks.client.dsi.utilities.DSIMessageKey;
import com.databricks.client.support.exceptions.ErrorException;
import com.databricks.client.support.exceptions.ExceptionType;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DSIMetadataFilterFactory
implements IMetadataFilterFactory {
    private final boolean m_caseInsensitiveSearch;
    private boolean m_performFiltering;

    public DSIMetadataFilterFactory(boolean bl, boolean bl2) {
        this.m_performFiltering = bl;
        this.m_caseInsensitiveSearch = bl2;
    }

    public DSIMetadataFilterFactory(boolean bl) {
        this(bl, false);
    }

    @Override
    public void createFilters(MetadataSourceID metadataSourceID, List<String> list, String string, String string2, boolean bl, IEnvironment iEnvironment, List<IFilter> list2, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        int n = this.getAPIType(iEnvironment);
        int n2 = 1 == n ? 7 : 3;
        int n3 = this.getEnvIntAttr(iEnvironment, n2);
        this.doCreateFilters(metadataSourceID, list, string, string2, bl, n, n3, list2, map);
    }

    @Deprecated
    public void createFilters(MetadataSourceID metadataSourceID, List<String> list, String string, String string2, boolean bl, List<IFilter> list2, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        int n = 1;
        int n2 = 4;
        this.doCreateFilters(metadataSourceID, list, string, string2, bl, n, n2, list2, map);
    }

    private void doCreateFilters(MetadataSourceID metadataSourceID, List<String> list, String string, String string2, boolean bl, int n, int n2, List<IFilter> list2, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        new FilterCreator(list, string, string2, bl, n, n2, list2, map).CreateFilters(metadataSourceID);
    }

    private int getAPIType(IEnvironment iEnvironment) throws ErrorException {
        return this.getEnvIntAttr(iEnvironment, 4);
    }

    private int getEnvIntAttr(IEnvironment iEnvironment, int n) throws ErrorException {
        try {
            return iEnvironment.getProperty(n).getInt();
        }
        catch (NumericOverflowException numericOverflowException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name());
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name());
        }
    }

    private class FilterCreator {
        private final List<String> m_filterValues;
        private int m_filterValueIndex = 0;
        private final String m_escapeChar;
        private final String m_identifierQuoteChar;
        private final boolean m_filterAsIdentifier;
        private final int m_APIType;
        private final int m_APIVersion;
        private final Collection<IFilter> m_filters;
        private final Map<MetadataSourceColumnTag, String> m_restrictions;

        FilterCreator(List<String> list, String string, String string2, boolean bl, int n, int n2, Collection<IFilter> collection, Map<MetadataSourceColumnTag, String> map) {
            this.m_filterValues = list;
            this.m_escapeChar = string;
            this.m_identifierQuoteChar = string2;
            this.m_filterAsIdentifier = bl;
            this.m_APIType = n;
            this.m_APIVersion = n2;
            this.m_filters = collection;
            this.m_restrictions = map;
        }

        public void CreateFilters(MetadataSourceID metadataSourceID) throws ErrorException {
            switch (metadataSourceID) {
                case CATALOG_SCHEMA_ONLY: {
                    this.createCatalogSchemaOnlyFilters();
                    break;
                }
                case COLUMN_PRIVILEGES: {
                    this.createColumnPrivilegesFilters();
                    break;
                }
                case COLUMNS: 
                case PSEUDO_COLUMNS_JDBC41: {
                    this.createColumnsFilters();
                    break;
                }
                case FOREIGN_KEYS: {
                    this.createForeignKeysFilters();
                    break;
                }
                case PRIMARY_KEYS: {
                    this.createPrimaryKeysFilters();
                    break;
                }
                case PROCEDURE_COLUMNS: 
                case FUNCTION_COLUMNS_JDBC4: {
                    this.createProcedureColumnsFilters();
                    break;
                }
                case PROCEDURES: 
                case FUNCTIONS_JDBC4: {
                    this.createProceduresFilters();
                    break;
                }
                case SPECIAL_COLUMNS: {
                    this.createSpecialColumnsFilters();
                    break;
                }
                case STATISTICS: {
                    this.createStatisticsFilters();
                    break;
                }
                case TABLE_PRIVILEGES: {
                    this.createTablePrivilegesFilters();
                    break;
                }
                case CATALOG_ONLY: 
                case SCHEMA_ONLY: 
                case TABLETYPE_ONLY: {
                    break;
                }
                case TABLES: {
                    this.createTablesFilters();
                    break;
                }
                case TYPE_INFO: {
                    this.createTypeInfoFilters();
                    break;
                }
                default: {
                    throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_METADATA_ID.name(), metadataSourceID.toString(), ExceptionType.DEFAULT);
                }
            }
        }

        private void createCatalogSchemaOnlyFilters() {
            this.addCatalogAndSchemaFilters(false, true);
        }

        private void createColumnPrivilegesFilters() {
            this.addCatalogAndSchemaFilters(false, false);
            this.addStringFilter(MetadataSourceColumnTag.TABLE_NAME);
            this.addPatternFilter(MetadataSourceColumnTag.COLUMN_NAME);
        }

        private void createColumnsFilters() {
            this.addCatalogAndSchemaFilters(false, true);
            this.addPatternFilter(MetadataSourceColumnTag.TABLE_NAME);
            this.addPatternFilter(MetadataSourceColumnTag.COLUMN_NAME);
        }

        private void createForeignKeysFilters() {
            this.createPrimaryKeysFilters();
            this.addCatalogOrSchemaFilter(MetadataSourceColumnTag.FOREIGN_KEY_CATALOG_NAME, false);
            this.addCatalogOrSchemaFilter(MetadataSourceColumnTag.FOREIGN_KEY_SCHEMA_NAME, false);
            this.addStringFilter(MetadataSourceColumnTag.FOREIGN_KEY_TABLE_NAME);
        }

        private void createPrimaryKeysFilters() {
            this.addCatalogOrSchemaFilter(MetadataSourceColumnTag.PRIMARY_KEY_CATALOG_NAME, false);
            this.addCatalogOrSchemaFilter(MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME, false);
            this.addStringFilter(MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME);
        }

        private void createProcedureColumnsFilters() {
            this.createProceduresFilters();
            this.addPatternFilter(MetadataSourceColumnTag.COLUMN_NAME);
        }

        private void createProceduresFilters() {
            this.addCatalogAndSchemaFilters(false, true);
            this.addPatternFilter(MetadataSourceColumnTag.PROCEDURE_NAME);
        }

        private void createSpecialColumnsFilters() {
            this.addRestriction(MetadataSourceColumnTag.IDENTIFIER_TYPE_TAG, this.getNextFilterValue());
            this.addCatalogAndSchemaFilters(false, false);
            this.addStringFilter(MetadataSourceColumnTag.TABLE_NAME);
            this.addSmallIntFilter(MetadataSourceColumnTag.SCOPE);
            this.addRestriction(MetadataSourceColumnTag.NULLABLE_TAG, this.getNextFilterValue());
        }

        private void createStatisticsFilters() {
            this.addCatalogAndSchemaFilters(false, false);
            this.addStringFilter(MetadataSourceColumnTag.TABLE_NAME);
            this.addRestriction(MetadataSourceColumnTag.UNIQUE_TAG, this.getNextFilterValue());
            this.addRestriction(MetadataSourceColumnTag.RESERVED_TAG, this.getNextFilterValue());
        }

        private void createTablePrivilegesFilters() {
            this.addCatalogAndSchemaFilters(false, true);
            this.addPatternFilter(MetadataSourceColumnTag.TABLE_NAME);
        }

        private void createTablesFilters() {
            boolean bl = this.m_APIType == 0 && this.m_APIVersion != 2;
            this.addCatalogAndSchemaFilters(bl, true);
            this.addPatternFilter(MetadataSourceColumnTag.TABLE_NAME);
            this.addStringListFilter(MetadataSourceColumnTag.TABLE_TYPE, !DSIMetadataFilterFactory.this.m_performFiltering);
        }

        private void createTypeInfoFilters() {
            String string = this.peekNextFilterValue();
            if (null != string && !string.equals("0")) {
                this.addSmallIntFilter(MetadataSourceColumnTag.DATA_TYPE);
            } else {
                this.getNextFilterValue();
            }
        }

        private String getNextFilterValue() {
            return this.m_filterValues.get(this.m_filterValueIndex++);
        }

        private String peekNextFilterValue() {
            return this.m_filterValues.get(this.m_filterValueIndex);
        }

        private void addSmallIntFilter(MetadataSourceColumnTag metadataSourceColumnTag) {
            String string = this.getNextFilterValue();
            this.m_filters.add(new SmallIntFilter(metadataSourceColumnTag, string));
            this.addRestriction(metadataSourceColumnTag, string);
        }

        private void addIdentifierFilter(MetadataSourceColumnTag metadataSourceColumnTag) {
            String string = this.getNextFilterValue();
            this.m_filters.add(new IdentifierFilter(metadataSourceColumnTag, string, this.m_identifierQuoteChar));
            this.addRestriction(metadataSourceColumnTag, string);
        }

        private void addPatternFilter(MetadataSourceColumnTag metadataSourceColumnTag) {
            if (this.m_filterAsIdentifier) {
                this.addIdentifierFilter(metadataSourceColumnTag);
            } else {
                String string = this.getNextFilterValue();
                StringPatternFilter stringPatternFilter = new StringPatternFilter(metadataSourceColumnTag, string, this.m_escapeChar, DSIMetadataFilterFactory.this.m_caseInsensitiveSearch);
                this.m_filters.add(stringPatternFilter);
                if (!DSIMetadataFilterFactory.this.m_performFiltering || !stringPatternFilter.hasPatternFilter()) {
                    this.addRestriction(metadataSourceColumnTag, string);
                }
            }
        }

        private void addStringFilter(MetadataSourceColumnTag metadataSourceColumnTag) {
            if (this.m_filterAsIdentifier) {
                this.addIdentifierFilter(metadataSourceColumnTag);
            } else {
                String string = this.getNextFilterValue();
                this.m_filters.add(new StringFilter(metadataSourceColumnTag, string, DSIMetadataFilterFactory.this.m_caseInsensitiveSearch));
                this.addRestriction(metadataSourceColumnTag, string);
            }
        }

        private void addStringListFilter(MetadataSourceColumnTag metadataSourceColumnTag, boolean bl) {
            String string = this.getNextFilterValue();
            this.m_filters.add(new StringListFilter(metadataSourceColumnTag, string));
            if (bl) {
                this.addRestriction(metadataSourceColumnTag, string);
            }
        }

        private void addIsNullFilter(MetadataSourceColumnTag metadataSourceColumnTag) {
            String string = this.getNextFilterValue();
            assert (string.isEmpty());
            this.m_filters.add(new IsNullOrEmptyFilter(metadataSourceColumnTag));
            this.addRestriction(metadataSourceColumnTag, string);
        }

        private void addCatalogOrSchemaFilter(MetadataSourceColumnTag metadataSourceColumnTag, boolean bl) {
            String string = this.peekNextFilterValue();
            if (string != null && string.isEmpty()) {
                this.addIsNullFilter(metadataSourceColumnTag);
            } else if (bl) {
                this.addPatternFilter(metadataSourceColumnTag);
            } else {
                this.addStringFilter(metadataSourceColumnTag);
            }
        }

        private void addCatalogAndSchemaFilters(boolean bl, boolean bl2) {
            this.addCatalogOrSchemaFilter(MetadataSourceColumnTag.CATALOG_NAME, bl);
            this.addCatalogOrSchemaFilter(MetadataSourceColumnTag.SCHEMA_NAME, bl2);
        }

        void addRestriction(MetadataSourceColumnTag metadataSourceColumnTag, String string) {
            if (string != null) {
                this.m_restrictions.put(metadataSourceColumnTag, string);
            }
        }
    }
}

