/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.connection.PartitionedQueryResultSet;
import com.google.cloud.spanner.jdbc.AbstractJdbcResultSet;
import com.google.cloud.spanner.jdbc.JdbcArray;
import com.google.cloud.spanner.jdbc.JdbcBlob;
import com.google.cloud.spanner.jdbc.JdbcClob;
import com.google.cloud.spanner.jdbc.JdbcDataType;
import com.google.cloud.spanner.jdbc.JdbcPartitionedQueryResultSet;
import com.google.cloud.spanner.jdbc.JdbcResultSetMetaData;
import com.google.cloud.spanner.jdbc.JdbcSqlExceptionFactory;
import com.google.cloud.spanner.jdbc.JdbcTypeConverter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.rpc.Code;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;

class JdbcResultSet
extends AbstractJdbcResultSet {
    private boolean closed = false;
    private final Statement statement;
    private boolean wasNull = false;
    private boolean nextReturnedFalse = false;
    private boolean nextCalledForMetaData = false;
    private boolean nextCalledForMetaDataResult = false;
    private long currentRow = 0L;
    private final ImmutableSet<Integer> columnsAllowedUncheckedLongCastToShort;

    static JdbcResultSet of(ResultSet resultSet) {
        return JdbcResultSet.of(resultSet, (ImmutableSet<Integer>)ImmutableSet.of());
    }

    static JdbcResultSet of(ResultSet resultSet, ImmutableSet<Integer> columnsAllowedUncheckedLongCastToShort) {
        return new JdbcResultSet(null, (ResultSet)Preconditions.checkNotNull((Object)resultSet), (ImmutableSet<Integer>)((ImmutableSet)Preconditions.checkNotNull(columnsAllowedUncheckedLongCastToShort)));
    }

    static JdbcResultSet of(Statement statement, ResultSet resultSet) {
        if (resultSet instanceof PartitionedQueryResultSet) {
            return JdbcPartitionedQueryResultSet.of(statement, (PartitionedQueryResultSet)resultSet);
        }
        return new JdbcResultSet((Statement)Preconditions.checkNotNull((Object)statement), (ResultSet)Preconditions.checkNotNull((Object)resultSet));
    }

    static JdbcResultSet copyOf(@Nonnull ResultSet resultSet) {
        Preconditions.checkNotNull((Object)resultSet);
        ImmutableList rows = ImmutableList.copyOf((Iterator)new ResultSetIterator(resultSet));
        return JdbcResultSet.of(ResultSets.forRows((Type)resultSet.getType(), (Iterable)rows));
    }

    JdbcResultSet(Statement statement, ResultSet spanner) {
        this(statement, spanner, (ImmutableSet<Integer>)ImmutableSet.of());
    }

    JdbcResultSet(Statement statement, ResultSet spanner, ImmutableSet<Integer> columnsAllowedUncheckedLongCastToShort) {
        super(spanner);
        this.statement = statement;
        this.columnsAllowedUncheckedLongCastToShort = columnsAllowedUncheckedLongCastToShort;
    }

    void checkClosedAndValidRow() throws SQLException {
        this.checkClosed();
        if (this.currentRow == 0L) {
            throw JdbcSqlExceptionFactory.of("ResultSet is before first row. Call next() first.", Code.FAILED_PRECONDITION);
        }
        if (this.nextReturnedFalse) {
            throw JdbcSqlExceptionFactory.of("ResultSet is after last row. There is no more data available.", Code.FAILED_PRECONDITION);
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        ++this.currentRow;
        if (this.nextCalledForMetaData) {
            this.nextReturnedFalse = !this.nextCalledForMetaDataResult;
            this.nextCalledForMetaData = false;
        } else {
            this.nextReturnedFalse = !this.spanner.next();
        }
        return !this.nextReturnedFalse;
    }

    @Override
    public void close() {
        this.spanner.close();
        this.closed = true;
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosedAndValidRow();
        return this.wasNull;
    }

    private boolean isNull(int columnIndex) {
        this.wasNull = this.spanner.isNull(columnIndex - 1);
        return this.wasNull;
    }

    SQLException createInvalidToGetAs(String sqlType, Type.Code type) {
        return JdbcSqlExceptionFactory.of(String.format("Invalid column type to get as %s: %s", sqlType, type.name()), Code.INVALID_ARGUMENT);
    }

    SQLException createCastException(String sqlType, Object value) {
        return JdbcSqlExceptionFactory.of(String.format("Cannot cast to %s: %s", sqlType, value), Code.INVALID_ARGUMENT);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        boolean isNull = this.isNull(columnIndex);
        int spannerIndex = columnIndex - 1;
        Type.Code type = JdbcTypeConverter.getMainTypeCode(this.spanner.getColumnType(spannerIndex));
        switch (type) {
            case BOOL: {
                return isNull ? null : String.valueOf(this.spanner.getBoolean(spannerIndex));
            }
            case BYTES: 
            case PROTO: {
                return isNull ? null : this.spanner.getBytes(spannerIndex).toBase64();
            }
            case DATE: {
                return isNull ? null : this.spanner.getDate(spannerIndex).toString();
            }
            case FLOAT32: {
                return isNull ? null : Float.toString(this.spanner.getFloat(spannerIndex));
            }
            case FLOAT64: {
                return isNull ? null : Double.toString(this.spanner.getDouble(spannerIndex));
            }
            case INT64: 
            case ENUM: {
                return isNull ? null : Long.toString(this.spanner.getLong(spannerIndex));
            }
            case NUMERIC: {
                return isNull ? null : this.spanner.getBigDecimal(spannerIndex).toString();
            }
            case PG_NUMERIC: {
                return isNull ? null : this.spanner.getString(spannerIndex);
            }
            case STRING: {
                return isNull ? null : this.spanner.getString(spannerIndex);
            }
            case JSON: {
                return isNull ? null : this.spanner.getJson(spannerIndex);
            }
            case PG_JSONB: {
                return isNull ? null : this.spanner.getPgJsonb(spannerIndex);
            }
            case TIMESTAMP: {
                return isNull ? null : this.spanner.getTimestamp(spannerIndex).toString();
            }
        }
        throw this.createInvalidToGetAs("string", type);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        boolean isNull = this.isNull(columnIndex);
        int spannerIndex = columnIndex - 1;
        Type.Code type = JdbcTypeConverter.getMainTypeCode(this.spanner.getColumnType(spannerIndex));
        switch (type) {
            case BOOL: {
                return !isNull && this.spanner.getBoolean(spannerIndex);
            }
            case FLOAT32: {
                return !isNull && this.spanner.getFloat(spannerIndex) != 0.0f;
            }
            case FLOAT64: {
                return !isNull && this.spanner.getDouble(spannerIndex) != 0.0;
            }
            case INT64: 
            case ENUM: {
                return !isNull && this.spanner.getLong(spannerIndex) != 0L;
            }
            case NUMERIC: {
                return !isNull && !this.spanner.getBigDecimal(spannerIndex).equals(BigDecimal.ZERO);
            }
            case PG_NUMERIC: {
                return !isNull && !this.spanner.getString(spannerIndex).equals("0");
            }
            case STRING: {
                return !isNull && Boolean.parseBoolean(this.spanner.getString(spannerIndex));
            }
        }
        throw this.createInvalidToGetAs("boolean", type);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        boolean isNull = this.isNull(columnIndex);
        int spannerIndex = columnIndex - 1;
        Type.Code type = JdbcTypeConverter.getMainTypeCode(this.spanner.getColumnType(spannerIndex));
        switch (type) {
            case BOOL: {
                return isNull ? (byte)0 : (this.spanner.getBoolean(spannerIndex) ? (byte)1 : 0);
            }
            case FLOAT32: {
                return isNull ? (byte)0 : JdbcResultSet.checkedCastToByte(Float.valueOf(this.spanner.getFloat(spannerIndex)).longValue());
            }
            case FLOAT64: {
                return isNull ? (byte)0 : JdbcResultSet.checkedCastToByte(Double.valueOf(this.spanner.getDouble(spannerIndex)).longValue());
            }
            case INT64: 
            case ENUM: {
                return isNull ? (byte)0 : JdbcResultSet.checkedCastToByte(this.spanner.getLong(spannerIndex));
            }
            case NUMERIC: {
                return isNull ? (byte)0 : JdbcResultSet.checkedCastToByte(this.spanner.getBigDecimal(spannerIndex));
            }
            case PG_NUMERIC: {
                return isNull ? (byte)0 : JdbcResultSet.checkedCastToByte(JdbcResultSet.parseBigDecimal(this.spanner.getString(spannerIndex)).toBigInteger());
            }
            case STRING: {
                return isNull ? (byte)0 : JdbcResultSet.checkedCastToByte(JdbcResultSet.parseLong(this.spanner.getString(spannerIndex)));
            }
        }
        throw this.createInvalidToGetAs("byte", type);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        boolean isNull = this.isNull(columnIndex);
        int spannerIndex = columnIndex - 1;
        Type.Code type = JdbcTypeConverter.getMainTypeCode(this.spanner.getColumnType(spannerIndex));
        switch (type) {
            case BOOL: {
                return isNull ? (short)0 : (this.spanner.getBoolean(spannerIndex) ? (short)1 : 0);
            }
            case FLOAT32: {
                return isNull ? (short)0 : JdbcResultSet.checkedCastToShort(Float.valueOf(this.spanner.getFloat(spannerIndex)).longValue());
            }
            case FLOAT64: {
                return isNull ? (short)0 : JdbcResultSet.checkedCastToShort(Double.valueOf(this.spanner.getDouble(spannerIndex)).longValue());
            }
            case INT64: 
            case ENUM: {
                if (this.columnsAllowedUncheckedLongCastToShort.contains((Object)columnIndex)) {
                    return isNull ? (short)0 : (short)this.spanner.getLong(spannerIndex);
                }
                return isNull ? (short)0 : JdbcResultSet.checkedCastToShort(this.spanner.getLong(spannerIndex));
            }
            case NUMERIC: {
                return isNull ? (short)0 : JdbcResultSet.checkedCastToShort(this.spanner.getBigDecimal(spannerIndex));
            }
            case PG_NUMERIC: {
                return isNull ? (short)0 : JdbcResultSet.checkedCastToShort(JdbcResultSet.parseBigDecimal(this.spanner.getString(spannerIndex)).toBigInteger());
            }
            case STRING: {
                return isNull ? (short)0 : JdbcResultSet.checkedCastToShort(JdbcResultSet.parseLong(this.spanner.getString(spannerIndex)));
            }
        }
        throw this.createInvalidToGetAs("short", type);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        boolean isNull = this.isNull(columnIndex);
        int spannerIndex = columnIndex - 1;
        Type.Code type = JdbcTypeConverter.getMainTypeCode(this.spanner.getColumnType(spannerIndex));
        switch (type) {
            case BOOL: {
                return isNull ? 0 : (this.spanner.getBoolean(spannerIndex) ? 1 : 0);
            }
            case FLOAT32: {
                return isNull ? 0 : JdbcResultSet.checkedCastToInt(Float.valueOf(this.spanner.getFloat(spannerIndex)).longValue());
            }
            case FLOAT64: {
                return isNull ? 0 : JdbcResultSet.checkedCastToInt(Double.valueOf(this.spanner.getDouble(spannerIndex)).longValue());
            }
            case INT64: 
            case ENUM: {
                return isNull ? 0 : JdbcResultSet.checkedCastToInt(this.spanner.getLong(spannerIndex));
            }
            case NUMERIC: {
                return isNull ? 0 : JdbcResultSet.checkedCastToInt(this.spanner.getBigDecimal(spannerIndex));
            }
            case PG_NUMERIC: {
                return isNull ? 0 : JdbcResultSet.checkedCastToInt(JdbcResultSet.parseBigDecimal(this.spanner.getString(spannerIndex)).toBigInteger());
            }
            case STRING: {
                return isNull ? 0 : JdbcResultSet.checkedCastToInt(JdbcResultSet.parseLong(this.spanner.getString(spannerIndex)));
            }
        }
        throw this.createInvalidToGetAs("int", type);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        boolean isNull = this.isNull(columnIndex);
        int spannerIndex = columnIndex - 1;
        Type.Code type = JdbcTypeConverter.getMainTypeCode(this.spanner.getColumnType(spannerIndex));
        switch (type) {
            case BOOL: {
                return isNull ? 0L : (this.spanner.getBoolean(spannerIndex) ? 1L : 0L);
            }
            case FLOAT32: {
                return isNull ? 0L : Float.valueOf(this.spanner.getFloat(spannerIndex)).longValue();
            }
            case FLOAT64: {
                return isNull ? 0L : Double.valueOf(this.spanner.getDouble(spannerIndex)).longValue();
            }
            case INT64: 
            case ENUM: {
                return isNull ? 0L : this.spanner.getLong(spannerIndex);
            }
            case NUMERIC: {
                return isNull ? 0L : JdbcResultSet.checkedCastToLong(JdbcResultSet.parseBigDecimal(this.spanner.getString(spannerIndex)));
            }
            case PG_NUMERIC: {
                return isNull ? 0L : JdbcResultSet.checkedCastToLong(JdbcResultSet.parseBigDecimal(this.spanner.getString(spannerIndex)).toBigInteger());
            }
            case STRING: {
                return isNull ? 0L : JdbcResultSet.parseLong(this.spanner.getString(spannerIndex));
            }
        }
        throw this.createInvalidToGetAs("long", type);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        boolean isNull = this.isNull(columnIndex);
        int spannerIndex = columnIndex - 1;
        Type.Code type = JdbcTypeConverter.getMainTypeCode(this.spanner.getColumnType(spannerIndex));
        switch (type) {
            case BOOL: {
                return isNull ? 0.0f : (this.spanner.getBoolean(spannerIndex) ? 1.0f : 0.0f);
            }
            case FLOAT32: {
                return isNull ? 0.0f : this.spanner.getFloat(spannerIndex);
            }
            case FLOAT64: {
                return isNull ? 0.0f : JdbcResultSet.checkedCastToFloat(this.spanner.getDouble(spannerIndex));
            }
            case INT64: 
            case ENUM: {
                return isNull ? 0.0f : JdbcResultSet.checkedCastToFloat(this.spanner.getLong(spannerIndex));
            }
            case NUMERIC: {
                return isNull ? 0.0f : this.spanner.getBigDecimal(spannerIndex).floatValue();
            }
            case PG_NUMERIC: {
                return isNull ? 0.0f : JdbcResultSet.parseFloat(this.spanner.getString(spannerIndex));
            }
            case STRING: {
                return isNull ? 0.0f : JdbcResultSet.checkedCastToFloat(JdbcResultSet.parseDouble(this.spanner.getString(spannerIndex)));
            }
        }
        throw this.createInvalidToGetAs("float", type);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        boolean isNull = this.isNull(columnIndex);
        int spannerIndex = columnIndex - 1;
        Type.Code type = JdbcTypeConverter.getMainTypeCode(this.spanner.getColumnType(spannerIndex));
        switch (type) {
            case BOOL: {
                return isNull ? 0.0 : (this.spanner.getBoolean(spannerIndex) ? 1.0 : 0.0);
            }
            case FLOAT32: {
                return isNull ? 0.0 : (double)this.spanner.getFloat(spannerIndex);
            }
            case FLOAT64: {
                return isNull ? 0.0 : this.spanner.getDouble(spannerIndex);
            }
            case INT64: 
            case ENUM: {
                return isNull ? 0.0 : (double)this.spanner.getLong(spannerIndex);
            }
            case NUMERIC: {
                return isNull ? 0.0 : this.spanner.getBigDecimal(spannerIndex).doubleValue();
            }
            case PG_NUMERIC: {
                return isNull ? 0.0 : JdbcResultSet.parseDouble(this.spanner.getString(spannerIndex));
            }
            case STRING: {
                return isNull ? 0.0 : JdbcResultSet.parseDouble(this.spanner.getString(spannerIndex));
            }
        }
        throw this.createInvalidToGetAs("double", type);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        boolean isNull = this.isNull(columnIndex);
        int spannerIndex = columnIndex - 1;
        return isNull ? null : this.spanner.getBytes(spannerIndex).toByteArray();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        boolean isNull = this.isNull(columnIndex);
        int spannerIndex = columnIndex - 1;
        Type.Code type = JdbcTypeConverter.getMainTypeCode(this.spanner.getColumnType(spannerIndex));
        switch (type) {
            case DATE: {
                return isNull ? null : JdbcTypeConverter.toSqlDate(this.spanner.getDate(spannerIndex));
            }
            case STRING: {
                return isNull ? null : JdbcResultSet.parseDate(this.spanner.getString(spannerIndex));
            }
            case TIMESTAMP: {
                return isNull ? null : new Date(this.spanner.getTimestamp(spannerIndex).toSqlTimestamp().getTime());
            }
        }
        throw this.createInvalidToGetAs("date", type);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        boolean isNull = this.isNull(columnIndex);
        int spannerIndex = columnIndex - 1;
        Type.Code type = JdbcTypeConverter.getMainTypeCode(this.spanner.getColumnType(spannerIndex));
        switch (type) {
            case STRING: {
                return isNull ? null : JdbcResultSet.parseTime(this.spanner.getString(spannerIndex));
            }
            case TIMESTAMP: {
                return isNull ? null : JdbcTypeConverter.toSqlTime(this.spanner.getTimestamp(spannerIndex));
            }
        }
        throw this.createInvalidToGetAs("time", type);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        boolean isNull = this.isNull(columnIndex);
        int spannerIndex = columnIndex - 1;
        Type.Code type = JdbcTypeConverter.getMainTypeCode(this.spanner.getColumnType(spannerIndex));
        switch (type) {
            case DATE: {
                return isNull ? null : JdbcTypeConverter.toSqlTimestamp(this.spanner.getDate(spannerIndex));
            }
            case STRING: {
                return isNull ? null : JdbcResultSet.parseTimestamp(this.spanner.getString(spannerIndex));
            }
            case TIMESTAMP: {
                return isNull ? null : JdbcTypeConverter.toSqlTimestamp(this.spanner.getTimestamp(spannerIndex));
            }
        }
        throw this.createInvalidToGetAs("timestamp", type);
    }

    private InputStream getInputStream(String val, Charset charset) {
        if (val == null) {
            return null;
        }
        byte[] b = val.getBytes(charset);
        return new ByteArrayInputStream(b);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getInputStream(this.getString(columnIndex), StandardCharsets.US_ASCII);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getInputStream(this.getString(columnIndex), StandardCharsets.UTF_16LE);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        byte[] val = this.getBytes(columnIndex);
        return val == null ? null : new ByteArrayInputStream(val);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public JdbcResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.isBeforeFirst() && !this.nextCalledForMetaData) {
            this.nextCalledForMetaData = true;
            this.nextCalledForMetaDataResult = this.spanner.next();
        }
        return new JdbcResultSetMetaData(this, this.statement);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        Type type = this.spanner.getColumnType(columnIndex - 1);
        return this.isNull(columnIndex) ? null : this.getObject(type, columnIndex);
    }

    private Object getObject(Type type, int columnIndex) throws SQLException {
        if (type == Type.bool()) {
            return this.getBoolean(columnIndex);
        }
        if (type == Type.bytes()) {
            return this.getBytes(columnIndex);
        }
        if (type == Type.date()) {
            return this.getDate(columnIndex);
        }
        if (type == Type.float32()) {
            return Float.valueOf(this.getFloat(columnIndex));
        }
        if (type == Type.float64()) {
            return this.getDouble(columnIndex);
        }
        if (type == Type.int64() || type == Type.pgOid()) {
            return this.getLong(columnIndex);
        }
        if (type == Type.numeric()) {
            return this.getBigDecimal(columnIndex);
        }
        if (type == Type.pgNumeric()) {
            String value = this.getString(columnIndex);
            try {
                return JdbcResultSet.parseBigDecimal(value);
            }
            catch (Exception e) {
                return JdbcResultSet.parseDouble(value);
            }
        }
        if (type == Type.string()) {
            return this.getString(columnIndex);
        }
        if (type == Type.json() || type == Type.pgJsonb()) {
            return this.getString(columnIndex);
        }
        if (type == Type.timestamp()) {
            return this.getTimestamp(columnIndex);
        }
        if (type.getCode() == Type.Code.PROTO) {
            return this.getBytes(columnIndex);
        }
        if (type.getCode() == Type.Code.ENUM) {
            return this.getLong(columnIndex);
        }
        if (type.getCode() == Type.Code.ARRAY) {
            return this.getArray(columnIndex);
        }
        throw JdbcSqlExceptionFactory.of("Unknown type: " + type, Code.INVALID_ARGUMENT);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkClosed();
        try {
            return this.spanner.getColumnIndex(columnLabel) + 1;
        }
        catch (IllegalArgumentException e) {
            throw JdbcSqlExceptionFactory.of("no column with label " + columnLabel + " found", Code.INVALID_ARGUMENT);
        }
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        String val = this.getString(columnIndex);
        return val == null ? null : new StringReader(val);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getBigDecimal(columnIndex, false, 0);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getBigDecimal(this.findColumn(columnLabel), false, 0);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getBigDecimal(columnIndex, true, scale);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getBigDecimal(this.findColumn(columnLabel), true, scale);
    }

    private BigDecimal getBigDecimal(int columnIndex, boolean fixedScale, int scale) throws SQLException {
        BigDecimal res;
        int spannerIndex = columnIndex - 1;
        Type.Code type = JdbcTypeConverter.getMainTypeCode(this.spanner.getColumnType(spannerIndex));
        boolean isNull = this.isNull(columnIndex);
        switch (type) {
            case BOOL: {
                res = isNull ? null : (this.spanner.getBoolean(columnIndex - 1) ? BigDecimal.ONE : BigDecimal.ZERO);
                break;
            }
            case FLOAT32: {
                res = isNull ? null : BigDecimal.valueOf(this.spanner.getFloat(spannerIndex));
                break;
            }
            case FLOAT64: {
                res = isNull ? null : BigDecimal.valueOf(this.spanner.getDouble(spannerIndex));
                break;
            }
            case INT64: 
            case ENUM: {
                res = isNull ? null : BigDecimal.valueOf(this.spanner.getLong(spannerIndex));
                break;
            }
            case NUMERIC: {
                res = isNull ? null : this.spanner.getBigDecimal(spannerIndex);
                break;
            }
            case PG_NUMERIC: {
                res = isNull ? null : JdbcResultSet.parseBigDecimal(this.spanner.getString(spannerIndex));
                break;
            }
            case STRING: {
                try {
                    res = isNull ? null : new BigDecimal(this.spanner.getString(spannerIndex));
                    break;
                }
                catch (NumberFormatException e) {
                    throw JdbcSqlExceptionFactory.of("The column does not contain a valid BigDecimal", Code.INVALID_ARGUMENT, e);
                }
            }
            default: {
                throw this.createInvalidToGetAs("BigDecimal", type);
            }
        }
        if (res != null && fixedScale) {
            res = res.setScale(scale, RoundingMode.HALF_UP);
        }
        return res;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        return this.currentRow == 0L;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        return this.nextReturnedFalse;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClosed();
        return this.currentRow == 1L;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed();
        return JdbcResultSet.checkedCastToInt(this.currentRow);
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return this.statement;
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getArray(this.findColumn(columnLabel));
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        if (this.isNull(columnIndex)) {
            return null;
        }
        Type type = this.spanner.getColumnType(columnIndex - 1);
        if (type.getCode() != Type.Code.ARRAY) {
            throw JdbcSqlExceptionFactory.of("Column with index " + columnIndex + " does not contain an array", Code.INVALID_ARGUMENT);
        }
        Type.Code elementCode = JdbcTypeConverter.getMainTypeCode(type.getArrayElementType());
        JdbcDataType dataType = JdbcDataType.getType(elementCode);
        try {
            List<?> elements = dataType.getArrayElements(this.spanner, columnIndex - 1);
            return JdbcArray.createArray(dataType, elements);
        }
        catch (NumberFormatException e) {
            String sqlType = "ARRAY<" + type.getArrayElementType() + ">";
            Value value = this.spanner.getValue(columnIndex - 1);
            throw this.createCastException(sqlType, value);
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkClosedAndValidRow();
        if (this.isNull(columnIndex)) {
            return null;
        }
        int spannerIndex = columnIndex - 1;
        Type.Code type = JdbcTypeConverter.getMainTypeCode(this.spanner.getColumnType(spannerIndex));
        switch (type) {
            case DATE: {
                return JdbcTypeConverter.toSqlDate(this.spanner.getDate(spannerIndex), cal);
            }
            case STRING: {
                return JdbcResultSet.parseDate(this.spanner.getString(spannerIndex), cal);
            }
            case TIMESTAMP: {
                return new Date(JdbcTypeConverter.getAsSqlTimestamp(this.spanner.getTimestamp(spannerIndex), cal).getTime());
            }
        }
        throw this.createInvalidToGetAs("date", type);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkClosedAndValidRow();
        boolean isNull = this.isNull(columnIndex);
        int spannerIndex = columnIndex - 1;
        Type.Code type = JdbcTypeConverter.getMainTypeCode(this.spanner.getColumnType(spannerIndex));
        switch (type) {
            case STRING: {
                return isNull ? null : JdbcResultSet.parseTime(this.spanner.getString(spannerIndex), cal);
            }
            case TIMESTAMP: {
                return isNull ? null : JdbcTypeConverter.toSqlTime(this.spanner.getTimestamp(spannerIndex), cal);
            }
        }
        throw this.createInvalidToGetAs("time", type);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkClosedAndValidRow();
        if (this.isNull(columnIndex)) {
            return null;
        }
        int spannerIndex = columnIndex - 1;
        Type.Code type = JdbcTypeConverter.getMainTypeCode(this.spanner.getColumnType(spannerIndex));
        switch (type) {
            case DATE: {
                return JdbcTypeConverter.toSqlTimestamp(this.spanner.getDate(spannerIndex), cal);
            }
            case STRING: {
                return JdbcResultSet.parseTimestamp(this.spanner.getString(spannerIndex), cal);
            }
            case TIMESTAMP: {
                return JdbcTypeConverter.getAsSqlTimestamp(this.spanner.getTimestamp(spannerIndex), cal);
            }
        }
        throw this.createInvalidToGetAs("timestamp", type);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        try {
            return this.isNull(columnIndex) ? null : new URL(this.getString(columnIndex));
        }
        catch (MalformedURLException e) {
            throw JdbcSqlExceptionFactory.of("Invalid URL: " + this.spanner.getString(columnIndex - 1), Code.INVALID_ARGUMENT);
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return 2;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getString(columnLabel);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        return this.getCharacterStream(columnLabel);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this.checkClosedAndValidRow();
        return this.convertObject(this.getObject(columnIndex), type, this.spanner.getColumnType(columnIndex - 1));
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        this.checkClosedAndValidRow();
        return this.convertObject(this.getObject(columnLabel), type, this.spanner.getColumnType(columnLabel));
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        this.checkClosedAndValidRow();
        return this.convertObject(this.getObject(columnIndex), map, this.spanner.getColumnType(columnIndex - 1));
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        this.checkClosedAndValidRow();
        return this.convertObject(this.getObject(columnLabel), map, this.spanner.getColumnType(columnLabel));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        byte[] val = this.getBytes(columnIndex);
        return val == null ? null : new JdbcBlob(val);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        byte[] val = this.getBytes(columnLabel);
        return val == null ? null : new JdbcBlob(val);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        String val = this.getString(columnIndex);
        return val == null ? null : new JdbcClob(val);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        String val = this.getString(columnLabel);
        return val == null ? null : new JdbcClob(val);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        this.checkClosedAndValidRow();
        String val = this.getString(columnIndex);
        return val == null ? null : new JdbcClob(val);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        this.checkClosedAndValidRow();
        String val = this.getString(columnLabel);
        return val == null ? null : new JdbcClob(val);
    }

    private <T> T convertObject(Object o, Class<T> javaType, Type type) throws SQLException {
        return (T)JdbcTypeConverter.convert(o, type, javaType);
    }

    private Object convertObject(Object o, Map<String, Class<?>> map, Type type) throws SQLException {
        if (map == null) {
            throw JdbcSqlExceptionFactory.of("Map may not be null", Code.INVALID_ARGUMENT);
        }
        if (o == null) {
            return null;
        }
        Class<?> javaType = map.get(type.getCode().name());
        if (javaType == null) {
            return o;
        }
        return JdbcTypeConverter.convert(o, type, javaType);
    }

    private static class ResultSetIterator
    implements Iterator<Struct> {
        private final ResultSet resultSet;
        private boolean calculatedHasNext = false;
        private boolean hasNext = false;

        ResultSetIterator(ResultSet resultSet) {
            this.resultSet = resultSet;
        }

        @Override
        public boolean hasNext() {
            if (!this.calculatedHasNext) {
                this.calculatedHasNext = true;
                this.hasNext = this.resultSet.next();
            }
            return this.hasNext;
        }

        @Override
        public Struct next() {
            if (this.hasNext()) {
                this.calculatedHasNext = false;
                return this.resultSet.getCurrentRowAsStruct();
            }
            throw new NoSuchElementException();
        }
    }
}

