/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.InstanceConfigId;
import com.google.cloud.spanner.InstanceInfo;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.concurrent.ExecutionException;

class EmulatorUtil {
    EmulatorUtil() {
    }

    static void maybeCreateInstanceAndDatabase(Spanner spanner, DatabaseId databaseId, Dialect dialect) {
        SpannerException spannerException;
        Preconditions.checkArgument((boolean)NoCredentials.getInstance().equals((Object)((SpannerOptions)spanner.getOptions()).getCredentials()));
        try {
            spanner.getInstanceAdminClient().createInstance(InstanceInfo.newBuilder(databaseId.getInstanceId()).setDisplayName("Automatically Generated Test Instance").setNodeCount(1).setInstanceConfigId(InstanceConfigId.of(databaseId.getInstanceId().getProject(), "emulator-config")).build()).get();
        }
        catch (ExecutionException executionException) {
            spannerException = (SpannerException)((Object)executionException.getCause());
            if (spannerException.getErrorCode() != ErrorCode.ALREADY_EXISTS) {
                throw spannerException;
            }
        }
        catch (InterruptedException e) {
            throw SpannerExceptionFactory.propagateInterrupt(e);
        }
        try {
            spanner.getDatabaseAdminClient().createDatabase(databaseId.getInstanceId().getInstance(), dialect.createDatabaseStatementFor(databaseId.getDatabase()), dialect, (Iterable<String>)ImmutableList.of()).get();
        }
        catch (ExecutionException executionException) {
            spannerException = (SpannerException)((Object)executionException.getCause());
            if (spannerException.getErrorCode() != ErrorCode.ALREADY_EXISTS) {
                throw spannerException;
            }
        }
        catch (InterruptedException e) {
            throw SpannerExceptionFactory.propagateInterrupt(e);
        }
    }
}

