/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.metadata;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.ing.data.cassandra.jdbc.CassandraMetadataResultSet;
import com.ing.data.cassandra.jdbc.CassandraStatement;
import com.ing.data.cassandra.jdbc.ColumnDefinitions;
import com.ing.data.cassandra.jdbc.metadata.AbstractMetadataResultSetBuilder;
import com.ing.data.cassandra.jdbc.metadata.MetadataResultSet;
import com.ing.data.cassandra.jdbc.metadata.MetadataRow;
import com.ing.data.cassandra.jdbc.types.AbstractJdbcType;
import com.ing.data.cassandra.jdbc.types.DataTypeEnum;
import com.ing.data.cassandra.jdbc.types.TypesMap;
import com.ing.data.cassandra.jdbc.utils.DriverUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeMetadataResultSetBuilder
extends AbstractMetadataResultSetBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(TypeMetadataResultSetBuilder.class);

    public TypeMetadataResultSetBuilder(CassandraStatement statement) throws SQLException {
        super(statement);
    }

    public CassandraMetadataResultSet buildUDTs(String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        String catalog = this.connection.getCatalog();
        ArrayList<MetadataRow> udtsRows = new ArrayList<MetadataRow>();
        MetadataRow.MetadataRowTemplate rowTemplate = new MetadataRow.MetadataRowTemplate(ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TYPE_CAT", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TYPE_SCHEM", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TYPE_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("CLASS_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("DATA_TYPE", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("REMARKS", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("BASE_TYPE", DataTypes.SMALLINT));
        String schemaName = schemaPattern;
        AtomicReference<String> typeName = new AtomicReference<String>(Objects.toString(typeNamePattern, "%"));
        if (typeName.get().contains(".")) {
            String[] fullyQualifiedTypeNameParts = typeNamePattern.split("\\.");
            schemaName = fullyQualifiedTypeNameParts[0];
            typeName.set(fullyQualifiedTypeNameParts[1]);
        }
        this.filterBySchemaNamePattern(schemaName, keyspaceMetadata -> {
            Map udts = keyspaceMetadata.getUserDefinedTypes();
            for (Map.Entry udt : udts.entrySet()) {
                UserDefinedType udtMetadata = (UserDefinedType)udt.getValue();
                if (!this.matchesPattern((String)typeName.get(), udtMetadata.getName().asInternal()) || types != null && !Arrays.stream(types).anyMatch(type -> type == 2000)) continue;
                MetadataRow row = new MetadataRow().withTemplate(rowTemplate, catalog, keyspaceMetadata.getName().asInternal(), udtMetadata.getName().asInternal(), UdtValue.class.getName(), 2000, "", null);
                udtsRows.add(row);
            }
        }, null);
        udtsRows.sort(Comparator.comparing(row -> ((MetadataRow)row).getString("TYPE_SCHEM")).thenComparing(row -> ((MetadataRow)row).getString("TYPE_NAME")));
        return CassandraMetadataResultSet.buildFrom(this.statement, new MetadataResultSet(rowTemplate).setRows(udtsRows));
    }

    public CassandraMetadataResultSet buildTypes(String databaseVersion) throws SQLException {
        ArrayList<MetadataRow> types = new ArrayList<MetadataRow>();
        MetadataRow.MetadataRowTemplate rowTemplate = new MetadataRow.MetadataRowTemplate(ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TYPE_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("DATA_TYPE", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("PRECISION", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("LITERAL_PREFIX", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("LITERAL_SUFFIX", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("CREATE_PARAMS", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("NULLABLE", DataTypes.SMALLINT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("CASE_SENSITIVE", DataTypes.BOOLEAN), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("SEARCHABLE", DataTypes.SMALLINT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("UNSIGNED_ATTRIBUTE", DataTypes.BOOLEAN), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("FIXED_PREC_SCALE", DataTypes.BOOLEAN), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("AUTO_INCREMENT", DataTypes.BOOLEAN), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("LOCAL_TYPE_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("MINIMUM_SCALE", DataTypes.SMALLINT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("MAXIMUM_SCALE", DataTypes.SMALLINT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("SQL_DATA_TYPE", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("SQL_DATETIME_SUB", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("NUM_PREC_RADIX", DataTypes.INT));
        for (DataTypeEnum dataType : DataTypeEnum.values()) {
            if (!DriverUtil.existsInDatabaseVersion(databaseVersion, dataType)) continue;
            AbstractJdbcType<?> jdbcType = TypesMap.getTypeForComparator(dataType.asLowercaseCql());
            String literalQuotingSymbol = null;
            if (jdbcType.needsQuotes()) {
                literalQuotingSymbol = "'";
            }
            MetadataRow row2 = new MetadataRow().withTemplate(rowTemplate, dataType.cqlType, jdbcType.getJdbcType(), jdbcType.getPrecision(null), literalQuotingSymbol, literalQuotingSymbol, null, (short)1, jdbcType.isCaseSensitive(), (short)2, !jdbcType.isSigned(), !jdbcType.isCurrency(), false, null, (short)0, (short)jdbcType.getScale(null), null, null, jdbcType.getPrecision(null));
            types.add(row2);
        }
        types.sort(Comparator.comparing(row -> row.getInt("DATA_TYPE")));
        return CassandraMetadataResultSet.buildFrom(this.statement, new MetadataResultSet(rowTemplate).setRows(types));
    }

    public CassandraMetadataResultSet buildAttributes(String schemaPattern, String typeNamePattern, String attributesNamePattern) throws SQLException {
        String catalog = this.connection.getCatalog();
        ArrayList<MetadataRow> attributesRows = new ArrayList<MetadataRow>();
        MetadataRow.MetadataRowTemplate rowTemplate = new MetadataRow.MetadataRowTemplate(ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TYPE_CAT", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TYPE_SCHEM", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TYPE_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("ATTR_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("DATA_TYPE", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("ATTR_TYPE_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("ATTR_SIZE", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("DECIMAL_DIGITS", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("NUM_PREC_RADIX", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("NULLABLE", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("REMARKS", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("ATTR_DEF", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("SQL_DATA_TYPE", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("SQL_DATETIME_SUB", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("CHAR_OCTET_LENGTH", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("ORDINAL_POSITION", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("IS_NULLABLE", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("SCOPE_CATALOG", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("SCOPE_SCHEMA", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("SCOPE_TABLE", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("SOURCE_DATA_TYPE", DataTypes.SMALLINT));
        String schemaName = schemaPattern;
        AtomicReference<String> typeName = new AtomicReference<String>(typeNamePattern);
        if (typeNamePattern.contains(".")) {
            String[] fullyQualifiedTypeNameParts = typeNamePattern.split("\\.");
            schemaName = fullyQualifiedTypeNameParts[0];
            typeName.set(fullyQualifiedTypeNameParts[1]);
        }
        this.filterBySchemaNamePattern(schemaName, keyspaceMetadata -> {
            Map udts = keyspaceMetadata.getUserDefinedTypes();
            udts.entrySet().stream().filter(udt -> this.matchesPattern((String)typeName.get(), ((UserDefinedType)udt.getValue()).getName().asInternal())).forEach(udt -> {
                UserDefinedType udtMetadata = (UserDefinedType)udt.getValue();
                List attrNames = udtMetadata.getFieldNames();
                List attrTypes = udtMetadata.getFieldTypes();
                for (int i = 0; i < attrNames.size(); ++i) {
                    String attrName = ((CqlIdentifier)attrNames.get(i)).asInternal();
                    if (!this.matchesPattern(attributesNamePattern, attrName)) continue;
                    DataType attrType = (DataType)attrTypes.get(i);
                    AbstractJdbcType<?> jdbcEquivalentType = TypesMap.getTypeForComparator(attrType.toString());
                    int columnSize = -1;
                    if (jdbcEquivalentType != null) {
                        columnSize = jdbcEquivalentType.getPrecision(null);
                    }
                    int radix = 2;
                    if (jdbcEquivalentType != null && (jdbcEquivalentType.getJdbcType() == 3 || jdbcEquivalentType.getJdbcType() == 2)) {
                        radix = 10;
                    }
                    int jdbcType = 1111;
                    try {
                        jdbcType = TypesMap.getTypeForComparator(attrType.toString()).getJdbcType();
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to get JDBC type for comparator [{}]: {}", (Object)attrType, (Object)e.getMessage());
                    }
                    MetadataRow row = new MetadataRow().withTemplate(rowTemplate, catalog, keyspaceMetadata.getName().asInternal(), udtMetadata.getName().asInternal(), attrName, jdbcType, attrType.toString(), columnSize, null, radix, (short)0, null, null, null, null, Integer.MAX_VALUE, i + 1, "", null, null, null, null);
                    attributesRows.add(row);
                }
            });
        }, null);
        attributesRows.sort(Comparator.comparing(row -> ((MetadataRow)row).getString("TYPE_SCHEM")).thenComparing(row -> ((MetadataRow)row).getString("TYPE_NAME")).thenComparing(row -> ((MetadataRow)row).getInt("ORDINAL_POSITION")));
        return CassandraMetadataResultSet.buildFrom(this.statement, new MetadataResultSet(rowTemplate).setRows(attributesRows));
    }
}

