.\"
.\" Copyright (c) Mark J. Kilgard, 1996.
.\"
.\" See the file "man/LICENSE" for information on usage and redistribution
.\"
.TH glutDisplayFunc 3 "April 2025" "freeglut" "freeglut"
.SH NAME
glutDisplayFunc - sets the display callback for the current window.
.SH SYNTAX
.nf
.LP
void glutDisplayFunc(void (*func)(void));
.fi
.SH ARGUMENTS
.IP \fIfunc\fP 1i
The new display callback function.
.SH DESCRIPTION
glutDisplayFunc sets the display callback for the current window.
When GLUT determines that the normal plane for the window needs to be
redisplayed, the display callback for the window is called. Before the
callback, the current window is set to the window needing to be
redisplayed and (if no overlay display callback is registered) the layer in
use is set to the normal plane. The display callback is called with no
parameters. The entire normal plane region should be redisplayed in
response to the callback (this includes ancillary buffers if your program
depends on their state).

GLUT determines when the display callback should be triggered based on
the window's redisplay state. The redisplay state for a window can be
either set explicitly by calling glutPostRedisplay or implicitly as the
result of window damage reported by the window system. Multiple posted
redisplays for a window are coalesced by GLUT to minimize the number
of display callbacks called.

When an overlay is established for a window, but there is no overlay
display callback registered, the display callback is used for redisplaying
both the overlay and normal plane (that is, it will be called if either the
redisplay state or overlay redisplay state is set). In this case, the layer in
use is not implicitly changed on entry to the display callback.

See glutOverlayDisplayFunc to understand how distinct callbacks
for the overlay and normal plane of a window may be established.

When a window is created, no display callback exists for the window. It is
the responsibility of the programmer to install a display callback for the
window before the window is shown. A display callback must be
registered for any window that is shown. If a window becomes displayed
without a display callback being registered, a fatal error occurs. Passing
NULL to glutDisplayFunc is illegal as of GLUT 3.0; there is no way to
``deregister'' a display callback (though another callback routine can
always be registered).

Upon return from the display callback, the normal damaged state of the
window (returned by calling glutLayerGet(GLUT_NORMAL_DAMAGED)
is cleared. If there is no overlay display callback registered the overlay
damaged state of the window (returned by calling
glutLayerGet(GLUT_OVERLAY_DAMAGED) is also cleared.
.SH SEE ALSO
glutCreateMenu, glutPostRedisplay, glutOverlayDisplayFunc
.SH AUTHOR
Mark J. Kilgard (mjk@nvidia.com)
