import { jsx as _jsx } from "react/jsx-runtime";
/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { GeminiMessage } from './GeminiMessage.js';
import { StreamingState } from '../../types.js';
import { renderWithProviders } from '../../../test-utils/render.js';
describe('<GeminiMessage /> - Raw Markdown Display Snapshots', () => {
    const baseProps = {
        text: 'Test **bold** and `code` markdown\n\n```javascript\nconst x = 1;\n```',
        isPending: false,
        terminalWidth: 80,
    };
    it.each([
        { renderMarkdown: true, description: '(default)' },
        {
            renderMarkdown: false,
            description: '(raw markdown with syntax highlighting, no line numbers)',
        },
    ])('renders with renderMarkdown=$renderMarkdown $description', ({ renderMarkdown }) => {
        const { lastFrame } = renderWithProviders(_jsx(GeminiMessage, { ...baseProps }), {
            uiState: { renderMarkdown, streamingState: StreamingState.Idle },
        });
        expect(lastFrame()).toMatchSnapshot();
    });
    it.each([{ renderMarkdown: true }, { renderMarkdown: false }])('renders pending state with renderMarkdown=$renderMarkdown', ({ renderMarkdown }) => {
        const { lastFrame } = renderWithProviders(_jsx(GeminiMessage, { ...baseProps, isPending: true }), {
            uiState: { renderMarkdown, streamingState: StreamingState.Idle },
        });
        expect(lastFrame()).toMatchSnapshot();
    });
});
//# sourceMappingURL=GeminiMessage.test.js.map