/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { type AuthType, type Config } from '@google/gemini-cli-core';
/**
 * Handles the initial authentication flow.
 * @param config The application config.
 * @param authType The selected auth type.
 * @returns An error message if authentication fails, otherwise null.
 */
export declare function performInitialAuth(config: Config, authType: AuthType | undefined): Promise<string | null>;
