/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import org.catacombae.hfsexplorer.Pair;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.deprecated.HFSPlusFileSystemView;
import org.catacombae.hfsexplorer.fs.NullProgressMonitor;
import org.catacombae.hfsexplorer.io.ForkFilter;
import org.catacombae.hfsexplorer.partitioning.APMPartition;
import org.catacombae.hfsexplorer.types.hfsplus.BTHeaderRec;
import org.catacombae.hfsexplorer.types.hfsplus.BTNodeDescriptor;
import org.catacombae.hfsexplorer.types.hfsplus.HFSCatalogNodeID;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogFile;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogFolder;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogKey;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogLeafNode;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogLeafRecord;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogLeafRecordData;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogThread;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusExtentDescriptor;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusForkData;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusVolumeHeader;
import org.catacombae.hfsexplorer.win32.WindowsLowLevelIO;
import org.catacombae.io.ReadableFileStream;
import org.catacombae.io.ReadableRandomAccessStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HFSExplorer {
    public static final String VERSION = "0.21";
    public static final String COPYRIGHT = "Copyright \u00a9 Erik Larsson 2006-2008";
    public static final String[] NOTICES = new String[]{"This program is distributed under the GNU General Public License version 3.", "See <http://www.gnu.org/copyleft/gpl.html> for the details.", "", "Libraries used:", "    swing-layout <https://swing-layout.dev.java.net/>", "        Copyright \u00a9 2005-2006 Sun Microsystems, Inc. Licensed under", "        the Lesser General Public License.", "        See <http://www.gnu.org/licenses/lgpl.html> for the details.", "    iHarder Base64 encoder/decoder <http://iharder.sourceforge.net>", "        Public domain software.", "    Apache Ant bzip2 library <http://ant.apache.org/>", "        Copyright \u00a9 the Apache Software Foundation (ASF). Licensed", "        under the Apache License, Version 2.0.", "        See <http://www.apache.org/licenses/LICENSE-2.0> for the details."};
    public static BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
    private static Options options = new Options();
    private static Operation operation;
    private static BufferedReader stdIn;

    public static void main(String[] args) throws IOException {
        long length;
        long offset;
        if (args.length == 0) {
            HFSExplorer.printUsageInfo();
            System.exit(0);
        }
        HFSExplorer.parseOptions(args, 0, args.length);
        ReadableRandomAccessStream isoRaf = WindowsLowLevelIO.isSystemSupported() ? new WindowsLowLevelIO(operation.getFilename()) : new ReadableFileStream(operation.getFilename());
        if (HFSExplorer.options.readAPM) {
            HFSExplorer.println("Reading the Apple Partition Map...");
            isoRaf.seek(512L);
            byte[] currentBlock = new byte[512];
            byte[] signature = new byte[2];
            ArrayList<APMPartition> partitions = new ArrayList<APMPartition>();
            for (int i = 0; i < 20; ++i) {
                isoRaf.readFully(currentBlock);
                signature[0] = currentBlock[0];
                signature[1] = currentBlock[1];
                if (!new String(signature, "ASCII").equals("PM")) break;
                HFSExplorer.print("Partition " + i + ": ");
                APMPartition p = new APMPartition(currentBlock, 0, 512);
                partitions.add(p);
                if (HFSExplorer.options.verbose) {
                    HFSExplorer.println();
                    p.printPartitionInfo(System.out);
                    continue;
                }
                HFSExplorer.println("\"" + p.getPmPartNameAsString() + "\" (" + p.getPmParTypeAsString() + ")");
            }
            HFSExplorer.print("Which partition do you wish to explore [0-" + (partitions.size() - 1) + "]? ");
            int partNum = Integer.parseInt(stdin.readLine());
            APMPartition chosenPartition = (APMPartition)partitions.get(partNum);
            String partitionType = chosenPartition.getPmParTypeAsString();
            if (!partitionType.trim().equals("Apple_HFS")) {
                HFSExplorer.println("The partition is not an HFS partition!");
                System.exit(0);
            }
            HFSExplorer.println("Parsing partition " + partNum + " (" + chosenPartition.getPmPartNameAsString().trim() + "/" + partitionType.trim() + ")");
            offset = (chosenPartition.getPmPyPartStart() + chosenPartition.getPmLgDataStart()) * 512;
            length = chosenPartition.getPmDataCnt() * 512;
        } else {
            offset = 0L;
            length = isoRaf.length();
        }
        if (operation == Operation.BROWSE) {
            HFSExplorer.operationBrowse(operation, isoRaf, offset, length);
        } else if (operation == Operation.FRAGCHECK) {
            HFSExplorer.operationFragCheck(operation, isoRaf, offset, length);
        } else if (operation == Operation.TEST) {
            HFSExplorer.operationTest(operation, isoRaf, offset, length);
        } else if (operation == Operation.SYSTEMFILEINFO) {
            HFSExplorer.operationSystemFileInfo(operation, isoRaf, offset, length);
        }
    }

    private static void operationTest(Operation operation, ReadableRandomAccessStream isoRaf, long offset, long length) throws IOException {
        System.out.println("Reading partition data starting at " + offset + "...");
        byte[] currentBlock = new byte[512];
        isoRaf.seek(offset + 1024L);
        isoRaf.read(currentBlock);
        HFSPlusVolumeHeader header = new HFSPlusVolumeHeader(currentBlock);
        header.print(System.out, "  ");
        long catalogFilePosition = header.getBlockSize() * header.getCatalogFile().getExtents().getExtentDescriptor(0).getStartBlock();
        long catalogFileLength = header.getBlockSize() * header.getCatalogFile().getExtents().getExtentDescriptor(0).getBlockCount();
        System.out.println("Catalog file offset: " + catalogFilePosition);
        System.out.println("Catalog file length: " + catalogFileLength + " bytes");
        System.out.println("Seeking...");
        isoRaf.seek(offset + catalogFilePosition);
        System.out.println("Current file pointer: " + isoRaf.getFilePointer());
        System.out.println("length of file: " + isoRaf.length());
        byte[] nodeDescriptorData = new byte[14];
        if (isoRaf.read(nodeDescriptorData) != nodeDescriptorData.length) {
            System.out.println("ERROR: Did not read nodeDescriptor completely.");
        }
        BTNodeDescriptor btnd = new BTNodeDescriptor(nodeDescriptorData, 0);
        btnd.print(System.out, "");
        byte[] headerRec = new byte[BTHeaderRec.length()];
        if (isoRaf.read(headerRec) != headerRec.length) {
            System.out.println("ERROR: Did not read headerRec completely.");
        }
        BTHeaderRec bthr = new BTHeaderRec(headerRec, 0);
        bthr.print(System.out, "");
        if (catalogFileLength % (long)bthr.getNodeSize() != 0L) {
            System.out.println("catalogFileLength is not aligned to node size! (" + catalogFileLength + " % " + bthr.getNodeSize() + " = " + catalogFileLength % (long)bthr.getNodeSize());
            return;
        }
        System.out.println("Number of nodes in the catalog file: " + catalogFileLength / (long)bthr.getNodeSize());
        int nodeSize = bthr.getNodeSize();
        byte[] currentNode = new byte[nodeSize];
        System.out.println();
        System.out.println();
        ForkFilter catalogFile = new ForkFilter(header.getCatalogFile(), header.getCatalogFile().getExtents().getExtentDescriptors(), isoRaf, offset, (long)header.getBlockSize(), 0L);
        HFSPlusCatalogLeafRecord[] f = HFSPlusFileSystemView.collectFilesInDir(new HFSCatalogNodeID(1), bthr.getRootNode(), isoRaf, offset, header, bthr, catalogFile);
        System.out.println("Found " + f.length + " items in subroot.");
        for (HFSPlusCatalogLeafRecord rec : f) {
            System.out.print("  \"" + rec.getKey().getNodeName().toString() + "\"");
            HFSPlusCatalogLeafRecordData data = rec.getData();
            if (data.getRecordType() == 1 && data instanceof HFSPlusCatalogFolder) {
                HFSPlusCatalogFolder folderData = (HFSPlusCatalogFolder)data;
                System.out.println(" (dir, id: " + folderData.getFolderID().toInt() + ")");
                HFSPlusCatalogLeafRecord[] f2 = HFSPlusFileSystemView.collectFilesInDir(folderData.getFolderID(), bthr.getRootNode(), isoRaf, offset, header, bthr, catalogFile);
                System.out.println("  Found " + f2.length + " items in " + rec.getKey().getNodeName().toString() + ".");
                for (HFSPlusCatalogLeafRecord rec2 : f2) {
                    System.out.println("    \"" + rec2.getKey().getNodeName() + "\"");
                }
                continue;
            }
            if (data.getRecordType() == 2 && data instanceof HFSPlusCatalogFile) {
                HFSPlusCatalogFile fileData = (HFSPlusCatalogFile)data;
                System.out.println(" (file, id: " + fileData.getFileID().toInt() + ")");
                continue;
            }
            if (data.getRecordType() == 3 && data instanceof HFSPlusCatalogThread) {
                System.out.println(" (folder thread)");
                continue;
            }
            if (data.getRecordType() == 4 && data instanceof HFSPlusCatalogThread) {
                System.out.println(" (file thread)");
                continue;
            }
            System.out.println(" (ENCOUNTERED UNKNOWN DATA. record type: " + data.getRecordType() + " rec: " + rec + ")");
        }
        System.out.println();
        System.out.println();
        System.out.println("Reading node by node...");
        isoRaf.seek(offset + catalogFilePosition);
        int nodeNumber = 0;
        int bytesRead = nodeSize;
        while (isoRaf.getFilePointer() - catalogFilePosition + (long)nodeSize <= catalogFileLength) {
            int i;
            System.out.println("Reading node " + nodeNumber + "...");
            isoRaf.readFully(currentNode);
            bytesRead += nodeSize;
            BTNodeDescriptor nodeDescriptor = new BTNodeDescriptor(currentNode, 0);
            System.out.println("  Kind: " + nodeDescriptor.getKindAsString());
            System.out.println("  Number of records: " + nodeDescriptor.getNumRecords());
            short[] offsets = new short[nodeDescriptor.getNumRecords()];
            for (i = 0; i < offsets.length; ++i) {
                offsets[i] = Util.readShortBE(currentNode, currentNode.length - (i + 1) * 2);
            }
            for (i = 0; i < offsets.length; ++i) {
                int currentOffset = Util.unsign(offsets[i]);
                if (i >= offsets.length - 1 || nodeDescriptor.getKind() == 1) continue;
                HFSPlusCatalogKey currentKey = new HFSPlusCatalogKey(currentNode, currentOffset);
                if (nodeDescriptor.getKind() == -1) {
                    System.out.println("  [" + nodeNumber + "]  Key: " + currentKey.getKeyLength() + ", " + currentKey.getParentID().toString() + ", \"" + currentKey.getNodeName().toString() + "\"");
                    short recordType = Util.readShortBE(currentNode, currentOffset + currentKey.length());
                    System.out.print("  [" + nodeNumber + "]   Record type: ");
                    if (recordType == 1) {
                        System.out.print("kHFSPlusFolderRecord");
                    } else if (recordType == 2) {
                        System.out.print("kHFSPlusFileRecord");
                    } else if (recordType == 3) {
                        System.out.print("kHFSPlusFolderThreadRecord");
                    } else if (recordType == 4) {
                        System.out.print("kHFSPlusFileThreadRecord");
                    } else {
                        System.out.print("UNKNOWN! (" + recordType + ")");
                    }
                    System.out.println();
                    if (recordType == 1) {
                        HFSPlusCatalogFolder folderRec = new HFSPlusCatalogFolder(currentNode, currentOffset + currentKey.length());
                        System.out.println("  [" + nodeNumber + "]   Node ID: " + folderRec.getFolderID());
                        System.out.println("  [" + nodeNumber + "]   Valence: " + folderRec.getValence());
                        continue;
                    }
                    if (recordType == 2) {
                        HFSPlusCatalogFile fileRec = new HFSPlusCatalogFile(currentNode, currentOffset + currentKey.length());
                        System.out.println("  [" + nodeNumber + "]   Node ID: " + fileRec.getFileID());
                        continue;
                    }
                    if (recordType == 3) {
                        HFSPlusCatalogThread folderThreadRec = new HFSPlusCatalogThread(currentNode, currentOffset + currentKey.length());
                        continue;
                    }
                    if (recordType != 4) continue;
                    HFSPlusCatalogThread fileThreadRec = new HFSPlusCatalogThread(currentNode, currentOffset + currentKey.length());
                    continue;
                }
                if (nodeDescriptor.getKind() != 0) continue;
                System.out.println("  [" + nodeNumber + "]    \"" + currentKey.getNodeName().toString() + "\" (parent: " + currentKey.getParentID() + ") -> " + Util.unsign(Util.readIntBE(currentNode, currentOffset + currentKey.length())));
            }
            System.out.print("Press enter to read next node (q and enter to exit)...");
            if (stdIn.readLine().trim().equalsIgnoreCase("q")) {
                return;
            }
            ++nodeNumber;
        }
        System.out.println("FP: " + isoRaf.getFilePointer() + " diff: " + (isoRaf.getFilePointer() - catalogFilePosition) + " (catalogFileLength: " + catalogFileLength + ")");
        System.out.println("bytesRead: " + bytesRead + " nodeSize: " + nodeSize + " number of nodes: " + catalogFileLength / (long)nodeSize);
        System.out.println("Nodes read: " + nodeNumber);
    }

    public static void operationBrowse(Operation op, ReadableRandomAccessStream hfsFile, long fsOffset, long fsLength) {
        HFSPlusCatalogLeafRecord rootRecord;
        HFSPlusFileSystemView fsView = new HFSPlusFileSystemView(hfsFile, fsOffset);
        HFSPlusCatalogLeafRecord currentDir = rootRecord = fsView.getRoot();
        LinkedList<String> pathStack = new LinkedList<String>();
        LinkedList<HFSPlusCatalogLeafRecord> pathThread = new LinkedList<HFSPlusCatalogLeafRecord>();
        pathStack.addLast("");
        BufferedReader stdIn = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            HFSPlusCatalogLeafRecord[] recordsInDir;
            HFSPlusCatalogThread currentThread = null;
            StringBuilder currentPath = new StringBuilder();
            for (String pathComponent : pathStack) {
                currentPath.append(pathComponent);
                currentPath.append("/");
            }
            HFSExplorer.println("Listing files in \"" + currentPath.toString() + "\":");
            boolean atLeastOneNonThreadEntryFound = false;
            for (HFSPlusCatalogLeafRecord rec : recordsInDir = fsView.listRecords(currentDir)) {
                HFSPlusCatalogThread catThread;
                HFSPlusCatalogLeafRecordData recData = rec.getData();
                if (recData.getRecordType() == 2 && recData instanceof HFSPlusCatalogFile) {
                    HFSPlusCatalogFile catFile = (HFSPlusCatalogFile)recData;
                    HFSExplorer.println("  [" + catFile.getFileID() + "] \"" + rec.getKey().getNodeName() + "\" (" + catFile.getDataFork().getLogicalSize() + " B)");
                    if (atLeastOneNonThreadEntryFound) continue;
                    atLeastOneNonThreadEntryFound = true;
                    continue;
                }
                if (recData.getRecordType() == 1 && recData instanceof HFSPlusCatalogFolder) {
                    HFSPlusCatalogFolder catFolder = (HFSPlusCatalogFolder)recData;
                    HFSExplorer.println("  [" + catFolder.getFolderID() + "] \"" + rec.getKey().getNodeName() + "/\"");
                    if (atLeastOneNonThreadEntryFound) continue;
                    atLeastOneNonThreadEntryFound = true;
                    continue;
                }
                if (recData.getRecordType() == 3 && recData instanceof HFSPlusCatalogThread) {
                    catThread = (HFSPlusCatalogThread)recData;
                    HFSExplorer.println("  [Folder Thread: [" + catThread.getParentID() + "] \"" + catThread.getNodeName() + "\"]");
                    if (currentThread == null) {
                        currentThread = catThread;
                        continue;
                    }
                    HFSExplorer.println("WARNING: Found more than one folder thread in " + currentPath + "!");
                    continue;
                }
                if (recData.getRecordType() != 4 || !(recData instanceof HFSPlusCatalogThread)) continue;
                catThread = (HFSPlusCatalogThread)recData;
                HFSExplorer.println("  [File Thread: [" + catThread.getParentID() + "] \"" + catThread.getNodeName() + "\"]");
            }
            if (currentThread == null && atLeastOneNonThreadEntryFound) {
                HFSExplorer.println("WARNING: Found no folder thread in " + currentPath + "! Won't be able to go back from children in hierarchy.");
            }
            while (true) {
                HFSPlusCatalogLeafRecordData recData;
                HFSPlusCatalogLeafRecord selectedFileRecord;
                HFSExplorer.print("Command[?]: ");
                String input = null;
                try {
                    input = stdIn.readLine().trim();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    return;
                }
                if (input.equalsIgnoreCase("?")) {
                    HFSExplorer.println("Available commands:");
                    HFSExplorer.println(" ls                List contents of current directory");
                    HFSExplorer.println(" cd <dirName>      Changes directory by name");
                    HFSExplorer.println(" cdn <dirID>       Changes directory by ID");
                    HFSExplorer.println(" info <fileID>     Gets extensive information about the file.");
                    HFSExplorer.println(" extract <fileID>  Extracts <fileID> to current directory");
                    HFSExplorer.println(" q                 Quits program");
                    continue;
                }
                if (input.equals("q")) {
                    return;
                }
                if (input.equals("ls")) break;
                if (input.startsWith("extract ")) {
                    input = input.substring("extract ".length()).trim();
                    try {
                        long nextID = Long.parseLong(input);
                        selectedFileRecord = null;
                        HFSPlusCatalogFile selectedFile = null;
                        for (HFSPlusCatalogLeafRecord rec : recordsInDir) {
                            HFSPlusCatalogFile catFile;
                            HFSPlusCatalogLeafRecordData recData2 = rec.getData();
                            if (recData2.getRecordType() != 2 || !(recData2 instanceof HFSPlusCatalogFile) || Util.unsign((catFile = (HFSPlusCatalogFile)recData2).getFileID().toInt()) != nextID) continue;
                            selectedFileRecord = rec;
                            selectedFile = (HFSPlusCatalogFile)recData2;
                            break;
                        }
                        if (selectedFileRecord == null) {
                            HFSExplorer.println("ID not present in dir.");
                            continue;
                        }
                        String dataForkFilename = selectedFileRecord.getKey().getNodeName().toString();
                        FileOutputStream dataOut = new FileOutputStream(dataForkFilename);
                        HFSExplorer.print("Extracting data fork to file \"" + dataForkFilename + "\"...");
                        try {
                            long bytesExtracted = fsView.extractDataForkToStream(selectedFileRecord, dataOut, NullProgressMonitor.getInstance());
                            HFSExplorer.println("extracted " + bytesExtracted + " bytes.");
                            dataOut.close();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                            try {
                                dataOut.close();
                            }
                            catch (IOException ioe2) {}
                            continue;
                        }
                        String resourceForkFilename = dataForkFilename + ".resourcefork";
                        FileOutputStream resourceOut = new FileOutputStream(resourceForkFilename);
                        HFSExplorer.print("Extracting resource fork to file \"" + resourceForkFilename + "\"...");
                        try {
                            long bytesExtracted = fsView.extractResourceForkToStream(selectedFileRecord, resourceOut, NullProgressMonitor.getInstance());
                            HFSExplorer.println("extracted " + bytesExtracted + " bytes.");
                            resourceOut.close();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                            try {
                                dataOut.close();
                            }
                            catch (IOException ioe2) {
                            }
                        }
                    }
                    catch (FileNotFoundException fnfe) {
                        fnfe.printStackTrace();
                    }
                    catch (NumberFormatException nfe) {
                        HFSExplorer.println("Invalid input!");
                    }
                    continue;
                }
                if (input.startsWith("info ")) {
                    input = input.substring("info ".length()).trim();
                    try {
                        long nextID = Long.parseLong(input);
                        selectedFileRecord = null;
                        for (HFSPlusCatalogLeafRecord rec : recordsInDir) {
                            HFSPlusCatalogFile catFile;
                            recData = rec.getData();
                            if (recData.getRecordType() != 2 || !(recData instanceof HFSPlusCatalogFile) || Util.unsign((catFile = (HFSPlusCatalogFile)recData).getFileID().toInt()) != nextID) continue;
                            selectedFileRecord = rec;
                            rec.print(System.out, "");
                            break;
                        }
                        if (selectedFileRecord != null) continue;
                        HFSExplorer.println("ID not present in dir.");
                    }
                    catch (NumberFormatException nfe) {
                        HFSExplorer.println("Invalid input!");
                    }
                    continue;
                }
                if (input.startsWith("cdn ")) {
                    if ((input = input.substring("cdn ".length()).trim()).equals("..")) {
                        HFSExplorer.println("Not yet implemented.");
                        continue;
                    }
                    try {
                        long nextID = Long.parseLong(input);
                        HFSPlusCatalogLeafRecord nextDir = null;
                        for (HFSPlusCatalogLeafRecord rec : recordsInDir) {
                            HFSPlusCatalogFolder catFolder;
                            recData = rec.getData();
                            if (recData.getRecordType() != 1 || !(recData instanceof HFSPlusCatalogFolder) || Util.unsign((catFolder = (HFSPlusCatalogFolder)recData).getFolderID().toInt()) != nextID) continue;
                            nextDir = rec;
                            break;
                        }
                        if (nextDir == null) {
                            HFSExplorer.println("ID not present in dir.");
                            continue;
                        }
                        pathStack.addLast(nextDir.getKey().getNodeName().toString());
                        pathThread.addLast(currentDir);
                        currentDir = nextDir;
                        break;
                    }
                    catch (Exception e) {
                        HFSExplorer.println("Invalid input!");
                        continue;
                    }
                }
                if (input.startsWith("cd ")) {
                    if ((input = input.substring("cd ".length())).equals("..")) {
                        pathStack.removeLast();
                        currentDir = (HFSPlusCatalogLeafRecord)pathThread.removeLast();
                        break;
                    }
                    try {
                        HFSPlusCatalogLeafRecord nextDir = null;
                        HFSPlusCatalogFolder nextFolder = null;
                        for (HFSPlusCatalogLeafRecord rec : recordsInDir) {
                            HFSPlusCatalogLeafRecordData recData3 = rec.getData();
                            if (recData3.getRecordType() != 1 || !(recData3 instanceof HFSPlusCatalogFolder) || !rec.getKey().getNodeName().toString().equals(input)) continue;
                            nextDir = rec;
                            nextFolder = (HFSPlusCatalogFolder)recData3;
                            break;
                        }
                        if (nextDir == null) {
                            HFSExplorer.println("Unknown directory.");
                            continue;
                        }
                        pathStack.addLast(nextDir.getKey().getNodeName().toString());
                        pathThread.addLast(currentDir);
                        currentDir = nextDir;
                        break;
                    }
                    catch (Exception e) {
                        HFSExplorer.println("Invalid input!");
                        continue;
                    }
                }
                HFSExplorer.println("Unknown command.");
            }
            HFSExplorer.println();
        }
    }

    private static void operationFragCheck(Operation op, ReadableRandomAccessStream hfsFile, long fsOffset, long fsLength) {
        HFSPlusCatalogLeafRecord rootRecord;
        HFSExplorer.println("Gathering information about the files on the volume...");
        int numberOfFilesToDisplay = 10;
        ArrayList<Pair<HFSPlusCatalogLeafRecord, Integer>> mostFragmentedList = new ArrayList<Pair<HFSPlusCatalogLeafRecord, Integer>>(11);
        HFSPlusFileSystemView fsView = new HFSPlusFileSystemView(hfsFile, fsOffset);
        HFSPlusCatalogLeafRecord currentDir = rootRecord = fsView.getRoot();
        HFSExplorer.recursiveFragmentSearch(fsView, rootRecord, mostFragmentedList, 10, HFSExplorer.options.verbose);
        if (!HFSExplorer.options.verbose) {
            HFSExplorer.println();
        }
        HFSExplorer.println("Most fragmented files: ");
        for (Pair<HFSPlusCatalogLeafRecord, Integer> phi : mostFragmentedList) {
            HFSExplorer.println(phi.b + " - \"" + ((HFSPlusCatalogLeafRecord)phi.a).getKey().getNodeName() + "\"");
        }
    }

    private static void recursiveFragmentSearch(HFSPlusFileSystemView fsView, HFSPlusCatalogLeafRecord currentDir, ArrayList<Pair<HFSPlusCatalogLeafRecord, Integer>> mostFragmentedList, int listMaxLength, boolean verbose) {
        for (HFSPlusCatalogLeafRecord rec : fsView.listRecords(currentDir)) {
            HFSPlusCatalogThread catThread;
            HFSPlusCatalogLeafRecordData recData = rec.getData();
            if (recData.getRecordType() == 2 && recData instanceof HFSPlusCatalogFile) {
                HFSPlusCatalogFile catFile = (HFSPlusCatalogFile)recData;
                HFSPlusExtentDescriptor[] descs = fsView.getAllDataExtentDescriptors(rec);
                mostFragmentedList.add(new Pair<HFSPlusCatalogLeafRecord, Integer>(rec, descs.length));
                for (int i = mostFragmentedList.size() - 1; i > 0; --i) {
                    Pair<HFSPlusCatalogLeafRecord, Integer> lower = mostFragmentedList.get(i);
                    Pair<HFSPlusCatalogLeafRecord, Integer> higher = mostFragmentedList.get(i - 1);
                    if ((Integer)lower.b <= (Integer)higher.b) break;
                    mostFragmentedList.set(i - 1, lower);
                    mostFragmentedList.set(i, higher);
                }
                while (mostFragmentedList.size() > listMaxLength) {
                    mostFragmentedList.remove(mostFragmentedList.size() - 1);
                }
                continue;
            }
            if (recData.getRecordType() == 1 && recData instanceof HFSPlusCatalogFolder) {
                HFSPlusCatalogFolder catFolder = (HFSPlusCatalogFolder)recData;
                if (verbose) {
                    HFSExplorer.println("  Processing folder \"" + rec.getKey().getNodeName().toString() + "\"");
                } else {
                    HFSExplorer.print(".");
                }
                HFSExplorer.recursiveFragmentSearch(fsView, rec, mostFragmentedList, listMaxLength, verbose);
                continue;
            }
            if (recData.getRecordType() == 3 && recData instanceof HFSPlusCatalogThread) {
                catThread = (HFSPlusCatalogThread)recData;
                continue;
            }
            if (recData.getRecordType() != 4 || !(recData instanceof HFSPlusCatalogThread)) continue;
            catThread = (HFSPlusCatalogThread)recData;
        }
    }

    private static void operationSystemFileInfo(Operation op, ReadableRandomAccessStream hfsFile, long fsOffset, long fsLength) {
        HFSPlusForkData[] intrestingFiles;
        ReadableRandomAccessStream oldHfsFile = hfsFile;
        HFSPlusFileSystemView fsView = new HFSPlusFileSystemView(hfsFile, fsOffset);
        HFSPlusVolumeHeader header = fsView.getVolumeHeader();
        int blockSize = header.getBlockSize();
        HFSCatalogNodeID[] ids = new HFSCatalogNodeID[]{HFSCatalogNodeID.kHFSAllocationFileID, HFSCatalogNodeID.kHFSExtentsFileID, HFSCatalogNodeID.kHFSCatalogFileID, HFSCatalogNodeID.kHFSAttributesFileID, HFSCatalogNodeID.kHFSStartupFileID};
        for (HFSPlusForkData f : intrestingFiles = new HFSPlusForkData[]{header.getAllocationFile(), header.getExtentsFile(), header.getCatalogFile(), header.getAttributesFile(), header.getStartupFile()}) {
            f.print(System.out, "");
        }
        String[] labels = new String[]{"Allocation file", "Extents file", "Catalog file", "Attributes file", "Startup file"};
        for (int i = 0; i < intrestingFiles.length; ++i) {
            System.out.println(labels[i] + ":");
            HFSPlusForkData currentFile = intrestingFiles[i];
            long basicExtentsBlockCount = 0L;
            HFSPlusExtentDescriptor[] basicExtents = currentFile.getExtents().getExtentDescriptors();
            long numberOfExtents = 0L;
            for (HFSPlusExtentDescriptor cur : basicExtents) {
                if (cur.getStartBlock() == 0 && cur.getBlockCount() == 0) break;
                basicExtentsBlockCount += Util.unsign(cur.getBlockCount());
                ++numberOfExtents;
            }
            if (basicExtentsBlockCount == currentFile.getTotalBlocks()) {
                System.out.println("  Number of extents: " + numberOfExtents + " (all in basic)");
                continue;
            }
            HFSCatalogNodeID currentID = ids[i];
            if (currentID == HFSCatalogNodeID.kHFSExtentsFileID) {
                System.out.println("  OVERFLOW IN EXTENTS OVERFLOW FILE!!");
                continue;
            }
            long totalBlockCount = 0L;
            HFSPlusExtentDescriptor[] allDescriptors = fsView.getAllDataExtentDescriptors(currentID, currentFile);
            System.out.println("  Number of extents: " + allDescriptors.length + " (overflowed)");
        }
    }

    public static void printUsageInfo() {
        HFSExplorer.println("HFSExplorer v0.21 Build #1081");
        HFSExplorer.println(COPYRIGHT);
        HFSExplorer.println("  displays information about an HFS filesystem.");
        HFSExplorer.println("  usage: java HFSExplorer [common options] <verb> [verb options] <file/device>");
        HFSExplorer.println();
        HFSExplorer.println("  Common options:");
        HFSExplorer.println("    -apm  Specifies that the HFS partition is embedded within an Apple");
        HFSExplorer.println("          Partition Map. The user will be allowed to choose which partition in");
        HFSExplorer.println("          the map to attempt reading.");
        HFSExplorer.println("    -v    Verbose operation.");
        HFSExplorer.println();
        HFSExplorer.println("  Verbs:");
        HFSExplorer.println("    browse  Launches a mode where the user can browse the files in a HFS+ file");
        HFSExplorer.println("            system.");
        HFSExplorer.println("    chfrag  Lists the 10 most fragmented files of the volume.");
        HFSExplorer.println("    test    Launches a test mode for extensive exploration of file system");
        HFSExplorer.println("            structures. Only for debugging purposes.");
        HFSExplorer.println();
        HFSExplorer.println("  Verb options:");
        HFSExplorer.println("    <none defined>");
    }

    public static void println() {
        System.out.println();
    }

    public static void println(String s) {
        System.out.println(s);
    }

    public static void print(String s) {
        System.out.print(s);
    }

    public static void vprintln() {
        if (HFSExplorer.options.verbose) {
            System.out.println();
        }
    }

    public static void vprintln(String s) {
        if (HFSExplorer.options.verbose) {
            System.out.println(s);
        }
    }

    public static void vprint(String s) {
        if (HFSExplorer.options.verbose) {
            System.out.print(s);
        }
    }

    public static void parseOptions(String[] arguments, int offset, int length) {
        int i;
        String currentArg = null;
        for (i = offset; i < length && (currentArg = arguments[i]).startsWith("-"); ++i) {
            if (currentArg.equals("-apm")) {
                HFSExplorer.options.readAPM = true;
                continue;
            }
            if (currentArg.equals("-v")) {
                HFSExplorer.options.verbose = true;
                continue;
            }
            HFSExplorer.println("\"" + currentArg + "\" is not a valid parameter.");
        }
        if (currentArg.equals("browse")) {
            operation = Operation.BROWSE;
        } else if (currentArg.equals("chfrag")) {
            operation = Operation.FRAGCHECK;
        } else if (currentArg.equals("test")) {
            operation = Operation.TEST;
        } else if (currentArg.equals("systemfileinfo")) {
            operation = Operation.SYSTEMFILEINFO;
        }
        ++i;
        while (i < length) {
            operation.addArg(arguments[i]);
            ++i;
        }
    }

    public static HFSPlusCatalogFile findFileID(HFSPlusCatalogLeafNode leafNode, HFSCatalogNodeID nodeID) {
        HFSPlusCatalogLeafRecord[] records = leafNode.getLeafRecords();
        for (int i = 0; i < records.length; ++i) {
            HFSPlusCatalogLeafRecord curRec = records[i];
            HFSPlusCatalogLeafRecordData curRecData = curRec.getData();
            if (!(curRecData instanceof HFSPlusCatalogFile) || ((HFSPlusCatalogFile)curRecData).getFileID().toInt() != nodeID.toInt()) continue;
            return (HFSPlusCatalogFile)curRecData;
        }
        return null;
    }

    public static HFSPlusCatalogFolder findFolderID(HFSPlusCatalogLeafNode leafNode, HFSCatalogNodeID nodeID) {
        HFSPlusCatalogLeafRecord[] records = leafNode.getLeafRecords();
        for (int i = 0; i < records.length; ++i) {
            HFSPlusCatalogLeafRecord curRec = records[i];
            HFSPlusCatalogLeafRecordData curRecData = curRec.getData();
            if (!(curRecData instanceof HFSPlusCatalogFolder) || ((HFSPlusCatalogFolder)curRecData).getFolderID().toInt() != nodeID.toInt()) continue;
            return (HFSPlusCatalogFolder)curRecData;
        }
        return null;
    }

    static {
        stdIn = new BufferedReader(new InputStreamReader(System.in));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Operation {
        BROWSE,
        FRAGCHECK,
        TEST,
        SYSTEMFILEINFO;

        private String filename;
        private LinkedList<String> argsList = new LinkedList();

        public void addArg(String argument) {
            this.argsList.add(argument);
        }

        public String[] getArgs() {
            return this.argsList.toArray(new String[this.argsList.size()]);
        }

        public String getFilename() {
            return this.argsList.getLast();
        }
    }

    private static class Options {
        public boolean readAPM = false;
        public boolean verbose = false;

        private Options() {
        }
    }
}

