/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.lisa.pcode.statements;

import java.util.Collections;
import java.util.Set;

import ghidra.program.model.pcode.PcodeOp;
import it.unive.lisa.symbolic.value.operator.unary.UnaryOperator;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.TypeSystem;

public class PcodeUnaryOperator implements UnaryOperator {

	private PcodeOp op;

	public PcodeUnaryOperator(PcodeOp op) {
		this.op = op;
	}

	public PcodeOp getOp() {
		return op;
	}

	@Override
	public String toString() {
		return op.getMnemonic();
	}

	@Override
	public Set<Type> typeInference(
			TypeSystem types,
			Set<Type> argument) {
		return Collections.singleton(types.getBooleanType());
	}
}
