!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
! In this file, the following modules are present in this order:
!   - cubetools_spectral_rest_types
!   - cubetools_spectral_f_or_w_types
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubetools_spectral_rest_types
  !------------------------------------------------------------------------
  ! Rest frequency or wavelength information
  !------------------------------------------------------------------------
  use cubetools_parameters
  use cubetools_messaging
  use cubetools_structure
  use cubetools_unit_arg
  use cubetools_header_interface
  !
  public :: spectral_rest_comm_t,spectral_rest_user_t,spectral_rest_prog_t
  private
  !
  type spectral_rest_comm_t
     type(option_t),   pointer :: comm
     type(unit_arg_t), pointer :: unit
   contains
     procedure, public :: register => cubetools_spectral_rest_comm_register
     procedure, public :: parse    => cubetools_spectral_rest_comm_parse
  end type spectral_rest_comm_t
  !
  type spectral_rest_user_t
     logical               :: present   = .false.  ! Is the key present?
     character(len=argu_l) :: signal    = strg_unk ! Rest signal    at reference pixel
     character(len=argu_l) :: image     = strg_unk ! Rest image     at reference pixel
     character(len=argu_l) :: increment = strg_unk ! Rest increment at reference pixel
     character(len=argu_l) :: unit      = strg_unk ! Unit
   contains
     procedure, public :: list => cubetools_spectral_rest_user_list
  end type spectral_rest_user_t
  !
  type spectral_rest_prog_t
     integer(kind=code_k)  :: code = code_spectral_unknown ! [--------] Frequency or wavelength?
     real(kind=coor_k)     :: signal    = 0d0              ! [ MHz|mum] Rest signal value
     real(kind=coor_k)     :: image     = 0d0              ! [ MHz|mum] Rest image  value
     real(kind=coor_k)     :: increment = 0d0              ! [ MHz|mum] Rest increment value
   contains
     procedure, public :: list => cubetools_spectral_rest_prog_list
     procedure, public :: from => cubetools_spectral_rest_prog_from_headinter
     procedure, public :: to   => cubetools_spectral_rest_prog_to_headinter
  end type spectral_rest_prog_t
  !
contains
  !
  subroutine cubetools_spectral_rest_comm_register(comm,name,abstract,help,unit,error)
    !----------------------------------------------------------------------
    ! Register a /FREQUENCY|WAVELENGTH key
    !----------------------------------------------------------------------
    class(spectral_rest_comm_t), intent(inout) :: comm
    character(len=*),            intent(in)    :: name
    character(len=*),            intent(in)    :: abstract
    character(len=*),            intent(in)    :: help
    integer(kind=code_k),        intent(in)    :: unit
    logical,                     intent(inout) :: error
    !
    type(standard_arg_t) :: stdarg
    type(unit_arg_t) :: unitarg
    character(len=*), parameter :: rname='SPECTRAL>REST>COMM>REGISTER'
    !
    call cubetools_message(toolseve%trace,rname,'Welcome')
    !
    if ((name.ne.'FREQUENCY').and.(name.ne.'WAVELENGTH')) then
       call cubetools_message(seve%e,rname,"Can only register a FREQUENCY or WAVELENGTH key")
       error = .true.
       return
    endif
    !
    call cubetools_register_option(&
         name,'rest [image [[increment] unit]]',&
         abstract,&
         help,&
         comm%comm,&
         error)
    if (error) return
    call stdarg%register(&
         'SIGNAL',&
         'Rest frame signal value at reference pixel',&
         '"*" or "=" mean previous value is kept',&
         code_arg_mandatory,&
         error)
    if (error) return
    call stdarg%register(&
         'IMAGE',&
         'Rest frame image value at reference pixel',&
         '"*" or "=" mean previous value is kept',&
         code_arg_optional,&
         error)
    if (error) return
    call stdarg%register(&
         'INCREMENT',&
         'Rest frame increment value at reference pixel',&
         '"*" or "=" mean previous value is kept',&
         code_arg_optional,&
         error)
    if (error) return
    call unitarg%register(&
         'UNIT',&
         'Unit',&
         '"=" or "*" mean current user unit',&
         code_arg_optional,&
         unit,&
         comm%unit,&
         error)
    if (error) return
  end subroutine cubetools_spectral_rest_comm_register
  !
  subroutine cubetools_spectral_rest_comm_parse(comm,line,user,error)
    !----------------------------------------------------------------------
    ! Parse /FREQ|WAVE signal [image [increment [unit]]]
    ! ----------------------------------------------------------------------
    class(spectral_rest_comm_t), intent(in)    :: comm
    character(len=*),            intent(in)    :: line
    class(spectral_rest_user_t), intent(inout) :: user
    logical,                     intent(inout) :: error
    !
    character(len=*), parameter :: rname='SPECTRAL>REST>COMM>PARSE'
    !
    call cubetools_message(toolseve%trace,rname,'Welcome')
    !
    user%signal    = strg_star
    user%image     = strg_star
    user%increment = strg_star
    user%unit      = strg_equal ! Unit should not be changed if user has not given a value
    call comm%comm%present(line,user%present,error)
    if (error) return
    if (user%present) then
       call cubetools_getarg(line,comm%comm,1,user%signal,mandatory,error)
       if (error) return
       call cubetools_getarg(line,comm%comm,2,user%image,optional,error)
       if (error) return
       call cubetools_getarg(line,comm%comm,3,user%increment,optional,error)
       if (error) return
       call cubetools_getarg(line,comm%comm,4,user%unit,optional,error)
       if (error) return
    endif
  end subroutine cubetools_spectral_rest_comm_parse
  !
  !------------------------------------------------------------------------
  !
  subroutine cubetools_spectral_rest_user_list(user,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(spectral_rest_user_t), intent(in)    :: user
    logical,                     intent(inout) :: error
    !
    character(len=*), parameter :: rname='SPECTRAL>REST>USER>LIST'
    !
    call cubetools_message(toolseve%trace,rname,'Welcome')
    !
    print *,'Present:   ',user%present
    print *,'Signal:    ',user%signal
    print *,'Image:     ',user%image
    print *,'Increment: ',user%increment
    print *,'Unit:      ',user%unit
  end subroutine cubetools_spectral_rest_user_list
  !
  !------------------------------------------------------------------------
  !
  subroutine cubetools_spectral_rest_prog_list(prog,error)
    use cubetools_format
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(spectral_rest_prog_t), intent(in)    :: prog
    logical,                     intent(inout) :: error
    !
    character(len=mess_l) :: mess
    character(len=*), parameter :: rname='SPECTRAL>REST>PROG>LIST'
    !
    call cubetools_message(toolseve%trace,rname,'Welcome')
    !
    mess = cubetools_format_stdkey_boldval('RESTKIND',prog%code,'i3',17)
    mess = trim(mess)//' '//cubetools_format_stdkey_boldval('SIG',prog%signal,fdouble,ndouble+3)
    mess = trim(mess)//' '//cubetools_format_stdkey_boldval('IMA',prog%image,fdouble,ndouble+3)
    mess = trim(mess)//' '//cubetools_format_stdkey_boldval('INC',prog%increment,fdouble,ndouble+3)
    call cubetools_message(seve%r,rname,mess)
  end subroutine cubetools_spectral_rest_prog_list
  !
  subroutine cubetools_spectral_rest_prog_from_headinter(prog,head,error)
    use cubetools_header_interface
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(spectral_rest_prog_t),   intent(inout) :: prog
    type(cube_header_interface_t), intent(in)    :: head
    logical,                       intent(inout) :: error
    !
    character(len=*), parameter :: rname='SPECTRAL>REST>PROG>FROM>HEADINTER'
    !
    call cubetools_message(toolseve%trace,rname,'Welcome')
    !
    prog%code      = head%spectral_code
    prog%signal    = head%spectral_signal_value
    prog%image     = head%spectral_image_value
    prog%increment = head%spectral_increment_value
  end subroutine cubetools_spectral_rest_prog_from_headinter
  !
  subroutine cubetools_spectral_rest_prog_to_headinter(prog,head,error)
    use cubetools_header_interface
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(spectral_rest_prog_t),   intent(in)    :: prog
    type(cube_header_interface_t), intent(inout) :: head
    logical,                       intent(inout) :: error
    !
    character(len=*), parameter :: rname='SPECTRAL>REST>PROG>TO>HEADINTER'
    !
    call cubetools_message(toolseve%trace,rname,'Welcome')
    !
    head%spectral_code            = prog%code
    head%spectral_signal_value    = prog%signal
    head%spectral_image_value     = prog%image
    head%spectral_increment_value = prog%increment
  end subroutine cubetools_spectral_rest_prog_to_headinter
end module cubetools_spectral_rest_types
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubetools_spectral_f_or_w_types
  use cubetools_parameters
  use cubetools_messaging
  use cubetools_spectral_rest_types
  !
  public :: spectral_f_or_w_comm_t,spectral_f_or_w_user_t
  private
  !
  type spectral_f_or_w_comm_t
     type(spectral_rest_comm_t) :: freq
     type(spectral_rest_comm_t) :: wave
   contains
     procedure, public :: register => cubetools_spectral_f_or_w_comm_register
     procedure, public :: parse    => cubetools_spectral_f_or_w_comm_parse
  end type spectral_f_or_w_comm_t
  !
  type spectral_f_or_w_user_t
     type(spectral_rest_user_t) :: freq
     type(spectral_rest_user_t) :: wave
   contains
     procedure, public :: toprog => cubetools_spectral_f_or_w_user_toprog
  end type spectral_f_or_w_user_t
  !
contains
  !
  subroutine cubetools_spectral_f_or_w_comm_register(comm,error)
    use cubetools_unit
    !----------------------------------------------------------------------
    ! Register the /FREQUENCY and /WAVELENGTH keys
    !----------------------------------------------------------------------
    class(spectral_f_or_w_comm_t), intent(inout) :: comm
    logical,                       intent(inout) :: error
    !
    character(len=*), parameter :: rname='SPECTRAL>F>OR>W>COMM>REGISTER'
    !
    call cubetools_message(toolseve%trace,rname,'Welcome')
    !
    call comm%freq%register(&
         'FREQUENCY',&
         'Edit the rest frequencies',&
         'Rest frequency updated based on user value in current user unit',&
         code_unit_freq,&
         error)
    if (error) return
    call comm%wave%register(&
         'WAVELENGTH',&
         'Edit the rest wavelengths',&
         'Rest wavelength updated based on user value in current user unit',&
         code_unit_wave,&
         error)
    if (error) return
  end subroutine cubetools_spectral_f_or_w_comm_register
  !
  subroutine cubetools_spectral_f_or_w_comm_parse(comm,line,user,error)
    !----------------------------------------------------------------------
    ! Parse the /FREQUENCY and /WAVELENGTH keys
    ! ----------------------------------------------------------------------
    class(spectral_f_or_w_comm_t), intent(in)    :: comm
    character(len=*),              intent(in)    :: line
    type(spectral_f_or_w_user_t),  intent(inout) :: user
    logical,                       intent(inout) :: error
    !
    character(len=*), parameter :: rname='SPECTRAL>F>OR>W>COMM>PARSE'
    !
    call cubetools_message(toolseve%trace,rname,'Welcome')
    !
    call comm%freq%parse(line,user%freq,error)
    if (error) return
    call comm%wave%parse(line,user%wave,error)
    if (error) return
  end subroutine cubetools_spectral_f_or_w_comm_parse
  !
  subroutine cubetools_spectral_f_or_w_user_toprog(user,proghead,error)
    use cubetools_unit
    use cubetools_header_interface
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(spectral_f_or_w_user_t), intent(in)    :: user
    type(cube_header_interface_t), intent(inout) :: proghead
    logical,                       intent(inout) :: error
    !
    type(spectral_rest_prog_t) :: progrest
    character(len=*), parameter :: rname='SPECTRAL>F>OR>W>USER>TOPROG'
    !
    call cubetools_message(toolseve%trace,rname,'Welcome')
    !
!!$    call user%freq%list(error)
!!$    if (error) return
!!$    call user%wave%list(error)
!!$    if (error) return
    !
    if (user%freq%present.and.user%wave%present) then
       call cubetools_message(seve%e,rname,'The /FREQUENCY and /WAVELENGTH keys are exclusive from each other')
       error = .true.
       return
    else if (user%freq%present.or.user%wave%present) then
       call progrest%from(proghead,error)
       if (error) return
       if (user%freq%present) then
          call user2prog(code_spectral_frequency,code_unit_freq,&
               user%freq,progrest,error)
          if (error) return
       else if (user%wave%present) then
          call user2prog(code_spectral_wavelength,code_unit_wave,&
               user%wave,progrest,error)
          if (error) return
       endif
       call progrest%to(proghead,error)
       if (error) return
    else
       ! Does nothing!
    endif
    !
!!$    call progrest%list(error)
!!$    if (error) return
    !
  contains
    !
    subroutine user2prog(code_spec,code_unit,user,prog,error)
      !----------------------------------------------------------------------
      !----------------------------------------------------------------------
      integer(kind=code_k),       intent(in)    :: code_spec
      integer(kind=code_k),       intent(in)    :: code_unit
      type(spectral_rest_user_t), intent(in)    :: user
      type(spectral_rest_prog_t), intent(inout) :: prog
      logical,                    intent(inout) :: error
      !
      type(unit_user_t) :: unit
      !
      call update_spectral_code(prog%code,code_spec)
      call unit%get_from_name_for_code(user%unit,code_unit,error)
      if (error) return
      call resolve(unit,user%signal,prog%signal,error)
      if (error) return
      call resolve(unit,user%image,prog%image,error)
      if (error) return
      call resolve(unit,user%increment,prog%increment,error)
      if (error) return
    end subroutine user2prog
    !
    subroutine update_spectral_code(prog,code)
      !----------------------------------------------------------------------
      !----------------------------------------------------------------------
      integer(kind=code_k) :: prog
      integer(kind=code_k) :: code
      !
      if (prog.ne.code) then
         call cubetools_message(seve%w,rname,'You are trying to change the cube spectral unit')
         call cubetools_message(seve%w,rname,'Using * or = may lead to unexpected results')
      endif
      prog = code
    end subroutine update_spectral_code
    !
    subroutine resolve(unit,user,prog,error)
      use cubetools_user2prog
      !----------------------------------------------------------------------
      !----------------------------------------------------------------------
      type(unit_user_t), intent(in)    :: unit
      character(len=*),  intent(in)    :: user
      real(kind=coor_k), intent(out)   :: prog
      logical,           intent(inout) :: error
      !
      real(kind=coor_k) :: default,previous
      !
      default = prog
      previous = prog
      call cubetools_user2prog_resolve_all(user,unit,default,previous,prog,error)
      if (error) return      
    end subroutine resolve
  end subroutine cubetools_spectral_f_or_w_user_toprog
end module cubetools_spectral_f_or_w_types
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
