//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armiothub

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/profile/p20200901/internal"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ResourceClient contains the methods for the IotHubResource group.
// Don't use this type directly, use NewResourceClient() instead.
type ResourceClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewResourceClient creates a new instance of ResourceClient with the specified values.
//   - subscriptionID - The subscription identifier.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewResourceClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ResourceClient, error) {
	cl, err := arm.NewClient(internal.ModuleName+"/armiothub.ResourceClient", internal.ModuleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ResourceClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CheckNameAvailability - Check if an IoT hub name is available.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-07-01-preview
//   - operationInputs - Set the name parameter in the OperationInputs structure to the name of the IoT hub to check.
//   - options - ResourceClientCheckNameAvailabilityOptions contains the optional parameters for the ResourceClient.CheckNameAvailability
//     method.
func (client *ResourceClient) CheckNameAvailability(ctx context.Context, operationInputs OperationInputs, options *ResourceClientCheckNameAvailabilityOptions) (ResourceClientCheckNameAvailabilityResponse, error) {
	req, err := client.checkNameAvailabilityCreateRequest(ctx, operationInputs, options)
	if err != nil {
		return ResourceClientCheckNameAvailabilityResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ResourceClientCheckNameAvailabilityResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ResourceClientCheckNameAvailabilityResponse{}, runtime.NewResponseError(resp)
	}
	return client.checkNameAvailabilityHandleResponse(resp)
}

// checkNameAvailabilityCreateRequest creates the CheckNameAvailability request.
func (client *ResourceClient) checkNameAvailabilityCreateRequest(ctx context.Context, operationInputs OperationInputs, options *ResourceClientCheckNameAvailabilityOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Devices/checkNameAvailability"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, operationInputs)
}

// checkNameAvailabilityHandleResponse handles the CheckNameAvailability response.
func (client *ResourceClient) checkNameAvailabilityHandleResponse(resp *http.Response) (ResourceClientCheckNameAvailabilityResponse, error) {
	result := ResourceClientCheckNameAvailabilityResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.NameAvailabilityInfo); err != nil {
		return ResourceClientCheckNameAvailabilityResponse{}, err
	}
	return result, nil
}

// CreateEventHubConsumerGroup - Add a consumer group to an Event Hub-compatible endpoint in an IoT hub.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-07-01-preview
//   - resourceGroupName - The name of the resource group that contains the IoT hub.
//   - resourceName - The name of the IoT hub.
//   - eventHubEndpointName - The name of the Event Hub-compatible endpoint in the IoT hub.
//   - name - The name of the consumer group to add.
//   - options - ResourceClientCreateEventHubConsumerGroupOptions contains the optional parameters for the ResourceClient.CreateEventHubConsumerGroup
//     method.
func (client *ResourceClient) CreateEventHubConsumerGroup(ctx context.Context, resourceGroupName string, resourceName string, eventHubEndpointName string, name string, options *ResourceClientCreateEventHubConsumerGroupOptions) (ResourceClientCreateEventHubConsumerGroupResponse, error) {
	req, err := client.createEventHubConsumerGroupCreateRequest(ctx, resourceGroupName, resourceName, eventHubEndpointName, name, options)
	if err != nil {
		return ResourceClientCreateEventHubConsumerGroupResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ResourceClientCreateEventHubConsumerGroupResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ResourceClientCreateEventHubConsumerGroupResponse{}, runtime.NewResponseError(resp)
	}
	return client.createEventHubConsumerGroupHandleResponse(resp)
}

// createEventHubConsumerGroupCreateRequest creates the CreateEventHubConsumerGroup request.
func (client *ResourceClient) createEventHubConsumerGroupCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, eventHubEndpointName string, name string, options *ResourceClientCreateEventHubConsumerGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if eventHubEndpointName == "" {
		return nil, errors.New("parameter eventHubEndpointName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{eventHubEndpointName}", url.PathEscape(eventHubEndpointName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// createEventHubConsumerGroupHandleResponse handles the CreateEventHubConsumerGroup response.
func (client *ResourceClient) createEventHubConsumerGroupHandleResponse(resp *http.Response) (ResourceClientCreateEventHubConsumerGroupResponse, error) {
	result := ResourceClientCreateEventHubConsumerGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EventHubConsumerGroupInfo); err != nil {
		return ResourceClientCreateEventHubConsumerGroupResponse{}, err
	}
	return result, nil
}

// BeginCreateOrUpdate - Create or update the metadata of an Iot hub. The usual pattern to modify a property is to retrieve
// the IoT hub metadata and security metadata, and then combine them with the modified values in a new
// body to update the IoT hub. If certain properties are missing in the JSON, updating IoT Hub may cause these values to fallback
// to default, which may lead to unexpected behavior.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-07-01-preview
//   - resourceGroupName - The name of the resource group that contains the IoT hub.
//   - resourceName - The name of the IoT hub.
//   - iotHubDescription - The IoT hub metadata and security metadata.
//   - options - ResourceClientBeginCreateOrUpdateOptions contains the optional parameters for the ResourceClient.BeginCreateOrUpdate
//     method.
func (client *ResourceClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, resourceName string, iotHubDescription Description, options *ResourceClientBeginCreateOrUpdateOptions) (*runtime.Poller[ResourceClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, resourceName, iotHubDescription, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[ResourceClientCreateOrUpdateResponse](resp, client.internal.Pipeline(), nil)
	} else {
		return runtime.NewPollerFromResumeToken[ResourceClientCreateOrUpdateResponse](options.ResumeToken, client.internal.Pipeline(), nil)
	}
}

// CreateOrUpdate - Create or update the metadata of an Iot hub. The usual pattern to modify a property is to retrieve the
// IoT hub metadata and security metadata, and then combine them with the modified values in a new
// body to update the IoT hub. If certain properties are missing in the JSON, updating IoT Hub may cause these values to fallback
// to default, which may lead to unexpected behavior.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-07-01-preview
func (client *ResourceClient) createOrUpdate(ctx context.Context, resourceGroupName string, resourceName string, iotHubDescription Description, options *ResourceClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, resourceName, iotHubDescription, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *ResourceClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, iotHubDescription Description, options *ResourceClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, iotHubDescription)
}

// BeginDelete - Delete an IoT hub.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-07-01-preview
//   - resourceGroupName - The name of the resource group that contains the IoT hub.
//   - resourceName - The name of the IoT hub.
//   - options - ResourceClientBeginDeleteOptions contains the optional parameters for the ResourceClient.BeginDelete method.
func (client *ResourceClient) BeginDelete(ctx context.Context, resourceGroupName string, resourceName string, options *ResourceClientBeginDeleteOptions) (*runtime.Poller[ResourceClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, resourceName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[ResourceClientDeleteResponse](resp, client.internal.Pipeline(), nil)
	} else {
		return runtime.NewPollerFromResumeToken[ResourceClientDeleteResponse](options.ResumeToken, client.internal.Pipeline(), nil)
	}
}

// Delete - Delete an IoT hub.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-07-01-preview
func (client *ResourceClient) deleteOperation(ctx context.Context, resourceGroupName string, resourceName string, options *ResourceClientBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted, http.StatusNoContent, http.StatusNotFound) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ResourceClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *ResourceClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteEventHubConsumerGroup - Delete a consumer group from an Event Hub-compatible endpoint in an IoT hub.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-07-01-preview
//   - resourceGroupName - The name of the resource group that contains the IoT hub.
//   - resourceName - The name of the IoT hub.
//   - eventHubEndpointName - The name of the Event Hub-compatible endpoint in the IoT hub.
//   - name - The name of the consumer group to delete.
//   - options - ResourceClientDeleteEventHubConsumerGroupOptions contains the optional parameters for the ResourceClient.DeleteEventHubConsumerGroup
//     method.
func (client *ResourceClient) DeleteEventHubConsumerGroup(ctx context.Context, resourceGroupName string, resourceName string, eventHubEndpointName string, name string, options *ResourceClientDeleteEventHubConsumerGroupOptions) (ResourceClientDeleteEventHubConsumerGroupResponse, error) {
	req, err := client.deleteEventHubConsumerGroupCreateRequest(ctx, resourceGroupName, resourceName, eventHubEndpointName, name, options)
	if err != nil {
		return ResourceClientDeleteEventHubConsumerGroupResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ResourceClientDeleteEventHubConsumerGroupResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ResourceClientDeleteEventHubConsumerGroupResponse{}, runtime.NewResponseError(resp)
	}
	return ResourceClientDeleteEventHubConsumerGroupResponse{}, nil
}

// deleteEventHubConsumerGroupCreateRequest creates the DeleteEventHubConsumerGroup request.
func (client *ResourceClient) deleteEventHubConsumerGroupCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, eventHubEndpointName string, name string, options *ResourceClientDeleteEventHubConsumerGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if eventHubEndpointName == "" {
		return nil, errors.New("parameter eventHubEndpointName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{eventHubEndpointName}", url.PathEscape(eventHubEndpointName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// ExportDevices - Exports all the device identities in the IoT hub identity registry to an Azure Storage blob container.
// For more information, see:
// https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-07-01-preview
//   - resourceGroupName - The name of the resource group that contains the IoT hub.
//   - resourceName - The name of the IoT hub.
//   - exportDevicesParameters - The parameters that specify the export devices operation.
//   - options - ResourceClientExportDevicesOptions contains the optional parameters for the ResourceClient.ExportDevices method.
func (client *ResourceClient) ExportDevices(ctx context.Context, resourceGroupName string, resourceName string, exportDevicesParameters ExportDevicesRequest, options *ResourceClientExportDevicesOptions) (ResourceClientExportDevicesResponse, error) {
	req, err := client.exportDevicesCreateRequest(ctx, resourceGroupName, resourceName, exportDevicesParameters, options)
	if err != nil {
		return ResourceClientExportDevicesResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ResourceClientExportDevicesResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ResourceClientExportDevicesResponse{}, runtime.NewResponseError(resp)
	}
	return client.exportDevicesHandleResponse(resp)
}

// exportDevicesCreateRequest creates the ExportDevices request.
func (client *ResourceClient) exportDevicesCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, exportDevicesParameters ExportDevicesRequest, options *ResourceClientExportDevicesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/exportDevices"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, exportDevicesParameters)
}

// exportDevicesHandleResponse handles the ExportDevices response.
func (client *ResourceClient) exportDevicesHandleResponse(resp *http.Response) (ResourceClientExportDevicesResponse, error) {
	result := ResourceClientExportDevicesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.JobResponse); err != nil {
		return ResourceClientExportDevicesResponse{}, err
	}
	return result, nil
}

// Get - Get the non-security related metadata of an IoT hub.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-07-01-preview
//   - resourceGroupName - The name of the resource group that contains the IoT hub.
//   - resourceName - The name of the IoT hub.
//   - options - ResourceClientGetOptions contains the optional parameters for the ResourceClient.Get method.
func (client *ResourceClient) Get(ctx context.Context, resourceGroupName string, resourceName string, options *ResourceClientGetOptions) (ResourceClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return ResourceClientGetResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ResourceClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ResourceClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *ResourceClient) getCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *ResourceClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ResourceClient) getHandleResponse(resp *http.Response) (ResourceClientGetResponse, error) {
	result := ResourceClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Description); err != nil {
		return ResourceClientGetResponse{}, err
	}
	return result, nil
}

// NewGetEndpointHealthPager - Get the health for routing endpoints.
//
// Generated from API version 2019-07-01-preview
//   - options - ResourceClientGetEndpointHealthOptions contains the optional parameters for the ResourceClient.NewGetEndpointHealthPager
//     method.
func (client *ResourceClient) NewGetEndpointHealthPager(resourceGroupName string, iotHubName string, options *ResourceClientGetEndpointHealthOptions) *runtime.Pager[ResourceClientGetEndpointHealthResponse] {
	return runtime.NewPager(runtime.PagingHandler[ResourceClientGetEndpointHealthResponse]{
		More: func(page ResourceClientGetEndpointHealthResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ResourceClientGetEndpointHealthResponse) (ResourceClientGetEndpointHealthResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.getEndpointHealthCreateRequest(ctx, resourceGroupName, iotHubName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ResourceClientGetEndpointHealthResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return ResourceClientGetEndpointHealthResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ResourceClientGetEndpointHealthResponse{}, runtime.NewResponseError(resp)
			}
			return client.getEndpointHealthHandleResponse(resp)
		},
	})
}

// getEndpointHealthCreateRequest creates the GetEndpointHealth request.
func (client *ResourceClient) getEndpointHealthCreateRequest(ctx context.Context, resourceGroupName string, iotHubName string, options *ResourceClientGetEndpointHealthOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{iotHubName}/routingEndpointsHealth"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if iotHubName == "" {
		return nil, errors.New("parameter iotHubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{iotHubName}", url.PathEscape(iotHubName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getEndpointHealthHandleResponse handles the GetEndpointHealth response.
func (client *ResourceClient) getEndpointHealthHandleResponse(resp *http.Response) (ResourceClientGetEndpointHealthResponse, error) {
	result := ResourceClientGetEndpointHealthResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EndpointHealthDataListResult); err != nil {
		return ResourceClientGetEndpointHealthResponse{}, err
	}
	return result, nil
}

// GetEventHubConsumerGroup - Get a consumer group from the Event Hub-compatible device-to-cloud endpoint for an IoT hub.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-07-01-preview
//   - resourceGroupName - The name of the resource group that contains the IoT hub.
//   - resourceName - The name of the IoT hub.
//   - eventHubEndpointName - The name of the Event Hub-compatible endpoint in the IoT hub.
//   - name - The name of the consumer group to retrieve.
//   - options - ResourceClientGetEventHubConsumerGroupOptions contains the optional parameters for the ResourceClient.GetEventHubConsumerGroup
//     method.
func (client *ResourceClient) GetEventHubConsumerGroup(ctx context.Context, resourceGroupName string, resourceName string, eventHubEndpointName string, name string, options *ResourceClientGetEventHubConsumerGroupOptions) (ResourceClientGetEventHubConsumerGroupResponse, error) {
	req, err := client.getEventHubConsumerGroupCreateRequest(ctx, resourceGroupName, resourceName, eventHubEndpointName, name, options)
	if err != nil {
		return ResourceClientGetEventHubConsumerGroupResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ResourceClientGetEventHubConsumerGroupResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ResourceClientGetEventHubConsumerGroupResponse{}, runtime.NewResponseError(resp)
	}
	return client.getEventHubConsumerGroupHandleResponse(resp)
}

// getEventHubConsumerGroupCreateRequest creates the GetEventHubConsumerGroup request.
func (client *ResourceClient) getEventHubConsumerGroupCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, eventHubEndpointName string, name string, options *ResourceClientGetEventHubConsumerGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if eventHubEndpointName == "" {
		return nil, errors.New("parameter eventHubEndpointName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{eventHubEndpointName}", url.PathEscape(eventHubEndpointName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getEventHubConsumerGroupHandleResponse handles the GetEventHubConsumerGroup response.
func (client *ResourceClient) getEventHubConsumerGroupHandleResponse(resp *http.Response) (ResourceClientGetEventHubConsumerGroupResponse, error) {
	result := ResourceClientGetEventHubConsumerGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EventHubConsumerGroupInfo); err != nil {
		return ResourceClientGetEventHubConsumerGroupResponse{}, err
	}
	return result, nil
}

// GetJob - Get the details of a job from an IoT hub. For more information, see: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-07-01-preview
//   - resourceGroupName - The name of the resource group that contains the IoT hub.
//   - resourceName - The name of the IoT hub.
//   - jobID - The job identifier.
//   - options - ResourceClientGetJobOptions contains the optional parameters for the ResourceClient.GetJob method.
func (client *ResourceClient) GetJob(ctx context.Context, resourceGroupName string, resourceName string, jobID string, options *ResourceClientGetJobOptions) (ResourceClientGetJobResponse, error) {
	req, err := client.getJobCreateRequest(ctx, resourceGroupName, resourceName, jobID, options)
	if err != nil {
		return ResourceClientGetJobResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ResourceClientGetJobResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ResourceClientGetJobResponse{}, runtime.NewResponseError(resp)
	}
	return client.getJobHandleResponse(resp)
}

// getJobCreateRequest creates the GetJob request.
func (client *ResourceClient) getJobCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, jobID string, options *ResourceClientGetJobOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/jobs/{jobId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if jobID == "" {
		return nil, errors.New("parameter jobID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{jobId}", url.PathEscape(jobID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getJobHandleResponse handles the GetJob response.
func (client *ResourceClient) getJobHandleResponse(resp *http.Response) (ResourceClientGetJobResponse, error) {
	result := ResourceClientGetJobResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.JobResponse); err != nil {
		return ResourceClientGetJobResponse{}, err
	}
	return result, nil
}

// GetKeysForKeyName - Get a shared access policy by name from an IoT hub. For more information, see: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-07-01-preview
//   - resourceGroupName - The name of the resource group that contains the IoT hub.
//   - resourceName - The name of the IoT hub.
//   - keyName - The name of the shared access policy.
//   - options - ResourceClientGetKeysForKeyNameOptions contains the optional parameters for the ResourceClient.GetKeysForKeyName
//     method.
func (client *ResourceClient) GetKeysForKeyName(ctx context.Context, resourceGroupName string, resourceName string, keyName string, options *ResourceClientGetKeysForKeyNameOptions) (ResourceClientGetKeysForKeyNameResponse, error) {
	req, err := client.getKeysForKeyNameCreateRequest(ctx, resourceGroupName, resourceName, keyName, options)
	if err != nil {
		return ResourceClientGetKeysForKeyNameResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ResourceClientGetKeysForKeyNameResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ResourceClientGetKeysForKeyNameResponse{}, runtime.NewResponseError(resp)
	}
	return client.getKeysForKeyNameHandleResponse(resp)
}

// getKeysForKeyNameCreateRequest creates the GetKeysForKeyName request.
func (client *ResourceClient) getKeysForKeyNameCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, keyName string, options *ResourceClientGetKeysForKeyNameOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/IotHubKeys/{keyName}/listkeys"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{keyName}", url.PathEscape(keyName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getKeysForKeyNameHandleResponse handles the GetKeysForKeyName response.
func (client *ResourceClient) getKeysForKeyNameHandleResponse(resp *http.Response) (ResourceClientGetKeysForKeyNameResponse, error) {
	result := ResourceClientGetKeysForKeyNameResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SharedAccessSignatureAuthorizationRule); err != nil {
		return ResourceClientGetKeysForKeyNameResponse{}, err
	}
	return result, nil
}

// NewGetQuotaMetricsPager - Get the quota metrics for an IoT hub.
//
// Generated from API version 2019-07-01-preview
//   - resourceGroupName - The name of the resource group that contains the IoT hub.
//   - resourceName - The name of the IoT hub.
//   - options - ResourceClientGetQuotaMetricsOptions contains the optional parameters for the ResourceClient.NewGetQuotaMetricsPager
//     method.
func (client *ResourceClient) NewGetQuotaMetricsPager(resourceGroupName string, resourceName string, options *ResourceClientGetQuotaMetricsOptions) *runtime.Pager[ResourceClientGetQuotaMetricsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ResourceClientGetQuotaMetricsResponse]{
		More: func(page ResourceClientGetQuotaMetricsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ResourceClientGetQuotaMetricsResponse) (ResourceClientGetQuotaMetricsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.getQuotaMetricsCreateRequest(ctx, resourceGroupName, resourceName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ResourceClientGetQuotaMetricsResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return ResourceClientGetQuotaMetricsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ResourceClientGetQuotaMetricsResponse{}, runtime.NewResponseError(resp)
			}
			return client.getQuotaMetricsHandleResponse(resp)
		},
	})
}

// getQuotaMetricsCreateRequest creates the GetQuotaMetrics request.
func (client *ResourceClient) getQuotaMetricsCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *ResourceClientGetQuotaMetricsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/quotaMetrics"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getQuotaMetricsHandleResponse handles the GetQuotaMetrics response.
func (client *ResourceClient) getQuotaMetricsHandleResponse(resp *http.Response) (ResourceClientGetQuotaMetricsResponse, error) {
	result := ResourceClientGetQuotaMetricsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.QuotaMetricInfoListResult); err != nil {
		return ResourceClientGetQuotaMetricsResponse{}, err
	}
	return result, nil
}

// GetStats - Get the statistics from an IoT hub.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-07-01-preview
//   - resourceGroupName - The name of the resource group that contains the IoT hub.
//   - resourceName - The name of the IoT hub.
//   - options - ResourceClientGetStatsOptions contains the optional parameters for the ResourceClient.GetStats method.
func (client *ResourceClient) GetStats(ctx context.Context, resourceGroupName string, resourceName string, options *ResourceClientGetStatsOptions) (ResourceClientGetStatsResponse, error) {
	req, err := client.getStatsCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return ResourceClientGetStatsResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ResourceClientGetStatsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ResourceClientGetStatsResponse{}, runtime.NewResponseError(resp)
	}
	return client.getStatsHandleResponse(resp)
}

// getStatsCreateRequest creates the GetStats request.
func (client *ResourceClient) getStatsCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *ResourceClientGetStatsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/IotHubStats"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getStatsHandleResponse handles the GetStats response.
func (client *ResourceClient) getStatsHandleResponse(resp *http.Response) (ResourceClientGetStatsResponse, error) {
	result := ResourceClientGetStatsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RegistryStatistics); err != nil {
		return ResourceClientGetStatsResponse{}, err
	}
	return result, nil
}

// NewGetValidSKUsPager - Get the list of valid SKUs for an IoT hub.
//
// Generated from API version 2019-07-01-preview
//   - resourceGroupName - The name of the resource group that contains the IoT hub.
//   - resourceName - The name of the IoT hub.
//   - options - ResourceClientGetValidSKUsOptions contains the optional parameters for the ResourceClient.NewGetValidSKUsPager
//     method.
func (client *ResourceClient) NewGetValidSKUsPager(resourceGroupName string, resourceName string, options *ResourceClientGetValidSKUsOptions) *runtime.Pager[ResourceClientGetValidSKUsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ResourceClientGetValidSKUsResponse]{
		More: func(page ResourceClientGetValidSKUsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ResourceClientGetValidSKUsResponse) (ResourceClientGetValidSKUsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.getValidSKUsCreateRequest(ctx, resourceGroupName, resourceName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ResourceClientGetValidSKUsResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return ResourceClientGetValidSKUsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ResourceClientGetValidSKUsResponse{}, runtime.NewResponseError(resp)
			}
			return client.getValidSKUsHandleResponse(resp)
		},
	})
}

// getValidSKUsCreateRequest creates the GetValidSKUs request.
func (client *ResourceClient) getValidSKUsCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *ResourceClientGetValidSKUsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/skus"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getValidSKUsHandleResponse handles the GetValidSKUs response.
func (client *ResourceClient) getValidSKUsHandleResponse(resp *http.Response) (ResourceClientGetValidSKUsResponse, error) {
	result := ResourceClientGetValidSKUsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SKUDescriptionListResult); err != nil {
		return ResourceClientGetValidSKUsResponse{}, err
	}
	return result, nil
}

// ImportDevices - Import, update, or delete device identities in the IoT hub identity registry from a blob. For more information,
// see:
// https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-07-01-preview
//   - resourceGroupName - The name of the resource group that contains the IoT hub.
//   - resourceName - The name of the IoT hub.
//   - importDevicesParameters - The parameters that specify the import devices operation.
//   - options - ResourceClientImportDevicesOptions contains the optional parameters for the ResourceClient.ImportDevices method.
func (client *ResourceClient) ImportDevices(ctx context.Context, resourceGroupName string, resourceName string, importDevicesParameters ImportDevicesRequest, options *ResourceClientImportDevicesOptions) (ResourceClientImportDevicesResponse, error) {
	req, err := client.importDevicesCreateRequest(ctx, resourceGroupName, resourceName, importDevicesParameters, options)
	if err != nil {
		return ResourceClientImportDevicesResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ResourceClientImportDevicesResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ResourceClientImportDevicesResponse{}, runtime.NewResponseError(resp)
	}
	return client.importDevicesHandleResponse(resp)
}

// importDevicesCreateRequest creates the ImportDevices request.
func (client *ResourceClient) importDevicesCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, importDevicesParameters ImportDevicesRequest, options *ResourceClientImportDevicesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/importDevices"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, importDevicesParameters)
}

// importDevicesHandleResponse handles the ImportDevices response.
func (client *ResourceClient) importDevicesHandleResponse(resp *http.Response) (ResourceClientImportDevicesResponse, error) {
	result := ResourceClientImportDevicesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.JobResponse); err != nil {
		return ResourceClientImportDevicesResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - Get all the IoT hubs in a resource group.
//
// Generated from API version 2019-07-01-preview
//   - resourceGroupName - The name of the resource group that contains the IoT hub.
//   - options - ResourceClientListByResourceGroupOptions contains the optional parameters for the ResourceClient.NewListByResourceGroupPager
//     method.
func (client *ResourceClient) NewListByResourceGroupPager(resourceGroupName string, options *ResourceClientListByResourceGroupOptions) *runtime.Pager[ResourceClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[ResourceClientListByResourceGroupResponse]{
		More: func(page ResourceClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ResourceClientListByResourceGroupResponse) (ResourceClientListByResourceGroupResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ResourceClientListByResourceGroupResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return ResourceClientListByResourceGroupResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ResourceClientListByResourceGroupResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *ResourceClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *ResourceClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *ResourceClient) listByResourceGroupHandleResponse(resp *http.Response) (ResourceClientListByResourceGroupResponse, error) {
	result := ResourceClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DescriptionListResult); err != nil {
		return ResourceClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - Get all the IoT hubs in a subscription.
//
// Generated from API version 2019-07-01-preview
//   - options - ResourceClientListBySubscriptionOptions contains the optional parameters for the ResourceClient.NewListBySubscriptionPager
//     method.
func (client *ResourceClient) NewListBySubscriptionPager(options *ResourceClientListBySubscriptionOptions) *runtime.Pager[ResourceClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[ResourceClientListBySubscriptionResponse]{
		More: func(page ResourceClientListBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ResourceClientListBySubscriptionResponse) (ResourceClientListBySubscriptionResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listBySubscriptionCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ResourceClientListBySubscriptionResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return ResourceClientListBySubscriptionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ResourceClientListBySubscriptionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *ResourceClient) listBySubscriptionCreateRequest(ctx context.Context, options *ResourceClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Devices/IotHubs"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *ResourceClient) listBySubscriptionHandleResponse(resp *http.Response) (ResourceClientListBySubscriptionResponse, error) {
	result := ResourceClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DescriptionListResult); err != nil {
		return ResourceClientListBySubscriptionResponse{}, err
	}
	return result, nil
}

// NewListEventHubConsumerGroupsPager - Get a list of the consumer groups in the Event Hub-compatible device-to-cloud endpoint
// in an IoT hub.
//
// Generated from API version 2019-07-01-preview
//   - resourceGroupName - The name of the resource group that contains the IoT hub.
//   - resourceName - The name of the IoT hub.
//   - eventHubEndpointName - The name of the Event Hub-compatible endpoint.
//   - options - ResourceClientListEventHubConsumerGroupsOptions contains the optional parameters for the ResourceClient.NewListEventHubConsumerGroupsPager
//     method.
func (client *ResourceClient) NewListEventHubConsumerGroupsPager(resourceGroupName string, resourceName string, eventHubEndpointName string, options *ResourceClientListEventHubConsumerGroupsOptions) *runtime.Pager[ResourceClientListEventHubConsumerGroupsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ResourceClientListEventHubConsumerGroupsResponse]{
		More: func(page ResourceClientListEventHubConsumerGroupsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ResourceClientListEventHubConsumerGroupsResponse) (ResourceClientListEventHubConsumerGroupsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listEventHubConsumerGroupsCreateRequest(ctx, resourceGroupName, resourceName, eventHubEndpointName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ResourceClientListEventHubConsumerGroupsResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return ResourceClientListEventHubConsumerGroupsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ResourceClientListEventHubConsumerGroupsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listEventHubConsumerGroupsHandleResponse(resp)
		},
	})
}

// listEventHubConsumerGroupsCreateRequest creates the ListEventHubConsumerGroups request.
func (client *ResourceClient) listEventHubConsumerGroupsCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, eventHubEndpointName string, options *ResourceClientListEventHubConsumerGroupsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if eventHubEndpointName == "" {
		return nil, errors.New("parameter eventHubEndpointName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{eventHubEndpointName}", url.PathEscape(eventHubEndpointName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listEventHubConsumerGroupsHandleResponse handles the ListEventHubConsumerGroups response.
func (client *ResourceClient) listEventHubConsumerGroupsHandleResponse(resp *http.Response) (ResourceClientListEventHubConsumerGroupsResponse, error) {
	result := ResourceClientListEventHubConsumerGroupsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EventHubConsumerGroupsListResult); err != nil {
		return ResourceClientListEventHubConsumerGroupsResponse{}, err
	}
	return result, nil
}

// NewListJobsPager - Get a list of all the jobs in an IoT hub. For more information, see: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry.
//
// Generated from API version 2019-07-01-preview
//   - resourceGroupName - The name of the resource group that contains the IoT hub.
//   - resourceName - The name of the IoT hub.
//   - options - ResourceClientListJobsOptions contains the optional parameters for the ResourceClient.NewListJobsPager method.
func (client *ResourceClient) NewListJobsPager(resourceGroupName string, resourceName string, options *ResourceClientListJobsOptions) *runtime.Pager[ResourceClientListJobsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ResourceClientListJobsResponse]{
		More: func(page ResourceClientListJobsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ResourceClientListJobsResponse) (ResourceClientListJobsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listJobsCreateRequest(ctx, resourceGroupName, resourceName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ResourceClientListJobsResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return ResourceClientListJobsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ResourceClientListJobsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listJobsHandleResponse(resp)
		},
	})
}

// listJobsCreateRequest creates the ListJobs request.
func (client *ResourceClient) listJobsCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *ResourceClientListJobsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/jobs"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listJobsHandleResponse handles the ListJobs response.
func (client *ResourceClient) listJobsHandleResponse(resp *http.Response) (ResourceClientListJobsResponse, error) {
	result := ResourceClientListJobsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.JobResponseListResult); err != nil {
		return ResourceClientListJobsResponse{}, err
	}
	return result, nil
}

// NewListKeysPager - Get the security metadata for an IoT hub. For more information, see: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-security.
//
// Generated from API version 2019-07-01-preview
//   - resourceGroupName - The name of the resource group that contains the IoT hub.
//   - resourceName - The name of the IoT hub.
//   - options - ResourceClientListKeysOptions contains the optional parameters for the ResourceClient.NewListKeysPager method.
func (client *ResourceClient) NewListKeysPager(resourceGroupName string, resourceName string, options *ResourceClientListKeysOptions) *runtime.Pager[ResourceClientListKeysResponse] {
	return runtime.NewPager(runtime.PagingHandler[ResourceClientListKeysResponse]{
		More: func(page ResourceClientListKeysResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ResourceClientListKeysResponse) (ResourceClientListKeysResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listKeysCreateRequest(ctx, resourceGroupName, resourceName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ResourceClientListKeysResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return ResourceClientListKeysResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ResourceClientListKeysResponse{}, runtime.NewResponseError(resp)
			}
			return client.listKeysHandleResponse(resp)
		},
	})
}

// listKeysCreateRequest creates the ListKeys request.
func (client *ResourceClient) listKeysCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *ResourceClientListKeysOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/listkeys"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listKeysHandleResponse handles the ListKeys response.
func (client *ResourceClient) listKeysHandleResponse(resp *http.Response) (ResourceClientListKeysResponse, error) {
	result := ResourceClientListKeysResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SharedAccessSignatureAuthorizationRuleListResult); err != nil {
		return ResourceClientListKeysResponse{}, err
	}
	return result, nil
}

// TestAllRoutes - Test all routes configured in this Iot Hub
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-07-01-preview
//   - iotHubName - IotHub to be tested
//   - resourceGroupName - resource group which Iot Hub belongs to
//   - input - Input for testing all routes
//   - options - ResourceClientTestAllRoutesOptions contains the optional parameters for the ResourceClient.TestAllRoutes method.
func (client *ResourceClient) TestAllRoutes(ctx context.Context, iotHubName string, resourceGroupName string, input TestAllRoutesInput, options *ResourceClientTestAllRoutesOptions) (ResourceClientTestAllRoutesResponse, error) {
	req, err := client.testAllRoutesCreateRequest(ctx, iotHubName, resourceGroupName, input, options)
	if err != nil {
		return ResourceClientTestAllRoutesResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ResourceClientTestAllRoutesResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ResourceClientTestAllRoutesResponse{}, runtime.NewResponseError(resp)
	}
	return client.testAllRoutesHandleResponse(resp)
}

// testAllRoutesCreateRequest creates the TestAllRoutes request.
func (client *ResourceClient) testAllRoutesCreateRequest(ctx context.Context, iotHubName string, resourceGroupName string, input TestAllRoutesInput, options *ResourceClientTestAllRoutesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{iotHubName}/routing/routes/$testall"
	if iotHubName == "" {
		return nil, errors.New("parameter iotHubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{iotHubName}", url.PathEscape(iotHubName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, input)
}

// testAllRoutesHandleResponse handles the TestAllRoutes response.
func (client *ResourceClient) testAllRoutesHandleResponse(resp *http.Response) (ResourceClientTestAllRoutesResponse, error) {
	result := ResourceClientTestAllRoutesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.TestAllRoutesResult); err != nil {
		return ResourceClientTestAllRoutesResponse{}, err
	}
	return result, nil
}

// TestRoute - Test the new route for this Iot Hub
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-07-01-preview
//   - iotHubName - IotHub to be tested
//   - resourceGroupName - resource group which Iot Hub belongs to
//   - input - Route that needs to be tested
//   - options - ResourceClientTestRouteOptions contains the optional parameters for the ResourceClient.TestRoute method.
func (client *ResourceClient) TestRoute(ctx context.Context, iotHubName string, resourceGroupName string, input TestRouteInput, options *ResourceClientTestRouteOptions) (ResourceClientTestRouteResponse, error) {
	req, err := client.testRouteCreateRequest(ctx, iotHubName, resourceGroupName, input, options)
	if err != nil {
		return ResourceClientTestRouteResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ResourceClientTestRouteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ResourceClientTestRouteResponse{}, runtime.NewResponseError(resp)
	}
	return client.testRouteHandleResponse(resp)
}

// testRouteCreateRequest creates the TestRoute request.
func (client *ResourceClient) testRouteCreateRequest(ctx context.Context, iotHubName string, resourceGroupName string, input TestRouteInput, options *ResourceClientTestRouteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{iotHubName}/routing/routes/$testnew"
	if iotHubName == "" {
		return nil, errors.New("parameter iotHubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{iotHubName}", url.PathEscape(iotHubName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, input)
}

// testRouteHandleResponse handles the TestRoute response.
func (client *ResourceClient) testRouteHandleResponse(resp *http.Response) (ResourceClientTestRouteResponse, error) {
	result := ResourceClientTestRouteResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.TestRouteResult); err != nil {
		return ResourceClientTestRouteResponse{}, err
	}
	return result, nil
}

// BeginUpdate - Update an existing IoT Hub tags. to update other fields use the CreateOrUpdate method
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-07-01-preview
//   - resourceGroupName - Resource group identifier.
//   - resourceName - Name of iot hub to update.
//   - iotHubTags - Updated tag information to set into the iot hub instance.
//   - options - ResourceClientBeginUpdateOptions contains the optional parameters for the ResourceClient.BeginUpdate method.
func (client *ResourceClient) BeginUpdate(ctx context.Context, resourceGroupName string, resourceName string, iotHubTags TagsResource, options *ResourceClientBeginUpdateOptions) (*runtime.Poller[ResourceClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, resourceGroupName, resourceName, iotHubTags, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[ResourceClientUpdateResponse](resp, client.internal.Pipeline(), nil)
	} else {
		return runtime.NewPollerFromResumeToken[ResourceClientUpdateResponse](options.ResumeToken, client.internal.Pipeline(), nil)
	}
}

// Update - Update an existing IoT Hub tags. to update other fields use the CreateOrUpdate method
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-07-01-preview
func (client *ResourceClient) update(ctx context.Context, resourceGroupName string, resourceName string, iotHubTags TagsResource, options *ResourceClientBeginUpdateOptions) (*http.Response, error) {
	req, err := client.updateCreateRequest(ctx, resourceGroupName, resourceName, iotHubTags, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// updateCreateRequest creates the Update request.
func (client *ResourceClient) updateCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, iotHubTags TagsResource, options *ResourceClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, iotHubTags)
}
