//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmonitor

import "time"

// DiagnosticSettings - The diagnostic settings.
type DiagnosticSettings struct {
	// The resource Id for the event hub authorization rule.
	EventHubAuthorizationRuleID *string `json:"eventHubAuthorizationRuleId,omitempty"`

	// The name of the event hub. If none is specified, the default event hub will be selected.
	EventHubName *string `json:"eventHubName,omitempty"`

	// A string indicating whether the export to Log Analytics should use the default destination type, i.e. AzureDiagnostics,
	// or use a destination type constructed as follows: _. Possible values are:
	// Dedicated and null (null is default.)
	LogAnalyticsDestinationType *string `json:"logAnalyticsDestinationType,omitempty"`

	// The list of logs settings.
	Logs []*LogSettings `json:"logs,omitempty"`

	// The list of metric settings.
	Metrics []*MetricSettings `json:"metrics,omitempty"`

	// The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
	ServiceBusRuleID *string `json:"serviceBusRuleId,omitempty"`

	// The resource ID of the storage account to which you would like to send Diagnostic Logs.
	StorageAccountID *string `json:"storageAccountId,omitempty"`

	// The full ARM resource ID of the Log Analytics workspace to which you would like to send Diagnostic Logs. Example:
	// /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
	WorkspaceID *string `json:"workspaceId,omitempty"`
}

// DiagnosticSettingsCategory - The diagnostic settings Category.
type DiagnosticSettingsCategory struct {
	// The type of the diagnostic settings category.
	CategoryType *CategoryType `json:"categoryType,omitempty"`
}

// DiagnosticSettingsCategoryClientGetOptions contains the optional parameters for the DiagnosticSettingsCategoryClient.Get
// method.
type DiagnosticSettingsCategoryClientGetOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticSettingsCategoryClientListOptions contains the optional parameters for the DiagnosticSettingsCategoryClient.List
// method.
type DiagnosticSettingsCategoryClientListOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticSettingsCategoryResource - The diagnostic settings category resource.
type DiagnosticSettingsCategoryResource struct {
	// The properties of a Diagnostic Settings Category.
	Properties *DiagnosticSettingsCategory `json:"properties,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DiagnosticSettingsCategoryResourceCollection - Represents a collection of diagnostic setting category resources.
type DiagnosticSettingsCategoryResourceCollection struct {
	// The collection of diagnostic settings category resources.
	Value []*DiagnosticSettingsCategoryResource `json:"value,omitempty"`
}

// DiagnosticSettingsClientCreateOrUpdateOptions contains the optional parameters for the DiagnosticSettingsClient.CreateOrUpdate
// method.
type DiagnosticSettingsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticSettingsClientDeleteOptions contains the optional parameters for the DiagnosticSettingsClient.Delete method.
type DiagnosticSettingsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticSettingsClientGetOptions contains the optional parameters for the DiagnosticSettingsClient.Get method.
type DiagnosticSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticSettingsClientListOptions contains the optional parameters for the DiagnosticSettingsClient.List method.
type DiagnosticSettingsClientListOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticSettingsResource - The diagnostic setting resource.
type DiagnosticSettingsResource struct {
	// Properties of a Diagnostic Settings Resource.
	Properties *DiagnosticSettings `json:"properties,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DiagnosticSettingsResourceCollection - Represents a collection of alert rule resources.
type DiagnosticSettingsResourceCollection struct {
	// The collection of diagnostic settings resources;.
	Value []*DiagnosticSettingsResource `json:"value,omitempty"`
}

// ErrorResponse - Describes the format of Error response.
type ErrorResponse struct {
	// Error code
	Code *string `json:"code,omitempty"`

	// Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// EventCategoriesClientListOptions contains the optional parameters for the EventCategoriesClient.NewListPager method.
type EventCategoriesClientListOptions struct {
	// placeholder for future optional parameters
}

// EventCategoryCollection - A collection of event categories. Currently possible values are: Administrative, Security, ServiceHealth,
// Alert, Recommendation, Policy.
type EventCategoryCollection struct {
	// REQUIRED; the list that includes the Azure event categories.
	Value []*LocalizableString `json:"value,omitempty"`
}

// LocalizableString - The localizable string class.
type LocalizableString struct {
	// REQUIRED; the invariant value.
	Value *string `json:"value,omitempty"`

	// the locale specific value.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// LogSettings - Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular log.
type LogSettings struct {
	// REQUIRED; a value indicating whether this log is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Name of a Diagnostic Log category for a resource type this setting is applied to. To obtain the list of Diagnostic Log
	// categories for a resource, first perform a GET diagnostic settings operation.
	Category *string `json:"category,omitempty"`

	// the retention policy for this log.
	RetentionPolicy *RetentionPolicy `json:"retentionPolicy,omitempty"`
}

// MetadataValue - Represents a metric metadata value.
type MetadataValue struct {
	// the name of the metadata.
	Name *LocalizableString `json:"name,omitempty"`

	// the value of the metadata.
	Value *string `json:"value,omitempty"`
}

// Metric - The result data of a query.
type Metric struct {
	// REQUIRED; the metric Id.
	ID *string `json:"id,omitempty"`

	// REQUIRED; the name and the display name of the metric, i.e. it is localizable string.
	Name *LocalizableString `json:"name,omitempty"`

	// REQUIRED; the time series returned when a data query is performed.
	Timeseries []*TimeSeriesElement `json:"timeseries,omitempty"`

	// REQUIRED; the resource type of the metric resource.
	Type *string `json:"type,omitempty"`

	// REQUIRED; The unit of the metric.
	Unit *MetricUnit `json:"unit,omitempty"`

	// Detailed description of this metric.
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// 'Success' or the error details on query failures for this metric.
	ErrorCode *string `json:"errorCode,omitempty"`

	// Error message encountered querying this specific metric.
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// MetricAvailability - Metric availability specifies the time grain (aggregation interval or frequency) and the retention
// period for that time grain.
type MetricAvailability struct {
	// the retention period for the metric at the specified timegrain. Expressed as a duration 'PT1M', 'P1D', etc.
	Retention *string `json:"retention,omitempty"`

	// the time grain specifies the aggregation interval for the metric. Expressed as a duration 'PT1M', 'P1D', etc.
	TimeGrain *string `json:"timeGrain,omitempty"`
}

// MetricDefinition - Metric definition class specifies the metadata for a metric.
type MetricDefinition struct {
	// Custom category name for this metric.
	Category *string `json:"category,omitempty"`

	// the name and the display name of the dimension, i.e. it is a localizable string.
	Dimensions []*LocalizableString `json:"dimensions,omitempty"`

	// Detailed description of this metric.
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// the resource identifier of the metric definition.
	ID *string `json:"id,omitempty"`

	// Flag to indicate whether the dimension is required.
	IsDimensionRequired *bool `json:"isDimensionRequired,omitempty"`

	// the collection of what aggregation intervals are available to be queried.
	MetricAvailabilities []*MetricAvailability `json:"metricAvailabilities,omitempty"`

	// The class of the metric.
	MetricClass *MetricClass `json:"metricClass,omitempty"`

	// the name and the display name of the metric, i.e. it is a localizable string.
	Name *LocalizableString `json:"name,omitempty"`

	// the namespace the metric belongs to.
	Namespace *string `json:"namespace,omitempty"`

	// the primary aggregation type value defining how to use the values for display.
	PrimaryAggregationType *AggregationType `json:"primaryAggregationType,omitempty"`

	// the resource identifier of the resource that emitted the metric.
	ResourceID *string `json:"resourceId,omitempty"`

	// the collection of what aggregation types are supported.
	SupportedAggregationTypes []*AggregationType `json:"supportedAggregationTypes,omitempty"`

	// The unit of the metric.
	Unit *MetricUnit `json:"unit,omitempty"`
}

// MetricDefinitionCollection - Represents collection of metric definitions.
type MetricDefinitionCollection struct {
	// REQUIRED; the values for the metric definitions.
	Value []*MetricDefinition `json:"value,omitempty"`
}

// MetricDefinitionsClientListOptions contains the optional parameters for the MetricDefinitionsClient.NewListPager method.
type MetricDefinitionsClientListOptions struct {
	// Metric namespace to query metric definitions for.
	Metricnamespace *string
}

// MetricSettings - Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular metric.
type MetricSettings struct {
	// REQUIRED; a value indicating whether this category is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Name of a Diagnostic Metric category for a resource type this setting is applied to. To obtain the list of Diagnostic metric
	// categories for a resource, first perform a GET diagnostic settings
	// operation.
	Category *string `json:"category,omitempty"`

	// the retention policy for this category.
	RetentionPolicy *RetentionPolicy `json:"retentionPolicy,omitempty"`

	// the timegrain of the metric in ISO8601 format.
	TimeGrain *string `json:"timeGrain,omitempty"`
}

// MetricValue - Represents a metric value.
type MetricValue struct {
	// REQUIRED; the timestamp for the metric value in ISO 8601 format.
	TimeStamp *time.Time `json:"timeStamp,omitempty"`

	// the average value in the time range.
	Average *float64 `json:"average,omitempty"`

	// the number of samples in the time range. Can be used to determine the number of values that contributed to the average
	// value.
	Count *float64 `json:"count,omitempty"`

	// the greatest value in the time range.
	Maximum *float64 `json:"maximum,omitempty"`

	// the least value in the time range.
	Minimum *float64 `json:"minimum,omitempty"`

	// the sum of all of the values in the time range.
	Total *float64 `json:"total,omitempty"`
}

// MetricsClientListOptions contains the optional parameters for the MetricsClient.List method.
type MetricsClientListOptions struct {
	// The list of aggregation types (comma separated) to retrieve.
	Aggregation *string
	// The $filter is used to reduce the set of metric data returned. Example: Metric contains metadata A, B and C. - Return all
	// time series of C where A = a1 and B = b1 or b2 $filter=A eq 'a1' and B eq 'b1'
	// or B eq 'b2' and C eq '' - Invalid variant: $filter=A eq 'a1' and B eq 'b1' and C eq '' or B = 'b2' This is invalid because
	// the logical or operator cannot separate two different metadata names. -
	// Return all time series where A = a1, B = b1 and C = c1: $filter=A eq 'a1' and B eq 'b1' and C eq 'c1' - Return all time
	// series where A = a1 $filter=A eq 'a1' and B eq '' and C eq ''. Special case:
	// When dimension name or dimension value uses round brackets. Eg: When dimension name is dim (test) 1 Instead of using $filter=
	// "dim (test) 1 eq '' " use $filter= "dim %2528test%2529 1 eq '' " When
	// dimension name is dim (test) 3 and dimension value is dim3 (test) val Instead of using $filter= "dim (test) 3 eq 'dim3
	// (test) val' " use $filter= "dim %2528test%2529 3 eq 'dim3 %2528test%2529 val' "
	Filter *string
	// The interval (i.e. timegrain) of the query.
	Interval *string
	// The names of the metrics (comma separated) to retrieve. Special case: If a metricname itself has a comma in it then use
	// %2 to indicate it. Eg: 'Metric,Name1' should be 'Metric%2Name1'
	Metricnames *string
	// Metric namespace to query metric definitions for.
	Metricnamespace *string
	// The aggregation to use for sorting results and the direction of the sort. Only one order can be specified. Examples: sum
	// asc.
	Orderby *string
	// Reduces the set of data collected. The syntax allowed depends on the operation. See the operation's description for details.
	ResultType *ResultType
	// The timespan of the query. It is a string with the following format 'startDateTimeISO/endDateTimeISO'.
	Timespan *string
	// The maximum number of records to retrieve. Valid only if $filter is specified. Defaults to 10.
	Top *int32
}

// Operation - Microsoft Insights API operation definition.
type Operation struct {
	// Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft.Insights
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed: AlertRules, Autoscale, etc.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of the request to list Microsoft.Insights operations. It contains a list of operations and
// a URL link to get the next set of results.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of operations supported by the Microsoft.Insights provider.
	Value []*Operation `json:"value,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ProxyOnlyResource - A proxy only azure resource object
type ProxyOnlyResource struct {
	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Response - The response to a metrics query.
type Response struct {
	// REQUIRED; The timespan for which the data was retrieved. Its value consists of two datetimes concatenated, separated by
	// '/'. This may be adjusted in the future and returned back from what was originally
	// requested.
	Timespan *string `json:"timespan,omitempty"`

	// REQUIRED; the value of the collection.
	Value []*Metric `json:"value,omitempty"`

	// The integer value representing the relative cost of the query.
	Cost *int32 `json:"cost,omitempty"`

	// The interval (window size) for which the metric data was returned in. This may be adjusted in the future and returned back
	// from what was originally requested. This is not present if a metadata request
	// was made.
	Interval *string `json:"interval,omitempty"`

	// The namespace of the metrics being queried
	Namespace *string `json:"namespace,omitempty"`

	// The region of the resource being queried for metrics.
	Resourceregion *string `json:"resourceregion,omitempty"`
}

// RetentionPolicy - Specifies the retention policy for the log.
type RetentionPolicy struct {
	// REQUIRED; the number of days for the retention in days. A value of 0 will retain the events indefinitely.
	Days *int32 `json:"days,omitempty"`

	// REQUIRED; a value indicating whether the retention policy is enabled.
	Enabled *bool `json:"enabled,omitempty"`
}

// TimeSeriesElement - A time series result type. The discriminator value is always TimeSeries in this case.
type TimeSeriesElement struct {
	// An array of data points representing the metric values. This is only returned if a result type of data is specified.
	Data []*MetricValue `json:"data,omitempty"`

	// the metadata values returned if $filter was specified in the call.
	Metadatavalues []*MetadataValue `json:"metadatavalues,omitempty"`
}
