//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package azwebpubsub

// AddConnectionToGroupOptions contains the optional parameters for the Client.AddConnectionToGroup method.
type AddConnectionToGroupOptions struct {
	// placeholder for future optional parameters
}

// AddConnectionsToGroupsOptions contains the optional parameters for the Client.AddConnectionsToGroups method.
type AddConnectionsToGroupsOptions struct {
	// placeholder for future optional parameters
}

// AddUserToGroupOptions contains the optional parameters for the Client.AddUserToGroup method.
type AddUserToGroupOptions struct {
	// placeholder for future optional parameters
}

// CheckPermissionOptions contains the optional parameters for the Client.CheckPermission method.
type CheckPermissionOptions struct {
	// The meaning of the target depends on the specific permission. For joinLeaveGroup and sendToGroup, targetName is a required
	// parameter standing for the group name.
	TargetName *string
}

// CloseAllConnectionsOptions contains the optional parameters for the Client.CloseAllConnections method.
type CloseAllConnectionsOptions struct {
	// Exclude these connectionIds when closing the connections in the hub.
	Excluded []string

	// The reason closing the client connection.
	Reason *string
}

// CloseConnectionOptions contains the optional parameters for the Client.CloseConnection method.
type CloseConnectionOptions struct {
	// The reason closing the client connection.
	Reason *string
}

// CloseGroupConnectionsOptions contains the optional parameters for the Client.CloseGroupConnections method.
type CloseGroupConnectionsOptions struct {
	// Exclude these connectionIds when closing the connections in the group.
	Excluded []string

	// The reason closing the client connection.
	Reason *string
}

// CloseUserConnectionsOptions contains the optional parameters for the Client.CloseUserConnections method.
type CloseUserConnectionsOptions struct {
	// Exclude these connectionIds when closing the connections for the user.
	Excluded []string

	// The reason closing the client connection.
	Reason *string
}

// ConnectionExistsOptions contains the optional parameters for the Client.ConnectionExists method.
type ConnectionExistsOptions struct {
	// placeholder for future optional parameters
}

// GenerateClientTokenOptions contains the optional parameters for the Client.GenerateClientToken method.
type GenerateClientTokenOptions struct {
	// Groups that the connection will join when it connects.
	Group []string

	// The expire time of the generated token.
	MinutesToExpire *int32

	// Roles that the connection with the generated token will have.
	Role []string

	// User Id.
	UserID *string
}

// GrantPermissionOptions contains the optional parameters for the Client.GrantPermission method.
type GrantPermissionOptions struct {
	// The meaning of the target depends on the specific permission. For joinLeaveGroup and sendToGroup, targetName is a required
	// parameter standing for the group name.
	TargetName *string
}

// GroupExistsOptions contains the optional parameters for the Client.GroupExists method.
type GroupExistsOptions struct {
	// placeholder for future optional parameters
}

// RemoveConnectionFromAllGroupsOptions contains the optional parameters for the Client.RemoveConnectionFromAllGroups
// method.
type RemoveConnectionFromAllGroupsOptions struct {
	// placeholder for future optional parameters
}

// RemoveConnectionFromGroupOptions contains the optional parameters for the Client.RemoveConnectionFromGroup method.
type RemoveConnectionFromGroupOptions struct {
	// placeholder for future optional parameters
}

// RemoveConnectionsFromGroupsOptions contains the optional parameters for the Client.RemoveConnectionsFromGroups method.
type RemoveConnectionsFromGroupsOptions struct {
	// placeholder for future optional parameters
}

// RemoveUserFromAllGroupsOptions contains the optional parameters for the Client.RemoveUserFromAllGroups method.
type RemoveUserFromAllGroupsOptions struct {
	// placeholder for future optional parameters
}

// RemoveUserFromGroupOptions contains the optional parameters for the Client.RemoveUserFromGroup method.
type RemoveUserFromGroupOptions struct {
	// placeholder for future optional parameters
}

// RevokePermissionOptions contains the optional parameters for the Client.RevokePermission method.
type RevokePermissionOptions struct {
	// The meaning of the target depends on the specific permission. For joinLeaveGroup and sendToGroup, targetName is a required
	// parameter standing for the group name.
	TargetName *string
}

// SendToAllOptions contains the optional parameters for the Client.SendToAll method.
type SendToAllOptions struct {
	// Excluded connection Ids.
	Excluded []string

	// Following OData filter syntax to filter out the subscribers receiving the messages.
	Filter *string

	// The time-to-live (TTL) value in seconds for messages sent to the service. 0 is the default value, which means the message
	// never expires. 300 is the maximum value. If this parameter is non-zero,
	// messages that are not consumed by the client within the specified TTL will be dropped by the service. This parameter can
	// help when the client's bandwidth is limited.
	MessageTTLSeconds *int32
}

// SendToConnectionOptions contains the optional parameters for the Client.SendToConnection method.
type SendToConnectionOptions struct {
	// The time-to-live (TTL) value in seconds for messages sent to the service. 0 is the default value, which means the message
	// never expires. 300 is the maximum value. If this parameter is non-zero,
	// messages that are not consumed by the client within the specified TTL will be dropped by the service. This parameter can
	// help when the client's bandwidth is limited.
	MessageTTLSeconds *int32
}

// SendToGroupOptions contains the optional parameters for the Client.SendToGroup method.
type SendToGroupOptions struct {
	// Excluded connection Ids
	Excluded []string

	// Following OData filter syntax to filter out the subscribers receiving the messages.
	Filter *string

	// The time-to-live (TTL) value in seconds for messages sent to the service. 0 is the default value, which means the message
	// never expires. 300 is the maximum value. If this parameter is non-zero,
	// messages that are not consumed by the client within the specified TTL will be dropped by the service. This parameter can
	// help when the client's bandwidth is limited.
	MessageTTLSeconds *int32
}

// SendToUserOptions contains the optional parameters for the Client.SendToUser method.
type SendToUserOptions struct {
	// Following OData filter syntax to filter out the subscribers receiving the messages.
	Filter *string

	// The time-to-live (TTL) value in seconds for messages sent to the service. 0 is the default value, which means the message
	// never expires. 300 is the maximum value. If this parameter is non-zero,
	// messages that are not consumed by the client within the specified TTL will be dropped by the service. This parameter can
	// help when the client's bandwidth is limited.
	MessageTTLSeconds *int32
}

// UserExistsOptions contains the optional parameters for the Client.UserExists method.
type UserExistsOptions struct {
	// placeholder for future optional parameters
}
