//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/alertsmanagement/armalertsmanagement"
	"net/http"
	"net/url"
	"regexp"
)

// AlertRuleRecommendationsServer is a fake server for instances of the armalertsmanagement.AlertRuleRecommendationsClient type.
type AlertRuleRecommendationsServer struct {
	// NewListByResourcePager is the fake for method AlertRuleRecommendationsClient.NewListByResourcePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourcePager func(resourceURI string, options *armalertsmanagement.AlertRuleRecommendationsClientListByResourceOptions) (resp azfake.PagerResponder[armalertsmanagement.AlertRuleRecommendationsClientListByResourceResponse])

	// NewListByTargetTypePager is the fake for method AlertRuleRecommendationsClient.NewListByTargetTypePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByTargetTypePager func(targetType string, options *armalertsmanagement.AlertRuleRecommendationsClientListByTargetTypeOptions) (resp azfake.PagerResponder[armalertsmanagement.AlertRuleRecommendationsClientListByTargetTypeResponse])
}

// NewAlertRuleRecommendationsServerTransport creates a new instance of AlertRuleRecommendationsServerTransport with the provided implementation.
// The returned AlertRuleRecommendationsServerTransport instance is connected to an instance of armalertsmanagement.AlertRuleRecommendationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAlertRuleRecommendationsServerTransport(srv *AlertRuleRecommendationsServer) *AlertRuleRecommendationsServerTransport {
	return &AlertRuleRecommendationsServerTransport{
		srv:                      srv,
		newListByResourcePager:   newTracker[azfake.PagerResponder[armalertsmanagement.AlertRuleRecommendationsClientListByResourceResponse]](),
		newListByTargetTypePager: newTracker[azfake.PagerResponder[armalertsmanagement.AlertRuleRecommendationsClientListByTargetTypeResponse]](),
	}
}

// AlertRuleRecommendationsServerTransport connects instances of armalertsmanagement.AlertRuleRecommendationsClient to instances of AlertRuleRecommendationsServer.
// Don't use this type directly, use NewAlertRuleRecommendationsServerTransport instead.
type AlertRuleRecommendationsServerTransport struct {
	srv                      *AlertRuleRecommendationsServer
	newListByResourcePager   *tracker[azfake.PagerResponder[armalertsmanagement.AlertRuleRecommendationsClientListByResourceResponse]]
	newListByTargetTypePager *tracker[azfake.PagerResponder[armalertsmanagement.AlertRuleRecommendationsClientListByTargetTypeResponse]]
}

// Do implements the policy.Transporter interface for AlertRuleRecommendationsServerTransport.
func (a *AlertRuleRecommendationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AlertRuleRecommendationsClient.NewListByResourcePager":
		resp, err = a.dispatchNewListByResourcePager(req)
	case "AlertRuleRecommendationsClient.NewListByTargetTypePager":
		resp, err = a.dispatchNewListByTargetTypePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AlertRuleRecommendationsServerTransport) dispatchNewListByResourcePager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListByResourcePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourcePager not implemented")}
	}
	newListByResourcePager := a.newListByResourcePager.get(req)
	if newListByResourcePager == nil {
		const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AlertsManagement/alertRuleRecommendations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListByResourcePager(resourceURIParam, nil)
		newListByResourcePager = &resp
		a.newListByResourcePager.add(req, newListByResourcePager)
		server.PagerResponderInjectNextLinks(newListByResourcePager, req, func(page *armalertsmanagement.AlertRuleRecommendationsClientListByResourceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourcePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListByResourcePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourcePager) {
		a.newListByResourcePager.remove(req)
	}
	return resp, nil
}

func (a *AlertRuleRecommendationsServerTransport) dispatchNewListByTargetTypePager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListByTargetTypePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByTargetTypePager not implemented")}
	}
	newListByTargetTypePager := a.newListByTargetTypePager.get(req)
	if newListByTargetTypePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AlertsManagement/alertRuleRecommendations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		targetTypeParam, err := url.QueryUnescape(qp.Get("targetType"))
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListByTargetTypePager(targetTypeParam, nil)
		newListByTargetTypePager = &resp
		a.newListByTargetTypePager.add(req, newListByTargetTypePager)
		server.PagerResponderInjectNextLinks(newListByTargetTypePager, req, func(page *armalertsmanagement.AlertRuleRecommendationsClientListByTargetTypeResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByTargetTypePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListByTargetTypePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByTargetTypePager) {
		a.newListByTargetTypePager.remove(req)
	}
	return resp, nil
}
